/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.codeexplorer.map;

import java.util.Set;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.filter.condition.ASelectableCondition;
import org.freeplane.features.filter.condition.ICondition;
import org.freeplane.features.map.NodeModel;

class DependencySnapshotCondition
extends ASelectableCondition {
    private static final String NAME = "dependencies_snapshot";
    private static String description;
    private final Set<String> dependentNodeIDs;
    private final ICondition baseCondition;

    public DependencySnapshotCondition(Set<String> dependentNodeIDs) {
        this(dependentNodeIDs, null);
    }

    public DependencySnapshotCondition(Set<String> dependentNodeIDs, ICondition baseCondition) {
        this.baseCondition = baseCondition;
        this.dependentNodeIDs = dependentNodeIDs;
    }

    public boolean checkNode(NodeModel node) {
        return this.dependentNodeIDs.contains(node.getID()) || this.baseCondition != null && this.baseCondition.checkNode(node);
    }

    protected String createDescription() {
        if (description == null) {
            description = TextUtils.getText((String)"code.filter_dependencies_snapshot");
        }
        return description;
    }

    protected String getName() {
        return NAME;
    }

    public boolean canBePersisted() {
        return false;
    }
}

