/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map.edge;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import org.freeplane.api.ChildNodesAlignment;
import org.freeplane.api.ChildrenSides;
import org.freeplane.features.nodelocation.LocationModel;
import org.freeplane.view.swing.map.MainView;
import org.freeplane.view.swing.map.NodeView;
import org.freeplane.view.swing.map.edge.EdgeView;
import org.freeplane.view.swing.map.link.CollisionDetector;

public class HorizontalEdgeView
extends EdgeView {
    private int[] xs;
    private int[] ys;

    public HorizontalEdgeView(NodeView source, NodeView target, Component paintedComponent) {
        super(source, target, paintedComponent);
    }

    @Override
    protected void createStart() {
        MainView mainView;
        NodeView source = this.getSource();
        NodeView target = this.getTarget();
        boolean usesHorizontalLayout = source.usesHorizontalLayout();
        ChildNodesAlignment childNodesAlignment = source.getChildNodesAlignment();
        if (!usesHorizontalLayout && childNodesAlignment.isStacked() && source.childrenSides() != ChildrenSides.BOTH_SIDES) {
            super.createStart();
            if (this.getStartConnectorLocation() == MainView.ConnectorLocation.RIGHT) {
                this.start.x -= this.getWidth() / 2;
            } else if (this.getStartConnectorLocation() == MainView.ConnectorLocation.LEFT) {
                this.start.x += this.getWidth() / 2;
            }
            return;
        }
        if (source.isRoot() && !MainView.USE_COMMON_OUT_POINT_FOR_ROOT_NODE) {
            super.createStart();
        } else {
            mainView = source.getMainView();
            if (usesHorizontalLayout) {
                if (childNodesAlignment == ChildNodesAlignment.AFTER_PARENT && source.childrenSides() == ChildrenSides.BOTH_SIDES) {
                    this.start = mainView.getRightPoint();
                } else if (childNodesAlignment == ChildNodesAlignment.BEFORE_PARENT && source.childrenSides() == ChildrenSides.BOTH_SIDES) {
                    this.start = mainView.getLeftPoint();
                } else {
                    if (source.getChildNodesAlignment().isStacked()) {
                        super.createStart();
                        return;
                    }
                    this.start = target.isTopOrLeft() ? mainView.getTopPoint() : mainView.getBottomPoint();
                }
            } else {
                this.start = source.getChildNodesAlignment() == ChildNodesAlignment.AFTER_PARENT ? mainView.getBottomPoint() : (source.getChildNodesAlignment() == ChildNodesAlignment.BEFORE_PARENT ? mainView.getTopPoint() : (target.isTopOrLeft() ? mainView.getLeftPoint() : mainView.getRightPoint()));
            }
        }
        mainView = target.getMainView();
        this.end = target.isTopOrLeft() ? (usesHorizontalLayout ? mainView.getBottomPoint() : mainView.getRightPoint()) : (usesHorizontalLayout ? mainView.getTopPoint() : mainView.getLeftPoint());
    }

    @Override
    protected void draw(Graphics2D g) {
        boolean left;
        Color color = this.getColor();
        g.setColor(color);
        Stroke stroke = this.getStroke();
        g.setStroke(stroke);
        NodeView source = this.getSource();
        boolean usesHorizontalLayout = source.usesHorizontalLayout();
        boolean areChildrenApart = source.getChildNodesAlignment().isStacked();
        int middleGap = this.getTarget().getMap().getZoomed(LocationModel.DEFAULT_HGAP_PX) / 2;
        boolean bl = left = this.getTarget().isTopOrLeft() || !MainView.USE_COMMON_OUT_POINT_FOR_ROOT_NODE && this.getSource().isRoot() && (!usesHorizontalLayout && this.start.x > this.end.x || usesHorizontalLayout && this.start.y > this.end.y);
        if (left) {
            middleGap = -middleGap;
        }
        if (usesHorizontalLayout) {
            int middleY = this.start.y + middleGap;
            this.xs = new int[]{this.start.x, this.start.x, this.end.x, this.end.x};
            this.ys = new int[]{this.start.y, middleY, middleY, this.end.y};
        } else if (areChildrenApart) {
            this.xs = new int[]{this.start.x, this.start.x, this.end.x};
            this.ys = new int[]{this.start.y, this.end.y, this.end.y};
        } else {
            int middleX = this.start.x + middleGap;
            this.xs = new int[]{this.start.x, middleX, middleX, this.end.x};
            this.ys = new int[]{this.start.y, this.start.y, this.end.y, this.end.y};
        }
        g.drawPolyline(this.xs, this.ys, this.xs.length);
        if (this.drawHiddenParentEdge()) {
            g.setColor(g.getBackground());
            g.setStroke(EdgeView.getEclipsedStroke());
            g.drawPolyline(this.xs, this.ys, this.xs.length);
            g.setColor(color);
            g.setStroke(stroke);
        }
    }

    @Override
    public boolean detectCollision(Point p) {
        CollisionDetector collisionDetector = new CollisionDetector();
        for (int i = 1; i < this.xs.length; ++i) {
            if (!collisionDetector.detectCollision(p, new Line2D.Float(this.xs[i - 1], this.ys[i - 1], this.xs[i], this.ys[i]))) continue;
            return true;
        }
        return false;
    }
}

