/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.GradientCacheEntry;
import com.jidesoft.swing.GradientInfo;
import java.awt.image.BufferedImage;
import java.lang.ref.ReferenceQueue;

class GradientCache {
    private GradientCacheEntry[] gradients;
    private int size;
    private int threshold = 16;
    private final float loadFactor;
    private final ReferenceQueue queue = new ReferenceQueue();

    GradientCache() {
        this.loadFactor = 0.75f;
        this.gradients = new GradientCacheEntry[16];
    }

    BufferedImage retrieve(GradientInfo info) {
        int ln = info.length;
        GradientCacheEntry[] grads = this.getGradients();
        int index = GradientCache.bucket(ln, grads.length);
        GradientCacheEntry e = grads[index];
        while (e != null) {
            GradientInfo egi = e.getInfo();
            try {
                if (egi != null && e.length == ln && egi.isEquivalent(info)) {
                    return e.gradient;
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            e = e.next;
        }
        return null;
    }

    Object store(GradientInfo info, BufferedImage gradient) {
        int i;
        GradientCacheEntry[] grads = this.getGradients();
        GradientCacheEntry e = grads[i = GradientCache.bucket(info.length, grads.length)];
        if (!this.entryNotInCache(e, info)) {
            System.err.println("Duplicate entry found!");
        }
        grads[i] = new GradientCacheEntry(info, gradient, this.queue, e);
        if (++this.size >= this.threshold) {
            this.resize(grads.length << 1);
        }
        return null;
    }

    void clear() {
        GradientCacheEntry[] a = this.getGradients();
        for (int i = 0; i < a.length; ++i) {
            a[i] = null;
        }
        this.size = 0;
        this.threshold = 16;
        this.gradients = new GradientCacheEntry[16];
    }

    private boolean entryNotInCache(GradientCacheEntry e, GradientInfo info) {
        while (e != null && e.getInfo() != null) {
            if (e.length == info.length && e.getInfo().isEquivalent(info)) {
                return false;
            }
            e = e.next;
        }
        return true;
    }

    private void resize(int newCapacity) {
        GradientCacheEntry[] oldArray = this.getGradients();
        int oldCapacity = oldArray.length;
        if (oldCapacity == 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        GradientCacheEntry[] newArray = new GradientCacheEntry[newCapacity];
        this.moveEntries(oldArray, newArray);
        this.gradients = newArray;
        if (this.size >= this.threshold >> 1) {
            this.threshold = (int)((float)newCapacity * this.loadFactor);
        } else {
            this.cleanOldCacheEntries();
            this.moveEntries(newArray, oldArray);
            this.gradients = oldArray;
        }
    }

    private GradientCacheEntry[] getGradients() {
        this.cleanOldCacheEntries();
        return this.gradients;
    }

    private static int bucket(int h2, int length) {
        return h2 & length - 1;
    }

    private void moveEntries(GradientCacheEntry[] src, GradientCacheEntry[] dest) {
        for (int j = 0; j < src.length; ++j) {
            GradientCacheEntry e = src[j];
            src[j] = null;
            while (e != null) {
                GradientCacheEntry next = e.next;
                Object o = e.get();
                if (o == null) {
                    e.next = null;
                    e.gradient = null;
                    --this.size;
                } else {
                    int i = GradientCache.bucket(e.length, dest.length);
                    e.next = dest[i];
                    dest[i] = e;
                }
                e = next;
            }
        }
    }

    private void cleanOldCacheEntries() {
        GradientCacheEntry e;
        block0: while ((e = (GradientCacheEntry)this.queue.poll()) != null) {
            GradientCacheEntry prev;
            int i = GradientCache.bucket(e.length, this.gradients.length);
            GradientCacheEntry p = prev = this.gradients[i];
            while (p != null) {
                GradientCacheEntry next = p.next;
                if (p == e) {
                    if (prev == e) {
                        this.gradients[i] = next;
                    } else {
                        prev.next = next;
                    }
                    e.next = null;
                    e.gradient = null;
                    --this.size;
                    continue block0;
                }
                prev = p;
                p = next;
            }
        }
    }
}

