/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.tasks;

import com.google.common.base.Stopwatch;
import java.io.IOException;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import mediathek.config.Daten;
import mediathek.daten.DatenFilm;
import mediathek.daten.IndexedFilmList;
import mediathek.mainwindow.MediathekGui;
import mediathek.tool.SwingErrorDialog;
import mediathek.tool.datum.DateUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.IntPoint;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.IndexSearcher;
import org.jetbrains.annotations.NotNull;

public class LuceneIndexWorker
extends SwingWorker<Void, Void> {
    private static final Logger logger = LogManager.getLogger();
    private final JProgressBar progressBar;
    private final JLabel progLabel;
    private int oldProgress = 0;

    public LuceneIndexWorker(@NotNull JLabel progLabel, @NotNull JProgressBar progressBar) {
        this.progressBar = progressBar;
        this.progLabel = progLabel;
        SwingUtilities.invokeLater(() -> {
            progLabel.setText("Blacklist anwenden");
            progressBar.setIndeterminate(true);
        });
    }

    private void indexFilm(@NotNull IndexWriter writer, @NotNull DatenFilm film) throws IOException {
        Document doc = new Document();
        doc.add(new StringField("id", Integer.toString(film.getFilmNr()), Field.Store.YES));
        doc.add(new StringField("neu", Boolean.toString(film.isNew()), Field.Store.NO));
        doc.add(new TextField("sender", film.getSender(), Field.Store.NO));
        doc.add(new TextField("titel", film.getTitle(), Field.Store.NO));
        doc.add(new TextField("thema", film.getThema(), Field.Store.NO));
        doc.add(new IntPoint("l\u00e4nge", film.getFilmLength()));
        doc.add(new IntPoint("gr\u00f6\u00dfe", film.getFileSize().toInteger()));
        doc.add(new TextField("beschreibung", film.getDescription(), Field.Store.NO));
        doc.add(new StringField("livestream", Boolean.toString(film.isLivestream()), Field.Store.NO));
        doc.add(new StringField("highquality", Boolean.toString(film.isHighQuality()), Field.Store.NO));
        doc.add(new StringField("untertitel", Boolean.toString(film.hasSubtitle() || film.hasBurnedInSubtitles()), Field.Store.NO));
        doc.add(new StringField("trailerteaser", Boolean.toString(film.isTrailerTeaser()), Field.Store.NO));
        doc.add(new StringField("audioversion", Boolean.toString(film.isAudioVersion()), Field.Store.NO));
        doc.add(new StringField("signlanguage", Boolean.toString(film.isSignLanguage()), Field.Store.NO));
        this.addSendeDatum(doc, film);
        writer.addDocument(doc);
    }

    private void addSendeDatum(@NotNull Document doc, @NotNull DatenFilm film) {
        String sendeDatumStr = DateTools.timeToString(DateUtil.convertFilmDateToLuceneDate(film), DateTools.Resolution.DAY);
        doc.add(new StringField("sendedatum", sendeDatumStr, Field.Store.NO));
    }

    @Override
    protected Void doInBackground() {
        IndexedFilmList filmListe = (IndexedFilmList)Daten.getInstance().getListeFilmeNachBlackList();
        SwingUtilities.invokeLater(() -> {
            this.progLabel.setText("Indiziere Filme");
            this.progressBar.setMinimum(0);
            this.progressBar.setMaximum(100);
            this.progressBar.setValue(0);
            this.progressBar.setIndeterminate(false);
        });
        IndexWriter writer = filmListe.getWriter();
        float totalSize = filmListe.size();
        try {
            int counter = 0;
            Stopwatch watch = Stopwatch.createStarted();
            writer.deleteAll();
            for (DatenFilm film : filmListe) {
                int progress;
                this.indexFilm(writer, film);
                if ((progress = (int)(100.0f * ((float)(++counter) / totalSize))) == this.oldProgress) continue;
                this.oldProgress = progress;
                SwingUtilities.invokeLater(() -> this.progressBar.setValue(progress));
            }
            writer.commit();
            watch.stop();
            logger.trace("Lucene index creation took {}", (Object)watch);
            DirectoryReader reader = filmListe.getReader();
            if (reader != null) {
                reader.close();
            }
            reader = DirectoryReader.open(filmListe.getLuceneDirectory());
            filmListe.setReader(reader);
            filmListe.setIndexSearcher(new IndexSearcher(reader));
        }
        catch (Exception ex) {
            SwingUtilities.invokeLater(() -> {
                SwingErrorDialog.showExceptionMessage(MediathekGui.ui(), "Fehler bei der Erstellung des Filmindex.\nDas Programm wird beendet da es nicht lauff\u00e4hig ist.", ex);
                MediathekGui.ui().quitApplication();
            });
        }
        return null;
    }
}

