/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.cluster.decommission.awareness.put;

import java.io.IOException;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ValidateActions;
import org.opensearch.action.support.clustermanager.ClusterManagerNodeRequest;
import org.opensearch.cluster.decommission.DecommissionAttribute;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;

public class DecommissionRequest
extends ClusterManagerNodeRequest<DecommissionRequest> {
    public static final TimeValue DEFAULT_NODE_DRAINING_TIMEOUT = TimeValue.timeValueSeconds((long)120L);
    private DecommissionAttribute decommissionAttribute;
    private String requestID;
    private TimeValue delayTimeout = DEFAULT_NODE_DRAINING_TIMEOUT;
    private boolean noDelay = false;

    public DecommissionRequest() {
    }

    public DecommissionRequest(DecommissionAttribute decommissionAttribute) {
        this.decommissionAttribute = decommissionAttribute;
    }

    public DecommissionRequest(StreamInput in) throws IOException {
        super(in);
        this.decommissionAttribute = new DecommissionAttribute(in);
        this.delayTimeout = in.readTimeValue();
        this.noDelay = in.readBoolean();
        this.requestID = in.readOptionalString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.decommissionAttribute.writeTo(out);
        out.writeTimeValue(this.delayTimeout);
        out.writeBoolean(this.noDelay);
        out.writeOptionalString(this.requestID);
    }

    public DecommissionRequest setDecommissionAttribute(DecommissionAttribute decommissionAttribute) {
        this.decommissionAttribute = decommissionAttribute;
        return this;
    }

    public DecommissionAttribute getDecommissionAttribute() {
        return this.decommissionAttribute;
    }

    public DecommissionRequest setDelayTimeout(TimeValue delayTimeout) {
        this.delayTimeout = delayTimeout;
        return this;
    }

    public TimeValue getDelayTimeout() {
        return this.delayTimeout;
    }

    public DecommissionRequest setNoDelay(boolean noDelay) {
        if (noDelay) {
            this.delayTimeout = TimeValue.ZERO;
        }
        this.noDelay = noDelay;
        return this;
    }

    public boolean isNoDelay() {
        return this.noDelay;
    }

    public DecommissionRequest setRequestID(String requestID) {
        this.requestID = requestID;
        return this;
    }

    public String requestID() {
        return this.requestID;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.decommissionAttribute == null) {
            validationException = ValidateActions.addValidationError("decommission attribute is missing", validationException);
            return validationException;
        }
        if (this.decommissionAttribute.attributeName() == null || Strings.isEmpty((CharSequence)this.decommissionAttribute.attributeName())) {
            validationException = ValidateActions.addValidationError("attribute name is missing", validationException);
        }
        if (this.decommissionAttribute.attributeValue() == null || Strings.isEmpty((CharSequence)this.decommissionAttribute.attributeValue())) {
            validationException = ValidateActions.addValidationError("attribute value is missing", validationException);
        }
        if (this.noDelay && this.delayTimeout.getSeconds() > 0L) {
            String validationMessage = "Invalid decommission request. no_delay is true and delay_timeout is set to " + this.delayTimeout.getSeconds() + "] Seconds";
            validationException = ValidateActions.addValidationError(validationMessage, validationException);
        }
        return validationException;
    }

    public String toString() {
        return "DecommissionRequest{decommissionAttribute=" + this.decommissionAttribute + ", delayTimeout=" + this.delayTimeout + ", noDelay=" + this.noDelay + "}";
    }
}

