/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.replication.repository;

import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.GlobalScope;
import kotlinx.coroutines.sync.Mutex;
import kotlinx.coroutines.sync.MutexKt;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.action.ActionRequest;
import org.opensearch.client.Client;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.unit.ByteSizeValue;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.index.store.Store;
import org.opensearch.index.store.StoreFileMetadata;
import org.opensearch.indices.recovery.MultiChunkTransfer;
import org.opensearch.indices.recovery.MultiFileWriter;
import org.opensearch.indices.recovery.RecoveryState;
import org.opensearch.replication.action.repository.GetFileChunkAction;
import org.opensearch.replication.action.repository.GetFileChunkRequest;
import org.opensearch.replication.action.repository.GetFileChunkResponse;
import org.opensearch.replication.metadata.store.ReplicationMetadata;
import org.opensearch.replication.repository.RemoteClusterRepositoryFileChunk;
import org.opensearch.replication.util.CoroutinesKt;
import org.opensearch.replication.util.ExtensionsKt;
import org.opensearch.threadpool.ThreadPool;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 M2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u0004:\u0001MB\u0081\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\b\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00020\u0017\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u0012\u0006\u0010\u001a\u001a\u00020\u001b\u0012\u0006\u0010\u001c\u001a\u00020\u001d\u0012\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f\u00a2\u0006\u0002\u0010!J\b\u0010B\u001a\u00020CH\u0016J\u001e\u0010D\u001a\u00020C2\u0006\u0010E\u001a\u00020\u00032\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fH\u0014J\u001c\u0010F\u001a\u00020C2\u0006\u0010G\u001a\u00020\u00022\n\u0010H\u001a\u00060Ij\u0002`JH\u0014J\u0010\u0010K\u001a\u00020\u00032\u0006\u0010G\u001a\u00020\u0002H\u0014J\u0010\u0010L\u001a\u00020C2\u0006\u0010G\u001a\u00020\u0002H\u0014R\u0011\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0012\u0010$\u001a\u00020%X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103R\u000e\u00104\u001a\u000205X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u000207X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00108\u001a\u000209X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010;R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u0010=R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010?R\u0011\u0010\u000f\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u0010)R\u000e\u0010A\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006N"}, d2={"Lorg/opensearch/replication/repository/RemoteClusterMultiChunkTransfer;", "Lorg/opensearch/indices/recovery/MultiChunkTransfer;", "Lorg/opensearch/index/store/StoreFileMetadata;", "Lorg/opensearch/replication/repository/RemoteClusterRepositoryFileChunk;", "Lkotlinx/coroutines/CoroutineScope;", "logger", "Lorg/apache/logging/log4j/Logger;", "followerClusterName", "", "threadContext", "Lorg/opensearch/common/util/concurrent/ThreadContext;", "localStore", "Lorg/opensearch/index/store/Store;", "maxConcurrentFileChunks", "", "restoreUUID", "replMetadata", "Lorg/opensearch/replication/metadata/store/ReplicationMetadata;", "leaderNode", "Lorg/opensearch/cluster/node/DiscoveryNode;", "leaderShardId", "Lorg/opensearch/core/index/shard/ShardId;", "remoteFiles", "", "leaderClusterClient", "Lorg/opensearch/client/Client;", "recoveryState", "Lorg/opensearch/indices/recovery/RecoveryState;", "chunkSize", "Lorg/opensearch/core/common/unit/ByteSizeValue;", "listener", "Lorg/opensearch/core/action/ActionListener;", "Ljava/lang/Void;", "(Lorg/apache/logging/log4j/Logger;Ljava/lang/String;Lorg/opensearch/common/util/concurrent/ThreadContext;Lorg/opensearch/index/store/Store;ILjava/lang/String;Lorg/opensearch/replication/metadata/store/ReplicationMetadata;Lorg/opensearch/cluster/node/DiscoveryNode;Lorg/opensearch/core/index/shard/ShardId;Ljava/util/List;Lorg/opensearch/client/Client;Lorg/opensearch/indices/recovery/RecoveryState;Lorg/opensearch/core/common/unit/ByteSizeValue;Lorg/opensearch/core/action/ActionListener;)V", "getChunkSize", "()Lorg/opensearch/core/common/unit/ByteSizeValue;", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "getFollowerClusterName", "()Ljava/lang/String;", "getLeaderClusterClient", "()Lorg/opensearch/client/Client;", "getLeaderNode", "()Lorg/opensearch/cluster/node/DiscoveryNode;", "getLeaderShardId", "()Lorg/opensearch/core/index/shard/ShardId;", "getLocalStore", "()Lorg/opensearch/index/store/Store;", "getLogger", "()Lorg/apache/logging/log4j/Logger;", "multiFileWriter", "Lorg/opensearch/indices/recovery/MultiFileWriter;", "mutex", "Lkotlinx/coroutines/sync/Mutex;", "offset", "", "getRecoveryState", "()Lorg/opensearch/indices/recovery/RecoveryState;", "getRemoteFiles", "()Ljava/util/List;", "getReplMetadata", "()Lorg/opensearch/replication/metadata/store/ReplicationMetadata;", "getRestoreUUID", "tempFilePrefix", "close", "", "executeChunkRequest", "request", "handleError", "md", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "nextChunkRequest", "onNewResource", "Companion", "opensearch-cross-cluster-replication"})
public final class RemoteClusterMultiChunkTransfer
extends MultiChunkTransfer<StoreFileMetadata, RemoteClusterRepositoryFileChunk>
implements CoroutineScope {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger logger;
    @NotNull
    private final String followerClusterName;
    @NotNull
    private final Store localStore;
    @NotNull
    private final String restoreUUID;
    @NotNull
    private final ReplicationMetadata replMetadata;
    @NotNull
    private final DiscoveryNode leaderNode;
    @NotNull
    private final ShardId leaderShardId;
    @NotNull
    private final List<StoreFileMetadata> remoteFiles;
    @NotNull
    private final Client leaderClusterClient;
    @NotNull
    private final RecoveryState recoveryState;
    @NotNull
    private final ByteSizeValue chunkSize;
    private final /* synthetic */ GlobalScope $$delegate_0;
    private long offset;
    @NotNull
    private final String tempFilePrefix;
    @NotNull
    private final MultiFileWriter multiFileWriter;
    @NotNull
    private final Mutex mutex;
    @NotNull
    public static final String RESTORE_SHARD_TEMP_FILE_PREFIX = "CLUSTER_REPO_TEMP_";

    public RemoteClusterMultiChunkTransfer(@NotNull Logger logger, @NotNull String followerClusterName, @NotNull ThreadContext threadContext, @NotNull Store localStore, int maxConcurrentFileChunks, @NotNull String restoreUUID, @NotNull ReplicationMetadata replMetadata, @NotNull DiscoveryNode leaderNode, @NotNull ShardId leaderShardId, @NotNull List<? extends StoreFileMetadata> remoteFiles, @NotNull Client leaderClusterClient2, @NotNull RecoveryState recoveryState, @NotNull ByteSizeValue chunkSize, @NotNull ActionListener<Void> listener2) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)followerClusterName, (String)"followerClusterName");
        Intrinsics.checkNotNullParameter((Object)threadContext, (String)"threadContext");
        Intrinsics.checkNotNullParameter((Object)localStore, (String)"localStore");
        Intrinsics.checkNotNullParameter((Object)restoreUUID, (String)"restoreUUID");
        Intrinsics.checkNotNullParameter((Object)replMetadata, (String)"replMetadata");
        Intrinsics.checkNotNullParameter((Object)leaderNode, (String)"leaderNode");
        Intrinsics.checkNotNullParameter((Object)leaderShardId, (String)"leaderShardId");
        Intrinsics.checkNotNullParameter(remoteFiles, (String)"remoteFiles");
        Intrinsics.checkNotNullParameter((Object)leaderClusterClient2, (String)"leaderClusterClient");
        Intrinsics.checkNotNullParameter((Object)recoveryState, (String)"recoveryState");
        Intrinsics.checkNotNullParameter((Object)chunkSize, (String)"chunkSize");
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        super(logger, threadContext, listener2, maxConcurrentFileChunks, remoteFiles);
        this.logger = logger;
        this.followerClusterName = followerClusterName;
        this.localStore = localStore;
        this.restoreUUID = restoreUUID;
        this.replMetadata = replMetadata;
        this.leaderNode = leaderNode;
        this.leaderShardId = leaderShardId;
        this.remoteFiles = remoteFiles;
        this.leaderClusterClient = leaderClusterClient2;
        this.recoveryState = recoveryState;
        this.chunkSize = chunkSize;
        this.$$delegate_0 = GlobalScope.INSTANCE;
        this.tempFilePrefix = RESTORE_SHARD_TEMP_FILE_PREFIX + this.restoreUUID + '.';
        this.multiFileWriter = new MultiFileWriter(this.localStore, this.recoveryState.getIndex(), this.tempFilePrefix, this.logger, RemoteClusterMultiChunkTransfer::multiFileWriter$lambda$0);
        this.mutex = MutexKt.Mutex$default((boolean)false, (int)1, null);
        for (StoreFileMetadata fileMetadata : this.remoteFiles) {
            this.recoveryState.getIndex().addFileDetail(fileMetadata.name(), fileMetadata.length(), false);
        }
        this.recoveryState.getIndex().setFileDetailsComplete();
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    @NotNull
    public final String getFollowerClusterName() {
        return this.followerClusterName;
    }

    @NotNull
    public final Store getLocalStore() {
        return this.localStore;
    }

    @NotNull
    public final String getRestoreUUID() {
        return this.restoreUUID;
    }

    @NotNull
    public final ReplicationMetadata getReplMetadata() {
        return this.replMetadata;
    }

    @NotNull
    public final DiscoveryNode getLeaderNode() {
        return this.leaderNode;
    }

    @NotNull
    public final ShardId getLeaderShardId() {
        return this.leaderShardId;
    }

    @NotNull
    public final List<StoreFileMetadata> getRemoteFiles() {
        return this.remoteFiles;
    }

    @NotNull
    public final Client getLeaderClusterClient() {
        return this.leaderClusterClient;
    }

    @NotNull
    public final RecoveryState getRecoveryState() {
        return this.recoveryState;
    }

    @NotNull
    public final ByteSizeValue getChunkSize() {
        return this.chunkSize;
    }

    @NotNull
    public CoroutineContext getCoroutineContext() {
        return this.$$delegate_0.getCoroutineContext();
    }

    protected void handleError(@NotNull StoreFileMetadata md, @NotNull Exception e) {
        Intrinsics.checkNotNullParameter((Object)md, (String)"md");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.logger.error("Error while transferring segments " + e);
    }

    protected void onNewResource(@NotNull StoreFileMetadata md) {
        Intrinsics.checkNotNullParameter((Object)md, (String)"md");
        this.offset = 0L;
    }

    protected void executeChunkRequest(@NotNull RemoteClusterRepositoryFileChunk request, @NotNull ActionListener<Void> listener2) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        StoreFileMetadata storeFileMetadata = request.getStoreFileMetadata();
        long l = request.getOffset();
        int n = request.getLength();
        ShardId shardId = this.recoveryState.getShardId();
        Intrinsics.checkNotNullExpressionValue((Object)shardId, (String)"recoveryState.shardId");
        GetFileChunkRequest getFileChunkRequest = new GetFileChunkRequest(this.restoreUUID, this.leaderNode, this.leaderShardId, storeFileMetadata, l, n, this.followerClusterName, shardId);
        CoroutineScope coroutineScope = this;
        CoroutineDispatcher coroutineDispatcher = Dispatchers.getIO();
        ThreadPool threadPool = this.leaderClusterClient.threadPool();
        Intrinsics.checkNotNullExpressionValue((Object)threadPool, (String)"leaderClusterClient.threadPool()");
        BuildersKt.launch$default((CoroutineScope)coroutineScope, (CoroutineContext)coroutineDispatcher.plus(CoroutinesKt.coroutineContext(threadPool)), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, getFileChunkRequest, request, listener2, null){
            Object L$0;
            Object L$1;
            Object L$2;
            Object L$3;
            Object L$4;
            int label;
            final /* synthetic */ RemoteClusterMultiChunkTransfer this$0;
            final /* synthetic */ GetFileChunkRequest $getFileChunkRequest;
            final /* synthetic */ RemoteClusterRepositoryFileChunk $request;
            final /* synthetic */ ActionListener<Void> $listener;
            {
                this.this$0 = $receiver;
                this.$getFileChunkRequest = $getFileChunkRequest;
                this.$request = $request;
                this.$listener = $listener;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var11_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = ExtensionsKt.suspendExecuteWithRetries$default(this.this$0.getLeaderClusterClient(), this.this$0.getReplMetadata(), GetFileChunkAction.Companion.getINSTANCE(), (ActionRequest)this.$getFileChunkRequest, 0, 0L, 0L, 0.0, this.this$0.getLogger(), null, false, false, (Continuation)this, 1912, null);
                        ** if (v0 != var11_2) goto lbl11
lbl10:
                        // 1 sources

                        return var11_2;
lbl11:
                        // 1 sources

                        ** GOTO lbl17
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl17:
                        // 2 sources

                        response = (GetFileChunkResponse)v0;
                        this.this$0.getLogger().debug("Filename: " + this.$request.getStoreFileMetadata().name() + ", response_size: " + response.getData().length() + ", response_offset: " + response.getOffset());
                        var3_5 = RemoteClusterMultiChunkTransfer.access$getMutex$p(this.this$0);
                        var5_6 = this.this$0;
                        var6_7 = this.$request;
                        var7_8 = this.$listener;
                        owner$iv = null;
                        $i$f$withLock = false;
                        this.L$0 = response;
                        this.L$1 = $this$withLock_u24default$iv;
                        this.L$2 = var5_6;
                        this.L$3 = var6_7;
                        this.L$4 = var7_8;
                        this.label = 2;
                        v1 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)this);
                        ** if (v1 != var11_2) goto lbl35
lbl34:
                        // 1 sources

                        return var11_2;
lbl35:
                        // 1 sources

                        ** GOTO lbl48
                    }
                    case 2: {
                        $i$f$withLock = false;
                        var7_8 = (ActionListener<Void>)this.L$4;
                        var6_7 = (RemoteClusterRepositoryFileChunk)this.L$3;
                        var5_6 = (RemoteClusterMultiChunkTransfer)this.L$2;
                        owner$iv = null;
                        $this$withLock_u24default$iv = (Mutex)this.L$1;
                        response = (GetFileChunkResponse)this.L$0;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl48:
                            // 2 sources

                            try {
                                $i$a$-withLock$default-RemoteClusterMultiChunkTransfer$executeChunkRequest$1$1 = false;
                                RemoteClusterMultiChunkTransfer.access$getMultiFileWriter$p(var5_6).writeFileChunk(response.getStoreFileMetadata(), response.getOffset(), response.getData(), var6_7.lastChunk());
                                var7_8.onResponse(null);
                                var10_13 = Unit.INSTANCE;
                            }
                            finally {
                                $this$withLock_u24default$iv.unlock(owner$iv);
                            }
                        }
                        catch (Exception e) {
                            this.this$0.getLogger().error("Failed to fetch file chunk for " + this.$request.getStoreFileMetadata().name() + " with offset " + this.$request.getOffset() + ": " + e);
                            this.$listener.onFailure(e);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    @NotNull
    protected RemoteClusterRepositoryFileChunk nextChunkRequest(@NotNull StoreFileMetadata md) {
        Intrinsics.checkNotNullParameter((Object)md, (String)"md");
        RemoteClusterRepositoryFileChunk chunkReq = new RemoteClusterRepositoryFileChunk(md, this.offset, this.chunkSize.bytesAsInt());
        this.offset += (long)this.chunkSize.bytesAsInt();
        return chunkReq;
    }

    public void close() {
        this.multiFileWriter.renameAllTempFiles();
        this.multiFileWriter.close();
    }

    private static final void multiFileWriter$lambda$0() {
    }

    public static final /* synthetic */ Mutex access$getMutex$p(RemoteClusterMultiChunkTransfer $this) {
        return $this.mutex;
    }

    public static final /* synthetic */ MultiFileWriter access$getMultiFileWriter$p(RemoteClusterMultiChunkTransfer $this) {
        return $this.multiFileWriter;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/opensearch/replication/repository/RemoteClusterMultiChunkTransfer$Companion;", "", "()V", "RESTORE_SHARD_TEMP_FILE_PREFIX", "", "opensearch-cross-cluster-replication"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

