/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.mapper;

import java.util.Locale;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.IndexableField;
import org.opensearch.index.mapper.ParametrizedFieldMapper;
import org.opensearch.index.mapper.ParseContext;
import org.opensearch.knn.index.VectorDataType;
import org.opensearch.knn.index.util.KNNEngine;

public class KNNVectorFieldMapperUtil {
    public static void validateFloatVectorValue(float value) {
        if (Float.isNaN(value)) {
            throw new IllegalArgumentException("KNN vector values cannot be NaN");
        }
        if (Float.isInfinite(value)) {
            throw new IllegalArgumentException("KNN vector values cannot be infinity");
        }
    }

    public static void validateByteVectorValue(float value) {
        KNNVectorFieldMapperUtil.validateFloatVectorValue(value);
        if (value % 1.0f != 0.0f) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "[%s] field was set as [%s] in index mapping. But, KNN vector values are floats instead of byte integers", "data_type", VectorDataType.BYTE.getValue()));
        }
        if ((int)value < -128 || (int)value > 127) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "[%s] field was set as [%s] in index mapping. But, KNN vector values are not within in the byte range [%d, %d]", "data_type", VectorDataType.BYTE.getValue(), (byte)-128, (byte)127));
        }
    }

    public static void validateVectorDimension(int dimension, int vectorSize) {
        if (dimension != vectorSize) {
            String errorMessage = String.format(Locale.ROOT, "Vector dimension mismatch. Expected: %d, Given: %d", dimension, vectorSize);
            throw new IllegalArgumentException(errorMessage);
        }
    }

    public static void validateVectorDataTypeWithEngine(ParametrizedFieldMapper.Parameter<VectorDataType> vectorDataType) {
        if (VectorDataType.FLOAT == vectorDataType.getValue()) {
            return;
        }
        throw new IllegalArgumentException(String.format(Locale.ROOT, "[%s] field with value [%s] is only supported for [%s] engine", "data_type", ((VectorDataType)((Object)vectorDataType.getValue())).getValue(), "lucene"));
    }

    public static void validateVectorDataTypeWithKnnIndexSetting(boolean knnIndexSetting, ParametrizedFieldMapper.Parameter<VectorDataType> vectorDataType) {
        if (VectorDataType.FLOAT == vectorDataType.getValue()) {
            return;
        }
        if (knnIndexSetting) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "[%s] field with value [%s] is only supported for [%s] engine", "data_type", ((VectorDataType)((Object)vectorDataType.getValue())).getValue(), "lucene"));
        }
    }

    public static FieldType buildDocValuesFieldType(KNNEngine knnEngine) {
        FieldType field = new FieldType();
        field.putAttribute("engine", knnEngine.getName());
        field.setDocValuesType(DocValuesType.BINARY);
        field.freeze();
        return field;
    }

    public static void addStoredFieldForVectorField(ParseContext context, FieldType fieldType, String mapperName, String vectorFieldAsString) {
        if (fieldType.stored()) {
            context.doc().add((IndexableField)new StoredField(mapperName, vectorFieldAsString));
        }
    }
}

