/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.processor;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.env.Environment;
import org.opensearch.index.mapper.MapperService;
import org.opensearch.ingest.AbstractProcessor;
import org.opensearch.ingest.IngestDocument;
import org.opensearch.neuralsearch.ml.MLCommonsClientAccessor;

public abstract class InferenceProcessor
extends AbstractProcessor {
    @Generated
    private static final Logger log = LogManager.getLogger(InferenceProcessor.class);
    public static final String MODEL_ID_FIELD = "model_id";
    public static final String FIELD_MAP_FIELD = "field_map";
    private final String type;
    private final String listTypeNestedMapKey;
    protected final String modelId;
    private final Map<String, Object> fieldMap;
    protected final MLCommonsClientAccessor mlCommonsClientAccessor;
    private final Environment environment;

    public InferenceProcessor(String tag, String description, String type, String listTypeNestedMapKey, String modelId, Map<String, Object> fieldMap, MLCommonsClientAccessor clientAccessor, Environment environment) {
        super(tag, description);
        this.type = type;
        if (StringUtils.isBlank((CharSequence)modelId)) {
            throw new IllegalArgumentException("model_id is null or empty, cannot process it");
        }
        this.validateEmbeddingConfiguration(fieldMap);
        this.listTypeNestedMapKey = listTypeNestedMapKey;
        this.modelId = modelId;
        this.fieldMap = fieldMap;
        this.mlCommonsClientAccessor = clientAccessor;
        this.environment = environment;
    }

    private void validateEmbeddingConfiguration(Map<String, Object> fieldMap) {
        if (fieldMap == null || fieldMap.size() == 0 || fieldMap.entrySet().stream().anyMatch(x -> StringUtils.isBlank((CharSequence)((CharSequence)x.getKey())) || Objects.isNull(x.getValue()) || StringUtils.isBlank((CharSequence)x.getValue().toString()))) {
            throw new IllegalArgumentException("Unable to create the processor as field_map has invalid key or value");
        }
    }

    public abstract void doExecute(IngestDocument var1, Map<String, Object> var2, List<String> var3, BiConsumer<IngestDocument, Exception> var4);

    public IngestDocument execute(IngestDocument ingestDocument) throws Exception {
        return ingestDocument;
    }

    public void execute(IngestDocument ingestDocument, BiConsumer<IngestDocument, Exception> handler) {
        try {
            this.validateEmbeddingFieldsValue(ingestDocument);
            Map<String, Object> ProcessMap = this.buildMapWithProcessorKeyAndOriginalValue(ingestDocument);
            List<String> inferenceList = this.createInferenceList(ProcessMap);
            if (inferenceList.size() == 0) {
                handler.accept(ingestDocument, null);
            } else {
                this.doExecute(ingestDocument, ProcessMap, inferenceList, handler);
            }
        }
        catch (Exception e) {
            handler.accept(null, e);
        }
    }

    private List<String> createInferenceList(Map<String, Object> knnKeyMap) {
        ArrayList<String> texts = new ArrayList<String>();
        knnKeyMap.entrySet().stream().filter(knnMapEntry -> knnMapEntry.getValue() != null).forEach(knnMapEntry -> {
            Object sourceValue = knnMapEntry.getValue();
            if (sourceValue instanceof List) {
                texts.addAll((List)sourceValue);
            } else if (sourceValue instanceof Map) {
                this.createInferenceListForMapTypeInput(sourceValue, texts);
            } else {
                texts.add(sourceValue.toString());
            }
        });
        return texts;
    }

    private void createInferenceListForMapTypeInput(Object sourceValue, List<String> texts) {
        if (sourceValue instanceof Map) {
            ((Map)sourceValue).forEach((k, v) -> this.createInferenceListForMapTypeInput(v, texts));
        } else if (sourceValue instanceof List) {
            texts.addAll((List)sourceValue);
        } else {
            if (sourceValue == null) {
                return;
            }
            texts.add(sourceValue.toString());
        }
    }

    @VisibleForTesting
    Map<String, Object> buildMapWithProcessorKeyAndOriginalValue(IngestDocument ingestDocument) {
        Map sourceAndMetadataMap = ingestDocument.getSourceAndMetadata();
        LinkedHashMap<String, Object> mapWithProcessorKeys = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> fieldMapEntry : this.fieldMap.entrySet()) {
            String originalKey = fieldMapEntry.getKey();
            Object targetKey = fieldMapEntry.getValue();
            if (targetKey instanceof Map) {
                LinkedHashMap<String, Object> treeRes = new LinkedHashMap<String, Object>();
                this.buildMapWithProcessorKeyAndOriginalValueForMapType(originalKey, targetKey, sourceAndMetadataMap, treeRes);
                mapWithProcessorKeys.put(originalKey, treeRes.get(originalKey));
                continue;
            }
            mapWithProcessorKeys.put(String.valueOf(targetKey), sourceAndMetadataMap.get(originalKey));
        }
        return mapWithProcessorKeys;
    }

    private void buildMapWithProcessorKeyAndOriginalValueForMapType(String parentKey, Object processorKey, Map<String, Object> sourceAndMetadataMap, Map<String, Object> treeRes) {
        if (processorKey == null || sourceAndMetadataMap == null) {
            return;
        }
        if (processorKey instanceof Map) {
            LinkedHashMap<String, Object> next = new LinkedHashMap<String, Object>();
            for (Map.Entry nestedFieldMapEntry : ((Map)processorKey).entrySet()) {
                this.buildMapWithProcessorKeyAndOriginalValueForMapType((String)nestedFieldMapEntry.getKey(), nestedFieldMapEntry.getValue(), (Map)sourceAndMetadataMap.get(parentKey), next);
            }
            treeRes.put(parentKey, next);
        } else {
            String key = String.valueOf(processorKey);
            treeRes.put(key, sourceAndMetadataMap.get(parentKey));
        }
    }

    private void validateEmbeddingFieldsValue(IngestDocument ingestDocument) {
        Map sourceAndMetadataMap = ingestDocument.getSourceAndMetadata();
        for (Map.Entry<String, Object> embeddingFieldsEntry : this.fieldMap.entrySet()) {
            Object sourceValue = sourceAndMetadataMap.get(embeddingFieldsEntry.getKey());
            if (sourceValue == null) continue;
            String sourceKey = embeddingFieldsEntry.getKey();
            Class<?> sourceValueClass = sourceValue.getClass();
            if (List.class.isAssignableFrom(sourceValueClass) || Map.class.isAssignableFrom(sourceValueClass)) {
                this.validateNestedTypeValue(sourceKey, sourceValue, () -> 1);
                continue;
            }
            if (!String.class.isAssignableFrom(sourceValueClass)) {
                throw new IllegalArgumentException("field [" + sourceKey + "] is neither string nor nested type, cannot process it");
            }
            if (!StringUtils.isBlank((CharSequence)sourceValue.toString())) continue;
            throw new IllegalArgumentException("field [" + sourceKey + "] has empty string value, cannot process it");
        }
    }

    private void validateNestedTypeValue(String sourceKey, Object sourceValue, Supplier<Integer> maxDepthSupplier) {
        int maxDepth = maxDepthSupplier.get();
        if ((long)maxDepth > (Long)MapperService.INDEX_MAPPING_DEPTH_LIMIT_SETTING.get(this.environment.settings())) {
            throw new IllegalArgumentException("map type field [" + sourceKey + "] reached max depth limit, cannot process it");
        }
        if (List.class.isAssignableFrom(sourceValue.getClass())) {
            this.validateListTypeValue(sourceKey, sourceValue);
        } else if (Map.class.isAssignableFrom(sourceValue.getClass())) {
            ((Map)sourceValue).values().stream().filter(Objects::nonNull).forEach(x -> this.validateNestedTypeValue(sourceKey, x, () -> maxDepth + 1));
        } else {
            if (!String.class.isAssignableFrom(sourceValue.getClass())) {
                throw new IllegalArgumentException("map type field [" + sourceKey + "] has non-string type, cannot process it");
            }
            if (StringUtils.isBlank((CharSequence)sourceValue.toString())) {
                throw new IllegalArgumentException("map type field [" + sourceKey + "] has empty string, cannot process it");
            }
        }
    }

    private void validateListTypeValue(String sourceKey, Object sourceValue) {
        for (Object value : (List)sourceValue) {
            if (value == null) {
                throw new IllegalArgumentException("list type field [" + sourceKey + "] has null, cannot process it");
            }
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("list type field [" + sourceKey + "] has non string value, cannot process it");
            }
            if (!StringUtils.isBlank((CharSequence)value.toString())) continue;
            throw new IllegalArgumentException("list type field [" + sourceKey + "] has empty string, cannot process it");
        }
    }

    protected void setVectorFieldsToDocument(IngestDocument ingestDocument, Map<String, Object> processorMap, List<?> results) {
        Objects.requireNonNull(results, "embedding failed, inference returns null result!");
        log.debug("Model inference result fetched, starting build vector output!");
        Map<String, Object> nlpResult = this.buildNLPResult(processorMap, results, ingestDocument.getSourceAndMetadata());
        nlpResult.forEach((arg_0, arg_1) -> ((IngestDocument)ingestDocument).setFieldValue(arg_0, arg_1));
    }

    @VisibleForTesting
    Map<String, Object> buildNLPResult(Map<String, Object> processorMap, List<?> results, Map<String, Object> sourceAndMetadataMap) {
        IndexWrapper indexWrapper = new IndexWrapper(0);
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> knnMapEntry : processorMap.entrySet()) {
            String knnKey = knnMapEntry.getKey();
            Object sourceValue = knnMapEntry.getValue();
            if (sourceValue instanceof String) {
                result.put(knnKey, results.get(indexWrapper.index++));
                continue;
            }
            if (sourceValue instanceof List) {
                result.put(knnKey, this.buildNLPResultForListType((List)sourceValue, results, indexWrapper));
                continue;
            }
            if (!(sourceValue instanceof Map)) continue;
            this.putNLPResultToSourceMapForMapType(knnKey, sourceValue, results, indexWrapper, sourceAndMetadataMap);
        }
        return result;
    }

    private void putNLPResultToSourceMapForMapType(String processorKey, Object sourceValue, List<?> results, IndexWrapper indexWrapper, Map<String, Object> sourceAndMetadataMap) {
        if (processorKey == null || sourceAndMetadataMap == null || sourceValue == null) {
            return;
        }
        if (sourceValue instanceof Map) {
            for (Map.Entry inputNestedMapEntry : ((Map)sourceValue).entrySet()) {
                this.putNLPResultToSourceMapForMapType((String)inputNestedMapEntry.getKey(), inputNestedMapEntry.getValue(), results, indexWrapper, (Map)sourceAndMetadataMap.get(processorKey));
            }
        } else if (sourceValue instanceof String) {
            sourceAndMetadataMap.put(processorKey, results.get(indexWrapper.index++));
        } else if (sourceValue instanceof List) {
            sourceAndMetadataMap.put(processorKey, this.buildNLPResultForListType((List)sourceValue, results, indexWrapper));
        }
    }

    private List<Map<String, Object>> buildNLPResultForListType(List<String> sourceValue, List<?> results, IndexWrapper indexWrapper) {
        ArrayList<Map<String, Object>> keyToResult = new ArrayList<Map<String, Object>>();
        IntStream.range(0, sourceValue.size()).forEachOrdered(x -> keyToResult.add((Map<String, Object>)ImmutableMap.of((Object)this.listTypeNestedMapKey, results.get(indexWrapper.index++))));
        return keyToResult;
    }

    public String getType() {
        return this.type;
    }

    static class IndexWrapper {
        private int index;

        protected IndexWrapper(int index) {
            this.index = index;
        }
    }
}

