/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.wire;

import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.HColorSet;
import net.sourceforge.plantuml.klimt.color.NoSuchColorException;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexOptional;
import net.sourceforge.plantuml.regex.RegexResult;
import net.sourceforge.plantuml.utils.LineLocation;
import net.sourceforge.plantuml.wire.WArrowDirection;
import net.sourceforge.plantuml.wire.WLinkType;
import net.sourceforge.plantuml.wire.WOrientation;
import net.sourceforge.plantuml.wire.WireDiagram;

public class CommandWLink
extends SingleLineCommand2<WireDiagram> {
    public CommandWLink() {
        super(false, CommandWLink.getRegexConcat());
    }

    static IRegex getRegexConcat() {
        return RegexConcat.build(CommandWLink.class.getName(), RegexLeaf.start(), new RegexLeaf("NAME1", "([\\w][.\\w]*)"), new RegexOptional((IRegex)new RegexConcat(new RegexLeaf("\\("), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("X1", "(-?\\d+(%|%[-+]\\d+)?)"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf(","), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("Y1", "(-?\\d+(%|%[-+]\\d+)?)"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("\\)"))), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("STYLE", "(\\<?[-=]{1,2}\\>|\\<?[-=]{1,2})"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("NAME2", "([\\w][.\\w]*)"), new RegexOptional((IRegex)new RegexConcat(RegexLeaf.spaceZeroOrMore(), new RegexLeaf("COLOR", "(#\\w+)?"))), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("MESSAGE", "(?::[%s]*(.*))?"), RegexLeaf.spaceZeroOrMore(), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeArg(WireDiagram diagram, LineLocation location, RegexResult arg) throws NoSuchColorException {
        Display label;
        String name1 = arg.get("NAME1", 0);
        String x1 = arg.get("X1", 0);
        String y1 = arg.get("Y1", 0);
        String name2 = arg.get("NAME2", 0);
        String style = arg.get("STYLE", 0);
        WLinkType type = WLinkType.from(style);
        WArrowDirection direction = WArrowDirection.from(style);
        WOrientation orientation = WOrientation.from(style);
        String stringColor = arg.get("COLOR", 0);
        HColor color = null;
        if (stringColor != null) {
            color = HColorSet.instance().getColor(stringColor);
        }
        if (arg.get("MESSAGE", 0) == null) {
            label = Display.NULL;
        } else {
            String message = arg.get("MESSAGE", 0);
            label = Display.getWithNewlines(message);
        }
        if (orientation == WOrientation.VERTICAL) {
            return diagram.vlink(name1, x1, y1, name2, type, direction, color, label);
        }
        return diagram.hlink(name1, x1, y1, name2, type, direction, color, label);
    }
}

