from typing import Any, ClassVar, Literal

LABELS_ADDED: str
NODES_CREATED: str
NODES_DELETED: str
RELATIONSHIPS_DELETED: str
PROPERTIES_SET: str
RELATIONSHIPS_CREATED: str
INDICES_CREATED: str
INDICES_DELETED: str
CACHED_EXECUTION: str
INTERNAL_EXECUTION_TIME: str
STATS: Any

class ResultSetColumnTypes:
    COLUMN_UNKNOWN: ClassVar[Literal[0]]
    COLUMN_SCALAR: ClassVar[Literal[1]]
    COLUMN_NODE: ClassVar[Literal[2]]
    COLUMN_RELATION: ClassVar[Literal[3]]

class ResultSetScalarTypes:
    VALUE_UNKNOWN: ClassVar[Literal[0]]
    VALUE_NULL: ClassVar[Literal[1]]
    VALUE_STRING: ClassVar[Literal[2]]
    VALUE_INTEGER: ClassVar[Literal[3]]
    VALUE_BOOLEAN: ClassVar[Literal[4]]
    VALUE_DOUBLE: ClassVar[Literal[5]]
    VALUE_ARRAY: ClassVar[Literal[6]]
    VALUE_EDGE: ClassVar[Literal[7]]
    VALUE_NODE: ClassVar[Literal[8]]
    VALUE_PATH: ClassVar[Literal[9]]
    VALUE_MAP: ClassVar[Literal[10]]
    VALUE_POINT: ClassVar[Literal[11]]

class QueryResult:
    graph: Any
    header: Any
    result_set: Any
    def __init__(self, graph, response, profile: bool = False) -> None: ...
    def parse_results(self, raw_result_set) -> None: ...
    statistics: Any
    def parse_statistics(self, raw_statistics) -> None: ...
    def parse_header(self, raw_result_set): ...
    def parse_records(self, raw_result_set): ...
    def parse_entity_properties(self, props): ...
    def parse_string(self, cell): ...
    def parse_node(self, cell): ...
    def parse_edge(self, cell): ...
    def parse_path(self, cell): ...
    def parse_map(self, cell): ...
    def parse_point(self, cell): ...
    def parse_scalar(self, cell): ...
    def parse_profile(self, response) -> None: ...
    def is_empty(self): ...
    @property
    def labels_added(self): ...
    @property
    def nodes_created(self): ...
    @property
    def nodes_deleted(self): ...
    @property
    def properties_set(self): ...
    @property
    def relationships_created(self): ...
    @property
    def relationships_deleted(self): ...
    @property
    def indices_created(self): ...
    @property
    def indices_deleted(self): ...
    @property
    def cached_execution(self): ...
    @property
    def run_time_ms(self): ...
