// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from LPC15xx_v0.7.svd, see https://github.com/posborne/cmsis-svd/tree/master/data/NXP

//go:build nxp && lpc15xx

// LPC15xx Cortex-M3 MCU; up to 64 kB flash; up to 12 kB SRAM; USB device; USART; EEPROM
//

package nxp

import (
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	Device       = "LPC15xx"
	CPU          = "CM3"
	FPUPresent   = false
	NVICPrioBits = 3
)

// Interrupt numbers.
const (
	// Windowed Watchdog Timer (WWDT)
	IRQ_WDT = 0

	// System configuration (SYSCON)
	IRQ_BOD_IRQ = 1

	// Flash controller
	IRQ_FLASH = 2

	// Flash controller
	IRQ_EE = 3

	// DMA controller
	IRQ_DMA = 4

	// Group interrupt 0/1 (GINT0/1)
	IRQ_GINT0 = 5

	// GINT1
	IRQ_GINT1 = 6

	// Pin interrupt and pattern match (PINT)
	IRQ_PIN_INT0 = 7

	// Pin interrupt and pattern match (PINT)
	IRQ_PIN_INT1 = 8

	// Pin interrupt and pattern match (PINT)
	IRQ_PIN_INT2 = 9

	// Pin interrupt and pattern match (PINT)
	IRQ_PIN_INT3 = 10

	// Pin interrupt and pattern match (PINT)
	IRQ_PIN_INT4 = 11

	// Pin interrupt and pattern match (PINT)
	IRQ_PIN_INT5 = 12

	// Pin interrupt and pattern match (PINT)
	IRQ_PIN_INT6 = 13

	// Pin interrupt and pattern match (PINT)
	IRQ_PIN_INT7 = 14

	// Repetitive Interrupt Timer (RIT)
	IRQ_RIT = 15

	// Large State Configurable Timers 0/1 (SCT0/1)
	IRQ_SCT0 = 16

	// SCT1
	IRQ_SCT1 = 17

	// Small State Configurable Timers 2/3 (SCT2/3)
	IRQ_SCT2 = 18

	// SCT3
	IRQ_SCT3 = 19

	// Multi-Rate Timer (MRT)
	IRQ_MRT = 20

	// USART0
	IRQ_UART0 = 21

	// USART1
	IRQ_UART1 = 22

	// USART2
	IRQ_UART2 = 23

	// I2C-bus interface
	IRQ_I2C0 = 24

	// SPI0
	IRQ_SPI0 = 25

	// SPI1
	IRQ_SPI1 = 26

	// Controller Area Network C_CAN0
	IRQ_C_CAN0 = 27

	// USB device controller
	IRQ_USB_IRQ = 28

	// USB device controller
	IRQ_USB_FIQ = 29

	// USB device controller
	IRQ_USBWAKEUP = 30

	// 12-bit ADC controller ADC0/1
	IRQ_ADC0_SEQA = 31

	// 12-bit ADC controller ADC0/1
	IRQ_ADC0_SEQB = 32

	// 12-bit ADC controller ADC0/1
	IRQ_ADC0_THCMP = 33

	// 12-bit ADC controller ADC0/1
	IRQ_ADC0_OVR = 34

	// ADC1
	IRQ_ADC1_SEQA = 35

	// ADC1
	IRQ_ADC1_SEQB = 36

	// ADC1
	IRQ_ADC1_THCMP = 37

	// ADC1
	IRQ_ADC1_OVR = 38

	// 12-bit DAC Modification
	IRQ_DAC = 39

	// Analog comparators ACMP0/1/2/3
	IRQ_CMP0 = 40

	// Analog comparators ACMP0/1/2/3
	IRQ_CMP1 = 41

	// Analog comparators ACMP0/1/2/3
	IRQ_CMP2 = 42

	// Analog comparators ACMP0/1/2/3
	IRQ_CMP3 = 43

	// Quadrature Encoder Interface (QEI)
	IRQ_QEI = 44

	// Real-Time Clock (RTC)
	IRQ_RTC_ALARM = 45

	// Real-Time Clock (RTC)
	IRQ_RTC_WAKE = 46

	// Highest interrupt number on this device.
	IRQ_max = 46
)

// Pseudo function call that is replaced by the compiler with the actual
// functions registered through interrupt.New.
//
//go:linkname callHandlers runtime/interrupt.callHandlers
func callHandlers(num int)

//export WDT_IRQHandler
func interruptWDT() {
	callHandlers(IRQ_WDT)
}

//export BOD_IRQ_IRQHandler
func interruptBOD_IRQ() {
	callHandlers(IRQ_BOD_IRQ)
}

//export FLASH_IRQHandler
func interruptFLASH() {
	callHandlers(IRQ_FLASH)
}

//export EE_IRQHandler
func interruptEE() {
	callHandlers(IRQ_EE)
}

//export DMA_IRQHandler
func interruptDMA() {
	callHandlers(IRQ_DMA)
}

//export GINT0_IRQHandler
func interruptGINT0() {
	callHandlers(IRQ_GINT0)
}

//export GINT1_IRQHandler
func interruptGINT1() {
	callHandlers(IRQ_GINT1)
}

//export PIN_INT0_IRQHandler
func interruptPIN_INT0() {
	callHandlers(IRQ_PIN_INT0)
}

//export PIN_INT1_IRQHandler
func interruptPIN_INT1() {
	callHandlers(IRQ_PIN_INT1)
}

//export PIN_INT2_IRQHandler
func interruptPIN_INT2() {
	callHandlers(IRQ_PIN_INT2)
}

//export PIN_INT3_IRQHandler
func interruptPIN_INT3() {
	callHandlers(IRQ_PIN_INT3)
}

//export PIN_INT4_IRQHandler
func interruptPIN_INT4() {
	callHandlers(IRQ_PIN_INT4)
}

//export PIN_INT5_IRQHandler
func interruptPIN_INT5() {
	callHandlers(IRQ_PIN_INT5)
}

//export PIN_INT6_IRQHandler
func interruptPIN_INT6() {
	callHandlers(IRQ_PIN_INT6)
}

//export PIN_INT7_IRQHandler
func interruptPIN_INT7() {
	callHandlers(IRQ_PIN_INT7)
}

//export RIT_IRQHandler
func interruptRIT() {
	callHandlers(IRQ_RIT)
}

//export SCT0_IRQHandler
func interruptSCT0() {
	callHandlers(IRQ_SCT0)
}

//export SCT1_IRQHandler
func interruptSCT1() {
	callHandlers(IRQ_SCT1)
}

//export SCT2_IRQHandler
func interruptSCT2() {
	callHandlers(IRQ_SCT2)
}

//export SCT3_IRQHandler
func interruptSCT3() {
	callHandlers(IRQ_SCT3)
}

//export MRT_IRQHandler
func interruptMRT() {
	callHandlers(IRQ_MRT)
}

//export UART0_IRQHandler
func interruptUART0() {
	callHandlers(IRQ_UART0)
}

//export UART1_IRQHandler
func interruptUART1() {
	callHandlers(IRQ_UART1)
}

//export UART2_IRQHandler
func interruptUART2() {
	callHandlers(IRQ_UART2)
}

//export I2C0_IRQHandler
func interruptI2C0() {
	callHandlers(IRQ_I2C0)
}

//export SPI0_IRQHandler
func interruptSPI0() {
	callHandlers(IRQ_SPI0)
}

//export SPI1_IRQHandler
func interruptSPI1() {
	callHandlers(IRQ_SPI1)
}

//export C_CAN0_IRQHandler
func interruptC_CAN0() {
	callHandlers(IRQ_C_CAN0)
}

//export USB_IRQ_IRQHandler
func interruptUSB_IRQ() {
	callHandlers(IRQ_USB_IRQ)
}

//export USB_FIQ_IRQHandler
func interruptUSB_FIQ() {
	callHandlers(IRQ_USB_FIQ)
}

//export USBWAKEUP_IRQHandler
func interruptUSBWAKEUP() {
	callHandlers(IRQ_USBWAKEUP)
}

//export ADC0_SEQA_IRQHandler
func interruptADC0_SEQA() {
	callHandlers(IRQ_ADC0_SEQA)
}

//export ADC0_SEQB_IRQHandler
func interruptADC0_SEQB() {
	callHandlers(IRQ_ADC0_SEQB)
}

//export ADC0_THCMP_IRQHandler
func interruptADC0_THCMP() {
	callHandlers(IRQ_ADC0_THCMP)
}

//export ADC0_OVR_IRQHandler
func interruptADC0_OVR() {
	callHandlers(IRQ_ADC0_OVR)
}

//export ADC1_SEQA_IRQHandler
func interruptADC1_SEQA() {
	callHandlers(IRQ_ADC1_SEQA)
}

//export ADC1_SEQB_IRQHandler
func interruptADC1_SEQB() {
	callHandlers(IRQ_ADC1_SEQB)
}

//export ADC1_THCMP_IRQHandler
func interruptADC1_THCMP() {
	callHandlers(IRQ_ADC1_THCMP)
}

//export ADC1_OVR_IRQHandler
func interruptADC1_OVR() {
	callHandlers(IRQ_ADC1_OVR)
}

//export DAC_IRQHandler
func interruptDAC() {
	callHandlers(IRQ_DAC)
}

//export CMP0_IRQHandler
func interruptCMP0() {
	callHandlers(IRQ_CMP0)
}

//export CMP1_IRQHandler
func interruptCMP1() {
	callHandlers(IRQ_CMP1)
}

//export CMP2_IRQHandler
func interruptCMP2() {
	callHandlers(IRQ_CMP2)
}

//export CMP3_IRQHandler
func interruptCMP3() {
	callHandlers(IRQ_CMP3)
}

//export QEI_IRQHandler
func interruptQEI() {
	callHandlers(IRQ_QEI)
}

//export RTC_ALARM_IRQHandler
func interruptRTC_ALARM() {
	callHandlers(IRQ_RTC_ALARM)
}

//export RTC_WAKE_IRQHandler
func interruptRTC_WAKE() {
	callHandlers(IRQ_RTC_WAKE)
}

// Peripherals.
var (
	// General Purpose I/O (GPIO)
	GPIO_PORT = (*GPIO_Type)(unsafe.Pointer(uintptr(0x1c000000)))

	// DMA controller
	DMA = (*DMA_Type)(unsafe.Pointer(uintptr(0x1c004000)))

	// USB device controller
	USB = (*USB_Type)(unsafe.Pointer(uintptr(0x1c00c000)))

	// Cyclic Redundancy Check (CRC) engine
	CRC = (*CRC_Type)(unsafe.Pointer(uintptr(0x1c010000)))

	// Large State Configurable Timers 0/1 (SCT0/1)
	SCT0 = (*SCT0_Type)(unsafe.Pointer(uintptr(0x1c018000)))

	// SCT1
	SCT1 = (*SCT0_Type)(unsafe.Pointer(uintptr(0x1c01c000)))

	// Small State Configurable Timers 2/3 (SCT2/3)
	SCT2 = (*SCT2_Type)(unsafe.Pointer(uintptr(0x1c020000)))

	// SCT3
	SCT3 = (*SCT2_Type)(unsafe.Pointer(uintptr(0x1c024000)))

	// 12-bit ADC controller ADC0/1
	ADC0 = (*ADC_Type)(unsafe.Pointer(uintptr(0x40000000)))

	// 12-bit DAC Modification
	DAC = (*DAC_Type)(unsafe.Pointer(uintptr(0x40004000)))

	// Analog comparators ACMP0/1/2/3
	ACMP = (*ACMP_Type)(unsafe.Pointer(uintptr(0x40008000)))

	// Input multiplexing (INMUX)
	INMUX = (*INMUX_Type)(unsafe.Pointer(uintptr(0x40014000)))

	// Real-Time Clock (RTC)
	RTC = (*RTC_Type)(unsafe.Pointer(uintptr(0x40028000)))

	// Windowed Watchdog Timer (WWDT)
	WWDT = (*WWDT_Type)(unsafe.Pointer(uintptr(0x4002c000)))

	// Switch Matrix (SWM)
	SWM = (*SWM_Type)(unsafe.Pointer(uintptr(0x40038000)))

	// Power Management Unit (PMU)
	PMU = (*PMU_Type)(unsafe.Pointer(uintptr(0x4003c000)))

	// USART0
	USART0 = (*USART0_Type)(unsafe.Pointer(uintptr(0x40040000)))

	// USART1
	USART1 = (*USART0_Type)(unsafe.Pointer(uintptr(0x40044000)))

	// SPI0
	SPI0 = (*SPI0_Type)(unsafe.Pointer(uintptr(0x40048000)))

	// SPI1
	SPI1 = (*SPI0_Type)(unsafe.Pointer(uintptr(0x4004c000)))

	// I2C-bus interface
	I2C0 = (*I2C0_Type)(unsafe.Pointer(uintptr(0x40050000)))

	// Quadrature Encoder Interface (QEI)
	QEI = (*QEI_Type)(unsafe.Pointer(uintptr(0x40058000)))

	// System configuration (SYSCON)
	SYSCON = (*SYSCON_Type)(unsafe.Pointer(uintptr(0x40074000)))

	// Multi-Rate Timer (MRT)
	MRT = (*MRT_Type)(unsafe.Pointer(uintptr(0x400a0000)))

	// Pin interrupt and pattern match (PINT)
	PINT = (*PINT_Type)(unsafe.Pointer(uintptr(0x400a4000)))

	// Group interrupt 0/1 (GINT0/1)
	GINT0 = (*GINT_Type)(unsafe.Pointer(uintptr(0x400a8000)))

	// Repetitive Interrupt Timer (RIT)
	RIT = (*RIT_Type)(unsafe.Pointer(uintptr(0x400b4000)))

	// SCT Input Processing Unit (IPU)
	SCTIPU = (*SCTIPU_Type)(unsafe.Pointer(uintptr(0x400b8000)))

	// Flash controller
	FLASHCTRL = (*FLASHCTRL_Type)(unsafe.Pointer(uintptr(0x400bc000)))

	// USART2
	USART2 = (*USART0_Type)(unsafe.Pointer(uintptr(0x400c0000)))

	// Controller Area Network C_CAN0
	C_CAN0 = (*C_CAN0_Type)(unsafe.Pointer(uintptr(0x400f0000)))

	// I/O pin configuration (IOCON)
	IOCON = (*IOCON_Type)(unsafe.Pointer(uintptr(0x400f8000)))

	// ADC1
	ADC1 = (*ADC_Type)(unsafe.Pointer(uintptr(0x40080000)))

	// GINT1
	GINT1 = (*GINT_Type)(unsafe.Pointer(uintptr(0x400ac000)))
)

// General Purpose I/O (GPIO)
type GPIO_Type struct {
	B    [76]volatile.Register8 // 0x0
	_    [4020]byte
	W    [76]volatile.Register32 // 0x1000
	_    [3792]byte
	DIR  [3]volatile.Register32 // 0x2000
	_    [116]byte
	MASK [3]volatile.Register32 // 0x2080
	_    [116]byte
	PIN  [3]volatile.Register32 // 0x2100
	_    [116]byte
	MPIN [3]volatile.Register32 // 0x2180
	_    [116]byte
	SET  [3]volatile.Register32 // 0x2200
	_    [116]byte
	CLR  [3]volatile.Register32 // 0x2280
	_    [116]byte
	NOT  [3]volatile.Register32 // 0x2300
}

// GPIO.B: Byte pin registers
func (o *GPIO_Type) SetB_PBYTE(idx int, value uint8) {
	volatile.StoreUint8(&o.B[idx].Reg, volatile.LoadUint8(&o.B[idx].Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetB_PBYTE(idx int) uint8 {
	return volatile.LoadUint8(&o.B[idx].Reg) & 0x1
}

// GPIO.W: Word pin registers
func (o *GPIO_Type) SetW(idx int, value uint32) {
	volatile.StoreUint32(&o.W[idx].Reg, value)
}
func (o *GPIO_Type) GetW(idx int) uint32 {
	return volatile.LoadUint32(&o.W[idx].Reg)
}

// GPIO.DIR: Port Direction registers
func (o *GPIO_Type) SetDIR_DIRP0(idx int, value uint32) {
	volatile.StoreUint32(&o.DIR[idx].Reg, volatile.LoadUint32(&o.DIR[idx].Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetDIR_DIRP0(idx int) uint32 {
	return volatile.LoadUint32(&o.DIR[idx].Reg) & 0x1
}
func (o *GPIO_Type) SetDIR_DIRP1(idx int, value uint32) {
	volatile.StoreUint32(&o.DIR[idx].Reg, volatile.LoadUint32(&o.DIR[idx].Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetDIR_DIRP1(idx int) uint32 {
	return (volatile.LoadUint32(&o.DIR[idx].Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetDIR_DIRP2(idx int, value uint32) {
	volatile.StoreUint32(&o.DIR[idx].Reg, volatile.LoadUint32(&o.DIR[idx].Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetDIR_DIRP2(idx int) uint32 {
	return (volatile.LoadUint32(&o.DIR[idx].Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetDIR_DIRP3(idx int, value uint32) {
	volatile.StoreUint32(&o.DIR[idx].Reg, volatile.LoadUint32(&o.DIR[idx].Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetDIR_DIRP3(idx int) uint32 {
	return (volatile.LoadUint32(&o.DIR[idx].Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetDIR_DIRP4(idx int, value uint32) {
	volatile.StoreUint32(&o.DIR[idx].Reg, volatile.LoadUint32(&o.DIR[idx].Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetDIR_DIRP4(idx int) uint32 {
	return (volatile.LoadUint32(&o.DIR[idx].Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetDIR_DIRP5(idx int, value uint32) {
	volatile.StoreUint32(&o.DIR[idx].Reg, volatile.LoadUint32(&o.DIR[idx].Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetDIR_DIRP5(idx int) uint32 {
	return (volatile.LoadUint32(&o.DIR[idx].Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetDIR_DIRP6(idx int, value uint32) {
	volatile.StoreUint32(&o.DIR[idx].Reg, volatile.LoadUint32(&o.DIR[idx].Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetDIR_DIRP6(idx int) uint32 {
	return (volatile.LoadUint32(&o.DIR[idx].Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetDIR_DIRP7(idx int, value uint32) {
	volatile.StoreUint32(&o.DIR[idx].Reg, volatile.LoadUint32(&o.DIR[idx].Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetDIR_DIRP7(idx int) uint32 {
	return (volatile.LoadUint32(&o.DIR[idx].Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetDIR_DIRP8(idx int, value uint32) {
	volatile.StoreUint32(&o.DIR[idx].Reg, volatile.LoadUint32(&o.DIR[idx].Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetDIR_DIRP8(idx int) uint32 {
	return (volatile.LoadUint32(&o.DIR[idx].Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetDIR_DIRP9(idx int, value uint32) {
	volatile.StoreUint32(&o.DIR[idx].Reg, volatile.LoadUint32(&o.DIR[idx].Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetDIR_DIRP9(idx int) uint32 {
	return (volatile.LoadUint32(&o.DIR[idx].Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetDIR_DIRP10(idx int, value uint32) {
	volatile.StoreUint32(&o.DIR[idx].Reg, volatile.LoadUint32(&o.DIR[idx].Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetDIR_DIRP10(idx int) uint32 {
	return (volatile.LoadUint32(&o.DIR[idx].Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetDIR_DIRP11(idx int, value uint32) {
	volatile.StoreUint32(&o.DIR[idx].Reg, volatile.LoadUint32(&o.DIR[idx].Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetDIR_DIRP11(idx int) uint32 {
	return (volatile.LoadUint32(&o.DIR[idx].Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetDIR_DIRP12(idx int, value uint32) {
	volatile.StoreUint32(&o.DIR[idx].Reg, volatile.LoadUint32(&o.DIR[idx].Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetDIR_DIRP12(idx int) uint32 {
	return (volatile.LoadUint32(&o.DIR[idx].Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetDIR_DIRP13(idx int, value uint32) {
	volatile.StoreUint32(&o.DIR[idx].Reg, volatile.LoadUint32(&o.DIR[idx].Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetDIR_DIRP13(idx int) uint32 {
	return (volatile.LoadUint32(&o.DIR[idx].Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetDIR_DIRP14(idx int, value uint32) {
	volatile.StoreUint32(&o.DIR[idx].Reg, volatile.LoadUint32(&o.DIR[idx].Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetDIR_DIRP14(idx int) uint32 {
	return (volatile.LoadUint32(&o.DIR[idx].Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetDIR_DIRP15(idx int, value uint32) {
	volatile.StoreUint32(&o.DIR[idx].Reg, volatile.LoadUint32(&o.DIR[idx].Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetDIR_DIRP15(idx int) uint32 {
	return (volatile.LoadUint32(&o.DIR[idx].Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetDIR_DIRP16(idx int, value uint32) {
	volatile.StoreUint32(&o.DIR[idx].Reg, volatile.LoadUint32(&o.DIR[idx].Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetDIR_DIRP16(idx int) uint32 {
	return (volatile.LoadUint32(&o.DIR[idx].Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetDIR_DIRP17(idx int, value uint32) {
	volatile.StoreUint32(&o.DIR[idx].Reg, volatile.LoadUint32(&o.DIR[idx].Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetDIR_DIRP17(idx int) uint32 {
	return (volatile.LoadUint32(&o.DIR[idx].Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetDIR_DIRP18(idx int, value uint32) {
	volatile.StoreUint32(&o.DIR[idx].Reg, volatile.LoadUint32(&o.DIR[idx].Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetDIR_DIRP18(idx int) uint32 {
	return (volatile.LoadUint32(&o.DIR[idx].Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetDIR_DIRP19(idx int, value uint32) {
	volatile.StoreUint32(&o.DIR[idx].Reg, volatile.LoadUint32(&o.DIR[idx].Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetDIR_DIRP19(idx int) uint32 {
	return (volatile.LoadUint32(&o.DIR[idx].Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetDIR_DIRP20(idx int, value uint32) {
	volatile.StoreUint32(&o.DIR[idx].Reg, volatile.LoadUint32(&o.DIR[idx].Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetDIR_DIRP20(idx int) uint32 {
	return (volatile.LoadUint32(&o.DIR[idx].Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetDIR_DIRP21(idx int, value uint32) {
	volatile.StoreUint32(&o.DIR[idx].Reg, volatile.LoadUint32(&o.DIR[idx].Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetDIR_DIRP21(idx int) uint32 {
	return (volatile.LoadUint32(&o.DIR[idx].Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetDIR_DIRP22(idx int, value uint32) {
	volatile.StoreUint32(&o.DIR[idx].Reg, volatile.LoadUint32(&o.DIR[idx].Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetDIR_DIRP22(idx int) uint32 {
	return (volatile.LoadUint32(&o.DIR[idx].Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetDIR_DIRP23(idx int, value uint32) {
	volatile.StoreUint32(&o.DIR[idx].Reg, volatile.LoadUint32(&o.DIR[idx].Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetDIR_DIRP23(idx int) uint32 {
	return (volatile.LoadUint32(&o.DIR[idx].Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetDIR_DIRP24(idx int, value uint32) {
	volatile.StoreUint32(&o.DIR[idx].Reg, volatile.LoadUint32(&o.DIR[idx].Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetDIR_DIRP24(idx int) uint32 {
	return (volatile.LoadUint32(&o.DIR[idx].Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetDIR_DIRP25(idx int, value uint32) {
	volatile.StoreUint32(&o.DIR[idx].Reg, volatile.LoadUint32(&o.DIR[idx].Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetDIR_DIRP25(idx int) uint32 {
	return (volatile.LoadUint32(&o.DIR[idx].Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetDIR_DIRP26(idx int, value uint32) {
	volatile.StoreUint32(&o.DIR[idx].Reg, volatile.LoadUint32(&o.DIR[idx].Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetDIR_DIRP26(idx int) uint32 {
	return (volatile.LoadUint32(&o.DIR[idx].Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetDIR_DIRP27(idx int, value uint32) {
	volatile.StoreUint32(&o.DIR[idx].Reg, volatile.LoadUint32(&o.DIR[idx].Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetDIR_DIRP27(idx int) uint32 {
	return (volatile.LoadUint32(&o.DIR[idx].Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetDIR_DIRP28(idx int, value uint32) {
	volatile.StoreUint32(&o.DIR[idx].Reg, volatile.LoadUint32(&o.DIR[idx].Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetDIR_DIRP28(idx int) uint32 {
	return (volatile.LoadUint32(&o.DIR[idx].Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetDIR_DIRP29(idx int, value uint32) {
	volatile.StoreUint32(&o.DIR[idx].Reg, volatile.LoadUint32(&o.DIR[idx].Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetDIR_DIRP29(idx int) uint32 {
	return (volatile.LoadUint32(&o.DIR[idx].Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetDIR_DIRP30(idx int, value uint32) {
	volatile.StoreUint32(&o.DIR[idx].Reg, volatile.LoadUint32(&o.DIR[idx].Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetDIR_DIRP30(idx int) uint32 {
	return (volatile.LoadUint32(&o.DIR[idx].Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetDIR_DIRP31(idx int, value uint32) {
	volatile.StoreUint32(&o.DIR[idx].Reg, volatile.LoadUint32(&o.DIR[idx].Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetDIR_DIRP31(idx int) uint32 {
	return (volatile.LoadUint32(&o.DIR[idx].Reg) & 0x80000000) >> 31
}

// GPIO.MASK: Port Mask register
func (o *GPIO_Type) SetMASK_MASKP0(idx int, value uint32) {
	volatile.StoreUint32(&o.MASK[idx].Reg, volatile.LoadUint32(&o.MASK[idx].Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetMASK_MASKP0(idx int) uint32 {
	return volatile.LoadUint32(&o.MASK[idx].Reg) & 0x1
}
func (o *GPIO_Type) SetMASK_MASKP1(idx int, value uint32) {
	volatile.StoreUint32(&o.MASK[idx].Reg, volatile.LoadUint32(&o.MASK[idx].Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetMASK_MASKP1(idx int) uint32 {
	return (volatile.LoadUint32(&o.MASK[idx].Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetMASK_MASKP2(idx int, value uint32) {
	volatile.StoreUint32(&o.MASK[idx].Reg, volatile.LoadUint32(&o.MASK[idx].Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetMASK_MASKP2(idx int) uint32 {
	return (volatile.LoadUint32(&o.MASK[idx].Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetMASK_MASKP3(idx int, value uint32) {
	volatile.StoreUint32(&o.MASK[idx].Reg, volatile.LoadUint32(&o.MASK[idx].Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetMASK_MASKP3(idx int) uint32 {
	return (volatile.LoadUint32(&o.MASK[idx].Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetMASK_MASKP4(idx int, value uint32) {
	volatile.StoreUint32(&o.MASK[idx].Reg, volatile.LoadUint32(&o.MASK[idx].Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetMASK_MASKP4(idx int) uint32 {
	return (volatile.LoadUint32(&o.MASK[idx].Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetMASK_MASKP5(idx int, value uint32) {
	volatile.StoreUint32(&o.MASK[idx].Reg, volatile.LoadUint32(&o.MASK[idx].Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetMASK_MASKP5(idx int) uint32 {
	return (volatile.LoadUint32(&o.MASK[idx].Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetMASK_MASKP6(idx int, value uint32) {
	volatile.StoreUint32(&o.MASK[idx].Reg, volatile.LoadUint32(&o.MASK[idx].Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetMASK_MASKP6(idx int) uint32 {
	return (volatile.LoadUint32(&o.MASK[idx].Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetMASK_MASKP7(idx int, value uint32) {
	volatile.StoreUint32(&o.MASK[idx].Reg, volatile.LoadUint32(&o.MASK[idx].Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetMASK_MASKP7(idx int) uint32 {
	return (volatile.LoadUint32(&o.MASK[idx].Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetMASK_MASKP8(idx int, value uint32) {
	volatile.StoreUint32(&o.MASK[idx].Reg, volatile.LoadUint32(&o.MASK[idx].Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetMASK_MASKP8(idx int) uint32 {
	return (volatile.LoadUint32(&o.MASK[idx].Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetMASK_MASKP9(idx int, value uint32) {
	volatile.StoreUint32(&o.MASK[idx].Reg, volatile.LoadUint32(&o.MASK[idx].Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetMASK_MASKP9(idx int) uint32 {
	return (volatile.LoadUint32(&o.MASK[idx].Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetMASK_MASKP10(idx int, value uint32) {
	volatile.StoreUint32(&o.MASK[idx].Reg, volatile.LoadUint32(&o.MASK[idx].Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetMASK_MASKP10(idx int) uint32 {
	return (volatile.LoadUint32(&o.MASK[idx].Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetMASK_MASKP11(idx int, value uint32) {
	volatile.StoreUint32(&o.MASK[idx].Reg, volatile.LoadUint32(&o.MASK[idx].Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetMASK_MASKP11(idx int) uint32 {
	return (volatile.LoadUint32(&o.MASK[idx].Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetMASK_MASKP12(idx int, value uint32) {
	volatile.StoreUint32(&o.MASK[idx].Reg, volatile.LoadUint32(&o.MASK[idx].Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetMASK_MASKP12(idx int) uint32 {
	return (volatile.LoadUint32(&o.MASK[idx].Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetMASK_MASKP13(idx int, value uint32) {
	volatile.StoreUint32(&o.MASK[idx].Reg, volatile.LoadUint32(&o.MASK[idx].Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetMASK_MASKP13(idx int) uint32 {
	return (volatile.LoadUint32(&o.MASK[idx].Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetMASK_MASKP14(idx int, value uint32) {
	volatile.StoreUint32(&o.MASK[idx].Reg, volatile.LoadUint32(&o.MASK[idx].Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetMASK_MASKP14(idx int) uint32 {
	return (volatile.LoadUint32(&o.MASK[idx].Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetMASK_MASKP15(idx int, value uint32) {
	volatile.StoreUint32(&o.MASK[idx].Reg, volatile.LoadUint32(&o.MASK[idx].Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetMASK_MASKP15(idx int) uint32 {
	return (volatile.LoadUint32(&o.MASK[idx].Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetMASK_MASKP16(idx int, value uint32) {
	volatile.StoreUint32(&o.MASK[idx].Reg, volatile.LoadUint32(&o.MASK[idx].Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetMASK_MASKP16(idx int) uint32 {
	return (volatile.LoadUint32(&o.MASK[idx].Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetMASK_MASKP17(idx int, value uint32) {
	volatile.StoreUint32(&o.MASK[idx].Reg, volatile.LoadUint32(&o.MASK[idx].Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetMASK_MASKP17(idx int) uint32 {
	return (volatile.LoadUint32(&o.MASK[idx].Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetMASK_MASKP18(idx int, value uint32) {
	volatile.StoreUint32(&o.MASK[idx].Reg, volatile.LoadUint32(&o.MASK[idx].Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetMASK_MASKP18(idx int) uint32 {
	return (volatile.LoadUint32(&o.MASK[idx].Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetMASK_MASKP19(idx int, value uint32) {
	volatile.StoreUint32(&o.MASK[idx].Reg, volatile.LoadUint32(&o.MASK[idx].Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetMASK_MASKP19(idx int) uint32 {
	return (volatile.LoadUint32(&o.MASK[idx].Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetMASK_MASKP20(idx int, value uint32) {
	volatile.StoreUint32(&o.MASK[idx].Reg, volatile.LoadUint32(&o.MASK[idx].Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetMASK_MASKP20(idx int) uint32 {
	return (volatile.LoadUint32(&o.MASK[idx].Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetMASK_MASKP21(idx int, value uint32) {
	volatile.StoreUint32(&o.MASK[idx].Reg, volatile.LoadUint32(&o.MASK[idx].Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetMASK_MASKP21(idx int) uint32 {
	return (volatile.LoadUint32(&o.MASK[idx].Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetMASK_MASKP22(idx int, value uint32) {
	volatile.StoreUint32(&o.MASK[idx].Reg, volatile.LoadUint32(&o.MASK[idx].Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetMASK_MASKP22(idx int) uint32 {
	return (volatile.LoadUint32(&o.MASK[idx].Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetMASK_MASKP23(idx int, value uint32) {
	volatile.StoreUint32(&o.MASK[idx].Reg, volatile.LoadUint32(&o.MASK[idx].Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetMASK_MASKP23(idx int) uint32 {
	return (volatile.LoadUint32(&o.MASK[idx].Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetMASK_MASKP24(idx int, value uint32) {
	volatile.StoreUint32(&o.MASK[idx].Reg, volatile.LoadUint32(&o.MASK[idx].Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetMASK_MASKP24(idx int) uint32 {
	return (volatile.LoadUint32(&o.MASK[idx].Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetMASK_MASKP25(idx int, value uint32) {
	volatile.StoreUint32(&o.MASK[idx].Reg, volatile.LoadUint32(&o.MASK[idx].Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetMASK_MASKP25(idx int) uint32 {
	return (volatile.LoadUint32(&o.MASK[idx].Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetMASK_MASKP26(idx int, value uint32) {
	volatile.StoreUint32(&o.MASK[idx].Reg, volatile.LoadUint32(&o.MASK[idx].Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetMASK_MASKP26(idx int) uint32 {
	return (volatile.LoadUint32(&o.MASK[idx].Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetMASK_MASKP27(idx int, value uint32) {
	volatile.StoreUint32(&o.MASK[idx].Reg, volatile.LoadUint32(&o.MASK[idx].Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetMASK_MASKP27(idx int) uint32 {
	return (volatile.LoadUint32(&o.MASK[idx].Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetMASK_MASKP28(idx int, value uint32) {
	volatile.StoreUint32(&o.MASK[idx].Reg, volatile.LoadUint32(&o.MASK[idx].Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetMASK_MASKP28(idx int) uint32 {
	return (volatile.LoadUint32(&o.MASK[idx].Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetMASK_MASKP29(idx int, value uint32) {
	volatile.StoreUint32(&o.MASK[idx].Reg, volatile.LoadUint32(&o.MASK[idx].Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetMASK_MASKP29(idx int) uint32 {
	return (volatile.LoadUint32(&o.MASK[idx].Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetMASK_MASKP30(idx int, value uint32) {
	volatile.StoreUint32(&o.MASK[idx].Reg, volatile.LoadUint32(&o.MASK[idx].Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetMASK_MASKP30(idx int) uint32 {
	return (volatile.LoadUint32(&o.MASK[idx].Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetMASK_MASKP31(idx int, value uint32) {
	volatile.StoreUint32(&o.MASK[idx].Reg, volatile.LoadUint32(&o.MASK[idx].Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetMASK_MASKP31(idx int) uint32 {
	return (volatile.LoadUint32(&o.MASK[idx].Reg) & 0x80000000) >> 31
}

// GPIO.PIN: Port pin register
func (o *GPIO_Type) SetPIN_PORT0(idx int, value uint32) {
	volatile.StoreUint32(&o.PIN[idx].Reg, volatile.LoadUint32(&o.PIN[idx].Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetPIN_PORT0(idx int) uint32 {
	return volatile.LoadUint32(&o.PIN[idx].Reg) & 0x1
}
func (o *GPIO_Type) SetPIN_PORT1(idx int, value uint32) {
	volatile.StoreUint32(&o.PIN[idx].Reg, volatile.LoadUint32(&o.PIN[idx].Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetPIN_PORT1(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIN[idx].Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetPIN_PORT2(idx int, value uint32) {
	volatile.StoreUint32(&o.PIN[idx].Reg, volatile.LoadUint32(&o.PIN[idx].Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN_PORT2(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIN[idx].Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN_PORT3(idx int, value uint32) {
	volatile.StoreUint32(&o.PIN[idx].Reg, volatile.LoadUint32(&o.PIN[idx].Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetPIN_PORT3(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIN[idx].Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetPIN_PORT4(idx int, value uint32) {
	volatile.StoreUint32(&o.PIN[idx].Reg, volatile.LoadUint32(&o.PIN[idx].Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetPIN_PORT4(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIN[idx].Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetPIN_PORT5(idx int, value uint32) {
	volatile.StoreUint32(&o.PIN[idx].Reg, volatile.LoadUint32(&o.PIN[idx].Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetPIN_PORT5(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIN[idx].Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetPIN_PORT6(idx int, value uint32) {
	volatile.StoreUint32(&o.PIN[idx].Reg, volatile.LoadUint32(&o.PIN[idx].Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetPIN_PORT6(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIN[idx].Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetPIN_PORT7(idx int, value uint32) {
	volatile.StoreUint32(&o.PIN[idx].Reg, volatile.LoadUint32(&o.PIN[idx].Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetPIN_PORT7(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIN[idx].Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetPIN_PORT8(idx int, value uint32) {
	volatile.StoreUint32(&o.PIN[idx].Reg, volatile.LoadUint32(&o.PIN[idx].Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetPIN_PORT8(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIN[idx].Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetPIN_PORT9(idx int, value uint32) {
	volatile.StoreUint32(&o.PIN[idx].Reg, volatile.LoadUint32(&o.PIN[idx].Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetPIN_PORT9(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIN[idx].Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetPIN_PORT10(idx int, value uint32) {
	volatile.StoreUint32(&o.PIN[idx].Reg, volatile.LoadUint32(&o.PIN[idx].Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN_PORT10(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIN[idx].Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN_PORT11(idx int, value uint32) {
	volatile.StoreUint32(&o.PIN[idx].Reg, volatile.LoadUint32(&o.PIN[idx].Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetPIN_PORT11(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIN[idx].Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetPIN_PORT12(idx int, value uint32) {
	volatile.StoreUint32(&o.PIN[idx].Reg, volatile.LoadUint32(&o.PIN[idx].Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetPIN_PORT12(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIN[idx].Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetPIN_PORT13(idx int, value uint32) {
	volatile.StoreUint32(&o.PIN[idx].Reg, volatile.LoadUint32(&o.PIN[idx].Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetPIN_PORT13(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIN[idx].Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetPIN_PORT14(idx int, value uint32) {
	volatile.StoreUint32(&o.PIN[idx].Reg, volatile.LoadUint32(&o.PIN[idx].Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetPIN_PORT14(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIN[idx].Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetPIN_PORT15(idx int, value uint32) {
	volatile.StoreUint32(&o.PIN[idx].Reg, volatile.LoadUint32(&o.PIN[idx].Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetPIN_PORT15(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIN[idx].Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetPIN_PORT16(idx int, value uint32) {
	volatile.StoreUint32(&o.PIN[idx].Reg, volatile.LoadUint32(&o.PIN[idx].Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetPIN_PORT16(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIN[idx].Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetPIN_PORT17(idx int, value uint32) {
	volatile.StoreUint32(&o.PIN[idx].Reg, volatile.LoadUint32(&o.PIN[idx].Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetPIN_PORT17(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIN[idx].Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetPIN_PORT18(idx int, value uint32) {
	volatile.StoreUint32(&o.PIN[idx].Reg, volatile.LoadUint32(&o.PIN[idx].Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetPIN_PORT18(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIN[idx].Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetPIN_PORT19(idx int, value uint32) {
	volatile.StoreUint32(&o.PIN[idx].Reg, volatile.LoadUint32(&o.PIN[idx].Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetPIN_PORT19(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIN[idx].Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetPIN_PORT20(idx int, value uint32) {
	volatile.StoreUint32(&o.PIN[idx].Reg, volatile.LoadUint32(&o.PIN[idx].Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetPIN_PORT20(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIN[idx].Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetPIN_PORT21(idx int, value uint32) {
	volatile.StoreUint32(&o.PIN[idx].Reg, volatile.LoadUint32(&o.PIN[idx].Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetPIN_PORT21(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIN[idx].Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetPIN_PORT22(idx int, value uint32) {
	volatile.StoreUint32(&o.PIN[idx].Reg, volatile.LoadUint32(&o.PIN[idx].Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetPIN_PORT22(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIN[idx].Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetPIN_PORT23(idx int, value uint32) {
	volatile.StoreUint32(&o.PIN[idx].Reg, volatile.LoadUint32(&o.PIN[idx].Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetPIN_PORT23(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIN[idx].Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetPIN_PORT24(idx int, value uint32) {
	volatile.StoreUint32(&o.PIN[idx].Reg, volatile.LoadUint32(&o.PIN[idx].Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetPIN_PORT24(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIN[idx].Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetPIN_PORT25(idx int, value uint32) {
	volatile.StoreUint32(&o.PIN[idx].Reg, volatile.LoadUint32(&o.PIN[idx].Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetPIN_PORT25(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIN[idx].Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetPIN_PORT26(idx int, value uint32) {
	volatile.StoreUint32(&o.PIN[idx].Reg, volatile.LoadUint32(&o.PIN[idx].Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetPIN_PORT26(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIN[idx].Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetPIN_PORT27(idx int, value uint32) {
	volatile.StoreUint32(&o.PIN[idx].Reg, volatile.LoadUint32(&o.PIN[idx].Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetPIN_PORT27(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIN[idx].Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetPIN_PORT28(idx int, value uint32) {
	volatile.StoreUint32(&o.PIN[idx].Reg, volatile.LoadUint32(&o.PIN[idx].Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetPIN_PORT28(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIN[idx].Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetPIN_PORT29(idx int, value uint32) {
	volatile.StoreUint32(&o.PIN[idx].Reg, volatile.LoadUint32(&o.PIN[idx].Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetPIN_PORT29(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIN[idx].Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetPIN_PORT30(idx int, value uint32) {
	volatile.StoreUint32(&o.PIN[idx].Reg, volatile.LoadUint32(&o.PIN[idx].Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetPIN_PORT30(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIN[idx].Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetPIN_PORT31(idx int, value uint32) {
	volatile.StoreUint32(&o.PIN[idx].Reg, volatile.LoadUint32(&o.PIN[idx].Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetPIN_PORT31(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIN[idx].Reg) & 0x80000000) >> 31
}

// GPIO.MPIN: Masked port register
func (o *GPIO_Type) SetMPIN_MPORTP0(idx int, value uint32) {
	volatile.StoreUint32(&o.MPIN[idx].Reg, volatile.LoadUint32(&o.MPIN[idx].Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetMPIN_MPORTP0(idx int) uint32 {
	return volatile.LoadUint32(&o.MPIN[idx].Reg) & 0x1
}
func (o *GPIO_Type) SetMPIN_MPORTP1(idx int, value uint32) {
	volatile.StoreUint32(&o.MPIN[idx].Reg, volatile.LoadUint32(&o.MPIN[idx].Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetMPIN_MPORTP1(idx int) uint32 {
	return (volatile.LoadUint32(&o.MPIN[idx].Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetMPIN_MPORTP2(idx int, value uint32) {
	volatile.StoreUint32(&o.MPIN[idx].Reg, volatile.LoadUint32(&o.MPIN[idx].Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetMPIN_MPORTP2(idx int) uint32 {
	return (volatile.LoadUint32(&o.MPIN[idx].Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetMPIN_MPORTP3(idx int, value uint32) {
	volatile.StoreUint32(&o.MPIN[idx].Reg, volatile.LoadUint32(&o.MPIN[idx].Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetMPIN_MPORTP3(idx int) uint32 {
	return (volatile.LoadUint32(&o.MPIN[idx].Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetMPIN_MPORTP4(idx int, value uint32) {
	volatile.StoreUint32(&o.MPIN[idx].Reg, volatile.LoadUint32(&o.MPIN[idx].Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetMPIN_MPORTP4(idx int) uint32 {
	return (volatile.LoadUint32(&o.MPIN[idx].Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetMPIN_MPORTP5(idx int, value uint32) {
	volatile.StoreUint32(&o.MPIN[idx].Reg, volatile.LoadUint32(&o.MPIN[idx].Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetMPIN_MPORTP5(idx int) uint32 {
	return (volatile.LoadUint32(&o.MPIN[idx].Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetMPIN_MPORTP6(idx int, value uint32) {
	volatile.StoreUint32(&o.MPIN[idx].Reg, volatile.LoadUint32(&o.MPIN[idx].Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetMPIN_MPORTP6(idx int) uint32 {
	return (volatile.LoadUint32(&o.MPIN[idx].Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetMPIN_MPORTP7(idx int, value uint32) {
	volatile.StoreUint32(&o.MPIN[idx].Reg, volatile.LoadUint32(&o.MPIN[idx].Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetMPIN_MPORTP7(idx int) uint32 {
	return (volatile.LoadUint32(&o.MPIN[idx].Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetMPIN_MPORTP8(idx int, value uint32) {
	volatile.StoreUint32(&o.MPIN[idx].Reg, volatile.LoadUint32(&o.MPIN[idx].Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetMPIN_MPORTP8(idx int) uint32 {
	return (volatile.LoadUint32(&o.MPIN[idx].Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetMPIN_MPORTP9(idx int, value uint32) {
	volatile.StoreUint32(&o.MPIN[idx].Reg, volatile.LoadUint32(&o.MPIN[idx].Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetMPIN_MPORTP9(idx int) uint32 {
	return (volatile.LoadUint32(&o.MPIN[idx].Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetMPIN_MPORTP10(idx int, value uint32) {
	volatile.StoreUint32(&o.MPIN[idx].Reg, volatile.LoadUint32(&o.MPIN[idx].Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetMPIN_MPORTP10(idx int) uint32 {
	return (volatile.LoadUint32(&o.MPIN[idx].Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetMPIN_MPORTP11(idx int, value uint32) {
	volatile.StoreUint32(&o.MPIN[idx].Reg, volatile.LoadUint32(&o.MPIN[idx].Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetMPIN_MPORTP11(idx int) uint32 {
	return (volatile.LoadUint32(&o.MPIN[idx].Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetMPIN_MPORTP12(idx int, value uint32) {
	volatile.StoreUint32(&o.MPIN[idx].Reg, volatile.LoadUint32(&o.MPIN[idx].Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetMPIN_MPORTP12(idx int) uint32 {
	return (volatile.LoadUint32(&o.MPIN[idx].Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetMPIN_MPORTP13(idx int, value uint32) {
	volatile.StoreUint32(&o.MPIN[idx].Reg, volatile.LoadUint32(&o.MPIN[idx].Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetMPIN_MPORTP13(idx int) uint32 {
	return (volatile.LoadUint32(&o.MPIN[idx].Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetMPIN_MPORTP14(idx int, value uint32) {
	volatile.StoreUint32(&o.MPIN[idx].Reg, volatile.LoadUint32(&o.MPIN[idx].Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetMPIN_MPORTP14(idx int) uint32 {
	return (volatile.LoadUint32(&o.MPIN[idx].Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetMPIN_MPORTP15(idx int, value uint32) {
	volatile.StoreUint32(&o.MPIN[idx].Reg, volatile.LoadUint32(&o.MPIN[idx].Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetMPIN_MPORTP15(idx int) uint32 {
	return (volatile.LoadUint32(&o.MPIN[idx].Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetMPIN_MPORTP16(idx int, value uint32) {
	volatile.StoreUint32(&o.MPIN[idx].Reg, volatile.LoadUint32(&o.MPIN[idx].Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetMPIN_MPORTP16(idx int) uint32 {
	return (volatile.LoadUint32(&o.MPIN[idx].Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetMPIN_MPORTP17(idx int, value uint32) {
	volatile.StoreUint32(&o.MPIN[idx].Reg, volatile.LoadUint32(&o.MPIN[idx].Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetMPIN_MPORTP17(idx int) uint32 {
	return (volatile.LoadUint32(&o.MPIN[idx].Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetMPIN_MPORTP18(idx int, value uint32) {
	volatile.StoreUint32(&o.MPIN[idx].Reg, volatile.LoadUint32(&o.MPIN[idx].Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetMPIN_MPORTP18(idx int) uint32 {
	return (volatile.LoadUint32(&o.MPIN[idx].Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetMPIN_MPORTP19(idx int, value uint32) {
	volatile.StoreUint32(&o.MPIN[idx].Reg, volatile.LoadUint32(&o.MPIN[idx].Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetMPIN_MPORTP19(idx int) uint32 {
	return (volatile.LoadUint32(&o.MPIN[idx].Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetMPIN_MPORTP20(idx int, value uint32) {
	volatile.StoreUint32(&o.MPIN[idx].Reg, volatile.LoadUint32(&o.MPIN[idx].Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetMPIN_MPORTP20(idx int) uint32 {
	return (volatile.LoadUint32(&o.MPIN[idx].Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetMPIN_MPORTP21(idx int, value uint32) {
	volatile.StoreUint32(&o.MPIN[idx].Reg, volatile.LoadUint32(&o.MPIN[idx].Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetMPIN_MPORTP21(idx int) uint32 {
	return (volatile.LoadUint32(&o.MPIN[idx].Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetMPIN_MPORTP22(idx int, value uint32) {
	volatile.StoreUint32(&o.MPIN[idx].Reg, volatile.LoadUint32(&o.MPIN[idx].Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetMPIN_MPORTP22(idx int) uint32 {
	return (volatile.LoadUint32(&o.MPIN[idx].Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetMPIN_MPORTP23(idx int, value uint32) {
	volatile.StoreUint32(&o.MPIN[idx].Reg, volatile.LoadUint32(&o.MPIN[idx].Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetMPIN_MPORTP23(idx int) uint32 {
	return (volatile.LoadUint32(&o.MPIN[idx].Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetMPIN_MPORTP24(idx int, value uint32) {
	volatile.StoreUint32(&o.MPIN[idx].Reg, volatile.LoadUint32(&o.MPIN[idx].Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetMPIN_MPORTP24(idx int) uint32 {
	return (volatile.LoadUint32(&o.MPIN[idx].Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetMPIN_MPORTP25(idx int, value uint32) {
	volatile.StoreUint32(&o.MPIN[idx].Reg, volatile.LoadUint32(&o.MPIN[idx].Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetMPIN_MPORTP25(idx int) uint32 {
	return (volatile.LoadUint32(&o.MPIN[idx].Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetMPIN_MPORTP26(idx int, value uint32) {
	volatile.StoreUint32(&o.MPIN[idx].Reg, volatile.LoadUint32(&o.MPIN[idx].Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetMPIN_MPORTP26(idx int) uint32 {
	return (volatile.LoadUint32(&o.MPIN[idx].Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetMPIN_MPORTP27(idx int, value uint32) {
	volatile.StoreUint32(&o.MPIN[idx].Reg, volatile.LoadUint32(&o.MPIN[idx].Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetMPIN_MPORTP27(idx int) uint32 {
	return (volatile.LoadUint32(&o.MPIN[idx].Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetMPIN_MPORTP28(idx int, value uint32) {
	volatile.StoreUint32(&o.MPIN[idx].Reg, volatile.LoadUint32(&o.MPIN[idx].Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetMPIN_MPORTP28(idx int) uint32 {
	return (volatile.LoadUint32(&o.MPIN[idx].Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetMPIN_MPORTP29(idx int, value uint32) {
	volatile.StoreUint32(&o.MPIN[idx].Reg, volatile.LoadUint32(&o.MPIN[idx].Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetMPIN_MPORTP29(idx int) uint32 {
	return (volatile.LoadUint32(&o.MPIN[idx].Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetMPIN_MPORTP30(idx int, value uint32) {
	volatile.StoreUint32(&o.MPIN[idx].Reg, volatile.LoadUint32(&o.MPIN[idx].Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetMPIN_MPORTP30(idx int) uint32 {
	return (volatile.LoadUint32(&o.MPIN[idx].Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetMPIN_MPORTP31(idx int, value uint32) {
	volatile.StoreUint32(&o.MPIN[idx].Reg, volatile.LoadUint32(&o.MPIN[idx].Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetMPIN_MPORTP31(idx int) uint32 {
	return (volatile.LoadUint32(&o.MPIN[idx].Reg) & 0x80000000) >> 31
}

// GPIO.SET: Write: Set port register Read: port output bits
func (o *GPIO_Type) SetSET_SETP00(idx int, value uint32) {
	volatile.StoreUint32(&o.SET[idx].Reg, volatile.LoadUint32(&o.SET[idx].Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetSET_SETP00(idx int) uint32 {
	return volatile.LoadUint32(&o.SET[idx].Reg) & 0x1
}
func (o *GPIO_Type) SetSET_SETP01(idx int, value uint32) {
	volatile.StoreUint32(&o.SET[idx].Reg, volatile.LoadUint32(&o.SET[idx].Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetSET_SETP01(idx int) uint32 {
	return (volatile.LoadUint32(&o.SET[idx].Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetSET_SETP02(idx int, value uint32) {
	volatile.StoreUint32(&o.SET[idx].Reg, volatile.LoadUint32(&o.SET[idx].Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetSET_SETP02(idx int) uint32 {
	return (volatile.LoadUint32(&o.SET[idx].Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetSET_SETP03(idx int, value uint32) {
	volatile.StoreUint32(&o.SET[idx].Reg, volatile.LoadUint32(&o.SET[idx].Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetSET_SETP03(idx int) uint32 {
	return (volatile.LoadUint32(&o.SET[idx].Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetSET_SETP04(idx int, value uint32) {
	volatile.StoreUint32(&o.SET[idx].Reg, volatile.LoadUint32(&o.SET[idx].Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetSET_SETP04(idx int) uint32 {
	return (volatile.LoadUint32(&o.SET[idx].Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetSET_SETP05(idx int, value uint32) {
	volatile.StoreUint32(&o.SET[idx].Reg, volatile.LoadUint32(&o.SET[idx].Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetSET_SETP05(idx int) uint32 {
	return (volatile.LoadUint32(&o.SET[idx].Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetSET_SETP06(idx int, value uint32) {
	volatile.StoreUint32(&o.SET[idx].Reg, volatile.LoadUint32(&o.SET[idx].Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetSET_SETP06(idx int) uint32 {
	return (volatile.LoadUint32(&o.SET[idx].Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetSET_SETP07(idx int, value uint32) {
	volatile.StoreUint32(&o.SET[idx].Reg, volatile.LoadUint32(&o.SET[idx].Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetSET_SETP07(idx int) uint32 {
	return (volatile.LoadUint32(&o.SET[idx].Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetSET_SETP08(idx int, value uint32) {
	volatile.StoreUint32(&o.SET[idx].Reg, volatile.LoadUint32(&o.SET[idx].Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetSET_SETP08(idx int) uint32 {
	return (volatile.LoadUint32(&o.SET[idx].Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetSET_SETP09(idx int, value uint32) {
	volatile.StoreUint32(&o.SET[idx].Reg, volatile.LoadUint32(&o.SET[idx].Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetSET_SETP09(idx int) uint32 {
	return (volatile.LoadUint32(&o.SET[idx].Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetSET_SETP010(idx int, value uint32) {
	volatile.StoreUint32(&o.SET[idx].Reg, volatile.LoadUint32(&o.SET[idx].Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetSET_SETP010(idx int) uint32 {
	return (volatile.LoadUint32(&o.SET[idx].Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetSET_SETP011(idx int, value uint32) {
	volatile.StoreUint32(&o.SET[idx].Reg, volatile.LoadUint32(&o.SET[idx].Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetSET_SETP011(idx int) uint32 {
	return (volatile.LoadUint32(&o.SET[idx].Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetSET_SETP012(idx int, value uint32) {
	volatile.StoreUint32(&o.SET[idx].Reg, volatile.LoadUint32(&o.SET[idx].Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetSET_SETP012(idx int) uint32 {
	return (volatile.LoadUint32(&o.SET[idx].Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetSET_SETP013(idx int, value uint32) {
	volatile.StoreUint32(&o.SET[idx].Reg, volatile.LoadUint32(&o.SET[idx].Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetSET_SETP013(idx int) uint32 {
	return (volatile.LoadUint32(&o.SET[idx].Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetSET_SETP014(idx int, value uint32) {
	volatile.StoreUint32(&o.SET[idx].Reg, volatile.LoadUint32(&o.SET[idx].Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetSET_SETP014(idx int) uint32 {
	return (volatile.LoadUint32(&o.SET[idx].Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetSET_SETP015(idx int, value uint32) {
	volatile.StoreUint32(&o.SET[idx].Reg, volatile.LoadUint32(&o.SET[idx].Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetSET_SETP015(idx int) uint32 {
	return (volatile.LoadUint32(&o.SET[idx].Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetSET_SETP016(idx int, value uint32) {
	volatile.StoreUint32(&o.SET[idx].Reg, volatile.LoadUint32(&o.SET[idx].Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetSET_SETP016(idx int) uint32 {
	return (volatile.LoadUint32(&o.SET[idx].Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetSET_SETP017(idx int, value uint32) {
	volatile.StoreUint32(&o.SET[idx].Reg, volatile.LoadUint32(&o.SET[idx].Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetSET_SETP017(idx int) uint32 {
	return (volatile.LoadUint32(&o.SET[idx].Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetSET_SETP018(idx int, value uint32) {
	volatile.StoreUint32(&o.SET[idx].Reg, volatile.LoadUint32(&o.SET[idx].Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetSET_SETP018(idx int) uint32 {
	return (volatile.LoadUint32(&o.SET[idx].Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetSET_SETP019(idx int, value uint32) {
	volatile.StoreUint32(&o.SET[idx].Reg, volatile.LoadUint32(&o.SET[idx].Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetSET_SETP019(idx int) uint32 {
	return (volatile.LoadUint32(&o.SET[idx].Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetSET_SETP020(idx int, value uint32) {
	volatile.StoreUint32(&o.SET[idx].Reg, volatile.LoadUint32(&o.SET[idx].Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetSET_SETP020(idx int) uint32 {
	return (volatile.LoadUint32(&o.SET[idx].Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetSET_SETP021(idx int, value uint32) {
	volatile.StoreUint32(&o.SET[idx].Reg, volatile.LoadUint32(&o.SET[idx].Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetSET_SETP021(idx int) uint32 {
	return (volatile.LoadUint32(&o.SET[idx].Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetSET_SETP022(idx int, value uint32) {
	volatile.StoreUint32(&o.SET[idx].Reg, volatile.LoadUint32(&o.SET[idx].Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetSET_SETP022(idx int) uint32 {
	return (volatile.LoadUint32(&o.SET[idx].Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetSET_SETP023(idx int, value uint32) {
	volatile.StoreUint32(&o.SET[idx].Reg, volatile.LoadUint32(&o.SET[idx].Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetSET_SETP023(idx int) uint32 {
	return (volatile.LoadUint32(&o.SET[idx].Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetSET_SETP024(idx int, value uint32) {
	volatile.StoreUint32(&o.SET[idx].Reg, volatile.LoadUint32(&o.SET[idx].Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetSET_SETP024(idx int) uint32 {
	return (volatile.LoadUint32(&o.SET[idx].Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetSET_SETP025(idx int, value uint32) {
	volatile.StoreUint32(&o.SET[idx].Reg, volatile.LoadUint32(&o.SET[idx].Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetSET_SETP025(idx int) uint32 {
	return (volatile.LoadUint32(&o.SET[idx].Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetSET_SETP026(idx int, value uint32) {
	volatile.StoreUint32(&o.SET[idx].Reg, volatile.LoadUint32(&o.SET[idx].Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetSET_SETP026(idx int) uint32 {
	return (volatile.LoadUint32(&o.SET[idx].Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetSET_SETP027(idx int, value uint32) {
	volatile.StoreUint32(&o.SET[idx].Reg, volatile.LoadUint32(&o.SET[idx].Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetSET_SETP027(idx int) uint32 {
	return (volatile.LoadUint32(&o.SET[idx].Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetSET_SETP028(idx int, value uint32) {
	volatile.StoreUint32(&o.SET[idx].Reg, volatile.LoadUint32(&o.SET[idx].Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetSET_SETP028(idx int) uint32 {
	return (volatile.LoadUint32(&o.SET[idx].Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetSET_SETP029(idx int, value uint32) {
	volatile.StoreUint32(&o.SET[idx].Reg, volatile.LoadUint32(&o.SET[idx].Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetSET_SETP029(idx int) uint32 {
	return (volatile.LoadUint32(&o.SET[idx].Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetSET_SETP030(idx int, value uint32) {
	volatile.StoreUint32(&o.SET[idx].Reg, volatile.LoadUint32(&o.SET[idx].Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetSET_SETP030(idx int) uint32 {
	return (volatile.LoadUint32(&o.SET[idx].Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetSET_SETP031(idx int, value uint32) {
	volatile.StoreUint32(&o.SET[idx].Reg, volatile.LoadUint32(&o.SET[idx].Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetSET_SETP031(idx int) uint32 {
	return (volatile.LoadUint32(&o.SET[idx].Reg) & 0x80000000) >> 31
}

// GPIO.CLR: Clear port
func (o *GPIO_Type) SetCLR_CLRP00(idx int, value uint32) {
	volatile.StoreUint32(&o.CLR[idx].Reg, volatile.LoadUint32(&o.CLR[idx].Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetCLR_CLRP00(idx int) uint32 {
	return volatile.LoadUint32(&o.CLR[idx].Reg) & 0x1
}
func (o *GPIO_Type) SetCLR_CLRP01(idx int, value uint32) {
	volatile.StoreUint32(&o.CLR[idx].Reg, volatile.LoadUint32(&o.CLR[idx].Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetCLR_CLRP01(idx int) uint32 {
	return (volatile.LoadUint32(&o.CLR[idx].Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetCLR_CLRP02(idx int, value uint32) {
	volatile.StoreUint32(&o.CLR[idx].Reg, volatile.LoadUint32(&o.CLR[idx].Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetCLR_CLRP02(idx int) uint32 {
	return (volatile.LoadUint32(&o.CLR[idx].Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetCLR_CLRP03(idx int, value uint32) {
	volatile.StoreUint32(&o.CLR[idx].Reg, volatile.LoadUint32(&o.CLR[idx].Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetCLR_CLRP03(idx int) uint32 {
	return (volatile.LoadUint32(&o.CLR[idx].Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetCLR_CLRP04(idx int, value uint32) {
	volatile.StoreUint32(&o.CLR[idx].Reg, volatile.LoadUint32(&o.CLR[idx].Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetCLR_CLRP04(idx int) uint32 {
	return (volatile.LoadUint32(&o.CLR[idx].Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetCLR_CLRP05(idx int, value uint32) {
	volatile.StoreUint32(&o.CLR[idx].Reg, volatile.LoadUint32(&o.CLR[idx].Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetCLR_CLRP05(idx int) uint32 {
	return (volatile.LoadUint32(&o.CLR[idx].Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetCLR_CLRP06(idx int, value uint32) {
	volatile.StoreUint32(&o.CLR[idx].Reg, volatile.LoadUint32(&o.CLR[idx].Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetCLR_CLRP06(idx int) uint32 {
	return (volatile.LoadUint32(&o.CLR[idx].Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetCLR_CLRP07(idx int, value uint32) {
	volatile.StoreUint32(&o.CLR[idx].Reg, volatile.LoadUint32(&o.CLR[idx].Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetCLR_CLRP07(idx int) uint32 {
	return (volatile.LoadUint32(&o.CLR[idx].Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetCLR_CLRP08(idx int, value uint32) {
	volatile.StoreUint32(&o.CLR[idx].Reg, volatile.LoadUint32(&o.CLR[idx].Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetCLR_CLRP08(idx int) uint32 {
	return (volatile.LoadUint32(&o.CLR[idx].Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetCLR_CLRP09(idx int, value uint32) {
	volatile.StoreUint32(&o.CLR[idx].Reg, volatile.LoadUint32(&o.CLR[idx].Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetCLR_CLRP09(idx int) uint32 {
	return (volatile.LoadUint32(&o.CLR[idx].Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetCLR_CLRP010(idx int, value uint32) {
	volatile.StoreUint32(&o.CLR[idx].Reg, volatile.LoadUint32(&o.CLR[idx].Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetCLR_CLRP010(idx int) uint32 {
	return (volatile.LoadUint32(&o.CLR[idx].Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetCLR_CLRP011(idx int, value uint32) {
	volatile.StoreUint32(&o.CLR[idx].Reg, volatile.LoadUint32(&o.CLR[idx].Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetCLR_CLRP011(idx int) uint32 {
	return (volatile.LoadUint32(&o.CLR[idx].Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetCLR_CLRP012(idx int, value uint32) {
	volatile.StoreUint32(&o.CLR[idx].Reg, volatile.LoadUint32(&o.CLR[idx].Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetCLR_CLRP012(idx int) uint32 {
	return (volatile.LoadUint32(&o.CLR[idx].Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetCLR_CLRP013(idx int, value uint32) {
	volatile.StoreUint32(&o.CLR[idx].Reg, volatile.LoadUint32(&o.CLR[idx].Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetCLR_CLRP013(idx int) uint32 {
	return (volatile.LoadUint32(&o.CLR[idx].Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetCLR_CLRP014(idx int, value uint32) {
	volatile.StoreUint32(&o.CLR[idx].Reg, volatile.LoadUint32(&o.CLR[idx].Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetCLR_CLRP014(idx int) uint32 {
	return (volatile.LoadUint32(&o.CLR[idx].Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetCLR_CLRP015(idx int, value uint32) {
	volatile.StoreUint32(&o.CLR[idx].Reg, volatile.LoadUint32(&o.CLR[idx].Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetCLR_CLRP015(idx int) uint32 {
	return (volatile.LoadUint32(&o.CLR[idx].Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetCLR_CLRP016(idx int, value uint32) {
	volatile.StoreUint32(&o.CLR[idx].Reg, volatile.LoadUint32(&o.CLR[idx].Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetCLR_CLRP016(idx int) uint32 {
	return (volatile.LoadUint32(&o.CLR[idx].Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetCLR_CLRP017(idx int, value uint32) {
	volatile.StoreUint32(&o.CLR[idx].Reg, volatile.LoadUint32(&o.CLR[idx].Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetCLR_CLRP017(idx int) uint32 {
	return (volatile.LoadUint32(&o.CLR[idx].Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetCLR_CLRP018(idx int, value uint32) {
	volatile.StoreUint32(&o.CLR[idx].Reg, volatile.LoadUint32(&o.CLR[idx].Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetCLR_CLRP018(idx int) uint32 {
	return (volatile.LoadUint32(&o.CLR[idx].Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetCLR_CLRP019(idx int, value uint32) {
	volatile.StoreUint32(&o.CLR[idx].Reg, volatile.LoadUint32(&o.CLR[idx].Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetCLR_CLRP019(idx int) uint32 {
	return (volatile.LoadUint32(&o.CLR[idx].Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetCLR_CLRP020(idx int, value uint32) {
	volatile.StoreUint32(&o.CLR[idx].Reg, volatile.LoadUint32(&o.CLR[idx].Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetCLR_CLRP020(idx int) uint32 {
	return (volatile.LoadUint32(&o.CLR[idx].Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetCLR_CLRP021(idx int, value uint32) {
	volatile.StoreUint32(&o.CLR[idx].Reg, volatile.LoadUint32(&o.CLR[idx].Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetCLR_CLRP021(idx int) uint32 {
	return (volatile.LoadUint32(&o.CLR[idx].Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetCLR_CLRP022(idx int, value uint32) {
	volatile.StoreUint32(&o.CLR[idx].Reg, volatile.LoadUint32(&o.CLR[idx].Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetCLR_CLRP022(idx int) uint32 {
	return (volatile.LoadUint32(&o.CLR[idx].Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetCLR_CLRP023(idx int, value uint32) {
	volatile.StoreUint32(&o.CLR[idx].Reg, volatile.LoadUint32(&o.CLR[idx].Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetCLR_CLRP023(idx int) uint32 {
	return (volatile.LoadUint32(&o.CLR[idx].Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetCLR_CLRP024(idx int, value uint32) {
	volatile.StoreUint32(&o.CLR[idx].Reg, volatile.LoadUint32(&o.CLR[idx].Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetCLR_CLRP024(idx int) uint32 {
	return (volatile.LoadUint32(&o.CLR[idx].Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetCLR_CLRP025(idx int, value uint32) {
	volatile.StoreUint32(&o.CLR[idx].Reg, volatile.LoadUint32(&o.CLR[idx].Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetCLR_CLRP025(idx int) uint32 {
	return (volatile.LoadUint32(&o.CLR[idx].Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetCLR_CLRP026(idx int, value uint32) {
	volatile.StoreUint32(&o.CLR[idx].Reg, volatile.LoadUint32(&o.CLR[idx].Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetCLR_CLRP026(idx int) uint32 {
	return (volatile.LoadUint32(&o.CLR[idx].Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetCLR_CLRP027(idx int, value uint32) {
	volatile.StoreUint32(&o.CLR[idx].Reg, volatile.LoadUint32(&o.CLR[idx].Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetCLR_CLRP027(idx int) uint32 {
	return (volatile.LoadUint32(&o.CLR[idx].Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetCLR_CLRP028(idx int, value uint32) {
	volatile.StoreUint32(&o.CLR[idx].Reg, volatile.LoadUint32(&o.CLR[idx].Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetCLR_CLRP028(idx int) uint32 {
	return (volatile.LoadUint32(&o.CLR[idx].Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetCLR_CLRP029(idx int, value uint32) {
	volatile.StoreUint32(&o.CLR[idx].Reg, volatile.LoadUint32(&o.CLR[idx].Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetCLR_CLRP029(idx int) uint32 {
	return (volatile.LoadUint32(&o.CLR[idx].Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetCLR_CLRP030(idx int, value uint32) {
	volatile.StoreUint32(&o.CLR[idx].Reg, volatile.LoadUint32(&o.CLR[idx].Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetCLR_CLRP030(idx int) uint32 {
	return (volatile.LoadUint32(&o.CLR[idx].Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetCLR_CLRP031(idx int, value uint32) {
	volatile.StoreUint32(&o.CLR[idx].Reg, volatile.LoadUint32(&o.CLR[idx].Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetCLR_CLRP031(idx int) uint32 {
	return (volatile.LoadUint32(&o.CLR[idx].Reg) & 0x80000000) >> 31
}

// GPIO.NOT: Toggle port
func (o *GPIO_Type) SetNOT_NOTP00(idx int, value uint32) {
	volatile.StoreUint32(&o.NOT[idx].Reg, volatile.LoadUint32(&o.NOT[idx].Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetNOT_NOTP00(idx int) uint32 {
	return volatile.LoadUint32(&o.NOT[idx].Reg) & 0x1
}
func (o *GPIO_Type) SetNOT_NOTP01(idx int, value uint32) {
	volatile.StoreUint32(&o.NOT[idx].Reg, volatile.LoadUint32(&o.NOT[idx].Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetNOT_NOTP01(idx int) uint32 {
	return (volatile.LoadUint32(&o.NOT[idx].Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetNOT_NOTP02(idx int, value uint32) {
	volatile.StoreUint32(&o.NOT[idx].Reg, volatile.LoadUint32(&o.NOT[idx].Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetNOT_NOTP02(idx int) uint32 {
	return (volatile.LoadUint32(&o.NOT[idx].Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetNOT_NOTP03(idx int, value uint32) {
	volatile.StoreUint32(&o.NOT[idx].Reg, volatile.LoadUint32(&o.NOT[idx].Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetNOT_NOTP03(idx int) uint32 {
	return (volatile.LoadUint32(&o.NOT[idx].Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetNOT_NOTP04(idx int, value uint32) {
	volatile.StoreUint32(&o.NOT[idx].Reg, volatile.LoadUint32(&o.NOT[idx].Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetNOT_NOTP04(idx int) uint32 {
	return (volatile.LoadUint32(&o.NOT[idx].Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetNOT_NOTP05(idx int, value uint32) {
	volatile.StoreUint32(&o.NOT[idx].Reg, volatile.LoadUint32(&o.NOT[idx].Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetNOT_NOTP05(idx int) uint32 {
	return (volatile.LoadUint32(&o.NOT[idx].Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetNOT_NOTP06(idx int, value uint32) {
	volatile.StoreUint32(&o.NOT[idx].Reg, volatile.LoadUint32(&o.NOT[idx].Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetNOT_NOTP06(idx int) uint32 {
	return (volatile.LoadUint32(&o.NOT[idx].Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetNOT_NOTP07(idx int, value uint32) {
	volatile.StoreUint32(&o.NOT[idx].Reg, volatile.LoadUint32(&o.NOT[idx].Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetNOT_NOTP07(idx int) uint32 {
	return (volatile.LoadUint32(&o.NOT[idx].Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetNOT_NOTP08(idx int, value uint32) {
	volatile.StoreUint32(&o.NOT[idx].Reg, volatile.LoadUint32(&o.NOT[idx].Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetNOT_NOTP08(idx int) uint32 {
	return (volatile.LoadUint32(&o.NOT[idx].Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetNOT_NOTP09(idx int, value uint32) {
	volatile.StoreUint32(&o.NOT[idx].Reg, volatile.LoadUint32(&o.NOT[idx].Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetNOT_NOTP09(idx int) uint32 {
	return (volatile.LoadUint32(&o.NOT[idx].Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetNOT_NOTP010(idx int, value uint32) {
	volatile.StoreUint32(&o.NOT[idx].Reg, volatile.LoadUint32(&o.NOT[idx].Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetNOT_NOTP010(idx int) uint32 {
	return (volatile.LoadUint32(&o.NOT[idx].Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetNOT_NOTP011(idx int, value uint32) {
	volatile.StoreUint32(&o.NOT[idx].Reg, volatile.LoadUint32(&o.NOT[idx].Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetNOT_NOTP011(idx int) uint32 {
	return (volatile.LoadUint32(&o.NOT[idx].Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetNOT_NOTP012(idx int, value uint32) {
	volatile.StoreUint32(&o.NOT[idx].Reg, volatile.LoadUint32(&o.NOT[idx].Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetNOT_NOTP012(idx int) uint32 {
	return (volatile.LoadUint32(&o.NOT[idx].Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetNOT_NOTP013(idx int, value uint32) {
	volatile.StoreUint32(&o.NOT[idx].Reg, volatile.LoadUint32(&o.NOT[idx].Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetNOT_NOTP013(idx int) uint32 {
	return (volatile.LoadUint32(&o.NOT[idx].Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetNOT_NOTP014(idx int, value uint32) {
	volatile.StoreUint32(&o.NOT[idx].Reg, volatile.LoadUint32(&o.NOT[idx].Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetNOT_NOTP014(idx int) uint32 {
	return (volatile.LoadUint32(&o.NOT[idx].Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetNOT_NOTP015(idx int, value uint32) {
	volatile.StoreUint32(&o.NOT[idx].Reg, volatile.LoadUint32(&o.NOT[idx].Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetNOT_NOTP015(idx int) uint32 {
	return (volatile.LoadUint32(&o.NOT[idx].Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetNOT_NOTP016(idx int, value uint32) {
	volatile.StoreUint32(&o.NOT[idx].Reg, volatile.LoadUint32(&o.NOT[idx].Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetNOT_NOTP016(idx int) uint32 {
	return (volatile.LoadUint32(&o.NOT[idx].Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetNOT_NOTP017(idx int, value uint32) {
	volatile.StoreUint32(&o.NOT[idx].Reg, volatile.LoadUint32(&o.NOT[idx].Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetNOT_NOTP017(idx int) uint32 {
	return (volatile.LoadUint32(&o.NOT[idx].Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetNOT_NOTP018(idx int, value uint32) {
	volatile.StoreUint32(&o.NOT[idx].Reg, volatile.LoadUint32(&o.NOT[idx].Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetNOT_NOTP018(idx int) uint32 {
	return (volatile.LoadUint32(&o.NOT[idx].Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetNOT_NOTP019(idx int, value uint32) {
	volatile.StoreUint32(&o.NOT[idx].Reg, volatile.LoadUint32(&o.NOT[idx].Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetNOT_NOTP019(idx int) uint32 {
	return (volatile.LoadUint32(&o.NOT[idx].Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetNOT_NOTP020(idx int, value uint32) {
	volatile.StoreUint32(&o.NOT[idx].Reg, volatile.LoadUint32(&o.NOT[idx].Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetNOT_NOTP020(idx int) uint32 {
	return (volatile.LoadUint32(&o.NOT[idx].Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetNOT_NOTP021(idx int, value uint32) {
	volatile.StoreUint32(&o.NOT[idx].Reg, volatile.LoadUint32(&o.NOT[idx].Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetNOT_NOTP021(idx int) uint32 {
	return (volatile.LoadUint32(&o.NOT[idx].Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetNOT_NOTP022(idx int, value uint32) {
	volatile.StoreUint32(&o.NOT[idx].Reg, volatile.LoadUint32(&o.NOT[idx].Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetNOT_NOTP022(idx int) uint32 {
	return (volatile.LoadUint32(&o.NOT[idx].Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetNOT_NOTP023(idx int, value uint32) {
	volatile.StoreUint32(&o.NOT[idx].Reg, volatile.LoadUint32(&o.NOT[idx].Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetNOT_NOTP023(idx int) uint32 {
	return (volatile.LoadUint32(&o.NOT[idx].Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetNOT_NOTP024(idx int, value uint32) {
	volatile.StoreUint32(&o.NOT[idx].Reg, volatile.LoadUint32(&o.NOT[idx].Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetNOT_NOTP024(idx int) uint32 {
	return (volatile.LoadUint32(&o.NOT[idx].Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetNOT_NOTP025(idx int, value uint32) {
	volatile.StoreUint32(&o.NOT[idx].Reg, volatile.LoadUint32(&o.NOT[idx].Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetNOT_NOTP025(idx int) uint32 {
	return (volatile.LoadUint32(&o.NOT[idx].Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetNOT_NOTP026(idx int, value uint32) {
	volatile.StoreUint32(&o.NOT[idx].Reg, volatile.LoadUint32(&o.NOT[idx].Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetNOT_NOTP026(idx int) uint32 {
	return (volatile.LoadUint32(&o.NOT[idx].Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetNOT_NOTP027(idx int, value uint32) {
	volatile.StoreUint32(&o.NOT[idx].Reg, volatile.LoadUint32(&o.NOT[idx].Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetNOT_NOTP027(idx int) uint32 {
	return (volatile.LoadUint32(&o.NOT[idx].Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetNOT_NOTP028(idx int, value uint32) {
	volatile.StoreUint32(&o.NOT[idx].Reg, volatile.LoadUint32(&o.NOT[idx].Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetNOT_NOTP028(idx int) uint32 {
	return (volatile.LoadUint32(&o.NOT[idx].Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetNOT_NOTP029(idx int, value uint32) {
	volatile.StoreUint32(&o.NOT[idx].Reg, volatile.LoadUint32(&o.NOT[idx].Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetNOT_NOTP029(idx int) uint32 {
	return (volatile.LoadUint32(&o.NOT[idx].Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetNOT_NOTP030(idx int, value uint32) {
	volatile.StoreUint32(&o.NOT[idx].Reg, volatile.LoadUint32(&o.NOT[idx].Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetNOT_NOTP030(idx int) uint32 {
	return (volatile.LoadUint32(&o.NOT[idx].Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetNOT_NOTP031(idx int, value uint32) {
	volatile.StoreUint32(&o.NOT[idx].Reg, volatile.LoadUint32(&o.NOT[idx].Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetNOT_NOTP031(idx int) uint32 {
	return (volatile.LoadUint32(&o.NOT[idx].Reg) & 0x80000000) >> 31
}

// DMA controller
type DMA_Type struct {
	CTRL       volatile.Register32 // 0x0
	INTSTAT    volatile.Register32 // 0x4
	SRAMBASE   volatile.Register32 // 0x8
	_          [20]byte
	ENABLESET0 volatile.Register32 // 0x20
	_          [4]byte
	ENABLECLR0 volatile.Register32 // 0x28
	_          [4]byte
	ACTIVE0    volatile.Register32 // 0x30
	_          [4]byte
	BUSY0      volatile.Register32 // 0x38
	_          [4]byte
	ERRINT0    volatile.Register32 // 0x40
	_          [4]byte
	INTENSET0  volatile.Register32 // 0x48
	_          [4]byte
	INTENCLR0  volatile.Register32 // 0x50
	_          [4]byte
	INTA0      volatile.Register32 // 0x58
	_          [4]byte
	INTB0      volatile.Register32 // 0x60
	_          [4]byte
	SETVALID0  volatile.Register32 // 0x68
	_          [4]byte
	SETTRIG0   volatile.Register32 // 0x70
	_          [4]byte
	ABORT0     volatile.Register32 // 0x78
	_          [900]byte
	CFG0       volatile.Register32 // 0x400
	CTLSTAT0   volatile.Register32 // 0x404
	XFERCFG0   volatile.Register32 // 0x408
	_          [4]byte
	CFG1       volatile.Register32 // 0x410
	CTLSTAT1   volatile.Register32 // 0x414
	XFERCFG1   volatile.Register32 // 0x418
	_          [4]byte
	CFG2       volatile.Register32 // 0x420
	CTLSTAT2   volatile.Register32 // 0x424
	XFERCFG2   volatile.Register32 // 0x428
	_          [4]byte
	CFG3       volatile.Register32 // 0x430
	CTLSTAT3   volatile.Register32 // 0x434
	XFERCFG3   volatile.Register32 // 0x438
	_          [4]byte
	CFG4       volatile.Register32 // 0x440
	CTLSTAT4   volatile.Register32 // 0x444
	XFERCFG4   volatile.Register32 // 0x448
	_          [4]byte
	CFG5       volatile.Register32 // 0x450
	CTLSTAT5   volatile.Register32 // 0x454
	XFERCFG5   volatile.Register32 // 0x458
	_          [4]byte
	CFG6       volatile.Register32 // 0x460
	CTLSTAT6   volatile.Register32 // 0x464
	XFERCFG6   volatile.Register32 // 0x468
	_          [4]byte
	CFG7       volatile.Register32 // 0x470
	CTLSTAT7   volatile.Register32 // 0x474
	XFERCFG7   volatile.Register32 // 0x478
	_          [4]byte
	CFG8       volatile.Register32 // 0x480
	CTLSTAT8   volatile.Register32 // 0x484
	XFERCFG8   volatile.Register32 // 0x488
	_          [4]byte
	CFG9       volatile.Register32 // 0x490
	CTLSTAT9   volatile.Register32 // 0x494
	XFERCFG9   volatile.Register32 // 0x498
	_          [4]byte
	CFG10      volatile.Register32 // 0x4A0
	CTLSTAT10  volatile.Register32 // 0x4A4
	XFERCFG10  volatile.Register32 // 0x4A8
	_          [4]byte
	CFG11      volatile.Register32 // 0x4B0
	CTLSTAT11  volatile.Register32 // 0x4B4
	XFERCFG11  volatile.Register32 // 0x4B8
	_          [4]byte
	CFG12      volatile.Register32 // 0x4C0
	CTLSTAT12  volatile.Register32 // 0x4C4
	XFERCFG12  volatile.Register32 // 0x4C8
	_          [4]byte
	CFG13      volatile.Register32 // 0x4D0
	CTLSTAT13  volatile.Register32 // 0x4D4
	XFERCFG13  volatile.Register32 // 0x4D8
	_          [4]byte
	CFG14      volatile.Register32 // 0x4E0
	CTLSTAT14  volatile.Register32 // 0x4E4
	XFERCFG14  volatile.Register32 // 0x4E8
	_          [4]byte
	CFG15      volatile.Register32 // 0x4F0
	CTLSTAT15  volatile.Register32 // 0x4F4
	XFERCFG15  volatile.Register32 // 0x4F8
	_          [4]byte
	CFG16      volatile.Register32 // 0x500
	CTLSTAT16  volatile.Register32 // 0x504
	XFERCFG16  volatile.Register32 // 0x508
	_          [4]byte
	CFG17      volatile.Register32 // 0x510
	CTLSTAT17  volatile.Register32 // 0x514
	XFERCFG17  volatile.Register32 // 0x518
}

// DMA.CTRL: DMA control.
func (o *DMA_Type) SetCTRL_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCTRL_ENABLE() uint32 {
	return volatile.LoadUint32(&o.CTRL.Reg) & 0x1
}
func (o *DMA_Type) SetCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0xfffffffe)|value<<1)
}
func (o *DMA_Type) GetCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0xfffffffe) >> 1
}

// DMA.INTSTAT: Interrupt status.
func (o *DMA_Type) SetINTSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetINTSTAT_RESERVED() uint32 {
	return volatile.LoadUint32(&o.INTSTAT.Reg) & 0x1
}
func (o *DMA_Type) SetINTSTAT_ACTIVEINT(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetINTSTAT_ACTIVEINT() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetINTSTAT_ACTIVEERRINT(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetINTSTAT_ACTIVEERRINT() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetINTSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0xfffffff8)|value<<3)
}
func (o *DMA_Type) GetINTSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0xfffffff8) >> 3
}

// DMA.SRAMBASE: SRAM address of the channel configuration table.
func (o *DMA_Type) SetSRAMBASE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SRAMBASE.Reg, volatile.LoadUint32(&o.SRAMBASE.Reg)&^(0x3ff)|value)
}
func (o *DMA_Type) GetSRAMBASE_RESERVED() uint32 {
	return volatile.LoadUint32(&o.SRAMBASE.Reg) & 0x3ff
}
func (o *DMA_Type) SetSRAMBASE_OFFSET(value uint32) {
	volatile.StoreUint32(&o.SRAMBASE.Reg, volatile.LoadUint32(&o.SRAMBASE.Reg)&^(0xfffffc00)|value<<10)
}
func (o *DMA_Type) GetSRAMBASE_OFFSET() uint32 {
	return (volatile.LoadUint32(&o.SRAMBASE.Reg) & 0xfffffc00) >> 10
}

// DMA.ENABLESET0: Channel Enable read and Set for all DMA channels.
func (o *DMA_Type) SetENABLESET0_ENA0(value uint32) {
	volatile.StoreUint32(&o.ENABLESET0.Reg, volatile.LoadUint32(&o.ENABLESET0.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetENABLESET0_ENA0() uint32 {
	return volatile.LoadUint32(&o.ENABLESET0.Reg) & 0x1
}
func (o *DMA_Type) SetENABLESET0_ENA1(value uint32) {
	volatile.StoreUint32(&o.ENABLESET0.Reg, volatile.LoadUint32(&o.ENABLESET0.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetENABLESET0_ENA1() uint32 {
	return (volatile.LoadUint32(&o.ENABLESET0.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetENABLESET0_ENA2(value uint32) {
	volatile.StoreUint32(&o.ENABLESET0.Reg, volatile.LoadUint32(&o.ENABLESET0.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetENABLESET0_ENA2() uint32 {
	return (volatile.LoadUint32(&o.ENABLESET0.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetENABLESET0_ENA3(value uint32) {
	volatile.StoreUint32(&o.ENABLESET0.Reg, volatile.LoadUint32(&o.ENABLESET0.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetENABLESET0_ENA3() uint32 {
	return (volatile.LoadUint32(&o.ENABLESET0.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetENABLESET0_ENA4(value uint32) {
	volatile.StoreUint32(&o.ENABLESET0.Reg, volatile.LoadUint32(&o.ENABLESET0.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetENABLESET0_ENA4() uint32 {
	return (volatile.LoadUint32(&o.ENABLESET0.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetENABLESET0_ENA5(value uint32) {
	volatile.StoreUint32(&o.ENABLESET0.Reg, volatile.LoadUint32(&o.ENABLESET0.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetENABLESET0_ENA5() uint32 {
	return (volatile.LoadUint32(&o.ENABLESET0.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetENABLESET0_ENA6(value uint32) {
	volatile.StoreUint32(&o.ENABLESET0.Reg, volatile.LoadUint32(&o.ENABLESET0.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetENABLESET0_ENA6() uint32 {
	return (volatile.LoadUint32(&o.ENABLESET0.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetENABLESET0_ENA7(value uint32) {
	volatile.StoreUint32(&o.ENABLESET0.Reg, volatile.LoadUint32(&o.ENABLESET0.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetENABLESET0_ENA7() uint32 {
	return (volatile.LoadUint32(&o.ENABLESET0.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetENABLESET0_ENA8(value uint32) {
	volatile.StoreUint32(&o.ENABLESET0.Reg, volatile.LoadUint32(&o.ENABLESET0.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetENABLESET0_ENA8() uint32 {
	return (volatile.LoadUint32(&o.ENABLESET0.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetENABLESET0_ENA9(value uint32) {
	volatile.StoreUint32(&o.ENABLESET0.Reg, volatile.LoadUint32(&o.ENABLESET0.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetENABLESET0_ENA9() uint32 {
	return (volatile.LoadUint32(&o.ENABLESET0.Reg) & 0x200) >> 9
}
func (o *DMA_Type) SetENABLESET0_ENA10(value uint32) {
	volatile.StoreUint32(&o.ENABLESET0.Reg, volatile.LoadUint32(&o.ENABLESET0.Reg)&^(0x400)|value<<10)
}
func (o *DMA_Type) GetENABLESET0_ENA10() uint32 {
	return (volatile.LoadUint32(&o.ENABLESET0.Reg) & 0x400) >> 10
}
func (o *DMA_Type) SetENABLESET0_ENA11(value uint32) {
	volatile.StoreUint32(&o.ENABLESET0.Reg, volatile.LoadUint32(&o.ENABLESET0.Reg)&^(0x800)|value<<11)
}
func (o *DMA_Type) GetENABLESET0_ENA11() uint32 {
	return (volatile.LoadUint32(&o.ENABLESET0.Reg) & 0x800) >> 11
}
func (o *DMA_Type) SetENABLESET0_ENA12(value uint32) {
	volatile.StoreUint32(&o.ENABLESET0.Reg, volatile.LoadUint32(&o.ENABLESET0.Reg)&^(0x1000)|value<<12)
}
func (o *DMA_Type) GetENABLESET0_ENA12() uint32 {
	return (volatile.LoadUint32(&o.ENABLESET0.Reg) & 0x1000) >> 12
}
func (o *DMA_Type) SetENABLESET0_ENA13(value uint32) {
	volatile.StoreUint32(&o.ENABLESET0.Reg, volatile.LoadUint32(&o.ENABLESET0.Reg)&^(0x2000)|value<<13)
}
func (o *DMA_Type) GetENABLESET0_ENA13() uint32 {
	return (volatile.LoadUint32(&o.ENABLESET0.Reg) & 0x2000) >> 13
}
func (o *DMA_Type) SetENABLESET0_ENA14(value uint32) {
	volatile.StoreUint32(&o.ENABLESET0.Reg, volatile.LoadUint32(&o.ENABLESET0.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetENABLESET0_ENA14() uint32 {
	return (volatile.LoadUint32(&o.ENABLESET0.Reg) & 0x4000) >> 14
}
func (o *DMA_Type) SetENABLESET0_ENA15(value uint32) {
	volatile.StoreUint32(&o.ENABLESET0.Reg, volatile.LoadUint32(&o.ENABLESET0.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetENABLESET0_ENA15() uint32 {
	return (volatile.LoadUint32(&o.ENABLESET0.Reg) & 0x8000) >> 15
}
func (o *DMA_Type) SetENABLESET0_ENA16(value uint32) {
	volatile.StoreUint32(&o.ENABLESET0.Reg, volatile.LoadUint32(&o.ENABLESET0.Reg)&^(0x10000)|value<<16)
}
func (o *DMA_Type) GetENABLESET0_ENA16() uint32 {
	return (volatile.LoadUint32(&o.ENABLESET0.Reg) & 0x10000) >> 16
}
func (o *DMA_Type) SetENABLESET0_ENA17(value uint32) {
	volatile.StoreUint32(&o.ENABLESET0.Reg, volatile.LoadUint32(&o.ENABLESET0.Reg)&^(0x20000)|value<<17)
}
func (o *DMA_Type) GetENABLESET0_ENA17() uint32 {
	return (volatile.LoadUint32(&o.ENABLESET0.Reg) & 0x20000) >> 17
}
func (o *DMA_Type) SetENABLESET0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENABLESET0.Reg, volatile.LoadUint32(&o.ENABLESET0.Reg)&^(0xfffc0000)|value<<18)
}
func (o *DMA_Type) GetENABLESET0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ENABLESET0.Reg) & 0xfffc0000) >> 18
}

// DMA.ENABLECLR0: Channel Enable Clear for all DMA channels.
func (o *DMA_Type) SetENABLECLR0_CLR0(value uint32) {
	volatile.StoreUint32(&o.ENABLECLR0.Reg, volatile.LoadUint32(&o.ENABLECLR0.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetENABLECLR0_CLR0() uint32 {
	return volatile.LoadUint32(&o.ENABLECLR0.Reg) & 0x1
}
func (o *DMA_Type) SetENABLECLR0_CLR1(value uint32) {
	volatile.StoreUint32(&o.ENABLECLR0.Reg, volatile.LoadUint32(&o.ENABLECLR0.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetENABLECLR0_CLR1() uint32 {
	return (volatile.LoadUint32(&o.ENABLECLR0.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetENABLECLR0_CLR2(value uint32) {
	volatile.StoreUint32(&o.ENABLECLR0.Reg, volatile.LoadUint32(&o.ENABLECLR0.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetENABLECLR0_CLR2() uint32 {
	return (volatile.LoadUint32(&o.ENABLECLR0.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetENABLECLR0_CLR3(value uint32) {
	volatile.StoreUint32(&o.ENABLECLR0.Reg, volatile.LoadUint32(&o.ENABLECLR0.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetENABLECLR0_CLR3() uint32 {
	return (volatile.LoadUint32(&o.ENABLECLR0.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetENABLECLR0_CLR4(value uint32) {
	volatile.StoreUint32(&o.ENABLECLR0.Reg, volatile.LoadUint32(&o.ENABLECLR0.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetENABLECLR0_CLR4() uint32 {
	return (volatile.LoadUint32(&o.ENABLECLR0.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetENABLECLR0_CLR5(value uint32) {
	volatile.StoreUint32(&o.ENABLECLR0.Reg, volatile.LoadUint32(&o.ENABLECLR0.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetENABLECLR0_CLR5() uint32 {
	return (volatile.LoadUint32(&o.ENABLECLR0.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetENABLECLR0_CLR6(value uint32) {
	volatile.StoreUint32(&o.ENABLECLR0.Reg, volatile.LoadUint32(&o.ENABLECLR0.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetENABLECLR0_CLR6() uint32 {
	return (volatile.LoadUint32(&o.ENABLECLR0.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetENABLECLR0_CLR7(value uint32) {
	volatile.StoreUint32(&o.ENABLECLR0.Reg, volatile.LoadUint32(&o.ENABLECLR0.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetENABLECLR0_CLR7() uint32 {
	return (volatile.LoadUint32(&o.ENABLECLR0.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetENABLECLR0_CLR8(value uint32) {
	volatile.StoreUint32(&o.ENABLECLR0.Reg, volatile.LoadUint32(&o.ENABLECLR0.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetENABLECLR0_CLR8() uint32 {
	return (volatile.LoadUint32(&o.ENABLECLR0.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetENABLECLR0_CLR9(value uint32) {
	volatile.StoreUint32(&o.ENABLECLR0.Reg, volatile.LoadUint32(&o.ENABLECLR0.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetENABLECLR0_CLR9() uint32 {
	return (volatile.LoadUint32(&o.ENABLECLR0.Reg) & 0x200) >> 9
}
func (o *DMA_Type) SetENABLECLR0_CLR10(value uint32) {
	volatile.StoreUint32(&o.ENABLECLR0.Reg, volatile.LoadUint32(&o.ENABLECLR0.Reg)&^(0x400)|value<<10)
}
func (o *DMA_Type) GetENABLECLR0_CLR10() uint32 {
	return (volatile.LoadUint32(&o.ENABLECLR0.Reg) & 0x400) >> 10
}
func (o *DMA_Type) SetENABLECLR0_CLR11(value uint32) {
	volatile.StoreUint32(&o.ENABLECLR0.Reg, volatile.LoadUint32(&o.ENABLECLR0.Reg)&^(0x800)|value<<11)
}
func (o *DMA_Type) GetENABLECLR0_CLR11() uint32 {
	return (volatile.LoadUint32(&o.ENABLECLR0.Reg) & 0x800) >> 11
}
func (o *DMA_Type) SetENABLECLR0_CLR12(value uint32) {
	volatile.StoreUint32(&o.ENABLECLR0.Reg, volatile.LoadUint32(&o.ENABLECLR0.Reg)&^(0x1000)|value<<12)
}
func (o *DMA_Type) GetENABLECLR0_CLR12() uint32 {
	return (volatile.LoadUint32(&o.ENABLECLR0.Reg) & 0x1000) >> 12
}
func (o *DMA_Type) SetENABLECLR0_CLR13(value uint32) {
	volatile.StoreUint32(&o.ENABLECLR0.Reg, volatile.LoadUint32(&o.ENABLECLR0.Reg)&^(0x2000)|value<<13)
}
func (o *DMA_Type) GetENABLECLR0_CLR13() uint32 {
	return (volatile.LoadUint32(&o.ENABLECLR0.Reg) & 0x2000) >> 13
}
func (o *DMA_Type) SetENABLECLR0_CLR14(value uint32) {
	volatile.StoreUint32(&o.ENABLECLR0.Reg, volatile.LoadUint32(&o.ENABLECLR0.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetENABLECLR0_CLR14() uint32 {
	return (volatile.LoadUint32(&o.ENABLECLR0.Reg) & 0x4000) >> 14
}
func (o *DMA_Type) SetENABLECLR0_CLR15(value uint32) {
	volatile.StoreUint32(&o.ENABLECLR0.Reg, volatile.LoadUint32(&o.ENABLECLR0.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetENABLECLR0_CLR15() uint32 {
	return (volatile.LoadUint32(&o.ENABLECLR0.Reg) & 0x8000) >> 15
}
func (o *DMA_Type) SetENABLECLR0_CLR16(value uint32) {
	volatile.StoreUint32(&o.ENABLECLR0.Reg, volatile.LoadUint32(&o.ENABLECLR0.Reg)&^(0x10000)|value<<16)
}
func (o *DMA_Type) GetENABLECLR0_CLR16() uint32 {
	return (volatile.LoadUint32(&o.ENABLECLR0.Reg) & 0x10000) >> 16
}
func (o *DMA_Type) SetENABLECLR0_CLR17(value uint32) {
	volatile.StoreUint32(&o.ENABLECLR0.Reg, volatile.LoadUint32(&o.ENABLECLR0.Reg)&^(0x20000)|value<<17)
}
func (o *DMA_Type) GetENABLECLR0_CLR17() uint32 {
	return (volatile.LoadUint32(&o.ENABLECLR0.Reg) & 0x20000) >> 17
}
func (o *DMA_Type) SetENABLECLR0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENABLECLR0.Reg, volatile.LoadUint32(&o.ENABLECLR0.Reg)&^(0xfffc0000)|value<<18)
}
func (o *DMA_Type) GetENABLECLR0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ENABLECLR0.Reg) & 0xfffc0000) >> 18
}

// DMA.ACTIVE0: Channel Active status for all DMA channels.
func (o *DMA_Type) SetACTIVE0_ACT0(value uint32) {
	volatile.StoreUint32(&o.ACTIVE0.Reg, volatile.LoadUint32(&o.ACTIVE0.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetACTIVE0_ACT0() uint32 {
	return volatile.LoadUint32(&o.ACTIVE0.Reg) & 0x1
}
func (o *DMA_Type) SetACTIVE0_ACT1(value uint32) {
	volatile.StoreUint32(&o.ACTIVE0.Reg, volatile.LoadUint32(&o.ACTIVE0.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetACTIVE0_ACT1() uint32 {
	return (volatile.LoadUint32(&o.ACTIVE0.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetACTIVE0_ACT2(value uint32) {
	volatile.StoreUint32(&o.ACTIVE0.Reg, volatile.LoadUint32(&o.ACTIVE0.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetACTIVE0_ACT2() uint32 {
	return (volatile.LoadUint32(&o.ACTIVE0.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetACTIVE0_ACT3(value uint32) {
	volatile.StoreUint32(&o.ACTIVE0.Reg, volatile.LoadUint32(&o.ACTIVE0.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetACTIVE0_ACT3() uint32 {
	return (volatile.LoadUint32(&o.ACTIVE0.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetACTIVE0_ACT4(value uint32) {
	volatile.StoreUint32(&o.ACTIVE0.Reg, volatile.LoadUint32(&o.ACTIVE0.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetACTIVE0_ACT4() uint32 {
	return (volatile.LoadUint32(&o.ACTIVE0.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetACTIVE0_ACT5(value uint32) {
	volatile.StoreUint32(&o.ACTIVE0.Reg, volatile.LoadUint32(&o.ACTIVE0.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetACTIVE0_ACT5() uint32 {
	return (volatile.LoadUint32(&o.ACTIVE0.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetACTIVE0_ACT6(value uint32) {
	volatile.StoreUint32(&o.ACTIVE0.Reg, volatile.LoadUint32(&o.ACTIVE0.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetACTIVE0_ACT6() uint32 {
	return (volatile.LoadUint32(&o.ACTIVE0.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetACTIVE0_ACT7(value uint32) {
	volatile.StoreUint32(&o.ACTIVE0.Reg, volatile.LoadUint32(&o.ACTIVE0.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetACTIVE0_ACT7() uint32 {
	return (volatile.LoadUint32(&o.ACTIVE0.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetACTIVE0_ACT8(value uint32) {
	volatile.StoreUint32(&o.ACTIVE0.Reg, volatile.LoadUint32(&o.ACTIVE0.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetACTIVE0_ACT8() uint32 {
	return (volatile.LoadUint32(&o.ACTIVE0.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetACTIVE0_ACT9(value uint32) {
	volatile.StoreUint32(&o.ACTIVE0.Reg, volatile.LoadUint32(&o.ACTIVE0.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetACTIVE0_ACT9() uint32 {
	return (volatile.LoadUint32(&o.ACTIVE0.Reg) & 0x200) >> 9
}
func (o *DMA_Type) SetACTIVE0_ACT10(value uint32) {
	volatile.StoreUint32(&o.ACTIVE0.Reg, volatile.LoadUint32(&o.ACTIVE0.Reg)&^(0x400)|value<<10)
}
func (o *DMA_Type) GetACTIVE0_ACT10() uint32 {
	return (volatile.LoadUint32(&o.ACTIVE0.Reg) & 0x400) >> 10
}
func (o *DMA_Type) SetACTIVE0_ACT11(value uint32) {
	volatile.StoreUint32(&o.ACTIVE0.Reg, volatile.LoadUint32(&o.ACTIVE0.Reg)&^(0x800)|value<<11)
}
func (o *DMA_Type) GetACTIVE0_ACT11() uint32 {
	return (volatile.LoadUint32(&o.ACTIVE0.Reg) & 0x800) >> 11
}
func (o *DMA_Type) SetACTIVE0_ACT12(value uint32) {
	volatile.StoreUint32(&o.ACTIVE0.Reg, volatile.LoadUint32(&o.ACTIVE0.Reg)&^(0x1000)|value<<12)
}
func (o *DMA_Type) GetACTIVE0_ACT12() uint32 {
	return (volatile.LoadUint32(&o.ACTIVE0.Reg) & 0x1000) >> 12
}
func (o *DMA_Type) SetACTIVE0_ACT13(value uint32) {
	volatile.StoreUint32(&o.ACTIVE0.Reg, volatile.LoadUint32(&o.ACTIVE0.Reg)&^(0x2000)|value<<13)
}
func (o *DMA_Type) GetACTIVE0_ACT13() uint32 {
	return (volatile.LoadUint32(&o.ACTIVE0.Reg) & 0x2000) >> 13
}
func (o *DMA_Type) SetACTIVE0_ACT14(value uint32) {
	volatile.StoreUint32(&o.ACTIVE0.Reg, volatile.LoadUint32(&o.ACTIVE0.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetACTIVE0_ACT14() uint32 {
	return (volatile.LoadUint32(&o.ACTIVE0.Reg) & 0x4000) >> 14
}
func (o *DMA_Type) SetACTIVE0_ACT15(value uint32) {
	volatile.StoreUint32(&o.ACTIVE0.Reg, volatile.LoadUint32(&o.ACTIVE0.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetACTIVE0_ACT15() uint32 {
	return (volatile.LoadUint32(&o.ACTIVE0.Reg) & 0x8000) >> 15
}
func (o *DMA_Type) SetACTIVE0_ACT16(value uint32) {
	volatile.StoreUint32(&o.ACTIVE0.Reg, volatile.LoadUint32(&o.ACTIVE0.Reg)&^(0x10000)|value<<16)
}
func (o *DMA_Type) GetACTIVE0_ACT16() uint32 {
	return (volatile.LoadUint32(&o.ACTIVE0.Reg) & 0x10000) >> 16
}
func (o *DMA_Type) SetACTIVE0_ACT17(value uint32) {
	volatile.StoreUint32(&o.ACTIVE0.Reg, volatile.LoadUint32(&o.ACTIVE0.Reg)&^(0x20000)|value<<17)
}
func (o *DMA_Type) GetACTIVE0_ACT17() uint32 {
	return (volatile.LoadUint32(&o.ACTIVE0.Reg) & 0x20000) >> 17
}
func (o *DMA_Type) SetACTIVE0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ACTIVE0.Reg, volatile.LoadUint32(&o.ACTIVE0.Reg)&^(0xfffc0000)|value<<18)
}
func (o *DMA_Type) GetACTIVE0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ACTIVE0.Reg) & 0xfffc0000) >> 18
}

// DMA.BUSY0: Channel Busy status for all DMA channels.
func (o *DMA_Type) SetBUSY0_BSY0(value uint32) {
	volatile.StoreUint32(&o.BUSY0.Reg, volatile.LoadUint32(&o.BUSY0.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetBUSY0_BSY0() uint32 {
	return volatile.LoadUint32(&o.BUSY0.Reg) & 0x1
}
func (o *DMA_Type) SetBUSY0_BSY1(value uint32) {
	volatile.StoreUint32(&o.BUSY0.Reg, volatile.LoadUint32(&o.BUSY0.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetBUSY0_BSY1() uint32 {
	return (volatile.LoadUint32(&o.BUSY0.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetBUSY0_BSY2(value uint32) {
	volatile.StoreUint32(&o.BUSY0.Reg, volatile.LoadUint32(&o.BUSY0.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetBUSY0_BSY2() uint32 {
	return (volatile.LoadUint32(&o.BUSY0.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetBUSY0_BSY3(value uint32) {
	volatile.StoreUint32(&o.BUSY0.Reg, volatile.LoadUint32(&o.BUSY0.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetBUSY0_BSY3() uint32 {
	return (volatile.LoadUint32(&o.BUSY0.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetBUSY0_BSY4(value uint32) {
	volatile.StoreUint32(&o.BUSY0.Reg, volatile.LoadUint32(&o.BUSY0.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetBUSY0_BSY4() uint32 {
	return (volatile.LoadUint32(&o.BUSY0.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetBUSY0_BSY5(value uint32) {
	volatile.StoreUint32(&o.BUSY0.Reg, volatile.LoadUint32(&o.BUSY0.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetBUSY0_BSY5() uint32 {
	return (volatile.LoadUint32(&o.BUSY0.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetBUSY0_BSY6(value uint32) {
	volatile.StoreUint32(&o.BUSY0.Reg, volatile.LoadUint32(&o.BUSY0.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetBUSY0_BSY6() uint32 {
	return (volatile.LoadUint32(&o.BUSY0.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetBUSY0_BSY7(value uint32) {
	volatile.StoreUint32(&o.BUSY0.Reg, volatile.LoadUint32(&o.BUSY0.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetBUSY0_BSY7() uint32 {
	return (volatile.LoadUint32(&o.BUSY0.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetBUSY0_BSY8(value uint32) {
	volatile.StoreUint32(&o.BUSY0.Reg, volatile.LoadUint32(&o.BUSY0.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetBUSY0_BSY8() uint32 {
	return (volatile.LoadUint32(&o.BUSY0.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetBUSY0_BSY9(value uint32) {
	volatile.StoreUint32(&o.BUSY0.Reg, volatile.LoadUint32(&o.BUSY0.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetBUSY0_BSY9() uint32 {
	return (volatile.LoadUint32(&o.BUSY0.Reg) & 0x200) >> 9
}
func (o *DMA_Type) SetBUSY0_BSY10(value uint32) {
	volatile.StoreUint32(&o.BUSY0.Reg, volatile.LoadUint32(&o.BUSY0.Reg)&^(0x400)|value<<10)
}
func (o *DMA_Type) GetBUSY0_BSY10() uint32 {
	return (volatile.LoadUint32(&o.BUSY0.Reg) & 0x400) >> 10
}
func (o *DMA_Type) SetBUSY0_BSY11(value uint32) {
	volatile.StoreUint32(&o.BUSY0.Reg, volatile.LoadUint32(&o.BUSY0.Reg)&^(0x800)|value<<11)
}
func (o *DMA_Type) GetBUSY0_BSY11() uint32 {
	return (volatile.LoadUint32(&o.BUSY0.Reg) & 0x800) >> 11
}
func (o *DMA_Type) SetBUSY0_BSY12(value uint32) {
	volatile.StoreUint32(&o.BUSY0.Reg, volatile.LoadUint32(&o.BUSY0.Reg)&^(0x1000)|value<<12)
}
func (o *DMA_Type) GetBUSY0_BSY12() uint32 {
	return (volatile.LoadUint32(&o.BUSY0.Reg) & 0x1000) >> 12
}
func (o *DMA_Type) SetBUSY0_BSY13(value uint32) {
	volatile.StoreUint32(&o.BUSY0.Reg, volatile.LoadUint32(&o.BUSY0.Reg)&^(0x2000)|value<<13)
}
func (o *DMA_Type) GetBUSY0_BSY13() uint32 {
	return (volatile.LoadUint32(&o.BUSY0.Reg) & 0x2000) >> 13
}
func (o *DMA_Type) SetBUSY0_BSY14(value uint32) {
	volatile.StoreUint32(&o.BUSY0.Reg, volatile.LoadUint32(&o.BUSY0.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetBUSY0_BSY14() uint32 {
	return (volatile.LoadUint32(&o.BUSY0.Reg) & 0x4000) >> 14
}
func (o *DMA_Type) SetBUSY0_BSY15(value uint32) {
	volatile.StoreUint32(&o.BUSY0.Reg, volatile.LoadUint32(&o.BUSY0.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetBUSY0_BSY15() uint32 {
	return (volatile.LoadUint32(&o.BUSY0.Reg) & 0x8000) >> 15
}
func (o *DMA_Type) SetBUSY0_BSY16(value uint32) {
	volatile.StoreUint32(&o.BUSY0.Reg, volatile.LoadUint32(&o.BUSY0.Reg)&^(0x10000)|value<<16)
}
func (o *DMA_Type) GetBUSY0_BSY16() uint32 {
	return (volatile.LoadUint32(&o.BUSY0.Reg) & 0x10000) >> 16
}
func (o *DMA_Type) SetBUSY0_BSY17(value uint32) {
	volatile.StoreUint32(&o.BUSY0.Reg, volatile.LoadUint32(&o.BUSY0.Reg)&^(0x20000)|value<<17)
}
func (o *DMA_Type) GetBUSY0_BSY17() uint32 {
	return (volatile.LoadUint32(&o.BUSY0.Reg) & 0x20000) >> 17
}
func (o *DMA_Type) SetBUSY0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.BUSY0.Reg, volatile.LoadUint32(&o.BUSY0.Reg)&^(0xfffc0000)|value<<18)
}
func (o *DMA_Type) GetBUSY0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.BUSY0.Reg) & 0xfffc0000) >> 18
}

// DMA.ERRINT0: Error Interrupt status for all DMA channels.
func (o *DMA_Type) SetERRINT0_ERR0(value uint32) {
	volatile.StoreUint32(&o.ERRINT0.Reg, volatile.LoadUint32(&o.ERRINT0.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetERRINT0_ERR0() uint32 {
	return volatile.LoadUint32(&o.ERRINT0.Reg) & 0x1
}
func (o *DMA_Type) SetERRINT0_ERR1(value uint32) {
	volatile.StoreUint32(&o.ERRINT0.Reg, volatile.LoadUint32(&o.ERRINT0.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetERRINT0_ERR1() uint32 {
	return (volatile.LoadUint32(&o.ERRINT0.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetERRINT0_ERR2(value uint32) {
	volatile.StoreUint32(&o.ERRINT0.Reg, volatile.LoadUint32(&o.ERRINT0.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetERRINT0_ERR2() uint32 {
	return (volatile.LoadUint32(&o.ERRINT0.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetERRINT0_ERR3(value uint32) {
	volatile.StoreUint32(&o.ERRINT0.Reg, volatile.LoadUint32(&o.ERRINT0.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetERRINT0_ERR3() uint32 {
	return (volatile.LoadUint32(&o.ERRINT0.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetERRINT0_ERR4(value uint32) {
	volatile.StoreUint32(&o.ERRINT0.Reg, volatile.LoadUint32(&o.ERRINT0.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetERRINT0_ERR4() uint32 {
	return (volatile.LoadUint32(&o.ERRINT0.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetERRINT0_ERR5(value uint32) {
	volatile.StoreUint32(&o.ERRINT0.Reg, volatile.LoadUint32(&o.ERRINT0.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetERRINT0_ERR5() uint32 {
	return (volatile.LoadUint32(&o.ERRINT0.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetERRINT0_ERR6(value uint32) {
	volatile.StoreUint32(&o.ERRINT0.Reg, volatile.LoadUint32(&o.ERRINT0.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetERRINT0_ERR6() uint32 {
	return (volatile.LoadUint32(&o.ERRINT0.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetERRINT0_ERR7(value uint32) {
	volatile.StoreUint32(&o.ERRINT0.Reg, volatile.LoadUint32(&o.ERRINT0.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetERRINT0_ERR7() uint32 {
	return (volatile.LoadUint32(&o.ERRINT0.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetERRINT0_ERR8(value uint32) {
	volatile.StoreUint32(&o.ERRINT0.Reg, volatile.LoadUint32(&o.ERRINT0.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetERRINT0_ERR8() uint32 {
	return (volatile.LoadUint32(&o.ERRINT0.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetERRINT0_ERR9(value uint32) {
	volatile.StoreUint32(&o.ERRINT0.Reg, volatile.LoadUint32(&o.ERRINT0.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetERRINT0_ERR9() uint32 {
	return (volatile.LoadUint32(&o.ERRINT0.Reg) & 0x200) >> 9
}
func (o *DMA_Type) SetERRINT0_ERR10(value uint32) {
	volatile.StoreUint32(&o.ERRINT0.Reg, volatile.LoadUint32(&o.ERRINT0.Reg)&^(0x400)|value<<10)
}
func (o *DMA_Type) GetERRINT0_ERR10() uint32 {
	return (volatile.LoadUint32(&o.ERRINT0.Reg) & 0x400) >> 10
}
func (o *DMA_Type) SetERRINT0_ERR11(value uint32) {
	volatile.StoreUint32(&o.ERRINT0.Reg, volatile.LoadUint32(&o.ERRINT0.Reg)&^(0x800)|value<<11)
}
func (o *DMA_Type) GetERRINT0_ERR11() uint32 {
	return (volatile.LoadUint32(&o.ERRINT0.Reg) & 0x800) >> 11
}
func (o *DMA_Type) SetERRINT0_ERR12(value uint32) {
	volatile.StoreUint32(&o.ERRINT0.Reg, volatile.LoadUint32(&o.ERRINT0.Reg)&^(0x1000)|value<<12)
}
func (o *DMA_Type) GetERRINT0_ERR12() uint32 {
	return (volatile.LoadUint32(&o.ERRINT0.Reg) & 0x1000) >> 12
}
func (o *DMA_Type) SetERRINT0_ERR13(value uint32) {
	volatile.StoreUint32(&o.ERRINT0.Reg, volatile.LoadUint32(&o.ERRINT0.Reg)&^(0x2000)|value<<13)
}
func (o *DMA_Type) GetERRINT0_ERR13() uint32 {
	return (volatile.LoadUint32(&o.ERRINT0.Reg) & 0x2000) >> 13
}
func (o *DMA_Type) SetERRINT0_ERR14(value uint32) {
	volatile.StoreUint32(&o.ERRINT0.Reg, volatile.LoadUint32(&o.ERRINT0.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetERRINT0_ERR14() uint32 {
	return (volatile.LoadUint32(&o.ERRINT0.Reg) & 0x4000) >> 14
}
func (o *DMA_Type) SetERRINT0_ERR15(value uint32) {
	volatile.StoreUint32(&o.ERRINT0.Reg, volatile.LoadUint32(&o.ERRINT0.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetERRINT0_ERR15() uint32 {
	return (volatile.LoadUint32(&o.ERRINT0.Reg) & 0x8000) >> 15
}
func (o *DMA_Type) SetERRINT0_ERR16(value uint32) {
	volatile.StoreUint32(&o.ERRINT0.Reg, volatile.LoadUint32(&o.ERRINT0.Reg)&^(0x10000)|value<<16)
}
func (o *DMA_Type) GetERRINT0_ERR16() uint32 {
	return (volatile.LoadUint32(&o.ERRINT0.Reg) & 0x10000) >> 16
}
func (o *DMA_Type) SetERRINT0_ERR17(value uint32) {
	volatile.StoreUint32(&o.ERRINT0.Reg, volatile.LoadUint32(&o.ERRINT0.Reg)&^(0x20000)|value<<17)
}
func (o *DMA_Type) GetERRINT0_ERR17() uint32 {
	return (volatile.LoadUint32(&o.ERRINT0.Reg) & 0x20000) >> 17
}
func (o *DMA_Type) SetERRINT0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ERRINT0.Reg, volatile.LoadUint32(&o.ERRINT0.Reg)&^(0xfffc0000)|value<<18)
}
func (o *DMA_Type) GetERRINT0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ERRINT0.Reg) & 0xfffc0000) >> 18
}

// DMA.INTENSET0: Interrupt Enable read and Set for all DMA channels.
func (o *DMA_Type) SetINTENSET0_SET0(value uint32) {
	volatile.StoreUint32(&o.INTENSET0.Reg, volatile.LoadUint32(&o.INTENSET0.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetINTENSET0_SET0() uint32 {
	return volatile.LoadUint32(&o.INTENSET0.Reg) & 0x1
}
func (o *DMA_Type) SetINTENSET0_SET1(value uint32) {
	volatile.StoreUint32(&o.INTENSET0.Reg, volatile.LoadUint32(&o.INTENSET0.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetINTENSET0_SET1() uint32 {
	return (volatile.LoadUint32(&o.INTENSET0.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetINTENSET0_SET2(value uint32) {
	volatile.StoreUint32(&o.INTENSET0.Reg, volatile.LoadUint32(&o.INTENSET0.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetINTENSET0_SET2() uint32 {
	return (volatile.LoadUint32(&o.INTENSET0.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetINTENSET0_SET3(value uint32) {
	volatile.StoreUint32(&o.INTENSET0.Reg, volatile.LoadUint32(&o.INTENSET0.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetINTENSET0_SET3() uint32 {
	return (volatile.LoadUint32(&o.INTENSET0.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetINTENSET0_SET4(value uint32) {
	volatile.StoreUint32(&o.INTENSET0.Reg, volatile.LoadUint32(&o.INTENSET0.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetINTENSET0_SET4() uint32 {
	return (volatile.LoadUint32(&o.INTENSET0.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetINTENSET0_SET5(value uint32) {
	volatile.StoreUint32(&o.INTENSET0.Reg, volatile.LoadUint32(&o.INTENSET0.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetINTENSET0_SET5() uint32 {
	return (volatile.LoadUint32(&o.INTENSET0.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetINTENSET0_SET6(value uint32) {
	volatile.StoreUint32(&o.INTENSET0.Reg, volatile.LoadUint32(&o.INTENSET0.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetINTENSET0_SET6() uint32 {
	return (volatile.LoadUint32(&o.INTENSET0.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetINTENSET0_SET7(value uint32) {
	volatile.StoreUint32(&o.INTENSET0.Reg, volatile.LoadUint32(&o.INTENSET0.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetINTENSET0_SET7() uint32 {
	return (volatile.LoadUint32(&o.INTENSET0.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetINTENSET0_SET8(value uint32) {
	volatile.StoreUint32(&o.INTENSET0.Reg, volatile.LoadUint32(&o.INTENSET0.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetINTENSET0_SET8() uint32 {
	return (volatile.LoadUint32(&o.INTENSET0.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetINTENSET0_SET9(value uint32) {
	volatile.StoreUint32(&o.INTENSET0.Reg, volatile.LoadUint32(&o.INTENSET0.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetINTENSET0_SET9() uint32 {
	return (volatile.LoadUint32(&o.INTENSET0.Reg) & 0x200) >> 9
}
func (o *DMA_Type) SetINTENSET0_SET10(value uint32) {
	volatile.StoreUint32(&o.INTENSET0.Reg, volatile.LoadUint32(&o.INTENSET0.Reg)&^(0x400)|value<<10)
}
func (o *DMA_Type) GetINTENSET0_SET10() uint32 {
	return (volatile.LoadUint32(&o.INTENSET0.Reg) & 0x400) >> 10
}
func (o *DMA_Type) SetINTENSET0_SET11(value uint32) {
	volatile.StoreUint32(&o.INTENSET0.Reg, volatile.LoadUint32(&o.INTENSET0.Reg)&^(0x800)|value<<11)
}
func (o *DMA_Type) GetINTENSET0_SET11() uint32 {
	return (volatile.LoadUint32(&o.INTENSET0.Reg) & 0x800) >> 11
}
func (o *DMA_Type) SetINTENSET0_SET12(value uint32) {
	volatile.StoreUint32(&o.INTENSET0.Reg, volatile.LoadUint32(&o.INTENSET0.Reg)&^(0x1000)|value<<12)
}
func (o *DMA_Type) GetINTENSET0_SET12() uint32 {
	return (volatile.LoadUint32(&o.INTENSET0.Reg) & 0x1000) >> 12
}
func (o *DMA_Type) SetINTENSET0_SET13(value uint32) {
	volatile.StoreUint32(&o.INTENSET0.Reg, volatile.LoadUint32(&o.INTENSET0.Reg)&^(0x2000)|value<<13)
}
func (o *DMA_Type) GetINTENSET0_SET13() uint32 {
	return (volatile.LoadUint32(&o.INTENSET0.Reg) & 0x2000) >> 13
}
func (o *DMA_Type) SetINTENSET0_SET14(value uint32) {
	volatile.StoreUint32(&o.INTENSET0.Reg, volatile.LoadUint32(&o.INTENSET0.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetINTENSET0_SET14() uint32 {
	return (volatile.LoadUint32(&o.INTENSET0.Reg) & 0x4000) >> 14
}
func (o *DMA_Type) SetINTENSET0_SET15(value uint32) {
	volatile.StoreUint32(&o.INTENSET0.Reg, volatile.LoadUint32(&o.INTENSET0.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetINTENSET0_SET15() uint32 {
	return (volatile.LoadUint32(&o.INTENSET0.Reg) & 0x8000) >> 15
}
func (o *DMA_Type) SetINTENSET0_SET16(value uint32) {
	volatile.StoreUint32(&o.INTENSET0.Reg, volatile.LoadUint32(&o.INTENSET0.Reg)&^(0x10000)|value<<16)
}
func (o *DMA_Type) GetINTENSET0_SET16() uint32 {
	return (volatile.LoadUint32(&o.INTENSET0.Reg) & 0x10000) >> 16
}
func (o *DMA_Type) SetINTENSET0_SET17(value uint32) {
	volatile.StoreUint32(&o.INTENSET0.Reg, volatile.LoadUint32(&o.INTENSET0.Reg)&^(0x20000)|value<<17)
}
func (o *DMA_Type) GetINTENSET0_SET17() uint32 {
	return (volatile.LoadUint32(&o.INTENSET0.Reg) & 0x20000) >> 17
}
func (o *DMA_Type) SetINTENSET0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTENSET0.Reg, volatile.LoadUint32(&o.INTENSET0.Reg)&^(0xfffc0000)|value<<18)
}
func (o *DMA_Type) GetINTENSET0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET0.Reg) & 0xfffc0000) >> 18
}

// DMA.INTENCLR0: Interrupt Enable Clear for all DMA channels.
func (o *DMA_Type) SetINTENCLR0_CLR0(value uint32) {
	volatile.StoreUint32(&o.INTENCLR0.Reg, volatile.LoadUint32(&o.INTENCLR0.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetINTENCLR0_CLR0() uint32 {
	return volatile.LoadUint32(&o.INTENCLR0.Reg) & 0x1
}
func (o *DMA_Type) SetINTENCLR0_CLR1(value uint32) {
	volatile.StoreUint32(&o.INTENCLR0.Reg, volatile.LoadUint32(&o.INTENCLR0.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetINTENCLR0_CLR1() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR0.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetINTENCLR0_CLR2(value uint32) {
	volatile.StoreUint32(&o.INTENCLR0.Reg, volatile.LoadUint32(&o.INTENCLR0.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetINTENCLR0_CLR2() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR0.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetINTENCLR0_CLR3(value uint32) {
	volatile.StoreUint32(&o.INTENCLR0.Reg, volatile.LoadUint32(&o.INTENCLR0.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetINTENCLR0_CLR3() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR0.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetINTENCLR0_CLR4(value uint32) {
	volatile.StoreUint32(&o.INTENCLR0.Reg, volatile.LoadUint32(&o.INTENCLR0.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetINTENCLR0_CLR4() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR0.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetINTENCLR0_CLR5(value uint32) {
	volatile.StoreUint32(&o.INTENCLR0.Reg, volatile.LoadUint32(&o.INTENCLR0.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetINTENCLR0_CLR5() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR0.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetINTENCLR0_CLR6(value uint32) {
	volatile.StoreUint32(&o.INTENCLR0.Reg, volatile.LoadUint32(&o.INTENCLR0.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetINTENCLR0_CLR6() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR0.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetINTENCLR0_CLR7(value uint32) {
	volatile.StoreUint32(&o.INTENCLR0.Reg, volatile.LoadUint32(&o.INTENCLR0.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetINTENCLR0_CLR7() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR0.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetINTENCLR0_CLR8(value uint32) {
	volatile.StoreUint32(&o.INTENCLR0.Reg, volatile.LoadUint32(&o.INTENCLR0.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetINTENCLR0_CLR8() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR0.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetINTENCLR0_CLR9(value uint32) {
	volatile.StoreUint32(&o.INTENCLR0.Reg, volatile.LoadUint32(&o.INTENCLR0.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetINTENCLR0_CLR9() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR0.Reg) & 0x200) >> 9
}
func (o *DMA_Type) SetINTENCLR0_CLR10(value uint32) {
	volatile.StoreUint32(&o.INTENCLR0.Reg, volatile.LoadUint32(&o.INTENCLR0.Reg)&^(0x400)|value<<10)
}
func (o *DMA_Type) GetINTENCLR0_CLR10() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR0.Reg) & 0x400) >> 10
}
func (o *DMA_Type) SetINTENCLR0_CLR11(value uint32) {
	volatile.StoreUint32(&o.INTENCLR0.Reg, volatile.LoadUint32(&o.INTENCLR0.Reg)&^(0x800)|value<<11)
}
func (o *DMA_Type) GetINTENCLR0_CLR11() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR0.Reg) & 0x800) >> 11
}
func (o *DMA_Type) SetINTENCLR0_CLR12(value uint32) {
	volatile.StoreUint32(&o.INTENCLR0.Reg, volatile.LoadUint32(&o.INTENCLR0.Reg)&^(0x1000)|value<<12)
}
func (o *DMA_Type) GetINTENCLR0_CLR12() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR0.Reg) & 0x1000) >> 12
}
func (o *DMA_Type) SetINTENCLR0_CLR13(value uint32) {
	volatile.StoreUint32(&o.INTENCLR0.Reg, volatile.LoadUint32(&o.INTENCLR0.Reg)&^(0x2000)|value<<13)
}
func (o *DMA_Type) GetINTENCLR0_CLR13() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR0.Reg) & 0x2000) >> 13
}
func (o *DMA_Type) SetINTENCLR0_CLR14(value uint32) {
	volatile.StoreUint32(&o.INTENCLR0.Reg, volatile.LoadUint32(&o.INTENCLR0.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetINTENCLR0_CLR14() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR0.Reg) & 0x4000) >> 14
}
func (o *DMA_Type) SetINTENCLR0_CLR15(value uint32) {
	volatile.StoreUint32(&o.INTENCLR0.Reg, volatile.LoadUint32(&o.INTENCLR0.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetINTENCLR0_CLR15() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR0.Reg) & 0x8000) >> 15
}
func (o *DMA_Type) SetINTENCLR0_CLR16(value uint32) {
	volatile.StoreUint32(&o.INTENCLR0.Reg, volatile.LoadUint32(&o.INTENCLR0.Reg)&^(0x10000)|value<<16)
}
func (o *DMA_Type) GetINTENCLR0_CLR16() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR0.Reg) & 0x10000) >> 16
}
func (o *DMA_Type) SetINTENCLR0_CLR17(value uint32) {
	volatile.StoreUint32(&o.INTENCLR0.Reg, volatile.LoadUint32(&o.INTENCLR0.Reg)&^(0x20000)|value<<17)
}
func (o *DMA_Type) GetINTENCLR0_CLR17() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR0.Reg) & 0x20000) >> 17
}
func (o *DMA_Type) SetINTENCLR0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR0.Reg, volatile.LoadUint32(&o.INTENCLR0.Reg)&^(0xfffc0000)|value<<18)
}
func (o *DMA_Type) GetINTENCLR0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR0.Reg) & 0xfffc0000) >> 18
}

// DMA.INTA0: Interrupt A status for all DMA channels.
func (o *DMA_Type) SetINTA0_IA0(value uint32) {
	volatile.StoreUint32(&o.INTA0.Reg, volatile.LoadUint32(&o.INTA0.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetINTA0_IA0() uint32 {
	return volatile.LoadUint32(&o.INTA0.Reg) & 0x1
}
func (o *DMA_Type) SetINTA0_IA1(value uint32) {
	volatile.StoreUint32(&o.INTA0.Reg, volatile.LoadUint32(&o.INTA0.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetINTA0_IA1() uint32 {
	return (volatile.LoadUint32(&o.INTA0.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetINTA0_IA2(value uint32) {
	volatile.StoreUint32(&o.INTA0.Reg, volatile.LoadUint32(&o.INTA0.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetINTA0_IA2() uint32 {
	return (volatile.LoadUint32(&o.INTA0.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetINTA0_IA3(value uint32) {
	volatile.StoreUint32(&o.INTA0.Reg, volatile.LoadUint32(&o.INTA0.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetINTA0_IA3() uint32 {
	return (volatile.LoadUint32(&o.INTA0.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetINTA0_IA4(value uint32) {
	volatile.StoreUint32(&o.INTA0.Reg, volatile.LoadUint32(&o.INTA0.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetINTA0_IA4() uint32 {
	return (volatile.LoadUint32(&o.INTA0.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetINTA0_IA5(value uint32) {
	volatile.StoreUint32(&o.INTA0.Reg, volatile.LoadUint32(&o.INTA0.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetINTA0_IA5() uint32 {
	return (volatile.LoadUint32(&o.INTA0.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetINTA0_IA6(value uint32) {
	volatile.StoreUint32(&o.INTA0.Reg, volatile.LoadUint32(&o.INTA0.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetINTA0_IA6() uint32 {
	return (volatile.LoadUint32(&o.INTA0.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetINTA0_IA7(value uint32) {
	volatile.StoreUint32(&o.INTA0.Reg, volatile.LoadUint32(&o.INTA0.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetINTA0_IA7() uint32 {
	return (volatile.LoadUint32(&o.INTA0.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetINTA0_IA8(value uint32) {
	volatile.StoreUint32(&o.INTA0.Reg, volatile.LoadUint32(&o.INTA0.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetINTA0_IA8() uint32 {
	return (volatile.LoadUint32(&o.INTA0.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetINTA0_IA9(value uint32) {
	volatile.StoreUint32(&o.INTA0.Reg, volatile.LoadUint32(&o.INTA0.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetINTA0_IA9() uint32 {
	return (volatile.LoadUint32(&o.INTA0.Reg) & 0x200) >> 9
}
func (o *DMA_Type) SetINTA0_IA10(value uint32) {
	volatile.StoreUint32(&o.INTA0.Reg, volatile.LoadUint32(&o.INTA0.Reg)&^(0x400)|value<<10)
}
func (o *DMA_Type) GetINTA0_IA10() uint32 {
	return (volatile.LoadUint32(&o.INTA0.Reg) & 0x400) >> 10
}
func (o *DMA_Type) SetINTA0_IA11(value uint32) {
	volatile.StoreUint32(&o.INTA0.Reg, volatile.LoadUint32(&o.INTA0.Reg)&^(0x800)|value<<11)
}
func (o *DMA_Type) GetINTA0_IA11() uint32 {
	return (volatile.LoadUint32(&o.INTA0.Reg) & 0x800) >> 11
}
func (o *DMA_Type) SetINTA0_IA12(value uint32) {
	volatile.StoreUint32(&o.INTA0.Reg, volatile.LoadUint32(&o.INTA0.Reg)&^(0x1000)|value<<12)
}
func (o *DMA_Type) GetINTA0_IA12() uint32 {
	return (volatile.LoadUint32(&o.INTA0.Reg) & 0x1000) >> 12
}
func (o *DMA_Type) SetINTA0_IA13(value uint32) {
	volatile.StoreUint32(&o.INTA0.Reg, volatile.LoadUint32(&o.INTA0.Reg)&^(0x2000)|value<<13)
}
func (o *DMA_Type) GetINTA0_IA13() uint32 {
	return (volatile.LoadUint32(&o.INTA0.Reg) & 0x2000) >> 13
}
func (o *DMA_Type) SetINTA0_IA14(value uint32) {
	volatile.StoreUint32(&o.INTA0.Reg, volatile.LoadUint32(&o.INTA0.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetINTA0_IA14() uint32 {
	return (volatile.LoadUint32(&o.INTA0.Reg) & 0x4000) >> 14
}
func (o *DMA_Type) SetINTA0_IA15(value uint32) {
	volatile.StoreUint32(&o.INTA0.Reg, volatile.LoadUint32(&o.INTA0.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetINTA0_IA15() uint32 {
	return (volatile.LoadUint32(&o.INTA0.Reg) & 0x8000) >> 15
}
func (o *DMA_Type) SetINTA0_IA16(value uint32) {
	volatile.StoreUint32(&o.INTA0.Reg, volatile.LoadUint32(&o.INTA0.Reg)&^(0x10000)|value<<16)
}
func (o *DMA_Type) GetINTA0_IA16() uint32 {
	return (volatile.LoadUint32(&o.INTA0.Reg) & 0x10000) >> 16
}
func (o *DMA_Type) SetINTA0_IA17(value uint32) {
	volatile.StoreUint32(&o.INTA0.Reg, volatile.LoadUint32(&o.INTA0.Reg)&^(0x20000)|value<<17)
}
func (o *DMA_Type) GetINTA0_IA17() uint32 {
	return (volatile.LoadUint32(&o.INTA0.Reg) & 0x20000) >> 17
}
func (o *DMA_Type) SetINTA0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTA0.Reg, volatile.LoadUint32(&o.INTA0.Reg)&^(0xfffc0000)|value<<18)
}
func (o *DMA_Type) GetINTA0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTA0.Reg) & 0xfffc0000) >> 18
}

// DMA.INTB0: Interrupt B status for all DMA channels.
func (o *DMA_Type) SetINTB0_IB0(value uint32) {
	volatile.StoreUint32(&o.INTB0.Reg, volatile.LoadUint32(&o.INTB0.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetINTB0_IB0() uint32 {
	return volatile.LoadUint32(&o.INTB0.Reg) & 0x1
}
func (o *DMA_Type) SetINTB0_IB1(value uint32) {
	volatile.StoreUint32(&o.INTB0.Reg, volatile.LoadUint32(&o.INTB0.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetINTB0_IB1() uint32 {
	return (volatile.LoadUint32(&o.INTB0.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetINTB0_IB2(value uint32) {
	volatile.StoreUint32(&o.INTB0.Reg, volatile.LoadUint32(&o.INTB0.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetINTB0_IB2() uint32 {
	return (volatile.LoadUint32(&o.INTB0.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetINTB0_IB3(value uint32) {
	volatile.StoreUint32(&o.INTB0.Reg, volatile.LoadUint32(&o.INTB0.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetINTB0_IB3() uint32 {
	return (volatile.LoadUint32(&o.INTB0.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetINTB0_IB4(value uint32) {
	volatile.StoreUint32(&o.INTB0.Reg, volatile.LoadUint32(&o.INTB0.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetINTB0_IB4() uint32 {
	return (volatile.LoadUint32(&o.INTB0.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetINTB0_IB5(value uint32) {
	volatile.StoreUint32(&o.INTB0.Reg, volatile.LoadUint32(&o.INTB0.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetINTB0_IB5() uint32 {
	return (volatile.LoadUint32(&o.INTB0.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetINTB0_IB6(value uint32) {
	volatile.StoreUint32(&o.INTB0.Reg, volatile.LoadUint32(&o.INTB0.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetINTB0_IB6() uint32 {
	return (volatile.LoadUint32(&o.INTB0.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetINTB0_IB7(value uint32) {
	volatile.StoreUint32(&o.INTB0.Reg, volatile.LoadUint32(&o.INTB0.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetINTB0_IB7() uint32 {
	return (volatile.LoadUint32(&o.INTB0.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetINTB0_IB8(value uint32) {
	volatile.StoreUint32(&o.INTB0.Reg, volatile.LoadUint32(&o.INTB0.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetINTB0_IB8() uint32 {
	return (volatile.LoadUint32(&o.INTB0.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetINTB0_IB9(value uint32) {
	volatile.StoreUint32(&o.INTB0.Reg, volatile.LoadUint32(&o.INTB0.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetINTB0_IB9() uint32 {
	return (volatile.LoadUint32(&o.INTB0.Reg) & 0x200) >> 9
}
func (o *DMA_Type) SetINTB0_IB10(value uint32) {
	volatile.StoreUint32(&o.INTB0.Reg, volatile.LoadUint32(&o.INTB0.Reg)&^(0x400)|value<<10)
}
func (o *DMA_Type) GetINTB0_IB10() uint32 {
	return (volatile.LoadUint32(&o.INTB0.Reg) & 0x400) >> 10
}
func (o *DMA_Type) SetINTB0_IB11(value uint32) {
	volatile.StoreUint32(&o.INTB0.Reg, volatile.LoadUint32(&o.INTB0.Reg)&^(0x800)|value<<11)
}
func (o *DMA_Type) GetINTB0_IB11() uint32 {
	return (volatile.LoadUint32(&o.INTB0.Reg) & 0x800) >> 11
}
func (o *DMA_Type) SetINTB0_IB12(value uint32) {
	volatile.StoreUint32(&o.INTB0.Reg, volatile.LoadUint32(&o.INTB0.Reg)&^(0x1000)|value<<12)
}
func (o *DMA_Type) GetINTB0_IB12() uint32 {
	return (volatile.LoadUint32(&o.INTB0.Reg) & 0x1000) >> 12
}
func (o *DMA_Type) SetINTB0_IB13(value uint32) {
	volatile.StoreUint32(&o.INTB0.Reg, volatile.LoadUint32(&o.INTB0.Reg)&^(0x2000)|value<<13)
}
func (o *DMA_Type) GetINTB0_IB13() uint32 {
	return (volatile.LoadUint32(&o.INTB0.Reg) & 0x2000) >> 13
}
func (o *DMA_Type) SetINTB0_IB14(value uint32) {
	volatile.StoreUint32(&o.INTB0.Reg, volatile.LoadUint32(&o.INTB0.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetINTB0_IB14() uint32 {
	return (volatile.LoadUint32(&o.INTB0.Reg) & 0x4000) >> 14
}
func (o *DMA_Type) SetINTB0_IB15(value uint32) {
	volatile.StoreUint32(&o.INTB0.Reg, volatile.LoadUint32(&o.INTB0.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetINTB0_IB15() uint32 {
	return (volatile.LoadUint32(&o.INTB0.Reg) & 0x8000) >> 15
}
func (o *DMA_Type) SetINTB0_IB16(value uint32) {
	volatile.StoreUint32(&o.INTB0.Reg, volatile.LoadUint32(&o.INTB0.Reg)&^(0x10000)|value<<16)
}
func (o *DMA_Type) GetINTB0_IB16() uint32 {
	return (volatile.LoadUint32(&o.INTB0.Reg) & 0x10000) >> 16
}
func (o *DMA_Type) SetINTB0_IB17(value uint32) {
	volatile.StoreUint32(&o.INTB0.Reg, volatile.LoadUint32(&o.INTB0.Reg)&^(0x20000)|value<<17)
}
func (o *DMA_Type) GetINTB0_IB17() uint32 {
	return (volatile.LoadUint32(&o.INTB0.Reg) & 0x20000) >> 17
}
func (o *DMA_Type) SetINTB0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTB0.Reg, volatile.LoadUint32(&o.INTB0.Reg)&^(0xfffc0000)|value<<18)
}
func (o *DMA_Type) GetINTB0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTB0.Reg) & 0xfffc0000) >> 18
}

// DMA.SETVALID0: Set ValidPending control bits for all DMA channels.
func (o *DMA_Type) SetSETVALID0_SV0(value uint32) {
	volatile.StoreUint32(&o.SETVALID0.Reg, volatile.LoadUint32(&o.SETVALID0.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetSETVALID0_SV0() uint32 {
	return volatile.LoadUint32(&o.SETVALID0.Reg) & 0x1
}
func (o *DMA_Type) SetSETVALID0_SV1(value uint32) {
	volatile.StoreUint32(&o.SETVALID0.Reg, volatile.LoadUint32(&o.SETVALID0.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetSETVALID0_SV1() uint32 {
	return (volatile.LoadUint32(&o.SETVALID0.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetSETVALID0_SV2(value uint32) {
	volatile.StoreUint32(&o.SETVALID0.Reg, volatile.LoadUint32(&o.SETVALID0.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetSETVALID0_SV2() uint32 {
	return (volatile.LoadUint32(&o.SETVALID0.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetSETVALID0_SV3(value uint32) {
	volatile.StoreUint32(&o.SETVALID0.Reg, volatile.LoadUint32(&o.SETVALID0.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetSETVALID0_SV3() uint32 {
	return (volatile.LoadUint32(&o.SETVALID0.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetSETVALID0_SV4(value uint32) {
	volatile.StoreUint32(&o.SETVALID0.Reg, volatile.LoadUint32(&o.SETVALID0.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetSETVALID0_SV4() uint32 {
	return (volatile.LoadUint32(&o.SETVALID0.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetSETVALID0_SV5(value uint32) {
	volatile.StoreUint32(&o.SETVALID0.Reg, volatile.LoadUint32(&o.SETVALID0.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetSETVALID0_SV5() uint32 {
	return (volatile.LoadUint32(&o.SETVALID0.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetSETVALID0_SV6(value uint32) {
	volatile.StoreUint32(&o.SETVALID0.Reg, volatile.LoadUint32(&o.SETVALID0.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetSETVALID0_SV6() uint32 {
	return (volatile.LoadUint32(&o.SETVALID0.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetSETVALID0_SV7(value uint32) {
	volatile.StoreUint32(&o.SETVALID0.Reg, volatile.LoadUint32(&o.SETVALID0.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetSETVALID0_SV7() uint32 {
	return (volatile.LoadUint32(&o.SETVALID0.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetSETVALID0_SV8(value uint32) {
	volatile.StoreUint32(&o.SETVALID0.Reg, volatile.LoadUint32(&o.SETVALID0.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetSETVALID0_SV8() uint32 {
	return (volatile.LoadUint32(&o.SETVALID0.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetSETVALID0_SV9(value uint32) {
	volatile.StoreUint32(&o.SETVALID0.Reg, volatile.LoadUint32(&o.SETVALID0.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetSETVALID0_SV9() uint32 {
	return (volatile.LoadUint32(&o.SETVALID0.Reg) & 0x200) >> 9
}
func (o *DMA_Type) SetSETVALID0_SV10(value uint32) {
	volatile.StoreUint32(&o.SETVALID0.Reg, volatile.LoadUint32(&o.SETVALID0.Reg)&^(0x400)|value<<10)
}
func (o *DMA_Type) GetSETVALID0_SV10() uint32 {
	return (volatile.LoadUint32(&o.SETVALID0.Reg) & 0x400) >> 10
}
func (o *DMA_Type) SetSETVALID0_SV11(value uint32) {
	volatile.StoreUint32(&o.SETVALID0.Reg, volatile.LoadUint32(&o.SETVALID0.Reg)&^(0x800)|value<<11)
}
func (o *DMA_Type) GetSETVALID0_SV11() uint32 {
	return (volatile.LoadUint32(&o.SETVALID0.Reg) & 0x800) >> 11
}
func (o *DMA_Type) SetSETVALID0_SV12(value uint32) {
	volatile.StoreUint32(&o.SETVALID0.Reg, volatile.LoadUint32(&o.SETVALID0.Reg)&^(0x1000)|value<<12)
}
func (o *DMA_Type) GetSETVALID0_SV12() uint32 {
	return (volatile.LoadUint32(&o.SETVALID0.Reg) & 0x1000) >> 12
}
func (o *DMA_Type) SetSETVALID0_SV13(value uint32) {
	volatile.StoreUint32(&o.SETVALID0.Reg, volatile.LoadUint32(&o.SETVALID0.Reg)&^(0x2000)|value<<13)
}
func (o *DMA_Type) GetSETVALID0_SV13() uint32 {
	return (volatile.LoadUint32(&o.SETVALID0.Reg) & 0x2000) >> 13
}
func (o *DMA_Type) SetSETVALID0_SV14(value uint32) {
	volatile.StoreUint32(&o.SETVALID0.Reg, volatile.LoadUint32(&o.SETVALID0.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetSETVALID0_SV14() uint32 {
	return (volatile.LoadUint32(&o.SETVALID0.Reg) & 0x4000) >> 14
}
func (o *DMA_Type) SetSETVALID0_SV15(value uint32) {
	volatile.StoreUint32(&o.SETVALID0.Reg, volatile.LoadUint32(&o.SETVALID0.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetSETVALID0_SV15() uint32 {
	return (volatile.LoadUint32(&o.SETVALID0.Reg) & 0x8000) >> 15
}
func (o *DMA_Type) SetSETVALID0_SV16(value uint32) {
	volatile.StoreUint32(&o.SETVALID0.Reg, volatile.LoadUint32(&o.SETVALID0.Reg)&^(0x10000)|value<<16)
}
func (o *DMA_Type) GetSETVALID0_SV16() uint32 {
	return (volatile.LoadUint32(&o.SETVALID0.Reg) & 0x10000) >> 16
}
func (o *DMA_Type) SetSETVALID0_SV17(value uint32) {
	volatile.StoreUint32(&o.SETVALID0.Reg, volatile.LoadUint32(&o.SETVALID0.Reg)&^(0x20000)|value<<17)
}
func (o *DMA_Type) GetSETVALID0_SV17() uint32 {
	return (volatile.LoadUint32(&o.SETVALID0.Reg) & 0x20000) >> 17
}
func (o *DMA_Type) SetSETVALID0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SETVALID0.Reg, volatile.LoadUint32(&o.SETVALID0.Reg)&^(0xfffc0000)|value<<18)
}
func (o *DMA_Type) GetSETVALID0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SETVALID0.Reg) & 0xfffc0000) >> 18
}

// DMA.SETTRIG0: Set Trigger control bits for all DMA channels.
func (o *DMA_Type) SetSETTRIG0(value uint32) {
	volatile.StoreUint32(&o.SETTRIG0.Reg, volatile.LoadUint32(&o.SETTRIG0.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetSETTRIG0() uint32 {
	return volatile.LoadUint32(&o.SETTRIG0.Reg) & 0x1
}
func (o *DMA_Type) SetSETTRIG0_SETTRIG1(value uint32) {
	volatile.StoreUint32(&o.SETTRIG0.Reg, volatile.LoadUint32(&o.SETTRIG0.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetSETTRIG0_SETTRIG1() uint32 {
	return (volatile.LoadUint32(&o.SETTRIG0.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetSETTRIG0_SETTRIG2(value uint32) {
	volatile.StoreUint32(&o.SETTRIG0.Reg, volatile.LoadUint32(&o.SETTRIG0.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetSETTRIG0_SETTRIG2() uint32 {
	return (volatile.LoadUint32(&o.SETTRIG0.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetSETTRIG0_SETTRIG3(value uint32) {
	volatile.StoreUint32(&o.SETTRIG0.Reg, volatile.LoadUint32(&o.SETTRIG0.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetSETTRIG0_SETTRIG3() uint32 {
	return (volatile.LoadUint32(&o.SETTRIG0.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetSETTRIG0_SETTRIG4(value uint32) {
	volatile.StoreUint32(&o.SETTRIG0.Reg, volatile.LoadUint32(&o.SETTRIG0.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetSETTRIG0_SETTRIG4() uint32 {
	return (volatile.LoadUint32(&o.SETTRIG0.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetSETTRIG0_SETTRIG5(value uint32) {
	volatile.StoreUint32(&o.SETTRIG0.Reg, volatile.LoadUint32(&o.SETTRIG0.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetSETTRIG0_SETTRIG5() uint32 {
	return (volatile.LoadUint32(&o.SETTRIG0.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetSETTRIG0_SETTRIG6(value uint32) {
	volatile.StoreUint32(&o.SETTRIG0.Reg, volatile.LoadUint32(&o.SETTRIG0.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetSETTRIG0_SETTRIG6() uint32 {
	return (volatile.LoadUint32(&o.SETTRIG0.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetSETTRIG0_SETTRIG7(value uint32) {
	volatile.StoreUint32(&o.SETTRIG0.Reg, volatile.LoadUint32(&o.SETTRIG0.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetSETTRIG0_SETTRIG7() uint32 {
	return (volatile.LoadUint32(&o.SETTRIG0.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetSETTRIG0_SETTRIG8(value uint32) {
	volatile.StoreUint32(&o.SETTRIG0.Reg, volatile.LoadUint32(&o.SETTRIG0.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetSETTRIG0_SETTRIG8() uint32 {
	return (volatile.LoadUint32(&o.SETTRIG0.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetSETTRIG0_SETTRIG9(value uint32) {
	volatile.StoreUint32(&o.SETTRIG0.Reg, volatile.LoadUint32(&o.SETTRIG0.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetSETTRIG0_SETTRIG9() uint32 {
	return (volatile.LoadUint32(&o.SETTRIG0.Reg) & 0x200) >> 9
}
func (o *DMA_Type) SetSETTRIG0_SETTRIG10(value uint32) {
	volatile.StoreUint32(&o.SETTRIG0.Reg, volatile.LoadUint32(&o.SETTRIG0.Reg)&^(0x400)|value<<10)
}
func (o *DMA_Type) GetSETTRIG0_SETTRIG10() uint32 {
	return (volatile.LoadUint32(&o.SETTRIG0.Reg) & 0x400) >> 10
}
func (o *DMA_Type) SetSETTRIG0_SETTRIG11(value uint32) {
	volatile.StoreUint32(&o.SETTRIG0.Reg, volatile.LoadUint32(&o.SETTRIG0.Reg)&^(0x800)|value<<11)
}
func (o *DMA_Type) GetSETTRIG0_SETTRIG11() uint32 {
	return (volatile.LoadUint32(&o.SETTRIG0.Reg) & 0x800) >> 11
}
func (o *DMA_Type) SetSETTRIG0_SETTRIG12(value uint32) {
	volatile.StoreUint32(&o.SETTRIG0.Reg, volatile.LoadUint32(&o.SETTRIG0.Reg)&^(0x1000)|value<<12)
}
func (o *DMA_Type) GetSETTRIG0_SETTRIG12() uint32 {
	return (volatile.LoadUint32(&o.SETTRIG0.Reg) & 0x1000) >> 12
}
func (o *DMA_Type) SetSETTRIG0_SETTRIG13(value uint32) {
	volatile.StoreUint32(&o.SETTRIG0.Reg, volatile.LoadUint32(&o.SETTRIG0.Reg)&^(0x2000)|value<<13)
}
func (o *DMA_Type) GetSETTRIG0_SETTRIG13() uint32 {
	return (volatile.LoadUint32(&o.SETTRIG0.Reg) & 0x2000) >> 13
}
func (o *DMA_Type) SetSETTRIG0_SETTRIG14(value uint32) {
	volatile.StoreUint32(&o.SETTRIG0.Reg, volatile.LoadUint32(&o.SETTRIG0.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetSETTRIG0_SETTRIG14() uint32 {
	return (volatile.LoadUint32(&o.SETTRIG0.Reg) & 0x4000) >> 14
}
func (o *DMA_Type) SetSETTRIG0_SETTRIG15(value uint32) {
	volatile.StoreUint32(&o.SETTRIG0.Reg, volatile.LoadUint32(&o.SETTRIG0.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetSETTRIG0_SETTRIG15() uint32 {
	return (volatile.LoadUint32(&o.SETTRIG0.Reg) & 0x8000) >> 15
}
func (o *DMA_Type) SetSETTRIG0_SETTRIG16(value uint32) {
	volatile.StoreUint32(&o.SETTRIG0.Reg, volatile.LoadUint32(&o.SETTRIG0.Reg)&^(0x10000)|value<<16)
}
func (o *DMA_Type) GetSETTRIG0_SETTRIG16() uint32 {
	return (volatile.LoadUint32(&o.SETTRIG0.Reg) & 0x10000) >> 16
}
func (o *DMA_Type) SetSETTRIG0_SETTRIG17(value uint32) {
	volatile.StoreUint32(&o.SETTRIG0.Reg, volatile.LoadUint32(&o.SETTRIG0.Reg)&^(0x20000)|value<<17)
}
func (o *DMA_Type) GetSETTRIG0_SETTRIG17() uint32 {
	return (volatile.LoadUint32(&o.SETTRIG0.Reg) & 0x20000) >> 17
}
func (o *DMA_Type) SetSETTRIG0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SETTRIG0.Reg, volatile.LoadUint32(&o.SETTRIG0.Reg)&^(0xfffc0000)|value<<18)
}
func (o *DMA_Type) GetSETTRIG0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SETTRIG0.Reg) & 0xfffc0000) >> 18
}

// DMA.ABORT0: Channel Abort control for all DMA channels.
func (o *DMA_Type) SetABORT0_AORTCTRL0(value uint32) {
	volatile.StoreUint32(&o.ABORT0.Reg, volatile.LoadUint32(&o.ABORT0.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetABORT0_AORTCTRL0() uint32 {
	return volatile.LoadUint32(&o.ABORT0.Reg) & 0x1
}
func (o *DMA_Type) SetABORT0_AORTCTRL1(value uint32) {
	volatile.StoreUint32(&o.ABORT0.Reg, volatile.LoadUint32(&o.ABORT0.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetABORT0_AORTCTRL1() uint32 {
	return (volatile.LoadUint32(&o.ABORT0.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetABORT0_AORTCTRL2(value uint32) {
	volatile.StoreUint32(&o.ABORT0.Reg, volatile.LoadUint32(&o.ABORT0.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetABORT0_AORTCTRL2() uint32 {
	return (volatile.LoadUint32(&o.ABORT0.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetABORT0_AORTCTRL3(value uint32) {
	volatile.StoreUint32(&o.ABORT0.Reg, volatile.LoadUint32(&o.ABORT0.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetABORT0_AORTCTRL3() uint32 {
	return (volatile.LoadUint32(&o.ABORT0.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetABORT0_AORTCTRL4(value uint32) {
	volatile.StoreUint32(&o.ABORT0.Reg, volatile.LoadUint32(&o.ABORT0.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetABORT0_AORTCTRL4() uint32 {
	return (volatile.LoadUint32(&o.ABORT0.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetABORT0_AORTCTRL5(value uint32) {
	volatile.StoreUint32(&o.ABORT0.Reg, volatile.LoadUint32(&o.ABORT0.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetABORT0_AORTCTRL5() uint32 {
	return (volatile.LoadUint32(&o.ABORT0.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetABORT0_AORTCTRL6(value uint32) {
	volatile.StoreUint32(&o.ABORT0.Reg, volatile.LoadUint32(&o.ABORT0.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetABORT0_AORTCTRL6() uint32 {
	return (volatile.LoadUint32(&o.ABORT0.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetABORT0_AORTCTRL7(value uint32) {
	volatile.StoreUint32(&o.ABORT0.Reg, volatile.LoadUint32(&o.ABORT0.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetABORT0_AORTCTRL7() uint32 {
	return (volatile.LoadUint32(&o.ABORT0.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetABORT0_AORTCTRL8(value uint32) {
	volatile.StoreUint32(&o.ABORT0.Reg, volatile.LoadUint32(&o.ABORT0.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetABORT0_AORTCTRL8() uint32 {
	return (volatile.LoadUint32(&o.ABORT0.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetABORT0_AORTCTRL9(value uint32) {
	volatile.StoreUint32(&o.ABORT0.Reg, volatile.LoadUint32(&o.ABORT0.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetABORT0_AORTCTRL9() uint32 {
	return (volatile.LoadUint32(&o.ABORT0.Reg) & 0x200) >> 9
}
func (o *DMA_Type) SetABORT0_AORTCTRL10(value uint32) {
	volatile.StoreUint32(&o.ABORT0.Reg, volatile.LoadUint32(&o.ABORT0.Reg)&^(0x400)|value<<10)
}
func (o *DMA_Type) GetABORT0_AORTCTRL10() uint32 {
	return (volatile.LoadUint32(&o.ABORT0.Reg) & 0x400) >> 10
}
func (o *DMA_Type) SetABORT0_AORTCTRL11(value uint32) {
	volatile.StoreUint32(&o.ABORT0.Reg, volatile.LoadUint32(&o.ABORT0.Reg)&^(0x800)|value<<11)
}
func (o *DMA_Type) GetABORT0_AORTCTRL11() uint32 {
	return (volatile.LoadUint32(&o.ABORT0.Reg) & 0x800) >> 11
}
func (o *DMA_Type) SetABORT0_AORTCTRL12(value uint32) {
	volatile.StoreUint32(&o.ABORT0.Reg, volatile.LoadUint32(&o.ABORT0.Reg)&^(0x1000)|value<<12)
}
func (o *DMA_Type) GetABORT0_AORTCTRL12() uint32 {
	return (volatile.LoadUint32(&o.ABORT0.Reg) & 0x1000) >> 12
}
func (o *DMA_Type) SetABORT0_AORTCTRL13(value uint32) {
	volatile.StoreUint32(&o.ABORT0.Reg, volatile.LoadUint32(&o.ABORT0.Reg)&^(0x2000)|value<<13)
}
func (o *DMA_Type) GetABORT0_AORTCTRL13() uint32 {
	return (volatile.LoadUint32(&o.ABORT0.Reg) & 0x2000) >> 13
}
func (o *DMA_Type) SetABORT0_AORTCTRL14(value uint32) {
	volatile.StoreUint32(&o.ABORT0.Reg, volatile.LoadUint32(&o.ABORT0.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetABORT0_AORTCTRL14() uint32 {
	return (volatile.LoadUint32(&o.ABORT0.Reg) & 0x4000) >> 14
}
func (o *DMA_Type) SetABORT0_AORTCTRL15(value uint32) {
	volatile.StoreUint32(&o.ABORT0.Reg, volatile.LoadUint32(&o.ABORT0.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetABORT0_AORTCTRL15() uint32 {
	return (volatile.LoadUint32(&o.ABORT0.Reg) & 0x8000) >> 15
}
func (o *DMA_Type) SetABORT0_AORTCTRL16(value uint32) {
	volatile.StoreUint32(&o.ABORT0.Reg, volatile.LoadUint32(&o.ABORT0.Reg)&^(0x10000)|value<<16)
}
func (o *DMA_Type) GetABORT0_AORTCTRL16() uint32 {
	return (volatile.LoadUint32(&o.ABORT0.Reg) & 0x10000) >> 16
}
func (o *DMA_Type) SetABORT0_AORTCTRL17(value uint32) {
	volatile.StoreUint32(&o.ABORT0.Reg, volatile.LoadUint32(&o.ABORT0.Reg)&^(0x20000)|value<<17)
}
func (o *DMA_Type) GetABORT0_AORTCTRL17() uint32 {
	return (volatile.LoadUint32(&o.ABORT0.Reg) & 0x20000) >> 17
}
func (o *DMA_Type) SetABORT0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ABORT0.Reg, volatile.LoadUint32(&o.ABORT0.Reg)&^(0xfffc0000)|value<<18)
}
func (o *DMA_Type) GetABORT0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ABORT0.Reg) & 0xfffc0000) >> 18
}

// DMA.CFG0: Configuration register for DMA channel 0.
func (o *DMA_Type) SetCFG0_PERIPHREQEN(value uint32) {
	volatile.StoreUint32(&o.CFG0.Reg, volatile.LoadUint32(&o.CFG0.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCFG0_PERIPHREQEN() uint32 {
	return volatile.LoadUint32(&o.CFG0.Reg) & 0x1
}
func (o *DMA_Type) SetCFG0_HWTRIGEN(value uint32) {
	volatile.StoreUint32(&o.CFG0.Reg, volatile.LoadUint32(&o.CFG0.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCFG0_HWTRIGEN() uint32 {
	return (volatile.LoadUint32(&o.CFG0.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCFG0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG0.Reg, volatile.LoadUint32(&o.CFG0.Reg)&^(0xc)|value<<2)
}
func (o *DMA_Type) GetCFG0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG0.Reg) & 0xc) >> 2
}
func (o *DMA_Type) SetCFG0_TRIGPOL(value uint32) {
	volatile.StoreUint32(&o.CFG0.Reg, volatile.LoadUint32(&o.CFG0.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetCFG0_TRIGPOL() uint32 {
	return (volatile.LoadUint32(&o.CFG0.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetCFG0_TRIGTYPE(value uint32) {
	volatile.StoreUint32(&o.CFG0.Reg, volatile.LoadUint32(&o.CFG0.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetCFG0_TRIGTYPE() uint32 {
	return (volatile.LoadUint32(&o.CFG0.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetCFG0_TRIGBURST(value uint32) {
	volatile.StoreUint32(&o.CFG0.Reg, volatile.LoadUint32(&o.CFG0.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetCFG0_TRIGBURST() uint32 {
	return (volatile.LoadUint32(&o.CFG0.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetCFG0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG0.Reg, volatile.LoadUint32(&o.CFG0.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetCFG0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG0.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetCFG0_BURSTPOWER(value uint32) {
	volatile.StoreUint32(&o.CFG0.Reg, volatile.LoadUint32(&o.CFG0.Reg)&^(0xf00)|value<<8)
}
func (o *DMA_Type) GetCFG0_BURSTPOWER() uint32 {
	return (volatile.LoadUint32(&o.CFG0.Reg) & 0xf00) >> 8
}
func (o *DMA_Type) SetCFG0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG0.Reg, volatile.LoadUint32(&o.CFG0.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetCFG0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG0.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetCFG0_SRCBURSTWRAP(value uint32) {
	volatile.StoreUint32(&o.CFG0.Reg, volatile.LoadUint32(&o.CFG0.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetCFG0_SRCBURSTWRAP() uint32 {
	return (volatile.LoadUint32(&o.CFG0.Reg) & 0x4000) >> 14
}
func (o *DMA_Type) SetCFG0_DSTBURSTWRAP(value uint32) {
	volatile.StoreUint32(&o.CFG0.Reg, volatile.LoadUint32(&o.CFG0.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetCFG0_DSTBURSTWRAP() uint32 {
	return (volatile.LoadUint32(&o.CFG0.Reg) & 0x8000) >> 15
}
func (o *DMA_Type) SetCFG0_CHPRIORITY(value uint32) {
	volatile.StoreUint32(&o.CFG0.Reg, volatile.LoadUint32(&o.CFG0.Reg)&^(0x70000)|value<<16)
}
func (o *DMA_Type) GetCFG0_CHPRIORITY() uint32 {
	return (volatile.LoadUint32(&o.CFG0.Reg) & 0x70000) >> 16
}
func (o *DMA_Type) SetCFG0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG0.Reg, volatile.LoadUint32(&o.CFG0.Reg)&^(0xfff80000)|value<<19)
}
func (o *DMA_Type) GetCFG0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG0.Reg) & 0xfff80000) >> 19
}

// DMA.CTLSTAT0: Control and status register for DMA channel 0.
func (o *DMA_Type) SetCTLSTAT0_VALIDPENDING(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT0.Reg, volatile.LoadUint32(&o.CTLSTAT0.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCTLSTAT0_VALIDPENDING() uint32 {
	return volatile.LoadUint32(&o.CTLSTAT0.Reg) & 0x1
}
func (o *DMA_Type) SetCTLSTAT0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT0.Reg, volatile.LoadUint32(&o.CTLSTAT0.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCTLSTAT0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTLSTAT0.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCTLSTAT0_TRIG(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT0.Reg, volatile.LoadUint32(&o.CTLSTAT0.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetCTLSTAT0_TRIG() uint32 {
	return (volatile.LoadUint32(&o.CTLSTAT0.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetCTLSTAT0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT0.Reg, volatile.LoadUint32(&o.CTLSTAT0.Reg)&^(0xfffffff8)|value<<3)
}
func (o *DMA_Type) GetCTLSTAT0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTLSTAT0.Reg) & 0xfffffff8) >> 3
}

// DMA.XFERCFG0: Transfer configuration register for DMA channel 0.
func (o *DMA_Type) SetXFERCFG0_CFGVALID(value uint32) {
	volatile.StoreUint32(&o.XFERCFG0.Reg, volatile.LoadUint32(&o.XFERCFG0.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetXFERCFG0_CFGVALID() uint32 {
	return volatile.LoadUint32(&o.XFERCFG0.Reg) & 0x1
}
func (o *DMA_Type) SetXFERCFG0_RELOAD(value uint32) {
	volatile.StoreUint32(&o.XFERCFG0.Reg, volatile.LoadUint32(&o.XFERCFG0.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetXFERCFG0_RELOAD() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG0.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetXFERCFG0_SWTRIG(value uint32) {
	volatile.StoreUint32(&o.XFERCFG0.Reg, volatile.LoadUint32(&o.XFERCFG0.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetXFERCFG0_SWTRIG() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG0.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetXFERCFG0_CLRTRIG(value uint32) {
	volatile.StoreUint32(&o.XFERCFG0.Reg, volatile.LoadUint32(&o.XFERCFG0.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetXFERCFG0_CLRTRIG() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG0.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetXFERCFG0_SETINTA(value uint32) {
	volatile.StoreUint32(&o.XFERCFG0.Reg, volatile.LoadUint32(&o.XFERCFG0.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetXFERCFG0_SETINTA() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG0.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetXFERCFG0_SETINTB(value uint32) {
	volatile.StoreUint32(&o.XFERCFG0.Reg, volatile.LoadUint32(&o.XFERCFG0.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetXFERCFG0_SETINTB() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG0.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetXFERCFG0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.XFERCFG0.Reg, volatile.LoadUint32(&o.XFERCFG0.Reg)&^(0xc0)|value<<6)
}
func (o *DMA_Type) GetXFERCFG0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG0.Reg) & 0xc0) >> 6
}
func (o *DMA_Type) SetXFERCFG0_WIDTH(value uint32) {
	volatile.StoreUint32(&o.XFERCFG0.Reg, volatile.LoadUint32(&o.XFERCFG0.Reg)&^(0x300)|value<<8)
}
func (o *DMA_Type) GetXFERCFG0_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG0.Reg) & 0x300) >> 8
}
func (o *DMA_Type) SetXFERCFG0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.XFERCFG0.Reg, volatile.LoadUint32(&o.XFERCFG0.Reg)&^(0xc00)|value<<10)
}
func (o *DMA_Type) GetXFERCFG0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG0.Reg) & 0xc00) >> 10
}
func (o *DMA_Type) SetXFERCFG0_SRCINC(value uint32) {
	volatile.StoreUint32(&o.XFERCFG0.Reg, volatile.LoadUint32(&o.XFERCFG0.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetXFERCFG0_SRCINC() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG0.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetXFERCFG0_DSTINC(value uint32) {
	volatile.StoreUint32(&o.XFERCFG0.Reg, volatile.LoadUint32(&o.XFERCFG0.Reg)&^(0xc000)|value<<14)
}
func (o *DMA_Type) GetXFERCFG0_DSTINC() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG0.Reg) & 0xc000) >> 14
}
func (o *DMA_Type) SetXFERCFG0_XFERCOUNT(value uint32) {
	volatile.StoreUint32(&o.XFERCFG0.Reg, volatile.LoadUint32(&o.XFERCFG0.Reg)&^(0x3ff0000)|value<<16)
}
func (o *DMA_Type) GetXFERCFG0_XFERCOUNT() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG0.Reg) & 0x3ff0000) >> 16
}
func (o *DMA_Type) SetXFERCFG0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.XFERCFG0.Reg, volatile.LoadUint32(&o.XFERCFG0.Reg)&^(0xfc000000)|value<<26)
}
func (o *DMA_Type) GetXFERCFG0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG0.Reg) & 0xfc000000) >> 26
}

// DMA.CFG1: Configuration register for DMA channel 0.
func (o *DMA_Type) SetCFG1_PERIPHREQEN(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCFG1_PERIPHREQEN() uint32 {
	return volatile.LoadUint32(&o.CFG1.Reg) & 0x1
}
func (o *DMA_Type) SetCFG1_HWTRIGEN(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCFG1_HWTRIGEN() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCFG1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0xc)|value<<2)
}
func (o *DMA_Type) GetCFG1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0xc) >> 2
}
func (o *DMA_Type) SetCFG1_TRIGPOL(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetCFG1_TRIGPOL() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetCFG1_TRIGTYPE(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetCFG1_TRIGTYPE() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetCFG1_TRIGBURST(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetCFG1_TRIGBURST() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetCFG1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetCFG1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetCFG1_BURSTPOWER(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0xf00)|value<<8)
}
func (o *DMA_Type) GetCFG1_BURSTPOWER() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0xf00) >> 8
}
func (o *DMA_Type) SetCFG1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetCFG1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetCFG1_SRCBURSTWRAP(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetCFG1_SRCBURSTWRAP() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x4000) >> 14
}
func (o *DMA_Type) SetCFG1_DSTBURSTWRAP(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetCFG1_DSTBURSTWRAP() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x8000) >> 15
}
func (o *DMA_Type) SetCFG1_CHPRIORITY(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x70000)|value<<16)
}
func (o *DMA_Type) GetCFG1_CHPRIORITY() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x70000) >> 16
}
func (o *DMA_Type) SetCFG1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0xfff80000)|value<<19)
}
func (o *DMA_Type) GetCFG1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0xfff80000) >> 19
}

// DMA.CTLSTAT1: Control and status register for DMA channel 0.
func (o *DMA_Type) SetCTLSTAT1_VALIDPENDING(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT1.Reg, volatile.LoadUint32(&o.CTLSTAT1.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCTLSTAT1_VALIDPENDING() uint32 {
	return volatile.LoadUint32(&o.CTLSTAT1.Reg) & 0x1
}
func (o *DMA_Type) SetCTLSTAT1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT1.Reg, volatile.LoadUint32(&o.CTLSTAT1.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCTLSTAT1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTLSTAT1.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCTLSTAT1_TRIG(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT1.Reg, volatile.LoadUint32(&o.CTLSTAT1.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetCTLSTAT1_TRIG() uint32 {
	return (volatile.LoadUint32(&o.CTLSTAT1.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetCTLSTAT1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT1.Reg, volatile.LoadUint32(&o.CTLSTAT1.Reg)&^(0xfffffff8)|value<<3)
}
func (o *DMA_Type) GetCTLSTAT1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTLSTAT1.Reg) & 0xfffffff8) >> 3
}

// DMA.XFERCFG1: Transfer configuration register for DMA channel 0.
func (o *DMA_Type) SetXFERCFG1_CFGVALID(value uint32) {
	volatile.StoreUint32(&o.XFERCFG1.Reg, volatile.LoadUint32(&o.XFERCFG1.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetXFERCFG1_CFGVALID() uint32 {
	return volatile.LoadUint32(&o.XFERCFG1.Reg) & 0x1
}
func (o *DMA_Type) SetXFERCFG1_RELOAD(value uint32) {
	volatile.StoreUint32(&o.XFERCFG1.Reg, volatile.LoadUint32(&o.XFERCFG1.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetXFERCFG1_RELOAD() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG1.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetXFERCFG1_SWTRIG(value uint32) {
	volatile.StoreUint32(&o.XFERCFG1.Reg, volatile.LoadUint32(&o.XFERCFG1.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetXFERCFG1_SWTRIG() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG1.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetXFERCFG1_CLRTRIG(value uint32) {
	volatile.StoreUint32(&o.XFERCFG1.Reg, volatile.LoadUint32(&o.XFERCFG1.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetXFERCFG1_CLRTRIG() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG1.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetXFERCFG1_SETINTA(value uint32) {
	volatile.StoreUint32(&o.XFERCFG1.Reg, volatile.LoadUint32(&o.XFERCFG1.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetXFERCFG1_SETINTA() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG1.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetXFERCFG1_SETINTB(value uint32) {
	volatile.StoreUint32(&o.XFERCFG1.Reg, volatile.LoadUint32(&o.XFERCFG1.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetXFERCFG1_SETINTB() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG1.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetXFERCFG1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.XFERCFG1.Reg, volatile.LoadUint32(&o.XFERCFG1.Reg)&^(0xc0)|value<<6)
}
func (o *DMA_Type) GetXFERCFG1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG1.Reg) & 0xc0) >> 6
}
func (o *DMA_Type) SetXFERCFG1_WIDTH(value uint32) {
	volatile.StoreUint32(&o.XFERCFG1.Reg, volatile.LoadUint32(&o.XFERCFG1.Reg)&^(0x300)|value<<8)
}
func (o *DMA_Type) GetXFERCFG1_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG1.Reg) & 0x300) >> 8
}
func (o *DMA_Type) SetXFERCFG1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.XFERCFG1.Reg, volatile.LoadUint32(&o.XFERCFG1.Reg)&^(0xc00)|value<<10)
}
func (o *DMA_Type) GetXFERCFG1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG1.Reg) & 0xc00) >> 10
}
func (o *DMA_Type) SetXFERCFG1_SRCINC(value uint32) {
	volatile.StoreUint32(&o.XFERCFG1.Reg, volatile.LoadUint32(&o.XFERCFG1.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetXFERCFG1_SRCINC() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG1.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetXFERCFG1_DSTINC(value uint32) {
	volatile.StoreUint32(&o.XFERCFG1.Reg, volatile.LoadUint32(&o.XFERCFG1.Reg)&^(0xc000)|value<<14)
}
func (o *DMA_Type) GetXFERCFG1_DSTINC() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG1.Reg) & 0xc000) >> 14
}
func (o *DMA_Type) SetXFERCFG1_XFERCOUNT(value uint32) {
	volatile.StoreUint32(&o.XFERCFG1.Reg, volatile.LoadUint32(&o.XFERCFG1.Reg)&^(0x3ff0000)|value<<16)
}
func (o *DMA_Type) GetXFERCFG1_XFERCOUNT() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG1.Reg) & 0x3ff0000) >> 16
}
func (o *DMA_Type) SetXFERCFG1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.XFERCFG1.Reg, volatile.LoadUint32(&o.XFERCFG1.Reg)&^(0xfc000000)|value<<26)
}
func (o *DMA_Type) GetXFERCFG1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG1.Reg) & 0xfc000000) >> 26
}

// DMA.CFG2: Configuration register for DMA channel 0.
func (o *DMA_Type) SetCFG2_PERIPHREQEN(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCFG2_PERIPHREQEN() uint32 {
	return volatile.LoadUint32(&o.CFG2.Reg) & 0x1
}
func (o *DMA_Type) SetCFG2_HWTRIGEN(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCFG2_HWTRIGEN() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCFG2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0xc)|value<<2)
}
func (o *DMA_Type) GetCFG2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0xc) >> 2
}
func (o *DMA_Type) SetCFG2_TRIGPOL(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetCFG2_TRIGPOL() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetCFG2_TRIGTYPE(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetCFG2_TRIGTYPE() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetCFG2_TRIGBURST(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetCFG2_TRIGBURST() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetCFG2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetCFG2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetCFG2_BURSTPOWER(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0xf00)|value<<8)
}
func (o *DMA_Type) GetCFG2_BURSTPOWER() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0xf00) >> 8
}
func (o *DMA_Type) SetCFG2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetCFG2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetCFG2_SRCBURSTWRAP(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetCFG2_SRCBURSTWRAP() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x4000) >> 14
}
func (o *DMA_Type) SetCFG2_DSTBURSTWRAP(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetCFG2_DSTBURSTWRAP() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x8000) >> 15
}
func (o *DMA_Type) SetCFG2_CHPRIORITY(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x70000)|value<<16)
}
func (o *DMA_Type) GetCFG2_CHPRIORITY() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x70000) >> 16
}
func (o *DMA_Type) SetCFG2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0xfff80000)|value<<19)
}
func (o *DMA_Type) GetCFG2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0xfff80000) >> 19
}

// DMA.CTLSTAT2: Control and status register for DMA channel 0.
func (o *DMA_Type) SetCTLSTAT2_VALIDPENDING(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT2.Reg, volatile.LoadUint32(&o.CTLSTAT2.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCTLSTAT2_VALIDPENDING() uint32 {
	return volatile.LoadUint32(&o.CTLSTAT2.Reg) & 0x1
}
func (o *DMA_Type) SetCTLSTAT2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT2.Reg, volatile.LoadUint32(&o.CTLSTAT2.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCTLSTAT2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTLSTAT2.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCTLSTAT2_TRIG(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT2.Reg, volatile.LoadUint32(&o.CTLSTAT2.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetCTLSTAT2_TRIG() uint32 {
	return (volatile.LoadUint32(&o.CTLSTAT2.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetCTLSTAT2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT2.Reg, volatile.LoadUint32(&o.CTLSTAT2.Reg)&^(0xfffffff8)|value<<3)
}
func (o *DMA_Type) GetCTLSTAT2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTLSTAT2.Reg) & 0xfffffff8) >> 3
}

// DMA.XFERCFG2: Transfer configuration register for DMA channel 0.
func (o *DMA_Type) SetXFERCFG2_CFGVALID(value uint32) {
	volatile.StoreUint32(&o.XFERCFG2.Reg, volatile.LoadUint32(&o.XFERCFG2.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetXFERCFG2_CFGVALID() uint32 {
	return volatile.LoadUint32(&o.XFERCFG2.Reg) & 0x1
}
func (o *DMA_Type) SetXFERCFG2_RELOAD(value uint32) {
	volatile.StoreUint32(&o.XFERCFG2.Reg, volatile.LoadUint32(&o.XFERCFG2.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetXFERCFG2_RELOAD() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG2.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetXFERCFG2_SWTRIG(value uint32) {
	volatile.StoreUint32(&o.XFERCFG2.Reg, volatile.LoadUint32(&o.XFERCFG2.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetXFERCFG2_SWTRIG() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG2.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetXFERCFG2_CLRTRIG(value uint32) {
	volatile.StoreUint32(&o.XFERCFG2.Reg, volatile.LoadUint32(&o.XFERCFG2.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetXFERCFG2_CLRTRIG() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG2.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetXFERCFG2_SETINTA(value uint32) {
	volatile.StoreUint32(&o.XFERCFG2.Reg, volatile.LoadUint32(&o.XFERCFG2.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetXFERCFG2_SETINTA() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG2.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetXFERCFG2_SETINTB(value uint32) {
	volatile.StoreUint32(&o.XFERCFG2.Reg, volatile.LoadUint32(&o.XFERCFG2.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetXFERCFG2_SETINTB() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG2.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetXFERCFG2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.XFERCFG2.Reg, volatile.LoadUint32(&o.XFERCFG2.Reg)&^(0xc0)|value<<6)
}
func (o *DMA_Type) GetXFERCFG2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG2.Reg) & 0xc0) >> 6
}
func (o *DMA_Type) SetXFERCFG2_WIDTH(value uint32) {
	volatile.StoreUint32(&o.XFERCFG2.Reg, volatile.LoadUint32(&o.XFERCFG2.Reg)&^(0x300)|value<<8)
}
func (o *DMA_Type) GetXFERCFG2_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG2.Reg) & 0x300) >> 8
}
func (o *DMA_Type) SetXFERCFG2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.XFERCFG2.Reg, volatile.LoadUint32(&o.XFERCFG2.Reg)&^(0xc00)|value<<10)
}
func (o *DMA_Type) GetXFERCFG2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG2.Reg) & 0xc00) >> 10
}
func (o *DMA_Type) SetXFERCFG2_SRCINC(value uint32) {
	volatile.StoreUint32(&o.XFERCFG2.Reg, volatile.LoadUint32(&o.XFERCFG2.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetXFERCFG2_SRCINC() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG2.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetXFERCFG2_DSTINC(value uint32) {
	volatile.StoreUint32(&o.XFERCFG2.Reg, volatile.LoadUint32(&o.XFERCFG2.Reg)&^(0xc000)|value<<14)
}
func (o *DMA_Type) GetXFERCFG2_DSTINC() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG2.Reg) & 0xc000) >> 14
}
func (o *DMA_Type) SetXFERCFG2_XFERCOUNT(value uint32) {
	volatile.StoreUint32(&o.XFERCFG2.Reg, volatile.LoadUint32(&o.XFERCFG2.Reg)&^(0x3ff0000)|value<<16)
}
func (o *DMA_Type) GetXFERCFG2_XFERCOUNT() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG2.Reg) & 0x3ff0000) >> 16
}
func (o *DMA_Type) SetXFERCFG2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.XFERCFG2.Reg, volatile.LoadUint32(&o.XFERCFG2.Reg)&^(0xfc000000)|value<<26)
}
func (o *DMA_Type) GetXFERCFG2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG2.Reg) & 0xfc000000) >> 26
}

// DMA.CFG3: Configuration register for DMA channel 0.
func (o *DMA_Type) SetCFG3_PERIPHREQEN(value uint32) {
	volatile.StoreUint32(&o.CFG3.Reg, volatile.LoadUint32(&o.CFG3.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCFG3_PERIPHREQEN() uint32 {
	return volatile.LoadUint32(&o.CFG3.Reg) & 0x1
}
func (o *DMA_Type) SetCFG3_HWTRIGEN(value uint32) {
	volatile.StoreUint32(&o.CFG3.Reg, volatile.LoadUint32(&o.CFG3.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCFG3_HWTRIGEN() uint32 {
	return (volatile.LoadUint32(&o.CFG3.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCFG3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG3.Reg, volatile.LoadUint32(&o.CFG3.Reg)&^(0xc)|value<<2)
}
func (o *DMA_Type) GetCFG3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG3.Reg) & 0xc) >> 2
}
func (o *DMA_Type) SetCFG3_TRIGPOL(value uint32) {
	volatile.StoreUint32(&o.CFG3.Reg, volatile.LoadUint32(&o.CFG3.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetCFG3_TRIGPOL() uint32 {
	return (volatile.LoadUint32(&o.CFG3.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetCFG3_TRIGTYPE(value uint32) {
	volatile.StoreUint32(&o.CFG3.Reg, volatile.LoadUint32(&o.CFG3.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetCFG3_TRIGTYPE() uint32 {
	return (volatile.LoadUint32(&o.CFG3.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetCFG3_TRIGBURST(value uint32) {
	volatile.StoreUint32(&o.CFG3.Reg, volatile.LoadUint32(&o.CFG3.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetCFG3_TRIGBURST() uint32 {
	return (volatile.LoadUint32(&o.CFG3.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetCFG3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG3.Reg, volatile.LoadUint32(&o.CFG3.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetCFG3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG3.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetCFG3_BURSTPOWER(value uint32) {
	volatile.StoreUint32(&o.CFG3.Reg, volatile.LoadUint32(&o.CFG3.Reg)&^(0xf00)|value<<8)
}
func (o *DMA_Type) GetCFG3_BURSTPOWER() uint32 {
	return (volatile.LoadUint32(&o.CFG3.Reg) & 0xf00) >> 8
}
func (o *DMA_Type) SetCFG3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG3.Reg, volatile.LoadUint32(&o.CFG3.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetCFG3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG3.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetCFG3_SRCBURSTWRAP(value uint32) {
	volatile.StoreUint32(&o.CFG3.Reg, volatile.LoadUint32(&o.CFG3.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetCFG3_SRCBURSTWRAP() uint32 {
	return (volatile.LoadUint32(&o.CFG3.Reg) & 0x4000) >> 14
}
func (o *DMA_Type) SetCFG3_DSTBURSTWRAP(value uint32) {
	volatile.StoreUint32(&o.CFG3.Reg, volatile.LoadUint32(&o.CFG3.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetCFG3_DSTBURSTWRAP() uint32 {
	return (volatile.LoadUint32(&o.CFG3.Reg) & 0x8000) >> 15
}
func (o *DMA_Type) SetCFG3_CHPRIORITY(value uint32) {
	volatile.StoreUint32(&o.CFG3.Reg, volatile.LoadUint32(&o.CFG3.Reg)&^(0x70000)|value<<16)
}
func (o *DMA_Type) GetCFG3_CHPRIORITY() uint32 {
	return (volatile.LoadUint32(&o.CFG3.Reg) & 0x70000) >> 16
}
func (o *DMA_Type) SetCFG3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG3.Reg, volatile.LoadUint32(&o.CFG3.Reg)&^(0xfff80000)|value<<19)
}
func (o *DMA_Type) GetCFG3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG3.Reg) & 0xfff80000) >> 19
}

// DMA.CTLSTAT3: Control and status register for DMA channel 0.
func (o *DMA_Type) SetCTLSTAT3_VALIDPENDING(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT3.Reg, volatile.LoadUint32(&o.CTLSTAT3.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCTLSTAT3_VALIDPENDING() uint32 {
	return volatile.LoadUint32(&o.CTLSTAT3.Reg) & 0x1
}
func (o *DMA_Type) SetCTLSTAT3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT3.Reg, volatile.LoadUint32(&o.CTLSTAT3.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCTLSTAT3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTLSTAT3.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCTLSTAT3_TRIG(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT3.Reg, volatile.LoadUint32(&o.CTLSTAT3.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetCTLSTAT3_TRIG() uint32 {
	return (volatile.LoadUint32(&o.CTLSTAT3.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetCTLSTAT3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT3.Reg, volatile.LoadUint32(&o.CTLSTAT3.Reg)&^(0xfffffff8)|value<<3)
}
func (o *DMA_Type) GetCTLSTAT3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTLSTAT3.Reg) & 0xfffffff8) >> 3
}

// DMA.XFERCFG3: Transfer configuration register for DMA channel 0.
func (o *DMA_Type) SetXFERCFG3_CFGVALID(value uint32) {
	volatile.StoreUint32(&o.XFERCFG3.Reg, volatile.LoadUint32(&o.XFERCFG3.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetXFERCFG3_CFGVALID() uint32 {
	return volatile.LoadUint32(&o.XFERCFG3.Reg) & 0x1
}
func (o *DMA_Type) SetXFERCFG3_RELOAD(value uint32) {
	volatile.StoreUint32(&o.XFERCFG3.Reg, volatile.LoadUint32(&o.XFERCFG3.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetXFERCFG3_RELOAD() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG3.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetXFERCFG3_SWTRIG(value uint32) {
	volatile.StoreUint32(&o.XFERCFG3.Reg, volatile.LoadUint32(&o.XFERCFG3.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetXFERCFG3_SWTRIG() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG3.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetXFERCFG3_CLRTRIG(value uint32) {
	volatile.StoreUint32(&o.XFERCFG3.Reg, volatile.LoadUint32(&o.XFERCFG3.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetXFERCFG3_CLRTRIG() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG3.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetXFERCFG3_SETINTA(value uint32) {
	volatile.StoreUint32(&o.XFERCFG3.Reg, volatile.LoadUint32(&o.XFERCFG3.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetXFERCFG3_SETINTA() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG3.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetXFERCFG3_SETINTB(value uint32) {
	volatile.StoreUint32(&o.XFERCFG3.Reg, volatile.LoadUint32(&o.XFERCFG3.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetXFERCFG3_SETINTB() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG3.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetXFERCFG3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.XFERCFG3.Reg, volatile.LoadUint32(&o.XFERCFG3.Reg)&^(0xc0)|value<<6)
}
func (o *DMA_Type) GetXFERCFG3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG3.Reg) & 0xc0) >> 6
}
func (o *DMA_Type) SetXFERCFG3_WIDTH(value uint32) {
	volatile.StoreUint32(&o.XFERCFG3.Reg, volatile.LoadUint32(&o.XFERCFG3.Reg)&^(0x300)|value<<8)
}
func (o *DMA_Type) GetXFERCFG3_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG3.Reg) & 0x300) >> 8
}
func (o *DMA_Type) SetXFERCFG3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.XFERCFG3.Reg, volatile.LoadUint32(&o.XFERCFG3.Reg)&^(0xc00)|value<<10)
}
func (o *DMA_Type) GetXFERCFG3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG3.Reg) & 0xc00) >> 10
}
func (o *DMA_Type) SetXFERCFG3_SRCINC(value uint32) {
	volatile.StoreUint32(&o.XFERCFG3.Reg, volatile.LoadUint32(&o.XFERCFG3.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetXFERCFG3_SRCINC() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG3.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetXFERCFG3_DSTINC(value uint32) {
	volatile.StoreUint32(&o.XFERCFG3.Reg, volatile.LoadUint32(&o.XFERCFG3.Reg)&^(0xc000)|value<<14)
}
func (o *DMA_Type) GetXFERCFG3_DSTINC() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG3.Reg) & 0xc000) >> 14
}
func (o *DMA_Type) SetXFERCFG3_XFERCOUNT(value uint32) {
	volatile.StoreUint32(&o.XFERCFG3.Reg, volatile.LoadUint32(&o.XFERCFG3.Reg)&^(0x3ff0000)|value<<16)
}
func (o *DMA_Type) GetXFERCFG3_XFERCOUNT() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG3.Reg) & 0x3ff0000) >> 16
}
func (o *DMA_Type) SetXFERCFG3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.XFERCFG3.Reg, volatile.LoadUint32(&o.XFERCFG3.Reg)&^(0xfc000000)|value<<26)
}
func (o *DMA_Type) GetXFERCFG3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG3.Reg) & 0xfc000000) >> 26
}

// DMA.CFG4: Configuration register for DMA channel 0.
func (o *DMA_Type) SetCFG4_PERIPHREQEN(value uint32) {
	volatile.StoreUint32(&o.CFG4.Reg, volatile.LoadUint32(&o.CFG4.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCFG4_PERIPHREQEN() uint32 {
	return volatile.LoadUint32(&o.CFG4.Reg) & 0x1
}
func (o *DMA_Type) SetCFG4_HWTRIGEN(value uint32) {
	volatile.StoreUint32(&o.CFG4.Reg, volatile.LoadUint32(&o.CFG4.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCFG4_HWTRIGEN() uint32 {
	return (volatile.LoadUint32(&o.CFG4.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCFG4_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG4.Reg, volatile.LoadUint32(&o.CFG4.Reg)&^(0xc)|value<<2)
}
func (o *DMA_Type) GetCFG4_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG4.Reg) & 0xc) >> 2
}
func (o *DMA_Type) SetCFG4_TRIGPOL(value uint32) {
	volatile.StoreUint32(&o.CFG4.Reg, volatile.LoadUint32(&o.CFG4.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetCFG4_TRIGPOL() uint32 {
	return (volatile.LoadUint32(&o.CFG4.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetCFG4_TRIGTYPE(value uint32) {
	volatile.StoreUint32(&o.CFG4.Reg, volatile.LoadUint32(&o.CFG4.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetCFG4_TRIGTYPE() uint32 {
	return (volatile.LoadUint32(&o.CFG4.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetCFG4_TRIGBURST(value uint32) {
	volatile.StoreUint32(&o.CFG4.Reg, volatile.LoadUint32(&o.CFG4.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetCFG4_TRIGBURST() uint32 {
	return (volatile.LoadUint32(&o.CFG4.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetCFG4_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG4.Reg, volatile.LoadUint32(&o.CFG4.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetCFG4_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG4.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetCFG4_BURSTPOWER(value uint32) {
	volatile.StoreUint32(&o.CFG4.Reg, volatile.LoadUint32(&o.CFG4.Reg)&^(0xf00)|value<<8)
}
func (o *DMA_Type) GetCFG4_BURSTPOWER() uint32 {
	return (volatile.LoadUint32(&o.CFG4.Reg) & 0xf00) >> 8
}
func (o *DMA_Type) SetCFG4_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG4.Reg, volatile.LoadUint32(&o.CFG4.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetCFG4_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG4.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetCFG4_SRCBURSTWRAP(value uint32) {
	volatile.StoreUint32(&o.CFG4.Reg, volatile.LoadUint32(&o.CFG4.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetCFG4_SRCBURSTWRAP() uint32 {
	return (volatile.LoadUint32(&o.CFG4.Reg) & 0x4000) >> 14
}
func (o *DMA_Type) SetCFG4_DSTBURSTWRAP(value uint32) {
	volatile.StoreUint32(&o.CFG4.Reg, volatile.LoadUint32(&o.CFG4.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetCFG4_DSTBURSTWRAP() uint32 {
	return (volatile.LoadUint32(&o.CFG4.Reg) & 0x8000) >> 15
}
func (o *DMA_Type) SetCFG4_CHPRIORITY(value uint32) {
	volatile.StoreUint32(&o.CFG4.Reg, volatile.LoadUint32(&o.CFG4.Reg)&^(0x70000)|value<<16)
}
func (o *DMA_Type) GetCFG4_CHPRIORITY() uint32 {
	return (volatile.LoadUint32(&o.CFG4.Reg) & 0x70000) >> 16
}
func (o *DMA_Type) SetCFG4_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG4.Reg, volatile.LoadUint32(&o.CFG4.Reg)&^(0xfff80000)|value<<19)
}
func (o *DMA_Type) GetCFG4_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG4.Reg) & 0xfff80000) >> 19
}

// DMA.CTLSTAT4: Control and status register for DMA channel 0.
func (o *DMA_Type) SetCTLSTAT4_VALIDPENDING(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT4.Reg, volatile.LoadUint32(&o.CTLSTAT4.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCTLSTAT4_VALIDPENDING() uint32 {
	return volatile.LoadUint32(&o.CTLSTAT4.Reg) & 0x1
}
func (o *DMA_Type) SetCTLSTAT4_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT4.Reg, volatile.LoadUint32(&o.CTLSTAT4.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCTLSTAT4_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTLSTAT4.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCTLSTAT4_TRIG(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT4.Reg, volatile.LoadUint32(&o.CTLSTAT4.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetCTLSTAT4_TRIG() uint32 {
	return (volatile.LoadUint32(&o.CTLSTAT4.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetCTLSTAT4_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT4.Reg, volatile.LoadUint32(&o.CTLSTAT4.Reg)&^(0xfffffff8)|value<<3)
}
func (o *DMA_Type) GetCTLSTAT4_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTLSTAT4.Reg) & 0xfffffff8) >> 3
}

// DMA.XFERCFG4: Transfer configuration register for DMA channel 0.
func (o *DMA_Type) SetXFERCFG4_CFGVALID(value uint32) {
	volatile.StoreUint32(&o.XFERCFG4.Reg, volatile.LoadUint32(&o.XFERCFG4.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetXFERCFG4_CFGVALID() uint32 {
	return volatile.LoadUint32(&o.XFERCFG4.Reg) & 0x1
}
func (o *DMA_Type) SetXFERCFG4_RELOAD(value uint32) {
	volatile.StoreUint32(&o.XFERCFG4.Reg, volatile.LoadUint32(&o.XFERCFG4.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetXFERCFG4_RELOAD() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG4.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetXFERCFG4_SWTRIG(value uint32) {
	volatile.StoreUint32(&o.XFERCFG4.Reg, volatile.LoadUint32(&o.XFERCFG4.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetXFERCFG4_SWTRIG() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG4.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetXFERCFG4_CLRTRIG(value uint32) {
	volatile.StoreUint32(&o.XFERCFG4.Reg, volatile.LoadUint32(&o.XFERCFG4.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetXFERCFG4_CLRTRIG() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG4.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetXFERCFG4_SETINTA(value uint32) {
	volatile.StoreUint32(&o.XFERCFG4.Reg, volatile.LoadUint32(&o.XFERCFG4.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetXFERCFG4_SETINTA() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG4.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetXFERCFG4_SETINTB(value uint32) {
	volatile.StoreUint32(&o.XFERCFG4.Reg, volatile.LoadUint32(&o.XFERCFG4.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetXFERCFG4_SETINTB() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG4.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetXFERCFG4_RESERVED(value uint32) {
	volatile.StoreUint32(&o.XFERCFG4.Reg, volatile.LoadUint32(&o.XFERCFG4.Reg)&^(0xc0)|value<<6)
}
func (o *DMA_Type) GetXFERCFG4_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG4.Reg) & 0xc0) >> 6
}
func (o *DMA_Type) SetXFERCFG4_WIDTH(value uint32) {
	volatile.StoreUint32(&o.XFERCFG4.Reg, volatile.LoadUint32(&o.XFERCFG4.Reg)&^(0x300)|value<<8)
}
func (o *DMA_Type) GetXFERCFG4_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG4.Reg) & 0x300) >> 8
}
func (o *DMA_Type) SetXFERCFG4_RESERVED(value uint32) {
	volatile.StoreUint32(&o.XFERCFG4.Reg, volatile.LoadUint32(&o.XFERCFG4.Reg)&^(0xc00)|value<<10)
}
func (o *DMA_Type) GetXFERCFG4_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG4.Reg) & 0xc00) >> 10
}
func (o *DMA_Type) SetXFERCFG4_SRCINC(value uint32) {
	volatile.StoreUint32(&o.XFERCFG4.Reg, volatile.LoadUint32(&o.XFERCFG4.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetXFERCFG4_SRCINC() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG4.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetXFERCFG4_DSTINC(value uint32) {
	volatile.StoreUint32(&o.XFERCFG4.Reg, volatile.LoadUint32(&o.XFERCFG4.Reg)&^(0xc000)|value<<14)
}
func (o *DMA_Type) GetXFERCFG4_DSTINC() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG4.Reg) & 0xc000) >> 14
}
func (o *DMA_Type) SetXFERCFG4_XFERCOUNT(value uint32) {
	volatile.StoreUint32(&o.XFERCFG4.Reg, volatile.LoadUint32(&o.XFERCFG4.Reg)&^(0x3ff0000)|value<<16)
}
func (o *DMA_Type) GetXFERCFG4_XFERCOUNT() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG4.Reg) & 0x3ff0000) >> 16
}
func (o *DMA_Type) SetXFERCFG4_RESERVED(value uint32) {
	volatile.StoreUint32(&o.XFERCFG4.Reg, volatile.LoadUint32(&o.XFERCFG4.Reg)&^(0xfc000000)|value<<26)
}
func (o *DMA_Type) GetXFERCFG4_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG4.Reg) & 0xfc000000) >> 26
}

// DMA.CFG5: Configuration register for DMA channel 0.
func (o *DMA_Type) SetCFG5_PERIPHREQEN(value uint32) {
	volatile.StoreUint32(&o.CFG5.Reg, volatile.LoadUint32(&o.CFG5.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCFG5_PERIPHREQEN() uint32 {
	return volatile.LoadUint32(&o.CFG5.Reg) & 0x1
}
func (o *DMA_Type) SetCFG5_HWTRIGEN(value uint32) {
	volatile.StoreUint32(&o.CFG5.Reg, volatile.LoadUint32(&o.CFG5.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCFG5_HWTRIGEN() uint32 {
	return (volatile.LoadUint32(&o.CFG5.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCFG5_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG5.Reg, volatile.LoadUint32(&o.CFG5.Reg)&^(0xc)|value<<2)
}
func (o *DMA_Type) GetCFG5_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG5.Reg) & 0xc) >> 2
}
func (o *DMA_Type) SetCFG5_TRIGPOL(value uint32) {
	volatile.StoreUint32(&o.CFG5.Reg, volatile.LoadUint32(&o.CFG5.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetCFG5_TRIGPOL() uint32 {
	return (volatile.LoadUint32(&o.CFG5.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetCFG5_TRIGTYPE(value uint32) {
	volatile.StoreUint32(&o.CFG5.Reg, volatile.LoadUint32(&o.CFG5.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetCFG5_TRIGTYPE() uint32 {
	return (volatile.LoadUint32(&o.CFG5.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetCFG5_TRIGBURST(value uint32) {
	volatile.StoreUint32(&o.CFG5.Reg, volatile.LoadUint32(&o.CFG5.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetCFG5_TRIGBURST() uint32 {
	return (volatile.LoadUint32(&o.CFG5.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetCFG5_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG5.Reg, volatile.LoadUint32(&o.CFG5.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetCFG5_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG5.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetCFG5_BURSTPOWER(value uint32) {
	volatile.StoreUint32(&o.CFG5.Reg, volatile.LoadUint32(&o.CFG5.Reg)&^(0xf00)|value<<8)
}
func (o *DMA_Type) GetCFG5_BURSTPOWER() uint32 {
	return (volatile.LoadUint32(&o.CFG5.Reg) & 0xf00) >> 8
}
func (o *DMA_Type) SetCFG5_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG5.Reg, volatile.LoadUint32(&o.CFG5.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetCFG5_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG5.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetCFG5_SRCBURSTWRAP(value uint32) {
	volatile.StoreUint32(&o.CFG5.Reg, volatile.LoadUint32(&o.CFG5.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetCFG5_SRCBURSTWRAP() uint32 {
	return (volatile.LoadUint32(&o.CFG5.Reg) & 0x4000) >> 14
}
func (o *DMA_Type) SetCFG5_DSTBURSTWRAP(value uint32) {
	volatile.StoreUint32(&o.CFG5.Reg, volatile.LoadUint32(&o.CFG5.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetCFG5_DSTBURSTWRAP() uint32 {
	return (volatile.LoadUint32(&o.CFG5.Reg) & 0x8000) >> 15
}
func (o *DMA_Type) SetCFG5_CHPRIORITY(value uint32) {
	volatile.StoreUint32(&o.CFG5.Reg, volatile.LoadUint32(&o.CFG5.Reg)&^(0x70000)|value<<16)
}
func (o *DMA_Type) GetCFG5_CHPRIORITY() uint32 {
	return (volatile.LoadUint32(&o.CFG5.Reg) & 0x70000) >> 16
}
func (o *DMA_Type) SetCFG5_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG5.Reg, volatile.LoadUint32(&o.CFG5.Reg)&^(0xfff80000)|value<<19)
}
func (o *DMA_Type) GetCFG5_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG5.Reg) & 0xfff80000) >> 19
}

// DMA.CTLSTAT5: Control and status register for DMA channel 0.
func (o *DMA_Type) SetCTLSTAT5_VALIDPENDING(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT5.Reg, volatile.LoadUint32(&o.CTLSTAT5.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCTLSTAT5_VALIDPENDING() uint32 {
	return volatile.LoadUint32(&o.CTLSTAT5.Reg) & 0x1
}
func (o *DMA_Type) SetCTLSTAT5_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT5.Reg, volatile.LoadUint32(&o.CTLSTAT5.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCTLSTAT5_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTLSTAT5.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCTLSTAT5_TRIG(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT5.Reg, volatile.LoadUint32(&o.CTLSTAT5.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetCTLSTAT5_TRIG() uint32 {
	return (volatile.LoadUint32(&o.CTLSTAT5.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetCTLSTAT5_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT5.Reg, volatile.LoadUint32(&o.CTLSTAT5.Reg)&^(0xfffffff8)|value<<3)
}
func (o *DMA_Type) GetCTLSTAT5_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTLSTAT5.Reg) & 0xfffffff8) >> 3
}

// DMA.XFERCFG5: Transfer configuration register for DMA channel 0.
func (o *DMA_Type) SetXFERCFG5_CFGVALID(value uint32) {
	volatile.StoreUint32(&o.XFERCFG5.Reg, volatile.LoadUint32(&o.XFERCFG5.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetXFERCFG5_CFGVALID() uint32 {
	return volatile.LoadUint32(&o.XFERCFG5.Reg) & 0x1
}
func (o *DMA_Type) SetXFERCFG5_RELOAD(value uint32) {
	volatile.StoreUint32(&o.XFERCFG5.Reg, volatile.LoadUint32(&o.XFERCFG5.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetXFERCFG5_RELOAD() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG5.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetXFERCFG5_SWTRIG(value uint32) {
	volatile.StoreUint32(&o.XFERCFG5.Reg, volatile.LoadUint32(&o.XFERCFG5.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetXFERCFG5_SWTRIG() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG5.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetXFERCFG5_CLRTRIG(value uint32) {
	volatile.StoreUint32(&o.XFERCFG5.Reg, volatile.LoadUint32(&o.XFERCFG5.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetXFERCFG5_CLRTRIG() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG5.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetXFERCFG5_SETINTA(value uint32) {
	volatile.StoreUint32(&o.XFERCFG5.Reg, volatile.LoadUint32(&o.XFERCFG5.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetXFERCFG5_SETINTA() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG5.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetXFERCFG5_SETINTB(value uint32) {
	volatile.StoreUint32(&o.XFERCFG5.Reg, volatile.LoadUint32(&o.XFERCFG5.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetXFERCFG5_SETINTB() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG5.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetXFERCFG5_RESERVED(value uint32) {
	volatile.StoreUint32(&o.XFERCFG5.Reg, volatile.LoadUint32(&o.XFERCFG5.Reg)&^(0xc0)|value<<6)
}
func (o *DMA_Type) GetXFERCFG5_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG5.Reg) & 0xc0) >> 6
}
func (o *DMA_Type) SetXFERCFG5_WIDTH(value uint32) {
	volatile.StoreUint32(&o.XFERCFG5.Reg, volatile.LoadUint32(&o.XFERCFG5.Reg)&^(0x300)|value<<8)
}
func (o *DMA_Type) GetXFERCFG5_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG5.Reg) & 0x300) >> 8
}
func (o *DMA_Type) SetXFERCFG5_RESERVED(value uint32) {
	volatile.StoreUint32(&o.XFERCFG5.Reg, volatile.LoadUint32(&o.XFERCFG5.Reg)&^(0xc00)|value<<10)
}
func (o *DMA_Type) GetXFERCFG5_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG5.Reg) & 0xc00) >> 10
}
func (o *DMA_Type) SetXFERCFG5_SRCINC(value uint32) {
	volatile.StoreUint32(&o.XFERCFG5.Reg, volatile.LoadUint32(&o.XFERCFG5.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetXFERCFG5_SRCINC() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG5.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetXFERCFG5_DSTINC(value uint32) {
	volatile.StoreUint32(&o.XFERCFG5.Reg, volatile.LoadUint32(&o.XFERCFG5.Reg)&^(0xc000)|value<<14)
}
func (o *DMA_Type) GetXFERCFG5_DSTINC() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG5.Reg) & 0xc000) >> 14
}
func (o *DMA_Type) SetXFERCFG5_XFERCOUNT(value uint32) {
	volatile.StoreUint32(&o.XFERCFG5.Reg, volatile.LoadUint32(&o.XFERCFG5.Reg)&^(0x3ff0000)|value<<16)
}
func (o *DMA_Type) GetXFERCFG5_XFERCOUNT() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG5.Reg) & 0x3ff0000) >> 16
}
func (o *DMA_Type) SetXFERCFG5_RESERVED(value uint32) {
	volatile.StoreUint32(&o.XFERCFG5.Reg, volatile.LoadUint32(&o.XFERCFG5.Reg)&^(0xfc000000)|value<<26)
}
func (o *DMA_Type) GetXFERCFG5_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG5.Reg) & 0xfc000000) >> 26
}

// DMA.CFG6: Configuration register for DMA channel 0.
func (o *DMA_Type) SetCFG6_PERIPHREQEN(value uint32) {
	volatile.StoreUint32(&o.CFG6.Reg, volatile.LoadUint32(&o.CFG6.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCFG6_PERIPHREQEN() uint32 {
	return volatile.LoadUint32(&o.CFG6.Reg) & 0x1
}
func (o *DMA_Type) SetCFG6_HWTRIGEN(value uint32) {
	volatile.StoreUint32(&o.CFG6.Reg, volatile.LoadUint32(&o.CFG6.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCFG6_HWTRIGEN() uint32 {
	return (volatile.LoadUint32(&o.CFG6.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCFG6_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG6.Reg, volatile.LoadUint32(&o.CFG6.Reg)&^(0xc)|value<<2)
}
func (o *DMA_Type) GetCFG6_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG6.Reg) & 0xc) >> 2
}
func (o *DMA_Type) SetCFG6_TRIGPOL(value uint32) {
	volatile.StoreUint32(&o.CFG6.Reg, volatile.LoadUint32(&o.CFG6.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetCFG6_TRIGPOL() uint32 {
	return (volatile.LoadUint32(&o.CFG6.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetCFG6_TRIGTYPE(value uint32) {
	volatile.StoreUint32(&o.CFG6.Reg, volatile.LoadUint32(&o.CFG6.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetCFG6_TRIGTYPE() uint32 {
	return (volatile.LoadUint32(&o.CFG6.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetCFG6_TRIGBURST(value uint32) {
	volatile.StoreUint32(&o.CFG6.Reg, volatile.LoadUint32(&o.CFG6.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetCFG6_TRIGBURST() uint32 {
	return (volatile.LoadUint32(&o.CFG6.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetCFG6_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG6.Reg, volatile.LoadUint32(&o.CFG6.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetCFG6_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG6.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetCFG6_BURSTPOWER(value uint32) {
	volatile.StoreUint32(&o.CFG6.Reg, volatile.LoadUint32(&o.CFG6.Reg)&^(0xf00)|value<<8)
}
func (o *DMA_Type) GetCFG6_BURSTPOWER() uint32 {
	return (volatile.LoadUint32(&o.CFG6.Reg) & 0xf00) >> 8
}
func (o *DMA_Type) SetCFG6_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG6.Reg, volatile.LoadUint32(&o.CFG6.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetCFG6_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG6.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetCFG6_SRCBURSTWRAP(value uint32) {
	volatile.StoreUint32(&o.CFG6.Reg, volatile.LoadUint32(&o.CFG6.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetCFG6_SRCBURSTWRAP() uint32 {
	return (volatile.LoadUint32(&o.CFG6.Reg) & 0x4000) >> 14
}
func (o *DMA_Type) SetCFG6_DSTBURSTWRAP(value uint32) {
	volatile.StoreUint32(&o.CFG6.Reg, volatile.LoadUint32(&o.CFG6.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetCFG6_DSTBURSTWRAP() uint32 {
	return (volatile.LoadUint32(&o.CFG6.Reg) & 0x8000) >> 15
}
func (o *DMA_Type) SetCFG6_CHPRIORITY(value uint32) {
	volatile.StoreUint32(&o.CFG6.Reg, volatile.LoadUint32(&o.CFG6.Reg)&^(0x70000)|value<<16)
}
func (o *DMA_Type) GetCFG6_CHPRIORITY() uint32 {
	return (volatile.LoadUint32(&o.CFG6.Reg) & 0x70000) >> 16
}
func (o *DMA_Type) SetCFG6_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG6.Reg, volatile.LoadUint32(&o.CFG6.Reg)&^(0xfff80000)|value<<19)
}
func (o *DMA_Type) GetCFG6_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG6.Reg) & 0xfff80000) >> 19
}

// DMA.CTLSTAT6: Control and status register for DMA channel 0.
func (o *DMA_Type) SetCTLSTAT6_VALIDPENDING(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT6.Reg, volatile.LoadUint32(&o.CTLSTAT6.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCTLSTAT6_VALIDPENDING() uint32 {
	return volatile.LoadUint32(&o.CTLSTAT6.Reg) & 0x1
}
func (o *DMA_Type) SetCTLSTAT6_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT6.Reg, volatile.LoadUint32(&o.CTLSTAT6.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCTLSTAT6_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTLSTAT6.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCTLSTAT6_TRIG(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT6.Reg, volatile.LoadUint32(&o.CTLSTAT6.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetCTLSTAT6_TRIG() uint32 {
	return (volatile.LoadUint32(&o.CTLSTAT6.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetCTLSTAT6_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT6.Reg, volatile.LoadUint32(&o.CTLSTAT6.Reg)&^(0xfffffff8)|value<<3)
}
func (o *DMA_Type) GetCTLSTAT6_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTLSTAT6.Reg) & 0xfffffff8) >> 3
}

// DMA.XFERCFG6: Transfer configuration register for DMA channel 0.
func (o *DMA_Type) SetXFERCFG6_CFGVALID(value uint32) {
	volatile.StoreUint32(&o.XFERCFG6.Reg, volatile.LoadUint32(&o.XFERCFG6.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetXFERCFG6_CFGVALID() uint32 {
	return volatile.LoadUint32(&o.XFERCFG6.Reg) & 0x1
}
func (o *DMA_Type) SetXFERCFG6_RELOAD(value uint32) {
	volatile.StoreUint32(&o.XFERCFG6.Reg, volatile.LoadUint32(&o.XFERCFG6.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetXFERCFG6_RELOAD() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG6.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetXFERCFG6_SWTRIG(value uint32) {
	volatile.StoreUint32(&o.XFERCFG6.Reg, volatile.LoadUint32(&o.XFERCFG6.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetXFERCFG6_SWTRIG() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG6.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetXFERCFG6_CLRTRIG(value uint32) {
	volatile.StoreUint32(&o.XFERCFG6.Reg, volatile.LoadUint32(&o.XFERCFG6.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetXFERCFG6_CLRTRIG() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG6.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetXFERCFG6_SETINTA(value uint32) {
	volatile.StoreUint32(&o.XFERCFG6.Reg, volatile.LoadUint32(&o.XFERCFG6.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetXFERCFG6_SETINTA() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG6.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetXFERCFG6_SETINTB(value uint32) {
	volatile.StoreUint32(&o.XFERCFG6.Reg, volatile.LoadUint32(&o.XFERCFG6.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetXFERCFG6_SETINTB() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG6.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetXFERCFG6_RESERVED(value uint32) {
	volatile.StoreUint32(&o.XFERCFG6.Reg, volatile.LoadUint32(&o.XFERCFG6.Reg)&^(0xc0)|value<<6)
}
func (o *DMA_Type) GetXFERCFG6_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG6.Reg) & 0xc0) >> 6
}
func (o *DMA_Type) SetXFERCFG6_WIDTH(value uint32) {
	volatile.StoreUint32(&o.XFERCFG6.Reg, volatile.LoadUint32(&o.XFERCFG6.Reg)&^(0x300)|value<<8)
}
func (o *DMA_Type) GetXFERCFG6_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG6.Reg) & 0x300) >> 8
}
func (o *DMA_Type) SetXFERCFG6_RESERVED(value uint32) {
	volatile.StoreUint32(&o.XFERCFG6.Reg, volatile.LoadUint32(&o.XFERCFG6.Reg)&^(0xc00)|value<<10)
}
func (o *DMA_Type) GetXFERCFG6_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG6.Reg) & 0xc00) >> 10
}
func (o *DMA_Type) SetXFERCFG6_SRCINC(value uint32) {
	volatile.StoreUint32(&o.XFERCFG6.Reg, volatile.LoadUint32(&o.XFERCFG6.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetXFERCFG6_SRCINC() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG6.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetXFERCFG6_DSTINC(value uint32) {
	volatile.StoreUint32(&o.XFERCFG6.Reg, volatile.LoadUint32(&o.XFERCFG6.Reg)&^(0xc000)|value<<14)
}
func (o *DMA_Type) GetXFERCFG6_DSTINC() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG6.Reg) & 0xc000) >> 14
}
func (o *DMA_Type) SetXFERCFG6_XFERCOUNT(value uint32) {
	volatile.StoreUint32(&o.XFERCFG6.Reg, volatile.LoadUint32(&o.XFERCFG6.Reg)&^(0x3ff0000)|value<<16)
}
func (o *DMA_Type) GetXFERCFG6_XFERCOUNT() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG6.Reg) & 0x3ff0000) >> 16
}
func (o *DMA_Type) SetXFERCFG6_RESERVED(value uint32) {
	volatile.StoreUint32(&o.XFERCFG6.Reg, volatile.LoadUint32(&o.XFERCFG6.Reg)&^(0xfc000000)|value<<26)
}
func (o *DMA_Type) GetXFERCFG6_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG6.Reg) & 0xfc000000) >> 26
}

// DMA.CFG7: Configuration register for DMA channel 0.
func (o *DMA_Type) SetCFG7_PERIPHREQEN(value uint32) {
	volatile.StoreUint32(&o.CFG7.Reg, volatile.LoadUint32(&o.CFG7.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCFG7_PERIPHREQEN() uint32 {
	return volatile.LoadUint32(&o.CFG7.Reg) & 0x1
}
func (o *DMA_Type) SetCFG7_HWTRIGEN(value uint32) {
	volatile.StoreUint32(&o.CFG7.Reg, volatile.LoadUint32(&o.CFG7.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCFG7_HWTRIGEN() uint32 {
	return (volatile.LoadUint32(&o.CFG7.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCFG7_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG7.Reg, volatile.LoadUint32(&o.CFG7.Reg)&^(0xc)|value<<2)
}
func (o *DMA_Type) GetCFG7_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG7.Reg) & 0xc) >> 2
}
func (o *DMA_Type) SetCFG7_TRIGPOL(value uint32) {
	volatile.StoreUint32(&o.CFG7.Reg, volatile.LoadUint32(&o.CFG7.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetCFG7_TRIGPOL() uint32 {
	return (volatile.LoadUint32(&o.CFG7.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetCFG7_TRIGTYPE(value uint32) {
	volatile.StoreUint32(&o.CFG7.Reg, volatile.LoadUint32(&o.CFG7.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetCFG7_TRIGTYPE() uint32 {
	return (volatile.LoadUint32(&o.CFG7.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetCFG7_TRIGBURST(value uint32) {
	volatile.StoreUint32(&o.CFG7.Reg, volatile.LoadUint32(&o.CFG7.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetCFG7_TRIGBURST() uint32 {
	return (volatile.LoadUint32(&o.CFG7.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetCFG7_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG7.Reg, volatile.LoadUint32(&o.CFG7.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetCFG7_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG7.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetCFG7_BURSTPOWER(value uint32) {
	volatile.StoreUint32(&o.CFG7.Reg, volatile.LoadUint32(&o.CFG7.Reg)&^(0xf00)|value<<8)
}
func (o *DMA_Type) GetCFG7_BURSTPOWER() uint32 {
	return (volatile.LoadUint32(&o.CFG7.Reg) & 0xf00) >> 8
}
func (o *DMA_Type) SetCFG7_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG7.Reg, volatile.LoadUint32(&o.CFG7.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetCFG7_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG7.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetCFG7_SRCBURSTWRAP(value uint32) {
	volatile.StoreUint32(&o.CFG7.Reg, volatile.LoadUint32(&o.CFG7.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetCFG7_SRCBURSTWRAP() uint32 {
	return (volatile.LoadUint32(&o.CFG7.Reg) & 0x4000) >> 14
}
func (o *DMA_Type) SetCFG7_DSTBURSTWRAP(value uint32) {
	volatile.StoreUint32(&o.CFG7.Reg, volatile.LoadUint32(&o.CFG7.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetCFG7_DSTBURSTWRAP() uint32 {
	return (volatile.LoadUint32(&o.CFG7.Reg) & 0x8000) >> 15
}
func (o *DMA_Type) SetCFG7_CHPRIORITY(value uint32) {
	volatile.StoreUint32(&o.CFG7.Reg, volatile.LoadUint32(&o.CFG7.Reg)&^(0x70000)|value<<16)
}
func (o *DMA_Type) GetCFG7_CHPRIORITY() uint32 {
	return (volatile.LoadUint32(&o.CFG7.Reg) & 0x70000) >> 16
}
func (o *DMA_Type) SetCFG7_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG7.Reg, volatile.LoadUint32(&o.CFG7.Reg)&^(0xfff80000)|value<<19)
}
func (o *DMA_Type) GetCFG7_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG7.Reg) & 0xfff80000) >> 19
}

// DMA.CTLSTAT7: Control and status register for DMA channel 0.
func (o *DMA_Type) SetCTLSTAT7_VALIDPENDING(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT7.Reg, volatile.LoadUint32(&o.CTLSTAT7.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCTLSTAT7_VALIDPENDING() uint32 {
	return volatile.LoadUint32(&o.CTLSTAT7.Reg) & 0x1
}
func (o *DMA_Type) SetCTLSTAT7_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT7.Reg, volatile.LoadUint32(&o.CTLSTAT7.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCTLSTAT7_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTLSTAT7.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCTLSTAT7_TRIG(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT7.Reg, volatile.LoadUint32(&o.CTLSTAT7.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetCTLSTAT7_TRIG() uint32 {
	return (volatile.LoadUint32(&o.CTLSTAT7.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetCTLSTAT7_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT7.Reg, volatile.LoadUint32(&o.CTLSTAT7.Reg)&^(0xfffffff8)|value<<3)
}
func (o *DMA_Type) GetCTLSTAT7_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTLSTAT7.Reg) & 0xfffffff8) >> 3
}

// DMA.XFERCFG7: Transfer configuration register for DMA channel 0.
func (o *DMA_Type) SetXFERCFG7_CFGVALID(value uint32) {
	volatile.StoreUint32(&o.XFERCFG7.Reg, volatile.LoadUint32(&o.XFERCFG7.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetXFERCFG7_CFGVALID() uint32 {
	return volatile.LoadUint32(&o.XFERCFG7.Reg) & 0x1
}
func (o *DMA_Type) SetXFERCFG7_RELOAD(value uint32) {
	volatile.StoreUint32(&o.XFERCFG7.Reg, volatile.LoadUint32(&o.XFERCFG7.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetXFERCFG7_RELOAD() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG7.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetXFERCFG7_SWTRIG(value uint32) {
	volatile.StoreUint32(&o.XFERCFG7.Reg, volatile.LoadUint32(&o.XFERCFG7.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetXFERCFG7_SWTRIG() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG7.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetXFERCFG7_CLRTRIG(value uint32) {
	volatile.StoreUint32(&o.XFERCFG7.Reg, volatile.LoadUint32(&o.XFERCFG7.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetXFERCFG7_CLRTRIG() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG7.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetXFERCFG7_SETINTA(value uint32) {
	volatile.StoreUint32(&o.XFERCFG7.Reg, volatile.LoadUint32(&o.XFERCFG7.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetXFERCFG7_SETINTA() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG7.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetXFERCFG7_SETINTB(value uint32) {
	volatile.StoreUint32(&o.XFERCFG7.Reg, volatile.LoadUint32(&o.XFERCFG7.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetXFERCFG7_SETINTB() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG7.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetXFERCFG7_RESERVED(value uint32) {
	volatile.StoreUint32(&o.XFERCFG7.Reg, volatile.LoadUint32(&o.XFERCFG7.Reg)&^(0xc0)|value<<6)
}
func (o *DMA_Type) GetXFERCFG7_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG7.Reg) & 0xc0) >> 6
}
func (o *DMA_Type) SetXFERCFG7_WIDTH(value uint32) {
	volatile.StoreUint32(&o.XFERCFG7.Reg, volatile.LoadUint32(&o.XFERCFG7.Reg)&^(0x300)|value<<8)
}
func (o *DMA_Type) GetXFERCFG7_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG7.Reg) & 0x300) >> 8
}
func (o *DMA_Type) SetXFERCFG7_RESERVED(value uint32) {
	volatile.StoreUint32(&o.XFERCFG7.Reg, volatile.LoadUint32(&o.XFERCFG7.Reg)&^(0xc00)|value<<10)
}
func (o *DMA_Type) GetXFERCFG7_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG7.Reg) & 0xc00) >> 10
}
func (o *DMA_Type) SetXFERCFG7_SRCINC(value uint32) {
	volatile.StoreUint32(&o.XFERCFG7.Reg, volatile.LoadUint32(&o.XFERCFG7.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetXFERCFG7_SRCINC() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG7.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetXFERCFG7_DSTINC(value uint32) {
	volatile.StoreUint32(&o.XFERCFG7.Reg, volatile.LoadUint32(&o.XFERCFG7.Reg)&^(0xc000)|value<<14)
}
func (o *DMA_Type) GetXFERCFG7_DSTINC() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG7.Reg) & 0xc000) >> 14
}
func (o *DMA_Type) SetXFERCFG7_XFERCOUNT(value uint32) {
	volatile.StoreUint32(&o.XFERCFG7.Reg, volatile.LoadUint32(&o.XFERCFG7.Reg)&^(0x3ff0000)|value<<16)
}
func (o *DMA_Type) GetXFERCFG7_XFERCOUNT() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG7.Reg) & 0x3ff0000) >> 16
}
func (o *DMA_Type) SetXFERCFG7_RESERVED(value uint32) {
	volatile.StoreUint32(&o.XFERCFG7.Reg, volatile.LoadUint32(&o.XFERCFG7.Reg)&^(0xfc000000)|value<<26)
}
func (o *DMA_Type) GetXFERCFG7_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG7.Reg) & 0xfc000000) >> 26
}

// DMA.CFG8: Configuration register for DMA channel 0.
func (o *DMA_Type) SetCFG8_PERIPHREQEN(value uint32) {
	volatile.StoreUint32(&o.CFG8.Reg, volatile.LoadUint32(&o.CFG8.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCFG8_PERIPHREQEN() uint32 {
	return volatile.LoadUint32(&o.CFG8.Reg) & 0x1
}
func (o *DMA_Type) SetCFG8_HWTRIGEN(value uint32) {
	volatile.StoreUint32(&o.CFG8.Reg, volatile.LoadUint32(&o.CFG8.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCFG8_HWTRIGEN() uint32 {
	return (volatile.LoadUint32(&o.CFG8.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCFG8_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG8.Reg, volatile.LoadUint32(&o.CFG8.Reg)&^(0xc)|value<<2)
}
func (o *DMA_Type) GetCFG8_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG8.Reg) & 0xc) >> 2
}
func (o *DMA_Type) SetCFG8_TRIGPOL(value uint32) {
	volatile.StoreUint32(&o.CFG8.Reg, volatile.LoadUint32(&o.CFG8.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetCFG8_TRIGPOL() uint32 {
	return (volatile.LoadUint32(&o.CFG8.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetCFG8_TRIGTYPE(value uint32) {
	volatile.StoreUint32(&o.CFG8.Reg, volatile.LoadUint32(&o.CFG8.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetCFG8_TRIGTYPE() uint32 {
	return (volatile.LoadUint32(&o.CFG8.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetCFG8_TRIGBURST(value uint32) {
	volatile.StoreUint32(&o.CFG8.Reg, volatile.LoadUint32(&o.CFG8.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetCFG8_TRIGBURST() uint32 {
	return (volatile.LoadUint32(&o.CFG8.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetCFG8_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG8.Reg, volatile.LoadUint32(&o.CFG8.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetCFG8_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG8.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetCFG8_BURSTPOWER(value uint32) {
	volatile.StoreUint32(&o.CFG8.Reg, volatile.LoadUint32(&o.CFG8.Reg)&^(0xf00)|value<<8)
}
func (o *DMA_Type) GetCFG8_BURSTPOWER() uint32 {
	return (volatile.LoadUint32(&o.CFG8.Reg) & 0xf00) >> 8
}
func (o *DMA_Type) SetCFG8_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG8.Reg, volatile.LoadUint32(&o.CFG8.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetCFG8_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG8.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetCFG8_SRCBURSTWRAP(value uint32) {
	volatile.StoreUint32(&o.CFG8.Reg, volatile.LoadUint32(&o.CFG8.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetCFG8_SRCBURSTWRAP() uint32 {
	return (volatile.LoadUint32(&o.CFG8.Reg) & 0x4000) >> 14
}
func (o *DMA_Type) SetCFG8_DSTBURSTWRAP(value uint32) {
	volatile.StoreUint32(&o.CFG8.Reg, volatile.LoadUint32(&o.CFG8.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetCFG8_DSTBURSTWRAP() uint32 {
	return (volatile.LoadUint32(&o.CFG8.Reg) & 0x8000) >> 15
}
func (o *DMA_Type) SetCFG8_CHPRIORITY(value uint32) {
	volatile.StoreUint32(&o.CFG8.Reg, volatile.LoadUint32(&o.CFG8.Reg)&^(0x70000)|value<<16)
}
func (o *DMA_Type) GetCFG8_CHPRIORITY() uint32 {
	return (volatile.LoadUint32(&o.CFG8.Reg) & 0x70000) >> 16
}
func (o *DMA_Type) SetCFG8_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG8.Reg, volatile.LoadUint32(&o.CFG8.Reg)&^(0xfff80000)|value<<19)
}
func (o *DMA_Type) GetCFG8_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG8.Reg) & 0xfff80000) >> 19
}

// DMA.CTLSTAT8: Control and status register for DMA channel 0.
func (o *DMA_Type) SetCTLSTAT8_VALIDPENDING(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT8.Reg, volatile.LoadUint32(&o.CTLSTAT8.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCTLSTAT8_VALIDPENDING() uint32 {
	return volatile.LoadUint32(&o.CTLSTAT8.Reg) & 0x1
}
func (o *DMA_Type) SetCTLSTAT8_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT8.Reg, volatile.LoadUint32(&o.CTLSTAT8.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCTLSTAT8_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTLSTAT8.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCTLSTAT8_TRIG(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT8.Reg, volatile.LoadUint32(&o.CTLSTAT8.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetCTLSTAT8_TRIG() uint32 {
	return (volatile.LoadUint32(&o.CTLSTAT8.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetCTLSTAT8_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT8.Reg, volatile.LoadUint32(&o.CTLSTAT8.Reg)&^(0xfffffff8)|value<<3)
}
func (o *DMA_Type) GetCTLSTAT8_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTLSTAT8.Reg) & 0xfffffff8) >> 3
}

// DMA.XFERCFG8: Transfer configuration register for DMA channel 0.
func (o *DMA_Type) SetXFERCFG8_CFGVALID(value uint32) {
	volatile.StoreUint32(&o.XFERCFG8.Reg, volatile.LoadUint32(&o.XFERCFG8.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetXFERCFG8_CFGVALID() uint32 {
	return volatile.LoadUint32(&o.XFERCFG8.Reg) & 0x1
}
func (o *DMA_Type) SetXFERCFG8_RELOAD(value uint32) {
	volatile.StoreUint32(&o.XFERCFG8.Reg, volatile.LoadUint32(&o.XFERCFG8.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetXFERCFG8_RELOAD() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG8.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetXFERCFG8_SWTRIG(value uint32) {
	volatile.StoreUint32(&o.XFERCFG8.Reg, volatile.LoadUint32(&o.XFERCFG8.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetXFERCFG8_SWTRIG() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG8.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetXFERCFG8_CLRTRIG(value uint32) {
	volatile.StoreUint32(&o.XFERCFG8.Reg, volatile.LoadUint32(&o.XFERCFG8.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetXFERCFG8_CLRTRIG() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG8.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetXFERCFG8_SETINTA(value uint32) {
	volatile.StoreUint32(&o.XFERCFG8.Reg, volatile.LoadUint32(&o.XFERCFG8.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetXFERCFG8_SETINTA() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG8.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetXFERCFG8_SETINTB(value uint32) {
	volatile.StoreUint32(&o.XFERCFG8.Reg, volatile.LoadUint32(&o.XFERCFG8.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetXFERCFG8_SETINTB() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG8.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetXFERCFG8_RESERVED(value uint32) {
	volatile.StoreUint32(&o.XFERCFG8.Reg, volatile.LoadUint32(&o.XFERCFG8.Reg)&^(0xc0)|value<<6)
}
func (o *DMA_Type) GetXFERCFG8_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG8.Reg) & 0xc0) >> 6
}
func (o *DMA_Type) SetXFERCFG8_WIDTH(value uint32) {
	volatile.StoreUint32(&o.XFERCFG8.Reg, volatile.LoadUint32(&o.XFERCFG8.Reg)&^(0x300)|value<<8)
}
func (o *DMA_Type) GetXFERCFG8_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG8.Reg) & 0x300) >> 8
}
func (o *DMA_Type) SetXFERCFG8_RESERVED(value uint32) {
	volatile.StoreUint32(&o.XFERCFG8.Reg, volatile.LoadUint32(&o.XFERCFG8.Reg)&^(0xc00)|value<<10)
}
func (o *DMA_Type) GetXFERCFG8_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG8.Reg) & 0xc00) >> 10
}
func (o *DMA_Type) SetXFERCFG8_SRCINC(value uint32) {
	volatile.StoreUint32(&o.XFERCFG8.Reg, volatile.LoadUint32(&o.XFERCFG8.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetXFERCFG8_SRCINC() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG8.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetXFERCFG8_DSTINC(value uint32) {
	volatile.StoreUint32(&o.XFERCFG8.Reg, volatile.LoadUint32(&o.XFERCFG8.Reg)&^(0xc000)|value<<14)
}
func (o *DMA_Type) GetXFERCFG8_DSTINC() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG8.Reg) & 0xc000) >> 14
}
func (o *DMA_Type) SetXFERCFG8_XFERCOUNT(value uint32) {
	volatile.StoreUint32(&o.XFERCFG8.Reg, volatile.LoadUint32(&o.XFERCFG8.Reg)&^(0x3ff0000)|value<<16)
}
func (o *DMA_Type) GetXFERCFG8_XFERCOUNT() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG8.Reg) & 0x3ff0000) >> 16
}
func (o *DMA_Type) SetXFERCFG8_RESERVED(value uint32) {
	volatile.StoreUint32(&o.XFERCFG8.Reg, volatile.LoadUint32(&o.XFERCFG8.Reg)&^(0xfc000000)|value<<26)
}
func (o *DMA_Type) GetXFERCFG8_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG8.Reg) & 0xfc000000) >> 26
}

// DMA.CFG9: Configuration register for DMA channel 0.
func (o *DMA_Type) SetCFG9_PERIPHREQEN(value uint32) {
	volatile.StoreUint32(&o.CFG9.Reg, volatile.LoadUint32(&o.CFG9.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCFG9_PERIPHREQEN() uint32 {
	return volatile.LoadUint32(&o.CFG9.Reg) & 0x1
}
func (o *DMA_Type) SetCFG9_HWTRIGEN(value uint32) {
	volatile.StoreUint32(&o.CFG9.Reg, volatile.LoadUint32(&o.CFG9.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCFG9_HWTRIGEN() uint32 {
	return (volatile.LoadUint32(&o.CFG9.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCFG9_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG9.Reg, volatile.LoadUint32(&o.CFG9.Reg)&^(0xc)|value<<2)
}
func (o *DMA_Type) GetCFG9_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG9.Reg) & 0xc) >> 2
}
func (o *DMA_Type) SetCFG9_TRIGPOL(value uint32) {
	volatile.StoreUint32(&o.CFG9.Reg, volatile.LoadUint32(&o.CFG9.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetCFG9_TRIGPOL() uint32 {
	return (volatile.LoadUint32(&o.CFG9.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetCFG9_TRIGTYPE(value uint32) {
	volatile.StoreUint32(&o.CFG9.Reg, volatile.LoadUint32(&o.CFG9.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetCFG9_TRIGTYPE() uint32 {
	return (volatile.LoadUint32(&o.CFG9.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetCFG9_TRIGBURST(value uint32) {
	volatile.StoreUint32(&o.CFG9.Reg, volatile.LoadUint32(&o.CFG9.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetCFG9_TRIGBURST() uint32 {
	return (volatile.LoadUint32(&o.CFG9.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetCFG9_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG9.Reg, volatile.LoadUint32(&o.CFG9.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetCFG9_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG9.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetCFG9_BURSTPOWER(value uint32) {
	volatile.StoreUint32(&o.CFG9.Reg, volatile.LoadUint32(&o.CFG9.Reg)&^(0xf00)|value<<8)
}
func (o *DMA_Type) GetCFG9_BURSTPOWER() uint32 {
	return (volatile.LoadUint32(&o.CFG9.Reg) & 0xf00) >> 8
}
func (o *DMA_Type) SetCFG9_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG9.Reg, volatile.LoadUint32(&o.CFG9.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetCFG9_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG9.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetCFG9_SRCBURSTWRAP(value uint32) {
	volatile.StoreUint32(&o.CFG9.Reg, volatile.LoadUint32(&o.CFG9.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetCFG9_SRCBURSTWRAP() uint32 {
	return (volatile.LoadUint32(&o.CFG9.Reg) & 0x4000) >> 14
}
func (o *DMA_Type) SetCFG9_DSTBURSTWRAP(value uint32) {
	volatile.StoreUint32(&o.CFG9.Reg, volatile.LoadUint32(&o.CFG9.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetCFG9_DSTBURSTWRAP() uint32 {
	return (volatile.LoadUint32(&o.CFG9.Reg) & 0x8000) >> 15
}
func (o *DMA_Type) SetCFG9_CHPRIORITY(value uint32) {
	volatile.StoreUint32(&o.CFG9.Reg, volatile.LoadUint32(&o.CFG9.Reg)&^(0x70000)|value<<16)
}
func (o *DMA_Type) GetCFG9_CHPRIORITY() uint32 {
	return (volatile.LoadUint32(&o.CFG9.Reg) & 0x70000) >> 16
}
func (o *DMA_Type) SetCFG9_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG9.Reg, volatile.LoadUint32(&o.CFG9.Reg)&^(0xfff80000)|value<<19)
}
func (o *DMA_Type) GetCFG9_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG9.Reg) & 0xfff80000) >> 19
}

// DMA.CTLSTAT9: Control and status register for DMA channel 0.
func (o *DMA_Type) SetCTLSTAT9_VALIDPENDING(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT9.Reg, volatile.LoadUint32(&o.CTLSTAT9.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCTLSTAT9_VALIDPENDING() uint32 {
	return volatile.LoadUint32(&o.CTLSTAT9.Reg) & 0x1
}
func (o *DMA_Type) SetCTLSTAT9_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT9.Reg, volatile.LoadUint32(&o.CTLSTAT9.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCTLSTAT9_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTLSTAT9.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCTLSTAT9_TRIG(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT9.Reg, volatile.LoadUint32(&o.CTLSTAT9.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetCTLSTAT9_TRIG() uint32 {
	return (volatile.LoadUint32(&o.CTLSTAT9.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetCTLSTAT9_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT9.Reg, volatile.LoadUint32(&o.CTLSTAT9.Reg)&^(0xfffffff8)|value<<3)
}
func (o *DMA_Type) GetCTLSTAT9_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTLSTAT9.Reg) & 0xfffffff8) >> 3
}

// DMA.XFERCFG9: Transfer configuration register for DMA channel 0.
func (o *DMA_Type) SetXFERCFG9_CFGVALID(value uint32) {
	volatile.StoreUint32(&o.XFERCFG9.Reg, volatile.LoadUint32(&o.XFERCFG9.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetXFERCFG9_CFGVALID() uint32 {
	return volatile.LoadUint32(&o.XFERCFG9.Reg) & 0x1
}
func (o *DMA_Type) SetXFERCFG9_RELOAD(value uint32) {
	volatile.StoreUint32(&o.XFERCFG9.Reg, volatile.LoadUint32(&o.XFERCFG9.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetXFERCFG9_RELOAD() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG9.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetXFERCFG9_SWTRIG(value uint32) {
	volatile.StoreUint32(&o.XFERCFG9.Reg, volatile.LoadUint32(&o.XFERCFG9.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetXFERCFG9_SWTRIG() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG9.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetXFERCFG9_CLRTRIG(value uint32) {
	volatile.StoreUint32(&o.XFERCFG9.Reg, volatile.LoadUint32(&o.XFERCFG9.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetXFERCFG9_CLRTRIG() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG9.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetXFERCFG9_SETINTA(value uint32) {
	volatile.StoreUint32(&o.XFERCFG9.Reg, volatile.LoadUint32(&o.XFERCFG9.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetXFERCFG9_SETINTA() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG9.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetXFERCFG9_SETINTB(value uint32) {
	volatile.StoreUint32(&o.XFERCFG9.Reg, volatile.LoadUint32(&o.XFERCFG9.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetXFERCFG9_SETINTB() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG9.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetXFERCFG9_RESERVED(value uint32) {
	volatile.StoreUint32(&o.XFERCFG9.Reg, volatile.LoadUint32(&o.XFERCFG9.Reg)&^(0xc0)|value<<6)
}
func (o *DMA_Type) GetXFERCFG9_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG9.Reg) & 0xc0) >> 6
}
func (o *DMA_Type) SetXFERCFG9_WIDTH(value uint32) {
	volatile.StoreUint32(&o.XFERCFG9.Reg, volatile.LoadUint32(&o.XFERCFG9.Reg)&^(0x300)|value<<8)
}
func (o *DMA_Type) GetXFERCFG9_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG9.Reg) & 0x300) >> 8
}
func (o *DMA_Type) SetXFERCFG9_RESERVED(value uint32) {
	volatile.StoreUint32(&o.XFERCFG9.Reg, volatile.LoadUint32(&o.XFERCFG9.Reg)&^(0xc00)|value<<10)
}
func (o *DMA_Type) GetXFERCFG9_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG9.Reg) & 0xc00) >> 10
}
func (o *DMA_Type) SetXFERCFG9_SRCINC(value uint32) {
	volatile.StoreUint32(&o.XFERCFG9.Reg, volatile.LoadUint32(&o.XFERCFG9.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetXFERCFG9_SRCINC() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG9.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetXFERCFG9_DSTINC(value uint32) {
	volatile.StoreUint32(&o.XFERCFG9.Reg, volatile.LoadUint32(&o.XFERCFG9.Reg)&^(0xc000)|value<<14)
}
func (o *DMA_Type) GetXFERCFG9_DSTINC() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG9.Reg) & 0xc000) >> 14
}
func (o *DMA_Type) SetXFERCFG9_XFERCOUNT(value uint32) {
	volatile.StoreUint32(&o.XFERCFG9.Reg, volatile.LoadUint32(&o.XFERCFG9.Reg)&^(0x3ff0000)|value<<16)
}
func (o *DMA_Type) GetXFERCFG9_XFERCOUNT() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG9.Reg) & 0x3ff0000) >> 16
}
func (o *DMA_Type) SetXFERCFG9_RESERVED(value uint32) {
	volatile.StoreUint32(&o.XFERCFG9.Reg, volatile.LoadUint32(&o.XFERCFG9.Reg)&^(0xfc000000)|value<<26)
}
func (o *DMA_Type) GetXFERCFG9_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG9.Reg) & 0xfc000000) >> 26
}

// DMA.CFG10: Configuration register for DMA channel 0.
func (o *DMA_Type) SetCFG10_PERIPHREQEN(value uint32) {
	volatile.StoreUint32(&o.CFG10.Reg, volatile.LoadUint32(&o.CFG10.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCFG10_PERIPHREQEN() uint32 {
	return volatile.LoadUint32(&o.CFG10.Reg) & 0x1
}
func (o *DMA_Type) SetCFG10_HWTRIGEN(value uint32) {
	volatile.StoreUint32(&o.CFG10.Reg, volatile.LoadUint32(&o.CFG10.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCFG10_HWTRIGEN() uint32 {
	return (volatile.LoadUint32(&o.CFG10.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCFG10_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG10.Reg, volatile.LoadUint32(&o.CFG10.Reg)&^(0xc)|value<<2)
}
func (o *DMA_Type) GetCFG10_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG10.Reg) & 0xc) >> 2
}
func (o *DMA_Type) SetCFG10_TRIGPOL(value uint32) {
	volatile.StoreUint32(&o.CFG10.Reg, volatile.LoadUint32(&o.CFG10.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetCFG10_TRIGPOL() uint32 {
	return (volatile.LoadUint32(&o.CFG10.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetCFG10_TRIGTYPE(value uint32) {
	volatile.StoreUint32(&o.CFG10.Reg, volatile.LoadUint32(&o.CFG10.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetCFG10_TRIGTYPE() uint32 {
	return (volatile.LoadUint32(&o.CFG10.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetCFG10_TRIGBURST(value uint32) {
	volatile.StoreUint32(&o.CFG10.Reg, volatile.LoadUint32(&o.CFG10.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetCFG10_TRIGBURST() uint32 {
	return (volatile.LoadUint32(&o.CFG10.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetCFG10_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG10.Reg, volatile.LoadUint32(&o.CFG10.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetCFG10_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG10.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetCFG10_BURSTPOWER(value uint32) {
	volatile.StoreUint32(&o.CFG10.Reg, volatile.LoadUint32(&o.CFG10.Reg)&^(0xf00)|value<<8)
}
func (o *DMA_Type) GetCFG10_BURSTPOWER() uint32 {
	return (volatile.LoadUint32(&o.CFG10.Reg) & 0xf00) >> 8
}
func (o *DMA_Type) SetCFG10_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG10.Reg, volatile.LoadUint32(&o.CFG10.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetCFG10_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG10.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetCFG10_SRCBURSTWRAP(value uint32) {
	volatile.StoreUint32(&o.CFG10.Reg, volatile.LoadUint32(&o.CFG10.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetCFG10_SRCBURSTWRAP() uint32 {
	return (volatile.LoadUint32(&o.CFG10.Reg) & 0x4000) >> 14
}
func (o *DMA_Type) SetCFG10_DSTBURSTWRAP(value uint32) {
	volatile.StoreUint32(&o.CFG10.Reg, volatile.LoadUint32(&o.CFG10.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetCFG10_DSTBURSTWRAP() uint32 {
	return (volatile.LoadUint32(&o.CFG10.Reg) & 0x8000) >> 15
}
func (o *DMA_Type) SetCFG10_CHPRIORITY(value uint32) {
	volatile.StoreUint32(&o.CFG10.Reg, volatile.LoadUint32(&o.CFG10.Reg)&^(0x70000)|value<<16)
}
func (o *DMA_Type) GetCFG10_CHPRIORITY() uint32 {
	return (volatile.LoadUint32(&o.CFG10.Reg) & 0x70000) >> 16
}
func (o *DMA_Type) SetCFG10_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG10.Reg, volatile.LoadUint32(&o.CFG10.Reg)&^(0xfff80000)|value<<19)
}
func (o *DMA_Type) GetCFG10_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG10.Reg) & 0xfff80000) >> 19
}

// DMA.CTLSTAT10: Control and status register for DMA channel 0.
func (o *DMA_Type) SetCTLSTAT10_VALIDPENDING(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT10.Reg, volatile.LoadUint32(&o.CTLSTAT10.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCTLSTAT10_VALIDPENDING() uint32 {
	return volatile.LoadUint32(&o.CTLSTAT10.Reg) & 0x1
}
func (o *DMA_Type) SetCTLSTAT10_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT10.Reg, volatile.LoadUint32(&o.CTLSTAT10.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCTLSTAT10_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTLSTAT10.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCTLSTAT10_TRIG(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT10.Reg, volatile.LoadUint32(&o.CTLSTAT10.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetCTLSTAT10_TRIG() uint32 {
	return (volatile.LoadUint32(&o.CTLSTAT10.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetCTLSTAT10_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT10.Reg, volatile.LoadUint32(&o.CTLSTAT10.Reg)&^(0xfffffff8)|value<<3)
}
func (o *DMA_Type) GetCTLSTAT10_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTLSTAT10.Reg) & 0xfffffff8) >> 3
}

// DMA.XFERCFG10: Transfer configuration register for DMA channel 0.
func (o *DMA_Type) SetXFERCFG10_CFGVALID(value uint32) {
	volatile.StoreUint32(&o.XFERCFG10.Reg, volatile.LoadUint32(&o.XFERCFG10.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetXFERCFG10_CFGVALID() uint32 {
	return volatile.LoadUint32(&o.XFERCFG10.Reg) & 0x1
}
func (o *DMA_Type) SetXFERCFG10_RELOAD(value uint32) {
	volatile.StoreUint32(&o.XFERCFG10.Reg, volatile.LoadUint32(&o.XFERCFG10.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetXFERCFG10_RELOAD() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG10.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetXFERCFG10_SWTRIG(value uint32) {
	volatile.StoreUint32(&o.XFERCFG10.Reg, volatile.LoadUint32(&o.XFERCFG10.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetXFERCFG10_SWTRIG() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG10.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetXFERCFG10_CLRTRIG(value uint32) {
	volatile.StoreUint32(&o.XFERCFG10.Reg, volatile.LoadUint32(&o.XFERCFG10.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetXFERCFG10_CLRTRIG() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG10.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetXFERCFG10_SETINTA(value uint32) {
	volatile.StoreUint32(&o.XFERCFG10.Reg, volatile.LoadUint32(&o.XFERCFG10.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetXFERCFG10_SETINTA() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG10.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetXFERCFG10_SETINTB(value uint32) {
	volatile.StoreUint32(&o.XFERCFG10.Reg, volatile.LoadUint32(&o.XFERCFG10.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetXFERCFG10_SETINTB() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG10.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetXFERCFG10_RESERVED(value uint32) {
	volatile.StoreUint32(&o.XFERCFG10.Reg, volatile.LoadUint32(&o.XFERCFG10.Reg)&^(0xc0)|value<<6)
}
func (o *DMA_Type) GetXFERCFG10_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG10.Reg) & 0xc0) >> 6
}
func (o *DMA_Type) SetXFERCFG10_WIDTH(value uint32) {
	volatile.StoreUint32(&o.XFERCFG10.Reg, volatile.LoadUint32(&o.XFERCFG10.Reg)&^(0x300)|value<<8)
}
func (o *DMA_Type) GetXFERCFG10_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG10.Reg) & 0x300) >> 8
}
func (o *DMA_Type) SetXFERCFG10_RESERVED(value uint32) {
	volatile.StoreUint32(&o.XFERCFG10.Reg, volatile.LoadUint32(&o.XFERCFG10.Reg)&^(0xc00)|value<<10)
}
func (o *DMA_Type) GetXFERCFG10_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG10.Reg) & 0xc00) >> 10
}
func (o *DMA_Type) SetXFERCFG10_SRCINC(value uint32) {
	volatile.StoreUint32(&o.XFERCFG10.Reg, volatile.LoadUint32(&o.XFERCFG10.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetXFERCFG10_SRCINC() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG10.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetXFERCFG10_DSTINC(value uint32) {
	volatile.StoreUint32(&o.XFERCFG10.Reg, volatile.LoadUint32(&o.XFERCFG10.Reg)&^(0xc000)|value<<14)
}
func (o *DMA_Type) GetXFERCFG10_DSTINC() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG10.Reg) & 0xc000) >> 14
}
func (o *DMA_Type) SetXFERCFG10_XFERCOUNT(value uint32) {
	volatile.StoreUint32(&o.XFERCFG10.Reg, volatile.LoadUint32(&o.XFERCFG10.Reg)&^(0x3ff0000)|value<<16)
}
func (o *DMA_Type) GetXFERCFG10_XFERCOUNT() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG10.Reg) & 0x3ff0000) >> 16
}
func (o *DMA_Type) SetXFERCFG10_RESERVED(value uint32) {
	volatile.StoreUint32(&o.XFERCFG10.Reg, volatile.LoadUint32(&o.XFERCFG10.Reg)&^(0xfc000000)|value<<26)
}
func (o *DMA_Type) GetXFERCFG10_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG10.Reg) & 0xfc000000) >> 26
}

// DMA.CFG11: Configuration register for DMA channel 0.
func (o *DMA_Type) SetCFG11_PERIPHREQEN(value uint32) {
	volatile.StoreUint32(&o.CFG11.Reg, volatile.LoadUint32(&o.CFG11.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCFG11_PERIPHREQEN() uint32 {
	return volatile.LoadUint32(&o.CFG11.Reg) & 0x1
}
func (o *DMA_Type) SetCFG11_HWTRIGEN(value uint32) {
	volatile.StoreUint32(&o.CFG11.Reg, volatile.LoadUint32(&o.CFG11.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCFG11_HWTRIGEN() uint32 {
	return (volatile.LoadUint32(&o.CFG11.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCFG11_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG11.Reg, volatile.LoadUint32(&o.CFG11.Reg)&^(0xc)|value<<2)
}
func (o *DMA_Type) GetCFG11_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG11.Reg) & 0xc) >> 2
}
func (o *DMA_Type) SetCFG11_TRIGPOL(value uint32) {
	volatile.StoreUint32(&o.CFG11.Reg, volatile.LoadUint32(&o.CFG11.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetCFG11_TRIGPOL() uint32 {
	return (volatile.LoadUint32(&o.CFG11.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetCFG11_TRIGTYPE(value uint32) {
	volatile.StoreUint32(&o.CFG11.Reg, volatile.LoadUint32(&o.CFG11.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetCFG11_TRIGTYPE() uint32 {
	return (volatile.LoadUint32(&o.CFG11.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetCFG11_TRIGBURST(value uint32) {
	volatile.StoreUint32(&o.CFG11.Reg, volatile.LoadUint32(&o.CFG11.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetCFG11_TRIGBURST() uint32 {
	return (volatile.LoadUint32(&o.CFG11.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetCFG11_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG11.Reg, volatile.LoadUint32(&o.CFG11.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetCFG11_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG11.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetCFG11_BURSTPOWER(value uint32) {
	volatile.StoreUint32(&o.CFG11.Reg, volatile.LoadUint32(&o.CFG11.Reg)&^(0xf00)|value<<8)
}
func (o *DMA_Type) GetCFG11_BURSTPOWER() uint32 {
	return (volatile.LoadUint32(&o.CFG11.Reg) & 0xf00) >> 8
}
func (o *DMA_Type) SetCFG11_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG11.Reg, volatile.LoadUint32(&o.CFG11.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetCFG11_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG11.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetCFG11_SRCBURSTWRAP(value uint32) {
	volatile.StoreUint32(&o.CFG11.Reg, volatile.LoadUint32(&o.CFG11.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetCFG11_SRCBURSTWRAP() uint32 {
	return (volatile.LoadUint32(&o.CFG11.Reg) & 0x4000) >> 14
}
func (o *DMA_Type) SetCFG11_DSTBURSTWRAP(value uint32) {
	volatile.StoreUint32(&o.CFG11.Reg, volatile.LoadUint32(&o.CFG11.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetCFG11_DSTBURSTWRAP() uint32 {
	return (volatile.LoadUint32(&o.CFG11.Reg) & 0x8000) >> 15
}
func (o *DMA_Type) SetCFG11_CHPRIORITY(value uint32) {
	volatile.StoreUint32(&o.CFG11.Reg, volatile.LoadUint32(&o.CFG11.Reg)&^(0x70000)|value<<16)
}
func (o *DMA_Type) GetCFG11_CHPRIORITY() uint32 {
	return (volatile.LoadUint32(&o.CFG11.Reg) & 0x70000) >> 16
}
func (o *DMA_Type) SetCFG11_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG11.Reg, volatile.LoadUint32(&o.CFG11.Reg)&^(0xfff80000)|value<<19)
}
func (o *DMA_Type) GetCFG11_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG11.Reg) & 0xfff80000) >> 19
}

// DMA.CTLSTAT11: Control and status register for DMA channel 0.
func (o *DMA_Type) SetCTLSTAT11_VALIDPENDING(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT11.Reg, volatile.LoadUint32(&o.CTLSTAT11.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCTLSTAT11_VALIDPENDING() uint32 {
	return volatile.LoadUint32(&o.CTLSTAT11.Reg) & 0x1
}
func (o *DMA_Type) SetCTLSTAT11_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT11.Reg, volatile.LoadUint32(&o.CTLSTAT11.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCTLSTAT11_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTLSTAT11.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCTLSTAT11_TRIG(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT11.Reg, volatile.LoadUint32(&o.CTLSTAT11.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetCTLSTAT11_TRIG() uint32 {
	return (volatile.LoadUint32(&o.CTLSTAT11.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetCTLSTAT11_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT11.Reg, volatile.LoadUint32(&o.CTLSTAT11.Reg)&^(0xfffffff8)|value<<3)
}
func (o *DMA_Type) GetCTLSTAT11_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTLSTAT11.Reg) & 0xfffffff8) >> 3
}

// DMA.XFERCFG11: Transfer configuration register for DMA channel 0.
func (o *DMA_Type) SetXFERCFG11_CFGVALID(value uint32) {
	volatile.StoreUint32(&o.XFERCFG11.Reg, volatile.LoadUint32(&o.XFERCFG11.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetXFERCFG11_CFGVALID() uint32 {
	return volatile.LoadUint32(&o.XFERCFG11.Reg) & 0x1
}
func (o *DMA_Type) SetXFERCFG11_RELOAD(value uint32) {
	volatile.StoreUint32(&o.XFERCFG11.Reg, volatile.LoadUint32(&o.XFERCFG11.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetXFERCFG11_RELOAD() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG11.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetXFERCFG11_SWTRIG(value uint32) {
	volatile.StoreUint32(&o.XFERCFG11.Reg, volatile.LoadUint32(&o.XFERCFG11.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetXFERCFG11_SWTRIG() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG11.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetXFERCFG11_CLRTRIG(value uint32) {
	volatile.StoreUint32(&o.XFERCFG11.Reg, volatile.LoadUint32(&o.XFERCFG11.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetXFERCFG11_CLRTRIG() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG11.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetXFERCFG11_SETINTA(value uint32) {
	volatile.StoreUint32(&o.XFERCFG11.Reg, volatile.LoadUint32(&o.XFERCFG11.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetXFERCFG11_SETINTA() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG11.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetXFERCFG11_SETINTB(value uint32) {
	volatile.StoreUint32(&o.XFERCFG11.Reg, volatile.LoadUint32(&o.XFERCFG11.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetXFERCFG11_SETINTB() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG11.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetXFERCFG11_RESERVED(value uint32) {
	volatile.StoreUint32(&o.XFERCFG11.Reg, volatile.LoadUint32(&o.XFERCFG11.Reg)&^(0xc0)|value<<6)
}
func (o *DMA_Type) GetXFERCFG11_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG11.Reg) & 0xc0) >> 6
}
func (o *DMA_Type) SetXFERCFG11_WIDTH(value uint32) {
	volatile.StoreUint32(&o.XFERCFG11.Reg, volatile.LoadUint32(&o.XFERCFG11.Reg)&^(0x300)|value<<8)
}
func (o *DMA_Type) GetXFERCFG11_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG11.Reg) & 0x300) >> 8
}
func (o *DMA_Type) SetXFERCFG11_RESERVED(value uint32) {
	volatile.StoreUint32(&o.XFERCFG11.Reg, volatile.LoadUint32(&o.XFERCFG11.Reg)&^(0xc00)|value<<10)
}
func (o *DMA_Type) GetXFERCFG11_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG11.Reg) & 0xc00) >> 10
}
func (o *DMA_Type) SetXFERCFG11_SRCINC(value uint32) {
	volatile.StoreUint32(&o.XFERCFG11.Reg, volatile.LoadUint32(&o.XFERCFG11.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetXFERCFG11_SRCINC() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG11.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetXFERCFG11_DSTINC(value uint32) {
	volatile.StoreUint32(&o.XFERCFG11.Reg, volatile.LoadUint32(&o.XFERCFG11.Reg)&^(0xc000)|value<<14)
}
func (o *DMA_Type) GetXFERCFG11_DSTINC() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG11.Reg) & 0xc000) >> 14
}
func (o *DMA_Type) SetXFERCFG11_XFERCOUNT(value uint32) {
	volatile.StoreUint32(&o.XFERCFG11.Reg, volatile.LoadUint32(&o.XFERCFG11.Reg)&^(0x3ff0000)|value<<16)
}
func (o *DMA_Type) GetXFERCFG11_XFERCOUNT() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG11.Reg) & 0x3ff0000) >> 16
}
func (o *DMA_Type) SetXFERCFG11_RESERVED(value uint32) {
	volatile.StoreUint32(&o.XFERCFG11.Reg, volatile.LoadUint32(&o.XFERCFG11.Reg)&^(0xfc000000)|value<<26)
}
func (o *DMA_Type) GetXFERCFG11_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG11.Reg) & 0xfc000000) >> 26
}

// DMA.CFG12: Configuration register for DMA channel 0.
func (o *DMA_Type) SetCFG12_PERIPHREQEN(value uint32) {
	volatile.StoreUint32(&o.CFG12.Reg, volatile.LoadUint32(&o.CFG12.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCFG12_PERIPHREQEN() uint32 {
	return volatile.LoadUint32(&o.CFG12.Reg) & 0x1
}
func (o *DMA_Type) SetCFG12_HWTRIGEN(value uint32) {
	volatile.StoreUint32(&o.CFG12.Reg, volatile.LoadUint32(&o.CFG12.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCFG12_HWTRIGEN() uint32 {
	return (volatile.LoadUint32(&o.CFG12.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCFG12_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG12.Reg, volatile.LoadUint32(&o.CFG12.Reg)&^(0xc)|value<<2)
}
func (o *DMA_Type) GetCFG12_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG12.Reg) & 0xc) >> 2
}
func (o *DMA_Type) SetCFG12_TRIGPOL(value uint32) {
	volatile.StoreUint32(&o.CFG12.Reg, volatile.LoadUint32(&o.CFG12.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetCFG12_TRIGPOL() uint32 {
	return (volatile.LoadUint32(&o.CFG12.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetCFG12_TRIGTYPE(value uint32) {
	volatile.StoreUint32(&o.CFG12.Reg, volatile.LoadUint32(&o.CFG12.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetCFG12_TRIGTYPE() uint32 {
	return (volatile.LoadUint32(&o.CFG12.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetCFG12_TRIGBURST(value uint32) {
	volatile.StoreUint32(&o.CFG12.Reg, volatile.LoadUint32(&o.CFG12.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetCFG12_TRIGBURST() uint32 {
	return (volatile.LoadUint32(&o.CFG12.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetCFG12_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG12.Reg, volatile.LoadUint32(&o.CFG12.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetCFG12_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG12.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetCFG12_BURSTPOWER(value uint32) {
	volatile.StoreUint32(&o.CFG12.Reg, volatile.LoadUint32(&o.CFG12.Reg)&^(0xf00)|value<<8)
}
func (o *DMA_Type) GetCFG12_BURSTPOWER() uint32 {
	return (volatile.LoadUint32(&o.CFG12.Reg) & 0xf00) >> 8
}
func (o *DMA_Type) SetCFG12_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG12.Reg, volatile.LoadUint32(&o.CFG12.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetCFG12_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG12.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetCFG12_SRCBURSTWRAP(value uint32) {
	volatile.StoreUint32(&o.CFG12.Reg, volatile.LoadUint32(&o.CFG12.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetCFG12_SRCBURSTWRAP() uint32 {
	return (volatile.LoadUint32(&o.CFG12.Reg) & 0x4000) >> 14
}
func (o *DMA_Type) SetCFG12_DSTBURSTWRAP(value uint32) {
	volatile.StoreUint32(&o.CFG12.Reg, volatile.LoadUint32(&o.CFG12.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetCFG12_DSTBURSTWRAP() uint32 {
	return (volatile.LoadUint32(&o.CFG12.Reg) & 0x8000) >> 15
}
func (o *DMA_Type) SetCFG12_CHPRIORITY(value uint32) {
	volatile.StoreUint32(&o.CFG12.Reg, volatile.LoadUint32(&o.CFG12.Reg)&^(0x70000)|value<<16)
}
func (o *DMA_Type) GetCFG12_CHPRIORITY() uint32 {
	return (volatile.LoadUint32(&o.CFG12.Reg) & 0x70000) >> 16
}
func (o *DMA_Type) SetCFG12_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG12.Reg, volatile.LoadUint32(&o.CFG12.Reg)&^(0xfff80000)|value<<19)
}
func (o *DMA_Type) GetCFG12_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG12.Reg) & 0xfff80000) >> 19
}

// DMA.CTLSTAT12: Control and status register for DMA channel 0.
func (o *DMA_Type) SetCTLSTAT12_VALIDPENDING(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT12.Reg, volatile.LoadUint32(&o.CTLSTAT12.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCTLSTAT12_VALIDPENDING() uint32 {
	return volatile.LoadUint32(&o.CTLSTAT12.Reg) & 0x1
}
func (o *DMA_Type) SetCTLSTAT12_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT12.Reg, volatile.LoadUint32(&o.CTLSTAT12.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCTLSTAT12_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTLSTAT12.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCTLSTAT12_TRIG(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT12.Reg, volatile.LoadUint32(&o.CTLSTAT12.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetCTLSTAT12_TRIG() uint32 {
	return (volatile.LoadUint32(&o.CTLSTAT12.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetCTLSTAT12_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT12.Reg, volatile.LoadUint32(&o.CTLSTAT12.Reg)&^(0xfffffff8)|value<<3)
}
func (o *DMA_Type) GetCTLSTAT12_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTLSTAT12.Reg) & 0xfffffff8) >> 3
}

// DMA.XFERCFG12: Transfer configuration register for DMA channel 0.
func (o *DMA_Type) SetXFERCFG12_CFGVALID(value uint32) {
	volatile.StoreUint32(&o.XFERCFG12.Reg, volatile.LoadUint32(&o.XFERCFG12.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetXFERCFG12_CFGVALID() uint32 {
	return volatile.LoadUint32(&o.XFERCFG12.Reg) & 0x1
}
func (o *DMA_Type) SetXFERCFG12_RELOAD(value uint32) {
	volatile.StoreUint32(&o.XFERCFG12.Reg, volatile.LoadUint32(&o.XFERCFG12.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetXFERCFG12_RELOAD() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG12.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetXFERCFG12_SWTRIG(value uint32) {
	volatile.StoreUint32(&o.XFERCFG12.Reg, volatile.LoadUint32(&o.XFERCFG12.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetXFERCFG12_SWTRIG() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG12.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetXFERCFG12_CLRTRIG(value uint32) {
	volatile.StoreUint32(&o.XFERCFG12.Reg, volatile.LoadUint32(&o.XFERCFG12.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetXFERCFG12_CLRTRIG() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG12.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetXFERCFG12_SETINTA(value uint32) {
	volatile.StoreUint32(&o.XFERCFG12.Reg, volatile.LoadUint32(&o.XFERCFG12.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetXFERCFG12_SETINTA() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG12.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetXFERCFG12_SETINTB(value uint32) {
	volatile.StoreUint32(&o.XFERCFG12.Reg, volatile.LoadUint32(&o.XFERCFG12.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetXFERCFG12_SETINTB() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG12.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetXFERCFG12_RESERVED(value uint32) {
	volatile.StoreUint32(&o.XFERCFG12.Reg, volatile.LoadUint32(&o.XFERCFG12.Reg)&^(0xc0)|value<<6)
}
func (o *DMA_Type) GetXFERCFG12_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG12.Reg) & 0xc0) >> 6
}
func (o *DMA_Type) SetXFERCFG12_WIDTH(value uint32) {
	volatile.StoreUint32(&o.XFERCFG12.Reg, volatile.LoadUint32(&o.XFERCFG12.Reg)&^(0x300)|value<<8)
}
func (o *DMA_Type) GetXFERCFG12_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG12.Reg) & 0x300) >> 8
}
func (o *DMA_Type) SetXFERCFG12_RESERVED(value uint32) {
	volatile.StoreUint32(&o.XFERCFG12.Reg, volatile.LoadUint32(&o.XFERCFG12.Reg)&^(0xc00)|value<<10)
}
func (o *DMA_Type) GetXFERCFG12_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG12.Reg) & 0xc00) >> 10
}
func (o *DMA_Type) SetXFERCFG12_SRCINC(value uint32) {
	volatile.StoreUint32(&o.XFERCFG12.Reg, volatile.LoadUint32(&o.XFERCFG12.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetXFERCFG12_SRCINC() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG12.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetXFERCFG12_DSTINC(value uint32) {
	volatile.StoreUint32(&o.XFERCFG12.Reg, volatile.LoadUint32(&o.XFERCFG12.Reg)&^(0xc000)|value<<14)
}
func (o *DMA_Type) GetXFERCFG12_DSTINC() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG12.Reg) & 0xc000) >> 14
}
func (o *DMA_Type) SetXFERCFG12_XFERCOUNT(value uint32) {
	volatile.StoreUint32(&o.XFERCFG12.Reg, volatile.LoadUint32(&o.XFERCFG12.Reg)&^(0x3ff0000)|value<<16)
}
func (o *DMA_Type) GetXFERCFG12_XFERCOUNT() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG12.Reg) & 0x3ff0000) >> 16
}
func (o *DMA_Type) SetXFERCFG12_RESERVED(value uint32) {
	volatile.StoreUint32(&o.XFERCFG12.Reg, volatile.LoadUint32(&o.XFERCFG12.Reg)&^(0xfc000000)|value<<26)
}
func (o *DMA_Type) GetXFERCFG12_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG12.Reg) & 0xfc000000) >> 26
}

// DMA.CFG13: Configuration register for DMA channel 0.
func (o *DMA_Type) SetCFG13_PERIPHREQEN(value uint32) {
	volatile.StoreUint32(&o.CFG13.Reg, volatile.LoadUint32(&o.CFG13.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCFG13_PERIPHREQEN() uint32 {
	return volatile.LoadUint32(&o.CFG13.Reg) & 0x1
}
func (o *DMA_Type) SetCFG13_HWTRIGEN(value uint32) {
	volatile.StoreUint32(&o.CFG13.Reg, volatile.LoadUint32(&o.CFG13.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCFG13_HWTRIGEN() uint32 {
	return (volatile.LoadUint32(&o.CFG13.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCFG13_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG13.Reg, volatile.LoadUint32(&o.CFG13.Reg)&^(0xc)|value<<2)
}
func (o *DMA_Type) GetCFG13_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG13.Reg) & 0xc) >> 2
}
func (o *DMA_Type) SetCFG13_TRIGPOL(value uint32) {
	volatile.StoreUint32(&o.CFG13.Reg, volatile.LoadUint32(&o.CFG13.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetCFG13_TRIGPOL() uint32 {
	return (volatile.LoadUint32(&o.CFG13.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetCFG13_TRIGTYPE(value uint32) {
	volatile.StoreUint32(&o.CFG13.Reg, volatile.LoadUint32(&o.CFG13.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetCFG13_TRIGTYPE() uint32 {
	return (volatile.LoadUint32(&o.CFG13.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetCFG13_TRIGBURST(value uint32) {
	volatile.StoreUint32(&o.CFG13.Reg, volatile.LoadUint32(&o.CFG13.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetCFG13_TRIGBURST() uint32 {
	return (volatile.LoadUint32(&o.CFG13.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetCFG13_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG13.Reg, volatile.LoadUint32(&o.CFG13.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetCFG13_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG13.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetCFG13_BURSTPOWER(value uint32) {
	volatile.StoreUint32(&o.CFG13.Reg, volatile.LoadUint32(&o.CFG13.Reg)&^(0xf00)|value<<8)
}
func (o *DMA_Type) GetCFG13_BURSTPOWER() uint32 {
	return (volatile.LoadUint32(&o.CFG13.Reg) & 0xf00) >> 8
}
func (o *DMA_Type) SetCFG13_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG13.Reg, volatile.LoadUint32(&o.CFG13.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetCFG13_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG13.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetCFG13_SRCBURSTWRAP(value uint32) {
	volatile.StoreUint32(&o.CFG13.Reg, volatile.LoadUint32(&o.CFG13.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetCFG13_SRCBURSTWRAP() uint32 {
	return (volatile.LoadUint32(&o.CFG13.Reg) & 0x4000) >> 14
}
func (o *DMA_Type) SetCFG13_DSTBURSTWRAP(value uint32) {
	volatile.StoreUint32(&o.CFG13.Reg, volatile.LoadUint32(&o.CFG13.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetCFG13_DSTBURSTWRAP() uint32 {
	return (volatile.LoadUint32(&o.CFG13.Reg) & 0x8000) >> 15
}
func (o *DMA_Type) SetCFG13_CHPRIORITY(value uint32) {
	volatile.StoreUint32(&o.CFG13.Reg, volatile.LoadUint32(&o.CFG13.Reg)&^(0x70000)|value<<16)
}
func (o *DMA_Type) GetCFG13_CHPRIORITY() uint32 {
	return (volatile.LoadUint32(&o.CFG13.Reg) & 0x70000) >> 16
}
func (o *DMA_Type) SetCFG13_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG13.Reg, volatile.LoadUint32(&o.CFG13.Reg)&^(0xfff80000)|value<<19)
}
func (o *DMA_Type) GetCFG13_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG13.Reg) & 0xfff80000) >> 19
}

// DMA.CTLSTAT13: Control and status register for DMA channel 0.
func (o *DMA_Type) SetCTLSTAT13_VALIDPENDING(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT13.Reg, volatile.LoadUint32(&o.CTLSTAT13.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCTLSTAT13_VALIDPENDING() uint32 {
	return volatile.LoadUint32(&o.CTLSTAT13.Reg) & 0x1
}
func (o *DMA_Type) SetCTLSTAT13_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT13.Reg, volatile.LoadUint32(&o.CTLSTAT13.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCTLSTAT13_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTLSTAT13.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCTLSTAT13_TRIG(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT13.Reg, volatile.LoadUint32(&o.CTLSTAT13.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetCTLSTAT13_TRIG() uint32 {
	return (volatile.LoadUint32(&o.CTLSTAT13.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetCTLSTAT13_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT13.Reg, volatile.LoadUint32(&o.CTLSTAT13.Reg)&^(0xfffffff8)|value<<3)
}
func (o *DMA_Type) GetCTLSTAT13_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTLSTAT13.Reg) & 0xfffffff8) >> 3
}

// DMA.XFERCFG13: Transfer configuration register for DMA channel 0.
func (o *DMA_Type) SetXFERCFG13_CFGVALID(value uint32) {
	volatile.StoreUint32(&o.XFERCFG13.Reg, volatile.LoadUint32(&o.XFERCFG13.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetXFERCFG13_CFGVALID() uint32 {
	return volatile.LoadUint32(&o.XFERCFG13.Reg) & 0x1
}
func (o *DMA_Type) SetXFERCFG13_RELOAD(value uint32) {
	volatile.StoreUint32(&o.XFERCFG13.Reg, volatile.LoadUint32(&o.XFERCFG13.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetXFERCFG13_RELOAD() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG13.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetXFERCFG13_SWTRIG(value uint32) {
	volatile.StoreUint32(&o.XFERCFG13.Reg, volatile.LoadUint32(&o.XFERCFG13.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetXFERCFG13_SWTRIG() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG13.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetXFERCFG13_CLRTRIG(value uint32) {
	volatile.StoreUint32(&o.XFERCFG13.Reg, volatile.LoadUint32(&o.XFERCFG13.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetXFERCFG13_CLRTRIG() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG13.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetXFERCFG13_SETINTA(value uint32) {
	volatile.StoreUint32(&o.XFERCFG13.Reg, volatile.LoadUint32(&o.XFERCFG13.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetXFERCFG13_SETINTA() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG13.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetXFERCFG13_SETINTB(value uint32) {
	volatile.StoreUint32(&o.XFERCFG13.Reg, volatile.LoadUint32(&o.XFERCFG13.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetXFERCFG13_SETINTB() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG13.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetXFERCFG13_RESERVED(value uint32) {
	volatile.StoreUint32(&o.XFERCFG13.Reg, volatile.LoadUint32(&o.XFERCFG13.Reg)&^(0xc0)|value<<6)
}
func (o *DMA_Type) GetXFERCFG13_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG13.Reg) & 0xc0) >> 6
}
func (o *DMA_Type) SetXFERCFG13_WIDTH(value uint32) {
	volatile.StoreUint32(&o.XFERCFG13.Reg, volatile.LoadUint32(&o.XFERCFG13.Reg)&^(0x300)|value<<8)
}
func (o *DMA_Type) GetXFERCFG13_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG13.Reg) & 0x300) >> 8
}
func (o *DMA_Type) SetXFERCFG13_RESERVED(value uint32) {
	volatile.StoreUint32(&o.XFERCFG13.Reg, volatile.LoadUint32(&o.XFERCFG13.Reg)&^(0xc00)|value<<10)
}
func (o *DMA_Type) GetXFERCFG13_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG13.Reg) & 0xc00) >> 10
}
func (o *DMA_Type) SetXFERCFG13_SRCINC(value uint32) {
	volatile.StoreUint32(&o.XFERCFG13.Reg, volatile.LoadUint32(&o.XFERCFG13.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetXFERCFG13_SRCINC() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG13.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetXFERCFG13_DSTINC(value uint32) {
	volatile.StoreUint32(&o.XFERCFG13.Reg, volatile.LoadUint32(&o.XFERCFG13.Reg)&^(0xc000)|value<<14)
}
func (o *DMA_Type) GetXFERCFG13_DSTINC() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG13.Reg) & 0xc000) >> 14
}
func (o *DMA_Type) SetXFERCFG13_XFERCOUNT(value uint32) {
	volatile.StoreUint32(&o.XFERCFG13.Reg, volatile.LoadUint32(&o.XFERCFG13.Reg)&^(0x3ff0000)|value<<16)
}
func (o *DMA_Type) GetXFERCFG13_XFERCOUNT() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG13.Reg) & 0x3ff0000) >> 16
}
func (o *DMA_Type) SetXFERCFG13_RESERVED(value uint32) {
	volatile.StoreUint32(&o.XFERCFG13.Reg, volatile.LoadUint32(&o.XFERCFG13.Reg)&^(0xfc000000)|value<<26)
}
func (o *DMA_Type) GetXFERCFG13_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG13.Reg) & 0xfc000000) >> 26
}

// DMA.CFG14: Configuration register for DMA channel 0.
func (o *DMA_Type) SetCFG14_PERIPHREQEN(value uint32) {
	volatile.StoreUint32(&o.CFG14.Reg, volatile.LoadUint32(&o.CFG14.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCFG14_PERIPHREQEN() uint32 {
	return volatile.LoadUint32(&o.CFG14.Reg) & 0x1
}
func (o *DMA_Type) SetCFG14_HWTRIGEN(value uint32) {
	volatile.StoreUint32(&o.CFG14.Reg, volatile.LoadUint32(&o.CFG14.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCFG14_HWTRIGEN() uint32 {
	return (volatile.LoadUint32(&o.CFG14.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCFG14_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG14.Reg, volatile.LoadUint32(&o.CFG14.Reg)&^(0xc)|value<<2)
}
func (o *DMA_Type) GetCFG14_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG14.Reg) & 0xc) >> 2
}
func (o *DMA_Type) SetCFG14_TRIGPOL(value uint32) {
	volatile.StoreUint32(&o.CFG14.Reg, volatile.LoadUint32(&o.CFG14.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetCFG14_TRIGPOL() uint32 {
	return (volatile.LoadUint32(&o.CFG14.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetCFG14_TRIGTYPE(value uint32) {
	volatile.StoreUint32(&o.CFG14.Reg, volatile.LoadUint32(&o.CFG14.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetCFG14_TRIGTYPE() uint32 {
	return (volatile.LoadUint32(&o.CFG14.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetCFG14_TRIGBURST(value uint32) {
	volatile.StoreUint32(&o.CFG14.Reg, volatile.LoadUint32(&o.CFG14.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetCFG14_TRIGBURST() uint32 {
	return (volatile.LoadUint32(&o.CFG14.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetCFG14_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG14.Reg, volatile.LoadUint32(&o.CFG14.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetCFG14_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG14.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetCFG14_BURSTPOWER(value uint32) {
	volatile.StoreUint32(&o.CFG14.Reg, volatile.LoadUint32(&o.CFG14.Reg)&^(0xf00)|value<<8)
}
func (o *DMA_Type) GetCFG14_BURSTPOWER() uint32 {
	return (volatile.LoadUint32(&o.CFG14.Reg) & 0xf00) >> 8
}
func (o *DMA_Type) SetCFG14_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG14.Reg, volatile.LoadUint32(&o.CFG14.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetCFG14_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG14.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetCFG14_SRCBURSTWRAP(value uint32) {
	volatile.StoreUint32(&o.CFG14.Reg, volatile.LoadUint32(&o.CFG14.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetCFG14_SRCBURSTWRAP() uint32 {
	return (volatile.LoadUint32(&o.CFG14.Reg) & 0x4000) >> 14
}
func (o *DMA_Type) SetCFG14_DSTBURSTWRAP(value uint32) {
	volatile.StoreUint32(&o.CFG14.Reg, volatile.LoadUint32(&o.CFG14.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetCFG14_DSTBURSTWRAP() uint32 {
	return (volatile.LoadUint32(&o.CFG14.Reg) & 0x8000) >> 15
}
func (o *DMA_Type) SetCFG14_CHPRIORITY(value uint32) {
	volatile.StoreUint32(&o.CFG14.Reg, volatile.LoadUint32(&o.CFG14.Reg)&^(0x70000)|value<<16)
}
func (o *DMA_Type) GetCFG14_CHPRIORITY() uint32 {
	return (volatile.LoadUint32(&o.CFG14.Reg) & 0x70000) >> 16
}
func (o *DMA_Type) SetCFG14_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG14.Reg, volatile.LoadUint32(&o.CFG14.Reg)&^(0xfff80000)|value<<19)
}
func (o *DMA_Type) GetCFG14_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG14.Reg) & 0xfff80000) >> 19
}

// DMA.CTLSTAT14: Control and status register for DMA channel 0.
func (o *DMA_Type) SetCTLSTAT14_VALIDPENDING(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT14.Reg, volatile.LoadUint32(&o.CTLSTAT14.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCTLSTAT14_VALIDPENDING() uint32 {
	return volatile.LoadUint32(&o.CTLSTAT14.Reg) & 0x1
}
func (o *DMA_Type) SetCTLSTAT14_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT14.Reg, volatile.LoadUint32(&o.CTLSTAT14.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCTLSTAT14_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTLSTAT14.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCTLSTAT14_TRIG(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT14.Reg, volatile.LoadUint32(&o.CTLSTAT14.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetCTLSTAT14_TRIG() uint32 {
	return (volatile.LoadUint32(&o.CTLSTAT14.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetCTLSTAT14_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT14.Reg, volatile.LoadUint32(&o.CTLSTAT14.Reg)&^(0xfffffff8)|value<<3)
}
func (o *DMA_Type) GetCTLSTAT14_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTLSTAT14.Reg) & 0xfffffff8) >> 3
}

// DMA.XFERCFG14: Transfer configuration register for DMA channel 0.
func (o *DMA_Type) SetXFERCFG14_CFGVALID(value uint32) {
	volatile.StoreUint32(&o.XFERCFG14.Reg, volatile.LoadUint32(&o.XFERCFG14.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetXFERCFG14_CFGVALID() uint32 {
	return volatile.LoadUint32(&o.XFERCFG14.Reg) & 0x1
}
func (o *DMA_Type) SetXFERCFG14_RELOAD(value uint32) {
	volatile.StoreUint32(&o.XFERCFG14.Reg, volatile.LoadUint32(&o.XFERCFG14.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetXFERCFG14_RELOAD() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG14.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetXFERCFG14_SWTRIG(value uint32) {
	volatile.StoreUint32(&o.XFERCFG14.Reg, volatile.LoadUint32(&o.XFERCFG14.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetXFERCFG14_SWTRIG() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG14.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetXFERCFG14_CLRTRIG(value uint32) {
	volatile.StoreUint32(&o.XFERCFG14.Reg, volatile.LoadUint32(&o.XFERCFG14.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetXFERCFG14_CLRTRIG() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG14.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetXFERCFG14_SETINTA(value uint32) {
	volatile.StoreUint32(&o.XFERCFG14.Reg, volatile.LoadUint32(&o.XFERCFG14.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetXFERCFG14_SETINTA() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG14.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetXFERCFG14_SETINTB(value uint32) {
	volatile.StoreUint32(&o.XFERCFG14.Reg, volatile.LoadUint32(&o.XFERCFG14.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetXFERCFG14_SETINTB() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG14.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetXFERCFG14_RESERVED(value uint32) {
	volatile.StoreUint32(&o.XFERCFG14.Reg, volatile.LoadUint32(&o.XFERCFG14.Reg)&^(0xc0)|value<<6)
}
func (o *DMA_Type) GetXFERCFG14_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG14.Reg) & 0xc0) >> 6
}
func (o *DMA_Type) SetXFERCFG14_WIDTH(value uint32) {
	volatile.StoreUint32(&o.XFERCFG14.Reg, volatile.LoadUint32(&o.XFERCFG14.Reg)&^(0x300)|value<<8)
}
func (o *DMA_Type) GetXFERCFG14_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG14.Reg) & 0x300) >> 8
}
func (o *DMA_Type) SetXFERCFG14_RESERVED(value uint32) {
	volatile.StoreUint32(&o.XFERCFG14.Reg, volatile.LoadUint32(&o.XFERCFG14.Reg)&^(0xc00)|value<<10)
}
func (o *DMA_Type) GetXFERCFG14_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG14.Reg) & 0xc00) >> 10
}
func (o *DMA_Type) SetXFERCFG14_SRCINC(value uint32) {
	volatile.StoreUint32(&o.XFERCFG14.Reg, volatile.LoadUint32(&o.XFERCFG14.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetXFERCFG14_SRCINC() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG14.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetXFERCFG14_DSTINC(value uint32) {
	volatile.StoreUint32(&o.XFERCFG14.Reg, volatile.LoadUint32(&o.XFERCFG14.Reg)&^(0xc000)|value<<14)
}
func (o *DMA_Type) GetXFERCFG14_DSTINC() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG14.Reg) & 0xc000) >> 14
}
func (o *DMA_Type) SetXFERCFG14_XFERCOUNT(value uint32) {
	volatile.StoreUint32(&o.XFERCFG14.Reg, volatile.LoadUint32(&o.XFERCFG14.Reg)&^(0x3ff0000)|value<<16)
}
func (o *DMA_Type) GetXFERCFG14_XFERCOUNT() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG14.Reg) & 0x3ff0000) >> 16
}
func (o *DMA_Type) SetXFERCFG14_RESERVED(value uint32) {
	volatile.StoreUint32(&o.XFERCFG14.Reg, volatile.LoadUint32(&o.XFERCFG14.Reg)&^(0xfc000000)|value<<26)
}
func (o *DMA_Type) GetXFERCFG14_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG14.Reg) & 0xfc000000) >> 26
}

// DMA.CFG15: Configuration register for DMA channel 0.
func (o *DMA_Type) SetCFG15_PERIPHREQEN(value uint32) {
	volatile.StoreUint32(&o.CFG15.Reg, volatile.LoadUint32(&o.CFG15.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCFG15_PERIPHREQEN() uint32 {
	return volatile.LoadUint32(&o.CFG15.Reg) & 0x1
}
func (o *DMA_Type) SetCFG15_HWTRIGEN(value uint32) {
	volatile.StoreUint32(&o.CFG15.Reg, volatile.LoadUint32(&o.CFG15.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCFG15_HWTRIGEN() uint32 {
	return (volatile.LoadUint32(&o.CFG15.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCFG15_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG15.Reg, volatile.LoadUint32(&o.CFG15.Reg)&^(0xc)|value<<2)
}
func (o *DMA_Type) GetCFG15_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG15.Reg) & 0xc) >> 2
}
func (o *DMA_Type) SetCFG15_TRIGPOL(value uint32) {
	volatile.StoreUint32(&o.CFG15.Reg, volatile.LoadUint32(&o.CFG15.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetCFG15_TRIGPOL() uint32 {
	return (volatile.LoadUint32(&o.CFG15.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetCFG15_TRIGTYPE(value uint32) {
	volatile.StoreUint32(&o.CFG15.Reg, volatile.LoadUint32(&o.CFG15.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetCFG15_TRIGTYPE() uint32 {
	return (volatile.LoadUint32(&o.CFG15.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetCFG15_TRIGBURST(value uint32) {
	volatile.StoreUint32(&o.CFG15.Reg, volatile.LoadUint32(&o.CFG15.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetCFG15_TRIGBURST() uint32 {
	return (volatile.LoadUint32(&o.CFG15.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetCFG15_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG15.Reg, volatile.LoadUint32(&o.CFG15.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetCFG15_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG15.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetCFG15_BURSTPOWER(value uint32) {
	volatile.StoreUint32(&o.CFG15.Reg, volatile.LoadUint32(&o.CFG15.Reg)&^(0xf00)|value<<8)
}
func (o *DMA_Type) GetCFG15_BURSTPOWER() uint32 {
	return (volatile.LoadUint32(&o.CFG15.Reg) & 0xf00) >> 8
}
func (o *DMA_Type) SetCFG15_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG15.Reg, volatile.LoadUint32(&o.CFG15.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetCFG15_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG15.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetCFG15_SRCBURSTWRAP(value uint32) {
	volatile.StoreUint32(&o.CFG15.Reg, volatile.LoadUint32(&o.CFG15.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetCFG15_SRCBURSTWRAP() uint32 {
	return (volatile.LoadUint32(&o.CFG15.Reg) & 0x4000) >> 14
}
func (o *DMA_Type) SetCFG15_DSTBURSTWRAP(value uint32) {
	volatile.StoreUint32(&o.CFG15.Reg, volatile.LoadUint32(&o.CFG15.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetCFG15_DSTBURSTWRAP() uint32 {
	return (volatile.LoadUint32(&o.CFG15.Reg) & 0x8000) >> 15
}
func (o *DMA_Type) SetCFG15_CHPRIORITY(value uint32) {
	volatile.StoreUint32(&o.CFG15.Reg, volatile.LoadUint32(&o.CFG15.Reg)&^(0x70000)|value<<16)
}
func (o *DMA_Type) GetCFG15_CHPRIORITY() uint32 {
	return (volatile.LoadUint32(&o.CFG15.Reg) & 0x70000) >> 16
}
func (o *DMA_Type) SetCFG15_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG15.Reg, volatile.LoadUint32(&o.CFG15.Reg)&^(0xfff80000)|value<<19)
}
func (o *DMA_Type) GetCFG15_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG15.Reg) & 0xfff80000) >> 19
}

// DMA.CTLSTAT15: Control and status register for DMA channel 0.
func (o *DMA_Type) SetCTLSTAT15_VALIDPENDING(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT15.Reg, volatile.LoadUint32(&o.CTLSTAT15.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCTLSTAT15_VALIDPENDING() uint32 {
	return volatile.LoadUint32(&o.CTLSTAT15.Reg) & 0x1
}
func (o *DMA_Type) SetCTLSTAT15_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT15.Reg, volatile.LoadUint32(&o.CTLSTAT15.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCTLSTAT15_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTLSTAT15.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCTLSTAT15_TRIG(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT15.Reg, volatile.LoadUint32(&o.CTLSTAT15.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetCTLSTAT15_TRIG() uint32 {
	return (volatile.LoadUint32(&o.CTLSTAT15.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetCTLSTAT15_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT15.Reg, volatile.LoadUint32(&o.CTLSTAT15.Reg)&^(0xfffffff8)|value<<3)
}
func (o *DMA_Type) GetCTLSTAT15_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTLSTAT15.Reg) & 0xfffffff8) >> 3
}

// DMA.XFERCFG15: Transfer configuration register for DMA channel 0.
func (o *DMA_Type) SetXFERCFG15_CFGVALID(value uint32) {
	volatile.StoreUint32(&o.XFERCFG15.Reg, volatile.LoadUint32(&o.XFERCFG15.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetXFERCFG15_CFGVALID() uint32 {
	return volatile.LoadUint32(&o.XFERCFG15.Reg) & 0x1
}
func (o *DMA_Type) SetXFERCFG15_RELOAD(value uint32) {
	volatile.StoreUint32(&o.XFERCFG15.Reg, volatile.LoadUint32(&o.XFERCFG15.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetXFERCFG15_RELOAD() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG15.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetXFERCFG15_SWTRIG(value uint32) {
	volatile.StoreUint32(&o.XFERCFG15.Reg, volatile.LoadUint32(&o.XFERCFG15.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetXFERCFG15_SWTRIG() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG15.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetXFERCFG15_CLRTRIG(value uint32) {
	volatile.StoreUint32(&o.XFERCFG15.Reg, volatile.LoadUint32(&o.XFERCFG15.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetXFERCFG15_CLRTRIG() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG15.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetXFERCFG15_SETINTA(value uint32) {
	volatile.StoreUint32(&o.XFERCFG15.Reg, volatile.LoadUint32(&o.XFERCFG15.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetXFERCFG15_SETINTA() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG15.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetXFERCFG15_SETINTB(value uint32) {
	volatile.StoreUint32(&o.XFERCFG15.Reg, volatile.LoadUint32(&o.XFERCFG15.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetXFERCFG15_SETINTB() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG15.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetXFERCFG15_RESERVED(value uint32) {
	volatile.StoreUint32(&o.XFERCFG15.Reg, volatile.LoadUint32(&o.XFERCFG15.Reg)&^(0xc0)|value<<6)
}
func (o *DMA_Type) GetXFERCFG15_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG15.Reg) & 0xc0) >> 6
}
func (o *DMA_Type) SetXFERCFG15_WIDTH(value uint32) {
	volatile.StoreUint32(&o.XFERCFG15.Reg, volatile.LoadUint32(&o.XFERCFG15.Reg)&^(0x300)|value<<8)
}
func (o *DMA_Type) GetXFERCFG15_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG15.Reg) & 0x300) >> 8
}
func (o *DMA_Type) SetXFERCFG15_RESERVED(value uint32) {
	volatile.StoreUint32(&o.XFERCFG15.Reg, volatile.LoadUint32(&o.XFERCFG15.Reg)&^(0xc00)|value<<10)
}
func (o *DMA_Type) GetXFERCFG15_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG15.Reg) & 0xc00) >> 10
}
func (o *DMA_Type) SetXFERCFG15_SRCINC(value uint32) {
	volatile.StoreUint32(&o.XFERCFG15.Reg, volatile.LoadUint32(&o.XFERCFG15.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetXFERCFG15_SRCINC() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG15.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetXFERCFG15_DSTINC(value uint32) {
	volatile.StoreUint32(&o.XFERCFG15.Reg, volatile.LoadUint32(&o.XFERCFG15.Reg)&^(0xc000)|value<<14)
}
func (o *DMA_Type) GetXFERCFG15_DSTINC() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG15.Reg) & 0xc000) >> 14
}
func (o *DMA_Type) SetXFERCFG15_XFERCOUNT(value uint32) {
	volatile.StoreUint32(&o.XFERCFG15.Reg, volatile.LoadUint32(&o.XFERCFG15.Reg)&^(0x3ff0000)|value<<16)
}
func (o *DMA_Type) GetXFERCFG15_XFERCOUNT() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG15.Reg) & 0x3ff0000) >> 16
}
func (o *DMA_Type) SetXFERCFG15_RESERVED(value uint32) {
	volatile.StoreUint32(&o.XFERCFG15.Reg, volatile.LoadUint32(&o.XFERCFG15.Reg)&^(0xfc000000)|value<<26)
}
func (o *DMA_Type) GetXFERCFG15_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG15.Reg) & 0xfc000000) >> 26
}

// DMA.CFG16: Configuration register for DMA channel 0.
func (o *DMA_Type) SetCFG16_PERIPHREQEN(value uint32) {
	volatile.StoreUint32(&o.CFG16.Reg, volatile.LoadUint32(&o.CFG16.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCFG16_PERIPHREQEN() uint32 {
	return volatile.LoadUint32(&o.CFG16.Reg) & 0x1
}
func (o *DMA_Type) SetCFG16_HWTRIGEN(value uint32) {
	volatile.StoreUint32(&o.CFG16.Reg, volatile.LoadUint32(&o.CFG16.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCFG16_HWTRIGEN() uint32 {
	return (volatile.LoadUint32(&o.CFG16.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCFG16_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG16.Reg, volatile.LoadUint32(&o.CFG16.Reg)&^(0xc)|value<<2)
}
func (o *DMA_Type) GetCFG16_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG16.Reg) & 0xc) >> 2
}
func (o *DMA_Type) SetCFG16_TRIGPOL(value uint32) {
	volatile.StoreUint32(&o.CFG16.Reg, volatile.LoadUint32(&o.CFG16.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetCFG16_TRIGPOL() uint32 {
	return (volatile.LoadUint32(&o.CFG16.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetCFG16_TRIGTYPE(value uint32) {
	volatile.StoreUint32(&o.CFG16.Reg, volatile.LoadUint32(&o.CFG16.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetCFG16_TRIGTYPE() uint32 {
	return (volatile.LoadUint32(&o.CFG16.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetCFG16_TRIGBURST(value uint32) {
	volatile.StoreUint32(&o.CFG16.Reg, volatile.LoadUint32(&o.CFG16.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetCFG16_TRIGBURST() uint32 {
	return (volatile.LoadUint32(&o.CFG16.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetCFG16_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG16.Reg, volatile.LoadUint32(&o.CFG16.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetCFG16_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG16.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetCFG16_BURSTPOWER(value uint32) {
	volatile.StoreUint32(&o.CFG16.Reg, volatile.LoadUint32(&o.CFG16.Reg)&^(0xf00)|value<<8)
}
func (o *DMA_Type) GetCFG16_BURSTPOWER() uint32 {
	return (volatile.LoadUint32(&o.CFG16.Reg) & 0xf00) >> 8
}
func (o *DMA_Type) SetCFG16_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG16.Reg, volatile.LoadUint32(&o.CFG16.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetCFG16_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG16.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetCFG16_SRCBURSTWRAP(value uint32) {
	volatile.StoreUint32(&o.CFG16.Reg, volatile.LoadUint32(&o.CFG16.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetCFG16_SRCBURSTWRAP() uint32 {
	return (volatile.LoadUint32(&o.CFG16.Reg) & 0x4000) >> 14
}
func (o *DMA_Type) SetCFG16_DSTBURSTWRAP(value uint32) {
	volatile.StoreUint32(&o.CFG16.Reg, volatile.LoadUint32(&o.CFG16.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetCFG16_DSTBURSTWRAP() uint32 {
	return (volatile.LoadUint32(&o.CFG16.Reg) & 0x8000) >> 15
}
func (o *DMA_Type) SetCFG16_CHPRIORITY(value uint32) {
	volatile.StoreUint32(&o.CFG16.Reg, volatile.LoadUint32(&o.CFG16.Reg)&^(0x70000)|value<<16)
}
func (o *DMA_Type) GetCFG16_CHPRIORITY() uint32 {
	return (volatile.LoadUint32(&o.CFG16.Reg) & 0x70000) >> 16
}
func (o *DMA_Type) SetCFG16_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG16.Reg, volatile.LoadUint32(&o.CFG16.Reg)&^(0xfff80000)|value<<19)
}
func (o *DMA_Type) GetCFG16_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG16.Reg) & 0xfff80000) >> 19
}

// DMA.CTLSTAT16: Control and status register for DMA channel 0.
func (o *DMA_Type) SetCTLSTAT16_VALIDPENDING(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT16.Reg, volatile.LoadUint32(&o.CTLSTAT16.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCTLSTAT16_VALIDPENDING() uint32 {
	return volatile.LoadUint32(&o.CTLSTAT16.Reg) & 0x1
}
func (o *DMA_Type) SetCTLSTAT16_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT16.Reg, volatile.LoadUint32(&o.CTLSTAT16.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCTLSTAT16_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTLSTAT16.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCTLSTAT16_TRIG(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT16.Reg, volatile.LoadUint32(&o.CTLSTAT16.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetCTLSTAT16_TRIG() uint32 {
	return (volatile.LoadUint32(&o.CTLSTAT16.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetCTLSTAT16_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT16.Reg, volatile.LoadUint32(&o.CTLSTAT16.Reg)&^(0xfffffff8)|value<<3)
}
func (o *DMA_Type) GetCTLSTAT16_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTLSTAT16.Reg) & 0xfffffff8) >> 3
}

// DMA.XFERCFG16: Transfer configuration register for DMA channel 0.
func (o *DMA_Type) SetXFERCFG16_CFGVALID(value uint32) {
	volatile.StoreUint32(&o.XFERCFG16.Reg, volatile.LoadUint32(&o.XFERCFG16.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetXFERCFG16_CFGVALID() uint32 {
	return volatile.LoadUint32(&o.XFERCFG16.Reg) & 0x1
}
func (o *DMA_Type) SetXFERCFG16_RELOAD(value uint32) {
	volatile.StoreUint32(&o.XFERCFG16.Reg, volatile.LoadUint32(&o.XFERCFG16.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetXFERCFG16_RELOAD() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG16.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetXFERCFG16_SWTRIG(value uint32) {
	volatile.StoreUint32(&o.XFERCFG16.Reg, volatile.LoadUint32(&o.XFERCFG16.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetXFERCFG16_SWTRIG() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG16.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetXFERCFG16_CLRTRIG(value uint32) {
	volatile.StoreUint32(&o.XFERCFG16.Reg, volatile.LoadUint32(&o.XFERCFG16.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetXFERCFG16_CLRTRIG() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG16.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetXFERCFG16_SETINTA(value uint32) {
	volatile.StoreUint32(&o.XFERCFG16.Reg, volatile.LoadUint32(&o.XFERCFG16.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetXFERCFG16_SETINTA() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG16.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetXFERCFG16_SETINTB(value uint32) {
	volatile.StoreUint32(&o.XFERCFG16.Reg, volatile.LoadUint32(&o.XFERCFG16.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetXFERCFG16_SETINTB() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG16.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetXFERCFG16_RESERVED(value uint32) {
	volatile.StoreUint32(&o.XFERCFG16.Reg, volatile.LoadUint32(&o.XFERCFG16.Reg)&^(0xc0)|value<<6)
}
func (o *DMA_Type) GetXFERCFG16_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG16.Reg) & 0xc0) >> 6
}
func (o *DMA_Type) SetXFERCFG16_WIDTH(value uint32) {
	volatile.StoreUint32(&o.XFERCFG16.Reg, volatile.LoadUint32(&o.XFERCFG16.Reg)&^(0x300)|value<<8)
}
func (o *DMA_Type) GetXFERCFG16_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG16.Reg) & 0x300) >> 8
}
func (o *DMA_Type) SetXFERCFG16_RESERVED(value uint32) {
	volatile.StoreUint32(&o.XFERCFG16.Reg, volatile.LoadUint32(&o.XFERCFG16.Reg)&^(0xc00)|value<<10)
}
func (o *DMA_Type) GetXFERCFG16_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG16.Reg) & 0xc00) >> 10
}
func (o *DMA_Type) SetXFERCFG16_SRCINC(value uint32) {
	volatile.StoreUint32(&o.XFERCFG16.Reg, volatile.LoadUint32(&o.XFERCFG16.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetXFERCFG16_SRCINC() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG16.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetXFERCFG16_DSTINC(value uint32) {
	volatile.StoreUint32(&o.XFERCFG16.Reg, volatile.LoadUint32(&o.XFERCFG16.Reg)&^(0xc000)|value<<14)
}
func (o *DMA_Type) GetXFERCFG16_DSTINC() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG16.Reg) & 0xc000) >> 14
}
func (o *DMA_Type) SetXFERCFG16_XFERCOUNT(value uint32) {
	volatile.StoreUint32(&o.XFERCFG16.Reg, volatile.LoadUint32(&o.XFERCFG16.Reg)&^(0x3ff0000)|value<<16)
}
func (o *DMA_Type) GetXFERCFG16_XFERCOUNT() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG16.Reg) & 0x3ff0000) >> 16
}
func (o *DMA_Type) SetXFERCFG16_RESERVED(value uint32) {
	volatile.StoreUint32(&o.XFERCFG16.Reg, volatile.LoadUint32(&o.XFERCFG16.Reg)&^(0xfc000000)|value<<26)
}
func (o *DMA_Type) GetXFERCFG16_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG16.Reg) & 0xfc000000) >> 26
}

// DMA.CFG17: Configuration register for DMA channel 0.
func (o *DMA_Type) SetCFG17_PERIPHREQEN(value uint32) {
	volatile.StoreUint32(&o.CFG17.Reg, volatile.LoadUint32(&o.CFG17.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCFG17_PERIPHREQEN() uint32 {
	return volatile.LoadUint32(&o.CFG17.Reg) & 0x1
}
func (o *DMA_Type) SetCFG17_HWTRIGEN(value uint32) {
	volatile.StoreUint32(&o.CFG17.Reg, volatile.LoadUint32(&o.CFG17.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCFG17_HWTRIGEN() uint32 {
	return (volatile.LoadUint32(&o.CFG17.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCFG17_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG17.Reg, volatile.LoadUint32(&o.CFG17.Reg)&^(0xc)|value<<2)
}
func (o *DMA_Type) GetCFG17_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG17.Reg) & 0xc) >> 2
}
func (o *DMA_Type) SetCFG17_TRIGPOL(value uint32) {
	volatile.StoreUint32(&o.CFG17.Reg, volatile.LoadUint32(&o.CFG17.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetCFG17_TRIGPOL() uint32 {
	return (volatile.LoadUint32(&o.CFG17.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetCFG17_TRIGTYPE(value uint32) {
	volatile.StoreUint32(&o.CFG17.Reg, volatile.LoadUint32(&o.CFG17.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetCFG17_TRIGTYPE() uint32 {
	return (volatile.LoadUint32(&o.CFG17.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetCFG17_TRIGBURST(value uint32) {
	volatile.StoreUint32(&o.CFG17.Reg, volatile.LoadUint32(&o.CFG17.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetCFG17_TRIGBURST() uint32 {
	return (volatile.LoadUint32(&o.CFG17.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetCFG17_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG17.Reg, volatile.LoadUint32(&o.CFG17.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetCFG17_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG17.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetCFG17_BURSTPOWER(value uint32) {
	volatile.StoreUint32(&o.CFG17.Reg, volatile.LoadUint32(&o.CFG17.Reg)&^(0xf00)|value<<8)
}
func (o *DMA_Type) GetCFG17_BURSTPOWER() uint32 {
	return (volatile.LoadUint32(&o.CFG17.Reg) & 0xf00) >> 8
}
func (o *DMA_Type) SetCFG17_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG17.Reg, volatile.LoadUint32(&o.CFG17.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetCFG17_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG17.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetCFG17_SRCBURSTWRAP(value uint32) {
	volatile.StoreUint32(&o.CFG17.Reg, volatile.LoadUint32(&o.CFG17.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetCFG17_SRCBURSTWRAP() uint32 {
	return (volatile.LoadUint32(&o.CFG17.Reg) & 0x4000) >> 14
}
func (o *DMA_Type) SetCFG17_DSTBURSTWRAP(value uint32) {
	volatile.StoreUint32(&o.CFG17.Reg, volatile.LoadUint32(&o.CFG17.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetCFG17_DSTBURSTWRAP() uint32 {
	return (volatile.LoadUint32(&o.CFG17.Reg) & 0x8000) >> 15
}
func (o *DMA_Type) SetCFG17_CHPRIORITY(value uint32) {
	volatile.StoreUint32(&o.CFG17.Reg, volatile.LoadUint32(&o.CFG17.Reg)&^(0x70000)|value<<16)
}
func (o *DMA_Type) GetCFG17_CHPRIORITY() uint32 {
	return (volatile.LoadUint32(&o.CFG17.Reg) & 0x70000) >> 16
}
func (o *DMA_Type) SetCFG17_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG17.Reg, volatile.LoadUint32(&o.CFG17.Reg)&^(0xfff80000)|value<<19)
}
func (o *DMA_Type) GetCFG17_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG17.Reg) & 0xfff80000) >> 19
}

// DMA.CTLSTAT17: Control and status register for DMA channel 0.
func (o *DMA_Type) SetCTLSTAT17_VALIDPENDING(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT17.Reg, volatile.LoadUint32(&o.CTLSTAT17.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCTLSTAT17_VALIDPENDING() uint32 {
	return volatile.LoadUint32(&o.CTLSTAT17.Reg) & 0x1
}
func (o *DMA_Type) SetCTLSTAT17_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT17.Reg, volatile.LoadUint32(&o.CTLSTAT17.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCTLSTAT17_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTLSTAT17.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCTLSTAT17_TRIG(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT17.Reg, volatile.LoadUint32(&o.CTLSTAT17.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetCTLSTAT17_TRIG() uint32 {
	return (volatile.LoadUint32(&o.CTLSTAT17.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetCTLSTAT17_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT17.Reg, volatile.LoadUint32(&o.CTLSTAT17.Reg)&^(0xfffffff8)|value<<3)
}
func (o *DMA_Type) GetCTLSTAT17_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTLSTAT17.Reg) & 0xfffffff8) >> 3
}

// DMA.XFERCFG17: Transfer configuration register for DMA channel 0.
func (o *DMA_Type) SetXFERCFG17_CFGVALID(value uint32) {
	volatile.StoreUint32(&o.XFERCFG17.Reg, volatile.LoadUint32(&o.XFERCFG17.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetXFERCFG17_CFGVALID() uint32 {
	return volatile.LoadUint32(&o.XFERCFG17.Reg) & 0x1
}
func (o *DMA_Type) SetXFERCFG17_RELOAD(value uint32) {
	volatile.StoreUint32(&o.XFERCFG17.Reg, volatile.LoadUint32(&o.XFERCFG17.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetXFERCFG17_RELOAD() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG17.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetXFERCFG17_SWTRIG(value uint32) {
	volatile.StoreUint32(&o.XFERCFG17.Reg, volatile.LoadUint32(&o.XFERCFG17.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetXFERCFG17_SWTRIG() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG17.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetXFERCFG17_CLRTRIG(value uint32) {
	volatile.StoreUint32(&o.XFERCFG17.Reg, volatile.LoadUint32(&o.XFERCFG17.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetXFERCFG17_CLRTRIG() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG17.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetXFERCFG17_SETINTA(value uint32) {
	volatile.StoreUint32(&o.XFERCFG17.Reg, volatile.LoadUint32(&o.XFERCFG17.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetXFERCFG17_SETINTA() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG17.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetXFERCFG17_SETINTB(value uint32) {
	volatile.StoreUint32(&o.XFERCFG17.Reg, volatile.LoadUint32(&o.XFERCFG17.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetXFERCFG17_SETINTB() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG17.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetXFERCFG17_RESERVED(value uint32) {
	volatile.StoreUint32(&o.XFERCFG17.Reg, volatile.LoadUint32(&o.XFERCFG17.Reg)&^(0xc0)|value<<6)
}
func (o *DMA_Type) GetXFERCFG17_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG17.Reg) & 0xc0) >> 6
}
func (o *DMA_Type) SetXFERCFG17_WIDTH(value uint32) {
	volatile.StoreUint32(&o.XFERCFG17.Reg, volatile.LoadUint32(&o.XFERCFG17.Reg)&^(0x300)|value<<8)
}
func (o *DMA_Type) GetXFERCFG17_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG17.Reg) & 0x300) >> 8
}
func (o *DMA_Type) SetXFERCFG17_RESERVED(value uint32) {
	volatile.StoreUint32(&o.XFERCFG17.Reg, volatile.LoadUint32(&o.XFERCFG17.Reg)&^(0xc00)|value<<10)
}
func (o *DMA_Type) GetXFERCFG17_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG17.Reg) & 0xc00) >> 10
}
func (o *DMA_Type) SetXFERCFG17_SRCINC(value uint32) {
	volatile.StoreUint32(&o.XFERCFG17.Reg, volatile.LoadUint32(&o.XFERCFG17.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetXFERCFG17_SRCINC() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG17.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetXFERCFG17_DSTINC(value uint32) {
	volatile.StoreUint32(&o.XFERCFG17.Reg, volatile.LoadUint32(&o.XFERCFG17.Reg)&^(0xc000)|value<<14)
}
func (o *DMA_Type) GetXFERCFG17_DSTINC() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG17.Reg) & 0xc000) >> 14
}
func (o *DMA_Type) SetXFERCFG17_XFERCOUNT(value uint32) {
	volatile.StoreUint32(&o.XFERCFG17.Reg, volatile.LoadUint32(&o.XFERCFG17.Reg)&^(0x3ff0000)|value<<16)
}
func (o *DMA_Type) GetXFERCFG17_XFERCOUNT() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG17.Reg) & 0x3ff0000) >> 16
}
func (o *DMA_Type) SetXFERCFG17_RESERVED(value uint32) {
	volatile.StoreUint32(&o.XFERCFG17.Reg, volatile.LoadUint32(&o.XFERCFG17.Reg)&^(0xfc000000)|value<<26)
}
func (o *DMA_Type) GetXFERCFG17_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG17.Reg) & 0xfc000000) >> 26
}

// USB device controller
type USB_Type struct {
	DEVCMDSTAT   volatile.Register32 // 0x0
	INFO         volatile.Register32 // 0x4
	EPLISTSTART  volatile.Register32 // 0x8
	DATABUFSTART volatile.Register32 // 0xC
	LPM          volatile.Register32 // 0x10
	EPSKIP       volatile.Register32 // 0x14
	EPINUSE      volatile.Register32 // 0x18
	EPBUFCFG     volatile.Register32 // 0x1C
	INTSTAT      volatile.Register32 // 0x20
	INTEN        volatile.Register32 // 0x24
	INTSETSTAT   volatile.Register32 // 0x28
	INTROUTING   volatile.Register32 // 0x2C
	_            [4]byte
	EPTOGGLE     volatile.Register32 // 0x34
}

// USB.DEVCMDSTAT: USB Device Command/Status register
func (o *USB_Type) SetDEVCMDSTAT_DEV_ADDR(value uint32) {
	volatile.StoreUint32(&o.DEVCMDSTAT.Reg, volatile.LoadUint32(&o.DEVCMDSTAT.Reg)&^(0x7f)|value)
}
func (o *USB_Type) GetDEVCMDSTAT_DEV_ADDR() uint32 {
	return volatile.LoadUint32(&o.DEVCMDSTAT.Reg) & 0x7f
}
func (o *USB_Type) SetDEVCMDSTAT_DEV_EN(value uint32) {
	volatile.StoreUint32(&o.DEVCMDSTAT.Reg, volatile.LoadUint32(&o.DEVCMDSTAT.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetDEVCMDSTAT_DEV_EN() uint32 {
	return (volatile.LoadUint32(&o.DEVCMDSTAT.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetDEVCMDSTAT_SETUP(value uint32) {
	volatile.StoreUint32(&o.DEVCMDSTAT.Reg, volatile.LoadUint32(&o.DEVCMDSTAT.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetDEVCMDSTAT_SETUP() uint32 {
	return (volatile.LoadUint32(&o.DEVCMDSTAT.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetDEVCMDSTAT_PLL_ON(value uint32) {
	volatile.StoreUint32(&o.DEVCMDSTAT.Reg, volatile.LoadUint32(&o.DEVCMDSTAT.Reg)&^(0x200)|value<<9)
}
func (o *USB_Type) GetDEVCMDSTAT_PLL_ON() uint32 {
	return (volatile.LoadUint32(&o.DEVCMDSTAT.Reg) & 0x200) >> 9
}
func (o *USB_Type) SetDEVCMDSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DEVCMDSTAT.Reg, volatile.LoadUint32(&o.DEVCMDSTAT.Reg)&^(0x400)|value<<10)
}
func (o *USB_Type) GetDEVCMDSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DEVCMDSTAT.Reg) & 0x400) >> 10
}
func (o *USB_Type) SetDEVCMDSTAT_LPM_SUP(value uint32) {
	volatile.StoreUint32(&o.DEVCMDSTAT.Reg, volatile.LoadUint32(&o.DEVCMDSTAT.Reg)&^(0x800)|value<<11)
}
func (o *USB_Type) GetDEVCMDSTAT_LPM_SUP() uint32 {
	return (volatile.LoadUint32(&o.DEVCMDSTAT.Reg) & 0x800) >> 11
}
func (o *USB_Type) SetDEVCMDSTAT_INTONNAK_AO(value uint32) {
	volatile.StoreUint32(&o.DEVCMDSTAT.Reg, volatile.LoadUint32(&o.DEVCMDSTAT.Reg)&^(0x1000)|value<<12)
}
func (o *USB_Type) GetDEVCMDSTAT_INTONNAK_AO() uint32 {
	return (volatile.LoadUint32(&o.DEVCMDSTAT.Reg) & 0x1000) >> 12
}
func (o *USB_Type) SetDEVCMDSTAT_INTONNAK_AI(value uint32) {
	volatile.StoreUint32(&o.DEVCMDSTAT.Reg, volatile.LoadUint32(&o.DEVCMDSTAT.Reg)&^(0x2000)|value<<13)
}
func (o *USB_Type) GetDEVCMDSTAT_INTONNAK_AI() uint32 {
	return (volatile.LoadUint32(&o.DEVCMDSTAT.Reg) & 0x2000) >> 13
}
func (o *USB_Type) SetDEVCMDSTAT_INTONNAK_CO(value uint32) {
	volatile.StoreUint32(&o.DEVCMDSTAT.Reg, volatile.LoadUint32(&o.DEVCMDSTAT.Reg)&^(0x4000)|value<<14)
}
func (o *USB_Type) GetDEVCMDSTAT_INTONNAK_CO() uint32 {
	return (volatile.LoadUint32(&o.DEVCMDSTAT.Reg) & 0x4000) >> 14
}
func (o *USB_Type) SetDEVCMDSTAT_INTONNAK_CI(value uint32) {
	volatile.StoreUint32(&o.DEVCMDSTAT.Reg, volatile.LoadUint32(&o.DEVCMDSTAT.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetDEVCMDSTAT_INTONNAK_CI() uint32 {
	return (volatile.LoadUint32(&o.DEVCMDSTAT.Reg) & 0x8000) >> 15
}
func (o *USB_Type) SetDEVCMDSTAT_DCON(value uint32) {
	volatile.StoreUint32(&o.DEVCMDSTAT.Reg, volatile.LoadUint32(&o.DEVCMDSTAT.Reg)&^(0x10000)|value<<16)
}
func (o *USB_Type) GetDEVCMDSTAT_DCON() uint32 {
	return (volatile.LoadUint32(&o.DEVCMDSTAT.Reg) & 0x10000) >> 16
}
func (o *USB_Type) SetDEVCMDSTAT_DSUS(value uint32) {
	volatile.StoreUint32(&o.DEVCMDSTAT.Reg, volatile.LoadUint32(&o.DEVCMDSTAT.Reg)&^(0x20000)|value<<17)
}
func (o *USB_Type) GetDEVCMDSTAT_DSUS() uint32 {
	return (volatile.LoadUint32(&o.DEVCMDSTAT.Reg) & 0x20000) >> 17
}
func (o *USB_Type) SetDEVCMDSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DEVCMDSTAT.Reg, volatile.LoadUint32(&o.DEVCMDSTAT.Reg)&^(0x40000)|value<<18)
}
func (o *USB_Type) GetDEVCMDSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DEVCMDSTAT.Reg) & 0x40000) >> 18
}
func (o *USB_Type) SetDEVCMDSTAT_LPM_SUS(value uint32) {
	volatile.StoreUint32(&o.DEVCMDSTAT.Reg, volatile.LoadUint32(&o.DEVCMDSTAT.Reg)&^(0x80000)|value<<19)
}
func (o *USB_Type) GetDEVCMDSTAT_LPM_SUS() uint32 {
	return (volatile.LoadUint32(&o.DEVCMDSTAT.Reg) & 0x80000) >> 19
}
func (o *USB_Type) SetDEVCMDSTAT_LPM_REWP(value uint32) {
	volatile.StoreUint32(&o.DEVCMDSTAT.Reg, volatile.LoadUint32(&o.DEVCMDSTAT.Reg)&^(0x100000)|value<<20)
}
func (o *USB_Type) GetDEVCMDSTAT_LPM_REWP() uint32 {
	return (volatile.LoadUint32(&o.DEVCMDSTAT.Reg) & 0x100000) >> 20
}
func (o *USB_Type) SetDEVCMDSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DEVCMDSTAT.Reg, volatile.LoadUint32(&o.DEVCMDSTAT.Reg)&^(0xe00000)|value<<21)
}
func (o *USB_Type) GetDEVCMDSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DEVCMDSTAT.Reg) & 0xe00000) >> 21
}
func (o *USB_Type) SetDEVCMDSTAT_DCON_C(value uint32) {
	volatile.StoreUint32(&o.DEVCMDSTAT.Reg, volatile.LoadUint32(&o.DEVCMDSTAT.Reg)&^(0x1000000)|value<<24)
}
func (o *USB_Type) GetDEVCMDSTAT_DCON_C() uint32 {
	return (volatile.LoadUint32(&o.DEVCMDSTAT.Reg) & 0x1000000) >> 24
}
func (o *USB_Type) SetDEVCMDSTAT_DSUS_C(value uint32) {
	volatile.StoreUint32(&o.DEVCMDSTAT.Reg, volatile.LoadUint32(&o.DEVCMDSTAT.Reg)&^(0x2000000)|value<<25)
}
func (o *USB_Type) GetDEVCMDSTAT_DSUS_C() uint32 {
	return (volatile.LoadUint32(&o.DEVCMDSTAT.Reg) & 0x2000000) >> 25
}
func (o *USB_Type) SetDEVCMDSTAT_DRES_C(value uint32) {
	volatile.StoreUint32(&o.DEVCMDSTAT.Reg, volatile.LoadUint32(&o.DEVCMDSTAT.Reg)&^(0x4000000)|value<<26)
}
func (o *USB_Type) GetDEVCMDSTAT_DRES_C() uint32 {
	return (volatile.LoadUint32(&o.DEVCMDSTAT.Reg) & 0x4000000) >> 26
}
func (o *USB_Type) SetDEVCMDSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DEVCMDSTAT.Reg, volatile.LoadUint32(&o.DEVCMDSTAT.Reg)&^(0x8000000)|value<<27)
}
func (o *USB_Type) GetDEVCMDSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DEVCMDSTAT.Reg) & 0x8000000) >> 27
}
func (o *USB_Type) SetDEVCMDSTAT_VBUSDEBOUNCED(value uint32) {
	volatile.StoreUint32(&o.DEVCMDSTAT.Reg, volatile.LoadUint32(&o.DEVCMDSTAT.Reg)&^(0x10000000)|value<<28)
}
func (o *USB_Type) GetDEVCMDSTAT_VBUSDEBOUNCED() uint32 {
	return (volatile.LoadUint32(&o.DEVCMDSTAT.Reg) & 0x10000000) >> 28
}
func (o *USB_Type) SetDEVCMDSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DEVCMDSTAT.Reg, volatile.LoadUint32(&o.DEVCMDSTAT.Reg)&^(0xe0000000)|value<<29)
}
func (o *USB_Type) GetDEVCMDSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DEVCMDSTAT.Reg) & 0xe0000000) >> 29
}

// USB.INFO: USB Info register
func (o *USB_Type) SetINFO_FRAME_NR(value uint32) {
	volatile.StoreUint32(&o.INFO.Reg, volatile.LoadUint32(&o.INFO.Reg)&^(0x7ff)|value)
}
func (o *USB_Type) GetINFO_FRAME_NR() uint32 {
	return volatile.LoadUint32(&o.INFO.Reg) & 0x7ff
}
func (o *USB_Type) SetINFO_ERR_CODE(value uint32) {
	volatile.StoreUint32(&o.INFO.Reg, volatile.LoadUint32(&o.INFO.Reg)&^(0x7800)|value<<11)
}
func (o *USB_Type) GetINFO_ERR_CODE() uint32 {
	return (volatile.LoadUint32(&o.INFO.Reg) & 0x7800) >> 11
}
func (o *USB_Type) SetINFO_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INFO.Reg, volatile.LoadUint32(&o.INFO.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetINFO_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INFO.Reg) & 0x8000) >> 15
}
func (o *USB_Type) SetINFO_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INFO.Reg, volatile.LoadUint32(&o.INFO.Reg)&^(0xffff0000)|value<<16)
}
func (o *USB_Type) GetINFO_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INFO.Reg) & 0xffff0000) >> 16
}

// USB.EPLISTSTART: USB EP Command/Status List start address
func (o *USB_Type) SetEPLISTSTART_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EPLISTSTART.Reg, volatile.LoadUint32(&o.EPLISTSTART.Reg)&^(0xff)|value)
}
func (o *USB_Type) GetEPLISTSTART_RESERVED() uint32 {
	return volatile.LoadUint32(&o.EPLISTSTART.Reg) & 0xff
}
func (o *USB_Type) SetEPLISTSTART_EP_LIST(value uint32) {
	volatile.StoreUint32(&o.EPLISTSTART.Reg, volatile.LoadUint32(&o.EPLISTSTART.Reg)&^(0xffffff00)|value<<8)
}
func (o *USB_Type) GetEPLISTSTART_EP_LIST() uint32 {
	return (volatile.LoadUint32(&o.EPLISTSTART.Reg) & 0xffffff00) >> 8
}

// USB.DATABUFSTART: USB Data buffer start address
func (o *USB_Type) SetDATABUFSTART_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DATABUFSTART.Reg, volatile.LoadUint32(&o.DATABUFSTART.Reg)&^(0x3fffff)|value)
}
func (o *USB_Type) GetDATABUFSTART_RESERVED() uint32 {
	return volatile.LoadUint32(&o.DATABUFSTART.Reg) & 0x3fffff
}
func (o *USB_Type) SetDATABUFSTART_DA_BUF(value uint32) {
	volatile.StoreUint32(&o.DATABUFSTART.Reg, volatile.LoadUint32(&o.DATABUFSTART.Reg)&^(0xffc00000)|value<<22)
}
func (o *USB_Type) GetDATABUFSTART_DA_BUF() uint32 {
	return (volatile.LoadUint32(&o.DATABUFSTART.Reg) & 0xffc00000) >> 22
}

// USB.LPM: Link Power Management register
func (o *USB_Type) SetLPM_HIRD_HW(value uint32) {
	volatile.StoreUint32(&o.LPM.Reg, volatile.LoadUint32(&o.LPM.Reg)&^(0xf)|value)
}
func (o *USB_Type) GetLPM_HIRD_HW() uint32 {
	return volatile.LoadUint32(&o.LPM.Reg) & 0xf
}
func (o *USB_Type) SetLPM_HIRD_SW(value uint32) {
	volatile.StoreUint32(&o.LPM.Reg, volatile.LoadUint32(&o.LPM.Reg)&^(0xf0)|value<<4)
}
func (o *USB_Type) GetLPM_HIRD_SW() uint32 {
	return (volatile.LoadUint32(&o.LPM.Reg) & 0xf0) >> 4
}
func (o *USB_Type) SetLPM_DATA_PENDING(value uint32) {
	volatile.StoreUint32(&o.LPM.Reg, volatile.LoadUint32(&o.LPM.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetLPM_DATA_PENDING() uint32 {
	return (volatile.LoadUint32(&o.LPM.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetLPM_RESERVED(value uint32) {
	volatile.StoreUint32(&o.LPM.Reg, volatile.LoadUint32(&o.LPM.Reg)&^(0xfffffe00)|value<<9)
}
func (o *USB_Type) GetLPM_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.LPM.Reg) & 0xfffffe00) >> 9
}

// USB.EPSKIP: USB Endpoint skip
func (o *USB_Type) SetEPSKIP_SKIP(value uint32) {
	volatile.StoreUint32(&o.EPSKIP.Reg, volatile.LoadUint32(&o.EPSKIP.Reg)&^(0x3fffffff)|value)
}
func (o *USB_Type) GetEPSKIP_SKIP() uint32 {
	return volatile.LoadUint32(&o.EPSKIP.Reg) & 0x3fffffff
}
func (o *USB_Type) SetEPSKIP_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EPSKIP.Reg, volatile.LoadUint32(&o.EPSKIP.Reg)&^(0xc0000000)|value<<30)
}
func (o *USB_Type) GetEPSKIP_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EPSKIP.Reg) & 0xc0000000) >> 30
}

// USB.EPINUSE: USB Endpoint Buffer in use
func (o *USB_Type) SetEPINUSE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EPINUSE.Reg, volatile.LoadUint32(&o.EPINUSE.Reg)&^(0x3)|value)
}
func (o *USB_Type) GetEPINUSE_RESERVED() uint32 {
	return volatile.LoadUint32(&o.EPINUSE.Reg) & 0x3
}
func (o *USB_Type) SetEPINUSE_BUF(value uint32) {
	volatile.StoreUint32(&o.EPINUSE.Reg, volatile.LoadUint32(&o.EPINUSE.Reg)&^(0x3fc)|value<<2)
}
func (o *USB_Type) GetEPINUSE_BUF() uint32 {
	return (volatile.LoadUint32(&o.EPINUSE.Reg) & 0x3fc) >> 2
}
func (o *USB_Type) SetEPINUSE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EPINUSE.Reg, volatile.LoadUint32(&o.EPINUSE.Reg)&^(0xfffffc00)|value<<10)
}
func (o *USB_Type) GetEPINUSE_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EPINUSE.Reg) & 0xfffffc00) >> 10
}

// USB.EPBUFCFG: USB Endpoint Buffer Configuration register
func (o *USB_Type) SetEPBUFCFG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EPBUFCFG.Reg, volatile.LoadUint32(&o.EPBUFCFG.Reg)&^(0x3)|value)
}
func (o *USB_Type) GetEPBUFCFG_RESERVED() uint32 {
	return volatile.LoadUint32(&o.EPBUFCFG.Reg) & 0x3
}
func (o *USB_Type) SetEPBUFCFG_BUF_SB(value uint32) {
	volatile.StoreUint32(&o.EPBUFCFG.Reg, volatile.LoadUint32(&o.EPBUFCFG.Reg)&^(0x3fc)|value<<2)
}
func (o *USB_Type) GetEPBUFCFG_BUF_SB() uint32 {
	return (volatile.LoadUint32(&o.EPBUFCFG.Reg) & 0x3fc) >> 2
}
func (o *USB_Type) SetEPBUFCFG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EPBUFCFG.Reg, volatile.LoadUint32(&o.EPBUFCFG.Reg)&^(0xfffffc00)|value<<10)
}
func (o *USB_Type) GetEPBUFCFG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EPBUFCFG.Reg) & 0xfffffc00) >> 10
}

// USB.INTSTAT: USB interrupt status register
func (o *USB_Type) SetINTSTAT_EP0OUT(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x1)|value)
}
func (o *USB_Type) GetINTSTAT_EP0OUT() uint32 {
	return volatile.LoadUint32(&o.INTSTAT.Reg) & 0x1
}
func (o *USB_Type) SetINTSTAT_EP0IN(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x2)|value<<1)
}
func (o *USB_Type) GetINTSTAT_EP0IN() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x2) >> 1
}
func (o *USB_Type) SetINTSTAT_EP1OUT(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x4)|value<<2)
}
func (o *USB_Type) GetINTSTAT_EP1OUT() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x4) >> 2
}
func (o *USB_Type) SetINTSTAT_EP1IN(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x8)|value<<3)
}
func (o *USB_Type) GetINTSTAT_EP1IN() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x8) >> 3
}
func (o *USB_Type) SetINTSTAT_EP2OUT(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x10)|value<<4)
}
func (o *USB_Type) GetINTSTAT_EP2OUT() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x10) >> 4
}
func (o *USB_Type) SetINTSTAT_EP2IN(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x20)|value<<5)
}
func (o *USB_Type) GetINTSTAT_EP2IN() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x20) >> 5
}
func (o *USB_Type) SetINTSTAT_EP3OUT(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x40)|value<<6)
}
func (o *USB_Type) GetINTSTAT_EP3OUT() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x40) >> 6
}
func (o *USB_Type) SetINTSTAT_EP3IN(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetINTSTAT_EP3IN() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetINTSTAT_EP4OUT(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetINTSTAT_EP4OUT() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetINTSTAT_EP4IN(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x200)|value<<9)
}
func (o *USB_Type) GetINTSTAT_EP4IN() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x200) >> 9
}
func (o *USB_Type) SetINTSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x3ffffc00)|value<<10)
}
func (o *USB_Type) GetINTSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x3ffffc00) >> 10
}
func (o *USB_Type) SetINTSTAT_FRAME_INT(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_Type) GetINTSTAT_FRAME_INT() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x40000000) >> 30
}
func (o *USB_Type) SetINTSTAT_DEV_INT(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_Type) GetINTSTAT_DEV_INT() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x80000000) >> 31
}

// USB.INTEN: USB interrupt enable register
func (o *USB_Type) SetINTEN_EP_INT_EN(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x3ff)|value)
}
func (o *USB_Type) GetINTEN_EP_INT_EN() uint32 {
	return volatile.LoadUint32(&o.INTEN.Reg) & 0x3ff
}
func (o *USB_Type) SetINTEN_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x3ffffc00)|value<<10)
}
func (o *USB_Type) GetINTEN_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x3ffffc00) >> 10
}
func (o *USB_Type) SetINTEN_FRAME_INT_EN(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_Type) GetINTEN_FRAME_INT_EN() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x40000000) >> 30
}
func (o *USB_Type) SetINTEN_DEV_INT_EN(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_Type) GetINTEN_DEV_INT_EN() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x80000000) >> 31
}

// USB.INTSETSTAT: USB set interrupt status register
func (o *USB_Type) SetINTSETSTAT_EP_SET_INT(value uint32) {
	volatile.StoreUint32(&o.INTSETSTAT.Reg, volatile.LoadUint32(&o.INTSETSTAT.Reg)&^(0x3ff)|value)
}
func (o *USB_Type) GetINTSETSTAT_EP_SET_INT() uint32 {
	return volatile.LoadUint32(&o.INTSETSTAT.Reg) & 0x3ff
}
func (o *USB_Type) SetINTSETSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTSETSTAT.Reg, volatile.LoadUint32(&o.INTSETSTAT.Reg)&^(0x3ffffc00)|value<<10)
}
func (o *USB_Type) GetINTSETSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTSETSTAT.Reg) & 0x3ffffc00) >> 10
}
func (o *USB_Type) SetINTSETSTAT_FRAME_SET_INT(value uint32) {
	volatile.StoreUint32(&o.INTSETSTAT.Reg, volatile.LoadUint32(&o.INTSETSTAT.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_Type) GetINTSETSTAT_FRAME_SET_INT() uint32 {
	return (volatile.LoadUint32(&o.INTSETSTAT.Reg) & 0x40000000) >> 30
}
func (o *USB_Type) SetINTSETSTAT_DEV_SET_INT(value uint32) {
	volatile.StoreUint32(&o.INTSETSTAT.Reg, volatile.LoadUint32(&o.INTSETSTAT.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_Type) GetINTSETSTAT_DEV_SET_INT() uint32 {
	return (volatile.LoadUint32(&o.INTSETSTAT.Reg) & 0x80000000) >> 31
}

// USB.INTROUTING: USB interrupt routing register
func (o *USB_Type) SetINTROUTING_ROUTE_INT9_0(value uint32) {
	volatile.StoreUint32(&o.INTROUTING.Reg, volatile.LoadUint32(&o.INTROUTING.Reg)&^(0x3ff)|value)
}
func (o *USB_Type) GetINTROUTING_ROUTE_INT9_0() uint32 {
	return volatile.LoadUint32(&o.INTROUTING.Reg) & 0x3ff
}
func (o *USB_Type) SetINTROUTING_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTROUTING.Reg, volatile.LoadUint32(&o.INTROUTING.Reg)&^(0x3ffffc00)|value<<10)
}
func (o *USB_Type) GetINTROUTING_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTROUTING.Reg) & 0x3ffffc00) >> 10
}
func (o *USB_Type) SetINTROUTING_ROUTE_INT30(value uint32) {
	volatile.StoreUint32(&o.INTROUTING.Reg, volatile.LoadUint32(&o.INTROUTING.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_Type) GetINTROUTING_ROUTE_INT30() uint32 {
	return (volatile.LoadUint32(&o.INTROUTING.Reg) & 0x40000000) >> 30
}
func (o *USB_Type) SetINTROUTING_ROUTE_INT31(value uint32) {
	volatile.StoreUint32(&o.INTROUTING.Reg, volatile.LoadUint32(&o.INTROUTING.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_Type) GetINTROUTING_ROUTE_INT31() uint32 {
	return (volatile.LoadUint32(&o.INTROUTING.Reg) & 0x80000000) >> 31
}

// USB.EPTOGGLE: USB Endpoint toggle register
func (o *USB_Type) SetEPTOGGLE_TOGGLE(value uint32) {
	volatile.StoreUint32(&o.EPTOGGLE.Reg, volatile.LoadUint32(&o.EPTOGGLE.Reg)&^(0x3ff)|value)
}
func (o *USB_Type) GetEPTOGGLE_TOGGLE() uint32 {
	return volatile.LoadUint32(&o.EPTOGGLE.Reg) & 0x3ff
}
func (o *USB_Type) SetEPTOGGLE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EPTOGGLE.Reg, volatile.LoadUint32(&o.EPTOGGLE.Reg)&^(0xfffffc00)|value<<10)
}
func (o *USB_Type) GetEPTOGGLE_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EPTOGGLE.Reg) & 0xfffffc00) >> 10
}

// Cyclic Redundancy Check (CRC) engine
type CRC_Type struct {
	MODE volatile.Register32 // 0x0
	SEED volatile.Register32 // 0x4
	SUM  volatile.Register32 // 0x8
}

// CRC.MODE: CRC mode register
func (o *CRC_Type) SetMODE_CRC_POLY(value uint32) {
	volatile.StoreUint32(&o.MODE.Reg, volatile.LoadUint32(&o.MODE.Reg)&^(0x3)|value)
}
func (o *CRC_Type) GetMODE_CRC_POLY() uint32 {
	return volatile.LoadUint32(&o.MODE.Reg) & 0x3
}
func (o *CRC_Type) SetMODE_BIT_RVS_WR(value uint32) {
	volatile.StoreUint32(&o.MODE.Reg, volatile.LoadUint32(&o.MODE.Reg)&^(0x4)|value<<2)
}
func (o *CRC_Type) GetMODE_BIT_RVS_WR() uint32 {
	return (volatile.LoadUint32(&o.MODE.Reg) & 0x4) >> 2
}
func (o *CRC_Type) SetMODE_CMPL_WR(value uint32) {
	volatile.StoreUint32(&o.MODE.Reg, volatile.LoadUint32(&o.MODE.Reg)&^(0x8)|value<<3)
}
func (o *CRC_Type) GetMODE_CMPL_WR() uint32 {
	return (volatile.LoadUint32(&o.MODE.Reg) & 0x8) >> 3
}
func (o *CRC_Type) SetMODE_BIT_RVS_SUM(value uint32) {
	volatile.StoreUint32(&o.MODE.Reg, volatile.LoadUint32(&o.MODE.Reg)&^(0x10)|value<<4)
}
func (o *CRC_Type) GetMODE_BIT_RVS_SUM() uint32 {
	return (volatile.LoadUint32(&o.MODE.Reg) & 0x10) >> 4
}
func (o *CRC_Type) SetMODE_CMPL_SUM(value uint32) {
	volatile.StoreUint32(&o.MODE.Reg, volatile.LoadUint32(&o.MODE.Reg)&^(0x20)|value<<5)
}
func (o *CRC_Type) GetMODE_CMPL_SUM() uint32 {
	return (volatile.LoadUint32(&o.MODE.Reg) & 0x20) >> 5
}
func (o *CRC_Type) SetMODE_Reserved(value uint32) {
	volatile.StoreUint32(&o.MODE.Reg, volatile.LoadUint32(&o.MODE.Reg)&^(0xffffffc0)|value<<6)
}
func (o *CRC_Type) GetMODE_Reserved() uint32 {
	return (volatile.LoadUint32(&o.MODE.Reg) & 0xffffffc0) >> 6
}

// CRC.SEED: CRC seed register
func (o *CRC_Type) SetSEED(value uint32) {
	volatile.StoreUint32(&o.SEED.Reg, value)
}
func (o *CRC_Type) GetSEED() uint32 {
	return volatile.LoadUint32(&o.SEED.Reg)
}

// CRC.SUM: CRC checksum register
func (o *CRC_Type) SetSUM(value uint32) {
	volatile.StoreUint32(&o.SUM.Reg, value)
}
func (o *CRC_Type) GetSUM() uint32 {
	return volatile.LoadUint32(&o.SUM.Reg)
}

// Large State Configurable Timers 0/1 (SCT0/1)
type SCT0_Type struct {
	CONFIG        volatile.Register32 // 0x0
	CTRL          volatile.Register32 // 0x4
	LIMIT         volatile.Register32 // 0x8
	HALT          volatile.Register32 // 0xC
	STOP          volatile.Register32 // 0x10
	START         volatile.Register32 // 0x14
	DITHER        volatile.Register32 // 0x18
	_             [36]byte
	COUNT         volatile.Register32 // 0x40
	STATE         volatile.Register32 // 0x44
	INPUT         volatile.Register32 // 0x48
	REGMODE       volatile.Register32 // 0x4C
	OUTPUT        volatile.Register32 // 0x50
	OUTPUTDIRCTRL volatile.Register32 // 0x54
	RES           volatile.Register32 // 0x58
	DMAREQ0       volatile.Register32 // 0x5C
	DMAREQ1       volatile.Register32 // 0x60
	_             [140]byte
	EVEN          volatile.Register32 // 0xF0
	EVFLAG        volatile.Register32 // 0xF4
	CONEN         volatile.Register32 // 0xF8
	CONFLAG       volatile.Register32 // 0xFC
	MATCH0        volatile.Register32 // 0x100
	MATCH1        volatile.Register32 // 0x104
	MATCH2        volatile.Register32 // 0x108
	MATCH3        volatile.Register32 // 0x10C
	MATCH4        volatile.Register32 // 0x110
	MATCH5        volatile.Register32 // 0x114
	MATCH6        volatile.Register32 // 0x118
	MATCH7        volatile.Register32 // 0x11C
	MATCH8        volatile.Register32 // 0x120
	MATCH9        volatile.Register32 // 0x124
	MATCH10       volatile.Register32 // 0x128
	MATCH11       volatile.Register32 // 0x12C
	MATCH12       volatile.Register32 // 0x130
	MATCH13       volatile.Register32 // 0x134
	MATCH14       volatile.Register32 // 0x138
	MATCH15       volatile.Register32 // 0x13C
	FRACMAT0      volatile.Register32 // 0x140
	FRACMAT1      volatile.Register32 // 0x144
	FRACMAT2      volatile.Register32 // 0x148
	FRACMAT3      volatile.Register32 // 0x14C
	FRACMAT4      volatile.Register32 // 0x150
	FRACMAT5      volatile.Register32 // 0x154
	_             [168]byte
	MATCHREL0     volatile.Register32 // 0x200
	MATCHREL1     volatile.Register32 // 0x204
	MATCHREL2     volatile.Register32 // 0x208
	MATCHREL3     volatile.Register32 // 0x20C
	MATCHREL4     volatile.Register32 // 0x210
	MATCHREL5     volatile.Register32 // 0x214
	MATCHREL6     volatile.Register32 // 0x218
	MATCHREL7     volatile.Register32 // 0x21C
	MATCHREL8     volatile.Register32 // 0x220
	MATCHREL9     volatile.Register32 // 0x224
	MATCHREL10    volatile.Register32 // 0x228
	MATCHREL11    volatile.Register32 // 0x22C
	MATCHREL12    volatile.Register32 // 0x230
	MATCHREL13    volatile.Register32 // 0x234
	MATCHREL14    volatile.Register32 // 0x238
	MATCHREL15    volatile.Register32 // 0x23C
	FRACMATREL0   volatile.Register32 // 0x240
	FRACMATREL1   volatile.Register32 // 0x244
	FRACMATREL2   volatile.Register32 // 0x248
	FRACMATREL3   volatile.Register32 // 0x24C
	FRACMATREL4   volatile.Register32 // 0x250
	FRACMATREL5   volatile.Register32 // 0x254
	_             [168]byte
	EV0_STATE     volatile.Register32 // 0x300
	EV0_CTRL      volatile.Register32 // 0x304
	EV1_STATE     volatile.Register32 // 0x308
	EV1_CTRL      volatile.Register32 // 0x30C
	EV2_STATE     volatile.Register32 // 0x310
	EV2_CTRL      volatile.Register32 // 0x314
	EV3_STATE     volatile.Register32 // 0x318
	EV3_CTRL      volatile.Register32 // 0x31C
	EV4_STATE     volatile.Register32 // 0x320
	EV4_CTRL      volatile.Register32 // 0x324
	EV5_STATE     volatile.Register32 // 0x328
	EV5_CTRL      volatile.Register32 // 0x32C
	EV6_STATE     volatile.Register32 // 0x330
	EV6_CTRL      volatile.Register32 // 0x334
	EV7_STATE     volatile.Register32 // 0x338
	EV7_CTRL      volatile.Register32 // 0x33C
	EV8_STATE     volatile.Register32 // 0x340
	EV8_CTRL      volatile.Register32 // 0x344
	EV9_STATE     volatile.Register32 // 0x348
	EV9_CTRL      volatile.Register32 // 0x34C
	EV10_STATE    volatile.Register32 // 0x350
	EV10_CTRL     volatile.Register32 // 0x354
	EV11_STATE    volatile.Register32 // 0x358
	EV11_CTRL     volatile.Register32 // 0x35C
	EV12_STATE    volatile.Register32 // 0x360
	EV12_CTRL     volatile.Register32 // 0x364
	EV13_STATE    volatile.Register32 // 0x368
	EV13_CTRL     volatile.Register32 // 0x36C
	EV14_STATE    volatile.Register32 // 0x370
	EV14_CTRL     volatile.Register32 // 0x374
	EV15_STATE    volatile.Register32 // 0x378
	EV15_CTRL     volatile.Register32 // 0x37C
	_             [384]byte
	OUT0_SET      volatile.Register32 // 0x500
	OUT0_CLR      volatile.Register32 // 0x504
	OUT1_SET      volatile.Register32 // 0x508
	OUT1_CLR      volatile.Register32 // 0x50C
	OUT2_SET      volatile.Register32 // 0x510
	OUT2_CLR      volatile.Register32 // 0x514
	OUT3_SET      volatile.Register32 // 0x518
	OUT3_CLR      volatile.Register32 // 0x51C
	OUT4_SET      volatile.Register32 // 0x520
	OUT4_CLR      volatile.Register32 // 0x524
	OUT5_SET      volatile.Register32 // 0x528
	OUT5_CLR      volatile.Register32 // 0x52C
	OUT6_SET      volatile.Register32 // 0x530
	OUT6_CLR      volatile.Register32 // 0x534
	OUT7_SET      volatile.Register32 // 0x538
	OUT7_CLR      volatile.Register32 // 0x53C
	OUT8_SET      volatile.Register32 // 0x540
	OUT8_CLR      volatile.Register32 // 0x544
	OUT9_SET      volatile.Register32 // 0x548
	OUT9_CLR      volatile.Register32 // 0x54C
}

// SCT0.CONFIG: SCT configuration register
func (o *SCT0_Type) SetCONFIG_UNIFY(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x1)|value)
}
func (o *SCT0_Type) GetCONFIG_UNIFY() uint32 {
	return volatile.LoadUint32(&o.CONFIG.Reg) & 0x1
}
func (o *SCT0_Type) SetCONFIG_CLKMODE(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x6)|value<<1)
}
func (o *SCT0_Type) GetCONFIG_CLKMODE() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0x6) >> 1
}
func (o *SCT0_Type) SetCONFIG_CLKSEL(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x78)|value<<3)
}
func (o *SCT0_Type) GetCONFIG_CLKSEL() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0x78) >> 3
}
func (o *SCT0_Type) SetCONFIG_NORELAOD_L(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x80)|value<<7)
}
func (o *SCT0_Type) GetCONFIG_NORELAOD_L() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0x80) >> 7
}
func (o *SCT0_Type) SetCONFIG_NORELOAD_H(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x100)|value<<8)
}
func (o *SCT0_Type) GetCONFIG_NORELOAD_H() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0x100) >> 8
}
func (o *SCT0_Type) SetCONFIG_INSYNC(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x1fe00)|value<<9)
}
func (o *SCT0_Type) GetCONFIG_INSYNC() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0x1fe00) >> 9
}
func (o *SCT0_Type) SetCONFIG_AUTOLIMIT_L(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x20000)|value<<17)
}
func (o *SCT0_Type) GetCONFIG_AUTOLIMIT_L() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0x20000) >> 17
}
func (o *SCT0_Type) SetCONFIG_AUTOLIMIT_H(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x40000)|value<<18)
}
func (o *SCT0_Type) GetCONFIG_AUTOLIMIT_H() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0x40000) >> 18
}
func (o *SCT0_Type) SetCONFIG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0xfff80000)|value<<19)
}
func (o *SCT0_Type) GetCONFIG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0xfff80000) >> 19
}

// SCT0.CTRL: SCT control register
func (o *SCT0_Type) SetCTRL_DOWN_L(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x1)|value)
}
func (o *SCT0_Type) GetCTRL_DOWN_L() uint32 {
	return volatile.LoadUint32(&o.CTRL.Reg) & 0x1
}
func (o *SCT0_Type) SetCTRL_STOP_L(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x2)|value<<1)
}
func (o *SCT0_Type) GetCTRL_STOP_L() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x2) >> 1
}
func (o *SCT0_Type) SetCTRL_HALT_L(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x4)|value<<2)
}
func (o *SCT0_Type) GetCTRL_HALT_L() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x4) >> 2
}
func (o *SCT0_Type) SetCTRL_CLRCTR_L(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x8)|value<<3)
}
func (o *SCT0_Type) GetCTRL_CLRCTR_L() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x8) >> 3
}
func (o *SCT0_Type) SetCTRL_BIDIR_L(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x10)|value<<4)
}
func (o *SCT0_Type) GetCTRL_BIDIR_L() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x10) >> 4
}
func (o *SCT0_Type) SetCTRL_PRE_L(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x1fe0)|value<<5)
}
func (o *SCT0_Type) GetCTRL_PRE_L() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x1fe0) >> 5
}
func (o *SCT0_Type) SetCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0xe000)|value<<13)
}
func (o *SCT0_Type) GetCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0xe000) >> 13
}
func (o *SCT0_Type) SetCTRL_DOWN_H(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x10000)|value<<16)
}
func (o *SCT0_Type) GetCTRL_DOWN_H() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x10000) >> 16
}
func (o *SCT0_Type) SetCTRL_STOP_H(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x20000)|value<<17)
}
func (o *SCT0_Type) GetCTRL_STOP_H() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x20000) >> 17
}
func (o *SCT0_Type) SetCTRL_HALT_H(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x40000)|value<<18)
}
func (o *SCT0_Type) GetCTRL_HALT_H() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x40000) >> 18
}
func (o *SCT0_Type) SetCTRL_CLRCTR_H(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x80000)|value<<19)
}
func (o *SCT0_Type) GetCTRL_CLRCTR_H() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x80000) >> 19
}
func (o *SCT0_Type) SetCTRL_BIDIR_H(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x100000)|value<<20)
}
func (o *SCT0_Type) GetCTRL_BIDIR_H() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x100000) >> 20
}
func (o *SCT0_Type) SetCTRL_PRE_H(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x1fe00000)|value<<21)
}
func (o *SCT0_Type) GetCTRL_PRE_H() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x1fe00000) >> 21
}
func (o *SCT0_Type) SetCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0xe0000000)|value<<29)
}
func (o *SCT0_Type) GetCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0xe0000000) >> 29
}

// SCT0.LIMIT: SCT limit register
func (o *SCT0_Type) SetLIMIT_LIMMSK_L(value uint32) {
	volatile.StoreUint32(&o.LIMIT.Reg, volatile.LoadUint32(&o.LIMIT.Reg)&^(0xffff)|value)
}
func (o *SCT0_Type) GetLIMIT_LIMMSK_L() uint32 {
	return volatile.LoadUint32(&o.LIMIT.Reg) & 0xffff
}
func (o *SCT0_Type) SetLIMIT_LIMMSK_H(value uint32) {
	volatile.StoreUint32(&o.LIMIT.Reg, volatile.LoadUint32(&o.LIMIT.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT0_Type) GetLIMIT_LIMMSK_H() uint32 {
	return (volatile.LoadUint32(&o.LIMIT.Reg) & 0xffff0000) >> 16
}

// SCT0.HALT: SCT halt condition register
func (o *SCT0_Type) SetHALT_HALTMSK_L(value uint32) {
	volatile.StoreUint32(&o.HALT.Reg, volatile.LoadUint32(&o.HALT.Reg)&^(0xffff)|value)
}
func (o *SCT0_Type) GetHALT_HALTMSK_L() uint32 {
	return volatile.LoadUint32(&o.HALT.Reg) & 0xffff
}
func (o *SCT0_Type) SetHALT_HALTMSK_H(value uint32) {
	volatile.StoreUint32(&o.HALT.Reg, volatile.LoadUint32(&o.HALT.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT0_Type) GetHALT_HALTMSK_H() uint32 {
	return (volatile.LoadUint32(&o.HALT.Reg) & 0xffff0000) >> 16
}

// SCT0.STOP: SCT stop condition register
func (o *SCT0_Type) SetSTOP_STOPMSK_L(value uint32) {
	volatile.StoreUint32(&o.STOP.Reg, volatile.LoadUint32(&o.STOP.Reg)&^(0xffff)|value)
}
func (o *SCT0_Type) GetSTOP_STOPMSK_L() uint32 {
	return volatile.LoadUint32(&o.STOP.Reg) & 0xffff
}
func (o *SCT0_Type) SetSTOP_STOPMSK_H(value uint32) {
	volatile.StoreUint32(&o.STOP.Reg, volatile.LoadUint32(&o.STOP.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT0_Type) GetSTOP_STOPMSK_H() uint32 {
	return (volatile.LoadUint32(&o.STOP.Reg) & 0xffff0000) >> 16
}

// SCT0.START: SCT start condition register
func (o *SCT0_Type) SetSTART_STARTMSK_L(value uint32) {
	volatile.StoreUint32(&o.START.Reg, volatile.LoadUint32(&o.START.Reg)&^(0xffff)|value)
}
func (o *SCT0_Type) GetSTART_STARTMSK_L() uint32 {
	return volatile.LoadUint32(&o.START.Reg) & 0xffff
}
func (o *SCT0_Type) SetSTART_STARTMSK_H(value uint32) {
	volatile.StoreUint32(&o.START.Reg, volatile.LoadUint32(&o.START.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT0_Type) GetSTART_STARTMSK_H() uint32 {
	return (volatile.LoadUint32(&o.START.Reg) & 0xffff0000) >> 16
}

// SCT0.DITHER: SCT dither condition register
func (o *SCT0_Type) SetDITHER_DITHMSK_L(value uint32) {
	volatile.StoreUint32(&o.DITHER.Reg, volatile.LoadUint32(&o.DITHER.Reg)&^(0xffff)|value)
}
func (o *SCT0_Type) GetDITHER_DITHMSK_L() uint32 {
	return volatile.LoadUint32(&o.DITHER.Reg) & 0xffff
}
func (o *SCT0_Type) SetDITHER_DITHMSK_H(value uint32) {
	volatile.StoreUint32(&o.DITHER.Reg, volatile.LoadUint32(&o.DITHER.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT0_Type) GetDITHER_DITHMSK_H() uint32 {
	return (volatile.LoadUint32(&o.DITHER.Reg) & 0xffff0000) >> 16
}

// SCT0.COUNT: SCT counter register
func (o *SCT0_Type) SetCOUNT_CTR_L(value uint32) {
	volatile.StoreUint32(&o.COUNT.Reg, volatile.LoadUint32(&o.COUNT.Reg)&^(0xffff)|value)
}
func (o *SCT0_Type) GetCOUNT_CTR_L() uint32 {
	return volatile.LoadUint32(&o.COUNT.Reg) & 0xffff
}
func (o *SCT0_Type) SetCOUNT_CTR_H(value uint32) {
	volatile.StoreUint32(&o.COUNT.Reg, volatile.LoadUint32(&o.COUNT.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT0_Type) GetCOUNT_CTR_H() uint32 {
	return (volatile.LoadUint32(&o.COUNT.Reg) & 0xffff0000) >> 16
}

// SCT0.STATE: SCT state register
func (o *SCT0_Type) SetSTATE_STATE_L(value uint32) {
	volatile.StoreUint32(&o.STATE.Reg, volatile.LoadUint32(&o.STATE.Reg)&^(0x1f)|value)
}
func (o *SCT0_Type) GetSTATE_STATE_L() uint32 {
	return volatile.LoadUint32(&o.STATE.Reg) & 0x1f
}
func (o *SCT0_Type) SetSTATE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATE.Reg, volatile.LoadUint32(&o.STATE.Reg)&^(0xffe0)|value<<5)
}
func (o *SCT0_Type) GetSTATE_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATE.Reg) & 0xffe0) >> 5
}
func (o *SCT0_Type) SetSTATE_STATE_H(value uint32) {
	volatile.StoreUint32(&o.STATE.Reg, volatile.LoadUint32(&o.STATE.Reg)&^(0x1f0000)|value<<16)
}
func (o *SCT0_Type) GetSTATE_STATE_H() uint32 {
	return (volatile.LoadUint32(&o.STATE.Reg) & 0x1f0000) >> 16
}
func (o *SCT0_Type) SetSTATE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATE.Reg, volatile.LoadUint32(&o.STATE.Reg)&^(0xffe00000)|value<<21)
}
func (o *SCT0_Type) GetSTATE_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATE.Reg) & 0xffe00000) >> 21
}

// SCT0.INPUT: SCT input register
func (o *SCT0_Type) SetINPUT_AIN0(value uint32) {
	volatile.StoreUint32(&o.INPUT.Reg, volatile.LoadUint32(&o.INPUT.Reg)&^(0x1)|value)
}
func (o *SCT0_Type) GetINPUT_AIN0() uint32 {
	return volatile.LoadUint32(&o.INPUT.Reg) & 0x1
}
func (o *SCT0_Type) SetINPUT_AIN1(value uint32) {
	volatile.StoreUint32(&o.INPUT.Reg, volatile.LoadUint32(&o.INPUT.Reg)&^(0x2)|value<<1)
}
func (o *SCT0_Type) GetINPUT_AIN1() uint32 {
	return (volatile.LoadUint32(&o.INPUT.Reg) & 0x2) >> 1
}
func (o *SCT0_Type) SetINPUT_AIN2(value uint32) {
	volatile.StoreUint32(&o.INPUT.Reg, volatile.LoadUint32(&o.INPUT.Reg)&^(0x4)|value<<2)
}
func (o *SCT0_Type) GetINPUT_AIN2() uint32 {
	return (volatile.LoadUint32(&o.INPUT.Reg) & 0x4) >> 2
}
func (o *SCT0_Type) SetINPUT_AIN3(value uint32) {
	volatile.StoreUint32(&o.INPUT.Reg, volatile.LoadUint32(&o.INPUT.Reg)&^(0x8)|value<<3)
}
func (o *SCT0_Type) GetINPUT_AIN3() uint32 {
	return (volatile.LoadUint32(&o.INPUT.Reg) & 0x8) >> 3
}
func (o *SCT0_Type) SetINPUT_AIN4(value uint32) {
	volatile.StoreUint32(&o.INPUT.Reg, volatile.LoadUint32(&o.INPUT.Reg)&^(0x10)|value<<4)
}
func (o *SCT0_Type) GetINPUT_AIN4() uint32 {
	return (volatile.LoadUint32(&o.INPUT.Reg) & 0x10) >> 4
}
func (o *SCT0_Type) SetINPUT_AIN5(value uint32) {
	volatile.StoreUint32(&o.INPUT.Reg, volatile.LoadUint32(&o.INPUT.Reg)&^(0x20)|value<<5)
}
func (o *SCT0_Type) GetINPUT_AIN5() uint32 {
	return (volatile.LoadUint32(&o.INPUT.Reg) & 0x20) >> 5
}
func (o *SCT0_Type) SetINPUT_AIN6(value uint32) {
	volatile.StoreUint32(&o.INPUT.Reg, volatile.LoadUint32(&o.INPUT.Reg)&^(0x40)|value<<6)
}
func (o *SCT0_Type) GetINPUT_AIN6() uint32 {
	return (volatile.LoadUint32(&o.INPUT.Reg) & 0x40) >> 6
}
func (o *SCT0_Type) SetINPUT_AIN7(value uint32) {
	volatile.StoreUint32(&o.INPUT.Reg, volatile.LoadUint32(&o.INPUT.Reg)&^(0x80)|value<<7)
}
func (o *SCT0_Type) GetINPUT_AIN7() uint32 {
	return (volatile.LoadUint32(&o.INPUT.Reg) & 0x80) >> 7
}
func (o *SCT0_Type) SetINPUT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INPUT.Reg, volatile.LoadUint32(&o.INPUT.Reg)&^(0xff00)|value<<8)
}
func (o *SCT0_Type) GetINPUT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INPUT.Reg) & 0xff00) >> 8
}
func (o *SCT0_Type) SetINPUT_SIN0(value uint32) {
	volatile.StoreUint32(&o.INPUT.Reg, volatile.LoadUint32(&o.INPUT.Reg)&^(0x10000)|value<<16)
}
func (o *SCT0_Type) GetINPUT_SIN0() uint32 {
	return (volatile.LoadUint32(&o.INPUT.Reg) & 0x10000) >> 16
}
func (o *SCT0_Type) SetINPUT_SIN1(value uint32) {
	volatile.StoreUint32(&o.INPUT.Reg, volatile.LoadUint32(&o.INPUT.Reg)&^(0x20000)|value<<17)
}
func (o *SCT0_Type) GetINPUT_SIN1() uint32 {
	return (volatile.LoadUint32(&o.INPUT.Reg) & 0x20000) >> 17
}
func (o *SCT0_Type) SetINPUT_SIN2(value uint32) {
	volatile.StoreUint32(&o.INPUT.Reg, volatile.LoadUint32(&o.INPUT.Reg)&^(0x40000)|value<<18)
}
func (o *SCT0_Type) GetINPUT_SIN2() uint32 {
	return (volatile.LoadUint32(&o.INPUT.Reg) & 0x40000) >> 18
}
func (o *SCT0_Type) SetINPUT_SIN3(value uint32) {
	volatile.StoreUint32(&o.INPUT.Reg, volatile.LoadUint32(&o.INPUT.Reg)&^(0x80000)|value<<19)
}
func (o *SCT0_Type) GetINPUT_SIN3() uint32 {
	return (volatile.LoadUint32(&o.INPUT.Reg) & 0x80000) >> 19
}
func (o *SCT0_Type) SetINPUT_SIN4(value uint32) {
	volatile.StoreUint32(&o.INPUT.Reg, volatile.LoadUint32(&o.INPUT.Reg)&^(0x100000)|value<<20)
}
func (o *SCT0_Type) GetINPUT_SIN4() uint32 {
	return (volatile.LoadUint32(&o.INPUT.Reg) & 0x100000) >> 20
}
func (o *SCT0_Type) SetINPUT_SIN5(value uint32) {
	volatile.StoreUint32(&o.INPUT.Reg, volatile.LoadUint32(&o.INPUT.Reg)&^(0x200000)|value<<21)
}
func (o *SCT0_Type) GetINPUT_SIN5() uint32 {
	return (volatile.LoadUint32(&o.INPUT.Reg) & 0x200000) >> 21
}
func (o *SCT0_Type) SetINPUT_SIN6(value uint32) {
	volatile.StoreUint32(&o.INPUT.Reg, volatile.LoadUint32(&o.INPUT.Reg)&^(0x400000)|value<<22)
}
func (o *SCT0_Type) GetINPUT_SIN6() uint32 {
	return (volatile.LoadUint32(&o.INPUT.Reg) & 0x400000) >> 22
}
func (o *SCT0_Type) SetINPUT_SIN7(value uint32) {
	volatile.StoreUint32(&o.INPUT.Reg, volatile.LoadUint32(&o.INPUT.Reg)&^(0x800000)|value<<23)
}
func (o *SCT0_Type) GetINPUT_SIN7() uint32 {
	return (volatile.LoadUint32(&o.INPUT.Reg) & 0x800000) >> 23
}
func (o *SCT0_Type) SetINPUT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INPUT.Reg, volatile.LoadUint32(&o.INPUT.Reg)&^(0xff000000)|value<<24)
}
func (o *SCT0_Type) GetINPUT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INPUT.Reg) & 0xff000000) >> 24
}

// SCT0.REGMODE: SCT match/capture registers mode register
func (o *SCT0_Type) SetREGMODE_REGMOD_L(value uint32) {
	volatile.StoreUint32(&o.REGMODE.Reg, volatile.LoadUint32(&o.REGMODE.Reg)&^(0xffff)|value)
}
func (o *SCT0_Type) GetREGMODE_REGMOD_L() uint32 {
	return volatile.LoadUint32(&o.REGMODE.Reg) & 0xffff
}
func (o *SCT0_Type) SetREGMODE_REGMOD_H(value uint32) {
	volatile.StoreUint32(&o.REGMODE.Reg, volatile.LoadUint32(&o.REGMODE.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT0_Type) GetREGMODE_REGMOD_H() uint32 {
	return (volatile.LoadUint32(&o.REGMODE.Reg) & 0xffff0000) >> 16
}

// SCT0.OUTPUT: SCT output register
func (o *SCT0_Type) SetOUTPUT_OUT(value uint32) {
	volatile.StoreUint32(&o.OUTPUT.Reg, volatile.LoadUint32(&o.OUTPUT.Reg)&^(0x3ff)|value)
}
func (o *SCT0_Type) GetOUTPUT_OUT() uint32 {
	return volatile.LoadUint32(&o.OUTPUT.Reg) & 0x3ff
}
func (o *SCT0_Type) SetOUTPUT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.OUTPUT.Reg, volatile.LoadUint32(&o.OUTPUT.Reg)&^(0xfffffc00)|value<<10)
}
func (o *SCT0_Type) GetOUTPUT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.OUTPUT.Reg) & 0xfffffc00) >> 10
}

// SCT0.OUTPUTDIRCTRL: SCT output counter direction control register
func (o *SCT0_Type) SetOUTPUTDIRCTRL_SETCLR0(value uint32) {
	volatile.StoreUint32(&o.OUTPUTDIRCTRL.Reg, volatile.LoadUint32(&o.OUTPUTDIRCTRL.Reg)&^(0x3)|value)
}
func (o *SCT0_Type) GetOUTPUTDIRCTRL_SETCLR0() uint32 {
	return volatile.LoadUint32(&o.OUTPUTDIRCTRL.Reg) & 0x3
}
func (o *SCT0_Type) SetOUTPUTDIRCTRL_SETCLR1(value uint32) {
	volatile.StoreUint32(&o.OUTPUTDIRCTRL.Reg, volatile.LoadUint32(&o.OUTPUTDIRCTRL.Reg)&^(0xc)|value<<2)
}
func (o *SCT0_Type) GetOUTPUTDIRCTRL_SETCLR1() uint32 {
	return (volatile.LoadUint32(&o.OUTPUTDIRCTRL.Reg) & 0xc) >> 2
}
func (o *SCT0_Type) SetOUTPUTDIRCTRL_SETCLR2(value uint32) {
	volatile.StoreUint32(&o.OUTPUTDIRCTRL.Reg, volatile.LoadUint32(&o.OUTPUTDIRCTRL.Reg)&^(0x30)|value<<4)
}
func (o *SCT0_Type) GetOUTPUTDIRCTRL_SETCLR2() uint32 {
	return (volatile.LoadUint32(&o.OUTPUTDIRCTRL.Reg) & 0x30) >> 4
}
func (o *SCT0_Type) SetOUTPUTDIRCTRL_SETCLR3(value uint32) {
	volatile.StoreUint32(&o.OUTPUTDIRCTRL.Reg, volatile.LoadUint32(&o.OUTPUTDIRCTRL.Reg)&^(0xc0)|value<<6)
}
func (o *SCT0_Type) GetOUTPUTDIRCTRL_SETCLR3() uint32 {
	return (volatile.LoadUint32(&o.OUTPUTDIRCTRL.Reg) & 0xc0) >> 6
}
func (o *SCT0_Type) SetOUTPUTDIRCTRL_SETCLR4(value uint32) {
	volatile.StoreUint32(&o.OUTPUTDIRCTRL.Reg, volatile.LoadUint32(&o.OUTPUTDIRCTRL.Reg)&^(0x300)|value<<8)
}
func (o *SCT0_Type) GetOUTPUTDIRCTRL_SETCLR4() uint32 {
	return (volatile.LoadUint32(&o.OUTPUTDIRCTRL.Reg) & 0x300) >> 8
}
func (o *SCT0_Type) SetOUTPUTDIRCTRL_SETCLR5(value uint32) {
	volatile.StoreUint32(&o.OUTPUTDIRCTRL.Reg, volatile.LoadUint32(&o.OUTPUTDIRCTRL.Reg)&^(0xc00)|value<<10)
}
func (o *SCT0_Type) GetOUTPUTDIRCTRL_SETCLR5() uint32 {
	return (volatile.LoadUint32(&o.OUTPUTDIRCTRL.Reg) & 0xc00) >> 10
}
func (o *SCT0_Type) SetOUTPUTDIRCTRL_SETCLR6(value uint32) {
	volatile.StoreUint32(&o.OUTPUTDIRCTRL.Reg, volatile.LoadUint32(&o.OUTPUTDIRCTRL.Reg)&^(0x3000)|value<<12)
}
func (o *SCT0_Type) GetOUTPUTDIRCTRL_SETCLR6() uint32 {
	return (volatile.LoadUint32(&o.OUTPUTDIRCTRL.Reg) & 0x3000) >> 12
}
func (o *SCT0_Type) SetOUTPUTDIRCTRL_SETCLR7(value uint32) {
	volatile.StoreUint32(&o.OUTPUTDIRCTRL.Reg, volatile.LoadUint32(&o.OUTPUTDIRCTRL.Reg)&^(0xc000)|value<<14)
}
func (o *SCT0_Type) GetOUTPUTDIRCTRL_SETCLR7() uint32 {
	return (volatile.LoadUint32(&o.OUTPUTDIRCTRL.Reg) & 0xc000) >> 14
}
func (o *SCT0_Type) SetOUTPUTDIRCTRL_SETCLR8(value uint32) {
	volatile.StoreUint32(&o.OUTPUTDIRCTRL.Reg, volatile.LoadUint32(&o.OUTPUTDIRCTRL.Reg)&^(0x30000)|value<<16)
}
func (o *SCT0_Type) GetOUTPUTDIRCTRL_SETCLR8() uint32 {
	return (volatile.LoadUint32(&o.OUTPUTDIRCTRL.Reg) & 0x30000) >> 16
}
func (o *SCT0_Type) SetOUTPUTDIRCTRL_SETCLR9(value uint32) {
	volatile.StoreUint32(&o.OUTPUTDIRCTRL.Reg, volatile.LoadUint32(&o.OUTPUTDIRCTRL.Reg)&^(0xc0000)|value<<18)
}
func (o *SCT0_Type) GetOUTPUTDIRCTRL_SETCLR9() uint32 {
	return (volatile.LoadUint32(&o.OUTPUTDIRCTRL.Reg) & 0xc0000) >> 18
}
func (o *SCT0_Type) SetOUTPUTDIRCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.OUTPUTDIRCTRL.Reg, volatile.LoadUint32(&o.OUTPUTDIRCTRL.Reg)&^(0xfff00000)|value<<20)
}
func (o *SCT0_Type) GetOUTPUTDIRCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.OUTPUTDIRCTRL.Reg) & 0xfff00000) >> 20
}

// SCT0.RES: SCT conflict resolution register
func (o *SCT0_Type) SetRES_O0RES(value uint32) {
	volatile.StoreUint32(&o.RES.Reg, volatile.LoadUint32(&o.RES.Reg)&^(0x3)|value)
}
func (o *SCT0_Type) GetRES_O0RES() uint32 {
	return volatile.LoadUint32(&o.RES.Reg) & 0x3
}
func (o *SCT0_Type) SetRES_O1RES(value uint32) {
	volatile.StoreUint32(&o.RES.Reg, volatile.LoadUint32(&o.RES.Reg)&^(0xc)|value<<2)
}
func (o *SCT0_Type) GetRES_O1RES() uint32 {
	return (volatile.LoadUint32(&o.RES.Reg) & 0xc) >> 2
}
func (o *SCT0_Type) SetRES_O2RES(value uint32) {
	volatile.StoreUint32(&o.RES.Reg, volatile.LoadUint32(&o.RES.Reg)&^(0x30)|value<<4)
}
func (o *SCT0_Type) GetRES_O2RES() uint32 {
	return (volatile.LoadUint32(&o.RES.Reg) & 0x30) >> 4
}
func (o *SCT0_Type) SetRES_O3RES(value uint32) {
	volatile.StoreUint32(&o.RES.Reg, volatile.LoadUint32(&o.RES.Reg)&^(0xc0)|value<<6)
}
func (o *SCT0_Type) GetRES_O3RES() uint32 {
	return (volatile.LoadUint32(&o.RES.Reg) & 0xc0) >> 6
}
func (o *SCT0_Type) SetRES_O4RES(value uint32) {
	volatile.StoreUint32(&o.RES.Reg, volatile.LoadUint32(&o.RES.Reg)&^(0x300)|value<<8)
}
func (o *SCT0_Type) GetRES_O4RES() uint32 {
	return (volatile.LoadUint32(&o.RES.Reg) & 0x300) >> 8
}
func (o *SCT0_Type) SetRES_O5RES(value uint32) {
	volatile.StoreUint32(&o.RES.Reg, volatile.LoadUint32(&o.RES.Reg)&^(0xc00)|value<<10)
}
func (o *SCT0_Type) GetRES_O5RES() uint32 {
	return (volatile.LoadUint32(&o.RES.Reg) & 0xc00) >> 10
}
func (o *SCT0_Type) SetRES_O6RES(value uint32) {
	volatile.StoreUint32(&o.RES.Reg, volatile.LoadUint32(&o.RES.Reg)&^(0x3000)|value<<12)
}
func (o *SCT0_Type) GetRES_O6RES() uint32 {
	return (volatile.LoadUint32(&o.RES.Reg) & 0x3000) >> 12
}
func (o *SCT0_Type) SetRES_O7RES(value uint32) {
	volatile.StoreUint32(&o.RES.Reg, volatile.LoadUint32(&o.RES.Reg)&^(0xc000)|value<<14)
}
func (o *SCT0_Type) GetRES_O7RES() uint32 {
	return (volatile.LoadUint32(&o.RES.Reg) & 0xc000) >> 14
}
func (o *SCT0_Type) SetRES_O8RES(value uint32) {
	volatile.StoreUint32(&o.RES.Reg, volatile.LoadUint32(&o.RES.Reg)&^(0x30000)|value<<16)
}
func (o *SCT0_Type) GetRES_O8RES() uint32 {
	return (volatile.LoadUint32(&o.RES.Reg) & 0x30000) >> 16
}
func (o *SCT0_Type) SetRES_O9RES(value uint32) {
	volatile.StoreUint32(&o.RES.Reg, volatile.LoadUint32(&o.RES.Reg)&^(0xc0000)|value<<18)
}
func (o *SCT0_Type) GetRES_O9RES() uint32 {
	return (volatile.LoadUint32(&o.RES.Reg) & 0xc0000) >> 18
}
func (o *SCT0_Type) SetRES_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RES.Reg, volatile.LoadUint32(&o.RES.Reg)&^(0xfff00000)|value<<20)
}
func (o *SCT0_Type) GetRES_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.RES.Reg) & 0xfff00000) >> 20
}

// SCT0.DMAREQ0: SCT DMA request 0 register
func (o *SCT0_Type) SetDMAREQ0_DEV_0(value uint32) {
	volatile.StoreUint32(&o.DMAREQ0.Reg, volatile.LoadUint32(&o.DMAREQ0.Reg)&^(0xffff)|value)
}
func (o *SCT0_Type) GetDMAREQ0_DEV_0() uint32 {
	return volatile.LoadUint32(&o.DMAREQ0.Reg) & 0xffff
}
func (o *SCT0_Type) SetDMAREQ0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DMAREQ0.Reg, volatile.LoadUint32(&o.DMAREQ0.Reg)&^(0x3fff0000)|value<<16)
}
func (o *SCT0_Type) GetDMAREQ0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DMAREQ0.Reg) & 0x3fff0000) >> 16
}
func (o *SCT0_Type) SetDMAREQ0_DRL0(value uint32) {
	volatile.StoreUint32(&o.DMAREQ0.Reg, volatile.LoadUint32(&o.DMAREQ0.Reg)&^(0x40000000)|value<<30)
}
func (o *SCT0_Type) GetDMAREQ0_DRL0() uint32 {
	return (volatile.LoadUint32(&o.DMAREQ0.Reg) & 0x40000000) >> 30
}
func (o *SCT0_Type) SetDMAREQ0_DRQ0(value uint32) {
	volatile.StoreUint32(&o.DMAREQ0.Reg, volatile.LoadUint32(&o.DMAREQ0.Reg)&^(0x80000000)|value<<31)
}
func (o *SCT0_Type) GetDMAREQ0_DRQ0() uint32 {
	return (volatile.LoadUint32(&o.DMAREQ0.Reg) & 0x80000000) >> 31
}

// SCT0.DMAREQ1: SCT DMA request 1 register
func (o *SCT0_Type) SetDMAREQ1_DEV_1(value uint32) {
	volatile.StoreUint32(&o.DMAREQ1.Reg, volatile.LoadUint32(&o.DMAREQ1.Reg)&^(0xffff)|value)
}
func (o *SCT0_Type) GetDMAREQ1_DEV_1() uint32 {
	return volatile.LoadUint32(&o.DMAREQ1.Reg) & 0xffff
}
func (o *SCT0_Type) SetDMAREQ1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DMAREQ1.Reg, volatile.LoadUint32(&o.DMAREQ1.Reg)&^(0x3fff0000)|value<<16)
}
func (o *SCT0_Type) GetDMAREQ1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DMAREQ1.Reg) & 0x3fff0000) >> 16
}
func (o *SCT0_Type) SetDMAREQ1_DRL1(value uint32) {
	volatile.StoreUint32(&o.DMAREQ1.Reg, volatile.LoadUint32(&o.DMAREQ1.Reg)&^(0x40000000)|value<<30)
}
func (o *SCT0_Type) GetDMAREQ1_DRL1() uint32 {
	return (volatile.LoadUint32(&o.DMAREQ1.Reg) & 0x40000000) >> 30
}
func (o *SCT0_Type) SetDMAREQ1_DRQ1(value uint32) {
	volatile.StoreUint32(&o.DMAREQ1.Reg, volatile.LoadUint32(&o.DMAREQ1.Reg)&^(0x80000000)|value<<31)
}
func (o *SCT0_Type) GetDMAREQ1_DRQ1() uint32 {
	return (volatile.LoadUint32(&o.DMAREQ1.Reg) & 0x80000000) >> 31
}

// SCT0.EVEN: SCT event enable register
func (o *SCT0_Type) SetEVEN_IEN(value uint32) {
	volatile.StoreUint32(&o.EVEN.Reg, volatile.LoadUint32(&o.EVEN.Reg)&^(0xffff)|value)
}
func (o *SCT0_Type) GetEVEN_IEN() uint32 {
	return volatile.LoadUint32(&o.EVEN.Reg) & 0xffff
}
func (o *SCT0_Type) SetEVEN_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EVEN.Reg, volatile.LoadUint32(&o.EVEN.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT0_Type) GetEVEN_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EVEN.Reg) & 0xffff0000) >> 16
}

// SCT0.EVFLAG: SCT event flag register
func (o *SCT0_Type) SetEVFLAG_FLAG(value uint32) {
	volatile.StoreUint32(&o.EVFLAG.Reg, volatile.LoadUint32(&o.EVFLAG.Reg)&^(0xffff)|value)
}
func (o *SCT0_Type) GetEVFLAG_FLAG() uint32 {
	return volatile.LoadUint32(&o.EVFLAG.Reg) & 0xffff
}
func (o *SCT0_Type) SetEVFLAG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EVFLAG.Reg, volatile.LoadUint32(&o.EVFLAG.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT0_Type) GetEVFLAG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EVFLAG.Reg) & 0xffff0000) >> 16
}

// SCT0.CONEN: SCT conflict enable register
func (o *SCT0_Type) SetCONEN_NCEN(value uint32) {
	volatile.StoreUint32(&o.CONEN.Reg, volatile.LoadUint32(&o.CONEN.Reg)&^(0x3ff)|value)
}
func (o *SCT0_Type) GetCONEN_NCEN() uint32 {
	return volatile.LoadUint32(&o.CONEN.Reg) & 0x3ff
}
func (o *SCT0_Type) SetCONEN_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CONEN.Reg, volatile.LoadUint32(&o.CONEN.Reg)&^(0xfffffc00)|value<<10)
}
func (o *SCT0_Type) GetCONEN_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CONEN.Reg) & 0xfffffc00) >> 10
}

// SCT0.CONFLAG: SCT conflict flag register
func (o *SCT0_Type) SetCONFLAG_NCFLAG(value uint32) {
	volatile.StoreUint32(&o.CONFLAG.Reg, volatile.LoadUint32(&o.CONFLAG.Reg)&^(0x3ff)|value)
}
func (o *SCT0_Type) GetCONFLAG_NCFLAG() uint32 {
	return volatile.LoadUint32(&o.CONFLAG.Reg) & 0x3ff
}
func (o *SCT0_Type) SetCONFLAG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CONFLAG.Reg, volatile.LoadUint32(&o.CONFLAG.Reg)&^(0x3ffffc00)|value<<10)
}
func (o *SCT0_Type) GetCONFLAG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CONFLAG.Reg) & 0x3ffffc00) >> 10
}
func (o *SCT0_Type) SetCONFLAG_BUSERRL(value uint32) {
	volatile.StoreUint32(&o.CONFLAG.Reg, volatile.LoadUint32(&o.CONFLAG.Reg)&^(0x40000000)|value<<30)
}
func (o *SCT0_Type) GetCONFLAG_BUSERRL() uint32 {
	return (volatile.LoadUint32(&o.CONFLAG.Reg) & 0x40000000) >> 30
}
func (o *SCT0_Type) SetCONFLAG_BUSERRH(value uint32) {
	volatile.StoreUint32(&o.CONFLAG.Reg, volatile.LoadUint32(&o.CONFLAG.Reg)&^(0x80000000)|value<<31)
}
func (o *SCT0_Type) GetCONFLAG_BUSERRH() uint32 {
	return (volatile.LoadUint32(&o.CONFLAG.Reg) & 0x80000000) >> 31
}

// SCT0.MATCH0: SCT match value register of match channels 0 to 15; REGMOD0 to REGMODE15 = 0
func (o *SCT0_Type) SetMATCH0_MATCHn_L(value uint32) {
	volatile.StoreUint32(&o.MATCH0.Reg, volatile.LoadUint32(&o.MATCH0.Reg)&^(0xffff)|value)
}
func (o *SCT0_Type) GetMATCH0_MATCHn_L() uint32 {
	return volatile.LoadUint32(&o.MATCH0.Reg) & 0xffff
}
func (o *SCT0_Type) SetMATCH0_MATCHn_H(value uint32) {
	volatile.StoreUint32(&o.MATCH0.Reg, volatile.LoadUint32(&o.MATCH0.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT0_Type) GetMATCH0_MATCHn_H() uint32 {
	return (volatile.LoadUint32(&o.MATCH0.Reg) & 0xffff0000) >> 16
}

// SCT0.MATCH1: SCT match value register of match channels 0 to 15; REGMOD0 to REGMODE15 = 0
func (o *SCT0_Type) SetMATCH1_MATCHn_L(value uint32) {
	volatile.StoreUint32(&o.MATCH1.Reg, volatile.LoadUint32(&o.MATCH1.Reg)&^(0xffff)|value)
}
func (o *SCT0_Type) GetMATCH1_MATCHn_L() uint32 {
	return volatile.LoadUint32(&o.MATCH1.Reg) & 0xffff
}
func (o *SCT0_Type) SetMATCH1_MATCHn_H(value uint32) {
	volatile.StoreUint32(&o.MATCH1.Reg, volatile.LoadUint32(&o.MATCH1.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT0_Type) GetMATCH1_MATCHn_H() uint32 {
	return (volatile.LoadUint32(&o.MATCH1.Reg) & 0xffff0000) >> 16
}

// SCT0.MATCH2: SCT match value register of match channels 0 to 15; REGMOD0 to REGMODE15 = 0
func (o *SCT0_Type) SetMATCH2_MATCHn_L(value uint32) {
	volatile.StoreUint32(&o.MATCH2.Reg, volatile.LoadUint32(&o.MATCH2.Reg)&^(0xffff)|value)
}
func (o *SCT0_Type) GetMATCH2_MATCHn_L() uint32 {
	return volatile.LoadUint32(&o.MATCH2.Reg) & 0xffff
}
func (o *SCT0_Type) SetMATCH2_MATCHn_H(value uint32) {
	volatile.StoreUint32(&o.MATCH2.Reg, volatile.LoadUint32(&o.MATCH2.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT0_Type) GetMATCH2_MATCHn_H() uint32 {
	return (volatile.LoadUint32(&o.MATCH2.Reg) & 0xffff0000) >> 16
}

// SCT0.MATCH3: SCT match value register of match channels 0 to 15; REGMOD0 to REGMODE15 = 0
func (o *SCT0_Type) SetMATCH3_MATCHn_L(value uint32) {
	volatile.StoreUint32(&o.MATCH3.Reg, volatile.LoadUint32(&o.MATCH3.Reg)&^(0xffff)|value)
}
func (o *SCT0_Type) GetMATCH3_MATCHn_L() uint32 {
	return volatile.LoadUint32(&o.MATCH3.Reg) & 0xffff
}
func (o *SCT0_Type) SetMATCH3_MATCHn_H(value uint32) {
	volatile.StoreUint32(&o.MATCH3.Reg, volatile.LoadUint32(&o.MATCH3.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT0_Type) GetMATCH3_MATCHn_H() uint32 {
	return (volatile.LoadUint32(&o.MATCH3.Reg) & 0xffff0000) >> 16
}

// SCT0.MATCH4: SCT match value register of match channels 0 to 15; REGMOD0 to REGMODE15 = 0
func (o *SCT0_Type) SetMATCH4_MATCHn_L(value uint32) {
	volatile.StoreUint32(&o.MATCH4.Reg, volatile.LoadUint32(&o.MATCH4.Reg)&^(0xffff)|value)
}
func (o *SCT0_Type) GetMATCH4_MATCHn_L() uint32 {
	return volatile.LoadUint32(&o.MATCH4.Reg) & 0xffff
}
func (o *SCT0_Type) SetMATCH4_MATCHn_H(value uint32) {
	volatile.StoreUint32(&o.MATCH4.Reg, volatile.LoadUint32(&o.MATCH4.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT0_Type) GetMATCH4_MATCHn_H() uint32 {
	return (volatile.LoadUint32(&o.MATCH4.Reg) & 0xffff0000) >> 16
}

// SCT0.MATCH5: SCT match value register of match channels 0 to 15; REGMOD0 to REGMODE15 = 0
func (o *SCT0_Type) SetMATCH5_MATCHn_L(value uint32) {
	volatile.StoreUint32(&o.MATCH5.Reg, volatile.LoadUint32(&o.MATCH5.Reg)&^(0xffff)|value)
}
func (o *SCT0_Type) GetMATCH5_MATCHn_L() uint32 {
	return volatile.LoadUint32(&o.MATCH5.Reg) & 0xffff
}
func (o *SCT0_Type) SetMATCH5_MATCHn_H(value uint32) {
	volatile.StoreUint32(&o.MATCH5.Reg, volatile.LoadUint32(&o.MATCH5.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT0_Type) GetMATCH5_MATCHn_H() uint32 {
	return (volatile.LoadUint32(&o.MATCH5.Reg) & 0xffff0000) >> 16
}

// SCT0.MATCH6: SCT match value register of match channels 0 to 15; REGMOD0 to REGMODE15 = 0
func (o *SCT0_Type) SetMATCH6_MATCHn_L(value uint32) {
	volatile.StoreUint32(&o.MATCH6.Reg, volatile.LoadUint32(&o.MATCH6.Reg)&^(0xffff)|value)
}
func (o *SCT0_Type) GetMATCH6_MATCHn_L() uint32 {
	return volatile.LoadUint32(&o.MATCH6.Reg) & 0xffff
}
func (o *SCT0_Type) SetMATCH6_MATCHn_H(value uint32) {
	volatile.StoreUint32(&o.MATCH6.Reg, volatile.LoadUint32(&o.MATCH6.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT0_Type) GetMATCH6_MATCHn_H() uint32 {
	return (volatile.LoadUint32(&o.MATCH6.Reg) & 0xffff0000) >> 16
}

// SCT0.MATCH7: SCT match value register of match channels 0 to 15; REGMOD0 to REGMODE15 = 0
func (o *SCT0_Type) SetMATCH7_MATCHn_L(value uint32) {
	volatile.StoreUint32(&o.MATCH7.Reg, volatile.LoadUint32(&o.MATCH7.Reg)&^(0xffff)|value)
}
func (o *SCT0_Type) GetMATCH7_MATCHn_L() uint32 {
	return volatile.LoadUint32(&o.MATCH7.Reg) & 0xffff
}
func (o *SCT0_Type) SetMATCH7_MATCHn_H(value uint32) {
	volatile.StoreUint32(&o.MATCH7.Reg, volatile.LoadUint32(&o.MATCH7.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT0_Type) GetMATCH7_MATCHn_H() uint32 {
	return (volatile.LoadUint32(&o.MATCH7.Reg) & 0xffff0000) >> 16
}

// SCT0.MATCH8: SCT match value register of match channels 0 to 15; REGMOD0 to REGMODE15 = 0
func (o *SCT0_Type) SetMATCH8_MATCHn_L(value uint32) {
	volatile.StoreUint32(&o.MATCH8.Reg, volatile.LoadUint32(&o.MATCH8.Reg)&^(0xffff)|value)
}
func (o *SCT0_Type) GetMATCH8_MATCHn_L() uint32 {
	return volatile.LoadUint32(&o.MATCH8.Reg) & 0xffff
}
func (o *SCT0_Type) SetMATCH8_MATCHn_H(value uint32) {
	volatile.StoreUint32(&o.MATCH8.Reg, volatile.LoadUint32(&o.MATCH8.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT0_Type) GetMATCH8_MATCHn_H() uint32 {
	return (volatile.LoadUint32(&o.MATCH8.Reg) & 0xffff0000) >> 16
}

// SCT0.MATCH9: SCT match value register of match channels 0 to 15; REGMOD0 to REGMODE15 = 0
func (o *SCT0_Type) SetMATCH9_MATCHn_L(value uint32) {
	volatile.StoreUint32(&o.MATCH9.Reg, volatile.LoadUint32(&o.MATCH9.Reg)&^(0xffff)|value)
}
func (o *SCT0_Type) GetMATCH9_MATCHn_L() uint32 {
	return volatile.LoadUint32(&o.MATCH9.Reg) & 0xffff
}
func (o *SCT0_Type) SetMATCH9_MATCHn_H(value uint32) {
	volatile.StoreUint32(&o.MATCH9.Reg, volatile.LoadUint32(&o.MATCH9.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT0_Type) GetMATCH9_MATCHn_H() uint32 {
	return (volatile.LoadUint32(&o.MATCH9.Reg) & 0xffff0000) >> 16
}

// SCT0.MATCH10: SCT match value register of match channels 0 to 15; REGMOD0 to REGMODE15 = 0
func (o *SCT0_Type) SetMATCH10_MATCHn_L(value uint32) {
	volatile.StoreUint32(&o.MATCH10.Reg, volatile.LoadUint32(&o.MATCH10.Reg)&^(0xffff)|value)
}
func (o *SCT0_Type) GetMATCH10_MATCHn_L() uint32 {
	return volatile.LoadUint32(&o.MATCH10.Reg) & 0xffff
}
func (o *SCT0_Type) SetMATCH10_MATCHn_H(value uint32) {
	volatile.StoreUint32(&o.MATCH10.Reg, volatile.LoadUint32(&o.MATCH10.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT0_Type) GetMATCH10_MATCHn_H() uint32 {
	return (volatile.LoadUint32(&o.MATCH10.Reg) & 0xffff0000) >> 16
}

// SCT0.MATCH11: SCT match value register of match channels 0 to 15; REGMOD0 to REGMODE15 = 0
func (o *SCT0_Type) SetMATCH11_MATCHn_L(value uint32) {
	volatile.StoreUint32(&o.MATCH11.Reg, volatile.LoadUint32(&o.MATCH11.Reg)&^(0xffff)|value)
}
func (o *SCT0_Type) GetMATCH11_MATCHn_L() uint32 {
	return volatile.LoadUint32(&o.MATCH11.Reg) & 0xffff
}
func (o *SCT0_Type) SetMATCH11_MATCHn_H(value uint32) {
	volatile.StoreUint32(&o.MATCH11.Reg, volatile.LoadUint32(&o.MATCH11.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT0_Type) GetMATCH11_MATCHn_H() uint32 {
	return (volatile.LoadUint32(&o.MATCH11.Reg) & 0xffff0000) >> 16
}

// SCT0.MATCH12: SCT match value register of match channels 0 to 15; REGMOD0 to REGMODE15 = 0
func (o *SCT0_Type) SetMATCH12_MATCHn_L(value uint32) {
	volatile.StoreUint32(&o.MATCH12.Reg, volatile.LoadUint32(&o.MATCH12.Reg)&^(0xffff)|value)
}
func (o *SCT0_Type) GetMATCH12_MATCHn_L() uint32 {
	return volatile.LoadUint32(&o.MATCH12.Reg) & 0xffff
}
func (o *SCT0_Type) SetMATCH12_MATCHn_H(value uint32) {
	volatile.StoreUint32(&o.MATCH12.Reg, volatile.LoadUint32(&o.MATCH12.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT0_Type) GetMATCH12_MATCHn_H() uint32 {
	return (volatile.LoadUint32(&o.MATCH12.Reg) & 0xffff0000) >> 16
}

// SCT0.MATCH13: SCT match value register of match channels 0 to 15; REGMOD0 to REGMODE15 = 0
func (o *SCT0_Type) SetMATCH13_MATCHn_L(value uint32) {
	volatile.StoreUint32(&o.MATCH13.Reg, volatile.LoadUint32(&o.MATCH13.Reg)&^(0xffff)|value)
}
func (o *SCT0_Type) GetMATCH13_MATCHn_L() uint32 {
	return volatile.LoadUint32(&o.MATCH13.Reg) & 0xffff
}
func (o *SCT0_Type) SetMATCH13_MATCHn_H(value uint32) {
	volatile.StoreUint32(&o.MATCH13.Reg, volatile.LoadUint32(&o.MATCH13.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT0_Type) GetMATCH13_MATCHn_H() uint32 {
	return (volatile.LoadUint32(&o.MATCH13.Reg) & 0xffff0000) >> 16
}

// SCT0.MATCH14: SCT match value register of match channels 0 to 15; REGMOD0 to REGMODE15 = 0
func (o *SCT0_Type) SetMATCH14_MATCHn_L(value uint32) {
	volatile.StoreUint32(&o.MATCH14.Reg, volatile.LoadUint32(&o.MATCH14.Reg)&^(0xffff)|value)
}
func (o *SCT0_Type) GetMATCH14_MATCHn_L() uint32 {
	return volatile.LoadUint32(&o.MATCH14.Reg) & 0xffff
}
func (o *SCT0_Type) SetMATCH14_MATCHn_H(value uint32) {
	volatile.StoreUint32(&o.MATCH14.Reg, volatile.LoadUint32(&o.MATCH14.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT0_Type) GetMATCH14_MATCHn_H() uint32 {
	return (volatile.LoadUint32(&o.MATCH14.Reg) & 0xffff0000) >> 16
}

// SCT0.MATCH15: SCT match value register of match channels 0 to 15; REGMOD0 to REGMODE15 = 0
func (o *SCT0_Type) SetMATCH15_MATCHn_L(value uint32) {
	volatile.StoreUint32(&o.MATCH15.Reg, volatile.LoadUint32(&o.MATCH15.Reg)&^(0xffff)|value)
}
func (o *SCT0_Type) GetMATCH15_MATCHn_L() uint32 {
	return volatile.LoadUint32(&o.MATCH15.Reg) & 0xffff
}
func (o *SCT0_Type) SetMATCH15_MATCHn_H(value uint32) {
	volatile.StoreUint32(&o.MATCH15.Reg, volatile.LoadUint32(&o.MATCH15.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT0_Type) GetMATCH15_MATCHn_H() uint32 {
	return (volatile.LoadUint32(&o.MATCH15.Reg) & 0xffff0000) >> 16
}

// SCT0.FRACMAT0: Fractional match registers 0 to 5 for SCT match value registers 0 to 5.
func (o *SCT0_Type) SetFRACMAT0_FRACMAT_L(value uint32) {
	volatile.StoreUint32(&o.FRACMAT0.Reg, volatile.LoadUint32(&o.FRACMAT0.Reg)&^(0xf)|value)
}
func (o *SCT0_Type) GetFRACMAT0_FRACMAT_L() uint32 {
	return volatile.LoadUint32(&o.FRACMAT0.Reg) & 0xf
}
func (o *SCT0_Type) SetFRACMAT0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.FRACMAT0.Reg, volatile.LoadUint32(&o.FRACMAT0.Reg)&^(0xfff0)|value<<4)
}
func (o *SCT0_Type) GetFRACMAT0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.FRACMAT0.Reg) & 0xfff0) >> 4
}
func (o *SCT0_Type) SetFRACMAT0_FRACMAT_H(value uint32) {
	volatile.StoreUint32(&o.FRACMAT0.Reg, volatile.LoadUint32(&o.FRACMAT0.Reg)&^(0xf0000)|value<<16)
}
func (o *SCT0_Type) GetFRACMAT0_FRACMAT_H() uint32 {
	return (volatile.LoadUint32(&o.FRACMAT0.Reg) & 0xf0000) >> 16
}
func (o *SCT0_Type) SetFRACMAT0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.FRACMAT0.Reg, volatile.LoadUint32(&o.FRACMAT0.Reg)&^(0xfff00000)|value<<20)
}
func (o *SCT0_Type) GetFRACMAT0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.FRACMAT0.Reg) & 0xfff00000) >> 20
}

// SCT0.FRACMAT1: Fractional match registers 0 to 5 for SCT match value registers 0 to 5.
func (o *SCT0_Type) SetFRACMAT1_FRACMAT_L(value uint32) {
	volatile.StoreUint32(&o.FRACMAT1.Reg, volatile.LoadUint32(&o.FRACMAT1.Reg)&^(0xf)|value)
}
func (o *SCT0_Type) GetFRACMAT1_FRACMAT_L() uint32 {
	return volatile.LoadUint32(&o.FRACMAT1.Reg) & 0xf
}
func (o *SCT0_Type) SetFRACMAT1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.FRACMAT1.Reg, volatile.LoadUint32(&o.FRACMAT1.Reg)&^(0xfff0)|value<<4)
}
func (o *SCT0_Type) GetFRACMAT1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.FRACMAT1.Reg) & 0xfff0) >> 4
}
func (o *SCT0_Type) SetFRACMAT1_FRACMAT_H(value uint32) {
	volatile.StoreUint32(&o.FRACMAT1.Reg, volatile.LoadUint32(&o.FRACMAT1.Reg)&^(0xf0000)|value<<16)
}
func (o *SCT0_Type) GetFRACMAT1_FRACMAT_H() uint32 {
	return (volatile.LoadUint32(&o.FRACMAT1.Reg) & 0xf0000) >> 16
}
func (o *SCT0_Type) SetFRACMAT1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.FRACMAT1.Reg, volatile.LoadUint32(&o.FRACMAT1.Reg)&^(0xfff00000)|value<<20)
}
func (o *SCT0_Type) GetFRACMAT1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.FRACMAT1.Reg) & 0xfff00000) >> 20
}

// SCT0.FRACMAT2: Fractional match registers 0 to 5 for SCT match value registers 0 to 5.
func (o *SCT0_Type) SetFRACMAT2_FRACMAT_L(value uint32) {
	volatile.StoreUint32(&o.FRACMAT2.Reg, volatile.LoadUint32(&o.FRACMAT2.Reg)&^(0xf)|value)
}
func (o *SCT0_Type) GetFRACMAT2_FRACMAT_L() uint32 {
	return volatile.LoadUint32(&o.FRACMAT2.Reg) & 0xf
}
func (o *SCT0_Type) SetFRACMAT2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.FRACMAT2.Reg, volatile.LoadUint32(&o.FRACMAT2.Reg)&^(0xfff0)|value<<4)
}
func (o *SCT0_Type) GetFRACMAT2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.FRACMAT2.Reg) & 0xfff0) >> 4
}
func (o *SCT0_Type) SetFRACMAT2_FRACMAT_H(value uint32) {
	volatile.StoreUint32(&o.FRACMAT2.Reg, volatile.LoadUint32(&o.FRACMAT2.Reg)&^(0xf0000)|value<<16)
}
func (o *SCT0_Type) GetFRACMAT2_FRACMAT_H() uint32 {
	return (volatile.LoadUint32(&o.FRACMAT2.Reg) & 0xf0000) >> 16
}
func (o *SCT0_Type) SetFRACMAT2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.FRACMAT2.Reg, volatile.LoadUint32(&o.FRACMAT2.Reg)&^(0xfff00000)|value<<20)
}
func (o *SCT0_Type) GetFRACMAT2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.FRACMAT2.Reg) & 0xfff00000) >> 20
}

// SCT0.FRACMAT3: Fractional match registers 0 to 5 for SCT match value registers 0 to 5.
func (o *SCT0_Type) SetFRACMAT3_FRACMAT_L(value uint32) {
	volatile.StoreUint32(&o.FRACMAT3.Reg, volatile.LoadUint32(&o.FRACMAT3.Reg)&^(0xf)|value)
}
func (o *SCT0_Type) GetFRACMAT3_FRACMAT_L() uint32 {
	return volatile.LoadUint32(&o.FRACMAT3.Reg) & 0xf
}
func (o *SCT0_Type) SetFRACMAT3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.FRACMAT3.Reg, volatile.LoadUint32(&o.FRACMAT3.Reg)&^(0xfff0)|value<<4)
}
func (o *SCT0_Type) GetFRACMAT3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.FRACMAT3.Reg) & 0xfff0) >> 4
}
func (o *SCT0_Type) SetFRACMAT3_FRACMAT_H(value uint32) {
	volatile.StoreUint32(&o.FRACMAT3.Reg, volatile.LoadUint32(&o.FRACMAT3.Reg)&^(0xf0000)|value<<16)
}
func (o *SCT0_Type) GetFRACMAT3_FRACMAT_H() uint32 {
	return (volatile.LoadUint32(&o.FRACMAT3.Reg) & 0xf0000) >> 16
}
func (o *SCT0_Type) SetFRACMAT3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.FRACMAT3.Reg, volatile.LoadUint32(&o.FRACMAT3.Reg)&^(0xfff00000)|value<<20)
}
func (o *SCT0_Type) GetFRACMAT3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.FRACMAT3.Reg) & 0xfff00000) >> 20
}

// SCT0.FRACMAT4: Fractional match registers 0 to 5 for SCT match value registers 0 to 5.
func (o *SCT0_Type) SetFRACMAT4_FRACMAT_L(value uint32) {
	volatile.StoreUint32(&o.FRACMAT4.Reg, volatile.LoadUint32(&o.FRACMAT4.Reg)&^(0xf)|value)
}
func (o *SCT0_Type) GetFRACMAT4_FRACMAT_L() uint32 {
	return volatile.LoadUint32(&o.FRACMAT4.Reg) & 0xf
}
func (o *SCT0_Type) SetFRACMAT4_RESERVED(value uint32) {
	volatile.StoreUint32(&o.FRACMAT4.Reg, volatile.LoadUint32(&o.FRACMAT4.Reg)&^(0xfff0)|value<<4)
}
func (o *SCT0_Type) GetFRACMAT4_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.FRACMAT4.Reg) & 0xfff0) >> 4
}
func (o *SCT0_Type) SetFRACMAT4_FRACMAT_H(value uint32) {
	volatile.StoreUint32(&o.FRACMAT4.Reg, volatile.LoadUint32(&o.FRACMAT4.Reg)&^(0xf0000)|value<<16)
}
func (o *SCT0_Type) GetFRACMAT4_FRACMAT_H() uint32 {
	return (volatile.LoadUint32(&o.FRACMAT4.Reg) & 0xf0000) >> 16
}
func (o *SCT0_Type) SetFRACMAT4_RESERVED(value uint32) {
	volatile.StoreUint32(&o.FRACMAT4.Reg, volatile.LoadUint32(&o.FRACMAT4.Reg)&^(0xfff00000)|value<<20)
}
func (o *SCT0_Type) GetFRACMAT4_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.FRACMAT4.Reg) & 0xfff00000) >> 20
}

// SCT0.FRACMAT5: Fractional match registers 0 to 5 for SCT match value registers 0 to 5.
func (o *SCT0_Type) SetFRACMAT5_FRACMAT_L(value uint32) {
	volatile.StoreUint32(&o.FRACMAT5.Reg, volatile.LoadUint32(&o.FRACMAT5.Reg)&^(0xf)|value)
}
func (o *SCT0_Type) GetFRACMAT5_FRACMAT_L() uint32 {
	return volatile.LoadUint32(&o.FRACMAT5.Reg) & 0xf
}
func (o *SCT0_Type) SetFRACMAT5_RESERVED(value uint32) {
	volatile.StoreUint32(&o.FRACMAT5.Reg, volatile.LoadUint32(&o.FRACMAT5.Reg)&^(0xfff0)|value<<4)
}
func (o *SCT0_Type) GetFRACMAT5_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.FRACMAT5.Reg) & 0xfff0) >> 4
}
func (o *SCT0_Type) SetFRACMAT5_FRACMAT_H(value uint32) {
	volatile.StoreUint32(&o.FRACMAT5.Reg, volatile.LoadUint32(&o.FRACMAT5.Reg)&^(0xf0000)|value<<16)
}
func (o *SCT0_Type) GetFRACMAT5_FRACMAT_H() uint32 {
	return (volatile.LoadUint32(&o.FRACMAT5.Reg) & 0xf0000) >> 16
}
func (o *SCT0_Type) SetFRACMAT5_RESERVED(value uint32) {
	volatile.StoreUint32(&o.FRACMAT5.Reg, volatile.LoadUint32(&o.FRACMAT5.Reg)&^(0xfff00000)|value<<20)
}
func (o *SCT0_Type) GetFRACMAT5_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.FRACMAT5.Reg) & 0xfff00000) >> 20
}

// SCT0.MATCHREL0: SCT match reload value register 0 to 15; REGMOD0 = 0 to REGMODE15 = 0
func (o *SCT0_Type) SetMATCHREL0_RELOADn_L(value uint32) {
	volatile.StoreUint32(&o.MATCHREL0.Reg, volatile.LoadUint32(&o.MATCHREL0.Reg)&^(0xffff)|value)
}
func (o *SCT0_Type) GetMATCHREL0_RELOADn_L() uint32 {
	return volatile.LoadUint32(&o.MATCHREL0.Reg) & 0xffff
}
func (o *SCT0_Type) SetMATCHREL0_RELOADn_H(value uint32) {
	volatile.StoreUint32(&o.MATCHREL0.Reg, volatile.LoadUint32(&o.MATCHREL0.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT0_Type) GetMATCHREL0_RELOADn_H() uint32 {
	return (volatile.LoadUint32(&o.MATCHREL0.Reg) & 0xffff0000) >> 16
}

// SCT0.MATCHREL1: SCT match reload value register 0 to 15; REGMOD0 = 0 to REGMODE15 = 0
func (o *SCT0_Type) SetMATCHREL1_RELOADn_L(value uint32) {
	volatile.StoreUint32(&o.MATCHREL1.Reg, volatile.LoadUint32(&o.MATCHREL1.Reg)&^(0xffff)|value)
}
func (o *SCT0_Type) GetMATCHREL1_RELOADn_L() uint32 {
	return volatile.LoadUint32(&o.MATCHREL1.Reg) & 0xffff
}
func (o *SCT0_Type) SetMATCHREL1_RELOADn_H(value uint32) {
	volatile.StoreUint32(&o.MATCHREL1.Reg, volatile.LoadUint32(&o.MATCHREL1.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT0_Type) GetMATCHREL1_RELOADn_H() uint32 {
	return (volatile.LoadUint32(&o.MATCHREL1.Reg) & 0xffff0000) >> 16
}

// SCT0.MATCHREL2: SCT match reload value register 0 to 15; REGMOD0 = 0 to REGMODE15 = 0
func (o *SCT0_Type) SetMATCHREL2_RELOADn_L(value uint32) {
	volatile.StoreUint32(&o.MATCHREL2.Reg, volatile.LoadUint32(&o.MATCHREL2.Reg)&^(0xffff)|value)
}
func (o *SCT0_Type) GetMATCHREL2_RELOADn_L() uint32 {
	return volatile.LoadUint32(&o.MATCHREL2.Reg) & 0xffff
}
func (o *SCT0_Type) SetMATCHREL2_RELOADn_H(value uint32) {
	volatile.StoreUint32(&o.MATCHREL2.Reg, volatile.LoadUint32(&o.MATCHREL2.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT0_Type) GetMATCHREL2_RELOADn_H() uint32 {
	return (volatile.LoadUint32(&o.MATCHREL2.Reg) & 0xffff0000) >> 16
}

// SCT0.MATCHREL3: SCT match reload value register 0 to 15; REGMOD0 = 0 to REGMODE15 = 0
func (o *SCT0_Type) SetMATCHREL3_RELOADn_L(value uint32) {
	volatile.StoreUint32(&o.MATCHREL3.Reg, volatile.LoadUint32(&o.MATCHREL3.Reg)&^(0xffff)|value)
}
func (o *SCT0_Type) GetMATCHREL3_RELOADn_L() uint32 {
	return volatile.LoadUint32(&o.MATCHREL3.Reg) & 0xffff
}
func (o *SCT0_Type) SetMATCHREL3_RELOADn_H(value uint32) {
	volatile.StoreUint32(&o.MATCHREL3.Reg, volatile.LoadUint32(&o.MATCHREL3.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT0_Type) GetMATCHREL3_RELOADn_H() uint32 {
	return (volatile.LoadUint32(&o.MATCHREL3.Reg) & 0xffff0000) >> 16
}

// SCT0.MATCHREL4: SCT match reload value register 0 to 15; REGMOD0 = 0 to REGMODE15 = 0
func (o *SCT0_Type) SetMATCHREL4_RELOADn_L(value uint32) {
	volatile.StoreUint32(&o.MATCHREL4.Reg, volatile.LoadUint32(&o.MATCHREL4.Reg)&^(0xffff)|value)
}
func (o *SCT0_Type) GetMATCHREL4_RELOADn_L() uint32 {
	return volatile.LoadUint32(&o.MATCHREL4.Reg) & 0xffff
}
func (o *SCT0_Type) SetMATCHREL4_RELOADn_H(value uint32) {
	volatile.StoreUint32(&o.MATCHREL4.Reg, volatile.LoadUint32(&o.MATCHREL4.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT0_Type) GetMATCHREL4_RELOADn_H() uint32 {
	return (volatile.LoadUint32(&o.MATCHREL4.Reg) & 0xffff0000) >> 16
}

// SCT0.MATCHREL5: SCT match reload value register 0 to 15; REGMOD0 = 0 to REGMODE15 = 0
func (o *SCT0_Type) SetMATCHREL5_RELOADn_L(value uint32) {
	volatile.StoreUint32(&o.MATCHREL5.Reg, volatile.LoadUint32(&o.MATCHREL5.Reg)&^(0xffff)|value)
}
func (o *SCT0_Type) GetMATCHREL5_RELOADn_L() uint32 {
	return volatile.LoadUint32(&o.MATCHREL5.Reg) & 0xffff
}
func (o *SCT0_Type) SetMATCHREL5_RELOADn_H(value uint32) {
	volatile.StoreUint32(&o.MATCHREL5.Reg, volatile.LoadUint32(&o.MATCHREL5.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT0_Type) GetMATCHREL5_RELOADn_H() uint32 {
	return (volatile.LoadUint32(&o.MATCHREL5.Reg) & 0xffff0000) >> 16
}

// SCT0.MATCHREL6: SCT match reload value register 0 to 15; REGMOD0 = 0 to REGMODE15 = 0
func (o *SCT0_Type) SetMATCHREL6_RELOADn_L(value uint32) {
	volatile.StoreUint32(&o.MATCHREL6.Reg, volatile.LoadUint32(&o.MATCHREL6.Reg)&^(0xffff)|value)
}
func (o *SCT0_Type) GetMATCHREL6_RELOADn_L() uint32 {
	return volatile.LoadUint32(&o.MATCHREL6.Reg) & 0xffff
}
func (o *SCT0_Type) SetMATCHREL6_RELOADn_H(value uint32) {
	volatile.StoreUint32(&o.MATCHREL6.Reg, volatile.LoadUint32(&o.MATCHREL6.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT0_Type) GetMATCHREL6_RELOADn_H() uint32 {
	return (volatile.LoadUint32(&o.MATCHREL6.Reg) & 0xffff0000) >> 16
}

// SCT0.MATCHREL7: SCT match reload value register 0 to 15; REGMOD0 = 0 to REGMODE15 = 0
func (o *SCT0_Type) SetMATCHREL7_RELOADn_L(value uint32) {
	volatile.StoreUint32(&o.MATCHREL7.Reg, volatile.LoadUint32(&o.MATCHREL7.Reg)&^(0xffff)|value)
}
func (o *SCT0_Type) GetMATCHREL7_RELOADn_L() uint32 {
	return volatile.LoadUint32(&o.MATCHREL7.Reg) & 0xffff
}
func (o *SCT0_Type) SetMATCHREL7_RELOADn_H(value uint32) {
	volatile.StoreUint32(&o.MATCHREL7.Reg, volatile.LoadUint32(&o.MATCHREL7.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT0_Type) GetMATCHREL7_RELOADn_H() uint32 {
	return (volatile.LoadUint32(&o.MATCHREL7.Reg) & 0xffff0000) >> 16
}

// SCT0.MATCHREL8: SCT match reload value register 0 to 15; REGMOD0 = 0 to REGMODE15 = 0
func (o *SCT0_Type) SetMATCHREL8_RELOADn_L(value uint32) {
	volatile.StoreUint32(&o.MATCHREL8.Reg, volatile.LoadUint32(&o.MATCHREL8.Reg)&^(0xffff)|value)
}
func (o *SCT0_Type) GetMATCHREL8_RELOADn_L() uint32 {
	return volatile.LoadUint32(&o.MATCHREL8.Reg) & 0xffff
}
func (o *SCT0_Type) SetMATCHREL8_RELOADn_H(value uint32) {
	volatile.StoreUint32(&o.MATCHREL8.Reg, volatile.LoadUint32(&o.MATCHREL8.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT0_Type) GetMATCHREL8_RELOADn_H() uint32 {
	return (volatile.LoadUint32(&o.MATCHREL8.Reg) & 0xffff0000) >> 16
}

// SCT0.MATCHREL9: SCT match reload value register 0 to 15; REGMOD0 = 0 to REGMODE15 = 0
func (o *SCT0_Type) SetMATCHREL9_RELOADn_L(value uint32) {
	volatile.StoreUint32(&o.MATCHREL9.Reg, volatile.LoadUint32(&o.MATCHREL9.Reg)&^(0xffff)|value)
}
func (o *SCT0_Type) GetMATCHREL9_RELOADn_L() uint32 {
	return volatile.LoadUint32(&o.MATCHREL9.Reg) & 0xffff
}
func (o *SCT0_Type) SetMATCHREL9_RELOADn_H(value uint32) {
	volatile.StoreUint32(&o.MATCHREL9.Reg, volatile.LoadUint32(&o.MATCHREL9.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT0_Type) GetMATCHREL9_RELOADn_H() uint32 {
	return (volatile.LoadUint32(&o.MATCHREL9.Reg) & 0xffff0000) >> 16
}

// SCT0.MATCHREL10: SCT match reload value register 0 to 15; REGMOD0 = 0 to REGMODE15 = 0
func (o *SCT0_Type) SetMATCHREL10_RELOADn_L(value uint32) {
	volatile.StoreUint32(&o.MATCHREL10.Reg, volatile.LoadUint32(&o.MATCHREL10.Reg)&^(0xffff)|value)
}
func (o *SCT0_Type) GetMATCHREL10_RELOADn_L() uint32 {
	return volatile.LoadUint32(&o.MATCHREL10.Reg) & 0xffff
}
func (o *SCT0_Type) SetMATCHREL10_RELOADn_H(value uint32) {
	volatile.StoreUint32(&o.MATCHREL10.Reg, volatile.LoadUint32(&o.MATCHREL10.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT0_Type) GetMATCHREL10_RELOADn_H() uint32 {
	return (volatile.LoadUint32(&o.MATCHREL10.Reg) & 0xffff0000) >> 16
}

// SCT0.MATCHREL11: SCT match reload value register 0 to 15; REGMOD0 = 0 to REGMODE15 = 0
func (o *SCT0_Type) SetMATCHREL11_RELOADn_L(value uint32) {
	volatile.StoreUint32(&o.MATCHREL11.Reg, volatile.LoadUint32(&o.MATCHREL11.Reg)&^(0xffff)|value)
}
func (o *SCT0_Type) GetMATCHREL11_RELOADn_L() uint32 {
	return volatile.LoadUint32(&o.MATCHREL11.Reg) & 0xffff
}
func (o *SCT0_Type) SetMATCHREL11_RELOADn_H(value uint32) {
	volatile.StoreUint32(&o.MATCHREL11.Reg, volatile.LoadUint32(&o.MATCHREL11.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT0_Type) GetMATCHREL11_RELOADn_H() uint32 {
	return (volatile.LoadUint32(&o.MATCHREL11.Reg) & 0xffff0000) >> 16
}

// SCT0.MATCHREL12: SCT match reload value register 0 to 15; REGMOD0 = 0 to REGMODE15 = 0
func (o *SCT0_Type) SetMATCHREL12_RELOADn_L(value uint32) {
	volatile.StoreUint32(&o.MATCHREL12.Reg, volatile.LoadUint32(&o.MATCHREL12.Reg)&^(0xffff)|value)
}
func (o *SCT0_Type) GetMATCHREL12_RELOADn_L() uint32 {
	return volatile.LoadUint32(&o.MATCHREL12.Reg) & 0xffff
}
func (o *SCT0_Type) SetMATCHREL12_RELOADn_H(value uint32) {
	volatile.StoreUint32(&o.MATCHREL12.Reg, volatile.LoadUint32(&o.MATCHREL12.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT0_Type) GetMATCHREL12_RELOADn_H() uint32 {
	return (volatile.LoadUint32(&o.MATCHREL12.Reg) & 0xffff0000) >> 16
}

// SCT0.MATCHREL13: SCT match reload value register 0 to 15; REGMOD0 = 0 to REGMODE15 = 0
func (o *SCT0_Type) SetMATCHREL13_RELOADn_L(value uint32) {
	volatile.StoreUint32(&o.MATCHREL13.Reg, volatile.LoadUint32(&o.MATCHREL13.Reg)&^(0xffff)|value)
}
func (o *SCT0_Type) GetMATCHREL13_RELOADn_L() uint32 {
	return volatile.LoadUint32(&o.MATCHREL13.Reg) & 0xffff
}
func (o *SCT0_Type) SetMATCHREL13_RELOADn_H(value uint32) {
	volatile.StoreUint32(&o.MATCHREL13.Reg, volatile.LoadUint32(&o.MATCHREL13.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT0_Type) GetMATCHREL13_RELOADn_H() uint32 {
	return (volatile.LoadUint32(&o.MATCHREL13.Reg) & 0xffff0000) >> 16
}

// SCT0.MATCHREL14: SCT match reload value register 0 to 15; REGMOD0 = 0 to REGMODE15 = 0
func (o *SCT0_Type) SetMATCHREL14_RELOADn_L(value uint32) {
	volatile.StoreUint32(&o.MATCHREL14.Reg, volatile.LoadUint32(&o.MATCHREL14.Reg)&^(0xffff)|value)
}
func (o *SCT0_Type) GetMATCHREL14_RELOADn_L() uint32 {
	return volatile.LoadUint32(&o.MATCHREL14.Reg) & 0xffff
}
func (o *SCT0_Type) SetMATCHREL14_RELOADn_H(value uint32) {
	volatile.StoreUint32(&o.MATCHREL14.Reg, volatile.LoadUint32(&o.MATCHREL14.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT0_Type) GetMATCHREL14_RELOADn_H() uint32 {
	return (volatile.LoadUint32(&o.MATCHREL14.Reg) & 0xffff0000) >> 16
}

// SCT0.MATCHREL15: SCT match reload value register 0 to 15; REGMOD0 = 0 to REGMODE15 = 0
func (o *SCT0_Type) SetMATCHREL15_RELOADn_L(value uint32) {
	volatile.StoreUint32(&o.MATCHREL15.Reg, volatile.LoadUint32(&o.MATCHREL15.Reg)&^(0xffff)|value)
}
func (o *SCT0_Type) GetMATCHREL15_RELOADn_L() uint32 {
	return volatile.LoadUint32(&o.MATCHREL15.Reg) & 0xffff
}
func (o *SCT0_Type) SetMATCHREL15_RELOADn_H(value uint32) {
	volatile.StoreUint32(&o.MATCHREL15.Reg, volatile.LoadUint32(&o.MATCHREL15.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT0_Type) GetMATCHREL15_RELOADn_H() uint32 {
	return (volatile.LoadUint32(&o.MATCHREL15.Reg) & 0xffff0000) >> 16
}

// SCT0.FRACMATREL0: Fractional match reload registers 0 to 5 for SCT match value registers 0 to 5.
func (o *SCT0_Type) SetFRACMATREL0_RELFRAC_L(value uint32) {
	volatile.StoreUint32(&o.FRACMATREL0.Reg, volatile.LoadUint32(&o.FRACMATREL0.Reg)&^(0xf)|value)
}
func (o *SCT0_Type) GetFRACMATREL0_RELFRAC_L() uint32 {
	return volatile.LoadUint32(&o.FRACMATREL0.Reg) & 0xf
}
func (o *SCT0_Type) SetFRACMATREL0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.FRACMATREL0.Reg, volatile.LoadUint32(&o.FRACMATREL0.Reg)&^(0xfff0)|value<<4)
}
func (o *SCT0_Type) GetFRACMATREL0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.FRACMATREL0.Reg) & 0xfff0) >> 4
}
func (o *SCT0_Type) SetFRACMATREL0_RELFRAC_H(value uint32) {
	volatile.StoreUint32(&o.FRACMATREL0.Reg, volatile.LoadUint32(&o.FRACMATREL0.Reg)&^(0xf0000)|value<<16)
}
func (o *SCT0_Type) GetFRACMATREL0_RELFRAC_H() uint32 {
	return (volatile.LoadUint32(&o.FRACMATREL0.Reg) & 0xf0000) >> 16
}
func (o *SCT0_Type) SetFRACMATREL0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.FRACMATREL0.Reg, volatile.LoadUint32(&o.FRACMATREL0.Reg)&^(0xfff00000)|value<<20)
}
func (o *SCT0_Type) GetFRACMATREL0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.FRACMATREL0.Reg) & 0xfff00000) >> 20
}

// SCT0.FRACMATREL1: Fractional match reload registers 0 to 5 for SCT match value registers 0 to 5.
func (o *SCT0_Type) SetFRACMATREL1_RELFRAC_L(value uint32) {
	volatile.StoreUint32(&o.FRACMATREL1.Reg, volatile.LoadUint32(&o.FRACMATREL1.Reg)&^(0xf)|value)
}
func (o *SCT0_Type) GetFRACMATREL1_RELFRAC_L() uint32 {
	return volatile.LoadUint32(&o.FRACMATREL1.Reg) & 0xf
}
func (o *SCT0_Type) SetFRACMATREL1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.FRACMATREL1.Reg, volatile.LoadUint32(&o.FRACMATREL1.Reg)&^(0xfff0)|value<<4)
}
func (o *SCT0_Type) GetFRACMATREL1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.FRACMATREL1.Reg) & 0xfff0) >> 4
}
func (o *SCT0_Type) SetFRACMATREL1_RELFRAC_H(value uint32) {
	volatile.StoreUint32(&o.FRACMATREL1.Reg, volatile.LoadUint32(&o.FRACMATREL1.Reg)&^(0xf0000)|value<<16)
}
func (o *SCT0_Type) GetFRACMATREL1_RELFRAC_H() uint32 {
	return (volatile.LoadUint32(&o.FRACMATREL1.Reg) & 0xf0000) >> 16
}
func (o *SCT0_Type) SetFRACMATREL1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.FRACMATREL1.Reg, volatile.LoadUint32(&o.FRACMATREL1.Reg)&^(0xfff00000)|value<<20)
}
func (o *SCT0_Type) GetFRACMATREL1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.FRACMATREL1.Reg) & 0xfff00000) >> 20
}

// SCT0.FRACMATREL2: Fractional match reload registers 0 to 5 for SCT match value registers 0 to 5.
func (o *SCT0_Type) SetFRACMATREL2_RELFRAC_L(value uint32) {
	volatile.StoreUint32(&o.FRACMATREL2.Reg, volatile.LoadUint32(&o.FRACMATREL2.Reg)&^(0xf)|value)
}
func (o *SCT0_Type) GetFRACMATREL2_RELFRAC_L() uint32 {
	return volatile.LoadUint32(&o.FRACMATREL2.Reg) & 0xf
}
func (o *SCT0_Type) SetFRACMATREL2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.FRACMATREL2.Reg, volatile.LoadUint32(&o.FRACMATREL2.Reg)&^(0xfff0)|value<<4)
}
func (o *SCT0_Type) GetFRACMATREL2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.FRACMATREL2.Reg) & 0xfff0) >> 4
}
func (o *SCT0_Type) SetFRACMATREL2_RELFRAC_H(value uint32) {
	volatile.StoreUint32(&o.FRACMATREL2.Reg, volatile.LoadUint32(&o.FRACMATREL2.Reg)&^(0xf0000)|value<<16)
}
func (o *SCT0_Type) GetFRACMATREL2_RELFRAC_H() uint32 {
	return (volatile.LoadUint32(&o.FRACMATREL2.Reg) & 0xf0000) >> 16
}
func (o *SCT0_Type) SetFRACMATREL2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.FRACMATREL2.Reg, volatile.LoadUint32(&o.FRACMATREL2.Reg)&^(0xfff00000)|value<<20)
}
func (o *SCT0_Type) GetFRACMATREL2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.FRACMATREL2.Reg) & 0xfff00000) >> 20
}

// SCT0.FRACMATREL3: Fractional match reload registers 0 to 5 for SCT match value registers 0 to 5.
func (o *SCT0_Type) SetFRACMATREL3_RELFRAC_L(value uint32) {
	volatile.StoreUint32(&o.FRACMATREL3.Reg, volatile.LoadUint32(&o.FRACMATREL3.Reg)&^(0xf)|value)
}
func (o *SCT0_Type) GetFRACMATREL3_RELFRAC_L() uint32 {
	return volatile.LoadUint32(&o.FRACMATREL3.Reg) & 0xf
}
func (o *SCT0_Type) SetFRACMATREL3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.FRACMATREL3.Reg, volatile.LoadUint32(&o.FRACMATREL3.Reg)&^(0xfff0)|value<<4)
}
func (o *SCT0_Type) GetFRACMATREL3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.FRACMATREL3.Reg) & 0xfff0) >> 4
}
func (o *SCT0_Type) SetFRACMATREL3_RELFRAC_H(value uint32) {
	volatile.StoreUint32(&o.FRACMATREL3.Reg, volatile.LoadUint32(&o.FRACMATREL3.Reg)&^(0xf0000)|value<<16)
}
func (o *SCT0_Type) GetFRACMATREL3_RELFRAC_H() uint32 {
	return (volatile.LoadUint32(&o.FRACMATREL3.Reg) & 0xf0000) >> 16
}
func (o *SCT0_Type) SetFRACMATREL3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.FRACMATREL3.Reg, volatile.LoadUint32(&o.FRACMATREL3.Reg)&^(0xfff00000)|value<<20)
}
func (o *SCT0_Type) GetFRACMATREL3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.FRACMATREL3.Reg) & 0xfff00000) >> 20
}

// SCT0.FRACMATREL4: Fractional match reload registers 0 to 5 for SCT match value registers 0 to 5.
func (o *SCT0_Type) SetFRACMATREL4_RELFRAC_L(value uint32) {
	volatile.StoreUint32(&o.FRACMATREL4.Reg, volatile.LoadUint32(&o.FRACMATREL4.Reg)&^(0xf)|value)
}
func (o *SCT0_Type) GetFRACMATREL4_RELFRAC_L() uint32 {
	return volatile.LoadUint32(&o.FRACMATREL4.Reg) & 0xf
}
func (o *SCT0_Type) SetFRACMATREL4_RESERVED(value uint32) {
	volatile.StoreUint32(&o.FRACMATREL4.Reg, volatile.LoadUint32(&o.FRACMATREL4.Reg)&^(0xfff0)|value<<4)
}
func (o *SCT0_Type) GetFRACMATREL4_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.FRACMATREL4.Reg) & 0xfff0) >> 4
}
func (o *SCT0_Type) SetFRACMATREL4_RELFRAC_H(value uint32) {
	volatile.StoreUint32(&o.FRACMATREL4.Reg, volatile.LoadUint32(&o.FRACMATREL4.Reg)&^(0xf0000)|value<<16)
}
func (o *SCT0_Type) GetFRACMATREL4_RELFRAC_H() uint32 {
	return (volatile.LoadUint32(&o.FRACMATREL4.Reg) & 0xf0000) >> 16
}
func (o *SCT0_Type) SetFRACMATREL4_RESERVED(value uint32) {
	volatile.StoreUint32(&o.FRACMATREL4.Reg, volatile.LoadUint32(&o.FRACMATREL4.Reg)&^(0xfff00000)|value<<20)
}
func (o *SCT0_Type) GetFRACMATREL4_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.FRACMATREL4.Reg) & 0xfff00000) >> 20
}

// SCT0.FRACMATREL5: Fractional match reload registers 0 to 5 for SCT match value registers 0 to 5.
func (o *SCT0_Type) SetFRACMATREL5_RELFRAC_L(value uint32) {
	volatile.StoreUint32(&o.FRACMATREL5.Reg, volatile.LoadUint32(&o.FRACMATREL5.Reg)&^(0xf)|value)
}
func (o *SCT0_Type) GetFRACMATREL5_RELFRAC_L() uint32 {
	return volatile.LoadUint32(&o.FRACMATREL5.Reg) & 0xf
}
func (o *SCT0_Type) SetFRACMATREL5_RESERVED(value uint32) {
	volatile.StoreUint32(&o.FRACMATREL5.Reg, volatile.LoadUint32(&o.FRACMATREL5.Reg)&^(0xfff0)|value<<4)
}
func (o *SCT0_Type) GetFRACMATREL5_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.FRACMATREL5.Reg) & 0xfff0) >> 4
}
func (o *SCT0_Type) SetFRACMATREL5_RELFRAC_H(value uint32) {
	volatile.StoreUint32(&o.FRACMATREL5.Reg, volatile.LoadUint32(&o.FRACMATREL5.Reg)&^(0xf0000)|value<<16)
}
func (o *SCT0_Type) GetFRACMATREL5_RELFRAC_H() uint32 {
	return (volatile.LoadUint32(&o.FRACMATREL5.Reg) & 0xf0000) >> 16
}
func (o *SCT0_Type) SetFRACMATREL5_RESERVED(value uint32) {
	volatile.StoreUint32(&o.FRACMATREL5.Reg, volatile.LoadUint32(&o.FRACMATREL5.Reg)&^(0xfff00000)|value<<20)
}
func (o *SCT0_Type) GetFRACMATREL5_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.FRACMATREL5.Reg) & 0xfff00000) >> 20
}

// SCT0.EV0_STATE: SCT event state register 0
func (o *SCT0_Type) SetEV0_STATE(value uint32) {
	volatile.StoreUint32(&o.EV0_STATE.Reg, value)
}
func (o *SCT0_Type) GetEV0_STATE() uint32 {
	return volatile.LoadUint32(&o.EV0_STATE.Reg)
}

// SCT0.EV0_CTRL: SCT event control register 0
func (o *SCT0_Type) SetEV0_CTRL_MATCHSEL(value uint32) {
	volatile.StoreUint32(&o.EV0_CTRL.Reg, volatile.LoadUint32(&o.EV0_CTRL.Reg)&^(0xf)|value)
}
func (o *SCT0_Type) GetEV0_CTRL_MATCHSEL() uint32 {
	return volatile.LoadUint32(&o.EV0_CTRL.Reg) & 0xf
}
func (o *SCT0_Type) SetEV0_CTRL_HEVENT(value uint32) {
	volatile.StoreUint32(&o.EV0_CTRL.Reg, volatile.LoadUint32(&o.EV0_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *SCT0_Type) GetEV0_CTRL_HEVENT() uint32 {
	return (volatile.LoadUint32(&o.EV0_CTRL.Reg) & 0x10) >> 4
}
func (o *SCT0_Type) SetEV0_CTRL_OUTSEL(value uint32) {
	volatile.StoreUint32(&o.EV0_CTRL.Reg, volatile.LoadUint32(&o.EV0_CTRL.Reg)&^(0x20)|value<<5)
}
func (o *SCT0_Type) GetEV0_CTRL_OUTSEL() uint32 {
	return (volatile.LoadUint32(&o.EV0_CTRL.Reg) & 0x20) >> 5
}
func (o *SCT0_Type) SetEV0_CTRL_IOSEL(value uint32) {
	volatile.StoreUint32(&o.EV0_CTRL.Reg, volatile.LoadUint32(&o.EV0_CTRL.Reg)&^(0x3c0)|value<<6)
}
func (o *SCT0_Type) GetEV0_CTRL_IOSEL() uint32 {
	return (volatile.LoadUint32(&o.EV0_CTRL.Reg) & 0x3c0) >> 6
}
func (o *SCT0_Type) SetEV0_CTRL_IOCOND(value uint32) {
	volatile.StoreUint32(&o.EV0_CTRL.Reg, volatile.LoadUint32(&o.EV0_CTRL.Reg)&^(0xc00)|value<<10)
}
func (o *SCT0_Type) GetEV0_CTRL_IOCOND() uint32 {
	return (volatile.LoadUint32(&o.EV0_CTRL.Reg) & 0xc00) >> 10
}
func (o *SCT0_Type) SetEV0_CTRL_COMBMODE(value uint32) {
	volatile.StoreUint32(&o.EV0_CTRL.Reg, volatile.LoadUint32(&o.EV0_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *SCT0_Type) GetEV0_CTRL_COMBMODE() uint32 {
	return (volatile.LoadUint32(&o.EV0_CTRL.Reg) & 0x3000) >> 12
}
func (o *SCT0_Type) SetEV0_CTRL_STATELD(value uint32) {
	volatile.StoreUint32(&o.EV0_CTRL.Reg, volatile.LoadUint32(&o.EV0_CTRL.Reg)&^(0x4000)|value<<14)
}
func (o *SCT0_Type) GetEV0_CTRL_STATELD() uint32 {
	return (volatile.LoadUint32(&o.EV0_CTRL.Reg) & 0x4000) >> 14
}
func (o *SCT0_Type) SetEV0_CTRL_STATEV(value uint32) {
	volatile.StoreUint32(&o.EV0_CTRL.Reg, volatile.LoadUint32(&o.EV0_CTRL.Reg)&^(0xf8000)|value<<15)
}
func (o *SCT0_Type) GetEV0_CTRL_STATEV() uint32 {
	return (volatile.LoadUint32(&o.EV0_CTRL.Reg) & 0xf8000) >> 15
}
func (o *SCT0_Type) SetEV0_CTRL_MATCHMEM(value uint32) {
	volatile.StoreUint32(&o.EV0_CTRL.Reg, volatile.LoadUint32(&o.EV0_CTRL.Reg)&^(0x100000)|value<<20)
}
func (o *SCT0_Type) GetEV0_CTRL_MATCHMEM() uint32 {
	return (volatile.LoadUint32(&o.EV0_CTRL.Reg) & 0x100000) >> 20
}
func (o *SCT0_Type) SetEV0_CTRL_DIRECTION(value uint32) {
	volatile.StoreUint32(&o.EV0_CTRL.Reg, volatile.LoadUint32(&o.EV0_CTRL.Reg)&^(0x600000)|value<<21)
}
func (o *SCT0_Type) GetEV0_CTRL_DIRECTION() uint32 {
	return (volatile.LoadUint32(&o.EV0_CTRL.Reg) & 0x600000) >> 21
}
func (o *SCT0_Type) SetEV0_CTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EV0_CTRL.Reg, volatile.LoadUint32(&o.EV0_CTRL.Reg)&^(0xff800000)|value<<23)
}
func (o *SCT0_Type) GetEV0_CTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EV0_CTRL.Reg) & 0xff800000) >> 23
}

// SCT0.EV1_STATE: SCT event state register 0
func (o *SCT0_Type) SetEV1_STATE(value uint32) {
	volatile.StoreUint32(&o.EV1_STATE.Reg, value)
}
func (o *SCT0_Type) GetEV1_STATE() uint32 {
	return volatile.LoadUint32(&o.EV1_STATE.Reg)
}

// SCT0.EV1_CTRL: SCT event control register 0
func (o *SCT0_Type) SetEV1_CTRL_MATCHSEL(value uint32) {
	volatile.StoreUint32(&o.EV1_CTRL.Reg, volatile.LoadUint32(&o.EV1_CTRL.Reg)&^(0xf)|value)
}
func (o *SCT0_Type) GetEV1_CTRL_MATCHSEL() uint32 {
	return volatile.LoadUint32(&o.EV1_CTRL.Reg) & 0xf
}
func (o *SCT0_Type) SetEV1_CTRL_HEVENT(value uint32) {
	volatile.StoreUint32(&o.EV1_CTRL.Reg, volatile.LoadUint32(&o.EV1_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *SCT0_Type) GetEV1_CTRL_HEVENT() uint32 {
	return (volatile.LoadUint32(&o.EV1_CTRL.Reg) & 0x10) >> 4
}
func (o *SCT0_Type) SetEV1_CTRL_OUTSEL(value uint32) {
	volatile.StoreUint32(&o.EV1_CTRL.Reg, volatile.LoadUint32(&o.EV1_CTRL.Reg)&^(0x20)|value<<5)
}
func (o *SCT0_Type) GetEV1_CTRL_OUTSEL() uint32 {
	return (volatile.LoadUint32(&o.EV1_CTRL.Reg) & 0x20) >> 5
}
func (o *SCT0_Type) SetEV1_CTRL_IOSEL(value uint32) {
	volatile.StoreUint32(&o.EV1_CTRL.Reg, volatile.LoadUint32(&o.EV1_CTRL.Reg)&^(0x3c0)|value<<6)
}
func (o *SCT0_Type) GetEV1_CTRL_IOSEL() uint32 {
	return (volatile.LoadUint32(&o.EV1_CTRL.Reg) & 0x3c0) >> 6
}
func (o *SCT0_Type) SetEV1_CTRL_IOCOND(value uint32) {
	volatile.StoreUint32(&o.EV1_CTRL.Reg, volatile.LoadUint32(&o.EV1_CTRL.Reg)&^(0xc00)|value<<10)
}
func (o *SCT0_Type) GetEV1_CTRL_IOCOND() uint32 {
	return (volatile.LoadUint32(&o.EV1_CTRL.Reg) & 0xc00) >> 10
}
func (o *SCT0_Type) SetEV1_CTRL_COMBMODE(value uint32) {
	volatile.StoreUint32(&o.EV1_CTRL.Reg, volatile.LoadUint32(&o.EV1_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *SCT0_Type) GetEV1_CTRL_COMBMODE() uint32 {
	return (volatile.LoadUint32(&o.EV1_CTRL.Reg) & 0x3000) >> 12
}
func (o *SCT0_Type) SetEV1_CTRL_STATELD(value uint32) {
	volatile.StoreUint32(&o.EV1_CTRL.Reg, volatile.LoadUint32(&o.EV1_CTRL.Reg)&^(0x4000)|value<<14)
}
func (o *SCT0_Type) GetEV1_CTRL_STATELD() uint32 {
	return (volatile.LoadUint32(&o.EV1_CTRL.Reg) & 0x4000) >> 14
}
func (o *SCT0_Type) SetEV1_CTRL_STATEV(value uint32) {
	volatile.StoreUint32(&o.EV1_CTRL.Reg, volatile.LoadUint32(&o.EV1_CTRL.Reg)&^(0xf8000)|value<<15)
}
func (o *SCT0_Type) GetEV1_CTRL_STATEV() uint32 {
	return (volatile.LoadUint32(&o.EV1_CTRL.Reg) & 0xf8000) >> 15
}
func (o *SCT0_Type) SetEV1_CTRL_MATCHMEM(value uint32) {
	volatile.StoreUint32(&o.EV1_CTRL.Reg, volatile.LoadUint32(&o.EV1_CTRL.Reg)&^(0x100000)|value<<20)
}
func (o *SCT0_Type) GetEV1_CTRL_MATCHMEM() uint32 {
	return (volatile.LoadUint32(&o.EV1_CTRL.Reg) & 0x100000) >> 20
}
func (o *SCT0_Type) SetEV1_CTRL_DIRECTION(value uint32) {
	volatile.StoreUint32(&o.EV1_CTRL.Reg, volatile.LoadUint32(&o.EV1_CTRL.Reg)&^(0x600000)|value<<21)
}
func (o *SCT0_Type) GetEV1_CTRL_DIRECTION() uint32 {
	return (volatile.LoadUint32(&o.EV1_CTRL.Reg) & 0x600000) >> 21
}
func (o *SCT0_Type) SetEV1_CTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EV1_CTRL.Reg, volatile.LoadUint32(&o.EV1_CTRL.Reg)&^(0xff800000)|value<<23)
}
func (o *SCT0_Type) GetEV1_CTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EV1_CTRL.Reg) & 0xff800000) >> 23
}

// SCT0.EV2_STATE: SCT event state register 0
func (o *SCT0_Type) SetEV2_STATE(value uint32) {
	volatile.StoreUint32(&o.EV2_STATE.Reg, value)
}
func (o *SCT0_Type) GetEV2_STATE() uint32 {
	return volatile.LoadUint32(&o.EV2_STATE.Reg)
}

// SCT0.EV2_CTRL: SCT event control register 0
func (o *SCT0_Type) SetEV2_CTRL_MATCHSEL(value uint32) {
	volatile.StoreUint32(&o.EV2_CTRL.Reg, volatile.LoadUint32(&o.EV2_CTRL.Reg)&^(0xf)|value)
}
func (o *SCT0_Type) GetEV2_CTRL_MATCHSEL() uint32 {
	return volatile.LoadUint32(&o.EV2_CTRL.Reg) & 0xf
}
func (o *SCT0_Type) SetEV2_CTRL_HEVENT(value uint32) {
	volatile.StoreUint32(&o.EV2_CTRL.Reg, volatile.LoadUint32(&o.EV2_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *SCT0_Type) GetEV2_CTRL_HEVENT() uint32 {
	return (volatile.LoadUint32(&o.EV2_CTRL.Reg) & 0x10) >> 4
}
func (o *SCT0_Type) SetEV2_CTRL_OUTSEL(value uint32) {
	volatile.StoreUint32(&o.EV2_CTRL.Reg, volatile.LoadUint32(&o.EV2_CTRL.Reg)&^(0x20)|value<<5)
}
func (o *SCT0_Type) GetEV2_CTRL_OUTSEL() uint32 {
	return (volatile.LoadUint32(&o.EV2_CTRL.Reg) & 0x20) >> 5
}
func (o *SCT0_Type) SetEV2_CTRL_IOSEL(value uint32) {
	volatile.StoreUint32(&o.EV2_CTRL.Reg, volatile.LoadUint32(&o.EV2_CTRL.Reg)&^(0x3c0)|value<<6)
}
func (o *SCT0_Type) GetEV2_CTRL_IOSEL() uint32 {
	return (volatile.LoadUint32(&o.EV2_CTRL.Reg) & 0x3c0) >> 6
}
func (o *SCT0_Type) SetEV2_CTRL_IOCOND(value uint32) {
	volatile.StoreUint32(&o.EV2_CTRL.Reg, volatile.LoadUint32(&o.EV2_CTRL.Reg)&^(0xc00)|value<<10)
}
func (o *SCT0_Type) GetEV2_CTRL_IOCOND() uint32 {
	return (volatile.LoadUint32(&o.EV2_CTRL.Reg) & 0xc00) >> 10
}
func (o *SCT0_Type) SetEV2_CTRL_COMBMODE(value uint32) {
	volatile.StoreUint32(&o.EV2_CTRL.Reg, volatile.LoadUint32(&o.EV2_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *SCT0_Type) GetEV2_CTRL_COMBMODE() uint32 {
	return (volatile.LoadUint32(&o.EV2_CTRL.Reg) & 0x3000) >> 12
}
func (o *SCT0_Type) SetEV2_CTRL_STATELD(value uint32) {
	volatile.StoreUint32(&o.EV2_CTRL.Reg, volatile.LoadUint32(&o.EV2_CTRL.Reg)&^(0x4000)|value<<14)
}
func (o *SCT0_Type) GetEV2_CTRL_STATELD() uint32 {
	return (volatile.LoadUint32(&o.EV2_CTRL.Reg) & 0x4000) >> 14
}
func (o *SCT0_Type) SetEV2_CTRL_STATEV(value uint32) {
	volatile.StoreUint32(&o.EV2_CTRL.Reg, volatile.LoadUint32(&o.EV2_CTRL.Reg)&^(0xf8000)|value<<15)
}
func (o *SCT0_Type) GetEV2_CTRL_STATEV() uint32 {
	return (volatile.LoadUint32(&o.EV2_CTRL.Reg) & 0xf8000) >> 15
}
func (o *SCT0_Type) SetEV2_CTRL_MATCHMEM(value uint32) {
	volatile.StoreUint32(&o.EV2_CTRL.Reg, volatile.LoadUint32(&o.EV2_CTRL.Reg)&^(0x100000)|value<<20)
}
func (o *SCT0_Type) GetEV2_CTRL_MATCHMEM() uint32 {
	return (volatile.LoadUint32(&o.EV2_CTRL.Reg) & 0x100000) >> 20
}
func (o *SCT0_Type) SetEV2_CTRL_DIRECTION(value uint32) {
	volatile.StoreUint32(&o.EV2_CTRL.Reg, volatile.LoadUint32(&o.EV2_CTRL.Reg)&^(0x600000)|value<<21)
}
func (o *SCT0_Type) GetEV2_CTRL_DIRECTION() uint32 {
	return (volatile.LoadUint32(&o.EV2_CTRL.Reg) & 0x600000) >> 21
}
func (o *SCT0_Type) SetEV2_CTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EV2_CTRL.Reg, volatile.LoadUint32(&o.EV2_CTRL.Reg)&^(0xff800000)|value<<23)
}
func (o *SCT0_Type) GetEV2_CTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EV2_CTRL.Reg) & 0xff800000) >> 23
}

// SCT0.EV3_STATE: SCT event state register 0
func (o *SCT0_Type) SetEV3_STATE(value uint32) {
	volatile.StoreUint32(&o.EV3_STATE.Reg, value)
}
func (o *SCT0_Type) GetEV3_STATE() uint32 {
	return volatile.LoadUint32(&o.EV3_STATE.Reg)
}

// SCT0.EV3_CTRL: SCT event control register 0
func (o *SCT0_Type) SetEV3_CTRL_MATCHSEL(value uint32) {
	volatile.StoreUint32(&o.EV3_CTRL.Reg, volatile.LoadUint32(&o.EV3_CTRL.Reg)&^(0xf)|value)
}
func (o *SCT0_Type) GetEV3_CTRL_MATCHSEL() uint32 {
	return volatile.LoadUint32(&o.EV3_CTRL.Reg) & 0xf
}
func (o *SCT0_Type) SetEV3_CTRL_HEVENT(value uint32) {
	volatile.StoreUint32(&o.EV3_CTRL.Reg, volatile.LoadUint32(&o.EV3_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *SCT0_Type) GetEV3_CTRL_HEVENT() uint32 {
	return (volatile.LoadUint32(&o.EV3_CTRL.Reg) & 0x10) >> 4
}
func (o *SCT0_Type) SetEV3_CTRL_OUTSEL(value uint32) {
	volatile.StoreUint32(&o.EV3_CTRL.Reg, volatile.LoadUint32(&o.EV3_CTRL.Reg)&^(0x20)|value<<5)
}
func (o *SCT0_Type) GetEV3_CTRL_OUTSEL() uint32 {
	return (volatile.LoadUint32(&o.EV3_CTRL.Reg) & 0x20) >> 5
}
func (o *SCT0_Type) SetEV3_CTRL_IOSEL(value uint32) {
	volatile.StoreUint32(&o.EV3_CTRL.Reg, volatile.LoadUint32(&o.EV3_CTRL.Reg)&^(0x3c0)|value<<6)
}
func (o *SCT0_Type) GetEV3_CTRL_IOSEL() uint32 {
	return (volatile.LoadUint32(&o.EV3_CTRL.Reg) & 0x3c0) >> 6
}
func (o *SCT0_Type) SetEV3_CTRL_IOCOND(value uint32) {
	volatile.StoreUint32(&o.EV3_CTRL.Reg, volatile.LoadUint32(&o.EV3_CTRL.Reg)&^(0xc00)|value<<10)
}
func (o *SCT0_Type) GetEV3_CTRL_IOCOND() uint32 {
	return (volatile.LoadUint32(&o.EV3_CTRL.Reg) & 0xc00) >> 10
}
func (o *SCT0_Type) SetEV3_CTRL_COMBMODE(value uint32) {
	volatile.StoreUint32(&o.EV3_CTRL.Reg, volatile.LoadUint32(&o.EV3_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *SCT0_Type) GetEV3_CTRL_COMBMODE() uint32 {
	return (volatile.LoadUint32(&o.EV3_CTRL.Reg) & 0x3000) >> 12
}
func (o *SCT0_Type) SetEV3_CTRL_STATELD(value uint32) {
	volatile.StoreUint32(&o.EV3_CTRL.Reg, volatile.LoadUint32(&o.EV3_CTRL.Reg)&^(0x4000)|value<<14)
}
func (o *SCT0_Type) GetEV3_CTRL_STATELD() uint32 {
	return (volatile.LoadUint32(&o.EV3_CTRL.Reg) & 0x4000) >> 14
}
func (o *SCT0_Type) SetEV3_CTRL_STATEV(value uint32) {
	volatile.StoreUint32(&o.EV3_CTRL.Reg, volatile.LoadUint32(&o.EV3_CTRL.Reg)&^(0xf8000)|value<<15)
}
func (o *SCT0_Type) GetEV3_CTRL_STATEV() uint32 {
	return (volatile.LoadUint32(&o.EV3_CTRL.Reg) & 0xf8000) >> 15
}
func (o *SCT0_Type) SetEV3_CTRL_MATCHMEM(value uint32) {
	volatile.StoreUint32(&o.EV3_CTRL.Reg, volatile.LoadUint32(&o.EV3_CTRL.Reg)&^(0x100000)|value<<20)
}
func (o *SCT0_Type) GetEV3_CTRL_MATCHMEM() uint32 {
	return (volatile.LoadUint32(&o.EV3_CTRL.Reg) & 0x100000) >> 20
}
func (o *SCT0_Type) SetEV3_CTRL_DIRECTION(value uint32) {
	volatile.StoreUint32(&o.EV3_CTRL.Reg, volatile.LoadUint32(&o.EV3_CTRL.Reg)&^(0x600000)|value<<21)
}
func (o *SCT0_Type) GetEV3_CTRL_DIRECTION() uint32 {
	return (volatile.LoadUint32(&o.EV3_CTRL.Reg) & 0x600000) >> 21
}
func (o *SCT0_Type) SetEV3_CTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EV3_CTRL.Reg, volatile.LoadUint32(&o.EV3_CTRL.Reg)&^(0xff800000)|value<<23)
}
func (o *SCT0_Type) GetEV3_CTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EV3_CTRL.Reg) & 0xff800000) >> 23
}

// SCT0.EV4_STATE: SCT event state register 0
func (o *SCT0_Type) SetEV4_STATE(value uint32) {
	volatile.StoreUint32(&o.EV4_STATE.Reg, value)
}
func (o *SCT0_Type) GetEV4_STATE() uint32 {
	return volatile.LoadUint32(&o.EV4_STATE.Reg)
}

// SCT0.EV4_CTRL: SCT event control register 0
func (o *SCT0_Type) SetEV4_CTRL_MATCHSEL(value uint32) {
	volatile.StoreUint32(&o.EV4_CTRL.Reg, volatile.LoadUint32(&o.EV4_CTRL.Reg)&^(0xf)|value)
}
func (o *SCT0_Type) GetEV4_CTRL_MATCHSEL() uint32 {
	return volatile.LoadUint32(&o.EV4_CTRL.Reg) & 0xf
}
func (o *SCT0_Type) SetEV4_CTRL_HEVENT(value uint32) {
	volatile.StoreUint32(&o.EV4_CTRL.Reg, volatile.LoadUint32(&o.EV4_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *SCT0_Type) GetEV4_CTRL_HEVENT() uint32 {
	return (volatile.LoadUint32(&o.EV4_CTRL.Reg) & 0x10) >> 4
}
func (o *SCT0_Type) SetEV4_CTRL_OUTSEL(value uint32) {
	volatile.StoreUint32(&o.EV4_CTRL.Reg, volatile.LoadUint32(&o.EV4_CTRL.Reg)&^(0x20)|value<<5)
}
func (o *SCT0_Type) GetEV4_CTRL_OUTSEL() uint32 {
	return (volatile.LoadUint32(&o.EV4_CTRL.Reg) & 0x20) >> 5
}
func (o *SCT0_Type) SetEV4_CTRL_IOSEL(value uint32) {
	volatile.StoreUint32(&o.EV4_CTRL.Reg, volatile.LoadUint32(&o.EV4_CTRL.Reg)&^(0x3c0)|value<<6)
}
func (o *SCT0_Type) GetEV4_CTRL_IOSEL() uint32 {
	return (volatile.LoadUint32(&o.EV4_CTRL.Reg) & 0x3c0) >> 6
}
func (o *SCT0_Type) SetEV4_CTRL_IOCOND(value uint32) {
	volatile.StoreUint32(&o.EV4_CTRL.Reg, volatile.LoadUint32(&o.EV4_CTRL.Reg)&^(0xc00)|value<<10)
}
func (o *SCT0_Type) GetEV4_CTRL_IOCOND() uint32 {
	return (volatile.LoadUint32(&o.EV4_CTRL.Reg) & 0xc00) >> 10
}
func (o *SCT0_Type) SetEV4_CTRL_COMBMODE(value uint32) {
	volatile.StoreUint32(&o.EV4_CTRL.Reg, volatile.LoadUint32(&o.EV4_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *SCT0_Type) GetEV4_CTRL_COMBMODE() uint32 {
	return (volatile.LoadUint32(&o.EV4_CTRL.Reg) & 0x3000) >> 12
}
func (o *SCT0_Type) SetEV4_CTRL_STATELD(value uint32) {
	volatile.StoreUint32(&o.EV4_CTRL.Reg, volatile.LoadUint32(&o.EV4_CTRL.Reg)&^(0x4000)|value<<14)
}
func (o *SCT0_Type) GetEV4_CTRL_STATELD() uint32 {
	return (volatile.LoadUint32(&o.EV4_CTRL.Reg) & 0x4000) >> 14
}
func (o *SCT0_Type) SetEV4_CTRL_STATEV(value uint32) {
	volatile.StoreUint32(&o.EV4_CTRL.Reg, volatile.LoadUint32(&o.EV4_CTRL.Reg)&^(0xf8000)|value<<15)
}
func (o *SCT0_Type) GetEV4_CTRL_STATEV() uint32 {
	return (volatile.LoadUint32(&o.EV4_CTRL.Reg) & 0xf8000) >> 15
}
func (o *SCT0_Type) SetEV4_CTRL_MATCHMEM(value uint32) {
	volatile.StoreUint32(&o.EV4_CTRL.Reg, volatile.LoadUint32(&o.EV4_CTRL.Reg)&^(0x100000)|value<<20)
}
func (o *SCT0_Type) GetEV4_CTRL_MATCHMEM() uint32 {
	return (volatile.LoadUint32(&o.EV4_CTRL.Reg) & 0x100000) >> 20
}
func (o *SCT0_Type) SetEV4_CTRL_DIRECTION(value uint32) {
	volatile.StoreUint32(&o.EV4_CTRL.Reg, volatile.LoadUint32(&o.EV4_CTRL.Reg)&^(0x600000)|value<<21)
}
func (o *SCT0_Type) GetEV4_CTRL_DIRECTION() uint32 {
	return (volatile.LoadUint32(&o.EV4_CTRL.Reg) & 0x600000) >> 21
}
func (o *SCT0_Type) SetEV4_CTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EV4_CTRL.Reg, volatile.LoadUint32(&o.EV4_CTRL.Reg)&^(0xff800000)|value<<23)
}
func (o *SCT0_Type) GetEV4_CTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EV4_CTRL.Reg) & 0xff800000) >> 23
}

// SCT0.EV5_STATE: SCT event state register 0
func (o *SCT0_Type) SetEV5_STATE(value uint32) {
	volatile.StoreUint32(&o.EV5_STATE.Reg, value)
}
func (o *SCT0_Type) GetEV5_STATE() uint32 {
	return volatile.LoadUint32(&o.EV5_STATE.Reg)
}

// SCT0.EV5_CTRL: SCT event control register 0
func (o *SCT0_Type) SetEV5_CTRL_MATCHSEL(value uint32) {
	volatile.StoreUint32(&o.EV5_CTRL.Reg, volatile.LoadUint32(&o.EV5_CTRL.Reg)&^(0xf)|value)
}
func (o *SCT0_Type) GetEV5_CTRL_MATCHSEL() uint32 {
	return volatile.LoadUint32(&o.EV5_CTRL.Reg) & 0xf
}
func (o *SCT0_Type) SetEV5_CTRL_HEVENT(value uint32) {
	volatile.StoreUint32(&o.EV5_CTRL.Reg, volatile.LoadUint32(&o.EV5_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *SCT0_Type) GetEV5_CTRL_HEVENT() uint32 {
	return (volatile.LoadUint32(&o.EV5_CTRL.Reg) & 0x10) >> 4
}
func (o *SCT0_Type) SetEV5_CTRL_OUTSEL(value uint32) {
	volatile.StoreUint32(&o.EV5_CTRL.Reg, volatile.LoadUint32(&o.EV5_CTRL.Reg)&^(0x20)|value<<5)
}
func (o *SCT0_Type) GetEV5_CTRL_OUTSEL() uint32 {
	return (volatile.LoadUint32(&o.EV5_CTRL.Reg) & 0x20) >> 5
}
func (o *SCT0_Type) SetEV5_CTRL_IOSEL(value uint32) {
	volatile.StoreUint32(&o.EV5_CTRL.Reg, volatile.LoadUint32(&o.EV5_CTRL.Reg)&^(0x3c0)|value<<6)
}
func (o *SCT0_Type) GetEV5_CTRL_IOSEL() uint32 {
	return (volatile.LoadUint32(&o.EV5_CTRL.Reg) & 0x3c0) >> 6
}
func (o *SCT0_Type) SetEV5_CTRL_IOCOND(value uint32) {
	volatile.StoreUint32(&o.EV5_CTRL.Reg, volatile.LoadUint32(&o.EV5_CTRL.Reg)&^(0xc00)|value<<10)
}
func (o *SCT0_Type) GetEV5_CTRL_IOCOND() uint32 {
	return (volatile.LoadUint32(&o.EV5_CTRL.Reg) & 0xc00) >> 10
}
func (o *SCT0_Type) SetEV5_CTRL_COMBMODE(value uint32) {
	volatile.StoreUint32(&o.EV5_CTRL.Reg, volatile.LoadUint32(&o.EV5_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *SCT0_Type) GetEV5_CTRL_COMBMODE() uint32 {
	return (volatile.LoadUint32(&o.EV5_CTRL.Reg) & 0x3000) >> 12
}
func (o *SCT0_Type) SetEV5_CTRL_STATELD(value uint32) {
	volatile.StoreUint32(&o.EV5_CTRL.Reg, volatile.LoadUint32(&o.EV5_CTRL.Reg)&^(0x4000)|value<<14)
}
func (o *SCT0_Type) GetEV5_CTRL_STATELD() uint32 {
	return (volatile.LoadUint32(&o.EV5_CTRL.Reg) & 0x4000) >> 14
}
func (o *SCT0_Type) SetEV5_CTRL_STATEV(value uint32) {
	volatile.StoreUint32(&o.EV5_CTRL.Reg, volatile.LoadUint32(&o.EV5_CTRL.Reg)&^(0xf8000)|value<<15)
}
func (o *SCT0_Type) GetEV5_CTRL_STATEV() uint32 {
	return (volatile.LoadUint32(&o.EV5_CTRL.Reg) & 0xf8000) >> 15
}
func (o *SCT0_Type) SetEV5_CTRL_MATCHMEM(value uint32) {
	volatile.StoreUint32(&o.EV5_CTRL.Reg, volatile.LoadUint32(&o.EV5_CTRL.Reg)&^(0x100000)|value<<20)
}
func (o *SCT0_Type) GetEV5_CTRL_MATCHMEM() uint32 {
	return (volatile.LoadUint32(&o.EV5_CTRL.Reg) & 0x100000) >> 20
}
func (o *SCT0_Type) SetEV5_CTRL_DIRECTION(value uint32) {
	volatile.StoreUint32(&o.EV5_CTRL.Reg, volatile.LoadUint32(&o.EV5_CTRL.Reg)&^(0x600000)|value<<21)
}
func (o *SCT0_Type) GetEV5_CTRL_DIRECTION() uint32 {
	return (volatile.LoadUint32(&o.EV5_CTRL.Reg) & 0x600000) >> 21
}
func (o *SCT0_Type) SetEV5_CTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EV5_CTRL.Reg, volatile.LoadUint32(&o.EV5_CTRL.Reg)&^(0xff800000)|value<<23)
}
func (o *SCT0_Type) GetEV5_CTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EV5_CTRL.Reg) & 0xff800000) >> 23
}

// SCT0.EV6_STATE: SCT event state register 0
func (o *SCT0_Type) SetEV6_STATE(value uint32) {
	volatile.StoreUint32(&o.EV6_STATE.Reg, value)
}
func (o *SCT0_Type) GetEV6_STATE() uint32 {
	return volatile.LoadUint32(&o.EV6_STATE.Reg)
}

// SCT0.EV6_CTRL: SCT event control register 0
func (o *SCT0_Type) SetEV6_CTRL_MATCHSEL(value uint32) {
	volatile.StoreUint32(&o.EV6_CTRL.Reg, volatile.LoadUint32(&o.EV6_CTRL.Reg)&^(0xf)|value)
}
func (o *SCT0_Type) GetEV6_CTRL_MATCHSEL() uint32 {
	return volatile.LoadUint32(&o.EV6_CTRL.Reg) & 0xf
}
func (o *SCT0_Type) SetEV6_CTRL_HEVENT(value uint32) {
	volatile.StoreUint32(&o.EV6_CTRL.Reg, volatile.LoadUint32(&o.EV6_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *SCT0_Type) GetEV6_CTRL_HEVENT() uint32 {
	return (volatile.LoadUint32(&o.EV6_CTRL.Reg) & 0x10) >> 4
}
func (o *SCT0_Type) SetEV6_CTRL_OUTSEL(value uint32) {
	volatile.StoreUint32(&o.EV6_CTRL.Reg, volatile.LoadUint32(&o.EV6_CTRL.Reg)&^(0x20)|value<<5)
}
func (o *SCT0_Type) GetEV6_CTRL_OUTSEL() uint32 {
	return (volatile.LoadUint32(&o.EV6_CTRL.Reg) & 0x20) >> 5
}
func (o *SCT0_Type) SetEV6_CTRL_IOSEL(value uint32) {
	volatile.StoreUint32(&o.EV6_CTRL.Reg, volatile.LoadUint32(&o.EV6_CTRL.Reg)&^(0x3c0)|value<<6)
}
func (o *SCT0_Type) GetEV6_CTRL_IOSEL() uint32 {
	return (volatile.LoadUint32(&o.EV6_CTRL.Reg) & 0x3c0) >> 6
}
func (o *SCT0_Type) SetEV6_CTRL_IOCOND(value uint32) {
	volatile.StoreUint32(&o.EV6_CTRL.Reg, volatile.LoadUint32(&o.EV6_CTRL.Reg)&^(0xc00)|value<<10)
}
func (o *SCT0_Type) GetEV6_CTRL_IOCOND() uint32 {
	return (volatile.LoadUint32(&o.EV6_CTRL.Reg) & 0xc00) >> 10
}
func (o *SCT0_Type) SetEV6_CTRL_COMBMODE(value uint32) {
	volatile.StoreUint32(&o.EV6_CTRL.Reg, volatile.LoadUint32(&o.EV6_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *SCT0_Type) GetEV6_CTRL_COMBMODE() uint32 {
	return (volatile.LoadUint32(&o.EV6_CTRL.Reg) & 0x3000) >> 12
}
func (o *SCT0_Type) SetEV6_CTRL_STATELD(value uint32) {
	volatile.StoreUint32(&o.EV6_CTRL.Reg, volatile.LoadUint32(&o.EV6_CTRL.Reg)&^(0x4000)|value<<14)
}
func (o *SCT0_Type) GetEV6_CTRL_STATELD() uint32 {
	return (volatile.LoadUint32(&o.EV6_CTRL.Reg) & 0x4000) >> 14
}
func (o *SCT0_Type) SetEV6_CTRL_STATEV(value uint32) {
	volatile.StoreUint32(&o.EV6_CTRL.Reg, volatile.LoadUint32(&o.EV6_CTRL.Reg)&^(0xf8000)|value<<15)
}
func (o *SCT0_Type) GetEV6_CTRL_STATEV() uint32 {
	return (volatile.LoadUint32(&o.EV6_CTRL.Reg) & 0xf8000) >> 15
}
func (o *SCT0_Type) SetEV6_CTRL_MATCHMEM(value uint32) {
	volatile.StoreUint32(&o.EV6_CTRL.Reg, volatile.LoadUint32(&o.EV6_CTRL.Reg)&^(0x100000)|value<<20)
}
func (o *SCT0_Type) GetEV6_CTRL_MATCHMEM() uint32 {
	return (volatile.LoadUint32(&o.EV6_CTRL.Reg) & 0x100000) >> 20
}
func (o *SCT0_Type) SetEV6_CTRL_DIRECTION(value uint32) {
	volatile.StoreUint32(&o.EV6_CTRL.Reg, volatile.LoadUint32(&o.EV6_CTRL.Reg)&^(0x600000)|value<<21)
}
func (o *SCT0_Type) GetEV6_CTRL_DIRECTION() uint32 {
	return (volatile.LoadUint32(&o.EV6_CTRL.Reg) & 0x600000) >> 21
}
func (o *SCT0_Type) SetEV6_CTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EV6_CTRL.Reg, volatile.LoadUint32(&o.EV6_CTRL.Reg)&^(0xff800000)|value<<23)
}
func (o *SCT0_Type) GetEV6_CTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EV6_CTRL.Reg) & 0xff800000) >> 23
}

// SCT0.EV7_STATE: SCT event state register 0
func (o *SCT0_Type) SetEV7_STATE(value uint32) {
	volatile.StoreUint32(&o.EV7_STATE.Reg, value)
}
func (o *SCT0_Type) GetEV7_STATE() uint32 {
	return volatile.LoadUint32(&o.EV7_STATE.Reg)
}

// SCT0.EV7_CTRL: SCT event control register 0
func (o *SCT0_Type) SetEV7_CTRL_MATCHSEL(value uint32) {
	volatile.StoreUint32(&o.EV7_CTRL.Reg, volatile.LoadUint32(&o.EV7_CTRL.Reg)&^(0xf)|value)
}
func (o *SCT0_Type) GetEV7_CTRL_MATCHSEL() uint32 {
	return volatile.LoadUint32(&o.EV7_CTRL.Reg) & 0xf
}
func (o *SCT0_Type) SetEV7_CTRL_HEVENT(value uint32) {
	volatile.StoreUint32(&o.EV7_CTRL.Reg, volatile.LoadUint32(&o.EV7_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *SCT0_Type) GetEV7_CTRL_HEVENT() uint32 {
	return (volatile.LoadUint32(&o.EV7_CTRL.Reg) & 0x10) >> 4
}
func (o *SCT0_Type) SetEV7_CTRL_OUTSEL(value uint32) {
	volatile.StoreUint32(&o.EV7_CTRL.Reg, volatile.LoadUint32(&o.EV7_CTRL.Reg)&^(0x20)|value<<5)
}
func (o *SCT0_Type) GetEV7_CTRL_OUTSEL() uint32 {
	return (volatile.LoadUint32(&o.EV7_CTRL.Reg) & 0x20) >> 5
}
func (o *SCT0_Type) SetEV7_CTRL_IOSEL(value uint32) {
	volatile.StoreUint32(&o.EV7_CTRL.Reg, volatile.LoadUint32(&o.EV7_CTRL.Reg)&^(0x3c0)|value<<6)
}
func (o *SCT0_Type) GetEV7_CTRL_IOSEL() uint32 {
	return (volatile.LoadUint32(&o.EV7_CTRL.Reg) & 0x3c0) >> 6
}
func (o *SCT0_Type) SetEV7_CTRL_IOCOND(value uint32) {
	volatile.StoreUint32(&o.EV7_CTRL.Reg, volatile.LoadUint32(&o.EV7_CTRL.Reg)&^(0xc00)|value<<10)
}
func (o *SCT0_Type) GetEV7_CTRL_IOCOND() uint32 {
	return (volatile.LoadUint32(&o.EV7_CTRL.Reg) & 0xc00) >> 10
}
func (o *SCT0_Type) SetEV7_CTRL_COMBMODE(value uint32) {
	volatile.StoreUint32(&o.EV7_CTRL.Reg, volatile.LoadUint32(&o.EV7_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *SCT0_Type) GetEV7_CTRL_COMBMODE() uint32 {
	return (volatile.LoadUint32(&o.EV7_CTRL.Reg) & 0x3000) >> 12
}
func (o *SCT0_Type) SetEV7_CTRL_STATELD(value uint32) {
	volatile.StoreUint32(&o.EV7_CTRL.Reg, volatile.LoadUint32(&o.EV7_CTRL.Reg)&^(0x4000)|value<<14)
}
func (o *SCT0_Type) GetEV7_CTRL_STATELD() uint32 {
	return (volatile.LoadUint32(&o.EV7_CTRL.Reg) & 0x4000) >> 14
}
func (o *SCT0_Type) SetEV7_CTRL_STATEV(value uint32) {
	volatile.StoreUint32(&o.EV7_CTRL.Reg, volatile.LoadUint32(&o.EV7_CTRL.Reg)&^(0xf8000)|value<<15)
}
func (o *SCT0_Type) GetEV7_CTRL_STATEV() uint32 {
	return (volatile.LoadUint32(&o.EV7_CTRL.Reg) & 0xf8000) >> 15
}
func (o *SCT0_Type) SetEV7_CTRL_MATCHMEM(value uint32) {
	volatile.StoreUint32(&o.EV7_CTRL.Reg, volatile.LoadUint32(&o.EV7_CTRL.Reg)&^(0x100000)|value<<20)
}
func (o *SCT0_Type) GetEV7_CTRL_MATCHMEM() uint32 {
	return (volatile.LoadUint32(&o.EV7_CTRL.Reg) & 0x100000) >> 20
}
func (o *SCT0_Type) SetEV7_CTRL_DIRECTION(value uint32) {
	volatile.StoreUint32(&o.EV7_CTRL.Reg, volatile.LoadUint32(&o.EV7_CTRL.Reg)&^(0x600000)|value<<21)
}
func (o *SCT0_Type) GetEV7_CTRL_DIRECTION() uint32 {
	return (volatile.LoadUint32(&o.EV7_CTRL.Reg) & 0x600000) >> 21
}
func (o *SCT0_Type) SetEV7_CTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EV7_CTRL.Reg, volatile.LoadUint32(&o.EV7_CTRL.Reg)&^(0xff800000)|value<<23)
}
func (o *SCT0_Type) GetEV7_CTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EV7_CTRL.Reg) & 0xff800000) >> 23
}

// SCT0.EV8_STATE: SCT event state register 0
func (o *SCT0_Type) SetEV8_STATE(value uint32) {
	volatile.StoreUint32(&o.EV8_STATE.Reg, value)
}
func (o *SCT0_Type) GetEV8_STATE() uint32 {
	return volatile.LoadUint32(&o.EV8_STATE.Reg)
}

// SCT0.EV8_CTRL: SCT event control register 0
func (o *SCT0_Type) SetEV8_CTRL_MATCHSEL(value uint32) {
	volatile.StoreUint32(&o.EV8_CTRL.Reg, volatile.LoadUint32(&o.EV8_CTRL.Reg)&^(0xf)|value)
}
func (o *SCT0_Type) GetEV8_CTRL_MATCHSEL() uint32 {
	return volatile.LoadUint32(&o.EV8_CTRL.Reg) & 0xf
}
func (o *SCT0_Type) SetEV8_CTRL_HEVENT(value uint32) {
	volatile.StoreUint32(&o.EV8_CTRL.Reg, volatile.LoadUint32(&o.EV8_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *SCT0_Type) GetEV8_CTRL_HEVENT() uint32 {
	return (volatile.LoadUint32(&o.EV8_CTRL.Reg) & 0x10) >> 4
}
func (o *SCT0_Type) SetEV8_CTRL_OUTSEL(value uint32) {
	volatile.StoreUint32(&o.EV8_CTRL.Reg, volatile.LoadUint32(&o.EV8_CTRL.Reg)&^(0x20)|value<<5)
}
func (o *SCT0_Type) GetEV8_CTRL_OUTSEL() uint32 {
	return (volatile.LoadUint32(&o.EV8_CTRL.Reg) & 0x20) >> 5
}
func (o *SCT0_Type) SetEV8_CTRL_IOSEL(value uint32) {
	volatile.StoreUint32(&o.EV8_CTRL.Reg, volatile.LoadUint32(&o.EV8_CTRL.Reg)&^(0x3c0)|value<<6)
}
func (o *SCT0_Type) GetEV8_CTRL_IOSEL() uint32 {
	return (volatile.LoadUint32(&o.EV8_CTRL.Reg) & 0x3c0) >> 6
}
func (o *SCT0_Type) SetEV8_CTRL_IOCOND(value uint32) {
	volatile.StoreUint32(&o.EV8_CTRL.Reg, volatile.LoadUint32(&o.EV8_CTRL.Reg)&^(0xc00)|value<<10)
}
func (o *SCT0_Type) GetEV8_CTRL_IOCOND() uint32 {
	return (volatile.LoadUint32(&o.EV8_CTRL.Reg) & 0xc00) >> 10
}
func (o *SCT0_Type) SetEV8_CTRL_COMBMODE(value uint32) {
	volatile.StoreUint32(&o.EV8_CTRL.Reg, volatile.LoadUint32(&o.EV8_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *SCT0_Type) GetEV8_CTRL_COMBMODE() uint32 {
	return (volatile.LoadUint32(&o.EV8_CTRL.Reg) & 0x3000) >> 12
}
func (o *SCT0_Type) SetEV8_CTRL_STATELD(value uint32) {
	volatile.StoreUint32(&o.EV8_CTRL.Reg, volatile.LoadUint32(&o.EV8_CTRL.Reg)&^(0x4000)|value<<14)
}
func (o *SCT0_Type) GetEV8_CTRL_STATELD() uint32 {
	return (volatile.LoadUint32(&o.EV8_CTRL.Reg) & 0x4000) >> 14
}
func (o *SCT0_Type) SetEV8_CTRL_STATEV(value uint32) {
	volatile.StoreUint32(&o.EV8_CTRL.Reg, volatile.LoadUint32(&o.EV8_CTRL.Reg)&^(0xf8000)|value<<15)
}
func (o *SCT0_Type) GetEV8_CTRL_STATEV() uint32 {
	return (volatile.LoadUint32(&o.EV8_CTRL.Reg) & 0xf8000) >> 15
}
func (o *SCT0_Type) SetEV8_CTRL_MATCHMEM(value uint32) {
	volatile.StoreUint32(&o.EV8_CTRL.Reg, volatile.LoadUint32(&o.EV8_CTRL.Reg)&^(0x100000)|value<<20)
}
func (o *SCT0_Type) GetEV8_CTRL_MATCHMEM() uint32 {
	return (volatile.LoadUint32(&o.EV8_CTRL.Reg) & 0x100000) >> 20
}
func (o *SCT0_Type) SetEV8_CTRL_DIRECTION(value uint32) {
	volatile.StoreUint32(&o.EV8_CTRL.Reg, volatile.LoadUint32(&o.EV8_CTRL.Reg)&^(0x600000)|value<<21)
}
func (o *SCT0_Type) GetEV8_CTRL_DIRECTION() uint32 {
	return (volatile.LoadUint32(&o.EV8_CTRL.Reg) & 0x600000) >> 21
}
func (o *SCT0_Type) SetEV8_CTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EV8_CTRL.Reg, volatile.LoadUint32(&o.EV8_CTRL.Reg)&^(0xff800000)|value<<23)
}
func (o *SCT0_Type) GetEV8_CTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EV8_CTRL.Reg) & 0xff800000) >> 23
}

// SCT0.EV9_STATE: SCT event state register 0
func (o *SCT0_Type) SetEV9_STATE(value uint32) {
	volatile.StoreUint32(&o.EV9_STATE.Reg, value)
}
func (o *SCT0_Type) GetEV9_STATE() uint32 {
	return volatile.LoadUint32(&o.EV9_STATE.Reg)
}

// SCT0.EV9_CTRL: SCT event control register 0
func (o *SCT0_Type) SetEV9_CTRL_MATCHSEL(value uint32) {
	volatile.StoreUint32(&o.EV9_CTRL.Reg, volatile.LoadUint32(&o.EV9_CTRL.Reg)&^(0xf)|value)
}
func (o *SCT0_Type) GetEV9_CTRL_MATCHSEL() uint32 {
	return volatile.LoadUint32(&o.EV9_CTRL.Reg) & 0xf
}
func (o *SCT0_Type) SetEV9_CTRL_HEVENT(value uint32) {
	volatile.StoreUint32(&o.EV9_CTRL.Reg, volatile.LoadUint32(&o.EV9_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *SCT0_Type) GetEV9_CTRL_HEVENT() uint32 {
	return (volatile.LoadUint32(&o.EV9_CTRL.Reg) & 0x10) >> 4
}
func (o *SCT0_Type) SetEV9_CTRL_OUTSEL(value uint32) {
	volatile.StoreUint32(&o.EV9_CTRL.Reg, volatile.LoadUint32(&o.EV9_CTRL.Reg)&^(0x20)|value<<5)
}
func (o *SCT0_Type) GetEV9_CTRL_OUTSEL() uint32 {
	return (volatile.LoadUint32(&o.EV9_CTRL.Reg) & 0x20) >> 5
}
func (o *SCT0_Type) SetEV9_CTRL_IOSEL(value uint32) {
	volatile.StoreUint32(&o.EV9_CTRL.Reg, volatile.LoadUint32(&o.EV9_CTRL.Reg)&^(0x3c0)|value<<6)
}
func (o *SCT0_Type) GetEV9_CTRL_IOSEL() uint32 {
	return (volatile.LoadUint32(&o.EV9_CTRL.Reg) & 0x3c0) >> 6
}
func (o *SCT0_Type) SetEV9_CTRL_IOCOND(value uint32) {
	volatile.StoreUint32(&o.EV9_CTRL.Reg, volatile.LoadUint32(&o.EV9_CTRL.Reg)&^(0xc00)|value<<10)
}
func (o *SCT0_Type) GetEV9_CTRL_IOCOND() uint32 {
	return (volatile.LoadUint32(&o.EV9_CTRL.Reg) & 0xc00) >> 10
}
func (o *SCT0_Type) SetEV9_CTRL_COMBMODE(value uint32) {
	volatile.StoreUint32(&o.EV9_CTRL.Reg, volatile.LoadUint32(&o.EV9_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *SCT0_Type) GetEV9_CTRL_COMBMODE() uint32 {
	return (volatile.LoadUint32(&o.EV9_CTRL.Reg) & 0x3000) >> 12
}
func (o *SCT0_Type) SetEV9_CTRL_STATELD(value uint32) {
	volatile.StoreUint32(&o.EV9_CTRL.Reg, volatile.LoadUint32(&o.EV9_CTRL.Reg)&^(0x4000)|value<<14)
}
func (o *SCT0_Type) GetEV9_CTRL_STATELD() uint32 {
	return (volatile.LoadUint32(&o.EV9_CTRL.Reg) & 0x4000) >> 14
}
func (o *SCT0_Type) SetEV9_CTRL_STATEV(value uint32) {
	volatile.StoreUint32(&o.EV9_CTRL.Reg, volatile.LoadUint32(&o.EV9_CTRL.Reg)&^(0xf8000)|value<<15)
}
func (o *SCT0_Type) GetEV9_CTRL_STATEV() uint32 {
	return (volatile.LoadUint32(&o.EV9_CTRL.Reg) & 0xf8000) >> 15
}
func (o *SCT0_Type) SetEV9_CTRL_MATCHMEM(value uint32) {
	volatile.StoreUint32(&o.EV9_CTRL.Reg, volatile.LoadUint32(&o.EV9_CTRL.Reg)&^(0x100000)|value<<20)
}
func (o *SCT0_Type) GetEV9_CTRL_MATCHMEM() uint32 {
	return (volatile.LoadUint32(&o.EV9_CTRL.Reg) & 0x100000) >> 20
}
func (o *SCT0_Type) SetEV9_CTRL_DIRECTION(value uint32) {
	volatile.StoreUint32(&o.EV9_CTRL.Reg, volatile.LoadUint32(&o.EV9_CTRL.Reg)&^(0x600000)|value<<21)
}
func (o *SCT0_Type) GetEV9_CTRL_DIRECTION() uint32 {
	return (volatile.LoadUint32(&o.EV9_CTRL.Reg) & 0x600000) >> 21
}
func (o *SCT0_Type) SetEV9_CTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EV9_CTRL.Reg, volatile.LoadUint32(&o.EV9_CTRL.Reg)&^(0xff800000)|value<<23)
}
func (o *SCT0_Type) GetEV9_CTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EV9_CTRL.Reg) & 0xff800000) >> 23
}

// SCT0.EV10_STATE: SCT event state register 0
func (o *SCT0_Type) SetEV10_STATE(value uint32) {
	volatile.StoreUint32(&o.EV10_STATE.Reg, value)
}
func (o *SCT0_Type) GetEV10_STATE() uint32 {
	return volatile.LoadUint32(&o.EV10_STATE.Reg)
}

// SCT0.EV10_CTRL: SCT event control register 0
func (o *SCT0_Type) SetEV10_CTRL_MATCHSEL(value uint32) {
	volatile.StoreUint32(&o.EV10_CTRL.Reg, volatile.LoadUint32(&o.EV10_CTRL.Reg)&^(0xf)|value)
}
func (o *SCT0_Type) GetEV10_CTRL_MATCHSEL() uint32 {
	return volatile.LoadUint32(&o.EV10_CTRL.Reg) & 0xf
}
func (o *SCT0_Type) SetEV10_CTRL_HEVENT(value uint32) {
	volatile.StoreUint32(&o.EV10_CTRL.Reg, volatile.LoadUint32(&o.EV10_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *SCT0_Type) GetEV10_CTRL_HEVENT() uint32 {
	return (volatile.LoadUint32(&o.EV10_CTRL.Reg) & 0x10) >> 4
}
func (o *SCT0_Type) SetEV10_CTRL_OUTSEL(value uint32) {
	volatile.StoreUint32(&o.EV10_CTRL.Reg, volatile.LoadUint32(&o.EV10_CTRL.Reg)&^(0x20)|value<<5)
}
func (o *SCT0_Type) GetEV10_CTRL_OUTSEL() uint32 {
	return (volatile.LoadUint32(&o.EV10_CTRL.Reg) & 0x20) >> 5
}
func (o *SCT0_Type) SetEV10_CTRL_IOSEL(value uint32) {
	volatile.StoreUint32(&o.EV10_CTRL.Reg, volatile.LoadUint32(&o.EV10_CTRL.Reg)&^(0x3c0)|value<<6)
}
func (o *SCT0_Type) GetEV10_CTRL_IOSEL() uint32 {
	return (volatile.LoadUint32(&o.EV10_CTRL.Reg) & 0x3c0) >> 6
}
func (o *SCT0_Type) SetEV10_CTRL_IOCOND(value uint32) {
	volatile.StoreUint32(&o.EV10_CTRL.Reg, volatile.LoadUint32(&o.EV10_CTRL.Reg)&^(0xc00)|value<<10)
}
func (o *SCT0_Type) GetEV10_CTRL_IOCOND() uint32 {
	return (volatile.LoadUint32(&o.EV10_CTRL.Reg) & 0xc00) >> 10
}
func (o *SCT0_Type) SetEV10_CTRL_COMBMODE(value uint32) {
	volatile.StoreUint32(&o.EV10_CTRL.Reg, volatile.LoadUint32(&o.EV10_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *SCT0_Type) GetEV10_CTRL_COMBMODE() uint32 {
	return (volatile.LoadUint32(&o.EV10_CTRL.Reg) & 0x3000) >> 12
}
func (o *SCT0_Type) SetEV10_CTRL_STATELD(value uint32) {
	volatile.StoreUint32(&o.EV10_CTRL.Reg, volatile.LoadUint32(&o.EV10_CTRL.Reg)&^(0x4000)|value<<14)
}
func (o *SCT0_Type) GetEV10_CTRL_STATELD() uint32 {
	return (volatile.LoadUint32(&o.EV10_CTRL.Reg) & 0x4000) >> 14
}
func (o *SCT0_Type) SetEV10_CTRL_STATEV(value uint32) {
	volatile.StoreUint32(&o.EV10_CTRL.Reg, volatile.LoadUint32(&o.EV10_CTRL.Reg)&^(0xf8000)|value<<15)
}
func (o *SCT0_Type) GetEV10_CTRL_STATEV() uint32 {
	return (volatile.LoadUint32(&o.EV10_CTRL.Reg) & 0xf8000) >> 15
}
func (o *SCT0_Type) SetEV10_CTRL_MATCHMEM(value uint32) {
	volatile.StoreUint32(&o.EV10_CTRL.Reg, volatile.LoadUint32(&o.EV10_CTRL.Reg)&^(0x100000)|value<<20)
}
func (o *SCT0_Type) GetEV10_CTRL_MATCHMEM() uint32 {
	return (volatile.LoadUint32(&o.EV10_CTRL.Reg) & 0x100000) >> 20
}
func (o *SCT0_Type) SetEV10_CTRL_DIRECTION(value uint32) {
	volatile.StoreUint32(&o.EV10_CTRL.Reg, volatile.LoadUint32(&o.EV10_CTRL.Reg)&^(0x600000)|value<<21)
}
func (o *SCT0_Type) GetEV10_CTRL_DIRECTION() uint32 {
	return (volatile.LoadUint32(&o.EV10_CTRL.Reg) & 0x600000) >> 21
}
func (o *SCT0_Type) SetEV10_CTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EV10_CTRL.Reg, volatile.LoadUint32(&o.EV10_CTRL.Reg)&^(0xff800000)|value<<23)
}
func (o *SCT0_Type) GetEV10_CTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EV10_CTRL.Reg) & 0xff800000) >> 23
}

// SCT0.EV11_STATE: SCT event state register 0
func (o *SCT0_Type) SetEV11_STATE(value uint32) {
	volatile.StoreUint32(&o.EV11_STATE.Reg, value)
}
func (o *SCT0_Type) GetEV11_STATE() uint32 {
	return volatile.LoadUint32(&o.EV11_STATE.Reg)
}

// SCT0.EV11_CTRL: SCT event control register 0
func (o *SCT0_Type) SetEV11_CTRL_MATCHSEL(value uint32) {
	volatile.StoreUint32(&o.EV11_CTRL.Reg, volatile.LoadUint32(&o.EV11_CTRL.Reg)&^(0xf)|value)
}
func (o *SCT0_Type) GetEV11_CTRL_MATCHSEL() uint32 {
	return volatile.LoadUint32(&o.EV11_CTRL.Reg) & 0xf
}
func (o *SCT0_Type) SetEV11_CTRL_HEVENT(value uint32) {
	volatile.StoreUint32(&o.EV11_CTRL.Reg, volatile.LoadUint32(&o.EV11_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *SCT0_Type) GetEV11_CTRL_HEVENT() uint32 {
	return (volatile.LoadUint32(&o.EV11_CTRL.Reg) & 0x10) >> 4
}
func (o *SCT0_Type) SetEV11_CTRL_OUTSEL(value uint32) {
	volatile.StoreUint32(&o.EV11_CTRL.Reg, volatile.LoadUint32(&o.EV11_CTRL.Reg)&^(0x20)|value<<5)
}
func (o *SCT0_Type) GetEV11_CTRL_OUTSEL() uint32 {
	return (volatile.LoadUint32(&o.EV11_CTRL.Reg) & 0x20) >> 5
}
func (o *SCT0_Type) SetEV11_CTRL_IOSEL(value uint32) {
	volatile.StoreUint32(&o.EV11_CTRL.Reg, volatile.LoadUint32(&o.EV11_CTRL.Reg)&^(0x3c0)|value<<6)
}
func (o *SCT0_Type) GetEV11_CTRL_IOSEL() uint32 {
	return (volatile.LoadUint32(&o.EV11_CTRL.Reg) & 0x3c0) >> 6
}
func (o *SCT0_Type) SetEV11_CTRL_IOCOND(value uint32) {
	volatile.StoreUint32(&o.EV11_CTRL.Reg, volatile.LoadUint32(&o.EV11_CTRL.Reg)&^(0xc00)|value<<10)
}
func (o *SCT0_Type) GetEV11_CTRL_IOCOND() uint32 {
	return (volatile.LoadUint32(&o.EV11_CTRL.Reg) & 0xc00) >> 10
}
func (o *SCT0_Type) SetEV11_CTRL_COMBMODE(value uint32) {
	volatile.StoreUint32(&o.EV11_CTRL.Reg, volatile.LoadUint32(&o.EV11_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *SCT0_Type) GetEV11_CTRL_COMBMODE() uint32 {
	return (volatile.LoadUint32(&o.EV11_CTRL.Reg) & 0x3000) >> 12
}
func (o *SCT0_Type) SetEV11_CTRL_STATELD(value uint32) {
	volatile.StoreUint32(&o.EV11_CTRL.Reg, volatile.LoadUint32(&o.EV11_CTRL.Reg)&^(0x4000)|value<<14)
}
func (o *SCT0_Type) GetEV11_CTRL_STATELD() uint32 {
	return (volatile.LoadUint32(&o.EV11_CTRL.Reg) & 0x4000) >> 14
}
func (o *SCT0_Type) SetEV11_CTRL_STATEV(value uint32) {
	volatile.StoreUint32(&o.EV11_CTRL.Reg, volatile.LoadUint32(&o.EV11_CTRL.Reg)&^(0xf8000)|value<<15)
}
func (o *SCT0_Type) GetEV11_CTRL_STATEV() uint32 {
	return (volatile.LoadUint32(&o.EV11_CTRL.Reg) & 0xf8000) >> 15
}
func (o *SCT0_Type) SetEV11_CTRL_MATCHMEM(value uint32) {
	volatile.StoreUint32(&o.EV11_CTRL.Reg, volatile.LoadUint32(&o.EV11_CTRL.Reg)&^(0x100000)|value<<20)
}
func (o *SCT0_Type) GetEV11_CTRL_MATCHMEM() uint32 {
	return (volatile.LoadUint32(&o.EV11_CTRL.Reg) & 0x100000) >> 20
}
func (o *SCT0_Type) SetEV11_CTRL_DIRECTION(value uint32) {
	volatile.StoreUint32(&o.EV11_CTRL.Reg, volatile.LoadUint32(&o.EV11_CTRL.Reg)&^(0x600000)|value<<21)
}
func (o *SCT0_Type) GetEV11_CTRL_DIRECTION() uint32 {
	return (volatile.LoadUint32(&o.EV11_CTRL.Reg) & 0x600000) >> 21
}
func (o *SCT0_Type) SetEV11_CTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EV11_CTRL.Reg, volatile.LoadUint32(&o.EV11_CTRL.Reg)&^(0xff800000)|value<<23)
}
func (o *SCT0_Type) GetEV11_CTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EV11_CTRL.Reg) & 0xff800000) >> 23
}

// SCT0.EV12_STATE: SCT event state register 0
func (o *SCT0_Type) SetEV12_STATE(value uint32) {
	volatile.StoreUint32(&o.EV12_STATE.Reg, value)
}
func (o *SCT0_Type) GetEV12_STATE() uint32 {
	return volatile.LoadUint32(&o.EV12_STATE.Reg)
}

// SCT0.EV12_CTRL: SCT event control register 0
func (o *SCT0_Type) SetEV12_CTRL_MATCHSEL(value uint32) {
	volatile.StoreUint32(&o.EV12_CTRL.Reg, volatile.LoadUint32(&o.EV12_CTRL.Reg)&^(0xf)|value)
}
func (o *SCT0_Type) GetEV12_CTRL_MATCHSEL() uint32 {
	return volatile.LoadUint32(&o.EV12_CTRL.Reg) & 0xf
}
func (o *SCT0_Type) SetEV12_CTRL_HEVENT(value uint32) {
	volatile.StoreUint32(&o.EV12_CTRL.Reg, volatile.LoadUint32(&o.EV12_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *SCT0_Type) GetEV12_CTRL_HEVENT() uint32 {
	return (volatile.LoadUint32(&o.EV12_CTRL.Reg) & 0x10) >> 4
}
func (o *SCT0_Type) SetEV12_CTRL_OUTSEL(value uint32) {
	volatile.StoreUint32(&o.EV12_CTRL.Reg, volatile.LoadUint32(&o.EV12_CTRL.Reg)&^(0x20)|value<<5)
}
func (o *SCT0_Type) GetEV12_CTRL_OUTSEL() uint32 {
	return (volatile.LoadUint32(&o.EV12_CTRL.Reg) & 0x20) >> 5
}
func (o *SCT0_Type) SetEV12_CTRL_IOSEL(value uint32) {
	volatile.StoreUint32(&o.EV12_CTRL.Reg, volatile.LoadUint32(&o.EV12_CTRL.Reg)&^(0x3c0)|value<<6)
}
func (o *SCT0_Type) GetEV12_CTRL_IOSEL() uint32 {
	return (volatile.LoadUint32(&o.EV12_CTRL.Reg) & 0x3c0) >> 6
}
func (o *SCT0_Type) SetEV12_CTRL_IOCOND(value uint32) {
	volatile.StoreUint32(&o.EV12_CTRL.Reg, volatile.LoadUint32(&o.EV12_CTRL.Reg)&^(0xc00)|value<<10)
}
func (o *SCT0_Type) GetEV12_CTRL_IOCOND() uint32 {
	return (volatile.LoadUint32(&o.EV12_CTRL.Reg) & 0xc00) >> 10
}
func (o *SCT0_Type) SetEV12_CTRL_COMBMODE(value uint32) {
	volatile.StoreUint32(&o.EV12_CTRL.Reg, volatile.LoadUint32(&o.EV12_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *SCT0_Type) GetEV12_CTRL_COMBMODE() uint32 {
	return (volatile.LoadUint32(&o.EV12_CTRL.Reg) & 0x3000) >> 12
}
func (o *SCT0_Type) SetEV12_CTRL_STATELD(value uint32) {
	volatile.StoreUint32(&o.EV12_CTRL.Reg, volatile.LoadUint32(&o.EV12_CTRL.Reg)&^(0x4000)|value<<14)
}
func (o *SCT0_Type) GetEV12_CTRL_STATELD() uint32 {
	return (volatile.LoadUint32(&o.EV12_CTRL.Reg) & 0x4000) >> 14
}
func (o *SCT0_Type) SetEV12_CTRL_STATEV(value uint32) {
	volatile.StoreUint32(&o.EV12_CTRL.Reg, volatile.LoadUint32(&o.EV12_CTRL.Reg)&^(0xf8000)|value<<15)
}
func (o *SCT0_Type) GetEV12_CTRL_STATEV() uint32 {
	return (volatile.LoadUint32(&o.EV12_CTRL.Reg) & 0xf8000) >> 15
}
func (o *SCT0_Type) SetEV12_CTRL_MATCHMEM(value uint32) {
	volatile.StoreUint32(&o.EV12_CTRL.Reg, volatile.LoadUint32(&o.EV12_CTRL.Reg)&^(0x100000)|value<<20)
}
func (o *SCT0_Type) GetEV12_CTRL_MATCHMEM() uint32 {
	return (volatile.LoadUint32(&o.EV12_CTRL.Reg) & 0x100000) >> 20
}
func (o *SCT0_Type) SetEV12_CTRL_DIRECTION(value uint32) {
	volatile.StoreUint32(&o.EV12_CTRL.Reg, volatile.LoadUint32(&o.EV12_CTRL.Reg)&^(0x600000)|value<<21)
}
func (o *SCT0_Type) GetEV12_CTRL_DIRECTION() uint32 {
	return (volatile.LoadUint32(&o.EV12_CTRL.Reg) & 0x600000) >> 21
}
func (o *SCT0_Type) SetEV12_CTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EV12_CTRL.Reg, volatile.LoadUint32(&o.EV12_CTRL.Reg)&^(0xff800000)|value<<23)
}
func (o *SCT0_Type) GetEV12_CTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EV12_CTRL.Reg) & 0xff800000) >> 23
}

// SCT0.EV13_STATE: SCT event state register 0
func (o *SCT0_Type) SetEV13_STATE(value uint32) {
	volatile.StoreUint32(&o.EV13_STATE.Reg, value)
}
func (o *SCT0_Type) GetEV13_STATE() uint32 {
	return volatile.LoadUint32(&o.EV13_STATE.Reg)
}

// SCT0.EV13_CTRL: SCT event control register 0
func (o *SCT0_Type) SetEV13_CTRL_MATCHSEL(value uint32) {
	volatile.StoreUint32(&o.EV13_CTRL.Reg, volatile.LoadUint32(&o.EV13_CTRL.Reg)&^(0xf)|value)
}
func (o *SCT0_Type) GetEV13_CTRL_MATCHSEL() uint32 {
	return volatile.LoadUint32(&o.EV13_CTRL.Reg) & 0xf
}
func (o *SCT0_Type) SetEV13_CTRL_HEVENT(value uint32) {
	volatile.StoreUint32(&o.EV13_CTRL.Reg, volatile.LoadUint32(&o.EV13_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *SCT0_Type) GetEV13_CTRL_HEVENT() uint32 {
	return (volatile.LoadUint32(&o.EV13_CTRL.Reg) & 0x10) >> 4
}
func (o *SCT0_Type) SetEV13_CTRL_OUTSEL(value uint32) {
	volatile.StoreUint32(&o.EV13_CTRL.Reg, volatile.LoadUint32(&o.EV13_CTRL.Reg)&^(0x20)|value<<5)
}
func (o *SCT0_Type) GetEV13_CTRL_OUTSEL() uint32 {
	return (volatile.LoadUint32(&o.EV13_CTRL.Reg) & 0x20) >> 5
}
func (o *SCT0_Type) SetEV13_CTRL_IOSEL(value uint32) {
	volatile.StoreUint32(&o.EV13_CTRL.Reg, volatile.LoadUint32(&o.EV13_CTRL.Reg)&^(0x3c0)|value<<6)
}
func (o *SCT0_Type) GetEV13_CTRL_IOSEL() uint32 {
	return (volatile.LoadUint32(&o.EV13_CTRL.Reg) & 0x3c0) >> 6
}
func (o *SCT0_Type) SetEV13_CTRL_IOCOND(value uint32) {
	volatile.StoreUint32(&o.EV13_CTRL.Reg, volatile.LoadUint32(&o.EV13_CTRL.Reg)&^(0xc00)|value<<10)
}
func (o *SCT0_Type) GetEV13_CTRL_IOCOND() uint32 {
	return (volatile.LoadUint32(&o.EV13_CTRL.Reg) & 0xc00) >> 10
}
func (o *SCT0_Type) SetEV13_CTRL_COMBMODE(value uint32) {
	volatile.StoreUint32(&o.EV13_CTRL.Reg, volatile.LoadUint32(&o.EV13_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *SCT0_Type) GetEV13_CTRL_COMBMODE() uint32 {
	return (volatile.LoadUint32(&o.EV13_CTRL.Reg) & 0x3000) >> 12
}
func (o *SCT0_Type) SetEV13_CTRL_STATELD(value uint32) {
	volatile.StoreUint32(&o.EV13_CTRL.Reg, volatile.LoadUint32(&o.EV13_CTRL.Reg)&^(0x4000)|value<<14)
}
func (o *SCT0_Type) GetEV13_CTRL_STATELD() uint32 {
	return (volatile.LoadUint32(&o.EV13_CTRL.Reg) & 0x4000) >> 14
}
func (o *SCT0_Type) SetEV13_CTRL_STATEV(value uint32) {
	volatile.StoreUint32(&o.EV13_CTRL.Reg, volatile.LoadUint32(&o.EV13_CTRL.Reg)&^(0xf8000)|value<<15)
}
func (o *SCT0_Type) GetEV13_CTRL_STATEV() uint32 {
	return (volatile.LoadUint32(&o.EV13_CTRL.Reg) & 0xf8000) >> 15
}
func (o *SCT0_Type) SetEV13_CTRL_MATCHMEM(value uint32) {
	volatile.StoreUint32(&o.EV13_CTRL.Reg, volatile.LoadUint32(&o.EV13_CTRL.Reg)&^(0x100000)|value<<20)
}
func (o *SCT0_Type) GetEV13_CTRL_MATCHMEM() uint32 {
	return (volatile.LoadUint32(&o.EV13_CTRL.Reg) & 0x100000) >> 20
}
func (o *SCT0_Type) SetEV13_CTRL_DIRECTION(value uint32) {
	volatile.StoreUint32(&o.EV13_CTRL.Reg, volatile.LoadUint32(&o.EV13_CTRL.Reg)&^(0x600000)|value<<21)
}
func (o *SCT0_Type) GetEV13_CTRL_DIRECTION() uint32 {
	return (volatile.LoadUint32(&o.EV13_CTRL.Reg) & 0x600000) >> 21
}
func (o *SCT0_Type) SetEV13_CTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EV13_CTRL.Reg, volatile.LoadUint32(&o.EV13_CTRL.Reg)&^(0xff800000)|value<<23)
}
func (o *SCT0_Type) GetEV13_CTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EV13_CTRL.Reg) & 0xff800000) >> 23
}

// SCT0.EV14_STATE: SCT event state register 0
func (o *SCT0_Type) SetEV14_STATE(value uint32) {
	volatile.StoreUint32(&o.EV14_STATE.Reg, value)
}
func (o *SCT0_Type) GetEV14_STATE() uint32 {
	return volatile.LoadUint32(&o.EV14_STATE.Reg)
}

// SCT0.EV14_CTRL: SCT event control register 0
func (o *SCT0_Type) SetEV14_CTRL_MATCHSEL(value uint32) {
	volatile.StoreUint32(&o.EV14_CTRL.Reg, volatile.LoadUint32(&o.EV14_CTRL.Reg)&^(0xf)|value)
}
func (o *SCT0_Type) GetEV14_CTRL_MATCHSEL() uint32 {
	return volatile.LoadUint32(&o.EV14_CTRL.Reg) & 0xf
}
func (o *SCT0_Type) SetEV14_CTRL_HEVENT(value uint32) {
	volatile.StoreUint32(&o.EV14_CTRL.Reg, volatile.LoadUint32(&o.EV14_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *SCT0_Type) GetEV14_CTRL_HEVENT() uint32 {
	return (volatile.LoadUint32(&o.EV14_CTRL.Reg) & 0x10) >> 4
}
func (o *SCT0_Type) SetEV14_CTRL_OUTSEL(value uint32) {
	volatile.StoreUint32(&o.EV14_CTRL.Reg, volatile.LoadUint32(&o.EV14_CTRL.Reg)&^(0x20)|value<<5)
}
func (o *SCT0_Type) GetEV14_CTRL_OUTSEL() uint32 {
	return (volatile.LoadUint32(&o.EV14_CTRL.Reg) & 0x20) >> 5
}
func (o *SCT0_Type) SetEV14_CTRL_IOSEL(value uint32) {
	volatile.StoreUint32(&o.EV14_CTRL.Reg, volatile.LoadUint32(&o.EV14_CTRL.Reg)&^(0x3c0)|value<<6)
}
func (o *SCT0_Type) GetEV14_CTRL_IOSEL() uint32 {
	return (volatile.LoadUint32(&o.EV14_CTRL.Reg) & 0x3c0) >> 6
}
func (o *SCT0_Type) SetEV14_CTRL_IOCOND(value uint32) {
	volatile.StoreUint32(&o.EV14_CTRL.Reg, volatile.LoadUint32(&o.EV14_CTRL.Reg)&^(0xc00)|value<<10)
}
func (o *SCT0_Type) GetEV14_CTRL_IOCOND() uint32 {
	return (volatile.LoadUint32(&o.EV14_CTRL.Reg) & 0xc00) >> 10
}
func (o *SCT0_Type) SetEV14_CTRL_COMBMODE(value uint32) {
	volatile.StoreUint32(&o.EV14_CTRL.Reg, volatile.LoadUint32(&o.EV14_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *SCT0_Type) GetEV14_CTRL_COMBMODE() uint32 {
	return (volatile.LoadUint32(&o.EV14_CTRL.Reg) & 0x3000) >> 12
}
func (o *SCT0_Type) SetEV14_CTRL_STATELD(value uint32) {
	volatile.StoreUint32(&o.EV14_CTRL.Reg, volatile.LoadUint32(&o.EV14_CTRL.Reg)&^(0x4000)|value<<14)
}
func (o *SCT0_Type) GetEV14_CTRL_STATELD() uint32 {
	return (volatile.LoadUint32(&o.EV14_CTRL.Reg) & 0x4000) >> 14
}
func (o *SCT0_Type) SetEV14_CTRL_STATEV(value uint32) {
	volatile.StoreUint32(&o.EV14_CTRL.Reg, volatile.LoadUint32(&o.EV14_CTRL.Reg)&^(0xf8000)|value<<15)
}
func (o *SCT0_Type) GetEV14_CTRL_STATEV() uint32 {
	return (volatile.LoadUint32(&o.EV14_CTRL.Reg) & 0xf8000) >> 15
}
func (o *SCT0_Type) SetEV14_CTRL_MATCHMEM(value uint32) {
	volatile.StoreUint32(&o.EV14_CTRL.Reg, volatile.LoadUint32(&o.EV14_CTRL.Reg)&^(0x100000)|value<<20)
}
func (o *SCT0_Type) GetEV14_CTRL_MATCHMEM() uint32 {
	return (volatile.LoadUint32(&o.EV14_CTRL.Reg) & 0x100000) >> 20
}
func (o *SCT0_Type) SetEV14_CTRL_DIRECTION(value uint32) {
	volatile.StoreUint32(&o.EV14_CTRL.Reg, volatile.LoadUint32(&o.EV14_CTRL.Reg)&^(0x600000)|value<<21)
}
func (o *SCT0_Type) GetEV14_CTRL_DIRECTION() uint32 {
	return (volatile.LoadUint32(&o.EV14_CTRL.Reg) & 0x600000) >> 21
}
func (o *SCT0_Type) SetEV14_CTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EV14_CTRL.Reg, volatile.LoadUint32(&o.EV14_CTRL.Reg)&^(0xff800000)|value<<23)
}
func (o *SCT0_Type) GetEV14_CTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EV14_CTRL.Reg) & 0xff800000) >> 23
}

// SCT0.EV15_STATE: SCT event state register 0
func (o *SCT0_Type) SetEV15_STATE(value uint32) {
	volatile.StoreUint32(&o.EV15_STATE.Reg, value)
}
func (o *SCT0_Type) GetEV15_STATE() uint32 {
	return volatile.LoadUint32(&o.EV15_STATE.Reg)
}

// SCT0.EV15_CTRL: SCT event control register 0
func (o *SCT0_Type) SetEV15_CTRL_MATCHSEL(value uint32) {
	volatile.StoreUint32(&o.EV15_CTRL.Reg, volatile.LoadUint32(&o.EV15_CTRL.Reg)&^(0xf)|value)
}
func (o *SCT0_Type) GetEV15_CTRL_MATCHSEL() uint32 {
	return volatile.LoadUint32(&o.EV15_CTRL.Reg) & 0xf
}
func (o *SCT0_Type) SetEV15_CTRL_HEVENT(value uint32) {
	volatile.StoreUint32(&o.EV15_CTRL.Reg, volatile.LoadUint32(&o.EV15_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *SCT0_Type) GetEV15_CTRL_HEVENT() uint32 {
	return (volatile.LoadUint32(&o.EV15_CTRL.Reg) & 0x10) >> 4
}
func (o *SCT0_Type) SetEV15_CTRL_OUTSEL(value uint32) {
	volatile.StoreUint32(&o.EV15_CTRL.Reg, volatile.LoadUint32(&o.EV15_CTRL.Reg)&^(0x20)|value<<5)
}
func (o *SCT0_Type) GetEV15_CTRL_OUTSEL() uint32 {
	return (volatile.LoadUint32(&o.EV15_CTRL.Reg) & 0x20) >> 5
}
func (o *SCT0_Type) SetEV15_CTRL_IOSEL(value uint32) {
	volatile.StoreUint32(&o.EV15_CTRL.Reg, volatile.LoadUint32(&o.EV15_CTRL.Reg)&^(0x3c0)|value<<6)
}
func (o *SCT0_Type) GetEV15_CTRL_IOSEL() uint32 {
	return (volatile.LoadUint32(&o.EV15_CTRL.Reg) & 0x3c0) >> 6
}
func (o *SCT0_Type) SetEV15_CTRL_IOCOND(value uint32) {
	volatile.StoreUint32(&o.EV15_CTRL.Reg, volatile.LoadUint32(&o.EV15_CTRL.Reg)&^(0xc00)|value<<10)
}
func (o *SCT0_Type) GetEV15_CTRL_IOCOND() uint32 {
	return (volatile.LoadUint32(&o.EV15_CTRL.Reg) & 0xc00) >> 10
}
func (o *SCT0_Type) SetEV15_CTRL_COMBMODE(value uint32) {
	volatile.StoreUint32(&o.EV15_CTRL.Reg, volatile.LoadUint32(&o.EV15_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *SCT0_Type) GetEV15_CTRL_COMBMODE() uint32 {
	return (volatile.LoadUint32(&o.EV15_CTRL.Reg) & 0x3000) >> 12
}
func (o *SCT0_Type) SetEV15_CTRL_STATELD(value uint32) {
	volatile.StoreUint32(&o.EV15_CTRL.Reg, volatile.LoadUint32(&o.EV15_CTRL.Reg)&^(0x4000)|value<<14)
}
func (o *SCT0_Type) GetEV15_CTRL_STATELD() uint32 {
	return (volatile.LoadUint32(&o.EV15_CTRL.Reg) & 0x4000) >> 14
}
func (o *SCT0_Type) SetEV15_CTRL_STATEV(value uint32) {
	volatile.StoreUint32(&o.EV15_CTRL.Reg, volatile.LoadUint32(&o.EV15_CTRL.Reg)&^(0xf8000)|value<<15)
}
func (o *SCT0_Type) GetEV15_CTRL_STATEV() uint32 {
	return (volatile.LoadUint32(&o.EV15_CTRL.Reg) & 0xf8000) >> 15
}
func (o *SCT0_Type) SetEV15_CTRL_MATCHMEM(value uint32) {
	volatile.StoreUint32(&o.EV15_CTRL.Reg, volatile.LoadUint32(&o.EV15_CTRL.Reg)&^(0x100000)|value<<20)
}
func (o *SCT0_Type) GetEV15_CTRL_MATCHMEM() uint32 {
	return (volatile.LoadUint32(&o.EV15_CTRL.Reg) & 0x100000) >> 20
}
func (o *SCT0_Type) SetEV15_CTRL_DIRECTION(value uint32) {
	volatile.StoreUint32(&o.EV15_CTRL.Reg, volatile.LoadUint32(&o.EV15_CTRL.Reg)&^(0x600000)|value<<21)
}
func (o *SCT0_Type) GetEV15_CTRL_DIRECTION() uint32 {
	return (volatile.LoadUint32(&o.EV15_CTRL.Reg) & 0x600000) >> 21
}
func (o *SCT0_Type) SetEV15_CTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EV15_CTRL.Reg, volatile.LoadUint32(&o.EV15_CTRL.Reg)&^(0xff800000)|value<<23)
}
func (o *SCT0_Type) GetEV15_CTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EV15_CTRL.Reg) & 0xff800000) >> 23
}

// SCT0.OUT0_SET: SCT output 0 set register
func (o *SCT0_Type) SetOUT0_SET_SET(value uint32) {
	volatile.StoreUint32(&o.OUT0_SET.Reg, volatile.LoadUint32(&o.OUT0_SET.Reg)&^(0xffff)|value)
}
func (o *SCT0_Type) GetOUT0_SET_SET() uint32 {
	return volatile.LoadUint32(&o.OUT0_SET.Reg) & 0xffff
}
func (o *SCT0_Type) SetOUT0_SET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.OUT0_SET.Reg, volatile.LoadUint32(&o.OUT0_SET.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT0_Type) GetOUT0_SET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.OUT0_SET.Reg) & 0xffff0000) >> 16
}

// SCT0.OUT0_CLR: SCT output 0 clear register
func (o *SCT0_Type) SetOUT0_CLR_CLR(value uint32) {
	volatile.StoreUint32(&o.OUT0_CLR.Reg, volatile.LoadUint32(&o.OUT0_CLR.Reg)&^(0xffff)|value)
}
func (o *SCT0_Type) GetOUT0_CLR_CLR() uint32 {
	return volatile.LoadUint32(&o.OUT0_CLR.Reg) & 0xffff
}
func (o *SCT0_Type) SetOUT0_CLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.OUT0_CLR.Reg, volatile.LoadUint32(&o.OUT0_CLR.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT0_Type) GetOUT0_CLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.OUT0_CLR.Reg) & 0xffff0000) >> 16
}

// SCT0.OUT1_SET: SCT output 0 set register
func (o *SCT0_Type) SetOUT1_SET_SET(value uint32) {
	volatile.StoreUint32(&o.OUT1_SET.Reg, volatile.LoadUint32(&o.OUT1_SET.Reg)&^(0xffff)|value)
}
func (o *SCT0_Type) GetOUT1_SET_SET() uint32 {
	return volatile.LoadUint32(&o.OUT1_SET.Reg) & 0xffff
}
func (o *SCT0_Type) SetOUT1_SET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.OUT1_SET.Reg, volatile.LoadUint32(&o.OUT1_SET.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT0_Type) GetOUT1_SET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.OUT1_SET.Reg) & 0xffff0000) >> 16
}

// SCT0.OUT1_CLR: SCT output 0 clear register
func (o *SCT0_Type) SetOUT1_CLR_CLR(value uint32) {
	volatile.StoreUint32(&o.OUT1_CLR.Reg, volatile.LoadUint32(&o.OUT1_CLR.Reg)&^(0xffff)|value)
}
func (o *SCT0_Type) GetOUT1_CLR_CLR() uint32 {
	return volatile.LoadUint32(&o.OUT1_CLR.Reg) & 0xffff
}
func (o *SCT0_Type) SetOUT1_CLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.OUT1_CLR.Reg, volatile.LoadUint32(&o.OUT1_CLR.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT0_Type) GetOUT1_CLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.OUT1_CLR.Reg) & 0xffff0000) >> 16
}

// SCT0.OUT2_SET: SCT output 0 set register
func (o *SCT0_Type) SetOUT2_SET_SET(value uint32) {
	volatile.StoreUint32(&o.OUT2_SET.Reg, volatile.LoadUint32(&o.OUT2_SET.Reg)&^(0xffff)|value)
}
func (o *SCT0_Type) GetOUT2_SET_SET() uint32 {
	return volatile.LoadUint32(&o.OUT2_SET.Reg) & 0xffff
}
func (o *SCT0_Type) SetOUT2_SET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.OUT2_SET.Reg, volatile.LoadUint32(&o.OUT2_SET.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT0_Type) GetOUT2_SET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.OUT2_SET.Reg) & 0xffff0000) >> 16
}

// SCT0.OUT2_CLR: SCT output 0 clear register
func (o *SCT0_Type) SetOUT2_CLR_CLR(value uint32) {
	volatile.StoreUint32(&o.OUT2_CLR.Reg, volatile.LoadUint32(&o.OUT2_CLR.Reg)&^(0xffff)|value)
}
func (o *SCT0_Type) GetOUT2_CLR_CLR() uint32 {
	return volatile.LoadUint32(&o.OUT2_CLR.Reg) & 0xffff
}
func (o *SCT0_Type) SetOUT2_CLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.OUT2_CLR.Reg, volatile.LoadUint32(&o.OUT2_CLR.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT0_Type) GetOUT2_CLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.OUT2_CLR.Reg) & 0xffff0000) >> 16
}

// SCT0.OUT3_SET: SCT output 0 set register
func (o *SCT0_Type) SetOUT3_SET_SET(value uint32) {
	volatile.StoreUint32(&o.OUT3_SET.Reg, volatile.LoadUint32(&o.OUT3_SET.Reg)&^(0xffff)|value)
}
func (o *SCT0_Type) GetOUT3_SET_SET() uint32 {
	return volatile.LoadUint32(&o.OUT3_SET.Reg) & 0xffff
}
func (o *SCT0_Type) SetOUT3_SET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.OUT3_SET.Reg, volatile.LoadUint32(&o.OUT3_SET.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT0_Type) GetOUT3_SET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.OUT3_SET.Reg) & 0xffff0000) >> 16
}

// SCT0.OUT3_CLR: SCT output 0 clear register
func (o *SCT0_Type) SetOUT3_CLR_CLR(value uint32) {
	volatile.StoreUint32(&o.OUT3_CLR.Reg, volatile.LoadUint32(&o.OUT3_CLR.Reg)&^(0xffff)|value)
}
func (o *SCT0_Type) GetOUT3_CLR_CLR() uint32 {
	return volatile.LoadUint32(&o.OUT3_CLR.Reg) & 0xffff
}
func (o *SCT0_Type) SetOUT3_CLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.OUT3_CLR.Reg, volatile.LoadUint32(&o.OUT3_CLR.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT0_Type) GetOUT3_CLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.OUT3_CLR.Reg) & 0xffff0000) >> 16
}

// SCT0.OUT4_SET: SCT output 0 set register
func (o *SCT0_Type) SetOUT4_SET_SET(value uint32) {
	volatile.StoreUint32(&o.OUT4_SET.Reg, volatile.LoadUint32(&o.OUT4_SET.Reg)&^(0xffff)|value)
}
func (o *SCT0_Type) GetOUT4_SET_SET() uint32 {
	return volatile.LoadUint32(&o.OUT4_SET.Reg) & 0xffff
}
func (o *SCT0_Type) SetOUT4_SET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.OUT4_SET.Reg, volatile.LoadUint32(&o.OUT4_SET.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT0_Type) GetOUT4_SET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.OUT4_SET.Reg) & 0xffff0000) >> 16
}

// SCT0.OUT4_CLR: SCT output 0 clear register
func (o *SCT0_Type) SetOUT4_CLR_CLR(value uint32) {
	volatile.StoreUint32(&o.OUT4_CLR.Reg, volatile.LoadUint32(&o.OUT4_CLR.Reg)&^(0xffff)|value)
}
func (o *SCT0_Type) GetOUT4_CLR_CLR() uint32 {
	return volatile.LoadUint32(&o.OUT4_CLR.Reg) & 0xffff
}
func (o *SCT0_Type) SetOUT4_CLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.OUT4_CLR.Reg, volatile.LoadUint32(&o.OUT4_CLR.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT0_Type) GetOUT4_CLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.OUT4_CLR.Reg) & 0xffff0000) >> 16
}

// SCT0.OUT5_SET: SCT output 0 set register
func (o *SCT0_Type) SetOUT5_SET_SET(value uint32) {
	volatile.StoreUint32(&o.OUT5_SET.Reg, volatile.LoadUint32(&o.OUT5_SET.Reg)&^(0xffff)|value)
}
func (o *SCT0_Type) GetOUT5_SET_SET() uint32 {
	return volatile.LoadUint32(&o.OUT5_SET.Reg) & 0xffff
}
func (o *SCT0_Type) SetOUT5_SET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.OUT5_SET.Reg, volatile.LoadUint32(&o.OUT5_SET.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT0_Type) GetOUT5_SET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.OUT5_SET.Reg) & 0xffff0000) >> 16
}

// SCT0.OUT5_CLR: SCT output 0 clear register
func (o *SCT0_Type) SetOUT5_CLR_CLR(value uint32) {
	volatile.StoreUint32(&o.OUT5_CLR.Reg, volatile.LoadUint32(&o.OUT5_CLR.Reg)&^(0xffff)|value)
}
func (o *SCT0_Type) GetOUT5_CLR_CLR() uint32 {
	return volatile.LoadUint32(&o.OUT5_CLR.Reg) & 0xffff
}
func (o *SCT0_Type) SetOUT5_CLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.OUT5_CLR.Reg, volatile.LoadUint32(&o.OUT5_CLR.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT0_Type) GetOUT5_CLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.OUT5_CLR.Reg) & 0xffff0000) >> 16
}

// SCT0.OUT6_SET: SCT output 0 set register
func (o *SCT0_Type) SetOUT6_SET_SET(value uint32) {
	volatile.StoreUint32(&o.OUT6_SET.Reg, volatile.LoadUint32(&o.OUT6_SET.Reg)&^(0xffff)|value)
}
func (o *SCT0_Type) GetOUT6_SET_SET() uint32 {
	return volatile.LoadUint32(&o.OUT6_SET.Reg) & 0xffff
}
func (o *SCT0_Type) SetOUT6_SET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.OUT6_SET.Reg, volatile.LoadUint32(&o.OUT6_SET.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT0_Type) GetOUT6_SET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.OUT6_SET.Reg) & 0xffff0000) >> 16
}

// SCT0.OUT6_CLR: SCT output 0 clear register
func (o *SCT0_Type) SetOUT6_CLR_CLR(value uint32) {
	volatile.StoreUint32(&o.OUT6_CLR.Reg, volatile.LoadUint32(&o.OUT6_CLR.Reg)&^(0xffff)|value)
}
func (o *SCT0_Type) GetOUT6_CLR_CLR() uint32 {
	return volatile.LoadUint32(&o.OUT6_CLR.Reg) & 0xffff
}
func (o *SCT0_Type) SetOUT6_CLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.OUT6_CLR.Reg, volatile.LoadUint32(&o.OUT6_CLR.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT0_Type) GetOUT6_CLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.OUT6_CLR.Reg) & 0xffff0000) >> 16
}

// SCT0.OUT7_SET: SCT output 0 set register
func (o *SCT0_Type) SetOUT7_SET_SET(value uint32) {
	volatile.StoreUint32(&o.OUT7_SET.Reg, volatile.LoadUint32(&o.OUT7_SET.Reg)&^(0xffff)|value)
}
func (o *SCT0_Type) GetOUT7_SET_SET() uint32 {
	return volatile.LoadUint32(&o.OUT7_SET.Reg) & 0xffff
}
func (o *SCT0_Type) SetOUT7_SET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.OUT7_SET.Reg, volatile.LoadUint32(&o.OUT7_SET.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT0_Type) GetOUT7_SET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.OUT7_SET.Reg) & 0xffff0000) >> 16
}

// SCT0.OUT7_CLR: SCT output 0 clear register
func (o *SCT0_Type) SetOUT7_CLR_CLR(value uint32) {
	volatile.StoreUint32(&o.OUT7_CLR.Reg, volatile.LoadUint32(&o.OUT7_CLR.Reg)&^(0xffff)|value)
}
func (o *SCT0_Type) GetOUT7_CLR_CLR() uint32 {
	return volatile.LoadUint32(&o.OUT7_CLR.Reg) & 0xffff
}
func (o *SCT0_Type) SetOUT7_CLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.OUT7_CLR.Reg, volatile.LoadUint32(&o.OUT7_CLR.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT0_Type) GetOUT7_CLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.OUT7_CLR.Reg) & 0xffff0000) >> 16
}

// SCT0.OUT8_SET: SCT output 0 set register
func (o *SCT0_Type) SetOUT8_SET_SET(value uint32) {
	volatile.StoreUint32(&o.OUT8_SET.Reg, volatile.LoadUint32(&o.OUT8_SET.Reg)&^(0xffff)|value)
}
func (o *SCT0_Type) GetOUT8_SET_SET() uint32 {
	return volatile.LoadUint32(&o.OUT8_SET.Reg) & 0xffff
}
func (o *SCT0_Type) SetOUT8_SET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.OUT8_SET.Reg, volatile.LoadUint32(&o.OUT8_SET.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT0_Type) GetOUT8_SET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.OUT8_SET.Reg) & 0xffff0000) >> 16
}

// SCT0.OUT8_CLR: SCT output 0 clear register
func (o *SCT0_Type) SetOUT8_CLR_CLR(value uint32) {
	volatile.StoreUint32(&o.OUT8_CLR.Reg, volatile.LoadUint32(&o.OUT8_CLR.Reg)&^(0xffff)|value)
}
func (o *SCT0_Type) GetOUT8_CLR_CLR() uint32 {
	return volatile.LoadUint32(&o.OUT8_CLR.Reg) & 0xffff
}
func (o *SCT0_Type) SetOUT8_CLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.OUT8_CLR.Reg, volatile.LoadUint32(&o.OUT8_CLR.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT0_Type) GetOUT8_CLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.OUT8_CLR.Reg) & 0xffff0000) >> 16
}

// SCT0.OUT9_SET: SCT output 0 set register
func (o *SCT0_Type) SetOUT9_SET_SET(value uint32) {
	volatile.StoreUint32(&o.OUT9_SET.Reg, volatile.LoadUint32(&o.OUT9_SET.Reg)&^(0xffff)|value)
}
func (o *SCT0_Type) GetOUT9_SET_SET() uint32 {
	return volatile.LoadUint32(&o.OUT9_SET.Reg) & 0xffff
}
func (o *SCT0_Type) SetOUT9_SET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.OUT9_SET.Reg, volatile.LoadUint32(&o.OUT9_SET.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT0_Type) GetOUT9_SET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.OUT9_SET.Reg) & 0xffff0000) >> 16
}

// SCT0.OUT9_CLR: SCT output 0 clear register
func (o *SCT0_Type) SetOUT9_CLR_CLR(value uint32) {
	volatile.StoreUint32(&o.OUT9_CLR.Reg, volatile.LoadUint32(&o.OUT9_CLR.Reg)&^(0xffff)|value)
}
func (o *SCT0_Type) GetOUT9_CLR_CLR() uint32 {
	return volatile.LoadUint32(&o.OUT9_CLR.Reg) & 0xffff
}
func (o *SCT0_Type) SetOUT9_CLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.OUT9_CLR.Reg, volatile.LoadUint32(&o.OUT9_CLR.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT0_Type) GetOUT9_CLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.OUT9_CLR.Reg) & 0xffff0000) >> 16
}

// Small State Configurable Timers 2/3 (SCT2/3)
type SCT2_Type struct {
	CONFIG        volatile.Register32 // 0x0
	CTRL          volatile.Register32 // 0x4
	LIMIT         volatile.Register32 // 0x8
	HALT          volatile.Register32 // 0xC
	STOP          volatile.Register32 // 0x10
	START         volatile.Register32 // 0x14
	_             [40]byte
	COUNT         volatile.Register32 // 0x40
	STATE         volatile.Register32 // 0x44
	INPUT         volatile.Register32 // 0x48
	REGMODE       volatile.Register32 // 0x4C
	OUTPUT        volatile.Register32 // 0x50
	OUTPUTDIRCTRL volatile.Register32 // 0x54
	RES           volatile.Register32 // 0x58
	DMAREQ0       volatile.Register32 // 0x5C
	DMAREQ1       volatile.Register32 // 0x60
	_             [140]byte
	EVEN          volatile.Register32 // 0xF0
	EVFLAG        volatile.Register32 // 0xF4
	CONEN         volatile.Register32 // 0xF8
	CONFLAG       volatile.Register32 // 0xFC
	MATCH0        volatile.Register32 // 0x100
	MATCH1        volatile.Register32 // 0x104
	MATCH2        volatile.Register32 // 0x108
	MATCH3        volatile.Register32 // 0x10C
	MATCH4        volatile.Register32 // 0x110
	MATCH5        volatile.Register32 // 0x114
	MATCH6        volatile.Register32 // 0x118
	MATCH7        volatile.Register32 // 0x11C
	_             [224]byte
	MATCHREL0     volatile.Register32 // 0x200
	MATCHREL1     volatile.Register32 // 0x204
	MATCHREL2     volatile.Register32 // 0x208
	MATCHREL3     volatile.Register32 // 0x20C
	MATCHREL4     volatile.Register32 // 0x210
	MATCHREL5     volatile.Register32 // 0x214
	MATCHREL6     volatile.Register32 // 0x218
	MATCHREL7     volatile.Register32 // 0x21C
	_             [224]byte
	EV0_STATE     volatile.Register32 // 0x300
	EV0_CTRL      volatile.Register32 // 0x304
	EV1_STATE     volatile.Register32 // 0x308
	EV1_CTRL      volatile.Register32 // 0x30C
	EV2_STATE     volatile.Register32 // 0x310
	EV2_CTRL      volatile.Register32 // 0x314
	EV3_STATE     volatile.Register32 // 0x318
	EV3_CTRL      volatile.Register32 // 0x31C
	EV4_STATE     volatile.Register32 // 0x320
	EV4_CTRL      volatile.Register32 // 0x324
	EV5_STATE     volatile.Register32 // 0x328
	EV5_CTRL      volatile.Register32 // 0x32C
	EV6_STATE     volatile.Register32 // 0x330
	EV6_CTRL      volatile.Register32 // 0x334
	EV7_STATE     volatile.Register32 // 0x338
	EV7_CTRL      volatile.Register32 // 0x33C
	EV8_STATE     volatile.Register32 // 0x340
	EV8_CTRL      volatile.Register32 // 0x344
	EV9_STATE     volatile.Register32 // 0x348
	EV9_CTRL      volatile.Register32 // 0x34C
	_             [432]byte
	OUT0_SET      volatile.Register32 // 0x500
	OUT0_CLR      volatile.Register32 // 0x504
	OUT1_SET      volatile.Register32 // 0x508
	OUT1_CLR      volatile.Register32 // 0x50C
	OUT2_SET      volatile.Register32 // 0x510
	OUT2_CLR      volatile.Register32 // 0x514
	OUT3_SET      volatile.Register32 // 0x518
	OUT3_CLR      volatile.Register32 // 0x51C
	OUT4_SET      volatile.Register32 // 0x520
	OUT4_CLR      volatile.Register32 // 0x524
	OUT5_SET      volatile.Register32 // 0x528
	OUT5_CLR      volatile.Register32 // 0x52C
}

// SCT2.CONFIG: SCT configuration register
func (o *SCT2_Type) SetCONFIG_UNIFY(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x1)|value)
}
func (o *SCT2_Type) GetCONFIG_UNIFY() uint32 {
	return volatile.LoadUint32(&o.CONFIG.Reg) & 0x1
}
func (o *SCT2_Type) SetCONFIG_CLKMODE(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x6)|value<<1)
}
func (o *SCT2_Type) GetCONFIG_CLKMODE() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0x6) >> 1
}
func (o *SCT2_Type) SetCONFIG_CKSEL(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x78)|value<<3)
}
func (o *SCT2_Type) GetCONFIG_CKSEL() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0x78) >> 3
}
func (o *SCT2_Type) SetCONFIG_NORELAOD_L(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x80)|value<<7)
}
func (o *SCT2_Type) GetCONFIG_NORELAOD_L() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0x80) >> 7
}
func (o *SCT2_Type) SetCONFIG_NORELOAD_H(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x100)|value<<8)
}
func (o *SCT2_Type) GetCONFIG_NORELOAD_H() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0x100) >> 8
}
func (o *SCT2_Type) SetCONFIG_INSYNC(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x1fe00)|value<<9)
}
func (o *SCT2_Type) GetCONFIG_INSYNC() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0x1fe00) >> 9
}
func (o *SCT2_Type) SetCONFIG_AUTOLIMIT_L(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x20000)|value<<17)
}
func (o *SCT2_Type) GetCONFIG_AUTOLIMIT_L() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0x20000) >> 17
}
func (o *SCT2_Type) SetCONFIG_AUTOLIMIT_H(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x40000)|value<<18)
}
func (o *SCT2_Type) GetCONFIG_AUTOLIMIT_H() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0x40000) >> 18
}
func (o *SCT2_Type) SetCONFIG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0xfff80000)|value<<19)
}
func (o *SCT2_Type) GetCONFIG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0xfff80000) >> 19
}

// SCT2.CTRL: SCT control register
func (o *SCT2_Type) SetCTRL_DOWN_L(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x1)|value)
}
func (o *SCT2_Type) GetCTRL_DOWN_L() uint32 {
	return volatile.LoadUint32(&o.CTRL.Reg) & 0x1
}
func (o *SCT2_Type) SetCTRL_STOP_L(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x2)|value<<1)
}
func (o *SCT2_Type) GetCTRL_STOP_L() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x2) >> 1
}
func (o *SCT2_Type) SetCTRL_HALT_L(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x4)|value<<2)
}
func (o *SCT2_Type) GetCTRL_HALT_L() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x4) >> 2
}
func (o *SCT2_Type) SetCTRL_CLRCTR_L(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x8)|value<<3)
}
func (o *SCT2_Type) GetCTRL_CLRCTR_L() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x8) >> 3
}
func (o *SCT2_Type) SetCTRL_BIDIR_L(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x10)|value<<4)
}
func (o *SCT2_Type) GetCTRL_BIDIR_L() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x10) >> 4
}
func (o *SCT2_Type) SetCTRL_PRE_L(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x1fe0)|value<<5)
}
func (o *SCT2_Type) GetCTRL_PRE_L() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x1fe0) >> 5
}
func (o *SCT2_Type) SetCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0xe000)|value<<13)
}
func (o *SCT2_Type) GetCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0xe000) >> 13
}
func (o *SCT2_Type) SetCTRL_DOWN_H(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x10000)|value<<16)
}
func (o *SCT2_Type) GetCTRL_DOWN_H() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x10000) >> 16
}
func (o *SCT2_Type) SetCTRL_STOP_H(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x20000)|value<<17)
}
func (o *SCT2_Type) GetCTRL_STOP_H() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x20000) >> 17
}
func (o *SCT2_Type) SetCTRL_HALT_H(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x40000)|value<<18)
}
func (o *SCT2_Type) GetCTRL_HALT_H() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x40000) >> 18
}
func (o *SCT2_Type) SetCTRL_CLRCTR_H(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x80000)|value<<19)
}
func (o *SCT2_Type) GetCTRL_CLRCTR_H() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x80000) >> 19
}
func (o *SCT2_Type) SetCTRL_BIDIR_H(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x100000)|value<<20)
}
func (o *SCT2_Type) GetCTRL_BIDIR_H() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x100000) >> 20
}
func (o *SCT2_Type) SetCTRL_PRE_H(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x1fe00000)|value<<21)
}
func (o *SCT2_Type) GetCTRL_PRE_H() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x1fe00000) >> 21
}
func (o *SCT2_Type) SetCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0xe0000000)|value<<29)
}
func (o *SCT2_Type) GetCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0xe0000000) >> 29
}

// SCT2.LIMIT: SCT limit register
func (o *SCT2_Type) SetLIMIT_LIMMSK_L(value uint32) {
	volatile.StoreUint32(&o.LIMIT.Reg, volatile.LoadUint32(&o.LIMIT.Reg)&^(0xffff)|value)
}
func (o *SCT2_Type) GetLIMIT_LIMMSK_L() uint32 {
	return volatile.LoadUint32(&o.LIMIT.Reg) & 0xffff
}
func (o *SCT2_Type) SetLIMIT_LIMMSK_H(value uint32) {
	volatile.StoreUint32(&o.LIMIT.Reg, volatile.LoadUint32(&o.LIMIT.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT2_Type) GetLIMIT_LIMMSK_H() uint32 {
	return (volatile.LoadUint32(&o.LIMIT.Reg) & 0xffff0000) >> 16
}

// SCT2.HALT: SCT halt condition register
func (o *SCT2_Type) SetHALT_HALTMSK_L(value uint32) {
	volatile.StoreUint32(&o.HALT.Reg, volatile.LoadUint32(&o.HALT.Reg)&^(0xffff)|value)
}
func (o *SCT2_Type) GetHALT_HALTMSK_L() uint32 {
	return volatile.LoadUint32(&o.HALT.Reg) & 0xffff
}
func (o *SCT2_Type) SetHALT_HALTMSK_H(value uint32) {
	volatile.StoreUint32(&o.HALT.Reg, volatile.LoadUint32(&o.HALT.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT2_Type) GetHALT_HALTMSK_H() uint32 {
	return (volatile.LoadUint32(&o.HALT.Reg) & 0xffff0000) >> 16
}

// SCT2.STOP: SCT stop condition register
func (o *SCT2_Type) SetSTOP_STOPMSK_L(value uint32) {
	volatile.StoreUint32(&o.STOP.Reg, volatile.LoadUint32(&o.STOP.Reg)&^(0xffff)|value)
}
func (o *SCT2_Type) GetSTOP_STOPMSK_L() uint32 {
	return volatile.LoadUint32(&o.STOP.Reg) & 0xffff
}
func (o *SCT2_Type) SetSTOP_STOPMSK_H(value uint32) {
	volatile.StoreUint32(&o.STOP.Reg, volatile.LoadUint32(&o.STOP.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT2_Type) GetSTOP_STOPMSK_H() uint32 {
	return (volatile.LoadUint32(&o.STOP.Reg) & 0xffff0000) >> 16
}

// SCT2.START: SCT start condition register
func (o *SCT2_Type) SetSTART_STARTMSK_L(value uint32) {
	volatile.StoreUint32(&o.START.Reg, volatile.LoadUint32(&o.START.Reg)&^(0xffff)|value)
}
func (o *SCT2_Type) GetSTART_STARTMSK_L() uint32 {
	return volatile.LoadUint32(&o.START.Reg) & 0xffff
}
func (o *SCT2_Type) SetSTART_STARTMSK_H(value uint32) {
	volatile.StoreUint32(&o.START.Reg, volatile.LoadUint32(&o.START.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT2_Type) GetSTART_STARTMSK_H() uint32 {
	return (volatile.LoadUint32(&o.START.Reg) & 0xffff0000) >> 16
}

// SCT2.COUNT: SCT counter register
func (o *SCT2_Type) SetCOUNT_CTR_L(value uint32) {
	volatile.StoreUint32(&o.COUNT.Reg, volatile.LoadUint32(&o.COUNT.Reg)&^(0xffff)|value)
}
func (o *SCT2_Type) GetCOUNT_CTR_L() uint32 {
	return volatile.LoadUint32(&o.COUNT.Reg) & 0xffff
}
func (o *SCT2_Type) SetCOUNT_CTR_H(value uint32) {
	volatile.StoreUint32(&o.COUNT.Reg, volatile.LoadUint32(&o.COUNT.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT2_Type) GetCOUNT_CTR_H() uint32 {
	return (volatile.LoadUint32(&o.COUNT.Reg) & 0xffff0000) >> 16
}

// SCT2.STATE: SCT state register
func (o *SCT2_Type) SetSTATE_STATE_L(value uint32) {
	volatile.StoreUint32(&o.STATE.Reg, volatile.LoadUint32(&o.STATE.Reg)&^(0x1f)|value)
}
func (o *SCT2_Type) GetSTATE_STATE_L() uint32 {
	return volatile.LoadUint32(&o.STATE.Reg) & 0x1f
}
func (o *SCT2_Type) SetSTATE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATE.Reg, volatile.LoadUint32(&o.STATE.Reg)&^(0xffe0)|value<<5)
}
func (o *SCT2_Type) GetSTATE_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATE.Reg) & 0xffe0) >> 5
}
func (o *SCT2_Type) SetSTATE_STATE_H(value uint32) {
	volatile.StoreUint32(&o.STATE.Reg, volatile.LoadUint32(&o.STATE.Reg)&^(0x1f0000)|value<<16)
}
func (o *SCT2_Type) GetSTATE_STATE_H() uint32 {
	return (volatile.LoadUint32(&o.STATE.Reg) & 0x1f0000) >> 16
}
func (o *SCT2_Type) SetSTATE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATE.Reg, volatile.LoadUint32(&o.STATE.Reg)&^(0xffe00000)|value<<21)
}
func (o *SCT2_Type) GetSTATE_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATE.Reg) & 0xffe00000) >> 21
}

// SCT2.INPUT: SCT input register
func (o *SCT2_Type) SetINPUT_AIN0(value uint32) {
	volatile.StoreUint32(&o.INPUT.Reg, volatile.LoadUint32(&o.INPUT.Reg)&^(0x1)|value)
}
func (o *SCT2_Type) GetINPUT_AIN0() uint32 {
	return volatile.LoadUint32(&o.INPUT.Reg) & 0x1
}
func (o *SCT2_Type) SetINPUT_AIN1(value uint32) {
	volatile.StoreUint32(&o.INPUT.Reg, volatile.LoadUint32(&o.INPUT.Reg)&^(0x2)|value<<1)
}
func (o *SCT2_Type) GetINPUT_AIN1() uint32 {
	return (volatile.LoadUint32(&o.INPUT.Reg) & 0x2) >> 1
}
func (o *SCT2_Type) SetINPUT_AIN2(value uint32) {
	volatile.StoreUint32(&o.INPUT.Reg, volatile.LoadUint32(&o.INPUT.Reg)&^(0x4)|value<<2)
}
func (o *SCT2_Type) GetINPUT_AIN2() uint32 {
	return (volatile.LoadUint32(&o.INPUT.Reg) & 0x4) >> 2
}
func (o *SCT2_Type) SetINPUT_AIN3(value uint32) {
	volatile.StoreUint32(&o.INPUT.Reg, volatile.LoadUint32(&o.INPUT.Reg)&^(0x8)|value<<3)
}
func (o *SCT2_Type) GetINPUT_AIN3() uint32 {
	return (volatile.LoadUint32(&o.INPUT.Reg) & 0x8) >> 3
}
func (o *SCT2_Type) SetINPUT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INPUT.Reg, volatile.LoadUint32(&o.INPUT.Reg)&^(0xfff0)|value<<4)
}
func (o *SCT2_Type) GetINPUT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INPUT.Reg) & 0xfff0) >> 4
}
func (o *SCT2_Type) SetINPUT_SIN0(value uint32) {
	volatile.StoreUint32(&o.INPUT.Reg, volatile.LoadUint32(&o.INPUT.Reg)&^(0x10000)|value<<16)
}
func (o *SCT2_Type) GetINPUT_SIN0() uint32 {
	return (volatile.LoadUint32(&o.INPUT.Reg) & 0x10000) >> 16
}
func (o *SCT2_Type) SetINPUT_SIN1(value uint32) {
	volatile.StoreUint32(&o.INPUT.Reg, volatile.LoadUint32(&o.INPUT.Reg)&^(0x20000)|value<<17)
}
func (o *SCT2_Type) GetINPUT_SIN1() uint32 {
	return (volatile.LoadUint32(&o.INPUT.Reg) & 0x20000) >> 17
}
func (o *SCT2_Type) SetINPUT_SIN2(value uint32) {
	volatile.StoreUint32(&o.INPUT.Reg, volatile.LoadUint32(&o.INPUT.Reg)&^(0x40000)|value<<18)
}
func (o *SCT2_Type) GetINPUT_SIN2() uint32 {
	return (volatile.LoadUint32(&o.INPUT.Reg) & 0x40000) >> 18
}
func (o *SCT2_Type) SetINPUT_SIN3(value uint32) {
	volatile.StoreUint32(&o.INPUT.Reg, volatile.LoadUint32(&o.INPUT.Reg)&^(0x80000)|value<<19)
}
func (o *SCT2_Type) GetINPUT_SIN3() uint32 {
	return (volatile.LoadUint32(&o.INPUT.Reg) & 0x80000) >> 19
}
func (o *SCT2_Type) SetINPUT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INPUT.Reg, volatile.LoadUint32(&o.INPUT.Reg)&^(0xfff00000)|value<<20)
}
func (o *SCT2_Type) GetINPUT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INPUT.Reg) & 0xfff00000) >> 20
}

// SCT2.REGMODE: SCT match/capture registers mode register
func (o *SCT2_Type) SetREGMODE_REGMOD_L(value uint32) {
	volatile.StoreUint32(&o.REGMODE.Reg, volatile.LoadUint32(&o.REGMODE.Reg)&^(0xffff)|value)
}
func (o *SCT2_Type) GetREGMODE_REGMOD_L() uint32 {
	return volatile.LoadUint32(&o.REGMODE.Reg) & 0xffff
}
func (o *SCT2_Type) SetREGMODE_REGMOD_H(value uint32) {
	volatile.StoreUint32(&o.REGMODE.Reg, volatile.LoadUint32(&o.REGMODE.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT2_Type) GetREGMODE_REGMOD_H() uint32 {
	return (volatile.LoadUint32(&o.REGMODE.Reg) & 0xffff0000) >> 16
}

// SCT2.OUTPUT: SCT output register
func (o *SCT2_Type) SetOUTPUT_OUT(value uint32) {
	volatile.StoreUint32(&o.OUTPUT.Reg, volatile.LoadUint32(&o.OUTPUT.Reg)&^(0x3f)|value)
}
func (o *SCT2_Type) GetOUTPUT_OUT() uint32 {
	return volatile.LoadUint32(&o.OUTPUT.Reg) & 0x3f
}
func (o *SCT2_Type) SetOUTPUT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.OUTPUT.Reg, volatile.LoadUint32(&o.OUTPUT.Reg)&^(0xffffffc0)|value<<6)
}
func (o *SCT2_Type) GetOUTPUT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.OUTPUT.Reg) & 0xffffffc0) >> 6
}

// SCT2.OUTPUTDIRCTRL: SCT output counter direction control register
func (o *SCT2_Type) SetOUTPUTDIRCTRL_SETCLR0(value uint32) {
	volatile.StoreUint32(&o.OUTPUTDIRCTRL.Reg, volatile.LoadUint32(&o.OUTPUTDIRCTRL.Reg)&^(0x3)|value)
}
func (o *SCT2_Type) GetOUTPUTDIRCTRL_SETCLR0() uint32 {
	return volatile.LoadUint32(&o.OUTPUTDIRCTRL.Reg) & 0x3
}
func (o *SCT2_Type) SetOUTPUTDIRCTRL_SETCLR1(value uint32) {
	volatile.StoreUint32(&o.OUTPUTDIRCTRL.Reg, volatile.LoadUint32(&o.OUTPUTDIRCTRL.Reg)&^(0xc)|value<<2)
}
func (o *SCT2_Type) GetOUTPUTDIRCTRL_SETCLR1() uint32 {
	return (volatile.LoadUint32(&o.OUTPUTDIRCTRL.Reg) & 0xc) >> 2
}
func (o *SCT2_Type) SetOUTPUTDIRCTRL_SETCLR2(value uint32) {
	volatile.StoreUint32(&o.OUTPUTDIRCTRL.Reg, volatile.LoadUint32(&o.OUTPUTDIRCTRL.Reg)&^(0x30)|value<<4)
}
func (o *SCT2_Type) GetOUTPUTDIRCTRL_SETCLR2() uint32 {
	return (volatile.LoadUint32(&o.OUTPUTDIRCTRL.Reg) & 0x30) >> 4
}
func (o *SCT2_Type) SetOUTPUTDIRCTRL_SETCLR3(value uint32) {
	volatile.StoreUint32(&o.OUTPUTDIRCTRL.Reg, volatile.LoadUint32(&o.OUTPUTDIRCTRL.Reg)&^(0xc0)|value<<6)
}
func (o *SCT2_Type) GetOUTPUTDIRCTRL_SETCLR3() uint32 {
	return (volatile.LoadUint32(&o.OUTPUTDIRCTRL.Reg) & 0xc0) >> 6
}
func (o *SCT2_Type) SetOUTPUTDIRCTRL_SETCLR4(value uint32) {
	volatile.StoreUint32(&o.OUTPUTDIRCTRL.Reg, volatile.LoadUint32(&o.OUTPUTDIRCTRL.Reg)&^(0x300)|value<<8)
}
func (o *SCT2_Type) GetOUTPUTDIRCTRL_SETCLR4() uint32 {
	return (volatile.LoadUint32(&o.OUTPUTDIRCTRL.Reg) & 0x300) >> 8
}
func (o *SCT2_Type) SetOUTPUTDIRCTRL_SETCLR5(value uint32) {
	volatile.StoreUint32(&o.OUTPUTDIRCTRL.Reg, volatile.LoadUint32(&o.OUTPUTDIRCTRL.Reg)&^(0xc00)|value<<10)
}
func (o *SCT2_Type) GetOUTPUTDIRCTRL_SETCLR5() uint32 {
	return (volatile.LoadUint32(&o.OUTPUTDIRCTRL.Reg) & 0xc00) >> 10
}
func (o *SCT2_Type) SetOUTPUTDIRCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.OUTPUTDIRCTRL.Reg, volatile.LoadUint32(&o.OUTPUTDIRCTRL.Reg)&^(0xfffff000)|value<<12)
}
func (o *SCT2_Type) GetOUTPUTDIRCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.OUTPUTDIRCTRL.Reg) & 0xfffff000) >> 12
}

// SCT2.RES: SCT conflict resolution register
func (o *SCT2_Type) SetRES_O0RES(value uint32) {
	volatile.StoreUint32(&o.RES.Reg, volatile.LoadUint32(&o.RES.Reg)&^(0x3)|value)
}
func (o *SCT2_Type) GetRES_O0RES() uint32 {
	return volatile.LoadUint32(&o.RES.Reg) & 0x3
}
func (o *SCT2_Type) SetRES_O1RES(value uint32) {
	volatile.StoreUint32(&o.RES.Reg, volatile.LoadUint32(&o.RES.Reg)&^(0xc)|value<<2)
}
func (o *SCT2_Type) GetRES_O1RES() uint32 {
	return (volatile.LoadUint32(&o.RES.Reg) & 0xc) >> 2
}
func (o *SCT2_Type) SetRES_O2RES(value uint32) {
	volatile.StoreUint32(&o.RES.Reg, volatile.LoadUint32(&o.RES.Reg)&^(0x30)|value<<4)
}
func (o *SCT2_Type) GetRES_O2RES() uint32 {
	return (volatile.LoadUint32(&o.RES.Reg) & 0x30) >> 4
}
func (o *SCT2_Type) SetRES_O3RES(value uint32) {
	volatile.StoreUint32(&o.RES.Reg, volatile.LoadUint32(&o.RES.Reg)&^(0xc0)|value<<6)
}
func (o *SCT2_Type) GetRES_O3RES() uint32 {
	return (volatile.LoadUint32(&o.RES.Reg) & 0xc0) >> 6
}
func (o *SCT2_Type) SetRES_O4RES(value uint32) {
	volatile.StoreUint32(&o.RES.Reg, volatile.LoadUint32(&o.RES.Reg)&^(0x300)|value<<8)
}
func (o *SCT2_Type) GetRES_O4RES() uint32 {
	return (volatile.LoadUint32(&o.RES.Reg) & 0x300) >> 8
}
func (o *SCT2_Type) SetRES_O5RES(value uint32) {
	volatile.StoreUint32(&o.RES.Reg, volatile.LoadUint32(&o.RES.Reg)&^(0xc00)|value<<10)
}
func (o *SCT2_Type) GetRES_O5RES() uint32 {
	return (volatile.LoadUint32(&o.RES.Reg) & 0xc00) >> 10
}
func (o *SCT2_Type) SetRES_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RES.Reg, volatile.LoadUint32(&o.RES.Reg)&^(0xfffff000)|value<<12)
}
func (o *SCT2_Type) GetRES_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.RES.Reg) & 0xfffff000) >> 12
}

// SCT2.DMAREQ0: SCT DMA request 0 register
func (o *SCT2_Type) SetDMAREQ0_DEV_0(value uint32) {
	volatile.StoreUint32(&o.DMAREQ0.Reg, volatile.LoadUint32(&o.DMAREQ0.Reg)&^(0xffff)|value)
}
func (o *SCT2_Type) GetDMAREQ0_DEV_0() uint32 {
	return volatile.LoadUint32(&o.DMAREQ0.Reg) & 0xffff
}
func (o *SCT2_Type) SetDMAREQ0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DMAREQ0.Reg, volatile.LoadUint32(&o.DMAREQ0.Reg)&^(0x3fff0000)|value<<16)
}
func (o *SCT2_Type) GetDMAREQ0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DMAREQ0.Reg) & 0x3fff0000) >> 16
}
func (o *SCT2_Type) SetDMAREQ0_DRL0(value uint32) {
	volatile.StoreUint32(&o.DMAREQ0.Reg, volatile.LoadUint32(&o.DMAREQ0.Reg)&^(0x40000000)|value<<30)
}
func (o *SCT2_Type) GetDMAREQ0_DRL0() uint32 {
	return (volatile.LoadUint32(&o.DMAREQ0.Reg) & 0x40000000) >> 30
}
func (o *SCT2_Type) SetDMAREQ0_DRQ0(value uint32) {
	volatile.StoreUint32(&o.DMAREQ0.Reg, volatile.LoadUint32(&o.DMAREQ0.Reg)&^(0x80000000)|value<<31)
}
func (o *SCT2_Type) GetDMAREQ0_DRQ0() uint32 {
	return (volatile.LoadUint32(&o.DMAREQ0.Reg) & 0x80000000) >> 31
}

// SCT2.DMAREQ1: SCT DMA request 1 register
func (o *SCT2_Type) SetDMAREQ1_DEV_1(value uint32) {
	volatile.StoreUint32(&o.DMAREQ1.Reg, volatile.LoadUint32(&o.DMAREQ1.Reg)&^(0xffff)|value)
}
func (o *SCT2_Type) GetDMAREQ1_DEV_1() uint32 {
	return volatile.LoadUint32(&o.DMAREQ1.Reg) & 0xffff
}
func (o *SCT2_Type) SetDMAREQ1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DMAREQ1.Reg, volatile.LoadUint32(&o.DMAREQ1.Reg)&^(0x3fff0000)|value<<16)
}
func (o *SCT2_Type) GetDMAREQ1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DMAREQ1.Reg) & 0x3fff0000) >> 16
}
func (o *SCT2_Type) SetDMAREQ1_DRL1(value uint32) {
	volatile.StoreUint32(&o.DMAREQ1.Reg, volatile.LoadUint32(&o.DMAREQ1.Reg)&^(0x40000000)|value<<30)
}
func (o *SCT2_Type) GetDMAREQ1_DRL1() uint32 {
	return (volatile.LoadUint32(&o.DMAREQ1.Reg) & 0x40000000) >> 30
}
func (o *SCT2_Type) SetDMAREQ1_DRQ1(value uint32) {
	volatile.StoreUint32(&o.DMAREQ1.Reg, volatile.LoadUint32(&o.DMAREQ1.Reg)&^(0x80000000)|value<<31)
}
func (o *SCT2_Type) GetDMAREQ1_DRQ1() uint32 {
	return (volatile.LoadUint32(&o.DMAREQ1.Reg) & 0x80000000) >> 31
}

// SCT2.EVEN: SCT event enable register
func (o *SCT2_Type) SetEVEN_IEN(value uint32) {
	volatile.StoreUint32(&o.EVEN.Reg, volatile.LoadUint32(&o.EVEN.Reg)&^(0xffff)|value)
}
func (o *SCT2_Type) GetEVEN_IEN() uint32 {
	return volatile.LoadUint32(&o.EVEN.Reg) & 0xffff
}
func (o *SCT2_Type) SetEVEN_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EVEN.Reg, volatile.LoadUint32(&o.EVEN.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT2_Type) GetEVEN_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EVEN.Reg) & 0xffff0000) >> 16
}

// SCT2.EVFLAG: SCT event flag register
func (o *SCT2_Type) SetEVFLAG_FLAG(value uint32) {
	volatile.StoreUint32(&o.EVFLAG.Reg, volatile.LoadUint32(&o.EVFLAG.Reg)&^(0xffff)|value)
}
func (o *SCT2_Type) GetEVFLAG_FLAG() uint32 {
	return volatile.LoadUint32(&o.EVFLAG.Reg) & 0xffff
}
func (o *SCT2_Type) SetEVFLAG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EVFLAG.Reg, volatile.LoadUint32(&o.EVFLAG.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT2_Type) GetEVFLAG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EVFLAG.Reg) & 0xffff0000) >> 16
}

// SCT2.CONEN: SCT conflict enable register
func (o *SCT2_Type) SetCONEN_NCEN(value uint32) {
	volatile.StoreUint32(&o.CONEN.Reg, volatile.LoadUint32(&o.CONEN.Reg)&^(0xffff)|value)
}
func (o *SCT2_Type) GetCONEN_NCEN() uint32 {
	return volatile.LoadUint32(&o.CONEN.Reg) & 0xffff
}
func (o *SCT2_Type) SetCONEN_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CONEN.Reg, volatile.LoadUint32(&o.CONEN.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT2_Type) GetCONEN_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CONEN.Reg) & 0xffff0000) >> 16
}

// SCT2.CONFLAG: SCT conflict flag register
func (o *SCT2_Type) SetCONFLAG_NCFLAG(value uint32) {
	volatile.StoreUint32(&o.CONFLAG.Reg, volatile.LoadUint32(&o.CONFLAG.Reg)&^(0x3f)|value)
}
func (o *SCT2_Type) GetCONFLAG_NCFLAG() uint32 {
	return volatile.LoadUint32(&o.CONFLAG.Reg) & 0x3f
}
func (o *SCT2_Type) SetCONFLAG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CONFLAG.Reg, volatile.LoadUint32(&o.CONFLAG.Reg)&^(0x3fffffc0)|value<<6)
}
func (o *SCT2_Type) GetCONFLAG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CONFLAG.Reg) & 0x3fffffc0) >> 6
}
func (o *SCT2_Type) SetCONFLAG_BUSERRL(value uint32) {
	volatile.StoreUint32(&o.CONFLAG.Reg, volatile.LoadUint32(&o.CONFLAG.Reg)&^(0x40000000)|value<<30)
}
func (o *SCT2_Type) GetCONFLAG_BUSERRL() uint32 {
	return (volatile.LoadUint32(&o.CONFLAG.Reg) & 0x40000000) >> 30
}
func (o *SCT2_Type) SetCONFLAG_BUSERRH(value uint32) {
	volatile.StoreUint32(&o.CONFLAG.Reg, volatile.LoadUint32(&o.CONFLAG.Reg)&^(0x80000000)|value<<31)
}
func (o *SCT2_Type) GetCONFLAG_BUSERRH() uint32 {
	return (volatile.LoadUint32(&o.CONFLAG.Reg) & 0x80000000) >> 31
}

// SCT2.MATCH0: SCT match value register of match channels 0 to 7; REGMOD0 to REGMODE7 = 0
func (o *SCT2_Type) SetMATCH0_MATCHn_L(value uint32) {
	volatile.StoreUint32(&o.MATCH0.Reg, volatile.LoadUint32(&o.MATCH0.Reg)&^(0xffff)|value)
}
func (o *SCT2_Type) GetMATCH0_MATCHn_L() uint32 {
	return volatile.LoadUint32(&o.MATCH0.Reg) & 0xffff
}
func (o *SCT2_Type) SetMATCH0_MATCHn_H(value uint32) {
	volatile.StoreUint32(&o.MATCH0.Reg, volatile.LoadUint32(&o.MATCH0.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT2_Type) GetMATCH0_MATCHn_H() uint32 {
	return (volatile.LoadUint32(&o.MATCH0.Reg) & 0xffff0000) >> 16
}

// SCT2.MATCH1: SCT match value register of match channels 0 to 7; REGMOD0 to REGMODE7 = 0
func (o *SCT2_Type) SetMATCH1_MATCHn_L(value uint32) {
	volatile.StoreUint32(&o.MATCH1.Reg, volatile.LoadUint32(&o.MATCH1.Reg)&^(0xffff)|value)
}
func (o *SCT2_Type) GetMATCH1_MATCHn_L() uint32 {
	return volatile.LoadUint32(&o.MATCH1.Reg) & 0xffff
}
func (o *SCT2_Type) SetMATCH1_MATCHn_H(value uint32) {
	volatile.StoreUint32(&o.MATCH1.Reg, volatile.LoadUint32(&o.MATCH1.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT2_Type) GetMATCH1_MATCHn_H() uint32 {
	return (volatile.LoadUint32(&o.MATCH1.Reg) & 0xffff0000) >> 16
}

// SCT2.MATCH2: SCT match value register of match channels 0 to 7; REGMOD0 to REGMODE7 = 0
func (o *SCT2_Type) SetMATCH2_MATCHn_L(value uint32) {
	volatile.StoreUint32(&o.MATCH2.Reg, volatile.LoadUint32(&o.MATCH2.Reg)&^(0xffff)|value)
}
func (o *SCT2_Type) GetMATCH2_MATCHn_L() uint32 {
	return volatile.LoadUint32(&o.MATCH2.Reg) & 0xffff
}
func (o *SCT2_Type) SetMATCH2_MATCHn_H(value uint32) {
	volatile.StoreUint32(&o.MATCH2.Reg, volatile.LoadUint32(&o.MATCH2.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT2_Type) GetMATCH2_MATCHn_H() uint32 {
	return (volatile.LoadUint32(&o.MATCH2.Reg) & 0xffff0000) >> 16
}

// SCT2.MATCH3: SCT match value register of match channels 0 to 7; REGMOD0 to REGMODE7 = 0
func (o *SCT2_Type) SetMATCH3_MATCHn_L(value uint32) {
	volatile.StoreUint32(&o.MATCH3.Reg, volatile.LoadUint32(&o.MATCH3.Reg)&^(0xffff)|value)
}
func (o *SCT2_Type) GetMATCH3_MATCHn_L() uint32 {
	return volatile.LoadUint32(&o.MATCH3.Reg) & 0xffff
}
func (o *SCT2_Type) SetMATCH3_MATCHn_H(value uint32) {
	volatile.StoreUint32(&o.MATCH3.Reg, volatile.LoadUint32(&o.MATCH3.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT2_Type) GetMATCH3_MATCHn_H() uint32 {
	return (volatile.LoadUint32(&o.MATCH3.Reg) & 0xffff0000) >> 16
}

// SCT2.MATCH4: SCT match value register of match channels 0 to 7; REGMOD0 to REGMODE7 = 0
func (o *SCT2_Type) SetMATCH4_MATCHn_L(value uint32) {
	volatile.StoreUint32(&o.MATCH4.Reg, volatile.LoadUint32(&o.MATCH4.Reg)&^(0xffff)|value)
}
func (o *SCT2_Type) GetMATCH4_MATCHn_L() uint32 {
	return volatile.LoadUint32(&o.MATCH4.Reg) & 0xffff
}
func (o *SCT2_Type) SetMATCH4_MATCHn_H(value uint32) {
	volatile.StoreUint32(&o.MATCH4.Reg, volatile.LoadUint32(&o.MATCH4.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT2_Type) GetMATCH4_MATCHn_H() uint32 {
	return (volatile.LoadUint32(&o.MATCH4.Reg) & 0xffff0000) >> 16
}

// SCT2.MATCH5: SCT match value register of match channels 0 to 7; REGMOD0 to REGMODE7 = 0
func (o *SCT2_Type) SetMATCH5_MATCHn_L(value uint32) {
	volatile.StoreUint32(&o.MATCH5.Reg, volatile.LoadUint32(&o.MATCH5.Reg)&^(0xffff)|value)
}
func (o *SCT2_Type) GetMATCH5_MATCHn_L() uint32 {
	return volatile.LoadUint32(&o.MATCH5.Reg) & 0xffff
}
func (o *SCT2_Type) SetMATCH5_MATCHn_H(value uint32) {
	volatile.StoreUint32(&o.MATCH5.Reg, volatile.LoadUint32(&o.MATCH5.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT2_Type) GetMATCH5_MATCHn_H() uint32 {
	return (volatile.LoadUint32(&o.MATCH5.Reg) & 0xffff0000) >> 16
}

// SCT2.MATCH6: SCT match value register of match channels 0 to 7; REGMOD0 to REGMODE7 = 0
func (o *SCT2_Type) SetMATCH6_MATCHn_L(value uint32) {
	volatile.StoreUint32(&o.MATCH6.Reg, volatile.LoadUint32(&o.MATCH6.Reg)&^(0xffff)|value)
}
func (o *SCT2_Type) GetMATCH6_MATCHn_L() uint32 {
	return volatile.LoadUint32(&o.MATCH6.Reg) & 0xffff
}
func (o *SCT2_Type) SetMATCH6_MATCHn_H(value uint32) {
	volatile.StoreUint32(&o.MATCH6.Reg, volatile.LoadUint32(&o.MATCH6.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT2_Type) GetMATCH6_MATCHn_H() uint32 {
	return (volatile.LoadUint32(&o.MATCH6.Reg) & 0xffff0000) >> 16
}

// SCT2.MATCH7: SCT match value register of match channels 0 to 7; REGMOD0 to REGMODE7 = 0
func (o *SCT2_Type) SetMATCH7_MATCHn_L(value uint32) {
	volatile.StoreUint32(&o.MATCH7.Reg, volatile.LoadUint32(&o.MATCH7.Reg)&^(0xffff)|value)
}
func (o *SCT2_Type) GetMATCH7_MATCHn_L() uint32 {
	return volatile.LoadUint32(&o.MATCH7.Reg) & 0xffff
}
func (o *SCT2_Type) SetMATCH7_MATCHn_H(value uint32) {
	volatile.StoreUint32(&o.MATCH7.Reg, volatile.LoadUint32(&o.MATCH7.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT2_Type) GetMATCH7_MATCHn_H() uint32 {
	return (volatile.LoadUint32(&o.MATCH7.Reg) & 0xffff0000) >> 16
}

// SCT2.MATCHREL0: SCT match reload value register 0 to 7; REGMOD0 = 0 to REGMODE7 = 0
func (o *SCT2_Type) SetMATCHREL0_RELOADn_L(value uint32) {
	volatile.StoreUint32(&o.MATCHREL0.Reg, volatile.LoadUint32(&o.MATCHREL0.Reg)&^(0xffff)|value)
}
func (o *SCT2_Type) GetMATCHREL0_RELOADn_L() uint32 {
	return volatile.LoadUint32(&o.MATCHREL0.Reg) & 0xffff
}
func (o *SCT2_Type) SetMATCHREL0_RELOADn_H(value uint32) {
	volatile.StoreUint32(&o.MATCHREL0.Reg, volatile.LoadUint32(&o.MATCHREL0.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT2_Type) GetMATCHREL0_RELOADn_H() uint32 {
	return (volatile.LoadUint32(&o.MATCHREL0.Reg) & 0xffff0000) >> 16
}

// SCT2.MATCHREL1: SCT match reload value register 0 to 7; REGMOD0 = 0 to REGMODE7 = 0
func (o *SCT2_Type) SetMATCHREL1_RELOADn_L(value uint32) {
	volatile.StoreUint32(&o.MATCHREL1.Reg, volatile.LoadUint32(&o.MATCHREL1.Reg)&^(0xffff)|value)
}
func (o *SCT2_Type) GetMATCHREL1_RELOADn_L() uint32 {
	return volatile.LoadUint32(&o.MATCHREL1.Reg) & 0xffff
}
func (o *SCT2_Type) SetMATCHREL1_RELOADn_H(value uint32) {
	volatile.StoreUint32(&o.MATCHREL1.Reg, volatile.LoadUint32(&o.MATCHREL1.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT2_Type) GetMATCHREL1_RELOADn_H() uint32 {
	return (volatile.LoadUint32(&o.MATCHREL1.Reg) & 0xffff0000) >> 16
}

// SCT2.MATCHREL2: SCT match reload value register 0 to 7; REGMOD0 = 0 to REGMODE7 = 0
func (o *SCT2_Type) SetMATCHREL2_RELOADn_L(value uint32) {
	volatile.StoreUint32(&o.MATCHREL2.Reg, volatile.LoadUint32(&o.MATCHREL2.Reg)&^(0xffff)|value)
}
func (o *SCT2_Type) GetMATCHREL2_RELOADn_L() uint32 {
	return volatile.LoadUint32(&o.MATCHREL2.Reg) & 0xffff
}
func (o *SCT2_Type) SetMATCHREL2_RELOADn_H(value uint32) {
	volatile.StoreUint32(&o.MATCHREL2.Reg, volatile.LoadUint32(&o.MATCHREL2.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT2_Type) GetMATCHREL2_RELOADn_H() uint32 {
	return (volatile.LoadUint32(&o.MATCHREL2.Reg) & 0xffff0000) >> 16
}

// SCT2.MATCHREL3: SCT match reload value register 0 to 7; REGMOD0 = 0 to REGMODE7 = 0
func (o *SCT2_Type) SetMATCHREL3_RELOADn_L(value uint32) {
	volatile.StoreUint32(&o.MATCHREL3.Reg, volatile.LoadUint32(&o.MATCHREL3.Reg)&^(0xffff)|value)
}
func (o *SCT2_Type) GetMATCHREL3_RELOADn_L() uint32 {
	return volatile.LoadUint32(&o.MATCHREL3.Reg) & 0xffff
}
func (o *SCT2_Type) SetMATCHREL3_RELOADn_H(value uint32) {
	volatile.StoreUint32(&o.MATCHREL3.Reg, volatile.LoadUint32(&o.MATCHREL3.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT2_Type) GetMATCHREL3_RELOADn_H() uint32 {
	return (volatile.LoadUint32(&o.MATCHREL3.Reg) & 0xffff0000) >> 16
}

// SCT2.MATCHREL4: SCT match reload value register 0 to 7; REGMOD0 = 0 to REGMODE7 = 0
func (o *SCT2_Type) SetMATCHREL4_RELOADn_L(value uint32) {
	volatile.StoreUint32(&o.MATCHREL4.Reg, volatile.LoadUint32(&o.MATCHREL4.Reg)&^(0xffff)|value)
}
func (o *SCT2_Type) GetMATCHREL4_RELOADn_L() uint32 {
	return volatile.LoadUint32(&o.MATCHREL4.Reg) & 0xffff
}
func (o *SCT2_Type) SetMATCHREL4_RELOADn_H(value uint32) {
	volatile.StoreUint32(&o.MATCHREL4.Reg, volatile.LoadUint32(&o.MATCHREL4.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT2_Type) GetMATCHREL4_RELOADn_H() uint32 {
	return (volatile.LoadUint32(&o.MATCHREL4.Reg) & 0xffff0000) >> 16
}

// SCT2.MATCHREL5: SCT match reload value register 0 to 7; REGMOD0 = 0 to REGMODE7 = 0
func (o *SCT2_Type) SetMATCHREL5_RELOADn_L(value uint32) {
	volatile.StoreUint32(&o.MATCHREL5.Reg, volatile.LoadUint32(&o.MATCHREL5.Reg)&^(0xffff)|value)
}
func (o *SCT2_Type) GetMATCHREL5_RELOADn_L() uint32 {
	return volatile.LoadUint32(&o.MATCHREL5.Reg) & 0xffff
}
func (o *SCT2_Type) SetMATCHREL5_RELOADn_H(value uint32) {
	volatile.StoreUint32(&o.MATCHREL5.Reg, volatile.LoadUint32(&o.MATCHREL5.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT2_Type) GetMATCHREL5_RELOADn_H() uint32 {
	return (volatile.LoadUint32(&o.MATCHREL5.Reg) & 0xffff0000) >> 16
}

// SCT2.MATCHREL6: SCT match reload value register 0 to 7; REGMOD0 = 0 to REGMODE7 = 0
func (o *SCT2_Type) SetMATCHREL6_RELOADn_L(value uint32) {
	volatile.StoreUint32(&o.MATCHREL6.Reg, volatile.LoadUint32(&o.MATCHREL6.Reg)&^(0xffff)|value)
}
func (o *SCT2_Type) GetMATCHREL6_RELOADn_L() uint32 {
	return volatile.LoadUint32(&o.MATCHREL6.Reg) & 0xffff
}
func (o *SCT2_Type) SetMATCHREL6_RELOADn_H(value uint32) {
	volatile.StoreUint32(&o.MATCHREL6.Reg, volatile.LoadUint32(&o.MATCHREL6.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT2_Type) GetMATCHREL6_RELOADn_H() uint32 {
	return (volatile.LoadUint32(&o.MATCHREL6.Reg) & 0xffff0000) >> 16
}

// SCT2.MATCHREL7: SCT match reload value register 0 to 7; REGMOD0 = 0 to REGMODE7 = 0
func (o *SCT2_Type) SetMATCHREL7_RELOADn_L(value uint32) {
	volatile.StoreUint32(&o.MATCHREL7.Reg, volatile.LoadUint32(&o.MATCHREL7.Reg)&^(0xffff)|value)
}
func (o *SCT2_Type) GetMATCHREL7_RELOADn_L() uint32 {
	return volatile.LoadUint32(&o.MATCHREL7.Reg) & 0xffff
}
func (o *SCT2_Type) SetMATCHREL7_RELOADn_H(value uint32) {
	volatile.StoreUint32(&o.MATCHREL7.Reg, volatile.LoadUint32(&o.MATCHREL7.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT2_Type) GetMATCHREL7_RELOADn_H() uint32 {
	return (volatile.LoadUint32(&o.MATCHREL7.Reg) & 0xffff0000) >> 16
}

// SCT2.EV0_STATE: SCT event state register 0
func (o *SCT2_Type) SetEV0_STATE_STATEMSKn(value uint32) {
	volatile.StoreUint32(&o.EV0_STATE.Reg, volatile.LoadUint32(&o.EV0_STATE.Reg)&^(0x3ff)|value)
}
func (o *SCT2_Type) GetEV0_STATE_STATEMSKn() uint32 {
	return volatile.LoadUint32(&o.EV0_STATE.Reg) & 0x3ff
}
func (o *SCT2_Type) SetEV0_STATE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EV0_STATE.Reg, volatile.LoadUint32(&o.EV0_STATE.Reg)&^(0xfffffc00)|value<<10)
}
func (o *SCT2_Type) GetEV0_STATE_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EV0_STATE.Reg) & 0xfffffc00) >> 10
}

// SCT2.EV0_CTRL: SCT event control register 0
func (o *SCT2_Type) SetEV0_CTRL_MATCHSEL(value uint32) {
	volatile.StoreUint32(&o.EV0_CTRL.Reg, volatile.LoadUint32(&o.EV0_CTRL.Reg)&^(0xf)|value)
}
func (o *SCT2_Type) GetEV0_CTRL_MATCHSEL() uint32 {
	return volatile.LoadUint32(&o.EV0_CTRL.Reg) & 0xf
}
func (o *SCT2_Type) SetEV0_CTRL_HEVENT(value uint32) {
	volatile.StoreUint32(&o.EV0_CTRL.Reg, volatile.LoadUint32(&o.EV0_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *SCT2_Type) GetEV0_CTRL_HEVENT() uint32 {
	return (volatile.LoadUint32(&o.EV0_CTRL.Reg) & 0x10) >> 4
}
func (o *SCT2_Type) SetEV0_CTRL_OUTSEL(value uint32) {
	volatile.StoreUint32(&o.EV0_CTRL.Reg, volatile.LoadUint32(&o.EV0_CTRL.Reg)&^(0x20)|value<<5)
}
func (o *SCT2_Type) GetEV0_CTRL_OUTSEL() uint32 {
	return (volatile.LoadUint32(&o.EV0_CTRL.Reg) & 0x20) >> 5
}
func (o *SCT2_Type) SetEV0_CTRL_IOSEL(value uint32) {
	volatile.StoreUint32(&o.EV0_CTRL.Reg, volatile.LoadUint32(&o.EV0_CTRL.Reg)&^(0x3c0)|value<<6)
}
func (o *SCT2_Type) GetEV0_CTRL_IOSEL() uint32 {
	return (volatile.LoadUint32(&o.EV0_CTRL.Reg) & 0x3c0) >> 6
}
func (o *SCT2_Type) SetEV0_CTRL_IOCOND(value uint32) {
	volatile.StoreUint32(&o.EV0_CTRL.Reg, volatile.LoadUint32(&o.EV0_CTRL.Reg)&^(0xc00)|value<<10)
}
func (o *SCT2_Type) GetEV0_CTRL_IOCOND() uint32 {
	return (volatile.LoadUint32(&o.EV0_CTRL.Reg) & 0xc00) >> 10
}
func (o *SCT2_Type) SetEV0_CTRL_COMBMODE(value uint32) {
	volatile.StoreUint32(&o.EV0_CTRL.Reg, volatile.LoadUint32(&o.EV0_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *SCT2_Type) GetEV0_CTRL_COMBMODE() uint32 {
	return (volatile.LoadUint32(&o.EV0_CTRL.Reg) & 0x3000) >> 12
}
func (o *SCT2_Type) SetEV0_CTRL_STATELD(value uint32) {
	volatile.StoreUint32(&o.EV0_CTRL.Reg, volatile.LoadUint32(&o.EV0_CTRL.Reg)&^(0x4000)|value<<14)
}
func (o *SCT2_Type) GetEV0_CTRL_STATELD() uint32 {
	return (volatile.LoadUint32(&o.EV0_CTRL.Reg) & 0x4000) >> 14
}
func (o *SCT2_Type) SetEV0_CTRL_STATEV(value uint32) {
	volatile.StoreUint32(&o.EV0_CTRL.Reg, volatile.LoadUint32(&o.EV0_CTRL.Reg)&^(0xf8000)|value<<15)
}
func (o *SCT2_Type) GetEV0_CTRL_STATEV() uint32 {
	return (volatile.LoadUint32(&o.EV0_CTRL.Reg) & 0xf8000) >> 15
}
func (o *SCT2_Type) SetEV0_CTRL_MATCHMEM(value uint32) {
	volatile.StoreUint32(&o.EV0_CTRL.Reg, volatile.LoadUint32(&o.EV0_CTRL.Reg)&^(0x100000)|value<<20)
}
func (o *SCT2_Type) GetEV0_CTRL_MATCHMEM() uint32 {
	return (volatile.LoadUint32(&o.EV0_CTRL.Reg) & 0x100000) >> 20
}
func (o *SCT2_Type) SetEV0_CTRL_DIRECTION(value uint32) {
	volatile.StoreUint32(&o.EV0_CTRL.Reg, volatile.LoadUint32(&o.EV0_CTRL.Reg)&^(0x600000)|value<<21)
}
func (o *SCT2_Type) GetEV0_CTRL_DIRECTION() uint32 {
	return (volatile.LoadUint32(&o.EV0_CTRL.Reg) & 0x600000) >> 21
}
func (o *SCT2_Type) SetEV0_CTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EV0_CTRL.Reg, volatile.LoadUint32(&o.EV0_CTRL.Reg)&^(0xff800000)|value<<23)
}
func (o *SCT2_Type) GetEV0_CTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EV0_CTRL.Reg) & 0xff800000) >> 23
}

// SCT2.EV1_STATE: SCT event state register 0
func (o *SCT2_Type) SetEV1_STATE_STATEMSKn(value uint32) {
	volatile.StoreUint32(&o.EV1_STATE.Reg, volatile.LoadUint32(&o.EV1_STATE.Reg)&^(0x3ff)|value)
}
func (o *SCT2_Type) GetEV1_STATE_STATEMSKn() uint32 {
	return volatile.LoadUint32(&o.EV1_STATE.Reg) & 0x3ff
}
func (o *SCT2_Type) SetEV1_STATE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EV1_STATE.Reg, volatile.LoadUint32(&o.EV1_STATE.Reg)&^(0xfffffc00)|value<<10)
}
func (o *SCT2_Type) GetEV1_STATE_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EV1_STATE.Reg) & 0xfffffc00) >> 10
}

// SCT2.EV1_CTRL: SCT event control register 0
func (o *SCT2_Type) SetEV1_CTRL_MATCHSEL(value uint32) {
	volatile.StoreUint32(&o.EV1_CTRL.Reg, volatile.LoadUint32(&o.EV1_CTRL.Reg)&^(0xf)|value)
}
func (o *SCT2_Type) GetEV1_CTRL_MATCHSEL() uint32 {
	return volatile.LoadUint32(&o.EV1_CTRL.Reg) & 0xf
}
func (o *SCT2_Type) SetEV1_CTRL_HEVENT(value uint32) {
	volatile.StoreUint32(&o.EV1_CTRL.Reg, volatile.LoadUint32(&o.EV1_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *SCT2_Type) GetEV1_CTRL_HEVENT() uint32 {
	return (volatile.LoadUint32(&o.EV1_CTRL.Reg) & 0x10) >> 4
}
func (o *SCT2_Type) SetEV1_CTRL_OUTSEL(value uint32) {
	volatile.StoreUint32(&o.EV1_CTRL.Reg, volatile.LoadUint32(&o.EV1_CTRL.Reg)&^(0x20)|value<<5)
}
func (o *SCT2_Type) GetEV1_CTRL_OUTSEL() uint32 {
	return (volatile.LoadUint32(&o.EV1_CTRL.Reg) & 0x20) >> 5
}
func (o *SCT2_Type) SetEV1_CTRL_IOSEL(value uint32) {
	volatile.StoreUint32(&o.EV1_CTRL.Reg, volatile.LoadUint32(&o.EV1_CTRL.Reg)&^(0x3c0)|value<<6)
}
func (o *SCT2_Type) GetEV1_CTRL_IOSEL() uint32 {
	return (volatile.LoadUint32(&o.EV1_CTRL.Reg) & 0x3c0) >> 6
}
func (o *SCT2_Type) SetEV1_CTRL_IOCOND(value uint32) {
	volatile.StoreUint32(&o.EV1_CTRL.Reg, volatile.LoadUint32(&o.EV1_CTRL.Reg)&^(0xc00)|value<<10)
}
func (o *SCT2_Type) GetEV1_CTRL_IOCOND() uint32 {
	return (volatile.LoadUint32(&o.EV1_CTRL.Reg) & 0xc00) >> 10
}
func (o *SCT2_Type) SetEV1_CTRL_COMBMODE(value uint32) {
	volatile.StoreUint32(&o.EV1_CTRL.Reg, volatile.LoadUint32(&o.EV1_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *SCT2_Type) GetEV1_CTRL_COMBMODE() uint32 {
	return (volatile.LoadUint32(&o.EV1_CTRL.Reg) & 0x3000) >> 12
}
func (o *SCT2_Type) SetEV1_CTRL_STATELD(value uint32) {
	volatile.StoreUint32(&o.EV1_CTRL.Reg, volatile.LoadUint32(&o.EV1_CTRL.Reg)&^(0x4000)|value<<14)
}
func (o *SCT2_Type) GetEV1_CTRL_STATELD() uint32 {
	return (volatile.LoadUint32(&o.EV1_CTRL.Reg) & 0x4000) >> 14
}
func (o *SCT2_Type) SetEV1_CTRL_STATEV(value uint32) {
	volatile.StoreUint32(&o.EV1_CTRL.Reg, volatile.LoadUint32(&o.EV1_CTRL.Reg)&^(0xf8000)|value<<15)
}
func (o *SCT2_Type) GetEV1_CTRL_STATEV() uint32 {
	return (volatile.LoadUint32(&o.EV1_CTRL.Reg) & 0xf8000) >> 15
}
func (o *SCT2_Type) SetEV1_CTRL_MATCHMEM(value uint32) {
	volatile.StoreUint32(&o.EV1_CTRL.Reg, volatile.LoadUint32(&o.EV1_CTRL.Reg)&^(0x100000)|value<<20)
}
func (o *SCT2_Type) GetEV1_CTRL_MATCHMEM() uint32 {
	return (volatile.LoadUint32(&o.EV1_CTRL.Reg) & 0x100000) >> 20
}
func (o *SCT2_Type) SetEV1_CTRL_DIRECTION(value uint32) {
	volatile.StoreUint32(&o.EV1_CTRL.Reg, volatile.LoadUint32(&o.EV1_CTRL.Reg)&^(0x600000)|value<<21)
}
func (o *SCT2_Type) GetEV1_CTRL_DIRECTION() uint32 {
	return (volatile.LoadUint32(&o.EV1_CTRL.Reg) & 0x600000) >> 21
}
func (o *SCT2_Type) SetEV1_CTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EV1_CTRL.Reg, volatile.LoadUint32(&o.EV1_CTRL.Reg)&^(0xff800000)|value<<23)
}
func (o *SCT2_Type) GetEV1_CTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EV1_CTRL.Reg) & 0xff800000) >> 23
}

// SCT2.EV2_STATE: SCT event state register 0
func (o *SCT2_Type) SetEV2_STATE_STATEMSKn(value uint32) {
	volatile.StoreUint32(&o.EV2_STATE.Reg, volatile.LoadUint32(&o.EV2_STATE.Reg)&^(0x3ff)|value)
}
func (o *SCT2_Type) GetEV2_STATE_STATEMSKn() uint32 {
	return volatile.LoadUint32(&o.EV2_STATE.Reg) & 0x3ff
}
func (o *SCT2_Type) SetEV2_STATE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EV2_STATE.Reg, volatile.LoadUint32(&o.EV2_STATE.Reg)&^(0xfffffc00)|value<<10)
}
func (o *SCT2_Type) GetEV2_STATE_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EV2_STATE.Reg) & 0xfffffc00) >> 10
}

// SCT2.EV2_CTRL: SCT event control register 0
func (o *SCT2_Type) SetEV2_CTRL_MATCHSEL(value uint32) {
	volatile.StoreUint32(&o.EV2_CTRL.Reg, volatile.LoadUint32(&o.EV2_CTRL.Reg)&^(0xf)|value)
}
func (o *SCT2_Type) GetEV2_CTRL_MATCHSEL() uint32 {
	return volatile.LoadUint32(&o.EV2_CTRL.Reg) & 0xf
}
func (o *SCT2_Type) SetEV2_CTRL_HEVENT(value uint32) {
	volatile.StoreUint32(&o.EV2_CTRL.Reg, volatile.LoadUint32(&o.EV2_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *SCT2_Type) GetEV2_CTRL_HEVENT() uint32 {
	return (volatile.LoadUint32(&o.EV2_CTRL.Reg) & 0x10) >> 4
}
func (o *SCT2_Type) SetEV2_CTRL_OUTSEL(value uint32) {
	volatile.StoreUint32(&o.EV2_CTRL.Reg, volatile.LoadUint32(&o.EV2_CTRL.Reg)&^(0x20)|value<<5)
}
func (o *SCT2_Type) GetEV2_CTRL_OUTSEL() uint32 {
	return (volatile.LoadUint32(&o.EV2_CTRL.Reg) & 0x20) >> 5
}
func (o *SCT2_Type) SetEV2_CTRL_IOSEL(value uint32) {
	volatile.StoreUint32(&o.EV2_CTRL.Reg, volatile.LoadUint32(&o.EV2_CTRL.Reg)&^(0x3c0)|value<<6)
}
func (o *SCT2_Type) GetEV2_CTRL_IOSEL() uint32 {
	return (volatile.LoadUint32(&o.EV2_CTRL.Reg) & 0x3c0) >> 6
}
func (o *SCT2_Type) SetEV2_CTRL_IOCOND(value uint32) {
	volatile.StoreUint32(&o.EV2_CTRL.Reg, volatile.LoadUint32(&o.EV2_CTRL.Reg)&^(0xc00)|value<<10)
}
func (o *SCT2_Type) GetEV2_CTRL_IOCOND() uint32 {
	return (volatile.LoadUint32(&o.EV2_CTRL.Reg) & 0xc00) >> 10
}
func (o *SCT2_Type) SetEV2_CTRL_COMBMODE(value uint32) {
	volatile.StoreUint32(&o.EV2_CTRL.Reg, volatile.LoadUint32(&o.EV2_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *SCT2_Type) GetEV2_CTRL_COMBMODE() uint32 {
	return (volatile.LoadUint32(&o.EV2_CTRL.Reg) & 0x3000) >> 12
}
func (o *SCT2_Type) SetEV2_CTRL_STATELD(value uint32) {
	volatile.StoreUint32(&o.EV2_CTRL.Reg, volatile.LoadUint32(&o.EV2_CTRL.Reg)&^(0x4000)|value<<14)
}
func (o *SCT2_Type) GetEV2_CTRL_STATELD() uint32 {
	return (volatile.LoadUint32(&o.EV2_CTRL.Reg) & 0x4000) >> 14
}
func (o *SCT2_Type) SetEV2_CTRL_STATEV(value uint32) {
	volatile.StoreUint32(&o.EV2_CTRL.Reg, volatile.LoadUint32(&o.EV2_CTRL.Reg)&^(0xf8000)|value<<15)
}
func (o *SCT2_Type) GetEV2_CTRL_STATEV() uint32 {
	return (volatile.LoadUint32(&o.EV2_CTRL.Reg) & 0xf8000) >> 15
}
func (o *SCT2_Type) SetEV2_CTRL_MATCHMEM(value uint32) {
	volatile.StoreUint32(&o.EV2_CTRL.Reg, volatile.LoadUint32(&o.EV2_CTRL.Reg)&^(0x100000)|value<<20)
}
func (o *SCT2_Type) GetEV2_CTRL_MATCHMEM() uint32 {
	return (volatile.LoadUint32(&o.EV2_CTRL.Reg) & 0x100000) >> 20
}
func (o *SCT2_Type) SetEV2_CTRL_DIRECTION(value uint32) {
	volatile.StoreUint32(&o.EV2_CTRL.Reg, volatile.LoadUint32(&o.EV2_CTRL.Reg)&^(0x600000)|value<<21)
}
func (o *SCT2_Type) GetEV2_CTRL_DIRECTION() uint32 {
	return (volatile.LoadUint32(&o.EV2_CTRL.Reg) & 0x600000) >> 21
}
func (o *SCT2_Type) SetEV2_CTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EV2_CTRL.Reg, volatile.LoadUint32(&o.EV2_CTRL.Reg)&^(0xff800000)|value<<23)
}
func (o *SCT2_Type) GetEV2_CTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EV2_CTRL.Reg) & 0xff800000) >> 23
}

// SCT2.EV3_STATE: SCT event state register 0
func (o *SCT2_Type) SetEV3_STATE_STATEMSKn(value uint32) {
	volatile.StoreUint32(&o.EV3_STATE.Reg, volatile.LoadUint32(&o.EV3_STATE.Reg)&^(0x3ff)|value)
}
func (o *SCT2_Type) GetEV3_STATE_STATEMSKn() uint32 {
	return volatile.LoadUint32(&o.EV3_STATE.Reg) & 0x3ff
}
func (o *SCT2_Type) SetEV3_STATE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EV3_STATE.Reg, volatile.LoadUint32(&o.EV3_STATE.Reg)&^(0xfffffc00)|value<<10)
}
func (o *SCT2_Type) GetEV3_STATE_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EV3_STATE.Reg) & 0xfffffc00) >> 10
}

// SCT2.EV3_CTRL: SCT event control register 0
func (o *SCT2_Type) SetEV3_CTRL_MATCHSEL(value uint32) {
	volatile.StoreUint32(&o.EV3_CTRL.Reg, volatile.LoadUint32(&o.EV3_CTRL.Reg)&^(0xf)|value)
}
func (o *SCT2_Type) GetEV3_CTRL_MATCHSEL() uint32 {
	return volatile.LoadUint32(&o.EV3_CTRL.Reg) & 0xf
}
func (o *SCT2_Type) SetEV3_CTRL_HEVENT(value uint32) {
	volatile.StoreUint32(&o.EV3_CTRL.Reg, volatile.LoadUint32(&o.EV3_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *SCT2_Type) GetEV3_CTRL_HEVENT() uint32 {
	return (volatile.LoadUint32(&o.EV3_CTRL.Reg) & 0x10) >> 4
}
func (o *SCT2_Type) SetEV3_CTRL_OUTSEL(value uint32) {
	volatile.StoreUint32(&o.EV3_CTRL.Reg, volatile.LoadUint32(&o.EV3_CTRL.Reg)&^(0x20)|value<<5)
}
func (o *SCT2_Type) GetEV3_CTRL_OUTSEL() uint32 {
	return (volatile.LoadUint32(&o.EV3_CTRL.Reg) & 0x20) >> 5
}
func (o *SCT2_Type) SetEV3_CTRL_IOSEL(value uint32) {
	volatile.StoreUint32(&o.EV3_CTRL.Reg, volatile.LoadUint32(&o.EV3_CTRL.Reg)&^(0x3c0)|value<<6)
}
func (o *SCT2_Type) GetEV3_CTRL_IOSEL() uint32 {
	return (volatile.LoadUint32(&o.EV3_CTRL.Reg) & 0x3c0) >> 6
}
func (o *SCT2_Type) SetEV3_CTRL_IOCOND(value uint32) {
	volatile.StoreUint32(&o.EV3_CTRL.Reg, volatile.LoadUint32(&o.EV3_CTRL.Reg)&^(0xc00)|value<<10)
}
func (o *SCT2_Type) GetEV3_CTRL_IOCOND() uint32 {
	return (volatile.LoadUint32(&o.EV3_CTRL.Reg) & 0xc00) >> 10
}
func (o *SCT2_Type) SetEV3_CTRL_COMBMODE(value uint32) {
	volatile.StoreUint32(&o.EV3_CTRL.Reg, volatile.LoadUint32(&o.EV3_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *SCT2_Type) GetEV3_CTRL_COMBMODE() uint32 {
	return (volatile.LoadUint32(&o.EV3_CTRL.Reg) & 0x3000) >> 12
}
func (o *SCT2_Type) SetEV3_CTRL_STATELD(value uint32) {
	volatile.StoreUint32(&o.EV3_CTRL.Reg, volatile.LoadUint32(&o.EV3_CTRL.Reg)&^(0x4000)|value<<14)
}
func (o *SCT2_Type) GetEV3_CTRL_STATELD() uint32 {
	return (volatile.LoadUint32(&o.EV3_CTRL.Reg) & 0x4000) >> 14
}
func (o *SCT2_Type) SetEV3_CTRL_STATEV(value uint32) {
	volatile.StoreUint32(&o.EV3_CTRL.Reg, volatile.LoadUint32(&o.EV3_CTRL.Reg)&^(0xf8000)|value<<15)
}
func (o *SCT2_Type) GetEV3_CTRL_STATEV() uint32 {
	return (volatile.LoadUint32(&o.EV3_CTRL.Reg) & 0xf8000) >> 15
}
func (o *SCT2_Type) SetEV3_CTRL_MATCHMEM(value uint32) {
	volatile.StoreUint32(&o.EV3_CTRL.Reg, volatile.LoadUint32(&o.EV3_CTRL.Reg)&^(0x100000)|value<<20)
}
func (o *SCT2_Type) GetEV3_CTRL_MATCHMEM() uint32 {
	return (volatile.LoadUint32(&o.EV3_CTRL.Reg) & 0x100000) >> 20
}
func (o *SCT2_Type) SetEV3_CTRL_DIRECTION(value uint32) {
	volatile.StoreUint32(&o.EV3_CTRL.Reg, volatile.LoadUint32(&o.EV3_CTRL.Reg)&^(0x600000)|value<<21)
}
func (o *SCT2_Type) GetEV3_CTRL_DIRECTION() uint32 {
	return (volatile.LoadUint32(&o.EV3_CTRL.Reg) & 0x600000) >> 21
}
func (o *SCT2_Type) SetEV3_CTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EV3_CTRL.Reg, volatile.LoadUint32(&o.EV3_CTRL.Reg)&^(0xff800000)|value<<23)
}
func (o *SCT2_Type) GetEV3_CTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EV3_CTRL.Reg) & 0xff800000) >> 23
}

// SCT2.EV4_STATE: SCT event state register 0
func (o *SCT2_Type) SetEV4_STATE_STATEMSKn(value uint32) {
	volatile.StoreUint32(&o.EV4_STATE.Reg, volatile.LoadUint32(&o.EV4_STATE.Reg)&^(0x3ff)|value)
}
func (o *SCT2_Type) GetEV4_STATE_STATEMSKn() uint32 {
	return volatile.LoadUint32(&o.EV4_STATE.Reg) & 0x3ff
}
func (o *SCT2_Type) SetEV4_STATE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EV4_STATE.Reg, volatile.LoadUint32(&o.EV4_STATE.Reg)&^(0xfffffc00)|value<<10)
}
func (o *SCT2_Type) GetEV4_STATE_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EV4_STATE.Reg) & 0xfffffc00) >> 10
}

// SCT2.EV4_CTRL: SCT event control register 0
func (o *SCT2_Type) SetEV4_CTRL_MATCHSEL(value uint32) {
	volatile.StoreUint32(&o.EV4_CTRL.Reg, volatile.LoadUint32(&o.EV4_CTRL.Reg)&^(0xf)|value)
}
func (o *SCT2_Type) GetEV4_CTRL_MATCHSEL() uint32 {
	return volatile.LoadUint32(&o.EV4_CTRL.Reg) & 0xf
}
func (o *SCT2_Type) SetEV4_CTRL_HEVENT(value uint32) {
	volatile.StoreUint32(&o.EV4_CTRL.Reg, volatile.LoadUint32(&o.EV4_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *SCT2_Type) GetEV4_CTRL_HEVENT() uint32 {
	return (volatile.LoadUint32(&o.EV4_CTRL.Reg) & 0x10) >> 4
}
func (o *SCT2_Type) SetEV4_CTRL_OUTSEL(value uint32) {
	volatile.StoreUint32(&o.EV4_CTRL.Reg, volatile.LoadUint32(&o.EV4_CTRL.Reg)&^(0x20)|value<<5)
}
func (o *SCT2_Type) GetEV4_CTRL_OUTSEL() uint32 {
	return (volatile.LoadUint32(&o.EV4_CTRL.Reg) & 0x20) >> 5
}
func (o *SCT2_Type) SetEV4_CTRL_IOSEL(value uint32) {
	volatile.StoreUint32(&o.EV4_CTRL.Reg, volatile.LoadUint32(&o.EV4_CTRL.Reg)&^(0x3c0)|value<<6)
}
func (o *SCT2_Type) GetEV4_CTRL_IOSEL() uint32 {
	return (volatile.LoadUint32(&o.EV4_CTRL.Reg) & 0x3c0) >> 6
}
func (o *SCT2_Type) SetEV4_CTRL_IOCOND(value uint32) {
	volatile.StoreUint32(&o.EV4_CTRL.Reg, volatile.LoadUint32(&o.EV4_CTRL.Reg)&^(0xc00)|value<<10)
}
func (o *SCT2_Type) GetEV4_CTRL_IOCOND() uint32 {
	return (volatile.LoadUint32(&o.EV4_CTRL.Reg) & 0xc00) >> 10
}
func (o *SCT2_Type) SetEV4_CTRL_COMBMODE(value uint32) {
	volatile.StoreUint32(&o.EV4_CTRL.Reg, volatile.LoadUint32(&o.EV4_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *SCT2_Type) GetEV4_CTRL_COMBMODE() uint32 {
	return (volatile.LoadUint32(&o.EV4_CTRL.Reg) & 0x3000) >> 12
}
func (o *SCT2_Type) SetEV4_CTRL_STATELD(value uint32) {
	volatile.StoreUint32(&o.EV4_CTRL.Reg, volatile.LoadUint32(&o.EV4_CTRL.Reg)&^(0x4000)|value<<14)
}
func (o *SCT2_Type) GetEV4_CTRL_STATELD() uint32 {
	return (volatile.LoadUint32(&o.EV4_CTRL.Reg) & 0x4000) >> 14
}
func (o *SCT2_Type) SetEV4_CTRL_STATEV(value uint32) {
	volatile.StoreUint32(&o.EV4_CTRL.Reg, volatile.LoadUint32(&o.EV4_CTRL.Reg)&^(0xf8000)|value<<15)
}
func (o *SCT2_Type) GetEV4_CTRL_STATEV() uint32 {
	return (volatile.LoadUint32(&o.EV4_CTRL.Reg) & 0xf8000) >> 15
}
func (o *SCT2_Type) SetEV4_CTRL_MATCHMEM(value uint32) {
	volatile.StoreUint32(&o.EV4_CTRL.Reg, volatile.LoadUint32(&o.EV4_CTRL.Reg)&^(0x100000)|value<<20)
}
func (o *SCT2_Type) GetEV4_CTRL_MATCHMEM() uint32 {
	return (volatile.LoadUint32(&o.EV4_CTRL.Reg) & 0x100000) >> 20
}
func (o *SCT2_Type) SetEV4_CTRL_DIRECTION(value uint32) {
	volatile.StoreUint32(&o.EV4_CTRL.Reg, volatile.LoadUint32(&o.EV4_CTRL.Reg)&^(0x600000)|value<<21)
}
func (o *SCT2_Type) GetEV4_CTRL_DIRECTION() uint32 {
	return (volatile.LoadUint32(&o.EV4_CTRL.Reg) & 0x600000) >> 21
}
func (o *SCT2_Type) SetEV4_CTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EV4_CTRL.Reg, volatile.LoadUint32(&o.EV4_CTRL.Reg)&^(0xff800000)|value<<23)
}
func (o *SCT2_Type) GetEV4_CTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EV4_CTRL.Reg) & 0xff800000) >> 23
}

// SCT2.EV5_STATE: SCT event state register 0
func (o *SCT2_Type) SetEV5_STATE_STATEMSKn(value uint32) {
	volatile.StoreUint32(&o.EV5_STATE.Reg, volatile.LoadUint32(&o.EV5_STATE.Reg)&^(0x3ff)|value)
}
func (o *SCT2_Type) GetEV5_STATE_STATEMSKn() uint32 {
	return volatile.LoadUint32(&o.EV5_STATE.Reg) & 0x3ff
}
func (o *SCT2_Type) SetEV5_STATE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EV5_STATE.Reg, volatile.LoadUint32(&o.EV5_STATE.Reg)&^(0xfffffc00)|value<<10)
}
func (o *SCT2_Type) GetEV5_STATE_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EV5_STATE.Reg) & 0xfffffc00) >> 10
}

// SCT2.EV5_CTRL: SCT event control register 0
func (o *SCT2_Type) SetEV5_CTRL_MATCHSEL(value uint32) {
	volatile.StoreUint32(&o.EV5_CTRL.Reg, volatile.LoadUint32(&o.EV5_CTRL.Reg)&^(0xf)|value)
}
func (o *SCT2_Type) GetEV5_CTRL_MATCHSEL() uint32 {
	return volatile.LoadUint32(&o.EV5_CTRL.Reg) & 0xf
}
func (o *SCT2_Type) SetEV5_CTRL_HEVENT(value uint32) {
	volatile.StoreUint32(&o.EV5_CTRL.Reg, volatile.LoadUint32(&o.EV5_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *SCT2_Type) GetEV5_CTRL_HEVENT() uint32 {
	return (volatile.LoadUint32(&o.EV5_CTRL.Reg) & 0x10) >> 4
}
func (o *SCT2_Type) SetEV5_CTRL_OUTSEL(value uint32) {
	volatile.StoreUint32(&o.EV5_CTRL.Reg, volatile.LoadUint32(&o.EV5_CTRL.Reg)&^(0x20)|value<<5)
}
func (o *SCT2_Type) GetEV5_CTRL_OUTSEL() uint32 {
	return (volatile.LoadUint32(&o.EV5_CTRL.Reg) & 0x20) >> 5
}
func (o *SCT2_Type) SetEV5_CTRL_IOSEL(value uint32) {
	volatile.StoreUint32(&o.EV5_CTRL.Reg, volatile.LoadUint32(&o.EV5_CTRL.Reg)&^(0x3c0)|value<<6)
}
func (o *SCT2_Type) GetEV5_CTRL_IOSEL() uint32 {
	return (volatile.LoadUint32(&o.EV5_CTRL.Reg) & 0x3c0) >> 6
}
func (o *SCT2_Type) SetEV5_CTRL_IOCOND(value uint32) {
	volatile.StoreUint32(&o.EV5_CTRL.Reg, volatile.LoadUint32(&o.EV5_CTRL.Reg)&^(0xc00)|value<<10)
}
func (o *SCT2_Type) GetEV5_CTRL_IOCOND() uint32 {
	return (volatile.LoadUint32(&o.EV5_CTRL.Reg) & 0xc00) >> 10
}
func (o *SCT2_Type) SetEV5_CTRL_COMBMODE(value uint32) {
	volatile.StoreUint32(&o.EV5_CTRL.Reg, volatile.LoadUint32(&o.EV5_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *SCT2_Type) GetEV5_CTRL_COMBMODE() uint32 {
	return (volatile.LoadUint32(&o.EV5_CTRL.Reg) & 0x3000) >> 12
}
func (o *SCT2_Type) SetEV5_CTRL_STATELD(value uint32) {
	volatile.StoreUint32(&o.EV5_CTRL.Reg, volatile.LoadUint32(&o.EV5_CTRL.Reg)&^(0x4000)|value<<14)
}
func (o *SCT2_Type) GetEV5_CTRL_STATELD() uint32 {
	return (volatile.LoadUint32(&o.EV5_CTRL.Reg) & 0x4000) >> 14
}
func (o *SCT2_Type) SetEV5_CTRL_STATEV(value uint32) {
	volatile.StoreUint32(&o.EV5_CTRL.Reg, volatile.LoadUint32(&o.EV5_CTRL.Reg)&^(0xf8000)|value<<15)
}
func (o *SCT2_Type) GetEV5_CTRL_STATEV() uint32 {
	return (volatile.LoadUint32(&o.EV5_CTRL.Reg) & 0xf8000) >> 15
}
func (o *SCT2_Type) SetEV5_CTRL_MATCHMEM(value uint32) {
	volatile.StoreUint32(&o.EV5_CTRL.Reg, volatile.LoadUint32(&o.EV5_CTRL.Reg)&^(0x100000)|value<<20)
}
func (o *SCT2_Type) GetEV5_CTRL_MATCHMEM() uint32 {
	return (volatile.LoadUint32(&o.EV5_CTRL.Reg) & 0x100000) >> 20
}
func (o *SCT2_Type) SetEV5_CTRL_DIRECTION(value uint32) {
	volatile.StoreUint32(&o.EV5_CTRL.Reg, volatile.LoadUint32(&o.EV5_CTRL.Reg)&^(0x600000)|value<<21)
}
func (o *SCT2_Type) GetEV5_CTRL_DIRECTION() uint32 {
	return (volatile.LoadUint32(&o.EV5_CTRL.Reg) & 0x600000) >> 21
}
func (o *SCT2_Type) SetEV5_CTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EV5_CTRL.Reg, volatile.LoadUint32(&o.EV5_CTRL.Reg)&^(0xff800000)|value<<23)
}
func (o *SCT2_Type) GetEV5_CTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EV5_CTRL.Reg) & 0xff800000) >> 23
}

// SCT2.EV6_STATE: SCT event state register 0
func (o *SCT2_Type) SetEV6_STATE_STATEMSKn(value uint32) {
	volatile.StoreUint32(&o.EV6_STATE.Reg, volatile.LoadUint32(&o.EV6_STATE.Reg)&^(0x3ff)|value)
}
func (o *SCT2_Type) GetEV6_STATE_STATEMSKn() uint32 {
	return volatile.LoadUint32(&o.EV6_STATE.Reg) & 0x3ff
}
func (o *SCT2_Type) SetEV6_STATE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EV6_STATE.Reg, volatile.LoadUint32(&o.EV6_STATE.Reg)&^(0xfffffc00)|value<<10)
}
func (o *SCT2_Type) GetEV6_STATE_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EV6_STATE.Reg) & 0xfffffc00) >> 10
}

// SCT2.EV6_CTRL: SCT event control register 0
func (o *SCT2_Type) SetEV6_CTRL_MATCHSEL(value uint32) {
	volatile.StoreUint32(&o.EV6_CTRL.Reg, volatile.LoadUint32(&o.EV6_CTRL.Reg)&^(0xf)|value)
}
func (o *SCT2_Type) GetEV6_CTRL_MATCHSEL() uint32 {
	return volatile.LoadUint32(&o.EV6_CTRL.Reg) & 0xf
}
func (o *SCT2_Type) SetEV6_CTRL_HEVENT(value uint32) {
	volatile.StoreUint32(&o.EV6_CTRL.Reg, volatile.LoadUint32(&o.EV6_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *SCT2_Type) GetEV6_CTRL_HEVENT() uint32 {
	return (volatile.LoadUint32(&o.EV6_CTRL.Reg) & 0x10) >> 4
}
func (o *SCT2_Type) SetEV6_CTRL_OUTSEL(value uint32) {
	volatile.StoreUint32(&o.EV6_CTRL.Reg, volatile.LoadUint32(&o.EV6_CTRL.Reg)&^(0x20)|value<<5)
}
func (o *SCT2_Type) GetEV6_CTRL_OUTSEL() uint32 {
	return (volatile.LoadUint32(&o.EV6_CTRL.Reg) & 0x20) >> 5
}
func (o *SCT2_Type) SetEV6_CTRL_IOSEL(value uint32) {
	volatile.StoreUint32(&o.EV6_CTRL.Reg, volatile.LoadUint32(&o.EV6_CTRL.Reg)&^(0x3c0)|value<<6)
}
func (o *SCT2_Type) GetEV6_CTRL_IOSEL() uint32 {
	return (volatile.LoadUint32(&o.EV6_CTRL.Reg) & 0x3c0) >> 6
}
func (o *SCT2_Type) SetEV6_CTRL_IOCOND(value uint32) {
	volatile.StoreUint32(&o.EV6_CTRL.Reg, volatile.LoadUint32(&o.EV6_CTRL.Reg)&^(0xc00)|value<<10)
}
func (o *SCT2_Type) GetEV6_CTRL_IOCOND() uint32 {
	return (volatile.LoadUint32(&o.EV6_CTRL.Reg) & 0xc00) >> 10
}
func (o *SCT2_Type) SetEV6_CTRL_COMBMODE(value uint32) {
	volatile.StoreUint32(&o.EV6_CTRL.Reg, volatile.LoadUint32(&o.EV6_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *SCT2_Type) GetEV6_CTRL_COMBMODE() uint32 {
	return (volatile.LoadUint32(&o.EV6_CTRL.Reg) & 0x3000) >> 12
}
func (o *SCT2_Type) SetEV6_CTRL_STATELD(value uint32) {
	volatile.StoreUint32(&o.EV6_CTRL.Reg, volatile.LoadUint32(&o.EV6_CTRL.Reg)&^(0x4000)|value<<14)
}
func (o *SCT2_Type) GetEV6_CTRL_STATELD() uint32 {
	return (volatile.LoadUint32(&o.EV6_CTRL.Reg) & 0x4000) >> 14
}
func (o *SCT2_Type) SetEV6_CTRL_STATEV(value uint32) {
	volatile.StoreUint32(&o.EV6_CTRL.Reg, volatile.LoadUint32(&o.EV6_CTRL.Reg)&^(0xf8000)|value<<15)
}
func (o *SCT2_Type) GetEV6_CTRL_STATEV() uint32 {
	return (volatile.LoadUint32(&o.EV6_CTRL.Reg) & 0xf8000) >> 15
}
func (o *SCT2_Type) SetEV6_CTRL_MATCHMEM(value uint32) {
	volatile.StoreUint32(&o.EV6_CTRL.Reg, volatile.LoadUint32(&o.EV6_CTRL.Reg)&^(0x100000)|value<<20)
}
func (o *SCT2_Type) GetEV6_CTRL_MATCHMEM() uint32 {
	return (volatile.LoadUint32(&o.EV6_CTRL.Reg) & 0x100000) >> 20
}
func (o *SCT2_Type) SetEV6_CTRL_DIRECTION(value uint32) {
	volatile.StoreUint32(&o.EV6_CTRL.Reg, volatile.LoadUint32(&o.EV6_CTRL.Reg)&^(0x600000)|value<<21)
}
func (o *SCT2_Type) GetEV6_CTRL_DIRECTION() uint32 {
	return (volatile.LoadUint32(&o.EV6_CTRL.Reg) & 0x600000) >> 21
}
func (o *SCT2_Type) SetEV6_CTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EV6_CTRL.Reg, volatile.LoadUint32(&o.EV6_CTRL.Reg)&^(0xff800000)|value<<23)
}
func (o *SCT2_Type) GetEV6_CTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EV6_CTRL.Reg) & 0xff800000) >> 23
}

// SCT2.EV7_STATE: SCT event state register 0
func (o *SCT2_Type) SetEV7_STATE_STATEMSKn(value uint32) {
	volatile.StoreUint32(&o.EV7_STATE.Reg, volatile.LoadUint32(&o.EV7_STATE.Reg)&^(0x3ff)|value)
}
func (o *SCT2_Type) GetEV7_STATE_STATEMSKn() uint32 {
	return volatile.LoadUint32(&o.EV7_STATE.Reg) & 0x3ff
}
func (o *SCT2_Type) SetEV7_STATE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EV7_STATE.Reg, volatile.LoadUint32(&o.EV7_STATE.Reg)&^(0xfffffc00)|value<<10)
}
func (o *SCT2_Type) GetEV7_STATE_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EV7_STATE.Reg) & 0xfffffc00) >> 10
}

// SCT2.EV7_CTRL: SCT event control register 0
func (o *SCT2_Type) SetEV7_CTRL_MATCHSEL(value uint32) {
	volatile.StoreUint32(&o.EV7_CTRL.Reg, volatile.LoadUint32(&o.EV7_CTRL.Reg)&^(0xf)|value)
}
func (o *SCT2_Type) GetEV7_CTRL_MATCHSEL() uint32 {
	return volatile.LoadUint32(&o.EV7_CTRL.Reg) & 0xf
}
func (o *SCT2_Type) SetEV7_CTRL_HEVENT(value uint32) {
	volatile.StoreUint32(&o.EV7_CTRL.Reg, volatile.LoadUint32(&o.EV7_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *SCT2_Type) GetEV7_CTRL_HEVENT() uint32 {
	return (volatile.LoadUint32(&o.EV7_CTRL.Reg) & 0x10) >> 4
}
func (o *SCT2_Type) SetEV7_CTRL_OUTSEL(value uint32) {
	volatile.StoreUint32(&o.EV7_CTRL.Reg, volatile.LoadUint32(&o.EV7_CTRL.Reg)&^(0x20)|value<<5)
}
func (o *SCT2_Type) GetEV7_CTRL_OUTSEL() uint32 {
	return (volatile.LoadUint32(&o.EV7_CTRL.Reg) & 0x20) >> 5
}
func (o *SCT2_Type) SetEV7_CTRL_IOSEL(value uint32) {
	volatile.StoreUint32(&o.EV7_CTRL.Reg, volatile.LoadUint32(&o.EV7_CTRL.Reg)&^(0x3c0)|value<<6)
}
func (o *SCT2_Type) GetEV7_CTRL_IOSEL() uint32 {
	return (volatile.LoadUint32(&o.EV7_CTRL.Reg) & 0x3c0) >> 6
}
func (o *SCT2_Type) SetEV7_CTRL_IOCOND(value uint32) {
	volatile.StoreUint32(&o.EV7_CTRL.Reg, volatile.LoadUint32(&o.EV7_CTRL.Reg)&^(0xc00)|value<<10)
}
func (o *SCT2_Type) GetEV7_CTRL_IOCOND() uint32 {
	return (volatile.LoadUint32(&o.EV7_CTRL.Reg) & 0xc00) >> 10
}
func (o *SCT2_Type) SetEV7_CTRL_COMBMODE(value uint32) {
	volatile.StoreUint32(&o.EV7_CTRL.Reg, volatile.LoadUint32(&o.EV7_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *SCT2_Type) GetEV7_CTRL_COMBMODE() uint32 {
	return (volatile.LoadUint32(&o.EV7_CTRL.Reg) & 0x3000) >> 12
}
func (o *SCT2_Type) SetEV7_CTRL_STATELD(value uint32) {
	volatile.StoreUint32(&o.EV7_CTRL.Reg, volatile.LoadUint32(&o.EV7_CTRL.Reg)&^(0x4000)|value<<14)
}
func (o *SCT2_Type) GetEV7_CTRL_STATELD() uint32 {
	return (volatile.LoadUint32(&o.EV7_CTRL.Reg) & 0x4000) >> 14
}
func (o *SCT2_Type) SetEV7_CTRL_STATEV(value uint32) {
	volatile.StoreUint32(&o.EV7_CTRL.Reg, volatile.LoadUint32(&o.EV7_CTRL.Reg)&^(0xf8000)|value<<15)
}
func (o *SCT2_Type) GetEV7_CTRL_STATEV() uint32 {
	return (volatile.LoadUint32(&o.EV7_CTRL.Reg) & 0xf8000) >> 15
}
func (o *SCT2_Type) SetEV7_CTRL_MATCHMEM(value uint32) {
	volatile.StoreUint32(&o.EV7_CTRL.Reg, volatile.LoadUint32(&o.EV7_CTRL.Reg)&^(0x100000)|value<<20)
}
func (o *SCT2_Type) GetEV7_CTRL_MATCHMEM() uint32 {
	return (volatile.LoadUint32(&o.EV7_CTRL.Reg) & 0x100000) >> 20
}
func (o *SCT2_Type) SetEV7_CTRL_DIRECTION(value uint32) {
	volatile.StoreUint32(&o.EV7_CTRL.Reg, volatile.LoadUint32(&o.EV7_CTRL.Reg)&^(0x600000)|value<<21)
}
func (o *SCT2_Type) GetEV7_CTRL_DIRECTION() uint32 {
	return (volatile.LoadUint32(&o.EV7_CTRL.Reg) & 0x600000) >> 21
}
func (o *SCT2_Type) SetEV7_CTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EV7_CTRL.Reg, volatile.LoadUint32(&o.EV7_CTRL.Reg)&^(0xff800000)|value<<23)
}
func (o *SCT2_Type) GetEV7_CTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EV7_CTRL.Reg) & 0xff800000) >> 23
}

// SCT2.EV8_STATE: SCT event state register 0
func (o *SCT2_Type) SetEV8_STATE_STATEMSKn(value uint32) {
	volatile.StoreUint32(&o.EV8_STATE.Reg, volatile.LoadUint32(&o.EV8_STATE.Reg)&^(0x3ff)|value)
}
func (o *SCT2_Type) GetEV8_STATE_STATEMSKn() uint32 {
	return volatile.LoadUint32(&o.EV8_STATE.Reg) & 0x3ff
}
func (o *SCT2_Type) SetEV8_STATE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EV8_STATE.Reg, volatile.LoadUint32(&o.EV8_STATE.Reg)&^(0xfffffc00)|value<<10)
}
func (o *SCT2_Type) GetEV8_STATE_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EV8_STATE.Reg) & 0xfffffc00) >> 10
}

// SCT2.EV8_CTRL: SCT event control register 0
func (o *SCT2_Type) SetEV8_CTRL_MATCHSEL(value uint32) {
	volatile.StoreUint32(&o.EV8_CTRL.Reg, volatile.LoadUint32(&o.EV8_CTRL.Reg)&^(0xf)|value)
}
func (o *SCT2_Type) GetEV8_CTRL_MATCHSEL() uint32 {
	return volatile.LoadUint32(&o.EV8_CTRL.Reg) & 0xf
}
func (o *SCT2_Type) SetEV8_CTRL_HEVENT(value uint32) {
	volatile.StoreUint32(&o.EV8_CTRL.Reg, volatile.LoadUint32(&o.EV8_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *SCT2_Type) GetEV8_CTRL_HEVENT() uint32 {
	return (volatile.LoadUint32(&o.EV8_CTRL.Reg) & 0x10) >> 4
}
func (o *SCT2_Type) SetEV8_CTRL_OUTSEL(value uint32) {
	volatile.StoreUint32(&o.EV8_CTRL.Reg, volatile.LoadUint32(&o.EV8_CTRL.Reg)&^(0x20)|value<<5)
}
func (o *SCT2_Type) GetEV8_CTRL_OUTSEL() uint32 {
	return (volatile.LoadUint32(&o.EV8_CTRL.Reg) & 0x20) >> 5
}
func (o *SCT2_Type) SetEV8_CTRL_IOSEL(value uint32) {
	volatile.StoreUint32(&o.EV8_CTRL.Reg, volatile.LoadUint32(&o.EV8_CTRL.Reg)&^(0x3c0)|value<<6)
}
func (o *SCT2_Type) GetEV8_CTRL_IOSEL() uint32 {
	return (volatile.LoadUint32(&o.EV8_CTRL.Reg) & 0x3c0) >> 6
}
func (o *SCT2_Type) SetEV8_CTRL_IOCOND(value uint32) {
	volatile.StoreUint32(&o.EV8_CTRL.Reg, volatile.LoadUint32(&o.EV8_CTRL.Reg)&^(0xc00)|value<<10)
}
func (o *SCT2_Type) GetEV8_CTRL_IOCOND() uint32 {
	return (volatile.LoadUint32(&o.EV8_CTRL.Reg) & 0xc00) >> 10
}
func (o *SCT2_Type) SetEV8_CTRL_COMBMODE(value uint32) {
	volatile.StoreUint32(&o.EV8_CTRL.Reg, volatile.LoadUint32(&o.EV8_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *SCT2_Type) GetEV8_CTRL_COMBMODE() uint32 {
	return (volatile.LoadUint32(&o.EV8_CTRL.Reg) & 0x3000) >> 12
}
func (o *SCT2_Type) SetEV8_CTRL_STATELD(value uint32) {
	volatile.StoreUint32(&o.EV8_CTRL.Reg, volatile.LoadUint32(&o.EV8_CTRL.Reg)&^(0x4000)|value<<14)
}
func (o *SCT2_Type) GetEV8_CTRL_STATELD() uint32 {
	return (volatile.LoadUint32(&o.EV8_CTRL.Reg) & 0x4000) >> 14
}
func (o *SCT2_Type) SetEV8_CTRL_STATEV(value uint32) {
	volatile.StoreUint32(&o.EV8_CTRL.Reg, volatile.LoadUint32(&o.EV8_CTRL.Reg)&^(0xf8000)|value<<15)
}
func (o *SCT2_Type) GetEV8_CTRL_STATEV() uint32 {
	return (volatile.LoadUint32(&o.EV8_CTRL.Reg) & 0xf8000) >> 15
}
func (o *SCT2_Type) SetEV8_CTRL_MATCHMEM(value uint32) {
	volatile.StoreUint32(&o.EV8_CTRL.Reg, volatile.LoadUint32(&o.EV8_CTRL.Reg)&^(0x100000)|value<<20)
}
func (o *SCT2_Type) GetEV8_CTRL_MATCHMEM() uint32 {
	return (volatile.LoadUint32(&o.EV8_CTRL.Reg) & 0x100000) >> 20
}
func (o *SCT2_Type) SetEV8_CTRL_DIRECTION(value uint32) {
	volatile.StoreUint32(&o.EV8_CTRL.Reg, volatile.LoadUint32(&o.EV8_CTRL.Reg)&^(0x600000)|value<<21)
}
func (o *SCT2_Type) GetEV8_CTRL_DIRECTION() uint32 {
	return (volatile.LoadUint32(&o.EV8_CTRL.Reg) & 0x600000) >> 21
}
func (o *SCT2_Type) SetEV8_CTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EV8_CTRL.Reg, volatile.LoadUint32(&o.EV8_CTRL.Reg)&^(0xff800000)|value<<23)
}
func (o *SCT2_Type) GetEV8_CTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EV8_CTRL.Reg) & 0xff800000) >> 23
}

// SCT2.EV9_STATE: SCT event state register 0
func (o *SCT2_Type) SetEV9_STATE_STATEMSKn(value uint32) {
	volatile.StoreUint32(&o.EV9_STATE.Reg, volatile.LoadUint32(&o.EV9_STATE.Reg)&^(0x3ff)|value)
}
func (o *SCT2_Type) GetEV9_STATE_STATEMSKn() uint32 {
	return volatile.LoadUint32(&o.EV9_STATE.Reg) & 0x3ff
}
func (o *SCT2_Type) SetEV9_STATE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EV9_STATE.Reg, volatile.LoadUint32(&o.EV9_STATE.Reg)&^(0xfffffc00)|value<<10)
}
func (o *SCT2_Type) GetEV9_STATE_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EV9_STATE.Reg) & 0xfffffc00) >> 10
}

// SCT2.EV9_CTRL: SCT event control register 0
func (o *SCT2_Type) SetEV9_CTRL_MATCHSEL(value uint32) {
	volatile.StoreUint32(&o.EV9_CTRL.Reg, volatile.LoadUint32(&o.EV9_CTRL.Reg)&^(0xf)|value)
}
func (o *SCT2_Type) GetEV9_CTRL_MATCHSEL() uint32 {
	return volatile.LoadUint32(&o.EV9_CTRL.Reg) & 0xf
}
func (o *SCT2_Type) SetEV9_CTRL_HEVENT(value uint32) {
	volatile.StoreUint32(&o.EV9_CTRL.Reg, volatile.LoadUint32(&o.EV9_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *SCT2_Type) GetEV9_CTRL_HEVENT() uint32 {
	return (volatile.LoadUint32(&o.EV9_CTRL.Reg) & 0x10) >> 4
}
func (o *SCT2_Type) SetEV9_CTRL_OUTSEL(value uint32) {
	volatile.StoreUint32(&o.EV9_CTRL.Reg, volatile.LoadUint32(&o.EV9_CTRL.Reg)&^(0x20)|value<<5)
}
func (o *SCT2_Type) GetEV9_CTRL_OUTSEL() uint32 {
	return (volatile.LoadUint32(&o.EV9_CTRL.Reg) & 0x20) >> 5
}
func (o *SCT2_Type) SetEV9_CTRL_IOSEL(value uint32) {
	volatile.StoreUint32(&o.EV9_CTRL.Reg, volatile.LoadUint32(&o.EV9_CTRL.Reg)&^(0x3c0)|value<<6)
}
func (o *SCT2_Type) GetEV9_CTRL_IOSEL() uint32 {
	return (volatile.LoadUint32(&o.EV9_CTRL.Reg) & 0x3c0) >> 6
}
func (o *SCT2_Type) SetEV9_CTRL_IOCOND(value uint32) {
	volatile.StoreUint32(&o.EV9_CTRL.Reg, volatile.LoadUint32(&o.EV9_CTRL.Reg)&^(0xc00)|value<<10)
}
func (o *SCT2_Type) GetEV9_CTRL_IOCOND() uint32 {
	return (volatile.LoadUint32(&o.EV9_CTRL.Reg) & 0xc00) >> 10
}
func (o *SCT2_Type) SetEV9_CTRL_COMBMODE(value uint32) {
	volatile.StoreUint32(&o.EV9_CTRL.Reg, volatile.LoadUint32(&o.EV9_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *SCT2_Type) GetEV9_CTRL_COMBMODE() uint32 {
	return (volatile.LoadUint32(&o.EV9_CTRL.Reg) & 0x3000) >> 12
}
func (o *SCT2_Type) SetEV9_CTRL_STATELD(value uint32) {
	volatile.StoreUint32(&o.EV9_CTRL.Reg, volatile.LoadUint32(&o.EV9_CTRL.Reg)&^(0x4000)|value<<14)
}
func (o *SCT2_Type) GetEV9_CTRL_STATELD() uint32 {
	return (volatile.LoadUint32(&o.EV9_CTRL.Reg) & 0x4000) >> 14
}
func (o *SCT2_Type) SetEV9_CTRL_STATEV(value uint32) {
	volatile.StoreUint32(&o.EV9_CTRL.Reg, volatile.LoadUint32(&o.EV9_CTRL.Reg)&^(0xf8000)|value<<15)
}
func (o *SCT2_Type) GetEV9_CTRL_STATEV() uint32 {
	return (volatile.LoadUint32(&o.EV9_CTRL.Reg) & 0xf8000) >> 15
}
func (o *SCT2_Type) SetEV9_CTRL_MATCHMEM(value uint32) {
	volatile.StoreUint32(&o.EV9_CTRL.Reg, volatile.LoadUint32(&o.EV9_CTRL.Reg)&^(0x100000)|value<<20)
}
func (o *SCT2_Type) GetEV9_CTRL_MATCHMEM() uint32 {
	return (volatile.LoadUint32(&o.EV9_CTRL.Reg) & 0x100000) >> 20
}
func (o *SCT2_Type) SetEV9_CTRL_DIRECTION(value uint32) {
	volatile.StoreUint32(&o.EV9_CTRL.Reg, volatile.LoadUint32(&o.EV9_CTRL.Reg)&^(0x600000)|value<<21)
}
func (o *SCT2_Type) GetEV9_CTRL_DIRECTION() uint32 {
	return (volatile.LoadUint32(&o.EV9_CTRL.Reg) & 0x600000) >> 21
}
func (o *SCT2_Type) SetEV9_CTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EV9_CTRL.Reg, volatile.LoadUint32(&o.EV9_CTRL.Reg)&^(0xff800000)|value<<23)
}
func (o *SCT2_Type) GetEV9_CTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EV9_CTRL.Reg) & 0xff800000) >> 23
}

// SCT2.OUT0_SET: SCT output 0 set register
func (o *SCT2_Type) SetOUT0_SET_SET(value uint32) {
	volatile.StoreUint32(&o.OUT0_SET.Reg, volatile.LoadUint32(&o.OUT0_SET.Reg)&^(0x3ff)|value)
}
func (o *SCT2_Type) GetOUT0_SET_SET() uint32 {
	return volatile.LoadUint32(&o.OUT0_SET.Reg) & 0x3ff
}
func (o *SCT2_Type) SetOUT0_SET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.OUT0_SET.Reg, volatile.LoadUint32(&o.OUT0_SET.Reg)&^(0xfffffc00)|value<<10)
}
func (o *SCT2_Type) GetOUT0_SET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.OUT0_SET.Reg) & 0xfffffc00) >> 10
}

// SCT2.OUT0_CLR: SCT output 0 clear register
func (o *SCT2_Type) SetOUT0_CLR_CLR(value uint32) {
	volatile.StoreUint32(&o.OUT0_CLR.Reg, volatile.LoadUint32(&o.OUT0_CLR.Reg)&^(0x3ff)|value)
}
func (o *SCT2_Type) GetOUT0_CLR_CLR() uint32 {
	return volatile.LoadUint32(&o.OUT0_CLR.Reg) & 0x3ff
}
func (o *SCT2_Type) SetOUT0_CLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.OUT0_CLR.Reg, volatile.LoadUint32(&o.OUT0_CLR.Reg)&^(0xfffffc00)|value<<10)
}
func (o *SCT2_Type) GetOUT0_CLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.OUT0_CLR.Reg) & 0xfffffc00) >> 10
}

// SCT2.OUT1_SET: SCT output 0 set register
func (o *SCT2_Type) SetOUT1_SET_SET(value uint32) {
	volatile.StoreUint32(&o.OUT1_SET.Reg, volatile.LoadUint32(&o.OUT1_SET.Reg)&^(0x3ff)|value)
}
func (o *SCT2_Type) GetOUT1_SET_SET() uint32 {
	return volatile.LoadUint32(&o.OUT1_SET.Reg) & 0x3ff
}
func (o *SCT2_Type) SetOUT1_SET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.OUT1_SET.Reg, volatile.LoadUint32(&o.OUT1_SET.Reg)&^(0xfffffc00)|value<<10)
}
func (o *SCT2_Type) GetOUT1_SET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.OUT1_SET.Reg) & 0xfffffc00) >> 10
}

// SCT2.OUT1_CLR: SCT output 0 clear register
func (o *SCT2_Type) SetOUT1_CLR_CLR(value uint32) {
	volatile.StoreUint32(&o.OUT1_CLR.Reg, volatile.LoadUint32(&o.OUT1_CLR.Reg)&^(0x3ff)|value)
}
func (o *SCT2_Type) GetOUT1_CLR_CLR() uint32 {
	return volatile.LoadUint32(&o.OUT1_CLR.Reg) & 0x3ff
}
func (o *SCT2_Type) SetOUT1_CLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.OUT1_CLR.Reg, volatile.LoadUint32(&o.OUT1_CLR.Reg)&^(0xfffffc00)|value<<10)
}
func (o *SCT2_Type) GetOUT1_CLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.OUT1_CLR.Reg) & 0xfffffc00) >> 10
}

// SCT2.OUT2_SET: SCT output 0 set register
func (o *SCT2_Type) SetOUT2_SET_SET(value uint32) {
	volatile.StoreUint32(&o.OUT2_SET.Reg, volatile.LoadUint32(&o.OUT2_SET.Reg)&^(0x3ff)|value)
}
func (o *SCT2_Type) GetOUT2_SET_SET() uint32 {
	return volatile.LoadUint32(&o.OUT2_SET.Reg) & 0x3ff
}
func (o *SCT2_Type) SetOUT2_SET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.OUT2_SET.Reg, volatile.LoadUint32(&o.OUT2_SET.Reg)&^(0xfffffc00)|value<<10)
}
func (o *SCT2_Type) GetOUT2_SET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.OUT2_SET.Reg) & 0xfffffc00) >> 10
}

// SCT2.OUT2_CLR: SCT output 0 clear register
func (o *SCT2_Type) SetOUT2_CLR_CLR(value uint32) {
	volatile.StoreUint32(&o.OUT2_CLR.Reg, volatile.LoadUint32(&o.OUT2_CLR.Reg)&^(0x3ff)|value)
}
func (o *SCT2_Type) GetOUT2_CLR_CLR() uint32 {
	return volatile.LoadUint32(&o.OUT2_CLR.Reg) & 0x3ff
}
func (o *SCT2_Type) SetOUT2_CLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.OUT2_CLR.Reg, volatile.LoadUint32(&o.OUT2_CLR.Reg)&^(0xfffffc00)|value<<10)
}
func (o *SCT2_Type) GetOUT2_CLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.OUT2_CLR.Reg) & 0xfffffc00) >> 10
}

// SCT2.OUT3_SET: SCT output 0 set register
func (o *SCT2_Type) SetOUT3_SET_SET(value uint32) {
	volatile.StoreUint32(&o.OUT3_SET.Reg, volatile.LoadUint32(&o.OUT3_SET.Reg)&^(0x3ff)|value)
}
func (o *SCT2_Type) GetOUT3_SET_SET() uint32 {
	return volatile.LoadUint32(&o.OUT3_SET.Reg) & 0x3ff
}
func (o *SCT2_Type) SetOUT3_SET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.OUT3_SET.Reg, volatile.LoadUint32(&o.OUT3_SET.Reg)&^(0xfffffc00)|value<<10)
}
func (o *SCT2_Type) GetOUT3_SET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.OUT3_SET.Reg) & 0xfffffc00) >> 10
}

// SCT2.OUT3_CLR: SCT output 0 clear register
func (o *SCT2_Type) SetOUT3_CLR_CLR(value uint32) {
	volatile.StoreUint32(&o.OUT3_CLR.Reg, volatile.LoadUint32(&o.OUT3_CLR.Reg)&^(0x3ff)|value)
}
func (o *SCT2_Type) GetOUT3_CLR_CLR() uint32 {
	return volatile.LoadUint32(&o.OUT3_CLR.Reg) & 0x3ff
}
func (o *SCT2_Type) SetOUT3_CLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.OUT3_CLR.Reg, volatile.LoadUint32(&o.OUT3_CLR.Reg)&^(0xfffffc00)|value<<10)
}
func (o *SCT2_Type) GetOUT3_CLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.OUT3_CLR.Reg) & 0xfffffc00) >> 10
}

// SCT2.OUT4_SET: SCT output 0 set register
func (o *SCT2_Type) SetOUT4_SET_SET(value uint32) {
	volatile.StoreUint32(&o.OUT4_SET.Reg, volatile.LoadUint32(&o.OUT4_SET.Reg)&^(0x3ff)|value)
}
func (o *SCT2_Type) GetOUT4_SET_SET() uint32 {
	return volatile.LoadUint32(&o.OUT4_SET.Reg) & 0x3ff
}
func (o *SCT2_Type) SetOUT4_SET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.OUT4_SET.Reg, volatile.LoadUint32(&o.OUT4_SET.Reg)&^(0xfffffc00)|value<<10)
}
func (o *SCT2_Type) GetOUT4_SET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.OUT4_SET.Reg) & 0xfffffc00) >> 10
}

// SCT2.OUT4_CLR: SCT output 0 clear register
func (o *SCT2_Type) SetOUT4_CLR_CLR(value uint32) {
	volatile.StoreUint32(&o.OUT4_CLR.Reg, volatile.LoadUint32(&o.OUT4_CLR.Reg)&^(0x3ff)|value)
}
func (o *SCT2_Type) GetOUT4_CLR_CLR() uint32 {
	return volatile.LoadUint32(&o.OUT4_CLR.Reg) & 0x3ff
}
func (o *SCT2_Type) SetOUT4_CLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.OUT4_CLR.Reg, volatile.LoadUint32(&o.OUT4_CLR.Reg)&^(0xfffffc00)|value<<10)
}
func (o *SCT2_Type) GetOUT4_CLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.OUT4_CLR.Reg) & 0xfffffc00) >> 10
}

// SCT2.OUT5_SET: SCT output 0 set register
func (o *SCT2_Type) SetOUT5_SET_SET(value uint32) {
	volatile.StoreUint32(&o.OUT5_SET.Reg, volatile.LoadUint32(&o.OUT5_SET.Reg)&^(0x3ff)|value)
}
func (o *SCT2_Type) GetOUT5_SET_SET() uint32 {
	return volatile.LoadUint32(&o.OUT5_SET.Reg) & 0x3ff
}
func (o *SCT2_Type) SetOUT5_SET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.OUT5_SET.Reg, volatile.LoadUint32(&o.OUT5_SET.Reg)&^(0xfffffc00)|value<<10)
}
func (o *SCT2_Type) GetOUT5_SET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.OUT5_SET.Reg) & 0xfffffc00) >> 10
}

// SCT2.OUT5_CLR: SCT output 0 clear register
func (o *SCT2_Type) SetOUT5_CLR_CLR(value uint32) {
	volatile.StoreUint32(&o.OUT5_CLR.Reg, volatile.LoadUint32(&o.OUT5_CLR.Reg)&^(0x3ff)|value)
}
func (o *SCT2_Type) GetOUT5_CLR_CLR() uint32 {
	return volatile.LoadUint32(&o.OUT5_CLR.Reg) & 0x3ff
}
func (o *SCT2_Type) SetOUT5_CLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.OUT5_CLR.Reg, volatile.LoadUint32(&o.OUT5_CLR.Reg)&^(0xfffffc00)|value<<10)
}
func (o *SCT2_Type) GetOUT5_CLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.OUT5_CLR.Reg) & 0xfffffc00) >> 10
}

// 12-bit ADC controller ADC0/1
type ADC_Type struct {
	CTRL        volatile.Register32 // 0x0
	INSEL       volatile.Register32 // 0x4
	SEQA_CTRL   volatile.Register32 // 0x8
	SEQB_CTRL   volatile.Register32 // 0xC
	SEQA_GDAT   volatile.Register32 // 0x10
	SEQB_GDAT   volatile.Register32 // 0x14
	_           [8]byte
	DAT         [12]volatile.Register32 // 0x20
	THR0_LOW    volatile.Register32     // 0x50
	THR1_LOW    volatile.Register32     // 0x54
	THR0_HIGH   volatile.Register32     // 0x58
	THR1_HIGH   volatile.Register32     // 0x5C
	CHAN_THRSEL volatile.Register32     // 0x60
	INTEN       volatile.Register32     // 0x64
	FLAGS       volatile.Register32     // 0x68
	TRM         volatile.Register32     // 0x6C
}

// ADC.CTRL: A/D Control Register. Contains the clock divide value, enable bits for each sequence and the A/D power-down bit.
func (o *ADC_Type) SetCTRL_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0xff)|value)
}
func (o *ADC_Type) GetCTRL_CLKDIV() uint32 {
	return volatile.LoadUint32(&o.CTRL.Reg) & 0xff
}
func (o *ADC_Type) SetCTRL_ASYNMODE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetCTRL_ASYNMODE() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetCTRL_MODE10BIT(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetCTRL_MODE10BIT() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetCTRL_LPWRMODE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetCTRL_LPWRMODE() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x3ffff800)|value<<11)
}
func (o *ADC_Type) GetCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x3ffff800) >> 11
}
func (o *ADC_Type) SetCTRL_CALMODE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x40000000)|value<<30)
}
func (o *ADC_Type) GetCTRL_CALMODE() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x40000000) >> 30
}
func (o *ADC_Type) SetCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x80000000)|value<<31)
}
func (o *ADC_Type) GetCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x80000000) >> 31
}

// ADC.INSEL: A/D Input Select Register: Selects between external pin and internal source for various channels
func (o *ADC_Type) SetINSEL_AD0SEL(value uint32) {
	volatile.StoreUint32(&o.INSEL.Reg, volatile.LoadUint32(&o.INSEL.Reg)&^(0xf)|value)
}
func (o *ADC_Type) GetINSEL_AD0SEL() uint32 {
	return volatile.LoadUint32(&o.INSEL.Reg) & 0xf
}
func (o *ADC_Type) SetINSEL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INSEL.Reg, volatile.LoadUint32(&o.INSEL.Reg)&^(0x3ffffff0)|value<<4)
}
func (o *ADC_Type) GetINSEL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INSEL.Reg) & 0x3ffffff0) >> 4
}
func (o *ADC_Type) SetINSEL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INSEL.Reg, volatile.LoadUint32(&o.INSEL.Reg)&^(0xc0000000)|value<<30)
}
func (o *ADC_Type) GetINSEL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INSEL.Reg) & 0xc0000000) >> 30
}

// ADC.SEQA_CTRL: A/D Conversion Sequence-A control Register: Controls triggering and channel selection for conversion sequence-A. Also specifies interrupt mode for sequence-A.
func (o *ADC_Type) SetSEQA_CTRL_CHANNELS(value uint32) {
	volatile.StoreUint32(&o.SEQA_CTRL.Reg, volatile.LoadUint32(&o.SEQA_CTRL.Reg)&^(0xfff)|value)
}
func (o *ADC_Type) GetSEQA_CTRL_CHANNELS() uint32 {
	return volatile.LoadUint32(&o.SEQA_CTRL.Reg) & 0xfff
}
func (o *ADC_Type) SetSEQA_CTRL_TRIGGER(value uint32) {
	volatile.StoreUint32(&o.SEQA_CTRL.Reg, volatile.LoadUint32(&o.SEQA_CTRL.Reg)&^(0xf000)|value<<12)
}
func (o *ADC_Type) GetSEQA_CTRL_TRIGGER() uint32 {
	return (volatile.LoadUint32(&o.SEQA_CTRL.Reg) & 0xf000) >> 12
}
func (o *ADC_Type) SetSEQA_CTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SEQA_CTRL.Reg, volatile.LoadUint32(&o.SEQA_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *ADC_Type) GetSEQA_CTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SEQA_CTRL.Reg) & 0x30000) >> 16
}
func (o *ADC_Type) SetSEQA_CTRL_TRIGPOL(value uint32) {
	volatile.StoreUint32(&o.SEQA_CTRL.Reg, volatile.LoadUint32(&o.SEQA_CTRL.Reg)&^(0x40000)|value<<18)
}
func (o *ADC_Type) GetSEQA_CTRL_TRIGPOL() uint32 {
	return (volatile.LoadUint32(&o.SEQA_CTRL.Reg) & 0x40000) >> 18
}
func (o *ADC_Type) SetSEQA_CTRL_SYNCBYPASS(value uint32) {
	volatile.StoreUint32(&o.SEQA_CTRL.Reg, volatile.LoadUint32(&o.SEQA_CTRL.Reg)&^(0x80000)|value<<19)
}
func (o *ADC_Type) GetSEQA_CTRL_SYNCBYPASS() uint32 {
	return (volatile.LoadUint32(&o.SEQA_CTRL.Reg) & 0x80000) >> 19
}
func (o *ADC_Type) SetSEQA_CTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SEQA_CTRL.Reg, volatile.LoadUint32(&o.SEQA_CTRL.Reg)&^(0x3f00000)|value<<20)
}
func (o *ADC_Type) GetSEQA_CTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SEQA_CTRL.Reg) & 0x3f00000) >> 20
}
func (o *ADC_Type) SetSEQA_CTRL_START(value uint32) {
	volatile.StoreUint32(&o.SEQA_CTRL.Reg, volatile.LoadUint32(&o.SEQA_CTRL.Reg)&^(0x4000000)|value<<26)
}
func (o *ADC_Type) GetSEQA_CTRL_START() uint32 {
	return (volatile.LoadUint32(&o.SEQA_CTRL.Reg) & 0x4000000) >> 26
}
func (o *ADC_Type) SetSEQA_CTRL_BURST(value uint32) {
	volatile.StoreUint32(&o.SEQA_CTRL.Reg, volatile.LoadUint32(&o.SEQA_CTRL.Reg)&^(0x8000000)|value<<27)
}
func (o *ADC_Type) GetSEQA_CTRL_BURST() uint32 {
	return (volatile.LoadUint32(&o.SEQA_CTRL.Reg) & 0x8000000) >> 27
}
func (o *ADC_Type) SetSEQA_CTRL_SINGLESTEP(value uint32) {
	volatile.StoreUint32(&o.SEQA_CTRL.Reg, volatile.LoadUint32(&o.SEQA_CTRL.Reg)&^(0x10000000)|value<<28)
}
func (o *ADC_Type) GetSEQA_CTRL_SINGLESTEP() uint32 {
	return (volatile.LoadUint32(&o.SEQA_CTRL.Reg) & 0x10000000) >> 28
}
func (o *ADC_Type) SetSEQA_CTRL_LOWPRIO(value uint32) {
	volatile.StoreUint32(&o.SEQA_CTRL.Reg, volatile.LoadUint32(&o.SEQA_CTRL.Reg)&^(0x20000000)|value<<29)
}
func (o *ADC_Type) GetSEQA_CTRL_LOWPRIO() uint32 {
	return (volatile.LoadUint32(&o.SEQA_CTRL.Reg) & 0x20000000) >> 29
}
func (o *ADC_Type) SetSEQA_CTRL_MODE(value uint32) {
	volatile.StoreUint32(&o.SEQA_CTRL.Reg, volatile.LoadUint32(&o.SEQA_CTRL.Reg)&^(0x40000000)|value<<30)
}
func (o *ADC_Type) GetSEQA_CTRL_MODE() uint32 {
	return (volatile.LoadUint32(&o.SEQA_CTRL.Reg) & 0x40000000) >> 30
}
func (o *ADC_Type) SetSEQA_CTRL_SEQA_ENA(value uint32) {
	volatile.StoreUint32(&o.SEQA_CTRL.Reg, volatile.LoadUint32(&o.SEQA_CTRL.Reg)&^(0x80000000)|value<<31)
}
func (o *ADC_Type) GetSEQA_CTRL_SEQA_ENA() uint32 {
	return (volatile.LoadUint32(&o.SEQA_CTRL.Reg) & 0x80000000) >> 31
}

// ADC.SEQB_CTRL: A/D Conversion Sequence-B Control Register: Controls triggering and channel selection for conversion sequence-B. Also specifies interrupt mode for sequence-B.
func (o *ADC_Type) SetSEQB_CTRL_CHANNELS(value uint32) {
	volatile.StoreUint32(&o.SEQB_CTRL.Reg, volatile.LoadUint32(&o.SEQB_CTRL.Reg)&^(0xfff)|value)
}
func (o *ADC_Type) GetSEQB_CTRL_CHANNELS() uint32 {
	return volatile.LoadUint32(&o.SEQB_CTRL.Reg) & 0xfff
}
func (o *ADC_Type) SetSEQB_CTRL_TRIGGER(value uint32) {
	volatile.StoreUint32(&o.SEQB_CTRL.Reg, volatile.LoadUint32(&o.SEQB_CTRL.Reg)&^(0xf000)|value<<12)
}
func (o *ADC_Type) GetSEQB_CTRL_TRIGGER() uint32 {
	return (volatile.LoadUint32(&o.SEQB_CTRL.Reg) & 0xf000) >> 12
}
func (o *ADC_Type) SetSEQB_CTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SEQB_CTRL.Reg, volatile.LoadUint32(&o.SEQB_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *ADC_Type) GetSEQB_CTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SEQB_CTRL.Reg) & 0x30000) >> 16
}
func (o *ADC_Type) SetSEQB_CTRL_TRIGPOL(value uint32) {
	volatile.StoreUint32(&o.SEQB_CTRL.Reg, volatile.LoadUint32(&o.SEQB_CTRL.Reg)&^(0x40000)|value<<18)
}
func (o *ADC_Type) GetSEQB_CTRL_TRIGPOL() uint32 {
	return (volatile.LoadUint32(&o.SEQB_CTRL.Reg) & 0x40000) >> 18
}
func (o *ADC_Type) SetSEQB_CTRL_SYNCBYPASS(value uint32) {
	volatile.StoreUint32(&o.SEQB_CTRL.Reg, volatile.LoadUint32(&o.SEQB_CTRL.Reg)&^(0x80000)|value<<19)
}
func (o *ADC_Type) GetSEQB_CTRL_SYNCBYPASS() uint32 {
	return (volatile.LoadUint32(&o.SEQB_CTRL.Reg) & 0x80000) >> 19
}
func (o *ADC_Type) SetSEQB_CTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SEQB_CTRL.Reg, volatile.LoadUint32(&o.SEQB_CTRL.Reg)&^(0x3f00000)|value<<20)
}
func (o *ADC_Type) GetSEQB_CTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SEQB_CTRL.Reg) & 0x3f00000) >> 20
}
func (o *ADC_Type) SetSEQB_CTRL_START(value uint32) {
	volatile.StoreUint32(&o.SEQB_CTRL.Reg, volatile.LoadUint32(&o.SEQB_CTRL.Reg)&^(0x4000000)|value<<26)
}
func (o *ADC_Type) GetSEQB_CTRL_START() uint32 {
	return (volatile.LoadUint32(&o.SEQB_CTRL.Reg) & 0x4000000) >> 26
}
func (o *ADC_Type) SetSEQB_CTRL_BURST(value uint32) {
	volatile.StoreUint32(&o.SEQB_CTRL.Reg, volatile.LoadUint32(&o.SEQB_CTRL.Reg)&^(0x8000000)|value<<27)
}
func (o *ADC_Type) GetSEQB_CTRL_BURST() uint32 {
	return (volatile.LoadUint32(&o.SEQB_CTRL.Reg) & 0x8000000) >> 27
}
func (o *ADC_Type) SetSEQB_CTRL_SINGLESTEP(value uint32) {
	volatile.StoreUint32(&o.SEQB_CTRL.Reg, volatile.LoadUint32(&o.SEQB_CTRL.Reg)&^(0x10000000)|value<<28)
}
func (o *ADC_Type) GetSEQB_CTRL_SINGLESTEP() uint32 {
	return (volatile.LoadUint32(&o.SEQB_CTRL.Reg) & 0x10000000) >> 28
}
func (o *ADC_Type) SetSEQB_CTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SEQB_CTRL.Reg, volatile.LoadUint32(&o.SEQB_CTRL.Reg)&^(0x20000000)|value<<29)
}
func (o *ADC_Type) GetSEQB_CTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SEQB_CTRL.Reg) & 0x20000000) >> 29
}
func (o *ADC_Type) SetSEQB_CTRL_MODE(value uint32) {
	volatile.StoreUint32(&o.SEQB_CTRL.Reg, volatile.LoadUint32(&o.SEQB_CTRL.Reg)&^(0x40000000)|value<<30)
}
func (o *ADC_Type) GetSEQB_CTRL_MODE() uint32 {
	return (volatile.LoadUint32(&o.SEQB_CTRL.Reg) & 0x40000000) >> 30
}
func (o *ADC_Type) SetSEQB_CTRL_SEQB_ENA(value uint32) {
	volatile.StoreUint32(&o.SEQB_CTRL.Reg, volatile.LoadUint32(&o.SEQB_CTRL.Reg)&^(0x80000000)|value<<31)
}
func (o *ADC_Type) GetSEQB_CTRL_SEQB_ENA() uint32 {
	return (volatile.LoadUint32(&o.SEQB_CTRL.Reg) & 0x80000000) >> 31
}

// ADC.SEQA_GDAT: A/D Sequence-A Global Data Register. This register contains the result of the most recent A/D conversion performed under sequence-A
func (o *ADC_Type) SetSEQA_GDAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SEQA_GDAT.Reg, volatile.LoadUint32(&o.SEQA_GDAT.Reg)&^(0xf)|value)
}
func (o *ADC_Type) GetSEQA_GDAT_RESERVED() uint32 {
	return volatile.LoadUint32(&o.SEQA_GDAT.Reg) & 0xf
}
func (o *ADC_Type) SetSEQA_GDAT_RESULT(value uint32) {
	volatile.StoreUint32(&o.SEQA_GDAT.Reg, volatile.LoadUint32(&o.SEQA_GDAT.Reg)&^(0xfff0)|value<<4)
}
func (o *ADC_Type) GetSEQA_GDAT_RESULT() uint32 {
	return (volatile.LoadUint32(&o.SEQA_GDAT.Reg) & 0xfff0) >> 4
}
func (o *ADC_Type) SetSEQA_GDAT_THCMPRANGE(value uint32) {
	volatile.StoreUint32(&o.SEQA_GDAT.Reg, volatile.LoadUint32(&o.SEQA_GDAT.Reg)&^(0x30000)|value<<16)
}
func (o *ADC_Type) GetSEQA_GDAT_THCMPRANGE() uint32 {
	return (volatile.LoadUint32(&o.SEQA_GDAT.Reg) & 0x30000) >> 16
}
func (o *ADC_Type) SetSEQA_GDAT_THCMPCROSS(value uint32) {
	volatile.StoreUint32(&o.SEQA_GDAT.Reg, volatile.LoadUint32(&o.SEQA_GDAT.Reg)&^(0xc0000)|value<<18)
}
func (o *ADC_Type) GetSEQA_GDAT_THCMPCROSS() uint32 {
	return (volatile.LoadUint32(&o.SEQA_GDAT.Reg) & 0xc0000) >> 18
}
func (o *ADC_Type) SetSEQA_GDAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SEQA_GDAT.Reg, volatile.LoadUint32(&o.SEQA_GDAT.Reg)&^(0x3f00000)|value<<20)
}
func (o *ADC_Type) GetSEQA_GDAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SEQA_GDAT.Reg) & 0x3f00000) >> 20
}
func (o *ADC_Type) SetSEQA_GDAT_CHN(value uint32) {
	volatile.StoreUint32(&o.SEQA_GDAT.Reg, volatile.LoadUint32(&o.SEQA_GDAT.Reg)&^(0x3c000000)|value<<26)
}
func (o *ADC_Type) GetSEQA_GDAT_CHN() uint32 {
	return (volatile.LoadUint32(&o.SEQA_GDAT.Reg) & 0x3c000000) >> 26
}
func (o *ADC_Type) SetSEQA_GDAT_OVERRUN(value uint32) {
	volatile.StoreUint32(&o.SEQA_GDAT.Reg, volatile.LoadUint32(&o.SEQA_GDAT.Reg)&^(0x40000000)|value<<30)
}
func (o *ADC_Type) GetSEQA_GDAT_OVERRUN() uint32 {
	return (volatile.LoadUint32(&o.SEQA_GDAT.Reg) & 0x40000000) >> 30
}
func (o *ADC_Type) SetSEQA_GDAT_DATAVALID(value uint32) {
	volatile.StoreUint32(&o.SEQA_GDAT.Reg, volatile.LoadUint32(&o.SEQA_GDAT.Reg)&^(0x80000000)|value<<31)
}
func (o *ADC_Type) GetSEQA_GDAT_DATAVALID() uint32 {
	return (volatile.LoadUint32(&o.SEQA_GDAT.Reg) & 0x80000000) >> 31
}

// ADC.SEQB_GDAT: A/D Sequence-B Global Data Register. This register contains the result of the most recent A/D conversion performed under sequence-B
func (o *ADC_Type) SetSEQB_GDAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SEQB_GDAT.Reg, volatile.LoadUint32(&o.SEQB_GDAT.Reg)&^(0xf)|value)
}
func (o *ADC_Type) GetSEQB_GDAT_RESERVED() uint32 {
	return volatile.LoadUint32(&o.SEQB_GDAT.Reg) & 0xf
}
func (o *ADC_Type) SetSEQB_GDAT_RESULT(value uint32) {
	volatile.StoreUint32(&o.SEQB_GDAT.Reg, volatile.LoadUint32(&o.SEQB_GDAT.Reg)&^(0xfff0)|value<<4)
}
func (o *ADC_Type) GetSEQB_GDAT_RESULT() uint32 {
	return (volatile.LoadUint32(&o.SEQB_GDAT.Reg) & 0xfff0) >> 4
}
func (o *ADC_Type) SetSEQB_GDAT_THCMPRANGE(value uint32) {
	volatile.StoreUint32(&o.SEQB_GDAT.Reg, volatile.LoadUint32(&o.SEQB_GDAT.Reg)&^(0x30000)|value<<16)
}
func (o *ADC_Type) GetSEQB_GDAT_THCMPRANGE() uint32 {
	return (volatile.LoadUint32(&o.SEQB_GDAT.Reg) & 0x30000) >> 16
}
func (o *ADC_Type) SetSEQB_GDAT_THCMPCROSS(value uint32) {
	volatile.StoreUint32(&o.SEQB_GDAT.Reg, volatile.LoadUint32(&o.SEQB_GDAT.Reg)&^(0xc0000)|value<<18)
}
func (o *ADC_Type) GetSEQB_GDAT_THCMPCROSS() uint32 {
	return (volatile.LoadUint32(&o.SEQB_GDAT.Reg) & 0xc0000) >> 18
}
func (o *ADC_Type) SetSEQB_GDAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SEQB_GDAT.Reg, volatile.LoadUint32(&o.SEQB_GDAT.Reg)&^(0x3f00000)|value<<20)
}
func (o *ADC_Type) GetSEQB_GDAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SEQB_GDAT.Reg) & 0x3f00000) >> 20
}
func (o *ADC_Type) SetSEQB_GDAT_CHN(value uint32) {
	volatile.StoreUint32(&o.SEQB_GDAT.Reg, volatile.LoadUint32(&o.SEQB_GDAT.Reg)&^(0x3c000000)|value<<26)
}
func (o *ADC_Type) GetSEQB_GDAT_CHN() uint32 {
	return (volatile.LoadUint32(&o.SEQB_GDAT.Reg) & 0x3c000000) >> 26
}
func (o *ADC_Type) SetSEQB_GDAT_OVERRUN(value uint32) {
	volatile.StoreUint32(&o.SEQB_GDAT.Reg, volatile.LoadUint32(&o.SEQB_GDAT.Reg)&^(0x40000000)|value<<30)
}
func (o *ADC_Type) GetSEQB_GDAT_OVERRUN() uint32 {
	return (volatile.LoadUint32(&o.SEQB_GDAT.Reg) & 0x40000000) >> 30
}
func (o *ADC_Type) SetSEQB_GDAT_DATAVALID(value uint32) {
	volatile.StoreUint32(&o.SEQB_GDAT.Reg, volatile.LoadUint32(&o.SEQB_GDAT.Reg)&^(0x80000000)|value<<31)
}
func (o *ADC_Type) GetSEQB_GDAT_DATAVALID() uint32 {
	return (volatile.LoadUint32(&o.SEQB_GDAT.Reg) & 0x80000000) >> 31
}

// ADC.DAT: A/D Channel 0 Data Register. This register contains the result of the most recent conversion completed on channel 0.
func (o *ADC_Type) SetDAT_RESERVED(idx int, value uint32) {
	volatile.StoreUint32(&o.DAT[idx].Reg, volatile.LoadUint32(&o.DAT[idx].Reg)&^(0xf)|value)
}
func (o *ADC_Type) GetDAT_RESERVED(idx int) uint32 {
	return volatile.LoadUint32(&o.DAT[idx].Reg) & 0xf
}
func (o *ADC_Type) SetDAT_RESULT(idx int, value uint32) {
	volatile.StoreUint32(&o.DAT[idx].Reg, volatile.LoadUint32(&o.DAT[idx].Reg)&^(0xfff0)|value<<4)
}
func (o *ADC_Type) GetDAT_RESULT(idx int) uint32 {
	return (volatile.LoadUint32(&o.DAT[idx].Reg) & 0xfff0) >> 4
}
func (o *ADC_Type) SetDAT_THCMPRANGE(idx int, value uint32) {
	volatile.StoreUint32(&o.DAT[idx].Reg, volatile.LoadUint32(&o.DAT[idx].Reg)&^(0x30000)|value<<16)
}
func (o *ADC_Type) GetDAT_THCMPRANGE(idx int) uint32 {
	return (volatile.LoadUint32(&o.DAT[idx].Reg) & 0x30000) >> 16
}
func (o *ADC_Type) SetDAT_THCMPCROSS(idx int, value uint32) {
	volatile.StoreUint32(&o.DAT[idx].Reg, volatile.LoadUint32(&o.DAT[idx].Reg)&^(0xc0000)|value<<18)
}
func (o *ADC_Type) GetDAT_THCMPCROSS(idx int) uint32 {
	return (volatile.LoadUint32(&o.DAT[idx].Reg) & 0xc0000) >> 18
}
func (o *ADC_Type) SetDAT_RESERVED(idx int, value uint32) {
	volatile.StoreUint32(&o.DAT[idx].Reg, volatile.LoadUint32(&o.DAT[idx].Reg)&^(0x3f00000)|value<<20)
}
func (o *ADC_Type) GetDAT_RESERVED(idx int) uint32 {
	return (volatile.LoadUint32(&o.DAT[idx].Reg) & 0x3f00000) >> 20
}
func (o *ADC_Type) SetDAT_CHANNEL(idx int, value uint32) {
	volatile.StoreUint32(&o.DAT[idx].Reg, volatile.LoadUint32(&o.DAT[idx].Reg)&^(0x3c000000)|value<<26)
}
func (o *ADC_Type) GetDAT_CHANNEL(idx int) uint32 {
	return (volatile.LoadUint32(&o.DAT[idx].Reg) & 0x3c000000) >> 26
}
func (o *ADC_Type) SetDAT_OVERRUN(idx int, value uint32) {
	volatile.StoreUint32(&o.DAT[idx].Reg, volatile.LoadUint32(&o.DAT[idx].Reg)&^(0x40000000)|value<<30)
}
func (o *ADC_Type) GetDAT_OVERRUN(idx int) uint32 {
	return (volatile.LoadUint32(&o.DAT[idx].Reg) & 0x40000000) >> 30
}
func (o *ADC_Type) SetDAT_DATAVALID(idx int, value uint32) {
	volatile.StoreUint32(&o.DAT[idx].Reg, volatile.LoadUint32(&o.DAT[idx].Reg)&^(0x80000000)|value<<31)
}
func (o *ADC_Type) GetDAT_DATAVALID(idx int) uint32 {
	return (volatile.LoadUint32(&o.DAT[idx].Reg) & 0x80000000) >> 31
}

// ADC.THR0_LOW: A/D Low Compare Threshold Register 0 : Contains the lower threshold level for automatic threshold comparison for any channels linked to threshold pair 0.
func (o *ADC_Type) SetTHR0_LOW_RESERVED(value uint32) {
	volatile.StoreUint32(&o.THR0_LOW.Reg, volatile.LoadUint32(&o.THR0_LOW.Reg)&^(0xf)|value)
}
func (o *ADC_Type) GetTHR0_LOW_RESERVED() uint32 {
	return volatile.LoadUint32(&o.THR0_LOW.Reg) & 0xf
}
func (o *ADC_Type) SetTHR0_LOW_THRLOW(value uint32) {
	volatile.StoreUint32(&o.THR0_LOW.Reg, volatile.LoadUint32(&o.THR0_LOW.Reg)&^(0xfff0)|value<<4)
}
func (o *ADC_Type) GetTHR0_LOW_THRLOW() uint32 {
	return (volatile.LoadUint32(&o.THR0_LOW.Reg) & 0xfff0) >> 4
}
func (o *ADC_Type) SetTHR0_LOW_RESERVED(value uint32) {
	volatile.StoreUint32(&o.THR0_LOW.Reg, volatile.LoadUint32(&o.THR0_LOW.Reg)&^(0xffff0000)|value<<16)
}
func (o *ADC_Type) GetTHR0_LOW_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.THR0_LOW.Reg) & 0xffff0000) >> 16
}

// ADC.THR1_LOW: A/D Low Compare Threshold Register 1: Contains the lower threshold level for automatic threshold comparison for any channels linked to threshold pair 1.
func (o *ADC_Type) SetTHR1_LOW_RESERVED(value uint32) {
	volatile.StoreUint32(&o.THR1_LOW.Reg, volatile.LoadUint32(&o.THR1_LOW.Reg)&^(0xf)|value)
}
func (o *ADC_Type) GetTHR1_LOW_RESERVED() uint32 {
	return volatile.LoadUint32(&o.THR1_LOW.Reg) & 0xf
}
func (o *ADC_Type) SetTHR1_LOW_THRLOW(value uint32) {
	volatile.StoreUint32(&o.THR1_LOW.Reg, volatile.LoadUint32(&o.THR1_LOW.Reg)&^(0xfff0)|value<<4)
}
func (o *ADC_Type) GetTHR1_LOW_THRLOW() uint32 {
	return (volatile.LoadUint32(&o.THR1_LOW.Reg) & 0xfff0) >> 4
}
func (o *ADC_Type) SetTHR1_LOW_RESERVED(value uint32) {
	volatile.StoreUint32(&o.THR1_LOW.Reg, volatile.LoadUint32(&o.THR1_LOW.Reg)&^(0xffff0000)|value<<16)
}
func (o *ADC_Type) GetTHR1_LOW_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.THR1_LOW.Reg) & 0xffff0000) >> 16
}

// ADC.THR0_HIGH: A/D High Compare Threshold Register 0: Contains the upper threshold level for automatic threshold comparison for any channels linked to threshold pair 0.
func (o *ADC_Type) SetTHR0_HIGH_RESERVED(value uint32) {
	volatile.StoreUint32(&o.THR0_HIGH.Reg, volatile.LoadUint32(&o.THR0_HIGH.Reg)&^(0xf)|value)
}
func (o *ADC_Type) GetTHR0_HIGH_RESERVED() uint32 {
	return volatile.LoadUint32(&o.THR0_HIGH.Reg) & 0xf
}
func (o *ADC_Type) SetTHR0_HIGH_THRHIGH(value uint32) {
	volatile.StoreUint32(&o.THR0_HIGH.Reg, volatile.LoadUint32(&o.THR0_HIGH.Reg)&^(0xfff0)|value<<4)
}
func (o *ADC_Type) GetTHR0_HIGH_THRHIGH() uint32 {
	return (volatile.LoadUint32(&o.THR0_HIGH.Reg) & 0xfff0) >> 4
}
func (o *ADC_Type) SetTHR0_HIGH_RESERVED(value uint32) {
	volatile.StoreUint32(&o.THR0_HIGH.Reg, volatile.LoadUint32(&o.THR0_HIGH.Reg)&^(0xffff0000)|value<<16)
}
func (o *ADC_Type) GetTHR0_HIGH_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.THR0_HIGH.Reg) & 0xffff0000) >> 16
}

// ADC.THR1_HIGH: A/D High Compare Threshold Register 1: Contains the upper threshold level for automatic threshold comparison for any channels linked to threshold pair 1.
func (o *ADC_Type) SetTHR1_HIGH_RESERVED(value uint32) {
	volatile.StoreUint32(&o.THR1_HIGH.Reg, volatile.LoadUint32(&o.THR1_HIGH.Reg)&^(0xf)|value)
}
func (o *ADC_Type) GetTHR1_HIGH_RESERVED() uint32 {
	return volatile.LoadUint32(&o.THR1_HIGH.Reg) & 0xf
}
func (o *ADC_Type) SetTHR1_HIGH_THRHIGH(value uint32) {
	volatile.StoreUint32(&o.THR1_HIGH.Reg, volatile.LoadUint32(&o.THR1_HIGH.Reg)&^(0xfff0)|value<<4)
}
func (o *ADC_Type) GetTHR1_HIGH_THRHIGH() uint32 {
	return (volatile.LoadUint32(&o.THR1_HIGH.Reg) & 0xfff0) >> 4
}
func (o *ADC_Type) SetTHR1_HIGH_RESERVED(value uint32) {
	volatile.StoreUint32(&o.THR1_HIGH.Reg, volatile.LoadUint32(&o.THR1_HIGH.Reg)&^(0xffff0000)|value<<16)
}
func (o *ADC_Type) GetTHR1_HIGH_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.THR1_HIGH.Reg) & 0xffff0000) >> 16
}

// ADC.CHAN_THRSEL: A/D Channel-Threshold Select Register. Specifies which set of threshold compare registers are to be used for each channel
func (o *ADC_Type) SetCHAN_THRSEL_CH0_THRSEL(value uint32) {
	volatile.StoreUint32(&o.CHAN_THRSEL.Reg, volatile.LoadUint32(&o.CHAN_THRSEL.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetCHAN_THRSEL_CH0_THRSEL() uint32 {
	return volatile.LoadUint32(&o.CHAN_THRSEL.Reg) & 0x1
}
func (o *ADC_Type) SetCHAN_THRSEL_CH1_THRSEL(value uint32) {
	volatile.StoreUint32(&o.CHAN_THRSEL.Reg, volatile.LoadUint32(&o.CHAN_THRSEL.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetCHAN_THRSEL_CH1_THRSEL() uint32 {
	return (volatile.LoadUint32(&o.CHAN_THRSEL.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetCHAN_THRSEL_CH2_THRSEL(value uint32) {
	volatile.StoreUint32(&o.CHAN_THRSEL.Reg, volatile.LoadUint32(&o.CHAN_THRSEL.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetCHAN_THRSEL_CH2_THRSEL() uint32 {
	return (volatile.LoadUint32(&o.CHAN_THRSEL.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetCHAN_THRSEL_CH3_THRSEL(value uint32) {
	volatile.StoreUint32(&o.CHAN_THRSEL.Reg, volatile.LoadUint32(&o.CHAN_THRSEL.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetCHAN_THRSEL_CH3_THRSEL() uint32 {
	return (volatile.LoadUint32(&o.CHAN_THRSEL.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetCHAN_THRSEL_CH4_THRSEL(value uint32) {
	volatile.StoreUint32(&o.CHAN_THRSEL.Reg, volatile.LoadUint32(&o.CHAN_THRSEL.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetCHAN_THRSEL_CH4_THRSEL() uint32 {
	return (volatile.LoadUint32(&o.CHAN_THRSEL.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetCHAN_THRSEL_CH5_THRSEL(value uint32) {
	volatile.StoreUint32(&o.CHAN_THRSEL.Reg, volatile.LoadUint32(&o.CHAN_THRSEL.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetCHAN_THRSEL_CH5_THRSEL() uint32 {
	return (volatile.LoadUint32(&o.CHAN_THRSEL.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetCHAN_THRSEL_CH6_THRSEL(value uint32) {
	volatile.StoreUint32(&o.CHAN_THRSEL.Reg, volatile.LoadUint32(&o.CHAN_THRSEL.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetCHAN_THRSEL_CH6_THRSEL() uint32 {
	return (volatile.LoadUint32(&o.CHAN_THRSEL.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetCHAN_THRSEL_CH7_THRSEL(value uint32) {
	volatile.StoreUint32(&o.CHAN_THRSEL.Reg, volatile.LoadUint32(&o.CHAN_THRSEL.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetCHAN_THRSEL_CH7_THRSEL() uint32 {
	return (volatile.LoadUint32(&o.CHAN_THRSEL.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetCHAN_THRSEL_CH8_THRSEL(value uint32) {
	volatile.StoreUint32(&o.CHAN_THRSEL.Reg, volatile.LoadUint32(&o.CHAN_THRSEL.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetCHAN_THRSEL_CH8_THRSEL() uint32 {
	return (volatile.LoadUint32(&o.CHAN_THRSEL.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetCHAN_THRSEL_CH9_THRSEL(value uint32) {
	volatile.StoreUint32(&o.CHAN_THRSEL.Reg, volatile.LoadUint32(&o.CHAN_THRSEL.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetCHAN_THRSEL_CH9_THRSEL() uint32 {
	return (volatile.LoadUint32(&o.CHAN_THRSEL.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetCHAN_THRSEL_CH10_THRSEL(value uint32) {
	volatile.StoreUint32(&o.CHAN_THRSEL.Reg, volatile.LoadUint32(&o.CHAN_THRSEL.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetCHAN_THRSEL_CH10_THRSEL() uint32 {
	return (volatile.LoadUint32(&o.CHAN_THRSEL.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetCHAN_THRSEL_CH11_THRSEL(value uint32) {
	volatile.StoreUint32(&o.CHAN_THRSEL.Reg, volatile.LoadUint32(&o.CHAN_THRSEL.Reg)&^(0x800)|value<<11)
}
func (o *ADC_Type) GetCHAN_THRSEL_CH11_THRSEL() uint32 {
	return (volatile.LoadUint32(&o.CHAN_THRSEL.Reg) & 0x800) >> 11
}
func (o *ADC_Type) SetCHAN_THRSEL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CHAN_THRSEL.Reg, volatile.LoadUint32(&o.CHAN_THRSEL.Reg)&^(0xfffff000)|value<<12)
}
func (o *ADC_Type) GetCHAN_THRSEL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CHAN_THRSEL.Reg) & 0xfffff000) >> 12
}

// ADC.INTEN: A/D Interrupt Enable Register. This register contains enable bits that enable the sequence-A, sequence-B, threshold compare and data overrun interrupts to be generated.
func (o *ADC_Type) SetINTEN_SEQA_INTEN(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetINTEN_SEQA_INTEN() uint32 {
	return volatile.LoadUint32(&o.INTEN.Reg) & 0x1
}
func (o *ADC_Type) SetINTEN_SEQB_INTEN(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetINTEN_SEQB_INTEN() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetINTEN_OVR_INTEN(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetINTEN_OVR_INTEN() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetINTEN_ADCMPINTEN0(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x18)|value<<3)
}
func (o *ADC_Type) GetINTEN_ADCMPINTEN0() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x18) >> 3
}
func (o *ADC_Type) SetINTEN_ADCMPINTEN1(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x60)|value<<5)
}
func (o *ADC_Type) GetINTEN_ADCMPINTEN1() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x60) >> 5
}
func (o *ADC_Type) SetINTEN_ADCMPINTEN2(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x180)|value<<7)
}
func (o *ADC_Type) GetINTEN_ADCMPINTEN2() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x180) >> 7
}
func (o *ADC_Type) SetINTEN_ADCMPINTEN3(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x600)|value<<9)
}
func (o *ADC_Type) GetINTEN_ADCMPINTEN3() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x600) >> 9
}
func (o *ADC_Type) SetINTEN_ADCMPINTEN4(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x1800)|value<<11)
}
func (o *ADC_Type) GetINTEN_ADCMPINTEN4() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x1800) >> 11
}
func (o *ADC_Type) SetINTEN_ADCMPINTEN5(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x6000)|value<<13)
}
func (o *ADC_Type) GetINTEN_ADCMPINTEN5() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x6000) >> 13
}
func (o *ADC_Type) SetINTEN_ADCMPINTEN6(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x18000)|value<<15)
}
func (o *ADC_Type) GetINTEN_ADCMPINTEN6() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x18000) >> 15
}
func (o *ADC_Type) SetINTEN_ADCMPINTEN7(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x60000)|value<<17)
}
func (o *ADC_Type) GetINTEN_ADCMPINTEN7() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x60000) >> 17
}
func (o *ADC_Type) SetINTEN_ADCMPINTEN8(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x180000)|value<<19)
}
func (o *ADC_Type) GetINTEN_ADCMPINTEN8() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x180000) >> 19
}
func (o *ADC_Type) SetINTEN_ADCMPINTEN9(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x600000)|value<<21)
}
func (o *ADC_Type) GetINTEN_ADCMPINTEN9() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x600000) >> 21
}
func (o *ADC_Type) SetINTEN_ADCMPINTEN10(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x1800000)|value<<23)
}
func (o *ADC_Type) GetINTEN_ADCMPINTEN10() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x1800000) >> 23
}
func (o *ADC_Type) SetINTEN_ADCMPINTEN11(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x6000000)|value<<25)
}
func (o *ADC_Type) GetINTEN_ADCMPINTEN11() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x6000000) >> 25
}
func (o *ADC_Type) SetINTEN_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0xf8000000)|value<<27)
}
func (o *ADC_Type) GetINTEN_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0xf8000000) >> 27
}

// ADC.FLAGS: A/D Flags Register. Contains the four interrupt request flags and the individual component overrun and threshold-compare flags. (The overrun bits replicate information stored in the result registers).
func (o *ADC_Type) SetFLAGS_THCMP0(value uint32) {
	volatile.StoreUint32(&o.FLAGS.Reg, volatile.LoadUint32(&o.FLAGS.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetFLAGS_THCMP0() uint32 {
	return volatile.LoadUint32(&o.FLAGS.Reg) & 0x1
}
func (o *ADC_Type) SetFLAGS_THCMP1(value uint32) {
	volatile.StoreUint32(&o.FLAGS.Reg, volatile.LoadUint32(&o.FLAGS.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetFLAGS_THCMP1() uint32 {
	return (volatile.LoadUint32(&o.FLAGS.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetFLAGS_THCMP2(value uint32) {
	volatile.StoreUint32(&o.FLAGS.Reg, volatile.LoadUint32(&o.FLAGS.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetFLAGS_THCMP2() uint32 {
	return (volatile.LoadUint32(&o.FLAGS.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetFLAGS_THCMP3(value uint32) {
	volatile.StoreUint32(&o.FLAGS.Reg, volatile.LoadUint32(&o.FLAGS.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetFLAGS_THCMP3() uint32 {
	return (volatile.LoadUint32(&o.FLAGS.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetFLAGS_THCMP4(value uint32) {
	volatile.StoreUint32(&o.FLAGS.Reg, volatile.LoadUint32(&o.FLAGS.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetFLAGS_THCMP4() uint32 {
	return (volatile.LoadUint32(&o.FLAGS.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetFLAGS_THCMP5(value uint32) {
	volatile.StoreUint32(&o.FLAGS.Reg, volatile.LoadUint32(&o.FLAGS.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetFLAGS_THCMP5() uint32 {
	return (volatile.LoadUint32(&o.FLAGS.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetFLAGS_THCMP6(value uint32) {
	volatile.StoreUint32(&o.FLAGS.Reg, volatile.LoadUint32(&o.FLAGS.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetFLAGS_THCMP6() uint32 {
	return (volatile.LoadUint32(&o.FLAGS.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetFLAGS_THCMP7(value uint32) {
	volatile.StoreUint32(&o.FLAGS.Reg, volatile.LoadUint32(&o.FLAGS.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetFLAGS_THCMP7() uint32 {
	return (volatile.LoadUint32(&o.FLAGS.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetFLAGS_THCMP8(value uint32) {
	volatile.StoreUint32(&o.FLAGS.Reg, volatile.LoadUint32(&o.FLAGS.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetFLAGS_THCMP8() uint32 {
	return (volatile.LoadUint32(&o.FLAGS.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetFLAGS_THCMP9(value uint32) {
	volatile.StoreUint32(&o.FLAGS.Reg, volatile.LoadUint32(&o.FLAGS.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetFLAGS_THCMP9() uint32 {
	return (volatile.LoadUint32(&o.FLAGS.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetFLAGS_THCMP10(value uint32) {
	volatile.StoreUint32(&o.FLAGS.Reg, volatile.LoadUint32(&o.FLAGS.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetFLAGS_THCMP10() uint32 {
	return (volatile.LoadUint32(&o.FLAGS.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetFLAGS_THCMP11(value uint32) {
	volatile.StoreUint32(&o.FLAGS.Reg, volatile.LoadUint32(&o.FLAGS.Reg)&^(0x800)|value<<11)
}
func (o *ADC_Type) GetFLAGS_THCMP11() uint32 {
	return (volatile.LoadUint32(&o.FLAGS.Reg) & 0x800) >> 11
}
func (o *ADC_Type) SetFLAGS_OVERRUN0(value uint32) {
	volatile.StoreUint32(&o.FLAGS.Reg, volatile.LoadUint32(&o.FLAGS.Reg)&^(0x1000)|value<<12)
}
func (o *ADC_Type) GetFLAGS_OVERRUN0() uint32 {
	return (volatile.LoadUint32(&o.FLAGS.Reg) & 0x1000) >> 12
}
func (o *ADC_Type) SetFLAGS_OVERRUN1(value uint32) {
	volatile.StoreUint32(&o.FLAGS.Reg, volatile.LoadUint32(&o.FLAGS.Reg)&^(0x2000)|value<<13)
}
func (o *ADC_Type) GetFLAGS_OVERRUN1() uint32 {
	return (volatile.LoadUint32(&o.FLAGS.Reg) & 0x2000) >> 13
}
func (o *ADC_Type) SetFLAGS_OVERRUN2(value uint32) {
	volatile.StoreUint32(&o.FLAGS.Reg, volatile.LoadUint32(&o.FLAGS.Reg)&^(0x4000)|value<<14)
}
func (o *ADC_Type) GetFLAGS_OVERRUN2() uint32 {
	return (volatile.LoadUint32(&o.FLAGS.Reg) & 0x4000) >> 14
}
func (o *ADC_Type) SetFLAGS_OVERRUN3(value uint32) {
	volatile.StoreUint32(&o.FLAGS.Reg, volatile.LoadUint32(&o.FLAGS.Reg)&^(0x8000)|value<<15)
}
func (o *ADC_Type) GetFLAGS_OVERRUN3() uint32 {
	return (volatile.LoadUint32(&o.FLAGS.Reg) & 0x8000) >> 15
}
func (o *ADC_Type) SetFLAGS_OVERRUN4(value uint32) {
	volatile.StoreUint32(&o.FLAGS.Reg, volatile.LoadUint32(&o.FLAGS.Reg)&^(0x10000)|value<<16)
}
func (o *ADC_Type) GetFLAGS_OVERRUN4() uint32 {
	return (volatile.LoadUint32(&o.FLAGS.Reg) & 0x10000) >> 16
}
func (o *ADC_Type) SetFLAGS_OVERRUN5(value uint32) {
	volatile.StoreUint32(&o.FLAGS.Reg, volatile.LoadUint32(&o.FLAGS.Reg)&^(0x20000)|value<<17)
}
func (o *ADC_Type) GetFLAGS_OVERRUN5() uint32 {
	return (volatile.LoadUint32(&o.FLAGS.Reg) & 0x20000) >> 17
}
func (o *ADC_Type) SetFLAGS_OVERRUN6(value uint32) {
	volatile.StoreUint32(&o.FLAGS.Reg, volatile.LoadUint32(&o.FLAGS.Reg)&^(0x40000)|value<<18)
}
func (o *ADC_Type) GetFLAGS_OVERRUN6() uint32 {
	return (volatile.LoadUint32(&o.FLAGS.Reg) & 0x40000) >> 18
}
func (o *ADC_Type) SetFLAGS_OVERRUN7(value uint32) {
	volatile.StoreUint32(&o.FLAGS.Reg, volatile.LoadUint32(&o.FLAGS.Reg)&^(0x80000)|value<<19)
}
func (o *ADC_Type) GetFLAGS_OVERRUN7() uint32 {
	return (volatile.LoadUint32(&o.FLAGS.Reg) & 0x80000) >> 19
}
func (o *ADC_Type) SetFLAGS_OVERRUN8(value uint32) {
	volatile.StoreUint32(&o.FLAGS.Reg, volatile.LoadUint32(&o.FLAGS.Reg)&^(0x100000)|value<<20)
}
func (o *ADC_Type) GetFLAGS_OVERRUN8() uint32 {
	return (volatile.LoadUint32(&o.FLAGS.Reg) & 0x100000) >> 20
}
func (o *ADC_Type) SetFLAGS_OVERRUN9(value uint32) {
	volatile.StoreUint32(&o.FLAGS.Reg, volatile.LoadUint32(&o.FLAGS.Reg)&^(0x200000)|value<<21)
}
func (o *ADC_Type) GetFLAGS_OVERRUN9() uint32 {
	return (volatile.LoadUint32(&o.FLAGS.Reg) & 0x200000) >> 21
}
func (o *ADC_Type) SetFLAGS_OVERRUN10(value uint32) {
	volatile.StoreUint32(&o.FLAGS.Reg, volatile.LoadUint32(&o.FLAGS.Reg)&^(0x400000)|value<<22)
}
func (o *ADC_Type) GetFLAGS_OVERRUN10() uint32 {
	return (volatile.LoadUint32(&o.FLAGS.Reg) & 0x400000) >> 22
}
func (o *ADC_Type) SetFLAGS_OVERRUN11(value uint32) {
	volatile.StoreUint32(&o.FLAGS.Reg, volatile.LoadUint32(&o.FLAGS.Reg)&^(0x800000)|value<<23)
}
func (o *ADC_Type) GetFLAGS_OVERRUN11() uint32 {
	return (volatile.LoadUint32(&o.FLAGS.Reg) & 0x800000) >> 23
}
func (o *ADC_Type) SetFLAGS_SEQA_OVR(value uint32) {
	volatile.StoreUint32(&o.FLAGS.Reg, volatile.LoadUint32(&o.FLAGS.Reg)&^(0x1000000)|value<<24)
}
func (o *ADC_Type) GetFLAGS_SEQA_OVR() uint32 {
	return (volatile.LoadUint32(&o.FLAGS.Reg) & 0x1000000) >> 24
}
func (o *ADC_Type) SetFLAGS_SEQB_OVR(value uint32) {
	volatile.StoreUint32(&o.FLAGS.Reg, volatile.LoadUint32(&o.FLAGS.Reg)&^(0x2000000)|value<<25)
}
func (o *ADC_Type) GetFLAGS_SEQB_OVR() uint32 {
	return (volatile.LoadUint32(&o.FLAGS.Reg) & 0x2000000) >> 25
}
func (o *ADC_Type) SetFLAGS_RESERVED(value uint32) {
	volatile.StoreUint32(&o.FLAGS.Reg, volatile.LoadUint32(&o.FLAGS.Reg)&^(0xc000000)|value<<26)
}
func (o *ADC_Type) GetFLAGS_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.FLAGS.Reg) & 0xc000000) >> 26
}
func (o *ADC_Type) SetFLAGS_SEQA_INT(value uint32) {
	volatile.StoreUint32(&o.FLAGS.Reg, volatile.LoadUint32(&o.FLAGS.Reg)&^(0x10000000)|value<<28)
}
func (o *ADC_Type) GetFLAGS_SEQA_INT() uint32 {
	return (volatile.LoadUint32(&o.FLAGS.Reg) & 0x10000000) >> 28
}
func (o *ADC_Type) SetFLAGS_SEQB_INT(value uint32) {
	volatile.StoreUint32(&o.FLAGS.Reg, volatile.LoadUint32(&o.FLAGS.Reg)&^(0x20000000)|value<<29)
}
func (o *ADC_Type) GetFLAGS_SEQB_INT() uint32 {
	return (volatile.LoadUint32(&o.FLAGS.Reg) & 0x20000000) >> 29
}
func (o *ADC_Type) SetFLAGS_THCMP_INT(value uint32) {
	volatile.StoreUint32(&o.FLAGS.Reg, volatile.LoadUint32(&o.FLAGS.Reg)&^(0x40000000)|value<<30)
}
func (o *ADC_Type) GetFLAGS_THCMP_INT() uint32 {
	return (volatile.LoadUint32(&o.FLAGS.Reg) & 0x40000000) >> 30
}
func (o *ADC_Type) SetFLAGS_OVR_INT(value uint32) {
	volatile.StoreUint32(&o.FLAGS.Reg, volatile.LoadUint32(&o.FLAGS.Reg)&^(0x80000000)|value<<31)
}
func (o *ADC_Type) GetFLAGS_OVR_INT() uint32 {
	return (volatile.LoadUint32(&o.FLAGS.Reg) & 0x80000000) >> 31
}

// ADC.TRM: ADC trim register.
func (o *ADC_Type) SetTRM_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TRM.Reg, volatile.LoadUint32(&o.TRM.Reg)&^(0x1f)|value)
}
func (o *ADC_Type) GetTRM_RESERVED() uint32 {
	return volatile.LoadUint32(&o.TRM.Reg) & 0x1f
}
func (o *ADC_Type) SetTRM_VRANGE(value uint32) {
	volatile.StoreUint32(&o.TRM.Reg, volatile.LoadUint32(&o.TRM.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetTRM_VRANGE() uint32 {
	return (volatile.LoadUint32(&o.TRM.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetTRM_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TRM.Reg, volatile.LoadUint32(&o.TRM.Reg)&^(0xffffffc0)|value<<6)
}
func (o *ADC_Type) GetTRM_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TRM.Reg) & 0xffffffc0) >> 6
}

// 12-bit DAC Modification
type DAC_Type struct {
	VAL    volatile.Register32 // 0x0
	CTRL   volatile.Register32 // 0x4
	CNTVAL volatile.Register32 // 0x8
}

// DAC.VAL: D/A Converter Value Register. This register contains the digital value to be converted to analog.
func (o *DAC_Type) SetVAL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.VAL.Reg, volatile.LoadUint32(&o.VAL.Reg)&^(0xf)|value)
}
func (o *DAC_Type) GetVAL_RESERVED() uint32 {
	return volatile.LoadUint32(&o.VAL.Reg) & 0xf
}
func (o *DAC_Type) SetVAL_VALUE(value uint32) {
	volatile.StoreUint32(&o.VAL.Reg, volatile.LoadUint32(&o.VAL.Reg)&^(0xfff0)|value<<4)
}
func (o *DAC_Type) GetVAL_VALUE() uint32 {
	return (volatile.LoadUint32(&o.VAL.Reg) & 0xfff0) >> 4
}
func (o *DAC_Type) SetVAL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.VAL.Reg, volatile.LoadUint32(&o.VAL.Reg)&^(0xffff0000)|value<<16)
}
func (o *DAC_Type) GetVAL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.VAL.Reg) & 0xffff0000) >> 16
}

// DAC.CTRL: DAC Control register. This register contains bits to configure DAC operation and the interrupt/dma request flag.
func (o *DAC_Type) SetCTRL_INT_DMA_FLAG(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x1)|value)
}
func (o *DAC_Type) GetCTRL_INT_DMA_FLAG() uint32 {
	return volatile.LoadUint32(&o.CTRL.Reg) & 0x1
}
func (o *DAC_Type) SetCTRL_TRIG_SRC(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0xe)|value<<1)
}
func (o *DAC_Type) GetCTRL_TRIG_SRC() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0xe) >> 1
}
func (o *DAC_Type) SetCTRL_POLARITY(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x10)|value<<4)
}
func (o *DAC_Type) GetCTRL_POLARITY() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x10) >> 4
}
func (o *DAC_Type) SetCTRL_SYNC_BYPASS(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x20)|value<<5)
}
func (o *DAC_Type) GetCTRL_SYNC_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x20) >> 5
}
func (o *DAC_Type) SetCTRL_TIMER_ENA(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x40)|value<<6)
}
func (o *DAC_Type) GetCTRL_TIMER_ENA() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x40) >> 6
}
func (o *DAC_Type) SetCTRL_DBLBUF_ENA(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x80)|value<<7)
}
func (o *DAC_Type) GetCTRL_DBLBUF_ENA() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x80) >> 7
}
func (o *DAC_Type) SetCTRL_SHUTOFF_ENA(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x100)|value<<8)
}
func (o *DAC_Type) GetCTRL_SHUTOFF_ENA() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x100) >> 8
}
func (o *DAC_Type) SetCTRL_SHUTOFF_FLAG(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x200)|value<<9)
}
func (o *DAC_Type) GetCTRL_SHUTOFF_FLAG() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x200) >> 9
}
func (o *DAC_Type) SetCTRL_BIAS(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x1c00)|value<<10)
}
func (o *DAC_Type) GetCTRL_BIAS() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x1c00) >> 10
}
func (o *DAC_Type) SetCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0xffffe000)|value<<13)
}
func (o *DAC_Type) GetCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0xffffe000) >> 13
}

// DAC.CNTVAL: DAC Counter Value register. This register contains the reload value for the internal DAC DMA/Interrupt timer.
func (o *DAC_Type) SetCNTVAL(value uint32) {
	volatile.StoreUint32(&o.CNTVAL.Reg, volatile.LoadUint32(&o.CNTVAL.Reg)&^(0xffff)|value)
}
func (o *DAC_Type) GetCNTVAL() uint32 {
	return volatile.LoadUint32(&o.CNTVAL.Reg) & 0xffff
}
func (o *DAC_Type) SetCNTVAL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CNTVAL.Reg, volatile.LoadUint32(&o.CNTVAL.Reg)&^(0xffff0000)|value<<16)
}
func (o *DAC_Type) GetCNTVAL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CNTVAL.Reg) & 0xffff0000) >> 16
}

// Analog comparators ACMP0/1/2/3
type ACMP_Type struct {
	CTRL      volatile.Register32 // 0x0
	CMP0      volatile.Register32 // 0x4
	CMPFILTR0 volatile.Register32 // 0x8
	CMP1      volatile.Register32 // 0xC
	CMPFILTR1 volatile.Register32 // 0x10
	CMP2      volatile.Register32 // 0x14
	CMPFILTR2 volatile.Register32 // 0x18
	CMP3      volatile.Register32 // 0x1C
	CMPFILTR3 volatile.Register32 // 0x20
}

// ACMP.CTRL: Comparator block control register
func (o *ACMP_Type) SetCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0xff)|value)
}
func (o *ACMP_Type) GetCTRL_RESERVED() uint32 {
	return volatile.LoadUint32(&o.CTRL.Reg) & 0xff
}
func (o *ACMP_Type) SetCTRL_ROSCCTL(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x100)|value<<8)
}
func (o *ACMP_Type) GetCTRL_ROSCCTL() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x100) >> 8
}
func (o *ACMP_Type) SetCTRL_EXT_RESET(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x200)|value<<9)
}
func (o *ACMP_Type) GetCTRL_EXT_RESET() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x200) >> 9
}
func (o *ACMP_Type) SetCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0xfffffc00)|value<<10)
}
func (o *ACMP_Type) GetCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0xfffffc00) >> 10
}

// ACMP.CMP0: Comparator 0 source control
func (o *ACMP_Type) SetCMP0_EN(value uint32) {
	volatile.StoreUint32(&o.CMP0.Reg, volatile.LoadUint32(&o.CMP0.Reg)&^(0x1)|value)
}
func (o *ACMP_Type) GetCMP0_EN() uint32 {
	return volatile.LoadUint32(&o.CMP0.Reg) & 0x1
}
func (o *ACMP_Type) SetCMP0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CMP0.Reg, volatile.LoadUint32(&o.CMP0.Reg)&^(0x2)|value<<1)
}
func (o *ACMP_Type) GetCMP0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CMP0.Reg) & 0x2) >> 1
}
func (o *ACMP_Type) SetCMP0_INTEN(value uint32) {
	volatile.StoreUint32(&o.CMP0.Reg, volatile.LoadUint32(&o.CMP0.Reg)&^(0x4)|value<<2)
}
func (o *ACMP_Type) GetCMP0_INTEN() uint32 {
	return (volatile.LoadUint32(&o.CMP0.Reg) & 0x4) >> 2
}
func (o *ACMP_Type) SetCMP0_STAT(value uint32) {
	volatile.StoreUint32(&o.CMP0.Reg, volatile.LoadUint32(&o.CMP0.Reg)&^(0x8)|value<<3)
}
func (o *ACMP_Type) GetCMP0_STAT() uint32 {
	return (volatile.LoadUint32(&o.CMP0.Reg) & 0x8) >> 3
}
func (o *ACMP_Type) SetCMP0_VM(value uint32) {
	volatile.StoreUint32(&o.CMP0.Reg, volatile.LoadUint32(&o.CMP0.Reg)&^(0x70)|value<<4)
}
func (o *ACMP_Type) GetCMP0_VM() uint32 {
	return (volatile.LoadUint32(&o.CMP0.Reg) & 0x70) >> 4
}
func (o *ACMP_Type) SetCMP0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CMP0.Reg, volatile.LoadUint32(&o.CMP0.Reg)&^(0x80)|value<<7)
}
func (o *ACMP_Type) GetCMP0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CMP0.Reg) & 0x80) >> 7
}
func (o *ACMP_Type) SetCMP0_VP(value uint32) {
	volatile.StoreUint32(&o.CMP0.Reg, volatile.LoadUint32(&o.CMP0.Reg)&^(0x700)|value<<8)
}
func (o *ACMP_Type) GetCMP0_VP() uint32 {
	return (volatile.LoadUint32(&o.CMP0.Reg) & 0x700) >> 8
}
func (o *ACMP_Type) SetCMP0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CMP0.Reg, volatile.LoadUint32(&o.CMP0.Reg)&^(0x1800)|value<<11)
}
func (o *ACMP_Type) GetCMP0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CMP0.Reg) & 0x1800) >> 11
}
func (o *ACMP_Type) SetCMP0_HYS(value uint32) {
	volatile.StoreUint32(&o.CMP0.Reg, volatile.LoadUint32(&o.CMP0.Reg)&^(0x6000)|value<<13)
}
func (o *ACMP_Type) GetCMP0_HYS() uint32 {
	return (volatile.LoadUint32(&o.CMP0.Reg) & 0x6000) >> 13
}
func (o *ACMP_Type) SetCMP0_INTPOL(value uint32) {
	volatile.StoreUint32(&o.CMP0.Reg, volatile.LoadUint32(&o.CMP0.Reg)&^(0x8000)|value<<15)
}
func (o *ACMP_Type) GetCMP0_INTPOL() uint32 {
	return (volatile.LoadUint32(&o.CMP0.Reg) & 0x8000) >> 15
}
func (o *ACMP_Type) SetCMP0_INTTYPE(value uint32) {
	volatile.StoreUint32(&o.CMP0.Reg, volatile.LoadUint32(&o.CMP0.Reg)&^(0x10000)|value<<16)
}
func (o *ACMP_Type) GetCMP0_INTTYPE() uint32 {
	return (volatile.LoadUint32(&o.CMP0.Reg) & 0x10000) >> 16
}
func (o *ACMP_Type) SetCMP0_INTEDGE(value uint32) {
	volatile.StoreUint32(&o.CMP0.Reg, volatile.LoadUint32(&o.CMP0.Reg)&^(0x60000)|value<<17)
}
func (o *ACMP_Type) GetCMP0_INTEDGE() uint32 {
	return (volatile.LoadUint32(&o.CMP0.Reg) & 0x60000) >> 17
}
func (o *ACMP_Type) SetCMP0_INTFLAG(value uint32) {
	volatile.StoreUint32(&o.CMP0.Reg, volatile.LoadUint32(&o.CMP0.Reg)&^(0x80000)|value<<19)
}
func (o *ACMP_Type) GetCMP0_INTFLAG() uint32 {
	return (volatile.LoadUint32(&o.CMP0.Reg) & 0x80000) >> 19
}
func (o *ACMP_Type) SetCMP0_VLADEN(value uint32) {
	volatile.StoreUint32(&o.CMP0.Reg, volatile.LoadUint32(&o.CMP0.Reg)&^(0x100000)|value<<20)
}
func (o *ACMP_Type) GetCMP0_VLADEN() uint32 {
	return (volatile.LoadUint32(&o.CMP0.Reg) & 0x100000) >> 20
}
func (o *ACMP_Type) SetCMP0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CMP0.Reg, volatile.LoadUint32(&o.CMP0.Reg)&^(0x200000)|value<<21)
}
func (o *ACMP_Type) GetCMP0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CMP0.Reg) & 0x200000) >> 21
}
func (o *ACMP_Type) SetCMP0_VLADREF(value uint32) {
	volatile.StoreUint32(&o.CMP0.Reg, volatile.LoadUint32(&o.CMP0.Reg)&^(0x400000)|value<<22)
}
func (o *ACMP_Type) GetCMP0_VLADREF() uint32 {
	return (volatile.LoadUint32(&o.CMP0.Reg) & 0x400000) >> 22
}
func (o *ACMP_Type) SetCMP0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CMP0.Reg, volatile.LoadUint32(&o.CMP0.Reg)&^(0x800000)|value<<23)
}
func (o *ACMP_Type) GetCMP0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CMP0.Reg) & 0x800000) >> 23
}
func (o *ACMP_Type) SetCMP0_VSEL(value uint32) {
	volatile.StoreUint32(&o.CMP0.Reg, volatile.LoadUint32(&o.CMP0.Reg)&^(0x1f000000)|value<<24)
}
func (o *ACMP_Type) GetCMP0_VSEL() uint32 {
	return (volatile.LoadUint32(&o.CMP0.Reg) & 0x1f000000) >> 24
}
func (o *ACMP_Type) SetCMP0_DLY(value uint32) {
	volatile.StoreUint32(&o.CMP0.Reg, volatile.LoadUint32(&o.CMP0.Reg)&^(0x60000000)|value<<29)
}
func (o *ACMP_Type) GetCMP0_DLY() uint32 {
	return (volatile.LoadUint32(&o.CMP0.Reg) & 0x60000000) >> 29
}
func (o *ACMP_Type) SetCMP0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CMP0.Reg, volatile.LoadUint32(&o.CMP0.Reg)&^(0x80000000)|value<<31)
}
func (o *ACMP_Type) GetCMP0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CMP0.Reg) & 0x80000000) >> 31
}

// ACMP.CMPFILTR0: Comparator 0 pin filter set-up
func (o *ACMP_Type) SetCMPFILTR0_S_MODE(value uint32) {
	volatile.StoreUint32(&o.CMPFILTR0.Reg, volatile.LoadUint32(&o.CMPFILTR0.Reg)&^(0x3)|value)
}
func (o *ACMP_Type) GetCMPFILTR0_S_MODE() uint32 {
	return volatile.LoadUint32(&o.CMPFILTR0.Reg) & 0x3
}
func (o *ACMP_Type) SetCMPFILTR0_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.CMPFILTR0.Reg, volatile.LoadUint32(&o.CMPFILTR0.Reg)&^(0x1c)|value<<2)
}
func (o *ACMP_Type) GetCMPFILTR0_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.CMPFILTR0.Reg) & 0x1c) >> 2
}
func (o *ACMP_Type) SetCMPFILTR0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CMPFILTR0.Reg, volatile.LoadUint32(&o.CMPFILTR0.Reg)&^(0xffffffe0)|value<<5)
}
func (o *ACMP_Type) GetCMPFILTR0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CMPFILTR0.Reg) & 0xffffffe0) >> 5
}

// ACMP.CMP1: Comparator 1 source control
func (o *ACMP_Type) SetCMP1_EN(value uint32) {
	volatile.StoreUint32(&o.CMP1.Reg, volatile.LoadUint32(&o.CMP1.Reg)&^(0x1)|value)
}
func (o *ACMP_Type) GetCMP1_EN() uint32 {
	return volatile.LoadUint32(&o.CMP1.Reg) & 0x1
}
func (o *ACMP_Type) SetCMP1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CMP1.Reg, volatile.LoadUint32(&o.CMP1.Reg)&^(0x2)|value<<1)
}
func (o *ACMP_Type) GetCMP1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CMP1.Reg) & 0x2) >> 1
}
func (o *ACMP_Type) SetCMP1_INTEN(value uint32) {
	volatile.StoreUint32(&o.CMP1.Reg, volatile.LoadUint32(&o.CMP1.Reg)&^(0x4)|value<<2)
}
func (o *ACMP_Type) GetCMP1_INTEN() uint32 {
	return (volatile.LoadUint32(&o.CMP1.Reg) & 0x4) >> 2
}
func (o *ACMP_Type) SetCMP1_STAT(value uint32) {
	volatile.StoreUint32(&o.CMP1.Reg, volatile.LoadUint32(&o.CMP1.Reg)&^(0x8)|value<<3)
}
func (o *ACMP_Type) GetCMP1_STAT() uint32 {
	return (volatile.LoadUint32(&o.CMP1.Reg) & 0x8) >> 3
}
func (o *ACMP_Type) SetCMP1_VM(value uint32) {
	volatile.StoreUint32(&o.CMP1.Reg, volatile.LoadUint32(&o.CMP1.Reg)&^(0x70)|value<<4)
}
func (o *ACMP_Type) GetCMP1_VM() uint32 {
	return (volatile.LoadUint32(&o.CMP1.Reg) & 0x70) >> 4
}
func (o *ACMP_Type) SetCMP1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CMP1.Reg, volatile.LoadUint32(&o.CMP1.Reg)&^(0x80)|value<<7)
}
func (o *ACMP_Type) GetCMP1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CMP1.Reg) & 0x80) >> 7
}
func (o *ACMP_Type) SetCMP1_VP(value uint32) {
	volatile.StoreUint32(&o.CMP1.Reg, volatile.LoadUint32(&o.CMP1.Reg)&^(0x700)|value<<8)
}
func (o *ACMP_Type) GetCMP1_VP() uint32 {
	return (volatile.LoadUint32(&o.CMP1.Reg) & 0x700) >> 8
}
func (o *ACMP_Type) SetCMP1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CMP1.Reg, volatile.LoadUint32(&o.CMP1.Reg)&^(0x1800)|value<<11)
}
func (o *ACMP_Type) GetCMP1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CMP1.Reg) & 0x1800) >> 11
}
func (o *ACMP_Type) SetCMP1_HYS(value uint32) {
	volatile.StoreUint32(&o.CMP1.Reg, volatile.LoadUint32(&o.CMP1.Reg)&^(0x6000)|value<<13)
}
func (o *ACMP_Type) GetCMP1_HYS() uint32 {
	return (volatile.LoadUint32(&o.CMP1.Reg) & 0x6000) >> 13
}
func (o *ACMP_Type) SetCMP1_INTPOL(value uint32) {
	volatile.StoreUint32(&o.CMP1.Reg, volatile.LoadUint32(&o.CMP1.Reg)&^(0x8000)|value<<15)
}
func (o *ACMP_Type) GetCMP1_INTPOL() uint32 {
	return (volatile.LoadUint32(&o.CMP1.Reg) & 0x8000) >> 15
}
func (o *ACMP_Type) SetCMP1_INTTYPE(value uint32) {
	volatile.StoreUint32(&o.CMP1.Reg, volatile.LoadUint32(&o.CMP1.Reg)&^(0x10000)|value<<16)
}
func (o *ACMP_Type) GetCMP1_INTTYPE() uint32 {
	return (volatile.LoadUint32(&o.CMP1.Reg) & 0x10000) >> 16
}
func (o *ACMP_Type) SetCMP1_INTEDGE(value uint32) {
	volatile.StoreUint32(&o.CMP1.Reg, volatile.LoadUint32(&o.CMP1.Reg)&^(0x60000)|value<<17)
}
func (o *ACMP_Type) GetCMP1_INTEDGE() uint32 {
	return (volatile.LoadUint32(&o.CMP1.Reg) & 0x60000) >> 17
}
func (o *ACMP_Type) SetCMP1_INTFLAG(value uint32) {
	volatile.StoreUint32(&o.CMP1.Reg, volatile.LoadUint32(&o.CMP1.Reg)&^(0x80000)|value<<19)
}
func (o *ACMP_Type) GetCMP1_INTFLAG() uint32 {
	return (volatile.LoadUint32(&o.CMP1.Reg) & 0x80000) >> 19
}
func (o *ACMP_Type) SetCMP1_VLADEN(value uint32) {
	volatile.StoreUint32(&o.CMP1.Reg, volatile.LoadUint32(&o.CMP1.Reg)&^(0x100000)|value<<20)
}
func (o *ACMP_Type) GetCMP1_VLADEN() uint32 {
	return (volatile.LoadUint32(&o.CMP1.Reg) & 0x100000) >> 20
}
func (o *ACMP_Type) SetCMP1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CMP1.Reg, volatile.LoadUint32(&o.CMP1.Reg)&^(0x200000)|value<<21)
}
func (o *ACMP_Type) GetCMP1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CMP1.Reg) & 0x200000) >> 21
}
func (o *ACMP_Type) SetCMP1_VLADREF(value uint32) {
	volatile.StoreUint32(&o.CMP1.Reg, volatile.LoadUint32(&o.CMP1.Reg)&^(0x400000)|value<<22)
}
func (o *ACMP_Type) GetCMP1_VLADREF() uint32 {
	return (volatile.LoadUint32(&o.CMP1.Reg) & 0x400000) >> 22
}
func (o *ACMP_Type) SetCMP1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CMP1.Reg, volatile.LoadUint32(&o.CMP1.Reg)&^(0x800000)|value<<23)
}
func (o *ACMP_Type) GetCMP1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CMP1.Reg) & 0x800000) >> 23
}
func (o *ACMP_Type) SetCMP1_VSEL(value uint32) {
	volatile.StoreUint32(&o.CMP1.Reg, volatile.LoadUint32(&o.CMP1.Reg)&^(0x1f000000)|value<<24)
}
func (o *ACMP_Type) GetCMP1_VSEL() uint32 {
	return (volatile.LoadUint32(&o.CMP1.Reg) & 0x1f000000) >> 24
}
func (o *ACMP_Type) SetCMP1_DLY(value uint32) {
	volatile.StoreUint32(&o.CMP1.Reg, volatile.LoadUint32(&o.CMP1.Reg)&^(0x60000000)|value<<29)
}
func (o *ACMP_Type) GetCMP1_DLY() uint32 {
	return (volatile.LoadUint32(&o.CMP1.Reg) & 0x60000000) >> 29
}
func (o *ACMP_Type) SetCMP1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CMP1.Reg, volatile.LoadUint32(&o.CMP1.Reg)&^(0x80000000)|value<<31)
}
func (o *ACMP_Type) GetCMP1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CMP1.Reg) & 0x80000000) >> 31
}

// ACMP.CMPFILTR1: Comparator 0 pin filter set-up
func (o *ACMP_Type) SetCMPFILTR1_S_MODE(value uint32) {
	volatile.StoreUint32(&o.CMPFILTR1.Reg, volatile.LoadUint32(&o.CMPFILTR1.Reg)&^(0x3)|value)
}
func (o *ACMP_Type) GetCMPFILTR1_S_MODE() uint32 {
	return volatile.LoadUint32(&o.CMPFILTR1.Reg) & 0x3
}
func (o *ACMP_Type) SetCMPFILTR1_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.CMPFILTR1.Reg, volatile.LoadUint32(&o.CMPFILTR1.Reg)&^(0x1c)|value<<2)
}
func (o *ACMP_Type) GetCMPFILTR1_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.CMPFILTR1.Reg) & 0x1c) >> 2
}
func (o *ACMP_Type) SetCMPFILTR1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CMPFILTR1.Reg, volatile.LoadUint32(&o.CMPFILTR1.Reg)&^(0xffffffe0)|value<<5)
}
func (o *ACMP_Type) GetCMPFILTR1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CMPFILTR1.Reg) & 0xffffffe0) >> 5
}

// ACMP.CMP2: Comparator 2 source control
func (o *ACMP_Type) SetCMP2_EN(value uint32) {
	volatile.StoreUint32(&o.CMP2.Reg, volatile.LoadUint32(&o.CMP2.Reg)&^(0x1)|value)
}
func (o *ACMP_Type) GetCMP2_EN() uint32 {
	return volatile.LoadUint32(&o.CMP2.Reg) & 0x1
}
func (o *ACMP_Type) SetCMP2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CMP2.Reg, volatile.LoadUint32(&o.CMP2.Reg)&^(0x2)|value<<1)
}
func (o *ACMP_Type) GetCMP2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CMP2.Reg) & 0x2) >> 1
}
func (o *ACMP_Type) SetCMP2_INTEN(value uint32) {
	volatile.StoreUint32(&o.CMP2.Reg, volatile.LoadUint32(&o.CMP2.Reg)&^(0x4)|value<<2)
}
func (o *ACMP_Type) GetCMP2_INTEN() uint32 {
	return (volatile.LoadUint32(&o.CMP2.Reg) & 0x4) >> 2
}
func (o *ACMP_Type) SetCMP2_STAT(value uint32) {
	volatile.StoreUint32(&o.CMP2.Reg, volatile.LoadUint32(&o.CMP2.Reg)&^(0x8)|value<<3)
}
func (o *ACMP_Type) GetCMP2_STAT() uint32 {
	return (volatile.LoadUint32(&o.CMP2.Reg) & 0x8) >> 3
}
func (o *ACMP_Type) SetCMP2_VM(value uint32) {
	volatile.StoreUint32(&o.CMP2.Reg, volatile.LoadUint32(&o.CMP2.Reg)&^(0x70)|value<<4)
}
func (o *ACMP_Type) GetCMP2_VM() uint32 {
	return (volatile.LoadUint32(&o.CMP2.Reg) & 0x70) >> 4
}
func (o *ACMP_Type) SetCMP2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CMP2.Reg, volatile.LoadUint32(&o.CMP2.Reg)&^(0x80)|value<<7)
}
func (o *ACMP_Type) GetCMP2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CMP2.Reg) & 0x80) >> 7
}
func (o *ACMP_Type) SetCMP2_VP(value uint32) {
	volatile.StoreUint32(&o.CMP2.Reg, volatile.LoadUint32(&o.CMP2.Reg)&^(0x700)|value<<8)
}
func (o *ACMP_Type) GetCMP2_VP() uint32 {
	return (volatile.LoadUint32(&o.CMP2.Reg) & 0x700) >> 8
}
func (o *ACMP_Type) SetCMP2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CMP2.Reg, volatile.LoadUint32(&o.CMP2.Reg)&^(0x1800)|value<<11)
}
func (o *ACMP_Type) GetCMP2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CMP2.Reg) & 0x1800) >> 11
}
func (o *ACMP_Type) SetCMP2_HYS(value uint32) {
	volatile.StoreUint32(&o.CMP2.Reg, volatile.LoadUint32(&o.CMP2.Reg)&^(0x6000)|value<<13)
}
func (o *ACMP_Type) GetCMP2_HYS() uint32 {
	return (volatile.LoadUint32(&o.CMP2.Reg) & 0x6000) >> 13
}
func (o *ACMP_Type) SetCMP2_INTPOL(value uint32) {
	volatile.StoreUint32(&o.CMP2.Reg, volatile.LoadUint32(&o.CMP2.Reg)&^(0x8000)|value<<15)
}
func (o *ACMP_Type) GetCMP2_INTPOL() uint32 {
	return (volatile.LoadUint32(&o.CMP2.Reg) & 0x8000) >> 15
}
func (o *ACMP_Type) SetCMP2_INTTYPE(value uint32) {
	volatile.StoreUint32(&o.CMP2.Reg, volatile.LoadUint32(&o.CMP2.Reg)&^(0x10000)|value<<16)
}
func (o *ACMP_Type) GetCMP2_INTTYPE() uint32 {
	return (volatile.LoadUint32(&o.CMP2.Reg) & 0x10000) >> 16
}
func (o *ACMP_Type) SetCMP2_INTEDGE(value uint32) {
	volatile.StoreUint32(&o.CMP2.Reg, volatile.LoadUint32(&o.CMP2.Reg)&^(0x60000)|value<<17)
}
func (o *ACMP_Type) GetCMP2_INTEDGE() uint32 {
	return (volatile.LoadUint32(&o.CMP2.Reg) & 0x60000) >> 17
}
func (o *ACMP_Type) SetCMP2_INTFLAG(value uint32) {
	volatile.StoreUint32(&o.CMP2.Reg, volatile.LoadUint32(&o.CMP2.Reg)&^(0x80000)|value<<19)
}
func (o *ACMP_Type) GetCMP2_INTFLAG() uint32 {
	return (volatile.LoadUint32(&o.CMP2.Reg) & 0x80000) >> 19
}
func (o *ACMP_Type) SetCMP2_VLADEN(value uint32) {
	volatile.StoreUint32(&o.CMP2.Reg, volatile.LoadUint32(&o.CMP2.Reg)&^(0x100000)|value<<20)
}
func (o *ACMP_Type) GetCMP2_VLADEN() uint32 {
	return (volatile.LoadUint32(&o.CMP2.Reg) & 0x100000) >> 20
}
func (o *ACMP_Type) SetCMP2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CMP2.Reg, volatile.LoadUint32(&o.CMP2.Reg)&^(0x200000)|value<<21)
}
func (o *ACMP_Type) GetCMP2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CMP2.Reg) & 0x200000) >> 21
}
func (o *ACMP_Type) SetCMP2_VLADREF(value uint32) {
	volatile.StoreUint32(&o.CMP2.Reg, volatile.LoadUint32(&o.CMP2.Reg)&^(0x400000)|value<<22)
}
func (o *ACMP_Type) GetCMP2_VLADREF() uint32 {
	return (volatile.LoadUint32(&o.CMP2.Reg) & 0x400000) >> 22
}
func (o *ACMP_Type) SetCMP2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CMP2.Reg, volatile.LoadUint32(&o.CMP2.Reg)&^(0x800000)|value<<23)
}
func (o *ACMP_Type) GetCMP2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CMP2.Reg) & 0x800000) >> 23
}
func (o *ACMP_Type) SetCMP2_VSEL(value uint32) {
	volatile.StoreUint32(&o.CMP2.Reg, volatile.LoadUint32(&o.CMP2.Reg)&^(0x1f000000)|value<<24)
}
func (o *ACMP_Type) GetCMP2_VSEL() uint32 {
	return (volatile.LoadUint32(&o.CMP2.Reg) & 0x1f000000) >> 24
}
func (o *ACMP_Type) SetCMP2_DLY(value uint32) {
	volatile.StoreUint32(&o.CMP2.Reg, volatile.LoadUint32(&o.CMP2.Reg)&^(0x60000000)|value<<29)
}
func (o *ACMP_Type) GetCMP2_DLY() uint32 {
	return (volatile.LoadUint32(&o.CMP2.Reg) & 0x60000000) >> 29
}
func (o *ACMP_Type) SetCMP2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CMP2.Reg, volatile.LoadUint32(&o.CMP2.Reg)&^(0x80000000)|value<<31)
}
func (o *ACMP_Type) GetCMP2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CMP2.Reg) & 0x80000000) >> 31
}

// ACMP.CMPFILTR2: Comparator 0 pin filter set-up
func (o *ACMP_Type) SetCMPFILTR2_S_MODE(value uint32) {
	volatile.StoreUint32(&o.CMPFILTR2.Reg, volatile.LoadUint32(&o.CMPFILTR2.Reg)&^(0x3)|value)
}
func (o *ACMP_Type) GetCMPFILTR2_S_MODE() uint32 {
	return volatile.LoadUint32(&o.CMPFILTR2.Reg) & 0x3
}
func (o *ACMP_Type) SetCMPFILTR2_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.CMPFILTR2.Reg, volatile.LoadUint32(&o.CMPFILTR2.Reg)&^(0x1c)|value<<2)
}
func (o *ACMP_Type) GetCMPFILTR2_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.CMPFILTR2.Reg) & 0x1c) >> 2
}
func (o *ACMP_Type) SetCMPFILTR2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CMPFILTR2.Reg, volatile.LoadUint32(&o.CMPFILTR2.Reg)&^(0xffffffe0)|value<<5)
}
func (o *ACMP_Type) GetCMPFILTR2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CMPFILTR2.Reg) & 0xffffffe0) >> 5
}

// ACMP.CMP3: Comparator 3 source control
func (o *ACMP_Type) SetCMP3_EN(value uint32) {
	volatile.StoreUint32(&o.CMP3.Reg, volatile.LoadUint32(&o.CMP3.Reg)&^(0x1)|value)
}
func (o *ACMP_Type) GetCMP3_EN() uint32 {
	return volatile.LoadUint32(&o.CMP3.Reg) & 0x1
}
func (o *ACMP_Type) SetCMP3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CMP3.Reg, volatile.LoadUint32(&o.CMP3.Reg)&^(0x2)|value<<1)
}
func (o *ACMP_Type) GetCMP3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CMP3.Reg) & 0x2) >> 1
}
func (o *ACMP_Type) SetCMP3_INTEN(value uint32) {
	volatile.StoreUint32(&o.CMP3.Reg, volatile.LoadUint32(&o.CMP3.Reg)&^(0x4)|value<<2)
}
func (o *ACMP_Type) GetCMP3_INTEN() uint32 {
	return (volatile.LoadUint32(&o.CMP3.Reg) & 0x4) >> 2
}
func (o *ACMP_Type) SetCMP3_STAT(value uint32) {
	volatile.StoreUint32(&o.CMP3.Reg, volatile.LoadUint32(&o.CMP3.Reg)&^(0x8)|value<<3)
}
func (o *ACMP_Type) GetCMP3_STAT() uint32 {
	return (volatile.LoadUint32(&o.CMP3.Reg) & 0x8) >> 3
}
func (o *ACMP_Type) SetCMP3_VM(value uint32) {
	volatile.StoreUint32(&o.CMP3.Reg, volatile.LoadUint32(&o.CMP3.Reg)&^(0x70)|value<<4)
}
func (o *ACMP_Type) GetCMP3_VM() uint32 {
	return (volatile.LoadUint32(&o.CMP3.Reg) & 0x70) >> 4
}
func (o *ACMP_Type) SetCMP3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CMP3.Reg, volatile.LoadUint32(&o.CMP3.Reg)&^(0x80)|value<<7)
}
func (o *ACMP_Type) GetCMP3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CMP3.Reg) & 0x80) >> 7
}
func (o *ACMP_Type) SetCMP3_VP(value uint32) {
	volatile.StoreUint32(&o.CMP3.Reg, volatile.LoadUint32(&o.CMP3.Reg)&^(0x700)|value<<8)
}
func (o *ACMP_Type) GetCMP3_VP() uint32 {
	return (volatile.LoadUint32(&o.CMP3.Reg) & 0x700) >> 8
}
func (o *ACMP_Type) SetCMP3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CMP3.Reg, volatile.LoadUint32(&o.CMP3.Reg)&^(0x1800)|value<<11)
}
func (o *ACMP_Type) GetCMP3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CMP3.Reg) & 0x1800) >> 11
}
func (o *ACMP_Type) SetCMP3_HYS(value uint32) {
	volatile.StoreUint32(&o.CMP3.Reg, volatile.LoadUint32(&o.CMP3.Reg)&^(0x6000)|value<<13)
}
func (o *ACMP_Type) GetCMP3_HYS() uint32 {
	return (volatile.LoadUint32(&o.CMP3.Reg) & 0x6000) >> 13
}
func (o *ACMP_Type) SetCMP3_INTPOL(value uint32) {
	volatile.StoreUint32(&o.CMP3.Reg, volatile.LoadUint32(&o.CMP3.Reg)&^(0x8000)|value<<15)
}
func (o *ACMP_Type) GetCMP3_INTPOL() uint32 {
	return (volatile.LoadUint32(&o.CMP3.Reg) & 0x8000) >> 15
}
func (o *ACMP_Type) SetCMP3_INTTYPE(value uint32) {
	volatile.StoreUint32(&o.CMP3.Reg, volatile.LoadUint32(&o.CMP3.Reg)&^(0x10000)|value<<16)
}
func (o *ACMP_Type) GetCMP3_INTTYPE() uint32 {
	return (volatile.LoadUint32(&o.CMP3.Reg) & 0x10000) >> 16
}
func (o *ACMP_Type) SetCMP3_INTEDGE(value uint32) {
	volatile.StoreUint32(&o.CMP3.Reg, volatile.LoadUint32(&o.CMP3.Reg)&^(0x60000)|value<<17)
}
func (o *ACMP_Type) GetCMP3_INTEDGE() uint32 {
	return (volatile.LoadUint32(&o.CMP3.Reg) & 0x60000) >> 17
}
func (o *ACMP_Type) SetCMP3_INTFLAG(value uint32) {
	volatile.StoreUint32(&o.CMP3.Reg, volatile.LoadUint32(&o.CMP3.Reg)&^(0x80000)|value<<19)
}
func (o *ACMP_Type) GetCMP3_INTFLAG() uint32 {
	return (volatile.LoadUint32(&o.CMP3.Reg) & 0x80000) >> 19
}
func (o *ACMP_Type) SetCMP3_VLADEN(value uint32) {
	volatile.StoreUint32(&o.CMP3.Reg, volatile.LoadUint32(&o.CMP3.Reg)&^(0x100000)|value<<20)
}
func (o *ACMP_Type) GetCMP3_VLADEN() uint32 {
	return (volatile.LoadUint32(&o.CMP3.Reg) & 0x100000) >> 20
}
func (o *ACMP_Type) SetCMP3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CMP3.Reg, volatile.LoadUint32(&o.CMP3.Reg)&^(0x200000)|value<<21)
}
func (o *ACMP_Type) GetCMP3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CMP3.Reg) & 0x200000) >> 21
}
func (o *ACMP_Type) SetCMP3_VLADREF(value uint32) {
	volatile.StoreUint32(&o.CMP3.Reg, volatile.LoadUint32(&o.CMP3.Reg)&^(0x400000)|value<<22)
}
func (o *ACMP_Type) GetCMP3_VLADREF() uint32 {
	return (volatile.LoadUint32(&o.CMP3.Reg) & 0x400000) >> 22
}
func (o *ACMP_Type) SetCMP3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CMP3.Reg, volatile.LoadUint32(&o.CMP3.Reg)&^(0x800000)|value<<23)
}
func (o *ACMP_Type) GetCMP3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CMP3.Reg) & 0x800000) >> 23
}
func (o *ACMP_Type) SetCMP3_VSEL(value uint32) {
	volatile.StoreUint32(&o.CMP3.Reg, volatile.LoadUint32(&o.CMP3.Reg)&^(0x1f000000)|value<<24)
}
func (o *ACMP_Type) GetCMP3_VSEL() uint32 {
	return (volatile.LoadUint32(&o.CMP3.Reg) & 0x1f000000) >> 24
}
func (o *ACMP_Type) SetCMP3_DLY(value uint32) {
	volatile.StoreUint32(&o.CMP3.Reg, volatile.LoadUint32(&o.CMP3.Reg)&^(0x60000000)|value<<29)
}
func (o *ACMP_Type) GetCMP3_DLY() uint32 {
	return (volatile.LoadUint32(&o.CMP3.Reg) & 0x60000000) >> 29
}
func (o *ACMP_Type) SetCMP3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CMP3.Reg, volatile.LoadUint32(&o.CMP3.Reg)&^(0x80000000)|value<<31)
}
func (o *ACMP_Type) GetCMP3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CMP3.Reg) & 0x80000000) >> 31
}

// ACMP.CMPFILTR3: Comparator 0 pin filter set-up
func (o *ACMP_Type) SetCMPFILTR3_S_MODE(value uint32) {
	volatile.StoreUint32(&o.CMPFILTR3.Reg, volatile.LoadUint32(&o.CMPFILTR3.Reg)&^(0x3)|value)
}
func (o *ACMP_Type) GetCMPFILTR3_S_MODE() uint32 {
	return volatile.LoadUint32(&o.CMPFILTR3.Reg) & 0x3
}
func (o *ACMP_Type) SetCMPFILTR3_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.CMPFILTR3.Reg, volatile.LoadUint32(&o.CMPFILTR3.Reg)&^(0x1c)|value<<2)
}
func (o *ACMP_Type) GetCMPFILTR3_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.CMPFILTR3.Reg) & 0x1c) >> 2
}
func (o *ACMP_Type) SetCMPFILTR3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CMPFILTR3.Reg, volatile.LoadUint32(&o.CMPFILTR3.Reg)&^(0xffffffe0)|value<<5)
}
func (o *ACMP_Type) GetCMPFILTR3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CMPFILTR3.Reg) & 0xffffffe0) >> 5
}

// Input multiplexing (INMUX)
type INMUX_Type struct {
	SCT0_INMUX      [7]volatile.Register32 // 0x0
	_               [4]byte
	SCT1_INMUX      [7]volatile.Register32 // 0x20
	_               [4]byte
	SCT2_INMUX      [3]volatile.Register32 // 0x40
	_               [20]byte
	SCT3_INMUX      [3]volatile.Register32 // 0x60
	_               [84]byte
	PINTSEL         [8]volatile.Register32  // 0xC0
	DMA_ITRIG_INMUX [18]volatile.Register32 // 0xE0
	_               [24]byte
	DMA_INMUX_INMUX [4]volatile.Register32 // 0x140
	_               [16]byte
	FREQMEAS_REF    volatile.Register32 // 0x160
	FREQMEAS_TARGET volatile.Register32 // 0x164
}

// INMUX.SCT0_INMUX: Pinmux register for SCT0 input 0
func (o *INMUX_Type) SetSCT0_INMUX_INP_N(idx int, value uint32) {
	volatile.StoreUint32(&o.SCT0_INMUX[idx].Reg, volatile.LoadUint32(&o.SCT0_INMUX[idx].Reg)&^(0x1f)|value)
}
func (o *INMUX_Type) GetSCT0_INMUX_INP_N(idx int) uint32 {
	return volatile.LoadUint32(&o.SCT0_INMUX[idx].Reg) & 0x1f
}
func (o *INMUX_Type) SetSCT0_INMUX_RESERVED(idx int, value uint32) {
	volatile.StoreUint32(&o.SCT0_INMUX[idx].Reg, volatile.LoadUint32(&o.SCT0_INMUX[idx].Reg)&^(0xffffffe0)|value<<5)
}
func (o *INMUX_Type) GetSCT0_INMUX_RESERVED(idx int) uint32 {
	return (volatile.LoadUint32(&o.SCT0_INMUX[idx].Reg) & 0xffffffe0) >> 5
}

// INMUX.SCT1_INMUX: Pinmux register for SCT1 input 0
func (o *INMUX_Type) SetSCT1_INMUX_INP_N(idx int, value uint32) {
	volatile.StoreUint32(&o.SCT1_INMUX[idx].Reg, volatile.LoadUint32(&o.SCT1_INMUX[idx].Reg)&^(0x1f)|value)
}
func (o *INMUX_Type) GetSCT1_INMUX_INP_N(idx int) uint32 {
	return volatile.LoadUint32(&o.SCT1_INMUX[idx].Reg) & 0x1f
}
func (o *INMUX_Type) SetSCT1_INMUX_RESERVED(idx int, value uint32) {
	volatile.StoreUint32(&o.SCT1_INMUX[idx].Reg, volatile.LoadUint32(&o.SCT1_INMUX[idx].Reg)&^(0xffffffe0)|value<<5)
}
func (o *INMUX_Type) GetSCT1_INMUX_RESERVED(idx int) uint32 {
	return (volatile.LoadUint32(&o.SCT1_INMUX[idx].Reg) & 0xffffffe0) >> 5
}

// INMUX.SCT2_INMUX: Pinmux register for SCT2 input 0
func (o *INMUX_Type) SetSCT2_INMUX_INP_N(idx int, value uint32) {
	volatile.StoreUint32(&o.SCT2_INMUX[idx].Reg, volatile.LoadUint32(&o.SCT2_INMUX[idx].Reg)&^(0x1f)|value)
}
func (o *INMUX_Type) GetSCT2_INMUX_INP_N(idx int) uint32 {
	return volatile.LoadUint32(&o.SCT2_INMUX[idx].Reg) & 0x1f
}
func (o *INMUX_Type) SetSCT2_INMUX_RESERVED(idx int, value uint32) {
	volatile.StoreUint32(&o.SCT2_INMUX[idx].Reg, volatile.LoadUint32(&o.SCT2_INMUX[idx].Reg)&^(0xffffffe0)|value<<5)
}
func (o *INMUX_Type) GetSCT2_INMUX_RESERVED(idx int) uint32 {
	return (volatile.LoadUint32(&o.SCT2_INMUX[idx].Reg) & 0xffffffe0) >> 5
}

// INMUX.SCT3_INMUX: Pinmux register for SCT3 input 0
func (o *INMUX_Type) SetSCT3_INMUX_INP_N(idx int, value uint32) {
	volatile.StoreUint32(&o.SCT3_INMUX[idx].Reg, volatile.LoadUint32(&o.SCT3_INMUX[idx].Reg)&^(0x1f)|value)
}
func (o *INMUX_Type) GetSCT3_INMUX_INP_N(idx int) uint32 {
	return volatile.LoadUint32(&o.SCT3_INMUX[idx].Reg) & 0x1f
}
func (o *INMUX_Type) SetSCT3_INMUX_RESERVED(idx int, value uint32) {
	volatile.StoreUint32(&o.SCT3_INMUX[idx].Reg, volatile.LoadUint32(&o.SCT3_INMUX[idx].Reg)&^(0xffffffe0)|value<<5)
}
func (o *INMUX_Type) GetSCT3_INMUX_RESERVED(idx int) uint32 {
	return (volatile.LoadUint32(&o.SCT3_INMUX[idx].Reg) & 0xffffffe0) >> 5
}

// INMUX.PINTSEL: Pin interrupt select register 0
func (o *INMUX_Type) SetPINTSEL_INTPIN(idx int, value uint32) {
	volatile.StoreUint32(&o.PINTSEL[idx].Reg, volatile.LoadUint32(&o.PINTSEL[idx].Reg)&^(0xff)|value)
}
func (o *INMUX_Type) GetPINTSEL_INTPIN(idx int) uint32 {
	return volatile.LoadUint32(&o.PINTSEL[idx].Reg) & 0xff
}
func (o *INMUX_Type) SetPINTSEL_RESERVED(idx int, value uint32) {
	volatile.StoreUint32(&o.PINTSEL[idx].Reg, volatile.LoadUint32(&o.PINTSEL[idx].Reg)&^(0xffffff80)|value<<7)
}
func (o *INMUX_Type) GetPINTSEL_RESERVED(idx int) uint32 {
	return (volatile.LoadUint32(&o.PINTSEL[idx].Reg) & 0xffffff80) >> 7
}

// INMUX.DMA_ITRIG_INMUX: Trigger input for DMA channel 0 select register.
func (o *INMUX_Type) SetDMA_ITRIG_INMUX_INP_N(idx int, value uint32) {
	volatile.StoreUint32(&o.DMA_ITRIG_INMUX[idx].Reg, volatile.LoadUint32(&o.DMA_ITRIG_INMUX[idx].Reg)&^(0x1f)|value)
}
func (o *INMUX_Type) GetDMA_ITRIG_INMUX_INP_N(idx int) uint32 {
	return volatile.LoadUint32(&o.DMA_ITRIG_INMUX[idx].Reg) & 0x1f
}
func (o *INMUX_Type) SetDMA_ITRIG_INMUX_RESERVED(idx int, value uint32) {
	volatile.StoreUint32(&o.DMA_ITRIG_INMUX[idx].Reg, volatile.LoadUint32(&o.DMA_ITRIG_INMUX[idx].Reg)&^(0xffffffe0)|value<<5)
}
func (o *INMUX_Type) GetDMA_ITRIG_INMUX_RESERVED(idx int) uint32 {
	return (volatile.LoadUint32(&o.DMA_ITRIG_INMUX[idx].Reg) & 0xffffffe0) >> 5
}

// INMUX.DMA_INMUX_INMUX: DMA trigger input select register.
func (o *INMUX_Type) SetDMA_INMUX_INMUX_INP(idx int, value uint32) {
	volatile.StoreUint32(&o.DMA_INMUX_INMUX[idx].Reg, volatile.LoadUint32(&o.DMA_INMUX_INMUX[idx].Reg)&^(0x1f)|value)
}
func (o *INMUX_Type) GetDMA_INMUX_INMUX_INP(idx int) uint32 {
	return volatile.LoadUint32(&o.DMA_INMUX_INMUX[idx].Reg) & 0x1f
}
func (o *INMUX_Type) SetDMA_INMUX_INMUX_RESERVED(idx int, value uint32) {
	volatile.StoreUint32(&o.DMA_INMUX_INMUX[idx].Reg, volatile.LoadUint32(&o.DMA_INMUX_INMUX[idx].Reg)&^(0xffffffe0)|value<<5)
}
func (o *INMUX_Type) GetDMA_INMUX_INMUX_RESERVED(idx int) uint32 {
	return (volatile.LoadUint32(&o.DMA_INMUX_INMUX[idx].Reg) & 0xffffffe0) >> 5
}

// INMUX.FREQMEAS_REF: Clock selection for frequency measurement function reference clock
func (o *INMUX_Type) SetFREQMEAS_REF_CLKIN(value uint32) {
	volatile.StoreUint32(&o.FREQMEAS_REF.Reg, volatile.LoadUint32(&o.FREQMEAS_REF.Reg)&^(0xf)|value)
}
func (o *INMUX_Type) GetFREQMEAS_REF_CLKIN() uint32 {
	return volatile.LoadUint32(&o.FREQMEAS_REF.Reg) & 0xf
}
func (o *INMUX_Type) SetFREQMEAS_REF_RESERVED(value uint32) {
	volatile.StoreUint32(&o.FREQMEAS_REF.Reg, volatile.LoadUint32(&o.FREQMEAS_REF.Reg)&^(0xfffffff0)|value<<4)
}
func (o *INMUX_Type) GetFREQMEAS_REF_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.FREQMEAS_REF.Reg) & 0xfffffff0) >> 4
}

// INMUX.FREQMEAS_TARGET: Clock selection for frequency measurement function target clock
func (o *INMUX_Type) SetFREQMEAS_TARGET_CLKIN(value uint32) {
	volatile.StoreUint32(&o.FREQMEAS_TARGET.Reg, volatile.LoadUint32(&o.FREQMEAS_TARGET.Reg)&^(0xf)|value)
}
func (o *INMUX_Type) GetFREQMEAS_TARGET_CLKIN() uint32 {
	return volatile.LoadUint32(&o.FREQMEAS_TARGET.Reg) & 0xf
}
func (o *INMUX_Type) SetFREQMEAS_TARGET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.FREQMEAS_TARGET.Reg, volatile.LoadUint32(&o.FREQMEAS_TARGET.Reg)&^(0xfffffff0)|value<<4)
}
func (o *INMUX_Type) GetFREQMEAS_TARGET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.FREQMEAS_TARGET.Reg) & 0xfffffff0) >> 4
}

// Real-Time Clock (RTC)
type RTC_Type struct {
	CTRL  volatile.Register32 // 0x0
	MATCH volatile.Register32 // 0x4
	COUNT volatile.Register32 // 0x8
	WAKE  volatile.Register32 // 0xC
}

// RTC.CTRL: RTC control register
func (o *RTC_Type) SetCTRL_SWRESET(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetCTRL_SWRESET() uint32 {
	return volatile.LoadUint32(&o.CTRL.Reg) & 0x1
}
func (o *RTC_Type) SetCTRL_OFD(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x2)|value<<1)
}
func (o *RTC_Type) GetCTRL_OFD() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x2) >> 1
}
func (o *RTC_Type) SetCTRL_ALARM1HZ(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x4)|value<<2)
}
func (o *RTC_Type) GetCTRL_ALARM1HZ() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x4) >> 2
}
func (o *RTC_Type) SetCTRL_WAKE1KHZ(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x8)|value<<3)
}
func (o *RTC_Type) GetCTRL_WAKE1KHZ() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x8) >> 3
}
func (o *RTC_Type) SetCTRL_ALARMDPD_EN(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x10)|value<<4)
}
func (o *RTC_Type) GetCTRL_ALARMDPD_EN() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x10) >> 4
}
func (o *RTC_Type) SetCTRL_WAKEDPD_EN(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x20)|value<<5)
}
func (o *RTC_Type) GetCTRL_WAKEDPD_EN() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x20) >> 5
}
func (o *RTC_Type) SetCTRL_RTC1KHZ_EN(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x40)|value<<6)
}
func (o *RTC_Type) GetCTRL_RTC1KHZ_EN() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x40) >> 6
}
func (o *RTC_Type) SetCTRL_RTC_EN(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x80)|value<<7)
}
func (o *RTC_Type) GetCTRL_RTC_EN() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x80) >> 7
}
func (o *RTC_Type) SetCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0xffffff00)|value<<8)
}
func (o *RTC_Type) GetCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0xffffff00) >> 8
}

// RTC.MATCH: RTC match register
func (o *RTC_Type) SetMATCH(value uint32) {
	volatile.StoreUint32(&o.MATCH.Reg, value)
}
func (o *RTC_Type) GetMATCH() uint32 {
	return volatile.LoadUint32(&o.MATCH.Reg)
}

// RTC.COUNT: RTC counter register
func (o *RTC_Type) SetCOUNT(value uint32) {
	volatile.StoreUint32(&o.COUNT.Reg, value)
}
func (o *RTC_Type) GetCOUNT() uint32 {
	return volatile.LoadUint32(&o.COUNT.Reg)
}

// RTC.WAKE: RTC high-resolution/wake-up timer control register
func (o *RTC_Type) SetWAKE_VAL(value uint32) {
	volatile.StoreUint32(&o.WAKE.Reg, volatile.LoadUint32(&o.WAKE.Reg)&^(0xffff)|value)
}
func (o *RTC_Type) GetWAKE_VAL() uint32 {
	return volatile.LoadUint32(&o.WAKE.Reg) & 0xffff
}
func (o *RTC_Type) SetWAKE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.WAKE.Reg, volatile.LoadUint32(&o.WAKE.Reg)&^(0xffff0000)|value<<16)
}
func (o *RTC_Type) GetWAKE_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.WAKE.Reg) & 0xffff0000) >> 16
}

// Windowed Watchdog Timer (WWDT)
type WWDT_Type struct {
	MOD     volatile.Register32 // 0x0
	TC      volatile.Register32 // 0x4
	FEED    volatile.Register32 // 0x8
	TV      volatile.Register32 // 0xC
	_       [4]byte
	WARNINT volatile.Register32 // 0x14
	WINDOW  volatile.Register32 // 0x18
}

// WWDT.MOD: Watchdog mode register. This register contains the basic mode and status of the Watchdog Timer.
func (o *WWDT_Type) SetMOD_WDEN(value uint32) {
	volatile.StoreUint32(&o.MOD.Reg, volatile.LoadUint32(&o.MOD.Reg)&^(0x1)|value)
}
func (o *WWDT_Type) GetMOD_WDEN() uint32 {
	return volatile.LoadUint32(&o.MOD.Reg) & 0x1
}
func (o *WWDT_Type) SetMOD_WDRESET(value uint32) {
	volatile.StoreUint32(&o.MOD.Reg, volatile.LoadUint32(&o.MOD.Reg)&^(0x2)|value<<1)
}
func (o *WWDT_Type) GetMOD_WDRESET() uint32 {
	return (volatile.LoadUint32(&o.MOD.Reg) & 0x2) >> 1
}
func (o *WWDT_Type) SetMOD_WDTOF(value uint32) {
	volatile.StoreUint32(&o.MOD.Reg, volatile.LoadUint32(&o.MOD.Reg)&^(0x4)|value<<2)
}
func (o *WWDT_Type) GetMOD_WDTOF() uint32 {
	return (volatile.LoadUint32(&o.MOD.Reg) & 0x4) >> 2
}
func (o *WWDT_Type) SetMOD_WDINT(value uint32) {
	volatile.StoreUint32(&o.MOD.Reg, volatile.LoadUint32(&o.MOD.Reg)&^(0x8)|value<<3)
}
func (o *WWDT_Type) GetMOD_WDINT() uint32 {
	return (volatile.LoadUint32(&o.MOD.Reg) & 0x8) >> 3
}
func (o *WWDT_Type) SetMOD_WDPROTECT(value uint32) {
	volatile.StoreUint32(&o.MOD.Reg, volatile.LoadUint32(&o.MOD.Reg)&^(0x10)|value<<4)
}
func (o *WWDT_Type) GetMOD_WDPROTECT() uint32 {
	return (volatile.LoadUint32(&o.MOD.Reg) & 0x10) >> 4
}
func (o *WWDT_Type) SetMOD_LOCK(value uint32) {
	volatile.StoreUint32(&o.MOD.Reg, volatile.LoadUint32(&o.MOD.Reg)&^(0x20)|value<<5)
}
func (o *WWDT_Type) GetMOD_LOCK() uint32 {
	return (volatile.LoadUint32(&o.MOD.Reg) & 0x20) >> 5
}
func (o *WWDT_Type) SetMOD_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MOD.Reg, volatile.LoadUint32(&o.MOD.Reg)&^(0xffffffc0)|value<<6)
}
func (o *WWDT_Type) GetMOD_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MOD.Reg) & 0xffffffc0) >> 6
}

// WWDT.TC: Watchdog timer constant register. This 24-bit register determines the time-out value.
func (o *WWDT_Type) SetTC_COUNT(value uint32) {
	volatile.StoreUint32(&o.TC.Reg, volatile.LoadUint32(&o.TC.Reg)&^(0xffffff)|value)
}
func (o *WWDT_Type) GetTC_COUNT() uint32 {
	return volatile.LoadUint32(&o.TC.Reg) & 0xffffff
}
func (o *WWDT_Type) SetTC_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TC.Reg, volatile.LoadUint32(&o.TC.Reg)&^(0xff000000)|value<<24)
}
func (o *WWDT_Type) GetTC_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TC.Reg) & 0xff000000) >> 24
}

// WWDT.FEED: Watchdog feed sequence register. Writing 0xAA followed by 0x55 to this register reloads the Watchdog timer with the value contained in WDTC.
func (o *WWDT_Type) SetFEED(value uint32) {
	volatile.StoreUint32(&o.FEED.Reg, volatile.LoadUint32(&o.FEED.Reg)&^(0xff)|value)
}
func (o *WWDT_Type) GetFEED() uint32 {
	return volatile.LoadUint32(&o.FEED.Reg) & 0xff
}
func (o *WWDT_Type) SetFEED_RESERVED(value uint32) {
	volatile.StoreUint32(&o.FEED.Reg, volatile.LoadUint32(&o.FEED.Reg)&^(0xffffff00)|value<<8)
}
func (o *WWDT_Type) GetFEED_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.FEED.Reg) & 0xffffff00) >> 8
}

// WWDT.TV: Watchdog timer value register. This 24-bit register reads out the current value of the Watchdog timer.
func (o *WWDT_Type) SetTV_COUNT(value uint32) {
	volatile.StoreUint32(&o.TV.Reg, volatile.LoadUint32(&o.TV.Reg)&^(0xffffff)|value)
}
func (o *WWDT_Type) GetTV_COUNT() uint32 {
	return volatile.LoadUint32(&o.TV.Reg) & 0xffffff
}
func (o *WWDT_Type) SetTV_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TV.Reg, volatile.LoadUint32(&o.TV.Reg)&^(0xff000000)|value<<24)
}
func (o *WWDT_Type) GetTV_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TV.Reg) & 0xff000000) >> 24
}

// WWDT.WARNINT: Watchdog Warning Interrupt compare value.
func (o *WWDT_Type) SetWARNINT(value uint32) {
	volatile.StoreUint32(&o.WARNINT.Reg, volatile.LoadUint32(&o.WARNINT.Reg)&^(0x3ff)|value)
}
func (o *WWDT_Type) GetWARNINT() uint32 {
	return volatile.LoadUint32(&o.WARNINT.Reg) & 0x3ff
}
func (o *WWDT_Type) SetWARNINT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.WARNINT.Reg, volatile.LoadUint32(&o.WARNINT.Reg)&^(0xfffffc00)|value<<10)
}
func (o *WWDT_Type) GetWARNINT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.WARNINT.Reg) & 0xfffffc00) >> 10
}

// WWDT.WINDOW: Watchdog Window compare value.
func (o *WWDT_Type) SetWINDOW(value uint32) {
	volatile.StoreUint32(&o.WINDOW.Reg, volatile.LoadUint32(&o.WINDOW.Reg)&^(0xffffff)|value)
}
func (o *WWDT_Type) GetWINDOW() uint32 {
	return volatile.LoadUint32(&o.WINDOW.Reg) & 0xffffff
}
func (o *WWDT_Type) SetWINDOW_RESERVED(value uint32) {
	volatile.StoreUint32(&o.WINDOW.Reg, volatile.LoadUint32(&o.WINDOW.Reg)&^(0xff000000)|value<<24)
}
func (o *WWDT_Type) GetWINDOW_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.WINDOW.Reg) & 0xff000000) >> 24
}

// Switch Matrix (SWM)
type SWM_Type struct {
	PINASSIGN0  volatile.Register32 // 0x0
	PINASSIGN1  volatile.Register32 // 0x4
	PINASSIGN2  volatile.Register32 // 0x8
	PINASSIGN3  volatile.Register32 // 0xC
	PINASSIGN4  volatile.Register32 // 0x10
	PINASSIGN5  volatile.Register32 // 0x14
	PINASSIGN6  volatile.Register32 // 0x18
	PINASSIGN7  volatile.Register32 // 0x1C
	PINASSIGN8  volatile.Register32 // 0x20
	PINASSIGN9  volatile.Register32 // 0x24
	PINASSIGN10 volatile.Register32 // 0x28
	PINASSIGN11 volatile.Register32 // 0x2C
	PINASSIGN12 volatile.Register32 // 0x30
	PINASSIGN13 volatile.Register32 // 0x34
	PINASSIGN14 volatile.Register32 // 0x38
	PINASSIGN15 volatile.Register32 // 0x3C
	_           [384]byte
	PINENABLE0  volatile.Register32 // 0x1C0
	PINENABLE1  volatile.Register32 // 0x1C4
}

// SWM.PINASSIGN0: Pin assign register 0. Assign movable functions U0_TXD, U0_RXD, U0_RTS, U0_CTS.
func (o *SWM_Type) SetPINASSIGN0_UART0_TXD_O(value uint32) {
	volatile.StoreUint32(&o.PINASSIGN0.Reg, volatile.LoadUint32(&o.PINASSIGN0.Reg)&^(0xff)|value)
}
func (o *SWM_Type) GetPINASSIGN0_UART0_TXD_O() uint32 {
	return volatile.LoadUint32(&o.PINASSIGN0.Reg) & 0xff
}
func (o *SWM_Type) SetPINASSIGN0_UART0_RXD_I(value uint32) {
	volatile.StoreUint32(&o.PINASSIGN0.Reg, volatile.LoadUint32(&o.PINASSIGN0.Reg)&^(0xff00)|value<<8)
}
func (o *SWM_Type) GetPINASSIGN0_UART0_RXD_I() uint32 {
	return (volatile.LoadUint32(&o.PINASSIGN0.Reg) & 0xff00) >> 8
}
func (o *SWM_Type) SetPINASSIGN0_UART0_RTS_O(value uint32) {
	volatile.StoreUint32(&o.PINASSIGN0.Reg, volatile.LoadUint32(&o.PINASSIGN0.Reg)&^(0xff0000)|value<<16)
}
func (o *SWM_Type) GetPINASSIGN0_UART0_RTS_O() uint32 {
	return (volatile.LoadUint32(&o.PINASSIGN0.Reg) & 0xff0000) >> 16
}
func (o *SWM_Type) SetPINASSIGN0_UART0_CTS_I(value uint32) {
	volatile.StoreUint32(&o.PINASSIGN0.Reg, volatile.LoadUint32(&o.PINASSIGN0.Reg)&^(0xff000000)|value<<24)
}
func (o *SWM_Type) GetPINASSIGN0_UART0_CTS_I() uint32 {
	return (volatile.LoadUint32(&o.PINASSIGN0.Reg) & 0xff000000) >> 24
}

// SWM.PINASSIGN1: Pin assign register 1. Assign movable functions U0_SCLK, U1_TXD, U1_RXD, U1_RTS.
func (o *SWM_Type) SetPINASSIGN1_UART0_SCLK_IO(value uint32) {
	volatile.StoreUint32(&o.PINASSIGN1.Reg, volatile.LoadUint32(&o.PINASSIGN1.Reg)&^(0xff)|value)
}
func (o *SWM_Type) GetPINASSIGN1_UART0_SCLK_IO() uint32 {
	return volatile.LoadUint32(&o.PINASSIGN1.Reg) & 0xff
}
func (o *SWM_Type) SetPINASSIGN1_UART1_TXD_O(value uint32) {
	volatile.StoreUint32(&o.PINASSIGN1.Reg, volatile.LoadUint32(&o.PINASSIGN1.Reg)&^(0xff00)|value<<8)
}
func (o *SWM_Type) GetPINASSIGN1_UART1_TXD_O() uint32 {
	return (volatile.LoadUint32(&o.PINASSIGN1.Reg) & 0xff00) >> 8
}
func (o *SWM_Type) SetPINASSIGN1_UART1_RXD_I(value uint32) {
	volatile.StoreUint32(&o.PINASSIGN1.Reg, volatile.LoadUint32(&o.PINASSIGN1.Reg)&^(0xff0000)|value<<16)
}
func (o *SWM_Type) GetPINASSIGN1_UART1_RXD_I() uint32 {
	return (volatile.LoadUint32(&o.PINASSIGN1.Reg) & 0xff0000) >> 16
}
func (o *SWM_Type) SetPINASSIGN1_UART1_RTS_O(value uint32) {
	volatile.StoreUint32(&o.PINASSIGN1.Reg, volatile.LoadUint32(&o.PINASSIGN1.Reg)&^(0xff000000)|value<<24)
}
func (o *SWM_Type) GetPINASSIGN1_UART1_RTS_O() uint32 {
	return (volatile.LoadUint32(&o.PINASSIGN1.Reg) & 0xff000000) >> 24
}

// SWM.PINASSIGN2: Pin assign register 2. Assign movable functions U1_CTS, U1_SCLK, U2_TXD, U2_RXD.
func (o *SWM_Type) SetPINASSIGN2_UART1_CTS_I(value uint32) {
	volatile.StoreUint32(&o.PINASSIGN2.Reg, volatile.LoadUint32(&o.PINASSIGN2.Reg)&^(0xff)|value)
}
func (o *SWM_Type) GetPINASSIGN2_UART1_CTS_I() uint32 {
	return volatile.LoadUint32(&o.PINASSIGN2.Reg) & 0xff
}
func (o *SWM_Type) SetPINASSIGN2_UART1_SCLK_IO(value uint32) {
	volatile.StoreUint32(&o.PINASSIGN2.Reg, volatile.LoadUint32(&o.PINASSIGN2.Reg)&^(0xff00)|value<<8)
}
func (o *SWM_Type) GetPINASSIGN2_UART1_SCLK_IO() uint32 {
	return (volatile.LoadUint32(&o.PINASSIGN2.Reg) & 0xff00) >> 8
}
func (o *SWM_Type) SetPINASSIGN2_UART2_TXD_O(value uint32) {
	volatile.StoreUint32(&o.PINASSIGN2.Reg, volatile.LoadUint32(&o.PINASSIGN2.Reg)&^(0xff0000)|value<<16)
}
func (o *SWM_Type) GetPINASSIGN2_UART2_TXD_O() uint32 {
	return (volatile.LoadUint32(&o.PINASSIGN2.Reg) & 0xff0000) >> 16
}
func (o *SWM_Type) SetPINASSIGN2_UART2_RXD_I(value uint32) {
	volatile.StoreUint32(&o.PINASSIGN2.Reg, volatile.LoadUint32(&o.PINASSIGN2.Reg)&^(0xff000000)|value<<24)
}
func (o *SWM_Type) GetPINASSIGN2_UART2_RXD_I() uint32 {
	return (volatile.LoadUint32(&o.PINASSIGN2.Reg) & 0xff000000) >> 24
}

// SWM.PINASSIGN3: Pin assign register 3. Assign movable function .
func (o *SWM_Type) SetPINASSIGN3_UART2_SCLK_IO(value uint32) {
	volatile.StoreUint32(&o.PINASSIGN3.Reg, volatile.LoadUint32(&o.PINASSIGN3.Reg)&^(0xff)|value)
}
func (o *SWM_Type) GetPINASSIGN3_UART2_SCLK_IO() uint32 {
	return volatile.LoadUint32(&o.PINASSIGN3.Reg) & 0xff
}
func (o *SWM_Type) SetPINASSIGN3_SSP0_SCK_IO(value uint32) {
	volatile.StoreUint32(&o.PINASSIGN3.Reg, volatile.LoadUint32(&o.PINASSIGN3.Reg)&^(0xff00)|value<<8)
}
func (o *SWM_Type) GetPINASSIGN3_SSP0_SCK_IO() uint32 {
	return (volatile.LoadUint32(&o.PINASSIGN3.Reg) & 0xff00) >> 8
}
func (o *SWM_Type) SetPINASSIGN3_SSP0_MOSI_IO(value uint32) {
	volatile.StoreUint32(&o.PINASSIGN3.Reg, volatile.LoadUint32(&o.PINASSIGN3.Reg)&^(0xff0000)|value<<16)
}
func (o *SWM_Type) GetPINASSIGN3_SSP0_MOSI_IO() uint32 {
	return (volatile.LoadUint32(&o.PINASSIGN3.Reg) & 0xff0000) >> 16
}
func (o *SWM_Type) SetPINASSIGN3_SSP0_MISO_IO(value uint32) {
	volatile.StoreUint32(&o.PINASSIGN3.Reg, volatile.LoadUint32(&o.PINASSIGN3.Reg)&^(0xff000000)|value<<24)
}
func (o *SWM_Type) GetPINASSIGN3_SSP0_MISO_IO() uint32 {
	return (volatile.LoadUint32(&o.PINASSIGN3.Reg) & 0xff000000) >> 24
}

// SWM.PINASSIGN4: Pin assign register 4. Assign movable functions
func (o *SWM_Type) SetPINASSIGN4_SSP0_SSELSN_0_IO(value uint32) {
	volatile.StoreUint32(&o.PINASSIGN4.Reg, volatile.LoadUint32(&o.PINASSIGN4.Reg)&^(0xff)|value)
}
func (o *SWM_Type) GetPINASSIGN4_SSP0_SSELSN_0_IO() uint32 {
	return volatile.LoadUint32(&o.PINASSIGN4.Reg) & 0xff
}
func (o *SWM_Type) SetPINASSIGN4_SSP0_SSELSN_1_IO(value uint32) {
	volatile.StoreUint32(&o.PINASSIGN4.Reg, volatile.LoadUint32(&o.PINASSIGN4.Reg)&^(0xff00)|value<<8)
}
func (o *SWM_Type) GetPINASSIGN4_SSP0_SSELSN_1_IO() uint32 {
	return (volatile.LoadUint32(&o.PINASSIGN4.Reg) & 0xff00) >> 8
}
func (o *SWM_Type) SetPINASSIGN4_SSP0_SSELSN_2_IO(value uint32) {
	volatile.StoreUint32(&o.PINASSIGN4.Reg, volatile.LoadUint32(&o.PINASSIGN4.Reg)&^(0xff0000)|value<<16)
}
func (o *SWM_Type) GetPINASSIGN4_SSP0_SSELSN_2_IO() uint32 {
	return (volatile.LoadUint32(&o.PINASSIGN4.Reg) & 0xff0000) >> 16
}
func (o *SWM_Type) SetPINASSIGN4_SSP0_SSELSN_3_IO(value uint32) {
	volatile.StoreUint32(&o.PINASSIGN4.Reg, volatile.LoadUint32(&o.PINASSIGN4.Reg)&^(0xff000000)|value<<24)
}
func (o *SWM_Type) GetPINASSIGN4_SSP0_SSELSN_3_IO() uint32 {
	return (volatile.LoadUint32(&o.PINASSIGN4.Reg) & 0xff000000) >> 24
}

// SWM.PINASSIGN5: Pin assign register 5. Assign movable functions
func (o *SWM_Type) SetPINASSIGN5_SSP1_SCK_IO(value uint32) {
	volatile.StoreUint32(&o.PINASSIGN5.Reg, volatile.LoadUint32(&o.PINASSIGN5.Reg)&^(0xff)|value)
}
func (o *SWM_Type) GetPINASSIGN5_SSP1_SCK_IO() uint32 {
	return volatile.LoadUint32(&o.PINASSIGN5.Reg) & 0xff
}
func (o *SWM_Type) SetPINASSIGN5_SSP1_MOSI_IO(value uint32) {
	volatile.StoreUint32(&o.PINASSIGN5.Reg, volatile.LoadUint32(&o.PINASSIGN5.Reg)&^(0xff00)|value<<8)
}
func (o *SWM_Type) GetPINASSIGN5_SSP1_MOSI_IO() uint32 {
	return (volatile.LoadUint32(&o.PINASSIGN5.Reg) & 0xff00) >> 8
}
func (o *SWM_Type) SetPINASSIGN5_SSP1_MISO_IO(value uint32) {
	volatile.StoreUint32(&o.PINASSIGN5.Reg, volatile.LoadUint32(&o.PINASSIGN5.Reg)&^(0xff0000)|value<<16)
}
func (o *SWM_Type) GetPINASSIGN5_SSP1_MISO_IO() uint32 {
	return (volatile.LoadUint32(&o.PINASSIGN5.Reg) & 0xff0000) >> 16
}
func (o *SWM_Type) SetPINASSIGN5_SSP1_SSELSN_0_IO(value uint32) {
	volatile.StoreUint32(&o.PINASSIGN5.Reg, volatile.LoadUint32(&o.PINASSIGN5.Reg)&^(0xff000000)|value<<24)
}
func (o *SWM_Type) GetPINASSIGN5_SSP1_SSELSN_0_IO() uint32 {
	return (volatile.LoadUint32(&o.PINASSIGN5.Reg) & 0xff000000) >> 24
}

// SWM.PINASSIGN6: Pin assign register 6. Assign movable functions
func (o *SWM_Type) SetPINASSIGN6_SSP1_SSELSN_1_IO(value uint32) {
	volatile.StoreUint32(&o.PINASSIGN6.Reg, volatile.LoadUint32(&o.PINASSIGN6.Reg)&^(0xff)|value)
}
func (o *SWM_Type) GetPINASSIGN6_SSP1_SSELSN_1_IO() uint32 {
	return volatile.LoadUint32(&o.PINASSIGN6.Reg) & 0xff
}
func (o *SWM_Type) SetPINASSIGN6_CAN_TD1_O(value uint32) {
	volatile.StoreUint32(&o.PINASSIGN6.Reg, volatile.LoadUint32(&o.PINASSIGN6.Reg)&^(0xff00)|value<<8)
}
func (o *SWM_Type) GetPINASSIGN6_CAN_TD1_O() uint32 {
	return (volatile.LoadUint32(&o.PINASSIGN6.Reg) & 0xff00) >> 8
}
func (o *SWM_Type) SetPINASSIGN6_CAN_RD1_I(value uint32) {
	volatile.StoreUint32(&o.PINASSIGN6.Reg, volatile.LoadUint32(&o.PINASSIGN6.Reg)&^(0xff0000)|value<<16)
}
func (o *SWM_Type) GetPINASSIGN6_CAN_RD1_I() uint32 {
	return (volatile.LoadUint32(&o.PINASSIGN6.Reg) & 0xff0000) >> 16
}
func (o *SWM_Type) SetPINASSIGN6_USB_CONNECTN_O(value uint32) {
	volatile.StoreUint32(&o.PINASSIGN6.Reg, volatile.LoadUint32(&o.PINASSIGN6.Reg)&^(0xff000000)|value<<24)
}
func (o *SWM_Type) GetPINASSIGN6_USB_CONNECTN_O() uint32 {
	return (volatile.LoadUint32(&o.PINASSIGN6.Reg) & 0xff000000) >> 24
}

// SWM.PINASSIGN7: Pin assign register 7. Assign movable functions
func (o *SWM_Type) SetPINASSIGN7_USB_VBUS_I(value uint32) {
	volatile.StoreUint32(&o.PINASSIGN7.Reg, volatile.LoadUint32(&o.PINASSIGN7.Reg)&^(0xff)|value)
}
func (o *SWM_Type) GetPINASSIGN7_USB_VBUS_I() uint32 {
	return volatile.LoadUint32(&o.PINASSIGN7.Reg) & 0xff
}
func (o *SWM_Type) SetPINASSIGN7_SCT0_OUT0_O(value uint32) {
	volatile.StoreUint32(&o.PINASSIGN7.Reg, volatile.LoadUint32(&o.PINASSIGN7.Reg)&^(0xff00)|value<<8)
}
func (o *SWM_Type) GetPINASSIGN7_SCT0_OUT0_O() uint32 {
	return (volatile.LoadUint32(&o.PINASSIGN7.Reg) & 0xff00) >> 8
}
func (o *SWM_Type) SetPINASSIGN7_SCT0_OUT1_O(value uint32) {
	volatile.StoreUint32(&o.PINASSIGN7.Reg, volatile.LoadUint32(&o.PINASSIGN7.Reg)&^(0xff0000)|value<<16)
}
func (o *SWM_Type) GetPINASSIGN7_SCT0_OUT1_O() uint32 {
	return (volatile.LoadUint32(&o.PINASSIGN7.Reg) & 0xff0000) >> 16
}
func (o *SWM_Type) SetPINASSIGN7_SCT0_OUT2_O(value uint32) {
	volatile.StoreUint32(&o.PINASSIGN7.Reg, volatile.LoadUint32(&o.PINASSIGN7.Reg)&^(0xff000000)|value<<24)
}
func (o *SWM_Type) GetPINASSIGN7_SCT0_OUT2_O() uint32 {
	return (volatile.LoadUint32(&o.PINASSIGN7.Reg) & 0xff000000) >> 24
}

// SWM.PINASSIGN8: Pin assign register 8. Assign movable functions
func (o *SWM_Type) SetPINASSIGN8_SCT1_OUT0_O(value uint32) {
	volatile.StoreUint32(&o.PINASSIGN8.Reg, volatile.LoadUint32(&o.PINASSIGN8.Reg)&^(0xff)|value)
}
func (o *SWM_Type) GetPINASSIGN8_SCT1_OUT0_O() uint32 {
	return volatile.LoadUint32(&o.PINASSIGN8.Reg) & 0xff
}
func (o *SWM_Type) SetPINASSIGN8_SCT1_OUT1_O(value uint32) {
	volatile.StoreUint32(&o.PINASSIGN8.Reg, volatile.LoadUint32(&o.PINASSIGN8.Reg)&^(0xff00)|value<<8)
}
func (o *SWM_Type) GetPINASSIGN8_SCT1_OUT1_O() uint32 {
	return (volatile.LoadUint32(&o.PINASSIGN8.Reg) & 0xff00) >> 8
}
func (o *SWM_Type) SetPINASSIGN8_SCT1_OUT2_O(value uint32) {
	volatile.StoreUint32(&o.PINASSIGN8.Reg, volatile.LoadUint32(&o.PINASSIGN8.Reg)&^(0xff0000)|value<<16)
}
func (o *SWM_Type) GetPINASSIGN8_SCT1_OUT2_O() uint32 {
	return (volatile.LoadUint32(&o.PINASSIGN8.Reg) & 0xff0000) >> 16
}
func (o *SWM_Type) SetPINASSIGN8_SCT2_OUT0_O(value uint32) {
	volatile.StoreUint32(&o.PINASSIGN8.Reg, volatile.LoadUint32(&o.PINASSIGN8.Reg)&^(0xff000000)|value<<24)
}
func (o *SWM_Type) GetPINASSIGN8_SCT2_OUT0_O() uint32 {
	return (volatile.LoadUint32(&o.PINASSIGN8.Reg) & 0xff000000) >> 24
}

// SWM.PINASSIGN9: Pin assign register 9. Assign movable functions
func (o *SWM_Type) SetPINASSIGN9_SCT2_OUT1_O(value uint32) {
	volatile.StoreUint32(&o.PINASSIGN9.Reg, volatile.LoadUint32(&o.PINASSIGN9.Reg)&^(0xff)|value)
}
func (o *SWM_Type) GetPINASSIGN9_SCT2_OUT1_O() uint32 {
	return volatile.LoadUint32(&o.PINASSIGN9.Reg) & 0xff
}
func (o *SWM_Type) SetPINASSIGN9_SCT2_OUT2_O(value uint32) {
	volatile.StoreUint32(&o.PINASSIGN9.Reg, volatile.LoadUint32(&o.PINASSIGN9.Reg)&^(0xff00)|value<<8)
}
func (o *SWM_Type) GetPINASSIGN9_SCT2_OUT2_O() uint32 {
	return (volatile.LoadUint32(&o.PINASSIGN9.Reg) & 0xff00) >> 8
}
func (o *SWM_Type) SetPINASSIGN9_SCT3_OUT0_O(value uint32) {
	volatile.StoreUint32(&o.PINASSIGN9.Reg, volatile.LoadUint32(&o.PINASSIGN9.Reg)&^(0xff0000)|value<<16)
}
func (o *SWM_Type) GetPINASSIGN9_SCT3_OUT0_O() uint32 {
	return (volatile.LoadUint32(&o.PINASSIGN9.Reg) & 0xff0000) >> 16
}
func (o *SWM_Type) SetPINASSIGN9_SCT3_OUT1_O(value uint32) {
	volatile.StoreUint32(&o.PINASSIGN9.Reg, volatile.LoadUint32(&o.PINASSIGN9.Reg)&^(0xff000000)|value<<24)
}
func (o *SWM_Type) GetPINASSIGN9_SCT3_OUT1_O() uint32 {
	return (volatile.LoadUint32(&o.PINASSIGN9.Reg) & 0xff000000) >> 24
}

// SWM.PINASSIGN10: Pin assign register 10. Assign movable functions
func (o *SWM_Type) SetPINASSIGN10_SCT3_OUT2_O(value uint32) {
	volatile.StoreUint32(&o.PINASSIGN10.Reg, volatile.LoadUint32(&o.PINASSIGN10.Reg)&^(0xff)|value)
}
func (o *SWM_Type) GetPINASSIGN10_SCT3_OUT2_O() uint32 {
	return volatile.LoadUint32(&o.PINASSIGN10.Reg) & 0xff
}
func (o *SWM_Type) SetPINASSIGN10_SCT_ABORT0_I(value uint32) {
	volatile.StoreUint32(&o.PINASSIGN10.Reg, volatile.LoadUint32(&o.PINASSIGN10.Reg)&^(0xff00)|value<<8)
}
func (o *SWM_Type) GetPINASSIGN10_SCT_ABORT0_I() uint32 {
	return (volatile.LoadUint32(&o.PINASSIGN10.Reg) & 0xff00) >> 8
}
func (o *SWM_Type) SetPINASSIGN10_SCT_ABORT1_I(value uint32) {
	volatile.StoreUint32(&o.PINASSIGN10.Reg, volatile.LoadUint32(&o.PINASSIGN10.Reg)&^(0xff0000)|value<<16)
}
func (o *SWM_Type) GetPINASSIGN10_SCT_ABORT1_I() uint32 {
	return (volatile.LoadUint32(&o.PINASSIGN10.Reg) & 0xff0000) >> 16
}
func (o *SWM_Type) SetPINASSIGN10_ADC0_PIN_TRIG0_I(value uint32) {
	volatile.StoreUint32(&o.PINASSIGN10.Reg, volatile.LoadUint32(&o.PINASSIGN10.Reg)&^(0xff000000)|value<<24)
}
func (o *SWM_Type) GetPINASSIGN10_ADC0_PIN_TRIG0_I() uint32 {
	return (volatile.LoadUint32(&o.PINASSIGN10.Reg) & 0xff000000) >> 24
}

// SWM.PINASSIGN11: Pin assign register 11. Assign movable functions
func (o *SWM_Type) SetPINASSIGN11_ADC0_PIN_TRIG1_I(value uint32) {
	volatile.StoreUint32(&o.PINASSIGN11.Reg, volatile.LoadUint32(&o.PINASSIGN11.Reg)&^(0xff)|value)
}
func (o *SWM_Type) GetPINASSIGN11_ADC0_PIN_TRIG1_I() uint32 {
	return volatile.LoadUint32(&o.PINASSIGN11.Reg) & 0xff
}
func (o *SWM_Type) SetPINASSIGN11_ADC1_PIN_TRIG0_I(value uint32) {
	volatile.StoreUint32(&o.PINASSIGN11.Reg, volatile.LoadUint32(&o.PINASSIGN11.Reg)&^(0xff00)|value<<8)
}
func (o *SWM_Type) GetPINASSIGN11_ADC1_PIN_TRIG0_I() uint32 {
	return (volatile.LoadUint32(&o.PINASSIGN11.Reg) & 0xff00) >> 8
}
func (o *SWM_Type) SetPINASSIGN11_ADC1_PIN_TRIG1_I(value uint32) {
	volatile.StoreUint32(&o.PINASSIGN11.Reg, volatile.LoadUint32(&o.PINASSIGN11.Reg)&^(0xff0000)|value<<16)
}
func (o *SWM_Type) GetPINASSIGN11_ADC1_PIN_TRIG1_I() uint32 {
	return (volatile.LoadUint32(&o.PINASSIGN11.Reg) & 0xff0000) >> 16
}
func (o *SWM_Type) SetPINASSIGN11_DAC_PIN_TRIG_I(value uint32) {
	volatile.StoreUint32(&o.PINASSIGN11.Reg, volatile.LoadUint32(&o.PINASSIGN11.Reg)&^(0xff000000)|value<<24)
}
func (o *SWM_Type) GetPINASSIGN11_DAC_PIN_TRIG_I() uint32 {
	return (volatile.LoadUint32(&o.PINASSIGN11.Reg) & 0xff000000) >> 24
}

// SWM.PINASSIGN12: Pin assign register 12. Assign movable functions
func (o *SWM_Type) SetPINASSIGN12_DAC_SHUTOFF_I(value uint32) {
	volatile.StoreUint32(&o.PINASSIGN12.Reg, volatile.LoadUint32(&o.PINASSIGN12.Reg)&^(0xff)|value)
}
func (o *SWM_Type) GetPINASSIGN12_DAC_SHUTOFF_I() uint32 {
	return volatile.LoadUint32(&o.PINASSIGN12.Reg) & 0xff
}
func (o *SWM_Type) SetPINASSIGN12_ACMP0_OUT_O(value uint32) {
	volatile.StoreUint32(&o.PINASSIGN12.Reg, volatile.LoadUint32(&o.PINASSIGN12.Reg)&^(0xff00)|value<<8)
}
func (o *SWM_Type) GetPINASSIGN12_ACMP0_OUT_O() uint32 {
	return (volatile.LoadUint32(&o.PINASSIGN12.Reg) & 0xff00) >> 8
}
func (o *SWM_Type) SetPINASSIGN12_ACMP1_OUT_O(value uint32) {
	volatile.StoreUint32(&o.PINASSIGN12.Reg, volatile.LoadUint32(&o.PINASSIGN12.Reg)&^(0xff0000)|value<<16)
}
func (o *SWM_Type) GetPINASSIGN12_ACMP1_OUT_O() uint32 {
	return (volatile.LoadUint32(&o.PINASSIGN12.Reg) & 0xff0000) >> 16
}
func (o *SWM_Type) SetPINASSIGN12_ACMP2_OUT_O(value uint32) {
	volatile.StoreUint32(&o.PINASSIGN12.Reg, volatile.LoadUint32(&o.PINASSIGN12.Reg)&^(0xff000000)|value<<24)
}
func (o *SWM_Type) GetPINASSIGN12_ACMP2_OUT_O() uint32 {
	return (volatile.LoadUint32(&o.PINASSIGN12.Reg) & 0xff000000) >> 24
}

// SWM.PINASSIGN13: Pin assign register 13. Assign movable functions
func (o *SWM_Type) SetPINASSIGN13_ACMP3_OUT_O(value uint32) {
	volatile.StoreUint32(&o.PINASSIGN13.Reg, volatile.LoadUint32(&o.PINASSIGN13.Reg)&^(0xff)|value)
}
func (o *SWM_Type) GetPINASSIGN13_ACMP3_OUT_O() uint32 {
	return volatile.LoadUint32(&o.PINASSIGN13.Reg) & 0xff
}
func (o *SWM_Type) SetPINASSIGN13_CLK_OUT_O(value uint32) {
	volatile.StoreUint32(&o.PINASSIGN13.Reg, volatile.LoadUint32(&o.PINASSIGN13.Reg)&^(0xff00)|value<<8)
}
func (o *SWM_Type) GetPINASSIGN13_CLK_OUT_O() uint32 {
	return (volatile.LoadUint32(&o.PINASSIGN13.Reg) & 0xff00) >> 8
}
func (o *SWM_Type) SetPINASSIGN13_ROSC0_O(value uint32) {
	volatile.StoreUint32(&o.PINASSIGN13.Reg, volatile.LoadUint32(&o.PINASSIGN13.Reg)&^(0xff0000)|value<<16)
}
func (o *SWM_Type) GetPINASSIGN13_ROSC0_O() uint32 {
	return (volatile.LoadUint32(&o.PINASSIGN13.Reg) & 0xff0000) >> 16
}
func (o *SWM_Type) SetPINASSIGN13_ROSC_RST0_I(value uint32) {
	volatile.StoreUint32(&o.PINASSIGN13.Reg, volatile.LoadUint32(&o.PINASSIGN13.Reg)&^(0xff000000)|value<<24)
}
func (o *SWM_Type) GetPINASSIGN13_ROSC_RST0_I() uint32 {
	return (volatile.LoadUint32(&o.PINASSIGN13.Reg) & 0xff000000) >> 24
}

// SWM.PINASSIGN14: Pin assign register 14. Assign movable functions
func (o *SWM_Type) SetPINASSIGN14_USB_FRAME_TOG_O(value uint32) {
	volatile.StoreUint32(&o.PINASSIGN14.Reg, volatile.LoadUint32(&o.PINASSIGN14.Reg)&^(0xff)|value)
}
func (o *SWM_Type) GetPINASSIGN14_USB_FRAME_TOG_O() uint32 {
	return volatile.LoadUint32(&o.PINASSIGN14.Reg) & 0xff
}
func (o *SWM_Type) SetPINASSIGN14_QEI0_PHA_I(value uint32) {
	volatile.StoreUint32(&o.PINASSIGN14.Reg, volatile.LoadUint32(&o.PINASSIGN14.Reg)&^(0xff00)|value<<8)
}
func (o *SWM_Type) GetPINASSIGN14_QEI0_PHA_I() uint32 {
	return (volatile.LoadUint32(&o.PINASSIGN14.Reg) & 0xff00) >> 8
}
func (o *SWM_Type) SetPINASSIGN14_QEI0_PHB_I(value uint32) {
	volatile.StoreUint32(&o.PINASSIGN14.Reg, volatile.LoadUint32(&o.PINASSIGN14.Reg)&^(0xff0000)|value<<16)
}
func (o *SWM_Type) GetPINASSIGN14_QEI0_PHB_I() uint32 {
	return (volatile.LoadUint32(&o.PINASSIGN14.Reg) & 0xff0000) >> 16
}
func (o *SWM_Type) SetPINASSIGN14_QEI0_IDX_I(value uint32) {
	volatile.StoreUint32(&o.PINASSIGN14.Reg, volatile.LoadUint32(&o.PINASSIGN14.Reg)&^(0xff000000)|value<<24)
}
func (o *SWM_Type) GetPINASSIGN14_QEI0_IDX_I() uint32 {
	return (volatile.LoadUint32(&o.PINASSIGN14.Reg) & 0xff000000) >> 24
}

// SWM.PINASSIGN15: Pin assign register 15. Assign movable functions
func (o *SWM_Type) SetPINASSIGN15_GPIO_INT_BMATCH_O(value uint32) {
	volatile.StoreUint32(&o.PINASSIGN15.Reg, volatile.LoadUint32(&o.PINASSIGN15.Reg)&^(0xff)|value)
}
func (o *SWM_Type) GetPINASSIGN15_GPIO_INT_BMATCH_O() uint32 {
	return volatile.LoadUint32(&o.PINASSIGN15.Reg) & 0xff
}
func (o *SWM_Type) SetPINASSIGN15_SWO_O(value uint32) {
	volatile.StoreUint32(&o.PINASSIGN15.Reg, volatile.LoadUint32(&o.PINASSIGN15.Reg)&^(0xff00)|value<<8)
}
func (o *SWM_Type) GetPINASSIGN15_SWO_O() uint32 {
	return (volatile.LoadUint32(&o.PINASSIGN15.Reg) & 0xff00) >> 8
}
func (o *SWM_Type) SetPINASSIGN15_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PINASSIGN15.Reg, volatile.LoadUint32(&o.PINASSIGN15.Reg)&^(0xff0000)|value<<16)
}
func (o *SWM_Type) GetPINASSIGN15_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PINASSIGN15.Reg) & 0xff0000) >> 16
}
func (o *SWM_Type) SetPINASSIGN15_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PINASSIGN15.Reg, volatile.LoadUint32(&o.PINASSIGN15.Reg)&^(0xff000000)|value<<24)
}
func (o *SWM_Type) GetPINASSIGN15_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PINASSIGN15.Reg) & 0xff000000) >> 24
}

// SWM.PINENABLE0: Pin enable register 0. Enables fixed-pin functions
func (o *SWM_Type) SetPINENABLE0_ADC0_0(value uint32) {
	volatile.StoreUint32(&o.PINENABLE0.Reg, volatile.LoadUint32(&o.PINENABLE0.Reg)&^(0x1)|value)
}
func (o *SWM_Type) GetPINENABLE0_ADC0_0() uint32 {
	return volatile.LoadUint32(&o.PINENABLE0.Reg) & 0x1
}
func (o *SWM_Type) SetPINENABLE0_ADC0_1(value uint32) {
	volatile.StoreUint32(&o.PINENABLE0.Reg, volatile.LoadUint32(&o.PINENABLE0.Reg)&^(0x2)|value<<1)
}
func (o *SWM_Type) GetPINENABLE0_ADC0_1() uint32 {
	return (volatile.LoadUint32(&o.PINENABLE0.Reg) & 0x2) >> 1
}
func (o *SWM_Type) SetPINENABLE0_ADC0_2(value uint32) {
	volatile.StoreUint32(&o.PINENABLE0.Reg, volatile.LoadUint32(&o.PINENABLE0.Reg)&^(0x4)|value<<2)
}
func (o *SWM_Type) GetPINENABLE0_ADC0_2() uint32 {
	return (volatile.LoadUint32(&o.PINENABLE0.Reg) & 0x4) >> 2
}
func (o *SWM_Type) SetPINENABLE0_ADC0_3(value uint32) {
	volatile.StoreUint32(&o.PINENABLE0.Reg, volatile.LoadUint32(&o.PINENABLE0.Reg)&^(0x8)|value<<3)
}
func (o *SWM_Type) GetPINENABLE0_ADC0_3() uint32 {
	return (volatile.LoadUint32(&o.PINENABLE0.Reg) & 0x8) >> 3
}
func (o *SWM_Type) SetPINENABLE0_ADC0_4(value uint32) {
	volatile.StoreUint32(&o.PINENABLE0.Reg, volatile.LoadUint32(&o.PINENABLE0.Reg)&^(0x10)|value<<4)
}
func (o *SWM_Type) GetPINENABLE0_ADC0_4() uint32 {
	return (volatile.LoadUint32(&o.PINENABLE0.Reg) & 0x10) >> 4
}
func (o *SWM_Type) SetPINENABLE0_ADC0_5(value uint32) {
	volatile.StoreUint32(&o.PINENABLE0.Reg, volatile.LoadUint32(&o.PINENABLE0.Reg)&^(0x20)|value<<5)
}
func (o *SWM_Type) GetPINENABLE0_ADC0_5() uint32 {
	return (volatile.LoadUint32(&o.PINENABLE0.Reg) & 0x20) >> 5
}
func (o *SWM_Type) SetPINENABLE0_ADC0_6(value uint32) {
	volatile.StoreUint32(&o.PINENABLE0.Reg, volatile.LoadUint32(&o.PINENABLE0.Reg)&^(0x40)|value<<6)
}
func (o *SWM_Type) GetPINENABLE0_ADC0_6() uint32 {
	return (volatile.LoadUint32(&o.PINENABLE0.Reg) & 0x40) >> 6
}
func (o *SWM_Type) SetPINENABLE0_ADC0_7(value uint32) {
	volatile.StoreUint32(&o.PINENABLE0.Reg, volatile.LoadUint32(&o.PINENABLE0.Reg)&^(0x80)|value<<7)
}
func (o *SWM_Type) GetPINENABLE0_ADC0_7() uint32 {
	return (volatile.LoadUint32(&o.PINENABLE0.Reg) & 0x80) >> 7
}
func (o *SWM_Type) SetPINENABLE0_ADC0_8(value uint32) {
	volatile.StoreUint32(&o.PINENABLE0.Reg, volatile.LoadUint32(&o.PINENABLE0.Reg)&^(0x100)|value<<8)
}
func (o *SWM_Type) GetPINENABLE0_ADC0_8() uint32 {
	return (volatile.LoadUint32(&o.PINENABLE0.Reg) & 0x100) >> 8
}
func (o *SWM_Type) SetPINENABLE0_ADC0_9(value uint32) {
	volatile.StoreUint32(&o.PINENABLE0.Reg, volatile.LoadUint32(&o.PINENABLE0.Reg)&^(0x200)|value<<9)
}
func (o *SWM_Type) GetPINENABLE0_ADC0_9() uint32 {
	return (volatile.LoadUint32(&o.PINENABLE0.Reg) & 0x200) >> 9
}
func (o *SWM_Type) SetPINENABLE0_ADC0_10(value uint32) {
	volatile.StoreUint32(&o.PINENABLE0.Reg, volatile.LoadUint32(&o.PINENABLE0.Reg)&^(0x400)|value<<10)
}
func (o *SWM_Type) GetPINENABLE0_ADC0_10() uint32 {
	return (volatile.LoadUint32(&o.PINENABLE0.Reg) & 0x400) >> 10
}
func (o *SWM_Type) SetPINENABLE0_ADC0_11(value uint32) {
	volatile.StoreUint32(&o.PINENABLE0.Reg, volatile.LoadUint32(&o.PINENABLE0.Reg)&^(0x800)|value<<11)
}
func (o *SWM_Type) GetPINENABLE0_ADC0_11() uint32 {
	return (volatile.LoadUint32(&o.PINENABLE0.Reg) & 0x800) >> 11
}
func (o *SWM_Type) SetPINENABLE0_ADC1_0(value uint32) {
	volatile.StoreUint32(&o.PINENABLE0.Reg, volatile.LoadUint32(&o.PINENABLE0.Reg)&^(0x1000)|value<<12)
}
func (o *SWM_Type) GetPINENABLE0_ADC1_0() uint32 {
	return (volatile.LoadUint32(&o.PINENABLE0.Reg) & 0x1000) >> 12
}
func (o *SWM_Type) SetPINENABLE0_ADC1_1(value uint32) {
	volatile.StoreUint32(&o.PINENABLE0.Reg, volatile.LoadUint32(&o.PINENABLE0.Reg)&^(0x2000)|value<<13)
}
func (o *SWM_Type) GetPINENABLE0_ADC1_1() uint32 {
	return (volatile.LoadUint32(&o.PINENABLE0.Reg) & 0x2000) >> 13
}
func (o *SWM_Type) SetPINENABLE0_ADC1_2(value uint32) {
	volatile.StoreUint32(&o.PINENABLE0.Reg, volatile.LoadUint32(&o.PINENABLE0.Reg)&^(0x4000)|value<<14)
}
func (o *SWM_Type) GetPINENABLE0_ADC1_2() uint32 {
	return (volatile.LoadUint32(&o.PINENABLE0.Reg) & 0x4000) >> 14
}
func (o *SWM_Type) SetPINENABLE0_ADC1_3(value uint32) {
	volatile.StoreUint32(&o.PINENABLE0.Reg, volatile.LoadUint32(&o.PINENABLE0.Reg)&^(0x8000)|value<<15)
}
func (o *SWM_Type) GetPINENABLE0_ADC1_3() uint32 {
	return (volatile.LoadUint32(&o.PINENABLE0.Reg) & 0x8000) >> 15
}
func (o *SWM_Type) SetPINENABLE0_ADC1_4(value uint32) {
	volatile.StoreUint32(&o.PINENABLE0.Reg, volatile.LoadUint32(&o.PINENABLE0.Reg)&^(0x10000)|value<<16)
}
func (o *SWM_Type) GetPINENABLE0_ADC1_4() uint32 {
	return (volatile.LoadUint32(&o.PINENABLE0.Reg) & 0x10000) >> 16
}
func (o *SWM_Type) SetPINENABLE0_ADC1_5(value uint32) {
	volatile.StoreUint32(&o.PINENABLE0.Reg, volatile.LoadUint32(&o.PINENABLE0.Reg)&^(0x20000)|value<<17)
}
func (o *SWM_Type) GetPINENABLE0_ADC1_5() uint32 {
	return (volatile.LoadUint32(&o.PINENABLE0.Reg) & 0x20000) >> 17
}
func (o *SWM_Type) SetPINENABLE0_ADC1_6(value uint32) {
	volatile.StoreUint32(&o.PINENABLE0.Reg, volatile.LoadUint32(&o.PINENABLE0.Reg)&^(0x40000)|value<<18)
}
func (o *SWM_Type) GetPINENABLE0_ADC1_6() uint32 {
	return (volatile.LoadUint32(&o.PINENABLE0.Reg) & 0x40000) >> 18
}
func (o *SWM_Type) SetPINENABLE0_ADC1_7(value uint32) {
	volatile.StoreUint32(&o.PINENABLE0.Reg, volatile.LoadUint32(&o.PINENABLE0.Reg)&^(0x80000)|value<<19)
}
func (o *SWM_Type) GetPINENABLE0_ADC1_7() uint32 {
	return (volatile.LoadUint32(&o.PINENABLE0.Reg) & 0x80000) >> 19
}
func (o *SWM_Type) SetPINENABLE0_ADC1_8(value uint32) {
	volatile.StoreUint32(&o.PINENABLE0.Reg, volatile.LoadUint32(&o.PINENABLE0.Reg)&^(0x100000)|value<<20)
}
func (o *SWM_Type) GetPINENABLE0_ADC1_8() uint32 {
	return (volatile.LoadUint32(&o.PINENABLE0.Reg) & 0x100000) >> 20
}
func (o *SWM_Type) SetPINENABLE0_ADC1_9(value uint32) {
	volatile.StoreUint32(&o.PINENABLE0.Reg, volatile.LoadUint32(&o.PINENABLE0.Reg)&^(0x200000)|value<<21)
}
func (o *SWM_Type) GetPINENABLE0_ADC1_9() uint32 {
	return (volatile.LoadUint32(&o.PINENABLE0.Reg) & 0x200000) >> 21
}
func (o *SWM_Type) SetPINENABLE0_ADC1_10(value uint32) {
	volatile.StoreUint32(&o.PINENABLE0.Reg, volatile.LoadUint32(&o.PINENABLE0.Reg)&^(0x400000)|value<<22)
}
func (o *SWM_Type) GetPINENABLE0_ADC1_10() uint32 {
	return (volatile.LoadUint32(&o.PINENABLE0.Reg) & 0x400000) >> 22
}
func (o *SWM_Type) SetPINENABLE0_ADC1_11(value uint32) {
	volatile.StoreUint32(&o.PINENABLE0.Reg, volatile.LoadUint32(&o.PINENABLE0.Reg)&^(0x800000)|value<<23)
}
func (o *SWM_Type) GetPINENABLE0_ADC1_11() uint32 {
	return (volatile.LoadUint32(&o.PINENABLE0.Reg) & 0x800000) >> 23
}
func (o *SWM_Type) SetPINENABLE0_DAC_OUT(value uint32) {
	volatile.StoreUint32(&o.PINENABLE0.Reg, volatile.LoadUint32(&o.PINENABLE0.Reg)&^(0x1000000)|value<<24)
}
func (o *SWM_Type) GetPINENABLE0_DAC_OUT() uint32 {
	return (volatile.LoadUint32(&o.PINENABLE0.Reg) & 0x1000000) >> 24
}
func (o *SWM_Type) SetPINENABLE0_ACMP_I1(value uint32) {
	volatile.StoreUint32(&o.PINENABLE0.Reg, volatile.LoadUint32(&o.PINENABLE0.Reg)&^(0x2000000)|value<<25)
}
func (o *SWM_Type) GetPINENABLE0_ACMP_I1() uint32 {
	return (volatile.LoadUint32(&o.PINENABLE0.Reg) & 0x2000000) >> 25
}
func (o *SWM_Type) SetPINENABLE0_ACMP_I2(value uint32) {
	volatile.StoreUint32(&o.PINENABLE0.Reg, volatile.LoadUint32(&o.PINENABLE0.Reg)&^(0x4000000)|value<<26)
}
func (o *SWM_Type) GetPINENABLE0_ACMP_I2() uint32 {
	return (volatile.LoadUint32(&o.PINENABLE0.Reg) & 0x4000000) >> 26
}
func (o *SWM_Type) SetPINENABLE0_ACMP0_I3(value uint32) {
	volatile.StoreUint32(&o.PINENABLE0.Reg, volatile.LoadUint32(&o.PINENABLE0.Reg)&^(0x8000000)|value<<27)
}
func (o *SWM_Type) GetPINENABLE0_ACMP0_I3() uint32 {
	return (volatile.LoadUint32(&o.PINENABLE0.Reg) & 0x8000000) >> 27
}
func (o *SWM_Type) SetPINENABLE0_ACMP0_I4(value uint32) {
	volatile.StoreUint32(&o.PINENABLE0.Reg, volatile.LoadUint32(&o.PINENABLE0.Reg)&^(0x10000000)|value<<28)
}
func (o *SWM_Type) GetPINENABLE0_ACMP0_I4() uint32 {
	return (volatile.LoadUint32(&o.PINENABLE0.Reg) & 0x10000000) >> 28
}
func (o *SWM_Type) SetPINENABLE0_ACMP1_I3(value uint32) {
	volatile.StoreUint32(&o.PINENABLE0.Reg, volatile.LoadUint32(&o.PINENABLE0.Reg)&^(0x20000000)|value<<29)
}
func (o *SWM_Type) GetPINENABLE0_ACMP1_I3() uint32 {
	return (volatile.LoadUint32(&o.PINENABLE0.Reg) & 0x20000000) >> 29
}
func (o *SWM_Type) SetPINENABLE0_ACMP1_I4(value uint32) {
	volatile.StoreUint32(&o.PINENABLE0.Reg, volatile.LoadUint32(&o.PINENABLE0.Reg)&^(0x40000000)|value<<30)
}
func (o *SWM_Type) GetPINENABLE0_ACMP1_I4() uint32 {
	return (volatile.LoadUint32(&o.PINENABLE0.Reg) & 0x40000000) >> 30
}
func (o *SWM_Type) SetPINENABLE0_ACMP2_I3(value uint32) {
	volatile.StoreUint32(&o.PINENABLE0.Reg, volatile.LoadUint32(&o.PINENABLE0.Reg)&^(0x80000000)|value<<31)
}
func (o *SWM_Type) GetPINENABLE0_ACMP2_I3() uint32 {
	return (volatile.LoadUint32(&o.PINENABLE0.Reg) & 0x80000000) >> 31
}

// SWM.PINENABLE1: Pin enable register 0. Enables fixed-pin functions
func (o *SWM_Type) SetPINENABLE1_ACMP2_I4(value uint32) {
	volatile.StoreUint32(&o.PINENABLE1.Reg, volatile.LoadUint32(&o.PINENABLE1.Reg)&^(0x1)|value)
}
func (o *SWM_Type) GetPINENABLE1_ACMP2_I4() uint32 {
	return volatile.LoadUint32(&o.PINENABLE1.Reg) & 0x1
}
func (o *SWM_Type) SetPINENABLE1_ACMP3_I3(value uint32) {
	volatile.StoreUint32(&o.PINENABLE1.Reg, volatile.LoadUint32(&o.PINENABLE1.Reg)&^(0x2)|value<<1)
}
func (o *SWM_Type) GetPINENABLE1_ACMP3_I3() uint32 {
	return (volatile.LoadUint32(&o.PINENABLE1.Reg) & 0x2) >> 1
}
func (o *SWM_Type) SetPINENABLE1_ACMP3_I4(value uint32) {
	volatile.StoreUint32(&o.PINENABLE1.Reg, volatile.LoadUint32(&o.PINENABLE1.Reg)&^(0x4)|value<<2)
}
func (o *SWM_Type) GetPINENABLE1_ACMP3_I4() uint32 {
	return (volatile.LoadUint32(&o.PINENABLE1.Reg) & 0x4) >> 2
}
func (o *SWM_Type) SetPINENABLE1_I2C0_SDA(value uint32) {
	volatile.StoreUint32(&o.PINENABLE1.Reg, volatile.LoadUint32(&o.PINENABLE1.Reg)&^(0x8)|value<<3)
}
func (o *SWM_Type) GetPINENABLE1_I2C0_SDA() uint32 {
	return (volatile.LoadUint32(&o.PINENABLE1.Reg) & 0x8) >> 3
}
func (o *SWM_Type) SetPINENABLE1_I2C0_SCL(value uint32) {
	volatile.StoreUint32(&o.PINENABLE1.Reg, volatile.LoadUint32(&o.PINENABLE1.Reg)&^(0x10)|value<<4)
}
func (o *SWM_Type) GetPINENABLE1_I2C0_SCL() uint32 {
	return (volatile.LoadUint32(&o.PINENABLE1.Reg) & 0x10) >> 4
}
func (o *SWM_Type) SetPINENABLE1_SCT0_OUT3(value uint32) {
	volatile.StoreUint32(&o.PINENABLE1.Reg, volatile.LoadUint32(&o.PINENABLE1.Reg)&^(0x20)|value<<5)
}
func (o *SWM_Type) GetPINENABLE1_SCT0_OUT3() uint32 {
	return (volatile.LoadUint32(&o.PINENABLE1.Reg) & 0x20) >> 5
}
func (o *SWM_Type) SetPINENABLE1_SCT0_OUT4(value uint32) {
	volatile.StoreUint32(&o.PINENABLE1.Reg, volatile.LoadUint32(&o.PINENABLE1.Reg)&^(0x40)|value<<6)
}
func (o *SWM_Type) GetPINENABLE1_SCT0_OUT4() uint32 {
	return (volatile.LoadUint32(&o.PINENABLE1.Reg) & 0x40) >> 6
}
func (o *SWM_Type) SetPINENABLE1_SCT0_OUT5(value uint32) {
	volatile.StoreUint32(&o.PINENABLE1.Reg, volatile.LoadUint32(&o.PINENABLE1.Reg)&^(0x80)|value<<7)
}
func (o *SWM_Type) GetPINENABLE1_SCT0_OUT5() uint32 {
	return (volatile.LoadUint32(&o.PINENABLE1.Reg) & 0x80) >> 7
}
func (o *SWM_Type) SetPINENABLE1_SCT0_OUT6(value uint32) {
	volatile.StoreUint32(&o.PINENABLE1.Reg, volatile.LoadUint32(&o.PINENABLE1.Reg)&^(0x100)|value<<8)
}
func (o *SWM_Type) GetPINENABLE1_SCT0_OUT6() uint32 {
	return (volatile.LoadUint32(&o.PINENABLE1.Reg) & 0x100) >> 8
}
func (o *SWM_Type) SetPINENABLE1_SCT0_OUT7(value uint32) {
	volatile.StoreUint32(&o.PINENABLE1.Reg, volatile.LoadUint32(&o.PINENABLE1.Reg)&^(0x200)|value<<9)
}
func (o *SWM_Type) GetPINENABLE1_SCT0_OUT7() uint32 {
	return (volatile.LoadUint32(&o.PINENABLE1.Reg) & 0x200) >> 9
}
func (o *SWM_Type) SetPINENABLE1_SCT1_OUT3(value uint32) {
	volatile.StoreUint32(&o.PINENABLE1.Reg, volatile.LoadUint32(&o.PINENABLE1.Reg)&^(0x400)|value<<10)
}
func (o *SWM_Type) GetPINENABLE1_SCT1_OUT3() uint32 {
	return (volatile.LoadUint32(&o.PINENABLE1.Reg) & 0x400) >> 10
}
func (o *SWM_Type) SetPINENABLE1_SCT1_OUT4(value uint32) {
	volatile.StoreUint32(&o.PINENABLE1.Reg, volatile.LoadUint32(&o.PINENABLE1.Reg)&^(0x800)|value<<11)
}
func (o *SWM_Type) GetPINENABLE1_SCT1_OUT4() uint32 {
	return (volatile.LoadUint32(&o.PINENABLE1.Reg) & 0x800) >> 11
}
func (o *SWM_Type) SetPINENABLE1_SCT1_OUT5(value uint32) {
	volatile.StoreUint32(&o.PINENABLE1.Reg, volatile.LoadUint32(&o.PINENABLE1.Reg)&^(0x1000)|value<<12)
}
func (o *SWM_Type) GetPINENABLE1_SCT1_OUT5() uint32 {
	return (volatile.LoadUint32(&o.PINENABLE1.Reg) & 0x1000) >> 12
}
func (o *SWM_Type) SetPINENABLE1_SCT1_OUT6(value uint32) {
	volatile.StoreUint32(&o.PINENABLE1.Reg, volatile.LoadUint32(&o.PINENABLE1.Reg)&^(0x2000)|value<<13)
}
func (o *SWM_Type) GetPINENABLE1_SCT1_OUT6() uint32 {
	return (volatile.LoadUint32(&o.PINENABLE1.Reg) & 0x2000) >> 13
}
func (o *SWM_Type) SetPINENABLE1_SCT1_OUT7(value uint32) {
	volatile.StoreUint32(&o.PINENABLE1.Reg, volatile.LoadUint32(&o.PINENABLE1.Reg)&^(0x4000)|value<<14)
}
func (o *SWM_Type) GetPINENABLE1_SCT1_OUT7() uint32 {
	return (volatile.LoadUint32(&o.PINENABLE1.Reg) & 0x4000) >> 14
}
func (o *SWM_Type) SetPINENABLE1_SCT2_OUT3(value uint32) {
	volatile.StoreUint32(&o.PINENABLE1.Reg, volatile.LoadUint32(&o.PINENABLE1.Reg)&^(0x8000)|value<<15)
}
func (o *SWM_Type) GetPINENABLE1_SCT2_OUT3() uint32 {
	return (volatile.LoadUint32(&o.PINENABLE1.Reg) & 0x8000) >> 15
}
func (o *SWM_Type) SetPINENABLE1_SCT2_OUT4(value uint32) {
	volatile.StoreUint32(&o.PINENABLE1.Reg, volatile.LoadUint32(&o.PINENABLE1.Reg)&^(0x10000)|value<<16)
}
func (o *SWM_Type) GetPINENABLE1_SCT2_OUT4() uint32 {
	return (volatile.LoadUint32(&o.PINENABLE1.Reg) & 0x10000) >> 16
}
func (o *SWM_Type) SetPINENABLE1_SCT2_OUT5(value uint32) {
	volatile.StoreUint32(&o.PINENABLE1.Reg, volatile.LoadUint32(&o.PINENABLE1.Reg)&^(0x20000)|value<<17)
}
func (o *SWM_Type) GetPINENABLE1_SCT2_OUT5() uint32 {
	return (volatile.LoadUint32(&o.PINENABLE1.Reg) & 0x20000) >> 17
}
func (o *SWM_Type) SetPINENABLE1_SCT3_OUT3(value uint32) {
	volatile.StoreUint32(&o.PINENABLE1.Reg, volatile.LoadUint32(&o.PINENABLE1.Reg)&^(0x40000)|value<<18)
}
func (o *SWM_Type) GetPINENABLE1_SCT3_OUT3() uint32 {
	return (volatile.LoadUint32(&o.PINENABLE1.Reg) & 0x40000) >> 18
}
func (o *SWM_Type) SetPINENABLE1_SCT3_OUT4(value uint32) {
	volatile.StoreUint32(&o.PINENABLE1.Reg, volatile.LoadUint32(&o.PINENABLE1.Reg)&^(0x80000)|value<<19)
}
func (o *SWM_Type) GetPINENABLE1_SCT3_OUT4() uint32 {
	return (volatile.LoadUint32(&o.PINENABLE1.Reg) & 0x80000) >> 19
}
func (o *SWM_Type) SetPINENABLE1_SCT3_OUT5(value uint32) {
	volatile.StoreUint32(&o.PINENABLE1.Reg, volatile.LoadUint32(&o.PINENABLE1.Reg)&^(0x100000)|value<<20)
}
func (o *SWM_Type) GetPINENABLE1_SCT3_OUT5() uint32 {
	return (volatile.LoadUint32(&o.PINENABLE1.Reg) & 0x100000) >> 20
}
func (o *SWM_Type) SetPINENABLE1_RESETN(value uint32) {
	volatile.StoreUint32(&o.PINENABLE1.Reg, volatile.LoadUint32(&o.PINENABLE1.Reg)&^(0x200000)|value<<21)
}
func (o *SWM_Type) GetPINENABLE1_RESETN() uint32 {
	return (volatile.LoadUint32(&o.PINENABLE1.Reg) & 0x200000) >> 21
}
func (o *SWM_Type) SetPINENABLE1_SWCLK_TCK(value uint32) {
	volatile.StoreUint32(&o.PINENABLE1.Reg, volatile.LoadUint32(&o.PINENABLE1.Reg)&^(0x400000)|value<<22)
}
func (o *SWM_Type) GetPINENABLE1_SWCLK_TCK() uint32 {
	return (volatile.LoadUint32(&o.PINENABLE1.Reg) & 0x400000) >> 22
}
func (o *SWM_Type) SetPINENABLE1_SWDIO(value uint32) {
	volatile.StoreUint32(&o.PINENABLE1.Reg, volatile.LoadUint32(&o.PINENABLE1.Reg)&^(0x800000)|value<<23)
}
func (o *SWM_Type) GetPINENABLE1_SWDIO() uint32 {
	return (volatile.LoadUint32(&o.PINENABLE1.Reg) & 0x800000) >> 23
}
func (o *SWM_Type) SetPINENABLE1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PINENABLE1.Reg, volatile.LoadUint32(&o.PINENABLE1.Reg)&^(0x1000000)|value<<24)
}
func (o *SWM_Type) GetPINENABLE1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PINENABLE1.Reg) & 0x1000000) >> 24
}
func (o *SWM_Type) SetPINENABLE1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PINENABLE1.Reg, volatile.LoadUint32(&o.PINENABLE1.Reg)&^(0x2000000)|value<<25)
}
func (o *SWM_Type) GetPINENABLE1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PINENABLE1.Reg) & 0x2000000) >> 25
}
func (o *SWM_Type) SetPINENABLE1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PINENABLE1.Reg, volatile.LoadUint32(&o.PINENABLE1.Reg)&^(0x4000000)|value<<26)
}
func (o *SWM_Type) GetPINENABLE1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PINENABLE1.Reg) & 0x4000000) >> 26
}
func (o *SWM_Type) SetPINENABLE1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PINENABLE1.Reg, volatile.LoadUint32(&o.PINENABLE1.Reg)&^(0x8000000)|value<<27)
}
func (o *SWM_Type) GetPINENABLE1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PINENABLE1.Reg) & 0x8000000) >> 27
}
func (o *SWM_Type) SetPINENABLE1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PINENABLE1.Reg, volatile.LoadUint32(&o.PINENABLE1.Reg)&^(0x10000000)|value<<28)
}
func (o *SWM_Type) GetPINENABLE1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PINENABLE1.Reg) & 0x10000000) >> 28
}
func (o *SWM_Type) SetPINENABLE1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PINENABLE1.Reg, volatile.LoadUint32(&o.PINENABLE1.Reg)&^(0x20000000)|value<<29)
}
func (o *SWM_Type) GetPINENABLE1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PINENABLE1.Reg) & 0x20000000) >> 29
}
func (o *SWM_Type) SetPINENABLE1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PINENABLE1.Reg, volatile.LoadUint32(&o.PINENABLE1.Reg)&^(0x40000000)|value<<30)
}
func (o *SWM_Type) GetPINENABLE1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PINENABLE1.Reg) & 0x40000000) >> 30
}
func (o *SWM_Type) SetPINENABLE1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PINENABLE1.Reg, volatile.LoadUint32(&o.PINENABLE1.Reg)&^(0x80000000)|value<<31)
}
func (o *SWM_Type) GetPINENABLE1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PINENABLE1.Reg) & 0x80000000) >> 31
}

// Power Management Unit (PMU)
type PMU_Type struct {
	PCON    volatile.Register32 // 0x0
	GPREG0  volatile.Register32 // 0x4
	GPREG1  volatile.Register32 // 0x8
	GPREG2  volatile.Register32 // 0xC
	GPREG3  volatile.Register32 // 0x10
	DPDCTRL volatile.Register32 // 0x14
}

// PMU.PCON: Power control register
func (o *PMU_Type) SetPCON_NODPD(value uint32) {
	volatile.StoreUint32(&o.PCON.Reg, volatile.LoadUint32(&o.PCON.Reg)&^(0x8)|value<<3)
}
func (o *PMU_Type) GetPCON_NODPD() uint32 {
	return (volatile.LoadUint32(&o.PCON.Reg) & 0x8) >> 3
}
func (o *PMU_Type) SetPCON_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PCON.Reg, volatile.LoadUint32(&o.PCON.Reg)&^(0xf0)|value<<4)
}
func (o *PMU_Type) GetPCON_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PCON.Reg) & 0xf0) >> 4
}
func (o *PMU_Type) SetPCON_SLEEPFLAG(value uint32) {
	volatile.StoreUint32(&o.PCON.Reg, volatile.LoadUint32(&o.PCON.Reg)&^(0x100)|value<<8)
}
func (o *PMU_Type) GetPCON_SLEEPFLAG() uint32 {
	return (volatile.LoadUint32(&o.PCON.Reg) & 0x100) >> 8
}
func (o *PMU_Type) SetPCON_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PCON.Reg, volatile.LoadUint32(&o.PCON.Reg)&^(0x600)|value<<9)
}
func (o *PMU_Type) GetPCON_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PCON.Reg) & 0x600) >> 9
}
func (o *PMU_Type) SetPCON_DPDFLAG(value uint32) {
	volatile.StoreUint32(&o.PCON.Reg, volatile.LoadUint32(&o.PCON.Reg)&^(0x800)|value<<11)
}
func (o *PMU_Type) GetPCON_DPDFLAG() uint32 {
	return (volatile.LoadUint32(&o.PCON.Reg) & 0x800) >> 11
}
func (o *PMU_Type) SetPCON_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PCON.Reg, volatile.LoadUint32(&o.PCON.Reg)&^(0xfffff000)|value<<12)
}
func (o *PMU_Type) GetPCON_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PCON.Reg) & 0xfffff000) >> 12
}

// PMU.GPREG0: General purpose register 0
func (o *PMU_Type) SetGPREG0(value uint32) {
	volatile.StoreUint32(&o.GPREG0.Reg, value)
}
func (o *PMU_Type) GetGPREG0() uint32 {
	return volatile.LoadUint32(&o.GPREG0.Reg)
}

// PMU.GPREG1: General purpose register 0
func (o *PMU_Type) SetGPREG1(value uint32) {
	volatile.StoreUint32(&o.GPREG1.Reg, value)
}
func (o *PMU_Type) GetGPREG1() uint32 {
	return volatile.LoadUint32(&o.GPREG1.Reg)
}

// PMU.GPREG2: General purpose register 0
func (o *PMU_Type) SetGPREG2(value uint32) {
	volatile.StoreUint32(&o.GPREG2.Reg, value)
}
func (o *PMU_Type) GetGPREG2() uint32 {
	return volatile.LoadUint32(&o.GPREG2.Reg)
}

// PMU.GPREG3: General purpose register 0
func (o *PMU_Type) SetGPREG3(value uint32) {
	volatile.StoreUint32(&o.GPREG3.Reg, value)
}
func (o *PMU_Type) GetGPREG3() uint32 {
	return volatile.LoadUint32(&o.GPREG3.Reg)
}

// PMU.DPDCTRL: Deep power-down control register
func (o *PMU_Type) SetDPDCTRL_WAKEUPHYS(value uint32) {
	volatile.StoreUint32(&o.DPDCTRL.Reg, volatile.LoadUint32(&o.DPDCTRL.Reg)&^(0x1)|value)
}
func (o *PMU_Type) GetDPDCTRL_WAKEUPHYS() uint32 {
	return volatile.LoadUint32(&o.DPDCTRL.Reg) & 0x1
}
func (o *PMU_Type) SetDPDCTRL_WAKEPAD_DISABLE(value uint32) {
	volatile.StoreUint32(&o.DPDCTRL.Reg, volatile.LoadUint32(&o.DPDCTRL.Reg)&^(0x2)|value<<1)
}
func (o *PMU_Type) GetDPDCTRL_WAKEPAD_DISABLE() uint32 {
	return (volatile.LoadUint32(&o.DPDCTRL.Reg) & 0x2) >> 1
}
func (o *PMU_Type) SetDPDCTRL_LPOSCEN(value uint32) {
	volatile.StoreUint32(&o.DPDCTRL.Reg, volatile.LoadUint32(&o.DPDCTRL.Reg)&^(0x4)|value<<2)
}
func (o *PMU_Type) GetDPDCTRL_LPOSCEN() uint32 {
	return (volatile.LoadUint32(&o.DPDCTRL.Reg) & 0x4) >> 2
}
func (o *PMU_Type) SetDPDCTRL_LPOSCDPDEN(value uint32) {
	volatile.StoreUint32(&o.DPDCTRL.Reg, volatile.LoadUint32(&o.DPDCTRL.Reg)&^(0x8)|value<<3)
}
func (o *PMU_Type) GetDPDCTRL_LPOSCDPDEN() uint32 {
	return (volatile.LoadUint32(&o.DPDCTRL.Reg) & 0x8) >> 3
}
func (o *PMU_Type) SetDPDCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DPDCTRL.Reg, volatile.LoadUint32(&o.DPDCTRL.Reg)&^(0xfffffff0)|value<<4)
}
func (o *PMU_Type) GetDPDCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DPDCTRL.Reg) & 0xfffffff0) >> 4
}

// USART0
type USART0_Type struct {
	CFG       volatile.Register32 // 0x0
	CTL       volatile.Register32 // 0x4
	STAT      volatile.Register32 // 0x8
	INTENSET  volatile.Register32 // 0xC
	INTENCLR  volatile.Register32 // 0x10
	RXDAT     volatile.Register32 // 0x14
	RXDATSTAT volatile.Register32 // 0x18
	TXDAT     volatile.Register32 // 0x1C
	BRG       volatile.Register32 // 0x20
	INTSTAT   volatile.Register32 // 0x24
	OSR       volatile.Register32 // 0x28
	ADDR      volatile.Register32 // 0x2C
}

// USART0.CFG: USART Configuration register. Basic USART configuration settings that typically are not changed during operation.
func (o *USART0_Type) SetCFG_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x1)|value)
}
func (o *USART0_Type) GetCFG_ENABLE() uint32 {
	return volatile.LoadUint32(&o.CFG.Reg) & 0x1
}
func (o *USART0_Type) SetCFG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x2)|value<<1)
}
func (o *USART0_Type) GetCFG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x2) >> 1
}
func (o *USART0_Type) SetCFG_DATALEN(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0xc)|value<<2)
}
func (o *USART0_Type) GetCFG_DATALEN() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0xc) >> 2
}
func (o *USART0_Type) SetCFG_PARITYSEL(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x30)|value<<4)
}
func (o *USART0_Type) GetCFG_PARITYSEL() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x30) >> 4
}
func (o *USART0_Type) SetCFG_STOPLEN(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x40)|value<<6)
}
func (o *USART0_Type) GetCFG_STOPLEN() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x40) >> 6
}
func (o *USART0_Type) SetCFG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x80)|value<<7)
}
func (o *USART0_Type) GetCFG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x80) >> 7
}
func (o *USART0_Type) SetCFG_MODE32K(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x80)|value<<7)
}
func (o *USART0_Type) GetCFG_MODE32K() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x80) >> 7
}
func (o *USART0_Type) SetCFG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x100)|value<<8)
}
func (o *USART0_Type) GetCFG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x100) >> 8
}
func (o *USART0_Type) SetCFG_CTSEN(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x200)|value<<9)
}
func (o *USART0_Type) GetCFG_CTSEN() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x200) >> 9
}
func (o *USART0_Type) SetCFG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x400)|value<<10)
}
func (o *USART0_Type) GetCFG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x400) >> 10
}
func (o *USART0_Type) SetCFG_SYNCEN(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x800)|value<<11)
}
func (o *USART0_Type) GetCFG_SYNCEN() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x800) >> 11
}
func (o *USART0_Type) SetCFG_CLKPOL(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x1000)|value<<12)
}
func (o *USART0_Type) GetCFG_CLKPOL() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x1000) >> 12
}
func (o *USART0_Type) SetCFG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x2000)|value<<13)
}
func (o *USART0_Type) GetCFG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x2000) >> 13
}
func (o *USART0_Type) SetCFG_SYNCMST(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x4000)|value<<14)
}
func (o *USART0_Type) GetCFG_SYNCMST() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x4000) >> 14
}
func (o *USART0_Type) SetCFG_LOOP(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x8000)|value<<15)
}
func (o *USART0_Type) GetCFG_LOOP() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x8000) >> 15
}
func (o *USART0_Type) SetCFG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x30000)|value<<16)
}
func (o *USART0_Type) GetCFG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x30000) >> 16
}
func (o *USART0_Type) SetCFG_OETA(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x40000)|value<<18)
}
func (o *USART0_Type) GetCFG_OETA() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x40000) >> 18
}
func (o *USART0_Type) SetCFG_AUTOADDR(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x80000)|value<<19)
}
func (o *USART0_Type) GetCFG_AUTOADDR() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x80000) >> 19
}
func (o *USART0_Type) SetCFG_OESEL(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x100000)|value<<20)
}
func (o *USART0_Type) GetCFG_OESEL() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x100000) >> 20
}
func (o *USART0_Type) SetCFG_OEPOL(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x200000)|value<<21)
}
func (o *USART0_Type) GetCFG_OEPOL() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x200000) >> 21
}
func (o *USART0_Type) SetCFG_RXPOL(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x400000)|value<<22)
}
func (o *USART0_Type) GetCFG_RXPOL() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x400000) >> 22
}
func (o *USART0_Type) SetCFG_TXPOL(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x800000)|value<<23)
}
func (o *USART0_Type) GetCFG_TXPOL() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x800000) >> 23
}
func (o *USART0_Type) SetCFG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0xff000000)|value<<24)
}
func (o *USART0_Type) GetCFG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0xff000000) >> 24
}

// USART0.CTL: USART Control register. USART control settings that are more likely to change during operation.
func (o *USART0_Type) SetCTL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTL.Reg, volatile.LoadUint32(&o.CTL.Reg)&^(0x1)|value)
}
func (o *USART0_Type) GetCTL_RESERVED() uint32 {
	return volatile.LoadUint32(&o.CTL.Reg) & 0x1
}
func (o *USART0_Type) SetCTL_TXBRKEN(value uint32) {
	volatile.StoreUint32(&o.CTL.Reg, volatile.LoadUint32(&o.CTL.Reg)&^(0x2)|value<<1)
}
func (o *USART0_Type) GetCTL_TXBRKEN() uint32 {
	return (volatile.LoadUint32(&o.CTL.Reg) & 0x2) >> 1
}
func (o *USART0_Type) SetCTL_ADDRDET(value uint32) {
	volatile.StoreUint32(&o.CTL.Reg, volatile.LoadUint32(&o.CTL.Reg)&^(0x4)|value<<2)
}
func (o *USART0_Type) GetCTL_ADDRDET() uint32 {
	return (volatile.LoadUint32(&o.CTL.Reg) & 0x4) >> 2
}
func (o *USART0_Type) SetCTL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTL.Reg, volatile.LoadUint32(&o.CTL.Reg)&^(0x38)|value<<3)
}
func (o *USART0_Type) GetCTL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTL.Reg) & 0x38) >> 3
}
func (o *USART0_Type) SetCTL_TXDIS(value uint32) {
	volatile.StoreUint32(&o.CTL.Reg, volatile.LoadUint32(&o.CTL.Reg)&^(0x40)|value<<6)
}
func (o *USART0_Type) GetCTL_TXDIS() uint32 {
	return (volatile.LoadUint32(&o.CTL.Reg) & 0x40) >> 6
}
func (o *USART0_Type) SetCTL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTL.Reg, volatile.LoadUint32(&o.CTL.Reg)&^(0x80)|value<<7)
}
func (o *USART0_Type) GetCTL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTL.Reg) & 0x80) >> 7
}
func (o *USART0_Type) SetCTL_CC(value uint32) {
	volatile.StoreUint32(&o.CTL.Reg, volatile.LoadUint32(&o.CTL.Reg)&^(0x100)|value<<8)
}
func (o *USART0_Type) GetCTL_CC() uint32 {
	return (volatile.LoadUint32(&o.CTL.Reg) & 0x100) >> 8
}
func (o *USART0_Type) SetCTL_CLRCCONRX(value uint32) {
	volatile.StoreUint32(&o.CTL.Reg, volatile.LoadUint32(&o.CTL.Reg)&^(0x200)|value<<9)
}
func (o *USART0_Type) GetCTL_CLRCCONRX() uint32 {
	return (volatile.LoadUint32(&o.CTL.Reg) & 0x200) >> 9
}
func (o *USART0_Type) SetCTL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTL.Reg, volatile.LoadUint32(&o.CTL.Reg)&^(0xfc00)|value<<10)
}
func (o *USART0_Type) GetCTL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTL.Reg) & 0xfc00) >> 10
}
func (o *USART0_Type) SetCTL_AUTOBAUD(value uint32) {
	volatile.StoreUint32(&o.CTL.Reg, volatile.LoadUint32(&o.CTL.Reg)&^(0x10000)|value<<16)
}
func (o *USART0_Type) GetCTL_AUTOBAUD() uint32 {
	return (volatile.LoadUint32(&o.CTL.Reg) & 0x10000) >> 16
}
func (o *USART0_Type) SetCTL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTL.Reg, volatile.LoadUint32(&o.CTL.Reg)&^(0xfffe0000)|value<<17)
}
func (o *USART0_Type) GetCTL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTL.Reg) & 0xfffe0000) >> 17
}

// USART0.STAT: USART Status register. The complete status value can be read here. Writing ones clears some bits in the register. Some bits can be cleared by writing a 1 to them.
func (o *USART0_Type) SetSTAT_RXRDY(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x1)|value)
}
func (o *USART0_Type) GetSTAT_RXRDY() uint32 {
	return volatile.LoadUint32(&o.STAT.Reg) & 0x1
}
func (o *USART0_Type) SetSTAT_RXIDLE(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x2)|value<<1)
}
func (o *USART0_Type) GetSTAT_RXIDLE() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x2) >> 1
}
func (o *USART0_Type) SetSTAT_TXRDY(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x4)|value<<2)
}
func (o *USART0_Type) GetSTAT_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x4) >> 2
}
func (o *USART0_Type) SetSTAT_TXIDLE(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x8)|value<<3)
}
func (o *USART0_Type) GetSTAT_TXIDLE() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x8) >> 3
}
func (o *USART0_Type) SetSTAT_CTS(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x10)|value<<4)
}
func (o *USART0_Type) GetSTAT_CTS() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x10) >> 4
}
func (o *USART0_Type) SetSTAT_DELTACTS(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x20)|value<<5)
}
func (o *USART0_Type) GetSTAT_DELTACTS() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x20) >> 5
}
func (o *USART0_Type) SetSTAT_TXDISSTAT(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x40)|value<<6)
}
func (o *USART0_Type) GetSTAT_TXDISSTAT() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x40) >> 6
}
func (o *USART0_Type) SetSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x80)|value<<7)
}
func (o *USART0_Type) GetSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x80) >> 7
}
func (o *USART0_Type) SetSTAT_OVERRUNINT(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x100)|value<<8)
}
func (o *USART0_Type) GetSTAT_OVERRUNINT() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x100) >> 8
}
func (o *USART0_Type) SetSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x200)|value<<9)
}
func (o *USART0_Type) GetSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x200) >> 9
}
func (o *USART0_Type) SetSTAT_RXBRK(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x400)|value<<10)
}
func (o *USART0_Type) GetSTAT_RXBRK() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x400) >> 10
}
func (o *USART0_Type) SetSTAT_DELTARXBRK(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x800)|value<<11)
}
func (o *USART0_Type) GetSTAT_DELTARXBRK() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x800) >> 11
}
func (o *USART0_Type) SetSTAT_START(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x1000)|value<<12)
}
func (o *USART0_Type) GetSTAT_START() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x1000) >> 12
}
func (o *USART0_Type) SetSTAT_FRAMERRINT(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x2000)|value<<13)
}
func (o *USART0_Type) GetSTAT_FRAMERRINT() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x2000) >> 13
}
func (o *USART0_Type) SetSTAT_PARITYERRINT(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x4000)|value<<14)
}
func (o *USART0_Type) GetSTAT_PARITYERRINT() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x4000) >> 14
}
func (o *USART0_Type) SetSTAT_RXNOISEINT(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x8000)|value<<15)
}
func (o *USART0_Type) GetSTAT_RXNOISEINT() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x8000) >> 15
}
func (o *USART0_Type) SetSTAT_ABERR(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x10000)|value<<16)
}
func (o *USART0_Type) GetSTAT_ABERR() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x10000) >> 16
}
func (o *USART0_Type) SetSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0xfffe0000)|value<<17)
}
func (o *USART0_Type) GetSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0xfffe0000) >> 17
}

// USART0.INTENSET: Interrupt Enable read and Set register. Contains an individual interrupt enable bit for each potential USART interrupt. A complete value may be read from this register. Writing a 1 to any implemented bit position causes that bit to be set.
func (o *USART0_Type) SetINTENSET_RXRDYEN(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *USART0_Type) GetINTENSET_RXRDYEN() uint32 {
	return volatile.LoadUint32(&o.INTENSET.Reg) & 0x1
}
func (o *USART0_Type) SetINTENSET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *USART0_Type) GetINTENSET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *USART0_Type) SetINTENSET_TXRDYEN(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4)|value<<2)
}
func (o *USART0_Type) GetINTENSET_TXRDYEN() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4) >> 2
}
func (o *USART0_Type) SetINTENSET_TXIDLEEN(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x8)|value<<3)
}
func (o *USART0_Type) GetINTENSET_TXIDLEEN() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x8) >> 3
}
func (o *USART0_Type) SetINTENSET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x10)|value<<4)
}
func (o *USART0_Type) GetINTENSET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x10) >> 4
}
func (o *USART0_Type) SetINTENSET_DELTACTSEN(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x20)|value<<5)
}
func (o *USART0_Type) GetINTENSET_DELTACTSEN() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x20) >> 5
}
func (o *USART0_Type) SetINTENSET_TXDISEN(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x40)|value<<6)
}
func (o *USART0_Type) GetINTENSET_TXDISEN() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x40) >> 6
}
func (o *USART0_Type) SetINTENSET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x80)|value<<7)
}
func (o *USART0_Type) GetINTENSET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x80) >> 7
}
func (o *USART0_Type) SetINTENSET_OVERRUNEN(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x100)|value<<8)
}
func (o *USART0_Type) GetINTENSET_OVERRUNEN() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x100) >> 8
}
func (o *USART0_Type) SetINTENSET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x600)|value<<9)
}
func (o *USART0_Type) GetINTENSET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x600) >> 9
}
func (o *USART0_Type) SetINTENSET_DELTARXBRKEN(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x800)|value<<11)
}
func (o *USART0_Type) GetINTENSET_DELTARXBRKEN() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x800) >> 11
}
func (o *USART0_Type) SetINTENSET_STARTEN(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1000)|value<<12)
}
func (o *USART0_Type) GetINTENSET_STARTEN() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x1000) >> 12
}
func (o *USART0_Type) SetINTENSET_FRAMERREN(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2000)|value<<13)
}
func (o *USART0_Type) GetINTENSET_FRAMERREN() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2000) >> 13
}
func (o *USART0_Type) SetINTENSET_PARITYERREN(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4000)|value<<14)
}
func (o *USART0_Type) GetINTENSET_PARITYERREN() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4000) >> 14
}
func (o *USART0_Type) SetINTENSET_RXNOISEEN(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x8000)|value<<15)
}
func (o *USART0_Type) GetINTENSET_RXNOISEEN() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x8000) >> 15
}
func (o *USART0_Type) SetINTENSET_ABERREN(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x10000)|value<<16)
}
func (o *USART0_Type) GetINTENSET_ABERREN() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x10000) >> 16
}
func (o *USART0_Type) SetINTENSET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0xfffe0000)|value<<17)
}
func (o *USART0_Type) GetINTENSET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0xfffe0000) >> 17
}

// USART0.INTENCLR: Interrupt Enable Clear register. Allows clearing any combination of bits in the INTENSET register. Writing a 1 to any implemented bit position causes the corresponding bit to be cleared.
func (o *USART0_Type) SetINTENCLR_RXRDYCLR(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *USART0_Type) GetINTENCLR_RXRDYCLR() uint32 {
	return volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1
}
func (o *USART0_Type) SetINTENCLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *USART0_Type) GetINTENCLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *USART0_Type) SetINTENCLR_TXRDYCLR(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4)|value<<2)
}
func (o *USART0_Type) GetINTENCLR_TXRDYCLR() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4) >> 2
}
func (o *USART0_Type) SetINTENCLR_TXIDLECLR(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x8)|value<<3)
}
func (o *USART0_Type) GetINTENCLR_TXIDLECLR() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x8) >> 3
}
func (o *USART0_Type) SetINTENCLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x10)|value<<4)
}
func (o *USART0_Type) GetINTENCLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x10) >> 4
}
func (o *USART0_Type) SetINTENCLR_DELTACTSCLR(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x20)|value<<5)
}
func (o *USART0_Type) GetINTENCLR_DELTACTSCLR() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x20) >> 5
}
func (o *USART0_Type) SetINTENCLR_TXDISCLR(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x40)|value<<6)
}
func (o *USART0_Type) GetINTENCLR_TXDISCLR() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x40) >> 6
}
func (o *USART0_Type) SetINTENCLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x80)|value<<7)
}
func (o *USART0_Type) GetINTENCLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x80) >> 7
}
func (o *USART0_Type) SetINTENCLR_OVERRUNCLR(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x100)|value<<8)
}
func (o *USART0_Type) GetINTENCLR_OVERRUNCLR() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x100) >> 8
}
func (o *USART0_Type) SetINTENCLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x600)|value<<9)
}
func (o *USART0_Type) GetINTENCLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x600) >> 9
}
func (o *USART0_Type) SetINTENCLR_DELTARXBRKCLR(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x800)|value<<11)
}
func (o *USART0_Type) GetINTENCLR_DELTARXBRKCLR() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x800) >> 11
}
func (o *USART0_Type) SetINTENCLR_STARTCLR(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1000)|value<<12)
}
func (o *USART0_Type) GetINTENCLR_STARTCLR() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1000) >> 12
}
func (o *USART0_Type) SetINTENCLR_FRAMERRCLR(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2000)|value<<13)
}
func (o *USART0_Type) GetINTENCLR_FRAMERRCLR() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2000) >> 13
}
func (o *USART0_Type) SetINTENCLR_PARITYERRCLR(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4000)|value<<14)
}
func (o *USART0_Type) GetINTENCLR_PARITYERRCLR() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4000) >> 14
}
func (o *USART0_Type) SetINTENCLR_RXNOISECLR(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x8000)|value<<15)
}
func (o *USART0_Type) GetINTENCLR_RXNOISECLR() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x8000) >> 15
}
func (o *USART0_Type) SetINTENCLR_ABERRCLR(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x10000)|value<<16)
}
func (o *USART0_Type) GetINTENCLR_ABERRCLR() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x10000) >> 16
}
func (o *USART0_Type) SetINTENCLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0xfffe0000)|value<<17)
}
func (o *USART0_Type) GetINTENCLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0xfffe0000) >> 17
}

// USART0.RXDAT: Receiver Data register. Contains the last character received.
func (o *USART0_Type) SetRXDAT_DATA(value uint32) {
	volatile.StoreUint32(&o.RXDAT.Reg, volatile.LoadUint32(&o.RXDAT.Reg)&^(0x1ff)|value)
}
func (o *USART0_Type) GetRXDAT_DATA() uint32 {
	return volatile.LoadUint32(&o.RXDAT.Reg) & 0x1ff
}
func (o *USART0_Type) SetRXDAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RXDAT.Reg, volatile.LoadUint32(&o.RXDAT.Reg)&^(0xfffffe00)|value<<9)
}
func (o *USART0_Type) GetRXDAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.RXDAT.Reg) & 0xfffffe00) >> 9
}

// USART0.RXDATSTAT: Receiver Data with Status register. Combines the last character received with the current USART receive status. Allows DMA or software to recover incoming data and status together.
func (o *USART0_Type) SetRXDATSTAT_RXDATA(value uint32) {
	volatile.StoreUint32(&o.RXDATSTAT.Reg, volatile.LoadUint32(&o.RXDATSTAT.Reg)&^(0x1ff)|value)
}
func (o *USART0_Type) GetRXDATSTAT_RXDATA() uint32 {
	return volatile.LoadUint32(&o.RXDATSTAT.Reg) & 0x1ff
}
func (o *USART0_Type) SetRXDATSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RXDATSTAT.Reg, volatile.LoadUint32(&o.RXDATSTAT.Reg)&^(0x1e00)|value<<9)
}
func (o *USART0_Type) GetRXDATSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.RXDATSTAT.Reg) & 0x1e00) >> 9
}
func (o *USART0_Type) SetRXDATSTAT_FRAMERR(value uint32) {
	volatile.StoreUint32(&o.RXDATSTAT.Reg, volatile.LoadUint32(&o.RXDATSTAT.Reg)&^(0x2000)|value<<13)
}
func (o *USART0_Type) GetRXDATSTAT_FRAMERR() uint32 {
	return (volatile.LoadUint32(&o.RXDATSTAT.Reg) & 0x2000) >> 13
}
func (o *USART0_Type) SetRXDATSTAT_PARITYERR(value uint32) {
	volatile.StoreUint32(&o.RXDATSTAT.Reg, volatile.LoadUint32(&o.RXDATSTAT.Reg)&^(0x4000)|value<<14)
}
func (o *USART0_Type) GetRXDATSTAT_PARITYERR() uint32 {
	return (volatile.LoadUint32(&o.RXDATSTAT.Reg) & 0x4000) >> 14
}
func (o *USART0_Type) SetRXDATSTAT_RXNOISE(value uint32) {
	volatile.StoreUint32(&o.RXDATSTAT.Reg, volatile.LoadUint32(&o.RXDATSTAT.Reg)&^(0x8000)|value<<15)
}
func (o *USART0_Type) GetRXDATSTAT_RXNOISE() uint32 {
	return (volatile.LoadUint32(&o.RXDATSTAT.Reg) & 0x8000) >> 15
}
func (o *USART0_Type) SetRXDATSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RXDATSTAT.Reg, volatile.LoadUint32(&o.RXDATSTAT.Reg)&^(0xffff0000)|value<<16)
}
func (o *USART0_Type) GetRXDATSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.RXDATSTAT.Reg) & 0xffff0000) >> 16
}

// USART0.TXDAT: Transmit Data register. Data to be transmitted is written here.
func (o *USART0_Type) SetTXDAT_TXDATA(value uint32) {
	volatile.StoreUint32(&o.TXDAT.Reg, volatile.LoadUint32(&o.TXDAT.Reg)&^(0x1ff)|value)
}
func (o *USART0_Type) GetTXDAT_TXDATA() uint32 {
	return volatile.LoadUint32(&o.TXDAT.Reg) & 0x1ff
}
func (o *USART0_Type) SetTXDAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TXDAT.Reg, volatile.LoadUint32(&o.TXDAT.Reg)&^(0xfffffe00)|value<<9)
}
func (o *USART0_Type) GetTXDAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TXDAT.Reg) & 0xfffffe00) >> 9
}

// USART0.BRG: Baud Rate Generator register. 16-bit integer baud rate divisor value.
func (o *USART0_Type) SetBRG_BRGVAL(value uint32) {
	volatile.StoreUint32(&o.BRG.Reg, volatile.LoadUint32(&o.BRG.Reg)&^(0xffff)|value)
}
func (o *USART0_Type) GetBRG_BRGVAL() uint32 {
	return volatile.LoadUint32(&o.BRG.Reg) & 0xffff
}
func (o *USART0_Type) SetBRG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.BRG.Reg, volatile.LoadUint32(&o.BRG.Reg)&^(0xffff0000)|value<<16)
}
func (o *USART0_Type) GetBRG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.BRG.Reg) & 0xffff0000) >> 16
}

// USART0.INTSTAT: Interrupt status register. Reflects interrupts that are currently enabled.
func (o *USART0_Type) SetINTSTAT_RXRDY(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x1)|value)
}
func (o *USART0_Type) GetINTSTAT_RXRDY() uint32 {
	return volatile.LoadUint32(&o.INTSTAT.Reg) & 0x1
}
func (o *USART0_Type) SetINTSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x2)|value<<1)
}
func (o *USART0_Type) GetINTSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x2) >> 1
}
func (o *USART0_Type) SetINTSTAT_TXRDY(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x4)|value<<2)
}
func (o *USART0_Type) GetINTSTAT_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x4) >> 2
}
func (o *USART0_Type) SetINTSTAT_TXIDLE(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x8)|value<<3)
}
func (o *USART0_Type) GetINTSTAT_TXIDLE() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x8) >> 3
}
func (o *USART0_Type) SetINTSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x10)|value<<4)
}
func (o *USART0_Type) GetINTSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x10) >> 4
}
func (o *USART0_Type) SetINTSTAT_DELTACTS(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x20)|value<<5)
}
func (o *USART0_Type) GetINTSTAT_DELTACTS() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x20) >> 5
}
func (o *USART0_Type) SetINTSTAT_TXDISINT(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x40)|value<<6)
}
func (o *USART0_Type) GetINTSTAT_TXDISINT() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x40) >> 6
}
func (o *USART0_Type) SetINTSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x80)|value<<7)
}
func (o *USART0_Type) GetINTSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x80) >> 7
}
func (o *USART0_Type) SetINTSTAT_OVERRUNINT(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x100)|value<<8)
}
func (o *USART0_Type) GetINTSTAT_OVERRUNINT() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x100) >> 8
}
func (o *USART0_Type) SetINTSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x600)|value<<9)
}
func (o *USART0_Type) GetINTSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x600) >> 9
}
func (o *USART0_Type) SetINTSTAT_DELTARXBRK(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x800)|value<<11)
}
func (o *USART0_Type) GetINTSTAT_DELTARXBRK() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x800) >> 11
}
func (o *USART0_Type) SetINTSTAT_START(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x1000)|value<<12)
}
func (o *USART0_Type) GetINTSTAT_START() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x1000) >> 12
}
func (o *USART0_Type) SetINTSTAT_FRAMERRINT(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x2000)|value<<13)
}
func (o *USART0_Type) GetINTSTAT_FRAMERRINT() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x2000) >> 13
}
func (o *USART0_Type) SetINTSTAT_PARITYERRINT(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x4000)|value<<14)
}
func (o *USART0_Type) GetINTSTAT_PARITYERRINT() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x4000) >> 14
}
func (o *USART0_Type) SetINTSTAT_RXNOISEINT(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x8000)|value<<15)
}
func (o *USART0_Type) GetINTSTAT_RXNOISEINT() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x8000) >> 15
}
func (o *USART0_Type) SetINTSTAT_ABERRINT(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x10000)|value<<16)
}
func (o *USART0_Type) GetINTSTAT_ABERRINT() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x10000) >> 16
}
func (o *USART0_Type) SetINTSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0xfffe0000)|value<<17)
}
func (o *USART0_Type) GetINTSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0xfffe0000) >> 17
}

// USART0.OSR: Oversample selection register for asynchronous communication.
func (o *USART0_Type) SetOSR_OSRVAL(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0xf)|value)
}
func (o *USART0_Type) GetOSR_OSRVAL() uint32 {
	return volatile.LoadUint32(&o.OSR.Reg) & 0xf
}
func (o *USART0_Type) SetOSR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0xfffffff0)|value<<4)
}
func (o *USART0_Type) GetOSR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0xfffffff0) >> 4
}

// USART0.ADDR: Address register for automatic address matching.
func (o *USART0_Type) SetADDR_ADDRESS(value uint32) {
	volatile.StoreUint32(&o.ADDR.Reg, volatile.LoadUint32(&o.ADDR.Reg)&^(0xff)|value)
}
func (o *USART0_Type) GetADDR_ADDRESS() uint32 {
	return volatile.LoadUint32(&o.ADDR.Reg) & 0xff
}
func (o *USART0_Type) SetADDR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ADDR.Reg, volatile.LoadUint32(&o.ADDR.Reg)&^(0xffffff00)|value<<8)
}
func (o *USART0_Type) GetADDR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ADDR.Reg) & 0xffffff00) >> 8
}

// SPI0
type SPI0_Type struct {
	CFG      volatile.Register32 // 0x0
	DLY      volatile.Register32 // 0x4
	STAT     volatile.Register32 // 0x8
	INTENSET volatile.Register32 // 0xC
	INTENCLR volatile.Register32 // 0x10
	RXDAT    volatile.Register32 // 0x14
	TXDATCTL volatile.Register32 // 0x18
	TXDAT    volatile.Register32 // 0x1C
	TXCTL    volatile.Register32 // 0x20
	DIV      volatile.Register32 // 0x24
	INTSTAT  volatile.Register32 // 0x28
}

// SPI0.CFG: SPI Configuration register
func (o *SPI0_Type) SetCFG_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x1)|value)
}
func (o *SPI0_Type) GetCFG_ENABLE() uint32 {
	return volatile.LoadUint32(&o.CFG.Reg) & 0x1
}
func (o *SPI0_Type) SetCFG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x2)|value<<1)
}
func (o *SPI0_Type) GetCFG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x2) >> 1
}
func (o *SPI0_Type) SetCFG_MASTER(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x4)|value<<2)
}
func (o *SPI0_Type) GetCFG_MASTER() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x4) >> 2
}
func (o *SPI0_Type) SetCFG_LSBF(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x8)|value<<3)
}
func (o *SPI0_Type) GetCFG_LSBF() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x8) >> 3
}
func (o *SPI0_Type) SetCFG_CPHA(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x10)|value<<4)
}
func (o *SPI0_Type) GetCFG_CPHA() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x10) >> 4
}
func (o *SPI0_Type) SetCFG_CPOL(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x20)|value<<5)
}
func (o *SPI0_Type) GetCFG_CPOL() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x20) >> 5
}
func (o *SPI0_Type) SetCFG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x40)|value<<6)
}
func (o *SPI0_Type) GetCFG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x40) >> 6
}
func (o *SPI0_Type) SetCFG_LOOP(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x80)|value<<7)
}
func (o *SPI0_Type) GetCFG_LOOP() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x80) >> 7
}
func (o *SPI0_Type) SetCFG_SPOL0(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x100)|value<<8)
}
func (o *SPI0_Type) GetCFG_SPOL0() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x100) >> 8
}
func (o *SPI0_Type) SetCFG_SPOL1(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x200)|value<<9)
}
func (o *SPI0_Type) GetCFG_SPOL1() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x200) >> 9
}
func (o *SPI0_Type) SetCFG_SPOL2(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x400)|value<<10)
}
func (o *SPI0_Type) GetCFG_SPOL2() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x400) >> 10
}
func (o *SPI0_Type) SetCFG_SPOL3(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x800)|value<<11)
}
func (o *SPI0_Type) GetCFG_SPOL3() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x800) >> 11
}
func (o *SPI0_Type) SetCFG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0xfffff000)|value<<12)
}
func (o *SPI0_Type) GetCFG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0xfffff000) >> 12
}

// SPI0.DLY: SPI Delay register
func (o *SPI0_Type) SetDLY_PRE_DELAY(value uint32) {
	volatile.StoreUint32(&o.DLY.Reg, volatile.LoadUint32(&o.DLY.Reg)&^(0xf)|value)
}
func (o *SPI0_Type) GetDLY_PRE_DELAY() uint32 {
	return volatile.LoadUint32(&o.DLY.Reg) & 0xf
}
func (o *SPI0_Type) SetDLY_POST_DELAY(value uint32) {
	volatile.StoreUint32(&o.DLY.Reg, volatile.LoadUint32(&o.DLY.Reg)&^(0xf0)|value<<4)
}
func (o *SPI0_Type) GetDLY_POST_DELAY() uint32 {
	return (volatile.LoadUint32(&o.DLY.Reg) & 0xf0) >> 4
}
func (o *SPI0_Type) SetDLY_FRAME_DELAY(value uint32) {
	volatile.StoreUint32(&o.DLY.Reg, volatile.LoadUint32(&o.DLY.Reg)&^(0xf00)|value<<8)
}
func (o *SPI0_Type) GetDLY_FRAME_DELAY() uint32 {
	return (volatile.LoadUint32(&o.DLY.Reg) & 0xf00) >> 8
}
func (o *SPI0_Type) SetDLY_TRANSFER_DELAY(value uint32) {
	volatile.StoreUint32(&o.DLY.Reg, volatile.LoadUint32(&o.DLY.Reg)&^(0xf000)|value<<12)
}
func (o *SPI0_Type) GetDLY_TRANSFER_DELAY() uint32 {
	return (volatile.LoadUint32(&o.DLY.Reg) & 0xf000) >> 12
}
func (o *SPI0_Type) SetDLY_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DLY.Reg, volatile.LoadUint32(&o.DLY.Reg)&^(0xffff0000)|value<<16)
}
func (o *SPI0_Type) GetDLY_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DLY.Reg) & 0xffff0000) >> 16
}

// SPI0.STAT: SPI Status. Some status flags can be cleared by writing a 1 to that bit position
func (o *SPI0_Type) SetSTAT_RXRDY(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x1)|value)
}
func (o *SPI0_Type) GetSTAT_RXRDY() uint32 {
	return volatile.LoadUint32(&o.STAT.Reg) & 0x1
}
func (o *SPI0_Type) SetSTAT_TXRDY(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x2)|value<<1)
}
func (o *SPI0_Type) GetSTAT_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x2) >> 1
}
func (o *SPI0_Type) SetSTAT_RXOV(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x4)|value<<2)
}
func (o *SPI0_Type) GetSTAT_RXOV() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x4) >> 2
}
func (o *SPI0_Type) SetSTAT_TXUR(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x8)|value<<3)
}
func (o *SPI0_Type) GetSTAT_TXUR() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x8) >> 3
}
func (o *SPI0_Type) SetSTAT_SSA(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x10)|value<<4)
}
func (o *SPI0_Type) GetSTAT_SSA() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x10) >> 4
}
func (o *SPI0_Type) SetSTAT_SSD(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x20)|value<<5)
}
func (o *SPI0_Type) GetSTAT_SSD() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x20) >> 5
}
func (o *SPI0_Type) SetSTAT_STALLED(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x40)|value<<6)
}
func (o *SPI0_Type) GetSTAT_STALLED() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x40) >> 6
}
func (o *SPI0_Type) SetSTAT_ENDTRANSFER(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x80)|value<<7)
}
func (o *SPI0_Type) GetSTAT_ENDTRANSFER() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x80) >> 7
}
func (o *SPI0_Type) SetSTAT_IDLE(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x100)|value<<8)
}
func (o *SPI0_Type) GetSTAT_IDLE() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x100) >> 8
}
func (o *SPI0_Type) SetSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0xfffffe00)|value<<9)
}
func (o *SPI0_Type) GetSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0xfffffe00) >> 9
}

// SPI0.INTENSET: SPI Interrupt Enable read and Set. A complete value may be read from this register. Writing a 1 to any implemented bit position causes that bit to be set.
func (o *SPI0_Type) SetINTENSET_RXRDYEN(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *SPI0_Type) GetINTENSET_RXRDYEN() uint32 {
	return volatile.LoadUint32(&o.INTENSET.Reg) & 0x1
}
func (o *SPI0_Type) SetINTENSET_TXRDYEN(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *SPI0_Type) GetINTENSET_TXRDYEN() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *SPI0_Type) SetINTENSET_RXOVEN(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4)|value<<2)
}
func (o *SPI0_Type) GetINTENSET_RXOVEN() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4) >> 2
}
func (o *SPI0_Type) SetINTENSET_TXUREN(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x8)|value<<3)
}
func (o *SPI0_Type) GetINTENSET_TXUREN() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x8) >> 3
}
func (o *SPI0_Type) SetINTENSET_SSAEN(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x10)|value<<4)
}
func (o *SPI0_Type) GetINTENSET_SSAEN() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x10) >> 4
}
func (o *SPI0_Type) SetINTENSET_SSDEN(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x20)|value<<5)
}
func (o *SPI0_Type) GetINTENSET_SSDEN() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x20) >> 5
}
func (o *SPI0_Type) SetINTENSET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0xffffffc0)|value<<6)
}
func (o *SPI0_Type) GetINTENSET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0xffffffc0) >> 6
}

// SPI0.INTENCLR: SPI Interrupt Enable Clear. Writing a 1 to any implemented bit position causes the corresponding bit in INTENSET to be cleared.
func (o *SPI0_Type) SetINTENCLR_RXRDYEN(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *SPI0_Type) GetINTENCLR_RXRDYEN() uint32 {
	return volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1
}
func (o *SPI0_Type) SetINTENCLR_TXRDYEN(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *SPI0_Type) GetINTENCLR_TXRDYEN() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *SPI0_Type) SetINTENCLR_RXOVEN(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4)|value<<2)
}
func (o *SPI0_Type) GetINTENCLR_RXOVEN() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4) >> 2
}
func (o *SPI0_Type) SetINTENCLR_TXUREN(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x8)|value<<3)
}
func (o *SPI0_Type) GetINTENCLR_TXUREN() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x8) >> 3
}
func (o *SPI0_Type) SetINTENCLR_SSAEN(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x10)|value<<4)
}
func (o *SPI0_Type) GetINTENCLR_SSAEN() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x10) >> 4
}
func (o *SPI0_Type) SetINTENCLR_SSDEN(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x20)|value<<5)
}
func (o *SPI0_Type) GetINTENCLR_SSDEN() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x20) >> 5
}
func (o *SPI0_Type) SetINTENCLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0xffffffc0)|value<<6)
}
func (o *SPI0_Type) GetINTENCLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0xffffffc0) >> 6
}

// SPI0.RXDAT: SPI Receive Data
func (o *SPI0_Type) SetRXDAT(value uint32) {
	volatile.StoreUint32(&o.RXDAT.Reg, volatile.LoadUint32(&o.RXDAT.Reg)&^(0xffff)|value)
}
func (o *SPI0_Type) GetRXDAT() uint32 {
	return volatile.LoadUint32(&o.RXDAT.Reg) & 0xffff
}
func (o *SPI0_Type) SetRXDAT_RXSSEL0(value uint32) {
	volatile.StoreUint32(&o.RXDAT.Reg, volatile.LoadUint32(&o.RXDAT.Reg)&^(0x10000)|value<<16)
}
func (o *SPI0_Type) GetRXDAT_RXSSEL0() uint32 {
	return (volatile.LoadUint32(&o.RXDAT.Reg) & 0x10000) >> 16
}
func (o *SPI0_Type) SetRXDAT_RXSSEL1(value uint32) {
	volatile.StoreUint32(&o.RXDAT.Reg, volatile.LoadUint32(&o.RXDAT.Reg)&^(0x20000)|value<<17)
}
func (o *SPI0_Type) GetRXDAT_RXSSEL1() uint32 {
	return (volatile.LoadUint32(&o.RXDAT.Reg) & 0x20000) >> 17
}
func (o *SPI0_Type) SetRXDAT_RXSSEL2(value uint32) {
	volatile.StoreUint32(&o.RXDAT.Reg, volatile.LoadUint32(&o.RXDAT.Reg)&^(0x40000)|value<<18)
}
func (o *SPI0_Type) GetRXDAT_RXSSEL2() uint32 {
	return (volatile.LoadUint32(&o.RXDAT.Reg) & 0x40000) >> 18
}
func (o *SPI0_Type) SetRXDAT_RXSSEL3(value uint32) {
	volatile.StoreUint32(&o.RXDAT.Reg, volatile.LoadUint32(&o.RXDAT.Reg)&^(0x80000)|value<<19)
}
func (o *SPI0_Type) GetRXDAT_RXSSEL3() uint32 {
	return (volatile.LoadUint32(&o.RXDAT.Reg) & 0x80000) >> 19
}
func (o *SPI0_Type) SetRXDAT_SOT(value uint32) {
	volatile.StoreUint32(&o.RXDAT.Reg, volatile.LoadUint32(&o.RXDAT.Reg)&^(0x100000)|value<<20)
}
func (o *SPI0_Type) GetRXDAT_SOT() uint32 {
	return (volatile.LoadUint32(&o.RXDAT.Reg) & 0x100000) >> 20
}
func (o *SPI0_Type) SetRXDAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RXDAT.Reg, volatile.LoadUint32(&o.RXDAT.Reg)&^(0xffe00000)|value<<21)
}
func (o *SPI0_Type) GetRXDAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.RXDAT.Reg) & 0xffe00000) >> 21
}

// SPI0.TXDATCTL: SPI Transmit Data with Control
func (o *SPI0_Type) SetTXDATCTL_TXDAT(value uint32) {
	volatile.StoreUint32(&o.TXDATCTL.Reg, volatile.LoadUint32(&o.TXDATCTL.Reg)&^(0xffff)|value)
}
func (o *SPI0_Type) GetTXDATCTL_TXDAT() uint32 {
	return volatile.LoadUint32(&o.TXDATCTL.Reg) & 0xffff
}
func (o *SPI0_Type) SetTXDATCTL_TXSSEL0(value uint32) {
	volatile.StoreUint32(&o.TXDATCTL.Reg, volatile.LoadUint32(&o.TXDATCTL.Reg)&^(0x10000)|value<<16)
}
func (o *SPI0_Type) GetTXDATCTL_TXSSEL0() uint32 {
	return (volatile.LoadUint32(&o.TXDATCTL.Reg) & 0x10000) >> 16
}
func (o *SPI0_Type) SetTXDATCTL_TXSSEL1(value uint32) {
	volatile.StoreUint32(&o.TXDATCTL.Reg, volatile.LoadUint32(&o.TXDATCTL.Reg)&^(0x20000)|value<<17)
}
func (o *SPI0_Type) GetTXDATCTL_TXSSEL1() uint32 {
	return (volatile.LoadUint32(&o.TXDATCTL.Reg) & 0x20000) >> 17
}
func (o *SPI0_Type) SetTXDATCTL_TXSSEL2(value uint32) {
	volatile.StoreUint32(&o.TXDATCTL.Reg, volatile.LoadUint32(&o.TXDATCTL.Reg)&^(0x40000)|value<<18)
}
func (o *SPI0_Type) GetTXDATCTL_TXSSEL2() uint32 {
	return (volatile.LoadUint32(&o.TXDATCTL.Reg) & 0x40000) >> 18
}
func (o *SPI0_Type) SetTXDATCTL_TXSSEL3(value uint32) {
	volatile.StoreUint32(&o.TXDATCTL.Reg, volatile.LoadUint32(&o.TXDATCTL.Reg)&^(0x80000)|value<<19)
}
func (o *SPI0_Type) GetTXDATCTL_TXSSEL3() uint32 {
	return (volatile.LoadUint32(&o.TXDATCTL.Reg) & 0x80000) >> 19
}
func (o *SPI0_Type) SetTXDATCTL_EOT(value uint32) {
	volatile.StoreUint32(&o.TXDATCTL.Reg, volatile.LoadUint32(&o.TXDATCTL.Reg)&^(0x100000)|value<<20)
}
func (o *SPI0_Type) GetTXDATCTL_EOT() uint32 {
	return (volatile.LoadUint32(&o.TXDATCTL.Reg) & 0x100000) >> 20
}
func (o *SPI0_Type) SetTXDATCTL_EOF(value uint32) {
	volatile.StoreUint32(&o.TXDATCTL.Reg, volatile.LoadUint32(&o.TXDATCTL.Reg)&^(0x200000)|value<<21)
}
func (o *SPI0_Type) GetTXDATCTL_EOF() uint32 {
	return (volatile.LoadUint32(&o.TXDATCTL.Reg) & 0x200000) >> 21
}
func (o *SPI0_Type) SetTXDATCTL_RXIGNORE(value uint32) {
	volatile.StoreUint32(&o.TXDATCTL.Reg, volatile.LoadUint32(&o.TXDATCTL.Reg)&^(0x400000)|value<<22)
}
func (o *SPI0_Type) GetTXDATCTL_RXIGNORE() uint32 {
	return (volatile.LoadUint32(&o.TXDATCTL.Reg) & 0x400000) >> 22
}
func (o *SPI0_Type) SetTXDATCTL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TXDATCTL.Reg, volatile.LoadUint32(&o.TXDATCTL.Reg)&^(0x800000)|value<<23)
}
func (o *SPI0_Type) GetTXDATCTL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TXDATCTL.Reg) & 0x800000) >> 23
}
func (o *SPI0_Type) SetTXDATCTL_FLEN(value uint32) {
	volatile.StoreUint32(&o.TXDATCTL.Reg, volatile.LoadUint32(&o.TXDATCTL.Reg)&^(0xf000000)|value<<24)
}
func (o *SPI0_Type) GetTXDATCTL_FLEN() uint32 {
	return (volatile.LoadUint32(&o.TXDATCTL.Reg) & 0xf000000) >> 24
}
func (o *SPI0_Type) SetTXDATCTL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TXDATCTL.Reg, volatile.LoadUint32(&o.TXDATCTL.Reg)&^(0xf0000000)|value<<28)
}
func (o *SPI0_Type) GetTXDATCTL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TXDATCTL.Reg) & 0xf0000000) >> 28
}

// SPI0.TXDAT: SPI Transmit Data with Control
func (o *SPI0_Type) SetTXDAT_DATA(value uint32) {
	volatile.StoreUint32(&o.TXDAT.Reg, volatile.LoadUint32(&o.TXDAT.Reg)&^(0xffff)|value)
}
func (o *SPI0_Type) GetTXDAT_DATA() uint32 {
	return volatile.LoadUint32(&o.TXDAT.Reg) & 0xffff
}
func (o *SPI0_Type) SetTXDAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TXDAT.Reg, volatile.LoadUint32(&o.TXDAT.Reg)&^(0xffff0000)|value<<16)
}
func (o *SPI0_Type) GetTXDAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TXDAT.Reg) & 0xffff0000) >> 16
}

// SPI0.TXCTL: SPI Transmit Control
func (o *SPI0_Type) SetTXCTL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TXCTL.Reg, volatile.LoadUint32(&o.TXCTL.Reg)&^(0xffff)|value)
}
func (o *SPI0_Type) GetTXCTL_RESERVED() uint32 {
	return volatile.LoadUint32(&o.TXCTL.Reg) & 0xffff
}
func (o *SPI0_Type) SetTXCTL_TXSSEL0(value uint32) {
	volatile.StoreUint32(&o.TXCTL.Reg, volatile.LoadUint32(&o.TXCTL.Reg)&^(0x10000)|value<<16)
}
func (o *SPI0_Type) GetTXCTL_TXSSEL0() uint32 {
	return (volatile.LoadUint32(&o.TXCTL.Reg) & 0x10000) >> 16
}
func (o *SPI0_Type) SetTXCTL_TXSSEL1(value uint32) {
	volatile.StoreUint32(&o.TXCTL.Reg, volatile.LoadUint32(&o.TXCTL.Reg)&^(0x20000)|value<<17)
}
func (o *SPI0_Type) GetTXCTL_TXSSEL1() uint32 {
	return (volatile.LoadUint32(&o.TXCTL.Reg) & 0x20000) >> 17
}
func (o *SPI0_Type) SetTXCTL_TXSSEL2(value uint32) {
	volatile.StoreUint32(&o.TXCTL.Reg, volatile.LoadUint32(&o.TXCTL.Reg)&^(0x40000)|value<<18)
}
func (o *SPI0_Type) GetTXCTL_TXSSEL2() uint32 {
	return (volatile.LoadUint32(&o.TXCTL.Reg) & 0x40000) >> 18
}
func (o *SPI0_Type) SetTXCTL_TXSSEL3(value uint32) {
	volatile.StoreUint32(&o.TXCTL.Reg, volatile.LoadUint32(&o.TXCTL.Reg)&^(0x80000)|value<<19)
}
func (o *SPI0_Type) GetTXCTL_TXSSEL3() uint32 {
	return (volatile.LoadUint32(&o.TXCTL.Reg) & 0x80000) >> 19
}
func (o *SPI0_Type) SetTXCTL_EOT(value uint32) {
	volatile.StoreUint32(&o.TXCTL.Reg, volatile.LoadUint32(&o.TXCTL.Reg)&^(0x100000)|value<<20)
}
func (o *SPI0_Type) GetTXCTL_EOT() uint32 {
	return (volatile.LoadUint32(&o.TXCTL.Reg) & 0x100000) >> 20
}
func (o *SPI0_Type) SetTXCTL_EOF(value uint32) {
	volatile.StoreUint32(&o.TXCTL.Reg, volatile.LoadUint32(&o.TXCTL.Reg)&^(0x200000)|value<<21)
}
func (o *SPI0_Type) GetTXCTL_EOF() uint32 {
	return (volatile.LoadUint32(&o.TXCTL.Reg) & 0x200000) >> 21
}
func (o *SPI0_Type) SetTXCTL_RXIGNORE(value uint32) {
	volatile.StoreUint32(&o.TXCTL.Reg, volatile.LoadUint32(&o.TXCTL.Reg)&^(0x400000)|value<<22)
}
func (o *SPI0_Type) GetTXCTL_RXIGNORE() uint32 {
	return (volatile.LoadUint32(&o.TXCTL.Reg) & 0x400000) >> 22
}
func (o *SPI0_Type) SetTXCTL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TXCTL.Reg, volatile.LoadUint32(&o.TXCTL.Reg)&^(0x800000)|value<<23)
}
func (o *SPI0_Type) GetTXCTL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TXCTL.Reg) & 0x800000) >> 23
}
func (o *SPI0_Type) SetTXCTL_FLEN(value uint32) {
	volatile.StoreUint32(&o.TXCTL.Reg, volatile.LoadUint32(&o.TXCTL.Reg)&^(0xf000000)|value<<24)
}
func (o *SPI0_Type) GetTXCTL_FLEN() uint32 {
	return (volatile.LoadUint32(&o.TXCTL.Reg) & 0xf000000) >> 24
}
func (o *SPI0_Type) SetTXCTL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TXCTL.Reg, volatile.LoadUint32(&o.TXCTL.Reg)&^(0xf0000000)|value<<28)
}
func (o *SPI0_Type) GetTXCTL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TXCTL.Reg) & 0xf0000000) >> 28
}

// SPI0.DIV: SPI clock Divider
func (o *SPI0_Type) SetDIV_DIVVAL(value uint32) {
	volatile.StoreUint32(&o.DIV.Reg, volatile.LoadUint32(&o.DIV.Reg)&^(0xffff)|value)
}
func (o *SPI0_Type) GetDIV_DIVVAL() uint32 {
	return volatile.LoadUint32(&o.DIV.Reg) & 0xffff
}
func (o *SPI0_Type) SetDIV_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DIV.Reg, volatile.LoadUint32(&o.DIV.Reg)&^(0xffff0000)|value<<16)
}
func (o *SPI0_Type) GetDIV_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DIV.Reg) & 0xffff0000) >> 16
}

// SPI0.INTSTAT: SPI Interrupt Status
func (o *SPI0_Type) SetINTSTAT_RXRDY(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x1)|value)
}
func (o *SPI0_Type) GetINTSTAT_RXRDY() uint32 {
	return volatile.LoadUint32(&o.INTSTAT.Reg) & 0x1
}
func (o *SPI0_Type) SetINTSTAT_TXRDY(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x2)|value<<1)
}
func (o *SPI0_Type) GetINTSTAT_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x2) >> 1
}
func (o *SPI0_Type) SetINTSTAT_RXOV(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x4)|value<<2)
}
func (o *SPI0_Type) GetINTSTAT_RXOV() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x4) >> 2
}
func (o *SPI0_Type) SetINTSTAT_TXUR(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x8)|value<<3)
}
func (o *SPI0_Type) GetINTSTAT_TXUR() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x8) >> 3
}
func (o *SPI0_Type) SetINTSTAT_SSA(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x10)|value<<4)
}
func (o *SPI0_Type) GetINTSTAT_SSA() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x10) >> 4
}
func (o *SPI0_Type) SetINTSTAT_SSD(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x20)|value<<5)
}
func (o *SPI0_Type) GetINTSTAT_SSD() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x20) >> 5
}
func (o *SPI0_Type) SetINTSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0xffffffc0)|value<<6)
}
func (o *SPI0_Type) GetINTSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0xffffffc0) >> 6
}

// I2C-bus interface
type I2C0_Type struct {
	CFG      volatile.Register32 // 0x0
	STAT     volatile.Register32 // 0x4
	INTENSET volatile.Register32 // 0x8
	INTENCLR volatile.Register32 // 0xC
	TIMEOUT  volatile.Register32 // 0x10
	CLKDIV   volatile.Register32 // 0x14
	INTSTAT  volatile.Register32 // 0x18
	_        [4]byte
	MSTCTL   volatile.Register32 // 0x20
	MSTTIME  volatile.Register32 // 0x24
	MSTDAT   volatile.Register32 // 0x28
	_        [20]byte
	SLVCTL   volatile.Register32 // 0x40
	SLVDAT   volatile.Register32 // 0x44
	SLVADR0  volatile.Register32 // 0x48
	SLVADR1  volatile.Register32 // 0x4C
	SLVADR2  volatile.Register32 // 0x50
	SLVADR3  volatile.Register32 // 0x54
	SLVQUAL0 volatile.Register32 // 0x58
	_        [36]byte
	MONRXDAT volatile.Register32 // 0x80
}

// I2C0.CFG: Configuration for shared functions.
func (o *I2C0_Type) SetCFG_MSTEN(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x1)|value)
}
func (o *I2C0_Type) GetCFG_MSTEN() uint32 {
	return volatile.LoadUint32(&o.CFG.Reg) & 0x1
}
func (o *I2C0_Type) SetCFG_SLVEN(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x2)|value<<1)
}
func (o *I2C0_Type) GetCFG_SLVEN() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x2) >> 1
}
func (o *I2C0_Type) SetCFG_MONEN(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x4)|value<<2)
}
func (o *I2C0_Type) GetCFG_MONEN() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x4) >> 2
}
func (o *I2C0_Type) SetCFG_TIMEOUTEN(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x8)|value<<3)
}
func (o *I2C0_Type) GetCFG_TIMEOUTEN() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x8) >> 3
}
func (o *I2C0_Type) SetCFG_MONCLKSTR(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x10)|value<<4)
}
func (o *I2C0_Type) GetCFG_MONCLKSTR() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x10) >> 4
}
func (o *I2C0_Type) SetCFG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0xffffffe0)|value<<5)
}
func (o *I2C0_Type) GetCFG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0xffffffe0) >> 5
}

// I2C0.STAT: Status register for Master, Slave, and Monitor functions.
func (o *I2C0_Type) SetSTAT_MSTPENDING(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x1)|value)
}
func (o *I2C0_Type) GetSTAT_MSTPENDING() uint32 {
	return volatile.LoadUint32(&o.STAT.Reg) & 0x1
}
func (o *I2C0_Type) SetSTAT_MSTSTATE(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0xe)|value<<1)
}
func (o *I2C0_Type) GetSTAT_MSTSTATE() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0xe) >> 1
}
func (o *I2C0_Type) SetSTAT_MSTARBLOSS(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x10)|value<<4)
}
func (o *I2C0_Type) GetSTAT_MSTARBLOSS() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x10) >> 4
}
func (o *I2C0_Type) SetSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x20)|value<<5)
}
func (o *I2C0_Type) GetSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x20) >> 5
}
func (o *I2C0_Type) SetSTAT_MSTSTSTPERR(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x40)|value<<6)
}
func (o *I2C0_Type) GetSTAT_MSTSTSTPERR() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x40) >> 6
}
func (o *I2C0_Type) SetSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x80)|value<<7)
}
func (o *I2C0_Type) GetSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x80) >> 7
}
func (o *I2C0_Type) SetSTAT_SLVPENDING(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x100)|value<<8)
}
func (o *I2C0_Type) GetSTAT_SLVPENDING() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x100) >> 8
}
func (o *I2C0_Type) SetSTAT_SLVSTATE(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x600)|value<<9)
}
func (o *I2C0_Type) GetSTAT_SLVSTATE() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x600) >> 9
}
func (o *I2C0_Type) SetSTAT_SLVNOTSTR(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x800)|value<<11)
}
func (o *I2C0_Type) GetSTAT_SLVNOTSTR() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x800) >> 11
}
func (o *I2C0_Type) SetSTAT_SLVIDX(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x3000)|value<<12)
}
func (o *I2C0_Type) GetSTAT_SLVIDX() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x3000) >> 12
}
func (o *I2C0_Type) SetSTAT_SLVSEL(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x4000)|value<<14)
}
func (o *I2C0_Type) GetSTAT_SLVSEL() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x4000) >> 14
}
func (o *I2C0_Type) SetSTAT_SLVDESEL(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x8000)|value<<15)
}
func (o *I2C0_Type) GetSTAT_SLVDESEL() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x8000) >> 15
}
func (o *I2C0_Type) SetSTAT_MONRDY(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x10000)|value<<16)
}
func (o *I2C0_Type) GetSTAT_MONRDY() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x10000) >> 16
}
func (o *I2C0_Type) SetSTAT_MONOV(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x20000)|value<<17)
}
func (o *I2C0_Type) GetSTAT_MONOV() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x20000) >> 17
}
func (o *I2C0_Type) SetSTAT_MONACTIVE(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x40000)|value<<18)
}
func (o *I2C0_Type) GetSTAT_MONACTIVE() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x40000) >> 18
}
func (o *I2C0_Type) SetSTAT_MONIDLE(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x80000)|value<<19)
}
func (o *I2C0_Type) GetSTAT_MONIDLE() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x80000) >> 19
}
func (o *I2C0_Type) SetSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0xf00000)|value<<20)
}
func (o *I2C0_Type) GetSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0xf00000) >> 20
}
func (o *I2C0_Type) SetSTAT_EVENTTIMEOUT(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x1000000)|value<<24)
}
func (o *I2C0_Type) GetSTAT_EVENTTIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x1000000) >> 24
}
func (o *I2C0_Type) SetSTAT_SCLTIMEOUT(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x2000000)|value<<25)
}
func (o *I2C0_Type) GetSTAT_SCLTIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x2000000) >> 25
}
func (o *I2C0_Type) SetSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0xfc000000)|value<<26)
}
func (o *I2C0_Type) GetSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0xfc000000) >> 26
}

// I2C0.INTENSET: Interrupt Enable Set and read register.
func (o *I2C0_Type) SetINTENSET_MSTPENDINGEN(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *I2C0_Type) GetINTENSET_MSTPENDINGEN() uint32 {
	return volatile.LoadUint32(&o.INTENSET.Reg) & 0x1
}
func (o *I2C0_Type) SetINTENSET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0xe)|value<<1)
}
func (o *I2C0_Type) GetINTENSET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0xe) >> 1
}
func (o *I2C0_Type) SetINTENSET_MSTARBLOSSEN(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x10)|value<<4)
}
func (o *I2C0_Type) GetINTENSET_MSTARBLOSSEN() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x10) >> 4
}
func (o *I2C0_Type) SetINTENSET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x20)|value<<5)
}
func (o *I2C0_Type) GetINTENSET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x20) >> 5
}
func (o *I2C0_Type) SetINTENSET_MSTSTSTPERREN(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x40)|value<<6)
}
func (o *I2C0_Type) GetINTENSET_MSTSTSTPERREN() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x40) >> 6
}
func (o *I2C0_Type) SetINTENSET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x80)|value<<7)
}
func (o *I2C0_Type) GetINTENSET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x80) >> 7
}
func (o *I2C0_Type) SetINTENSET_SLVPENDINGEN(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x100)|value<<8)
}
func (o *I2C0_Type) GetINTENSET_SLVPENDINGEN() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x100) >> 8
}
func (o *I2C0_Type) SetINTENSET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x600)|value<<9)
}
func (o *I2C0_Type) GetINTENSET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x600) >> 9
}
func (o *I2C0_Type) SetINTENSET_SLVNOTSTREN(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x800)|value<<11)
}
func (o *I2C0_Type) GetINTENSET_SLVNOTSTREN() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x800) >> 11
}
func (o *I2C0_Type) SetINTENSET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x7000)|value<<12)
}
func (o *I2C0_Type) GetINTENSET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x7000) >> 12
}
func (o *I2C0_Type) SetINTENSET_SLVDESELEN(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x8000)|value<<15)
}
func (o *I2C0_Type) GetINTENSET_SLVDESELEN() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x8000) >> 15
}
func (o *I2C0_Type) SetINTENSET_MONRDYEN(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x10000)|value<<16)
}
func (o *I2C0_Type) GetINTENSET_MONRDYEN() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x10000) >> 16
}
func (o *I2C0_Type) SetINTENSET_MONOVEN(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x20000)|value<<17)
}
func (o *I2C0_Type) GetINTENSET_MONOVEN() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x20000) >> 17
}
func (o *I2C0_Type) SetINTENSET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x40000)|value<<18)
}
func (o *I2C0_Type) GetINTENSET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x40000) >> 18
}
func (o *I2C0_Type) SetINTENSET_MONIDLEEN(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x80000)|value<<19)
}
func (o *I2C0_Type) GetINTENSET_MONIDLEEN() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x80000) >> 19
}
func (o *I2C0_Type) SetINTENSET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0xf00000)|value<<20)
}
func (o *I2C0_Type) GetINTENSET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0xf00000) >> 20
}
func (o *I2C0_Type) SetINTENSET_EVENTTIMEOUTEN(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1000000)|value<<24)
}
func (o *I2C0_Type) GetINTENSET_EVENTTIMEOUTEN() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x1000000) >> 24
}
func (o *I2C0_Type) SetINTENSET_SCLTIMEOUTEN(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2000000)|value<<25)
}
func (o *I2C0_Type) GetINTENSET_SCLTIMEOUTEN() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2000000) >> 25
}
func (o *I2C0_Type) SetINTENSET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0xfc000000)|value<<26)
}
func (o *I2C0_Type) GetINTENSET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0xfc000000) >> 26
}

// I2C0.INTENCLR: Interrupt Enable Clear register.
func (o *I2C0_Type) SetINTENCLR_MSTPENDINGCLR(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *I2C0_Type) GetINTENCLR_MSTPENDINGCLR() uint32 {
	return volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1
}
func (o *I2C0_Type) SetINTENCLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0xe)|value<<1)
}
func (o *I2C0_Type) GetINTENCLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0xe) >> 1
}
func (o *I2C0_Type) SetINTENCLR_MSTARBLOSSCLR(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x10)|value<<4)
}
func (o *I2C0_Type) GetINTENCLR_MSTARBLOSSCLR() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x10) >> 4
}
func (o *I2C0_Type) SetINTENCLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x20)|value<<5)
}
func (o *I2C0_Type) GetINTENCLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x20) >> 5
}
func (o *I2C0_Type) SetINTENCLR_MSTSTSTPERRCLR(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x40)|value<<6)
}
func (o *I2C0_Type) GetINTENCLR_MSTSTSTPERRCLR() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x40) >> 6
}
func (o *I2C0_Type) SetINTENCLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x80)|value<<7)
}
func (o *I2C0_Type) GetINTENCLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x80) >> 7
}
func (o *I2C0_Type) SetINTENCLR_SLVPENDINGCLR(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x100)|value<<8)
}
func (o *I2C0_Type) GetINTENCLR_SLVPENDINGCLR() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x100) >> 8
}
func (o *I2C0_Type) SetINTENCLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x600)|value<<9)
}
func (o *I2C0_Type) GetINTENCLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x600) >> 9
}
func (o *I2C0_Type) SetINTENCLR_SLVNOTSTRCLR(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x800)|value<<11)
}
func (o *I2C0_Type) GetINTENCLR_SLVNOTSTRCLR() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x800) >> 11
}
func (o *I2C0_Type) SetINTENCLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x7000)|value<<12)
}
func (o *I2C0_Type) GetINTENCLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x7000) >> 12
}
func (o *I2C0_Type) SetINTENCLR_SLVDESELCLR(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x8000)|value<<15)
}
func (o *I2C0_Type) GetINTENCLR_SLVDESELCLR() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x8000) >> 15
}
func (o *I2C0_Type) SetINTENCLR_MONRDYCLR(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x10000)|value<<16)
}
func (o *I2C0_Type) GetINTENCLR_MONRDYCLR() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x10000) >> 16
}
func (o *I2C0_Type) SetINTENCLR_MONOVCLR(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x20000)|value<<17)
}
func (o *I2C0_Type) GetINTENCLR_MONOVCLR() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x20000) >> 17
}
func (o *I2C0_Type) SetINTENCLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x40000)|value<<18)
}
func (o *I2C0_Type) GetINTENCLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x40000) >> 18
}
func (o *I2C0_Type) SetINTENCLR_MONIDLECLR(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x80000)|value<<19)
}
func (o *I2C0_Type) GetINTENCLR_MONIDLECLR() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x80000) >> 19
}
func (o *I2C0_Type) SetINTENCLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0xf00000)|value<<20)
}
func (o *I2C0_Type) GetINTENCLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0xf00000) >> 20
}
func (o *I2C0_Type) SetINTENCLR_EVENTTIMEOUTCLR(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1000000)|value<<24)
}
func (o *I2C0_Type) GetINTENCLR_EVENTTIMEOUTCLR() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1000000) >> 24
}
func (o *I2C0_Type) SetINTENCLR_SCLTIMEOUTCLR(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2000000)|value<<25)
}
func (o *I2C0_Type) GetINTENCLR_SCLTIMEOUTCLR() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2000000) >> 25
}
func (o *I2C0_Type) SetINTENCLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0xfc000000)|value<<26)
}
func (o *I2C0_Type) GetINTENCLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0xfc000000) >> 26
}

// I2C0.TIMEOUT: Time-out value register.
func (o *I2C0_Type) SetTIMEOUT_TOMIN(value uint32) {
	volatile.StoreUint32(&o.TIMEOUT.Reg, volatile.LoadUint32(&o.TIMEOUT.Reg)&^(0xf)|value)
}
func (o *I2C0_Type) GetTIMEOUT_TOMIN() uint32 {
	return volatile.LoadUint32(&o.TIMEOUT.Reg) & 0xf
}
func (o *I2C0_Type) SetTIMEOUT_TO(value uint32) {
	volatile.StoreUint32(&o.TIMEOUT.Reg, volatile.LoadUint32(&o.TIMEOUT.Reg)&^(0xfff0)|value<<4)
}
func (o *I2C0_Type) GetTIMEOUT_TO() uint32 {
	return (volatile.LoadUint32(&o.TIMEOUT.Reg) & 0xfff0) >> 4
}
func (o *I2C0_Type) SetTIMEOUT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TIMEOUT.Reg, volatile.LoadUint32(&o.TIMEOUT.Reg)&^(0xffff0000)|value<<16)
}
func (o *I2C0_Type) GetTIMEOUT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TIMEOUT.Reg) & 0xffff0000) >> 16
}

// I2C0.CLKDIV: Clock pre-divider for the entire I2C block. This determines what time increments are used for the MSTTIME and SLVTIME registers.
func (o *I2C0_Type) SetCLKDIV_DIVVAL(value uint32) {
	volatile.StoreUint32(&o.CLKDIV.Reg, volatile.LoadUint32(&o.CLKDIV.Reg)&^(0xffff)|value)
}
func (o *I2C0_Type) GetCLKDIV_DIVVAL() uint32 {
	return volatile.LoadUint32(&o.CLKDIV.Reg) & 0xffff
}
func (o *I2C0_Type) SetCLKDIV_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CLKDIV.Reg, volatile.LoadUint32(&o.CLKDIV.Reg)&^(0xffff0000)|value<<16)
}
func (o *I2C0_Type) GetCLKDIV_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CLKDIV.Reg) & 0xffff0000) >> 16
}

// I2C0.INTSTAT: Interrupt Status register for Master, Slave, and Monitor functions.
func (o *I2C0_Type) SetINTSTAT_MSTPENDING(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x1)|value)
}
func (o *I2C0_Type) GetINTSTAT_MSTPENDING() uint32 {
	return volatile.LoadUint32(&o.INTSTAT.Reg) & 0x1
}
func (o *I2C0_Type) SetINTSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0xe)|value<<1)
}
func (o *I2C0_Type) GetINTSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0xe) >> 1
}
func (o *I2C0_Type) SetINTSTAT_MSTARBLOSS(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x10)|value<<4)
}
func (o *I2C0_Type) GetINTSTAT_MSTARBLOSS() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x10) >> 4
}
func (o *I2C0_Type) SetINTSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x20)|value<<5)
}
func (o *I2C0_Type) GetINTSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x20) >> 5
}
func (o *I2C0_Type) SetINTSTAT_MSTSTSTPERR(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x40)|value<<6)
}
func (o *I2C0_Type) GetINTSTAT_MSTSTSTPERR() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x40) >> 6
}
func (o *I2C0_Type) SetINTSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x80)|value<<7)
}
func (o *I2C0_Type) GetINTSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x80) >> 7
}
func (o *I2C0_Type) SetINTSTAT_SLVPENDING(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x100)|value<<8)
}
func (o *I2C0_Type) GetINTSTAT_SLVPENDING() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x100) >> 8
}
func (o *I2C0_Type) SetINTSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x600)|value<<9)
}
func (o *I2C0_Type) GetINTSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x600) >> 9
}
func (o *I2C0_Type) SetINTSTAT_SLVNOTSTR(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x800)|value<<11)
}
func (o *I2C0_Type) GetINTSTAT_SLVNOTSTR() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x800) >> 11
}
func (o *I2C0_Type) SetINTSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x7000)|value<<12)
}
func (o *I2C0_Type) GetINTSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x7000) >> 12
}
func (o *I2C0_Type) SetINTSTAT_SLVDESEL(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x8000)|value<<15)
}
func (o *I2C0_Type) GetINTSTAT_SLVDESEL() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x8000) >> 15
}
func (o *I2C0_Type) SetINTSTAT_MONRDY(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x10000)|value<<16)
}
func (o *I2C0_Type) GetINTSTAT_MONRDY() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x10000) >> 16
}
func (o *I2C0_Type) SetINTSTAT_MONOV(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x20000)|value<<17)
}
func (o *I2C0_Type) GetINTSTAT_MONOV() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x20000) >> 17
}
func (o *I2C0_Type) SetINTSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x40000)|value<<18)
}
func (o *I2C0_Type) GetINTSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x40000) >> 18
}
func (o *I2C0_Type) SetINTSTAT_MONIDLE(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x80000)|value<<19)
}
func (o *I2C0_Type) GetINTSTAT_MONIDLE() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x80000) >> 19
}
func (o *I2C0_Type) SetINTSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0xf00000)|value<<20)
}
func (o *I2C0_Type) GetINTSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0xf00000) >> 20
}
func (o *I2C0_Type) SetINTSTAT_EVENTTIMEOUT(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x1000000)|value<<24)
}
func (o *I2C0_Type) GetINTSTAT_EVENTTIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x1000000) >> 24
}
func (o *I2C0_Type) SetINTSTAT_SCLTIMEOUT(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x2000000)|value<<25)
}
func (o *I2C0_Type) GetINTSTAT_SCLTIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x2000000) >> 25
}
func (o *I2C0_Type) SetINTSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0xfc000000)|value<<26)
}
func (o *I2C0_Type) GetINTSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0xfc000000) >> 26
}

// I2C0.MSTCTL: Master control register.
func (o *I2C0_Type) SetMSTCTL_MSTCONTINUE(value uint32) {
	volatile.StoreUint32(&o.MSTCTL.Reg, volatile.LoadUint32(&o.MSTCTL.Reg)&^(0x1)|value)
}
func (o *I2C0_Type) GetMSTCTL_MSTCONTINUE() uint32 {
	return volatile.LoadUint32(&o.MSTCTL.Reg) & 0x1
}
func (o *I2C0_Type) SetMSTCTL_MSTSTART(value uint32) {
	volatile.StoreUint32(&o.MSTCTL.Reg, volatile.LoadUint32(&o.MSTCTL.Reg)&^(0x2)|value<<1)
}
func (o *I2C0_Type) GetMSTCTL_MSTSTART() uint32 {
	return (volatile.LoadUint32(&o.MSTCTL.Reg) & 0x2) >> 1
}
func (o *I2C0_Type) SetMSTCTL_MSTSTOP(value uint32) {
	volatile.StoreUint32(&o.MSTCTL.Reg, volatile.LoadUint32(&o.MSTCTL.Reg)&^(0x4)|value<<2)
}
func (o *I2C0_Type) GetMSTCTL_MSTSTOP() uint32 {
	return (volatile.LoadUint32(&o.MSTCTL.Reg) & 0x4) >> 2
}
func (o *I2C0_Type) SetMSTCTL_MSTDMA(value uint32) {
	volatile.StoreUint32(&o.MSTCTL.Reg, volatile.LoadUint32(&o.MSTCTL.Reg)&^(0x8)|value<<3)
}
func (o *I2C0_Type) GetMSTCTL_MSTDMA() uint32 {
	return (volatile.LoadUint32(&o.MSTCTL.Reg) & 0x8) >> 3
}
func (o *I2C0_Type) SetMSTCTL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MSTCTL.Reg, volatile.LoadUint32(&o.MSTCTL.Reg)&^(0xfffffff0)|value<<4)
}
func (o *I2C0_Type) GetMSTCTL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MSTCTL.Reg) & 0xfffffff0) >> 4
}

// I2C0.MSTTIME: Master timing configuration.
func (o *I2C0_Type) SetMSTTIME_MSTSCLLOW(value uint32) {
	volatile.StoreUint32(&o.MSTTIME.Reg, volatile.LoadUint32(&o.MSTTIME.Reg)&^(0x7)|value)
}
func (o *I2C0_Type) GetMSTTIME_MSTSCLLOW() uint32 {
	return volatile.LoadUint32(&o.MSTTIME.Reg) & 0x7
}
func (o *I2C0_Type) SetMSTTIME_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MSTTIME.Reg, volatile.LoadUint32(&o.MSTTIME.Reg)&^(0x8)|value<<3)
}
func (o *I2C0_Type) GetMSTTIME_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MSTTIME.Reg) & 0x8) >> 3
}
func (o *I2C0_Type) SetMSTTIME_MSTSCLHIGH(value uint32) {
	volatile.StoreUint32(&o.MSTTIME.Reg, volatile.LoadUint32(&o.MSTTIME.Reg)&^(0x70)|value<<4)
}
func (o *I2C0_Type) GetMSTTIME_MSTSCLHIGH() uint32 {
	return (volatile.LoadUint32(&o.MSTTIME.Reg) & 0x70) >> 4
}
func (o *I2C0_Type) SetMSTTIME_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MSTTIME.Reg, volatile.LoadUint32(&o.MSTTIME.Reg)&^(0xffffff80)|value<<7)
}
func (o *I2C0_Type) GetMSTTIME_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MSTTIME.Reg) & 0xffffff80) >> 7
}

// I2C0.MSTDAT: Combined Master receiver and transmitter data register.
func (o *I2C0_Type) SetMSTDAT_DATA(value uint32) {
	volatile.StoreUint32(&o.MSTDAT.Reg, volatile.LoadUint32(&o.MSTDAT.Reg)&^(0xff)|value)
}
func (o *I2C0_Type) GetMSTDAT_DATA() uint32 {
	return volatile.LoadUint32(&o.MSTDAT.Reg) & 0xff
}
func (o *I2C0_Type) SetMSTDAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MSTDAT.Reg, volatile.LoadUint32(&o.MSTDAT.Reg)&^(0xffffff00)|value<<8)
}
func (o *I2C0_Type) GetMSTDAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MSTDAT.Reg) & 0xffffff00) >> 8
}

// I2C0.SLVCTL: Slave control register.
func (o *I2C0_Type) SetSLVCTL_SLVCONTINUE(value uint32) {
	volatile.StoreUint32(&o.SLVCTL.Reg, volatile.LoadUint32(&o.SLVCTL.Reg)&^(0x1)|value)
}
func (o *I2C0_Type) GetSLVCTL_SLVCONTINUE() uint32 {
	return volatile.LoadUint32(&o.SLVCTL.Reg) & 0x1
}
func (o *I2C0_Type) SetSLVCTL_SLVNACK(value uint32) {
	volatile.StoreUint32(&o.SLVCTL.Reg, volatile.LoadUint32(&o.SLVCTL.Reg)&^(0x2)|value<<1)
}
func (o *I2C0_Type) GetSLVCTL_SLVNACK() uint32 {
	return (volatile.LoadUint32(&o.SLVCTL.Reg) & 0x2) >> 1
}
func (o *I2C0_Type) SetSLVCTL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SLVCTL.Reg, volatile.LoadUint32(&o.SLVCTL.Reg)&^(0x4)|value<<2)
}
func (o *I2C0_Type) GetSLVCTL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SLVCTL.Reg) & 0x4) >> 2
}
func (o *I2C0_Type) SetSLVCTL_SLVDMA(value uint32) {
	volatile.StoreUint32(&o.SLVCTL.Reg, volatile.LoadUint32(&o.SLVCTL.Reg)&^(0x8)|value<<3)
}
func (o *I2C0_Type) GetSLVCTL_SLVDMA() uint32 {
	return (volatile.LoadUint32(&o.SLVCTL.Reg) & 0x8) >> 3
}
func (o *I2C0_Type) SetSLVCTL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SLVCTL.Reg, volatile.LoadUint32(&o.SLVCTL.Reg)&^(0xfffffff0)|value<<4)
}
func (o *I2C0_Type) GetSLVCTL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SLVCTL.Reg) & 0xfffffff0) >> 4
}

// I2C0.SLVDAT: Combined Slave receiver and transmitter data register.
func (o *I2C0_Type) SetSLVDAT_DATA(value uint32) {
	volatile.StoreUint32(&o.SLVDAT.Reg, volatile.LoadUint32(&o.SLVDAT.Reg)&^(0xff)|value)
}
func (o *I2C0_Type) GetSLVDAT_DATA() uint32 {
	return volatile.LoadUint32(&o.SLVDAT.Reg) & 0xff
}
func (o *I2C0_Type) SetSLVDAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SLVDAT.Reg, volatile.LoadUint32(&o.SLVDAT.Reg)&^(0xffffff00)|value<<8)
}
func (o *I2C0_Type) GetSLVDAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SLVDAT.Reg) & 0xffffff00) >> 8
}

// I2C0.SLVADR0: Slave address 0.
func (o *I2C0_Type) SetSLVADR0_SADISABLE(value uint32) {
	volatile.StoreUint32(&o.SLVADR0.Reg, volatile.LoadUint32(&o.SLVADR0.Reg)&^(0x1)|value)
}
func (o *I2C0_Type) GetSLVADR0_SADISABLE() uint32 {
	return volatile.LoadUint32(&o.SLVADR0.Reg) & 0x1
}
func (o *I2C0_Type) SetSLVADR0_SLVADR(value uint32) {
	volatile.StoreUint32(&o.SLVADR0.Reg, volatile.LoadUint32(&o.SLVADR0.Reg)&^(0xfe)|value<<1)
}
func (o *I2C0_Type) GetSLVADR0_SLVADR() uint32 {
	return (volatile.LoadUint32(&o.SLVADR0.Reg) & 0xfe) >> 1
}
func (o *I2C0_Type) SetSLVADR0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SLVADR0.Reg, volatile.LoadUint32(&o.SLVADR0.Reg)&^(0xffffff00)|value<<8)
}
func (o *I2C0_Type) GetSLVADR0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SLVADR0.Reg) & 0xffffff00) >> 8
}

// I2C0.SLVADR1: Slave address 0.
func (o *I2C0_Type) SetSLVADR1_SADISABLE(value uint32) {
	volatile.StoreUint32(&o.SLVADR1.Reg, volatile.LoadUint32(&o.SLVADR1.Reg)&^(0x1)|value)
}
func (o *I2C0_Type) GetSLVADR1_SADISABLE() uint32 {
	return volatile.LoadUint32(&o.SLVADR1.Reg) & 0x1
}
func (o *I2C0_Type) SetSLVADR1_SLVADR(value uint32) {
	volatile.StoreUint32(&o.SLVADR1.Reg, volatile.LoadUint32(&o.SLVADR1.Reg)&^(0xfe)|value<<1)
}
func (o *I2C0_Type) GetSLVADR1_SLVADR() uint32 {
	return (volatile.LoadUint32(&o.SLVADR1.Reg) & 0xfe) >> 1
}
func (o *I2C0_Type) SetSLVADR1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SLVADR1.Reg, volatile.LoadUint32(&o.SLVADR1.Reg)&^(0xffffff00)|value<<8)
}
func (o *I2C0_Type) GetSLVADR1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SLVADR1.Reg) & 0xffffff00) >> 8
}

// I2C0.SLVADR2: Slave address 0.
func (o *I2C0_Type) SetSLVADR2_SADISABLE(value uint32) {
	volatile.StoreUint32(&o.SLVADR2.Reg, volatile.LoadUint32(&o.SLVADR2.Reg)&^(0x1)|value)
}
func (o *I2C0_Type) GetSLVADR2_SADISABLE() uint32 {
	return volatile.LoadUint32(&o.SLVADR2.Reg) & 0x1
}
func (o *I2C0_Type) SetSLVADR2_SLVADR(value uint32) {
	volatile.StoreUint32(&o.SLVADR2.Reg, volatile.LoadUint32(&o.SLVADR2.Reg)&^(0xfe)|value<<1)
}
func (o *I2C0_Type) GetSLVADR2_SLVADR() uint32 {
	return (volatile.LoadUint32(&o.SLVADR2.Reg) & 0xfe) >> 1
}
func (o *I2C0_Type) SetSLVADR2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SLVADR2.Reg, volatile.LoadUint32(&o.SLVADR2.Reg)&^(0xffffff00)|value<<8)
}
func (o *I2C0_Type) GetSLVADR2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SLVADR2.Reg) & 0xffffff00) >> 8
}

// I2C0.SLVADR3: Slave address 0.
func (o *I2C0_Type) SetSLVADR3_SADISABLE(value uint32) {
	volatile.StoreUint32(&o.SLVADR3.Reg, volatile.LoadUint32(&o.SLVADR3.Reg)&^(0x1)|value)
}
func (o *I2C0_Type) GetSLVADR3_SADISABLE() uint32 {
	return volatile.LoadUint32(&o.SLVADR3.Reg) & 0x1
}
func (o *I2C0_Type) SetSLVADR3_SLVADR(value uint32) {
	volatile.StoreUint32(&o.SLVADR3.Reg, volatile.LoadUint32(&o.SLVADR3.Reg)&^(0xfe)|value<<1)
}
func (o *I2C0_Type) GetSLVADR3_SLVADR() uint32 {
	return (volatile.LoadUint32(&o.SLVADR3.Reg) & 0xfe) >> 1
}
func (o *I2C0_Type) SetSLVADR3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SLVADR3.Reg, volatile.LoadUint32(&o.SLVADR3.Reg)&^(0xffffff00)|value<<8)
}
func (o *I2C0_Type) GetSLVADR3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SLVADR3.Reg) & 0xffffff00) >> 8
}

// I2C0.SLVQUAL0: Slave Qualification for address 0.
func (o *I2C0_Type) SetSLVQUAL0_QUALMODE0(value uint32) {
	volatile.StoreUint32(&o.SLVQUAL0.Reg, volatile.LoadUint32(&o.SLVQUAL0.Reg)&^(0x1)|value)
}
func (o *I2C0_Type) GetSLVQUAL0_QUALMODE0() uint32 {
	return volatile.LoadUint32(&o.SLVQUAL0.Reg) & 0x1
}
func (o *I2C0_Type) SetSLVQUAL0(value uint32) {
	volatile.StoreUint32(&o.SLVQUAL0.Reg, volatile.LoadUint32(&o.SLVQUAL0.Reg)&^(0xfe)|value<<1)
}
func (o *I2C0_Type) GetSLVQUAL0() uint32 {
	return (volatile.LoadUint32(&o.SLVQUAL0.Reg) & 0xfe) >> 1
}
func (o *I2C0_Type) SetSLVQUAL0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SLVQUAL0.Reg, volatile.LoadUint32(&o.SLVQUAL0.Reg)&^(0xffffff00)|value<<8)
}
func (o *I2C0_Type) GetSLVQUAL0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SLVQUAL0.Reg) & 0xffffff00) >> 8
}

// I2C0.MONRXDAT: Monitor receiver data register.
func (o *I2C0_Type) SetMONRXDAT(value uint32) {
	volatile.StoreUint32(&o.MONRXDAT.Reg, volatile.LoadUint32(&o.MONRXDAT.Reg)&^(0xff)|value)
}
func (o *I2C0_Type) GetMONRXDAT() uint32 {
	return volatile.LoadUint32(&o.MONRXDAT.Reg) & 0xff
}
func (o *I2C0_Type) SetMONRXDAT_MONSTART(value uint32) {
	volatile.StoreUint32(&o.MONRXDAT.Reg, volatile.LoadUint32(&o.MONRXDAT.Reg)&^(0x100)|value<<8)
}
func (o *I2C0_Type) GetMONRXDAT_MONSTART() uint32 {
	return (volatile.LoadUint32(&o.MONRXDAT.Reg) & 0x100) >> 8
}
func (o *I2C0_Type) SetMONRXDAT_MONRESTART(value uint32) {
	volatile.StoreUint32(&o.MONRXDAT.Reg, volatile.LoadUint32(&o.MONRXDAT.Reg)&^(0x200)|value<<9)
}
func (o *I2C0_Type) GetMONRXDAT_MONRESTART() uint32 {
	return (volatile.LoadUint32(&o.MONRXDAT.Reg) & 0x200) >> 9
}
func (o *I2C0_Type) SetMONRXDAT_MONNACK(value uint32) {
	volatile.StoreUint32(&o.MONRXDAT.Reg, volatile.LoadUint32(&o.MONRXDAT.Reg)&^(0x400)|value<<10)
}
func (o *I2C0_Type) GetMONRXDAT_MONNACK() uint32 {
	return (volatile.LoadUint32(&o.MONRXDAT.Reg) & 0x400) >> 10
}
func (o *I2C0_Type) SetMONRXDAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MONRXDAT.Reg, volatile.LoadUint32(&o.MONRXDAT.Reg)&^(0xfffff800)|value<<11)
}
func (o *I2C0_Type) GetMONRXDAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MONRXDAT.Reg) & 0xfffff800) >> 11
}

// Quadrature Encoder Interface (QEI)
type QEI_Type struct {
	CON       volatile.Register32 // 0x0
	STAT      volatile.Register32 // 0x4
	CONF      volatile.Register32 // 0x8
	POS       volatile.Register32 // 0xC
	MAXPOS    volatile.Register32 // 0x10
	CMPOS0    volatile.Register32 // 0x14
	CMPOS1    volatile.Register32 // 0x18
	CMPOS2    volatile.Register32 // 0x1C
	INXCNT    volatile.Register32 // 0x20
	INXCMP0   volatile.Register32 // 0x24
	LOAD      volatile.Register32 // 0x28
	TIME      volatile.Register32 // 0x2C
	VEL       volatile.Register32 // 0x30
	CAP       volatile.Register32 // 0x34
	VELCOMP   volatile.Register32 // 0x38
	FILTERPHA volatile.Register32 // 0x3C
	FILTERPHB volatile.Register32 // 0x40
	FILTERINX volatile.Register32 // 0x44
	WINDOW    volatile.Register32 // 0x48
	INXCMP1   volatile.Register32 // 0x4C
	INXCMP2   volatile.Register32 // 0x50
	_         [3972]byte
	IEC       volatile.Register32 // 0xFD8
	IES       volatile.Register32 // 0xFDC
	INTSTAT   volatile.Register32 // 0xFE0
	IE        volatile.Register32 // 0xFE4
	CLR       volatile.Register32 // 0xFE8
	SET       volatile.Register32 // 0xFEC
}

// QEI.CON: Control register
func (o *QEI_Type) SetCON_RESP(value uint32) {
	volatile.StoreUint32(&o.CON.Reg, volatile.LoadUint32(&o.CON.Reg)&^(0x1)|value)
}
func (o *QEI_Type) GetCON_RESP() uint32 {
	return volatile.LoadUint32(&o.CON.Reg) & 0x1
}
func (o *QEI_Type) SetCON_RESPI(value uint32) {
	volatile.StoreUint32(&o.CON.Reg, volatile.LoadUint32(&o.CON.Reg)&^(0x2)|value<<1)
}
func (o *QEI_Type) GetCON_RESPI() uint32 {
	return (volatile.LoadUint32(&o.CON.Reg) & 0x2) >> 1
}
func (o *QEI_Type) SetCON_RESV(value uint32) {
	volatile.StoreUint32(&o.CON.Reg, volatile.LoadUint32(&o.CON.Reg)&^(0x4)|value<<2)
}
func (o *QEI_Type) GetCON_RESV() uint32 {
	return (volatile.LoadUint32(&o.CON.Reg) & 0x4) >> 2
}
func (o *QEI_Type) SetCON_RESI(value uint32) {
	volatile.StoreUint32(&o.CON.Reg, volatile.LoadUint32(&o.CON.Reg)&^(0x8)|value<<3)
}
func (o *QEI_Type) GetCON_RESI() uint32 {
	return (volatile.LoadUint32(&o.CON.Reg) & 0x8) >> 3
}
func (o *QEI_Type) SetCON_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CON.Reg, volatile.LoadUint32(&o.CON.Reg)&^(0xfffffff0)|value<<4)
}
func (o *QEI_Type) GetCON_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CON.Reg) & 0xfffffff0) >> 4
}

// QEI.STAT: Encoder status register
func (o *QEI_Type) SetSTAT_DIR(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x1)|value)
}
func (o *QEI_Type) GetSTAT_DIR() uint32 {
	return volatile.LoadUint32(&o.STAT.Reg) & 0x1
}
func (o *QEI_Type) SetSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0xfffffffe)|value<<1)
}
func (o *QEI_Type) GetSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0xfffffffe) >> 1
}

// QEI.CONF: Configuration register
func (o *QEI_Type) SetCONF_DIRINV(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0x1)|value)
}
func (o *QEI_Type) GetCONF_DIRINV() uint32 {
	return volatile.LoadUint32(&o.CONF.Reg) & 0x1
}
func (o *QEI_Type) SetCONF_SIGMODE(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0x2)|value<<1)
}
func (o *QEI_Type) GetCONF_SIGMODE() uint32 {
	return (volatile.LoadUint32(&o.CONF.Reg) & 0x2) >> 1
}
func (o *QEI_Type) SetCONF_CAPMODE(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0x4)|value<<2)
}
func (o *QEI_Type) GetCONF_CAPMODE() uint32 {
	return (volatile.LoadUint32(&o.CONF.Reg) & 0x4) >> 2
}
func (o *QEI_Type) SetCONF_INVINX(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0x8)|value<<3)
}
func (o *QEI_Type) GetCONF_INVINX() uint32 {
	return (volatile.LoadUint32(&o.CONF.Reg) & 0x8) >> 3
}
func (o *QEI_Type) SetCONF_CRESPI(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0x10)|value<<4)
}
func (o *QEI_Type) GetCONF_CRESPI() uint32 {
	return (volatile.LoadUint32(&o.CONF.Reg) & 0x10) >> 4
}
func (o *QEI_Type) SetCONF_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0xffe0)|value<<5)
}
func (o *QEI_Type) GetCONF_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CONF.Reg) & 0xffe0) >> 5
}
func (o *QEI_Type) SetCONF_INXGATE(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0xf0000)|value<<16)
}
func (o *QEI_Type) GetCONF_INXGATE() uint32 {
	return (volatile.LoadUint32(&o.CONF.Reg) & 0xf0000) >> 16
}
func (o *QEI_Type) SetCONF_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0xfff00000)|value<<20)
}
func (o *QEI_Type) GetCONF_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CONF.Reg) & 0xfff00000) >> 20
}

// QEI.POS: Position register
func (o *QEI_Type) SetPOS(value uint32) {
	volatile.StoreUint32(&o.POS.Reg, value)
}
func (o *QEI_Type) GetPOS() uint32 {
	return volatile.LoadUint32(&o.POS.Reg)
}

// QEI.MAXPOS: Maximum position register
func (o *QEI_Type) SetMAXPOS(value uint32) {
	volatile.StoreUint32(&o.MAXPOS.Reg, value)
}
func (o *QEI_Type) GetMAXPOS() uint32 {
	return volatile.LoadUint32(&o.MAXPOS.Reg)
}

// QEI.CMPOS0: position compare register 0
func (o *QEI_Type) SetCMPOS0(value uint32) {
	volatile.StoreUint32(&o.CMPOS0.Reg, value)
}
func (o *QEI_Type) GetCMPOS0() uint32 {
	return volatile.LoadUint32(&o.CMPOS0.Reg)
}

// QEI.CMPOS1: position compare register 1
func (o *QEI_Type) SetCMPOS1(value uint32) {
	volatile.StoreUint32(&o.CMPOS1.Reg, value)
}
func (o *QEI_Type) GetCMPOS1() uint32 {
	return volatile.LoadUint32(&o.CMPOS1.Reg)
}

// QEI.CMPOS2: position compare register 2
func (o *QEI_Type) SetCMPOS2(value uint32) {
	volatile.StoreUint32(&o.CMPOS2.Reg, value)
}
func (o *QEI_Type) GetCMPOS2() uint32 {
	return volatile.LoadUint32(&o.CMPOS2.Reg)
}

// QEI.INXCNT: Index count register
func (o *QEI_Type) SetINXCNT(value uint32) {
	volatile.StoreUint32(&o.INXCNT.Reg, value)
}
func (o *QEI_Type) GetINXCNT() uint32 {
	return volatile.LoadUint32(&o.INXCNT.Reg)
}

// QEI.INXCMP0: Index compare register 0
func (o *QEI_Type) SetINXCMP0(value uint32) {
	volatile.StoreUint32(&o.INXCMP0.Reg, value)
}
func (o *QEI_Type) GetINXCMP0() uint32 {
	return volatile.LoadUint32(&o.INXCMP0.Reg)
}

// QEI.LOAD: Velocity timer reload register
func (o *QEI_Type) SetLOAD(value uint32) {
	volatile.StoreUint32(&o.LOAD.Reg, value)
}
func (o *QEI_Type) GetLOAD() uint32 {
	return volatile.LoadUint32(&o.LOAD.Reg)
}

// QEI.TIME: Velocity timer register
func (o *QEI_Type) SetTIME(value uint32) {
	volatile.StoreUint32(&o.TIME.Reg, value)
}
func (o *QEI_Type) GetTIME() uint32 {
	return volatile.LoadUint32(&o.TIME.Reg)
}

// QEI.VEL: Velocity counter register
func (o *QEI_Type) SetVEL(value uint32) {
	volatile.StoreUint32(&o.VEL.Reg, value)
}
func (o *QEI_Type) GetVEL() uint32 {
	return volatile.LoadUint32(&o.VEL.Reg)
}

// QEI.CAP: Velocity capture register
func (o *QEI_Type) SetCAP(value uint32) {
	volatile.StoreUint32(&o.CAP.Reg, value)
}
func (o *QEI_Type) GetCAP() uint32 {
	return volatile.LoadUint32(&o.CAP.Reg)
}

// QEI.VELCOMP: Velocity compare register
func (o *QEI_Type) SetVELCOMP(value uint32) {
	volatile.StoreUint32(&o.VELCOMP.Reg, value)
}
func (o *QEI_Type) GetVELCOMP() uint32 {
	return volatile.LoadUint32(&o.VELCOMP.Reg)
}

// QEI.FILTERPHA: Digital filter register on input phase A (QEI_A)
func (o *QEI_Type) SetFILTERPHA(value uint32) {
	volatile.StoreUint32(&o.FILTERPHA.Reg, value)
}
func (o *QEI_Type) GetFILTERPHA() uint32 {
	return volatile.LoadUint32(&o.FILTERPHA.Reg)
}

// QEI.FILTERPHB: Digital filter register on input phase B (QEI_B)
func (o *QEI_Type) SetFILTERPHB(value uint32) {
	volatile.StoreUint32(&o.FILTERPHB.Reg, value)
}
func (o *QEI_Type) GetFILTERPHB() uint32 {
	return volatile.LoadUint32(&o.FILTERPHB.Reg)
}

// QEI.FILTERINX: Digital filter register on input index (QEI_IDX)
func (o *QEI_Type) SetFILTERINX(value uint32) {
	volatile.StoreUint32(&o.FILTERINX.Reg, value)
}
func (o *QEI_Type) GetFILTERINX() uint32 {
	return volatile.LoadUint32(&o.FILTERINX.Reg)
}

// QEI.WINDOW: Index acceptance window register
func (o *QEI_Type) SetWINDOW(value uint32) {
	volatile.StoreUint32(&o.WINDOW.Reg, value)
}
func (o *QEI_Type) GetWINDOW() uint32 {
	return volatile.LoadUint32(&o.WINDOW.Reg)
}

// QEI.INXCMP1: Index compare register 1
func (o *QEI_Type) SetINXCMP1(value uint32) {
	volatile.StoreUint32(&o.INXCMP1.Reg, value)
}
func (o *QEI_Type) GetINXCMP1() uint32 {
	return volatile.LoadUint32(&o.INXCMP1.Reg)
}

// QEI.INXCMP2: Index compare register 2
func (o *QEI_Type) SetINXCMP2(value uint32) {
	volatile.StoreUint32(&o.INXCMP2.Reg, value)
}
func (o *QEI_Type) GetINXCMP2() uint32 {
	return volatile.LoadUint32(&o.INXCMP2.Reg)
}

// QEI.IEC: Interrupt enable clear register
func (o *QEI_Type) SetIEC_INX_EN(value uint32) {
	volatile.StoreUint32(&o.IEC.Reg, volatile.LoadUint32(&o.IEC.Reg)&^(0x1)|value)
}
func (o *QEI_Type) GetIEC_INX_EN() uint32 {
	return volatile.LoadUint32(&o.IEC.Reg) & 0x1
}
func (o *QEI_Type) SetIEC_TIM_EN(value uint32) {
	volatile.StoreUint32(&o.IEC.Reg, volatile.LoadUint32(&o.IEC.Reg)&^(0x2)|value<<1)
}
func (o *QEI_Type) GetIEC_TIM_EN() uint32 {
	return (volatile.LoadUint32(&o.IEC.Reg) & 0x2) >> 1
}
func (o *QEI_Type) SetIEC_VELC_EN(value uint32) {
	volatile.StoreUint32(&o.IEC.Reg, volatile.LoadUint32(&o.IEC.Reg)&^(0x4)|value<<2)
}
func (o *QEI_Type) GetIEC_VELC_EN() uint32 {
	return (volatile.LoadUint32(&o.IEC.Reg) & 0x4) >> 2
}
func (o *QEI_Type) SetIEC_DIR_EN(value uint32) {
	volatile.StoreUint32(&o.IEC.Reg, volatile.LoadUint32(&o.IEC.Reg)&^(0x8)|value<<3)
}
func (o *QEI_Type) GetIEC_DIR_EN() uint32 {
	return (volatile.LoadUint32(&o.IEC.Reg) & 0x8) >> 3
}
func (o *QEI_Type) SetIEC_ERR_EN(value uint32) {
	volatile.StoreUint32(&o.IEC.Reg, volatile.LoadUint32(&o.IEC.Reg)&^(0x10)|value<<4)
}
func (o *QEI_Type) GetIEC_ERR_EN() uint32 {
	return (volatile.LoadUint32(&o.IEC.Reg) & 0x10) >> 4
}
func (o *QEI_Type) SetIEC_ENCLK_EN(value uint32) {
	volatile.StoreUint32(&o.IEC.Reg, volatile.LoadUint32(&o.IEC.Reg)&^(0x20)|value<<5)
}
func (o *QEI_Type) GetIEC_ENCLK_EN() uint32 {
	return (volatile.LoadUint32(&o.IEC.Reg) & 0x20) >> 5
}
func (o *QEI_Type) SetIEC_POS0_INT(value uint32) {
	volatile.StoreUint32(&o.IEC.Reg, volatile.LoadUint32(&o.IEC.Reg)&^(0x40)|value<<6)
}
func (o *QEI_Type) GetIEC_POS0_INT() uint32 {
	return (volatile.LoadUint32(&o.IEC.Reg) & 0x40) >> 6
}
func (o *QEI_Type) SetIEC_POS1_INT(value uint32) {
	volatile.StoreUint32(&o.IEC.Reg, volatile.LoadUint32(&o.IEC.Reg)&^(0x80)|value<<7)
}
func (o *QEI_Type) GetIEC_POS1_INT() uint32 {
	return (volatile.LoadUint32(&o.IEC.Reg) & 0x80) >> 7
}
func (o *QEI_Type) SetIEC_POS2_INT(value uint32) {
	volatile.StoreUint32(&o.IEC.Reg, volatile.LoadUint32(&o.IEC.Reg)&^(0x100)|value<<8)
}
func (o *QEI_Type) GetIEC_POS2_INT() uint32 {
	return (volatile.LoadUint32(&o.IEC.Reg) & 0x100) >> 8
}
func (o *QEI_Type) SetIEC_REV0_INT(value uint32) {
	volatile.StoreUint32(&o.IEC.Reg, volatile.LoadUint32(&o.IEC.Reg)&^(0x200)|value<<9)
}
func (o *QEI_Type) GetIEC_REV0_INT() uint32 {
	return (volatile.LoadUint32(&o.IEC.Reg) & 0x200) >> 9
}
func (o *QEI_Type) SetIEC_POS0REV_INT(value uint32) {
	volatile.StoreUint32(&o.IEC.Reg, volatile.LoadUint32(&o.IEC.Reg)&^(0x400)|value<<10)
}
func (o *QEI_Type) GetIEC_POS0REV_INT() uint32 {
	return (volatile.LoadUint32(&o.IEC.Reg) & 0x400) >> 10
}
func (o *QEI_Type) SetIEC_POS1REV_INT(value uint32) {
	volatile.StoreUint32(&o.IEC.Reg, volatile.LoadUint32(&o.IEC.Reg)&^(0x800)|value<<11)
}
func (o *QEI_Type) GetIEC_POS1REV_INT() uint32 {
	return (volatile.LoadUint32(&o.IEC.Reg) & 0x800) >> 11
}
func (o *QEI_Type) SetIEC_POS2REV_INT(value uint32) {
	volatile.StoreUint32(&o.IEC.Reg, volatile.LoadUint32(&o.IEC.Reg)&^(0x1000)|value<<12)
}
func (o *QEI_Type) GetIEC_POS2REV_INT() uint32 {
	return (volatile.LoadUint32(&o.IEC.Reg) & 0x1000) >> 12
}
func (o *QEI_Type) SetIEC_REV1_INT(value uint32) {
	volatile.StoreUint32(&o.IEC.Reg, volatile.LoadUint32(&o.IEC.Reg)&^(0x2000)|value<<13)
}
func (o *QEI_Type) GetIEC_REV1_INT() uint32 {
	return (volatile.LoadUint32(&o.IEC.Reg) & 0x2000) >> 13
}
func (o *QEI_Type) SetIEC_REV2_INT(value uint32) {
	volatile.StoreUint32(&o.IEC.Reg, volatile.LoadUint32(&o.IEC.Reg)&^(0x4000)|value<<14)
}
func (o *QEI_Type) GetIEC_REV2_INT() uint32 {
	return (volatile.LoadUint32(&o.IEC.Reg) & 0x4000) >> 14
}
func (o *QEI_Type) SetIEC_MAXPOS_INT(value uint32) {
	volatile.StoreUint32(&o.IEC.Reg, volatile.LoadUint32(&o.IEC.Reg)&^(0x8000)|value<<15)
}
func (o *QEI_Type) GetIEC_MAXPOS_INT() uint32 {
	return (volatile.LoadUint32(&o.IEC.Reg) & 0x8000) >> 15
}
func (o *QEI_Type) SetIEC_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IEC.Reg, volatile.LoadUint32(&o.IEC.Reg)&^(0xffff0000)|value<<16)
}
func (o *QEI_Type) GetIEC_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IEC.Reg) & 0xffff0000) >> 16
}

// QEI.IES: Interrupt enable set register
func (o *QEI_Type) SetIES_INX_EN(value uint32) {
	volatile.StoreUint32(&o.IES.Reg, volatile.LoadUint32(&o.IES.Reg)&^(0x1)|value)
}
func (o *QEI_Type) GetIES_INX_EN() uint32 {
	return volatile.LoadUint32(&o.IES.Reg) & 0x1
}
func (o *QEI_Type) SetIES_TIM_EN(value uint32) {
	volatile.StoreUint32(&o.IES.Reg, volatile.LoadUint32(&o.IES.Reg)&^(0x2)|value<<1)
}
func (o *QEI_Type) GetIES_TIM_EN() uint32 {
	return (volatile.LoadUint32(&o.IES.Reg) & 0x2) >> 1
}
func (o *QEI_Type) SetIES_VELC_EN(value uint32) {
	volatile.StoreUint32(&o.IES.Reg, volatile.LoadUint32(&o.IES.Reg)&^(0x4)|value<<2)
}
func (o *QEI_Type) GetIES_VELC_EN() uint32 {
	return (volatile.LoadUint32(&o.IES.Reg) & 0x4) >> 2
}
func (o *QEI_Type) SetIES_DIR_EN(value uint32) {
	volatile.StoreUint32(&o.IES.Reg, volatile.LoadUint32(&o.IES.Reg)&^(0x8)|value<<3)
}
func (o *QEI_Type) GetIES_DIR_EN() uint32 {
	return (volatile.LoadUint32(&o.IES.Reg) & 0x8) >> 3
}
func (o *QEI_Type) SetIES_ERR_EN(value uint32) {
	volatile.StoreUint32(&o.IES.Reg, volatile.LoadUint32(&o.IES.Reg)&^(0x10)|value<<4)
}
func (o *QEI_Type) GetIES_ERR_EN() uint32 {
	return (volatile.LoadUint32(&o.IES.Reg) & 0x10) >> 4
}
func (o *QEI_Type) SetIES_ENCLK_EN(value uint32) {
	volatile.StoreUint32(&o.IES.Reg, volatile.LoadUint32(&o.IES.Reg)&^(0x20)|value<<5)
}
func (o *QEI_Type) GetIES_ENCLK_EN() uint32 {
	return (volatile.LoadUint32(&o.IES.Reg) & 0x20) >> 5
}
func (o *QEI_Type) SetIES_POS0_INT(value uint32) {
	volatile.StoreUint32(&o.IES.Reg, volatile.LoadUint32(&o.IES.Reg)&^(0x40)|value<<6)
}
func (o *QEI_Type) GetIES_POS0_INT() uint32 {
	return (volatile.LoadUint32(&o.IES.Reg) & 0x40) >> 6
}
func (o *QEI_Type) SetIES_POS1_INT(value uint32) {
	volatile.StoreUint32(&o.IES.Reg, volatile.LoadUint32(&o.IES.Reg)&^(0x80)|value<<7)
}
func (o *QEI_Type) GetIES_POS1_INT() uint32 {
	return (volatile.LoadUint32(&o.IES.Reg) & 0x80) >> 7
}
func (o *QEI_Type) SetIES_POS2_INT(value uint32) {
	volatile.StoreUint32(&o.IES.Reg, volatile.LoadUint32(&o.IES.Reg)&^(0x100)|value<<8)
}
func (o *QEI_Type) GetIES_POS2_INT() uint32 {
	return (volatile.LoadUint32(&o.IES.Reg) & 0x100) >> 8
}
func (o *QEI_Type) SetIES_REV0_INT(value uint32) {
	volatile.StoreUint32(&o.IES.Reg, volatile.LoadUint32(&o.IES.Reg)&^(0x200)|value<<9)
}
func (o *QEI_Type) GetIES_REV0_INT() uint32 {
	return (volatile.LoadUint32(&o.IES.Reg) & 0x200) >> 9
}
func (o *QEI_Type) SetIES_POS0REV_INT(value uint32) {
	volatile.StoreUint32(&o.IES.Reg, volatile.LoadUint32(&o.IES.Reg)&^(0x400)|value<<10)
}
func (o *QEI_Type) GetIES_POS0REV_INT() uint32 {
	return (volatile.LoadUint32(&o.IES.Reg) & 0x400) >> 10
}
func (o *QEI_Type) SetIES_POS1REV_INT(value uint32) {
	volatile.StoreUint32(&o.IES.Reg, volatile.LoadUint32(&o.IES.Reg)&^(0x800)|value<<11)
}
func (o *QEI_Type) GetIES_POS1REV_INT() uint32 {
	return (volatile.LoadUint32(&o.IES.Reg) & 0x800) >> 11
}
func (o *QEI_Type) SetIES_POS2REV_INT(value uint32) {
	volatile.StoreUint32(&o.IES.Reg, volatile.LoadUint32(&o.IES.Reg)&^(0x1000)|value<<12)
}
func (o *QEI_Type) GetIES_POS2REV_INT() uint32 {
	return (volatile.LoadUint32(&o.IES.Reg) & 0x1000) >> 12
}
func (o *QEI_Type) SetIES_REV1_INT(value uint32) {
	volatile.StoreUint32(&o.IES.Reg, volatile.LoadUint32(&o.IES.Reg)&^(0x2000)|value<<13)
}
func (o *QEI_Type) GetIES_REV1_INT() uint32 {
	return (volatile.LoadUint32(&o.IES.Reg) & 0x2000) >> 13
}
func (o *QEI_Type) SetIES_REV2_INT(value uint32) {
	volatile.StoreUint32(&o.IES.Reg, volatile.LoadUint32(&o.IES.Reg)&^(0x4000)|value<<14)
}
func (o *QEI_Type) GetIES_REV2_INT() uint32 {
	return (volatile.LoadUint32(&o.IES.Reg) & 0x4000) >> 14
}
func (o *QEI_Type) SetIES_MAXPOS_INT(value uint32) {
	volatile.StoreUint32(&o.IES.Reg, volatile.LoadUint32(&o.IES.Reg)&^(0x8000)|value<<15)
}
func (o *QEI_Type) GetIES_MAXPOS_INT() uint32 {
	return (volatile.LoadUint32(&o.IES.Reg) & 0x8000) >> 15
}
func (o *QEI_Type) SetIES_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IES.Reg, volatile.LoadUint32(&o.IES.Reg)&^(0xffff0000)|value<<16)
}
func (o *QEI_Type) GetIES_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IES.Reg) & 0xffff0000) >> 16
}

// QEI.INTSTAT: Interrupt status register
func (o *QEI_Type) SetINTSTAT_INX_INT(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x1)|value)
}
func (o *QEI_Type) GetINTSTAT_INX_INT() uint32 {
	return volatile.LoadUint32(&o.INTSTAT.Reg) & 0x1
}
func (o *QEI_Type) SetINTSTAT_TIM_INT(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x2)|value<<1)
}
func (o *QEI_Type) GetINTSTAT_TIM_INT() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x2) >> 1
}
func (o *QEI_Type) SetINTSTAT_VELC_INT(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x4)|value<<2)
}
func (o *QEI_Type) GetINTSTAT_VELC_INT() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x4) >> 2
}
func (o *QEI_Type) SetINTSTAT_DIR_INT(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x8)|value<<3)
}
func (o *QEI_Type) GetINTSTAT_DIR_INT() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x8) >> 3
}
func (o *QEI_Type) SetINTSTAT_ERR_INT(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x10)|value<<4)
}
func (o *QEI_Type) GetINTSTAT_ERR_INT() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x10) >> 4
}
func (o *QEI_Type) SetINTSTAT_ENCLK_INT(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x20)|value<<5)
}
func (o *QEI_Type) GetINTSTAT_ENCLK_INT() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x20) >> 5
}
func (o *QEI_Type) SetINTSTAT_POS0_INT(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x40)|value<<6)
}
func (o *QEI_Type) GetINTSTAT_POS0_INT() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x40) >> 6
}
func (o *QEI_Type) SetINTSTAT_POS1_INT(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x80)|value<<7)
}
func (o *QEI_Type) GetINTSTAT_POS1_INT() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x80) >> 7
}
func (o *QEI_Type) SetINTSTAT_POS2_INT(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x100)|value<<8)
}
func (o *QEI_Type) GetINTSTAT_POS2_INT() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x100) >> 8
}
func (o *QEI_Type) SetINTSTAT_REV0_INT(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x200)|value<<9)
}
func (o *QEI_Type) GetINTSTAT_REV0_INT() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x200) >> 9
}
func (o *QEI_Type) SetINTSTAT_POS0REV_INT(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x400)|value<<10)
}
func (o *QEI_Type) GetINTSTAT_POS0REV_INT() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x400) >> 10
}
func (o *QEI_Type) SetINTSTAT_POS1REV_INT(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x800)|value<<11)
}
func (o *QEI_Type) GetINTSTAT_POS1REV_INT() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x800) >> 11
}
func (o *QEI_Type) SetINTSTAT_POS2REV_INT(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x1000)|value<<12)
}
func (o *QEI_Type) GetINTSTAT_POS2REV_INT() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x1000) >> 12
}
func (o *QEI_Type) SetINTSTAT_REV1_INT(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x2000)|value<<13)
}
func (o *QEI_Type) GetINTSTAT_REV1_INT() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x2000) >> 13
}
func (o *QEI_Type) SetINTSTAT_REV2_INT(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x4000)|value<<14)
}
func (o *QEI_Type) GetINTSTAT_REV2_INT() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x4000) >> 14
}
func (o *QEI_Type) SetINTSTAT_MAXPOS_INT(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x8000)|value<<15)
}
func (o *QEI_Type) GetINTSTAT_MAXPOS_INT() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x8000) >> 15
}
func (o *QEI_Type) SetINTSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0xffff0000)|value<<16)
}
func (o *QEI_Type) GetINTSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0xffff0000) >> 16
}

// QEI.IE: Interrupt enable clear register
func (o *QEI_Type) SetIE_INX_INT(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x1)|value)
}
func (o *QEI_Type) GetIE_INX_INT() uint32 {
	return volatile.LoadUint32(&o.IE.Reg) & 0x1
}
func (o *QEI_Type) SetIE_TIM_INT(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x2)|value<<1)
}
func (o *QEI_Type) GetIE_TIM_INT() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x2) >> 1
}
func (o *QEI_Type) SetIE_VELC_INT(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x4)|value<<2)
}
func (o *QEI_Type) GetIE_VELC_INT() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x4) >> 2
}
func (o *QEI_Type) SetIE_DIR_INT(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x8)|value<<3)
}
func (o *QEI_Type) GetIE_DIR_INT() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x8) >> 3
}
func (o *QEI_Type) SetIE_ERR_INT(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x10)|value<<4)
}
func (o *QEI_Type) GetIE_ERR_INT() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x10) >> 4
}
func (o *QEI_Type) SetIE_ENCLK_INT(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x20)|value<<5)
}
func (o *QEI_Type) GetIE_ENCLK_INT() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x20) >> 5
}
func (o *QEI_Type) SetIE_POS0_INT(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x40)|value<<6)
}
func (o *QEI_Type) GetIE_POS0_INT() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x40) >> 6
}
func (o *QEI_Type) SetIE_POS1_INT(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x80)|value<<7)
}
func (o *QEI_Type) GetIE_POS1_INT() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x80) >> 7
}
func (o *QEI_Type) SetIE_POS2_INT(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x100)|value<<8)
}
func (o *QEI_Type) GetIE_POS2_INT() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x100) >> 8
}
func (o *QEI_Type) SetIE_REV0_INT(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x200)|value<<9)
}
func (o *QEI_Type) GetIE_REV0_INT() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x200) >> 9
}
func (o *QEI_Type) SetIE_POS0REV_INT(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x400)|value<<10)
}
func (o *QEI_Type) GetIE_POS0REV_INT() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x400) >> 10
}
func (o *QEI_Type) SetIE_POS1REV_INT(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x800)|value<<11)
}
func (o *QEI_Type) GetIE_POS1REV_INT() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x800) >> 11
}
func (o *QEI_Type) SetIE_POS2REV_INT(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x1000)|value<<12)
}
func (o *QEI_Type) GetIE_POS2REV_INT() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x1000) >> 12
}
func (o *QEI_Type) SetIE_REV1_INT(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x2000)|value<<13)
}
func (o *QEI_Type) GetIE_REV1_INT() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x2000) >> 13
}
func (o *QEI_Type) SetIE_REV2_INT(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x4000)|value<<14)
}
func (o *QEI_Type) GetIE_REV2_INT() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x4000) >> 14
}
func (o *QEI_Type) SetIE_MAXPOS_INT(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x8000)|value<<15)
}
func (o *QEI_Type) GetIE_MAXPOS_INT() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x8000) >> 15
}
func (o *QEI_Type) SetIE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0xffff0000)|value<<16)
}
func (o *QEI_Type) GetIE_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0xffff0000) >> 16
}

// QEI.CLR: Interrupt status clear register
func (o *QEI_Type) SetCLR_INX_INT(value uint32) {
	volatile.StoreUint32(&o.CLR.Reg, volatile.LoadUint32(&o.CLR.Reg)&^(0x1)|value)
}
func (o *QEI_Type) GetCLR_INX_INT() uint32 {
	return volatile.LoadUint32(&o.CLR.Reg) & 0x1
}
func (o *QEI_Type) SetCLR_TIM_INT(value uint32) {
	volatile.StoreUint32(&o.CLR.Reg, volatile.LoadUint32(&o.CLR.Reg)&^(0x2)|value<<1)
}
func (o *QEI_Type) GetCLR_TIM_INT() uint32 {
	return (volatile.LoadUint32(&o.CLR.Reg) & 0x2) >> 1
}
func (o *QEI_Type) SetCLR_VELC_INT(value uint32) {
	volatile.StoreUint32(&o.CLR.Reg, volatile.LoadUint32(&o.CLR.Reg)&^(0x4)|value<<2)
}
func (o *QEI_Type) GetCLR_VELC_INT() uint32 {
	return (volatile.LoadUint32(&o.CLR.Reg) & 0x4) >> 2
}
func (o *QEI_Type) SetCLR_DIR_INT(value uint32) {
	volatile.StoreUint32(&o.CLR.Reg, volatile.LoadUint32(&o.CLR.Reg)&^(0x8)|value<<3)
}
func (o *QEI_Type) GetCLR_DIR_INT() uint32 {
	return (volatile.LoadUint32(&o.CLR.Reg) & 0x8) >> 3
}
func (o *QEI_Type) SetCLR_ERR_INT(value uint32) {
	volatile.StoreUint32(&o.CLR.Reg, volatile.LoadUint32(&o.CLR.Reg)&^(0x10)|value<<4)
}
func (o *QEI_Type) GetCLR_ERR_INT() uint32 {
	return (volatile.LoadUint32(&o.CLR.Reg) & 0x10) >> 4
}
func (o *QEI_Type) SetCLR_ENCLK_INT(value uint32) {
	volatile.StoreUint32(&o.CLR.Reg, volatile.LoadUint32(&o.CLR.Reg)&^(0x20)|value<<5)
}
func (o *QEI_Type) GetCLR_ENCLK_INT() uint32 {
	return (volatile.LoadUint32(&o.CLR.Reg) & 0x20) >> 5
}
func (o *QEI_Type) SetCLR_POS0_INT(value uint32) {
	volatile.StoreUint32(&o.CLR.Reg, volatile.LoadUint32(&o.CLR.Reg)&^(0x40)|value<<6)
}
func (o *QEI_Type) GetCLR_POS0_INT() uint32 {
	return (volatile.LoadUint32(&o.CLR.Reg) & 0x40) >> 6
}
func (o *QEI_Type) SetCLR_POS1_INT(value uint32) {
	volatile.StoreUint32(&o.CLR.Reg, volatile.LoadUint32(&o.CLR.Reg)&^(0x80)|value<<7)
}
func (o *QEI_Type) GetCLR_POS1_INT() uint32 {
	return (volatile.LoadUint32(&o.CLR.Reg) & 0x80) >> 7
}
func (o *QEI_Type) SetCLR_POS2_INT(value uint32) {
	volatile.StoreUint32(&o.CLR.Reg, volatile.LoadUint32(&o.CLR.Reg)&^(0x100)|value<<8)
}
func (o *QEI_Type) GetCLR_POS2_INT() uint32 {
	return (volatile.LoadUint32(&o.CLR.Reg) & 0x100) >> 8
}
func (o *QEI_Type) SetCLR_REV0_INT(value uint32) {
	volatile.StoreUint32(&o.CLR.Reg, volatile.LoadUint32(&o.CLR.Reg)&^(0x200)|value<<9)
}
func (o *QEI_Type) GetCLR_REV0_INT() uint32 {
	return (volatile.LoadUint32(&o.CLR.Reg) & 0x200) >> 9
}
func (o *QEI_Type) SetCLR_POS0REV_INT(value uint32) {
	volatile.StoreUint32(&o.CLR.Reg, volatile.LoadUint32(&o.CLR.Reg)&^(0x400)|value<<10)
}
func (o *QEI_Type) GetCLR_POS0REV_INT() uint32 {
	return (volatile.LoadUint32(&o.CLR.Reg) & 0x400) >> 10
}
func (o *QEI_Type) SetCLR_POS1REV_INT(value uint32) {
	volatile.StoreUint32(&o.CLR.Reg, volatile.LoadUint32(&o.CLR.Reg)&^(0x800)|value<<11)
}
func (o *QEI_Type) GetCLR_POS1REV_INT() uint32 {
	return (volatile.LoadUint32(&o.CLR.Reg) & 0x800) >> 11
}
func (o *QEI_Type) SetCLR_POS2REV_INT(value uint32) {
	volatile.StoreUint32(&o.CLR.Reg, volatile.LoadUint32(&o.CLR.Reg)&^(0x1000)|value<<12)
}
func (o *QEI_Type) GetCLR_POS2REV_INT() uint32 {
	return (volatile.LoadUint32(&o.CLR.Reg) & 0x1000) >> 12
}
func (o *QEI_Type) SetCLR_REV1_INT(value uint32) {
	volatile.StoreUint32(&o.CLR.Reg, volatile.LoadUint32(&o.CLR.Reg)&^(0x2000)|value<<13)
}
func (o *QEI_Type) GetCLR_REV1_INT() uint32 {
	return (volatile.LoadUint32(&o.CLR.Reg) & 0x2000) >> 13
}
func (o *QEI_Type) SetCLR_REV2_INT(value uint32) {
	volatile.StoreUint32(&o.CLR.Reg, volatile.LoadUint32(&o.CLR.Reg)&^(0x4000)|value<<14)
}
func (o *QEI_Type) GetCLR_REV2_INT() uint32 {
	return (volatile.LoadUint32(&o.CLR.Reg) & 0x4000) >> 14
}
func (o *QEI_Type) SetCLR_MAXPOS_INT(value uint32) {
	volatile.StoreUint32(&o.CLR.Reg, volatile.LoadUint32(&o.CLR.Reg)&^(0x8000)|value<<15)
}
func (o *QEI_Type) GetCLR_MAXPOS_INT() uint32 {
	return (volatile.LoadUint32(&o.CLR.Reg) & 0x8000) >> 15
}
func (o *QEI_Type) SetCLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CLR.Reg, volatile.LoadUint32(&o.CLR.Reg)&^(0xffff0000)|value<<16)
}
func (o *QEI_Type) GetCLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CLR.Reg) & 0xffff0000) >> 16
}

// QEI.SET: Interrupt status set register
func (o *QEI_Type) SetSET_INX_INT(value uint32) {
	volatile.StoreUint32(&o.SET.Reg, volatile.LoadUint32(&o.SET.Reg)&^(0x1)|value)
}
func (o *QEI_Type) GetSET_INX_INT() uint32 {
	return volatile.LoadUint32(&o.SET.Reg) & 0x1
}
func (o *QEI_Type) SetSET_TIM_INT(value uint32) {
	volatile.StoreUint32(&o.SET.Reg, volatile.LoadUint32(&o.SET.Reg)&^(0x2)|value<<1)
}
func (o *QEI_Type) GetSET_TIM_INT() uint32 {
	return (volatile.LoadUint32(&o.SET.Reg) & 0x2) >> 1
}
func (o *QEI_Type) SetSET_VELC_INT(value uint32) {
	volatile.StoreUint32(&o.SET.Reg, volatile.LoadUint32(&o.SET.Reg)&^(0x4)|value<<2)
}
func (o *QEI_Type) GetSET_VELC_INT() uint32 {
	return (volatile.LoadUint32(&o.SET.Reg) & 0x4) >> 2
}
func (o *QEI_Type) SetSET_DIR_INT(value uint32) {
	volatile.StoreUint32(&o.SET.Reg, volatile.LoadUint32(&o.SET.Reg)&^(0x8)|value<<3)
}
func (o *QEI_Type) GetSET_DIR_INT() uint32 {
	return (volatile.LoadUint32(&o.SET.Reg) & 0x8) >> 3
}
func (o *QEI_Type) SetSET_ERR_INT(value uint32) {
	volatile.StoreUint32(&o.SET.Reg, volatile.LoadUint32(&o.SET.Reg)&^(0x10)|value<<4)
}
func (o *QEI_Type) GetSET_ERR_INT() uint32 {
	return (volatile.LoadUint32(&o.SET.Reg) & 0x10) >> 4
}
func (o *QEI_Type) SetSET_ENCLK_INT(value uint32) {
	volatile.StoreUint32(&o.SET.Reg, volatile.LoadUint32(&o.SET.Reg)&^(0x20)|value<<5)
}
func (o *QEI_Type) GetSET_ENCLK_INT() uint32 {
	return (volatile.LoadUint32(&o.SET.Reg) & 0x20) >> 5
}
func (o *QEI_Type) SetSET_POS0_INT(value uint32) {
	volatile.StoreUint32(&o.SET.Reg, volatile.LoadUint32(&o.SET.Reg)&^(0x40)|value<<6)
}
func (o *QEI_Type) GetSET_POS0_INT() uint32 {
	return (volatile.LoadUint32(&o.SET.Reg) & 0x40) >> 6
}
func (o *QEI_Type) SetSET_POS1_INT(value uint32) {
	volatile.StoreUint32(&o.SET.Reg, volatile.LoadUint32(&o.SET.Reg)&^(0x80)|value<<7)
}
func (o *QEI_Type) GetSET_POS1_INT() uint32 {
	return (volatile.LoadUint32(&o.SET.Reg) & 0x80) >> 7
}
func (o *QEI_Type) SetSET_POS2_INT(value uint32) {
	volatile.StoreUint32(&o.SET.Reg, volatile.LoadUint32(&o.SET.Reg)&^(0x100)|value<<8)
}
func (o *QEI_Type) GetSET_POS2_INT() uint32 {
	return (volatile.LoadUint32(&o.SET.Reg) & 0x100) >> 8
}
func (o *QEI_Type) SetSET_REV0_INT(value uint32) {
	volatile.StoreUint32(&o.SET.Reg, volatile.LoadUint32(&o.SET.Reg)&^(0x200)|value<<9)
}
func (o *QEI_Type) GetSET_REV0_INT() uint32 {
	return (volatile.LoadUint32(&o.SET.Reg) & 0x200) >> 9
}
func (o *QEI_Type) SetSET_POS0REV_INT(value uint32) {
	volatile.StoreUint32(&o.SET.Reg, volatile.LoadUint32(&o.SET.Reg)&^(0x400)|value<<10)
}
func (o *QEI_Type) GetSET_POS0REV_INT() uint32 {
	return (volatile.LoadUint32(&o.SET.Reg) & 0x400) >> 10
}
func (o *QEI_Type) SetSET_POS1REV_INT(value uint32) {
	volatile.StoreUint32(&o.SET.Reg, volatile.LoadUint32(&o.SET.Reg)&^(0x800)|value<<11)
}
func (o *QEI_Type) GetSET_POS1REV_INT() uint32 {
	return (volatile.LoadUint32(&o.SET.Reg) & 0x800) >> 11
}
func (o *QEI_Type) SetSET_POS2REV_INT(value uint32) {
	volatile.StoreUint32(&o.SET.Reg, volatile.LoadUint32(&o.SET.Reg)&^(0x1000)|value<<12)
}
func (o *QEI_Type) GetSET_POS2REV_INT() uint32 {
	return (volatile.LoadUint32(&o.SET.Reg) & 0x1000) >> 12
}
func (o *QEI_Type) SetSET_REV1_INT(value uint32) {
	volatile.StoreUint32(&o.SET.Reg, volatile.LoadUint32(&o.SET.Reg)&^(0x2000)|value<<13)
}
func (o *QEI_Type) GetSET_REV1_INT() uint32 {
	return (volatile.LoadUint32(&o.SET.Reg) & 0x2000) >> 13
}
func (o *QEI_Type) SetSET_REV2_INT(value uint32) {
	volatile.StoreUint32(&o.SET.Reg, volatile.LoadUint32(&o.SET.Reg)&^(0x4000)|value<<14)
}
func (o *QEI_Type) GetSET_REV2_INT() uint32 {
	return (volatile.LoadUint32(&o.SET.Reg) & 0x4000) >> 14
}
func (o *QEI_Type) SetSET_MAXPOS_INT(value uint32) {
	volatile.StoreUint32(&o.SET.Reg, volatile.LoadUint32(&o.SET.Reg)&^(0x8000)|value<<15)
}
func (o *QEI_Type) GetSET_MAXPOS_INT() uint32 {
	return (volatile.LoadUint32(&o.SET.Reg) & 0x8000) >> 15
}
func (o *QEI_Type) SetSET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SET.Reg, volatile.LoadUint32(&o.SET.Reg)&^(0xffff0000)|value<<16)
}
func (o *QEI_Type) GetSET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SET.Reg) & 0xffff0000) >> 16
}

// System configuration (SYSCON)
type SYSCON_Type struct {
	SYSMEMREMAP    volatile.Register32 // 0x0
	_              [16]byte
	SYSTCKCAL      volatile.Register32 // 0x14
	_              [4]byte
	NMISRC         volatile.Register32 // 0x1C
	_              [32]byte
	SYSRSTSTAT     volatile.Register32 // 0x40
	PRESETCTRL0    volatile.Register32 // 0x44
	PRESETCTRL1    volatile.Register32 // 0x48
	PIOPORCAP0     volatile.Register32 // 0x4C
	PIOPORCAP1     volatile.Register32 // 0x50
	PIOPORCAP2     volatile.Register32 // 0x54
	_              [40]byte
	MAINCLKSELA    volatile.Register32 // 0x80
	MAINCLKSELB    volatile.Register32 // 0x84
	USBCLKSEL      volatile.Register32 // 0x88
	ADCASYNCCLKSEL volatile.Register32 // 0x8C
	_              [4]byte
	CLKOUTSELA     volatile.Register32 // 0x94
	CLKOUTSELB     volatile.Register32 // 0x98
	_              [4]byte
	SYSPLLCLKSEL   volatile.Register32 // 0xA0
	USBPLLCLKSEL   volatile.Register32 // 0xA4
	SCTPLLCLKSEL   volatile.Register32 // 0xA8
	_              [20]byte
	SYSAHBCLKDIV   volatile.Register32 // 0xC0
	SYSAHBCLKCTRL0 volatile.Register32 // 0xC4
	SYSAHBCLKCTRL1 volatile.Register32 // 0xC8
	SYSTICKCLKDIV  volatile.Register32 // 0xCC
	UARTCLKDIV     volatile.Register32 // 0xD0
	IOCONCLKDIV    volatile.Register32 // 0xD4
	TRACECLKDIV    volatile.Register32 // 0xD8
	_              [16]byte
	USBCLKDIV      volatile.Register32 // 0xEC
	ADCASYNCCLKDIV volatile.Register32 // 0xF0
	_              [4]byte
	CLKOUTDIV      volatile.Register32 // 0xF8
	_              [44]byte
	FRGCTRL        volatile.Register32 // 0x128
	USBCLKCTRL     volatile.Register32 // 0x12C
	USBCLKST       volatile.Register32 // 0x130
	_              [76]byte
	BODCTRL        volatile.Register32 // 0x180
	_              [4]byte
	SYSOSCCTRL     volatile.Register32 // 0x188
	_              [4]byte
	RTCOSCCTRL     volatile.Register32 // 0x190
	_              [4]byte
	SYSPLLCTRL     volatile.Register32 // 0x198
	SYSPLLSTAT     volatile.Register32 // 0x19C
	USBPLLCTRL     volatile.Register32 // 0x1A0
	USBPLLSTAT     volatile.Register32 // 0x1A4
	SCTPLLCTRL     volatile.Register32 // 0x1A8
	SCTPLLSTAT     volatile.Register32 // 0x1AC
	_              [84]byte
	PDAWAKECFG     volatile.Register32 // 0x204
	PDRUNCFG       volatile.Register32 // 0x208
	_              [12]byte
	STARTERP0      volatile.Register32 // 0x218
	STARTERP1      volatile.Register32 // 0x21C
}

// SYSCON.SYSMEMREMAP: System memory remap
func (o *SYSCON_Type) SetSYSMEMREMAP_MAP(value uint32) {
	volatile.StoreUint32(&o.SYSMEMREMAP.Reg, volatile.LoadUint32(&o.SYSMEMREMAP.Reg)&^(0x3)|value)
}
func (o *SYSCON_Type) GetSYSMEMREMAP_MAP() uint32 {
	return volatile.LoadUint32(&o.SYSMEMREMAP.Reg) & 0x3
}
func (o *SYSCON_Type) SetSYSMEMREMAP_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SYSMEMREMAP.Reg, volatile.LoadUint32(&o.SYSMEMREMAP.Reg)&^(0xfffffffc)|value<<2)
}
func (o *SYSCON_Type) GetSYSMEMREMAP_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SYSMEMREMAP.Reg) & 0xfffffffc) >> 2
}

// SYSCON.SYSTCKCAL: System tick counter calibration
func (o *SYSCON_Type) SetSYSTCKCAL_CAL(value uint32) {
	volatile.StoreUint32(&o.SYSTCKCAL.Reg, volatile.LoadUint32(&o.SYSTCKCAL.Reg)&^(0x3ffffff)|value)
}
func (o *SYSCON_Type) GetSYSTCKCAL_CAL() uint32 {
	return volatile.LoadUint32(&o.SYSTCKCAL.Reg) & 0x3ffffff
}
func (o *SYSCON_Type) SetSYSTCKCAL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SYSTCKCAL.Reg, volatile.LoadUint32(&o.SYSTCKCAL.Reg)&^(0xfc000000)|value<<26)
}
func (o *SYSCON_Type) GetSYSTCKCAL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SYSTCKCAL.Reg) & 0xfc000000) >> 26
}

// SYSCON.NMISRC: NMI Source Control
func (o *SYSCON_Type) SetNMISRC_IRQNO(value uint32) {
	volatile.StoreUint32(&o.NMISRC.Reg, volatile.LoadUint32(&o.NMISRC.Reg)&^(0x1f)|value)
}
func (o *SYSCON_Type) GetNMISRC_IRQNO() uint32 {
	return volatile.LoadUint32(&o.NMISRC.Reg) & 0x1f
}
func (o *SYSCON_Type) SetNMISRC_RESERVED(value uint32) {
	volatile.StoreUint32(&o.NMISRC.Reg, volatile.LoadUint32(&o.NMISRC.Reg)&^(0x7fffffe0)|value<<5)
}
func (o *SYSCON_Type) GetNMISRC_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.NMISRC.Reg) & 0x7fffffe0) >> 5
}
func (o *SYSCON_Type) SetNMISRC_NMIEN(value uint32) {
	volatile.StoreUint32(&o.NMISRC.Reg, volatile.LoadUint32(&o.NMISRC.Reg)&^(0x80000000)|value<<31)
}
func (o *SYSCON_Type) GetNMISRC_NMIEN() uint32 {
	return (volatile.LoadUint32(&o.NMISRC.Reg) & 0x80000000) >> 31
}

// SYSCON.SYSRSTSTAT: System reset status register
func (o *SYSCON_Type) SetSYSRSTSTAT_POR(value uint32) {
	volatile.StoreUint32(&o.SYSRSTSTAT.Reg, volatile.LoadUint32(&o.SYSRSTSTAT.Reg)&^(0x1)|value)
}
func (o *SYSCON_Type) GetSYSRSTSTAT_POR() uint32 {
	return volatile.LoadUint32(&o.SYSRSTSTAT.Reg) & 0x1
}
func (o *SYSCON_Type) SetSYSRSTSTAT_EXTRST(value uint32) {
	volatile.StoreUint32(&o.SYSRSTSTAT.Reg, volatile.LoadUint32(&o.SYSRSTSTAT.Reg)&^(0x2)|value<<1)
}
func (o *SYSCON_Type) GetSYSRSTSTAT_EXTRST() uint32 {
	return (volatile.LoadUint32(&o.SYSRSTSTAT.Reg) & 0x2) >> 1
}
func (o *SYSCON_Type) SetSYSRSTSTAT_WDT(value uint32) {
	volatile.StoreUint32(&o.SYSRSTSTAT.Reg, volatile.LoadUint32(&o.SYSRSTSTAT.Reg)&^(0x4)|value<<2)
}
func (o *SYSCON_Type) GetSYSRSTSTAT_WDT() uint32 {
	return (volatile.LoadUint32(&o.SYSRSTSTAT.Reg) & 0x4) >> 2
}
func (o *SYSCON_Type) SetSYSRSTSTAT_BOD(value uint32) {
	volatile.StoreUint32(&o.SYSRSTSTAT.Reg, volatile.LoadUint32(&o.SYSRSTSTAT.Reg)&^(0x8)|value<<3)
}
func (o *SYSCON_Type) GetSYSRSTSTAT_BOD() uint32 {
	return (volatile.LoadUint32(&o.SYSRSTSTAT.Reg) & 0x8) >> 3
}
func (o *SYSCON_Type) SetSYSRSTSTAT_SYSRST(value uint32) {
	volatile.StoreUint32(&o.SYSRSTSTAT.Reg, volatile.LoadUint32(&o.SYSRSTSTAT.Reg)&^(0x10)|value<<4)
}
func (o *SYSCON_Type) GetSYSRSTSTAT_SYSRST() uint32 {
	return (volatile.LoadUint32(&o.SYSRSTSTAT.Reg) & 0x10) >> 4
}
func (o *SYSCON_Type) SetSYSRSTSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SYSRSTSTAT.Reg, volatile.LoadUint32(&o.SYSRSTSTAT.Reg)&^(0xffffffe0)|value<<5)
}
func (o *SYSCON_Type) GetSYSRSTSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SYSRSTSTAT.Reg) & 0xffffffe0) >> 5
}

// SYSCON.PRESETCTRL0: Peripheral reset control 0
func (o *SYSCON_Type) SetPRESETCTRL0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PRESETCTRL0.Reg, volatile.LoadUint32(&o.PRESETCTRL0.Reg)&^(0x7f)|value)
}
func (o *SYSCON_Type) GetPRESETCTRL0_RESERVED() uint32 {
	return volatile.LoadUint32(&o.PRESETCTRL0.Reg) & 0x7f
}
func (o *SYSCON_Type) SetPRESETCTRL0_FLASH_RST(value uint32) {
	volatile.StoreUint32(&o.PRESETCTRL0.Reg, volatile.LoadUint32(&o.PRESETCTRL0.Reg)&^(0x80)|value<<7)
}
func (o *SYSCON_Type) GetPRESETCTRL0_FLASH_RST() uint32 {
	return (volatile.LoadUint32(&o.PRESETCTRL0.Reg) & 0x80) >> 7
}
func (o *SYSCON_Type) SetPRESETCTRL0_FMC_RST(value uint32) {
	volatile.StoreUint32(&o.PRESETCTRL0.Reg, volatile.LoadUint32(&o.PRESETCTRL0.Reg)&^(0x100)|value<<8)
}
func (o *SYSCON_Type) GetPRESETCTRL0_FMC_RST() uint32 {
	return (volatile.LoadUint32(&o.PRESETCTRL0.Reg) & 0x100) >> 8
}
func (o *SYSCON_Type) SetPRESETCTRL0_EEPROM_RST(value uint32) {
	volatile.StoreUint32(&o.PRESETCTRL0.Reg, volatile.LoadUint32(&o.PRESETCTRL0.Reg)&^(0x200)|value<<9)
}
func (o *SYSCON_Type) GetPRESETCTRL0_EEPROM_RST() uint32 {
	return (volatile.LoadUint32(&o.PRESETCTRL0.Reg) & 0x200) >> 9
}
func (o *SYSCON_Type) SetPRESETCTRL0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PRESETCTRL0.Reg, volatile.LoadUint32(&o.PRESETCTRL0.Reg)&^(0x400)|value<<10)
}
func (o *SYSCON_Type) GetPRESETCTRL0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PRESETCTRL0.Reg) & 0x400) >> 10
}
func (o *SYSCON_Type) SetPRESETCTRL0_PMUX_RST(value uint32) {
	volatile.StoreUint32(&o.PRESETCTRL0.Reg, volatile.LoadUint32(&o.PRESETCTRL0.Reg)&^(0x800)|value<<11)
}
func (o *SYSCON_Type) GetPRESETCTRL0_PMUX_RST() uint32 {
	return (volatile.LoadUint32(&o.PRESETCTRL0.Reg) & 0x800) >> 11
}
func (o *SYSCON_Type) SetPRESETCTRL0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PRESETCTRL0.Reg, volatile.LoadUint32(&o.PRESETCTRL0.Reg)&^(0x1000)|value<<12)
}
func (o *SYSCON_Type) GetPRESETCTRL0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PRESETCTRL0.Reg) & 0x1000) >> 12
}
func (o *SYSCON_Type) SetPRESETCTRL0_IOCON_RST(value uint32) {
	volatile.StoreUint32(&o.PRESETCTRL0.Reg, volatile.LoadUint32(&o.PRESETCTRL0.Reg)&^(0x2000)|value<<13)
}
func (o *SYSCON_Type) GetPRESETCTRL0_IOCON_RST() uint32 {
	return (volatile.LoadUint32(&o.PRESETCTRL0.Reg) & 0x2000) >> 13
}
func (o *SYSCON_Type) SetPRESETCTRL0_GPIO0_RST(value uint32) {
	volatile.StoreUint32(&o.PRESETCTRL0.Reg, volatile.LoadUint32(&o.PRESETCTRL0.Reg)&^(0x4000)|value<<14)
}
func (o *SYSCON_Type) GetPRESETCTRL0_GPIO0_RST() uint32 {
	return (volatile.LoadUint32(&o.PRESETCTRL0.Reg) & 0x4000) >> 14
}
func (o *SYSCON_Type) SetPRESETCTRL0_GPIO1_RST(value uint32) {
	volatile.StoreUint32(&o.PRESETCTRL0.Reg, volatile.LoadUint32(&o.PRESETCTRL0.Reg)&^(0x8000)|value<<15)
}
func (o *SYSCON_Type) GetPRESETCTRL0_GPIO1_RST() uint32 {
	return (volatile.LoadUint32(&o.PRESETCTRL0.Reg) & 0x8000) >> 15
}
func (o *SYSCON_Type) SetPRESETCTRL0_GPIO2_RST(value uint32) {
	volatile.StoreUint32(&o.PRESETCTRL0.Reg, volatile.LoadUint32(&o.PRESETCTRL0.Reg)&^(0x10000)|value<<16)
}
func (o *SYSCON_Type) GetPRESETCTRL0_GPIO2_RST() uint32 {
	return (volatile.LoadUint32(&o.PRESETCTRL0.Reg) & 0x10000) >> 16
}
func (o *SYSCON_Type) SetPRESETCTRL0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PRESETCTRL0.Reg, volatile.LoadUint32(&o.PRESETCTRL0.Reg)&^(0x20000)|value<<17)
}
func (o *SYSCON_Type) GetPRESETCTRL0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PRESETCTRL0.Reg) & 0x20000) >> 17
}
func (o *SYSCON_Type) SetPRESETCTRL0_PINT_RST(value uint32) {
	volatile.StoreUint32(&o.PRESETCTRL0.Reg, volatile.LoadUint32(&o.PRESETCTRL0.Reg)&^(0x40000)|value<<18)
}
func (o *SYSCON_Type) GetPRESETCTRL0_PINT_RST() uint32 {
	return (volatile.LoadUint32(&o.PRESETCTRL0.Reg) & 0x40000) >> 18
}
func (o *SYSCON_Type) SetPRESETCTRL0_GINT_RST(value uint32) {
	volatile.StoreUint32(&o.PRESETCTRL0.Reg, volatile.LoadUint32(&o.PRESETCTRL0.Reg)&^(0x80000)|value<<19)
}
func (o *SYSCON_Type) GetPRESETCTRL0_GINT_RST() uint32 {
	return (volatile.LoadUint32(&o.PRESETCTRL0.Reg) & 0x80000) >> 19
}
func (o *SYSCON_Type) SetPRESETCTRL0_DMA_RST(value uint32) {
	volatile.StoreUint32(&o.PRESETCTRL0.Reg, volatile.LoadUint32(&o.PRESETCTRL0.Reg)&^(0x100000)|value<<20)
}
func (o *SYSCON_Type) GetPRESETCTRL0_DMA_RST() uint32 {
	return (volatile.LoadUint32(&o.PRESETCTRL0.Reg) & 0x100000) >> 20
}
func (o *SYSCON_Type) SetPRESETCTRL0_CRC_RST(value uint32) {
	volatile.StoreUint32(&o.PRESETCTRL0.Reg, volatile.LoadUint32(&o.PRESETCTRL0.Reg)&^(0x200000)|value<<21)
}
func (o *SYSCON_Type) GetPRESETCTRL0_CRC_RST() uint32 {
	return (volatile.LoadUint32(&o.PRESETCTRL0.Reg) & 0x200000) >> 21
}
func (o *SYSCON_Type) SetPRESETCTRL0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PRESETCTRL0.Reg, volatile.LoadUint32(&o.PRESETCTRL0.Reg)&^(0x7c00000)|value<<22)
}
func (o *SYSCON_Type) GetPRESETCTRL0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PRESETCTRL0.Reg) & 0x7c00000) >> 22
}
func (o *SYSCON_Type) SetPRESETCTRL0_ADC0_RST(value uint32) {
	volatile.StoreUint32(&o.PRESETCTRL0.Reg, volatile.LoadUint32(&o.PRESETCTRL0.Reg)&^(0x8000000)|value<<27)
}
func (o *SYSCON_Type) GetPRESETCTRL0_ADC0_RST() uint32 {
	return (volatile.LoadUint32(&o.PRESETCTRL0.Reg) & 0x8000000) >> 27
}
func (o *SYSCON_Type) SetPRESETCTRL0_ADC1_RST(value uint32) {
	volatile.StoreUint32(&o.PRESETCTRL0.Reg, volatile.LoadUint32(&o.PRESETCTRL0.Reg)&^(0x10000000)|value<<28)
}
func (o *SYSCON_Type) GetPRESETCTRL0_ADC1_RST() uint32 {
	return (volatile.LoadUint32(&o.PRESETCTRL0.Reg) & 0x10000000) >> 28
}
func (o *SYSCON_Type) SetPRESETCTRL0_DAC_RST(value uint32) {
	volatile.StoreUint32(&o.PRESETCTRL0.Reg, volatile.LoadUint32(&o.PRESETCTRL0.Reg)&^(0x20000000)|value<<29)
}
func (o *SYSCON_Type) GetPRESETCTRL0_DAC_RST() uint32 {
	return (volatile.LoadUint32(&o.PRESETCTRL0.Reg) & 0x20000000) >> 29
}
func (o *SYSCON_Type) SetPRESETCTRL0_ACMP_RST(value uint32) {
	volatile.StoreUint32(&o.PRESETCTRL0.Reg, volatile.LoadUint32(&o.PRESETCTRL0.Reg)&^(0x40000000)|value<<30)
}
func (o *SYSCON_Type) GetPRESETCTRL0_ACMP_RST() uint32 {
	return (volatile.LoadUint32(&o.PRESETCTRL0.Reg) & 0x40000000) >> 30
}
func (o *SYSCON_Type) SetPRESETCTRL0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PRESETCTRL0.Reg, volatile.LoadUint32(&o.PRESETCTRL0.Reg)&^(0x80000000)|value<<31)
}
func (o *SYSCON_Type) GetPRESETCTRL0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PRESETCTRL0.Reg) & 0x80000000) >> 31
}

// SYSCON.PRESETCTRL1: Peripheral reset control 1
func (o *SYSCON_Type) SetPRESETCTRL1_MRT_RST(value uint32) {
	volatile.StoreUint32(&o.PRESETCTRL1.Reg, volatile.LoadUint32(&o.PRESETCTRL1.Reg)&^(0x1)|value)
}
func (o *SYSCON_Type) GetPRESETCTRL1_MRT_RST() uint32 {
	return volatile.LoadUint32(&o.PRESETCTRL1.Reg) & 0x1
}
func (o *SYSCON_Type) SetPRESETCTRL1_RIT_RST(value uint32) {
	volatile.StoreUint32(&o.PRESETCTRL1.Reg, volatile.LoadUint32(&o.PRESETCTRL1.Reg)&^(0x2)|value<<1)
}
func (o *SYSCON_Type) GetPRESETCTRL1_RIT_RST() uint32 {
	return (volatile.LoadUint32(&o.PRESETCTRL1.Reg) & 0x2) >> 1
}
func (o *SYSCON_Type) SetPRESETCTRL1_SCT0_RST(value uint32) {
	volatile.StoreUint32(&o.PRESETCTRL1.Reg, volatile.LoadUint32(&o.PRESETCTRL1.Reg)&^(0x4)|value<<2)
}
func (o *SYSCON_Type) GetPRESETCTRL1_SCT0_RST() uint32 {
	return (volatile.LoadUint32(&o.PRESETCTRL1.Reg) & 0x4) >> 2
}
func (o *SYSCON_Type) SetPRESETCTRL1_SCT1_RST(value uint32) {
	volatile.StoreUint32(&o.PRESETCTRL1.Reg, volatile.LoadUint32(&o.PRESETCTRL1.Reg)&^(0x8)|value<<3)
}
func (o *SYSCON_Type) GetPRESETCTRL1_SCT1_RST() uint32 {
	return (volatile.LoadUint32(&o.PRESETCTRL1.Reg) & 0x8) >> 3
}
func (o *SYSCON_Type) SetPRESETCTRL1_SCT2_RST(value uint32) {
	volatile.StoreUint32(&o.PRESETCTRL1.Reg, volatile.LoadUint32(&o.PRESETCTRL1.Reg)&^(0x10)|value<<4)
}
func (o *SYSCON_Type) GetPRESETCTRL1_SCT2_RST() uint32 {
	return (volatile.LoadUint32(&o.PRESETCTRL1.Reg) & 0x10) >> 4
}
func (o *SYSCON_Type) SetPRESETCTRL1_SCT3_RST(value uint32) {
	volatile.StoreUint32(&o.PRESETCTRL1.Reg, volatile.LoadUint32(&o.PRESETCTRL1.Reg)&^(0x20)|value<<5)
}
func (o *SYSCON_Type) GetPRESETCTRL1_SCT3_RST() uint32 {
	return (volatile.LoadUint32(&o.PRESETCTRL1.Reg) & 0x20) >> 5
}
func (o *SYSCON_Type) SetPRESETCTRL1_SCTIPU_RST(value uint32) {
	volatile.StoreUint32(&o.PRESETCTRL1.Reg, volatile.LoadUint32(&o.PRESETCTRL1.Reg)&^(0x40)|value<<6)
}
func (o *SYSCON_Type) GetPRESETCTRL1_SCTIPU_RST() uint32 {
	return (volatile.LoadUint32(&o.PRESETCTRL1.Reg) & 0x40) >> 6
}
func (o *SYSCON_Type) SetPRESETCTRL1_CCAN_RST(value uint32) {
	volatile.StoreUint32(&o.PRESETCTRL1.Reg, volatile.LoadUint32(&o.PRESETCTRL1.Reg)&^(0x80)|value<<7)
}
func (o *SYSCON_Type) GetPRESETCTRL1_CCAN_RST() uint32 {
	return (volatile.LoadUint32(&o.PRESETCTRL1.Reg) & 0x80) >> 7
}
func (o *SYSCON_Type) SetPRESETCTRL1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PRESETCTRL1.Reg, volatile.LoadUint32(&o.PRESETCTRL1.Reg)&^(0x100)|value<<8)
}
func (o *SYSCON_Type) GetPRESETCTRL1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PRESETCTRL1.Reg) & 0x100) >> 8
}
func (o *SYSCON_Type) SetPRESETCTRL1_SPI0_RST(value uint32) {
	volatile.StoreUint32(&o.PRESETCTRL1.Reg, volatile.LoadUint32(&o.PRESETCTRL1.Reg)&^(0x200)|value<<9)
}
func (o *SYSCON_Type) GetPRESETCTRL1_SPI0_RST() uint32 {
	return (volatile.LoadUint32(&o.PRESETCTRL1.Reg) & 0x200) >> 9
}
func (o *SYSCON_Type) SetPRESETCTRL1_SPI1_RST(value uint32) {
	volatile.StoreUint32(&o.PRESETCTRL1.Reg, volatile.LoadUint32(&o.PRESETCTRL1.Reg)&^(0x400)|value<<10)
}
func (o *SYSCON_Type) GetPRESETCTRL1_SPI1_RST() uint32 {
	return (volatile.LoadUint32(&o.PRESETCTRL1.Reg) & 0x400) >> 10
}
func (o *SYSCON_Type) SetPRESETCTRL1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PRESETCTRL1.Reg, volatile.LoadUint32(&o.PRESETCTRL1.Reg)&^(0x1800)|value<<11)
}
func (o *SYSCON_Type) GetPRESETCTRL1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PRESETCTRL1.Reg) & 0x1800) >> 11
}
func (o *SYSCON_Type) SetPRESETCTRL1_I2C0_RST(value uint32) {
	volatile.StoreUint32(&o.PRESETCTRL1.Reg, volatile.LoadUint32(&o.PRESETCTRL1.Reg)&^(0x2000)|value<<13)
}
func (o *SYSCON_Type) GetPRESETCTRL1_I2C0_RST() uint32 {
	return (volatile.LoadUint32(&o.PRESETCTRL1.Reg) & 0x2000) >> 13
}
func (o *SYSCON_Type) SetPRESETCTRL1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PRESETCTRL1.Reg, volatile.LoadUint32(&o.PRESETCTRL1.Reg)&^(0x1c000)|value<<14)
}
func (o *SYSCON_Type) GetPRESETCTRL1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PRESETCTRL1.Reg) & 0x1c000) >> 14
}
func (o *SYSCON_Type) SetPRESETCTRL1_UART0_RST(value uint32) {
	volatile.StoreUint32(&o.PRESETCTRL1.Reg, volatile.LoadUint32(&o.PRESETCTRL1.Reg)&^(0x20000)|value<<17)
}
func (o *SYSCON_Type) GetPRESETCTRL1_UART0_RST() uint32 {
	return (volatile.LoadUint32(&o.PRESETCTRL1.Reg) & 0x20000) >> 17
}
func (o *SYSCON_Type) SetPRESETCTRL1_UART1_RST(value uint32) {
	volatile.StoreUint32(&o.PRESETCTRL1.Reg, volatile.LoadUint32(&o.PRESETCTRL1.Reg)&^(0x40000)|value<<18)
}
func (o *SYSCON_Type) GetPRESETCTRL1_UART1_RST() uint32 {
	return (volatile.LoadUint32(&o.PRESETCTRL1.Reg) & 0x40000) >> 18
}
func (o *SYSCON_Type) SetPRESETCTRL1_UART2_RST(value uint32) {
	volatile.StoreUint32(&o.PRESETCTRL1.Reg, volatile.LoadUint32(&o.PRESETCTRL1.Reg)&^(0x80000)|value<<19)
}
func (o *SYSCON_Type) GetPRESETCTRL1_UART2_RST() uint32 {
	return (volatile.LoadUint32(&o.PRESETCTRL1.Reg) & 0x80000) >> 19
}
func (o *SYSCON_Type) SetPRESETCTRL1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PRESETCTRL1.Reg, volatile.LoadUint32(&o.PRESETCTRL1.Reg)&^(0x100000)|value<<20)
}
func (o *SYSCON_Type) GetPRESETCTRL1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PRESETCTRL1.Reg) & 0x100000) >> 20
}
func (o *SYSCON_Type) SetPRESETCTRL1_QEI0_RST(value uint32) {
	volatile.StoreUint32(&o.PRESETCTRL1.Reg, volatile.LoadUint32(&o.PRESETCTRL1.Reg)&^(0x200000)|value<<21)
}
func (o *SYSCON_Type) GetPRESETCTRL1_QEI0_RST() uint32 {
	return (volatile.LoadUint32(&o.PRESETCTRL1.Reg) & 0x200000) >> 21
}
func (o *SYSCON_Type) SetPRESETCTRL1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PRESETCTRL1.Reg, volatile.LoadUint32(&o.PRESETCTRL1.Reg)&^(0x400000)|value<<22)
}
func (o *SYSCON_Type) GetPRESETCTRL1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PRESETCTRL1.Reg) & 0x400000) >> 22
}
func (o *SYSCON_Type) SetPRESETCTRL1_USB_RST(value uint32) {
	volatile.StoreUint32(&o.PRESETCTRL1.Reg, volatile.LoadUint32(&o.PRESETCTRL1.Reg)&^(0x800000)|value<<23)
}
func (o *SYSCON_Type) GetPRESETCTRL1_USB_RST() uint32 {
	return (volatile.LoadUint32(&o.PRESETCTRL1.Reg) & 0x800000) >> 23
}
func (o *SYSCON_Type) SetPRESETCTRL1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PRESETCTRL1.Reg, volatile.LoadUint32(&o.PRESETCTRL1.Reg)&^(0xff000000)|value<<24)
}
func (o *SYSCON_Type) GetPRESETCTRL1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PRESETCTRL1.Reg) & 0xff000000) >> 24
}

// SYSCON.PIOPORCAP0: POR captured PIO status 0
func (o *SYSCON_Type) SetPIOPORCAP0(value uint32) {
	volatile.StoreUint32(&o.PIOPORCAP0.Reg, value)
}
func (o *SYSCON_Type) GetPIOPORCAP0() uint32 {
	return volatile.LoadUint32(&o.PIOPORCAP0.Reg)
}

// SYSCON.PIOPORCAP1: POR captured PIO status 1
func (o *SYSCON_Type) SetPIOPORCAP1(value uint32) {
	volatile.StoreUint32(&o.PIOPORCAP1.Reg, value)
}
func (o *SYSCON_Type) GetPIOPORCAP1() uint32 {
	return volatile.LoadUint32(&o.PIOPORCAP1.Reg)
}

// SYSCON.PIOPORCAP2: POR captured PIO status 2
func (o *SYSCON_Type) SetPIOPORCAP2_PIOSTAT(value uint32) {
	volatile.StoreUint32(&o.PIOPORCAP2.Reg, volatile.LoadUint32(&o.PIOPORCAP2.Reg)&^(0xfff)|value)
}
func (o *SYSCON_Type) GetPIOPORCAP2_PIOSTAT() uint32 {
	return volatile.LoadUint32(&o.PIOPORCAP2.Reg) & 0xfff
}
func (o *SYSCON_Type) SetPIOPORCAP2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIOPORCAP2.Reg, volatile.LoadUint32(&o.PIOPORCAP2.Reg)&^(0xfffff000)|value<<12)
}
func (o *SYSCON_Type) GetPIOPORCAP2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIOPORCAP2.Reg) & 0xfffff000) >> 12
}

// SYSCON.MAINCLKSELA: Main clock source select A
func (o *SYSCON_Type) SetMAINCLKSELA_SEL(value uint32) {
	volatile.StoreUint32(&o.MAINCLKSELA.Reg, volatile.LoadUint32(&o.MAINCLKSELA.Reg)&^(0x3)|value)
}
func (o *SYSCON_Type) GetMAINCLKSELA_SEL() uint32 {
	return volatile.LoadUint32(&o.MAINCLKSELA.Reg) & 0x3
}
func (o *SYSCON_Type) SetMAINCLKSELA_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MAINCLKSELA.Reg, volatile.LoadUint32(&o.MAINCLKSELA.Reg)&^(0xfffffffc)|value<<2)
}
func (o *SYSCON_Type) GetMAINCLKSELA_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MAINCLKSELA.Reg) & 0xfffffffc) >> 2
}

// SYSCON.MAINCLKSELB: Main clock source select B
func (o *SYSCON_Type) SetMAINCLKSELB_SEL(value uint32) {
	volatile.StoreUint32(&o.MAINCLKSELB.Reg, volatile.LoadUint32(&o.MAINCLKSELB.Reg)&^(0x3)|value)
}
func (o *SYSCON_Type) GetMAINCLKSELB_SEL() uint32 {
	return volatile.LoadUint32(&o.MAINCLKSELB.Reg) & 0x3
}
func (o *SYSCON_Type) SetMAINCLKSELB_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MAINCLKSELB.Reg, volatile.LoadUint32(&o.MAINCLKSELB.Reg)&^(0xfffffffc)|value<<2)
}
func (o *SYSCON_Type) GetMAINCLKSELB_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MAINCLKSELB.Reg) & 0xfffffffc) >> 2
}

// SYSCON.USBCLKSEL: USB clock source select
func (o *SYSCON_Type) SetUSBCLKSEL_SEL(value uint32) {
	volatile.StoreUint32(&o.USBCLKSEL.Reg, volatile.LoadUint32(&o.USBCLKSEL.Reg)&^(0x3)|value)
}
func (o *SYSCON_Type) GetUSBCLKSEL_SEL() uint32 {
	return volatile.LoadUint32(&o.USBCLKSEL.Reg) & 0x3
}
func (o *SYSCON_Type) SetUSBCLKSEL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.USBCLKSEL.Reg, volatile.LoadUint32(&o.USBCLKSEL.Reg)&^(0xfffffffc)|value<<2)
}
func (o *SYSCON_Type) GetUSBCLKSEL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.USBCLKSEL.Reg) & 0xfffffffc) >> 2
}

// SYSCON.ADCASYNCCLKSEL: ADC asynchronous clock source select
func (o *SYSCON_Type) SetADCASYNCCLKSEL_SEL(value uint32) {
	volatile.StoreUint32(&o.ADCASYNCCLKSEL.Reg, volatile.LoadUint32(&o.ADCASYNCCLKSEL.Reg)&^(0x3)|value)
}
func (o *SYSCON_Type) GetADCASYNCCLKSEL_SEL() uint32 {
	return volatile.LoadUint32(&o.ADCASYNCCLKSEL.Reg) & 0x3
}
func (o *SYSCON_Type) SetADCASYNCCLKSEL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ADCASYNCCLKSEL.Reg, volatile.LoadUint32(&o.ADCASYNCCLKSEL.Reg)&^(0xfffffffc)|value<<2)
}
func (o *SYSCON_Type) GetADCASYNCCLKSEL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ADCASYNCCLKSEL.Reg) & 0xfffffffc) >> 2
}

// SYSCON.CLKOUTSELA: CLKOUT clock source select A
func (o *SYSCON_Type) SetCLKOUTSELA_SEL(value uint32) {
	volatile.StoreUint32(&o.CLKOUTSELA.Reg, volatile.LoadUint32(&o.CLKOUTSELA.Reg)&^(0x3)|value)
}
func (o *SYSCON_Type) GetCLKOUTSELA_SEL() uint32 {
	return volatile.LoadUint32(&o.CLKOUTSELA.Reg) & 0x3
}
func (o *SYSCON_Type) SetCLKOUTSELA_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CLKOUTSELA.Reg, volatile.LoadUint32(&o.CLKOUTSELA.Reg)&^(0xfffffffc)|value<<2)
}
func (o *SYSCON_Type) GetCLKOUTSELA_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CLKOUTSELA.Reg) & 0xfffffffc) >> 2
}

// SYSCON.CLKOUTSELB: CLKOUT clock source select B
func (o *SYSCON_Type) SetCLKOUTSELB_SEL(value uint32) {
	volatile.StoreUint32(&o.CLKOUTSELB.Reg, volatile.LoadUint32(&o.CLKOUTSELB.Reg)&^(0x3)|value)
}
func (o *SYSCON_Type) GetCLKOUTSELB_SEL() uint32 {
	return volatile.LoadUint32(&o.CLKOUTSELB.Reg) & 0x3
}
func (o *SYSCON_Type) SetCLKOUTSELB_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CLKOUTSELB.Reg, volatile.LoadUint32(&o.CLKOUTSELB.Reg)&^(0xfffffffc)|value<<2)
}
func (o *SYSCON_Type) GetCLKOUTSELB_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CLKOUTSELB.Reg) & 0xfffffffc) >> 2
}

// SYSCON.SYSPLLCLKSEL: System PLL clock source select
func (o *SYSCON_Type) SetSYSPLLCLKSEL_SEL(value uint32) {
	volatile.StoreUint32(&o.SYSPLLCLKSEL.Reg, volatile.LoadUint32(&o.SYSPLLCLKSEL.Reg)&^(0x3)|value)
}
func (o *SYSCON_Type) GetSYSPLLCLKSEL_SEL() uint32 {
	return volatile.LoadUint32(&o.SYSPLLCLKSEL.Reg) & 0x3
}
func (o *SYSCON_Type) SetSYSPLLCLKSEL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SYSPLLCLKSEL.Reg, volatile.LoadUint32(&o.SYSPLLCLKSEL.Reg)&^(0xfffffffc)|value<<2)
}
func (o *SYSCON_Type) GetSYSPLLCLKSEL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SYSPLLCLKSEL.Reg) & 0xfffffffc) >> 2
}

// SYSCON.USBPLLCLKSEL: USB PLL clock source select
func (o *SYSCON_Type) SetUSBPLLCLKSEL_SEL(value uint32) {
	volatile.StoreUint32(&o.USBPLLCLKSEL.Reg, volatile.LoadUint32(&o.USBPLLCLKSEL.Reg)&^(0x3)|value)
}
func (o *SYSCON_Type) GetUSBPLLCLKSEL_SEL() uint32 {
	return volatile.LoadUint32(&o.USBPLLCLKSEL.Reg) & 0x3
}
func (o *SYSCON_Type) SetUSBPLLCLKSEL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.USBPLLCLKSEL.Reg, volatile.LoadUint32(&o.USBPLLCLKSEL.Reg)&^(0xfffffffc)|value<<2)
}
func (o *SYSCON_Type) GetUSBPLLCLKSEL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.USBPLLCLKSEL.Reg) & 0xfffffffc) >> 2
}

// SYSCON.SCTPLLCLKSEL: SCT PLL clock source select
func (o *SYSCON_Type) SetSCTPLLCLKSEL_SEL(value uint32) {
	volatile.StoreUint32(&o.SCTPLLCLKSEL.Reg, volatile.LoadUint32(&o.SCTPLLCLKSEL.Reg)&^(0x3)|value)
}
func (o *SYSCON_Type) GetSCTPLLCLKSEL_SEL() uint32 {
	return volatile.LoadUint32(&o.SCTPLLCLKSEL.Reg) & 0x3
}
func (o *SYSCON_Type) SetSCTPLLCLKSEL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SCTPLLCLKSEL.Reg, volatile.LoadUint32(&o.SCTPLLCLKSEL.Reg)&^(0xfffffffc)|value<<2)
}
func (o *SYSCON_Type) GetSCTPLLCLKSEL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SCTPLLCLKSEL.Reg) & 0xfffffffc) >> 2
}

// SYSCON.SYSAHBCLKDIV: System clock divider
func (o *SYSCON_Type) SetSYSAHBCLKDIV_DIV(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKDIV.Reg, volatile.LoadUint32(&o.SYSAHBCLKDIV.Reg)&^(0xff)|value)
}
func (o *SYSCON_Type) GetSYSAHBCLKDIV_DIV() uint32 {
	return volatile.LoadUint32(&o.SYSAHBCLKDIV.Reg) & 0xff
}
func (o *SYSCON_Type) SetSYSAHBCLKDIV_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKDIV.Reg, volatile.LoadUint32(&o.SYSAHBCLKDIV.Reg)&^(0xffffff00)|value<<8)
}
func (o *SYSCON_Type) GetSYSAHBCLKDIV_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKDIV.Reg) & 0xffffff00) >> 8
}

// SYSCON.SYSAHBCLKCTRL0: System clock control 0
func (o *SYSCON_Type) SetSYSAHBCLKCTRL0_SYS(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL0.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL0.Reg)&^(0x1)|value)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL0_SYS() uint32 {
	return volatile.LoadUint32(&o.SYSAHBCLKCTRL0.Reg) & 0x1
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL0_ROM(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL0.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL0.Reg)&^(0x2)|value<<1)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL0_ROM() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL0.Reg) & 0x2) >> 1
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL0.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL0.Reg)&^(0x4)|value<<2)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL0.Reg) & 0x4) >> 2
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL0_SRAM1(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL0.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL0.Reg)&^(0x8)|value<<3)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL0_SRAM1() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL0.Reg) & 0x8) >> 3
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL0_SRAM2(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL0.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL0.Reg)&^(0x10)|value<<4)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL0_SRAM2() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL0.Reg) & 0x10) >> 4
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL0.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL0.Reg)&^(0x60)|value<<5)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL0.Reg) & 0x60) >> 5
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL0_FLASH(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL0.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL0.Reg)&^(0x80)|value<<7)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL0_FLASH() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL0.Reg) & 0x80) >> 7
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL0_FMC(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL0.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL0.Reg)&^(0x100)|value<<8)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL0_FMC() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL0.Reg) & 0x100) >> 8
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL0_EEPROM(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL0.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL0.Reg)&^(0x200)|value<<9)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL0_EEPROM() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL0.Reg) & 0x200) >> 9
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL0.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL0.Reg)&^(0x400)|value<<10)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL0.Reg) & 0x400) >> 10
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL0_PMUX(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL0.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL0.Reg)&^(0x800)|value<<11)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL0_PMUX() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL0.Reg) & 0x800) >> 11
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL0_SWM(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL0.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL0.Reg)&^(0x1000)|value<<12)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL0_SWM() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL0.Reg) & 0x1000) >> 12
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL0_IOCON(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL0.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL0.Reg)&^(0x2000)|value<<13)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL0_IOCON() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL0.Reg) & 0x2000) >> 13
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL0_GPIO0(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL0.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL0.Reg)&^(0x4000)|value<<14)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL0_GPIO0() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL0.Reg) & 0x4000) >> 14
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL0_GPIO1(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL0.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL0.Reg)&^(0x8000)|value<<15)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL0_GPIO1() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL0.Reg) & 0x8000) >> 15
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL0_GPIO2(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL0.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL0.Reg)&^(0x10000)|value<<16)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL0_GPIO2() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL0.Reg) & 0x10000) >> 16
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL0.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL0.Reg)&^(0x20000)|value<<17)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL0.Reg) & 0x20000) >> 17
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL0_PINT(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL0.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL0.Reg)&^(0x40000)|value<<18)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL0_PINT() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL0.Reg) & 0x40000) >> 18
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL0_GINT(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL0.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL0.Reg)&^(0x80000)|value<<19)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL0_GINT() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL0.Reg) & 0x80000) >> 19
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL0_DMA(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL0.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL0.Reg)&^(0x100000)|value<<20)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL0_DMA() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL0.Reg) & 0x100000) >> 20
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL0_CRC(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL0.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL0.Reg)&^(0x200000)|value<<21)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL0_CRC() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL0.Reg) & 0x200000) >> 21
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL0_WWDT(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL0.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL0.Reg)&^(0x400000)|value<<22)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL0_WWDT() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL0.Reg) & 0x400000) >> 22
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL0_RTC(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL0.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL0.Reg)&^(0x800000)|value<<23)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL0_RTC() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL0.Reg) & 0x800000) >> 23
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL0.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL0.Reg)&^(0x7000000)|value<<24)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL0.Reg) & 0x7000000) >> 24
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL0_ADC0(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL0.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL0.Reg)&^(0x8000000)|value<<27)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL0_ADC0() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL0.Reg) & 0x8000000) >> 27
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL0_ADC1(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL0.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL0.Reg)&^(0x10000000)|value<<28)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL0_ADC1() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL0.Reg) & 0x10000000) >> 28
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL0_DAC(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL0.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL0.Reg)&^(0x20000000)|value<<29)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL0_DAC() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL0.Reg) & 0x20000000) >> 29
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL0_CMP(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL0.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL0.Reg)&^(0x40000000)|value<<30)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL0_CMP() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL0.Reg) & 0x40000000) >> 30
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL0.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL0.Reg)&^(0x80000000)|value<<31)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL0.Reg) & 0x80000000) >> 31
}

// SYSCON.SYSAHBCLKCTRL1: System clock control 1
func (o *SYSCON_Type) SetSYSAHBCLKCTRL1_MRT(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL1.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL1.Reg)&^(0x1)|value)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL1_MRT() uint32 {
	return volatile.LoadUint32(&o.SYSAHBCLKCTRL1.Reg) & 0x1
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL1_RIT(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL1.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL1.Reg)&^(0x2)|value<<1)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL1_RIT() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL1.Reg) & 0x2) >> 1
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL1_SCT0(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL1.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL1.Reg)&^(0x4)|value<<2)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL1_SCT0() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL1.Reg) & 0x4) >> 2
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL1_SCT1(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL1.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL1.Reg)&^(0x8)|value<<3)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL1_SCT1() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL1.Reg) & 0x8) >> 3
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL1_SCT2(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL1.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL1.Reg)&^(0x10)|value<<4)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL1_SCT2() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL1.Reg) & 0x10) >> 4
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL1_SCT3(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL1.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL1.Reg)&^(0x20)|value<<5)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL1_SCT3() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL1.Reg) & 0x20) >> 5
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL1_SCTIPU(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL1.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL1.Reg)&^(0x40)|value<<6)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL1_SCTIPU() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL1.Reg) & 0x40) >> 6
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL1_CCAN(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL1.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL1.Reg)&^(0x80)|value<<7)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL1_CCAN() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL1.Reg) & 0x80) >> 7
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL1.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL1.Reg)&^(0x100)|value<<8)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL1.Reg) & 0x100) >> 8
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL1_SPI0(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL1.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL1.Reg)&^(0x200)|value<<9)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL1_SPI0() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL1.Reg) & 0x200) >> 9
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL1_SPI1(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL1.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL1.Reg)&^(0x400)|value<<10)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL1_SPI1() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL1.Reg) & 0x400) >> 10
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL1.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL1.Reg)&^(0x1800)|value<<11)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL1.Reg) & 0x1800) >> 11
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL1_I2C0(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL1.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL1.Reg)&^(0x2000)|value<<13)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL1_I2C0() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL1.Reg) & 0x2000) >> 13
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL1_I2C1(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL1.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL1.Reg)&^(0x4000)|value<<14)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL1_I2C1() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL1.Reg) & 0x4000) >> 14
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL1.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL1.Reg)&^(0x18000)|value<<15)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL1.Reg) & 0x18000) >> 15
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL1_UART0(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL1.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL1.Reg)&^(0x20000)|value<<17)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL1_UART0() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL1.Reg) & 0x20000) >> 17
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL1_UART1(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL1.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL1.Reg)&^(0x40000)|value<<18)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL1_UART1() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL1.Reg) & 0x40000) >> 18
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL1_UART2(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL1.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL1.Reg)&^(0x80000)|value<<19)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL1_UART2() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL1.Reg) & 0x80000) >> 19
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL1.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL1.Reg)&^(0x100000)|value<<20)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL1.Reg) & 0x100000) >> 20
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL1_QEI(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL1.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL1.Reg)&^(0x200000)|value<<21)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL1_QEI() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL1.Reg) & 0x200000) >> 21
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL1.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL1.Reg)&^(0x400000)|value<<22)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL1.Reg) & 0x400000) >> 22
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL1_USB(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL1.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL1.Reg)&^(0x800000)|value<<23)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL1_USB() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL1.Reg) & 0x800000) >> 23
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL1.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL1.Reg)&^(0xff000000)|value<<24)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL1.Reg) & 0xff000000) >> 24
}

// SYSCON.SYSTICKCLKDIV: SYSTICK clock divider
func (o *SYSCON_Type) SetSYSTICKCLKDIV_DIV(value uint32) {
	volatile.StoreUint32(&o.SYSTICKCLKDIV.Reg, volatile.LoadUint32(&o.SYSTICKCLKDIV.Reg)&^(0xff)|value)
}
func (o *SYSCON_Type) GetSYSTICKCLKDIV_DIV() uint32 {
	return volatile.LoadUint32(&o.SYSTICKCLKDIV.Reg) & 0xff
}
func (o *SYSCON_Type) SetSYSTICKCLKDIV_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SYSTICKCLKDIV.Reg, volatile.LoadUint32(&o.SYSTICKCLKDIV.Reg)&^(0xffffff00)|value<<8)
}
func (o *SYSCON_Type) GetSYSTICKCLKDIV_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SYSTICKCLKDIV.Reg) & 0xffffff00) >> 8
}

// SYSCON.UARTCLKDIV: USART clock divider. Clock divider for the USART fractional baud rate generator.
func (o *SYSCON_Type) SetUARTCLKDIV_DIV(value uint32) {
	volatile.StoreUint32(&o.UARTCLKDIV.Reg, volatile.LoadUint32(&o.UARTCLKDIV.Reg)&^(0xff)|value)
}
func (o *SYSCON_Type) GetUARTCLKDIV_DIV() uint32 {
	return volatile.LoadUint32(&o.UARTCLKDIV.Reg) & 0xff
}
func (o *SYSCON_Type) SetUARTCLKDIV_RESERVED(value uint32) {
	volatile.StoreUint32(&o.UARTCLKDIV.Reg, volatile.LoadUint32(&o.UARTCLKDIV.Reg)&^(0xffffff00)|value<<8)
}
func (o *SYSCON_Type) GetUARTCLKDIV_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.UARTCLKDIV.Reg) & 0xffffff00) >> 8
}

// SYSCON.IOCONCLKDIV: Peripheral clock to the IOCON block for programmable glitch filter
func (o *SYSCON_Type) SetIOCONCLKDIV_DIV(value uint32) {
	volatile.StoreUint32(&o.IOCONCLKDIV.Reg, volatile.LoadUint32(&o.IOCONCLKDIV.Reg)&^(0xff)|value)
}
func (o *SYSCON_Type) GetIOCONCLKDIV_DIV() uint32 {
	return volatile.LoadUint32(&o.IOCONCLKDIV.Reg) & 0xff
}
func (o *SYSCON_Type) SetIOCONCLKDIV_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IOCONCLKDIV.Reg, volatile.LoadUint32(&o.IOCONCLKDIV.Reg)&^(0xffffff00)|value<<8)
}
func (o *SYSCON_Type) GetIOCONCLKDIV_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IOCONCLKDIV.Reg) & 0xffffff00) >> 8
}

// SYSCON.TRACECLKDIV: ARM trace clock divider
func (o *SYSCON_Type) SetTRACECLKDIV_DIV(value uint32) {
	volatile.StoreUint32(&o.TRACECLKDIV.Reg, volatile.LoadUint32(&o.TRACECLKDIV.Reg)&^(0xff)|value)
}
func (o *SYSCON_Type) GetTRACECLKDIV_DIV() uint32 {
	return volatile.LoadUint32(&o.TRACECLKDIV.Reg) & 0xff
}
func (o *SYSCON_Type) SetTRACECLKDIV_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TRACECLKDIV.Reg, volatile.LoadUint32(&o.TRACECLKDIV.Reg)&^(0xffffff00)|value<<8)
}
func (o *SYSCON_Type) GetTRACECLKDIV_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TRACECLKDIV.Reg) & 0xffffff00) >> 8
}

// SYSCON.USBCLKDIV: USB clock divider
func (o *SYSCON_Type) SetUSBCLKDIV_DIV(value uint32) {
	volatile.StoreUint32(&o.USBCLKDIV.Reg, volatile.LoadUint32(&o.USBCLKDIV.Reg)&^(0xff)|value)
}
func (o *SYSCON_Type) GetUSBCLKDIV_DIV() uint32 {
	return volatile.LoadUint32(&o.USBCLKDIV.Reg) & 0xff
}
func (o *SYSCON_Type) SetUSBCLKDIV_RESERVED(value uint32) {
	volatile.StoreUint32(&o.USBCLKDIV.Reg, volatile.LoadUint32(&o.USBCLKDIV.Reg)&^(0xffffff00)|value<<8)
}
func (o *SYSCON_Type) GetUSBCLKDIV_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.USBCLKDIV.Reg) & 0xffffff00) >> 8
}

// SYSCON.ADCASYNCCLKDIV: Asynchronous ADC clock divider
func (o *SYSCON_Type) SetADCASYNCCLKDIV_DIV(value uint32) {
	volatile.StoreUint32(&o.ADCASYNCCLKDIV.Reg, volatile.LoadUint32(&o.ADCASYNCCLKDIV.Reg)&^(0xff)|value)
}
func (o *SYSCON_Type) GetADCASYNCCLKDIV_DIV() uint32 {
	return volatile.LoadUint32(&o.ADCASYNCCLKDIV.Reg) & 0xff
}
func (o *SYSCON_Type) SetADCASYNCCLKDIV_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ADCASYNCCLKDIV.Reg, volatile.LoadUint32(&o.ADCASYNCCLKDIV.Reg)&^(0xffffff00)|value<<8)
}
func (o *SYSCON_Type) GetADCASYNCCLKDIV_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ADCASYNCCLKDIV.Reg) & 0xffffff00) >> 8
}

// SYSCON.CLKOUTDIV: CLKOUT clock divider
func (o *SYSCON_Type) SetCLKOUTDIV_DIV(value uint32) {
	volatile.StoreUint32(&o.CLKOUTDIV.Reg, volatile.LoadUint32(&o.CLKOUTDIV.Reg)&^(0xff)|value)
}
func (o *SYSCON_Type) GetCLKOUTDIV_DIV() uint32 {
	return volatile.LoadUint32(&o.CLKOUTDIV.Reg) & 0xff
}
func (o *SYSCON_Type) SetCLKOUTDIV_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CLKOUTDIV.Reg, volatile.LoadUint32(&o.CLKOUTDIV.Reg)&^(0xffffff00)|value<<8)
}
func (o *SYSCON_Type) GetCLKOUTDIV_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CLKOUTDIV.Reg) & 0xffffff00) >> 8
}

// SYSCON.FRGCTRL: USART fractional baud rate generator control
func (o *SYSCON_Type) SetFRGCTRL_DIV(value uint32) {
	volatile.StoreUint32(&o.FRGCTRL.Reg, volatile.LoadUint32(&o.FRGCTRL.Reg)&^(0xff)|value)
}
func (o *SYSCON_Type) GetFRGCTRL_DIV() uint32 {
	return volatile.LoadUint32(&o.FRGCTRL.Reg) & 0xff
}
func (o *SYSCON_Type) SetFRGCTRL_MULT(value uint32) {
	volatile.StoreUint32(&o.FRGCTRL.Reg, volatile.LoadUint32(&o.FRGCTRL.Reg)&^(0xff00)|value<<8)
}
func (o *SYSCON_Type) GetFRGCTRL_MULT() uint32 {
	return (volatile.LoadUint32(&o.FRGCTRL.Reg) & 0xff00) >> 8
}
func (o *SYSCON_Type) SetFRGCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.FRGCTRL.Reg, volatile.LoadUint32(&o.FRGCTRL.Reg)&^(0xffff0000)|value<<16)
}
func (o *SYSCON_Type) GetFRGCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.FRGCTRL.Reg) & 0xffff0000) >> 16
}

// SYSCON.USBCLKCTRL: USB clock control
func (o *SYSCON_Type) SetUSBCLKCTRL_AP_CLK(value uint32) {
	volatile.StoreUint32(&o.USBCLKCTRL.Reg, volatile.LoadUint32(&o.USBCLKCTRL.Reg)&^(0x1)|value)
}
func (o *SYSCON_Type) GetUSBCLKCTRL_AP_CLK() uint32 {
	return volatile.LoadUint32(&o.USBCLKCTRL.Reg) & 0x1
}
func (o *SYSCON_Type) SetUSBCLKCTRL_POL_CLK(value uint32) {
	volatile.StoreUint32(&o.USBCLKCTRL.Reg, volatile.LoadUint32(&o.USBCLKCTRL.Reg)&^(0x2)|value<<1)
}
func (o *SYSCON_Type) GetUSBCLKCTRL_POL_CLK() uint32 {
	return (volatile.LoadUint32(&o.USBCLKCTRL.Reg) & 0x2) >> 1
}
func (o *SYSCON_Type) SetUSBCLKCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.USBCLKCTRL.Reg, volatile.LoadUint32(&o.USBCLKCTRL.Reg)&^(0xfffffffc)|value<<2)
}
func (o *SYSCON_Type) GetUSBCLKCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.USBCLKCTRL.Reg) & 0xfffffffc) >> 2
}

// SYSCON.USBCLKST: USB clock status
func (o *SYSCON_Type) SetUSBCLKST_NEED_CLKST(value uint32) {
	volatile.StoreUint32(&o.USBCLKST.Reg, volatile.LoadUint32(&o.USBCLKST.Reg)&^(0x1)|value)
}
func (o *SYSCON_Type) GetUSBCLKST_NEED_CLKST() uint32 {
	return volatile.LoadUint32(&o.USBCLKST.Reg) & 0x1
}
func (o *SYSCON_Type) SetUSBCLKST_RESERVED(value uint32) {
	volatile.StoreUint32(&o.USBCLKST.Reg, volatile.LoadUint32(&o.USBCLKST.Reg)&^(0xfffffffe)|value<<1)
}
func (o *SYSCON_Type) GetUSBCLKST_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.USBCLKST.Reg) & 0xfffffffe) >> 1
}

// SYSCON.BODCTRL: Brown-Out Detect
func (o *SYSCON_Type) SetBODCTRL_BODRSTLEV(value uint32) {
	volatile.StoreUint32(&o.BODCTRL.Reg, volatile.LoadUint32(&o.BODCTRL.Reg)&^(0x3)|value)
}
func (o *SYSCON_Type) GetBODCTRL_BODRSTLEV() uint32 {
	return volatile.LoadUint32(&o.BODCTRL.Reg) & 0x3
}
func (o *SYSCON_Type) SetBODCTRL_BODINTVAL(value uint32) {
	volatile.StoreUint32(&o.BODCTRL.Reg, volatile.LoadUint32(&o.BODCTRL.Reg)&^(0xc)|value<<2)
}
func (o *SYSCON_Type) GetBODCTRL_BODINTVAL() uint32 {
	return (volatile.LoadUint32(&o.BODCTRL.Reg) & 0xc) >> 2
}
func (o *SYSCON_Type) SetBODCTRL_BODRSTENA(value uint32) {
	volatile.StoreUint32(&o.BODCTRL.Reg, volatile.LoadUint32(&o.BODCTRL.Reg)&^(0x10)|value<<4)
}
func (o *SYSCON_Type) GetBODCTRL_BODRSTENA() uint32 {
	return (volatile.LoadUint32(&o.BODCTRL.Reg) & 0x10) >> 4
}
func (o *SYSCON_Type) SetBODCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.BODCTRL.Reg, volatile.LoadUint32(&o.BODCTRL.Reg)&^(0xffffffe0)|value<<5)
}
func (o *SYSCON_Type) GetBODCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.BODCTRL.Reg) & 0xffffffe0) >> 5
}

// SYSCON.SYSOSCCTRL: System oscillator control
func (o *SYSCON_Type) SetSYSOSCCTRL_BYPASS(value uint32) {
	volatile.StoreUint32(&o.SYSOSCCTRL.Reg, volatile.LoadUint32(&o.SYSOSCCTRL.Reg)&^(0x1)|value)
}
func (o *SYSCON_Type) GetSYSOSCCTRL_BYPASS() uint32 {
	return volatile.LoadUint32(&o.SYSOSCCTRL.Reg) & 0x1
}
func (o *SYSCON_Type) SetSYSOSCCTRL_FREQRANGE(value uint32) {
	volatile.StoreUint32(&o.SYSOSCCTRL.Reg, volatile.LoadUint32(&o.SYSOSCCTRL.Reg)&^(0x2)|value<<1)
}
func (o *SYSCON_Type) GetSYSOSCCTRL_FREQRANGE() uint32 {
	return (volatile.LoadUint32(&o.SYSOSCCTRL.Reg) & 0x2) >> 1
}
func (o *SYSCON_Type) SetSYSOSCCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SYSOSCCTRL.Reg, volatile.LoadUint32(&o.SYSOSCCTRL.Reg)&^(0xfffffffc)|value<<2)
}
func (o *SYSCON_Type) GetSYSOSCCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SYSOSCCTRL.Reg) & 0xfffffffc) >> 2
}

// SYSCON.RTCOSCCTRL: RTC oscillator control
func (o *SYSCON_Type) SetRTCOSCCTRL_EN(value uint32) {
	volatile.StoreUint32(&o.RTCOSCCTRL.Reg, volatile.LoadUint32(&o.RTCOSCCTRL.Reg)&^(0x1)|value)
}
func (o *SYSCON_Type) GetRTCOSCCTRL_EN() uint32 {
	return volatile.LoadUint32(&o.RTCOSCCTRL.Reg) & 0x1
}
func (o *SYSCON_Type) SetRTCOSCCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RTCOSCCTRL.Reg, volatile.LoadUint32(&o.RTCOSCCTRL.Reg)&^(0xfffffffe)|value<<1)
}
func (o *SYSCON_Type) GetRTCOSCCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.RTCOSCCTRL.Reg) & 0xfffffffe) >> 1
}

// SYSCON.SYSPLLCTRL: System PLL control
func (o *SYSCON_Type) SetSYSPLLCTRL_MSEL(value uint32) {
	volatile.StoreUint32(&o.SYSPLLCTRL.Reg, volatile.LoadUint32(&o.SYSPLLCTRL.Reg)&^(0x3f)|value)
}
func (o *SYSCON_Type) GetSYSPLLCTRL_MSEL() uint32 {
	return volatile.LoadUint32(&o.SYSPLLCTRL.Reg) & 0x3f
}
func (o *SYSCON_Type) SetSYSPLLCTRL_PSEL(value uint32) {
	volatile.StoreUint32(&o.SYSPLLCTRL.Reg, volatile.LoadUint32(&o.SYSPLLCTRL.Reg)&^(0xc0)|value<<6)
}
func (o *SYSCON_Type) GetSYSPLLCTRL_PSEL() uint32 {
	return (volatile.LoadUint32(&o.SYSPLLCTRL.Reg) & 0xc0) >> 6
}
func (o *SYSCON_Type) SetSYSPLLCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SYSPLLCTRL.Reg, volatile.LoadUint32(&o.SYSPLLCTRL.Reg)&^(0xffffff00)|value<<8)
}
func (o *SYSCON_Type) GetSYSPLLCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SYSPLLCTRL.Reg) & 0xffffff00) >> 8
}

// SYSCON.SYSPLLSTAT: System PLL status
func (o *SYSCON_Type) SetSYSPLLSTAT_LOCK(value uint32) {
	volatile.StoreUint32(&o.SYSPLLSTAT.Reg, volatile.LoadUint32(&o.SYSPLLSTAT.Reg)&^(0x1)|value)
}
func (o *SYSCON_Type) GetSYSPLLSTAT_LOCK() uint32 {
	return volatile.LoadUint32(&o.SYSPLLSTAT.Reg) & 0x1
}
func (o *SYSCON_Type) SetSYSPLLSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SYSPLLSTAT.Reg, volatile.LoadUint32(&o.SYSPLLSTAT.Reg)&^(0xfffffffe)|value<<1)
}
func (o *SYSCON_Type) GetSYSPLLSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SYSPLLSTAT.Reg) & 0xfffffffe) >> 1
}

// SYSCON.USBPLLCTRL: USB PLL control
func (o *SYSCON_Type) SetUSBPLLCTRL_MSEL(value uint32) {
	volatile.StoreUint32(&o.USBPLLCTRL.Reg, volatile.LoadUint32(&o.USBPLLCTRL.Reg)&^(0x3f)|value)
}
func (o *SYSCON_Type) GetUSBPLLCTRL_MSEL() uint32 {
	return volatile.LoadUint32(&o.USBPLLCTRL.Reg) & 0x3f
}
func (o *SYSCON_Type) SetUSBPLLCTRL_PSEL(value uint32) {
	volatile.StoreUint32(&o.USBPLLCTRL.Reg, volatile.LoadUint32(&o.USBPLLCTRL.Reg)&^(0xc0)|value<<6)
}
func (o *SYSCON_Type) GetUSBPLLCTRL_PSEL() uint32 {
	return (volatile.LoadUint32(&o.USBPLLCTRL.Reg) & 0xc0) >> 6
}
func (o *SYSCON_Type) SetUSBPLLCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.USBPLLCTRL.Reg, volatile.LoadUint32(&o.USBPLLCTRL.Reg)&^(0xffffff00)|value<<8)
}
func (o *SYSCON_Type) GetUSBPLLCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.USBPLLCTRL.Reg) & 0xffffff00) >> 8
}

// SYSCON.USBPLLSTAT: USB PLL status
func (o *SYSCON_Type) SetUSBPLLSTAT_LOCK(value uint32) {
	volatile.StoreUint32(&o.USBPLLSTAT.Reg, volatile.LoadUint32(&o.USBPLLSTAT.Reg)&^(0x1)|value)
}
func (o *SYSCON_Type) GetUSBPLLSTAT_LOCK() uint32 {
	return volatile.LoadUint32(&o.USBPLLSTAT.Reg) & 0x1
}
func (o *SYSCON_Type) SetUSBPLLSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.USBPLLSTAT.Reg, volatile.LoadUint32(&o.USBPLLSTAT.Reg)&^(0xfffffffe)|value<<1)
}
func (o *SYSCON_Type) GetUSBPLLSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.USBPLLSTAT.Reg) & 0xfffffffe) >> 1
}

// SYSCON.SCTPLLCTRL: SCT PLL control
func (o *SYSCON_Type) SetSCTPLLCTRL_MSEL(value uint32) {
	volatile.StoreUint32(&o.SCTPLLCTRL.Reg, volatile.LoadUint32(&o.SCTPLLCTRL.Reg)&^(0x3f)|value)
}
func (o *SYSCON_Type) GetSCTPLLCTRL_MSEL() uint32 {
	return volatile.LoadUint32(&o.SCTPLLCTRL.Reg) & 0x3f
}
func (o *SYSCON_Type) SetSCTPLLCTRL_PSEL(value uint32) {
	volatile.StoreUint32(&o.SCTPLLCTRL.Reg, volatile.LoadUint32(&o.SCTPLLCTRL.Reg)&^(0xc0)|value<<6)
}
func (o *SYSCON_Type) GetSCTPLLCTRL_PSEL() uint32 {
	return (volatile.LoadUint32(&o.SCTPLLCTRL.Reg) & 0xc0) >> 6
}
func (o *SYSCON_Type) SetSCTPLLCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SCTPLLCTRL.Reg, volatile.LoadUint32(&o.SCTPLLCTRL.Reg)&^(0xffffff00)|value<<8)
}
func (o *SYSCON_Type) GetSCTPLLCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SCTPLLCTRL.Reg) & 0xffffff00) >> 8
}

// SYSCON.SCTPLLSTAT: SCT PLL status
func (o *SYSCON_Type) SetSCTPLLSTAT_LOCK(value uint32) {
	volatile.StoreUint32(&o.SCTPLLSTAT.Reg, volatile.LoadUint32(&o.SCTPLLSTAT.Reg)&^(0x1)|value)
}
func (o *SYSCON_Type) GetSCTPLLSTAT_LOCK() uint32 {
	return volatile.LoadUint32(&o.SCTPLLSTAT.Reg) & 0x1
}
func (o *SYSCON_Type) SetSCTPLLSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SCTPLLSTAT.Reg, volatile.LoadUint32(&o.SCTPLLSTAT.Reg)&^(0xfffffffe)|value<<1)
}
func (o *SYSCON_Type) GetSCTPLLSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SCTPLLSTAT.Reg) & 0xfffffffe) >> 1
}

// SYSCON.PDAWAKECFG: Power-down states for wake-up from deep-sleep
func (o *SYSCON_Type) SetPDAWAKECFG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PDAWAKECFG.Reg, volatile.LoadUint32(&o.PDAWAKECFG.Reg)&^(0x7)|value)
}
func (o *SYSCON_Type) GetPDAWAKECFG_RESERVED() uint32 {
	return volatile.LoadUint32(&o.PDAWAKECFG.Reg) & 0x7
}
func (o *SYSCON_Type) SetPDAWAKECFG_IRCOUT_PD(value uint32) {
	volatile.StoreUint32(&o.PDAWAKECFG.Reg, volatile.LoadUint32(&o.PDAWAKECFG.Reg)&^(0x8)|value<<3)
}
func (o *SYSCON_Type) GetPDAWAKECFG_IRCOUT_PD() uint32 {
	return (volatile.LoadUint32(&o.PDAWAKECFG.Reg) & 0x8) >> 3
}
func (o *SYSCON_Type) SetPDAWAKECFG_IRC(value uint32) {
	volatile.StoreUint32(&o.PDAWAKECFG.Reg, volatile.LoadUint32(&o.PDAWAKECFG.Reg)&^(0x10)|value<<4)
}
func (o *SYSCON_Type) GetPDAWAKECFG_IRC() uint32 {
	return (volatile.LoadUint32(&o.PDAWAKECFG.Reg) & 0x10) >> 4
}
func (o *SYSCON_Type) SetPDAWAKECFG_FLASH(value uint32) {
	volatile.StoreUint32(&o.PDAWAKECFG.Reg, volatile.LoadUint32(&o.PDAWAKECFG.Reg)&^(0x20)|value<<5)
}
func (o *SYSCON_Type) GetPDAWAKECFG_FLASH() uint32 {
	return (volatile.LoadUint32(&o.PDAWAKECFG.Reg) & 0x20) >> 5
}
func (o *SYSCON_Type) SetPDAWAKECFG_EEPROM(value uint32) {
	volatile.StoreUint32(&o.PDAWAKECFG.Reg, volatile.LoadUint32(&o.PDAWAKECFG.Reg)&^(0x40)|value<<6)
}
func (o *SYSCON_Type) GetPDAWAKECFG_EEPROM() uint32 {
	return (volatile.LoadUint32(&o.PDAWAKECFG.Reg) & 0x40) >> 6
}
func (o *SYSCON_Type) SetPDAWAKECFG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PDAWAKECFG.Reg, volatile.LoadUint32(&o.PDAWAKECFG.Reg)&^(0x80)|value<<7)
}
func (o *SYSCON_Type) GetPDAWAKECFG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PDAWAKECFG.Reg) & 0x80) >> 7
}
func (o *SYSCON_Type) SetPDAWAKECFG_BOD_PD(value uint32) {
	volatile.StoreUint32(&o.PDAWAKECFG.Reg, volatile.LoadUint32(&o.PDAWAKECFG.Reg)&^(0x100)|value<<8)
}
func (o *SYSCON_Type) GetPDAWAKECFG_BOD_PD() uint32 {
	return (volatile.LoadUint32(&o.PDAWAKECFG.Reg) & 0x100) >> 8
}
func (o *SYSCON_Type) SetPDAWAKECFG_USBPHY_PD(value uint32) {
	volatile.StoreUint32(&o.PDAWAKECFG.Reg, volatile.LoadUint32(&o.PDAWAKECFG.Reg)&^(0x200)|value<<9)
}
func (o *SYSCON_Type) GetPDAWAKECFG_USBPHY_PD() uint32 {
	return (volatile.LoadUint32(&o.PDAWAKECFG.Reg) & 0x200) >> 9
}
func (o *SYSCON_Type) SetPDAWAKECFG_ADC0_PD(value uint32) {
	volatile.StoreUint32(&o.PDAWAKECFG.Reg, volatile.LoadUint32(&o.PDAWAKECFG.Reg)&^(0x400)|value<<10)
}
func (o *SYSCON_Type) GetPDAWAKECFG_ADC0_PD() uint32 {
	return (volatile.LoadUint32(&o.PDAWAKECFG.Reg) & 0x400) >> 10
}
func (o *SYSCON_Type) SetPDAWAKECFG_ADC1_PD(value uint32) {
	volatile.StoreUint32(&o.PDAWAKECFG.Reg, volatile.LoadUint32(&o.PDAWAKECFG.Reg)&^(0x800)|value<<11)
}
func (o *SYSCON_Type) GetPDAWAKECFG_ADC1_PD() uint32 {
	return (volatile.LoadUint32(&o.PDAWAKECFG.Reg) & 0x800) >> 11
}
func (o *SYSCON_Type) SetPDAWAKECFG_DAC_PD(value uint32) {
	volatile.StoreUint32(&o.PDAWAKECFG.Reg, volatile.LoadUint32(&o.PDAWAKECFG.Reg)&^(0x1000)|value<<12)
}
func (o *SYSCON_Type) GetPDAWAKECFG_DAC_PD() uint32 {
	return (volatile.LoadUint32(&o.PDAWAKECFG.Reg) & 0x1000) >> 12
}
func (o *SYSCON_Type) SetPDAWAKECFG_ACMP0_PD(value uint32) {
	volatile.StoreUint32(&o.PDAWAKECFG.Reg, volatile.LoadUint32(&o.PDAWAKECFG.Reg)&^(0x2000)|value<<13)
}
func (o *SYSCON_Type) GetPDAWAKECFG_ACMP0_PD() uint32 {
	return (volatile.LoadUint32(&o.PDAWAKECFG.Reg) & 0x2000) >> 13
}
func (o *SYSCON_Type) SetPDAWAKECFG_ACMP1_PD(value uint32) {
	volatile.StoreUint32(&o.PDAWAKECFG.Reg, volatile.LoadUint32(&o.PDAWAKECFG.Reg)&^(0x4000)|value<<14)
}
func (o *SYSCON_Type) GetPDAWAKECFG_ACMP1_PD() uint32 {
	return (volatile.LoadUint32(&o.PDAWAKECFG.Reg) & 0x4000) >> 14
}
func (o *SYSCON_Type) SetPDAWAKECFG_ACMP2_PD(value uint32) {
	volatile.StoreUint32(&o.PDAWAKECFG.Reg, volatile.LoadUint32(&o.PDAWAKECFG.Reg)&^(0x8000)|value<<15)
}
func (o *SYSCON_Type) GetPDAWAKECFG_ACMP2_PD() uint32 {
	return (volatile.LoadUint32(&o.PDAWAKECFG.Reg) & 0x8000) >> 15
}
func (o *SYSCON_Type) SetPDAWAKECFG_ACMP3_PD(value uint32) {
	volatile.StoreUint32(&o.PDAWAKECFG.Reg, volatile.LoadUint32(&o.PDAWAKECFG.Reg)&^(0x10000)|value<<16)
}
func (o *SYSCON_Type) GetPDAWAKECFG_ACMP3_PD() uint32 {
	return (volatile.LoadUint32(&o.PDAWAKECFG.Reg) & 0x10000) >> 16
}
func (o *SYSCON_Type) SetPDAWAKECFG_IREF_PD(value uint32) {
	volatile.StoreUint32(&o.PDAWAKECFG.Reg, volatile.LoadUint32(&o.PDAWAKECFG.Reg)&^(0x20000)|value<<17)
}
func (o *SYSCON_Type) GetPDAWAKECFG_IREF_PD() uint32 {
	return (volatile.LoadUint32(&o.PDAWAKECFG.Reg) & 0x20000) >> 17
}
func (o *SYSCON_Type) SetPDAWAKECFG_TS_PD(value uint32) {
	volatile.StoreUint32(&o.PDAWAKECFG.Reg, volatile.LoadUint32(&o.PDAWAKECFG.Reg)&^(0x40000)|value<<18)
}
func (o *SYSCON_Type) GetPDAWAKECFG_TS_PD() uint32 {
	return (volatile.LoadUint32(&o.PDAWAKECFG.Reg) & 0x40000) >> 18
}
func (o *SYSCON_Type) SetPDAWAKECFG_VDDADIV_PD(value uint32) {
	volatile.StoreUint32(&o.PDAWAKECFG.Reg, volatile.LoadUint32(&o.PDAWAKECFG.Reg)&^(0x80000)|value<<19)
}
func (o *SYSCON_Type) GetPDAWAKECFG_VDDADIV_PD() uint32 {
	return (volatile.LoadUint32(&o.PDAWAKECFG.Reg) & 0x80000) >> 19
}
func (o *SYSCON_Type) SetPDAWAKECFG_WDTOSC_PD(value uint32) {
	volatile.StoreUint32(&o.PDAWAKECFG.Reg, volatile.LoadUint32(&o.PDAWAKECFG.Reg)&^(0x100000)|value<<20)
}
func (o *SYSCON_Type) GetPDAWAKECFG_WDTOSC_PD() uint32 {
	return (volatile.LoadUint32(&o.PDAWAKECFG.Reg) & 0x100000) >> 20
}
func (o *SYSCON_Type) SetPDAWAKECFG_SYSOSC_PD(value uint32) {
	volatile.StoreUint32(&o.PDAWAKECFG.Reg, volatile.LoadUint32(&o.PDAWAKECFG.Reg)&^(0x200000)|value<<21)
}
func (o *SYSCON_Type) GetPDAWAKECFG_SYSOSC_PD() uint32 {
	return (volatile.LoadUint32(&o.PDAWAKECFG.Reg) & 0x200000) >> 21
}
func (o *SYSCON_Type) SetPDAWAKECFG_SYSPLL_PD(value uint32) {
	volatile.StoreUint32(&o.PDAWAKECFG.Reg, volatile.LoadUint32(&o.PDAWAKECFG.Reg)&^(0x400000)|value<<22)
}
func (o *SYSCON_Type) GetPDAWAKECFG_SYSPLL_PD() uint32 {
	return (volatile.LoadUint32(&o.PDAWAKECFG.Reg) & 0x400000) >> 22
}
func (o *SYSCON_Type) SetPDAWAKECFG_USBPLL_PD(value uint32) {
	volatile.StoreUint32(&o.PDAWAKECFG.Reg, volatile.LoadUint32(&o.PDAWAKECFG.Reg)&^(0x800000)|value<<23)
}
func (o *SYSCON_Type) GetPDAWAKECFG_USBPLL_PD() uint32 {
	return (volatile.LoadUint32(&o.PDAWAKECFG.Reg) & 0x800000) >> 23
}
func (o *SYSCON_Type) SetPDAWAKECFG_SCTPLL_PD(value uint32) {
	volatile.StoreUint32(&o.PDAWAKECFG.Reg, volatile.LoadUint32(&o.PDAWAKECFG.Reg)&^(0x1000000)|value<<24)
}
func (o *SYSCON_Type) GetPDAWAKECFG_SCTPLL_PD() uint32 {
	return (volatile.LoadUint32(&o.PDAWAKECFG.Reg) & 0x1000000) >> 24
}
func (o *SYSCON_Type) SetPDAWAKECFG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PDAWAKECFG.Reg, volatile.LoadUint32(&o.PDAWAKECFG.Reg)&^(0xfe000000)|value<<25)
}
func (o *SYSCON_Type) GetPDAWAKECFG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PDAWAKECFG.Reg) & 0xfe000000) >> 25
}

// SYSCON.PDRUNCFG: Power configuration register
func (o *SYSCON_Type) SetPDRUNCFG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PDRUNCFG.Reg, volatile.LoadUint32(&o.PDRUNCFG.Reg)&^(0x7)|value)
}
func (o *SYSCON_Type) GetPDRUNCFG_RESERVED() uint32 {
	return volatile.LoadUint32(&o.PDRUNCFG.Reg) & 0x7
}
func (o *SYSCON_Type) SetPDRUNCFG_IRCOUT_PD(value uint32) {
	volatile.StoreUint32(&o.PDRUNCFG.Reg, volatile.LoadUint32(&o.PDRUNCFG.Reg)&^(0x8)|value<<3)
}
func (o *SYSCON_Type) GetPDRUNCFG_IRCOUT_PD() uint32 {
	return (volatile.LoadUint32(&o.PDRUNCFG.Reg) & 0x8) >> 3
}
func (o *SYSCON_Type) SetPDRUNCFG_IRC(value uint32) {
	volatile.StoreUint32(&o.PDRUNCFG.Reg, volatile.LoadUint32(&o.PDRUNCFG.Reg)&^(0x10)|value<<4)
}
func (o *SYSCON_Type) GetPDRUNCFG_IRC() uint32 {
	return (volatile.LoadUint32(&o.PDRUNCFG.Reg) & 0x10) >> 4
}
func (o *SYSCON_Type) SetPDRUNCFG_FLASH(value uint32) {
	volatile.StoreUint32(&o.PDRUNCFG.Reg, volatile.LoadUint32(&o.PDRUNCFG.Reg)&^(0x20)|value<<5)
}
func (o *SYSCON_Type) GetPDRUNCFG_FLASH() uint32 {
	return (volatile.LoadUint32(&o.PDRUNCFG.Reg) & 0x20) >> 5
}
func (o *SYSCON_Type) SetPDRUNCFG_EEPROM(value uint32) {
	volatile.StoreUint32(&o.PDRUNCFG.Reg, volatile.LoadUint32(&o.PDRUNCFG.Reg)&^(0x40)|value<<6)
}
func (o *SYSCON_Type) GetPDRUNCFG_EEPROM() uint32 {
	return (volatile.LoadUint32(&o.PDRUNCFG.Reg) & 0x40) >> 6
}
func (o *SYSCON_Type) SetPDRUNCFG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PDRUNCFG.Reg, volatile.LoadUint32(&o.PDRUNCFG.Reg)&^(0x80)|value<<7)
}
func (o *SYSCON_Type) GetPDRUNCFG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PDRUNCFG.Reg) & 0x80) >> 7
}
func (o *SYSCON_Type) SetPDRUNCFG_BOD_PD(value uint32) {
	volatile.StoreUint32(&o.PDRUNCFG.Reg, volatile.LoadUint32(&o.PDRUNCFG.Reg)&^(0x100)|value<<8)
}
func (o *SYSCON_Type) GetPDRUNCFG_BOD_PD() uint32 {
	return (volatile.LoadUint32(&o.PDRUNCFG.Reg) & 0x100) >> 8
}
func (o *SYSCON_Type) SetPDRUNCFG_USBPHY_PD(value uint32) {
	volatile.StoreUint32(&o.PDRUNCFG.Reg, volatile.LoadUint32(&o.PDRUNCFG.Reg)&^(0x200)|value<<9)
}
func (o *SYSCON_Type) GetPDRUNCFG_USBPHY_PD() uint32 {
	return (volatile.LoadUint32(&o.PDRUNCFG.Reg) & 0x200) >> 9
}
func (o *SYSCON_Type) SetPDRUNCFG_ADC0_PD(value uint32) {
	volatile.StoreUint32(&o.PDRUNCFG.Reg, volatile.LoadUint32(&o.PDRUNCFG.Reg)&^(0x400)|value<<10)
}
func (o *SYSCON_Type) GetPDRUNCFG_ADC0_PD() uint32 {
	return (volatile.LoadUint32(&o.PDRUNCFG.Reg) & 0x400) >> 10
}
func (o *SYSCON_Type) SetPDRUNCFG_ADC1_PD(value uint32) {
	volatile.StoreUint32(&o.PDRUNCFG.Reg, volatile.LoadUint32(&o.PDRUNCFG.Reg)&^(0x800)|value<<11)
}
func (o *SYSCON_Type) GetPDRUNCFG_ADC1_PD() uint32 {
	return (volatile.LoadUint32(&o.PDRUNCFG.Reg) & 0x800) >> 11
}
func (o *SYSCON_Type) SetPDRUNCFG_DAC_PD(value uint32) {
	volatile.StoreUint32(&o.PDRUNCFG.Reg, volatile.LoadUint32(&o.PDRUNCFG.Reg)&^(0x1000)|value<<12)
}
func (o *SYSCON_Type) GetPDRUNCFG_DAC_PD() uint32 {
	return (volatile.LoadUint32(&o.PDRUNCFG.Reg) & 0x1000) >> 12
}
func (o *SYSCON_Type) SetPDRUNCFG_ACMP0_PD(value uint32) {
	volatile.StoreUint32(&o.PDRUNCFG.Reg, volatile.LoadUint32(&o.PDRUNCFG.Reg)&^(0x2000)|value<<13)
}
func (o *SYSCON_Type) GetPDRUNCFG_ACMP0_PD() uint32 {
	return (volatile.LoadUint32(&o.PDRUNCFG.Reg) & 0x2000) >> 13
}
func (o *SYSCON_Type) SetPDRUNCFG_ACMP1_PD(value uint32) {
	volatile.StoreUint32(&o.PDRUNCFG.Reg, volatile.LoadUint32(&o.PDRUNCFG.Reg)&^(0x4000)|value<<14)
}
func (o *SYSCON_Type) GetPDRUNCFG_ACMP1_PD() uint32 {
	return (volatile.LoadUint32(&o.PDRUNCFG.Reg) & 0x4000) >> 14
}
func (o *SYSCON_Type) SetPDRUNCFG_ACMP2_PD(value uint32) {
	volatile.StoreUint32(&o.PDRUNCFG.Reg, volatile.LoadUint32(&o.PDRUNCFG.Reg)&^(0x8000)|value<<15)
}
func (o *SYSCON_Type) GetPDRUNCFG_ACMP2_PD() uint32 {
	return (volatile.LoadUint32(&o.PDRUNCFG.Reg) & 0x8000) >> 15
}
func (o *SYSCON_Type) SetPDRUNCFG_ACMP3_PD(value uint32) {
	volatile.StoreUint32(&o.PDRUNCFG.Reg, volatile.LoadUint32(&o.PDRUNCFG.Reg)&^(0x10000)|value<<16)
}
func (o *SYSCON_Type) GetPDRUNCFG_ACMP3_PD() uint32 {
	return (volatile.LoadUint32(&o.PDRUNCFG.Reg) & 0x10000) >> 16
}
func (o *SYSCON_Type) SetPDRUNCFG_IREF_PD(value uint32) {
	volatile.StoreUint32(&o.PDRUNCFG.Reg, volatile.LoadUint32(&o.PDRUNCFG.Reg)&^(0x20000)|value<<17)
}
func (o *SYSCON_Type) GetPDRUNCFG_IREF_PD() uint32 {
	return (volatile.LoadUint32(&o.PDRUNCFG.Reg) & 0x20000) >> 17
}
func (o *SYSCON_Type) SetPDRUNCFG_TS_PD(value uint32) {
	volatile.StoreUint32(&o.PDRUNCFG.Reg, volatile.LoadUint32(&o.PDRUNCFG.Reg)&^(0x40000)|value<<18)
}
func (o *SYSCON_Type) GetPDRUNCFG_TS_PD() uint32 {
	return (volatile.LoadUint32(&o.PDRUNCFG.Reg) & 0x40000) >> 18
}
func (o *SYSCON_Type) SetPDRUNCFG_VDDADIV_PD(value uint32) {
	volatile.StoreUint32(&o.PDRUNCFG.Reg, volatile.LoadUint32(&o.PDRUNCFG.Reg)&^(0x80000)|value<<19)
}
func (o *SYSCON_Type) GetPDRUNCFG_VDDADIV_PD() uint32 {
	return (volatile.LoadUint32(&o.PDRUNCFG.Reg) & 0x80000) >> 19
}
func (o *SYSCON_Type) SetPDRUNCFG_WDTOSC_PD(value uint32) {
	volatile.StoreUint32(&o.PDRUNCFG.Reg, volatile.LoadUint32(&o.PDRUNCFG.Reg)&^(0x100000)|value<<20)
}
func (o *SYSCON_Type) GetPDRUNCFG_WDTOSC_PD() uint32 {
	return (volatile.LoadUint32(&o.PDRUNCFG.Reg) & 0x100000) >> 20
}
func (o *SYSCON_Type) SetPDRUNCFG_SYSOSC_PD(value uint32) {
	volatile.StoreUint32(&o.PDRUNCFG.Reg, volatile.LoadUint32(&o.PDRUNCFG.Reg)&^(0x200000)|value<<21)
}
func (o *SYSCON_Type) GetPDRUNCFG_SYSOSC_PD() uint32 {
	return (volatile.LoadUint32(&o.PDRUNCFG.Reg) & 0x200000) >> 21
}
func (o *SYSCON_Type) SetPDRUNCFG_SYSPLL_PD(value uint32) {
	volatile.StoreUint32(&o.PDRUNCFG.Reg, volatile.LoadUint32(&o.PDRUNCFG.Reg)&^(0x400000)|value<<22)
}
func (o *SYSCON_Type) GetPDRUNCFG_SYSPLL_PD() uint32 {
	return (volatile.LoadUint32(&o.PDRUNCFG.Reg) & 0x400000) >> 22
}
func (o *SYSCON_Type) SetPDRUNCFG_USBPLL_PD(value uint32) {
	volatile.StoreUint32(&o.PDRUNCFG.Reg, volatile.LoadUint32(&o.PDRUNCFG.Reg)&^(0x800000)|value<<23)
}
func (o *SYSCON_Type) GetPDRUNCFG_USBPLL_PD() uint32 {
	return (volatile.LoadUint32(&o.PDRUNCFG.Reg) & 0x800000) >> 23
}
func (o *SYSCON_Type) SetPDRUNCFG_SCTPLL_PD(value uint32) {
	volatile.StoreUint32(&o.PDRUNCFG.Reg, volatile.LoadUint32(&o.PDRUNCFG.Reg)&^(0x1000000)|value<<24)
}
func (o *SYSCON_Type) GetPDRUNCFG_SCTPLL_PD() uint32 {
	return (volatile.LoadUint32(&o.PDRUNCFG.Reg) & 0x1000000) >> 24
}
func (o *SYSCON_Type) SetPDRUNCFG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PDRUNCFG.Reg, volatile.LoadUint32(&o.PDRUNCFG.Reg)&^(0xfe000000)|value<<25)
}
func (o *SYSCON_Type) GetPDRUNCFG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PDRUNCFG.Reg) & 0xfe000000) >> 25
}

// SYSCON.STARTERP0: Start logic 0 wake-up enable register
func (o *SYSCON_Type) SetSTARTERP0_WWDT(value uint32) {
	volatile.StoreUint32(&o.STARTERP0.Reg, volatile.LoadUint32(&o.STARTERP0.Reg)&^(0x1)|value)
}
func (o *SYSCON_Type) GetSTARTERP0_WWDT() uint32 {
	return volatile.LoadUint32(&o.STARTERP0.Reg) & 0x1
}
func (o *SYSCON_Type) SetSTARTERP0_BOD(value uint32) {
	volatile.StoreUint32(&o.STARTERP0.Reg, volatile.LoadUint32(&o.STARTERP0.Reg)&^(0x2)|value<<1)
}
func (o *SYSCON_Type) GetSTARTERP0_BOD() uint32 {
	return (volatile.LoadUint32(&o.STARTERP0.Reg) & 0x2) >> 1
}
func (o *SYSCON_Type) SetSTARTERP0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STARTERP0.Reg, volatile.LoadUint32(&o.STARTERP0.Reg)&^(0x1c)|value<<2)
}
func (o *SYSCON_Type) GetSTARTERP0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STARTERP0.Reg) & 0x1c) >> 2
}
func (o *SYSCON_Type) SetSTARTERP0_GINT0(value uint32) {
	volatile.StoreUint32(&o.STARTERP0.Reg, volatile.LoadUint32(&o.STARTERP0.Reg)&^(0x20)|value<<5)
}
func (o *SYSCON_Type) GetSTARTERP0_GINT0() uint32 {
	return (volatile.LoadUint32(&o.STARTERP0.Reg) & 0x20) >> 5
}
func (o *SYSCON_Type) SetSTARTERP0_GINT1(value uint32) {
	volatile.StoreUint32(&o.STARTERP0.Reg, volatile.LoadUint32(&o.STARTERP0.Reg)&^(0x40)|value<<6)
}
func (o *SYSCON_Type) GetSTARTERP0_GINT1() uint32 {
	return (volatile.LoadUint32(&o.STARTERP0.Reg) & 0x40) >> 6
}
func (o *SYSCON_Type) SetSTARTERP0_PINT0(value uint32) {
	volatile.StoreUint32(&o.STARTERP0.Reg, volatile.LoadUint32(&o.STARTERP0.Reg)&^(0x80)|value<<7)
}
func (o *SYSCON_Type) GetSTARTERP0_PINT0() uint32 {
	return (volatile.LoadUint32(&o.STARTERP0.Reg) & 0x80) >> 7
}
func (o *SYSCON_Type) SetSTARTERP0_PINT1(value uint32) {
	volatile.StoreUint32(&o.STARTERP0.Reg, volatile.LoadUint32(&o.STARTERP0.Reg)&^(0x100)|value<<8)
}
func (o *SYSCON_Type) GetSTARTERP0_PINT1() uint32 {
	return (volatile.LoadUint32(&o.STARTERP0.Reg) & 0x100) >> 8
}
func (o *SYSCON_Type) SetSTARTERP0_PINT2(value uint32) {
	volatile.StoreUint32(&o.STARTERP0.Reg, volatile.LoadUint32(&o.STARTERP0.Reg)&^(0x200)|value<<9)
}
func (o *SYSCON_Type) GetSTARTERP0_PINT2() uint32 {
	return (volatile.LoadUint32(&o.STARTERP0.Reg) & 0x200) >> 9
}
func (o *SYSCON_Type) SetSTARTERP0_PINT3(value uint32) {
	volatile.StoreUint32(&o.STARTERP0.Reg, volatile.LoadUint32(&o.STARTERP0.Reg)&^(0x400)|value<<10)
}
func (o *SYSCON_Type) GetSTARTERP0_PINT3() uint32 {
	return (volatile.LoadUint32(&o.STARTERP0.Reg) & 0x400) >> 10
}
func (o *SYSCON_Type) SetSTARTERP0_PINT4(value uint32) {
	volatile.StoreUint32(&o.STARTERP0.Reg, volatile.LoadUint32(&o.STARTERP0.Reg)&^(0x800)|value<<11)
}
func (o *SYSCON_Type) GetSTARTERP0_PINT4() uint32 {
	return (volatile.LoadUint32(&o.STARTERP0.Reg) & 0x800) >> 11
}
func (o *SYSCON_Type) SetSTARTERP0_PINT5(value uint32) {
	volatile.StoreUint32(&o.STARTERP0.Reg, volatile.LoadUint32(&o.STARTERP0.Reg)&^(0x1000)|value<<12)
}
func (o *SYSCON_Type) GetSTARTERP0_PINT5() uint32 {
	return (volatile.LoadUint32(&o.STARTERP0.Reg) & 0x1000) >> 12
}
func (o *SYSCON_Type) SetSTARTERP0_PINT6(value uint32) {
	volatile.StoreUint32(&o.STARTERP0.Reg, volatile.LoadUint32(&o.STARTERP0.Reg)&^(0x2000)|value<<13)
}
func (o *SYSCON_Type) GetSTARTERP0_PINT6() uint32 {
	return (volatile.LoadUint32(&o.STARTERP0.Reg) & 0x2000) >> 13
}
func (o *SYSCON_Type) SetSTARTERP0_PINT7(value uint32) {
	volatile.StoreUint32(&o.STARTERP0.Reg, volatile.LoadUint32(&o.STARTERP0.Reg)&^(0x4000)|value<<14)
}
func (o *SYSCON_Type) GetSTARTERP0_PINT7() uint32 {
	return (volatile.LoadUint32(&o.STARTERP0.Reg) & 0x4000) >> 14
}
func (o *SYSCON_Type) SetSTARTERP0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STARTERP0.Reg, volatile.LoadUint32(&o.STARTERP0.Reg)&^(0x1f8000)|value<<15)
}
func (o *SYSCON_Type) GetSTARTERP0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STARTERP0.Reg) & 0x1f8000) >> 15
}
func (o *SYSCON_Type) SetSTARTERP0_USART0(value uint32) {
	volatile.StoreUint32(&o.STARTERP0.Reg, volatile.LoadUint32(&o.STARTERP0.Reg)&^(0x200000)|value<<21)
}
func (o *SYSCON_Type) GetSTARTERP0_USART0() uint32 {
	return (volatile.LoadUint32(&o.STARTERP0.Reg) & 0x200000) >> 21
}
func (o *SYSCON_Type) SetSTARTERP0_USART1(value uint32) {
	volatile.StoreUint32(&o.STARTERP0.Reg, volatile.LoadUint32(&o.STARTERP0.Reg)&^(0x400000)|value<<22)
}
func (o *SYSCON_Type) GetSTARTERP0_USART1() uint32 {
	return (volatile.LoadUint32(&o.STARTERP0.Reg) & 0x400000) >> 22
}
func (o *SYSCON_Type) SetSTARTERP0_USART2(value uint32) {
	volatile.StoreUint32(&o.STARTERP0.Reg, volatile.LoadUint32(&o.STARTERP0.Reg)&^(0x800000)|value<<23)
}
func (o *SYSCON_Type) GetSTARTERP0_USART2() uint32 {
	return (volatile.LoadUint32(&o.STARTERP0.Reg) & 0x800000) >> 23
}
func (o *SYSCON_Type) SetSTARTERP0_I2C(value uint32) {
	volatile.StoreUint32(&o.STARTERP0.Reg, volatile.LoadUint32(&o.STARTERP0.Reg)&^(0x1000000)|value<<24)
}
func (o *SYSCON_Type) GetSTARTERP0_I2C() uint32 {
	return (volatile.LoadUint32(&o.STARTERP0.Reg) & 0x1000000) >> 24
}
func (o *SYSCON_Type) SetSTARTERP0_SPI0(value uint32) {
	volatile.StoreUint32(&o.STARTERP0.Reg, volatile.LoadUint32(&o.STARTERP0.Reg)&^(0x2000000)|value<<25)
}
func (o *SYSCON_Type) GetSTARTERP0_SPI0() uint32 {
	return (volatile.LoadUint32(&o.STARTERP0.Reg) & 0x2000000) >> 25
}
func (o *SYSCON_Type) SetSTARTERP0_SPI1(value uint32) {
	volatile.StoreUint32(&o.STARTERP0.Reg, volatile.LoadUint32(&o.STARTERP0.Reg)&^(0x4000000)|value<<26)
}
func (o *SYSCON_Type) GetSTARTERP0_SPI1() uint32 {
	return (volatile.LoadUint32(&o.STARTERP0.Reg) & 0x4000000) >> 26
}
func (o *SYSCON_Type) SetSTARTERP0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STARTERP0.Reg, volatile.LoadUint32(&o.STARTERP0.Reg)&^(0x38000000)|value<<27)
}
func (o *SYSCON_Type) GetSTARTERP0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STARTERP0.Reg) & 0x38000000) >> 27
}
func (o *SYSCON_Type) SetSTARTERP0_USB_WAKEUP(value uint32) {
	volatile.StoreUint32(&o.STARTERP0.Reg, volatile.LoadUint32(&o.STARTERP0.Reg)&^(0x40000000)|value<<30)
}
func (o *SYSCON_Type) GetSTARTERP0_USB_WAKEUP() uint32 {
	return (volatile.LoadUint32(&o.STARTERP0.Reg) & 0x40000000) >> 30
}
func (o *SYSCON_Type) SetSTARTERP0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STARTERP0.Reg, volatile.LoadUint32(&o.STARTERP0.Reg)&^(0x80000000)|value<<31)
}
func (o *SYSCON_Type) GetSTARTERP0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STARTERP0.Reg) & 0x80000000) >> 31
}

// SYSCON.STARTERP1: Start logic 1 wake-up enable register
func (o *SYSCON_Type) SetSTARTERP1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STARTERP1.Reg, volatile.LoadUint32(&o.STARTERP1.Reg)&^(0xff)|value)
}
func (o *SYSCON_Type) GetSTARTERP1_RESERVED() uint32 {
	return volatile.LoadUint32(&o.STARTERP1.Reg) & 0xff
}
func (o *SYSCON_Type) SetSTARTERP1_ACMP0(value uint32) {
	volatile.StoreUint32(&o.STARTERP1.Reg, volatile.LoadUint32(&o.STARTERP1.Reg)&^(0x100)|value<<8)
}
func (o *SYSCON_Type) GetSTARTERP1_ACMP0() uint32 {
	return (volatile.LoadUint32(&o.STARTERP1.Reg) & 0x100) >> 8
}
func (o *SYSCON_Type) SetSTARTERP1_ACMP1(value uint32) {
	volatile.StoreUint32(&o.STARTERP1.Reg, volatile.LoadUint32(&o.STARTERP1.Reg)&^(0x200)|value<<9)
}
func (o *SYSCON_Type) GetSTARTERP1_ACMP1() uint32 {
	return (volatile.LoadUint32(&o.STARTERP1.Reg) & 0x200) >> 9
}
func (o *SYSCON_Type) SetSTARTERP1_ACMP2(value uint32) {
	volatile.StoreUint32(&o.STARTERP1.Reg, volatile.LoadUint32(&o.STARTERP1.Reg)&^(0x400)|value<<10)
}
func (o *SYSCON_Type) GetSTARTERP1_ACMP2() uint32 {
	return (volatile.LoadUint32(&o.STARTERP1.Reg) & 0x400) >> 10
}
func (o *SYSCON_Type) SetSTARTERP1_ACMP3(value uint32) {
	volatile.StoreUint32(&o.STARTERP1.Reg, volatile.LoadUint32(&o.STARTERP1.Reg)&^(0x800)|value<<11)
}
func (o *SYSCON_Type) GetSTARTERP1_ACMP3() uint32 {
	return (volatile.LoadUint32(&o.STARTERP1.Reg) & 0x800) >> 11
}
func (o *SYSCON_Type) SetSTARTERP1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STARTERP1.Reg, volatile.LoadUint32(&o.STARTERP1.Reg)&^(0x1000)|value<<12)
}
func (o *SYSCON_Type) GetSTARTERP1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STARTERP1.Reg) & 0x1000) >> 12
}
func (o *SYSCON_Type) SetSTARTERP1_RTCALARM(value uint32) {
	volatile.StoreUint32(&o.STARTERP1.Reg, volatile.LoadUint32(&o.STARTERP1.Reg)&^(0x2000)|value<<13)
}
func (o *SYSCON_Type) GetSTARTERP1_RTCALARM() uint32 {
	return (volatile.LoadUint32(&o.STARTERP1.Reg) & 0x2000) >> 13
}
func (o *SYSCON_Type) SetSTARTERP1_RTCWAKE(value uint32) {
	volatile.StoreUint32(&o.STARTERP1.Reg, volatile.LoadUint32(&o.STARTERP1.Reg)&^(0x4000)|value<<14)
}
func (o *SYSCON_Type) GetSTARTERP1_RTCWAKE() uint32 {
	return (volatile.LoadUint32(&o.STARTERP1.Reg) & 0x4000) >> 14
}
func (o *SYSCON_Type) SetSTARTERP1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STARTERP1.Reg, volatile.LoadUint32(&o.STARTERP1.Reg)&^(0xffff8000)|value<<15)
}
func (o *SYSCON_Type) GetSTARTERP1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STARTERP1.Reg) & 0xffff8000) >> 15
}

// Multi-Rate Timer (MRT)
type MRT_Type struct {
	INTVAL0  volatile.Register32 // 0x0
	TIMER0   volatile.Register32 // 0x4
	CTRL0    volatile.Register32 // 0x8
	STAT0    volatile.Register32 // 0xC
	INTVAL1  volatile.Register32 // 0x10
	TIMER1   volatile.Register32 // 0x14
	CTRL1    volatile.Register32 // 0x18
	STAT1    volatile.Register32 // 0x1C
	INTVAL2  volatile.Register32 // 0x20
	TIMER2   volatile.Register32 // 0x24
	CTRL2    volatile.Register32 // 0x28
	STAT2    volatile.Register32 // 0x2C
	INTVAL3  volatile.Register32 // 0x30
	TIMER3   volatile.Register32 // 0x34
	CTRL3    volatile.Register32 // 0x38
	STAT3    volatile.Register32 // 0x3C
	_        [180]byte
	IDLE_CH  volatile.Register32 // 0xF4
	IRQ_FLAG volatile.Register32 // 0xF8
}

// MRT.INTVAL0: MRT0 Time interval value register. This value is loaded into the TIMER0 register.
func (o *MRT_Type) SetINTVAL0_IVALUE(value uint32) {
	volatile.StoreUint32(&o.INTVAL0.Reg, volatile.LoadUint32(&o.INTVAL0.Reg)&^(0xffffff)|value)
}
func (o *MRT_Type) GetINTVAL0_IVALUE() uint32 {
	return volatile.LoadUint32(&o.INTVAL0.Reg) & 0xffffff
}
func (o *MRT_Type) SetINTVAL0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTVAL0.Reg, volatile.LoadUint32(&o.INTVAL0.Reg)&^(0x7f000000)|value<<24)
}
func (o *MRT_Type) GetINTVAL0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTVAL0.Reg) & 0x7f000000) >> 24
}
func (o *MRT_Type) SetINTVAL0_LOAD(value uint32) {
	volatile.StoreUint32(&o.INTVAL0.Reg, volatile.LoadUint32(&o.INTVAL0.Reg)&^(0x80000000)|value<<31)
}
func (o *MRT_Type) GetINTVAL0_LOAD() uint32 {
	return (volatile.LoadUint32(&o.INTVAL0.Reg) & 0x80000000) >> 31
}

// MRT.TIMER0: MRT0 Timer register. This register reads the value of the down-counter.
func (o *MRT_Type) SetTIMER0_VALUE(value uint32) {
	volatile.StoreUint32(&o.TIMER0.Reg, volatile.LoadUint32(&o.TIMER0.Reg)&^(0xffffff)|value)
}
func (o *MRT_Type) GetTIMER0_VALUE() uint32 {
	return volatile.LoadUint32(&o.TIMER0.Reg) & 0xffffff
}
func (o *MRT_Type) SetTIMER0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TIMER0.Reg, volatile.LoadUint32(&o.TIMER0.Reg)&^(0xff000000)|value<<24)
}
func (o *MRT_Type) GetTIMER0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TIMER0.Reg) & 0xff000000) >> 24
}

// MRT.CTRL0: MRT0 Control register. This register controls the MRT0 modes.
func (o *MRT_Type) SetCTRL0_INTEN(value uint32) {
	volatile.StoreUint32(&o.CTRL0.Reg, volatile.LoadUint32(&o.CTRL0.Reg)&^(0x1)|value)
}
func (o *MRT_Type) GetCTRL0_INTEN() uint32 {
	return volatile.LoadUint32(&o.CTRL0.Reg) & 0x1
}
func (o *MRT_Type) SetCTRL0_MODE(value uint32) {
	volatile.StoreUint32(&o.CTRL0.Reg, volatile.LoadUint32(&o.CTRL0.Reg)&^(0x6)|value<<1)
}
func (o *MRT_Type) GetCTRL0_MODE() uint32 {
	return (volatile.LoadUint32(&o.CTRL0.Reg) & 0x6) >> 1
}
func (o *MRT_Type) SetCTRL0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTRL0.Reg, volatile.LoadUint32(&o.CTRL0.Reg)&^(0xfffffff8)|value<<3)
}
func (o *MRT_Type) GetCTRL0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTRL0.Reg) & 0xfffffff8) >> 3
}

// MRT.STAT0: MRT0 Status register.
func (o *MRT_Type) SetSTAT0_INTFLAG(value uint32) {
	volatile.StoreUint32(&o.STAT0.Reg, volatile.LoadUint32(&o.STAT0.Reg)&^(0x1)|value)
}
func (o *MRT_Type) GetSTAT0_INTFLAG() uint32 {
	return volatile.LoadUint32(&o.STAT0.Reg) & 0x1
}
func (o *MRT_Type) SetSTAT0_RUN(value uint32) {
	volatile.StoreUint32(&o.STAT0.Reg, volatile.LoadUint32(&o.STAT0.Reg)&^(0x2)|value<<1)
}
func (o *MRT_Type) GetSTAT0_RUN() uint32 {
	return (volatile.LoadUint32(&o.STAT0.Reg) & 0x2) >> 1
}
func (o *MRT_Type) SetSTAT0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STAT0.Reg, volatile.LoadUint32(&o.STAT0.Reg)&^(0xfffffffc)|value<<2)
}
func (o *MRT_Type) GetSTAT0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STAT0.Reg) & 0xfffffffc) >> 2
}

// MRT.INTVAL1: MRT0 Time interval value register. This value is loaded into the TIMER0 register.
func (o *MRT_Type) SetINTVAL1_IVALUE(value uint32) {
	volatile.StoreUint32(&o.INTVAL1.Reg, volatile.LoadUint32(&o.INTVAL1.Reg)&^(0xffffff)|value)
}
func (o *MRT_Type) GetINTVAL1_IVALUE() uint32 {
	return volatile.LoadUint32(&o.INTVAL1.Reg) & 0xffffff
}
func (o *MRT_Type) SetINTVAL1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTVAL1.Reg, volatile.LoadUint32(&o.INTVAL1.Reg)&^(0x7f000000)|value<<24)
}
func (o *MRT_Type) GetINTVAL1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTVAL1.Reg) & 0x7f000000) >> 24
}
func (o *MRT_Type) SetINTVAL1_LOAD(value uint32) {
	volatile.StoreUint32(&o.INTVAL1.Reg, volatile.LoadUint32(&o.INTVAL1.Reg)&^(0x80000000)|value<<31)
}
func (o *MRT_Type) GetINTVAL1_LOAD() uint32 {
	return (volatile.LoadUint32(&o.INTVAL1.Reg) & 0x80000000) >> 31
}

// MRT.TIMER1: MRT0 Timer register. This register reads the value of the down-counter.
func (o *MRT_Type) SetTIMER1_VALUE(value uint32) {
	volatile.StoreUint32(&o.TIMER1.Reg, volatile.LoadUint32(&o.TIMER1.Reg)&^(0xffffff)|value)
}
func (o *MRT_Type) GetTIMER1_VALUE() uint32 {
	return volatile.LoadUint32(&o.TIMER1.Reg) & 0xffffff
}
func (o *MRT_Type) SetTIMER1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TIMER1.Reg, volatile.LoadUint32(&o.TIMER1.Reg)&^(0xff000000)|value<<24)
}
func (o *MRT_Type) GetTIMER1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TIMER1.Reg) & 0xff000000) >> 24
}

// MRT.CTRL1: MRT0 Control register. This register controls the MRT0 modes.
func (o *MRT_Type) SetCTRL1_INTEN(value uint32) {
	volatile.StoreUint32(&o.CTRL1.Reg, volatile.LoadUint32(&o.CTRL1.Reg)&^(0x1)|value)
}
func (o *MRT_Type) GetCTRL1_INTEN() uint32 {
	return volatile.LoadUint32(&o.CTRL1.Reg) & 0x1
}
func (o *MRT_Type) SetCTRL1_MODE(value uint32) {
	volatile.StoreUint32(&o.CTRL1.Reg, volatile.LoadUint32(&o.CTRL1.Reg)&^(0x6)|value<<1)
}
func (o *MRT_Type) GetCTRL1_MODE() uint32 {
	return (volatile.LoadUint32(&o.CTRL1.Reg) & 0x6) >> 1
}
func (o *MRT_Type) SetCTRL1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTRL1.Reg, volatile.LoadUint32(&o.CTRL1.Reg)&^(0xfffffff8)|value<<3)
}
func (o *MRT_Type) GetCTRL1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTRL1.Reg) & 0xfffffff8) >> 3
}

// MRT.STAT1: MRT0 Status register.
func (o *MRT_Type) SetSTAT1_INTFLAG(value uint32) {
	volatile.StoreUint32(&o.STAT1.Reg, volatile.LoadUint32(&o.STAT1.Reg)&^(0x1)|value)
}
func (o *MRT_Type) GetSTAT1_INTFLAG() uint32 {
	return volatile.LoadUint32(&o.STAT1.Reg) & 0x1
}
func (o *MRT_Type) SetSTAT1_RUN(value uint32) {
	volatile.StoreUint32(&o.STAT1.Reg, volatile.LoadUint32(&o.STAT1.Reg)&^(0x2)|value<<1)
}
func (o *MRT_Type) GetSTAT1_RUN() uint32 {
	return (volatile.LoadUint32(&o.STAT1.Reg) & 0x2) >> 1
}
func (o *MRT_Type) SetSTAT1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STAT1.Reg, volatile.LoadUint32(&o.STAT1.Reg)&^(0xfffffffc)|value<<2)
}
func (o *MRT_Type) GetSTAT1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STAT1.Reg) & 0xfffffffc) >> 2
}

// MRT.INTVAL2: MRT0 Time interval value register. This value is loaded into the TIMER0 register.
func (o *MRT_Type) SetINTVAL2_IVALUE(value uint32) {
	volatile.StoreUint32(&o.INTVAL2.Reg, volatile.LoadUint32(&o.INTVAL2.Reg)&^(0xffffff)|value)
}
func (o *MRT_Type) GetINTVAL2_IVALUE() uint32 {
	return volatile.LoadUint32(&o.INTVAL2.Reg) & 0xffffff
}
func (o *MRT_Type) SetINTVAL2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTVAL2.Reg, volatile.LoadUint32(&o.INTVAL2.Reg)&^(0x7f000000)|value<<24)
}
func (o *MRT_Type) GetINTVAL2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTVAL2.Reg) & 0x7f000000) >> 24
}
func (o *MRT_Type) SetINTVAL2_LOAD(value uint32) {
	volatile.StoreUint32(&o.INTVAL2.Reg, volatile.LoadUint32(&o.INTVAL2.Reg)&^(0x80000000)|value<<31)
}
func (o *MRT_Type) GetINTVAL2_LOAD() uint32 {
	return (volatile.LoadUint32(&o.INTVAL2.Reg) & 0x80000000) >> 31
}

// MRT.TIMER2: MRT0 Timer register. This register reads the value of the down-counter.
func (o *MRT_Type) SetTIMER2_VALUE(value uint32) {
	volatile.StoreUint32(&o.TIMER2.Reg, volatile.LoadUint32(&o.TIMER2.Reg)&^(0xffffff)|value)
}
func (o *MRT_Type) GetTIMER2_VALUE() uint32 {
	return volatile.LoadUint32(&o.TIMER2.Reg) & 0xffffff
}
func (o *MRT_Type) SetTIMER2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TIMER2.Reg, volatile.LoadUint32(&o.TIMER2.Reg)&^(0xff000000)|value<<24)
}
func (o *MRT_Type) GetTIMER2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TIMER2.Reg) & 0xff000000) >> 24
}

// MRT.CTRL2: MRT0 Control register. This register controls the MRT0 modes.
func (o *MRT_Type) SetCTRL2_INTEN(value uint32) {
	volatile.StoreUint32(&o.CTRL2.Reg, volatile.LoadUint32(&o.CTRL2.Reg)&^(0x1)|value)
}
func (o *MRT_Type) GetCTRL2_INTEN() uint32 {
	return volatile.LoadUint32(&o.CTRL2.Reg) & 0x1
}
func (o *MRT_Type) SetCTRL2_MODE(value uint32) {
	volatile.StoreUint32(&o.CTRL2.Reg, volatile.LoadUint32(&o.CTRL2.Reg)&^(0x6)|value<<1)
}
func (o *MRT_Type) GetCTRL2_MODE() uint32 {
	return (volatile.LoadUint32(&o.CTRL2.Reg) & 0x6) >> 1
}
func (o *MRT_Type) SetCTRL2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTRL2.Reg, volatile.LoadUint32(&o.CTRL2.Reg)&^(0xfffffff8)|value<<3)
}
func (o *MRT_Type) GetCTRL2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTRL2.Reg) & 0xfffffff8) >> 3
}

// MRT.STAT2: MRT0 Status register.
func (o *MRT_Type) SetSTAT2_INTFLAG(value uint32) {
	volatile.StoreUint32(&o.STAT2.Reg, volatile.LoadUint32(&o.STAT2.Reg)&^(0x1)|value)
}
func (o *MRT_Type) GetSTAT2_INTFLAG() uint32 {
	return volatile.LoadUint32(&o.STAT2.Reg) & 0x1
}
func (o *MRT_Type) SetSTAT2_RUN(value uint32) {
	volatile.StoreUint32(&o.STAT2.Reg, volatile.LoadUint32(&o.STAT2.Reg)&^(0x2)|value<<1)
}
func (o *MRT_Type) GetSTAT2_RUN() uint32 {
	return (volatile.LoadUint32(&o.STAT2.Reg) & 0x2) >> 1
}
func (o *MRT_Type) SetSTAT2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STAT2.Reg, volatile.LoadUint32(&o.STAT2.Reg)&^(0xfffffffc)|value<<2)
}
func (o *MRT_Type) GetSTAT2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STAT2.Reg) & 0xfffffffc) >> 2
}

// MRT.INTVAL3: MRT0 Time interval value register. This value is loaded into the TIMER0 register.
func (o *MRT_Type) SetINTVAL3_IVALUE(value uint32) {
	volatile.StoreUint32(&o.INTVAL3.Reg, volatile.LoadUint32(&o.INTVAL3.Reg)&^(0xffffff)|value)
}
func (o *MRT_Type) GetINTVAL3_IVALUE() uint32 {
	return volatile.LoadUint32(&o.INTVAL3.Reg) & 0xffffff
}
func (o *MRT_Type) SetINTVAL3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTVAL3.Reg, volatile.LoadUint32(&o.INTVAL3.Reg)&^(0x7f000000)|value<<24)
}
func (o *MRT_Type) GetINTVAL3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTVAL3.Reg) & 0x7f000000) >> 24
}
func (o *MRT_Type) SetINTVAL3_LOAD(value uint32) {
	volatile.StoreUint32(&o.INTVAL3.Reg, volatile.LoadUint32(&o.INTVAL3.Reg)&^(0x80000000)|value<<31)
}
func (o *MRT_Type) GetINTVAL3_LOAD() uint32 {
	return (volatile.LoadUint32(&o.INTVAL3.Reg) & 0x80000000) >> 31
}

// MRT.TIMER3: MRT0 Timer register. This register reads the value of the down-counter.
func (o *MRT_Type) SetTIMER3_VALUE(value uint32) {
	volatile.StoreUint32(&o.TIMER3.Reg, volatile.LoadUint32(&o.TIMER3.Reg)&^(0xffffff)|value)
}
func (o *MRT_Type) GetTIMER3_VALUE() uint32 {
	return volatile.LoadUint32(&o.TIMER3.Reg) & 0xffffff
}
func (o *MRT_Type) SetTIMER3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TIMER3.Reg, volatile.LoadUint32(&o.TIMER3.Reg)&^(0xff000000)|value<<24)
}
func (o *MRT_Type) GetTIMER3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TIMER3.Reg) & 0xff000000) >> 24
}

// MRT.CTRL3: MRT0 Control register. This register controls the MRT0 modes.
func (o *MRT_Type) SetCTRL3_INTEN(value uint32) {
	volatile.StoreUint32(&o.CTRL3.Reg, volatile.LoadUint32(&o.CTRL3.Reg)&^(0x1)|value)
}
func (o *MRT_Type) GetCTRL3_INTEN() uint32 {
	return volatile.LoadUint32(&o.CTRL3.Reg) & 0x1
}
func (o *MRT_Type) SetCTRL3_MODE(value uint32) {
	volatile.StoreUint32(&o.CTRL3.Reg, volatile.LoadUint32(&o.CTRL3.Reg)&^(0x6)|value<<1)
}
func (o *MRT_Type) GetCTRL3_MODE() uint32 {
	return (volatile.LoadUint32(&o.CTRL3.Reg) & 0x6) >> 1
}
func (o *MRT_Type) SetCTRL3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTRL3.Reg, volatile.LoadUint32(&o.CTRL3.Reg)&^(0xfffffff8)|value<<3)
}
func (o *MRT_Type) GetCTRL3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTRL3.Reg) & 0xfffffff8) >> 3
}

// MRT.STAT3: MRT0 Status register.
func (o *MRT_Type) SetSTAT3_INTFLAG(value uint32) {
	volatile.StoreUint32(&o.STAT3.Reg, volatile.LoadUint32(&o.STAT3.Reg)&^(0x1)|value)
}
func (o *MRT_Type) GetSTAT3_INTFLAG() uint32 {
	return volatile.LoadUint32(&o.STAT3.Reg) & 0x1
}
func (o *MRT_Type) SetSTAT3_RUN(value uint32) {
	volatile.StoreUint32(&o.STAT3.Reg, volatile.LoadUint32(&o.STAT3.Reg)&^(0x2)|value<<1)
}
func (o *MRT_Type) GetSTAT3_RUN() uint32 {
	return (volatile.LoadUint32(&o.STAT3.Reg) & 0x2) >> 1
}
func (o *MRT_Type) SetSTAT3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STAT3.Reg, volatile.LoadUint32(&o.STAT3.Reg)&^(0xfffffffc)|value<<2)
}
func (o *MRT_Type) GetSTAT3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STAT3.Reg) & 0xfffffffc) >> 2
}

// MRT.IDLE_CH: Idle channel register. This register returns the number of the first idle channel.
func (o *MRT_Type) SetIDLE_CH_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IDLE_CH.Reg, volatile.LoadUint32(&o.IDLE_CH.Reg)&^(0xf)|value)
}
func (o *MRT_Type) GetIDLE_CH_RESERVED() uint32 {
	return volatile.LoadUint32(&o.IDLE_CH.Reg) & 0xf
}
func (o *MRT_Type) SetIDLE_CH_CHAN(value uint32) {
	volatile.StoreUint32(&o.IDLE_CH.Reg, volatile.LoadUint32(&o.IDLE_CH.Reg)&^(0xf0)|value<<4)
}
func (o *MRT_Type) GetIDLE_CH_CHAN() uint32 {
	return (volatile.LoadUint32(&o.IDLE_CH.Reg) & 0xf0) >> 4
}
func (o *MRT_Type) SetIDLE_CH_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IDLE_CH.Reg, volatile.LoadUint32(&o.IDLE_CH.Reg)&^(0xffffff00)|value<<8)
}
func (o *MRT_Type) GetIDLE_CH_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IDLE_CH.Reg) & 0xffffff00) >> 8
}

// MRT.IRQ_FLAG: Global interrupt flag register
func (o *MRT_Type) SetIRQ_FLAG_GFLAG0(value uint32) {
	volatile.StoreUint32(&o.IRQ_FLAG.Reg, volatile.LoadUint32(&o.IRQ_FLAG.Reg)&^(0x1)|value)
}
func (o *MRT_Type) GetIRQ_FLAG_GFLAG0() uint32 {
	return volatile.LoadUint32(&o.IRQ_FLAG.Reg) & 0x1
}
func (o *MRT_Type) SetIRQ_FLAG_GFLAG1(value uint32) {
	volatile.StoreUint32(&o.IRQ_FLAG.Reg, volatile.LoadUint32(&o.IRQ_FLAG.Reg)&^(0x2)|value<<1)
}
func (o *MRT_Type) GetIRQ_FLAG_GFLAG1() uint32 {
	return (volatile.LoadUint32(&o.IRQ_FLAG.Reg) & 0x2) >> 1
}
func (o *MRT_Type) SetIRQ_FLAG_GFLAG2(value uint32) {
	volatile.StoreUint32(&o.IRQ_FLAG.Reg, volatile.LoadUint32(&o.IRQ_FLAG.Reg)&^(0x4)|value<<2)
}
func (o *MRT_Type) GetIRQ_FLAG_GFLAG2() uint32 {
	return (volatile.LoadUint32(&o.IRQ_FLAG.Reg) & 0x4) >> 2
}
func (o *MRT_Type) SetIRQ_FLAG_GFLAG3(value uint32) {
	volatile.StoreUint32(&o.IRQ_FLAG.Reg, volatile.LoadUint32(&o.IRQ_FLAG.Reg)&^(0x8)|value<<3)
}
func (o *MRT_Type) GetIRQ_FLAG_GFLAG3() uint32 {
	return (volatile.LoadUint32(&o.IRQ_FLAG.Reg) & 0x8) >> 3
}
func (o *MRT_Type) SetIRQ_FLAG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IRQ_FLAG.Reg, volatile.LoadUint32(&o.IRQ_FLAG.Reg)&^(0xfffffff0)|value<<4)
}
func (o *MRT_Type) GetIRQ_FLAG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IRQ_FLAG.Reg) & 0xfffffff0) >> 4
}

// Pin interrupt and pattern match (PINT)
type PINT_Type struct {
	ISEL   volatile.Register32 // 0x0
	IENR   volatile.Register32 // 0x4
	SIENR  volatile.Register32 // 0x8
	CIENR  volatile.Register32 // 0xC
	IENF   volatile.Register32 // 0x10
	SIENF  volatile.Register32 // 0x14
	CIENF  volatile.Register32 // 0x18
	RISE   volatile.Register32 // 0x1C
	FALL   volatile.Register32 // 0x20
	IST    volatile.Register32 // 0x24
	PMCTRL volatile.Register32 // 0x28
	PMSRC  volatile.Register32 // 0x2C
	PMCFG  volatile.Register32 // 0x30
}

// PINT.ISEL: Pin Interrupt Mode register
func (o *PINT_Type) SetISEL_PMODE0(value uint32) {
	volatile.StoreUint32(&o.ISEL.Reg, volatile.LoadUint32(&o.ISEL.Reg)&^(0x1)|value)
}
func (o *PINT_Type) GetISEL_PMODE0() uint32 {
	return volatile.LoadUint32(&o.ISEL.Reg) & 0x1
}
func (o *PINT_Type) SetISEL_PMODE1(value uint32) {
	volatile.StoreUint32(&o.ISEL.Reg, volatile.LoadUint32(&o.ISEL.Reg)&^(0x2)|value<<1)
}
func (o *PINT_Type) GetISEL_PMODE1() uint32 {
	return (volatile.LoadUint32(&o.ISEL.Reg) & 0x2) >> 1
}
func (o *PINT_Type) SetISEL_PMODE2(value uint32) {
	volatile.StoreUint32(&o.ISEL.Reg, volatile.LoadUint32(&o.ISEL.Reg)&^(0x4)|value<<2)
}
func (o *PINT_Type) GetISEL_PMODE2() uint32 {
	return (volatile.LoadUint32(&o.ISEL.Reg) & 0x4) >> 2
}
func (o *PINT_Type) SetISEL_PMODE3(value uint32) {
	volatile.StoreUint32(&o.ISEL.Reg, volatile.LoadUint32(&o.ISEL.Reg)&^(0x8)|value<<3)
}
func (o *PINT_Type) GetISEL_PMODE3() uint32 {
	return (volatile.LoadUint32(&o.ISEL.Reg) & 0x8) >> 3
}
func (o *PINT_Type) SetISEL_PMODE4(value uint32) {
	volatile.StoreUint32(&o.ISEL.Reg, volatile.LoadUint32(&o.ISEL.Reg)&^(0x10)|value<<4)
}
func (o *PINT_Type) GetISEL_PMODE4() uint32 {
	return (volatile.LoadUint32(&o.ISEL.Reg) & 0x10) >> 4
}
func (o *PINT_Type) SetISEL_PMODE5(value uint32) {
	volatile.StoreUint32(&o.ISEL.Reg, volatile.LoadUint32(&o.ISEL.Reg)&^(0x20)|value<<5)
}
func (o *PINT_Type) GetISEL_PMODE5() uint32 {
	return (volatile.LoadUint32(&o.ISEL.Reg) & 0x20) >> 5
}
func (o *PINT_Type) SetISEL_PMODE6(value uint32) {
	volatile.StoreUint32(&o.ISEL.Reg, volatile.LoadUint32(&o.ISEL.Reg)&^(0x40)|value<<6)
}
func (o *PINT_Type) GetISEL_PMODE6() uint32 {
	return (volatile.LoadUint32(&o.ISEL.Reg) & 0x40) >> 6
}
func (o *PINT_Type) SetISEL_PMODE7(value uint32) {
	volatile.StoreUint32(&o.ISEL.Reg, volatile.LoadUint32(&o.ISEL.Reg)&^(0x80)|value<<7)
}
func (o *PINT_Type) GetISEL_PMODE7() uint32 {
	return (volatile.LoadUint32(&o.ISEL.Reg) & 0x80) >> 7
}
func (o *PINT_Type) SetISEL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ISEL.Reg, volatile.LoadUint32(&o.ISEL.Reg)&^(0xffffff00)|value<<8)
}
func (o *PINT_Type) GetISEL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ISEL.Reg) & 0xffffff00) >> 8
}

// PINT.IENR: Pin interrupt level or rising edge interrupt enable register
func (o *PINT_Type) SetIENR_ENRL0(value uint32) {
	volatile.StoreUint32(&o.IENR.Reg, volatile.LoadUint32(&o.IENR.Reg)&^(0x1)|value)
}
func (o *PINT_Type) GetIENR_ENRL0() uint32 {
	return volatile.LoadUint32(&o.IENR.Reg) & 0x1
}
func (o *PINT_Type) SetIENR_ENRL1(value uint32) {
	volatile.StoreUint32(&o.IENR.Reg, volatile.LoadUint32(&o.IENR.Reg)&^(0x2)|value<<1)
}
func (o *PINT_Type) GetIENR_ENRL1() uint32 {
	return (volatile.LoadUint32(&o.IENR.Reg) & 0x2) >> 1
}
func (o *PINT_Type) SetIENR_ENRL2(value uint32) {
	volatile.StoreUint32(&o.IENR.Reg, volatile.LoadUint32(&o.IENR.Reg)&^(0x4)|value<<2)
}
func (o *PINT_Type) GetIENR_ENRL2() uint32 {
	return (volatile.LoadUint32(&o.IENR.Reg) & 0x4) >> 2
}
func (o *PINT_Type) SetIENR_ENRL3(value uint32) {
	volatile.StoreUint32(&o.IENR.Reg, volatile.LoadUint32(&o.IENR.Reg)&^(0x8)|value<<3)
}
func (o *PINT_Type) GetIENR_ENRL3() uint32 {
	return (volatile.LoadUint32(&o.IENR.Reg) & 0x8) >> 3
}
func (o *PINT_Type) SetIENR_ENRL4(value uint32) {
	volatile.StoreUint32(&o.IENR.Reg, volatile.LoadUint32(&o.IENR.Reg)&^(0x10)|value<<4)
}
func (o *PINT_Type) GetIENR_ENRL4() uint32 {
	return (volatile.LoadUint32(&o.IENR.Reg) & 0x10) >> 4
}
func (o *PINT_Type) SetIENR_ENRL5(value uint32) {
	volatile.StoreUint32(&o.IENR.Reg, volatile.LoadUint32(&o.IENR.Reg)&^(0x20)|value<<5)
}
func (o *PINT_Type) GetIENR_ENRL5() uint32 {
	return (volatile.LoadUint32(&o.IENR.Reg) & 0x20) >> 5
}
func (o *PINT_Type) SetIENR_ENRL6(value uint32) {
	volatile.StoreUint32(&o.IENR.Reg, volatile.LoadUint32(&o.IENR.Reg)&^(0x40)|value<<6)
}
func (o *PINT_Type) GetIENR_ENRL6() uint32 {
	return (volatile.LoadUint32(&o.IENR.Reg) & 0x40) >> 6
}
func (o *PINT_Type) SetIENR_ENRL7(value uint32) {
	volatile.StoreUint32(&o.IENR.Reg, volatile.LoadUint32(&o.IENR.Reg)&^(0x80)|value<<7)
}
func (o *PINT_Type) GetIENR_ENRL7() uint32 {
	return (volatile.LoadUint32(&o.IENR.Reg) & 0x80) >> 7
}
func (o *PINT_Type) SetIENR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IENR.Reg, volatile.LoadUint32(&o.IENR.Reg)&^(0xffffff00)|value<<8)
}
func (o *PINT_Type) GetIENR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IENR.Reg) & 0xffffff00) >> 8
}

// PINT.SIENR: Pin interrupt level or rising edge interrupt set register
func (o *PINT_Type) SetSIENR_SETENRL0(value uint32) {
	volatile.StoreUint32(&o.SIENR.Reg, volatile.LoadUint32(&o.SIENR.Reg)&^(0x1)|value)
}
func (o *PINT_Type) GetSIENR_SETENRL0() uint32 {
	return volatile.LoadUint32(&o.SIENR.Reg) & 0x1
}
func (o *PINT_Type) SetSIENR_SETENRL1(value uint32) {
	volatile.StoreUint32(&o.SIENR.Reg, volatile.LoadUint32(&o.SIENR.Reg)&^(0x2)|value<<1)
}
func (o *PINT_Type) GetSIENR_SETENRL1() uint32 {
	return (volatile.LoadUint32(&o.SIENR.Reg) & 0x2) >> 1
}
func (o *PINT_Type) SetSIENR_SETENRL2(value uint32) {
	volatile.StoreUint32(&o.SIENR.Reg, volatile.LoadUint32(&o.SIENR.Reg)&^(0x4)|value<<2)
}
func (o *PINT_Type) GetSIENR_SETENRL2() uint32 {
	return (volatile.LoadUint32(&o.SIENR.Reg) & 0x4) >> 2
}
func (o *PINT_Type) SetSIENR_SETENRL3(value uint32) {
	volatile.StoreUint32(&o.SIENR.Reg, volatile.LoadUint32(&o.SIENR.Reg)&^(0x8)|value<<3)
}
func (o *PINT_Type) GetSIENR_SETENRL3() uint32 {
	return (volatile.LoadUint32(&o.SIENR.Reg) & 0x8) >> 3
}
func (o *PINT_Type) SetSIENR_SETENRL4(value uint32) {
	volatile.StoreUint32(&o.SIENR.Reg, volatile.LoadUint32(&o.SIENR.Reg)&^(0x10)|value<<4)
}
func (o *PINT_Type) GetSIENR_SETENRL4() uint32 {
	return (volatile.LoadUint32(&o.SIENR.Reg) & 0x10) >> 4
}
func (o *PINT_Type) SetSIENR_SETENRL5(value uint32) {
	volatile.StoreUint32(&o.SIENR.Reg, volatile.LoadUint32(&o.SIENR.Reg)&^(0x20)|value<<5)
}
func (o *PINT_Type) GetSIENR_SETENRL5() uint32 {
	return (volatile.LoadUint32(&o.SIENR.Reg) & 0x20) >> 5
}
func (o *PINT_Type) SetSIENR_SETENRL6(value uint32) {
	volatile.StoreUint32(&o.SIENR.Reg, volatile.LoadUint32(&o.SIENR.Reg)&^(0x40)|value<<6)
}
func (o *PINT_Type) GetSIENR_SETENRL6() uint32 {
	return (volatile.LoadUint32(&o.SIENR.Reg) & 0x40) >> 6
}
func (o *PINT_Type) SetSIENR_SETENRL7(value uint32) {
	volatile.StoreUint32(&o.SIENR.Reg, volatile.LoadUint32(&o.SIENR.Reg)&^(0x80)|value<<7)
}
func (o *PINT_Type) GetSIENR_SETENRL7() uint32 {
	return (volatile.LoadUint32(&o.SIENR.Reg) & 0x80) >> 7
}
func (o *PINT_Type) SetSIENR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SIENR.Reg, volatile.LoadUint32(&o.SIENR.Reg)&^(0xffffff00)|value<<8)
}
func (o *PINT_Type) GetSIENR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SIENR.Reg) & 0xffffff00) >> 8
}

// PINT.CIENR: Pin interrupt level (rising edge interrupt) clear register
func (o *PINT_Type) SetCIENR_CENRL0(value uint32) {
	volatile.StoreUint32(&o.CIENR.Reg, volatile.LoadUint32(&o.CIENR.Reg)&^(0x1)|value)
}
func (o *PINT_Type) GetCIENR_CENRL0() uint32 {
	return volatile.LoadUint32(&o.CIENR.Reg) & 0x1
}
func (o *PINT_Type) SetCIENR_CENRL1(value uint32) {
	volatile.StoreUint32(&o.CIENR.Reg, volatile.LoadUint32(&o.CIENR.Reg)&^(0x2)|value<<1)
}
func (o *PINT_Type) GetCIENR_CENRL1() uint32 {
	return (volatile.LoadUint32(&o.CIENR.Reg) & 0x2) >> 1
}
func (o *PINT_Type) SetCIENR_CENRL2(value uint32) {
	volatile.StoreUint32(&o.CIENR.Reg, volatile.LoadUint32(&o.CIENR.Reg)&^(0x4)|value<<2)
}
func (o *PINT_Type) GetCIENR_CENRL2() uint32 {
	return (volatile.LoadUint32(&o.CIENR.Reg) & 0x4) >> 2
}
func (o *PINT_Type) SetCIENR_CENRL3(value uint32) {
	volatile.StoreUint32(&o.CIENR.Reg, volatile.LoadUint32(&o.CIENR.Reg)&^(0x8)|value<<3)
}
func (o *PINT_Type) GetCIENR_CENRL3() uint32 {
	return (volatile.LoadUint32(&o.CIENR.Reg) & 0x8) >> 3
}
func (o *PINT_Type) SetCIENR_CENRL4(value uint32) {
	volatile.StoreUint32(&o.CIENR.Reg, volatile.LoadUint32(&o.CIENR.Reg)&^(0x10)|value<<4)
}
func (o *PINT_Type) GetCIENR_CENRL4() uint32 {
	return (volatile.LoadUint32(&o.CIENR.Reg) & 0x10) >> 4
}
func (o *PINT_Type) SetCIENR_CENRL5(value uint32) {
	volatile.StoreUint32(&o.CIENR.Reg, volatile.LoadUint32(&o.CIENR.Reg)&^(0x20)|value<<5)
}
func (o *PINT_Type) GetCIENR_CENRL5() uint32 {
	return (volatile.LoadUint32(&o.CIENR.Reg) & 0x20) >> 5
}
func (o *PINT_Type) SetCIENR_CENRL6(value uint32) {
	volatile.StoreUint32(&o.CIENR.Reg, volatile.LoadUint32(&o.CIENR.Reg)&^(0x40)|value<<6)
}
func (o *PINT_Type) GetCIENR_CENRL6() uint32 {
	return (volatile.LoadUint32(&o.CIENR.Reg) & 0x40) >> 6
}
func (o *PINT_Type) SetCIENR_CENRL7(value uint32) {
	volatile.StoreUint32(&o.CIENR.Reg, volatile.LoadUint32(&o.CIENR.Reg)&^(0x80)|value<<7)
}
func (o *PINT_Type) GetCIENR_CENRL7() uint32 {
	return (volatile.LoadUint32(&o.CIENR.Reg) & 0x80) >> 7
}
func (o *PINT_Type) SetCIENR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CIENR.Reg, volatile.LoadUint32(&o.CIENR.Reg)&^(0xffffff00)|value<<8)
}
func (o *PINT_Type) GetCIENR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CIENR.Reg) & 0xffffff00) >> 8
}

// PINT.IENF: Pin interrupt active level or falling edge interrupt enable register
func (o *PINT_Type) SetIENF_ENAF0(value uint32) {
	volatile.StoreUint32(&o.IENF.Reg, volatile.LoadUint32(&o.IENF.Reg)&^(0x1)|value)
}
func (o *PINT_Type) GetIENF_ENAF0() uint32 {
	return volatile.LoadUint32(&o.IENF.Reg) & 0x1
}
func (o *PINT_Type) SetIENF_ENAF1(value uint32) {
	volatile.StoreUint32(&o.IENF.Reg, volatile.LoadUint32(&o.IENF.Reg)&^(0x2)|value<<1)
}
func (o *PINT_Type) GetIENF_ENAF1() uint32 {
	return (volatile.LoadUint32(&o.IENF.Reg) & 0x2) >> 1
}
func (o *PINT_Type) SetIENF_ENAF2(value uint32) {
	volatile.StoreUint32(&o.IENF.Reg, volatile.LoadUint32(&o.IENF.Reg)&^(0x4)|value<<2)
}
func (o *PINT_Type) GetIENF_ENAF2() uint32 {
	return (volatile.LoadUint32(&o.IENF.Reg) & 0x4) >> 2
}
func (o *PINT_Type) SetIENF_ENAF3(value uint32) {
	volatile.StoreUint32(&o.IENF.Reg, volatile.LoadUint32(&o.IENF.Reg)&^(0x8)|value<<3)
}
func (o *PINT_Type) GetIENF_ENAF3() uint32 {
	return (volatile.LoadUint32(&o.IENF.Reg) & 0x8) >> 3
}
func (o *PINT_Type) SetIENF_ENAF4(value uint32) {
	volatile.StoreUint32(&o.IENF.Reg, volatile.LoadUint32(&o.IENF.Reg)&^(0x10)|value<<4)
}
func (o *PINT_Type) GetIENF_ENAF4() uint32 {
	return (volatile.LoadUint32(&o.IENF.Reg) & 0x10) >> 4
}
func (o *PINT_Type) SetIENF_ENAF5(value uint32) {
	volatile.StoreUint32(&o.IENF.Reg, volatile.LoadUint32(&o.IENF.Reg)&^(0x20)|value<<5)
}
func (o *PINT_Type) GetIENF_ENAF5() uint32 {
	return (volatile.LoadUint32(&o.IENF.Reg) & 0x20) >> 5
}
func (o *PINT_Type) SetIENF_ENAF6(value uint32) {
	volatile.StoreUint32(&o.IENF.Reg, volatile.LoadUint32(&o.IENF.Reg)&^(0x40)|value<<6)
}
func (o *PINT_Type) GetIENF_ENAF6() uint32 {
	return (volatile.LoadUint32(&o.IENF.Reg) & 0x40) >> 6
}
func (o *PINT_Type) SetIENF_ENAF7(value uint32) {
	volatile.StoreUint32(&o.IENF.Reg, volatile.LoadUint32(&o.IENF.Reg)&^(0x80)|value<<7)
}
func (o *PINT_Type) GetIENF_ENAF7() uint32 {
	return (volatile.LoadUint32(&o.IENF.Reg) & 0x80) >> 7
}
func (o *PINT_Type) SetIENF_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IENF.Reg, volatile.LoadUint32(&o.IENF.Reg)&^(0xffffff00)|value<<8)
}
func (o *PINT_Type) GetIENF_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IENF.Reg) & 0xffffff00) >> 8
}

// PINT.SIENF: Pin interrupt active level or falling edge interrupt set register
func (o *PINT_Type) SetSIENF_SETENAF0(value uint32) {
	volatile.StoreUint32(&o.SIENF.Reg, volatile.LoadUint32(&o.SIENF.Reg)&^(0x1)|value)
}
func (o *PINT_Type) GetSIENF_SETENAF0() uint32 {
	return volatile.LoadUint32(&o.SIENF.Reg) & 0x1
}
func (o *PINT_Type) SetSIENF_SETENAF1(value uint32) {
	volatile.StoreUint32(&o.SIENF.Reg, volatile.LoadUint32(&o.SIENF.Reg)&^(0x2)|value<<1)
}
func (o *PINT_Type) GetSIENF_SETENAF1() uint32 {
	return (volatile.LoadUint32(&o.SIENF.Reg) & 0x2) >> 1
}
func (o *PINT_Type) SetSIENF_SETENAF2(value uint32) {
	volatile.StoreUint32(&o.SIENF.Reg, volatile.LoadUint32(&o.SIENF.Reg)&^(0x4)|value<<2)
}
func (o *PINT_Type) GetSIENF_SETENAF2() uint32 {
	return (volatile.LoadUint32(&o.SIENF.Reg) & 0x4) >> 2
}
func (o *PINT_Type) SetSIENF_SETENAF3(value uint32) {
	volatile.StoreUint32(&o.SIENF.Reg, volatile.LoadUint32(&o.SIENF.Reg)&^(0x8)|value<<3)
}
func (o *PINT_Type) GetSIENF_SETENAF3() uint32 {
	return (volatile.LoadUint32(&o.SIENF.Reg) & 0x8) >> 3
}
func (o *PINT_Type) SetSIENF_SETENAF4(value uint32) {
	volatile.StoreUint32(&o.SIENF.Reg, volatile.LoadUint32(&o.SIENF.Reg)&^(0x10)|value<<4)
}
func (o *PINT_Type) GetSIENF_SETENAF4() uint32 {
	return (volatile.LoadUint32(&o.SIENF.Reg) & 0x10) >> 4
}
func (o *PINT_Type) SetSIENF_SETENAF5(value uint32) {
	volatile.StoreUint32(&o.SIENF.Reg, volatile.LoadUint32(&o.SIENF.Reg)&^(0x20)|value<<5)
}
func (o *PINT_Type) GetSIENF_SETENAF5() uint32 {
	return (volatile.LoadUint32(&o.SIENF.Reg) & 0x20) >> 5
}
func (o *PINT_Type) SetSIENF_SETENAF6(value uint32) {
	volatile.StoreUint32(&o.SIENF.Reg, volatile.LoadUint32(&o.SIENF.Reg)&^(0x40)|value<<6)
}
func (o *PINT_Type) GetSIENF_SETENAF6() uint32 {
	return (volatile.LoadUint32(&o.SIENF.Reg) & 0x40) >> 6
}
func (o *PINT_Type) SetSIENF_SETENAF7(value uint32) {
	volatile.StoreUint32(&o.SIENF.Reg, volatile.LoadUint32(&o.SIENF.Reg)&^(0x80)|value<<7)
}
func (o *PINT_Type) GetSIENF_SETENAF7() uint32 {
	return (volatile.LoadUint32(&o.SIENF.Reg) & 0x80) >> 7
}
func (o *PINT_Type) SetSIENF_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SIENF.Reg, volatile.LoadUint32(&o.SIENF.Reg)&^(0xffffff00)|value<<8)
}
func (o *PINT_Type) GetSIENF_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SIENF.Reg) & 0xffffff00) >> 8
}

// PINT.CIENF: Pin interrupt active level or falling edge interrupt clear register
func (o *PINT_Type) SetCIENF_CENAF0(value uint32) {
	volatile.StoreUint32(&o.CIENF.Reg, volatile.LoadUint32(&o.CIENF.Reg)&^(0x1)|value)
}
func (o *PINT_Type) GetCIENF_CENAF0() uint32 {
	return volatile.LoadUint32(&o.CIENF.Reg) & 0x1
}
func (o *PINT_Type) SetCIENF_CENAF1(value uint32) {
	volatile.StoreUint32(&o.CIENF.Reg, volatile.LoadUint32(&o.CIENF.Reg)&^(0x2)|value<<1)
}
func (o *PINT_Type) GetCIENF_CENAF1() uint32 {
	return (volatile.LoadUint32(&o.CIENF.Reg) & 0x2) >> 1
}
func (o *PINT_Type) SetCIENF_CENAF2(value uint32) {
	volatile.StoreUint32(&o.CIENF.Reg, volatile.LoadUint32(&o.CIENF.Reg)&^(0x4)|value<<2)
}
func (o *PINT_Type) GetCIENF_CENAF2() uint32 {
	return (volatile.LoadUint32(&o.CIENF.Reg) & 0x4) >> 2
}
func (o *PINT_Type) SetCIENF_CENAF3(value uint32) {
	volatile.StoreUint32(&o.CIENF.Reg, volatile.LoadUint32(&o.CIENF.Reg)&^(0x8)|value<<3)
}
func (o *PINT_Type) GetCIENF_CENAF3() uint32 {
	return (volatile.LoadUint32(&o.CIENF.Reg) & 0x8) >> 3
}
func (o *PINT_Type) SetCIENF_CENAF4(value uint32) {
	volatile.StoreUint32(&o.CIENF.Reg, volatile.LoadUint32(&o.CIENF.Reg)&^(0x10)|value<<4)
}
func (o *PINT_Type) GetCIENF_CENAF4() uint32 {
	return (volatile.LoadUint32(&o.CIENF.Reg) & 0x10) >> 4
}
func (o *PINT_Type) SetCIENF_CENAF5(value uint32) {
	volatile.StoreUint32(&o.CIENF.Reg, volatile.LoadUint32(&o.CIENF.Reg)&^(0x20)|value<<5)
}
func (o *PINT_Type) GetCIENF_CENAF5() uint32 {
	return (volatile.LoadUint32(&o.CIENF.Reg) & 0x20) >> 5
}
func (o *PINT_Type) SetCIENF_CENAF6(value uint32) {
	volatile.StoreUint32(&o.CIENF.Reg, volatile.LoadUint32(&o.CIENF.Reg)&^(0x40)|value<<6)
}
func (o *PINT_Type) GetCIENF_CENAF6() uint32 {
	return (volatile.LoadUint32(&o.CIENF.Reg) & 0x40) >> 6
}
func (o *PINT_Type) SetCIENF_CENAF7(value uint32) {
	volatile.StoreUint32(&o.CIENF.Reg, volatile.LoadUint32(&o.CIENF.Reg)&^(0x80)|value<<7)
}
func (o *PINT_Type) GetCIENF_CENAF7() uint32 {
	return (volatile.LoadUint32(&o.CIENF.Reg) & 0x80) >> 7
}
func (o *PINT_Type) SetCIENF_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CIENF.Reg, volatile.LoadUint32(&o.CIENF.Reg)&^(0xffffff00)|value<<8)
}
func (o *PINT_Type) GetCIENF_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CIENF.Reg) & 0xffffff00) >> 8
}

// PINT.RISE: Pin interrupt rising edge register
func (o *PINT_Type) SetRISE_RDET0(value uint32) {
	volatile.StoreUint32(&o.RISE.Reg, volatile.LoadUint32(&o.RISE.Reg)&^(0x1)|value)
}
func (o *PINT_Type) GetRISE_RDET0() uint32 {
	return volatile.LoadUint32(&o.RISE.Reg) & 0x1
}
func (o *PINT_Type) SetRISE_RDET1(value uint32) {
	volatile.StoreUint32(&o.RISE.Reg, volatile.LoadUint32(&o.RISE.Reg)&^(0x2)|value<<1)
}
func (o *PINT_Type) GetRISE_RDET1() uint32 {
	return (volatile.LoadUint32(&o.RISE.Reg) & 0x2) >> 1
}
func (o *PINT_Type) SetRISE_RDET2(value uint32) {
	volatile.StoreUint32(&o.RISE.Reg, volatile.LoadUint32(&o.RISE.Reg)&^(0x4)|value<<2)
}
func (o *PINT_Type) GetRISE_RDET2() uint32 {
	return (volatile.LoadUint32(&o.RISE.Reg) & 0x4) >> 2
}
func (o *PINT_Type) SetRISE_RDET3(value uint32) {
	volatile.StoreUint32(&o.RISE.Reg, volatile.LoadUint32(&o.RISE.Reg)&^(0x8)|value<<3)
}
func (o *PINT_Type) GetRISE_RDET3() uint32 {
	return (volatile.LoadUint32(&o.RISE.Reg) & 0x8) >> 3
}
func (o *PINT_Type) SetRISE_RDET4(value uint32) {
	volatile.StoreUint32(&o.RISE.Reg, volatile.LoadUint32(&o.RISE.Reg)&^(0x10)|value<<4)
}
func (o *PINT_Type) GetRISE_RDET4() uint32 {
	return (volatile.LoadUint32(&o.RISE.Reg) & 0x10) >> 4
}
func (o *PINT_Type) SetRISE_RDET5(value uint32) {
	volatile.StoreUint32(&o.RISE.Reg, volatile.LoadUint32(&o.RISE.Reg)&^(0x20)|value<<5)
}
func (o *PINT_Type) GetRISE_RDET5() uint32 {
	return (volatile.LoadUint32(&o.RISE.Reg) & 0x20) >> 5
}
func (o *PINT_Type) SetRISE_RDET6(value uint32) {
	volatile.StoreUint32(&o.RISE.Reg, volatile.LoadUint32(&o.RISE.Reg)&^(0x40)|value<<6)
}
func (o *PINT_Type) GetRISE_RDET6() uint32 {
	return (volatile.LoadUint32(&o.RISE.Reg) & 0x40) >> 6
}
func (o *PINT_Type) SetRISE_RDET7(value uint32) {
	volatile.StoreUint32(&o.RISE.Reg, volatile.LoadUint32(&o.RISE.Reg)&^(0x80)|value<<7)
}
func (o *PINT_Type) GetRISE_RDET7() uint32 {
	return (volatile.LoadUint32(&o.RISE.Reg) & 0x80) >> 7
}
func (o *PINT_Type) SetRISE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RISE.Reg, volatile.LoadUint32(&o.RISE.Reg)&^(0xffffff00)|value<<8)
}
func (o *PINT_Type) GetRISE_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.RISE.Reg) & 0xffffff00) >> 8
}

// PINT.FALL: Pin interrupt falling edge register
func (o *PINT_Type) SetFALL_FDET0(value uint32) {
	volatile.StoreUint32(&o.FALL.Reg, volatile.LoadUint32(&o.FALL.Reg)&^(0x1)|value)
}
func (o *PINT_Type) GetFALL_FDET0() uint32 {
	return volatile.LoadUint32(&o.FALL.Reg) & 0x1
}
func (o *PINT_Type) SetFALL_FDET1(value uint32) {
	volatile.StoreUint32(&o.FALL.Reg, volatile.LoadUint32(&o.FALL.Reg)&^(0x2)|value<<1)
}
func (o *PINT_Type) GetFALL_FDET1() uint32 {
	return (volatile.LoadUint32(&o.FALL.Reg) & 0x2) >> 1
}
func (o *PINT_Type) SetFALL_FDET2(value uint32) {
	volatile.StoreUint32(&o.FALL.Reg, volatile.LoadUint32(&o.FALL.Reg)&^(0x4)|value<<2)
}
func (o *PINT_Type) GetFALL_FDET2() uint32 {
	return (volatile.LoadUint32(&o.FALL.Reg) & 0x4) >> 2
}
func (o *PINT_Type) SetFALL_FDET3(value uint32) {
	volatile.StoreUint32(&o.FALL.Reg, volatile.LoadUint32(&o.FALL.Reg)&^(0x8)|value<<3)
}
func (o *PINT_Type) GetFALL_FDET3() uint32 {
	return (volatile.LoadUint32(&o.FALL.Reg) & 0x8) >> 3
}
func (o *PINT_Type) SetFALL_FDET4(value uint32) {
	volatile.StoreUint32(&o.FALL.Reg, volatile.LoadUint32(&o.FALL.Reg)&^(0x10)|value<<4)
}
func (o *PINT_Type) GetFALL_FDET4() uint32 {
	return (volatile.LoadUint32(&o.FALL.Reg) & 0x10) >> 4
}
func (o *PINT_Type) SetFALL_FDET5(value uint32) {
	volatile.StoreUint32(&o.FALL.Reg, volatile.LoadUint32(&o.FALL.Reg)&^(0x20)|value<<5)
}
func (o *PINT_Type) GetFALL_FDET5() uint32 {
	return (volatile.LoadUint32(&o.FALL.Reg) & 0x20) >> 5
}
func (o *PINT_Type) SetFALL_FDET6(value uint32) {
	volatile.StoreUint32(&o.FALL.Reg, volatile.LoadUint32(&o.FALL.Reg)&^(0x40)|value<<6)
}
func (o *PINT_Type) GetFALL_FDET6() uint32 {
	return (volatile.LoadUint32(&o.FALL.Reg) & 0x40) >> 6
}
func (o *PINT_Type) SetFALL_FDET7(value uint32) {
	volatile.StoreUint32(&o.FALL.Reg, volatile.LoadUint32(&o.FALL.Reg)&^(0x80)|value<<7)
}
func (o *PINT_Type) GetFALL_FDET7() uint32 {
	return (volatile.LoadUint32(&o.FALL.Reg) & 0x80) >> 7
}
func (o *PINT_Type) SetFALL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.FALL.Reg, volatile.LoadUint32(&o.FALL.Reg)&^(0xffffff00)|value<<8)
}
func (o *PINT_Type) GetFALL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.FALL.Reg) & 0xffffff00) >> 8
}

// PINT.IST: Pin interrupt status register
func (o *PINT_Type) SetIST_PSTAT0(value uint32) {
	volatile.StoreUint32(&o.IST.Reg, volatile.LoadUint32(&o.IST.Reg)&^(0x1)|value)
}
func (o *PINT_Type) GetIST_PSTAT0() uint32 {
	return volatile.LoadUint32(&o.IST.Reg) & 0x1
}
func (o *PINT_Type) SetIST_PSTAT1(value uint32) {
	volatile.StoreUint32(&o.IST.Reg, volatile.LoadUint32(&o.IST.Reg)&^(0x2)|value<<1)
}
func (o *PINT_Type) GetIST_PSTAT1() uint32 {
	return (volatile.LoadUint32(&o.IST.Reg) & 0x2) >> 1
}
func (o *PINT_Type) SetIST_PSTAT2(value uint32) {
	volatile.StoreUint32(&o.IST.Reg, volatile.LoadUint32(&o.IST.Reg)&^(0x4)|value<<2)
}
func (o *PINT_Type) GetIST_PSTAT2() uint32 {
	return (volatile.LoadUint32(&o.IST.Reg) & 0x4) >> 2
}
func (o *PINT_Type) SetIST_PSTAT3(value uint32) {
	volatile.StoreUint32(&o.IST.Reg, volatile.LoadUint32(&o.IST.Reg)&^(0x8)|value<<3)
}
func (o *PINT_Type) GetIST_PSTAT3() uint32 {
	return (volatile.LoadUint32(&o.IST.Reg) & 0x8) >> 3
}
func (o *PINT_Type) SetIST_PSTAT4(value uint32) {
	volatile.StoreUint32(&o.IST.Reg, volatile.LoadUint32(&o.IST.Reg)&^(0x10)|value<<4)
}
func (o *PINT_Type) GetIST_PSTAT4() uint32 {
	return (volatile.LoadUint32(&o.IST.Reg) & 0x10) >> 4
}
func (o *PINT_Type) SetIST_PSTAT5(value uint32) {
	volatile.StoreUint32(&o.IST.Reg, volatile.LoadUint32(&o.IST.Reg)&^(0x20)|value<<5)
}
func (o *PINT_Type) GetIST_PSTAT5() uint32 {
	return (volatile.LoadUint32(&o.IST.Reg) & 0x20) >> 5
}
func (o *PINT_Type) SetIST_PSTAT6(value uint32) {
	volatile.StoreUint32(&o.IST.Reg, volatile.LoadUint32(&o.IST.Reg)&^(0x40)|value<<6)
}
func (o *PINT_Type) GetIST_PSTAT6() uint32 {
	return (volatile.LoadUint32(&o.IST.Reg) & 0x40) >> 6
}
func (o *PINT_Type) SetIST_PSTAT7(value uint32) {
	volatile.StoreUint32(&o.IST.Reg, volatile.LoadUint32(&o.IST.Reg)&^(0x80)|value<<7)
}
func (o *PINT_Type) GetIST_PSTAT7() uint32 {
	return (volatile.LoadUint32(&o.IST.Reg) & 0x80) >> 7
}
func (o *PINT_Type) SetIST_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IST.Reg, volatile.LoadUint32(&o.IST.Reg)&^(0xffffff00)|value<<8)
}
func (o *PINT_Type) GetIST_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IST.Reg) & 0xffffff00) >> 8
}

// PINT.PMCTRL: Pattern match interrupt control register
func (o *PINT_Type) SetPMCTRL_SEL_PMATCH(value uint32) {
	volatile.StoreUint32(&o.PMCTRL.Reg, volatile.LoadUint32(&o.PMCTRL.Reg)&^(0x1)|value)
}
func (o *PINT_Type) GetPMCTRL_SEL_PMATCH() uint32 {
	return volatile.LoadUint32(&o.PMCTRL.Reg) & 0x1
}
func (o *PINT_Type) SetPMCTRL_ENA_RXEV(value uint32) {
	volatile.StoreUint32(&o.PMCTRL.Reg, volatile.LoadUint32(&o.PMCTRL.Reg)&^(0x2)|value<<1)
}
func (o *PINT_Type) GetPMCTRL_ENA_RXEV() uint32 {
	return (volatile.LoadUint32(&o.PMCTRL.Reg) & 0x2) >> 1
}
func (o *PINT_Type) SetPMCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PMCTRL.Reg, volatile.LoadUint32(&o.PMCTRL.Reg)&^(0xfffffc)|value<<2)
}
func (o *PINT_Type) GetPMCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PMCTRL.Reg) & 0xfffffc) >> 2
}
func (o *PINT_Type) SetPMCTRL_PMAT(value uint32) {
	volatile.StoreUint32(&o.PMCTRL.Reg, volatile.LoadUint32(&o.PMCTRL.Reg)&^(0xff000000)|value<<24)
}
func (o *PINT_Type) GetPMCTRL_PMAT() uint32 {
	return (volatile.LoadUint32(&o.PMCTRL.Reg) & 0xff000000) >> 24
}

// PINT.PMSRC: Pattern match interrupt bit-slice source register
func (o *PINT_Type) SetPMSRC_Reserved(value uint32) {
	volatile.StoreUint32(&o.PMSRC.Reg, volatile.LoadUint32(&o.PMSRC.Reg)&^(0xff)|value)
}
func (o *PINT_Type) GetPMSRC_Reserved() uint32 {
	return volatile.LoadUint32(&o.PMSRC.Reg) & 0xff
}
func (o *PINT_Type) SetPMSRC_SRC0(value uint32) {
	volatile.StoreUint32(&o.PMSRC.Reg, volatile.LoadUint32(&o.PMSRC.Reg)&^(0x700)|value<<8)
}
func (o *PINT_Type) GetPMSRC_SRC0() uint32 {
	return (volatile.LoadUint32(&o.PMSRC.Reg) & 0x700) >> 8
}
func (o *PINT_Type) SetPMSRC_SRC1(value uint32) {
	volatile.StoreUint32(&o.PMSRC.Reg, volatile.LoadUint32(&o.PMSRC.Reg)&^(0x3800)|value<<11)
}
func (o *PINT_Type) GetPMSRC_SRC1() uint32 {
	return (volatile.LoadUint32(&o.PMSRC.Reg) & 0x3800) >> 11
}
func (o *PINT_Type) SetPMSRC_SRC2(value uint32) {
	volatile.StoreUint32(&o.PMSRC.Reg, volatile.LoadUint32(&o.PMSRC.Reg)&^(0x1c000)|value<<14)
}
func (o *PINT_Type) GetPMSRC_SRC2() uint32 {
	return (volatile.LoadUint32(&o.PMSRC.Reg) & 0x1c000) >> 14
}
func (o *PINT_Type) SetPMSRC_SRC3(value uint32) {
	volatile.StoreUint32(&o.PMSRC.Reg, volatile.LoadUint32(&o.PMSRC.Reg)&^(0xe0000)|value<<17)
}
func (o *PINT_Type) GetPMSRC_SRC3() uint32 {
	return (volatile.LoadUint32(&o.PMSRC.Reg) & 0xe0000) >> 17
}
func (o *PINT_Type) SetPMSRC_SRC4(value uint32) {
	volatile.StoreUint32(&o.PMSRC.Reg, volatile.LoadUint32(&o.PMSRC.Reg)&^(0x700000)|value<<20)
}
func (o *PINT_Type) GetPMSRC_SRC4() uint32 {
	return (volatile.LoadUint32(&o.PMSRC.Reg) & 0x700000) >> 20
}
func (o *PINT_Type) SetPMSRC_SRC5(value uint32) {
	volatile.StoreUint32(&o.PMSRC.Reg, volatile.LoadUint32(&o.PMSRC.Reg)&^(0x3800000)|value<<23)
}
func (o *PINT_Type) GetPMSRC_SRC5() uint32 {
	return (volatile.LoadUint32(&o.PMSRC.Reg) & 0x3800000) >> 23
}
func (o *PINT_Type) SetPMSRC_SRC6(value uint32) {
	volatile.StoreUint32(&o.PMSRC.Reg, volatile.LoadUint32(&o.PMSRC.Reg)&^(0x1c000000)|value<<26)
}
func (o *PINT_Type) GetPMSRC_SRC6() uint32 {
	return (volatile.LoadUint32(&o.PMSRC.Reg) & 0x1c000000) >> 26
}
func (o *PINT_Type) SetPMSRC_SRC7(value uint32) {
	volatile.StoreUint32(&o.PMSRC.Reg, volatile.LoadUint32(&o.PMSRC.Reg)&^(0xe0000000)|value<<29)
}
func (o *PINT_Type) GetPMSRC_SRC7() uint32 {
	return (volatile.LoadUint32(&o.PMSRC.Reg) & 0xe0000000) >> 29
}

// PINT.PMCFG: Pattern match interrupt bit slice configuration register
func (o *PINT_Type) SetPMCFG_PROD_ENDPTS(value uint32) {
	volatile.StoreUint32(&o.PMCFG.Reg, volatile.LoadUint32(&o.PMCFG.Reg)&^(0x7f)|value)
}
func (o *PINT_Type) GetPMCFG_PROD_ENDPTS() uint32 {
	return volatile.LoadUint32(&o.PMCFG.Reg) & 0x7f
}
func (o *PINT_Type) SetPMCFG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PMCFG.Reg, volatile.LoadUint32(&o.PMCFG.Reg)&^(0x80)|value<<7)
}
func (o *PINT_Type) GetPMCFG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PMCFG.Reg) & 0x80) >> 7
}
func (o *PINT_Type) SetPMCFG_CFG0(value uint32) {
	volatile.StoreUint32(&o.PMCFG.Reg, volatile.LoadUint32(&o.PMCFG.Reg)&^(0x700)|value<<8)
}
func (o *PINT_Type) GetPMCFG_CFG0() uint32 {
	return (volatile.LoadUint32(&o.PMCFG.Reg) & 0x700) >> 8
}
func (o *PINT_Type) SetPMCFG_CFG1(value uint32) {
	volatile.StoreUint32(&o.PMCFG.Reg, volatile.LoadUint32(&o.PMCFG.Reg)&^(0x3800)|value<<11)
}
func (o *PINT_Type) GetPMCFG_CFG1() uint32 {
	return (volatile.LoadUint32(&o.PMCFG.Reg) & 0x3800) >> 11
}
func (o *PINT_Type) SetPMCFG_CFG2(value uint32) {
	volatile.StoreUint32(&o.PMCFG.Reg, volatile.LoadUint32(&o.PMCFG.Reg)&^(0x1c000)|value<<14)
}
func (o *PINT_Type) GetPMCFG_CFG2() uint32 {
	return (volatile.LoadUint32(&o.PMCFG.Reg) & 0x1c000) >> 14
}
func (o *PINT_Type) SetPMCFG_CFG3(value uint32) {
	volatile.StoreUint32(&o.PMCFG.Reg, volatile.LoadUint32(&o.PMCFG.Reg)&^(0xe0000)|value<<17)
}
func (o *PINT_Type) GetPMCFG_CFG3() uint32 {
	return (volatile.LoadUint32(&o.PMCFG.Reg) & 0xe0000) >> 17
}
func (o *PINT_Type) SetPMCFG_CFG4(value uint32) {
	volatile.StoreUint32(&o.PMCFG.Reg, volatile.LoadUint32(&o.PMCFG.Reg)&^(0x700000)|value<<20)
}
func (o *PINT_Type) GetPMCFG_CFG4() uint32 {
	return (volatile.LoadUint32(&o.PMCFG.Reg) & 0x700000) >> 20
}
func (o *PINT_Type) SetPMCFG_CFG5(value uint32) {
	volatile.StoreUint32(&o.PMCFG.Reg, volatile.LoadUint32(&o.PMCFG.Reg)&^(0x3800000)|value<<23)
}
func (o *PINT_Type) GetPMCFG_CFG5() uint32 {
	return (volatile.LoadUint32(&o.PMCFG.Reg) & 0x3800000) >> 23
}
func (o *PINT_Type) SetPMCFG_CFG6(value uint32) {
	volatile.StoreUint32(&o.PMCFG.Reg, volatile.LoadUint32(&o.PMCFG.Reg)&^(0x1c000000)|value<<26)
}
func (o *PINT_Type) GetPMCFG_CFG6() uint32 {
	return (volatile.LoadUint32(&o.PMCFG.Reg) & 0x1c000000) >> 26
}
func (o *PINT_Type) SetPMCFG_CFG7(value uint32) {
	volatile.StoreUint32(&o.PMCFG.Reg, volatile.LoadUint32(&o.PMCFG.Reg)&^(0xe0000000)|value<<29)
}
func (o *PINT_Type) GetPMCFG_CFG7() uint32 {
	return (volatile.LoadUint32(&o.PMCFG.Reg) & 0xe0000000) >> 29
}

// Group interrupt 0/1 (GINT0/1)
type GINT_Type struct {
	CTRL     volatile.Register32 // 0x0
	_        [28]byte
	PORT_POL [3]volatile.Register32 // 0x20
	_        [20]byte
	PORT_ENA [3]volatile.Register32 // 0x40
}

// GINT.CTRL: GPIO grouped interrupt control register
func (o *GINT_Type) SetCTRL_INT(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x1)|value)
}
func (o *GINT_Type) GetCTRL_INT() uint32 {
	return volatile.LoadUint32(&o.CTRL.Reg) & 0x1
}
func (o *GINT_Type) SetCTRL_COMB(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x2)|value<<1)
}
func (o *GINT_Type) GetCTRL_COMB() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x2) >> 1
}
func (o *GINT_Type) SetCTRL_TRIG(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x4)|value<<2)
}
func (o *GINT_Type) GetCTRL_TRIG() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x4) >> 2
}
func (o *GINT_Type) SetCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0xfffffff8)|value<<3)
}
func (o *GINT_Type) GetCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0xfffffff8) >> 3
}

// GINT.PORT_POL: GPIO grouped interrupt port 0 polarity register
func (o *GINT_Type) SetPORT_POL_POL0(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_POL[idx].Reg, volatile.LoadUint32(&o.PORT_POL[idx].Reg)&^(0x1)|value)
}
func (o *GINT_Type) GetPORT_POL_POL0(idx int) uint32 {
	return volatile.LoadUint32(&o.PORT_POL[idx].Reg) & 0x1
}
func (o *GINT_Type) SetPORT_POL_POL1(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_POL[idx].Reg, volatile.LoadUint32(&o.PORT_POL[idx].Reg)&^(0x2)|value<<1)
}
func (o *GINT_Type) GetPORT_POL_POL1(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_POL[idx].Reg) & 0x2) >> 1
}
func (o *GINT_Type) SetPORT_POL_POL2(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_POL[idx].Reg, volatile.LoadUint32(&o.PORT_POL[idx].Reg)&^(0x4)|value<<2)
}
func (o *GINT_Type) GetPORT_POL_POL2(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_POL[idx].Reg) & 0x4) >> 2
}
func (o *GINT_Type) SetPORT_POL_POL3(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_POL[idx].Reg, volatile.LoadUint32(&o.PORT_POL[idx].Reg)&^(0x8)|value<<3)
}
func (o *GINT_Type) GetPORT_POL_POL3(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_POL[idx].Reg) & 0x8) >> 3
}
func (o *GINT_Type) SetPORT_POL_POL4(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_POL[idx].Reg, volatile.LoadUint32(&o.PORT_POL[idx].Reg)&^(0x10)|value<<4)
}
func (o *GINT_Type) GetPORT_POL_POL4(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_POL[idx].Reg) & 0x10) >> 4
}
func (o *GINT_Type) SetPORT_POL_POL5(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_POL[idx].Reg, volatile.LoadUint32(&o.PORT_POL[idx].Reg)&^(0x20)|value<<5)
}
func (o *GINT_Type) GetPORT_POL_POL5(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_POL[idx].Reg) & 0x20) >> 5
}
func (o *GINT_Type) SetPORT_POL_POL6(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_POL[idx].Reg, volatile.LoadUint32(&o.PORT_POL[idx].Reg)&^(0x40)|value<<6)
}
func (o *GINT_Type) GetPORT_POL_POL6(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_POL[idx].Reg) & 0x40) >> 6
}
func (o *GINT_Type) SetPORT_POL_POL7(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_POL[idx].Reg, volatile.LoadUint32(&o.PORT_POL[idx].Reg)&^(0x80)|value<<7)
}
func (o *GINT_Type) GetPORT_POL_POL7(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_POL[idx].Reg) & 0x80) >> 7
}
func (o *GINT_Type) SetPORT_POL_POL8(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_POL[idx].Reg, volatile.LoadUint32(&o.PORT_POL[idx].Reg)&^(0x100)|value<<8)
}
func (o *GINT_Type) GetPORT_POL_POL8(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_POL[idx].Reg) & 0x100) >> 8
}
func (o *GINT_Type) SetPORT_POL_POL9(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_POL[idx].Reg, volatile.LoadUint32(&o.PORT_POL[idx].Reg)&^(0x200)|value<<9)
}
func (o *GINT_Type) GetPORT_POL_POL9(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_POL[idx].Reg) & 0x200) >> 9
}
func (o *GINT_Type) SetPORT_POL_POL10(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_POL[idx].Reg, volatile.LoadUint32(&o.PORT_POL[idx].Reg)&^(0x400)|value<<10)
}
func (o *GINT_Type) GetPORT_POL_POL10(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_POL[idx].Reg) & 0x400) >> 10
}
func (o *GINT_Type) SetPORT_POL_POL11(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_POL[idx].Reg, volatile.LoadUint32(&o.PORT_POL[idx].Reg)&^(0x800)|value<<11)
}
func (o *GINT_Type) GetPORT_POL_POL11(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_POL[idx].Reg) & 0x800) >> 11
}
func (o *GINT_Type) SetPORT_POL_POL12(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_POL[idx].Reg, volatile.LoadUint32(&o.PORT_POL[idx].Reg)&^(0x1000)|value<<12)
}
func (o *GINT_Type) GetPORT_POL_POL12(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_POL[idx].Reg) & 0x1000) >> 12
}
func (o *GINT_Type) SetPORT_POL_POL13(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_POL[idx].Reg, volatile.LoadUint32(&o.PORT_POL[idx].Reg)&^(0x2000)|value<<13)
}
func (o *GINT_Type) GetPORT_POL_POL13(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_POL[idx].Reg) & 0x2000) >> 13
}
func (o *GINT_Type) SetPORT_POL_POL14(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_POL[idx].Reg, volatile.LoadUint32(&o.PORT_POL[idx].Reg)&^(0x4000)|value<<14)
}
func (o *GINT_Type) GetPORT_POL_POL14(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_POL[idx].Reg) & 0x4000) >> 14
}
func (o *GINT_Type) SetPORT_POL_POL15(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_POL[idx].Reg, volatile.LoadUint32(&o.PORT_POL[idx].Reg)&^(0x8000)|value<<15)
}
func (o *GINT_Type) GetPORT_POL_POL15(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_POL[idx].Reg) & 0x8000) >> 15
}
func (o *GINT_Type) SetPORT_POL_POL16(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_POL[idx].Reg, volatile.LoadUint32(&o.PORT_POL[idx].Reg)&^(0x10000)|value<<16)
}
func (o *GINT_Type) GetPORT_POL_POL16(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_POL[idx].Reg) & 0x10000) >> 16
}
func (o *GINT_Type) SetPORT_POL_POL17(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_POL[idx].Reg, volatile.LoadUint32(&o.PORT_POL[idx].Reg)&^(0x20000)|value<<17)
}
func (o *GINT_Type) GetPORT_POL_POL17(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_POL[idx].Reg) & 0x20000) >> 17
}
func (o *GINT_Type) SetPORT_POL_POL18(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_POL[idx].Reg, volatile.LoadUint32(&o.PORT_POL[idx].Reg)&^(0x40000)|value<<18)
}
func (o *GINT_Type) GetPORT_POL_POL18(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_POL[idx].Reg) & 0x40000) >> 18
}
func (o *GINT_Type) SetPORT_POL_POL19(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_POL[idx].Reg, volatile.LoadUint32(&o.PORT_POL[idx].Reg)&^(0x80000)|value<<19)
}
func (o *GINT_Type) GetPORT_POL_POL19(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_POL[idx].Reg) & 0x80000) >> 19
}
func (o *GINT_Type) SetPORT_POL_POL20(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_POL[idx].Reg, volatile.LoadUint32(&o.PORT_POL[idx].Reg)&^(0x100000)|value<<20)
}
func (o *GINT_Type) GetPORT_POL_POL20(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_POL[idx].Reg) & 0x100000) >> 20
}
func (o *GINT_Type) SetPORT_POL_POL21(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_POL[idx].Reg, volatile.LoadUint32(&o.PORT_POL[idx].Reg)&^(0x200000)|value<<21)
}
func (o *GINT_Type) GetPORT_POL_POL21(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_POL[idx].Reg) & 0x200000) >> 21
}
func (o *GINT_Type) SetPORT_POL_POL22(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_POL[idx].Reg, volatile.LoadUint32(&o.PORT_POL[idx].Reg)&^(0x400000)|value<<22)
}
func (o *GINT_Type) GetPORT_POL_POL22(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_POL[idx].Reg) & 0x400000) >> 22
}
func (o *GINT_Type) SetPORT_POL_POL23(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_POL[idx].Reg, volatile.LoadUint32(&o.PORT_POL[idx].Reg)&^(0x800000)|value<<23)
}
func (o *GINT_Type) GetPORT_POL_POL23(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_POL[idx].Reg) & 0x800000) >> 23
}
func (o *GINT_Type) SetPORT_POL_POL24(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_POL[idx].Reg, volatile.LoadUint32(&o.PORT_POL[idx].Reg)&^(0x1000000)|value<<24)
}
func (o *GINT_Type) GetPORT_POL_POL24(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_POL[idx].Reg) & 0x1000000) >> 24
}
func (o *GINT_Type) SetPORT_POL_POL25(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_POL[idx].Reg, volatile.LoadUint32(&o.PORT_POL[idx].Reg)&^(0x2000000)|value<<25)
}
func (o *GINT_Type) GetPORT_POL_POL25(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_POL[idx].Reg) & 0x2000000) >> 25
}
func (o *GINT_Type) SetPORT_POL_POL26(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_POL[idx].Reg, volatile.LoadUint32(&o.PORT_POL[idx].Reg)&^(0x4000000)|value<<26)
}
func (o *GINT_Type) GetPORT_POL_POL26(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_POL[idx].Reg) & 0x4000000) >> 26
}
func (o *GINT_Type) SetPORT_POL_POL27(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_POL[idx].Reg, volatile.LoadUint32(&o.PORT_POL[idx].Reg)&^(0x8000000)|value<<27)
}
func (o *GINT_Type) GetPORT_POL_POL27(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_POL[idx].Reg) & 0x8000000) >> 27
}
func (o *GINT_Type) SetPORT_POL_POL28(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_POL[idx].Reg, volatile.LoadUint32(&o.PORT_POL[idx].Reg)&^(0x10000000)|value<<28)
}
func (o *GINT_Type) GetPORT_POL_POL28(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_POL[idx].Reg) & 0x10000000) >> 28
}
func (o *GINT_Type) SetPORT_POL_POL29(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_POL[idx].Reg, volatile.LoadUint32(&o.PORT_POL[idx].Reg)&^(0x20000000)|value<<29)
}
func (o *GINT_Type) GetPORT_POL_POL29(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_POL[idx].Reg) & 0x20000000) >> 29
}
func (o *GINT_Type) SetPORT_POL_POL30(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_POL[idx].Reg, volatile.LoadUint32(&o.PORT_POL[idx].Reg)&^(0x40000000)|value<<30)
}
func (o *GINT_Type) GetPORT_POL_POL30(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_POL[idx].Reg) & 0x40000000) >> 30
}
func (o *GINT_Type) SetPORT_POL_POL31(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_POL[idx].Reg, volatile.LoadUint32(&o.PORT_POL[idx].Reg)&^(0x80000000)|value<<31)
}
func (o *GINT_Type) GetPORT_POL_POL31(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_POL[idx].Reg) & 0x80000000) >> 31
}

// GINT.PORT_ENA: GPIO grouped interrupt port 0 enable register
func (o *GINT_Type) SetPORT_ENA_ENA0(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_ENA[idx].Reg, volatile.LoadUint32(&o.PORT_ENA[idx].Reg)&^(0x1)|value)
}
func (o *GINT_Type) GetPORT_ENA_ENA0(idx int) uint32 {
	return volatile.LoadUint32(&o.PORT_ENA[idx].Reg) & 0x1
}
func (o *GINT_Type) SetPORT_ENA_ENA1(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_ENA[idx].Reg, volatile.LoadUint32(&o.PORT_ENA[idx].Reg)&^(0x2)|value<<1)
}
func (o *GINT_Type) GetPORT_ENA_ENA1(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA[idx].Reg) & 0x2) >> 1
}
func (o *GINT_Type) SetPORT_ENA_ENA2(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_ENA[idx].Reg, volatile.LoadUint32(&o.PORT_ENA[idx].Reg)&^(0x4)|value<<2)
}
func (o *GINT_Type) GetPORT_ENA_ENA2(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA[idx].Reg) & 0x4) >> 2
}
func (o *GINT_Type) SetPORT_ENA_ENA3(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_ENA[idx].Reg, volatile.LoadUint32(&o.PORT_ENA[idx].Reg)&^(0x8)|value<<3)
}
func (o *GINT_Type) GetPORT_ENA_ENA3(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA[idx].Reg) & 0x8) >> 3
}
func (o *GINT_Type) SetPORT_ENA_ENA4(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_ENA[idx].Reg, volatile.LoadUint32(&o.PORT_ENA[idx].Reg)&^(0x10)|value<<4)
}
func (o *GINT_Type) GetPORT_ENA_ENA4(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA[idx].Reg) & 0x10) >> 4
}
func (o *GINT_Type) SetPORT_ENA_ENA5(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_ENA[idx].Reg, volatile.LoadUint32(&o.PORT_ENA[idx].Reg)&^(0x20)|value<<5)
}
func (o *GINT_Type) GetPORT_ENA_ENA5(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA[idx].Reg) & 0x20) >> 5
}
func (o *GINT_Type) SetPORT_ENA_ENA6(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_ENA[idx].Reg, volatile.LoadUint32(&o.PORT_ENA[idx].Reg)&^(0x40)|value<<6)
}
func (o *GINT_Type) GetPORT_ENA_ENA6(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA[idx].Reg) & 0x40) >> 6
}
func (o *GINT_Type) SetPORT_ENA_ENA7(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_ENA[idx].Reg, volatile.LoadUint32(&o.PORT_ENA[idx].Reg)&^(0x80)|value<<7)
}
func (o *GINT_Type) GetPORT_ENA_ENA7(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA[idx].Reg) & 0x80) >> 7
}
func (o *GINT_Type) SetPORT_ENA_ENA8(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_ENA[idx].Reg, volatile.LoadUint32(&o.PORT_ENA[idx].Reg)&^(0x100)|value<<8)
}
func (o *GINT_Type) GetPORT_ENA_ENA8(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA[idx].Reg) & 0x100) >> 8
}
func (o *GINT_Type) SetPORT_ENA_ENA9(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_ENA[idx].Reg, volatile.LoadUint32(&o.PORT_ENA[idx].Reg)&^(0x200)|value<<9)
}
func (o *GINT_Type) GetPORT_ENA_ENA9(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA[idx].Reg) & 0x200) >> 9
}
func (o *GINT_Type) SetPORT_ENA_ENA10(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_ENA[idx].Reg, volatile.LoadUint32(&o.PORT_ENA[idx].Reg)&^(0x400)|value<<10)
}
func (o *GINT_Type) GetPORT_ENA_ENA10(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA[idx].Reg) & 0x400) >> 10
}
func (o *GINT_Type) SetPORT_ENA_ENA11(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_ENA[idx].Reg, volatile.LoadUint32(&o.PORT_ENA[idx].Reg)&^(0x800)|value<<11)
}
func (o *GINT_Type) GetPORT_ENA_ENA11(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA[idx].Reg) & 0x800) >> 11
}
func (o *GINT_Type) SetPORT_ENA_ENA12(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_ENA[idx].Reg, volatile.LoadUint32(&o.PORT_ENA[idx].Reg)&^(0x1000)|value<<12)
}
func (o *GINT_Type) GetPORT_ENA_ENA12(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA[idx].Reg) & 0x1000) >> 12
}
func (o *GINT_Type) SetPORT_ENA_ENA13(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_ENA[idx].Reg, volatile.LoadUint32(&o.PORT_ENA[idx].Reg)&^(0x2000)|value<<13)
}
func (o *GINT_Type) GetPORT_ENA_ENA13(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA[idx].Reg) & 0x2000) >> 13
}
func (o *GINT_Type) SetPORT_ENA_ENA14(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_ENA[idx].Reg, volatile.LoadUint32(&o.PORT_ENA[idx].Reg)&^(0x4000)|value<<14)
}
func (o *GINT_Type) GetPORT_ENA_ENA14(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA[idx].Reg) & 0x4000) >> 14
}
func (o *GINT_Type) SetPORT_ENA_ENA15(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_ENA[idx].Reg, volatile.LoadUint32(&o.PORT_ENA[idx].Reg)&^(0x8000)|value<<15)
}
func (o *GINT_Type) GetPORT_ENA_ENA15(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA[idx].Reg) & 0x8000) >> 15
}
func (o *GINT_Type) SetPORT_ENA_ENA16(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_ENA[idx].Reg, volatile.LoadUint32(&o.PORT_ENA[idx].Reg)&^(0x10000)|value<<16)
}
func (o *GINT_Type) GetPORT_ENA_ENA16(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA[idx].Reg) & 0x10000) >> 16
}
func (o *GINT_Type) SetPORT_ENA_ENA17(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_ENA[idx].Reg, volatile.LoadUint32(&o.PORT_ENA[idx].Reg)&^(0x20000)|value<<17)
}
func (o *GINT_Type) GetPORT_ENA_ENA17(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA[idx].Reg) & 0x20000) >> 17
}
func (o *GINT_Type) SetPORT_ENA_ENA18(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_ENA[idx].Reg, volatile.LoadUint32(&o.PORT_ENA[idx].Reg)&^(0x40000)|value<<18)
}
func (o *GINT_Type) GetPORT_ENA_ENA18(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA[idx].Reg) & 0x40000) >> 18
}
func (o *GINT_Type) SetPORT_ENA_ENA19(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_ENA[idx].Reg, volatile.LoadUint32(&o.PORT_ENA[idx].Reg)&^(0x80000)|value<<19)
}
func (o *GINT_Type) GetPORT_ENA_ENA19(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA[idx].Reg) & 0x80000) >> 19
}
func (o *GINT_Type) SetPORT_ENA_ENA20(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_ENA[idx].Reg, volatile.LoadUint32(&o.PORT_ENA[idx].Reg)&^(0x100000)|value<<20)
}
func (o *GINT_Type) GetPORT_ENA_ENA20(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA[idx].Reg) & 0x100000) >> 20
}
func (o *GINT_Type) SetPORT_ENA_ENA21(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_ENA[idx].Reg, volatile.LoadUint32(&o.PORT_ENA[idx].Reg)&^(0x200000)|value<<21)
}
func (o *GINT_Type) GetPORT_ENA_ENA21(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA[idx].Reg) & 0x200000) >> 21
}
func (o *GINT_Type) SetPORT_ENA_ENA22(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_ENA[idx].Reg, volatile.LoadUint32(&o.PORT_ENA[idx].Reg)&^(0x400000)|value<<22)
}
func (o *GINT_Type) GetPORT_ENA_ENA22(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA[idx].Reg) & 0x400000) >> 22
}
func (o *GINT_Type) SetPORT_ENA_ENA23(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_ENA[idx].Reg, volatile.LoadUint32(&o.PORT_ENA[idx].Reg)&^(0x800000)|value<<23)
}
func (o *GINT_Type) GetPORT_ENA_ENA23(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA[idx].Reg) & 0x800000) >> 23
}
func (o *GINT_Type) SetPORT_ENA_ENA24(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_ENA[idx].Reg, volatile.LoadUint32(&o.PORT_ENA[idx].Reg)&^(0x1000000)|value<<24)
}
func (o *GINT_Type) GetPORT_ENA_ENA24(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA[idx].Reg) & 0x1000000) >> 24
}
func (o *GINT_Type) SetPORT_ENA_ENA25(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_ENA[idx].Reg, volatile.LoadUint32(&o.PORT_ENA[idx].Reg)&^(0x2000000)|value<<25)
}
func (o *GINT_Type) GetPORT_ENA_ENA25(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA[idx].Reg) & 0x2000000) >> 25
}
func (o *GINT_Type) SetPORT_ENA_ENA26(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_ENA[idx].Reg, volatile.LoadUint32(&o.PORT_ENA[idx].Reg)&^(0x4000000)|value<<26)
}
func (o *GINT_Type) GetPORT_ENA_ENA26(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA[idx].Reg) & 0x4000000) >> 26
}
func (o *GINT_Type) SetPORT_ENA_ENA27(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_ENA[idx].Reg, volatile.LoadUint32(&o.PORT_ENA[idx].Reg)&^(0x8000000)|value<<27)
}
func (o *GINT_Type) GetPORT_ENA_ENA27(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA[idx].Reg) & 0x8000000) >> 27
}
func (o *GINT_Type) SetPORT_ENA_ENA28(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_ENA[idx].Reg, volatile.LoadUint32(&o.PORT_ENA[idx].Reg)&^(0x10000000)|value<<28)
}
func (o *GINT_Type) GetPORT_ENA_ENA28(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA[idx].Reg) & 0x10000000) >> 28
}
func (o *GINT_Type) SetPORT_ENA_ENA29(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_ENA[idx].Reg, volatile.LoadUint32(&o.PORT_ENA[idx].Reg)&^(0x20000000)|value<<29)
}
func (o *GINT_Type) GetPORT_ENA_ENA29(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA[idx].Reg) & 0x20000000) >> 29
}
func (o *GINT_Type) SetPORT_ENA_ENA30(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_ENA[idx].Reg, volatile.LoadUint32(&o.PORT_ENA[idx].Reg)&^(0x40000000)|value<<30)
}
func (o *GINT_Type) GetPORT_ENA_ENA30(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA[idx].Reg) & 0x40000000) >> 30
}
func (o *GINT_Type) SetPORT_ENA_ENA31(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_ENA[idx].Reg, volatile.LoadUint32(&o.PORT_ENA[idx].Reg)&^(0x80000000)|value<<31)
}
func (o *GINT_Type) GetPORT_ENA_ENA31(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA[idx].Reg) & 0x80000000) >> 31
}

// Repetitive Interrupt Timer (RIT)
type RIT_Type struct {
	COMPVAL   volatile.Register32 // 0x0
	MASK      volatile.Register32 // 0x4
	CTRL      volatile.Register32 // 0x8
	COUNTER   volatile.Register32 // 0xC
	COMPVAL_H volatile.Register32 // 0x10
	MASK_H    volatile.Register32 // 0x14
	_         [4]byte
	COUNTER_H volatile.Register32 // 0x1C
}

// RIT.COMPVAL: Compare value LSB register. Holds the 32 LSBs of the compare value.
func (o *RIT_Type) SetCOMPVAL(value uint32) {
	volatile.StoreUint32(&o.COMPVAL.Reg, value)
}
func (o *RIT_Type) GetCOMPVAL() uint32 {
	return volatile.LoadUint32(&o.COMPVAL.Reg)
}

// RIT.MASK: Mask LSB register. This register holds the 32 LSB s of the mask value. A 1 written to any bit will force a compare on the corresponding bit of the counter and compare register.
func (o *RIT_Type) SetMASK(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, value)
}
func (o *RIT_Type) GetMASK() uint32 {
	return volatile.LoadUint32(&o.MASK.Reg)
}

// RIT.CTRL: Control register.
func (o *RIT_Type) SetCTRL_RITINT(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x1)|value)
}
func (o *RIT_Type) GetCTRL_RITINT() uint32 {
	return volatile.LoadUint32(&o.CTRL.Reg) & 0x1
}
func (o *RIT_Type) SetCTRL_RITENCLR(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x2)|value<<1)
}
func (o *RIT_Type) GetCTRL_RITENCLR() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x2) >> 1
}
func (o *RIT_Type) SetCTRL_RITENBR(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x4)|value<<2)
}
func (o *RIT_Type) GetCTRL_RITENBR() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x4) >> 2
}
func (o *RIT_Type) SetCTRL_RITEN(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x8)|value<<3)
}
func (o *RIT_Type) GetCTRL_RITEN() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x8) >> 3
}
func (o *RIT_Type) SetCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0xfffffff0)|value<<4)
}
func (o *RIT_Type) GetCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0xfffffff0) >> 4
}

// RIT.COUNTER: Counter LSB register. 32 LSBs of the counter.
func (o *RIT_Type) SetCOUNTER(value uint32) {
	volatile.StoreUint32(&o.COUNTER.Reg, value)
}
func (o *RIT_Type) GetCOUNTER() uint32 {
	return volatile.LoadUint32(&o.COUNTER.Reg)
}

// RIT.COMPVAL_H: Compare value MSB register. Holds the 16 MSBs of the compare value.
func (o *RIT_Type) SetCOMPVAL_H_RICOMP(value uint32) {
	volatile.StoreUint32(&o.COMPVAL_H.Reg, volatile.LoadUint32(&o.COMPVAL_H.Reg)&^(0xffff)|value)
}
func (o *RIT_Type) GetCOMPVAL_H_RICOMP() uint32 {
	return volatile.LoadUint32(&o.COMPVAL_H.Reg) & 0xffff
}
func (o *RIT_Type) SetCOMPVAL_H_RESERVED(value uint32) {
	volatile.StoreUint32(&o.COMPVAL_H.Reg, volatile.LoadUint32(&o.COMPVAL_H.Reg)&^(0xffff0000)|value<<16)
}
func (o *RIT_Type) GetCOMPVAL_H_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.COMPVAL_H.Reg) & 0xffff0000) >> 16
}

// RIT.MASK_H: Mask MSB register. This register holds the 16 MSBs of the mask value. A 1 written to any bit will force a compare on the corresponding bit of the counter and compare register.
func (o *RIT_Type) SetMASK_H_RIMASK(value uint32) {
	volatile.StoreUint32(&o.MASK_H.Reg, volatile.LoadUint32(&o.MASK_H.Reg)&^(0xffff)|value)
}
func (o *RIT_Type) GetMASK_H_RIMASK() uint32 {
	return volatile.LoadUint32(&o.MASK_H.Reg) & 0xffff
}
func (o *RIT_Type) SetMASK_H_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MASK_H.Reg, volatile.LoadUint32(&o.MASK_H.Reg)&^(0xffff0000)|value<<16)
}
func (o *RIT_Type) GetMASK_H_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MASK_H.Reg) & 0xffff0000) >> 16
}

// RIT.COUNTER_H: Counter MSB register. 16 MSBs of the counter.
func (o *RIT_Type) SetCOUNTER_H_RICOUNTER(value uint32) {
	volatile.StoreUint32(&o.COUNTER_H.Reg, volatile.LoadUint32(&o.COUNTER_H.Reg)&^(0xffff)|value)
}
func (o *RIT_Type) GetCOUNTER_H_RICOUNTER() uint32 {
	return volatile.LoadUint32(&o.COUNTER_H.Reg) & 0xffff
}
func (o *RIT_Type) SetCOUNTER_H_RESERVED(value uint32) {
	volatile.StoreUint32(&o.COUNTER_H.Reg, volatile.LoadUint32(&o.COUNTER_H.Reg)&^(0xffff0000)|value<<16)
}
func (o *RIT_Type) GetCOUNTER_H_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.COUNTER_H.Reg) & 0xffff0000) >> 16
}

// SCT Input Processing Unit (IPU)
type SCTIPU_Type struct {
	SAMPLE_CTRL   volatile.Register32 // 0x0
	_             [28]byte
	ABORT_ENABLE0 volatile.Register32 // 0x20
	ABORT_SOURCE0 volatile.Register32 // 0x24
	_             [24]byte
	ABORT_ENABLE1 volatile.Register32 // 0x40
	ABORT_SOURCE1 volatile.Register32 // 0x44
	_             [24]byte
	ABORT_ENABLE2 volatile.Register32 // 0x60
	ABORT_SOURCE2 volatile.Register32 // 0x64
	_             [24]byte
	ABORT_ENABLE3 volatile.Register32 // 0x80
	ABORT_SOURCE3 volatile.Register32 // 0x84
}

// SCTIPU.SAMPLE_CTRL: SCT IPU sample control register. Contains the input mux selects, latch/sample-enable mux selects, and sample overrride bits for the SAMPLE module.
func (o *SCTIPU_Type) SetSAMPLE_CTRL_IN0SEL(value uint32) {
	volatile.StoreUint32(&o.SAMPLE_CTRL.Reg, volatile.LoadUint32(&o.SAMPLE_CTRL.Reg)&^(0x1)|value)
}
func (o *SCTIPU_Type) GetSAMPLE_CTRL_IN0SEL() uint32 {
	return volatile.LoadUint32(&o.SAMPLE_CTRL.Reg) & 0x1
}
func (o *SCTIPU_Type) SetSAMPLE_CTRL_IN1SEL(value uint32) {
	volatile.StoreUint32(&o.SAMPLE_CTRL.Reg, volatile.LoadUint32(&o.SAMPLE_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *SCTIPU_Type) GetSAMPLE_CTRL_IN1SEL() uint32 {
	return (volatile.LoadUint32(&o.SAMPLE_CTRL.Reg) & 0x2) >> 1
}
func (o *SCTIPU_Type) SetSAMPLE_CTRL_IN2SEL(value uint32) {
	volatile.StoreUint32(&o.SAMPLE_CTRL.Reg, volatile.LoadUint32(&o.SAMPLE_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *SCTIPU_Type) GetSAMPLE_CTRL_IN2SEL() uint32 {
	return (volatile.LoadUint32(&o.SAMPLE_CTRL.Reg) & 0x4) >> 2
}
func (o *SCTIPU_Type) SetSAMPLE_CTRL_IN3SEL(value uint32) {
	volatile.StoreUint32(&o.SAMPLE_CTRL.Reg, volatile.LoadUint32(&o.SAMPLE_CTRL.Reg)&^(0x8)|value<<3)
}
func (o *SCTIPU_Type) GetSAMPLE_CTRL_IN3SEL() uint32 {
	return (volatile.LoadUint32(&o.SAMPLE_CTRL.Reg) & 0x8) >> 3
}
func (o *SCTIPU_Type) SetSAMPLE_CTRL_SAMPLE_EN0SEL(value uint32) {
	volatile.StoreUint32(&o.SAMPLE_CTRL.Reg, volatile.LoadUint32(&o.SAMPLE_CTRL.Reg)&^(0x30)|value<<4)
}
func (o *SCTIPU_Type) GetSAMPLE_CTRL_SAMPLE_EN0SEL() uint32 {
	return (volatile.LoadUint32(&o.SAMPLE_CTRL.Reg) & 0x30) >> 4
}
func (o *SCTIPU_Type) SetSAMPLE_CTRL_SAMPLE_EN1SEL(value uint32) {
	volatile.StoreUint32(&o.SAMPLE_CTRL.Reg, volatile.LoadUint32(&o.SAMPLE_CTRL.Reg)&^(0xc0)|value<<6)
}
func (o *SCTIPU_Type) GetSAMPLE_CTRL_SAMPLE_EN1SEL() uint32 {
	return (volatile.LoadUint32(&o.SAMPLE_CTRL.Reg) & 0xc0) >> 6
}
func (o *SCTIPU_Type) SetSAMPLE_CTRL_SAMPLE_EN2SEL(value uint32) {
	volatile.StoreUint32(&o.SAMPLE_CTRL.Reg, volatile.LoadUint32(&o.SAMPLE_CTRL.Reg)&^(0x300)|value<<8)
}
func (o *SCTIPU_Type) GetSAMPLE_CTRL_SAMPLE_EN2SEL() uint32 {
	return (volatile.LoadUint32(&o.SAMPLE_CTRL.Reg) & 0x300) >> 8
}
func (o *SCTIPU_Type) SetSAMPLE_CTRL_SAMPLE_EN3SEL(value uint32) {
	volatile.StoreUint32(&o.SAMPLE_CTRL.Reg, volatile.LoadUint32(&o.SAMPLE_CTRL.Reg)&^(0xc00)|value<<10)
}
func (o *SCTIPU_Type) GetSAMPLE_CTRL_SAMPLE_EN3SEL() uint32 {
	return (volatile.LoadUint32(&o.SAMPLE_CTRL.Reg) & 0xc00) >> 10
}
func (o *SCTIPU_Type) SetSAMPLE_CTRL_LATCHEN0(value uint32) {
	volatile.StoreUint32(&o.SAMPLE_CTRL.Reg, volatile.LoadUint32(&o.SAMPLE_CTRL.Reg)&^(0x1000)|value<<12)
}
func (o *SCTIPU_Type) GetSAMPLE_CTRL_LATCHEN0() uint32 {
	return (volatile.LoadUint32(&o.SAMPLE_CTRL.Reg) & 0x1000) >> 12
}
func (o *SCTIPU_Type) SetSAMPLE_CTRL_LATCHEN1(value uint32) {
	volatile.StoreUint32(&o.SAMPLE_CTRL.Reg, volatile.LoadUint32(&o.SAMPLE_CTRL.Reg)&^(0x2000)|value<<13)
}
func (o *SCTIPU_Type) GetSAMPLE_CTRL_LATCHEN1() uint32 {
	return (volatile.LoadUint32(&o.SAMPLE_CTRL.Reg) & 0x2000) >> 13
}
func (o *SCTIPU_Type) SetSAMPLE_CTRL_LATCHEN2(value uint32) {
	volatile.StoreUint32(&o.SAMPLE_CTRL.Reg, volatile.LoadUint32(&o.SAMPLE_CTRL.Reg)&^(0x4000)|value<<14)
}
func (o *SCTIPU_Type) GetSAMPLE_CTRL_LATCHEN2() uint32 {
	return (volatile.LoadUint32(&o.SAMPLE_CTRL.Reg) & 0x4000) >> 14
}
func (o *SCTIPU_Type) SetSAMPLE_CTRL_LATCHEN3(value uint32) {
	volatile.StoreUint32(&o.SAMPLE_CTRL.Reg, volatile.LoadUint32(&o.SAMPLE_CTRL.Reg)&^(0x8000)|value<<15)
}
func (o *SCTIPU_Type) GetSAMPLE_CTRL_LATCHEN3() uint32 {
	return (volatile.LoadUint32(&o.SAMPLE_CTRL.Reg) & 0x8000) >> 15
}

// SCTIPU.ABORT_ENABLE0: SCT IPU abort enable register: Selects which input source contributes to ORed Abort Output 0.
func (o *SCTIPU_Type) SetABORT_ENABLE0_ENA0(value uint32) {
	volatile.StoreUint32(&o.ABORT_ENABLE0.Reg, volatile.LoadUint32(&o.ABORT_ENABLE0.Reg)&^(0x1)|value)
}
func (o *SCTIPU_Type) GetABORT_ENABLE0_ENA0() uint32 {
	return volatile.LoadUint32(&o.ABORT_ENABLE0.Reg) & 0x1
}
func (o *SCTIPU_Type) SetABORT_ENABLE0_ENA1(value uint32) {
	volatile.StoreUint32(&o.ABORT_ENABLE0.Reg, volatile.LoadUint32(&o.ABORT_ENABLE0.Reg)&^(0x2)|value<<1)
}
func (o *SCTIPU_Type) GetABORT_ENABLE0_ENA1() uint32 {
	return (volatile.LoadUint32(&o.ABORT_ENABLE0.Reg) & 0x2) >> 1
}
func (o *SCTIPU_Type) SetABORT_ENABLE0_ENA2(value uint32) {
	volatile.StoreUint32(&o.ABORT_ENABLE0.Reg, volatile.LoadUint32(&o.ABORT_ENABLE0.Reg)&^(0x4)|value<<2)
}
func (o *SCTIPU_Type) GetABORT_ENABLE0_ENA2() uint32 {
	return (volatile.LoadUint32(&o.ABORT_ENABLE0.Reg) & 0x4) >> 2
}
func (o *SCTIPU_Type) SetABORT_ENABLE0_ENA3(value uint32) {
	volatile.StoreUint32(&o.ABORT_ENABLE0.Reg, volatile.LoadUint32(&o.ABORT_ENABLE0.Reg)&^(0x8)|value<<3)
}
func (o *SCTIPU_Type) GetABORT_ENABLE0_ENA3() uint32 {
	return (volatile.LoadUint32(&o.ABORT_ENABLE0.Reg) & 0x8) >> 3
}
func (o *SCTIPU_Type) SetABORT_ENABLE0_ENA4(value uint32) {
	volatile.StoreUint32(&o.ABORT_ENABLE0.Reg, volatile.LoadUint32(&o.ABORT_ENABLE0.Reg)&^(0x10)|value<<4)
}
func (o *SCTIPU_Type) GetABORT_ENABLE0_ENA4() uint32 {
	return (volatile.LoadUint32(&o.ABORT_ENABLE0.Reg) & 0x10) >> 4
}
func (o *SCTIPU_Type) SetABORT_ENABLE0_ENA5(value uint32) {
	volatile.StoreUint32(&o.ABORT_ENABLE0.Reg, volatile.LoadUint32(&o.ABORT_ENABLE0.Reg)&^(0x20)|value<<5)
}
func (o *SCTIPU_Type) GetABORT_ENABLE0_ENA5() uint32 {
	return (volatile.LoadUint32(&o.ABORT_ENABLE0.Reg) & 0x20) >> 5
}
func (o *SCTIPU_Type) SetABORT_ENABLE0_ENA6(value uint32) {
	volatile.StoreUint32(&o.ABORT_ENABLE0.Reg, volatile.LoadUint32(&o.ABORT_ENABLE0.Reg)&^(0x40)|value<<6)
}
func (o *SCTIPU_Type) GetABORT_ENABLE0_ENA6() uint32 {
	return (volatile.LoadUint32(&o.ABORT_ENABLE0.Reg) & 0x40) >> 6
}
func (o *SCTIPU_Type) SetABORT_ENABLE0_ENA7(value uint32) {
	volatile.StoreUint32(&o.ABORT_ENABLE0.Reg, volatile.LoadUint32(&o.ABORT_ENABLE0.Reg)&^(0x80)|value<<7)
}
func (o *SCTIPU_Type) GetABORT_ENABLE0_ENA7() uint32 {
	return (volatile.LoadUint32(&o.ABORT_ENABLE0.Reg) & 0x80) >> 7
}
func (o *SCTIPU_Type) SetABORT_ENABLE0_ENA8(value uint32) {
	volatile.StoreUint32(&o.ABORT_ENABLE0.Reg, volatile.LoadUint32(&o.ABORT_ENABLE0.Reg)&^(0x100)|value<<8)
}
func (o *SCTIPU_Type) GetABORT_ENABLE0_ENA8() uint32 {
	return (volatile.LoadUint32(&o.ABORT_ENABLE0.Reg) & 0x100) >> 8
}

// SCTIPU.ABORT_SOURCE0: SCT IPU abort source register: Status register indicating which input source caused abort output 0.
func (o *SCTIPU_Type) SetABORT_SOURCE0_ACT0(value uint32) {
	volatile.StoreUint32(&o.ABORT_SOURCE0.Reg, volatile.LoadUint32(&o.ABORT_SOURCE0.Reg)&^(0x1)|value)
}
func (o *SCTIPU_Type) GetABORT_SOURCE0_ACT0() uint32 {
	return volatile.LoadUint32(&o.ABORT_SOURCE0.Reg) & 0x1
}
func (o *SCTIPU_Type) SetABORT_SOURCE0_ACT1(value uint32) {
	volatile.StoreUint32(&o.ABORT_SOURCE0.Reg, volatile.LoadUint32(&o.ABORT_SOURCE0.Reg)&^(0x2)|value<<1)
}
func (o *SCTIPU_Type) GetABORT_SOURCE0_ACT1() uint32 {
	return (volatile.LoadUint32(&o.ABORT_SOURCE0.Reg) & 0x2) >> 1
}
func (o *SCTIPU_Type) SetABORT_SOURCE0_ACT2(value uint32) {
	volatile.StoreUint32(&o.ABORT_SOURCE0.Reg, volatile.LoadUint32(&o.ABORT_SOURCE0.Reg)&^(0x4)|value<<2)
}
func (o *SCTIPU_Type) GetABORT_SOURCE0_ACT2() uint32 {
	return (volatile.LoadUint32(&o.ABORT_SOURCE0.Reg) & 0x4) >> 2
}
func (o *SCTIPU_Type) SetABORT_SOURCE0_ACT3(value uint32) {
	volatile.StoreUint32(&o.ABORT_SOURCE0.Reg, volatile.LoadUint32(&o.ABORT_SOURCE0.Reg)&^(0x8)|value<<3)
}
func (o *SCTIPU_Type) GetABORT_SOURCE0_ACT3() uint32 {
	return (volatile.LoadUint32(&o.ABORT_SOURCE0.Reg) & 0x8) >> 3
}
func (o *SCTIPU_Type) SetABORT_SOURCE0_ACT4(value uint32) {
	volatile.StoreUint32(&o.ABORT_SOURCE0.Reg, volatile.LoadUint32(&o.ABORT_SOURCE0.Reg)&^(0x10)|value<<4)
}
func (o *SCTIPU_Type) GetABORT_SOURCE0_ACT4() uint32 {
	return (volatile.LoadUint32(&o.ABORT_SOURCE0.Reg) & 0x10) >> 4
}
func (o *SCTIPU_Type) SetABORT_SOURCE0_ACT5(value uint32) {
	volatile.StoreUint32(&o.ABORT_SOURCE0.Reg, volatile.LoadUint32(&o.ABORT_SOURCE0.Reg)&^(0x20)|value<<5)
}
func (o *SCTIPU_Type) GetABORT_SOURCE0_ACT5() uint32 {
	return (volatile.LoadUint32(&o.ABORT_SOURCE0.Reg) & 0x20) >> 5
}
func (o *SCTIPU_Type) SetABORT_SOURCE0_ACT6(value uint32) {
	volatile.StoreUint32(&o.ABORT_SOURCE0.Reg, volatile.LoadUint32(&o.ABORT_SOURCE0.Reg)&^(0x40)|value<<6)
}
func (o *SCTIPU_Type) GetABORT_SOURCE0_ACT6() uint32 {
	return (volatile.LoadUint32(&o.ABORT_SOURCE0.Reg) & 0x40) >> 6
}
func (o *SCTIPU_Type) SetABORT_SOURCE0_ACT7(value uint32) {
	volatile.StoreUint32(&o.ABORT_SOURCE0.Reg, volatile.LoadUint32(&o.ABORT_SOURCE0.Reg)&^(0x80)|value<<7)
}
func (o *SCTIPU_Type) GetABORT_SOURCE0_ACT7() uint32 {
	return (volatile.LoadUint32(&o.ABORT_SOURCE0.Reg) & 0x80) >> 7
}
func (o *SCTIPU_Type) SetABORT_SOURCE0_ACT8(value uint32) {
	volatile.StoreUint32(&o.ABORT_SOURCE0.Reg, volatile.LoadUint32(&o.ABORT_SOURCE0.Reg)&^(0x100)|value<<8)
}
func (o *SCTIPU_Type) GetABORT_SOURCE0_ACT8() uint32 {
	return (volatile.LoadUint32(&o.ABORT_SOURCE0.Reg) & 0x100) >> 8
}

// SCTIPU.ABORT_ENABLE1: SCT IPU abort enable register: Selects which input source contributes to ORed Abort Output 0.
func (o *SCTIPU_Type) SetABORT_ENABLE1_ENA0(value uint32) {
	volatile.StoreUint32(&o.ABORT_ENABLE1.Reg, volatile.LoadUint32(&o.ABORT_ENABLE1.Reg)&^(0x1)|value)
}
func (o *SCTIPU_Type) GetABORT_ENABLE1_ENA0() uint32 {
	return volatile.LoadUint32(&o.ABORT_ENABLE1.Reg) & 0x1
}
func (o *SCTIPU_Type) SetABORT_ENABLE1_ENA1(value uint32) {
	volatile.StoreUint32(&o.ABORT_ENABLE1.Reg, volatile.LoadUint32(&o.ABORT_ENABLE1.Reg)&^(0x2)|value<<1)
}
func (o *SCTIPU_Type) GetABORT_ENABLE1_ENA1() uint32 {
	return (volatile.LoadUint32(&o.ABORT_ENABLE1.Reg) & 0x2) >> 1
}
func (o *SCTIPU_Type) SetABORT_ENABLE1_ENA2(value uint32) {
	volatile.StoreUint32(&o.ABORT_ENABLE1.Reg, volatile.LoadUint32(&o.ABORT_ENABLE1.Reg)&^(0x4)|value<<2)
}
func (o *SCTIPU_Type) GetABORT_ENABLE1_ENA2() uint32 {
	return (volatile.LoadUint32(&o.ABORT_ENABLE1.Reg) & 0x4) >> 2
}
func (o *SCTIPU_Type) SetABORT_ENABLE1_ENA3(value uint32) {
	volatile.StoreUint32(&o.ABORT_ENABLE1.Reg, volatile.LoadUint32(&o.ABORT_ENABLE1.Reg)&^(0x8)|value<<3)
}
func (o *SCTIPU_Type) GetABORT_ENABLE1_ENA3() uint32 {
	return (volatile.LoadUint32(&o.ABORT_ENABLE1.Reg) & 0x8) >> 3
}
func (o *SCTIPU_Type) SetABORT_ENABLE1_ENA4(value uint32) {
	volatile.StoreUint32(&o.ABORT_ENABLE1.Reg, volatile.LoadUint32(&o.ABORT_ENABLE1.Reg)&^(0x10)|value<<4)
}
func (o *SCTIPU_Type) GetABORT_ENABLE1_ENA4() uint32 {
	return (volatile.LoadUint32(&o.ABORT_ENABLE1.Reg) & 0x10) >> 4
}
func (o *SCTIPU_Type) SetABORT_ENABLE1_ENA5(value uint32) {
	volatile.StoreUint32(&o.ABORT_ENABLE1.Reg, volatile.LoadUint32(&o.ABORT_ENABLE1.Reg)&^(0x20)|value<<5)
}
func (o *SCTIPU_Type) GetABORT_ENABLE1_ENA5() uint32 {
	return (volatile.LoadUint32(&o.ABORT_ENABLE1.Reg) & 0x20) >> 5
}
func (o *SCTIPU_Type) SetABORT_ENABLE1_ENA6(value uint32) {
	volatile.StoreUint32(&o.ABORT_ENABLE1.Reg, volatile.LoadUint32(&o.ABORT_ENABLE1.Reg)&^(0x40)|value<<6)
}
func (o *SCTIPU_Type) GetABORT_ENABLE1_ENA6() uint32 {
	return (volatile.LoadUint32(&o.ABORT_ENABLE1.Reg) & 0x40) >> 6
}
func (o *SCTIPU_Type) SetABORT_ENABLE1_ENA7(value uint32) {
	volatile.StoreUint32(&o.ABORT_ENABLE1.Reg, volatile.LoadUint32(&o.ABORT_ENABLE1.Reg)&^(0x80)|value<<7)
}
func (o *SCTIPU_Type) GetABORT_ENABLE1_ENA7() uint32 {
	return (volatile.LoadUint32(&o.ABORT_ENABLE1.Reg) & 0x80) >> 7
}
func (o *SCTIPU_Type) SetABORT_ENABLE1_ENA8(value uint32) {
	volatile.StoreUint32(&o.ABORT_ENABLE1.Reg, volatile.LoadUint32(&o.ABORT_ENABLE1.Reg)&^(0x100)|value<<8)
}
func (o *SCTIPU_Type) GetABORT_ENABLE1_ENA8() uint32 {
	return (volatile.LoadUint32(&o.ABORT_ENABLE1.Reg) & 0x100) >> 8
}

// SCTIPU.ABORT_SOURCE1: SCT IPU abort source register: Status register indicating which input source caused abort output 0.
func (o *SCTIPU_Type) SetABORT_SOURCE1_ACT0(value uint32) {
	volatile.StoreUint32(&o.ABORT_SOURCE1.Reg, volatile.LoadUint32(&o.ABORT_SOURCE1.Reg)&^(0x1)|value)
}
func (o *SCTIPU_Type) GetABORT_SOURCE1_ACT0() uint32 {
	return volatile.LoadUint32(&o.ABORT_SOURCE1.Reg) & 0x1
}
func (o *SCTIPU_Type) SetABORT_SOURCE1_ACT1(value uint32) {
	volatile.StoreUint32(&o.ABORT_SOURCE1.Reg, volatile.LoadUint32(&o.ABORT_SOURCE1.Reg)&^(0x2)|value<<1)
}
func (o *SCTIPU_Type) GetABORT_SOURCE1_ACT1() uint32 {
	return (volatile.LoadUint32(&o.ABORT_SOURCE1.Reg) & 0x2) >> 1
}
func (o *SCTIPU_Type) SetABORT_SOURCE1_ACT2(value uint32) {
	volatile.StoreUint32(&o.ABORT_SOURCE1.Reg, volatile.LoadUint32(&o.ABORT_SOURCE1.Reg)&^(0x4)|value<<2)
}
func (o *SCTIPU_Type) GetABORT_SOURCE1_ACT2() uint32 {
	return (volatile.LoadUint32(&o.ABORT_SOURCE1.Reg) & 0x4) >> 2
}
func (o *SCTIPU_Type) SetABORT_SOURCE1_ACT3(value uint32) {
	volatile.StoreUint32(&o.ABORT_SOURCE1.Reg, volatile.LoadUint32(&o.ABORT_SOURCE1.Reg)&^(0x8)|value<<3)
}
func (o *SCTIPU_Type) GetABORT_SOURCE1_ACT3() uint32 {
	return (volatile.LoadUint32(&o.ABORT_SOURCE1.Reg) & 0x8) >> 3
}
func (o *SCTIPU_Type) SetABORT_SOURCE1_ACT4(value uint32) {
	volatile.StoreUint32(&o.ABORT_SOURCE1.Reg, volatile.LoadUint32(&o.ABORT_SOURCE1.Reg)&^(0x10)|value<<4)
}
func (o *SCTIPU_Type) GetABORT_SOURCE1_ACT4() uint32 {
	return (volatile.LoadUint32(&o.ABORT_SOURCE1.Reg) & 0x10) >> 4
}
func (o *SCTIPU_Type) SetABORT_SOURCE1_ACT5(value uint32) {
	volatile.StoreUint32(&o.ABORT_SOURCE1.Reg, volatile.LoadUint32(&o.ABORT_SOURCE1.Reg)&^(0x20)|value<<5)
}
func (o *SCTIPU_Type) GetABORT_SOURCE1_ACT5() uint32 {
	return (volatile.LoadUint32(&o.ABORT_SOURCE1.Reg) & 0x20) >> 5
}
func (o *SCTIPU_Type) SetABORT_SOURCE1_ACT6(value uint32) {
	volatile.StoreUint32(&o.ABORT_SOURCE1.Reg, volatile.LoadUint32(&o.ABORT_SOURCE1.Reg)&^(0x40)|value<<6)
}
func (o *SCTIPU_Type) GetABORT_SOURCE1_ACT6() uint32 {
	return (volatile.LoadUint32(&o.ABORT_SOURCE1.Reg) & 0x40) >> 6
}
func (o *SCTIPU_Type) SetABORT_SOURCE1_ACT7(value uint32) {
	volatile.StoreUint32(&o.ABORT_SOURCE1.Reg, volatile.LoadUint32(&o.ABORT_SOURCE1.Reg)&^(0x80)|value<<7)
}
func (o *SCTIPU_Type) GetABORT_SOURCE1_ACT7() uint32 {
	return (volatile.LoadUint32(&o.ABORT_SOURCE1.Reg) & 0x80) >> 7
}
func (o *SCTIPU_Type) SetABORT_SOURCE1_ACT8(value uint32) {
	volatile.StoreUint32(&o.ABORT_SOURCE1.Reg, volatile.LoadUint32(&o.ABORT_SOURCE1.Reg)&^(0x100)|value<<8)
}
func (o *SCTIPU_Type) GetABORT_SOURCE1_ACT8() uint32 {
	return (volatile.LoadUint32(&o.ABORT_SOURCE1.Reg) & 0x100) >> 8
}

// SCTIPU.ABORT_ENABLE2: SCT IPU abort enable register: Selects which input source contributes to ORed Abort Output 0.
func (o *SCTIPU_Type) SetABORT_ENABLE2_ENA0(value uint32) {
	volatile.StoreUint32(&o.ABORT_ENABLE2.Reg, volatile.LoadUint32(&o.ABORT_ENABLE2.Reg)&^(0x1)|value)
}
func (o *SCTIPU_Type) GetABORT_ENABLE2_ENA0() uint32 {
	return volatile.LoadUint32(&o.ABORT_ENABLE2.Reg) & 0x1
}
func (o *SCTIPU_Type) SetABORT_ENABLE2_ENA1(value uint32) {
	volatile.StoreUint32(&o.ABORT_ENABLE2.Reg, volatile.LoadUint32(&o.ABORT_ENABLE2.Reg)&^(0x2)|value<<1)
}
func (o *SCTIPU_Type) GetABORT_ENABLE2_ENA1() uint32 {
	return (volatile.LoadUint32(&o.ABORT_ENABLE2.Reg) & 0x2) >> 1
}
func (o *SCTIPU_Type) SetABORT_ENABLE2_ENA2(value uint32) {
	volatile.StoreUint32(&o.ABORT_ENABLE2.Reg, volatile.LoadUint32(&o.ABORT_ENABLE2.Reg)&^(0x4)|value<<2)
}
func (o *SCTIPU_Type) GetABORT_ENABLE2_ENA2() uint32 {
	return (volatile.LoadUint32(&o.ABORT_ENABLE2.Reg) & 0x4) >> 2
}
func (o *SCTIPU_Type) SetABORT_ENABLE2_ENA3(value uint32) {
	volatile.StoreUint32(&o.ABORT_ENABLE2.Reg, volatile.LoadUint32(&o.ABORT_ENABLE2.Reg)&^(0x8)|value<<3)
}
func (o *SCTIPU_Type) GetABORT_ENABLE2_ENA3() uint32 {
	return (volatile.LoadUint32(&o.ABORT_ENABLE2.Reg) & 0x8) >> 3
}
func (o *SCTIPU_Type) SetABORT_ENABLE2_ENA4(value uint32) {
	volatile.StoreUint32(&o.ABORT_ENABLE2.Reg, volatile.LoadUint32(&o.ABORT_ENABLE2.Reg)&^(0x10)|value<<4)
}
func (o *SCTIPU_Type) GetABORT_ENABLE2_ENA4() uint32 {
	return (volatile.LoadUint32(&o.ABORT_ENABLE2.Reg) & 0x10) >> 4
}
func (o *SCTIPU_Type) SetABORT_ENABLE2_ENA5(value uint32) {
	volatile.StoreUint32(&o.ABORT_ENABLE2.Reg, volatile.LoadUint32(&o.ABORT_ENABLE2.Reg)&^(0x20)|value<<5)
}
func (o *SCTIPU_Type) GetABORT_ENABLE2_ENA5() uint32 {
	return (volatile.LoadUint32(&o.ABORT_ENABLE2.Reg) & 0x20) >> 5
}
func (o *SCTIPU_Type) SetABORT_ENABLE2_ENA6(value uint32) {
	volatile.StoreUint32(&o.ABORT_ENABLE2.Reg, volatile.LoadUint32(&o.ABORT_ENABLE2.Reg)&^(0x40)|value<<6)
}
func (o *SCTIPU_Type) GetABORT_ENABLE2_ENA6() uint32 {
	return (volatile.LoadUint32(&o.ABORT_ENABLE2.Reg) & 0x40) >> 6
}
func (o *SCTIPU_Type) SetABORT_ENABLE2_ENA7(value uint32) {
	volatile.StoreUint32(&o.ABORT_ENABLE2.Reg, volatile.LoadUint32(&o.ABORT_ENABLE2.Reg)&^(0x80)|value<<7)
}
func (o *SCTIPU_Type) GetABORT_ENABLE2_ENA7() uint32 {
	return (volatile.LoadUint32(&o.ABORT_ENABLE2.Reg) & 0x80) >> 7
}
func (o *SCTIPU_Type) SetABORT_ENABLE2_ENA8(value uint32) {
	volatile.StoreUint32(&o.ABORT_ENABLE2.Reg, volatile.LoadUint32(&o.ABORT_ENABLE2.Reg)&^(0x100)|value<<8)
}
func (o *SCTIPU_Type) GetABORT_ENABLE2_ENA8() uint32 {
	return (volatile.LoadUint32(&o.ABORT_ENABLE2.Reg) & 0x100) >> 8
}

// SCTIPU.ABORT_SOURCE2: SCT IPU abort source register: Status register indicating which input source caused abort output 0.
func (o *SCTIPU_Type) SetABORT_SOURCE2_ACT0(value uint32) {
	volatile.StoreUint32(&o.ABORT_SOURCE2.Reg, volatile.LoadUint32(&o.ABORT_SOURCE2.Reg)&^(0x1)|value)
}
func (o *SCTIPU_Type) GetABORT_SOURCE2_ACT0() uint32 {
	return volatile.LoadUint32(&o.ABORT_SOURCE2.Reg) & 0x1
}
func (o *SCTIPU_Type) SetABORT_SOURCE2_ACT1(value uint32) {
	volatile.StoreUint32(&o.ABORT_SOURCE2.Reg, volatile.LoadUint32(&o.ABORT_SOURCE2.Reg)&^(0x2)|value<<1)
}
func (o *SCTIPU_Type) GetABORT_SOURCE2_ACT1() uint32 {
	return (volatile.LoadUint32(&o.ABORT_SOURCE2.Reg) & 0x2) >> 1
}
func (o *SCTIPU_Type) SetABORT_SOURCE2_ACT2(value uint32) {
	volatile.StoreUint32(&o.ABORT_SOURCE2.Reg, volatile.LoadUint32(&o.ABORT_SOURCE2.Reg)&^(0x4)|value<<2)
}
func (o *SCTIPU_Type) GetABORT_SOURCE2_ACT2() uint32 {
	return (volatile.LoadUint32(&o.ABORT_SOURCE2.Reg) & 0x4) >> 2
}
func (o *SCTIPU_Type) SetABORT_SOURCE2_ACT3(value uint32) {
	volatile.StoreUint32(&o.ABORT_SOURCE2.Reg, volatile.LoadUint32(&o.ABORT_SOURCE2.Reg)&^(0x8)|value<<3)
}
func (o *SCTIPU_Type) GetABORT_SOURCE2_ACT3() uint32 {
	return (volatile.LoadUint32(&o.ABORT_SOURCE2.Reg) & 0x8) >> 3
}
func (o *SCTIPU_Type) SetABORT_SOURCE2_ACT4(value uint32) {
	volatile.StoreUint32(&o.ABORT_SOURCE2.Reg, volatile.LoadUint32(&o.ABORT_SOURCE2.Reg)&^(0x10)|value<<4)
}
func (o *SCTIPU_Type) GetABORT_SOURCE2_ACT4() uint32 {
	return (volatile.LoadUint32(&o.ABORT_SOURCE2.Reg) & 0x10) >> 4
}
func (o *SCTIPU_Type) SetABORT_SOURCE2_ACT5(value uint32) {
	volatile.StoreUint32(&o.ABORT_SOURCE2.Reg, volatile.LoadUint32(&o.ABORT_SOURCE2.Reg)&^(0x20)|value<<5)
}
func (o *SCTIPU_Type) GetABORT_SOURCE2_ACT5() uint32 {
	return (volatile.LoadUint32(&o.ABORT_SOURCE2.Reg) & 0x20) >> 5
}
func (o *SCTIPU_Type) SetABORT_SOURCE2_ACT6(value uint32) {
	volatile.StoreUint32(&o.ABORT_SOURCE2.Reg, volatile.LoadUint32(&o.ABORT_SOURCE2.Reg)&^(0x40)|value<<6)
}
func (o *SCTIPU_Type) GetABORT_SOURCE2_ACT6() uint32 {
	return (volatile.LoadUint32(&o.ABORT_SOURCE2.Reg) & 0x40) >> 6
}
func (o *SCTIPU_Type) SetABORT_SOURCE2_ACT7(value uint32) {
	volatile.StoreUint32(&o.ABORT_SOURCE2.Reg, volatile.LoadUint32(&o.ABORT_SOURCE2.Reg)&^(0x80)|value<<7)
}
func (o *SCTIPU_Type) GetABORT_SOURCE2_ACT7() uint32 {
	return (volatile.LoadUint32(&o.ABORT_SOURCE2.Reg) & 0x80) >> 7
}
func (o *SCTIPU_Type) SetABORT_SOURCE2_ACT8(value uint32) {
	volatile.StoreUint32(&o.ABORT_SOURCE2.Reg, volatile.LoadUint32(&o.ABORT_SOURCE2.Reg)&^(0x100)|value<<8)
}
func (o *SCTIPU_Type) GetABORT_SOURCE2_ACT8() uint32 {
	return (volatile.LoadUint32(&o.ABORT_SOURCE2.Reg) & 0x100) >> 8
}

// SCTIPU.ABORT_ENABLE3: SCT IPU abort enable register: Selects which input source contributes to ORed Abort Output 0.
func (o *SCTIPU_Type) SetABORT_ENABLE3_ENA0(value uint32) {
	volatile.StoreUint32(&o.ABORT_ENABLE3.Reg, volatile.LoadUint32(&o.ABORT_ENABLE3.Reg)&^(0x1)|value)
}
func (o *SCTIPU_Type) GetABORT_ENABLE3_ENA0() uint32 {
	return volatile.LoadUint32(&o.ABORT_ENABLE3.Reg) & 0x1
}
func (o *SCTIPU_Type) SetABORT_ENABLE3_ENA1(value uint32) {
	volatile.StoreUint32(&o.ABORT_ENABLE3.Reg, volatile.LoadUint32(&o.ABORT_ENABLE3.Reg)&^(0x2)|value<<1)
}
func (o *SCTIPU_Type) GetABORT_ENABLE3_ENA1() uint32 {
	return (volatile.LoadUint32(&o.ABORT_ENABLE3.Reg) & 0x2) >> 1
}
func (o *SCTIPU_Type) SetABORT_ENABLE3_ENA2(value uint32) {
	volatile.StoreUint32(&o.ABORT_ENABLE3.Reg, volatile.LoadUint32(&o.ABORT_ENABLE3.Reg)&^(0x4)|value<<2)
}
func (o *SCTIPU_Type) GetABORT_ENABLE3_ENA2() uint32 {
	return (volatile.LoadUint32(&o.ABORT_ENABLE3.Reg) & 0x4) >> 2
}
func (o *SCTIPU_Type) SetABORT_ENABLE3_ENA3(value uint32) {
	volatile.StoreUint32(&o.ABORT_ENABLE3.Reg, volatile.LoadUint32(&o.ABORT_ENABLE3.Reg)&^(0x8)|value<<3)
}
func (o *SCTIPU_Type) GetABORT_ENABLE3_ENA3() uint32 {
	return (volatile.LoadUint32(&o.ABORT_ENABLE3.Reg) & 0x8) >> 3
}
func (o *SCTIPU_Type) SetABORT_ENABLE3_ENA4(value uint32) {
	volatile.StoreUint32(&o.ABORT_ENABLE3.Reg, volatile.LoadUint32(&o.ABORT_ENABLE3.Reg)&^(0x10)|value<<4)
}
func (o *SCTIPU_Type) GetABORT_ENABLE3_ENA4() uint32 {
	return (volatile.LoadUint32(&o.ABORT_ENABLE3.Reg) & 0x10) >> 4
}
func (o *SCTIPU_Type) SetABORT_ENABLE3_ENA5(value uint32) {
	volatile.StoreUint32(&o.ABORT_ENABLE3.Reg, volatile.LoadUint32(&o.ABORT_ENABLE3.Reg)&^(0x20)|value<<5)
}
func (o *SCTIPU_Type) GetABORT_ENABLE3_ENA5() uint32 {
	return (volatile.LoadUint32(&o.ABORT_ENABLE3.Reg) & 0x20) >> 5
}
func (o *SCTIPU_Type) SetABORT_ENABLE3_ENA6(value uint32) {
	volatile.StoreUint32(&o.ABORT_ENABLE3.Reg, volatile.LoadUint32(&o.ABORT_ENABLE3.Reg)&^(0x40)|value<<6)
}
func (o *SCTIPU_Type) GetABORT_ENABLE3_ENA6() uint32 {
	return (volatile.LoadUint32(&o.ABORT_ENABLE3.Reg) & 0x40) >> 6
}
func (o *SCTIPU_Type) SetABORT_ENABLE3_ENA7(value uint32) {
	volatile.StoreUint32(&o.ABORT_ENABLE3.Reg, volatile.LoadUint32(&o.ABORT_ENABLE3.Reg)&^(0x80)|value<<7)
}
func (o *SCTIPU_Type) GetABORT_ENABLE3_ENA7() uint32 {
	return (volatile.LoadUint32(&o.ABORT_ENABLE3.Reg) & 0x80) >> 7
}
func (o *SCTIPU_Type) SetABORT_ENABLE3_ENA8(value uint32) {
	volatile.StoreUint32(&o.ABORT_ENABLE3.Reg, volatile.LoadUint32(&o.ABORT_ENABLE3.Reg)&^(0x100)|value<<8)
}
func (o *SCTIPU_Type) GetABORT_ENABLE3_ENA8() uint32 {
	return (volatile.LoadUint32(&o.ABORT_ENABLE3.Reg) & 0x100) >> 8
}

// SCTIPU.ABORT_SOURCE3: SCT IPU abort source register: Status register indicating which input source caused abort output 0.
func (o *SCTIPU_Type) SetABORT_SOURCE3_ACT0(value uint32) {
	volatile.StoreUint32(&o.ABORT_SOURCE3.Reg, volatile.LoadUint32(&o.ABORT_SOURCE3.Reg)&^(0x1)|value)
}
func (o *SCTIPU_Type) GetABORT_SOURCE3_ACT0() uint32 {
	return volatile.LoadUint32(&o.ABORT_SOURCE3.Reg) & 0x1
}
func (o *SCTIPU_Type) SetABORT_SOURCE3_ACT1(value uint32) {
	volatile.StoreUint32(&o.ABORT_SOURCE3.Reg, volatile.LoadUint32(&o.ABORT_SOURCE3.Reg)&^(0x2)|value<<1)
}
func (o *SCTIPU_Type) GetABORT_SOURCE3_ACT1() uint32 {
	return (volatile.LoadUint32(&o.ABORT_SOURCE3.Reg) & 0x2) >> 1
}
func (o *SCTIPU_Type) SetABORT_SOURCE3_ACT2(value uint32) {
	volatile.StoreUint32(&o.ABORT_SOURCE3.Reg, volatile.LoadUint32(&o.ABORT_SOURCE3.Reg)&^(0x4)|value<<2)
}
func (o *SCTIPU_Type) GetABORT_SOURCE3_ACT2() uint32 {
	return (volatile.LoadUint32(&o.ABORT_SOURCE3.Reg) & 0x4) >> 2
}
func (o *SCTIPU_Type) SetABORT_SOURCE3_ACT3(value uint32) {
	volatile.StoreUint32(&o.ABORT_SOURCE3.Reg, volatile.LoadUint32(&o.ABORT_SOURCE3.Reg)&^(0x8)|value<<3)
}
func (o *SCTIPU_Type) GetABORT_SOURCE3_ACT3() uint32 {
	return (volatile.LoadUint32(&o.ABORT_SOURCE3.Reg) & 0x8) >> 3
}
func (o *SCTIPU_Type) SetABORT_SOURCE3_ACT4(value uint32) {
	volatile.StoreUint32(&o.ABORT_SOURCE3.Reg, volatile.LoadUint32(&o.ABORT_SOURCE3.Reg)&^(0x10)|value<<4)
}
func (o *SCTIPU_Type) GetABORT_SOURCE3_ACT4() uint32 {
	return (volatile.LoadUint32(&o.ABORT_SOURCE3.Reg) & 0x10) >> 4
}
func (o *SCTIPU_Type) SetABORT_SOURCE3_ACT5(value uint32) {
	volatile.StoreUint32(&o.ABORT_SOURCE3.Reg, volatile.LoadUint32(&o.ABORT_SOURCE3.Reg)&^(0x20)|value<<5)
}
func (o *SCTIPU_Type) GetABORT_SOURCE3_ACT5() uint32 {
	return (volatile.LoadUint32(&o.ABORT_SOURCE3.Reg) & 0x20) >> 5
}
func (o *SCTIPU_Type) SetABORT_SOURCE3_ACT6(value uint32) {
	volatile.StoreUint32(&o.ABORT_SOURCE3.Reg, volatile.LoadUint32(&o.ABORT_SOURCE3.Reg)&^(0x40)|value<<6)
}
func (o *SCTIPU_Type) GetABORT_SOURCE3_ACT6() uint32 {
	return (volatile.LoadUint32(&o.ABORT_SOURCE3.Reg) & 0x40) >> 6
}
func (o *SCTIPU_Type) SetABORT_SOURCE3_ACT7(value uint32) {
	volatile.StoreUint32(&o.ABORT_SOURCE3.Reg, volatile.LoadUint32(&o.ABORT_SOURCE3.Reg)&^(0x80)|value<<7)
}
func (o *SCTIPU_Type) GetABORT_SOURCE3_ACT7() uint32 {
	return (volatile.LoadUint32(&o.ABORT_SOURCE3.Reg) & 0x80) >> 7
}
func (o *SCTIPU_Type) SetABORT_SOURCE3_ACT8(value uint32) {
	volatile.StoreUint32(&o.ABORT_SOURCE3.Reg, volatile.LoadUint32(&o.ABORT_SOURCE3.Reg)&^(0x100)|value<<8)
}
func (o *SCTIPU_Type) GetABORT_SOURCE3_ACT8() uint32 {
	return (volatile.LoadUint32(&o.ABORT_SOURCE3.Reg) & 0x100) >> 8
}

// Flash controller
type FLASHCTRL_Type struct {
	_        [32]byte
	FMSSTART volatile.Register32 // 0x20
	FMSSTOP  volatile.Register32 // 0x24
	_        [4]byte
	FMSW0    volatile.Register32 // 0x2C
}

// FLASHCTRL.FMSSTART: Signature start address register
func (o *FLASHCTRL_Type) SetFMSSTART_START(value uint32) {
	volatile.StoreUint32(&o.FMSSTART.Reg, volatile.LoadUint32(&o.FMSSTART.Reg)&^(0x1ffff)|value)
}
func (o *FLASHCTRL_Type) GetFMSSTART_START() uint32 {
	return volatile.LoadUint32(&o.FMSSTART.Reg) & 0x1ffff
}
func (o *FLASHCTRL_Type) SetFMSSTART_RESERVED(value uint32) {
	volatile.StoreUint32(&o.FMSSTART.Reg, volatile.LoadUint32(&o.FMSSTART.Reg)&^(0xfffe0000)|value<<17)
}
func (o *FLASHCTRL_Type) GetFMSSTART_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.FMSSTART.Reg) & 0xfffe0000) >> 17
}

// FLASHCTRL.FMSSTOP: Signature stop-address register
func (o *FLASHCTRL_Type) SetFMSSTOP_STOPA(value uint32) {
	volatile.StoreUint32(&o.FMSSTOP.Reg, volatile.LoadUint32(&o.FMSSTOP.Reg)&^(0x1ffff)|value)
}
func (o *FLASHCTRL_Type) GetFMSSTOP_STOPA() uint32 {
	return volatile.LoadUint32(&o.FMSSTOP.Reg) & 0x1ffff
}
func (o *FLASHCTRL_Type) SetFMSSTOP_RESERVED(value uint32) {
	volatile.StoreUint32(&o.FMSSTOP.Reg, volatile.LoadUint32(&o.FMSSTOP.Reg)&^(0x7ffe0000)|value<<17)
}
func (o *FLASHCTRL_Type) GetFMSSTOP_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.FMSSTOP.Reg) & 0x7ffe0000) >> 17
}
func (o *FLASHCTRL_Type) SetFMSSTOP_STRTBIST(value uint32) {
	volatile.StoreUint32(&o.FMSSTOP.Reg, volatile.LoadUint32(&o.FMSSTOP.Reg)&^(0x80000000)|value<<31)
}
func (o *FLASHCTRL_Type) GetFMSSTOP_STRTBIST() uint32 {
	return (volatile.LoadUint32(&o.FMSSTOP.Reg) & 0x80000000) >> 31
}

// FLASHCTRL.FMSW0: Signature word
func (o *FLASHCTRL_Type) SetFMSW0(value uint32) {
	volatile.StoreUint32(&o.FMSW0.Reg, value)
}
func (o *FLASHCTRL_Type) GetFMSW0() uint32 {
	return volatile.LoadUint32(&o.FMSW0.Reg)
}

// Controller Area Network C_CAN0
type C_CAN0_Type struct {
	CNTL         volatile.Register32 // 0x0
	STAT         volatile.Register32 // 0x4
	EC           volatile.Register32 // 0x8
	BT           volatile.Register32 // 0xC
	INT          volatile.Register32 // 0x10
	TEST         volatile.Register32 // 0x14
	BRPE         volatile.Register32 // 0x18
	_            [4]byte
	IF1_CMDREQ   volatile.Register32 // 0x20
	IF1_CMDMSK_W volatile.Register32 // 0x24
	IF1_MSK1     volatile.Register32 // 0x28
	IF1_MSK2     volatile.Register32 // 0x2C
	IF1_ARB1     volatile.Register32 // 0x30
	IF1_ARB2     volatile.Register32 // 0x34
	IF1_MCTRL    volatile.Register32 // 0x38
	IF1_DA1      volatile.Register32 // 0x3C
	IF1_DA2      volatile.Register32 // 0x40
	IF1_DB1      volatile.Register32 // 0x44
	IF1_DB2      volatile.Register32 // 0x48
	_            [52]byte
	IF2_CMDREQ   volatile.Register32 // 0x80
	IF2_CMDMSK_W volatile.Register32 // 0x84
	IF2_MSK1     volatile.Register32 // 0x88
	IF2_MSK2     volatile.Register32 // 0x8C
	IF2_ARB1     volatile.Register32 // 0x90
	IF2_ARB2     volatile.Register32 // 0x94
	IF2_MCTRL    volatile.Register32 // 0x98
	IF2_DA1      volatile.Register32 // 0x9C
	IF2_DA2      volatile.Register32 // 0xA0
	IF2_DB1      volatile.Register32 // 0xA4
	IF2_DB2      volatile.Register32 // 0xA8
	_            [84]byte
	TXREQ1       volatile.Register32 // 0x100
	TXREQ2       volatile.Register32 // 0x104
	_            [24]byte
	ND1          volatile.Register32 // 0x120
	ND2          volatile.Register32 // 0x124
	_            [24]byte
	IR1          volatile.Register32 // 0x140
	IR2          volatile.Register32 // 0x144
	_            [24]byte
	MSGV1        volatile.Register32 // 0x160
	MSGV2        volatile.Register32 // 0x164
	_            [24]byte
	CLKDIV       volatile.Register32 // 0x180
}

// C_CAN0.CNTL: CAN control
func (o *C_CAN0_Type) SetCNTL_INIT(value uint32) {
	volatile.StoreUint32(&o.CNTL.Reg, volatile.LoadUint32(&o.CNTL.Reg)&^(0x1)|value)
}
func (o *C_CAN0_Type) GetCNTL_INIT() uint32 {
	return volatile.LoadUint32(&o.CNTL.Reg) & 0x1
}
func (o *C_CAN0_Type) SetCNTL_IE(value uint32) {
	volatile.StoreUint32(&o.CNTL.Reg, volatile.LoadUint32(&o.CNTL.Reg)&^(0x2)|value<<1)
}
func (o *C_CAN0_Type) GetCNTL_IE() uint32 {
	return (volatile.LoadUint32(&o.CNTL.Reg) & 0x2) >> 1
}
func (o *C_CAN0_Type) SetCNTL_SIE(value uint32) {
	volatile.StoreUint32(&o.CNTL.Reg, volatile.LoadUint32(&o.CNTL.Reg)&^(0x4)|value<<2)
}
func (o *C_CAN0_Type) GetCNTL_SIE() uint32 {
	return (volatile.LoadUint32(&o.CNTL.Reg) & 0x4) >> 2
}
func (o *C_CAN0_Type) SetCNTL_EIE(value uint32) {
	volatile.StoreUint32(&o.CNTL.Reg, volatile.LoadUint32(&o.CNTL.Reg)&^(0x8)|value<<3)
}
func (o *C_CAN0_Type) GetCNTL_EIE() uint32 {
	return (volatile.LoadUint32(&o.CNTL.Reg) & 0x8) >> 3
}
func (o *C_CAN0_Type) SetCNTL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CNTL.Reg, volatile.LoadUint32(&o.CNTL.Reg)&^(0x10)|value<<4)
}
func (o *C_CAN0_Type) GetCNTL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CNTL.Reg) & 0x10) >> 4
}
func (o *C_CAN0_Type) SetCNTL_DAR(value uint32) {
	volatile.StoreUint32(&o.CNTL.Reg, volatile.LoadUint32(&o.CNTL.Reg)&^(0x20)|value<<5)
}
func (o *C_CAN0_Type) GetCNTL_DAR() uint32 {
	return (volatile.LoadUint32(&o.CNTL.Reg) & 0x20) >> 5
}
func (o *C_CAN0_Type) SetCNTL_CCE(value uint32) {
	volatile.StoreUint32(&o.CNTL.Reg, volatile.LoadUint32(&o.CNTL.Reg)&^(0x40)|value<<6)
}
func (o *C_CAN0_Type) GetCNTL_CCE() uint32 {
	return (volatile.LoadUint32(&o.CNTL.Reg) & 0x40) >> 6
}
func (o *C_CAN0_Type) SetCNTL_TEST(value uint32) {
	volatile.StoreUint32(&o.CNTL.Reg, volatile.LoadUint32(&o.CNTL.Reg)&^(0x80)|value<<7)
}
func (o *C_CAN0_Type) GetCNTL_TEST() uint32 {
	return (volatile.LoadUint32(&o.CNTL.Reg) & 0x80) >> 7
}
func (o *C_CAN0_Type) SetCNTL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CNTL.Reg, volatile.LoadUint32(&o.CNTL.Reg)&^(0xffffff00)|value<<8)
}
func (o *C_CAN0_Type) GetCNTL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CNTL.Reg) & 0xffffff00) >> 8
}

// C_CAN0.STAT: Status register
func (o *C_CAN0_Type) SetSTAT_LEC(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x7)|value)
}
func (o *C_CAN0_Type) GetSTAT_LEC() uint32 {
	return volatile.LoadUint32(&o.STAT.Reg) & 0x7
}
func (o *C_CAN0_Type) SetSTAT_TXOK(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x8)|value<<3)
}
func (o *C_CAN0_Type) GetSTAT_TXOK() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x8) >> 3
}
func (o *C_CAN0_Type) SetSTAT_RXOK(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x10)|value<<4)
}
func (o *C_CAN0_Type) GetSTAT_RXOK() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x10) >> 4
}
func (o *C_CAN0_Type) SetSTAT_EPASS(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x20)|value<<5)
}
func (o *C_CAN0_Type) GetSTAT_EPASS() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x20) >> 5
}
func (o *C_CAN0_Type) SetSTAT_EWARN(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x40)|value<<6)
}
func (o *C_CAN0_Type) GetSTAT_EWARN() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x40) >> 6
}
func (o *C_CAN0_Type) SetSTAT_BOFF(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x80)|value<<7)
}
func (o *C_CAN0_Type) GetSTAT_BOFF() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x80) >> 7
}
func (o *C_CAN0_Type) SetSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0xffffff00)|value<<8)
}
func (o *C_CAN0_Type) GetSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0xffffff00) >> 8
}

// C_CAN0.EC: Error counter
func (o *C_CAN0_Type) SetEC_TEC7_0(value uint32) {
	volatile.StoreUint32(&o.EC.Reg, volatile.LoadUint32(&o.EC.Reg)&^(0xff)|value)
}
func (o *C_CAN0_Type) GetEC_TEC7_0() uint32 {
	return volatile.LoadUint32(&o.EC.Reg) & 0xff
}
func (o *C_CAN0_Type) SetEC_REC6_0(value uint32) {
	volatile.StoreUint32(&o.EC.Reg, volatile.LoadUint32(&o.EC.Reg)&^(0x7f00)|value<<8)
}
func (o *C_CAN0_Type) GetEC_REC6_0() uint32 {
	return (volatile.LoadUint32(&o.EC.Reg) & 0x7f00) >> 8
}
func (o *C_CAN0_Type) SetEC_RP(value uint32) {
	volatile.StoreUint32(&o.EC.Reg, volatile.LoadUint32(&o.EC.Reg)&^(0x8000)|value<<15)
}
func (o *C_CAN0_Type) GetEC_RP() uint32 {
	return (volatile.LoadUint32(&o.EC.Reg) & 0x8000) >> 15
}
func (o *C_CAN0_Type) SetEC_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EC.Reg, volatile.LoadUint32(&o.EC.Reg)&^(0xffff0000)|value<<16)
}
func (o *C_CAN0_Type) GetEC_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EC.Reg) & 0xffff0000) >> 16
}

// C_CAN0.BT: Bit timing register
func (o *C_CAN0_Type) SetBT_BRP(value uint32) {
	volatile.StoreUint32(&o.BT.Reg, volatile.LoadUint32(&o.BT.Reg)&^(0x3f)|value)
}
func (o *C_CAN0_Type) GetBT_BRP() uint32 {
	return volatile.LoadUint32(&o.BT.Reg) & 0x3f
}
func (o *C_CAN0_Type) SetBT_SJW(value uint32) {
	volatile.StoreUint32(&o.BT.Reg, volatile.LoadUint32(&o.BT.Reg)&^(0xc0)|value<<6)
}
func (o *C_CAN0_Type) GetBT_SJW() uint32 {
	return (volatile.LoadUint32(&o.BT.Reg) & 0xc0) >> 6
}
func (o *C_CAN0_Type) SetBT_TSEG1(value uint32) {
	volatile.StoreUint32(&o.BT.Reg, volatile.LoadUint32(&o.BT.Reg)&^(0xf00)|value<<8)
}
func (o *C_CAN0_Type) GetBT_TSEG1() uint32 {
	return (volatile.LoadUint32(&o.BT.Reg) & 0xf00) >> 8
}
func (o *C_CAN0_Type) SetBT_TSEG2(value uint32) {
	volatile.StoreUint32(&o.BT.Reg, volatile.LoadUint32(&o.BT.Reg)&^(0x7000)|value<<12)
}
func (o *C_CAN0_Type) GetBT_TSEG2() uint32 {
	return (volatile.LoadUint32(&o.BT.Reg) & 0x7000) >> 12
}
func (o *C_CAN0_Type) SetBT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.BT.Reg, volatile.LoadUint32(&o.BT.Reg)&^(0xffff8000)|value<<15)
}
func (o *C_CAN0_Type) GetBT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.BT.Reg) & 0xffff8000) >> 15
}

// C_CAN0.INT: Interrupt register
func (o *C_CAN0_Type) SetINT_INTID(value uint32) {
	volatile.StoreUint32(&o.INT.Reg, volatile.LoadUint32(&o.INT.Reg)&^(0xffff)|value)
}
func (o *C_CAN0_Type) GetINT_INTID() uint32 {
	return volatile.LoadUint32(&o.INT.Reg) & 0xffff
}
func (o *C_CAN0_Type) SetINT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INT.Reg, volatile.LoadUint32(&o.INT.Reg)&^(0xffff0000)|value<<16)
}
func (o *C_CAN0_Type) GetINT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INT.Reg) & 0xffff0000) >> 16
}

// C_CAN0.TEST: Test register
func (o *C_CAN0_Type) SetTEST_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TEST.Reg, volatile.LoadUint32(&o.TEST.Reg)&^(0x3)|value)
}
func (o *C_CAN0_Type) GetTEST_RESERVED() uint32 {
	return volatile.LoadUint32(&o.TEST.Reg) & 0x3
}
func (o *C_CAN0_Type) SetTEST_BASIC(value uint32) {
	volatile.StoreUint32(&o.TEST.Reg, volatile.LoadUint32(&o.TEST.Reg)&^(0x4)|value<<2)
}
func (o *C_CAN0_Type) GetTEST_BASIC() uint32 {
	return (volatile.LoadUint32(&o.TEST.Reg) & 0x4) >> 2
}
func (o *C_CAN0_Type) SetTEST_SILENT(value uint32) {
	volatile.StoreUint32(&o.TEST.Reg, volatile.LoadUint32(&o.TEST.Reg)&^(0x8)|value<<3)
}
func (o *C_CAN0_Type) GetTEST_SILENT() uint32 {
	return (volatile.LoadUint32(&o.TEST.Reg) & 0x8) >> 3
}
func (o *C_CAN0_Type) SetTEST_LBACK(value uint32) {
	volatile.StoreUint32(&o.TEST.Reg, volatile.LoadUint32(&o.TEST.Reg)&^(0x10)|value<<4)
}
func (o *C_CAN0_Type) GetTEST_LBACK() uint32 {
	return (volatile.LoadUint32(&o.TEST.Reg) & 0x10) >> 4
}
func (o *C_CAN0_Type) SetTEST_TX(value uint32) {
	volatile.StoreUint32(&o.TEST.Reg, volatile.LoadUint32(&o.TEST.Reg)&^(0x60)|value<<5)
}
func (o *C_CAN0_Type) GetTEST_TX() uint32 {
	return (volatile.LoadUint32(&o.TEST.Reg) & 0x60) >> 5
}
func (o *C_CAN0_Type) SetTEST_RX(value uint32) {
	volatile.StoreUint32(&o.TEST.Reg, volatile.LoadUint32(&o.TEST.Reg)&^(0x80)|value<<7)
}
func (o *C_CAN0_Type) GetTEST_RX() uint32 {
	return (volatile.LoadUint32(&o.TEST.Reg) & 0x80) >> 7
}
func (o *C_CAN0_Type) SetTEST_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TEST.Reg, volatile.LoadUint32(&o.TEST.Reg)&^(0xffffff00)|value<<8)
}
func (o *C_CAN0_Type) GetTEST_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TEST.Reg) & 0xffffff00) >> 8
}

// C_CAN0.BRPE: Baud rate prescaler extension register
func (o *C_CAN0_Type) SetBRPE(value uint32) {
	volatile.StoreUint32(&o.BRPE.Reg, volatile.LoadUint32(&o.BRPE.Reg)&^(0xf)|value)
}
func (o *C_CAN0_Type) GetBRPE() uint32 {
	return volatile.LoadUint32(&o.BRPE.Reg) & 0xf
}
func (o *C_CAN0_Type) SetBRPE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.BRPE.Reg, volatile.LoadUint32(&o.BRPE.Reg)&^(0xfffffff0)|value<<4)
}
func (o *C_CAN0_Type) GetBRPE_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.BRPE.Reg) & 0xfffffff0) >> 4
}

// C_CAN0.IF1_CMDREQ: Message interface command request
func (o *C_CAN0_Type) SetIF1_CMDREQ_MN(value uint32) {
	volatile.StoreUint32(&o.IF1_CMDREQ.Reg, volatile.LoadUint32(&o.IF1_CMDREQ.Reg)&^(0x3f)|value)
}
func (o *C_CAN0_Type) GetIF1_CMDREQ_MN() uint32 {
	return volatile.LoadUint32(&o.IF1_CMDREQ.Reg) & 0x3f
}
func (o *C_CAN0_Type) SetIF1_CMDREQ_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IF1_CMDREQ.Reg, volatile.LoadUint32(&o.IF1_CMDREQ.Reg)&^(0x7fc0)|value<<6)
}
func (o *C_CAN0_Type) GetIF1_CMDREQ_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IF1_CMDREQ.Reg) & 0x7fc0) >> 6
}
func (o *C_CAN0_Type) SetIF1_CMDREQ_BUSY(value uint32) {
	volatile.StoreUint32(&o.IF1_CMDREQ.Reg, volatile.LoadUint32(&o.IF1_CMDREQ.Reg)&^(0x8000)|value<<15)
}
func (o *C_CAN0_Type) GetIF1_CMDREQ_BUSY() uint32 {
	return (volatile.LoadUint32(&o.IF1_CMDREQ.Reg) & 0x8000) >> 15
}
func (o *C_CAN0_Type) SetIF1_CMDREQ_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IF1_CMDREQ.Reg, volatile.LoadUint32(&o.IF1_CMDREQ.Reg)&^(0xffff0000)|value<<16)
}
func (o *C_CAN0_Type) GetIF1_CMDREQ_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IF1_CMDREQ.Reg) & 0xffff0000) >> 16
}

// C_CAN0.IF1_CMDMSK_W: Message interface command mask (write direction)
func (o *C_CAN0_Type) SetIF1_CMDMSK_W_DATA_B(value uint32) {
	volatile.StoreUint32(&o.IF1_CMDMSK_W.Reg, volatile.LoadUint32(&o.IF1_CMDMSK_W.Reg)&^(0x1)|value)
}
func (o *C_CAN0_Type) GetIF1_CMDMSK_W_DATA_B() uint32 {
	return volatile.LoadUint32(&o.IF1_CMDMSK_W.Reg) & 0x1
}
func (o *C_CAN0_Type) SetIF1_CMDMSK_W_DATA_A(value uint32) {
	volatile.StoreUint32(&o.IF1_CMDMSK_W.Reg, volatile.LoadUint32(&o.IF1_CMDMSK_W.Reg)&^(0x2)|value<<1)
}
func (o *C_CAN0_Type) GetIF1_CMDMSK_W_DATA_A() uint32 {
	return (volatile.LoadUint32(&o.IF1_CMDMSK_W.Reg) & 0x2) >> 1
}
func (o *C_CAN0_Type) SetIF1_CMDMSK_W_TXRQST(value uint32) {
	volatile.StoreUint32(&o.IF1_CMDMSK_W.Reg, volatile.LoadUint32(&o.IF1_CMDMSK_W.Reg)&^(0x4)|value<<2)
}
func (o *C_CAN0_Type) GetIF1_CMDMSK_W_TXRQST() uint32 {
	return (volatile.LoadUint32(&o.IF1_CMDMSK_W.Reg) & 0x4) >> 2
}
func (o *C_CAN0_Type) SetIF1_CMDMSK_W_CLRINTPND(value uint32) {
	volatile.StoreUint32(&o.IF1_CMDMSK_W.Reg, volatile.LoadUint32(&o.IF1_CMDMSK_W.Reg)&^(0x8)|value<<3)
}
func (o *C_CAN0_Type) GetIF1_CMDMSK_W_CLRINTPND() uint32 {
	return (volatile.LoadUint32(&o.IF1_CMDMSK_W.Reg) & 0x8) >> 3
}
func (o *C_CAN0_Type) SetIF1_CMDMSK_W_CTRL(value uint32) {
	volatile.StoreUint32(&o.IF1_CMDMSK_W.Reg, volatile.LoadUint32(&o.IF1_CMDMSK_W.Reg)&^(0x10)|value<<4)
}
func (o *C_CAN0_Type) GetIF1_CMDMSK_W_CTRL() uint32 {
	return (volatile.LoadUint32(&o.IF1_CMDMSK_W.Reg) & 0x10) >> 4
}
func (o *C_CAN0_Type) SetIF1_CMDMSK_W_ARB(value uint32) {
	volatile.StoreUint32(&o.IF1_CMDMSK_W.Reg, volatile.LoadUint32(&o.IF1_CMDMSK_W.Reg)&^(0x20)|value<<5)
}
func (o *C_CAN0_Type) GetIF1_CMDMSK_W_ARB() uint32 {
	return (volatile.LoadUint32(&o.IF1_CMDMSK_W.Reg) & 0x20) >> 5
}
func (o *C_CAN0_Type) SetIF1_CMDMSK_W_MASK(value uint32) {
	volatile.StoreUint32(&o.IF1_CMDMSK_W.Reg, volatile.LoadUint32(&o.IF1_CMDMSK_W.Reg)&^(0x40)|value<<6)
}
func (o *C_CAN0_Type) GetIF1_CMDMSK_W_MASK() uint32 {
	return (volatile.LoadUint32(&o.IF1_CMDMSK_W.Reg) & 0x40) >> 6
}
func (o *C_CAN0_Type) SetIF1_CMDMSK_W_WR_RD(value uint32) {
	volatile.StoreUint32(&o.IF1_CMDMSK_W.Reg, volatile.LoadUint32(&o.IF1_CMDMSK_W.Reg)&^(0x80)|value<<7)
}
func (o *C_CAN0_Type) GetIF1_CMDMSK_W_WR_RD() uint32 {
	return (volatile.LoadUint32(&o.IF1_CMDMSK_W.Reg) & 0x80) >> 7
}
func (o *C_CAN0_Type) SetIF1_CMDMSK_W_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IF1_CMDMSK_W.Reg, volatile.LoadUint32(&o.IF1_CMDMSK_W.Reg)&^(0xffffff00)|value<<8)
}
func (o *C_CAN0_Type) GetIF1_CMDMSK_W_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IF1_CMDMSK_W.Reg) & 0xffffff00) >> 8
}

// C_CAN0.IF1_MSK1: Message interface mask 1
func (o *C_CAN0_Type) SetIF1_MSK1_MSK15_0(value uint32) {
	volatile.StoreUint32(&o.IF1_MSK1.Reg, volatile.LoadUint32(&o.IF1_MSK1.Reg)&^(0xffff)|value)
}
func (o *C_CAN0_Type) GetIF1_MSK1_MSK15_0() uint32 {
	return volatile.LoadUint32(&o.IF1_MSK1.Reg) & 0xffff
}
func (o *C_CAN0_Type) SetIF1_MSK1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IF1_MSK1.Reg, volatile.LoadUint32(&o.IF1_MSK1.Reg)&^(0xffff0000)|value<<16)
}
func (o *C_CAN0_Type) GetIF1_MSK1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IF1_MSK1.Reg) & 0xffff0000) >> 16
}

// C_CAN0.IF1_MSK2: Message interface mask 2
func (o *C_CAN0_Type) SetIF1_MSK2_MSK28_16(value uint32) {
	volatile.StoreUint32(&o.IF1_MSK2.Reg, volatile.LoadUint32(&o.IF1_MSK2.Reg)&^(0x1fff)|value)
}
func (o *C_CAN0_Type) GetIF1_MSK2_MSK28_16() uint32 {
	return volatile.LoadUint32(&o.IF1_MSK2.Reg) & 0x1fff
}
func (o *C_CAN0_Type) SetIF1_MSK2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IF1_MSK2.Reg, volatile.LoadUint32(&o.IF1_MSK2.Reg)&^(0x2000)|value<<13)
}
func (o *C_CAN0_Type) GetIF1_MSK2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IF1_MSK2.Reg) & 0x2000) >> 13
}
func (o *C_CAN0_Type) SetIF1_MSK2_MDIR(value uint32) {
	volatile.StoreUint32(&o.IF1_MSK2.Reg, volatile.LoadUint32(&o.IF1_MSK2.Reg)&^(0x4000)|value<<14)
}
func (o *C_CAN0_Type) GetIF1_MSK2_MDIR() uint32 {
	return (volatile.LoadUint32(&o.IF1_MSK2.Reg) & 0x4000) >> 14
}
func (o *C_CAN0_Type) SetIF1_MSK2_MXTD(value uint32) {
	volatile.StoreUint32(&o.IF1_MSK2.Reg, volatile.LoadUint32(&o.IF1_MSK2.Reg)&^(0x8000)|value<<15)
}
func (o *C_CAN0_Type) GetIF1_MSK2_MXTD() uint32 {
	return (volatile.LoadUint32(&o.IF1_MSK2.Reg) & 0x8000) >> 15
}
func (o *C_CAN0_Type) SetIF1_MSK2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IF1_MSK2.Reg, volatile.LoadUint32(&o.IF1_MSK2.Reg)&^(0xffff0000)|value<<16)
}
func (o *C_CAN0_Type) GetIF1_MSK2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IF1_MSK2.Reg) & 0xffff0000) >> 16
}

// C_CAN0.IF1_ARB1: Message interface arbitration 1
func (o *C_CAN0_Type) SetIF1_ARB1_ID15_0(value uint32) {
	volatile.StoreUint32(&o.IF1_ARB1.Reg, volatile.LoadUint32(&o.IF1_ARB1.Reg)&^(0xffff)|value)
}
func (o *C_CAN0_Type) GetIF1_ARB1_ID15_0() uint32 {
	return volatile.LoadUint32(&o.IF1_ARB1.Reg) & 0xffff
}
func (o *C_CAN0_Type) SetIF1_ARB1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IF1_ARB1.Reg, volatile.LoadUint32(&o.IF1_ARB1.Reg)&^(0xffff0000)|value<<16)
}
func (o *C_CAN0_Type) GetIF1_ARB1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IF1_ARB1.Reg) & 0xffff0000) >> 16
}

// C_CAN0.IF1_ARB2: Message interface arbitration 2
func (o *C_CAN0_Type) SetIF1_ARB2_ID28_16(value uint32) {
	volatile.StoreUint32(&o.IF1_ARB2.Reg, volatile.LoadUint32(&o.IF1_ARB2.Reg)&^(0x1fff)|value)
}
func (o *C_CAN0_Type) GetIF1_ARB2_ID28_16() uint32 {
	return volatile.LoadUint32(&o.IF1_ARB2.Reg) & 0x1fff
}
func (o *C_CAN0_Type) SetIF1_ARB2_DIR(value uint32) {
	volatile.StoreUint32(&o.IF1_ARB2.Reg, volatile.LoadUint32(&o.IF1_ARB2.Reg)&^(0x2000)|value<<13)
}
func (o *C_CAN0_Type) GetIF1_ARB2_DIR() uint32 {
	return (volatile.LoadUint32(&o.IF1_ARB2.Reg) & 0x2000) >> 13
}
func (o *C_CAN0_Type) SetIF1_ARB2_XTD(value uint32) {
	volatile.StoreUint32(&o.IF1_ARB2.Reg, volatile.LoadUint32(&o.IF1_ARB2.Reg)&^(0x4000)|value<<14)
}
func (o *C_CAN0_Type) GetIF1_ARB2_XTD() uint32 {
	return (volatile.LoadUint32(&o.IF1_ARB2.Reg) & 0x4000) >> 14
}
func (o *C_CAN0_Type) SetIF1_ARB2_MSGVAL(value uint32) {
	volatile.StoreUint32(&o.IF1_ARB2.Reg, volatile.LoadUint32(&o.IF1_ARB2.Reg)&^(0x8000)|value<<15)
}
func (o *C_CAN0_Type) GetIF1_ARB2_MSGVAL() uint32 {
	return (volatile.LoadUint32(&o.IF1_ARB2.Reg) & 0x8000) >> 15
}
func (o *C_CAN0_Type) SetIF1_ARB2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IF1_ARB2.Reg, volatile.LoadUint32(&o.IF1_ARB2.Reg)&^(0xffff0000)|value<<16)
}
func (o *C_CAN0_Type) GetIF1_ARB2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IF1_ARB2.Reg) & 0xffff0000) >> 16
}

// C_CAN0.IF1_MCTRL: Message interface message control
func (o *C_CAN0_Type) SetIF1_MCTRL_DLC3_0(value uint32) {
	volatile.StoreUint32(&o.IF1_MCTRL.Reg, volatile.LoadUint32(&o.IF1_MCTRL.Reg)&^(0xf)|value)
}
func (o *C_CAN0_Type) GetIF1_MCTRL_DLC3_0() uint32 {
	return volatile.LoadUint32(&o.IF1_MCTRL.Reg) & 0xf
}
func (o *C_CAN0_Type) SetIF1_MCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IF1_MCTRL.Reg, volatile.LoadUint32(&o.IF1_MCTRL.Reg)&^(0x70)|value<<4)
}
func (o *C_CAN0_Type) GetIF1_MCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IF1_MCTRL.Reg) & 0x70) >> 4
}
func (o *C_CAN0_Type) SetIF1_MCTRL_EOB(value uint32) {
	volatile.StoreUint32(&o.IF1_MCTRL.Reg, volatile.LoadUint32(&o.IF1_MCTRL.Reg)&^(0x80)|value<<7)
}
func (o *C_CAN0_Type) GetIF1_MCTRL_EOB() uint32 {
	return (volatile.LoadUint32(&o.IF1_MCTRL.Reg) & 0x80) >> 7
}
func (o *C_CAN0_Type) SetIF1_MCTRL_TXRQST(value uint32) {
	volatile.StoreUint32(&o.IF1_MCTRL.Reg, volatile.LoadUint32(&o.IF1_MCTRL.Reg)&^(0x100)|value<<8)
}
func (o *C_CAN0_Type) GetIF1_MCTRL_TXRQST() uint32 {
	return (volatile.LoadUint32(&o.IF1_MCTRL.Reg) & 0x100) >> 8
}
func (o *C_CAN0_Type) SetIF1_MCTRL_RMTEN(value uint32) {
	volatile.StoreUint32(&o.IF1_MCTRL.Reg, volatile.LoadUint32(&o.IF1_MCTRL.Reg)&^(0x200)|value<<9)
}
func (o *C_CAN0_Type) GetIF1_MCTRL_RMTEN() uint32 {
	return (volatile.LoadUint32(&o.IF1_MCTRL.Reg) & 0x200) >> 9
}
func (o *C_CAN0_Type) SetIF1_MCTRL_RXIE(value uint32) {
	volatile.StoreUint32(&o.IF1_MCTRL.Reg, volatile.LoadUint32(&o.IF1_MCTRL.Reg)&^(0x400)|value<<10)
}
func (o *C_CAN0_Type) GetIF1_MCTRL_RXIE() uint32 {
	return (volatile.LoadUint32(&o.IF1_MCTRL.Reg) & 0x400) >> 10
}
func (o *C_CAN0_Type) SetIF1_MCTRL_TXIE(value uint32) {
	volatile.StoreUint32(&o.IF1_MCTRL.Reg, volatile.LoadUint32(&o.IF1_MCTRL.Reg)&^(0x800)|value<<11)
}
func (o *C_CAN0_Type) GetIF1_MCTRL_TXIE() uint32 {
	return (volatile.LoadUint32(&o.IF1_MCTRL.Reg) & 0x800) >> 11
}
func (o *C_CAN0_Type) SetIF1_MCTRL_UMASK(value uint32) {
	volatile.StoreUint32(&o.IF1_MCTRL.Reg, volatile.LoadUint32(&o.IF1_MCTRL.Reg)&^(0x1000)|value<<12)
}
func (o *C_CAN0_Type) GetIF1_MCTRL_UMASK() uint32 {
	return (volatile.LoadUint32(&o.IF1_MCTRL.Reg) & 0x1000) >> 12
}
func (o *C_CAN0_Type) SetIF1_MCTRL_INTPND(value uint32) {
	volatile.StoreUint32(&o.IF1_MCTRL.Reg, volatile.LoadUint32(&o.IF1_MCTRL.Reg)&^(0x2000)|value<<13)
}
func (o *C_CAN0_Type) GetIF1_MCTRL_INTPND() uint32 {
	return (volatile.LoadUint32(&o.IF1_MCTRL.Reg) & 0x2000) >> 13
}
func (o *C_CAN0_Type) SetIF1_MCTRL_MSGLST(value uint32) {
	volatile.StoreUint32(&o.IF1_MCTRL.Reg, volatile.LoadUint32(&o.IF1_MCTRL.Reg)&^(0x4000)|value<<14)
}
func (o *C_CAN0_Type) GetIF1_MCTRL_MSGLST() uint32 {
	return (volatile.LoadUint32(&o.IF1_MCTRL.Reg) & 0x4000) >> 14
}
func (o *C_CAN0_Type) SetIF1_MCTRL_NEWDAT(value uint32) {
	volatile.StoreUint32(&o.IF1_MCTRL.Reg, volatile.LoadUint32(&o.IF1_MCTRL.Reg)&^(0x8000)|value<<15)
}
func (o *C_CAN0_Type) GetIF1_MCTRL_NEWDAT() uint32 {
	return (volatile.LoadUint32(&o.IF1_MCTRL.Reg) & 0x8000) >> 15
}
func (o *C_CAN0_Type) SetIF1_MCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IF1_MCTRL.Reg, volatile.LoadUint32(&o.IF1_MCTRL.Reg)&^(0xffff0000)|value<<16)
}
func (o *C_CAN0_Type) GetIF1_MCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IF1_MCTRL.Reg) & 0xffff0000) >> 16
}

// C_CAN0.IF1_DA1: Message interface data A1
func (o *C_CAN0_Type) SetIF1_DA1_DATA0(value uint32) {
	volatile.StoreUint32(&o.IF1_DA1.Reg, volatile.LoadUint32(&o.IF1_DA1.Reg)&^(0xff)|value)
}
func (o *C_CAN0_Type) GetIF1_DA1_DATA0() uint32 {
	return volatile.LoadUint32(&o.IF1_DA1.Reg) & 0xff
}
func (o *C_CAN0_Type) SetIF1_DA1_DATA1(value uint32) {
	volatile.StoreUint32(&o.IF1_DA1.Reg, volatile.LoadUint32(&o.IF1_DA1.Reg)&^(0xff00)|value<<8)
}
func (o *C_CAN0_Type) GetIF1_DA1_DATA1() uint32 {
	return (volatile.LoadUint32(&o.IF1_DA1.Reg) & 0xff00) >> 8
}
func (o *C_CAN0_Type) SetIF1_DA1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IF1_DA1.Reg, volatile.LoadUint32(&o.IF1_DA1.Reg)&^(0xffff0000)|value<<16)
}
func (o *C_CAN0_Type) GetIF1_DA1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IF1_DA1.Reg) & 0xffff0000) >> 16
}

// C_CAN0.IF1_DA2: Message interface 1 data A2
func (o *C_CAN0_Type) SetIF1_DA2_DATA2(value uint32) {
	volatile.StoreUint32(&o.IF1_DA2.Reg, volatile.LoadUint32(&o.IF1_DA2.Reg)&^(0xff)|value)
}
func (o *C_CAN0_Type) GetIF1_DA2_DATA2() uint32 {
	return volatile.LoadUint32(&o.IF1_DA2.Reg) & 0xff
}
func (o *C_CAN0_Type) SetIF1_DA2_DATA3(value uint32) {
	volatile.StoreUint32(&o.IF1_DA2.Reg, volatile.LoadUint32(&o.IF1_DA2.Reg)&^(0xff00)|value<<8)
}
func (o *C_CAN0_Type) GetIF1_DA2_DATA3() uint32 {
	return (volatile.LoadUint32(&o.IF1_DA2.Reg) & 0xff00) >> 8
}
func (o *C_CAN0_Type) SetIF1_DA2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IF1_DA2.Reg, volatile.LoadUint32(&o.IF1_DA2.Reg)&^(0xffff0000)|value<<16)
}
func (o *C_CAN0_Type) GetIF1_DA2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IF1_DA2.Reg) & 0xffff0000) >> 16
}

// C_CAN0.IF1_DB1: Message interface 1 data B1
func (o *C_CAN0_Type) SetIF1_DB1_DATA4(value uint32) {
	volatile.StoreUint32(&o.IF1_DB1.Reg, volatile.LoadUint32(&o.IF1_DB1.Reg)&^(0xff)|value)
}
func (o *C_CAN0_Type) GetIF1_DB1_DATA4() uint32 {
	return volatile.LoadUint32(&o.IF1_DB1.Reg) & 0xff
}
func (o *C_CAN0_Type) SetIF1_DB1_DATA5(value uint32) {
	volatile.StoreUint32(&o.IF1_DB1.Reg, volatile.LoadUint32(&o.IF1_DB1.Reg)&^(0xff00)|value<<8)
}
func (o *C_CAN0_Type) GetIF1_DB1_DATA5() uint32 {
	return (volatile.LoadUint32(&o.IF1_DB1.Reg) & 0xff00) >> 8
}
func (o *C_CAN0_Type) SetIF1_DB1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IF1_DB1.Reg, volatile.LoadUint32(&o.IF1_DB1.Reg)&^(0xffff0000)|value<<16)
}
func (o *C_CAN0_Type) GetIF1_DB1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IF1_DB1.Reg) & 0xffff0000) >> 16
}

// C_CAN0.IF1_DB2: Message interface 1 data B2
func (o *C_CAN0_Type) SetIF1_DB2_DATA6(value uint32) {
	volatile.StoreUint32(&o.IF1_DB2.Reg, volatile.LoadUint32(&o.IF1_DB2.Reg)&^(0xff)|value)
}
func (o *C_CAN0_Type) GetIF1_DB2_DATA6() uint32 {
	return volatile.LoadUint32(&o.IF1_DB2.Reg) & 0xff
}
func (o *C_CAN0_Type) SetIF1_DB2_DATA7(value uint32) {
	volatile.StoreUint32(&o.IF1_DB2.Reg, volatile.LoadUint32(&o.IF1_DB2.Reg)&^(0xff00)|value<<8)
}
func (o *C_CAN0_Type) GetIF1_DB2_DATA7() uint32 {
	return (volatile.LoadUint32(&o.IF1_DB2.Reg) & 0xff00) >> 8
}
func (o *C_CAN0_Type) SetIF1_DB2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IF1_DB2.Reg, volatile.LoadUint32(&o.IF1_DB2.Reg)&^(0xffff0000)|value<<16)
}
func (o *C_CAN0_Type) GetIF1_DB2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IF1_DB2.Reg) & 0xffff0000) >> 16
}

// C_CAN0.IF2_CMDREQ: Message interface command request
func (o *C_CAN0_Type) SetIF2_CMDREQ_MN(value uint32) {
	volatile.StoreUint32(&o.IF2_CMDREQ.Reg, volatile.LoadUint32(&o.IF2_CMDREQ.Reg)&^(0x3f)|value)
}
func (o *C_CAN0_Type) GetIF2_CMDREQ_MN() uint32 {
	return volatile.LoadUint32(&o.IF2_CMDREQ.Reg) & 0x3f
}
func (o *C_CAN0_Type) SetIF2_CMDREQ_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IF2_CMDREQ.Reg, volatile.LoadUint32(&o.IF2_CMDREQ.Reg)&^(0x7fc0)|value<<6)
}
func (o *C_CAN0_Type) GetIF2_CMDREQ_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IF2_CMDREQ.Reg) & 0x7fc0) >> 6
}
func (o *C_CAN0_Type) SetIF2_CMDREQ_BUSY(value uint32) {
	volatile.StoreUint32(&o.IF2_CMDREQ.Reg, volatile.LoadUint32(&o.IF2_CMDREQ.Reg)&^(0x8000)|value<<15)
}
func (o *C_CAN0_Type) GetIF2_CMDREQ_BUSY() uint32 {
	return (volatile.LoadUint32(&o.IF2_CMDREQ.Reg) & 0x8000) >> 15
}
func (o *C_CAN0_Type) SetIF2_CMDREQ_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IF2_CMDREQ.Reg, volatile.LoadUint32(&o.IF2_CMDREQ.Reg)&^(0xffff0000)|value<<16)
}
func (o *C_CAN0_Type) GetIF2_CMDREQ_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IF2_CMDREQ.Reg) & 0xffff0000) >> 16
}

// C_CAN0.IF2_CMDMSK_W: Message interface command mask (write direction)
func (o *C_CAN0_Type) SetIF2_CMDMSK_W_DATA_B(value uint32) {
	volatile.StoreUint32(&o.IF2_CMDMSK_W.Reg, volatile.LoadUint32(&o.IF2_CMDMSK_W.Reg)&^(0x1)|value)
}
func (o *C_CAN0_Type) GetIF2_CMDMSK_W_DATA_B() uint32 {
	return volatile.LoadUint32(&o.IF2_CMDMSK_W.Reg) & 0x1
}
func (o *C_CAN0_Type) SetIF2_CMDMSK_W_DATA_A(value uint32) {
	volatile.StoreUint32(&o.IF2_CMDMSK_W.Reg, volatile.LoadUint32(&o.IF2_CMDMSK_W.Reg)&^(0x2)|value<<1)
}
func (o *C_CAN0_Type) GetIF2_CMDMSK_W_DATA_A() uint32 {
	return (volatile.LoadUint32(&o.IF2_CMDMSK_W.Reg) & 0x2) >> 1
}
func (o *C_CAN0_Type) SetIF2_CMDMSK_W_TXRQST(value uint32) {
	volatile.StoreUint32(&o.IF2_CMDMSK_W.Reg, volatile.LoadUint32(&o.IF2_CMDMSK_W.Reg)&^(0x4)|value<<2)
}
func (o *C_CAN0_Type) GetIF2_CMDMSK_W_TXRQST() uint32 {
	return (volatile.LoadUint32(&o.IF2_CMDMSK_W.Reg) & 0x4) >> 2
}
func (o *C_CAN0_Type) SetIF2_CMDMSK_W_CLRINTPND(value uint32) {
	volatile.StoreUint32(&o.IF2_CMDMSK_W.Reg, volatile.LoadUint32(&o.IF2_CMDMSK_W.Reg)&^(0x8)|value<<3)
}
func (o *C_CAN0_Type) GetIF2_CMDMSK_W_CLRINTPND() uint32 {
	return (volatile.LoadUint32(&o.IF2_CMDMSK_W.Reg) & 0x8) >> 3
}
func (o *C_CAN0_Type) SetIF2_CMDMSK_W_CTRL(value uint32) {
	volatile.StoreUint32(&o.IF2_CMDMSK_W.Reg, volatile.LoadUint32(&o.IF2_CMDMSK_W.Reg)&^(0x10)|value<<4)
}
func (o *C_CAN0_Type) GetIF2_CMDMSK_W_CTRL() uint32 {
	return (volatile.LoadUint32(&o.IF2_CMDMSK_W.Reg) & 0x10) >> 4
}
func (o *C_CAN0_Type) SetIF2_CMDMSK_W_ARB(value uint32) {
	volatile.StoreUint32(&o.IF2_CMDMSK_W.Reg, volatile.LoadUint32(&o.IF2_CMDMSK_W.Reg)&^(0x20)|value<<5)
}
func (o *C_CAN0_Type) GetIF2_CMDMSK_W_ARB() uint32 {
	return (volatile.LoadUint32(&o.IF2_CMDMSK_W.Reg) & 0x20) >> 5
}
func (o *C_CAN0_Type) SetIF2_CMDMSK_W_MASK(value uint32) {
	volatile.StoreUint32(&o.IF2_CMDMSK_W.Reg, volatile.LoadUint32(&o.IF2_CMDMSK_W.Reg)&^(0x40)|value<<6)
}
func (o *C_CAN0_Type) GetIF2_CMDMSK_W_MASK() uint32 {
	return (volatile.LoadUint32(&o.IF2_CMDMSK_W.Reg) & 0x40) >> 6
}
func (o *C_CAN0_Type) SetIF2_CMDMSK_W_WR_RD(value uint32) {
	volatile.StoreUint32(&o.IF2_CMDMSK_W.Reg, volatile.LoadUint32(&o.IF2_CMDMSK_W.Reg)&^(0x80)|value<<7)
}
func (o *C_CAN0_Type) GetIF2_CMDMSK_W_WR_RD() uint32 {
	return (volatile.LoadUint32(&o.IF2_CMDMSK_W.Reg) & 0x80) >> 7
}
func (o *C_CAN0_Type) SetIF2_CMDMSK_W_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IF2_CMDMSK_W.Reg, volatile.LoadUint32(&o.IF2_CMDMSK_W.Reg)&^(0xffffff00)|value<<8)
}
func (o *C_CAN0_Type) GetIF2_CMDMSK_W_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IF2_CMDMSK_W.Reg) & 0xffffff00) >> 8
}

// C_CAN0.IF2_MSK1: Message interface mask 1
func (o *C_CAN0_Type) SetIF2_MSK1_MSK15_0(value uint32) {
	volatile.StoreUint32(&o.IF2_MSK1.Reg, volatile.LoadUint32(&o.IF2_MSK1.Reg)&^(0xffff)|value)
}
func (o *C_CAN0_Type) GetIF2_MSK1_MSK15_0() uint32 {
	return volatile.LoadUint32(&o.IF2_MSK1.Reg) & 0xffff
}
func (o *C_CAN0_Type) SetIF2_MSK1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IF2_MSK1.Reg, volatile.LoadUint32(&o.IF2_MSK1.Reg)&^(0xffff0000)|value<<16)
}
func (o *C_CAN0_Type) GetIF2_MSK1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IF2_MSK1.Reg) & 0xffff0000) >> 16
}

// C_CAN0.IF2_MSK2: Message interface mask 2
func (o *C_CAN0_Type) SetIF2_MSK2_MSK28_16(value uint32) {
	volatile.StoreUint32(&o.IF2_MSK2.Reg, volatile.LoadUint32(&o.IF2_MSK2.Reg)&^(0x1fff)|value)
}
func (o *C_CAN0_Type) GetIF2_MSK2_MSK28_16() uint32 {
	return volatile.LoadUint32(&o.IF2_MSK2.Reg) & 0x1fff
}
func (o *C_CAN0_Type) SetIF2_MSK2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IF2_MSK2.Reg, volatile.LoadUint32(&o.IF2_MSK2.Reg)&^(0x2000)|value<<13)
}
func (o *C_CAN0_Type) GetIF2_MSK2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IF2_MSK2.Reg) & 0x2000) >> 13
}
func (o *C_CAN0_Type) SetIF2_MSK2_MDIR(value uint32) {
	volatile.StoreUint32(&o.IF2_MSK2.Reg, volatile.LoadUint32(&o.IF2_MSK2.Reg)&^(0x4000)|value<<14)
}
func (o *C_CAN0_Type) GetIF2_MSK2_MDIR() uint32 {
	return (volatile.LoadUint32(&o.IF2_MSK2.Reg) & 0x4000) >> 14
}
func (o *C_CAN0_Type) SetIF2_MSK2_MXTD(value uint32) {
	volatile.StoreUint32(&o.IF2_MSK2.Reg, volatile.LoadUint32(&o.IF2_MSK2.Reg)&^(0x8000)|value<<15)
}
func (o *C_CAN0_Type) GetIF2_MSK2_MXTD() uint32 {
	return (volatile.LoadUint32(&o.IF2_MSK2.Reg) & 0x8000) >> 15
}
func (o *C_CAN0_Type) SetIF2_MSK2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IF2_MSK2.Reg, volatile.LoadUint32(&o.IF2_MSK2.Reg)&^(0xffff0000)|value<<16)
}
func (o *C_CAN0_Type) GetIF2_MSK2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IF2_MSK2.Reg) & 0xffff0000) >> 16
}

// C_CAN0.IF2_ARB1: Message interface arbitration 1
func (o *C_CAN0_Type) SetIF2_ARB1_ID15_0(value uint32) {
	volatile.StoreUint32(&o.IF2_ARB1.Reg, volatile.LoadUint32(&o.IF2_ARB1.Reg)&^(0xffff)|value)
}
func (o *C_CAN0_Type) GetIF2_ARB1_ID15_0() uint32 {
	return volatile.LoadUint32(&o.IF2_ARB1.Reg) & 0xffff
}
func (o *C_CAN0_Type) SetIF2_ARB1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IF2_ARB1.Reg, volatile.LoadUint32(&o.IF2_ARB1.Reg)&^(0xffff0000)|value<<16)
}
func (o *C_CAN0_Type) GetIF2_ARB1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IF2_ARB1.Reg) & 0xffff0000) >> 16
}

// C_CAN0.IF2_ARB2: Message interface arbitration 2
func (o *C_CAN0_Type) SetIF2_ARB2_ID28_16(value uint32) {
	volatile.StoreUint32(&o.IF2_ARB2.Reg, volatile.LoadUint32(&o.IF2_ARB2.Reg)&^(0x1fff)|value)
}
func (o *C_CAN0_Type) GetIF2_ARB2_ID28_16() uint32 {
	return volatile.LoadUint32(&o.IF2_ARB2.Reg) & 0x1fff
}
func (o *C_CAN0_Type) SetIF2_ARB2_DIR(value uint32) {
	volatile.StoreUint32(&o.IF2_ARB2.Reg, volatile.LoadUint32(&o.IF2_ARB2.Reg)&^(0x2000)|value<<13)
}
func (o *C_CAN0_Type) GetIF2_ARB2_DIR() uint32 {
	return (volatile.LoadUint32(&o.IF2_ARB2.Reg) & 0x2000) >> 13
}
func (o *C_CAN0_Type) SetIF2_ARB2_XTD(value uint32) {
	volatile.StoreUint32(&o.IF2_ARB2.Reg, volatile.LoadUint32(&o.IF2_ARB2.Reg)&^(0x4000)|value<<14)
}
func (o *C_CAN0_Type) GetIF2_ARB2_XTD() uint32 {
	return (volatile.LoadUint32(&o.IF2_ARB2.Reg) & 0x4000) >> 14
}
func (o *C_CAN0_Type) SetIF2_ARB2_MSGVAL(value uint32) {
	volatile.StoreUint32(&o.IF2_ARB2.Reg, volatile.LoadUint32(&o.IF2_ARB2.Reg)&^(0x8000)|value<<15)
}
func (o *C_CAN0_Type) GetIF2_ARB2_MSGVAL() uint32 {
	return (volatile.LoadUint32(&o.IF2_ARB2.Reg) & 0x8000) >> 15
}
func (o *C_CAN0_Type) SetIF2_ARB2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IF2_ARB2.Reg, volatile.LoadUint32(&o.IF2_ARB2.Reg)&^(0xffff0000)|value<<16)
}
func (o *C_CAN0_Type) GetIF2_ARB2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IF2_ARB2.Reg) & 0xffff0000) >> 16
}

// C_CAN0.IF2_MCTRL: Message interface message control
func (o *C_CAN0_Type) SetIF2_MCTRL_DLC3_0(value uint32) {
	volatile.StoreUint32(&o.IF2_MCTRL.Reg, volatile.LoadUint32(&o.IF2_MCTRL.Reg)&^(0xf)|value)
}
func (o *C_CAN0_Type) GetIF2_MCTRL_DLC3_0() uint32 {
	return volatile.LoadUint32(&o.IF2_MCTRL.Reg) & 0xf
}
func (o *C_CAN0_Type) SetIF2_MCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IF2_MCTRL.Reg, volatile.LoadUint32(&o.IF2_MCTRL.Reg)&^(0x70)|value<<4)
}
func (o *C_CAN0_Type) GetIF2_MCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IF2_MCTRL.Reg) & 0x70) >> 4
}
func (o *C_CAN0_Type) SetIF2_MCTRL_EOB(value uint32) {
	volatile.StoreUint32(&o.IF2_MCTRL.Reg, volatile.LoadUint32(&o.IF2_MCTRL.Reg)&^(0x80)|value<<7)
}
func (o *C_CAN0_Type) GetIF2_MCTRL_EOB() uint32 {
	return (volatile.LoadUint32(&o.IF2_MCTRL.Reg) & 0x80) >> 7
}
func (o *C_CAN0_Type) SetIF2_MCTRL_TXRQST(value uint32) {
	volatile.StoreUint32(&o.IF2_MCTRL.Reg, volatile.LoadUint32(&o.IF2_MCTRL.Reg)&^(0x100)|value<<8)
}
func (o *C_CAN0_Type) GetIF2_MCTRL_TXRQST() uint32 {
	return (volatile.LoadUint32(&o.IF2_MCTRL.Reg) & 0x100) >> 8
}
func (o *C_CAN0_Type) SetIF2_MCTRL_RMTEN(value uint32) {
	volatile.StoreUint32(&o.IF2_MCTRL.Reg, volatile.LoadUint32(&o.IF2_MCTRL.Reg)&^(0x200)|value<<9)
}
func (o *C_CAN0_Type) GetIF2_MCTRL_RMTEN() uint32 {
	return (volatile.LoadUint32(&o.IF2_MCTRL.Reg) & 0x200) >> 9
}
func (o *C_CAN0_Type) SetIF2_MCTRL_RXIE(value uint32) {
	volatile.StoreUint32(&o.IF2_MCTRL.Reg, volatile.LoadUint32(&o.IF2_MCTRL.Reg)&^(0x400)|value<<10)
}
func (o *C_CAN0_Type) GetIF2_MCTRL_RXIE() uint32 {
	return (volatile.LoadUint32(&o.IF2_MCTRL.Reg) & 0x400) >> 10
}
func (o *C_CAN0_Type) SetIF2_MCTRL_TXIE(value uint32) {
	volatile.StoreUint32(&o.IF2_MCTRL.Reg, volatile.LoadUint32(&o.IF2_MCTRL.Reg)&^(0x800)|value<<11)
}
func (o *C_CAN0_Type) GetIF2_MCTRL_TXIE() uint32 {
	return (volatile.LoadUint32(&o.IF2_MCTRL.Reg) & 0x800) >> 11
}
func (o *C_CAN0_Type) SetIF2_MCTRL_UMASK(value uint32) {
	volatile.StoreUint32(&o.IF2_MCTRL.Reg, volatile.LoadUint32(&o.IF2_MCTRL.Reg)&^(0x1000)|value<<12)
}
func (o *C_CAN0_Type) GetIF2_MCTRL_UMASK() uint32 {
	return (volatile.LoadUint32(&o.IF2_MCTRL.Reg) & 0x1000) >> 12
}
func (o *C_CAN0_Type) SetIF2_MCTRL_INTPND(value uint32) {
	volatile.StoreUint32(&o.IF2_MCTRL.Reg, volatile.LoadUint32(&o.IF2_MCTRL.Reg)&^(0x2000)|value<<13)
}
func (o *C_CAN0_Type) GetIF2_MCTRL_INTPND() uint32 {
	return (volatile.LoadUint32(&o.IF2_MCTRL.Reg) & 0x2000) >> 13
}
func (o *C_CAN0_Type) SetIF2_MCTRL_MSGLST(value uint32) {
	volatile.StoreUint32(&o.IF2_MCTRL.Reg, volatile.LoadUint32(&o.IF2_MCTRL.Reg)&^(0x4000)|value<<14)
}
func (o *C_CAN0_Type) GetIF2_MCTRL_MSGLST() uint32 {
	return (volatile.LoadUint32(&o.IF2_MCTRL.Reg) & 0x4000) >> 14
}
func (o *C_CAN0_Type) SetIF2_MCTRL_NEWDAT(value uint32) {
	volatile.StoreUint32(&o.IF2_MCTRL.Reg, volatile.LoadUint32(&o.IF2_MCTRL.Reg)&^(0x8000)|value<<15)
}
func (o *C_CAN0_Type) GetIF2_MCTRL_NEWDAT() uint32 {
	return (volatile.LoadUint32(&o.IF2_MCTRL.Reg) & 0x8000) >> 15
}
func (o *C_CAN0_Type) SetIF2_MCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IF2_MCTRL.Reg, volatile.LoadUint32(&o.IF2_MCTRL.Reg)&^(0xffff0000)|value<<16)
}
func (o *C_CAN0_Type) GetIF2_MCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IF2_MCTRL.Reg) & 0xffff0000) >> 16
}

// C_CAN0.IF2_DA1: Message interface data A1
func (o *C_CAN0_Type) SetIF2_DA1_DATA0(value uint32) {
	volatile.StoreUint32(&o.IF2_DA1.Reg, volatile.LoadUint32(&o.IF2_DA1.Reg)&^(0xff)|value)
}
func (o *C_CAN0_Type) GetIF2_DA1_DATA0() uint32 {
	return volatile.LoadUint32(&o.IF2_DA1.Reg) & 0xff
}
func (o *C_CAN0_Type) SetIF2_DA1_DATA1(value uint32) {
	volatile.StoreUint32(&o.IF2_DA1.Reg, volatile.LoadUint32(&o.IF2_DA1.Reg)&^(0xff00)|value<<8)
}
func (o *C_CAN0_Type) GetIF2_DA1_DATA1() uint32 {
	return (volatile.LoadUint32(&o.IF2_DA1.Reg) & 0xff00) >> 8
}
func (o *C_CAN0_Type) SetIF2_DA1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IF2_DA1.Reg, volatile.LoadUint32(&o.IF2_DA1.Reg)&^(0xffff0000)|value<<16)
}
func (o *C_CAN0_Type) GetIF2_DA1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IF2_DA1.Reg) & 0xffff0000) >> 16
}

// C_CAN0.IF2_DA2: Message interface 1 data A2
func (o *C_CAN0_Type) SetIF2_DA2_DATA2(value uint32) {
	volatile.StoreUint32(&o.IF2_DA2.Reg, volatile.LoadUint32(&o.IF2_DA2.Reg)&^(0xff)|value)
}
func (o *C_CAN0_Type) GetIF2_DA2_DATA2() uint32 {
	return volatile.LoadUint32(&o.IF2_DA2.Reg) & 0xff
}
func (o *C_CAN0_Type) SetIF2_DA2_DATA3(value uint32) {
	volatile.StoreUint32(&o.IF2_DA2.Reg, volatile.LoadUint32(&o.IF2_DA2.Reg)&^(0xff00)|value<<8)
}
func (o *C_CAN0_Type) GetIF2_DA2_DATA3() uint32 {
	return (volatile.LoadUint32(&o.IF2_DA2.Reg) & 0xff00) >> 8
}
func (o *C_CAN0_Type) SetIF2_DA2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IF2_DA2.Reg, volatile.LoadUint32(&o.IF2_DA2.Reg)&^(0xffff0000)|value<<16)
}
func (o *C_CAN0_Type) GetIF2_DA2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IF2_DA2.Reg) & 0xffff0000) >> 16
}

// C_CAN0.IF2_DB1: Message interface 1 data B1
func (o *C_CAN0_Type) SetIF2_DB1_DATA4(value uint32) {
	volatile.StoreUint32(&o.IF2_DB1.Reg, volatile.LoadUint32(&o.IF2_DB1.Reg)&^(0xff)|value)
}
func (o *C_CAN0_Type) GetIF2_DB1_DATA4() uint32 {
	return volatile.LoadUint32(&o.IF2_DB1.Reg) & 0xff
}
func (o *C_CAN0_Type) SetIF2_DB1_DATA5(value uint32) {
	volatile.StoreUint32(&o.IF2_DB1.Reg, volatile.LoadUint32(&o.IF2_DB1.Reg)&^(0xff00)|value<<8)
}
func (o *C_CAN0_Type) GetIF2_DB1_DATA5() uint32 {
	return (volatile.LoadUint32(&o.IF2_DB1.Reg) & 0xff00) >> 8
}
func (o *C_CAN0_Type) SetIF2_DB1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IF2_DB1.Reg, volatile.LoadUint32(&o.IF2_DB1.Reg)&^(0xffff0000)|value<<16)
}
func (o *C_CAN0_Type) GetIF2_DB1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IF2_DB1.Reg) & 0xffff0000) >> 16
}

// C_CAN0.IF2_DB2: Message interface 1 data B2
func (o *C_CAN0_Type) SetIF2_DB2_DATA6(value uint32) {
	volatile.StoreUint32(&o.IF2_DB2.Reg, volatile.LoadUint32(&o.IF2_DB2.Reg)&^(0xff)|value)
}
func (o *C_CAN0_Type) GetIF2_DB2_DATA6() uint32 {
	return volatile.LoadUint32(&o.IF2_DB2.Reg) & 0xff
}
func (o *C_CAN0_Type) SetIF2_DB2_DATA7(value uint32) {
	volatile.StoreUint32(&o.IF2_DB2.Reg, volatile.LoadUint32(&o.IF2_DB2.Reg)&^(0xff00)|value<<8)
}
func (o *C_CAN0_Type) GetIF2_DB2_DATA7() uint32 {
	return (volatile.LoadUint32(&o.IF2_DB2.Reg) & 0xff00) >> 8
}
func (o *C_CAN0_Type) SetIF2_DB2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IF2_DB2.Reg, volatile.LoadUint32(&o.IF2_DB2.Reg)&^(0xffff0000)|value<<16)
}
func (o *C_CAN0_Type) GetIF2_DB2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IF2_DB2.Reg) & 0xffff0000) >> 16
}

// C_CAN0.TXREQ1: Transmission request 1
func (o *C_CAN0_Type) SetTXREQ1_TXRQST16_1(value uint32) {
	volatile.StoreUint32(&o.TXREQ1.Reg, volatile.LoadUint32(&o.TXREQ1.Reg)&^(0xffff)|value)
}
func (o *C_CAN0_Type) GetTXREQ1_TXRQST16_1() uint32 {
	return volatile.LoadUint32(&o.TXREQ1.Reg) & 0xffff
}
func (o *C_CAN0_Type) SetTXREQ1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TXREQ1.Reg, volatile.LoadUint32(&o.TXREQ1.Reg)&^(0xffff0000)|value<<16)
}
func (o *C_CAN0_Type) GetTXREQ1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TXREQ1.Reg) & 0xffff0000) >> 16
}

// C_CAN0.TXREQ2: Transmission request 2
func (o *C_CAN0_Type) SetTXREQ2_TXRQST32_17(value uint32) {
	volatile.StoreUint32(&o.TXREQ2.Reg, volatile.LoadUint32(&o.TXREQ2.Reg)&^(0xffff)|value)
}
func (o *C_CAN0_Type) GetTXREQ2_TXRQST32_17() uint32 {
	return volatile.LoadUint32(&o.TXREQ2.Reg) & 0xffff
}
func (o *C_CAN0_Type) SetTXREQ2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TXREQ2.Reg, volatile.LoadUint32(&o.TXREQ2.Reg)&^(0xffff0000)|value<<16)
}
func (o *C_CAN0_Type) GetTXREQ2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TXREQ2.Reg) & 0xffff0000) >> 16
}

// C_CAN0.ND1: New data 1
func (o *C_CAN0_Type) SetND1_NEWDAT16_1(value uint32) {
	volatile.StoreUint32(&o.ND1.Reg, volatile.LoadUint32(&o.ND1.Reg)&^(0xffff)|value)
}
func (o *C_CAN0_Type) GetND1_NEWDAT16_1() uint32 {
	return volatile.LoadUint32(&o.ND1.Reg) & 0xffff
}
func (o *C_CAN0_Type) SetND1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ND1.Reg, volatile.LoadUint32(&o.ND1.Reg)&^(0xffff0000)|value<<16)
}
func (o *C_CAN0_Type) GetND1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ND1.Reg) & 0xffff0000) >> 16
}

// C_CAN0.ND2: New data 2
func (o *C_CAN0_Type) SetND2_NEWDAT32_17(value uint32) {
	volatile.StoreUint32(&o.ND2.Reg, volatile.LoadUint32(&o.ND2.Reg)&^(0xffff)|value)
}
func (o *C_CAN0_Type) GetND2_NEWDAT32_17() uint32 {
	return volatile.LoadUint32(&o.ND2.Reg) & 0xffff
}
func (o *C_CAN0_Type) SetND2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ND2.Reg, volatile.LoadUint32(&o.ND2.Reg)&^(0xffff0000)|value<<16)
}
func (o *C_CAN0_Type) GetND2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ND2.Reg) & 0xffff0000) >> 16
}

// C_CAN0.IR1: Interrupt pending 1
func (o *C_CAN0_Type) SetIR1_INTPND16_1(value uint32) {
	volatile.StoreUint32(&o.IR1.Reg, volatile.LoadUint32(&o.IR1.Reg)&^(0xffff)|value)
}
func (o *C_CAN0_Type) GetIR1_INTPND16_1() uint32 {
	return volatile.LoadUint32(&o.IR1.Reg) & 0xffff
}
func (o *C_CAN0_Type) SetIR1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IR1.Reg, volatile.LoadUint32(&o.IR1.Reg)&^(0xffff0000)|value<<16)
}
func (o *C_CAN0_Type) GetIR1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IR1.Reg) & 0xffff0000) >> 16
}

// C_CAN0.IR2: Interrupt pending 2
func (o *C_CAN0_Type) SetIR2_INTPND32_17(value uint32) {
	volatile.StoreUint32(&o.IR2.Reg, volatile.LoadUint32(&o.IR2.Reg)&^(0xffff)|value)
}
func (o *C_CAN0_Type) GetIR2_INTPND32_17() uint32 {
	return volatile.LoadUint32(&o.IR2.Reg) & 0xffff
}
func (o *C_CAN0_Type) SetIR2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IR2.Reg, volatile.LoadUint32(&o.IR2.Reg)&^(0xffff0000)|value<<16)
}
func (o *C_CAN0_Type) GetIR2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IR2.Reg) & 0xffff0000) >> 16
}

// C_CAN0.MSGV1: Message valid 1
func (o *C_CAN0_Type) SetMSGV1_MSGVAL16_1(value uint32) {
	volatile.StoreUint32(&o.MSGV1.Reg, volatile.LoadUint32(&o.MSGV1.Reg)&^(0xffff)|value)
}
func (o *C_CAN0_Type) GetMSGV1_MSGVAL16_1() uint32 {
	return volatile.LoadUint32(&o.MSGV1.Reg) & 0xffff
}
func (o *C_CAN0_Type) SetMSGV1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MSGV1.Reg, volatile.LoadUint32(&o.MSGV1.Reg)&^(0xffff0000)|value<<16)
}
func (o *C_CAN0_Type) GetMSGV1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MSGV1.Reg) & 0xffff0000) >> 16
}

// C_CAN0.MSGV2: Message valid 2
func (o *C_CAN0_Type) SetMSGV2_MSGVAL32_17(value uint32) {
	volatile.StoreUint32(&o.MSGV2.Reg, volatile.LoadUint32(&o.MSGV2.Reg)&^(0xffff)|value)
}
func (o *C_CAN0_Type) GetMSGV2_MSGVAL32_17() uint32 {
	return volatile.LoadUint32(&o.MSGV2.Reg) & 0xffff
}
func (o *C_CAN0_Type) SetMSGV2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MSGV2.Reg, volatile.LoadUint32(&o.MSGV2.Reg)&^(0xffff0000)|value<<16)
}
func (o *C_CAN0_Type) GetMSGV2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MSGV2.Reg) & 0xffff0000) >> 16
}

// C_CAN0.CLKDIV: CAN clock divider register
func (o *C_CAN0_Type) SetCLKDIV_CLKDIVVAL(value uint32) {
	volatile.StoreUint32(&o.CLKDIV.Reg, volatile.LoadUint32(&o.CLKDIV.Reg)&^(0xf)|value)
}
func (o *C_CAN0_Type) GetCLKDIV_CLKDIVVAL() uint32 {
	return volatile.LoadUint32(&o.CLKDIV.Reg) & 0xf
}
func (o *C_CAN0_Type) SetCLKDIV_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CLKDIV.Reg, volatile.LoadUint32(&o.CLKDIV.Reg)&^(0xfffffff0)|value<<4)
}
func (o *C_CAN0_Type) GetCLKDIV_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CLKDIV.Reg) & 0xfffffff0) >> 4
}

// I/O pin configuration (IOCON)
type IOCON_Type struct {
	PIO0_0  volatile.Register32 // 0x0
	PIO0_1  volatile.Register32 // 0x4
	PIO0_2  volatile.Register32 // 0x8
	PIO0_3  volatile.Register32 // 0xC
	PIO0_4  volatile.Register32 // 0x10
	PIO0_5  volatile.Register32 // 0x14
	PIO0_6  volatile.Register32 // 0x18
	PIO0_7  volatile.Register32 // 0x1C
	PIO0_8  volatile.Register32 // 0x20
	PIO0_9  volatile.Register32 // 0x24
	PIO0_10 volatile.Register32 // 0x28
	PIO0_11 volatile.Register32 // 0x2C
	PIO0_12 volatile.Register32 // 0x30
	PIO0_13 volatile.Register32 // 0x34
	PIO0_14 volatile.Register32 // 0x38
	PIO0_15 volatile.Register32 // 0x3C
	PIO0_16 volatile.Register32 // 0x40
	PIO0_17 volatile.Register32 // 0x44
	PIO0_18 volatile.Register32 // 0x48
	PIO0_19 volatile.Register32 // 0x4C
	PIO0_20 volatile.Register32 // 0x50
	PIO0_21 volatile.Register32 // 0x54
	PIO0_22 volatile.Register32 // 0x58
	PIO0_23 volatile.Register32 // 0x5C
	PIO0_24 volatile.Register32 // 0x60
	PIO0_25 volatile.Register32 // 0x64
	PIO0_26 volatile.Register32 // 0x68
	PIO0_27 volatile.Register32 // 0x6C
	PIO0_28 volatile.Register32 // 0x70
	PIO0_29 volatile.Register32 // 0x74
	PIO0_30 volatile.Register32 // 0x78
	PIO0_31 volatile.Register32 // 0x7C
	PIO1_0  volatile.Register32 // 0x80
	PIO1_1  volatile.Register32 // 0x84
	PIO1_2  volatile.Register32 // 0x88
	PIO1_3  volatile.Register32 // 0x8C
	PIO1_4  volatile.Register32 // 0x90
	PIO1_5  volatile.Register32 // 0x94
	PIO1_6  volatile.Register32 // 0x98
	PIO1_7  volatile.Register32 // 0x9C
	PIO1_8  volatile.Register32 // 0xA0
	PIO1_9  volatile.Register32 // 0xA4
	PIO1_10 volatile.Register32 // 0xA8
	PIO1_11 volatile.Register32 // 0xAC
	PIO1_12 volatile.Register32 // 0xB0
	PIO1_13 volatile.Register32 // 0xB4
	PIO1_14 volatile.Register32 // 0xB8
	PIO1_15 volatile.Register32 // 0xBC
	PIO1_16 volatile.Register32 // 0xC0
	PIO1_17 volatile.Register32 // 0xC4
	PIO1_18 volatile.Register32 // 0xC8
	PIO1_19 volatile.Register32 // 0xCC
	PIO1_20 volatile.Register32 // 0xD0
	PIO1_21 volatile.Register32 // 0xD4
	PIO1_22 volatile.Register32 // 0xD8
	PIO1_23 volatile.Register32 // 0xDC
	PIO1_24 volatile.Register32 // 0xE0
	PIO1_25 volatile.Register32 // 0xE4
	PIO1_26 volatile.Register32 // 0xE8
	PIO1_27 volatile.Register32 // 0xEC
	PIO1_28 volatile.Register32 // 0xF0
	PIO1_29 volatile.Register32 // 0xF4
	PIO1_30 volatile.Register32 // 0xF8
	PIO1_31 volatile.Register32 // 0xFC
	PIO2_0  volatile.Register32 // 0x100
	PIO2_1  volatile.Register32 // 0x104
	PIO2_2  volatile.Register32 // 0x108
	PIO2_3  volatile.Register32 // 0x10C
	PIO2_4  volatile.Register32 // 0x110
	PIO2_5  volatile.Register32 // 0x114
	PIO2_6  volatile.Register32 // 0x118
	PIO2_7  volatile.Register32 // 0x11C
	PIO2_8  volatile.Register32 // 0x120
	PIO2_9  volatile.Register32 // 0x124
	PIO2_10 volatile.Register32 // 0x128
	PIO2_11 volatile.Register32 // 0x12C
	PIO2_12 volatile.Register32 // 0x130
	PIO2_13 volatile.Register32 // 0x134
}

// IOCON.PIO0_0: Digital I/O control for port 0 pins PIO0_0 to PIO0_17. With glitch filter.
func (o *IOCON_Type) SetPIO0_0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_0.Reg, volatile.LoadUint32(&o.PIO0_0.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO0_0_RESERVED() uint32 {
	return volatile.LoadUint32(&o.PIO0_0.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO0_0_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_0.Reg, volatile.LoadUint32(&o.PIO0_0.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO0_0_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_0.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO0_0_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO0_0.Reg, volatile.LoadUint32(&o.PIO0_0.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO0_0_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO0_0.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO0_0_INV(value uint32) {
	volatile.StoreUint32(&o.PIO0_0.Reg, volatile.LoadUint32(&o.PIO0_0.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO0_0_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_0.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO0_0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_0.Reg, volatile.LoadUint32(&o.PIO0_0.Reg)&^(0x80)|value<<7)
}
func (o *IOCON_Type) GetPIO0_0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_0.Reg) & 0x80) >> 7
}
func (o *IOCON_Type) SetPIO0_0_FILTR(value uint32) {
	volatile.StoreUint32(&o.PIO0_0.Reg, volatile.LoadUint32(&o.PIO0_0.Reg)&^(0x100)|value<<8)
}
func (o *IOCON_Type) GetPIO0_0_FILTR() uint32 {
	return (volatile.LoadUint32(&o.PIO0_0.Reg) & 0x100) >> 8
}
func (o *IOCON_Type) SetPIO0_0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_0.Reg, volatile.LoadUint32(&o.PIO0_0.Reg)&^(0x200)|value<<9)
}
func (o *IOCON_Type) GetPIO0_0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_0.Reg) & 0x200) >> 9
}
func (o *IOCON_Type) SetPIO0_0_OD(value uint32) {
	volatile.StoreUint32(&o.PIO0_0.Reg, volatile.LoadUint32(&o.PIO0_0.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO0_0_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO0_0.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO0_0_S_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_0.Reg, volatile.LoadUint32(&o.PIO0_0.Reg)&^(0x1800)|value<<11)
}
func (o *IOCON_Type) GetPIO0_0_S_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_0.Reg) & 0x1800) >> 11
}
func (o *IOCON_Type) SetPIO0_0_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.PIO0_0.Reg, volatile.LoadUint32(&o.PIO0_0.Reg)&^(0xe000)|value<<13)
}
func (o *IOCON_Type) GetPIO0_0_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_0.Reg) & 0xe000) >> 13
}
func (o *IOCON_Type) SetPIO0_0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_0.Reg, volatile.LoadUint32(&o.PIO0_0.Reg)&^(0xffff0000)|value<<16)
}
func (o *IOCON_Type) GetPIO0_0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_0.Reg) & 0xffff0000) >> 16
}

// IOCON.PIO0_1: Digital I/O control for port 0 pins PIO0_0 to PIO0_17. With glitch filter.
func (o *IOCON_Type) SetPIO0_1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_1.Reg, volatile.LoadUint32(&o.PIO0_1.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO0_1_RESERVED() uint32 {
	return volatile.LoadUint32(&o.PIO0_1.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO0_1_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_1.Reg, volatile.LoadUint32(&o.PIO0_1.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO0_1_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_1.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO0_1_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO0_1.Reg, volatile.LoadUint32(&o.PIO0_1.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO0_1_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO0_1.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO0_1_INV(value uint32) {
	volatile.StoreUint32(&o.PIO0_1.Reg, volatile.LoadUint32(&o.PIO0_1.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO0_1_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_1.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO0_1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_1.Reg, volatile.LoadUint32(&o.PIO0_1.Reg)&^(0x80)|value<<7)
}
func (o *IOCON_Type) GetPIO0_1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_1.Reg) & 0x80) >> 7
}
func (o *IOCON_Type) SetPIO0_1_FILTR(value uint32) {
	volatile.StoreUint32(&o.PIO0_1.Reg, volatile.LoadUint32(&o.PIO0_1.Reg)&^(0x100)|value<<8)
}
func (o *IOCON_Type) GetPIO0_1_FILTR() uint32 {
	return (volatile.LoadUint32(&o.PIO0_1.Reg) & 0x100) >> 8
}
func (o *IOCON_Type) SetPIO0_1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_1.Reg, volatile.LoadUint32(&o.PIO0_1.Reg)&^(0x200)|value<<9)
}
func (o *IOCON_Type) GetPIO0_1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_1.Reg) & 0x200) >> 9
}
func (o *IOCON_Type) SetPIO0_1_OD(value uint32) {
	volatile.StoreUint32(&o.PIO0_1.Reg, volatile.LoadUint32(&o.PIO0_1.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO0_1_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO0_1.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO0_1_S_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_1.Reg, volatile.LoadUint32(&o.PIO0_1.Reg)&^(0x1800)|value<<11)
}
func (o *IOCON_Type) GetPIO0_1_S_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_1.Reg) & 0x1800) >> 11
}
func (o *IOCON_Type) SetPIO0_1_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.PIO0_1.Reg, volatile.LoadUint32(&o.PIO0_1.Reg)&^(0xe000)|value<<13)
}
func (o *IOCON_Type) GetPIO0_1_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_1.Reg) & 0xe000) >> 13
}
func (o *IOCON_Type) SetPIO0_1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_1.Reg, volatile.LoadUint32(&o.PIO0_1.Reg)&^(0xffff0000)|value<<16)
}
func (o *IOCON_Type) GetPIO0_1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_1.Reg) & 0xffff0000) >> 16
}

// IOCON.PIO0_2: Digital I/O control for port 0 pins PIO0_0 to PIO0_17. With glitch filter.
func (o *IOCON_Type) SetPIO0_2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_2.Reg, volatile.LoadUint32(&o.PIO0_2.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO0_2_RESERVED() uint32 {
	return volatile.LoadUint32(&o.PIO0_2.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO0_2_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_2.Reg, volatile.LoadUint32(&o.PIO0_2.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO0_2_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_2.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO0_2_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO0_2.Reg, volatile.LoadUint32(&o.PIO0_2.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO0_2_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO0_2.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO0_2_INV(value uint32) {
	volatile.StoreUint32(&o.PIO0_2.Reg, volatile.LoadUint32(&o.PIO0_2.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO0_2_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_2.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO0_2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_2.Reg, volatile.LoadUint32(&o.PIO0_2.Reg)&^(0x80)|value<<7)
}
func (o *IOCON_Type) GetPIO0_2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_2.Reg) & 0x80) >> 7
}
func (o *IOCON_Type) SetPIO0_2_FILTR(value uint32) {
	volatile.StoreUint32(&o.PIO0_2.Reg, volatile.LoadUint32(&o.PIO0_2.Reg)&^(0x100)|value<<8)
}
func (o *IOCON_Type) GetPIO0_2_FILTR() uint32 {
	return (volatile.LoadUint32(&o.PIO0_2.Reg) & 0x100) >> 8
}
func (o *IOCON_Type) SetPIO0_2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_2.Reg, volatile.LoadUint32(&o.PIO0_2.Reg)&^(0x200)|value<<9)
}
func (o *IOCON_Type) GetPIO0_2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_2.Reg) & 0x200) >> 9
}
func (o *IOCON_Type) SetPIO0_2_OD(value uint32) {
	volatile.StoreUint32(&o.PIO0_2.Reg, volatile.LoadUint32(&o.PIO0_2.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO0_2_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO0_2.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO0_2_S_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_2.Reg, volatile.LoadUint32(&o.PIO0_2.Reg)&^(0x1800)|value<<11)
}
func (o *IOCON_Type) GetPIO0_2_S_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_2.Reg) & 0x1800) >> 11
}
func (o *IOCON_Type) SetPIO0_2_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.PIO0_2.Reg, volatile.LoadUint32(&o.PIO0_2.Reg)&^(0xe000)|value<<13)
}
func (o *IOCON_Type) GetPIO0_2_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_2.Reg) & 0xe000) >> 13
}
func (o *IOCON_Type) SetPIO0_2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_2.Reg, volatile.LoadUint32(&o.PIO0_2.Reg)&^(0xffff0000)|value<<16)
}
func (o *IOCON_Type) GetPIO0_2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_2.Reg) & 0xffff0000) >> 16
}

// IOCON.PIO0_3: Digital I/O control for port 0 pins PIO0_0 to PIO0_17. With glitch filter.
func (o *IOCON_Type) SetPIO0_3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_3.Reg, volatile.LoadUint32(&o.PIO0_3.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO0_3_RESERVED() uint32 {
	return volatile.LoadUint32(&o.PIO0_3.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO0_3_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_3.Reg, volatile.LoadUint32(&o.PIO0_3.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO0_3_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_3.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO0_3_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO0_3.Reg, volatile.LoadUint32(&o.PIO0_3.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO0_3_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO0_3.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO0_3_INV(value uint32) {
	volatile.StoreUint32(&o.PIO0_3.Reg, volatile.LoadUint32(&o.PIO0_3.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO0_3_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_3.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO0_3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_3.Reg, volatile.LoadUint32(&o.PIO0_3.Reg)&^(0x80)|value<<7)
}
func (o *IOCON_Type) GetPIO0_3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_3.Reg) & 0x80) >> 7
}
func (o *IOCON_Type) SetPIO0_3_FILTR(value uint32) {
	volatile.StoreUint32(&o.PIO0_3.Reg, volatile.LoadUint32(&o.PIO0_3.Reg)&^(0x100)|value<<8)
}
func (o *IOCON_Type) GetPIO0_3_FILTR() uint32 {
	return (volatile.LoadUint32(&o.PIO0_3.Reg) & 0x100) >> 8
}
func (o *IOCON_Type) SetPIO0_3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_3.Reg, volatile.LoadUint32(&o.PIO0_3.Reg)&^(0x200)|value<<9)
}
func (o *IOCON_Type) GetPIO0_3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_3.Reg) & 0x200) >> 9
}
func (o *IOCON_Type) SetPIO0_3_OD(value uint32) {
	volatile.StoreUint32(&o.PIO0_3.Reg, volatile.LoadUint32(&o.PIO0_3.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO0_3_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO0_3.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO0_3_S_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_3.Reg, volatile.LoadUint32(&o.PIO0_3.Reg)&^(0x1800)|value<<11)
}
func (o *IOCON_Type) GetPIO0_3_S_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_3.Reg) & 0x1800) >> 11
}
func (o *IOCON_Type) SetPIO0_3_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.PIO0_3.Reg, volatile.LoadUint32(&o.PIO0_3.Reg)&^(0xe000)|value<<13)
}
func (o *IOCON_Type) GetPIO0_3_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_3.Reg) & 0xe000) >> 13
}
func (o *IOCON_Type) SetPIO0_3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_3.Reg, volatile.LoadUint32(&o.PIO0_3.Reg)&^(0xffff0000)|value<<16)
}
func (o *IOCON_Type) GetPIO0_3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_3.Reg) & 0xffff0000) >> 16
}

// IOCON.PIO0_4: Digital I/O control for port 0 pins PIO0_0 to PIO0_17. With glitch filter.
func (o *IOCON_Type) SetPIO0_4_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_4.Reg, volatile.LoadUint32(&o.PIO0_4.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO0_4_RESERVED() uint32 {
	return volatile.LoadUint32(&o.PIO0_4.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO0_4_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_4.Reg, volatile.LoadUint32(&o.PIO0_4.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO0_4_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_4.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO0_4_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO0_4.Reg, volatile.LoadUint32(&o.PIO0_4.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO0_4_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO0_4.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO0_4_INV(value uint32) {
	volatile.StoreUint32(&o.PIO0_4.Reg, volatile.LoadUint32(&o.PIO0_4.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO0_4_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_4.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO0_4_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_4.Reg, volatile.LoadUint32(&o.PIO0_4.Reg)&^(0x80)|value<<7)
}
func (o *IOCON_Type) GetPIO0_4_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_4.Reg) & 0x80) >> 7
}
func (o *IOCON_Type) SetPIO0_4_FILTR(value uint32) {
	volatile.StoreUint32(&o.PIO0_4.Reg, volatile.LoadUint32(&o.PIO0_4.Reg)&^(0x100)|value<<8)
}
func (o *IOCON_Type) GetPIO0_4_FILTR() uint32 {
	return (volatile.LoadUint32(&o.PIO0_4.Reg) & 0x100) >> 8
}
func (o *IOCON_Type) SetPIO0_4_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_4.Reg, volatile.LoadUint32(&o.PIO0_4.Reg)&^(0x200)|value<<9)
}
func (o *IOCON_Type) GetPIO0_4_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_4.Reg) & 0x200) >> 9
}
func (o *IOCON_Type) SetPIO0_4_OD(value uint32) {
	volatile.StoreUint32(&o.PIO0_4.Reg, volatile.LoadUint32(&o.PIO0_4.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO0_4_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO0_4.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO0_4_S_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_4.Reg, volatile.LoadUint32(&o.PIO0_4.Reg)&^(0x1800)|value<<11)
}
func (o *IOCON_Type) GetPIO0_4_S_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_4.Reg) & 0x1800) >> 11
}
func (o *IOCON_Type) SetPIO0_4_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.PIO0_4.Reg, volatile.LoadUint32(&o.PIO0_4.Reg)&^(0xe000)|value<<13)
}
func (o *IOCON_Type) GetPIO0_4_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_4.Reg) & 0xe000) >> 13
}
func (o *IOCON_Type) SetPIO0_4_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_4.Reg, volatile.LoadUint32(&o.PIO0_4.Reg)&^(0xffff0000)|value<<16)
}
func (o *IOCON_Type) GetPIO0_4_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_4.Reg) & 0xffff0000) >> 16
}

// IOCON.PIO0_5: Digital I/O control for port 0 pins PIO0_0 to PIO0_17. With glitch filter.
func (o *IOCON_Type) SetPIO0_5_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_5.Reg, volatile.LoadUint32(&o.PIO0_5.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO0_5_RESERVED() uint32 {
	return volatile.LoadUint32(&o.PIO0_5.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO0_5_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_5.Reg, volatile.LoadUint32(&o.PIO0_5.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO0_5_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_5.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO0_5_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO0_5.Reg, volatile.LoadUint32(&o.PIO0_5.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO0_5_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO0_5.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO0_5_INV(value uint32) {
	volatile.StoreUint32(&o.PIO0_5.Reg, volatile.LoadUint32(&o.PIO0_5.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO0_5_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_5.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO0_5_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_5.Reg, volatile.LoadUint32(&o.PIO0_5.Reg)&^(0x80)|value<<7)
}
func (o *IOCON_Type) GetPIO0_5_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_5.Reg) & 0x80) >> 7
}
func (o *IOCON_Type) SetPIO0_5_FILTR(value uint32) {
	volatile.StoreUint32(&o.PIO0_5.Reg, volatile.LoadUint32(&o.PIO0_5.Reg)&^(0x100)|value<<8)
}
func (o *IOCON_Type) GetPIO0_5_FILTR() uint32 {
	return (volatile.LoadUint32(&o.PIO0_5.Reg) & 0x100) >> 8
}
func (o *IOCON_Type) SetPIO0_5_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_5.Reg, volatile.LoadUint32(&o.PIO0_5.Reg)&^(0x200)|value<<9)
}
func (o *IOCON_Type) GetPIO0_5_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_5.Reg) & 0x200) >> 9
}
func (o *IOCON_Type) SetPIO0_5_OD(value uint32) {
	volatile.StoreUint32(&o.PIO0_5.Reg, volatile.LoadUint32(&o.PIO0_5.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO0_5_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO0_5.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO0_5_S_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_5.Reg, volatile.LoadUint32(&o.PIO0_5.Reg)&^(0x1800)|value<<11)
}
func (o *IOCON_Type) GetPIO0_5_S_MODE() uint