// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from AT91SAM9G35.svd, see https://github.com/posborne/cmsis-svd/tree/master/data/Atmel

//go:build sam && at91sam9g35

// Atmel AT91SAM9G35 device: ARM926EJ Embedded Microprocessor Unit, 400MHz, LCD, Touchscreen, Ethernet, HS USB, LPDDR/DDR2/MLC NAND support, 217 Pins (refer to http://www.atmel.com/devices/SAM9G35.aspx for more)
//

package sam

import (
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	Device = "AT91SAM9G35"
)

// Interrupt numbers.
const (
	// Advanced Interrupt Controller
	IRQ_FIQ = 0

	// Debug Unit
	IRQ_DBGU = 1

	// Parallel Input/Output Controller A
	IRQ_PIOA = 2

	// Parallel Input/Output Controller C
	IRQ_PIOC = 3

	// Software Modem Device
	IRQ_SMD = 4

	// Universal Synchronous Asynchronous Receiver Transmitter 0
	IRQ_USART0 = 5

	// Universal Synchronous Asynchronous Receiver Transmitter 1
	IRQ_USART1 = 6

	// Universal Synchronous Asynchronous Receiver Transmitter 2
	IRQ_USART2 = 7

	// Two-wire Interface 0
	IRQ_TWI0 = 9

	// Two-wire Interface 1
	IRQ_TWI1 = 10

	// Two-wire Interface 2
	IRQ_TWI2 = 11

	// High Speed MultiMedia Card Interface 0
	IRQ_HSMCI0 = 12

	// Serial Peripheral Interface 0
	IRQ_SPI0 = 13

	// Serial Peripheral Interface 1
	IRQ_SPI1 = 14

	// Universal Asynchronous Receiver Transmitter 0
	IRQ_UART0 = 15

	// Universal Asynchronous Receiver Transmitter 1
	IRQ_UART1 = 16

	// Timer Counter 0
	IRQ_TC0 = 17

	// Pulse Width Modulation Controller
	IRQ_PWM = 18

	// Analog-to-Digital Converter
	IRQ_ADC = 19

	// DMA Controller 0
	IRQ_DMAC0 = 20

	// DMA Controller 1
	IRQ_DMAC1 = 21

	// USB High Speed Device Port
	IRQ_UDPHS = 23

	// Ethernet MAC 10/100
	IRQ_EMAC = 24

	// LCD Controller
	IRQ_LCDC = 25

	// High Speed MultiMedia Card Interface 1
	IRQ_HSMCI1 = 26

	// Synchronous Serial Controller
	IRQ_SSC = 28

	// Advanced Interrupt Controller
	IRQ_IRQ = 31

	// Highest interrupt number on this device.
	IRQ_max = 31
)

// Pseudo function call that is replaced by the compiler with the actual
// functions registered through interrupt.New.
//
//go:linkname callHandlers runtime/interrupt.callHandlers
func callHandlers(num int)

//export FIQ_IRQHandler
func interruptFIQ() {
	callHandlers(IRQ_FIQ)
}

//export DBGU_IRQHandler
func interruptDBGU() {
	callHandlers(IRQ_DBGU)
}

//export PIOA_IRQHandler
func interruptPIOA() {
	callHandlers(IRQ_PIOA)
}

//export PIOC_IRQHandler
func interruptPIOC() {
	callHandlers(IRQ_PIOC)
}

//export SMD_IRQHandler
func interruptSMD() {
	callHandlers(IRQ_SMD)
}

//export USART0_IRQHandler
func interruptUSART0() {
	callHandlers(IRQ_USART0)
}

//export USART1_IRQHandler
func interruptUSART1() {
	callHandlers(IRQ_USART1)
}

//export USART2_IRQHandler
func interruptUSART2() {
	callHandlers(IRQ_USART2)
}

//export TWI0_IRQHandler
func interruptTWI0() {
	callHandlers(IRQ_TWI0)
}

//export TWI1_IRQHandler
func interruptTWI1() {
	callHandlers(IRQ_TWI1)
}

//export TWI2_IRQHandler
func interruptTWI2() {
	callHandlers(IRQ_TWI2)
}

//export HSMCI0_IRQHandler
func interruptHSMCI0() {
	callHandlers(IRQ_HSMCI0)
}

//export SPI0_IRQHandler
func interruptSPI0() {
	callHandlers(IRQ_SPI0)
}

//export SPI1_IRQHandler
func interruptSPI1() {
	callHandlers(IRQ_SPI1)
}

//export UART0_IRQHandler
func interruptUART0() {
	callHandlers(IRQ_UART0)
}

//export UART1_IRQHandler
func interruptUART1() {
	callHandlers(IRQ_UART1)
}

//export TC0_IRQHandler
func interruptTC0() {
	callHandlers(IRQ_TC0)
}

//export PWM_IRQHandler
func interruptPWM() {
	callHandlers(IRQ_PWM)
}

//export ADC_IRQHandler
func interruptADC() {
	callHandlers(IRQ_ADC)
}

//export DMAC0_IRQHandler
func interruptDMAC0() {
	callHandlers(IRQ_DMAC0)
}

//export DMAC1_IRQHandler
func interruptDMAC1() {
	callHandlers(IRQ_DMAC1)
}

//export UDPHS_IRQHandler
func interruptUDPHS() {
	callHandlers(IRQ_UDPHS)
}

//export EMAC_IRQHandler
func interruptEMAC() {
	callHandlers(IRQ_EMAC)
}

//export LCDC_IRQHandler
func interruptLCDC() {
	callHandlers(IRQ_LCDC)
}

//export HSMCI1_IRQHandler
func interruptHSMCI1() {
	callHandlers(IRQ_HSMCI1)
}

//export SSC_IRQHandler
func interruptSSC() {
	callHandlers(IRQ_SSC)
}

//export IRQ_IRQHandler
func interruptIRQ() {
	callHandlers(IRQ_IRQ)
}

// Peripherals.
var (
	// Software Modem Device
	SMD = (*SMD_Type)(unsafe.Pointer(uintptr(0x400000)))

	// Serial Peripheral Interface 0
	SPI0 = (*SPI_Type)(unsafe.Pointer(uintptr(0xf0000000)))

	// Serial Peripheral Interface 1
	SPI1 = (*SPI_Type)(unsafe.Pointer(uintptr(0xf0004000)))

	// High Speed MultiMedia Card Interface 0
	HSMCI0 = (*HSMCI_Type)(unsafe.Pointer(uintptr(0xf0008000)))

	// High Speed MultiMedia Card Interface 1
	HSMCI1 = (*HSMCI_Type)(unsafe.Pointer(uintptr(0xf000c000)))

	// Synchronous Serial Controller
	SSC = (*SSC_Type)(unsafe.Pointer(uintptr(0xf0010000)))

	// Timer Counter 0
	TC0 = (*TC_Type)(unsafe.Pointer(uintptr(0xf8008000)))

	// Timer Counter 1
	TC1 = (*TC_Type)(unsafe.Pointer(uintptr(0xf800c000)))

	// Two-wire Interface 0
	TWI0 = (*TWI_Type)(unsafe.Pointer(uintptr(0xf8010000)))

	// Two-wire Interface 1
	TWI1 = (*TWI_Type)(unsafe.Pointer(uintptr(0xf8014000)))

	// Two-wire Interface 2
	TWI2 = (*TWI_Type)(unsafe.Pointer(uintptr(0xf8018000)))

	// Universal Synchronous Asynchronous Receiver Transmitter 0
	USART0 = (*USART_Type)(unsafe.Pointer(uintptr(0xf801c000)))

	// Universal Synchronous Asynchronous Receiver Transmitter 1
	USART1 = (*USART_Type)(unsafe.Pointer(uintptr(0xf8020000)))

	// Universal Synchronous Asynchronous Receiver Transmitter 2
	USART2 = (*USART_Type)(unsafe.Pointer(uintptr(0xf8024000)))

	// Ethernet MAC 10/100
	EMAC = (*EMAC_Type)(unsafe.Pointer(uintptr(0xf802c000)))

	// Pulse Width Modulation Controller
	PWM = (*PWM_Type)(unsafe.Pointer(uintptr(0xf8034000)))

	// LCD Controller
	LCDC = (*LCDC_Type)(unsafe.Pointer(uintptr(0xf8038000)))

	// USB High Speed Device Port
	UDPHS = (*UDPHS_Type)(unsafe.Pointer(uintptr(0xf803c000)))

	// Universal Asynchronous Receiver Transmitter 0
	UART0 = (*UART_Type)(unsafe.Pointer(uintptr(0xf8040000)))

	// Universal Asynchronous Receiver Transmitter 1
	UART1 = (*UART_Type)(unsafe.Pointer(uintptr(0xf8044000)))

	// Analog-to-Digital Converter
	ADC = (*ADC_Type)(unsafe.Pointer(uintptr(0xf804c000)))

	// AHB Bus Matrix
	MATRIX = (*MATRIX_Type)(unsafe.Pointer(uintptr(0xffffde00)))

	// Programmable Multibit Error Corrected Code Controller
	PMECC = (*EBI_Type)(unsafe.Pointer(uintptr(0xffffe000)))

	// Programmable Multibit ECC Error Location
	PMERRLOC = (*EBI_Type)(unsafe.Pointer(uintptr(0xffffe600)))

	// DDR_SDR SDRAM Controller
	DDRSDRC = (*EBI_Type)(unsafe.Pointer(uintptr(0xffffe800)))

	// Static Memory Controller
	SMC = (*EBI_Type)(unsafe.Pointer(uintptr(0xffffea00)))

	// DMA Controller 0
	DMAC0 = (*DMAC_Type)(unsafe.Pointer(uintptr(0xffffec00)))

	// DMA Controller 1
	DMAC1 = (*DMAC_Type)(unsafe.Pointer(uintptr(0xffffee00)))

	// Advanced Interrupt Controller
	AIC = (*AIC_Type)(unsafe.Pointer(uintptr(0xfffff000)))

	// Debug Unit
	DBGU = (*DBGU_Type)(unsafe.Pointer(uintptr(0xfffff200)))

	// Parallel Input/Output Controller A
	PIOA = (*PIO_Type)(unsafe.Pointer(uintptr(0xfffff400)))

	// Parallel Input/Output Controller B
	PIOB = (*PIO_Type)(unsafe.Pointer(uintptr(0xfffff600)))

	// Parallel Input/Output Controller C
	PIOC = (*PIO_Type)(unsafe.Pointer(uintptr(0xfffff800)))

	// Parallel Input/Output Controller D
	PIOD = (*PIO_Type)(unsafe.Pointer(uintptr(0xfffffa00)))

	// Power Management Controller
	PMC = (*PMC_Type)(unsafe.Pointer(uintptr(0xfffffc00)))

	// Reset Controller
	RSTC = (*SYSC_Type)(unsafe.Pointer(uintptr(0xfffffe00)))

	// Shutdown Controller
	SHDWC = (*SYSC_Type)(unsafe.Pointer(uintptr(0xfffffe10)))

	// Periodic Interval Timer
	PIT = (*SYSC_Type)(unsafe.Pointer(uintptr(0xfffffe30)))

	// Watchdog Timer
	WDT = (*SYSC_Type)(unsafe.Pointer(uintptr(0xfffffe40)))

	// Slow Clock Controller
	SCKC = (*SYSC_Type)(unsafe.Pointer(uintptr(0xfffffe50)))

	// Boot Sequence Controller
	BSC = (*SYSC_Type)(unsafe.Pointer(uintptr(0xfffffe54)))

	// General Purpose Backup Register
	GPBR = (*SYSC_Type)(unsafe.Pointer(uintptr(0xfffffe60)))

	// Real-time Clock
	RTC = (*RTC_Type)(unsafe.Pointer(uintptr(0xfffffeb0)))
)

// Software Modem Device
type SMD_Type struct {
}

// Serial Peripheral Interface 0
type SPI_Type struct {
	CR   volatile.Register32 // 0x0
	MR   volatile.Register32 // 0x4
	RDR  volatile.Register32 // 0x8
	TDR  volatile.Register32 // 0xC
	SR   volatile.Register32 // 0x10
	IER  volatile.Register32 // 0x14
	IDR  volatile.Register32 // 0x18
	IMR  volatile.Register32 // 0x1C
	_    [16]byte
	CSR  [4]volatile.Register32 // 0x30
	_    [164]byte
	WPMR volatile.Register32 // 0xE4
	WPSR volatile.Register32 // 0xE8
}

// SPI.CR: Control Register
func (o *SPI_Type) SetCR_SPIEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetCR_SPIEN() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *SPI_Type) SetCR_SPIDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetCR_SPIDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetCR_SWRST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *SPI_Type) GetCR_SWRST() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *SPI_Type) SetCR_LASTXFER(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000000)|value<<24)
}
func (o *SPI_Type) GetCR_LASTXFER() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000000) >> 24
}

// SPI.MR: Mode Register
func (o *SPI_Type) SetMR_MSTR(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetMR_MSTR() uint32 {
	return volatile.LoadUint32(&o.MR.Reg) & 0x1
}
func (o *SPI_Type) SetMR_PS(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetMR_PS() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetMR_PCSDEC(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x4)|value<<2)
}
func (o *SPI_Type) GetMR_PCSDEC() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x4) >> 2
}
func (o *SPI_Type) SetMR_MODFDIS(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x10)|value<<4)
}
func (o *SPI_Type) GetMR_MODFDIS() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x10) >> 4
}
func (o *SPI_Type) SetMR_WDRBT(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x20)|value<<5)
}
func (o *SPI_Type) GetMR_WDRBT() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x20) >> 5
}
func (o *SPI_Type) SetMR_LLB(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x80)|value<<7)
}
func (o *SPI_Type) GetMR_LLB() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x80) >> 7
}
func (o *SPI_Type) SetMR_PCS(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xf0000)|value<<16)
}
func (o *SPI_Type) GetMR_PCS() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xf0000) >> 16
}
func (o *SPI_Type) SetMR_DLYBCS(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xff000000)|value<<24)
}
func (o *SPI_Type) GetMR_DLYBCS() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xff000000) >> 24
}

// SPI.RDR: Receive Data Register
func (o *SPI_Type) SetRDR_RD(value uint32) {
	volatile.StoreUint32(&o.RDR.Reg, volatile.LoadUint32(&o.RDR.Reg)&^(0xffff)|value)
}
func (o *SPI_Type) GetRDR_RD() uint32 {
	return volatile.LoadUint32(&o.RDR.Reg) & 0xffff
}
func (o *SPI_Type) SetRDR_PCS(value uint32) {
	volatile.StoreUint32(&o.RDR.Reg, volatile.LoadUint32(&o.RDR.Reg)&^(0xf0000)|value<<16)
}
func (o *SPI_Type) GetRDR_PCS() uint32 {
	return (volatile.LoadUint32(&o.RDR.Reg) & 0xf0000) >> 16
}

// SPI.TDR: Transmit Data Register
func (o *SPI_Type) SetTDR_TD(value uint32) {
	volatile.StoreUint32(&o.TDR.Reg, volatile.LoadUint32(&o.TDR.Reg)&^(0xffff)|value)
}
func (o *SPI_Type) GetTDR_TD() uint32 {
	return volatile.LoadUint32(&o.TDR.Reg) & 0xffff
}
func (o *SPI_Type) SetTDR_PCS(value uint32) {
	volatile.StoreUint32(&o.TDR.Reg, volatile.LoadUint32(&o.TDR.Reg)&^(0xf0000)|value<<16)
}
func (o *SPI_Type) GetTDR_PCS() uint32 {
	return (volatile.LoadUint32(&o.TDR.Reg) & 0xf0000) >> 16
}
func (o *SPI_Type) SetTDR_LASTXFER(value uint32) {
	volatile.StoreUint32(&o.TDR.Reg, volatile.LoadUint32(&o.TDR.Reg)&^(0x1000000)|value<<24)
}
func (o *SPI_Type) GetTDR_LASTXFER() uint32 {
	return (volatile.LoadUint32(&o.TDR.Reg) & 0x1000000) >> 24
}

// SPI.SR: Status Register
func (o *SPI_Type) SetSR_RDRF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetSR_RDRF() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *SPI_Type) SetSR_TDRE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetSR_TDRE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetSR_MODF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *SPI_Type) GetSR_MODF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *SPI_Type) SetSR_OVRES(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *SPI_Type) GetSR_OVRES() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *SPI_Type) SetSR_NSSR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100)|value<<8)
}
func (o *SPI_Type) GetSR_NSSR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100) >> 8
}
func (o *SPI_Type) SetSR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x200)|value<<9)
}
func (o *SPI_Type) GetSR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x200) >> 9
}
func (o *SPI_Type) SetSR_SPIENS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10000)|value<<16)
}
func (o *SPI_Type) GetSR_SPIENS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10000) >> 16
}

// SPI.IER: Interrupt Enable Register
func (o *SPI_Type) SetIER_RDRF(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetIER_RDRF() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *SPI_Type) SetIER_TDRE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetIER_TDRE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetIER_MODF(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *SPI_Type) GetIER_MODF() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *SPI_Type) SetIER_OVRES(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *SPI_Type) GetIER_OVRES() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *SPI_Type) SetIER_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80)|value<<7)
}
func (o *SPI_Type) GetIER_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80) >> 7
}
func (o *SPI_Type) SetIER_NSSR(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100)|value<<8)
}
func (o *SPI_Type) GetIER_NSSR() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100) >> 8
}
func (o *SPI_Type) SetIER_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200)|value<<9)
}
func (o *SPI_Type) GetIER_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200) >> 9
}

// SPI.IDR: Interrupt Disable Register
func (o *SPI_Type) SetIDR_RDRF(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetIDR_RDRF() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *SPI_Type) SetIDR_TDRE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetIDR_TDRE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetIDR_MODF(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4)|value<<2)
}
func (o *SPI_Type) GetIDR_MODF() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4) >> 2
}
func (o *SPI_Type) SetIDR_OVRES(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8)|value<<3)
}
func (o *SPI_Type) GetIDR_OVRES() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8) >> 3
}
func (o *SPI_Type) SetIDR_NSSR(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100)|value<<8)
}
func (o *SPI_Type) GetIDR_NSSR() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100) >> 8
}
func (o *SPI_Type) SetIDR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200)|value<<9)
}
func (o *SPI_Type) GetIDR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200) >> 9
}

// SPI.IMR: Interrupt Mask Register
func (o *SPI_Type) SetIMR_RDRF(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetIMR_RDRF() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *SPI_Type) SetIMR_TDRE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetIMR_TDRE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetIMR_MODF(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4)|value<<2)
}
func (o *SPI_Type) GetIMR_MODF() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4) >> 2
}
func (o *SPI_Type) SetIMR_OVRES(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8)|value<<3)
}
func (o *SPI_Type) GetIMR_OVRES() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8) >> 3
}
func (o *SPI_Type) SetIMR_NSSR(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100)|value<<8)
}
func (o *SPI_Type) GetIMR_NSSR() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100) >> 8
}
func (o *SPI_Type) SetIMR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200)|value<<9)
}
func (o *SPI_Type) GetIMR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200) >> 9
}

// SPI.CSR: Chip Select Register
func (o *SPI_Type) SetCSR_CPOL(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetCSR_CPOL(idx int) uint32 {
	return volatile.LoadUint32(&o.CSR[idx].Reg) & 0x1
}
func (o *SPI_Type) SetCSR_NCPHA(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetCSR_NCPHA(idx int) uint32 {
	return (volatile.LoadUint32(&o.CSR[idx].Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetCSR_CSAAT(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0x8)|value<<3)
}
func (o *SPI_Type) GetCSR_CSAAT(idx int) uint32 {
	return (volatile.LoadUint32(&o.CSR[idx].Reg) & 0x8) >> 3
}
func (o *SPI_Type) SetCSR_BITS(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0xf0)|value<<4)
}
func (o *SPI_Type) GetCSR_BITS(idx int) uint32 {
	return (volatile.LoadUint32(&o.CSR[idx].Reg) & 0xf0) >> 4
}
func (o *SPI_Type) SetCSR_SCBR(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0xff00)|value<<8)
}
func (o *SPI_Type) GetCSR_SCBR(idx int) uint32 {
	return (volatile.LoadUint32(&o.CSR[idx].Reg) & 0xff00) >> 8
}
func (o *SPI_Type) SetCSR_DLYBS(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0xff0000)|value<<16)
}
func (o *SPI_Type) GetCSR_DLYBS(idx int) uint32 {
	return (volatile.LoadUint32(&o.CSR[idx].Reg) & 0xff0000) >> 16
}
func (o *SPI_Type) SetCSR_DLYBCT(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0xff000000)|value<<24)
}
func (o *SPI_Type) GetCSR_DLYBCT(idx int) uint32 {
	return (volatile.LoadUint32(&o.CSR[idx].Reg) & 0xff000000) >> 24
}

// SPI.WPMR: Write Protection Control Register
func (o *SPI_Type) SetWPMR_WPEN(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetWPMR_WPEN() uint32 {
	return volatile.LoadUint32(&o.WPMR.Reg) & 0x1
}
func (o *SPI_Type) SetWPMR_WPKEY(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *SPI_Type) GetWPMR_WPKEY() uint32 {
	return (volatile.LoadUint32(&o.WPMR.Reg) & 0xffffff00) >> 8
}

// SPI.WPSR: Write Protection Status Register
func (o *SPI_Type) SetWPSR_WPVS(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetWPSR_WPVS() uint32 {
	return volatile.LoadUint32(&o.WPSR.Reg) & 0x1
}
func (o *SPI_Type) SetWPSR_WPVSRC(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0xff00)|value<<8)
}
func (o *SPI_Type) GetWPSR_WPVSRC() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0xff00) >> 8
}

// High Speed MultiMedia Card Interface 0
type HSMCI_Type struct {
	CR    volatile.Register32    // 0x0
	MR    volatile.Register32    // 0x4
	DTOR  volatile.Register32    // 0x8
	SDCR  volatile.Register32    // 0xC
	ARGR  volatile.Register32    // 0x10
	CMDR  volatile.Register32    // 0x14
	BLKR  volatile.Register32    // 0x18
	CSTOR volatile.Register32    // 0x1C
	RSPR  [4]volatile.Register32 // 0x20
	RDR   volatile.Register32    // 0x30
	TDR   volatile.Register32    // 0x34
	_     [8]byte
	SR    volatile.Register32 // 0x40
	IER   volatile.Register32 // 0x44
	IDR   volatile.Register32 // 0x48
	IMR   volatile.Register32 // 0x4C
	DMA   volatile.Register32 // 0x50
	CFG   volatile.Register32 // 0x54
	_     [140]byte
	WPMR  volatile.Register32 // 0xE4
	WPSR  volatile.Register32 // 0xE8
	_     [276]byte
	FIFO  [256]volatile.Register32 // 0x200
}

// HSMCI.CR: Control Register
func (o *HSMCI_Type) SetCR_MCIEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *HSMCI_Type) GetCR_MCIEN() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *HSMCI_Type) SetCR_MCIDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *HSMCI_Type) GetCR_MCIDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *HSMCI_Type) SetCR_PWSEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *HSMCI_Type) GetCR_PWSEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *HSMCI_Type) SetCR_PWSDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *HSMCI_Type) GetCR_PWSDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *HSMCI_Type) SetCR_SWRST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *HSMCI_Type) GetCR_SWRST() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}

// HSMCI.MR: Mode Register
func (o *HSMCI_Type) SetMR_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xff)|value)
}
func (o *HSMCI_Type) GetMR_CLKDIV() uint32 {
	return volatile.LoadUint32(&o.MR.Reg) & 0xff
}
func (o *HSMCI_Type) SetMR_PWSDIV(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x700)|value<<8)
}
func (o *HSMCI_Type) GetMR_PWSDIV() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x700) >> 8
}
func (o *HSMCI_Type) SetMR_RDPROOF(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x800)|value<<11)
}
func (o *HSMCI_Type) GetMR_RDPROOF() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x800) >> 11
}
func (o *HSMCI_Type) SetMR_WRPROOF(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x1000)|value<<12)
}
func (o *HSMCI_Type) GetMR_WRPROOF() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x1000) >> 12
}
func (o *HSMCI_Type) SetMR_FBYTE(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x2000)|value<<13)
}
func (o *HSMCI_Type) GetMR_FBYTE() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x2000) >> 13
}
func (o *HSMCI_Type) SetMR_PADV(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x4000)|value<<14)
}
func (o *HSMCI_Type) GetMR_PADV() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x4000) >> 14
}
func (o *HSMCI_Type) SetMR_CLKODD(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x10000)|value<<16)
}
func (o *HSMCI_Type) GetMR_CLKODD() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x10000) >> 16
}

// HSMCI.DTOR: Data Timeout Register
func (o *HSMCI_Type) SetDTOR_DTOCYC(value uint32) {
	volatile.StoreUint32(&o.DTOR.Reg, volatile.LoadUint32(&o.DTOR.Reg)&^(0xf)|value)
}
func (o *HSMCI_Type) GetDTOR_DTOCYC() uint32 {
	return volatile.LoadUint32(&o.DTOR.Reg) & 0xf
}
func (o *HSMCI_Type) SetDTOR_DTOMUL(value uint32) {
	volatile.StoreUint32(&o.DTOR.Reg, volatile.LoadUint32(&o.DTOR.Reg)&^(0x70)|value<<4)
}
func (o *HSMCI_Type) GetDTOR_DTOMUL() uint32 {
	return (volatile.LoadUint32(&o.DTOR.Reg) & 0x70) >> 4
}

// HSMCI.SDCR: SD/SDIO Card Register
func (o *HSMCI_Type) SetSDCR_SDCSEL(value uint32) {
	volatile.StoreUint32(&o.SDCR.Reg, volatile.LoadUint32(&o.SDCR.Reg)&^(0x3)|value)
}
func (o *HSMCI_Type) GetSDCR_SDCSEL() uint32 {
	return volatile.LoadUint32(&o.SDCR.Reg) & 0x3
}
func (o *HSMCI_Type) SetSDCR_SDCBUS(value uint32) {
	volatile.StoreUint32(&o.SDCR.Reg, volatile.LoadUint32(&o.SDCR.Reg)&^(0xc0)|value<<6)
}
func (o *HSMCI_Type) GetSDCR_SDCBUS() uint32 {
	return (volatile.LoadUint32(&o.SDCR.Reg) & 0xc0) >> 6
}

// HSMCI.ARGR: Argument Register
func (o *HSMCI_Type) SetARGR(value uint32) {
	volatile.StoreUint32(&o.ARGR.Reg, value)
}
func (o *HSMCI_Type) GetARGR() uint32 {
	return volatile.LoadUint32(&o.ARGR.Reg)
}

// HSMCI.CMDR: Command Register
func (o *HSMCI_Type) SetCMDR_CMDNB(value uint32) {
	volatile.StoreUint32(&o.CMDR.Reg, volatile.LoadUint32(&o.CMDR.Reg)&^(0x3f)|value)
}
func (o *HSMCI_Type) GetCMDR_CMDNB() uint32 {
	return volatile.LoadUint32(&o.CMDR.Reg) & 0x3f
}
func (o *HSMCI_Type) SetCMDR_RSPTYP(value uint32) {
	volatile.StoreUint32(&o.CMDR.Reg, volatile.LoadUint32(&o.CMDR.Reg)&^(0xc0)|value<<6)
}
func (o *HSMCI_Type) GetCMDR_RSPTYP() uint32 {
	return (volatile.LoadUint32(&o.CMDR.Reg) & 0xc0) >> 6
}
func (o *HSMCI_Type) SetCMDR_SPCMD(value uint32) {
	volatile.StoreUint32(&o.CMDR.Reg, volatile.LoadUint32(&o.CMDR.Reg)&^(0x700)|value<<8)
}
func (o *HSMCI_Type) GetCMDR_SPCMD() uint32 {
	return (volatile.LoadUint32(&o.CMDR.Reg) & 0x700) >> 8
}
func (o *HSMCI_Type) SetCMDR_OPDCMD(value uint32) {
	volatile.StoreUint32(&o.CMDR.Reg, volatile.LoadUint32(&o.CMDR.Reg)&^(0x800)|value<<11)
}
func (o *HSMCI_Type) GetCMDR_OPDCMD() uint32 {
	return (volatile.LoadUint32(&o.CMDR.Reg) & 0x800) >> 11
}
func (o *HSMCI_Type) SetCMDR_MAXLAT(value uint32) {
	volatile.StoreUint32(&o.CMDR.Reg, volatile.LoadUint32(&o.CMDR.Reg)&^(0x1000)|value<<12)
}
func (o *HSMCI_Type) GetCMDR_MAXLAT() uint32 {
	return (volatile.LoadUint32(&o.CMDR.Reg) & 0x1000) >> 12
}
func (o *HSMCI_Type) SetCMDR_TRCMD(value uint32) {
	volatile.StoreUint32(&o.CMDR.Reg, volatile.LoadUint32(&o.CMDR.Reg)&^(0x30000)|value<<16)
}
func (o *HSMCI_Type) GetCMDR_TRCMD() uint32 {
	return (volatile.LoadUint32(&o.CMDR.Reg) & 0x30000) >> 16
}
func (o *HSMCI_Type) SetCMDR_TRDIR(value uint32) {
	volatile.StoreUint32(&o.CMDR.Reg, volatile.LoadUint32(&o.CMDR.Reg)&^(0x40000)|value<<18)
}
func (o *HSMCI_Type) GetCMDR_TRDIR() uint32 {
	return (volatile.LoadUint32(&o.CMDR.Reg) & 0x40000) >> 18
}
func (o *HSMCI_Type) SetCMDR_TRTYP(value uint32) {
	volatile.StoreUint32(&o.CMDR.Reg, volatile.LoadUint32(&o.CMDR.Reg)&^(0x380000)|value<<19)
}
func (o *HSMCI_Type) GetCMDR_TRTYP() uint32 {
	return (volatile.LoadUint32(&o.CMDR.Reg) & 0x380000) >> 19
}
func (o *HSMCI_Type) SetCMDR_IOSPCMD(value uint32) {
	volatile.StoreUint32(&o.CMDR.Reg, volatile.LoadUint32(&o.CMDR.Reg)&^(0x3000000)|value<<24)
}
func (o *HSMCI_Type) GetCMDR_IOSPCMD() uint32 {
	return (volatile.LoadUint32(&o.CMDR.Reg) & 0x3000000) >> 24
}
func (o *HSMCI_Type) SetCMDR_ATACS(value uint32) {
	volatile.StoreUint32(&o.CMDR.Reg, volatile.LoadUint32(&o.CMDR.Reg)&^(0x4000000)|value<<26)
}
func (o *HSMCI_Type) GetCMDR_ATACS() uint32 {
	return (volatile.LoadUint32(&o.CMDR.Reg) & 0x4000000) >> 26
}
func (o *HSMCI_Type) SetCMDR_BOOT_ACK(value uint32) {
	volatile.StoreUint32(&o.CMDR.Reg, volatile.LoadUint32(&o.CMDR.Reg)&^(0x8000000)|value<<27)
}
func (o *HSMCI_Type) GetCMDR_BOOT_ACK() uint32 {
	return (volatile.LoadUint32(&o.CMDR.Reg) & 0x8000000) >> 27
}

// HSMCI.BLKR: Block Register
func (o *HSMCI_Type) SetBLKR_BCNT(value uint32) {
	volatile.StoreUint32(&o.BLKR.Reg, volatile.LoadUint32(&o.BLKR.Reg)&^(0xffff)|value)
}
func (o *HSMCI_Type) GetBLKR_BCNT() uint32 {
	return volatile.LoadUint32(&o.BLKR.Reg) & 0xffff
}
func (o *HSMCI_Type) SetBLKR_BLKLEN(value uint32) {
	volatile.StoreUint32(&o.BLKR.Reg, volatile.LoadUint32(&o.BLKR.Reg)&^(0xffff0000)|value<<16)
}
func (o *HSMCI_Type) GetBLKR_BLKLEN() uint32 {
	return (volatile.LoadUint32(&o.BLKR.Reg) & 0xffff0000) >> 16
}

// HSMCI.CSTOR: Completion Signal Timeout Register
func (o *HSMCI_Type) SetCSTOR_CSTOCYC(value uint32) {
	volatile.StoreUint32(&o.CSTOR.Reg, volatile.LoadUint32(&o.CSTOR.Reg)&^(0xf)|value)
}
func (o *HSMCI_Type) GetCSTOR_CSTOCYC() uint32 {
	return volatile.LoadUint32(&o.CSTOR.Reg) & 0xf
}
func (o *HSMCI_Type) SetCSTOR_CSTOMUL(value uint32) {
	volatile.StoreUint32(&o.CSTOR.Reg, volatile.LoadUint32(&o.CSTOR.Reg)&^(0x70)|value<<4)
}
func (o *HSMCI_Type) GetCSTOR_CSTOMUL() uint32 {
	return (volatile.LoadUint32(&o.CSTOR.Reg) & 0x70) >> 4
}

// HSMCI.RSPR: Response Register
func (o *HSMCI_Type) SetRSPR(idx int, value uint32) {
	volatile.StoreUint32(&o.RSPR[idx].Reg, value)
}
func (o *HSMCI_Type) GetRSPR(idx int) uint32 {
	return volatile.LoadUint32(&o.RSPR[idx].Reg)
}

// HSMCI.RDR: Receive Data Register
func (o *HSMCI_Type) SetRDR(value uint32) {
	volatile.StoreUint32(&o.RDR.Reg, value)
}
func (o *HSMCI_Type) GetRDR() uint32 {
	return volatile.LoadUint32(&o.RDR.Reg)
}

// HSMCI.TDR: Transmit Data Register
func (o *HSMCI_Type) SetTDR(value uint32) {
	volatile.StoreUint32(&o.TDR.Reg, value)
}
func (o *HSMCI_Type) GetTDR() uint32 {
	return volatile.LoadUint32(&o.TDR.Reg)
}

// HSMCI.SR: Status Register
func (o *HSMCI_Type) SetSR_CMDRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *HSMCI_Type) GetSR_CMDRDY() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *HSMCI_Type) SetSR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *HSMCI_Type) GetSR_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *HSMCI_Type) SetSR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *HSMCI_Type) GetSR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *HSMCI_Type) SetSR_BLKE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *HSMCI_Type) GetSR_BLKE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *HSMCI_Type) SetSR_DTIP(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *HSMCI_Type) GetSR_DTIP() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *HSMCI_Type) SetSR_NOTBUSY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *HSMCI_Type) GetSR_NOTBUSY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *HSMCI_Type) SetSR_SDIOIRQA(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100)|value<<8)
}
func (o *HSMCI_Type) GetSR_SDIOIRQA() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100) >> 8
}
func (o *HSMCI_Type) SetSR_SDIOWAIT(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1000)|value<<12)
}
func (o *HSMCI_Type) GetSR_SDIOWAIT() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x1000) >> 12
}
func (o *HSMCI_Type) SetSR_CSRCV(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2000)|value<<13)
}
func (o *HSMCI_Type) GetSR_CSRCV() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2000) >> 13
}
func (o *HSMCI_Type) SetSR_RINDE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10000)|value<<16)
}
func (o *HSMCI_Type) GetSR_RINDE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10000) >> 16
}
func (o *HSMCI_Type) SetSR_RDIRE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20000)|value<<17)
}
func (o *HSMCI_Type) GetSR_RDIRE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20000) >> 17
}
func (o *HSMCI_Type) SetSR_RCRCE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40000)|value<<18)
}
func (o *HSMCI_Type) GetSR_RCRCE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40000) >> 18
}
func (o *HSMCI_Type) SetSR_RENDE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80000)|value<<19)
}
func (o *HSMCI_Type) GetSR_RENDE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80000) >> 19
}
func (o *HSMCI_Type) SetSR_RTOE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100000)|value<<20)
}
func (o *HSMCI_Type) GetSR_RTOE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100000) >> 20
}
func (o *HSMCI_Type) SetSR_DCRCE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x200000)|value<<21)
}
func (o *HSMCI_Type) GetSR_DCRCE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x200000) >> 21
}
func (o *HSMCI_Type) SetSR_DTOE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x400000)|value<<22)
}
func (o *HSMCI_Type) GetSR_DTOE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x400000) >> 22
}
func (o *HSMCI_Type) SetSR_CSTOE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x800000)|value<<23)
}
func (o *HSMCI_Type) GetSR_CSTOE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x800000) >> 23
}
func (o *HSMCI_Type) SetSR_BLKOVRE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1000000)|value<<24)
}
func (o *HSMCI_Type) GetSR_BLKOVRE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x1000000) >> 24
}
func (o *HSMCI_Type) SetSR_DMADONE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2000000)|value<<25)
}
func (o *HSMCI_Type) GetSR_DMADONE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2000000) >> 25
}
func (o *HSMCI_Type) SetSR_FIFOEMPTY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4000000)|value<<26)
}
func (o *HSMCI_Type) GetSR_FIFOEMPTY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4000000) >> 26
}
func (o *HSMCI_Type) SetSR_XFRDONE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8000000)|value<<27)
}
func (o *HSMCI_Type) GetSR_XFRDONE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8000000) >> 27
}
func (o *HSMCI_Type) SetSR_ACKRCV(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10000000)|value<<28)
}
func (o *HSMCI_Type) GetSR_ACKRCV() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10000000) >> 28
}
func (o *HSMCI_Type) SetSR_ACKRCVE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20000000)|value<<29)
}
func (o *HSMCI_Type) GetSR_ACKRCVE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20000000) >> 29
}
func (o *HSMCI_Type) SetSR_OVRE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40000000)|value<<30)
}
func (o *HSMCI_Type) GetSR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40000000) >> 30
}
func (o *HSMCI_Type) SetSR_UNRE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80000000)|value<<31)
}
func (o *HSMCI_Type) GetSR_UNRE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80000000) >> 31
}

// HSMCI.IER: Interrupt Enable Register
func (o *HSMCI_Type) SetIER_CMDRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *HSMCI_Type) GetIER_CMDRDY() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *HSMCI_Type) SetIER_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *HSMCI_Type) GetIER_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *HSMCI_Type) SetIER_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *HSMCI_Type) GetIER_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *HSMCI_Type) SetIER_BLKE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *HSMCI_Type) GetIER_BLKE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *HSMCI_Type) SetIER_DTIP(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *HSMCI_Type) GetIER_DTIP() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *HSMCI_Type) SetIER_NOTBUSY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *HSMCI_Type) GetIER_NOTBUSY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *HSMCI_Type) SetIER_SDIOIRQA(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100)|value<<8)
}
func (o *HSMCI_Type) GetIER_SDIOIRQA() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100) >> 8
}
func (o *HSMCI_Type) SetIER_SDIOWAIT(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1000)|value<<12)
}
func (o *HSMCI_Type) GetIER_SDIOWAIT() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x1000) >> 12
}
func (o *HSMCI_Type) SetIER_CSRCV(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2000)|value<<13)
}
func (o *HSMCI_Type) GetIER_CSRCV() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2000) >> 13
}
func (o *HSMCI_Type) SetIER_RINDE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10000)|value<<16)
}
func (o *HSMCI_Type) GetIER_RINDE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10000) >> 16
}
func (o *HSMCI_Type) SetIER_RDIRE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20000)|value<<17)
}
func (o *HSMCI_Type) GetIER_RDIRE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20000) >> 17
}
func (o *HSMCI_Type) SetIER_RCRCE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40000)|value<<18)
}
func (o *HSMCI_Type) GetIER_RCRCE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40000) >> 18
}
func (o *HSMCI_Type) SetIER_RENDE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80000)|value<<19)
}
func (o *HSMCI_Type) GetIER_RENDE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80000) >> 19
}
func (o *HSMCI_Type) SetIER_RTOE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100000)|value<<20)
}
func (o *HSMCI_Type) GetIER_RTOE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100000) >> 20
}
func (o *HSMCI_Type) SetIER_DCRCE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200000)|value<<21)
}
func (o *HSMCI_Type) GetIER_DCRCE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200000) >> 21
}
func (o *HSMCI_Type) SetIER_DTOE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400000)|value<<22)
}
func (o *HSMCI_Type) GetIER_DTOE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400000) >> 22
}
func (o *HSMCI_Type) SetIER_CSTOE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x800000)|value<<23)
}
func (o *HSMCI_Type) GetIER_CSTOE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x800000) >> 23
}
func (o *HSMCI_Type) SetIER_BLKOVRE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1000000)|value<<24)
}
func (o *HSMCI_Type) GetIER_BLKOVRE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x1000000) >> 24
}
func (o *HSMCI_Type) SetIER_DMADONE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2000000)|value<<25)
}
func (o *HSMCI_Type) GetIER_DMADONE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2000000) >> 25
}
func (o *HSMCI_Type) SetIER_FIFOEMPTY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4000000)|value<<26)
}
func (o *HSMCI_Type) GetIER_FIFOEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4000000) >> 26
}
func (o *HSMCI_Type) SetIER_XFRDONE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8000000)|value<<27)
}
func (o *HSMCI_Type) GetIER_XFRDONE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8000000) >> 27
}
func (o *HSMCI_Type) SetIER_ACKRCV(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10000000)|value<<28)
}
func (o *HSMCI_Type) GetIER_ACKRCV() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10000000) >> 28
}
func (o *HSMCI_Type) SetIER_ACKRCVE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20000000)|value<<29)
}
func (o *HSMCI_Type) GetIER_ACKRCVE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20000000) >> 29
}
func (o *HSMCI_Type) SetIER_OVRE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40000000)|value<<30)
}
func (o *HSMCI_Type) GetIER_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40000000) >> 30
}
func (o *HSMCI_Type) SetIER_UNRE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80000000)|value<<31)
}
func (o *HSMCI_Type) GetIER_UNRE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80000000) >> 31
}

// HSMCI.IDR: Interrupt Disable Register
func (o *HSMCI_Type) SetIDR_CMDRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *HSMCI_Type) GetIDR_CMDRDY() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *HSMCI_Type) SetIDR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *HSMCI_Type) GetIDR_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *HSMCI_Type) SetIDR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4)|value<<2)
}
func (o *HSMCI_Type) GetIDR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4) >> 2
}
func (o *HSMCI_Type) SetIDR_BLKE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8)|value<<3)
}
func (o *HSMCI_Type) GetIDR_BLKE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8) >> 3
}
func (o *HSMCI_Type) SetIDR_DTIP(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10)|value<<4)
}
func (o *HSMCI_Type) GetIDR_DTIP() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10) >> 4
}
func (o *HSMCI_Type) SetIDR_NOTBUSY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20)|value<<5)
}
func (o *HSMCI_Type) GetIDR_NOTBUSY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20) >> 5
}
func (o *HSMCI_Type) SetIDR_SDIOIRQA(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100)|value<<8)
}
func (o *HSMCI_Type) GetIDR_SDIOIRQA() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100) >> 8
}
func (o *HSMCI_Type) SetIDR_SDIOWAIT(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1000)|value<<12)
}
func (o *HSMCI_Type) GetIDR_SDIOWAIT() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x1000) >> 12
}
func (o *HSMCI_Type) SetIDR_CSRCV(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2000)|value<<13)
}
func (o *HSMCI_Type) GetIDR_CSRCV() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2000) >> 13
}
func (o *HSMCI_Type) SetIDR_RINDE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10000)|value<<16)
}
func (o *HSMCI_Type) GetIDR_RINDE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10000) >> 16
}
func (o *HSMCI_Type) SetIDR_RDIRE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20000)|value<<17)
}
func (o *HSMCI_Type) GetIDR_RDIRE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20000) >> 17
}
func (o *HSMCI_Type) SetIDR_RCRCE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40000)|value<<18)
}
func (o *HSMCI_Type) GetIDR_RCRCE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40000) >> 18
}
func (o *HSMCI_Type) SetIDR_RENDE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80000)|value<<19)
}
func (o *HSMCI_Type) GetIDR_RENDE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80000) >> 19
}
func (o *HSMCI_Type) SetIDR_RTOE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100000)|value<<20)
}
func (o *HSMCI_Type) GetIDR_RTOE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100000) >> 20
}
func (o *HSMCI_Type) SetIDR_DCRCE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200000)|value<<21)
}
func (o *HSMCI_Type) GetIDR_DCRCE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200000) >> 21
}
func (o *HSMCI_Type) SetIDR_DTOE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400000)|value<<22)
}
func (o *HSMCI_Type) GetIDR_DTOE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400000) >> 22
}
func (o *HSMCI_Type) SetIDR_CSTOE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x800000)|value<<23)
}
func (o *HSMCI_Type) GetIDR_CSTOE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x800000) >> 23
}
func (o *HSMCI_Type) SetIDR_BLKOVRE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1000000)|value<<24)
}
func (o *HSMCI_Type) GetIDR_BLKOVRE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x1000000) >> 24
}
func (o *HSMCI_Type) SetIDR_DMADONE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2000000)|value<<25)
}
func (o *HSMCI_Type) GetIDR_DMADONE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2000000) >> 25
}
func (o *HSMCI_Type) SetIDR_FIFOEMPTY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4000000)|value<<26)
}
func (o *HSMCI_Type) GetIDR_FIFOEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4000000) >> 26
}
func (o *HSMCI_Type) SetIDR_XFRDONE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8000000)|value<<27)
}
func (o *HSMCI_Type) GetIDR_XFRDONE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8000000) >> 27
}
func (o *HSMCI_Type) SetIDR_ACKRCV(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10000000)|value<<28)
}
func (o *HSMCI_Type) GetIDR_ACKRCV() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10000000) >> 28
}
func (o *HSMCI_Type) SetIDR_ACKRCVE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20000000)|value<<29)
}
func (o *HSMCI_Type) GetIDR_ACKRCVE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20000000) >> 29
}
func (o *HSMCI_Type) SetIDR_OVRE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40000000)|value<<30)
}
func (o *HSMCI_Type) GetIDR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40000000) >> 30
}
func (o *HSMCI_Type) SetIDR_UNRE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80000000)|value<<31)
}
func (o *HSMCI_Type) GetIDR_UNRE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80000000) >> 31
}

// HSMCI.IMR: Interrupt Mask Register
func (o *HSMCI_Type) SetIMR_CMDRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *HSMCI_Type) GetIMR_CMDRDY() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *HSMCI_Type) SetIMR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *HSMCI_Type) GetIMR_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *HSMCI_Type) SetIMR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4)|value<<2)
}
func (o *HSMCI_Type) GetIMR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4) >> 2
}
func (o *HSMCI_Type) SetIMR_BLKE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8)|value<<3)
}
func (o *HSMCI_Type) GetIMR_BLKE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8) >> 3
}
func (o *HSMCI_Type) SetIMR_DTIP(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10)|value<<4)
}
func (o *HSMCI_Type) GetIMR_DTIP() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10) >> 4
}
func (o *HSMCI_Type) SetIMR_NOTBUSY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20)|value<<5)
}
func (o *HSMCI_Type) GetIMR_NOTBUSY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20) >> 5
}
func (o *HSMCI_Type) SetIMR_SDIOIRQA(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100)|value<<8)
}
func (o *HSMCI_Type) GetIMR_SDIOIRQA() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100) >> 8
}
func (o *HSMCI_Type) SetIMR_SDIOWAIT(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1000)|value<<12)
}
func (o *HSMCI_Type) GetIMR_SDIOWAIT() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x1000) >> 12
}
func (o *HSMCI_Type) SetIMR_CSRCV(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2000)|value<<13)
}
func (o *HSMCI_Type) GetIMR_CSRCV() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2000) >> 13
}
func (o *HSMCI_Type) SetIMR_RINDE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10000)|value<<16)
}
func (o *HSMCI_Type) GetIMR_RINDE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10000) >> 16
}
func (o *HSMCI_Type) SetIMR_RDIRE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20000)|value<<17)
}
func (o *HSMCI_Type) GetIMR_RDIRE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20000) >> 17
}
func (o *HSMCI_Type) SetIMR_RCRCE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40000)|value<<18)
}
func (o *HSMCI_Type) GetIMR_RCRCE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40000) >> 18
}
func (o *HSMCI_Type) SetIMR_RENDE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80000)|value<<19)
}
func (o *HSMCI_Type) GetIMR_RENDE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80000) >> 19
}
func (o *HSMCI_Type) SetIMR_RTOE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100000)|value<<20)
}
func (o *HSMCI_Type) GetIMR_RTOE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100000) >> 20
}
func (o *HSMCI_Type) SetIMR_DCRCE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200000)|value<<21)
}
func (o *HSMCI_Type) GetIMR_DCRCE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200000) >> 21
}
func (o *HSMCI_Type) SetIMR_DTOE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400000)|value<<22)
}
func (o *HSMCI_Type) GetIMR_DTOE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400000) >> 22
}
func (o *HSMCI_Type) SetIMR_CSTOE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x800000)|value<<23)
}
func (o *HSMCI_Type) GetIMR_CSTOE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x800000) >> 23
}
func (o *HSMCI_Type) SetIMR_BLKOVRE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1000000)|value<<24)
}
func (o *HSMCI_Type) GetIMR_BLKOVRE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x1000000) >> 24
}
func (o *HSMCI_Type) SetIMR_DMADONE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2000000)|value<<25)
}
func (o *HSMCI_Type) GetIMR_DMADONE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2000000) >> 25
}
func (o *HSMCI_Type) SetIMR_FIFOEMPTY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4000000)|value<<26)
}
func (o *HSMCI_Type) GetIMR_FIFOEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4000000) >> 26
}
func (o *HSMCI_Type) SetIMR_XFRDONE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8000000)|value<<27)
}
func (o *HSMCI_Type) GetIMR_XFRDONE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8000000) >> 27
}
func (o *HSMCI_Type) SetIMR_ACKRCV(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10000000)|value<<28)
}
func (o *HSMCI_Type) GetIMR_ACKRCV() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10000000) >> 28
}
func (o *HSMCI_Type) SetIMR_ACKRCVE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20000000)|value<<29)
}
func (o *HSMCI_Type) GetIMR_ACKRCVE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20000000) >> 29
}
func (o *HSMCI_Type) SetIMR_OVRE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40000000)|value<<30)
}
func (o *HSMCI_Type) GetIMR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40000000) >> 30
}
func (o *HSMCI_Type) SetIMR_UNRE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80000000)|value<<31)
}
func (o *HSMCI_Type) GetIMR_UNRE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80000000) >> 31
}

// HSMCI.DMA: DMA Configuration Register
func (o *HSMCI_Type) SetDMA_OFFSET(value uint32) {
	volatile.StoreUint32(&o.DMA.Reg, volatile.LoadUint32(&o.DMA.Reg)&^(0x3)|value)
}
func (o *HSMCI_Type) GetDMA_OFFSET() uint32 {
	return volatile.LoadUint32(&o.DMA.Reg) & 0x3
}
func (o *HSMCI_Type) SetDMA_CHKSIZE(value uint32) {
	volatile.StoreUint32(&o.DMA.Reg, volatile.LoadUint32(&o.DMA.Reg)&^(0x30)|value<<4)
}
func (o *HSMCI_Type) GetDMA_CHKSIZE() uint32 {
	return (volatile.LoadUint32(&o.DMA.Reg) & 0x30) >> 4
}
func (o *HSMCI_Type) SetDMA_DMAEN(value uint32) {
	volatile.StoreUint32(&o.DMA.Reg, volatile.LoadUint32(&o.DMA.Reg)&^(0x100)|value<<8)
}
func (o *HSMCI_Type) GetDMA_DMAEN() uint32 {
	return (volatile.LoadUint32(&o.DMA.Reg) & 0x100) >> 8
}
func (o *HSMCI_Type) SetDMA_ROPT(value uint32) {
	volatile.StoreUint32(&o.DMA.Reg, volatile.LoadUint32(&o.DMA.Reg)&^(0x1000)|value<<12)
}
func (o *HSMCI_Type) GetDMA_ROPT() uint32 {
	return (volatile.LoadUint32(&o.DMA.Reg) & 0x1000) >> 12
}

// HSMCI.CFG: Configuration Register
func (o *HSMCI_Type) SetCFG_FIFOMODE(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x1)|value)
}
func (o *HSMCI_Type) GetCFG_FIFOMODE() uint32 {
	return volatile.LoadUint32(&o.CFG.Reg) & 0x1
}
func (o *HSMCI_Type) SetCFG_FERRCTRL(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x10)|value<<4)
}
func (o *HSMCI_Type) GetCFG_FERRCTRL() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x10) >> 4
}
func (o *HSMCI_Type) SetCFG_HSMODE(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x100)|value<<8)
}
func (o *HSMCI_Type) GetCFG_HSMODE() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x100) >> 8
}
func (o *HSMCI_Type) SetCFG_LSYNC(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x1000)|value<<12)
}
func (o *HSMCI_Type) GetCFG_LSYNC() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x1000) >> 12
}

// HSMCI.WPMR: Write Protection Mode Register
func (o *HSMCI_Type) SetWPMR_WP_EN(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0x1)|value)
}
func (o *HSMCI_Type) GetWPMR_WP_EN() uint32 {
	return volatile.LoadUint32(&o.WPMR.Reg) & 0x1
}
func (o *HSMCI_Type) SetWPMR_WP_KEY(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *HSMCI_Type) GetWPMR_WP_KEY() uint32 {
	return (volatile.LoadUint32(&o.WPMR.Reg) & 0xffffff00) >> 8
}

// HSMCI.WPSR: Write Protection Status Register
func (o *HSMCI_Type) SetWPSR_WP_VS(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0xf)|value)
}
func (o *HSMCI_Type) GetWPSR_WP_VS() uint32 {
	return volatile.LoadUint32(&o.WPSR.Reg) & 0xf
}
func (o *HSMCI_Type) SetWPSR_WP_VSRC(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0xffff00)|value<<8)
}
func (o *HSMCI_Type) GetWPSR_WP_VSRC() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0xffff00) >> 8
}

// HSMCI.FIFO: FIFO Memory Aperture0
func (o *HSMCI_Type) SetFIFO(idx int, value uint32) {
	volatile.StoreUint32(&o.FIFO[idx].Reg, value)
}
func (o *HSMCI_Type) GetFIFO(idx int) uint32 {
	return volatile.LoadUint32(&o.FIFO[idx].Reg)
}

// Synchronous Serial Controller
type SSC_Type struct {
	CR   volatile.Register32 // 0x0
	CMR  volatile.Register32 // 0x4
	_    [8]byte
	RCMR volatile.Register32 // 0x10
	RFMR volatile.Register32 // 0x14
	TCMR volatile.Register32 // 0x18
	TFMR volatile.Register32 // 0x1C
	RHR  volatile.Register32 // 0x20
	THR  volatile.Register32 // 0x24
	_    [8]byte
	RSHR volatile.Register32 // 0x30
	TSHR volatile.Register32 // 0x34
	RC0R volatile.Register32 // 0x38
	RC1R volatile.Register32 // 0x3C
	SR   volatile.Register32 // 0x40
	IER  volatile.Register32 // 0x44
	IDR  volatile.Register32 // 0x48
	IMR  volatile.Register32 // 0x4C
	_    [148]byte
	WPMR volatile.Register32 // 0xE4
	WPSR volatile.Register32 // 0xE8
}

// SSC.CR: Control Register
func (o *SSC_Type) SetCR_RXEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *SSC_Type) GetCR_RXEN() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *SSC_Type) SetCR_RXDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *SSC_Type) GetCR_RXDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *SSC_Type) SetCR_TXEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100)|value<<8)
}
func (o *SSC_Type) GetCR_TXEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100) >> 8
}
func (o *SSC_Type) SetCR_TXDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x200)|value<<9)
}
func (o *SSC_Type) GetCR_TXDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x200) >> 9
}
func (o *SSC_Type) SetCR_SWRST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8000)|value<<15)
}
func (o *SSC_Type) GetCR_SWRST() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8000) >> 15
}

// SSC.CMR: Clock Mode Register
func (o *SSC_Type) SetCMR_DIV(value uint32) {
	volatile.StoreUint32(&o.CMR.Reg, volatile.LoadUint32(&o.CMR.Reg)&^(0xfff)|value)
}
func (o *SSC_Type) GetCMR_DIV() uint32 {
	return volatile.LoadUint32(&o.CMR.Reg) & 0xfff
}

// SSC.RCMR: Receive Clock Mode Register
func (o *SSC_Type) SetRCMR_CKS(value uint32) {
	volatile.StoreUint32(&o.RCMR.Reg, volatile.LoadUint32(&o.RCMR.Reg)&^(0x3)|value)
}
func (o *SSC_Type) GetRCMR_CKS() uint32 {
	return volatile.LoadUint32(&o.RCMR.Reg) & 0x3
}
func (o *SSC_Type) SetRCMR_CKO(value uint32) {
	volatile.StoreUint32(&o.RCMR.Reg, volatile.LoadUint32(&o.RCMR.Reg)&^(0x1c)|value<<2)
}
func (o *SSC_Type) GetRCMR_CKO() uint32 {
	return (volatile.LoadUint32(&o.RCMR.Reg) & 0x1c) >> 2
}
func (o *SSC_Type) SetRCMR_CKI(value uint32) {
	volatile.StoreUint32(&o.RCMR.Reg, volatile.LoadUint32(&o.RCMR.Reg)&^(0x20)|value<<5)
}
func (o *SSC_Type) GetRCMR_CKI() uint32 {
	return (volatile.LoadUint32(&o.RCMR.Reg) & 0x20) >> 5
}
func (o *SSC_Type) SetRCMR_CKG(value uint32) {
	volatile.StoreUint32(&o.RCMR.Reg, volatile.LoadUint32(&o.RCMR.Reg)&^(0xc0)|value<<6)
}
func (o *SSC_Type) GetRCMR_CKG() uint32 {
	return (volatile.LoadUint32(&o.RCMR.Reg) & 0xc0) >> 6
}
func (o *SSC_Type) SetRCMR_START(value uint32) {
	volatile.StoreUint32(&o.RCMR.Reg, volatile.LoadUint32(&o.RCMR.Reg)&^(0xf00)|value<<8)
}
func (o *SSC_Type) GetRCMR_START() uint32 {
	return (volatile.LoadUint32(&o.RCMR.Reg) & 0xf00) >> 8
}
func (o *SSC_Type) SetRCMR_STOP(value uint32) {
	volatile.StoreUint32(&o.RCMR.Reg, volatile.LoadUint32(&o.RCMR.Reg)&^(0x1000)|value<<12)
}
func (o *SSC_Type) GetRCMR_STOP() uint32 {
	return (volatile.LoadUint32(&o.RCMR.Reg) & 0x1000) >> 12
}
func (o *SSC_Type) SetRCMR_STTDLY(value uint32) {
	volatile.StoreUint32(&o.RCMR.Reg, volatile.LoadUint32(&o.RCMR.Reg)&^(0xff0000)|value<<16)
}
func (o *SSC_Type) GetRCMR_STTDLY() uint32 {
	return (volatile.LoadUint32(&o.RCMR.Reg) & 0xff0000) >> 16
}
func (o *SSC_Type) SetRCMR_PERIOD(value uint32) {
	volatile.StoreUint32(&o.RCMR.Reg, volatile.LoadUint32(&o.RCMR.Reg)&^(0xff000000)|value<<24)
}
func (o *SSC_Type) GetRCMR_PERIOD() uint32 {
	return (volatile.LoadUint32(&o.RCMR.Reg) & 0xff000000) >> 24
}

// SSC.RFMR: Receive Frame Mode Register
func (o *SSC_Type) SetRFMR_DATLEN(value uint32) {
	volatile.StoreUint32(&o.RFMR.Reg, volatile.LoadUint32(&o.RFMR.Reg)&^(0x1f)|value)
}
func (o *SSC_Type) GetRFMR_DATLEN() uint32 {
	return volatile.LoadUint32(&o.RFMR.Reg) & 0x1f
}
func (o *SSC_Type) SetRFMR_LOOP(value uint32) {
	volatile.StoreUint32(&o.RFMR.Reg, volatile.LoadUint32(&o.RFMR.Reg)&^(0x20)|value<<5)
}
func (o *SSC_Type) GetRFMR_LOOP() uint32 {
	return (volatile.LoadUint32(&o.RFMR.Reg) & 0x20) >> 5
}
func (o *SSC_Type) SetRFMR_MSBF(value uint32) {
	volatile.StoreUint32(&o.RFMR.Reg, volatile.LoadUint32(&o.RFMR.Reg)&^(0x80)|value<<7)
}
func (o *SSC_Type) GetRFMR_MSBF() uint32 {
	return (volatile.LoadUint32(&o.RFMR.Reg) & 0x80) >> 7
}
func (o *SSC_Type) SetRFMR_DATNB(value uint32) {
	volatile.StoreUint32(&o.RFMR.Reg, volatile.LoadUint32(&o.RFMR.Reg)&^(0xf00)|value<<8)
}
func (o *SSC_Type) GetRFMR_DATNB() uint32 {
	return (volatile.LoadUint32(&o.RFMR.Reg) & 0xf00) >> 8
}
func (o *SSC_Type) SetRFMR_FSLEN(value uint32) {
	volatile.StoreUint32(&o.RFMR.Reg, volatile.LoadUint32(&o.RFMR.Reg)&^(0xf0000)|value<<16)
}
func (o *SSC_Type) GetRFMR_FSLEN() uint32 {
	return (volatile.LoadUint32(&o.RFMR.Reg) & 0xf0000) >> 16
}
func (o *SSC_Type) SetRFMR_FSOS(value uint32) {
	volatile.StoreUint32(&o.RFMR.Reg, volatile.LoadUint32(&o.RFMR.Reg)&^(0x700000)|value<<20)
}
func (o *SSC_Type) GetRFMR_FSOS() uint32 {
	return (volatile.LoadUint32(&o.RFMR.Reg) & 0x700000) >> 20
}
func (o *SSC_Type) SetRFMR_FSEDGE(value uint32) {
	volatile.StoreUint32(&o.RFMR.Reg, volatile.LoadUint32(&o.RFMR.Reg)&^(0x1000000)|value<<24)
}
func (o *SSC_Type) GetRFMR_FSEDGE() uint32 {
	return (volatile.LoadUint32(&o.RFMR.Reg) & 0x1000000) >> 24
}
func (o *SSC_Type) SetRFMR_FSLEN_EXT(value uint32) {
	volatile.StoreUint32(&o.RFMR.Reg, volatile.LoadUint32(&o.RFMR.Reg)&^(0xf0000000)|value<<28)
}
func (o *SSC_Type) GetRFMR_FSLEN_EXT() uint32 {
	return (volatile.LoadUint32(&o.RFMR.Reg) & 0xf0000000) >> 28
}

// SSC.TCMR: Transmit Clock Mode Register
func (o *SSC_Type) SetTCMR_CKS(value uint32) {
	volatile.StoreUint32(&o.TCMR.Reg, volatile.LoadUint32(&o.TCMR.Reg)&^(0x3)|value)
}
func (o *SSC_Type) GetTCMR_CKS() uint32 {
	return volatile.LoadUint32(&o.TCMR.Reg) & 0x3
}
func (o *SSC_Type) SetTCMR_CKO(value uint32) {
	volatile.StoreUint32(&o.TCMR.Reg, volatile.LoadUint32(&o.TCMR.Reg)&^(0x1c)|value<<2)
}
func (o *SSC_Type) GetTCMR_CKO() uint32 {
	return (volatile.LoadUint32(&o.TCMR.Reg) & 0x1c) >> 2
}
func (o *SSC_Type) SetTCMR_CKI(value uint32) {
	volatile.StoreUint32(&o.TCMR.Reg, volatile.LoadUint32(&o.TCMR.Reg)&^(0x20)|value<<5)
}
func (o *SSC_Type) GetTCMR_CKI() uint32 {
	return (volatile.LoadUint32(&o.TCMR.Reg) & 0x20) >> 5
}
func (o *SSC_Type) SetTCMR_CKG(value uint32) {
	volatile.StoreUint32(&o.TCMR.Reg, volatile.LoadUint32(&o.TCMR.Reg)&^(0xc0)|value<<6)
}
func (o *SSC_Type) GetTCMR_CKG() uint32 {
	return (volatile.LoadUint32(&o.TCMR.Reg) & 0xc0) >> 6
}
func (o *SSC_Type) SetTCMR_START(value uint32) {
	volatile.StoreUint32(&o.TCMR.Reg, volatile.LoadUint32(&o.TCMR.Reg)&^(0xf00)|value<<8)
}
func (o *SSC_Type) GetTCMR_START() uint32 {
	return (volatile.LoadUint32(&o.TCMR.Reg) & 0xf00) >> 8
}
func (o *SSC_Type) SetTCMR_STTDLY(value uint32) {
	volatile.StoreUint32(&o.TCMR.Reg, volatile.LoadUint32(&o.TCMR.Reg)&^(0xff0000)|value<<16)
}
func (o *SSC_Type) GetTCMR_STTDLY() uint32 {
	return (volatile.LoadUint32(&o.TCMR.Reg) & 0xff0000) >> 16
}
func (o *SSC_Type) SetTCMR_PERIOD(value uint32) {
	volatile.StoreUint32(&o.TCMR.Reg, volatile.LoadUint32(&o.TCMR.Reg)&^(0xff000000)|value<<24)
}
func (o *SSC_Type) GetTCMR_PERIOD() uint32 {
	return (volatile.LoadUint32(&o.TCMR.Reg) & 0xff000000) >> 24
}

// SSC.TFMR: Transmit Frame Mode Register
func (o *SSC_Type) SetTFMR_DATLEN(value uint32) {
	volatile.StoreUint32(&o.TFMR.Reg, volatile.LoadUint32(&o.TFMR.Reg)&^(0x1f)|value)
}
func (o *SSC_Type) GetTFMR_DATLEN() uint32 {
	return volatile.LoadUint32(&o.TFMR.Reg) & 0x1f
}
func (o *SSC_Type) SetTFMR_DATDEF(value uint32) {
	volatile.StoreUint32(&o.TFMR.Reg, volatile.LoadUint32(&o.TFMR.Reg)&^(0x20)|value<<5)
}
func (o *SSC_Type) GetTFMR_DATDEF() uint32 {
	return (volatile.LoadUint32(&o.TFMR.Reg) & 0x20) >> 5
}
func (o *SSC_Type) SetTFMR_MSBF(value uint32) {
	volatile.StoreUint32(&o.TFMR.Reg, volatile.LoadUint32(&o.TFMR.Reg)&^(0x80)|value<<7)
}
func (o *SSC_Type) GetTFMR_MSBF() uint32 {
	return (volatile.LoadUint32(&o.TFMR.Reg) & 0x80) >> 7
}
func (o *SSC_Type) SetTFMR_DATNB(value uint32) {
	volatile.StoreUint32(&o.TFMR.Reg, volatile.LoadUint32(&o.TFMR.Reg)&^(0xf00)|value<<8)
}
func (o *SSC_Type) GetTFMR_DATNB() uint32 {
	return (volatile.LoadUint32(&o.TFMR.Reg) & 0xf00) >> 8
}
func (o *SSC_Type) SetTFMR_FSLEN(value uint32) {
	volatile.StoreUint32(&o.TFMR.Reg, volatile.LoadUint32(&o.TFMR.Reg)&^(0xf0000)|value<<16)
}
func (o *SSC_Type) GetTFMR_FSLEN() uint32 {
	return (volatile.LoadUint32(&o.TFMR.Reg) & 0xf0000) >> 16
}
func (o *SSC_Type) SetTFMR_FSOS(value uint32) {
	volatile.StoreUint32(&o.TFMR.Reg, volatile.LoadUint32(&o.TFMR.Reg)&^(0x700000)|value<<20)
}
func (o *SSC_Type) GetTFMR_FSOS() uint32 {
	return (volatile.LoadUint32(&o.TFMR.Reg) & 0x700000) >> 20
}
func (o *SSC_Type) SetTFMR_FSDEN(value uint32) {
	volatile.StoreUint32(&o.TFMR.Reg, volatile.LoadUint32(&o.TFMR.Reg)&^(0x800000)|value<<23)
}
func (o *SSC_Type) GetTFMR_FSDEN() uint32 {
	return (volatile.LoadUint32(&o.TFMR.Reg) & 0x800000) >> 23
}
func (o *SSC_Type) SetTFMR_FSEDGE(value uint32) {
	volatile.StoreUint32(&o.TFMR.Reg, volatile.LoadUint32(&o.TFMR.Reg)&^(0x1000000)|value<<24)
}
func (o *SSC_Type) GetTFMR_FSEDGE() uint32 {
	return (volatile.LoadUint32(&o.TFMR.Reg) & 0x1000000) >> 24
}
func (o *SSC_Type) SetTFMR_FSLEN_EXT(value uint32) {
	volatile.StoreUint32(&o.TFMR.Reg, volatile.LoadUint32(&o.TFMR.Reg)&^(0xf0000000)|value<<28)
}
func (o *SSC_Type) GetTFMR_FSLEN_EXT() uint32 {
	return (volatile.LoadUint32(&o.TFMR.Reg) & 0xf0000000) >> 28
}

// SSC.RHR: Receive Holding Register
func (o *SSC_Type) SetRHR(value uint32) {
	volatile.StoreUint32(&o.RHR.Reg, value)
}
func (o *SSC_Type) GetRHR() uint32 {
	return volatile.LoadUint32(&o.RHR.Reg)
}

// SSC.THR: Transmit Holding Register
func (o *SSC_Type) SetTHR(value uint32) {
	volatile.StoreUint32(&o.THR.Reg, value)
}
func (o *SSC_Type) GetTHR() uint32 {
	return volatile.LoadUint32(&o.THR.Reg)
}

// SSC.RSHR: Receive Sync. Holding Register
func (o *SSC_Type) SetRSHR_RSDAT(value uint32) {
	volatile.StoreUint32(&o.RSHR.Reg, volatile.LoadUint32(&o.RSHR.Reg)&^(0xffff)|value)
}
func (o *SSC_Type) GetRSHR_RSDAT() uint32 {
	return volatile.LoadUint32(&o.RSHR.Reg) & 0xffff
}

// SSC.TSHR: Transmit Sync. Holding Register
func (o *SSC_Type) SetTSHR_TSDAT(value uint32) {
	volatile.StoreUint32(&o.TSHR.Reg, volatile.LoadUint32(&o.TSHR.Reg)&^(0xffff)|value)
}
func (o *SSC_Type) GetTSHR_TSDAT() uint32 {
	return volatile.LoadUint32(&o.TSHR.Reg) & 0xffff
}

// SSC.RC0R: Receive Compare 0 Register
func (o *SSC_Type) SetRC0R_CP0(value uint32) {
	volatile.StoreUint32(&o.RC0R.Reg, volatile.LoadUint32(&o.RC0R.Reg)&^(0xffff)|value)
}
func (o *SSC_Type) GetRC0R_CP0() uint32 {
	return volatile.LoadUint32(&o.RC0R.Reg) & 0xffff
}

// SSC.RC1R: Receive Compare 1 Register
func (o *SSC_Type) SetRC1R_CP1(value uint32) {
	volatile.StoreUint32(&o.RC1R.Reg, volatile.LoadUint32(&o.RC1R.Reg)&^(0xffff)|value)
}
func (o *SSC_Type) GetRC1R_CP1() uint32 {
	return volatile.LoadUint32(&o.RC1R.Reg) & 0xffff
}

// SSC.SR: Status Register
func (o *SSC_Type) SetSR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *SSC_Type) GetSR_TXRDY() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *SSC_Type) SetSR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *SSC_Type) GetSR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *SSC_Type) SetSR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *SSC_Type) GetSR_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *SSC_Type) SetSR_OVRUN(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *SSC_Type) GetSR_OVRUN() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *SSC_Type) SetSR_CP0(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100)|value<<8)
}
func (o *SSC_Type) GetSR_CP0() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100) >> 8
}
func (o *SSC_Type) SetSR_CP1(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x200)|value<<9)
}
func (o *SSC_Type) GetSR_CP1() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x200) >> 9
}
func (o *SSC_Type) SetSR_TXSYN(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x400)|value<<10)
}
func (o *SSC_Type) GetSR_TXSYN() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x400) >> 10
}
func (o *SSC_Type) SetSR_RXSYN(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x800)|value<<11)
}
func (o *SSC_Type) GetSR_RXSYN() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x800) >> 11
}
func (o *SSC_Type) SetSR_TXEN(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10000)|value<<16)
}
func (o *SSC_Type) GetSR_TXEN() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10000) >> 16
}
func (o *SSC_Type) SetSR_RXEN(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20000)|value<<17)
}
func (o *SSC_Type) GetSR_RXEN() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20000) >> 17
}

// SSC.IER: Interrupt Enable Register
func (o *SSC_Type) SetIER_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *SSC_Type) GetIER_TXRDY() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *SSC_Type) SetIER_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *SSC_Type) GetIER_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *SSC_Type) SetIER_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *SSC_Type) GetIER_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *SSC_Type) SetIER_OVRUN(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *SSC_Type) GetIER_OVRUN() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *SSC_Type) SetIER_CP0(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100)|value<<8)
}
func (o *SSC_Type) GetIER_CP0() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100) >> 8
}
func (o *SSC_Type) SetIER_CP1(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200)|value<<9)
}
func (o *SSC_Type) GetIER_CP1() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200) >> 9
}
func (o *SSC_Type) SetIER_TXSYN(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400)|value<<10)
}
func (o *SSC_Type) GetIER_TXSYN() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400) >> 10
}
func (o *SSC_Type) SetIER_RXSYN(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x800)|value<<11)
}
func (o *SSC_Type) GetIER_RXSYN() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x800) >> 11
}

// SSC.IDR: Interrupt Disable Register
func (o *SSC_Type) SetIDR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *SSC_Type) GetIDR_TXRDY() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *SSC_Type) SetIDR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *SSC_Type) GetIDR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *SSC_Type) SetIDR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10)|value<<4)
}
func (o *SSC_Type) GetIDR_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10) >> 4
}
func (o *SSC_Type) SetIDR_OVRUN(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20)|value<<5)
}
func (o *SSC_Type) GetIDR_OVRUN() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20) >> 5
}
func (o *SSC_Type) SetIDR_CP0(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100)|value<<8)
}
func (o *SSC_Type) GetIDR_CP0() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100) >> 8
}
func (o *SSC_Type) SetIDR_CP1(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200)|value<<9)
}
func (o *SSC_Type) GetIDR_CP1() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200) >> 9
}
func (o *SSC_Type) SetIDR_TXSYN(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400)|value<<10)
}
func (o *SSC_Type) GetIDR_TXSYN() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400) >> 10
}
func (o *SSC_Type) SetIDR_RXSYN(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x800)|value<<11)
}
func (o *SSC_Type) GetIDR_RXSYN() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x800) >> 11
}

// SSC.IMR: Interrupt Mask Register
func (o *SSC_Type) SetIMR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *SSC_Type) GetIMR_TXRDY() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *SSC_Type) SetIMR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *SSC_Type) GetIMR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *SSC_Type) SetIMR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10)|value<<4)
}
func (o *SSC_Type) GetIMR_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10) >> 4
}
func (o *SSC_Type) SetIMR_OVRUN(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20)|value<<5)
}
func (o *SSC_Type) GetIMR_OVRUN() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20) >> 5
}
func (o *SSC_Type) SetIMR_CP0(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100)|value<<8)
}
func (o *SSC_Type) GetIMR_CP0() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100) >> 8
}
func (o *SSC_Type) SetIMR_CP1(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200)|value<<9)
}
func (o *SSC_Type) GetIMR_CP1() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200) >> 9
}
func (o *SSC_Type) SetIMR_TXSYN(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400)|value<<10)
}
func (o *SSC_Type) GetIMR_TXSYN() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400) >> 10
}
func (o *SSC_Type) SetIMR_RXSYN(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x800)|value<<11)
}
func (o *SSC_Type) GetIMR_RXSYN() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x800) >> 11
}

// SSC.WPMR: Write Protect Mode Register
func (o *SSC_Type) SetWPMR_WPEN(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0x1)|value)
}
func (o *SSC_Type) GetWPMR_WPEN() uint32 {
	return volatile.LoadUint32(&o.WPMR.Reg) & 0x1
}
func (o *SSC_Type) SetWPMR_WPKEY(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *SSC_Type) GetWPMR_WPKEY() uint32 {
	return (volatile.LoadUint32(&o.WPMR.Reg) & 0xffffff00) >> 8
}

// Timer Counter 0
type TC_Type struct {
	CCR0 volatile.Register32 // 0x0
	CMR0 volatile.Register32 // 0x4
	_    [8]byte
	CV0  volatile.Register32 // 0x10
	RA0  volatile.Register32 // 0x14
	RB0  volatile.Register32 // 0x18
	RC0  volatile.Register32 // 0x1C
	SR0  volatile.Register32 // 0x20
	IER0 volatile.Register32 // 0x24
	IDR0 volatile.Register32 // 0x28
	IMR0 volatile.Register32 // 0x2C
	_    [16]byte
	CCR1 volatile.Register32 // 0x40
	CMR1 volatile.Register32 // 0x44
	_    [8]byte
	CV1  volatile.Register32 // 0x50
	RA1  volatile.Register32 // 0x54
	RB1  volatile.Register32 // 0x58
	RC1  volatile.Register32 // 0x5C
	SR1  volatile.Register32 // 0x60
	IER1 volatile.Register32 // 0x64
	IDR1 volatile.Register32 // 0x68
	IMR1 volatile.Register32 // 0x6C
	_    [16]byte
	CCR2 volatile.Register32 // 0x80
	CMR2 volatile.Register32 // 0x84
	_    [8]byte
	CV2  volatile.Register32 // 0x90
	RA2  volatile.Register32 // 0x94
	RB2  volatile.Register32 // 0x98
	RC2  volatile.Register32 // 0x9C
	SR2  volatile.Register32 // 0xA0
	IER2 volatile.Register32 // 0xA4
	IDR2 volatile.Register32 // 0xA8
	IMR2 volatile.Register32 // 0xAC
	_    [16]byte
	BCR  volatile.Register32 // 0xC0
	BMR  volatile.Register32 // 0xC4
}

// TC.CCR0: Channel Control Register (channel = 0)
func (o *TC_Type) SetCCR0_CLKEN(value uint32) {
	volatile.StoreUint32(&o.CCR0.Reg, volatile.LoadUint32(&o.CCR0.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetCCR0_CLKEN() uint32 {
	return volatile.LoadUint32(&o.CCR0.Reg) & 0x1
}
func (o *TC_Type) SetCCR0_CLKDIS(value uint32) {
	volatile.StoreUint32(&o.CCR0.Reg, volatile.LoadUint32(&o.CCR0.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetCCR0_CLKDIS() uint32 {
	return (volatile.LoadUint32(&o.CCR0.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetCCR0_SWTRG(value uint32) {
	volatile.StoreUint32(&o.CCR0.Reg, volatile.LoadUint32(&o.CCR0.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetCCR0_SWTRG() uint32 {
	return (volatile.LoadUint32(&o.CCR0.Reg) & 0x4) >> 2
}

// TC.CMR0: Channel Mode Register (channel = 0)
func (o *TC_Type) SetCMR0_TCCLKS(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x7)|value)
}
func (o *TC_Type) GetCMR0_TCCLKS() uint32 {
	return volatile.LoadUint32(&o.CMR0.Reg) & 0x7
}
func (o *TC_Type) SetCMR0_CLKI(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetCMR0_CLKI() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetCMR0_BURST(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x30)|value<<4)
}
func (o *TC_Type) GetCMR0_BURST() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x30) >> 4
}
func (o *TC_Type) SetCMR0_LDBSTOP(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetCMR0_LDBSTOP() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetCMR0_LDBDIS(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetCMR0_LDBDIS() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x80) >> 7
}
func (o *TC_Type) SetCMR0_ETRGEDG(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x300)|value<<8)
}
func (o *TC_Type) GetCMR0_ETRGEDG() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x300) >> 8
}
func (o *TC_Type) SetCMR0_ABETRG(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x400)|value<<10)
}
func (o *TC_Type) GetCMR0_ABETRG() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x400) >> 10
}
func (o *TC_Type) SetCMR0_CPCTRG(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x4000)|value<<14)
}
func (o *TC_Type) GetCMR0_CPCTRG() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x4000) >> 14
}
func (o *TC_Type) SetCMR0_WAVE(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x8000)|value<<15)
}
func (o *TC_Type) GetCMR0_WAVE() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x8000) >> 15
}
func (o *TC_Type) SetCMR0_LDRA(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x30000)|value<<16)
}
func (o *TC_Type) GetCMR0_LDRA() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x30000) >> 16
}
func (o *TC_Type) SetCMR0_LDRB(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0xc0000)|value<<18)
}
func (o *TC_Type) GetCMR0_LDRB() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0xc0000) >> 18
}

// TC.CV0: Counter Value (channel = 0)
func (o *TC_Type) SetCV0(value uint32) {
	volatile.StoreUint32(&o.CV0.Reg, value)
}
func (o *TC_Type) GetCV0() uint32 {
	return volatile.LoadUint32(&o.CV0.Reg)
}

// TC.RA0: Register A (channel = 0)
func (o *TC_Type) SetRA0(value uint32) {
	volatile.StoreUint32(&o.RA0.Reg, value)
}
func (o *TC_Type) GetRA0() uint32 {
	return volatile.LoadUint32(&o.RA0.Reg)
}

// TC.RB0: Register B (channel = 0)
func (o *TC_Type) SetRB0(value uint32) {
	volatile.StoreUint32(&o.RB0.Reg, value)
}
func (o *TC_Type) GetRB0() uint32 {
	return volatile.LoadUint32(&o.RB0.Reg)
}

// TC.RC0: Register C (channel = 0)
func (o *TC_Type) SetRC0(value uint32) {
	volatile.StoreUint32(&o.RC0.Reg, value)
}
func (o *TC_Type) GetRC0() uint32 {
	return volatile.LoadUint32(&o.RC0.Reg)
}

// TC.SR0: Status Register (channel = 0)
func (o *TC_Type) SetSR0_COVFS(value uint32) {
	volatile.StoreUint32(&o.SR0.Reg, volatile.LoadUint32(&o.SR0.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetSR0_COVFS() uint32 {
	return volatile.LoadUint32(&o.SR0.Reg) & 0x1
}
func (o *TC_Type) SetSR0_LOVRS(value uint32) {
	volatile.StoreUint32(&o.SR0.Reg, volatile.LoadUint32(&o.SR0.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetSR0_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.SR0.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetSR0_CPAS(value uint32) {
	volatile.StoreUint32(&o.SR0.Reg, volatile.LoadUint32(&o.SR0.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetSR0_CPAS() uint32 {
	return (volatile.LoadUint32(&o.SR0.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetSR0_CPBS(value uint32) {
	volatile.StoreUint32(&o.SR0.Reg, volatile.LoadUint32(&o.SR0.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetSR0_CPBS() uint32 {
	return (volatile.LoadUint32(&o.SR0.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetSR0_CPCS(value uint32) {
	volatile.StoreUint32(&o.SR0.Reg, volatile.LoadUint32(&o.SR0.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetSR0_CPCS() uint32 {
	return (volatile.LoadUint32(&o.SR0.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetSR0_LDRAS(value uint32) {
	volatile.StoreUint32(&o.SR0.Reg, volatile.LoadUint32(&o.SR0.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetSR0_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.SR0.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetSR0_LDRBS(value uint32) {
	volatile.StoreUint32(&o.SR0.Reg, volatile.LoadUint32(&o.SR0.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetSR0_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.SR0.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetSR0_ETRGS(value uint32) {
	volatile.StoreUint32(&o.SR0.Reg, volatile.LoadUint32(&o.SR0.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetSR0_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.SR0.Reg) & 0x80) >> 7
}
func (o *TC_Type) SetSR0_CLKSTA(value uint32) {
	volatile.StoreUint32(&o.SR0.Reg, volatile.LoadUint32(&o.SR0.Reg)&^(0x10000)|value<<16)
}
func (o *TC_Type) GetSR0_CLKSTA() uint32 {
	return (volatile.LoadUint32(&o.SR0.Reg) & 0x10000) >> 16
}
func (o *TC_Type) SetSR0_MTIOA(value uint32) {
	volatile.StoreUint32(&o.SR0.Reg, volatile.LoadUint32(&o.SR0.Reg)&^(0x20000)|value<<17)
}
func (o *TC_Type) GetSR0_MTIOA() uint32 {
	return (volatile.LoadUint32(&o.SR0.Reg) & 0x20000) >> 17
}
func (o *TC_Type) SetSR0_MTIOB(value uint32) {
	volatile.StoreUint32(&o.SR0.Reg, volatile.LoadUint32(&o.SR0.Reg)&^(0x40000)|value<<18)
}
func (o *TC_Type) GetSR0_MTIOB() uint32 {
	return (volatile.LoadUint32(&o.SR0.Reg) & 0x40000) >> 18
}

// TC.IER0: Interrupt Enable Register (channel = 0)
func (o *TC_Type) SetIER0_COVFS(value uint32) {
	volatile.StoreUint32(&o.IER0.Reg, volatile.LoadUint32(&o.IER0.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetIER0_COVFS() uint32 {
	return volatile.LoadUint32(&o.IER0.Reg) & 0x1
}
func (o *TC_Type) SetIER0_LOVRS(value uint32) {
	volatile.StoreUint32(&o.IER0.Reg, volatile.LoadUint32(&o.IER0.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetIER0_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.IER0.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetIER0_CPAS(value uint32) {
	volatile.StoreUint32(&o.IER0.Reg, volatile.LoadUint32(&o.IER0.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetIER0_CPAS() uint32 {
	return (volatile.LoadUint32(&o.IER0.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetIER0_CPBS(value uint32) {
	volatile.StoreUint32(&o.IER0.Reg, volatile.LoadUint32(&o.IER0.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetIER0_CPBS() uint32 {
	return (volatile.LoadUint32(&o.IER0.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetIER0_CPCS(value uint32) {
	volatile.StoreUint32(&o.IER0.Reg, volatile.LoadUint32(&o.IER0.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetIER0_CPCS() uint32 {
	return (volatile.LoadUint32(&o.IER0.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetIER0_LDRAS(value uint32) {
	volatile.StoreUint32(&o.IER0.Reg, volatile.LoadUint32(&o.IER0.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetIER0_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.IER0.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetIER0_LDRBS(value uint32) {
	volatile.StoreUint32(&o.IER0.Reg, volatile.LoadUint32(&o.IER0.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetIER0_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.IER0.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetIER0_ETRGS(value uint32) {
	volatile.StoreUint32(&o.IER0.Reg, volatile.LoadUint32(&o.IER0.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetIER0_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.IER0.Reg) & 0x80) >> 7
}

// TC.IDR0: Interrupt Disable Register (channel = 0)
func (o *TC_Type) SetIDR0_COVFS(value uint32) {
	volatile.StoreUint32(&o.IDR0.Reg, volatile.LoadUint32(&o.IDR0.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetIDR0_COVFS() uint32 {
	return volatile.LoadUint32(&o.IDR0.Reg) & 0x1
}
func (o *TC_Type) SetIDR0_LOVRS(value uint32) {
	volatile.StoreUint32(&o.IDR0.Reg, volatile.LoadUint32(&o.IDR0.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetIDR0_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.IDR0.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetIDR0_CPAS(value uint32) {
	volatile.StoreUint32(&o.IDR0.Reg, volatile.LoadUint32(&o.IDR0.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetIDR0_CPAS() uint32 {
	return (volatile.LoadUint32(&o.IDR0.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetIDR0_CPBS(value uint32) {
	volatile.StoreUint32(&o.IDR0.Reg, volatile.LoadUint32(&o.IDR0.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetIDR0_CPBS() uint32 {
	return (volatile.LoadUint32(&o.IDR0.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetIDR0_CPCS(value uint32) {
	volatile.StoreUint32(&o.IDR0.Reg, volatile.LoadUint32(&o.IDR0.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetIDR0_CPCS() uint32 {
	return (volatile.LoadUint32(&o.IDR0.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetIDR0_LDRAS(value uint32) {
	volatile.StoreUint32(&o.IDR0.Reg, volatile.LoadUint32(&o.IDR0.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetIDR0_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.IDR0.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetIDR0_LDRBS(value uint32) {
	volatile.StoreUint32(&o.IDR0.Reg, volatile.LoadUint32(&o.IDR0.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetIDR0_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.IDR0.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetIDR0_ETRGS(value uint32) {
	volatile.StoreUint32(&o.IDR0.Reg, volatile.LoadUint32(&o.IDR0.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetIDR0_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.IDR0.Reg) & 0x80) >> 7
}

// TC.IMR0: Interrupt Mask Register (channel = 0)
func (o *TC_Type) SetIMR0_COVFS(value uint32) {
	volatile.StoreUint32(&o.IMR0.Reg, volatile.LoadUint32(&o.IMR0.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetIMR0_COVFS() uint32 {
	return volatile.LoadUint32(&o.IMR0.Reg) & 0x1
}
func (o *TC_Type) SetIMR0_LOVRS(value uint32) {
	volatile.StoreUint32(&o.IMR0.Reg, volatile.LoadUint32(&o.IMR0.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetIMR0_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.IMR0.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetIMR0_CPAS(value uint32) {
	volatile.StoreUint32(&o.IMR0.Reg, volatile.LoadUint32(&o.IMR0.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetIMR0_CPAS() uint32 {
	return (volatile.LoadUint32(&o.IMR0.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetIMR0_CPBS(value uint32) {
	volatile.StoreUint32(&o.IMR0.Reg, volatile.LoadUint32(&o.IMR0.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetIMR0_CPBS() uint32 {
	return (volatile.LoadUint32(&o.IMR0.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetIMR0_CPCS(value uint32) {
	volatile.StoreUint32(&o.IMR0.Reg, volatile.LoadUint32(&o.IMR0.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetIMR0_CPCS() uint32 {
	return (volatile.LoadUint32(&o.IMR0.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetIMR0_LDRAS(value uint32) {
	volatile.StoreUint32(&o.IMR0.Reg, volatile.LoadUint32(&o.IMR0.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetIMR0_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.IMR0.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetIMR0_LDRBS(value uint32) {
	volatile.StoreUint32(&o.IMR0.Reg, volatile.LoadUint32(&o.IMR0.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetIMR0_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.IMR0.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetIMR0_ETRGS(value uint32) {
	volatile.StoreUint32(&o.IMR0.Reg, volatile.LoadUint32(&o.IMR0.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetIMR0_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.IMR0.Reg) & 0x80) >> 7
}

// TC.CCR1: Channel Control Register (channel = 1)
func (o *TC_Type) SetCCR1_CLKEN(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetCCR1_CLKEN() uint32 {
	return volatile.LoadUint32(&o.CCR1.Reg) & 0x1
}
func (o *TC_Type) SetCCR1_CLKDIS(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetCCR1_CLKDIS() uint32 {
	return (volatile.LoadUint32(&o.CCR1.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetCCR1_SWTRG(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetCCR1_SWTRG() uint32 {
	return (volatile.LoadUint32(&o.CCR1.Reg) & 0x4) >> 2
}

// TC.CMR1: Channel Mode Register (channel = 1)
func (o *TC_Type) SetCMR1_TCCLKS(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x7)|value)
}
func (o *TC_Type) GetCMR1_TCCLKS() uint32 {
	return volatile.LoadUint32(&o.CMR1.Reg) & 0x7
}
func (o *TC_Type) SetCMR1_CLKI(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetCMR1_CLKI() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetCMR1_BURST(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x30)|value<<4)
}
func (o *TC_Type) GetCMR1_BURST() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x30) >> 4
}
func (o *TC_Type) SetCMR1_LDBSTOP(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetCMR1_LDBSTOP() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetCMR1_LDBDIS(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetCMR1_LDBDIS() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x80) >> 7
}
func (o *TC_Type) SetCMR1_ETRGEDG(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x300)|value<<8)
}
func (o *TC_Type) GetCMR1_ETRGEDG() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x300) >> 8
}
func (o *TC_Type) SetCMR1_ABETRG(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x400)|value<<10)
}
func (o *TC_Type) GetCMR1_ABETRG() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x400) >> 10
}
func (o *TC_Type) SetCMR1_CPCTRG(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x4000)|value<<14)
}
func (o *TC_Type) GetCMR1_CPCTRG() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x4000) >> 14
}
func (o *TC_Type) SetCMR1_WAVE(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x8000)|value<<15)
}
func (o *TC_Type) GetCMR1_WAVE() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x8000) >> 15
}
func (o *TC_Type) SetCMR1_LDRA(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x30000)|value<<16)
}
func (o *TC_Type) GetCMR1_LDRA() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x30000) >> 16
}
func (o *TC_Type) SetCMR1_LDRB(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0xc0000)|value<<18)
}
func (o *TC_Type) GetCMR1_LDRB() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0xc0000) >> 18
}

// TC.CV1: Counter Value (channel = 1)
func (o *TC_Type) SetCV1(value uint32) {
	volatile.StoreUint32(&o.CV1.Reg, value)
}
func (o *TC_Type) GetCV1() uint32 {
	return volatile.LoadUint32(&o.CV1.Reg)
}

// TC.RA1: Register A (channel = 1)
func (o *TC_Type) SetRA1(value uint32) {
	volatile.StoreUint32(&o.RA1.Reg, value)
}
func (o *TC_Type) GetRA1() uint32 {
	return volatile.LoadUint32(&o.RA1.Reg)
}

// TC.RB1: Register B (channel = 1)
func (o *TC_Type) SetRB1(value uint32) {
	volatile.StoreUint32(&o.RB1.Reg, value)
}
func (o *TC_Type) GetRB1() uint32 {
	return volatile.LoadUint32(&o.RB1.Reg)
}

// TC.RC1: Register C (channel = 1)
func (o *TC_Type) SetRC1(value uint32) {
	volatile.StoreUint32(&o.RC1.Reg, value)
}
func (o *TC_Type) GetRC1() uint32 {
	return volatile.LoadUint32(&o.RC1.Reg)
}

// TC.SR1: Status Register (channel = 1)
func (o *TC_Type) SetSR1_COVFS(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetSR1_COVFS() uint32 {
	return volatile.LoadUint32(&o.SR1.Reg) & 0x1
}
func (o *TC_Type) SetSR1_LOVRS(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetSR1_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetSR1_CPAS(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetSR1_CPAS() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetSR1_CPBS(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetSR1_CPBS() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetSR1_CPCS(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetSR1_CPCS() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetSR1_LDRAS(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetSR1_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetSR1_LDRBS(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetSR1_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetSR1_ETRGS(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetSR1_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x80) >> 7
}
func (o *TC_Type) SetSR1_CLKSTA(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x10000)|value<<16)
}
func (o *TC_Type) GetSR1_CLKSTA() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x10000) >> 16
}
func (o *TC_Type) SetSR1_MTIOA(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x20000)|value<<17)
}
func (o *TC_Type) GetSR1_MTIOA() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x20000) >> 17
}
func (o *TC_Type) SetSR1_MTIOB(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x40000)|value<<18)
}
func (o *TC_Type) GetSR1_MTIOB() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x40000) >> 18
}

// TC.IER1: Interrupt Enable Register (channel = 1)
func (o *TC_Type) SetIER1_COVFS(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetIER1_COVFS() uint32 {
	return volatile.LoadUint32(&o.IER1.Reg) & 0x1
}
func (o *TC_Type) SetIER1_LOVRS(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetIER1_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetIER1_CPAS(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetIER1_CPAS() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetIER1_CPBS(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetIER1_CPBS() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetIER1_CPCS(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetIER1_CPCS() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetIER1_LDRAS(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetIER1_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetIER1_LDRBS(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetIER1_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetIER1_ETRGS(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetIER1_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x80) >> 7
}

// TC.IDR1: Interrupt Disable Register (channel = 1)
func (o *TC_Type) SetIDR1_COVFS(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetIDR1_COVFS() uint32 {
	return volatile.LoadUint32(&o.IDR1.Reg) & 0x1
}
func (o *TC_Type) SetIDR1_LOVRS(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetIDR1_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetIDR1_CPAS(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetIDR1_CPAS() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetIDR1_CPBS(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetIDR1_CPBS() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetIDR1_CPCS(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetIDR1_CPCS() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetIDR1_LDRAS(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetIDR1_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetIDR1_LDRBS(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetIDR1_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetIDR1_ETRGS(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetIDR1_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x80) >> 7
}

// TC.IMR1: Interrupt Mask Register (channel = 1)
func (o *TC_Type) SetIMR1_COVFS(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetIMR1_COVFS() uint32 {
	return volatile.LoadUint32(&o.IMR1.Reg) & 0x1
}
func (o *TC_Type) SetIMR1_LOVRS(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetIMR1_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetIMR1_CPAS(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetIMR1_CPAS() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetIMR1_CPBS(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetIMR1_CPBS() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetIMR1_CPCS(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetIMR1_CPCS() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetIMR1_LDRAS(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetIMR1_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetIMR1_LDRBS(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetIMR1_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetIMR1_ETRGS(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetIMR1_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x80) >> 7
}

// TC.CCR2: Channel Control Register (channel = 2)
func (o *TC_Type) SetCCR2_CLKEN(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetCCR2_CLKEN() uint32 {
	return volatile.LoadUint32(&o.CCR2.Reg) & 0x1
}
func (o *TC_Type) SetCCR2_CLKDIS(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetCCR2_CLKDIS() uint32 {
	return (volatile.LoadUint32(&o.CCR2.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetCCR2_SWTRG(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetCCR2_SWTRG() uint32 {
	return (volatile.LoadUint32(&o.CCR2.Reg) & 0x4) >> 2
}

// TC.CMR2: Channel Mode Register (channel = 2)
func (o *TC_Type) SetCMR2_TCCLKS(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x7)|value)
}
func (o *TC_Type) GetCMR2_TCCLKS() uint32 {
	return volatile.LoadUint32(&o.CMR2.Reg) & 0x7
}
func (o *TC_Type) SetCMR2_CLKI(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetCMR2_CLKI() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetCMR2_BURST(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x30)|value<<4)
}
func (o *TC_Type) GetCMR2_BURST() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x30) >> 4
}
func (o *TC_Type) SetCMR2_LDBSTOP(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetCMR2_LDBSTOP() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetCMR2_LDBDIS(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetCMR2_LDBDIS() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x80) >> 7
}
func (o *TC_Type) SetCMR2_ETRGEDG(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x300)|value<<8)
}
func (o *TC_Type) GetCMR2_ETRGEDG() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x300) >> 8
}
func (o *TC_Type) SetCMR2_ABETRG(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x400)|value<<10)
}
func (o *TC_Type) GetCMR2_ABETRG() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x400) >> 10
}
func (o *TC_Type) SetCMR2_CPCTRG(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x4000)|value<<14)
}
func (o *TC_Type) GetCMR2_CPCTRG() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x4000) >> 14
}
func (o *TC_Type) SetCMR2_WAVE(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x8000)|value<<15)
}
func (o *TC_Type) GetCMR2_WAVE() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x8000) >> 15
}
func (o *TC_Type) SetCMR2_LDRA(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x30000)|value<<16)
}
func (o *TC_Type) GetCMR2_LDRA() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x30000) >> 16
}
func (o *TC_Type) SetCMR2_LDRB(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0xc0000)|value<<18)
}
func (o *TC_Type) GetCMR2_LDRB() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0xc0000) >> 18
}

// TC.CV2: Counter Value (channel = 2)
func (o *TC_Type) SetCV2(value uint32) {
	volatile.StoreUint32(&o.CV2.Reg, value)
}
func (o *TC_Type) GetCV2() uint32 {
	return volatile.LoadUint32(&o.CV2.Reg)
}

// TC.RA2: Register A (channel = 2)
func (o *TC_Type) SetRA2(value uint32) {
	volatile.StoreUint32(&o.RA2.Reg, value)
}
func (o *TC_Type) GetRA2() uint32 {
	return volatile.LoadUint32(&o.RA2.Reg)
}

// TC.RB2: Register B (channel = 2)
func (o *TC_Type) SetRB2(value uint32) {
	volatile.StoreUint32(&o.RB2.Reg, value)
}
func (o *TC_Type) GetRB2() uint32 {
	return volatile.LoadUint32(&o.RB2.Reg)
}

// TC.RC2: Register C (channel = 2)
func (o *TC_Type) SetRC2(value uint32) {
	volatile.StoreUint32(&o.RC2.Reg, value)
}
func (o *TC_Type) GetRC2() uint32 {
	return volatile.LoadUint32(&o.RC2.Reg)
}

// TC.SR2: Status Register (channel = 2)
func (o *TC_Type) SetSR2_COVFS(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetSR2_COVFS() uint32 {
	return volatile.LoadUint32(&o.SR2.Reg) & 0x1
}
func (o *TC_Type) SetSR2_LOVRS(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetSR2_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetSR2_CPAS(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetSR2_CPAS() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetSR2_CPBS(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetSR2_CPBS() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetSR2_CPCS(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetSR2_CPCS() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetSR2_LDRAS(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetSR2_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetSR2_LDRBS(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetSR2_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetSR2_ETRGS(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetSR2_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x80) >> 7
}
func (o *TC_Type) SetSR2_CLKSTA(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x10000)|value<<16)
}
func (o *TC_Type) GetSR2_CLKSTA() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x10000) >> 16
}
func (o *TC_Type) SetSR2_MTIOA(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x20000)|value<<17)
}
func (o *TC_Type) GetSR2_MTIOA() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x20000) >> 17
}
func (o *TC_Type) SetSR2_MTIOB(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x40000)|value<<18)
}
func (o *TC_Type) GetSR2_MTIOB() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x40000) >> 18
}

// TC.IER2: Interrupt Enable Register (channel = 2)
func (o *TC_Type) SetIER2_COVFS(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetIER2_COVFS() uint32 {
	return volatile.LoadUint32(&o.IER2.Reg) & 0x1
}
func (o *TC_Type) SetIER2_LOVRS(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetIER2_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetIER2_CPAS(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetIER2_CPAS() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetIER2_CPBS(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetIER2_CPBS() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetIER2_CPCS(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetIER2_CPCS() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetIER2_LDRAS(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetIER2_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetIER2_LDRBS(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetIER2_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetIER2_ETRGS(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetIER2_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x80) >> 7
}

// TC.IDR2: Interrupt Disable Register (channel = 2)
func (o *TC_Type) SetIDR2_COVFS(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetIDR2_COVFS() uint32 {
	return volatile.LoadUint32(&o.IDR2.Reg) & 0x1
}
func (o *TC_Type) SetIDR2_LOVRS(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetIDR2_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetIDR2_CPAS(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetIDR2_CPAS() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetIDR2_CPBS(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetIDR2_CPBS() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetIDR2_CPCS(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetIDR2_CPCS() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetIDR2_LDRAS(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetIDR2_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetIDR2_LDRBS(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetIDR2_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetIDR2_ETRGS(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetIDR2_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x80) >> 7
}

// TC.IMR2: Interrupt Mask Register (channel = 2)
func (o *TC_Type) SetIMR2_COVFS(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetIMR2_COVFS() uint32 {
	return volatile.LoadUint32(&o.IMR2.Reg) & 0x1
}
func (o *TC_Type) SetIMR2_LOVRS(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetIMR2_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetIMR2_CPAS(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetIMR2_CPAS() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetIMR2_CPBS(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetIMR2_CPBS() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetIMR2_CPCS(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetIMR2_CPCS() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetIMR2_LDRAS(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetIMR2_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetIMR2_LDRBS(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetIMR2_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetIMR2_ETRGS(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetIMR2_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x80) >> 7
}

// TC.BCR: Block Control Register
func (o *TC_Type) SetBCR_SYNC(value uint32) {
	volatile.StoreUint32(&o.BCR.Reg, volatile.LoadUint32(&o.BCR.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetBCR_SYNC() uint32 {
	return volatile.LoadUint32(&o.BCR.Reg) & 0x1
}

// TC.BMR: Block Mode Register
func (o *TC_Type) SetBMR_TC0XC0S(value uint32) {
	volatile.StoreUint32(&o.BMR.Reg, volatile.LoadUint32(&o.BMR.Reg)&^(0x3)|value)
}
func (o *TC_Type) GetBMR_TC0XC0S() uint32 {
	return volatile.LoadUint32(&o.BMR.Reg) & 0x3
}
func (o *TC_Type) SetBMR_TC1XC1S(value uint32) {
	volatile.StoreUint32(&o.BMR.Reg, volatile.LoadUint32(&o.BMR.Reg)&^(0xc)|value<<2)
}
func (o *TC_Type) GetBMR_TC1XC1S() uint32 {
	return (volatile.LoadUint32(&o.BMR.Reg) & 0xc) >> 2
}
func (o *TC_Type) SetBMR_TC2XC2S(value uint32) {
	volatile.StoreUint32(&o.BMR.Reg, volatile.LoadUint32(&o.BMR.Reg)&^(0x30)|value<<4)
}
func (o *TC_Type) GetBMR_TC2XC2S() uint32 {
	return (volatile.LoadUint32(&o.BMR.Reg) & 0x30) >> 4
}

// Two-wire Interface 0
type TWI_Type struct {
	CR   volatile.Register32 // 0x0
	MMR  volatile.Register32 // 0x4
	SMR  volatile.Register32 // 0x8
	IADR volatile.Register32 // 0xC
	CWGR volatile.Register32 // 0x10
	_    [12]byte
	SR   volatile.Register32 // 0x20
	IER  volatile.Register32 // 0x24
	IDR  volatile.Register32 // 0x28
	IMR  volatile.Register32 // 0x2C
	RHR  volatile.Register32 // 0x30
	THR  volatile.Register32 // 0x34
}

// TWI.CR: Control Register
func (o *TWI_Type) SetCR_START(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *TWI_Type) GetCR_START() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *TWI_Type) SetCR_STOP(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *TWI_Type) GetCR_STOP() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *TWI_Type) SetCR_MSEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *TWI_Type) GetCR_MSEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *TWI_Type) SetCR_MSDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *TWI_Type) GetCR_MSDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *TWI_Type) SetCR_SVEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *TWI_Type) GetCR_SVEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *TWI_Type) SetCR_SVDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20)|value<<5)
}
func (o *TWI_Type) GetCR_SVDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20) >> 5
}
func (o *TWI_Type) SetCR_QUICK(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40)|value<<6)
}
func (o *TWI_Type) GetCR_QUICK() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40) >> 6
}
func (o *TWI_Type) SetCR_SWRST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *TWI_Type) GetCR_SWRST() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}

// TWI.MMR: Master Mode Register
func (o *TWI_Type) SetMMR_IADRSZ(value uint32) {
	volatile.StoreUint32(&o.MMR.Reg, volatile.LoadUint32(&o.MMR.Reg)&^(0x300)|value<<8)
}
func (o *TWI_Type) GetMMR_IADRSZ() uint32 {
	return (volatile.LoadUint32(&o.MMR.Reg) & 0x300) >> 8
}
func (o *TWI_Type) SetMMR_MREAD(value uint32) {
	volatile.StoreUint32(&o.MMR.Reg, volatile.LoadUint32(&o.MMR.Reg)&^(0x1000)|value<<12)
}
func (o *TWI_Type) GetMMR_MREAD() uint32 {
	return (volatile.LoadUint32(&o.MMR.Reg) & 0x1000) >> 12
}
func (o *TWI_Type) SetMMR_DADR(value uint32) {
	volatile.StoreUint32(&o.MMR.Reg, volatile.LoadUint32(&o.MMR.Reg)&^(0x7f0000)|value<<16)
}
func (o *TWI_Type) GetMMR_DADR() uint32 {
	return (volatile.LoadUint32(&o.MMR.Reg) & 0x7f0000) >> 16
}

// TWI.SMR: Slave Mode Register
func (o *TWI_Type) SetSMR_SADR(value uint32) {
	volatile.StoreUint32(&o.SMR.Reg, volatile.LoadUint32(&o.SMR.Reg)&^(0x7f0000)|value<<16)
}
func (o *TWI_Type) GetSMR_SADR() uint32 {
	return (volatile.LoadUint32(&o.SMR.Reg) & 0x7f0000) >> 16
}

// TWI.IADR: Internal Address Register
func (o *TWI_Type) SetIADR(value uint32) {
	volatile.StoreUint32(&o.IADR.Reg, volatile.LoadUint32(&o.IADR.Reg)&^(0xffffff)|value)
}
func (o *TWI_Type) GetIADR() uint32 {
	return volatile.LoadUint32(&o.IADR.Reg) & 0xffffff
}

// TWI.CWGR: Clock Waveform Generator Register
func (o *TWI_Type) SetCWGR_CLDIV(value uint32) {
	volatile.StoreUint32(&o.CWGR.Reg, volatile.LoadUint32(&o.CWGR.Reg)&^(0xff)|value)
}
func (o *TWI_Type) GetCWGR_CLDIV() uint32 {
	return volatile.LoadUint32(&o.CWGR.Reg) & 0xff
}
func (o *TWI_Type) SetCWGR_CHDIV(value uint32) {
	volatile.StoreUint32(&o.CWGR.Reg, volatile.LoadUint32(&o.CWGR.Reg)&^(0xff00)|value<<8)
}
func (o *TWI_Type) GetCWGR_CHDIV() uint32 {
	return (volatile.LoadUint32(&o.CWGR.Reg) & 0xff00) >> 8
}
func (o *TWI_Type) SetCWGR_CKDIV(value uint32) {
	volatile.StoreUint32(&o.CWGR.Reg, volatile.LoadUint32(&o.CWGR.Reg)&^(0x70000)|value<<16)
}
func (o *TWI_Type) GetCWGR_CKDIV() uint32 {
	return (volatile.LoadUint32(&o.CWGR.Reg) & 0x70000) >> 16
}

// TWI.SR: Status Register
func (o *TWI_Type) SetSR_TXCOMP(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *TWI_Type) GetSR_TXCOMP() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *TWI_Type) SetSR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *TWI_Type) GetSR_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *TWI_Type) SetSR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *TWI_Type) GetSR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *TWI_Type) SetSR_SVREAD(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *TWI_Type) GetSR_SVREAD() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *TWI_Type) SetSR_SVACC(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *TWI_Type) GetSR_SVACC() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *TWI_Type) SetSR_GACC(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *TWI_Type) GetSR_GACC() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *TWI_Type) SetSR_OVRE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *TWI_Type) GetSR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *TWI_Type) SetSR_NACK(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100)|value<<8)
}
func (o *TWI_Type) GetSR_NACK() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100) >> 8
}
func (o *TWI_Type) SetSR_ARBLST(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x200)|value<<9)
}
func (o *TWI_Type) GetSR_ARBLST() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x200) >> 9
}
func (o *TWI_Type) SetSR_SCLWS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x400)|value<<10)
}
func (o *TWI_Type) GetSR_SCLWS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x400) >> 10
}
func (o *TWI_Type) SetSR_EOSACC(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x800)|value<<11)
}
func (o *TWI_Type) GetSR_EOSACC() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x800) >> 11
}

// TWI.IER: Interrupt Enable Register
func (o *TWI_Type) SetIER_TXCOMP(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *TWI_Type) GetIER_TXCOMP() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *TWI_Type) SetIER_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *TWI_Type) GetIER_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *TWI_Type) SetIER_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *TWI_Type) GetIER_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *TWI_Type) SetIER_SVACC(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *TWI_Type) GetIER_SVACC() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *TWI_Type) SetIER_GACC(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *TWI_Type) GetIER_GACC() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *TWI_Type) SetIER_OVRE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40)|value<<6)
}
func (o *TWI_Type) GetIER_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40) >> 6
}
func (o *TWI_Type) SetIER_NACK(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100)|value<<8)
}
func (o *TWI_Type) GetIER_NACK() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100) >> 8
}
func (o *TWI_Type) SetIER_ARBLST(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200)|value<<9)
}
func (o *TWI_Type) GetIER_ARBLST() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200) >> 9
}
func (o *TWI_Type) SetIER_SCL_WS(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400)|value<<10)
}
func (o *TWI_Type) GetIER_SCL_WS() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400) >> 10
}
func (o *TWI_Type) SetIER_EOSACC(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x800)|value<<11)
}
func (o *TWI_Type) GetIER_EOSACC() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x800) >> 11
}

// TWI.IDR: Interrupt Disable Register
func (o *TWI_Type) SetIDR_TXCOMP(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *TWI_Type) GetIDR_TXCOMP() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *TWI_Type) SetIDR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *TWI_Type) GetIDR_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *TWI_Type) SetIDR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4)|value<<2)
}
func (o *TWI_Type) GetIDR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4) >> 2
}
func (o *TWI_Type) SetIDR_SVACC(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10)|value<<4)
}
func (o *TWI_Type) GetIDR_SVACC() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10) >> 4
}
func (o *TWI_Type) SetIDR_GACC(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20)|value<<5)
}
func (o *TWI_Type) GetIDR_GACC() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20) >> 5
}
func (o *TWI_Type) SetIDR_OVRE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40)|value<<6)
}
func (o *TWI_Type) GetIDR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40) >> 6
}
func (o *TWI_Type) SetIDR_NACK(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100)|value<<8)
}
func (o *TWI_Type) GetIDR_NACK() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100) >> 8
}
func (o *TWI_Type) SetIDR_ARBLST(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200)|value<<9)
}
func (o *TWI_Type) GetIDR_ARBLST() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200) >> 9
}
func (o *TWI_Type) SetIDR_SCL_WS(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400)|value<<10)
}
func (o *TWI_Type) GetIDR_SCL_WS() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400) >> 10
}
func (o *TWI_Type) SetIDR_EOSACC(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x800)|value<<11)
}
func (o *TWI_Type) GetIDR_EOSACC() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x800) >> 11
}

// TWI.IMR: Interrupt Mask Register
func (o *TWI_Type) SetIMR_TXCOMP(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *TWI_Type) GetIMR_TXCOMP() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *TWI_Type) SetIMR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *TWI_Type) GetIMR_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *TWI_Type) SetIMR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4)|value<<2)
}
func (o *TWI_Type) GetIMR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4) >> 2
}
func (o *TWI_Type) SetIMR_SVACC(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10)|value<<4)
}
func (o *TWI_Type) GetIMR_SVACC() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10) >> 4
}
func (o *TWI_Type) SetIMR_GACC(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20)|value<<5)
}
func (o *TWI_Type) GetIMR_GACC() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20) >> 5
}
func (o *TWI_Type) SetIMR_OVRE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40)|value<<6)
}
func (o *TWI_Type) GetIMR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40) >> 6
}
func (o *TWI_Type) SetIMR_NACK(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100)|value<<8)
}
func (o *TWI_Type) GetIMR_NACK() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100) >> 8
}
func (o *TWI_Type) SetIMR_ARBLST(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200)|value<<9)
}
func (o *TWI_Type) GetIMR_ARBLST() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200) >> 9
}
func (o *TWI_Type) SetIMR_SCL_WS(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400)|value<<10)
}
func (o *TWI_Type) GetIMR_SCL_WS() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400) >> 10
}
func (o *TWI_Type) SetIMR_EOSACC(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x800)|value<<11)
}
func (o *TWI_Type) GetIMR_EOSACC() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x800) >> 11
}

// TWI.RHR: Receive Holding Register
func (o *TWI_Type) SetRHR_RXDATA(value uint32) {
	volatile.StoreUint32(&o.RHR.Reg, volatile.LoadUint32(&o.RHR.Reg)&^(0xff)|value)
}
func (o *TWI_Type) GetRHR_RXDATA() uint32 {
	return volatile.LoadUint32(&o.RHR.Reg) & 0xff
}

// TWI.THR: Transmit Holding Register
func (o *TWI_Type) SetTHR_TXDATA(value uint32) {
	volatile.StoreUint32(&o.THR.Reg, volatile.LoadUint32(&o.THR.Reg)&^(0xff)|value)
}
func (o *TWI_Type) GetTHR_TXDATA() uint32 {
	return volatile.LoadUint32(&o.THR.Reg) & 0xff
}

// Universal Synchronous Asynchronous Receiver Transmitter 0
type USART_Type struct {
	CR    volatile.Register32 // 0x0
	MR    volatile.Register32 // 0x4
	IER   volatile.Register32 // 0x8
	IDR   volatile.Register32 // 0xC
	IMR   volatile.Register32 // 0x10
	CSR   volatile.Register32 // 0x14
	RHR   volatile.Register32 // 0x18
	THR   volatile.Register32 // 0x1C
	BRGR  volatile.Register32 // 0x20
	RTOR  volatile.Register32 // 0x24
	TTGR  volatile.Register32 // 0x28
	_     [20]byte
	FIDI  volatile.Register32 // 0x40
	NER   volatile.Register32 // 0x44
	_     [4]byte
	IF    volatile.Register32 // 0x4C
	MAN   volatile.Register32 // 0x50
	LINMR volatile.Register32 // 0x54
	LINIR volatile.Register32 // 0x58
	_     [136]byte
	WPMR  volatile.Register32 // 0xE4
	WPSR  volatile.Register32 // 0xE8
}

// USART.CR: Control Register
func (o *USART_Type) SetCR_RSTRX(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetCR_RSTRX() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetCR_RSTTX(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetCR_RSTTX() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetCR_RXEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetCR_RXEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetCR_RXDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetCR_RXDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetCR_TXEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetCR_TXEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetCR_TXDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetCR_TXDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetCR_RSTSTA(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetCR_RSTSTA() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetCR_STTBRK(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetCR_STTBRK() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetCR_STPBRK(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x400)|value<<10)
}
func (o *USART_Type) GetCR_STPBRK() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x400) >> 10
}
func (o *USART_Type) SetCR_STTTO(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x800)|value<<11)
}
func (o *USART_Type) GetCR_STTTO() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x800) >> 11
}
func (o *USART_Type) SetCR_SENDA(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000)|value<<12)
}
func (o *USART_Type) GetCR_SENDA() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000) >> 12
}
func (o *USART_Type) SetCR_RSTIT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2000)|value<<13)
}
func (o *USART_Type) GetCR_RSTIT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2000) >> 13
}
func (o *USART_Type) SetCR_RSTNACK(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4000)|value<<14)
}
func (o *USART_Type) GetCR_RSTNACK() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4000) >> 14
}
func (o *USART_Type) SetCR_RETTO(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8000)|value<<15)
}
func (o *USART_Type) GetCR_RETTO() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8000) >> 15
}
func (o *USART_Type) SetCR_RTSEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40000)|value<<18)
}
func (o *USART_Type) GetCR_RTSEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40000) >> 18
}
func (o *USART_Type) SetCR_RTSDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80000)|value<<19)
}
func (o *USART_Type) GetCR_RTSDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80000) >> 19
}
func (o *USART_Type) SetCR_LINABT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100000)|value<<20)
}
func (o *USART_Type) GetCR_LINABT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100000) >> 20
}
func (o *USART_Type) SetCR_LINWKUP(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x200000)|value<<21)
}
func (o *USART_Type) GetCR_LINWKUP() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x200000) >> 21
}

// USART.MR: Mode Register
func (o *USART_Type) SetMR_USART_MODE(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xf)|value)
}
func (o *USART_Type) GetMR_USART_MODE() uint32 {
	return volatile.LoadUint32(&o.MR.Reg) & 0xf
}
func (o *USART_Type) SetMR_USCLKS(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x30)|value<<4)
}
func (o *USART_Type) GetMR_USCLKS() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x30) >> 4
}
func (o *USART_Type) SetMR_CHRL(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xc0)|value<<6)
}
func (o *USART_Type) GetMR_CHRL() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xc0) >> 6
}
func (o *USART_Type) SetMR_SYNC(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetMR_SYNC() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetMR_PAR(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xe00)|value<<9)
}
func (o *USART_Type) GetMR_PAR() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xe00) >> 9
}
func (o *USART_Type) SetMR_NBSTOP(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x3000)|value<<12)
}
func (o *USART_Type) GetMR_NBSTOP() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x3000) >> 12
}
func (o *USART_Type) SetMR_CHMODE(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xc000)|value<<14)
}
func (o *USART_Type) GetMR_CHMODE() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xc000) >> 14
}
func (o *USART_Type) SetMR_MSBF(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x10000)|value<<16)
}
func (o *USART_Type) GetMR_MSBF() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x10000) >> 16
}
func (o *USART_Type) SetMR_MODE9(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x20000)|value<<17)
}
func (o *USART_Type) GetMR_MODE9() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x20000) >> 17
}
func (o *USART_Type) SetMR_CLKO(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x40000)|value<<18)
}
func (o *USART_Type) GetMR_CLKO() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x40000) >> 18
}
func (o *USART_Type) SetMR_OVER(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x80000)|value<<19)
}
func (o *USART_Type) GetMR_OVER() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x80000) >> 19
}
func (o *USART_Type) SetMR_INACK(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x100000)|value<<20)
}
func (o *USART_Type) GetMR_INACK() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x100000) >> 20
}
func (o *USART_Type) SetMR_DSNACK(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x200000)|value<<21)
}
func (o *USART_Type) GetMR_DSNACK() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x200000) >> 21
}
func (o *USART_Type) SetMR_VAR_SYNC(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x400000)|value<<22)
}
func (o *USART_Type) GetMR_VAR_SYNC() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x400000) >> 22
}
func (o *USART_Type) SetMR_MAX_ITERATION(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x7000000)|value<<24)
}
func (o *USART_Type) GetMR_MAX_ITERATION() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x7000000) >> 24
}
func (o *USART_Type) SetMR_FILTER(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x10000000)|value<<28)
}
func (o *USART_Type) GetMR_FILTER() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x10000000) >> 28
}
func (o *USART_Type) SetMR_MAN(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x20000000)|value<<29)
}
func (o *USART_Type) GetMR_MAN() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x20000000) >> 29
}
func (o *USART_Type) SetMR_MODSYNC(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x40000000)|value<<30)
}
func (o *USART_Type) GetMR_MODSYNC() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x40000000) >> 30
}
func (o *USART_Type) SetMR_ONEBIT(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x80000000)|value<<31)
}
func (o *USART_Type) GetMR_ONEBIT() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x80000000) >> 31
}

// USART.IER: Interrupt Enable Register
func (o *USART_Type) SetIER_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetIER_RXRDY() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *USART_Type) SetIER_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetIER_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetIER_RXBRK(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetIER_RXBRK() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetIER_OVRE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetIER_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetIER_FRAME(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetIER_FRAME() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetIER_PARE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetIER_PARE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetIER_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetIER_TIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetIER_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetIER_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetIER_ITER(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400)|value<<10)
}
func (o *USART_Type) GetIER_ITER() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400) >> 10
}
func (o *USART_Type) SetIER_NACK(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2000)|value<<13)
}
func (o *USART_Type) GetIER_NACK() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2000) >> 13
}
func (o *USART_Type) SetIER_CTSIC(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80000)|value<<19)
}
func (o *USART_Type) GetIER_CTSIC() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80000) >> 19
}
func (o *USART_Type) SetIER_MANE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1000000)|value<<24)
}
func (o *USART_Type) GetIER_MANE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x1000000) >> 24
}

// USART.IDR: Interrupt Disable Register
func (o *USART_Type) SetIDR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetIDR_RXRDY() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *USART_Type) SetIDR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetIDR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetIDR_RXBRK(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetIDR_RXBRK() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetIDR_OVRE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetIDR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetIDR_FRAME(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetIDR_FRAME() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetIDR_PARE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetIDR_PARE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetIDR_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetIDR_TIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetIDR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetIDR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetIDR_ITER(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400)|value<<10)
}
func (o *USART_Type) GetIDR_ITER() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400) >> 10
}
func (o *USART_Type) SetIDR_NACK(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2000)|value<<13)
}
func (o *USART_Type) GetIDR_NACK() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2000) >> 13
}
func (o *USART_Type) SetIDR_CTSIC(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80000)|value<<19)
}
func (o *USART_Type) GetIDR_CTSIC() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80000) >> 19
}
func (o *USART_Type) SetIDR_MANE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1000000)|value<<24)
}
func (o *USART_Type) GetIDR_MANE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x1000000) >> 24
}

// USART.IMR: Interrupt Mask Register
func (o *USART_Type) SetIMR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetIMR_RXRDY() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *USART_Type) SetIMR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetIMR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetIMR_RXBRK(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetIMR_RXBRK() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetIMR_OVRE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetIMR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetIMR_FRAME(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetIMR_FRAME() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetIMR_PARE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetIMR_PARE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetIMR_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetIMR_TIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetIMR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetIMR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetIMR_ITER(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400)|value<<10)
}
func (o *USART_Type) GetIMR_ITER() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400) >> 10
}
func (o *USART_Type) SetIMR_NACK(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2000)|value<<13)
}
func (o *USART_Type) GetIMR_NACK() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2000) >> 13
}
func (o *USART_Type) SetIMR_CTSIC(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80000)|value<<19)
}
func (o *USART_Type) GetIMR_CTSIC() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80000) >> 19
}
func (o *USART_Type) SetIMR_MANE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1000000)|value<<24)
}
func (o *USART_Type) GetIMR_MANE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x1000000) >> 24
}

// USART.CSR: Channel Status Register
func (o *USART_Type) SetCSR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetCSR_RXRDY() uint32 {
	return volatile.LoadUint32(&o.CSR.Reg) & 0x1
}
func (o *USART_Type) SetCSR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetCSR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetCSR_RXBRK(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetCSR_RXBRK() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetCSR_OVRE(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetCSR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetCSR_FRAME(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetCSR_FRAME() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetCSR_PARE(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetCSR_PARE() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetCSR_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetCSR_TIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetCSR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetCSR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetCSR_ITER(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x400)|value<<10)
}
func (o *USART_Type) GetCSR_ITER() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x400) >> 10
}
func (o *USART_Type) SetCSR_NACK(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x2000)|value<<13)
}
func (o *USART_Type) GetCSR_NACK() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x2000) >> 13
}
func (o *USART_Type) SetCSR_CTSIC(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x80000)|value<<19)
}
func (o *USART_Type) GetCSR_CTSIC() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x80000) >> 19
}
func (o *USART_Type) SetCSR_CTS(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x800000)|value<<23)
}
func (o *USART_Type) GetCSR_CTS() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x800000) >> 23
}
func (o *USART_Type) SetCSR_MANERR(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x1000000)|value<<24)
}
func (o *USART_Type) GetCSR_MANERR() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x1000000) >> 24
}

// USART.RHR: Receiver Holding Register
func (o *USART_Type) SetRHR_RXCHR(value uint32) {
	volatile.StoreUint32(&o.RHR.Reg, volatile.LoadUint32(&o.RHR.Reg)&^(0x1ff)|value)
}
func (o *USART_Type) GetRHR_RXCHR() uint32 {
	return volatile.LoadUint32(&o.RHR.Reg) & 0x1ff
}
func (o *USART_Type) SetRHR_RXSYNH(value uint32) {
	volatile.StoreUint32(&o.RHR.Reg, volatile.LoadUint32(&o.RHR.Reg)&^(0x8000)|value<<15)
}
func (o *USART_Type) GetRHR_RXSYNH() uint32 {
	return (volatile.LoadUint32(&o.RHR.Reg) & 0x8000) >> 15
}

// USART.THR: Transmitter Holding Register
func (o *USART_Type) SetTHR_TXCHR(value uint32) {
	volatile.StoreUint32(&o.THR.Reg, volatile.LoadUint32(&o.THR.Reg)&^(0x1ff)|value)
}
func (o *USART_Type) GetTHR_TXCHR() uint32 {
	return volatile.LoadUint32(&o.THR.Reg) & 0x1ff
}
func (o *USART_Type) SetTHR_TXSYNH(value uint32) {
	volatile.StoreUint32(&o.THR.Reg, volatile.LoadUint32(&o.THR.Reg)&^(0x8000)|value<<15)
}
func (o *USART_Type) GetTHR_TXSYNH() uint32 {
	return (volatile.LoadUint32(&o.THR.Reg) & 0x8000) >> 15
}

// USART.BRGR: Baud Rate Generator Register
func (o *USART_Type) SetBRGR_CD(value uint32) {
	volatile.StoreUint32(&o.BRGR.Reg, volatile.LoadUint32(&o.BRGR.Reg)&^(0xffff)|value)
}
func (o *USART_Type) GetBRGR_CD() uint32 {
	return volatile.LoadUint32(&o.BRGR.Reg) & 0xffff
}
func (o *USART_Type) SetBRGR_FP(value uint32) {
	volatile.StoreUint32(&o.BRGR.Reg, volatile.LoadUint32(&o.BRGR.Reg)&^(0x70000)|value<<16)
}
func (o *USART_Type) GetBRGR_FP() uint32 {
	return (volatile.LoadUint32(&o.BRGR.Reg) & 0x70000) >> 16
}

// USART.RTOR: Receiver Time-out Register
func (o *USART_Type) SetRTOR_TO(value uint32) {
	volatile.StoreUint32(&o.RTOR.Reg, volatile.LoadUint32(&o.RTOR.Reg)&^(0x1ffff)|value)
}
func (o *USART_Type) GetRTOR_TO() uint32 {
	return volatile.LoadUint32(&o.RTOR.Reg) & 0x1ffff
}

// USART.TTGR: Transmitter Timeguard Register
func (o *USART_Type) SetTTGR_TG(value uint32) {
	volatile.StoreUint32(&o.TTGR.Reg, volatile.LoadUint32(&o.TTGR.Reg)&^(0xff)|value)
}
func (o *USART_Type) GetTTGR_TG() uint32 {
	return volatile.LoadUint32(&o.TTGR.Reg) & 0xff
}

// USART.FIDI: FI DI Ratio Register
func (o *USART_Type) SetFIDI_FI_DI_RATIO(value uint32) {
	volatile.StoreUint32(&o.FIDI.Reg, volatile.LoadUint32(&o.FIDI.Reg)&^(0x7ff)|value)
}
func (o *USART_Type) GetFIDI_FI_DI_RATIO() uint32 {
	return volatile.LoadUint32(&o.FIDI.Reg) & 0x7ff
}

// USART.NER: Number of Errors Register
func (o *USART_Type) SetNER_NB_ERRORS(value uint32) {
	volatile.StoreUint32(&o.NER.Reg, volatile.LoadUint32(&o.NER.Reg)&^(0xff)|value)
}
func (o *USART_Type) GetNER_NB_ERRORS() uint32 {
	return volatile.LoadUint32(&o.NER.Reg) & 0xff
}

// USART.IF: IrDA Filter Register
func (o *USART_Type) SetIF_IRDA_FILTER(value uint32) {
	volatile.StoreUint32(&o.IF.Reg, volatile.LoadUint32(&o.IF.Reg)&^(0xff)|value)
}
func (o *USART_Type) GetIF_IRDA_FILTER() uint32 {
	return volatile.LoadUint32(&o.IF.Reg) & 0xff
}

// USART.MAN: Manchester Encoder Decoder Register
func (o *USART_Type) SetMAN_TX_PL(value uint32) {
	volatile.StoreUint32(&o.MAN.Reg, volatile.LoadUint32(&o.MAN.Reg)&^(0xf)|value)
}
func (o *USART_Type) GetMAN_TX_PL() uint32 {
	return volatile.LoadUint32(&o.MAN.Reg) & 0xf
}
func (o *USART_Type) SetMAN_TX_PP(value uint32) {
	volatile.StoreUint32(&o.MAN.Reg, volatile.LoadUint32(&o.MAN.Reg)&^(0x300)|value<<8)
}
func (o *USART_Type) GetMAN_TX_PP() uint32 {
	return (volatile.LoadUint32(&o.MAN.Reg) & 0x300) >> 8
}
func (o *USART_Type) SetMAN_TX_MPOL(value uint32) {
	volatile.StoreUint32(&o.MAN.Reg, volatile.LoadUint32(&o.MAN.Reg)&^(0x1000)|value<<12)
}
func (o *USART_Type) GetMAN_TX_MPOL() uint32 {
	return (volatile.LoadUint32(&o.MAN.Reg) & 0x1000) >> 12
}
func (o *USART_Type) SetMAN_RX_PL(value uint32) {
	volatile.StoreUint32(&o.MAN.Reg, volatile.LoadUint32(&o.MAN.Reg)&^(0xf0000)|value<<16)
}
func (o *USART_Type) GetMAN_RX_PL() uint32 {
	return (volatile.LoadUint32(&o.MAN.Reg) & 0xf0000) >> 16
}
func (o *USART_Type) SetMAN_RX_PP(value uint32) {
	volatile.StoreUint32(&o.MAN.Reg, volatile.LoadUint32(&o.MAN.Reg)&^(0x3000000)|value<<24)
}
func (o *USART_Type) GetMAN_RX_PP() uint32 {
	return (volatile.LoadUint32(&o.MAN.Reg) & 0x3000000) >> 24
}
func (o *USART_Type) SetMAN_RX_MPOL(value uint32) {
	volatile.StoreUint32(&o.MAN.Reg, volatile.LoadUint32(&o.MAN.Reg)&^(0x10000000)|value<<28)
}
func (o *USART_Type) GetMAN_RX_MPOL() uint32 {
	return (volatile.LoadUint32(&o.MAN.Reg) & 0x10000000) >> 28
}
func (o *USART_Type) SetMAN_ONE(value uint32) {
	volatile.StoreUint32(&o.MAN.Reg, volatile.LoadUint32(&o.MAN.Reg)&^(0x20000000)|value<<29)
}
func (o *USART_Type) GetMAN_ONE() uint32 {
	return (volatile.LoadUint32(&o.MAN.Reg) & 0x20000000) >> 29
}
func (o *USART_Type) SetMAN_DRIFT(value uint32) {
	volatile.StoreUint32(&o.MAN.Reg, volatile.LoadUint32(&o.MAN.Reg)&^(0x40000000)|value<<30)
}
func (o *USART_Type) GetMAN_DRIFT() uint32 {
	return (volatile.LoadUint32(&o.MAN.Reg) & 0x40000000) >> 30
}

// USART.LINMR: LIN Mode Register
func (o *USART_Type) SetLINMR_NACT(value uint32) {
	volatile.StoreUint32(&o.LINMR.Reg, volatile.LoadUint32(&o.LINMR.Reg)&^(0x3)|value)
}
func (o *USART_Type) GetLINMR_NACT() uint32 {
	return volatile.LoadUint32(&o.LINMR.Reg) & 0x3
}
func (o *USART_Type) SetLINMR_PARDIS(value uint32) {
	volatile.StoreUint32(&o.LINMR.Reg, volatile.LoadUint32(&o.LINMR.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetLINMR_PARDIS() uint32 {
	return (volatile.LoadUint32(&o.LINMR.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetLINMR_CHKDIS(value uint32) {
	volatile.StoreUint32(&o.LINMR.Reg, volatile.LoadUint32(&o.LINMR.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetLINMR_CHKDIS() uint32 {
	return (volatile.LoadUint32(&o.LINMR.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetLINMR_CHKTYP(value uint32) {
	volatile.StoreUint32(&o.LINMR.Reg, volatile.LoadUint32(&o.LINMR.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetLINMR_CHKTYP() uint32 {
	return (volatile.LoadUint32(&o.LINMR.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetLINMR_DLM(value uint32) {
	volatile.StoreUint32(&o.LINMR.Reg, volatile.LoadUint32(&o.LINMR.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetLINMR_DLM() uint32 {
	return (volatile.LoadUint32(&o.LINMR.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetLINMR_FSDIS(value uint32) {
	volatile.StoreUint32(&o.LINMR.Reg, volatile.LoadUint32(&o.LINMR.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetLINMR_FSDIS() uint32 {
	return (volatile.LoadUint32(&o.LINMR.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetLINMR_WKUPTYP(value uint32) {
	volatile.StoreUint32(&o.LINMR.Reg, volatile.LoadUint32(&o.LINMR.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetLINMR_WKUPTYP() uint32 {
	return (volatile.LoadUint32(&o.LINMR.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetLINMR_DLC(value uint32) {
	volatile.StoreUint32(&o.LINMR.Reg, volatile.LoadUint32(&o.LINMR.Reg)&^(0xff00)|value<<8)
}
func (o *USART_Type) GetLINMR_DLC() uint32 {
	return (volatile.LoadUint32(&o.LINMR.Reg) & 0xff00) >> 8
}
func (o *USART_Type) SetLINMR_PDCM(value uint32) {
	volatile.StoreUint32(&o.LINMR.Reg, volatile.LoadUint32(&o.LINMR.Reg)&^(0x10000)|value<<16)
}
func (o *USART_Type) GetLINMR_PDCM() uint32 {
	return (volatile.LoadUint32(&o.LINMR.Reg) & 0x10000) >> 16
}

// USART.LINIR: LIN Identifier Register
func (o *USART_Type) SetLINIR_IDCHR(value uint32) {
	volatile.StoreUint32(&o.LINIR.Reg, volatile.LoadUint32(&o.LINIR.Reg)&^(0xff)|value)
}
func (o *USART_Type) GetLINIR_IDCHR() uint32 {
	return volatile.LoadUint32(&o.LINIR.Reg) & 0xff
}

// USART.WPMR: Write Protect Mode Register
func (o *USART_Type) SetWPMR_WPEN(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetWPMR_WPEN() uint32 {
	return volatile.LoadUint32(&o.WPMR.Reg) & 0x1
}
func (o *USART_Type) SetWPMR_WPKEY(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *USART_Type) GetWPMR_WPKEY() uint32 {
	return (volatile.LoadUint32(&o.WPMR.Reg) & 0xffffff00) >> 8
}

// USART.WPSR: Write Protect Status Register
func (o *USART_Type) SetWPSR_WPVS(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetWPSR_WPVS() uint32 {
	return volatile.LoadUint32(&o.WPSR.Reg) & 0x1
}
func (o *USART_Type) SetWPSR_WPVSRC(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0xffff00)|value<<8)
}
func (o *USART_Type) GetWPSR_WPVSRC() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0xffff00) >> 8
}

// Ethernet MAC 10/100
type EMAC_Type struct {
	NCR   volatile.Register32 // 0x0
	NCFGR volatile.Register32 // 0x4
	NSR   volatile.Register32 // 0x8
	_     [8]byte
	TSR   volatile.Register32 // 0x14
	RBQP  volatile.Register32 // 0x18
	TBQP  volatile.Register32 // 0x1C
	RSR   volatile.Register32 // 0x20
	ISR   volatile.Register32 // 0x24
	IER   volatile.Register32 // 0x28
	IDR   volatile.Register32 // 0x2C
	IMR   volatile.Register32 // 0x30
	MAN   volatile.Register32 // 0x34
	PTR   volatile.Register32 // 0x38
	PFR   volatile.Register32 // 0x3C
	FTO   volatile.Register32 // 0x40
	SCF   volatile.Register32 // 0x44
	MCF   volatile.Register32 // 0x48
	FRO   volatile.Register32 // 0x4C
	FCSE  volatile.Register32 // 0x50
	ALE   volatile.Register32 // 0x54
	DTF   volatile.Register32 // 0x58
	LCOL  volatile.Register32 // 0x5C
	ECOL  volatile.Register32 // 0x60
	TUND  volatile.Register32 // 0x64
	CSE   volatile.Register32 // 0x68
	RRE   volatile.Register32 // 0x6C
	ROV   volatile.Register32 // 0x70
	RSE   volatile.Register32 // 0x74
	ELE   volatile.Register32 // 0x78
	RJA   volatile.Register32 // 0x7C
	USF   volatile.Register32 // 0x80
	STE   volatile.Register32 // 0x84
	RLE   volatile.Register32 // 0x88
	_     [4]byte
	HRB   volatile.Register32 // 0x90
	HRT   volatile.Register32 // 0x94
	SA1B  volatile.Register32 // 0x98
	SA1T  volatile.Register32 // 0x9C
	SA2B  volatile.Register32 // 0xA0
	SA2T  volatile.Register32 // 0xA4
	SA3B  volatile.Register32 // 0xA8
	SA3T  volatile.Register32 // 0xAC
	SA4B  volatile.Register32 // 0xB0
	SA4T  volatile.Register32 // 0xB4
	TID   volatile.Register32 // 0xB8
	_     [4]byte
	USRIO volatile.Register32 // 0xC0
}

// EMAC.NCR: Network Control Register
func (o *EMAC_Type) SetNCR_LB(value uint32) {
	volatile.StoreUint32(&o.NCR.Reg, volatile.LoadUint32(&o.NCR.Reg)&^(0x1)|value)
}
func (o *EMAC_Type) GetNCR_LB() uint32 {
	return volatile.LoadUint32(&o.NCR.Reg) & 0x1
}
func (o *EMAC_Type) SetNCR_LLB(value uint32) {
	volatile.StoreUint32(&o.NCR.Reg, volatile.LoadUint32(&o.NCR.Reg)&^(0x2)|value<<1)
}
func (o *EMAC_Type) GetNCR_LLB() uint32 {
	return (volatile.LoadUint32(&o.NCR.Reg) & 0x2) >> 1
}
func (o *EMAC_Type) SetNCR_RE(value uint32) {
	volatile.StoreUint32(&o.NCR.Reg, volatile.LoadUint32(&o.NCR.Reg)&^(0x4)|value<<2)
}
func (o *EMAC_Type) GetNCR_RE() uint32 {
	return (volatile.LoadUint32(&o.NCR.Reg) & 0x4) >> 2
}
func (o *EMAC_Type) SetNCR_TE(value uint32) {
	volatile.StoreUint32(&o.NCR.Reg, volatile.LoadUint32(&o.NCR.Reg)&^(0x8)|value<<3)
}
func (o *EMAC_Type) GetNCR_TE() uint32 {
	return (volatile.LoadUint32(&o.NCR.Reg) & 0x8) >> 3
}
func (o *EMAC_Type) SetNCR_MPE(value uint32) {
	volatile.StoreUint32(&o.NCR.Reg, volatile.LoadUint32(&o.NCR.Reg)&^(0x10)|value<<4)
}
func (o *EMAC_Type) GetNCR_MPE() uint32 {
	return (volatile.LoadUint32(&o.NCR.Reg) & 0x10) >> 4
}
func (o *EMAC_Type) SetNCR_CLRSTAT(value uint32) {
	volatile.StoreUint32(&o.NCR.Reg, volatile.LoadUint32(&o.NCR.Reg)&^(0x20)|value<<5)
}
func (o *EMAC_Type) GetNCR_CLRSTAT() uint32 {
	return (volatile.LoadUint32(&o.NCR.Reg) & 0x20) >> 5
}
func (o *EMAC_Type) SetNCR_INCSTAT(value uint32) {
	volatile.StoreUint32(&o.NCR.Reg, volatile.LoadUint32(&o.NCR.Reg)&^(0x40)|value<<6)
}
func (o *EMAC_Type) GetNCR_INCSTAT() uint32 {
	return (volatile.LoadUint32(&o.NCR.Reg) & 0x40) >> 6
}
func (o *EMAC_Type) SetNCR_WESTAT(value uint32) {
	volatile.StoreUint32(&o.NCR.Reg, volatile.LoadUint32(&o.NCR.Reg)&^(0x80)|value<<7)
}
func (o *EMAC_Type) GetNCR_WESTAT() uint32 {
	return (volatile.LoadUint32(&o.NCR.Reg) & 0x80) >> 7
}
func (o *EMAC_Type) SetNCR_BP(value uint32) {
	volatile.StoreUint32(&o.NCR.Reg, volatile.LoadUint32(&o.NCR.Reg)&^(0x100)|value<<8)
}
func (o *EMAC_Type) GetNCR_BP() uint32 {
	return (volatile.LoadUint32(&o.NCR.Reg) & 0x100) >> 8
}
func (o *EMAC_Type) SetNCR_TSTART(value uint32) {
	volatile.StoreUint32(&o.NCR.Reg, volatile.LoadUint32(&o.NCR.Reg)&^(0x200)|value<<9)
}
func (o *EMAC_Type) GetNCR_TSTART() uint32 {
	return (volatile.LoadUint32(&o.NCR.Reg) & 0x200) >> 9
}
func (o *EMAC_Type) SetNCR_THALT(value uint32) {
	volatile.StoreUint32(&o.NCR.Reg, volatile.LoadUint32(&o.NCR.Reg)&^(0x400)|value<<10)
}
func (o *EMAC_Type) GetNCR_THALT() uint32 {
	return (volatile.LoadUint32(&o.NCR.Reg) & 0x400) >> 10
}

// EMAC.NCFGR: Network Configuration Register
func (o *EMAC_Type) SetNCFGR_SPD(value uint32) {
	volatile.StoreUint32(&o.NCFGR.Reg, volatile.LoadUint32(&o.NCFGR.Reg)&^(0x1)|value)
}
func (o *EMAC_Type) GetNCFGR_SPD() uint32 {
	return volatile.LoadUint32(&o.NCFGR.Reg) & 0x1
}
func (o *EMAC_Type) SetNCFGR_FD(value uint32) {
	volatile.StoreUint32(&o.NCFGR.Reg, volatile.LoadUint32(&o.NCFGR.Reg)&^(0x2)|value<<1)
}
func (o *EMAC_Type) GetNCFGR_FD() uint32 {
	return (volatile.LoadUint32(&o.NCFGR.Reg) & 0x2) >> 1
}
func (o *EMAC_Type) SetNCFGR_JFRAME(value uint32) {
	volatile.StoreUint32(&o.NCFGR.Reg, volatile.LoadUint32(&o.NCFGR.Reg)&^(0x8)|value<<3)
}
func (o *EMAC_Type) GetNCFGR_JFRAME() uint32 {
	return (volatile.LoadUint32(&o.NCFGR.Reg) & 0x8) >> 3
}
func (o *EMAC_Type) SetNCFGR_CAF(value uint32) {
	volatile.StoreUint32(&o.NCFGR.Reg, volatile.LoadUint32(&o.NCFGR.Reg)&^(0x10)|value<<4)
}
func (o *EMAC_Type) GetNCFGR_CAF() uint32 {
	return (volatile.LoadUint32(&o.NCFGR.Reg) & 0x10) >> 4
}
func (o *EMAC_Type) SetNCFGR_NBC(value uint32) {
	volatile.StoreUint32(&o.NCFGR.Reg, volatile.LoadUint32(&o.NCFGR.Reg)&^(0x20)|value<<5)
}
func (o *EMAC_Type) GetNCFGR_NBC() uint32 {
	return (volatile.LoadUint32(&o.NCFGR.Reg) & 0x20) >> 5
}
func (o *EMAC_Type) SetNCFGR_MTI(value uint32) {
	volatile.StoreUint32(&o.NCFGR.Reg, volatile.LoadUint32(&o.NCFGR.Reg)&^(0x40)|value<<6)
}
func (o *EMAC_Type) GetNCFGR_MTI() uint32 {
	return (volatile.LoadUint32(&o.NCFGR.Reg) & 0x40) >> 6
}
func (o *EMAC_Type) SetNCFGR_UNI(value uint32) {
	volatile.StoreUint32(&o.NCFGR.Reg, volatile.LoadUint32(&o.NCFGR.Reg)&^(0x80)|value<<7)
}
func (o *EMAC_Type) GetNCFGR_UNI() uint32 {
	return (volatile.LoadUint32(&o.NCFGR.Reg) & 0x80) >> 7
}
func (o *EMAC_Type) SetNCFGR_BIG(value uint32) {
	volatile.StoreUint32(&o.NCFGR.Reg, volatile.LoadUint32(&o.NCFGR.Reg)&^(0x100)|value<<8)
}
func (o *EMAC_Type) GetNCFGR_BIG() uint32 {
	return (volatile.LoadUint32(&o.NCFGR.Reg) & 0x100) >> 8
}
func (o *EMAC_Type) SetNCFGR_CLK(value uint32) {
	volatile.StoreUint32(&o.NCFGR.Reg, volatile.LoadUint32(&o.NCFGR.Reg)&^(0xc00)|value<<10)
}
func (o *EMAC_Type) GetNCFGR_CLK() uint32 {
	return (volatile.LoadUint32(&o.NCFGR.Reg) & 0xc00) >> 10
}
func (o *EMAC_Type) SetNCFGR_RTY(value uint32) {
	volatile.StoreUint32(&o.NCFGR.Reg, volatile.LoadUint32(&o.NCFGR.Reg)&^(0x1000)|value<<12)
}
func (o *EMAC_Type) GetNCFGR_RTY() uint32 {
	return (volatile.LoadUint32(&o.NCFGR.Reg) & 0x1000) >> 12
}
func (o *EMAC_Type) SetNCFGR_PAE(value uint32) {
	volatile.StoreUint32(&o.NCFGR.Reg, volatile.LoadUint32(&o.NCFGR.Reg)&^(0x2000)|value<<13)
}
func (o *EMAC_Type) GetNCFGR_PAE() uint32 {
	return (volatile.LoadUint32(&o.NCFGR.Reg) & 0x2000) >> 13
}
func (o *EMAC_Type) SetNCFGR_RBOF(value uint32) {
	volatile.StoreUint32(&o.NCFGR.Reg, volatile.LoadUint32(&o.NCFGR.Reg)&^(0xc000)|value<<14)
}
func (o *EMAC_Type) GetNCFGR_RBOF() uint32 {
	return (volatile.LoadUint32(&o.NCFGR.Reg) & 0xc000) >> 14
}
func (o *EMAC_Type) SetNCFGR_RLCE(value uint32) {
	volatile.StoreUint32(&o.NCFGR.Reg, volatile.LoadUint32(&o.NCFGR.Reg)&^(0x10000)|value<<16)
}
func (o *EMAC_Type) GetNCFGR_RLCE() uint32 {
	return (volatile.LoadUint32(&o.NCFGR.Reg) & 0x10000) >> 16
}
func (o *EMAC_Type) SetNCFGR_DRFCS(value uint32) {
	volatile.StoreUint32(&o.NCFGR.Reg, volatile.LoadUint32(&o.NCFGR.Reg)&^(0x20000)|value<<17)
}
func (o *EMAC_Type) GetNCFGR_DRFCS() uint32 {
	return (volatile.LoadUint32(&o.NCFGR.Reg) & 0x20000) >> 17
}
func (o *EMAC_Type) SetNCFGR_EFRHD(value uint32) {
	volatile.StoreUint32(&o.NCFGR.Reg, volatile.LoadUint32(&o.NCFGR.Reg)&^(0x40000)|value<<18)
}
func (o *EMAC_Type) GetNCFGR_EFRHD() uint32 {
	return (volatile.LoadUint32(&o.NCFGR.Reg) & 0x40000) >> 18
}
func (o *EMAC_Type) SetNCFGR_IRXFCS(value uint32) {
	volatile.StoreUint32(&o.NCFGR.Reg, volatile.LoadUint32(&o.NCFGR.Reg)&^(0x80000)|value<<19)
}
func (o *EMAC_Type) GetNCFGR_IRXFCS() uint32 {
	return (volatile.LoadUint32(&o.NCFGR.Reg) & 0x80000) >> 19
}

// EMAC.NSR: Network Status Register
func (o *EMAC_Type) SetNSR_MDIO(value uint32) {
	volatile.StoreUint32(&o.NSR.Reg, volatile.LoadUint32(&o.NSR.Reg)&^(0x2)|value<<1)
}
func (o *EMAC_Type) GetNSR_MDIO() uint32 {
	return (volatile.LoadUint32(&o.NSR.Reg) & 0x2) >> 1
}
func (o *EMAC_Type) SetNSR_IDLE(value uint32) {
	volatile.StoreUint32(&o.NSR.Reg, volatile.LoadUint32(&o.NSR.Reg)&^(0x4)|value<<2)
}
func (o *EMAC_Type) GetNSR_IDLE() uint32 {
	return (volatile.LoadUint32(&o.NSR.Reg) & 0x4) >> 2
}

// EMAC.TSR: Transmit Status Register
func (o *EMAC_Type) SetTSR_UBR(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x1)|value)
}
func (o *EMAC_Type) GetTSR_UBR() uint32 {
	return volatile.LoadUint32(&o.TSR.Reg) & 0x1
}
func (o *EMAC_Type) SetTSR_COL(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x2)|value<<1)
}
func (o *EMAC_Type) GetTSR_COL() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x2) >> 1
}
func (o *EMAC_Type) SetTSR_RLES(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x4)|value<<2)
}
func (o *EMAC_Type) GetTSR_RLES() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x4) >> 2
}
func (o *EMAC_Type) SetTSR_TGO(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x8)|value<<3)
}
func (o *EMAC_Type) GetTSR_TGO() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x8) >> 3
}
func (o *EMAC_Type) SetTSR_BEX(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x10)|value<<4)
}
func (o *EMAC_Type) GetTSR_BEX() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x10) >> 4
}
func (o *EMAC_Type) SetTSR_COMP(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x20)|value<<5)
}
func (o *EMAC_Type) GetTSR_COMP() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x20) >> 5
}
func (o *EMAC_Type) SetTSR_UND(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x40)|value<<6)
}
func (o *EMAC_Type) GetTSR_UND() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x40) >> 6
}

// EMAC.RBQP: Receive Buffer Queue Pointer Register
func (o *EMAC_Type) SetRBQP_ADDR(value uint32) {
	volatile.StoreUint32(&o.RBQP.Reg, volatile.LoadUint32(&o.RBQP.Reg)&^(0xfffffffc)|value<<2)
}
func (o *EMAC_Type) GetRBQP_ADDR() uint32 {
	return (volatile.LoadUint32(&o.RBQP.Reg) & 0xfffffffc) >> 2
}

// EMAC.TBQP: Transmit Buffer Queue Pointer Register
func (o *EMAC_Type) SetTBQP_ADDR(value uint32) {
	volatile.StoreUint32(&o.TBQP.Reg, volatile.LoadUint32(&o.TBQP.Reg)&^(0xfffffffc)|value<<2)
}
func (o *EMAC_Type) GetTBQP_ADDR() uint32 {
	return (volatile.LoadUint32(&o.TBQP.Reg) & 0xfffffffc) >> 2
}

// EMAC.RSR: Receive Status Register
func (o *EMAC_Type) SetRSR_BNA(value uint32) {
	volatile.StoreUint32(&o.RSR.Reg, volatile.LoadUint32(&o.RSR.Reg)&^(0x1)|value)
}
func (o *EMAC_Type) GetRSR_BNA() uint32 {
	return volatile.LoadUint32(&o.RSR.Reg) & 0x1
}
func (o *EMAC_Type) SetRSR_REC(value uint32) {
	volatile.StoreUint32(&o.RSR.Reg, volatile.LoadUint32(&o.RSR.Reg)&^(0x2)|value<<1)
}
func (o *EMAC_Type) GetRSR_REC() uint32 {
	return (volatile.LoadUint32(&o.RSR.Reg) & 0x2) >> 1
}
func (o *EMAC_Type) SetRSR_OVR(value uint32) {
	volatile.StoreUint32(&o.RSR.Reg, volatile.LoadUint32(&o.RSR.Reg)&^(0x4)|value<<2)
}
func (o *EMAC_Type) GetRSR_OVR() uint32 {
	return (volatile.LoadUint32(&o.RSR.Reg) & 0x4) >> 2
}

// EMAC.ISR: Interrupt Status Register
func (o *EMAC_Type) SetISR_MFD(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *EMAC_Type) GetISR_MFD() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}
func (o *EMAC_Type) SetISR_RCOMP(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *EMAC_Type) GetISR_RCOMP() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *EMAC_Type) SetISR_RXUBR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *EMAC_Type) GetISR_RXUBR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *EMAC_Type) SetISR_TXUBR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *EMAC_Type) GetISR_TXUBR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *EMAC_Type) SetISR_TUND(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *EMAC_Type) GetISR_TUND() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *EMAC_Type) SetISR_RLEX(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20)|value<<5)
}
func (o *EMAC_Type) GetISR_RLEX() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20) >> 5
}
func (o *EMAC_Type) SetISR_TXERR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40)|value<<6)
}
func (o *EMAC_Type) GetISR_TXERR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40) >> 6
}
func (o *EMAC_Type) SetISR_TCOMP(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80)|value<<7)
}
func (o *EMAC_Type) GetISR_TCOMP() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80) >> 7
}
func (o *EMAC_Type) SetISR_ROVR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400)|value<<10)
}
func (o *EMAC_Type) GetISR_ROVR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400) >> 10
}
func (o *EMAC_Type) SetISR_HRESP(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x800)|value<<11)
}
func (o *EMAC_Type) GetISR_HRESP() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x800) >> 11
}
func (o *EMAC_Type) SetISR_PFRE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1000)|value<<12)
}
func (o *EMAC_Type) GetISR_PFRE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x1000) >> 12
}
func (o *EMAC_Type) SetISR_PTZ(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2000)|value<<13)
}
func (o *EMAC_Type) GetISR_PTZ() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2000) >> 13
}

// EMAC.IER: Interrupt Enable Register
func (o *EMAC_Type) SetIER_MFD(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *EMAC_Type) GetIER_MFD() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *EMAC_Type) SetIER_RCOMP(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *EMAC_Type) GetIER_RCOMP() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *EMAC_Type) SetIER_RXUBR(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *EMAC_Type) GetIER_RXUBR() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *EMAC_Type) SetIER_TXUBR(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *EMAC_Type) GetIER_TXUBR() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *EMAC_Type) SetIER_TUND(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *EMAC_Type) GetIER_TUND() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *EMAC_Type) SetIER_RLE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *EMAC_Type) GetIER_RLE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *EMAC_Type) SetIER_TXERR(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40)|value<<6)
}
func (o *EMAC_Type) GetIER_TXERR() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40) >> 6
}
func (o *EMAC_Type) SetIER_TCOMP(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80)|value<<7)
}
func (o *EMAC_Type) GetIER_TCOMP() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80) >> 7
}
func (o *EMAC_Type) SetIER_ROVR(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400)|value<<10)
}
func (o *EMAC_Type) GetIER_ROVR() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400) >> 10
}
func (o *EMAC_Type) SetIER_HRESP(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x800)|value<<11)
}
func (o *EMAC_Type) GetIER_HRESP() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x800) >> 11
}
func (o *EMAC_Type) SetIER_PFR(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1000)|value<<12)
}
func (o *EMAC_Type) GetIER_PFR() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x1000) >> 12
}
func (o *EMAC_Type) SetIER_PTZ(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2000)|value<<13)
}
func (o *EMAC_Type) GetIER_PTZ() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2000) >> 13
}

// EMAC.IDR: Interrupt Disable Register
func (o *EMAC_Type) SetIDR_MFD(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *EMAC_Type) GetIDR_MFD() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *EMAC_Type) SetIDR_RCOMP(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *EMAC_Type) GetIDR_RCOMP() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *EMAC_Type) SetIDR_RXUBR(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4)|value<<2)
}
func (o *EMAC_Type) GetIDR_RXUBR() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4) >> 2
}
func (o *EMAC_Type) SetIDR_TXUBR(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8)|value<<3)
}
func (o *EMAC_Type) GetIDR_TXUBR() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8) >> 3
}
func (o *EMAC_Type) SetIDR_TUND(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10)|value<<4)
}
func (o *EMAC_Type) GetIDR_TUND() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10) >> 4
}
func (o *EMAC_Type) SetIDR_RLE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20)|value<<5)
}
func (o *EMAC_Type) GetIDR_RLE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20) >> 5
}
func (o *EMAC_Type) SetIDR_TXERR(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40)|value<<6)
}
func (o *EMAC_Type) GetIDR_TXERR() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40) >> 6
}
func (o *EMAC_Type) SetIDR_TCOMP(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80)|value<<7)
}
func (o *EMAC_Type) GetIDR_TCOMP() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80) >> 7
}
func (o *EMAC_Type) SetIDR_ROVR(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400)|value<<10)
}
func (o *EMAC_Type) GetIDR_ROVR() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400) >> 10
}
func (o *EMAC_Type) SetIDR_HRESP(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x800)|value<<11)
}
func (o *EMAC_Type) GetIDR_HRESP() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x800) >> 11
}
func (o *EMAC_Type) SetIDR_PFR(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1000)|value<<12)
}
func (o *EMAC_Type) GetIDR_PFR() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x1000) >> 12
}
func (o *EMAC_Type) SetIDR_PTZ(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2000)|value<<13)
}
func (o *EMAC_Type) GetIDR_PTZ() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2000) >> 13
}

// EMAC.IMR: Interrupt Mask Register
func (o *EMAC_Type) SetIMR_MFD(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *EMAC_Type) GetIMR_MFD() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *EMAC_Type) SetIMR_RCOMP(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *EMAC_Type) GetIMR_RCOMP() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *EMAC_Type) SetIMR_RXUBR(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4)|value<<2)
}
func (o *EMAC_Type) GetIMR_RXUBR() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4) >> 2
}
func (o *EMAC_Type) SetIMR_TXUBR(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8)|value<<3)
}
func (o *EMAC_Type) GetIMR_TXUBR() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8) >> 3
}
func (o *EMAC_Type) SetIMR_TUND(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10)|value<<4)
}
func (o *EMAC_Type) GetIMR_TUND() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10) >> 4
}
func (o *EMAC_Type) SetIMR_RLE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20)|value<<5)
}
func (o *EMAC_Type) GetIMR_RLE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20) >> 5
}
func (o *EMAC_Type) SetIMR_TXERR(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40)|value<<6)
}
func (o *EMAC_Type) GetIMR_TXERR() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40) >> 6
}
func (o *EMAC_Type) SetIMR_TCOMP(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80)|value<<7)
}
func (o *EMAC_Type) GetIMR_TCOMP() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80) >> 7
}
func (o *EMAC_Type) SetIMR_ROVR(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400)|value<<10)
}
func (o *EMAC_Type) GetIMR_ROVR() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400) >> 10
}
func (o *EMAC_Type) SetIMR_HRESP(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x800)|value<<11)
}
func (o *EMAC_Type) GetIMR_HRESP() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x800) >> 11
}
func (o *EMAC_Type) SetIMR_PFR(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1000)|value<<12)
}
func (o *EMAC_Type) GetIMR_PFR() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x1000) >> 12
}
func (o *EMAC_Type) SetIMR_PTZ(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2000)|value<<13)
}
func (o *EMAC_Type) GetIMR_PTZ() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2000) >> 13
}

// EMAC.MAN: Phy Maintenance Register
func (o *EMAC_Type) SetMAN_DATA(value uint32) {
	volatile.StoreUint32(&o.MAN.Reg, volatile.LoadUint32(&o.MAN.Reg)&^(0xffff)|value)
}
func (o *EMAC_Type) GetMAN_DATA() uint32 {
	return volatile.LoadUint32(&o.MAN.Reg) & 0xffff
}
func (o *EMAC_Type) SetMAN_CODE(value uint32) {
	volatile.StoreUint32(&o.MAN.Reg, volatile.LoadUint32(&o.MAN.Reg)&^(0x30000)|value<<16)
}
func (o *EMAC_Type) GetMAN_CODE() uint32 {
	return (volatile.LoadUint32(&o.MAN.Reg) & 0x30000) >> 16
}
func (o *EMAC_Type) SetMAN_REGA(value uint32) {
	volatile.StoreUint32(&o.MAN.Reg, volatile.LoadUint32(&o.MAN.Reg)&^(0x7c0000)|value<<18)
}
func (o *EMAC_Type) GetMAN_REGA() uint32 {
	return (volatile.LoadUint32(&o.MAN.Reg) & 0x7c0000) >> 18
}
func (o *EMAC_Type) SetMAN_PHYA(value uint32) {
	volatile.StoreUint32(&o.MAN.Reg, volatile.LoadUint32(&o.MAN.Reg)&^(0xf800000)|value<<23)
}
func (o *EMAC_Type) GetMAN_PHYA() uint32 {
	return (volatile.LoadUint32(&o.MAN.Reg) & 0xf800000) >> 23
}
func (o *EMAC_Type) SetMAN_RW(value uint32) {
	volatile.StoreUint32(&o.MAN.Reg, volatile.LoadUint32(&o.MAN.Reg)&^(0x30000000)|value<<28)
}
func (o *EMAC_Type) GetMAN_RW() uint32 {
	return (volatile.LoadUint32(&o.MAN.Reg) & 0x30000000) >> 28
}
func (o *EMAC_Type) SetMAN_SOF(value uint32) {
	volatile.StoreUint32(&o.MAN.Reg, volatile.LoadUint32(&o.MAN.Reg)&^(0xc0000000)|value<<30)
}
func (o *EMAC_Type) GetMAN_SOF() uint32 {
	return (volatile.LoadUint32(&o.MAN.Reg) & 0xc0000000) >> 30
}

// EMAC.PTR: Pause Time Register
func (o *EMAC_Type) SetPTR_PTIME(value uint32) {
	volatile.StoreUint32(&o.PTR.Reg, volatile.LoadUint32(&o.PTR.Reg)&^(0xffff)|value)
}
func (o *EMAC_Type) GetPTR_PTIME() uint32 {
	return volatile.LoadUint32(&o.PTR.Reg) & 0xffff
}

// EMAC.PFR: Pause Frames Received Register
func (o *EMAC_Type) SetPFR_FROK(value uint32) {
	volatile.StoreUint32(&o.PFR.Reg, volatile.LoadUint32(&o.PFR.Reg)&^(0xffff)|value)
}
func (o *EMAC_Type) GetPFR_FROK() uint32 {
	return volatile.LoadUint32(&o.PFR.Reg) & 0xffff
}

// EMAC.FTO: Frames Transmitted Ok Register
func (o *EMAC_Type) SetFTO_FTOK(value uint32) {
	volatile.StoreUint32(&o.FTO.Reg, volatile.LoadUint32(&o.FTO.Reg)&^(0xffffff)|value)
}
func (o *EMAC_Type) GetFTO_FTOK() uint32 {
	return volatile.LoadUint32(&o.FTO.Reg) & 0xffffff
}

// EMAC.SCF: Single Collision Frames Register
func (o *EMAC_Type) SetSCF(value uint32) {
	volatile.StoreUint32(&o.SCF.Reg, volatile.LoadUint32(&o.SCF.Reg)&^(0xffff)|value)
}
func (o *EMAC_Type) GetSCF() uint32 {
	return volatile.LoadUint32(&o.SCF.Reg) & 0xffff
}

// EMAC.MCF: Multiple Collision Frames Register
func (o *EMAC_Type) SetMCF(value uint32) {
	volatile.StoreUint32(&o.MCF.Reg, volatile.LoadUint32(&o.MCF.Reg)&^(0xffff)|value)
}
func (o *EMAC_Type) GetMCF() uint32 {
	return volatile.LoadUint32(&o.MCF.Reg) & 0xffff
}

// EMAC.FRO: Frames Received Ok Register
func (o *EMAC_Type) SetFRO_FROK(value uint32) {
	volatile.StoreUint32(&o.FRO.Reg, volatile.LoadUint32(&o.FRO.Reg)&^(0xffffff)|value)
}
func (o *EMAC_Type) GetFRO_FROK() uint32 {
	return volatile.LoadUint32(&o.FRO.Reg) & 0xffffff
}

// EMAC.FCSE: Frame Check Sequence Errors Register
func (o *EMAC_Type) SetFCSE(value uint32) {
	volatile.StoreUint32(&o.FCSE.Reg, volatile.LoadUint32(&o.FCSE.Reg)&^(0xff)|value)
}
func (o *EMAC_Type) GetFCSE() uint32 {
	return volatile.LoadUint32(&o.FCSE.Reg) & 0xff
}

// EMAC.ALE: Alignment Errors Register
func (o *EMAC_Type) SetALE(value uint32) {
	volatile.StoreUint32(&o.ALE.Reg, volatile.LoadUint32(&o.ALE.Reg)&^(0xff)|value)
}
func (o *EMAC_Type) GetALE() uint32 {
	return volatile.LoadUint32(&o.ALE.Reg) & 0xff
}

// EMAC.DTF: Deferred Transmission Frames Register
func (o *EMAC_Type) SetDTF(value uint32) {
	volatile.StoreUint32(&o.DTF.Reg, volatile.LoadUint32(&o.DTF.Reg)&^(0xffff)|value)
}
func (o *EMAC_Type) GetDTF() uint32 {
	return volatile.LoadUint32(&o.DTF.Reg) & 0xffff
}

// EMAC.LCOL: Late Collisions Register
func (o *EMAC_Type) SetLCOL(value uint32) {
	volatile.StoreUint32(&o.LCOL.Reg, volatile.LoadUint32(&o.LCOL.Reg)&^(0xff)|value)
}
func (o *EMAC_Type) GetLCOL() uint32 {
	return volatile.LoadUint32(&o.LCOL.Reg) & 0xff
}

// EMAC.ECOL: Excessive Collisions Register
func (o *EMAC_Type) SetECOL_EXCOL(value uint32) {
	volatile.StoreUint32(&o.ECOL.Reg, volatile.LoadUint32(&o.ECOL.Reg)&^(0xff)|value)
}
func (o *EMAC_Type) GetECOL_EXCOL() uint32 {
	return volatile.LoadUint32(&o.ECOL.Reg) & 0xff
}

// EMAC.TUND: Transmit Underrun Errors Register
func (o *EMAC_Type) SetTUND(value uint32) {
	volatile.StoreUint32(&o.TUND.Reg, volatile.LoadUint32(&o.TUND.Reg)&^(0xff)|value)
}
func (o *EMAC_Type) GetTUND() uint32 {
	return volatile.LoadUint32(&o.TUND.Reg) & 0xff
}

// EMAC.CSE: Carrier Sense Errors Register
func (o *EMAC_Type) SetCSE(value uint32) {
	volatile.StoreUint32(&o.CSE.Reg, volatile.LoadUint32(&o.CSE.Reg)&^(0xff)|value)
}
func (o *EMAC_Type) GetCSE() uint32 {
	return volatile.LoadUint32(&o.CSE.Reg) & 0xff
}

// EMAC.RRE: Receive Resource Errors Register
func (o *EMAC_Type) SetRRE(value uint32) {
	volatile.StoreUint32(&o.RRE.Reg, volatile.LoadUint32(&o.RRE.Reg)&^(0xffff)|value)
}
func (o *EMAC_Type) GetRRE() uint32 {
	return volatile.LoadUint32(&o.RRE.Reg) & 0xffff
}

// EMAC.ROV: Receive Overrun Errors Register
func (o *EMAC_Type) SetROV_ROVR(value uint32) {
	volatile.StoreUint32(&o.ROV.Reg, volatile.LoadUint32(&o.ROV.Reg)&^(0xff)|value)
}
func (o *EMAC_Type) GetROV_ROVR() uint32 {
	return volatile.LoadUint32(&o.ROV.Reg) & 0xff
}

// EMAC.RSE: Receive Symbol Errors Register
func (o *EMAC_Type) SetRSE(value uint32) {
	volatile.StoreUint32(&o.RSE.Reg, volatile.LoadUint32(&o.RSE.Reg)&^(0xff)|value)
}
func (o *EMAC_Type) GetRSE() uint32 {
	return volatile.LoadUint32(&o.RSE.Reg) & 0xff
}

// EMAC.ELE: Excessive Length Errors Register
func (o *EMAC_Type) SetELE_EXL(value uint32) {
	volatile.StoreUint32(&o.ELE.Reg, volatile.LoadUint32(&o.ELE.Reg)&^(0xff)|value)
}
func (o *EMAC_Type) GetELE_EXL() uint32 {
	return volatile.LoadUint32(&o.ELE.Reg) & 0xff
}

// EMAC.RJA: Receive Jabbers Register
func (o *EMAC_Type) SetRJA_RJB(value uint32) {
	volatile.StoreUint32(&o.RJA.Reg, volatile.LoadUint32(&o.RJA.Reg)&^(0xff)|value)
}
func (o *EMAC_Type) GetRJA_RJB() uint32 {
	return volatile.LoadUint32(&o.RJA.Reg) & 0xff
}

// EMAC.USF: Undersize Frames Register
func (o *EMAC_Type) SetUSF(value uint32) {
	volatile.StoreUint32(&o.USF.Reg, volatile.LoadUint32(&o.USF.Reg)&^(0xff)|value)
}
func (o *EMAC_Type) GetUSF() uint32 {
	return volatile.LoadUint32(&o.USF.Reg) & 0xff
}

// EMAC.STE: SQE Test Errors Register
func (o *EMAC_Type) SetSTE_SQER(value uint32) {
	volatile.StoreUint32(&o.STE.Reg, volatile.LoadUint32(&o.STE.Reg)&^(0xff)|value)
}
func (o *EMAC_Type) GetSTE_SQER() uint32 {
	return volatile.LoadUint32(&o.STE.Reg) & 0xff
}

// EMAC.RLE: Received Length Field Mismatch Register
func (o *EMAC_Type) SetRLE_RLFM(value uint32) {
	volatile.StoreUint32(&o.RLE.Reg, volatile.LoadUint32(&o.RLE.Reg)&^(0xff)|value)
}
func (o *EMAC_Type) GetRLE_RLFM() uint32 {
	return volatile.LoadUint32(&o.RLE.Reg) & 0xff
}

// EMAC.HRB: Hash Register Bottom [31:0] Register
func (o *EMAC_Type) SetHRB(value uint32) {
	volatile.StoreUint32(&o.HRB.Reg, value)
}
func (o *EMAC_Type) GetHRB() uint32 {
	return volatile.LoadUint32(&o.HRB.Reg)
}

// EMAC.HRT: Hash Register Top [63:32] Register
func (o *EMAC_Type) SetHRT(value uint32) {
	volatile.StoreUint32(&o.HRT.Reg, value)
}
func (o *EMAC_Type) GetHRT() uint32 {
	return volatile.LoadUint32(&o.HRT.Reg)
}

// EMAC.SA1B: Specific Address 1 Bottom Register
func (o *EMAC_Type) SetSA1B(value uint32) {
	volatile.StoreUint32(&o.SA1B.Reg, value)
}
func (o *EMAC_Type) GetSA1B() uint32 {
	return volatile.LoadUint32(&o.SA1B.Reg)
}

// EMAC.SA1T: Specific Address 1 Top Register
func (o *EMAC_Type) SetSA1T_ADDR(value uint32) {
	volatile.StoreUint32(&o.SA1T.Reg, volatile.LoadUint32(&o.SA1T.Reg)&^(0xffff)|value)
}
func (o *EMAC_Type) GetSA1T_ADDR() uint32 {
	return volatile.LoadUint32(&o.SA1T.Reg) & 0xffff
}

// EMAC.SA2B: Specific Address 2 Bottom Register
func (o *EMAC_Type) SetSA2B(value uint32) {
	volatile.StoreUint32(&o.SA2B.Reg, value)
}
func (o *EMAC_Type) GetSA2B() uint32 {
	return volatile.LoadUint32(&o.SA2B.Reg)
}

// EMAC.SA2T: Specific Address 2 Top Register
func (o *EMAC_Type) SetSA2T_ADDR(value uint32) {
	volatile.StoreUint32(&o.SA2T.Reg, volatile.LoadUint32(&o.SA2T.Reg)&^(0xffff)|value)
}
func (o *EMAC_Type) GetSA2T_ADDR() uint32 {
	return volatile.LoadUint32(&o.SA2T.Reg) & 0xffff
}

// EMAC.SA3B: Specific Address 3 Bottom Register
func (o *EMAC_Type) SetSA3B(value uint32) {
	volatile.StoreUint32(&o.SA3B.Reg, value)
}
func (o *EMAC_Type) GetSA3B() uint32 {
	return volatile.LoadUint32(&o.SA3B.Reg)
}

// EMAC.SA3T: Specific Address 3 Top Register
func (o *EMAC_Type) SetSA3T_ADDR(value uint32) {
	volatile.StoreUint32(&o.SA3T.Reg, volatile.LoadUint32(&o.SA3T.Reg)&^(0xffff)|value)
}
func (o *EMAC_Type) GetSA3T_ADDR() uint32 {
	return volatile.LoadUint32(&o.SA3T.Reg) & 0xffff
}

// EMAC.SA4B: Specific Address 4 Bottom Register
func (o *EMAC_Type) SetSA4B(value uint32) {
	volatile.StoreUint32(&o.SA4B.Reg, value)
}
func (o *EMAC_Type) GetSA4B() uint32 {
	return volatile.LoadUint32(&o.SA4B.Reg)
}

// EMAC.SA4T: Specific Address 4 Top Register
func (o *EMAC_Type) SetSA4T_ADDR(value uint32) {
	volatile.StoreUint32(&o.SA4T.Reg, volatile.LoadUint32(&o.SA4T.Reg)&^(0xffff)|value)
}
func (o *EMAC_Type) GetSA4T_ADDR() uint32 {
	return volatile.LoadUint32(&o.SA4T.Reg) & 0xffff
}

// EMAC.TID: Type ID Checking Register
func (o *EMAC_Type) SetTID(value uint32) {
	volatile.StoreUint32(&o.TID.Reg, volatile.LoadUint32(&o.TID.Reg)&^(0xffff)|value)
}
func (o *EMAC_Type) GetTID() uint32 {
	return volatile.LoadUint32(&o.TID.Reg) & 0xffff
}

// EMAC.USRIO: User Input/Output Register
func (o *EMAC_Type) SetUSRIO_RMII(value uint32) {
	volatile.StoreUint32(&o.USRIO.Reg, volatile.LoadUint32(&o.USRIO.Reg)&^(0x1)|value)
}
func (o *EMAC_Type) GetUSRIO_RMII() uint32 {
	return volatile.LoadUint32(&o.USRIO.Reg) & 0x1
}
func (o *EMAC_Type) SetUSRIO_CLKEN(value uint32) {
	volatile.StoreUint32(&o.USRIO.Reg, volatile.LoadUint32(&o.USRIO.Reg)&^(0x2)|value<<1)
}
func (o *EMAC_Type) GetUSRIO_CLKEN() uint32 {
	return (volatile.LoadUint32(&o.USRIO.Reg) & 0x2) >> 1
}

// Pulse Width Modulation Controller
type PWM_Type struct {
	MR    volatile.Register32 // 0x0
	ENA   volatile.Register32 // 0x4
	DIS   volatile.Register32 // 0x8
	SR    volatile.Register32 // 0xC
	IER   volatile.Register32 // 0x10
	IDR   volatile.Register32 // 0x14
	IMR   volatile.Register32 // 0x18
	ISR   volatile.Register32 // 0x1C
	_     [480]byte
	CMR0  volatile.Register32 // 0x200
	CDTY0 volatile.Register32 // 0x204
	CPRD0 volatile.Register32 // 0x208
	CCNT0 volatile.Register32 // 0x20C
	CUPD0 volatile.Register32 // 0x210
	_     [12]byte
	CMR1  volatile.Register32 // 0x220
	CDTY1 volatile.Register32 // 0x224
	CPRD1 volatile.Register32 // 0x228
	CCNT1 volatile.Register32 // 0x22C
	CUPD1 volatile.Register32 // 0x230
	_     [12]byte
	CMR2  volatile.Register32 // 0x240
	CDTY2 volatile.Register32 // 0x244
	CPRD2 volatile.Register32 // 0x248
	CCNT2 volatile.Register32 // 0x24C
	CUPD2 volatile.Register32 // 0x250
	_     [12]byte
	CMR3  volatile.Register32 // 0x260
	CDTY3 volatile.Register32 // 0x264
	CPRD3 volatile.Register32 // 0x268
	CCNT3 volatile.Register32 // 0x26C
	CUPD3 volatile.Register32 // 0x270
}

// PWM.MR: PWM Mode Register
func (o *PWM_Type) SetMR_DIVA(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xff)|value)
}
func (o *PWM_Type) GetMR_DIVA() uint32 {
	return volatile.LoadUint32(&o.MR.Reg) & 0xff
}
func (o *PWM_Type) SetMR_PREA(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xf00)|value<<8)
}
func (o *PWM_Type) GetMR_PREA() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xf00) >> 8
}
func (o *PWM_Type) SetMR_DIVB(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xff0000)|value<<16)
}
func (o *PWM_Type) GetMR_DIVB() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xff0000) >> 16
}
func (o *PWM_Type) SetMR_PREB(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xf000000)|value<<24)
}
func (o *PWM_Type) GetMR_PREB() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xf000000) >> 24
}

// PWM.ENA: PWM Enable Register
func (o *PWM_Type) SetENA_CHID0(value uint32) {
	volatile.StoreUint32(&o.ENA.Reg, volatile.LoadUint32(&o.ENA.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetENA_CHID0() uint32 {
	return volatile.LoadUint32(&o.ENA.Reg) & 0x1
}
func (o *PWM_Type) SetENA_CHID1(value uint32) {
	volatile.StoreUint32(&o.ENA.Reg, volatile.LoadUint32(&o.ENA.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetENA_CHID1() uint32 {
	return (volatile.LoadUint32(&o.ENA.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetENA_CHID2(value uint32) {
	volatile.StoreUint32(&o.ENA.Reg, volatile.LoadUint32(&o.ENA.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetENA_CHID2() uint32 {
	return (volatile.LoadUint32(&o.ENA.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetENA_CHID3(value uint32) {
	volatile.StoreUint32(&o.ENA.Reg, volatile.LoadUint32(&o.ENA.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetENA_CHID3() uint32 {
	return (volatile.LoadUint32(&o.ENA.Reg) & 0x8) >> 3
}

// PWM.DIS: PWM Disable Register
func (o *PWM_Type) SetDIS_CHID0(value uint32) {
	volatile.StoreUint32(&o.DIS.Reg, volatile.LoadUint32(&o.DIS.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetDIS_CHID0() uint32 {
	return volatile.LoadUint32(&o.DIS.Reg) & 0x1
}
func (o *PWM_Type) SetDIS_CHID1(value uint32) {
	volatile.StoreUint32(&o.DIS.Reg, volatile.LoadUint32(&o.DIS.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetDIS_CHID1() uint32 {
	return (volatile.LoadUint32(&o.DIS.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetDIS_CHID2(value uint32) {
	volatile.StoreUint32(&o.DIS.Reg, volatile.LoadUint32(&o.DIS.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetDIS_CHID2() uint32 {
	return (volatile.LoadUint32(&o.DIS.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetDIS_CHID3(value uint32) {
	volatile.StoreUint32(&o.DIS.Reg, volatile.LoadUint32(&o.DIS.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetDIS_CHID3() uint32 {
	return (volatile.LoadUint32(&o.DIS.Reg) & 0x8) >> 3
}

// PWM.SR: PWM Status Register
func (o *PWM_Type) SetSR_CHID0(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetSR_CHID0() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *PWM_Type) SetSR_CHID1(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetSR_CHID1() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetSR_CHID2(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetSR_CHID2() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetSR_CHID3(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetSR_CHID3() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}

// PWM.IER: PWM Interrupt Enable Register
func (o *PWM_Type) SetIER_CHID0(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetIER_CHID0() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *PWM_Type) SetIER_CHID1(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetIER_CHID1() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetIER_CHID2(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetIER_CHID2() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetIER_CHID3(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetIER_CHID3() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}

// PWM.IDR: PWM Interrupt Disable Register
func (o *PWM_Type) SetIDR_CHID0(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetIDR_CHID0() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *PWM_Type) SetIDR_CHID1(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetIDR_CHID1() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetIDR_CHID2(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetIDR_CHID2() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetIDR_CHID3(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetIDR_CHID3() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8) >> 3
}

// PWM.IMR: PWM Interrupt Mask Register
func (o *PWM_Type) SetIMR_CHID0(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetIMR_CHID0() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *PWM_Type) SetIMR_CHID1(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetIMR_CHID1() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetIMR_CHID2(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetIMR_CHID2() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetIMR_CHID3(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetIMR_CHID3() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8) >> 3
}

// PWM.ISR: PWM Interrupt Status Register
func (o *PWM_Type) SetISR_CHID0(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetISR_CHID0() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}
func (o *PWM_Type) SetISR_CHID1(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetISR_CHID1() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetISR_CHID2(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetISR_CHID2() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetISR_CHID3(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetISR_CHID3() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}

// PWM.CMR0: PWM Channel Mode Register (ch_num = 0)
func (o *PWM_Type) SetCMR0_CPRE(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0xf)|value)
}
func (o *PWM_Type) GetCMR0_CPRE() uint32 {
	return volatile.LoadUint32(&o.CMR0.Reg) & 0xf
}
func (o *PWM_Type) SetCMR0_CALG(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x100)|value<<8)
}
func (o *PWM_Type) GetCMR0_CALG() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x100) >> 8
}
func (o *PWM_Type) SetCMR0_CPOL(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x200)|value<<9)
}
func (o *PWM_Type) GetCMR0_CPOL() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x200) >> 9
}
func (o *PWM_Type) SetCMR0_CPD(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x400)|value<<10)
}
func (o *PWM_Type) GetCMR0_CPD() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x400) >> 10
}

// PWM.CDTY0: PWM Channel Duty Cycle Register (ch_num = 0)
func (o *PWM_Type) SetCDTY0(value uint32) {
	volatile.StoreUint32(&o.CDTY0.Reg, value)
}
func (o *PWM_Type) GetCDTY0() uint32 {
	return volatile.LoadUint32(&o.CDTY0.Reg)
}

// PWM.CPRD0: PWM Channel Period Register (ch_num = 0)
func (o *PWM_Type) SetCPRD0(value uint32) {
	volatile.StoreUint32(&o.CPRD0.Reg, value)
}
func (o *PWM_Type) GetCPRD0() uint32 {
	return volatile.LoadUint32(&o.CPRD0.Reg)
}

// PWM.CCNT0: PWM Channel Counter Register (ch_num = 0)
func (o *PWM_Type) SetCCNT0(value uint32) {
	volatile.StoreUint32(&o.CCNT0.Reg, value)
}
func (o *PWM_Type) GetCCNT0() uint32 {
	return volatile.LoadUint32(&o.CCNT0.Reg)
}

// PWM.CUPD0: PWM Channel Update Register (ch_num = 0)
func (o *PWM_Type) SetCUPD0(value uint32) {
	volatile.StoreUint32(&o.CUPD0.Reg, value)
}
func (o *PWM_Type) GetCUPD0() uint32 {
	return volatile.LoadUint32(&o.CUPD0.Reg)
}

// PWM.CMR1: PWM Channel Mode Register (ch_num = 1)
func (o *PWM_Type) SetCMR1_CPRE(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0xf)|value)
}
func (o *PWM_Type) GetCMR1_CPRE() uint32 {
	return volatile.LoadUint32(&o.CMR1.Reg) & 0xf
}
func (o *PWM_Type) SetCMR1_CALG(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x100)|value<<8)
}
func (o *PWM_Type) GetCMR1_CALG() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x100) >> 8
}
func (o *PWM_Type) SetCMR1_CPOL(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x200)|value<<9)
}
func (o *PWM_Type) GetCMR1_CPOL() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x200) >> 9
}
func (o *PWM_Type) SetCMR1_CPD(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x400)|value<<10)
}
func (o *PWM_Type) GetCMR1_CPD() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x400) >> 10
}

// PWM.CDTY1: PWM Channel Duty Cycle Register (ch_num = 1)
func (o *PWM_Type) SetCDTY1(value uint32) {
	volatile.StoreUint32(&o.CDTY1.Reg, value)
}
func (o *PWM_Type) GetCDTY1() uint32 {
	return volatile.LoadUint32(&o.CDTY1.Reg)
}

// PWM.CPRD1: PWM Channel Period Register (ch_num = 1)
func (o *PWM_Type) SetCPRD1(value uint32) {
	volatile.StoreUint32(&o.CPRD1.Reg, value)
}
func (o *PWM_Type) GetCPRD1() uint32 {
	return volatile.LoadUint32(&o.CPRD1.Reg)
}

// PWM.CCNT1: PWM Channel Counter Register (ch_num = 1)
func (o *PWM_Type) SetCCNT1(value uint32) {
	volatile.StoreUint32(&o.CCNT1.Reg, value)
}
func (o *PWM_Type) GetCCNT1() uint32 {
	return volatile.LoadUint32(&o.CCNT1.Reg)
}

// PWM.CUPD1: PWM Channel Update Register (ch_num = 1)
func (o *PWM_Type) SetCUPD1(value uint32) {
	volatile.StoreUint32(&o.CUPD1.Reg, value)
}
func (o *PWM_Type) GetCUPD1() uint32 {
	return volatile.LoadUint32(&o.CUPD1.Reg)
}

// PWM.CMR2: PWM Channel Mode Register (ch_num = 2)
func (o *PWM_Type) SetCMR2_CPRE(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0xf)|value)
}
func (o *PWM_Type) GetCMR2_CPRE() uint32 {
	return volatile.LoadUint32(&o.CMR2.Reg) & 0xf
}
func (o *PWM_Type) SetCMR2_CALG(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x100)|value<<8)
}
func (o *PWM_Type) GetCMR2_CALG() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x100) >> 8
}
func (o *PWM_Type) SetCMR2_CPOL(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x200)|value<<9)
}
func (o *PWM_Type) GetCMR2_CPOL() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x200) >> 9
}
func (o *PWM_Type) SetCMR2_CPD(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x400)|value<<10)
}
func (o *PWM_Type) GetCMR2_CPD() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x400) >> 10
}

// PWM.CDTY2: PWM Channel Duty Cycle Register (ch_num = 2)
func (o *PWM_Type) SetCDTY2(value uint32) {
	volatile.StoreUint32(&o.CDTY2.Reg, value)
}
func (o *PWM_Type) GetCDTY2() uint32 {
	return volatile.LoadUint32(&o.CDTY2.Reg)
}

// PWM.CPRD2: PWM Channel Period Register (ch_num = 2)
func (o *PWM_Type) SetCPRD2(value uint32) {
	volatile.StoreUint32(&o.CPRD2.Reg, value)
}
func (o *PWM_Type) GetCPRD2() uint32 {
	return volatile.LoadUint32(&o.CPRD2.Reg)
}

// PWM.CCNT2: PWM Channel Counter Register (ch_num = 2)
func (o *PWM_Type) SetCCNT2(value uint32) {
	volatile.StoreUint32(&o.CCNT2.Reg, value)
}
func (o *PWM_Type) GetCCNT2() uint32 {
	return volatile.LoadUint32(&o.CCNT2.Reg)
}

// PWM.CUPD2: PWM Channel Update Register (ch_num = 2)
func (o *PWM_Type) SetCUPD2(value uint32) {
	volatile.StoreUint32(&o.CUPD2.Reg, value)
}
func (o *PWM_Type) GetCUPD2() uint32 {
	return volatile.LoadUint32(&o.CUPD2.Reg)
}

// PWM.CMR3: PWM Channel Mode Register (ch_num = 3)
func (o *PWM_Type) SetCMR3_CPRE(value uint32) {
	volatile.StoreUint32(&o.CMR3.Reg, volatile.LoadUint32(&o.CMR3.Reg)&^(0xf)|value)
}
func (o *PWM_Type) GetCMR3_CPRE() uint32 {
	return volatile.LoadUint32(&o.CMR3.Reg) & 0xf
}
func (o *PWM_Type) SetCMR3_CALG(value uint32) {
	volatile.StoreUint32(&o.CMR3.Reg, volatile.LoadUint32(&o.CMR3.Reg)&^(0x100)|value<<8)
}
func (o *PWM_Type) GetCMR3_CALG() uint32 {
	return (volatile.LoadUint32(&o.CMR3.Reg) & 0x100) >> 8
}
func (o *PWM_Type) SetCMR3_CPOL(value uint32) {
	volatile.StoreUint32(&o.CMR3.Reg, volatile.LoadUint32(&o.CMR3.Reg)&^(0x200)|value<<9)
}
func (o *PWM_Type) GetCMR3_CPOL() uint32 {
	return (volatile.LoadUint32(&o.CMR3.Reg) & 0x200) >> 9
}
func (o *PWM_Type) SetCMR3_CPD(value uint32) {
	volatile.StoreUint32(&o.CMR3.Reg, volatile.LoadUint32(&o.CMR3.Reg)&^(0x400)|value<<10)
}
func (o *PWM_Type) GetCMR3_CPD() uint32 {
	return (volatile.LoadUint32(&o.CMR3.Reg) & 0x400) >> 10
}

// PWM.CDTY3: PWM Channel Duty Cycle Register (ch_num = 3)
func (o *PWM_Type) SetCDTY3(value uint32) {
	volatile.StoreUint32(&o.CDTY3.Reg, value)
}
func (o *PWM_Type) GetCDTY3() uint32 {
	return volatile.LoadUint32(&o.CDTY3.Reg)
}

// PWM.CPRD3: PWM Channel Period Register (ch_num = 3)
func (o *PWM_Type) SetCPRD3(value uint32) {
	volatile.StoreUint32(&o.CPRD3.Reg, value)
}
func (o *PWM_Type) GetCPRD3() uint32 {
	return volatile.LoadUint32(&o.CPRD3.Reg)
}

// PWM.CCNT3: PWM Channel Counter Register (ch_num = 3)
func (o *PWM_Type) SetCCNT3(value uint32) {
	volatile.StoreUint32(&o.CCNT3.Reg, value)
}
func (o *PWM_Type) GetCCNT3() uint32 {
	return volatile.LoadUint32(&o.CCNT3.Reg)
}

// PWM.CUPD3: PWM Channel Update Register (ch_num = 3)
func (o *PWM_Type) SetCUPD3(value uint32) {
	volatile.StoreUint32(&o.CUPD3.Reg, value)
}
func (o *PWM_Type) GetCUPD3() uint32 {
	return volatile.LoadUint32(&o.CUPD3.Reg)
}

// LCD Controller
type LCDC_Type struct {
	LCDCFG0  volatile.Register32 // 0x0
	LCDCFG1  volatile.Register32 // 0x4
	LCDCFG2  volatile.Register32 // 0x8
	LCDCFG3  volatile.Register32 // 0xC
	LCDCFG4  volatile.Register32 // 0x10
	LCDCFG5  volatile.Register32 // 0x14
	LCDCFG6  volatile.Register32 // 0x18
	_        [4]byte
	LCDEN    volatile.Register32 // 0x20
	LCDDIS   volatile.Register32 // 0x24
	LCDSR    volatile.Register32 // 0x28
	LCDIER   volatile.Register32 // 0x2C
	LCDIDR   volatile.Register32 // 0x30
	LCDIMR   volatile.Register32 // 0x34
	LCDISR   volatile.Register32 // 0x38
	_        [4]byte
	BASECHER volatile.Register32 // 0x40
	BASECHDR volatile.Register32 // 0x44
	BASECHSR volatile.Register32 // 0x48
	BASEIER  volatile.Register32 // 0x4C
	BASEIDR  volatile.Register32 // 0x50
	BASEIMR  volatile.Register32 // 0x54
	BASEISR  volatile.Register32 // 0x58
	BASEHEAD volatile.Register32 // 0x5C
	BASEADDR volatile.Register32 // 0x60
	BASECTRL volatile.Register32 // 0x64
	BASENEXT volatile.Register32 // 0x68
	BASECFG0 volatile.Register32 // 0x6C
	BASECFG1 volatile.Register32 // 0x70
	BASECFG2 volatile.Register32 // 0x74
	BASECFG3 volatile.Register32 // 0x78
	BASECFG4 volatile.Register32 // 0x7C
	_        [128]byte
	OVRCHER1 volatile.Register32 // 0x100
	OVRCHDR1 volatile.Register32 // 0x104
	OVRCHSR1 volatile.Register32 // 0x108
	OVRIER1  volatile.Register32 // 0x10C
	OVRIDR1  volatile.Register32 // 0x110
	OVRIMR1  volatile.Register32 // 0x114
	OVRISR1  volatile.Register32 // 0x118
	OVRHEAD1 volatile.Register32 // 0x11C
	OVRADDR1 volatile.Register32 // 0x120
	OVRCTRL1 volatile.Register32 // 0x124
	OVRNEXT1 volatile.Register32 // 0x128
	OVR1CFG0 volatile.Register32 // 0x12C
	OVR1CFG1 volatile.Register32 // 0x130
	OVR1CFG2 volatile.Register32 // 0x134
	OVR1CFG3 volatile.Register32 // 0x138
	OVR1CFG4 volatile.Register32 // 0x13C
	OVR1CFG5 volatile.Register32 // 0x140
	OVR1CFG6 volatile.Register32 // 0x144
	OVR1CFG7 volatile.Register32 // 0x148
	OVR1CFG8 volatile.Register32 // 0x14C
	OVR1CFG9 volatile.Register32 // 0x150
	_        [300]byte
	HEOCHER  volatile.Register32 // 0x280
	HEOCHDR  volatile.Register32 // 0x284
	HEOCHSR  volatile.Register32 // 0x288
	HEOIER   volatile.Register32 // 0x28C
	HEOIDR   volatile.Register32 // 0x290
	HEOIMR   volatile.Register32 // 0x294
	HEOISR   volatile.Register32 // 0x298
	HEOHEAD  volatile.Register32 // 0x29C
	HEOADDR  volatile.Register32 // 0x2A0
	HEOCTRL  volatile.Register32 // 0x2A4
	HEONEXT  volatile.Register32 // 0x2A8
	HEOUHEAD volatile.Register32 // 0x2AC
	HEOUADDR volatile.Register32 // 0x2B0
	HEOUCTRL volatile.Register32 // 0x2B4
	HEOUNEXT volatile.Register32 // 0x2B8
	HEOVHEAD volatile.Register32 // 0x2BC
	HEOVADDR volatile.Register32 // 0x2C0
	HEOVCTRL volatile.Register32 // 0x2C4
	HEOVNEXT volatile.Register32 // 0x2C8
	HEOCFG0  volatile.Register32 // 0x2CC
	HEOCFG1  volatile.Register32 // 0x2D0
	HEOCFG2  volatile.Register32 // 0x2D4
	HEOCFG3  volatile.Register32 // 0x2D8
	HEOCFG4  volatile.Register32 // 0x2DC
	HEOCFG5  volatile.Register32 // 0x2E0
	HEOCFG6  volatile.Register32 // 0x2E4
	HEOCFG7  volatile.Register32 // 0x2E8
	HEOCFG8  volatile.Register32 // 0x2EC
	HEOCFG9  volatile.Register32 // 0x2F0
	HEOCFG10 volatile.Register32 // 0x2F4
	HEOCFG11 volatile.Register32 // 0x2F8
	HEOCFG12 volatile.Register32 // 0x2FC
	HEOCFG13 volatile.Register32 // 0x300
	HEOCFG14 volatile.Register32 // 0x304
	HEOCFG15 volatile.Register32 // 0x308
	HEOCFG16 volatile.Register32 // 0x30C
	_        [48]byte
	HCRCHER  volatile.Register32 // 0x340
	HCRCHDR  volatile.Register32 // 0x344
	HCRCHSR  volatile.Register32 // 0x348
	HCRIER   volatile.Register32 // 0x34C
	HCRIDR   volatile.Register32 // 0x350
	HCRIMR   volatile.Register32 // 0x354
	HCRISR   volatile.Register32 // 0x358
	HCRHEAD  volatile.Register32 // 0x35C
	HCRADDR  volatile.Register32 // 0x360
	HCRCTRL  volatile.Register32 // 0x364
	HCRNEXT  volatile.Register32 // 0x368
	HCRCFG0  volatile.Register32 // 0x36C
	HCRCFG1  volatile.Register32 // 0x370
	HCRCFG2  volatile.Register32 // 0x374
	HCRCFG3  volatile.Register32 // 0x378
	HCRCFG4  volatile.Register32 // 0x37C
	_        [4]byte
	HCRCFG6  volatile.Register32 // 0x384
	HCRCFG7  volatile.Register32 // 0x388
	HCRCFG8  volatile.Register32 // 0x38C
	HCRCFG9  volatile.Register32 // 0x390
	_        [108]byte
	BASECLUT [256]volatile.Register32 // 0x400
	OVR1CLUT [256]volatile.Register32 // 0x800
	_        [1024]byte
	HEOCLUT  [256]volatile.Register32 // 0x1000
	HCRCLUT  [256]volatile.Register32 // 0x1400
	_        [2028]byte
	ADDRSIZE volatile.Register32    // 0x1FEC
	IPNAME   [2]volatile.Register32 // 0x1FF0
	FEATURES volatile.Register32    // 0x1FF8
	VERSION  volatile.Register32    // 0x1FFC
}

// LCDC.LCDCFG0: LCD Controller Configuration Register 0
func (o *LCDC_Type) SetLCDCFG0_CLKPOL(value uint32) {
	volatile.StoreUint32(&o.LCDCFG0.Reg, volatile.LoadUint32(&o.LCDCFG0.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetLCDCFG0_CLKPOL() uint32 {
	return volatile.LoadUint32(&o.LCDCFG0.Reg) & 0x1
}
func (o *LCDC_Type) SetLCDCFG0_CLKSEL(value uint32) {
	volatile.StoreUint32(&o.LCDCFG0.Reg, volatile.LoadUint32(&o.LCDCFG0.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetLCDCFG0_CLKSEL() uint32 {
	return (volatile.LoadUint32(&o.LCDCFG0.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetLCDCFG0_CLKPWMSEL(value uint32) {
	volatile.StoreUint32(&o.LCDCFG0.Reg, volatile.LoadUint32(&o.LCDCFG0.Reg)&^(0x8)|value<<3)
}
func (o *LCDC_Type) GetLCDCFG0_CLKPWMSEL() uint32 {
	return (volatile.LoadUint32(&o.LCDCFG0.Reg) & 0x8) >> 3
}
func (o *LCDC_Type) SetLCDCFG0_CGDISBASE(value uint32) {
	volatile.StoreUint32(&o.LCDCFG0.Reg, volatile.LoadUint32(&o.LCDCFG0.Reg)&^(0x100)|value<<8)
}
func (o *LCDC_Type) GetLCDCFG0_CGDISBASE() uint32 {
	return (volatile.LoadUint32(&o.LCDCFG0.Reg) & 0x100) >> 8
}
func (o *LCDC_Type) SetLCDCFG0_CGDISOVR1(value uint32) {
	volatile.StoreUint32(&o.LCDCFG0.Reg, volatile.LoadUint32(&o.LCDCFG0.Reg)&^(0x200)|value<<9)
}
func (o *LCDC_Type) GetLCDCFG0_CGDISOVR1() uint32 {
	return (volatile.LoadUint32(&o.LCDCFG0.Reg) & 0x200) >> 9
}
func (o *LCDC_Type) SetLCDCFG0_CGDISHEO(value uint32) {
	volatile.StoreUint32(&o.LCDCFG0.Reg, volatile.LoadUint32(&o.LCDCFG0.Reg)&^(0x800)|value<<11)
}
func (o *LCDC_Type) GetLCDCFG0_CGDISHEO() uint32 {
	return (volatile.LoadUint32(&o.LCDCFG0.Reg) & 0x800) >> 11
}
func (o *LCDC_Type) SetLCDCFG0_CGDISHCR(value uint32) {
	volatile.StoreUint32(&o.LCDCFG0.Reg, volatile.LoadUint32(&o.LCDCFG0.Reg)&^(0x1000)|value<<12)
}
func (o *LCDC_Type) GetLCDCFG0_CGDISHCR() uint32 {
	return (volatile.LoadUint32(&o.LCDCFG0.Reg) & 0x1000) >> 12
}
func (o *LCDC_Type) SetLCDCFG0_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.LCDCFG0.Reg, volatile.LoadUint32(&o.LCDCFG0.Reg)&^(0xff0000)|value<<16)
}
func (o *LCDC_Type) GetLCDCFG0_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.LCDCFG0.Reg) & 0xff0000) >> 16
}

// LCDC.LCDCFG1: LCD Controller Configuration Register 1
func (o *LCDC_Type) SetLCDCFG1_HSPW(value uint32) {
	volatile.StoreUint32(&o.LCDCFG1.Reg, volatile.LoadUint32(&o.LCDCFG1.Reg)&^(0x3f)|value)
}
func (o *LCDC_Type) GetLCDCFG1_HSPW() uint32 {
	return volatile.LoadUint32(&o.LCDCFG1.Reg) & 0x3f
}
func (o *LCDC_Type) SetLCDCFG1_VSPW(value uint32) {
	volatile.StoreUint32(&o.LCDCFG1.Reg, volatile.LoadUint32(&o.LCDCFG1.Reg)&^(0x3f0000)|value<<16)
}
func (o *LCDC_Type) GetLCDCFG1_VSPW() uint32 {
	return (volatile.LoadUint32(&o.LCDCFG1.Reg) & 0x3f0000) >> 16
}

// LCDC.LCDCFG2: LCD Controller Configuration Register 2
func (o *LCDC_Type) SetLCDCFG2_VFPW(value uint32) {
	volatile.StoreUint32(&o.LCDCFG2.Reg, volatile.LoadUint32(&o.LCDCFG2.Reg)&^(0x3f)|value)
}
func (o *LCDC_Type) GetLCDCFG2_VFPW() uint32 {
	return volatile.LoadUint32(&o.LCDCFG2.Reg) & 0x3f
}
func (o *LCDC_Type) SetLCDCFG2_VBPW(value uint32) {
	volatile.StoreUint32(&o.LCDCFG2.Reg, volatile.LoadUint32(&o.LCDCFG2.Reg)&^(0x3f0000)|value<<16)
}
func (o *LCDC_Type) GetLCDCFG2_VBPW() uint32 {
	return (volatile.LoadUint32(&o.LCDCFG2.Reg) & 0x3f0000) >> 16
}

// LCDC.LCDCFG3: LCD Controller Configuration Register 3
func (o *LCDC_Type) SetLCDCFG3_HFPW(value uint32) {
	volatile.StoreUint32(&o.LCDCFG3.Reg, volatile.LoadUint32(&o.LCDCFG3.Reg)&^(0xff)|value)
}
func (o *LCDC_Type) GetLCDCFG3_HFPW() uint32 {
	return volatile.LoadUint32(&o.LCDCFG3.Reg) & 0xff
}
func (o *LCDC_Type) SetLCDCFG3_HBPW(value uint32) {
	volatile.StoreUint32(&o.LCDCFG3.Reg, volatile.LoadUint32(&o.LCDCFG3.Reg)&^(0xff0000)|value<<16)
}
func (o *LCDC_Type) GetLCDCFG3_HBPW() uint32 {
	return (volatile.LoadUint32(&o.LCDCFG3.Reg) & 0xff0000) >> 16
}

// LCDC.LCDCFG4: LCD Controller Configuration Register 4
func (o *LCDC_Type) SetLCDCFG4_PPL(value uint32) {
	volatile.StoreUint32(&o.LCDCFG4.Reg, volatile.LoadUint32(&o.LCDCFG4.Reg)&^(0x7ff)|value)
}
func (o *LCDC_Type) GetLCDCFG4_PPL() uint32 {
	return volatile.LoadUint32(&o.LCDCFG4.Reg) & 0x7ff
}
func (o *LCDC_Type) SetLCDCFG4_RPF(value uint32) {
	volatile.StoreUint32(&o.LCDCFG4.Reg, volatile.LoadUint32(&o.LCDCFG4.Reg)&^(0x7ff0000)|value<<16)
}
func (o *LCDC_Type) GetLCDCFG4_RPF() uint32 {
	return (volatile.LoadUint32(&o.LCDCFG4.Reg) & 0x7ff0000) >> 16
}

// LCDC.LCDCFG5: LCD Controller Configuration Register 5
func (o *LCDC_Type) SetLCDCFG5_HSPOL(value uint32) {
	volatile.StoreUint32(&o.LCDCFG5.Reg, volatile.LoadUint32(&o.LCDCFG5.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetLCDCFG5_HSPOL() uint32 {
	return volatile.LoadUint32(&o.LCDCFG5.Reg) & 0x1
}
func (o *LCDC_Type) SetLCDCFG5_VSPOL(value uint32) {
	volatile.StoreUint32(&o.LCDCFG5.Reg, volatile.LoadUint32(&o.LCDCFG5.Reg)&^(0x2)|value<<1)
}
func (o *LCDC_Type) GetLCDCFG5_VSPOL() uint32 {
	return (volatile.LoadUint32(&o.LCDCFG5.Reg) & 0x2) >> 1
}
func (o *LCDC_Type) SetLCDCFG5_VSPDLYS(value uint32) {
	volatile.StoreUint32(&o.LCDCFG5.Reg, volatile.LoadUint32(&o.LCDCFG5.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetLCDCFG5_VSPDLYS() uint32 {
	return (volatile.LoadUint32(&o.LCDCFG5.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetLCDCFG5_VSPDLYE(value uint32) {
	volatile.StoreUint32(&o.LCDCFG5.Reg, volatile.LoadUint32(&o.LCDCFG5.Reg)&^(0x8)|value<<3)
}
func (o *LCDC_Type) GetLCDCFG5_VSPDLYE() uint32 {
	return (volatile.LoadUint32(&o.LCDCFG5.Reg) & 0x8) >> 3
}
func (o *LCDC_Type) SetLCDCFG5_DISPPOL(value uint32) {
	volatile.StoreUint32(&o.LCDCFG5.Reg, volatile.LoadUint32(&o.LCDCFG5.Reg)&^(0x10)|value<<4)
}
func (o *LCDC_Type) GetLCDCFG5_DISPPOL() uint32 {
	return (volatile.LoadUint32(&o.LCDCFG5.Reg) & 0x10) >> 4
}
func (o *LCDC_Type) SetLCDCFG5_DITHER(value uint32) {
	volatile.StoreUint32(&o.LCDCFG5.Reg, volatile.LoadUint32(&o.LCDCFG5.Reg)&^(0x40)|value<<6)
}
func (o *LCDC_Type) GetLCDCFG5_DITHER() uint32 {
	return (volatile.LoadUint32(&o.LCDCFG5.Reg) & 0x40) >> 6
}
func (o *LCDC_Type) SetLCDCFG5_DISPDLY(value uint32) {
	volatile.StoreUint32(&o.LCDCFG5.Reg, volatile.LoadUint32(&o.LCDCFG5.Reg)&^(0x80)|value<<7)
}
func (o *LCDC_Type) GetLCDCFG5_DISPDLY() uint32 {
	return (volatile.LoadUint32(&o.LCDCFG5.Reg) & 0x80) >> 7
}
func (o *LCDC_Type) SetLCDCFG5_MODE(value uint32) {
	volatile.StoreUint32(&o.LCDCFG5.Reg, volatile.LoadUint32(&o.LCDCFG5.Reg)&^(0x300)|value<<8)
}
func (o *LCDC_Type) GetLCDCFG5_MODE() uint32 {
	return (volatile.LoadUint32(&o.LCDCFG5.Reg) & 0x300) >> 8
}
func (o *LCDC_Type) SetLCDCFG5_VSPSU(value uint32) {
	volatile.StoreUint32(&o.LCDCFG5.Reg, volatile.LoadUint32(&o.LCDCFG5.Reg)&^(0x1000)|value<<12)
}
func (o *LCDC_Type) GetLCDCFG5_VSPSU() uint32 {
	return (volatile.LoadUint32(&o.LCDCFG5.Reg) & 0x1000) >> 12
}
func (o *LCDC_Type) SetLCDCFG5_VSPHO(value uint32) {
	volatile.StoreUint32(&o.LCDCFG5.Reg, volatile.LoadUint32(&o.LCDCFG5.Reg)&^(0x2000)|value<<13)
}
func (o *LCDC_Type) GetLCDCFG5_VSPHO() uint32 {
	return (volatile.LoadUint32(&o.LCDCFG5.Reg) & 0x2000) >> 13
}
func (o *LCDC_Type) SetLCDCFG5_GUARDTIME(value uint32) {
	volatile.StoreUint32(&o.LCDCFG5.Reg, volatile.LoadUint32(&o.LCDCFG5.Reg)&^(0x1f0000)|value<<16)
}
func (o *LCDC_Type) GetLCDCFG5_GUARDTIME() uint32 {
	return (volatile.LoadUint32(&o.LCDCFG5.Reg) & 0x1f0000) >> 16
}

// LCDC.LCDCFG6: LCD Controller Configuration Register 6
func (o *LCDC_Type) SetLCDCFG6_PWMPS(value uint32) {
	volatile.StoreUint32(&o.LCDCFG6.Reg, volatile.LoadUint32(&o.LCDCFG6.Reg)&^(0x7)|value)
}
func (o *LCDC_Type) GetLCDCFG6_PWMPS() uint32 {
	return volatile.LoadUint32(&o.LCDCFG6.Reg) & 0x7
}
func (o *LCDC_Type) SetLCDCFG6_PWMPOL(value uint32) {
	volatile.StoreUint32(&o.LCDCFG6.Reg, volatile.LoadUint32(&o.LCDCFG6.Reg)&^(0x10)|value<<4)
}
func (o *LCDC_Type) GetLCDCFG6_PWMPOL() uint32 {
	return (volatile.LoadUint32(&o.LCDCFG6.Reg) & 0x10) >> 4
}
func (o *LCDC_Type) SetLCDCFG6_PWMCVAL(value uint32) {
	volatile.StoreUint32(&o.LCDCFG6.Reg, volatile.LoadUint32(&o.LCDCFG6.Reg)&^(0xff00)|value<<8)
}
func (o *LCDC_Type) GetLCDCFG6_PWMCVAL() uint32 {
	return (volatile.LoadUint32(&o.LCDCFG6.Reg) & 0xff00) >> 8
}

// LCDC.LCDEN: LCD Controller Enable Register
func (o *LCDC_Type) SetLCDEN_CLKEN(value uint32) {
	volatile.StoreUint32(&o.LCDEN.Reg, volatile.LoadUint32(&o.LCDEN.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetLCDEN_CLKEN() uint32 {
	return volatile.LoadUint32(&o.LCDEN.Reg) & 0x1
}
func (o *LCDC_Type) SetLCDEN_SYNCEN(value uint32) {
	volatile.StoreUint32(&o.LCDEN.Reg, volatile.LoadUint32(&o.LCDEN.Reg)&^(0x2)|value<<1)
}
func (o *LCDC_Type) GetLCDEN_SYNCEN() uint32 {
	return (volatile.LoadUint32(&o.LCDEN.Reg) & 0x2) >> 1
}
func (o *LCDC_Type) SetLCDEN_DISPEN(value uint32) {
	volatile.StoreUint32(&o.LCDEN.Reg, volatile.LoadUint32(&o.LCDEN.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetLCDEN_DISPEN() uint32 {
	return (volatile.LoadUint32(&o.LCDEN.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetLCDEN_PWMEN(value uint32) {
	volatile.StoreUint32(&o.LCDEN.Reg, volatile.LoadUint32(&o.LCDEN.Reg)&^(0x8)|value<<3)
}
func (o *LCDC_Type) GetLCDEN_PWMEN() uint32 {
	return (volatile.LoadUint32(&o.LCDEN.Reg) & 0x8) >> 3
}

// LCDC.LCDDIS: LCD Controller Disable Register
func (o *LCDC_Type) SetLCDDIS_CLKDIS(value uint32) {
	volatile.StoreUint32(&o.LCDDIS.Reg, volatile.LoadUint32(&o.LCDDIS.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetLCDDIS_CLKDIS() uint32 {
	return volatile.LoadUint32(&o.LCDDIS.Reg) & 0x1
}
func (o *LCDC_Type) SetLCDDIS_SYNCDIS(value uint32) {
	volatile.StoreUint32(&o.LCDDIS.Reg, volatile.LoadUint32(&o.LCDDIS.Reg)&^(0x2)|value<<1)
}
func (o *LCDC_Type) GetLCDDIS_SYNCDIS() uint32 {
	return (volatile.LoadUint32(&o.LCDDIS.Reg) & 0x2) >> 1
}
func (o *LCDC_Type) SetLCDDIS_DISPDIS(value uint32) {
	volatile.StoreUint32(&o.LCDDIS.Reg, volatile.LoadUint32(&o.LCDDIS.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetLCDDIS_DISPDIS() uint32 {
	return (volatile.LoadUint32(&o.LCDDIS.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetLCDDIS_PWMDIS(value uint32) {
	volatile.StoreUint32(&o.LCDDIS.Reg, volatile.LoadUint32(&o.LCDDIS.Reg)&^(0x8)|value<<3)
}
func (o *LCDC_Type) GetLCDDIS_PWMDIS() uint32 {
	return (volatile.LoadUint32(&o.LCDDIS.Reg) & 0x8) >> 3
}
func (o *LCDC_Type) SetLCDDIS_CLKRST(value uint32) {
	volatile.StoreUint32(&o.LCDDIS.Reg, volatile.LoadUint32(&o.LCDDIS.Reg)&^(0x100)|value<<8)
}
func (o *LCDC_Type) GetLCDDIS_CLKRST() uint32 {
	return (volatile.LoadUint32(&o.LCDDIS.Reg) & 0x100) >> 8
}
func (o *LCDC_Type) SetLCDDIS_SYNCRST(value uint32) {
	volatile.StoreUint32(&o.LCDDIS.Reg, volatile.LoadUint32(&o.LCDDIS.Reg)&^(0x200)|value<<9)
}
func (o *LCDC_Type) GetLCDDIS_SYNCRST() uint32 {
	return (volatile.LoadUint32(&o.LCDDIS.Reg) & 0x200) >> 9
}
func (o *LCDC_Type) SetLCDDIS_DISPRST(value uint32) {
	volatile.StoreUint32(&o.LCDDIS.Reg, volatile.LoadUint32(&o.LCDDIS.Reg)&^(0x400)|value<<10)
}
func (o *LCDC_Type) GetLCDDIS_DISPRST() uint32 {
	return (volatile.LoadUint32(&o.LCDDIS.Reg) & 0x400) >> 10
}
func (o *LCDC_Type) SetLCDDIS_PWMRST(value uint32) {
	volatile.StoreUint32(&o.LCDDIS.Reg, volatile.LoadUint32(&o.LCDDIS.Reg)&^(0x800)|value<<11)
}
func (o *LCDC_Type) GetLCDDIS_PWMRST() uint32 {
	return (volatile.LoadUint32(&o.LCDDIS.Reg) & 0x800) >> 11
}

// LCDC.LCDSR: LCD Controller Status Register
func (o *LCDC_Type) SetLCDSR_CLKSTS(value uint32) {
	volatile.StoreUint32(&o.LCDSR.Reg, volatile.LoadUint32(&o.LCDSR.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetLCDSR_CLKSTS() uint32 {
	return volatile.LoadUint32(&o.LCDSR.Reg) & 0x1
}
func (o *LCDC_Type) SetLCDSR_LCDSTS(value uint32) {
	volatile.StoreUint32(&o.LCDSR.Reg, volatile.LoadUint32(&o.LCDSR.Reg)&^(0x2)|value<<1)
}
func (o *LCDC_Type) GetLCDSR_LCDSTS() uint32 {
	return (volatile.LoadUint32(&o.LCDSR.Reg) & 0x2) >> 1
}
func (o *LCDC_Type) SetLCDSR_DISPSTS(value uint32) {
	volatile.StoreUint32(&o.LCDSR.Reg, volatile.LoadUint32(&o.LCDSR.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetLCDSR_DISPSTS() uint32 {
	return (volatile.LoadUint32(&o.LCDSR.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetLCDSR_PWMSTS(value uint32) {
	volatile.StoreUint32(&o.LCDSR.Reg, volatile.LoadUint32(&o.LCDSR.Reg)&^(0x8)|value<<3)
}
func (o *LCDC_Type) GetLCDSR_PWMSTS() uint32 {
	return (volatile.LoadUint32(&o.LCDSR.Reg) & 0x8) >> 3
}
func (o *LCDC_Type) SetLCDSR_SIPSTS(value uint32) {
	volatile.StoreUint32(&o.LCDSR.Reg, volatile.LoadUint32(&o.LCDSR.Reg)&^(0x10)|value<<4)
}
func (o *LCDC_Type) GetLCDSR_SIPSTS() uint32 {
	return (volatile.LoadUint32(&o.LCDSR.Reg) & 0x10) >> 4
}

// LCDC.LCDIER: LCD Controller Interrupt Enable Register
func (o *LCDC_Type) SetLCDIER_SOFIE(value uint32) {
	volatile.StoreUint32(&o.LCDIER.Reg, volatile.LoadUint32(&o.LCDIER.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetLCDIER_SOFIE() uint32 {
	return volatile.LoadUint32(&o.LCDIER.Reg) & 0x1
}
func (o *LCDC_Type) SetLCDIER_DISIE(value uint32) {
	volatile.StoreUint32(&o.LCDIER.Reg, volatile.LoadUint32(&o.LCDIER.Reg)&^(0x2)|value<<1)
}
func (o *LCDC_Type) GetLCDIER_DISIE() uint32 {
	return (volatile.LoadUint32(&o.LCDIER.Reg) & 0x2) >> 1
}
func (o *LCDC_Type) SetLCDIER_DISPIE(value uint32) {
	volatile.StoreUint32(&o.LCDIER.Reg, volatile.LoadUint32(&o.LCDIER.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetLCDIER_DISPIE() uint32 {
	return (volatile.LoadUint32(&o.LCDIER.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetLCDIER_FIFOERRIE(value uint32) {
	volatile.StoreUint32(&o.LCDIER.Reg, volatile.LoadUint32(&o.LCDIER.Reg)&^(0x10)|value<<4)
}
func (o *LCDC_Type) GetLCDIER_FIFOERRIE() uint32 {
	return (volatile.LoadUint32(&o.LCDIER.Reg) & 0x10) >> 4
}
func (o *LCDC_Type) SetLCDIER_BASEIE(value uint32) {
	volatile.StoreUint32(&o.LCDIER.Reg, volatile.LoadUint32(&o.LCDIER.Reg)&^(0x100)|value<<8)
}
func (o *LCDC_Type) GetLCDIER_BASEIE() uint32 {
	return (volatile.LoadUint32(&o.LCDIER.Reg) & 0x100) >> 8
}
func (o *LCDC_Type) SetLCDIER_OVR1IE(value uint32) {
	volatile.StoreUint32(&o.LCDIER.Reg, volatile.LoadUint32(&o.LCDIER.Reg)&^(0x200)|value<<9)
}
func (o *LCDC_Type) GetLCDIER_OVR1IE() uint32 {
	return (volatile.LoadUint32(&o.LCDIER.Reg) & 0x200) >> 9
}
func (o *LCDC_Type) SetLCDIER_HEOIE(value uint32) {
	volatile.StoreUint32(&o.LCDIER.Reg, volatile.LoadUint32(&o.LCDIER.Reg)&^(0x400)|value<<10)
}
func (o *LCDC_Type) GetLCDIER_HEOIE() uint32 {
	return (volatile.LoadUint32(&o.LCDIER.Reg) & 0x400) >> 10
}
func (o *LCDC_Type) SetLCDIER_HCRIE(value uint32) {
	volatile.StoreUint32(&o.LCDIER.Reg, volatile.LoadUint32(&o.LCDIER.Reg)&^(0x800)|value<<11)
}
func (o *LCDC_Type) GetLCDIER_HCRIE() uint32 {
	return (volatile.LoadUint32(&o.LCDIER.Reg) & 0x800) >> 11
}

// LCDC.LCDIDR: LCD Controller Interrupt Disable Register
func (o *LCDC_Type) SetLCDIDR_SOFID(value uint32) {
	volatile.StoreUint32(&o.LCDIDR.Reg, volatile.LoadUint32(&o.LCDIDR.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetLCDIDR_SOFID() uint32 {
	return volatile.LoadUint32(&o.LCDIDR.Reg) & 0x1
}
func (o *LCDC_Type) SetLCDIDR_DISID(value uint32) {
	volatile.StoreUint32(&o.LCDIDR.Reg, volatile.LoadUint32(&o.LCDIDR.Reg)&^(0x2)|value<<1)
}
func (o *LCDC_Type) GetLCDIDR_DISID() uint32 {
	return (volatile.LoadUint32(&o.LCDIDR.Reg) & 0x2) >> 1
}
func (o *LCDC_Type) SetLCDIDR_DISPID(value uint32) {
	volatile.StoreUint32(&o.LCDIDR.Reg, volatile.LoadUint32(&o.LCDIDR.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetLCDIDR_DISPID() uint32 {
	return (volatile.LoadUint32(&o.LCDIDR.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetLCDIDR_FIFOERRID(value uint32) {
	volatile.StoreUint32(&o.LCDIDR.Reg, volatile.LoadUint32(&o.LCDIDR.Reg)&^(0x10)|value<<4)
}
func (o *LCDC_Type) GetLCDIDR_FIFOERRID() uint32 {
	return (volatile.LoadUint32(&o.LCDIDR.Reg) & 0x10) >> 4
}
func (o *LCDC_Type) SetLCDIDR_BASEID(value uint32) {
	volatile.StoreUint32(&o.LCDIDR.Reg, volatile.LoadUint32(&o.LCDIDR.Reg)&^(0x100)|value<<8)
}
func (o *LCDC_Type) GetLCDIDR_BASEID() uint32 {
	return (volatile.LoadUint32(&o.LCDIDR.Reg) & 0x100) >> 8
}
func (o *LCDC_Type) SetLCDIDR_OVR1ID(value uint32) {
	volatile.StoreUint32(&o.LCDIDR.Reg, volatile.LoadUint32(&o.LCDIDR.Reg)&^(0x200)|value<<9)
}
func (o *LCDC_Type) GetLCDIDR_OVR1ID() uint32 {
	return (volatile.LoadUint32(&o.LCDIDR.Reg) & 0x200) >> 9
}
func (o *LCDC_Type) SetLCDIDR_HEOID(value uint32) {
	volatile.StoreUint32(&o.LCDIDR.Reg, volatile.LoadUint32(&o.LCDIDR.Reg)&^(0x400)|value<<10)
}
func (o *LCDC_Type) GetLCDIDR_HEOID() uint32 {
	return (volatile.LoadUint32(&o.LCDIDR.Reg) & 0x400) >> 10
}
func (o *LCDC_Type) SetLCDIDR_HCRID(value uint32) {
	volatile.StoreUint32(&o.LCDIDR.Reg, volatile.LoadUint32(&o.LCDIDR.Reg)&^(0x800)|value<<11)
}
func (o *LCDC_Type) GetLCDIDR_HCRID() uint32 {
	return (volatile.LoadUint32(&o.LCDIDR.Reg) & 0x800) >> 11
}

// LCDC.LCDIMR: LCD Controller Interrupt Mask Register
func (o *LCDC_Type) SetLCDIMR_SOFIM(value uint32) {
	volatile.StoreUint32(&o.LCDIMR.Reg, volatile.LoadUint32(&o.LCDIMR.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetLCDIMR_SOFIM() uint32 {
	return volatile.LoadUint32(&o.LCDIMR.Reg) & 0x1
}
func (o *LCDC_Type) SetLCDIMR_DISIM(value uint32) {
	volatile.StoreUint32(&o.LCDIMR.Reg, volatile.LoadUint32(&o.LCDIMR.Reg)&^(0x2)|value<<1)
}
func (o *LCDC_Type) GetLCDIMR_DISIM() uint32 {
	return (volatile.LoadUint32(&o.LCDIMR.Reg) & 0x2) >> 1
}
func (o *LCDC_Type) SetLCDIMR_DISPIM(value uint32) {
	volatile.StoreUint32(&o.LCDIMR.Reg, volatile.LoadUint32(&o.LCDIMR.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetLCDIMR_DISPIM() uint32 {
	return (volatile.LoadUint32(&o.LCDIMR.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetLCDIMR_FIFOERRIM(value uint32) {
	volatile.StoreUint32(&o.LCDIMR.Reg, volatile.LoadUint32(&o.LCDIMR.Reg)&^(0x10)|value<<4)
}
func (o *LCDC_Type) GetLCDIMR_FIFOERRIM() uint32 {
	return (volatile.LoadUint32(&o.LCDIMR.Reg) & 0x10) >> 4
}
func (o *LCDC_Type) SetLCDIMR_BASEIM(value uint32) {
	volatile.StoreUint32(&o.LCDIMR.Reg, volatile.LoadUint32(&o.LCDIMR.Reg)&^(0x100)|value<<8)
}
func (o *LCDC_Type) GetLCDIMR_BASEIM() uint32 {
	return (volatile.LoadUint32(&o.LCDIMR.Reg) & 0x100) >> 8
}
func (o *LCDC_Type) SetLCDIMR_OVR1IM(value uint32) {
	volatile.StoreUint32(&o.LCDIMR.Reg, volatile.LoadUint32(&o.LCDIMR.Reg)&^(0x200)|value<<9)
}
func (o *LCDC_Type) GetLCDIMR_OVR1IM() uint32 {
	return (volatile.LoadUint32(&o.LCDIMR.Reg) & 0x200) >> 9
}
func (o *LCDC_Type) SetLCDIMR_HEOIM(value uint32) {
	volatile.StoreUint32(&o.LCDIMR.Reg, volatile.LoadUint32(&o.LCDIMR.Reg)&^(0x400)|value<<10)
}
func (o *LCDC_Type) GetLCDIMR_HEOIM() uint32 {
	return (volatile.LoadUint32(&o.LCDIMR.Reg) & 0x400) >> 10
}
func (o *LCDC_Type) SetLCDIMR_HCRIM(value uint32) {
	volatile.StoreUint32(&o.LCDIMR.Reg, volatile.LoadUint32(&o.LCDIMR.Reg)&^(0x800)|value<<11)
}
func (o *LCDC_Type) GetLCDIMR_HCRIM() uint32 {
	return (volatile.LoadUint32(&o.LCDIMR.Reg) & 0x800) >> 11
}

// LCDC.LCDISR: LCD Controller Interrupt Status Register
func (o *LCDC_Type) SetLCDISR_SOF(value uint32) {
	volatile.StoreUint32(&o.LCDISR.Reg, volatile.LoadUint32(&o.LCDISR.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetLCDISR_SOF() uint32 {
	return volatile.LoadUint32(&o.LCDISR.Reg) & 0x1
}
func (o *LCDC_Type) SetLCDISR_DIS(value uint32) {
	volatile.StoreUint32(&o.LCDISR.Reg, volatile.LoadUint32(&o.LCDISR.Reg)&^(0x2)|value<<1)
}
func (o *LCDC_Type) GetLCDISR_DIS() uint32 {
	return (volatile.LoadUint32(&o.LCDISR.Reg) & 0x2) >> 1
}
func (o *LCDC_Type) SetLCDISR_DISP(value uint32) {
	volatile.StoreUint32(&o.LCDISR.Reg, volatile.LoadUint32(&o.LCDISR.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetLCDISR_DISP() uint32 {
	return (volatile.LoadUint32(&o.LCDISR.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetLCDISR_FIFOERR(value uint32) {
	volatile.StoreUint32(&o.LCDISR.Reg, volatile.LoadUint32(&o.LCDISR.Reg)&^(0x10)|value<<4)
}
func (o *LCDC_Type) GetLCDISR_FIFOERR() uint32 {
	return (volatile.LoadUint32(&o.LCDISR.Reg) & 0x10) >> 4
}
func (o *LCDC_Type) SetLCDISR_BASE(value uint32) {
	volatile.StoreUint32(&o.LCDISR.Reg, volatile.LoadUint32(&o.LCDISR.Reg)&^(0x100)|value<<8)
}
func (o *LCDC_Type) GetLCDISR_BASE() uint32 {
	return (volatile.LoadUint32(&o.LCDISR.Reg) & 0x100) >> 8
}
func (o *LCDC_Type) SetLCDISR_OVR1(value uint32) {
	volatile.StoreUint32(&o.LCDISR.Reg, volatile.LoadUint32(&o.LCDISR.Reg)&^(0x200)|value<<9)
}
func (o *LCDC_Type) GetLCDISR_OVR1() uint32 {
	return (volatile.LoadUint32(&o.LCDISR.Reg) & 0x200) >> 9
}
func (o *LCDC_Type) SetLCDISR_HEO(value uint32) {
	volatile.StoreUint32(&o.LCDISR.Reg, volatile.LoadUint32(&o.LCDISR.Reg)&^(0x400)|value<<10)
}
func (o *LCDC_Type) GetLCDISR_HEO() uint32 {
	return (volatile.LoadUint32(&o.LCDISR.Reg) & 0x400) >> 10
}
func (o *LCDC_Type) SetLCDISR_HCR(value uint32) {
	volatile.StoreUint32(&o.LCDISR.Reg, volatile.LoadUint32(&o.LCDISR.Reg)&^(0x800)|value<<11)
}
func (o *LCDC_Type) GetLCDISR_HCR() uint32 {
	return (volatile.LoadUint32(&o.LCDISR.Reg) & 0x800) >> 11
}

// LCDC.BASECHER: Base Layer Channel Enable Register
func (o *LCDC_Type) SetBASECHER_CHEN(value uint32) {
	volatile.StoreUint32(&o.BASECHER.Reg, volatile.LoadUint32(&o.BASECHER.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetBASECHER_CHEN() uint32 {
	return volatile.LoadUint32(&o.BASECHER.Reg) & 0x1
}
func (o *LCDC_Type) SetBASECHER_UPDATEEN(value uint32) {
	volatile.StoreUint32(&o.BASECHER.Reg, volatile.LoadUint32(&o.BASECHER.Reg)&^(0x2)|value<<1)
}
func (o *LCDC_Type) GetBASECHER_UPDATEEN() uint32 {
	return (volatile.LoadUint32(&o.BASECHER.Reg) & 0x2) >> 1
}
func (o *LCDC_Type) SetBASECHER_A2QEN(value uint32) {
	volatile.StoreUint32(&o.BASECHER.Reg, volatile.LoadUint32(&o.BASECHER.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetBASECHER_A2QEN() uint32 {
	return (volatile.LoadUint32(&o.BASECHER.Reg) & 0x4) >> 2
}

// LCDC.BASECHDR: Base Layer Channel Disable Register
func (o *LCDC_Type) SetBASECHDR_CHDIS(value uint32) {
	volatile.StoreUint32(&o.BASECHDR.Reg, volatile.LoadUint32(&o.BASECHDR.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetBASECHDR_CHDIS() uint32 {
	return volatile.LoadUint32(&o.BASECHDR.Reg) & 0x1
}
func (o *LCDC_Type) SetBASECHDR_CHRST(value uint32) {
	volatile.StoreUint32(&o.BASECHDR.Reg, volatile.LoadUint32(&o.BASECHDR.Reg)&^(0x100)|value<<8)
}
func (o *LCDC_Type) GetBASECHDR_CHRST() uint32 {
	return (volatile.LoadUint32(&o.BASECHDR.Reg) & 0x100) >> 8
}

// LCDC.BASECHSR: Base Layer Channel Status Register
func (o *LCDC_Type) SetBASECHSR_CHSR(value uint32) {
	volatile.StoreUint32(&o.BASECHSR.Reg, volatile.LoadUint32(&o.BASECHSR.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetBASECHSR_CHSR() uint32 {
	return volatile.LoadUint32(&o.BASECHSR.Reg) & 0x1
}
func (o *LCDC_Type) SetBASECHSR_UPDATESR(value uint32) {
	volatile.StoreUint32(&o.BASECHSR.Reg, volatile.LoadUint32(&o.BASECHSR.Reg)&^(0x2)|value<<1)
}
func (o *LCDC_Type) GetBASECHSR_UPDATESR() uint32 {
	return (volatile.LoadUint32(&o.BASECHSR.Reg) & 0x2) >> 1
}
func (o *LCDC_Type) SetBASECHSR_A2QSR(value uint32) {
	volatile.StoreUint32(&o.BASECHSR.Reg, volatile.LoadUint32(&o.BASECHSR.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetBASECHSR_A2QSR() uint32 {
	return (volatile.LoadUint32(&o.BASECHSR.Reg) & 0x4) >> 2
}

// LCDC.BASEIER: Base Layer Interrupt Enable Register
func (o *LCDC_Type) SetBASEIER_DMA(value uint32) {
	volatile.StoreUint32(&o.BASEIER.Reg, volatile.LoadUint32(&o.BASEIER.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetBASEIER_DMA() uint32 {
	return (volatile.LoadUint32(&o.BASEIER.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetBASEIER_DSCR(value uint32) {
	volatile.StoreUint32(&o.BASEIER.Reg, volatile.LoadUint32(&o.BASEIER.Reg)&^(0x8)|value<<3)
}
func (o *LCDC_Type) GetBASEIER_DSCR() uint32 {
	return (volatile.LoadUint32(&o.BASEIER.Reg) & 0x8) >> 3
}
func (o *LCDC_Type) SetBASEIER_ADD(value uint32) {
	volatile.StoreUint32(&o.BASEIER.Reg, volatile.LoadUint32(&o.BASEIER.Reg)&^(0x10)|value<<4)
}
func (o *LCDC_Type) GetBASEIER_ADD() uint32 {
	return (volatile.LoadUint32(&o.BASEIER.Reg) & 0x10) >> 4
}
func (o *LCDC_Type) SetBASEIER_DONE(value uint32) {
	volatile.StoreUint32(&o.BASEIER.Reg, volatile.LoadUint32(&o.BASEIER.Reg)&^(0x20)|value<<5)
}
func (o *LCDC_Type) GetBASEIER_DONE() uint32 {
	return (volatile.LoadUint32(&o.BASEIER.Reg) & 0x20) >> 5
}
func (o *LCDC_Type) SetBASEIER_OVR(value uint32) {
	volatile.StoreUint32(&o.BASEIER.Reg, volatile.LoadUint32(&o.BASEIER.Reg)&^(0x40)|value<<6)
}
func (o *LCDC_Type) GetBASEIER_OVR() uint32 {
	return (volatile.LoadUint32(&o.BASEIER.Reg) & 0x40) >> 6
}

// LCDC.BASEIDR: Base Layer Interrupt Disabled Register
func (o *LCDC_Type) SetBASEIDR_DMA(value uint32) {
	volatile.StoreUint32(&o.BASEIDR.Reg, volatile.LoadUint32(&o.BASEIDR.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetBASEIDR_DMA() uint32 {
	return (volatile.LoadUint32(&o.BASEIDR.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetBASEIDR_DSCR(value uint32) {
	volatile.StoreUint32(&o.BASEIDR.Reg, volatile.LoadUint32(&o.BASEIDR.Reg)&^(0x8)|value<<3)
}
func (o *LCDC_Type) GetBASEIDR_DSCR() uint32 {
	return (volatile.LoadUint32(&o.BASEIDR.Reg) & 0x8) >> 3
}
func (o *LCDC_Type) SetBASEIDR_ADD(value uint32) {
	volatile.StoreUint32(&o.BASEIDR.Reg, volatile.LoadUint32(&o.BASEIDR.Reg)&^(0x10)|value<<4)
}
func (o *LCDC_Type) GetBASEIDR_ADD() uint32 {
	return (volatile.LoadUint32(&o.BASEIDR.Reg) & 0x10) >> 4
}
func (o *LCDC_Type) SetBASEIDR_DONE(value uint32) {
	volatile.StoreUint32(&o.BASEIDR.Reg, volatile.LoadUint32(&o.BASEIDR.Reg)&^(0x20)|value<<5)
}
func (o *LCDC_Type) GetBASEIDR_DONE() uint32 {
	return (volatile.LoadUint32(&o.BASEIDR.Reg) & 0x20) >> 5
}
func (o *LCDC_Type) SetBASEIDR_OVR(value uint32) {
	volatile.StoreUint32(&o.BASEIDR.Reg, volatile.LoadUint32(&o.BASEIDR.Reg)&^(0x40)|value<<6)
}
func (o *LCDC_Type) GetBASEIDR_OVR() uint32 {
	return (volatile.LoadUint32(&o.BASEIDR.Reg) & 0x40) >> 6
}

// LCDC.BASEIMR: Base Layer Interrupt Mask Register
func (o *LCDC_Type) SetBASEIMR_DMA(value uint32) {
	volatile.StoreUint32(&o.BASEIMR.Reg, volatile.LoadUint32(&o.BASEIMR.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetBASEIMR_DMA() uint32 {
	return (volatile.LoadUint32(&o.BASEIMR.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetBASEIMR_DSCR(value uint32) {
	volatile.StoreUint32(&o.BASEIMR.Reg, volatile.LoadUint32(&o.BASEIMR.Reg)&^(0x8)|value<<3)
}
func (o *LCDC_Type) GetBASEIMR_DSCR() uint32 {
	return (volatile.LoadUint32(&o.BASEIMR.Reg) & 0x8) >> 3
}
func (o *LCDC_Type) SetBASEIMR_ADD(value uint32) {
	volatile.StoreUint32(&o.BASEIMR.Reg, volatile.LoadUint32(&o.BASEIMR.Reg)&^(0x10)|value<<4)
}
func (o *LCDC_Type) GetBASEIMR_ADD() uint32 {
	return (volatile.LoadUint32(&o.BASEIMR.Reg) & 0x10) >> 4
}
func (o *LCDC_Type) SetBASEIMR_DONE(value uint32) {
	volatile.StoreUint32(&o.BASEIMR.Reg, volatile.LoadUint32(&o.BASEIMR.Reg)&^(0x20)|value<<5)
}
func (o *LCDC_Type) GetBASEIMR_DONE() uint32 {
	return (volatile.LoadUint32(&o.BASEIMR.Reg) & 0x20) >> 5
}
func (o *LCDC_Type) SetBASEIMR_OVR(value uint32) {
	volatile.StoreUint32(&o.BASEIMR.Reg, volatile.LoadUint32(&o.BASEIMR.Reg)&^(0x40)|value<<6)
}
func (o *LCDC_Type) GetBASEIMR_OVR() uint32 {
	return (volatile.LoadUint32(&o.BASEIMR.Reg) & 0x40) >> 6
}

// LCDC.BASEISR: Base Layer Interrupt status Register
func (o *LCDC_Type) SetBASEISR_DMA(value uint32) {
	volatile.StoreUint32(&o.BASEISR.Reg, volatile.LoadUint32(&o.BASEISR.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetBASEISR_DMA() uint32 {
	return (volatile.LoadUint32(&o.BASEISR.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetBASEISR_DSCR(value uint32) {
	volatile.StoreUint32(&o.BASEISR.Reg, volatile.LoadUint32(&o.BASEISR.Reg)&^(0x8)|value<<3)
}
func (o *LCDC_Type) GetBASEISR_DSCR() uint32 {
	return (volatile.LoadUint32(&o.BASEISR.Reg) & 0x8) >> 3
}
func (o *LCDC_Type) SetBASEISR_ADD(value uint32) {
	volatile.StoreUint32(&o.BASEISR.Reg, volatile.LoadUint32(&o.BASEISR.Reg)&^(0x10)|value<<4)
}
func (o *LCDC_Type) GetBASEISR_ADD() uint32 {
	return (volatile.LoadUint32(&o.BASEISR.Reg) & 0x10) >> 4
}
func (o *LCDC_Type) SetBASEISR_DONE(value uint32) {
	volatile.StoreUint32(&o.BASEISR.Reg, volatile.LoadUint32(&o.BASEISR.Reg)&^(0x20)|value<<5)
}
func (o *LCDC_Type) GetBASEISR_DONE() uint32 {
	return (volatile.LoadUint32(&o.BASEISR.Reg) & 0x20) >> 5
}
func (o *LCDC_Type) SetBASEISR_OVR(value uint32) {
	volatile.StoreUint32(&o.BASEISR.Reg, volatile.LoadUint32(&o.BASEISR.Reg)&^(0x40)|value<<6)
}
func (o *LCDC_Type) GetBASEISR_OVR() uint32 {
	return (volatile.LoadUint32(&o.BASEISR.Reg) & 0x40) >> 6
}

// LCDC.BASEHEAD: Base Layer DMA Head Register
func (o *LCDC_Type) SetBASEHEAD_HEAD(value uint32) {
	volatile.StoreUint32(&o.BASEHEAD.Reg, volatile.LoadUint32(&o.BASEHEAD.Reg)&^(0xfffffffc)|value<<2)
}
func (o *LCDC_Type) GetBASEHEAD_HEAD() uint32 {
	return (volatile.LoadUint32(&o.BASEHEAD.Reg) & 0xfffffffc) >> 2
}

// LCDC.BASEADDR: Base Layer DMA Address Register
func (o *LCDC_Type) SetBASEADDR(value uint32) {
	volatile.StoreUint32(&o.BASEADDR.Reg, value)
}
func (o *LCDC_Type) GetBASEADDR() uint32 {
	return volatile.LoadUint32(&o.BASEADDR.Reg)
}

// LCDC.BASECTRL: Base Layer DMA Control Register
func (o *LCDC_Type) SetBASECTRL_DFETCH(value uint32) {
	volatile.StoreUint32(&o.BASECTRL.Reg, volatile.LoadUint32(&o.BASECTRL.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetBASECTRL_DFETCH() uint32 {
	return volatile.LoadUint32(&o.BASECTRL.Reg) & 0x1
}
func (o *LCDC_Type) SetBASECTRL_LFETCH(value uint32) {
	volatile.StoreUint32(&o.BASECTRL.Reg, volatile.LoadUint32(&o.BASECTRL.Reg)&^(0x2)|value<<1)
}
func (o *LCDC_Type) GetBASECTRL_LFETCH() uint32 {
	return (volatile.LoadUint32(&o.BASECTRL.Reg) & 0x2) >> 1
}
func (o *LCDC_Type) SetBASECTRL_DMAIEN(value uint32) {
	volatile.StoreUint32(&o.BASECTRL.Reg, volatile.LoadUint32(&o.BASECTRL.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetBASECTRL_DMAIEN() uint32 {
	return (volatile.LoadUint32(&o.BASECTRL.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetBASECTRL_DSCRIEN(value uint32) {
	volatile.StoreUint32(&o.BASECTRL.Reg, volatile.LoadUint32(&o.BASECTRL.Reg)&^(0x8)|value<<3)
}
func (o *LCDC_Type) GetBASECTRL_DSCRIEN() uint32 {
	return (volatile.LoadUint32(&o.BASECTRL.Reg) & 0x8) >> 3
}
func (o *LCDC_Type) SetBASECTRL_ADDIEN(value uint32) {
	volatile.StoreUint32(&o.BASECTRL.Reg, volatile.LoadUint32(&o.BASECTRL.Reg)&^(0x10)|value<<4)
}
func (o *LCDC_Type) GetBASECTRL_ADDIEN() uint32 {
	return (volatile.LoadUint32(&o.BASECTRL.Reg) & 0x10) >> 4
}
func (o *LCDC_Type) SetBASECTRL_DONEIEN(value uint32) {
	volatile.StoreUint32(&o.BASECTRL.Reg, volatile.LoadUint32(&o.BASECTRL.Reg)&^(0x20)|value<<5)
}
func (o *LCDC_Type) GetBASECTRL_DONEIEN() uint32 {
	return (volatile.LoadUint32(&o.BASECTRL.Reg) & 0x20) >> 5
}

// LCDC.BASENEXT: Base Layer DMA Next Register
func (o *LCDC_Type) SetBASENEXT(value uint32) {
	volatile.StoreUint32(&o.BASENEXT.Reg, value)
}
func (o *LCDC_Type) GetBASENEXT() uint32 {
	return volatile.LoadUint32(&o.BASENEXT.Reg)
}

// LCDC.BASECFG0: Base Layer Configuration Register 0
func (o *LCDC_Type) SetBASECFG0_BLEN(value uint32) {
	volatile.StoreUint32(&o.BASECFG0.Reg, volatile.LoadUint32(&o.BASECFG0.Reg)&^(0x30)|value<<4)
}
func (o *LCDC_Type) GetBASECFG0_BLEN() uint32 {
	return (volatile.LoadUint32(&o.BASECFG0.Reg) & 0x30) >> 4
}
func (o *LCDC_Type) SetBASECFG0_DLBO(value uint32) {
	volatile.StoreUint32(&o.BASECFG0.Reg, volatile.LoadUint32(&o.BASECFG0.Reg)&^(0x100)|value<<8)
}
func (o *LCDC_Type) GetBASECFG0_DLBO() uint32 {
	return (volatile.LoadUint32(&o.BASECFG0.Reg) & 0x100) >> 8
}

// LCDC.BASECFG1: Base Layer Configuration Register 1
func (o *LCDC_Type) SetBASECFG1_CLUTEN(value uint32) {
	volatile.StoreUint32(&o.BASECFG1.Reg, volatile.LoadUint32(&o.BASECFG1.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetBASECFG1_CLUTEN() uint32 {
	return volatile.LoadUint32(&o.BASECFG1.Reg) & 0x1
}
func (o *LCDC_Type) SetBASECFG1_RGBMODE(value uint32) {
	volatile.StoreUint32(&o.BASECFG1.Reg, volatile.LoadUint32(&o.BASECFG1.Reg)&^(0xf0)|value<<4)
}
func (o *LCDC_Type) GetBASECFG1_RGBMODE() uint32 {
	return (volatile.LoadUint32(&o.BASECFG1.Reg) & 0xf0) >> 4
}
func (o *LCDC_Type) SetBASECFG1_CLUTMODE(value uint32) {
	volatile.StoreUint32(&o.BASECFG1.Reg, volatile.LoadUint32(&o.BASECFG1.Reg)&^(0x300)|value<<8)
}
func (o *LCDC_Type) GetBASECFG1_CLUTMODE() uint32 {
	return (volatile.LoadUint32(&o.BASECFG1.Reg) & 0x300) >> 8
}

// LCDC.BASECFG2: Base Layer Configuration Register 2
func (o *LCDC_Type) SetBASECFG2(value uint32) {
	volatile.StoreUint32(&o.BASECFG2.Reg, value)
}
func (o *LCDC_Type) GetBASECFG2() uint32 {
	return volatile.LoadUint32(&o.BASECFG2.Reg)
}

// LCDC.BASECFG3: Base Layer Configuration Register 3
func (o *LCDC_Type) SetBASECFG3_BDEF(value uint32) {
	volatile.StoreUint32(&o.BASECFG3.Reg, volatile.LoadUint32(&o.BASECFG3.Reg)&^(0xff)|value)
}
func (o *LCDC_Type) GetBASECFG3_BDEF() uint32 {
	return volatile.LoadUint32(&o.BASECFG3.Reg) & 0xff
}
func (o *LCDC_Type) SetBASECFG3_GDEF(value uint32) {
	volatile.StoreUint32(&o.BASECFG3.Reg, volatile.LoadUint32(&o.BASECFG3.Reg)&^(0xff00)|value<<8)
}
func (o *LCDC_Type) GetBASECFG3_GDEF() uint32 {
	return (volatile.LoadUint32(&o.BASECFG3.Reg) & 0xff00) >> 8
}
func (o *LCDC_Type) SetBASECFG3_RDEF(value uint32) {
	volatile.StoreUint32(&o.BASECFG3.Reg, volatile.LoadUint32(&o.BASECFG3.Reg)&^(0xff0000)|value<<16)
}
func (o *LCDC_Type) GetBASECFG3_RDEF() uint32 {
	return (volatile.LoadUint32(&o.BASECFG3.Reg) & 0xff0000) >> 16
}

// LCDC.BASECFG4: Base Layer Configuration Register 4
func (o *LCDC_Type) SetBASECFG4_DMA(value uint32) {
	volatile.StoreUint32(&o.BASECFG4.Reg, volatile.LoadUint32(&o.BASECFG4.Reg)&^(0x100)|value<<8)
}
func (o *LCDC_Type) GetBASECFG4_DMA() uint32 {
	return (volatile.LoadUint32(&o.BASECFG4.Reg) & 0x100) >> 8
}
func (o *LCDC_Type) SetBASECFG4_REP(value uint32) {
	volatile.StoreUint32(&o.BASECFG4.Reg, volatile.LoadUint32(&o.BASECFG4.Reg)&^(0x200)|value<<9)
}
func (o *LCDC_Type) GetBASECFG4_REP() uint32 {
	return (volatile.LoadUint32(&o.BASECFG4.Reg) & 0x200) >> 9
}

// LCDC.OVRCHER1: Overlay 1 Channel Enable Register
func (o *LCDC_Type) SetOVRCHER1_CHEN(value uint32) {
	volatile.StoreUint32(&o.OVRCHER1.Reg, volatile.LoadUint32(&o.OVRCHER1.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetOVRCHER1_CHEN() uint32 {
	return volatile.LoadUint32(&o.OVRCHER1.Reg) & 0x1
}
func (o *LCDC_Type) SetOVRCHER1_UPDATEEN(value uint32) {
	volatile.StoreUint32(&o.OVRCHER1.Reg, volatile.LoadUint32(&o.OVRCHER1.Reg)&^(0x2)|value<<1)
}
func (o *LCDC_Type) GetOVRCHER1_UPDATEEN() uint32 {
	return (volatile.LoadUint32(&o.OVRCHER1.Reg) & 0x2) >> 1
}
func (o *LCDC_Type) SetOVRCHER1_A2QEN(value uint32) {
	volatile.StoreUint32(&o.OVRCHER1.Reg, volatile.LoadUint32(&o.OVRCHER1.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetOVRCHER1_A2QEN() uint32 {
	return (volatile.LoadUint32(&o.OVRCHER1.Reg) & 0x4) >> 2
}

// LCDC.OVRCHDR1: Overlay 1 Channel Disable Register
func (o *LCDC_Type) SetOVRCHDR1_CHDIS(value uint32) {
	volatile.StoreUint32(&o.OVRCHDR1.Reg, volatile.LoadUint32(&o.OVRCHDR1.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetOVRCHDR1_CHDIS() uint32 {
	return volatile.LoadUint32(&o.OVRCHDR1.Reg) & 0x1
}
func (o *LCDC_Type) SetOVRCHDR1_CHRST(value uint32) {
	volatile.StoreUint32(&o.OVRCHDR1.Reg, volatile.LoadUint32(&o.OVRCHDR1.Reg)&^(0x100)|value<<8)
}
func (o *LCDC_Type) GetOVRCHDR1_CHRST() uint32 {
	return (volatile.LoadUint32(&o.OVRCHDR1.Reg) & 0x100) >> 8
}

// LCDC.OVRCHSR1: Overlay 1 Channel Status Register
func (o *LCDC_Type) SetOVRCHSR1_CHSR(value uint32) {
	volatile.StoreUint32(&o.OVRCHSR1.Reg, volatile.LoadUint32(&o.OVRCHSR1.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetOVRCHSR1_CHSR() uint32 {
	return volatile.LoadUint32(&o.OVRCHSR1.Reg) & 0x1
}
func (o *LCDC_Type) SetOVRCHSR1_UPDATESR(value uint32) {
	volatile.StoreUint32(&o.OVRCHSR1.Reg, volatile.LoadUint32(&o.OVRCHSR1.Reg)&^(0x2)|value<<1)
}
func (o *LCDC_Type) GetOVRCHSR1_UPDATESR() uint32 {
	return (volatile.LoadUint32(&o.OVRCHSR1.Reg) & 0x2) >> 1
}
func (o *LCDC_Type) SetOVRCHSR1_A2QSR(value uint32) {
	volatile.StoreUint32(&o.OVRCHSR1.Reg, volatile.LoadUint32(&o.OVRCHSR1.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetOVRCHSR1_A2QSR() uint32 {
	return (volatile.LoadUint32(&o.OVRCHSR1.Reg) & 0x4) >> 2
}

// LCDC.OVRIER1: Overlay 1 Interrupt Enable Register
func (o *LCDC_Type) SetOVRIER1_DMA(value uint32) {
	volatile.StoreUint32(&o.OVRIER1.Reg, volatile.LoadUint32(&o.OVRIER1.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetOVRIER1_DMA() uint32 {
	return (volatile.LoadUint32(&o.OVRIER1.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetOVRIER1_DSCR(value uint32) {
	volatile.StoreUint32(&o.OVRIER1.Reg, volatile.LoadUint32(&o.OVRIER1.Reg)&^(0x8)|value<<3)
}
func (o *LCDC_Type) GetOVRIER1_DSCR() uint32 {
	return (volatile.LoadUint32(&o.OVRIER1.Reg) & 0x8) >> 3
}
func (o *LCDC_Type) SetOVRIER1_ADD(value uint32) {
	volatile.StoreUint32(&o.OVRIER1.Reg, volatile.LoadUint32(&o.OVRIER1.Reg)&^(0x10)|value<<4)
}
func (o *LCDC_Type) GetOVRIER1_ADD() uint32 {
	return (volatile.LoadUint32(&o.OVRIER1.Reg) & 0x10) >> 4
}
func (o *LCDC_Type) SetOVRIER1_DONE(value uint32) {
	volatile.StoreUint32(&o.OVRIER1.Reg, volatile.LoadUint32(&o.OVRIER1.Reg)&^(0x20)|value<<5)
}
func (o *LCDC_Type) GetOVRIER1_DONE() uint32 {
	return (volatile.LoadUint32(&o.OVRIER1.Reg) & 0x20) >> 5
}
func (o *LCDC_Type) SetOVRIER1_OVR(value uint32) {
	volatile.StoreUint32(&o.OVRIER1.Reg, volatile.LoadUint32(&o.OVRIER1.Reg)&^(0x40)|value<<6)
}
func (o *LCDC_Type) GetOVRIER1_OVR() uint32 {
	return (volatile.LoadUint32(&o.OVRIER1.Reg) & 0x40) >> 6
}

// LCDC.OVRIDR1: Overlay 1 Interrupt Disable Register
func (o *LCDC_Type) SetOVRIDR1_DMA(value uint32) {
	volatile.StoreUint32(&o.OVRIDR1.Reg, volatile.LoadUint32(&o.OVRIDR1.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetOVRIDR1_DMA() uint32 {
	return (volatile.LoadUint32(&o.OVRIDR1.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetOVRIDR1_DSCR(value uint32) {
	volatile.StoreUint32(&o.OVRIDR1.Reg, volatile.LoadUint32(&o.OVRIDR1.Reg)&^(0x8)|value<<3)
}
func (o *LCDC_Type) GetOVRIDR1_DSCR() uint32 {
	return (volatile.LoadUint32(&o.OVRIDR1.Reg) & 0x8) >> 3
}
func (o *LCDC_Type) SetOVRIDR1_ADD(value uint32) {
	volatile.StoreUint32(&o.OVRIDR1.Reg, volatile.LoadUint32(&o.OVRIDR1.Reg)&^(0x10)|value<<4)
}
func (o *LCDC_Type) GetOVRIDR1_ADD() uint32 {
	return (volatile.LoadUint32(&o.OVRIDR1.Reg) & 0x10) >> 4
}
func (o *LCDC_Type) SetOVRIDR1_DONE(value uint32) {
	volatile.StoreUint32(&o.OVRIDR1.Reg, volatile.LoadUint32(&o.OVRIDR1.Reg)&^(0x20)|value<<5)
}
func (o *LCDC_Type) GetOVRIDR1_DONE() uint32 {
	return (volatile.LoadUint32(&o.OVRIDR1.Reg) & 0x20) >> 5
}
func (o *LCDC_Type) SetOVRIDR1_OVR(value uint32) {
	volatile.StoreUint32(&o.OVRIDR1.Reg, volatile.LoadUint32(&o.OVRIDR1.Reg)&^(0x40)|value<<6)
}
func (o *LCDC_Type) GetOVRIDR1_OVR() uint32 {
	return (volatile.LoadUint32(&o.OVRIDR1.Reg) & 0x40) >> 6
}

// LCDC.OVRIMR1: Overlay 1 Interrupt Mask Register
func (o *LCDC_Type) SetOVRIMR1_DMA(value uint32) {
	volatile.StoreUint32(&o.OVRIMR1.Reg, volatile.LoadUint32(&o.OVRIMR1.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetOVRIMR1_DMA() uint32 {
	return (volatile.LoadUint32(&o.OVRIMR1.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetOVRIMR1_DSCR(value uint32) {
	volatile.StoreUint32(&o.OVRIMR1.Reg, volatile.LoadUint32(&o.OVRIMR1.Reg)&^(0x8)|value<<3)
}
func (o *LCDC_Type) GetOVRIMR1_DSCR() uint32 {
	return (volatile.LoadUint32(&o.OVRIMR1.Reg) & 0x8) >> 3
}
func (o *LCDC_Type) SetOVRIMR1_ADD(value uint32) {
	volatile.StoreUint32(&o.OVRIMR1.Reg, volatile.LoadUint32(&o.OVRIMR1.Reg)&^(0x10)|value<<4)
}
func (o *LCDC_Type) GetOVRIMR1_ADD() uint32 {
	return (volatile.LoadUint32(&o.OVRIMR1.Reg) & 0x10) >> 4
}
func (o *LCDC_Type) SetOVRIMR1_DONE(value uint32) {
	volatile.StoreUint32(&o.OVRIMR1.Reg, volatile.LoadUint32(&o.OVRIMR1.Reg)&^(0x20)|value<<5)
}
func (o *LCDC_Type) GetOVRIMR1_DONE() uint32 {
	return (volatile.LoadUint32(&o.OVRIMR1.Reg) & 0x20) >> 5
}
func (o *LCDC_Type) SetOVRIMR1_OVR(value uint32) {
	volatile.StoreUint32(&o.OVRIMR1.Reg, volatile.LoadUint32(&o.OVRIMR1.Reg)&^(0x40)|value<<6)
}
func (o *LCDC_Type) GetOVRIMR1_OVR() uint32 {
	return (volatile.LoadUint32(&o.OVRIMR1.Reg) & 0x40) >> 6
}

// LCDC.OVRISR1: Overlay 1 Interrupt Status Register
func (o *LCDC_Type) SetOVRISR1_DMA(value uint32) {
	volatile.StoreUint32(&o.OVRISR1.Reg, volatile.LoadUint32(&o.OVRISR1.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetOVRISR1_DMA() uint32 {
	return (volatile.LoadUint32(&o.OVRISR1.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetOVRISR1_DSCR(value uint32) {
	volatile.StoreUint32(&o.OVRISR1.Reg, volatile.LoadUint32(&o.OVRISR1.Reg)&^(0x8)|value<<3)
}
func (o *LCDC_Type) GetOVRISR1_DSCR() uint32 {
	return (volatile.LoadUint32(&o.OVRISR1.Reg) & 0x8) >> 3
}
func (o *LCDC_Type) SetOVRISR1_ADD(value uint32) {
	volatile.StoreUint32(&o.OVRISR1.Reg, volatile.LoadUint32(&o.OVRISR1.Reg)&^(0x10)|value<<4)
}
func (o *LCDC_Type) GetOVRISR1_ADD() uint32 {
	return (volatile.LoadUint32(&o.OVRISR1.Reg) & 0x10) >> 4
}
func (o *LCDC_Type) SetOVRISR1_DONE(value uint32) {
	volatile.StoreUint32(&o.OVRISR1.Reg, volatile.LoadUint32(&o.OVRISR1.Reg)&^(0x20)|value<<5)
}
func (o *LCDC_Type) GetOVRISR1_DONE() uint32 {
	return (volatile.LoadUint32(&o.OVRISR1.Reg) & 0x20) >> 5
}
func (o *LCDC_Type) SetOVRISR1_OVR(value uint32) {
	volatile.StoreUint32(&o.OVRISR1.Reg, volatile.LoadUint32(&o.OVRISR1.Reg)&^(0x40)|value<<6)
}
func (o *LCDC_Type) GetOVRISR1_OVR() uint32 {
	return (volatile.LoadUint32(&o.OVRISR1.Reg) & 0x40) >> 6
}

// LCDC.OVRHEAD1: Overlay 1 DMA Head Register
func (o *LCDC_Type) SetOVRHEAD1_HEAD(value uint32) {
	volatile.StoreUint32(&o.OVRHEAD1.Reg, volatile.LoadUint32(&o.OVRHEAD1.Reg)&^(0xfffffffc)|value<<2)
}
func (o *LCDC_Type) GetOVRHEAD1_HEAD() uint32 {
	return (volatile.LoadUint32(&o.OVRHEAD1.Reg) & 0xfffffffc) >> 2
}

// LCDC.OVRADDR1: Overlay 1 DMA Address Register
func (o *LCDC_Type) SetOVRADDR1(value uint32) {
	volatile.StoreUint32(&o.OVRADDR1.Reg, value)
}
func (o *LCDC_Type) GetOVRADDR1() uint32 {
	return volatile.LoadUint32(&o.OVRADDR1.Reg)
}

// LCDC.OVRCTRL1: Overlay1 DMA Control Register
func (o *LCDC_Type) SetOVRCTRL1_DFETCH(value uint32) {
	volatile.StoreUint32(&o.OVRCTRL1.Reg, volatile.LoadUint32(&o.OVRCTRL1.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetOVRCTRL1_DFETCH() uint32 {
	return volatile.LoadUint32(&o.OVRCTRL1.Reg) & 0x1
}
func (o *LCDC_Type) SetOVRCTRL1_LFETCH(value uint32) {
	volatile.StoreUint32(&o.OVRCTRL1.Reg, volatile.LoadUint32(&o.OVRCTRL1.Reg)&^(0x2)|value<<1)
}
func (o *LCDC_Type) GetOVRCTRL1_LFETCH() uint32 {
	return (volatile.LoadUint32(&o.OVRCTRL1.Reg) & 0x2) >> 1
}
func (o *LCDC_Type) SetOVRCTRL1_DMAIEN(value uint32) {
	volatile.StoreUint32(&o.OVRCTRL1.Reg, volatile.LoadUint32(&o.OVRCTRL1.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetOVRCTRL1_DMAIEN() uint32 {
	return (volatile.LoadUint32(&o.OVRCTRL1.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetOVRCTRL1_DSCRIEN(value uint32) {
	volatile.StoreUint32(&o.OVRCTRL1.Reg, volatile.LoadUint32(&o.OVRCTRL1.Reg)&^(0x8)|value<<3)
}
func (o *LCDC_Type) GetOVRCTRL1_DSCRIEN() uint32 {
	return (volatile.LoadUint32(&o.OVRCTRL1.Reg) & 0x8) >> 3
}
func (o *LCDC_Type) SetOVRCTRL1_ADDIEN(value uint32) {
	volatile.StoreUint32(&o.OVRCTRL1.Reg, volatile.LoadUint32(&o.OVRCTRL1.Reg)&^(0x10)|value<<4)
}
func (o *LCDC_Type) GetOVRCTRL1_ADDIEN() uint32 {
	return (volatile.LoadUint32(&o.OVRCTRL1.Reg) & 0x10) >> 4
}
func (o *LCDC_Type) SetOVRCTRL1_DONEIEN(value uint32) {
	volatile.StoreUint32(&o.OVRCTRL1.Reg, volatile.LoadUint32(&o.OVRCTRL1.Reg)&^(0x20)|value<<5)
}
func (o *LCDC_Type) GetOVRCTRL1_DONEIEN() uint32 {
	return (volatile.LoadUint32(&o.OVRCTRL1.Reg) & 0x20) >> 5
}

// LCDC.OVRNEXT1: Overlay1 DMA Next Register
func (o *LCDC_Type) SetOVRNEXT1(value uint32) {
	volatile.StoreUint32(&o.OVRNEXT1.Reg, value)
}
func (o *LCDC_Type) GetOVRNEXT1() uint32 {
	return volatile.LoadUint32(&o.OVRNEXT1.Reg)
}

// LCDC.OVR1CFG0: Overlay 1 Configuration 0 Register
func (o *LCDC_Type) SetOVR1CFG0_BLEN(value uint32) {
	volatile.StoreUint32(&o.OVR1CFG0.Reg, volatile.LoadUint32(&o.OVR1CFG0.Reg)&^(0x30)|value<<4)
}
func (o *LCDC_Type) GetOVR1CFG0_BLEN() uint32 {
	return (volatile.LoadUint32(&o.OVR1CFG0.Reg) & 0x30) >> 4
}
func (o *LCDC_Type) SetOVR1CFG0_DLBO(value uint32) {
	volatile.StoreUint32(&o.OVR1CFG0.Reg, volatile.LoadUint32(&o.OVR1CFG0.Reg)&^(0x100)|value<<8)
}
func (o *LCDC_Type) GetOVR1CFG0_DLBO() uint32 {
	return (volatile.LoadUint32(&o.OVR1CFG0.Reg) & 0x100) >> 8
}
func (o *LCDC_Type) SetOVR1CFG0_ROTDIS(value uint32) {
	volatile.StoreUint32(&o.OVR1CFG0.Reg, volatile.LoadUint32(&o.OVR1CFG0.Reg)&^(0x1000)|value<<12)
}
func (o *LCDC_Type) GetOVR1CFG0_ROTDIS() uint32 {
	return (volatile.LoadUint32(&o.OVR1CFG0.Reg) & 0x1000) >> 12
}
func (o *LCDC_Type) SetOVR1CFG0_LOCKDIS(value uint32) {
	volatile.StoreUint32(&o.OVR1CFG0.Reg, volatile.LoadUint32(&o.OVR1CFG0.Reg)&^(0x2000)|value<<13)
}
func (o *LCDC_Type) GetOVR1CFG0_LOCKDIS() uint32 {
	return (volatile.LoadUint32(&o.OVR1CFG0.Reg) & 0x2000) >> 13
}

// LCDC.OVR1CFG1: Overlay 1 Configuration 1 Register
func (o *LCDC_Type) SetOVR1CFG1_CLUTEN(value uint32) {
	volatile.StoreUint32(&o.OVR1CFG1.Reg, volatile.LoadUint32(&o.OVR1CFG1.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetOVR1CFG1_CLUTEN() uint32 {
	return volatile.LoadUint32(&o.OVR1CFG1.Reg) & 0x1
}
func (o *LCDC_Type) SetOVR1CFG1_RGBMODE(value uint32) {
	volatile.StoreUint32(&o.OVR1CFG1.Reg, volatile.LoadUint32(&o.OVR1CFG1.Reg)&^(0xf0)|value<<4)
}
func (o *LCDC_Type) GetOVR1CFG1_RGBMODE() uint32 {
	return (volatile.LoadUint32(&o.OVR1CFG1.Reg) & 0xf0) >> 4
}
func (o *LCDC_Type) SetOVR1CFG1_CLUTMODE(value uint32) {
	volatile.StoreUint32(&o.OVR1CFG1.Reg, volatile.LoadUint32(&o.OVR1CFG1.Reg)&^(0x300)|value<<8)
}
func (o *LCDC_Type) GetOVR1CFG1_CLUTMODE() uint32 {
	return (volatile.LoadUint32(&o.OVR1CFG1.Reg) & 0x300) >> 8
}

// LCDC.OVR1CFG2: Overlay 1 Configuration 2 Register
func (o *LCDC_Type) SetOVR1CFG2_XPOS(value uint32) {
	volatile.StoreUint32(&o.OVR1CFG2.Reg, volatile.LoadUint32(&o.OVR1CFG2.Reg)&^(0x7ff)|value)
}
func (o *LCDC_Type) GetOVR1CFG2_XPOS() uint32 {
	return volatile.LoadUint32(&o.OVR1CFG2.Reg) & 0x7ff
}
func (o *LCDC_Type) SetOVR1CFG2_YPOS(value uint32) {
	volatile.StoreUint32(&o.OVR1CFG2.Reg, volatile.LoadUint32(&o.OVR1CFG2.Reg)&^(0x7ff0000)|value<<16)
}
func (o *LCDC_Type) GetOVR1CFG2_YPOS() uint32 {
	return (volatile.LoadUint32(&o.OVR1CFG2.Reg) & 0x7ff0000) >> 16
}

// LCDC.OVR1CFG3: Overlay 1 Configuration 3 Register
func (o *LCDC_Type) SetOVR1CFG3_XSIZE(value uint32) {
	volatile.StoreUint32(&o.OVR1CFG3.Reg, volatile.LoadUint32(&o.OVR1CFG3.Reg)&^(0x7ff)|value)
}
func (o *LCDC_Type) GetOVR1CFG3_XSIZE() uint32 {
	return volatile.LoadUint32(&o.OVR1CFG3.Reg) & 0x7ff
}
func (o *LCDC_Type) SetOVR1CFG3_YSIZE(value uint32) {
	volatile.StoreUint32(&o.OVR1CFG3.Reg, volatile.LoadUint32(&o.OVR1CFG3.Reg)&^(0x7ff0000)|value<<16)
}
func (o *LCDC_Type) GetOVR1CFG3_YSIZE() uint32 {
	return (volatile.LoadUint32(&o.OVR1CFG3.Reg) & 0x7ff0000) >> 16
}

// LCDC.OVR1CFG4: Overlay 1 Configuration 4 Register
func (o *LCDC_Type) SetOVR1CFG4(value uint32) {
	volatile.StoreUint32(&o.OVR1CFG4.Reg, value)
}
func (o *LCDC_Type) GetOVR1CFG4() uint32 {
	return volatile.LoadUint32(&o.OVR1CFG4.Reg)
}

// LCDC.OVR1CFG5: Overlay 1 Configuration 5 Register
func (o *LCDC_Type) SetOVR1CFG5(value uint32) {
	volatile.StoreUint32(&o.OVR1CFG5.Reg, value)
}
func (o *LCDC_Type) GetOVR1CFG5() uint32 {
	return volatile.LoadUint32(&o.OVR1CFG5.Reg)
}

// LCDC.OVR1CFG6: Overlay 1 Configuration 6 Register
func (o *LCDC_Type) SetOVR1CFG6_BDEF(value uint32) {
	volatile.StoreUint32(&o.OVR1CFG6.Reg, volatile.LoadUint32(&o.OVR1CFG6.Reg)&^(0xff)|value)
}
func (o *LCDC_Type) GetOVR1CFG6_BDEF() uint32 {
	return volatile.LoadUint32(&o.OVR1CFG6.Reg) & 0xff
}
func (o *LCDC_Type) SetOVR1CFG6_GDEF(value uint32) {
	volatile.StoreUint32(&o.OVR1CFG6.Reg, volatile.LoadUint32(&o.OVR1CFG6.Reg)&^(0xff00)|value<<8)
}
func (o *LCDC_Type) GetOVR1CFG6_GDEF() uint32 {
	return (volatile.LoadUint32(&o.OVR1CFG6.Reg) & 0xff00) >> 8
}
func (o *LCDC_Type) SetOVR1CFG6_RDEF(value uint32) {
	volatile.StoreUint32(&o.OVR1CFG6.Reg, volatile.LoadUint32(&o.OVR1CFG6.Reg)&^(0xff0000)|value<<16)
}
func (o *LCDC_Type) GetOVR1CFG6_RDEF() uint32 {
	return (volatile.LoadUint32(&o.OVR1CFG6.Reg) & 0xff0000) >> 16
}

// LCDC.OVR1CFG7: Overlay 1 Configuration 7 Register
func (o *LCDC_Type) SetOVR1CFG7_BKEY(value uint32) {
	volatile.StoreUint32(&o.OVR1CFG7.Reg, volatile.LoadUint32(&o.OVR1CFG7.Reg)&^(0xff)|value)
}
func (o *LCDC_Type) GetOVR1CFG7_BKEY() uint32 {
	return volatile.LoadUint32(&o.OVR1CFG7.Reg) & 0xff
}
func (o *LCDC_Type) SetOVR1CFG7_GKEY(value uint32) {
	volatile.StoreUint32(&o.OVR1CFG7.Reg, volatile.LoadUint32(&o.OVR1CFG7.Reg)&^(0xff00)|value<<8)
}
func (o *LCDC_Type) GetOVR1CFG7_GKEY() uint32 {
	return (volatile.LoadUint32(&o.OVR1CFG7.Reg) & 0xff00) >> 8
}
func (o *LCDC_Type) SetOVR1CFG7_RKEY(value uint32) {
	volatile.StoreUint32(&o.OVR1CFG7.Reg, volatile.LoadUint32(&o.OVR1CFG7.Reg)&^(0xff0000)|value<<16)
}
func (o *LCDC_Type) GetOVR1CFG7_RKEY() uint32 {
	return (volatile.LoadUint32(&o.OVR1CFG7.Reg) & 0xff0000) >> 16
}

// LCDC.OVR1CFG8: Overlay 1 Configuration 8 Register
func (o *LCDC_Type) SetOVR1CFG8_BMASK(value uint32) {
	volatile.StoreUint32(&o.OVR1CFG8.Reg, volatile.LoadUint32(&o.OVR1CFG8.Reg)&^(0xff)|value)
}
func (o *LCDC_Type) GetOVR1CFG8_BMASK() uint32 {
	return volatile.LoadUint32(&o.OVR1CFG8.Reg) & 0xff
}
func (o *LCDC_Type) SetOVR1CFG8_GMASK(value uint32) {
	volatile.StoreUint32(&o.OVR1CFG8.Reg, volatile.LoadUint32(&o.OVR1CFG8.Reg)&^(0xff00)|value<<8)
}
func (o *LCDC_Type) GetOVR1CFG8_GMASK() uint32 {
	return (volatile.LoadUint32(&o.OVR1CFG8.Reg) & 0xff00) >> 8
}
func (o *LCDC_Type) SetOVR1CFG8_RMASK(value uint32) {
	volatile.StoreUint32(&o.OVR1CFG8.Reg, volatile.LoadUint32(&o.OVR1CFG8.Reg)&^(0xff0000)|value<<16)
}
func (o *LCDC_Type) GetOVR1CFG8_RMASK() uint32 {
	return (volatile.LoadUint32(&o.OVR1CFG8.Reg) & 0xff0000) >> 16
}

// LCDC.OVR1CFG9: Overlay 1 Configuration 9 Register
func (o *LCDC_Type) SetOVR1CFG9_CRKEY(value uint32) {
	volatile.StoreUint32(&o.OVR1CFG9.Reg, volatile.LoadUint32(&o.OVR1CFG9.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetOVR1CFG9_CRKEY() uint32 {
	return volatile.LoadUint32(&o.OVR1CFG9.Reg) & 0x1
}
func (o *LCDC_Type) SetOVR1CFG9_INV(value uint32) {
	volatile.StoreUint32(&o.OVR1CFG9.Reg, volatile.LoadUint32(&o.OVR1CFG9.Reg)&^(0x2)|value<<1)
}
func (o *LCDC_Type) GetOVR1CFG9_INV() uint32 {
	return (volatile.LoadUint32(&o.OVR1CFG9.Reg) & 0x2) >> 1
}
func (o *LCDC_Type) SetOVR1CFG9_ITER2BL(value uint32) {
	volatile.StoreUint32(&o.OVR1CFG9.Reg, volatile.LoadUint32(&o.OVR1CFG9.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetOVR1CFG9_ITER2BL() uint32 {
	return (volatile.LoadUint32(&o.OVR1CFG9.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetOVR1CFG9_ITER(value uint32) {
	volatile.StoreUint32(&o.OVR1CFG9.Reg, volatile.LoadUint32(&o.OVR1CFG9.Reg)&^(0x8)|value<<3)
}
func (o *LCDC_Type) GetOVR1CFG9_ITER() uint32 {
	return (volatile.LoadUint32(&o.OVR1CFG9.Reg) & 0x8) >> 3
}
func (o *LCDC_Type) SetOVR1CFG9_REVALPHA(value uint32) {
	volatile.StoreUint32(&o.OVR1CFG9.Reg, volatile.LoadUint32(&o.OVR1CFG9.Reg)&^(0x10)|value<<4)
}
func (o *LCDC_Type) GetOVR1CFG9_REVALPHA() uint32 {
	return (volatile.LoadUint32(&o.OVR1CFG9.Reg) & 0x10) >> 4
}
func (o *LCDC_Type) SetOVR1CFG9_GAEN(value uint32) {
	volatile.StoreUint32(&o.OVR1CFG9.Reg, volatile.LoadUint32(&o.OVR1CFG9.Reg)&^(0x20)|value<<5)
}
func (o *LCDC_Type) GetOVR1CFG9_GAEN() uint32 {
	return (volatile.LoadUint32(&o.OVR1CFG9.Reg) & 0x20) >> 5
}
func (o *LCDC_Type) SetOVR1CFG9_LAEN(value uint32) {
	volatile.StoreUint32(&o.OVR1CFG9.Reg, volatile.LoadUint32(&o.OVR1CFG9.Reg)&^(0x40)|value<<6)
}
func (o *LCDC_Type) GetOVR1CFG9_LAEN() uint32 {
	return (volatile.LoadUint32(&o.OVR1CFG9.Reg) & 0x40) >> 6
}
func (o *LCDC_Type) SetOVR1CFG9_OVR(value uint32) {
	volatile.StoreUint32(&o.OVR1CFG9.Reg, volatile.LoadUint32(&o.OVR1CFG9.Reg)&^(0x80)|value<<7)
}
func (o *LCDC_Type) GetOVR1CFG9_OVR() uint32 {
	return (volatile.LoadUint32(&o.OVR1CFG9.Reg) & 0x80) >> 7
}
func (o *LCDC_Type) SetOVR1CFG9_DMA(value uint32) {
	volatile.StoreUint32(&o.OVR1CFG9.Reg, volatile.LoadUint32(&o.OVR1CFG9.Reg)&^(0x100)|value<<8)
}
func (o *LCDC_Type) GetOVR1CFG9_DMA() uint32 {
	return (volatile.LoadUint32(&o.OVR1CFG9.Reg) & 0x100) >> 8
}
func (o *LCDC_Type) SetOVR1CFG9_REP(value uint32) {
	volatile.StoreUint32(&o.OVR1CFG9.Reg, volatile.LoadUint32(&o.OVR1CFG9.Reg)&^(0x200)|value<<9)
}
func (o *LCDC_Type) GetOVR1CFG9_REP() uint32 {
	return (volatile.LoadUint32(&o.OVR1CFG9.Reg) & 0x200) >> 9
}
func (o *LCDC_Type) SetOVR1CFG9_DSTKEY(value uint32) {
	volatile.StoreUint32(&o.OVR1CFG9.Reg, volatile.LoadUint32(&o.OVR1CFG9.Reg)&^(0x400)|value<<10)
}
func (o *LCDC_Type) GetOVR1CFG9_DSTKEY() uint32 {
	return (volatile.LoadUint32(&o.OVR1CFG9.Reg) & 0x400) >> 10
}
func (o *LCDC_Type) SetOVR1CFG9_GA(value uint32) {
	volatile.StoreUint32(&o.OVR1CFG9.Reg, volatile.LoadUint32(&o.OVR1CFG9.Reg)&^(0xff0000)|value<<16)
}
func (o *LCDC_Type) GetOVR1CFG9_GA() uint32 {
	return (volatile.LoadUint32(&o.OVR1CFG9.Reg) & 0xff0000) >> 16
}

// LCDC.HEOCHER: High End Overlay Channel Enable Register
func (o *LCDC_Type) SetHEOCHER_CHEN(value uint32) {
	volatile.StoreUint32(&o.HEOCHER.Reg, volatile.LoadUint32(&o.HEOCHER.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetHEOCHER_CHEN() uint32 {
	return volatile.LoadUint32(&o.HEOCHER.Reg) & 0x1
}
func (o *LCDC_Type) SetHEOCHER_UPDATEEN(value uint32) {
	volatile.StoreUint32(&o.HEOCHER.Reg, volatile.LoadUint32(&o.HEOCHER.Reg)&^(0x2)|value<<1)
}
func (o *LCDC_Type) GetHEOCHER_UPDATEEN() uint32 {
	return (volatile.LoadUint32(&o.HEOCHER.Reg) & 0x2) >> 1
}
func (o *LCDC_Type) SetHEOCHER_A2QEN(value uint32) {
	volatile.StoreUint32(&o.HEOCHER.Reg, volatile.LoadUint32(&o.HEOCHER.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetHEOCHER_A2QEN() uint32 {
	return (volatile.LoadUint32(&o.HEOCHER.Reg) & 0x4) >> 2
}

// LCDC.HEOCHDR: High End Overlay Channel Disable Register
func (o *LCDC_Type) SetHEOCHDR_CHDIS(value uint32) {
	volatile.StoreUint32(&o.HEOCHDR.Reg, volatile.LoadUint32(&o.HEOCHDR.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetHEOCHDR_CHDIS() uint32 {
	return volatile.LoadUint32(&o.HEOCHDR.Reg) & 0x1
}
func (o *LCDC_Type) SetHEOCHDR_CHRST(value uint32) {
	volatile.StoreUint32(&o.HEOCHDR.Reg, volatile.LoadUint32(&o.HEOCHDR.Reg)&^(0x100)|value<<8)
}
func (o *LCDC_Type) GetHEOCHDR_CHRST() uint32 {
	return (volatile.LoadUint32(&o.HEOCHDR.Reg) & 0x100) >> 8
}

// LCDC.HEOCHSR: High End Overlay Channel Status Register
func (o *LCDC_Type) SetHEOCHSR_CHSR(value uint32) {
	volatile.StoreUint32(&o.HEOCHSR.Reg, volatile.LoadUint32(&o.HEOCHSR.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetHEOCHSR_CHSR() uint32 {
	return volatile.LoadUint32(&o.HEOCHSR.Reg) & 0x1
}
func (o *LCDC_Type) SetHEOCHSR_UPDATESR(value uint32) {
	volatile.StoreUint32(&o.HEOCHSR.Reg, volatile.LoadUint32(&o.HEOCHSR.Reg)&^(0x2)|value<<1)
}
func (o *LCDC_Type) GetHEOCHSR_UPDATESR() uint32 {
	return (volatile.LoadUint32(&o.HEOCHSR.Reg) & 0x2) >> 1
}
func (o *LCDC_Type) SetHEOCHSR_A2QSR(value uint32) {
	volatile.StoreUint32(&o.HEOCHSR.Reg, volatile.LoadUint32(&o.HEOCHSR.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetHEOCHSR_A2QSR() uint32 {
	return (volatile.LoadUint32(&o.HEOCHSR.Reg) & 0x4) >> 2
}

// LCDC.HEOIER: High End Overlay Interrupt Enable Register
func (o *LCDC_Type) SetHEOIER_DMA(value uint32) {
	volatile.StoreUint32(&o.HEOIER.Reg, volatile.LoadUint32(&o.HEOIER.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetHEOIER_DMA() uint32 {
	return (volatile.LoadUint32(&o.HEOIER.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetHEOIER_DSCR(value uint32) {
	volatile.StoreUint32(&o.HEOIER.Reg, volatile.LoadUint32(&o.HEOIER.Reg)&^(0x8)|value<<3)
}
func (o *LCDC_Type) GetHEOIER_DSCR() uint32 {
	return (volatile.LoadUint32(&o.HEOIER.Reg) & 0x8) >> 3
}
func (o *LCDC_Type) SetHEOIER_ADD(value uint32) {
	volatile.StoreUint32(&o.HEOIER.Reg, volatile.LoadUint32(&o.HEOIER.Reg)&^(0x10)|value<<4)
}
func (o *LCDC_Type) GetHEOIER_ADD() uint32 {
	return (volatile.LoadUint32(&o.HEOIER.Reg) & 0x10) >> 4
}
func (o *LCDC_Type) SetHEOIER_DONE(value uint32) {
	volatile.StoreUint32(&o.HEOIER.Reg, volatile.LoadUint32(&o.HEOIER.Reg)&^(0x20)|value<<5)
}
func (o *LCDC_Type) GetHEOIER_DONE() uint32 {
	return (volatile.LoadUint32(&o.HEOIER.Reg) & 0x20) >> 5
}
func (o *LCDC_Type) SetHEOIER_OVR(value uint32) {
	volatile.StoreUint32(&o.HEOIER.Reg, volatile.LoadUint32(&o.HEOIER.Reg)&^(0x40)|value<<6)
}
func (o *LCDC_Type) GetHEOIER_OVR() uint32 {
	return (volatile.LoadUint32(&o.HEOIER.Reg) & 0x40) >> 6
}
func (o *LCDC_Type) SetHEOIER_UDMA(value uint32) {
	volatile.StoreUint32(&o.HEOIER.Reg, volatile.LoadUint32(&o.HEOIER.Reg)&^(0x400)|value<<10)
}
func (o *LCDC_Type) GetHEOIER_UDMA() uint32 {
	return (volatile.LoadUint32(&o.HEOIER.Reg) & 0x400) >> 10
}
func (o *LCDC_Type) SetHEOIER_UDSCR(value uint32) {
	volatile.StoreUint32(&o.HEOIER.Reg, volatile.LoadUint32(&o.HEOIER.Reg)&^(0x800)|value<<11)
}
func (o *LCDC_Type) GetHEOIER_UDSCR() uint32 {
	return (volatile.LoadUint32(&o.HEOIER.Reg) & 0x800) >> 11
}
func (o *LCDC_Type) SetHEOIER_UADD(value uint32) {
	volatile.StoreUint32(&o.HEOIER.Reg, volatile.LoadUint32(&o.HEOIER.Reg)&^(0x1000)|value<<12)
}
func (o *LCDC_Type) GetHEOIER_UADD() uint32 {
	return (volatile.LoadUint32(&o.HEOIER.Reg) & 0x1000) >> 12
}
func (o *LCDC_Type) SetHEOIER_UDONE(value uint32) {
	volatile.StoreUint32(&o.HEOIER.Reg, volatile.LoadUint32(&o.HEOIER.Reg)&^(0x2000)|value<<13)
}
func (o *LCDC_Type) GetHEOIER_UDONE() uint32 {
	return (volatile.LoadUint32(&o.HEOIER.Reg) & 0x2000) >> 13
}
func (o *LCDC_Type) SetHEOIER_UOVR(value uint32) {
	volatile.StoreUint32(&o.HEOIER.Reg, volatile.LoadUint32(&o.HEOIER.Reg)&^(0x4000)|value<<14)
}
func (o *LCDC_Type) GetHEOIER_UOVR() uint32 {
	return (volatile.LoadUint32(&o.HEOIER.Reg) & 0x4000) >> 14
}
func (o *LCDC_Type) SetHEOIER_VDMA(value uint32) {
	volatile.StoreUint32(&o.HEOIER.Reg, volatile.LoadUint32(&o.HEOIER.Reg)&^(0x40000)|value<<18)
}
func (o *LCDC_Type) GetHEOIER_VDMA() uint32 {
	return (volatile.LoadUint32(&o.HEOIER.Reg) & 0x40000) >> 18
}
func (o *LCDC_Type) SetHEOIER_VDSCR(value uint32) {
	volatile.StoreUint32(&o.HEOIER.Reg, volatile.LoadUint32(&o.HEOIER.Reg)&^(0x80000)|value<<19)
}
func (o *LCDC_Type) GetHEOIER_VDSCR() uint32 {
	return (volatile.LoadUint32(&o.HEOIER.Reg) & 0x80000) >> 19
}
func (o *LCDC_Type) SetHEOIER_VADD(value uint32) {
	volatile.StoreUint32(&o.HEOIER.Reg, volatile.LoadUint32(&o.HEOIER.Reg)&^(0x100000)|value<<20)
}
func (o *LCDC_Type) GetHEOIER_VADD() uint32 {
	return (volatile.LoadUint32(&o.HEOIER.Reg) & 0x100000) >> 20
}
func (o *LCDC_Type) SetHEOIER_VDONE(value uint32) {
	volatile.StoreUint32(&o.HEOIER.Reg, volatile.LoadUint32(&o.HEOIER.Reg)&^(0x200000)|value<<21)
}
func (o *LCDC_Type) GetHEOIER_VDONE() uint32 {
	return (volatile.LoadUint32(&o.HEOIER.Reg) & 0x200000) >> 21
}
func (o *LCDC_Type) SetHEOIER_VOVR(value uint32) {
	volatile.StoreUint32(&o.HEOIER.Reg, volatile.LoadUint32(&o.HEOIER.Reg)&^(0x400000)|value<<22)
}
func (o *LCDC_Type) GetHEOIER_VOVR() uint32 {
	return (volatile.LoadUint32(&o.HEOIER.Reg) & 0x400000) >> 22
}

// LCDC.HEOIDR: High End Overlay Interrupt Disable Register
func (o *LCDC_Type) SetHEOIDR_DMA(value uint32) {
	volatile.StoreUint32(&o.HEOIDR.Reg, volatile.LoadUint32(&o.HEOIDR.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetHEOIDR_DMA() uint32 {
	return (volatile.LoadUint32(&o.HEOIDR.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetHEOIDR_DSCR(value uint32) {
	volatile.StoreUint32(&o.HEOIDR.Reg, volatile.LoadUint32(&o.HEOIDR.Reg)&^(0x8)|value<<3)
}
func (o *LCDC_Type) GetHEOIDR_DSCR() uint32 {
	return (volatile.LoadUint32(&o.HEOIDR.Reg) & 0x8) >> 3
}
func (o *LCDC_Type) SetHEOIDR_ADD(value uint32) {
	volatile.StoreUint32(&o.HEOIDR.Reg, volatile.LoadUint32(&o.HEOIDR.Reg)&^(0x10)|value<<4)
}
func (o *LCDC_Type) GetHEOIDR_ADD() uint32 {
	return (volatile.LoadUint32(&o.HEOIDR.Reg) & 0x10) >> 4
}
func (o *LCDC_Type) SetHEOIDR_DONE(value uint32) {
	volatile.StoreUint32(&o.HEOIDR.Reg, volatile.LoadUint32(&o.HEOIDR.Reg)&^(0x20)|value<<5)
}
func (o *LCDC_Type) GetHEOIDR_DONE() uint32 {
	return (volatile.LoadUint32(&o.HEOIDR.Reg) & 0x20) >> 5
}
func (o *LCDC_Type) SetHEOIDR_OVR(value uint32) {
	volatile.StoreUint32(&o.HEOIDR.Reg, volatile.LoadUint32(&o.HEOIDR.Reg)&^(0x40)|value<<6)
}
func (o *LCDC_Type) GetHEOIDR_OVR() uint32 {
	return (volatile.LoadUint32(&o.HEOIDR.Reg) & 0x40) >> 6
}
func (o *LCDC_Type) SetHEOIDR_UDMA(value uint32) {
	volatile.StoreUint32(&o.HEOIDR.Reg, volatile.LoadUint32(&o.HEOIDR.Reg)&^(0x400)|value<<10)
}
func (o *LCDC_Type) GetHEOIDR_UDMA() uint32 {
	return (volatile.LoadUint32(&o.HEOIDR.Reg) & 0x400) >> 10
}
func (o *LCDC_Type) SetHEOIDR_UDSCR(value uint32) {
	volatile.StoreUint32(&o.HEOIDR.Reg, volatile.LoadUint32(&o.HEOIDR.Reg)&^(0x800)|value<<11)
}
func (o *LCDC_Type) GetHEOIDR_UDSCR() uint32 {
	return (volatile.LoadUint32(&o.HEOIDR.Reg) & 0x800) >> 11
}
func (o *LCDC_Type) SetHEOIDR_UADD(value uint32) {
	volatile.StoreUint32(&o.HEOIDR.Reg, volatile.LoadUint32(&o.HEOIDR.Reg)&^(0x1000)|value<<12)
}
func (o *LCDC_Type) GetHEOIDR_UADD() uint32 {
	return (volatile.LoadUint32(&o.HEOIDR.Reg) & 0x1000) >> 12
}
func (o *LCDC_Type) SetHEOIDR_UDONE(value uint32) {
	volatile.StoreUint32(&o.HEOIDR.Reg, volatile.LoadUint32(&o.HEOIDR.Reg)&^(0x2000)|value<<13)
}
func (o *LCDC_Type) GetHEOIDR_UDONE() uint32 {
	return (volatile.LoadUint32(&o.HEOIDR.Reg) & 0x2000) >> 13
}
func (o *LCDC_Type) SetHEOIDR_UOVR(value uint32) {
	volatile.StoreUint32(&o.HEOIDR.Reg, volatile.LoadUint32(&o.HEOIDR.Reg)&^(0x4000)|value<<14)
}
func (o *LCDC_Type) GetHEOIDR_UOVR() uint32 {
	return (volatile.LoadUint32(&o.HEOIDR.Reg) & 0x4000) >> 14
}
func (o *LCDC_Type) SetHEOIDR_VDMA(value uint32) {
	volatile.StoreUint32(&o.HEOIDR.Reg, volatile.LoadUint32(&o.HEOIDR.Reg)&^(0x40000)|value<<18)
}
func (o *LCDC_Type) GetHEOIDR_VDMA() uint32 {
	return (volatile.LoadUint32(&o.HEOIDR.Reg) & 0x40000) >> 18
}
func (o *LCDC_Type) SetHEOIDR_VDSCR(value uint32) {
	volatile.StoreUint32(&o.HEOIDR.Reg, volatile.LoadUint32(&o.HEOIDR.Reg)&^(0x80000)|value<<19)
}
func (o *LCDC_Type) GetHEOIDR_VDSCR() uint32 {
	return (volatile.LoadUint32(&o.HEOIDR.Reg) & 0x80000) >> 19
}
func (o *LCDC_Type) SetHEOIDR_VADD(value uint32) {
	volatile.StoreUint32(&o.HEOIDR.Reg, volatile.LoadUint32(&o.HEOIDR.Reg)&^(0x100000)|value<<20)
}
func (o *LCDC_Type) GetHEOIDR_VADD() uint32 {
	return (volatile.LoadUint32(&o.HEOIDR.Reg) & 0x100000) >> 20
}
func (o *LCDC_Type) SetHEOIDR_VDONE(value uint32) {
	volatile.StoreUint32(&o.HEOIDR.Reg, volatile.LoadUint32(&o.HEOIDR.Reg)&^(0x200000)|value<<21)
}
func (o *LCDC_Type) GetHEOIDR_VDONE() uint32 {
	return (volatile.LoadUint32(&o.HEOIDR.Reg) & 0x200000) >> 21
}
func (o *LCDC_Type) SetHEOIDR_VOVR(value uint32) {
	volatile.StoreUint32(&o.HEOIDR.Reg, volatile.LoadUint32(&o.HEOIDR.Reg)&^(0x400000)|value<<22)
}
func (o *LCDC_Type) GetHEOIDR_VOVR() uint32 {
	return (volatile.LoadUint32(&o.HEOIDR.Reg) & 0x400000) >> 22
}

// LCDC.HEOIMR: High End Overlay Interrupt Mask Register
func (o *LCDC_Type) SetHEOIMR_DMA(value uint32) {
	volatile.StoreUint32(&o.HEOIMR.Reg, volatile.LoadUint32(&o.HEOIMR.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetHEOIMR_DMA() uint32 {
	return (volatile.LoadUint32(&o.HEOIMR.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetHEOIMR_DSCR(value uint32) {
	volatile.StoreUint32(&o.HEOIMR.Reg, volatile.LoadUint32(&o.HEOIMR.Reg)&^(0x8)|value<<3)
}
func (o *LCDC_Type) GetHEOIMR_DSCR() uint32 {
	return (volatile.LoadUint32(&o.HEOIMR.Reg) & 0x8) >> 3
}
func (o *LCDC_Type) SetHEOIMR_ADD(value uint32) {
	volatile.StoreUint32(&o.HEOIMR.Reg, volatile.LoadUint32(&o.HEOIMR.Reg)&^(0x10)|value<<4)
}
func (o *LCDC_Type) GetHEOIMR_ADD() uint32 {
	return (volatile.LoadUint32(&o.HEOIMR.Reg) & 0x10) >> 4
}
func (o *LCDC_Type) SetHEOIMR_DONE(value uint32) {
	volatile.StoreUint32(&o.HEOIMR.Reg, volatile.LoadUint32(&o.HEOIMR.Reg)&^(0x20)|value<<5)
}
func (o *LCDC_Type) GetHEOIMR_DONE() uint32 {
	return (volatile.LoadUint32(&o.HEOIMR.Reg) & 0x20) >> 5
}
func (o *LCDC_Type) SetHEOIMR_OVR(value uint32) {
	volatile.StoreUint32(&o.HEOIMR.Reg, volatile.LoadUint32(&o.HEOIMR.Reg)&^(0x40)|value<<6)
}
func (o *LCDC_Type) GetHEOIMR_OVR() uint32 {
	return (volatile.LoadUint32(&o.HEOIMR.Reg) & 0x40) >> 6
}
func (o *LCDC_Type) SetHEOIMR_UDMA(value uint32) {
	volatile.StoreUint32(&o.HEOIMR.Reg, volatile.LoadUint32(&o.HEOIMR.Reg)&^(0x400)|value<<10)
}
func (o *LCDC_Type) GetHEOIMR_UDMA() uint32 {
	return (volatile.LoadUint32(&o.HEOIMR.Reg) & 0x400) >> 10
}
func (o *LCDC_Type) SetHEOIMR_UDSCR(value uint32) {
	volatile.StoreUint32(&o.HEOIMR.Reg, volatile.LoadUint32(&o.HEOIMR.Reg)&^(0x800)|value<<11)
}
func (o *LCDC_Type) GetHEOIMR_UDSCR() uint32 {
	return (volatile.LoadUint32(&o.HEOIMR.Reg) & 0x800) >> 11
}
func (o *LCDC_Type) SetHEOIMR_UADD(value uint32) {
	volatile.StoreUint32(&o.HEOIMR.Reg, volatile.LoadUint32(&o.HEOIMR.Reg)&^(0x1000)|value<<12)
}
func (o *LCDC_Type) GetHEOIMR_UADD() uint32 {
	return (volatile.LoadUint32(&o.HEOIMR.Reg) & 0x1000) >> 12
}
func (o *LCDC_Type) SetHEOIMR_UDONE(value uint32) {
	volatile.StoreUint32(&o.HEOIMR.Reg, volatile.LoadUint32(&o.HEOIMR.Reg)&^(0x2000)|value<<13)
}
func (o *LCDC_Type) GetHEOIMR_UDONE() uint32 {
	return (volatile.LoadUint32(&o.HEOIMR.Reg) & 0x2000) >> 13
}
func (o *LCDC_Type) SetHEOIMR_UOVR(value uint32) {
	volatile.StoreUint32(&o.HEOIMR.Reg, volatile.LoadUint32(&o.HEOIMR.Reg)&^(0x4000)|value<<14)
}
func (o *LCDC_Type) GetHEOIMR_UOVR() uint32 {
	return (volatile.LoadUint32(&o.HEOIMR.Reg) & 0x4000) >> 14
}
func (o *LCDC_Type) SetHEOIMR_VDMA(value uint32) {
	volatile.StoreUint32(&o.HEOIMR.Reg, volatile.LoadUint32(&o.HEOIMR.Reg)&^(0x40000)|value<<18)
}
func (o *LCDC_Type) GetHEOIMR_VDMA() uint32 {
	return (volatile.LoadUint32(&o.HEOIMR.Reg) & 0x40000) >> 18
}
func (o *LCDC_Type) SetHEOIMR_VDSCR(value uint32) {
	volatile.StoreUint32(&o.HEOIMR.Reg, volatile.LoadUint32(&o.HEOIMR.Reg)&^(0x80000)|value<<19)
}
func (o *LCDC_Type) GetHEOIMR_VDSCR() uint32 {
	return (volatile.LoadUint32(&o.HEOIMR.Reg) & 0x80000) >> 19
}
func (o *LCDC_Type) SetHEOIMR_VADD(value uint32) {
	volatile.StoreUint32(&o.HEOIMR.Reg, volatile.LoadUint32(&o.HEOIMR.Reg)&^(0x100000)|value<<20)
}
func (o *LCDC_Type) GetHEOIMR_VADD() uint32 {
	return (volatile.LoadUint32(&o.HEOIMR.Reg) & 0x100000) >> 20
}
func (o *LCDC_Type) SetHEOIMR_VDONE(value uint32) {
	volatile.StoreUint32(&o.HEOIMR.Reg, volatile.LoadUint32(&o.HEOIMR.Reg)&^(0x200000)|value<<21)
}
func (o *LCDC_Type) GetHEOIMR_VDONE() uint32 {
	return (volatile.LoadUint32(&o.HEOIMR.Reg) & 0x200000) >> 21
}
func (o *LCDC_Type) SetHEOIMR_VOVR(value uint32) {
	volatile.StoreUint32(&o.HEOIMR.Reg, volatile.LoadUint32(&o.HEOIMR.Reg)&^(0x400000)|value<<22)
}
func (o *LCDC_Type) GetHEOIMR_VOVR() uint32 {
	return (volatile.LoadUint32(&o.HEOIMR.Reg) & 0x400000) >> 22
}

// LCDC.HEOISR: High End Overlay Interrupt Status Register
func (o *LCDC_Type) SetHEOISR_DMA(value uint32) {
	volatile.StoreUint32(&o.HEOISR.Reg, volatile.LoadUint32(&o.HEOISR.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetHEOISR_DMA() uint32 {
	return (volatile.LoadUint32(&o.HEOISR.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetHEOISR_DSCR(value uint32) {
	volatile.StoreUint32(&o.HEOISR.Reg, volatile.LoadUint32(&o.HEOISR.Reg)&^(0x8)|value<<3)
}
func (o *LCDC_Type) GetHEOISR_DSCR() uint32 {
	return (volatile.LoadUint32(&o.HEOISR.Reg) & 0x8) >> 3
}
func (o *LCDC_Type) SetHEOISR_ADD(value uint32) {
	volatile.StoreUint32(&o.HEOISR.Reg, volatile.LoadUint32(&o.HEOISR.Reg)&^(0x10)|value<<4)
}
func (o *LCDC_Type) GetHEOISR_ADD() uint32 {
	return (volatile.LoadUint32(&o.HEOISR.Reg) & 0x10) >> 4
}
func (o *LCDC_Type) SetHEOISR_DONE(value uint32) {
	volatile.StoreUint32(&o.HEOISR.Reg, volatile.LoadUint32(&o.HEOISR.Reg)&^(0x20)|value<<5)
}
func (o *LCDC_Type) GetHEOISR_DONE() uint32 {
	return (volatile.LoadUint32(&o.HEOISR.Reg) & 0x20) >> 5
}
func (o *LCDC_Type) SetHEOISR_OVR(value uint32) {
	volatile.StoreUint32(&o.HEOISR.Reg, volatile.LoadUint32(&o.HEOISR.Reg)&^(0x40)|value<<6)
}
func (o *LCDC_Type) GetHEOISR_OVR() uint32 {
	return (volatile.LoadUint32(&o.HEOISR.Reg) & 0x40) >> 6
}
func (o *LCDC_Type) SetHEOISR_UDMA(value uint32) {
	volatile.StoreUint32(&o.HEOISR.Reg, volatile.LoadUint32(&o.HEOISR.Reg)&^(0x400)|value<<10)
}
func (o *LCDC_Type) GetHEOISR_UDMA() uint32 {
	return (volatile.LoadUint32(&o.HEOISR.Reg) & 0x400) >> 10
}
func (o *LCDC_Type) SetHEOISR_UDSCR(value uint32) {
	volatile.StoreUint32(&o.HEOISR.Reg, volatile.LoadUint32(&o.HEOISR.Reg)&^(0x800)|value<<11)
}
func (o *LCDC_Type) GetHEOISR_UDSCR() uint32 {
	return (volatile.LoadUint32(&o.HEOISR.Reg) & 0x800) >> 11
}
func (o *LCDC_Type) SetHEOISR_UADD(value uint32) {
	volatile.StoreUint32(&o.HEOISR.Reg, volatile.LoadUint32(&o.HEOISR.Reg)&^(0x1000)|value<<12)
}
func (o *LCDC_Type) GetHEOISR_UADD() uint32 {
	return (volatile.LoadUint32(&o.HEOISR.Reg) & 0x1000) >> 12
}
func (o *LCDC_Type) SetHEOISR_UDONE(value uint32) {
	volatile.StoreUint32(&o.HEOISR.Reg, volatile.LoadUint32(&o.HEOISR.Reg)&^(0x2000)|value<<13)
}
func (o *LCDC_Type) GetHEOISR_UDONE() uint32 {
	return (volatile.LoadUint32(&o.HEOISR.Reg) & 0x2000) >> 13
}
func (o *LCDC_Type) SetHEOISR_UOVR(value uint32) {
	volatile.StoreUint32(&o.HEOISR.Reg, volatile.LoadUint32(&o.HEOISR.Reg)&^(0x4000)|value<<14)
}
func (o *LCDC_Type) GetHEOISR_UOVR() uint32 {
	return (volatile.LoadUint32(&o.HEOISR.Reg) & 0x4000) >> 14
}
func (o *LCDC_Type) SetHEOISR_VDMA(value uint32) {
	volatile.StoreUint32(&o.HEOISR.Reg, volatile.LoadUint32(&o.HEOISR.Reg)&^(0x40000)|value<<18)
}
func (o *LCDC_Type) GetHEOISR_VDMA() uint32 {
	return (volatile.LoadUint32(&o.HEOISR.Reg) & 0x40000) >> 18
}
func (o *LCDC_Type) SetHEOISR_VDSCR(value uint32) {
	volatile.StoreUint32(&o.HEOISR.Reg, volatile.LoadUint32(&o.HEOISR.Reg)&^(0x80000)|value<<19)
}
func (o *LCDC_Type) GetHEOISR_VDSCR() uint32 {
	return (volatile.LoadUint32(&o.HEOISR.Reg) & 0x80000) >> 19
}
func (o *LCDC_Type) SetHEOISR_VADD(value uint32) {
	volatile.StoreUint32(&o.HEOISR.Reg, volatile.LoadUint32(&o.HEOISR.Reg)&^(0x100000)|value<<20)
}
func (o *LCDC_Type) GetHEOISR_VADD() uint32 {
	return (volatile.LoadUint32(&o.HEOISR.Reg) & 0x100000) >> 20
}
func (o *LCDC_Type) SetHEOISR_VDONE(value uint32) {
	volatile.StoreUint32(&o.HEOISR.Reg, volatile.LoadUint32(&o.HEOISR.Reg)&^(0x200000)|value<<21)
}
func (o *LCDC_Type) GetHEOISR_VDONE() uint32 {
	return (volatile.LoadUint32(&o.HEOISR.Reg) & 0x200000) >> 21
}
func (o *LCDC_Type) SetHEOISR_VOVR(value uint32) {
	volatile.StoreUint32(&o.HEOISR.Reg, volatile.LoadUint32(&o.HEOISR.Reg)&^(0x400000)|value<<22)
}
func (o *LCDC_Type) GetHEOISR_VOVR() uint32 {
	return (volatile.LoadUint32(&o.HEOISR.Reg) & 0x400000) >> 22
}

// LCDC.HEOHEAD: High End Overlay DMA Head Register
func (o *LCDC_Type) SetHEOHEAD_HEAD(value uint32) {
	volatile.StoreUint32(&o.HEOHEAD.Reg, volatile.LoadUint32(&o.HEOHEAD.Reg)&^(0xfffffffc)|value<<2)
}
func (o *LCDC_Type) GetHEOHEAD_HEAD() uint32 {
	return (volatile.LoadUint32(&o.HEOHEAD.Reg) & 0xfffffffc) >> 2
}

// LCDC.HEOADDR: High End Overlay DMA Address Register
func (o *LCDC_Type) SetHEOADDR(value uint32) {
	volatile.StoreUint32(&o.HEOADDR.Reg, value)
}
func (o *LCDC_Type) GetHEOADDR() uint32 {
	return volatile.LoadUint32(&o.HEOADDR.Reg)
}

// LCDC.HEOCTRL: High End Overlay DMA Control Register
func (o *LCDC_Type) SetHEOCTRL_DFETCH(value uint32) {
	volatile.StoreUint32(&o.HEOCTRL.Reg, volatile.LoadUint32(&o.HEOCTRL.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetHEOCTRL_DFETCH() uint32 {
	return volatile.LoadUint32(&o.HEOCTRL.Reg) & 0x1
}
func (o *LCDC_Type) SetHEOCTRL_LFETCH(value uint32) {
	volatile.StoreUint32(&o.HEOCTRL.Reg, volatile.LoadUint32(&o.HEOCTRL.Reg)&^(0x2)|value<<1)
}
func (o *LCDC_Type) GetHEOCTRL_LFETCH() uint32 {
	return (volatile.LoadUint32(&o.HEOCTRL.Reg) & 0x2) >> 1
}
func (o *LCDC_Type) SetHEOCTRL_DMAIEN(value uint32) {
	volatile.StoreUint32(&o.HEOCTRL.Reg, volatile.LoadUint32(&o.HEOCTRL.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetHEOCTRL_DMAIEN() uint32 {
	return (volatile.LoadUint32(&o.HEOCTRL.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetHEOCTRL_DSCRIEN(value uint32) {
	volatile.StoreUint32(&o.HEOCTRL.Reg, volatile.LoadUint32(&o.HEOCTRL.Reg)&^(0x8)|value<<3)
}
func (o *LCDC_Type) GetHEOCTRL_DSCRIEN() uint32 {
	return (volatile.LoadUint32(&o.HEOCTRL.Reg) & 0x8) >> 3
}
func (o *LCDC_Type) SetHEOCTRL_ADDIEN(value uint32) {
	volatile.StoreUint32(&o.HEOCTRL.Reg, volatile.LoadUint32(&o.HEOCTRL.Reg)&^(0x10)|value<<4)
}
func (o *LCDC_Type) GetHEOCTRL_ADDIEN() uint32 {
	return (volatile.LoadUint32(&o.HEOCTRL.Reg) & 0x10) >> 4
}
func (o *LCDC_Type) SetHEOCTRL_DONEIEN(value uint32) {
	volatile.StoreUint32(&o.HEOCTRL.Reg, volatile.LoadUint32(&o.HEOCTRL.Reg)&^(0x20)|value<<5)
}
func (o *LCDC_Type) GetHEOCTRL_DONEIEN() uint32 {
	return (volatile.LoadUint32(&o.HEOCTRL.Reg) & 0x20) >> 5
}

// LCDC.HEONEXT: High End Overlay DMA Next Register
func (o *LCDC_Type) SetHEONEXT(value uint32) {
	volatile.StoreUint32(&o.HEONEXT.Reg, value)
}
func (o *LCDC_Type) GetHEONEXT() uint32 {
	return volatile.LoadUint32(&o.HEONEXT.Reg)
}

// LCDC.HEOUHEAD: High End Overlay U DMA Head Register
func (o *LCDC_Type) SetHEOUHEAD(value uint32) {
	volatile.StoreUint32(&o.HEOUHEAD.Reg, value)
}
func (o *LCDC_Type) GetHEOUHEAD() uint32 {
	return volatile.LoadUint32(&o.HEOUHEAD.Reg)
}

// LCDC.HEOUADDR: High End Overlay U DMA Address Register
func (o *LCDC_Type) SetHEOUADDR(value uint32) {
	volatile.StoreUint32(&o.HEOUADDR.Reg, value)
}
func (o *LCDC_Type) GetHEOUADDR() uint32 {
	return volatile.LoadUint32(&o.HEOUADDR.Reg)
}

// LCDC.HEOUCTRL: High End Overlay U DMA Control Register
func (o *LCDC_Type) SetHEOUCTRL_UDFETCH(value uint32) {
	volatile.StoreUint32(&o.HEOUCTRL.Reg, volatile.LoadUint32(&o.HEOUCTRL.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetHEOUCTRL_UDFETCH() uint32 {
	return volatile.LoadUint32(&o.HEOUCTRL.Reg) & 0x1
}
func (o *LCDC_Type) SetHEOUCTRL_UDMAIEN(value uint32) {
	volatile.StoreUint32(&o.HEOUCTRL.Reg, volatile.LoadUint32(&o.HEOUCTRL.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetHEOUCTRL_UDMAIEN() uint32 {
	return (volatile.LoadUint32(&o.HEOUCTRL.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetHEOUCTRL_UDSCRIEN(value uint32) {
	volatile.StoreUint32(&o.HEOUCTRL.Reg, volatile.LoadUint32(&o.HEOUCTRL.Reg)&^(0x8)|value<<3)
}
func (o *LCDC_Type) GetHEOUCTRL_UDSCRIEN() uint32 {
	return (volatile.LoadUint32(&o.HEOUCTRL.Reg) & 0x8) >> 3
}
func (o *LCDC_Type) SetHEOUCTRL_UADDIEN(value uint32) {
	volatile.StoreUint32(&o.HEOUCTRL.Reg, volatile.LoadUint32(&o.HEOUCTRL.Reg)&^(0x10)|value<<4)
}
func (o *LCDC_Type) GetHEOUCTRL_UADDIEN() uint32 {
	return (volatile.LoadUint32(&o.HEOUCTRL.Reg) & 0x10) >> 4
}
func (o *LCDC_Type) SetHEOUCTRL_UDONEIEN(value uint32) {
	volatile.StoreUint32(&o.HEOUCTRL.Reg, volatile.LoadUint32(&o.HEOUCTRL.Reg)&^(0x20)|value<<5)
}
func (o *LCDC_Type) GetHEOUCTRL_UDONEIEN() uint32 {
	return (volatile.LoadUint32(&o.HEOUCTRL.Reg) & 0x20) >> 5
}

// LCDC.HEOUNEXT: High End Overlay U DMA Next Register
func (o *LCDC_Type) SetHEOUNEXT(value uint32) {
	volatile.StoreUint32(&o.HEOUNEXT.Reg, value)
}
func (o *LCDC_Type) GetHEOUNEXT() uint32 {
	return volatile.LoadUint32(&o.HEOUNEXT.Reg)
}

// LCDC.HEOVHEAD: High End Overlay V DMA Head Register
func (o *LCDC_Type) SetHEOVHEAD(value uint32) {
	volatile.StoreUint32(&o.HEOVHEAD.Reg, value)
}
func (o *LCDC_Type) GetHEOVHEAD() uint32 {
	return volatile.LoadUint32(&o.HEOVHEAD.Reg)
}

// LCDC.HEOVADDR: High End Overlay V DMA Address Register
func (o *LCDC_Type) SetHEOVADDR(value uint32) {
	volatile.StoreUint32(&o.HEOVADDR.Reg, value)
}
func (o *LCDC_Type) GetHEOVADDR() uint32 {
	return volatile.LoadUint32(&o.HEOVADDR.Reg)
}

// LCDC.HEOVCTRL: High End Overlay V DMA Control Register
func (o *LCDC_Type) SetHEOVCTRL_VDFETCH(value uint32) {
	volatile.StoreUint32(&o.HEOVCTRL.Reg, volatile.LoadUint32(&o.HEOVCTRL.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetHEOVCTRL_VDFETCH() uint32 {
	return volatile.LoadUint32(&o.HEOVCTRL.Reg) & 0x1
}
func (o *LCDC_Type) SetHEOVCTRL_VDMAIEN(value uint32) {
	volatile.StoreUint32(&o.HEOVCTRL.Reg, volatile.LoadUint32(&o.HEOVCTRL.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetHEOVCTRL_VDMAIEN() uint32 {
	return (volatile.LoadUint32(&o.HEOVCTRL.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetHEOVCTRL_VDSCRIEN(value uint32) {
	volatile.StoreUint32(&o.HEOVCTRL.Reg, volatile.LoadUint32(&o.HEOVCTRL.Reg)&^(0x8)|value<<3)
}
func (o *LCDC_Type) GetHEOVCTRL_VDSCRIEN() uint32 {
	return (volatile.LoadUint32(&o.HEOVCTRL.Reg) & 0x8) >> 3
}
func (o *LCDC_Type) SetHEOVCTRL_VADDIEN(value uint32) {
	volatile.StoreUint32(&o.HEOVCTRL.Reg, volatile.LoadUint32(&o.HEOVCTRL.Reg)&^(0x10)|value<<4)
}
func (o *LCDC_Type) GetHEOVCTRL_VADDIEN() uint32 {
	return (volatile.LoadUint32(&o.HEOVCTRL.Reg) & 0x10) >> 4
}
func (o *LCDC_Type) SetHEOVCTRL_VDONEIEN(value uint32) {
	volatile.StoreUint32(&o.HEOVCTRL.Reg, volatile.LoadUint32(&o.HEOVCTRL.Reg)&^(0x20)|value<<5)
}
func (o *LCDC_Type) GetHEOVCTRL_VDONEIEN() uint32 {
	return (volatile.LoadUint32(&o.HEOVCTRL.Reg) & 0x20) >> 5
}

// LCDC.HEOVNEXT: High End Overlay VDMA Next Register
func (o *LCDC_Type) SetHEOVNEXT(value uint32) {
	volatile.StoreUint32(&o.HEOVNEXT.Reg, value)
}
func (o *LCDC_Type) GetHEOVNEXT() uint32 {
	return volatile.LoadUint32(&o.HEOVNEXT.Reg)
}

// LCDC.HEOCFG0: High End Overlay Configuration Register 0
func (o *LCDC_Type) SetHEOCFG0_BLEN(value uint32) {
	volatile.StoreUint32(&o.HEOCFG0.Reg, volatile.LoadUint32(&o.HEOCFG0.Reg)&^(0x30)|value<<4)
}
func (o *LCDC_Type) GetHEOCFG0_BLEN() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG0.Reg) & 0x30) >> 4
}
func (o *LCDC_Type) SetHEOCFG0_BLENUV(value uint32) {
	volatile.StoreUint32(&o.HEOCFG0.Reg, volatile.LoadUint32(&o.HEOCFG0.Reg)&^(0xc0)|value<<6)
}
func (o *LCDC_Type) GetHEOCFG0_BLENUV() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG0.Reg) & 0xc0) >> 6
}
func (o *LCDC_Type) SetHEOCFG0_DLBO(value uint32) {
	volatile.StoreUint32(&o.HEOCFG0.Reg, volatile.LoadUint32(&o.HEOCFG0.Reg)&^(0x100)|value<<8)
}
func (o *LCDC_Type) GetHEOCFG0_DLBO() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG0.Reg) & 0x100) >> 8
}
func (o *LCDC_Type) SetHEOCFG0_ROTDIS(value uint32) {
	volatile.StoreUint32(&o.HEOCFG0.Reg, volatile.LoadUint32(&o.HEOCFG0.Reg)&^(0x1000)|value<<12)
}
func (o *LCDC_Type) GetHEOCFG0_ROTDIS() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG0.Reg) & 0x1000) >> 12
}
func (o *LCDC_Type) SetHEOCFG0_LOCKDIS(value uint32) {
	volatile.StoreUint32(&o.HEOCFG0.Reg, volatile.LoadUint32(&o.HEOCFG0.Reg)&^(0x2000)|value<<13)
}
func (o *LCDC_Type) GetHEOCFG0_LOCKDIS() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG0.Reg) & 0x2000) >> 13
}

// LCDC.HEOCFG1: High End Overlay Configuration Register 1
func (o *LCDC_Type) SetHEOCFG1_CLUTEN(value uint32) {
	volatile.StoreUint32(&o.HEOCFG1.Reg, volatile.LoadUint32(&o.HEOCFG1.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetHEOCFG1_CLUTEN() uint32 {
	return volatile.LoadUint32(&o.HEOCFG1.Reg) & 0x1
}
func (o *LCDC_Type) SetHEOCFG1_YUVEN(value uint32) {
	volatile.StoreUint32(&o.HEOCFG1.Reg, volatile.LoadUint32(&o.HEOCFG1.Reg)&^(0x2)|value<<1)
}
func (o *LCDC_Type) GetHEOCFG1_YUVEN() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG1.Reg) & 0x2) >> 1
}
func (o *LCDC_Type) SetHEOCFG1_RGBMODE(value uint32) {
	volatile.StoreUint32(&o.HEOCFG1.Reg, volatile.LoadUint32(&o.HEOCFG1.Reg)&^(0xf0)|value<<4)
}
func (o *LCDC_Type) GetHEOCFG1_RGBMODE() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG1.Reg) & 0xf0) >> 4
}
func (o *LCDC_Type) SetHEOCFG1_CLUTMODE(value uint32) {
	volatile.StoreUint32(&o.HEOCFG1.Reg, volatile.LoadUint32(&o.HEOCFG1.Reg)&^(0x300)|value<<8)
}
func (o *LCDC_Type) GetHEOCFG1_CLUTMODE() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG1.Reg) & 0x300) >> 8
}
func (o *LCDC_Type) SetHEOCFG1_YUVMODE(value uint32) {
	volatile.StoreUint32(&o.HEOCFG1.Reg, volatile.LoadUint32(&o.HEOCFG1.Reg)&^(0xf000)|value<<12)
}
func (o *LCDC_Type) GetHEOCFG1_YUVMODE() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG1.Reg) & 0xf000) >> 12
}
func (o *LCDC_Type) SetHEOCFG1_YUV422ROT(value uint32) {
	volatile.StoreUint32(&o.HEOCFG1.Reg, volatile.LoadUint32(&o.HEOCFG1.Reg)&^(0x10000)|value<<16)
}
func (o *LCDC_Type) GetHEOCFG1_YUV422ROT() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG1.Reg) & 0x10000) >> 16
}
func (o *LCDC_Type) SetHEOCFG1_YUV422SWP(value uint32) {
	volatile.StoreUint32(&o.HEOCFG1.Reg, volatile.LoadUint32(&o.HEOCFG1.Reg)&^(0x20000)|value<<17)
}
func (o *LCDC_Type) GetHEOCFG1_YUV422SWP() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG1.Reg) & 0x20000) >> 17
}

// LCDC.HEOCFG2: High End Overlay Configuration Register 2
func (o *LCDC_Type) SetHEOCFG2_XPOS(value uint32) {
	volatile.StoreUint32(&o.HEOCFG2.Reg, volatile.LoadUint32(&o.HEOCFG2.Reg)&^(0x7ff)|value)
}
func (o *LCDC_Type) GetHEOCFG2_XPOS() uint32 {
	return volatile.LoadUint32(&o.HEOCFG2.Reg) & 0x7ff
}
func (o *LCDC_Type) SetHEOCFG2_YPOS(value uint32) {
	volatile.StoreUint32(&o.HEOCFG2.Reg, volatile.LoadUint32(&o.HEOCFG2.Reg)&^(0x7ff0000)|value<<16)
}
func (o *LCDC_Type) GetHEOCFG2_YPOS() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG2.Reg) & 0x7ff0000) >> 16
}

// LCDC.HEOCFG3: High End Overlay Configuration Register 3
func (o *LCDC_Type) SetHEOCFG3_XSIZE(value uint32) {
	volatile.StoreUint32(&o.HEOCFG3.Reg, volatile.LoadUint32(&o.HEOCFG3.Reg)&^(0x7ff)|value)
}
func (o *LCDC_Type) GetHEOCFG3_XSIZE() uint32 {
	return volatile.LoadUint32(&o.HEOCFG3.Reg) & 0x7ff
}
func (o *LCDC_Type) SetHEOCFG3_YSIZE(value uint32) {
	volatile.StoreUint32(&o.HEOCFG3.Reg, volatile.LoadUint32(&o.HEOCFG3.Reg)&^(0x7ff0000)|value<<16)
}
func (o *LCDC_Type) GetHEOCFG3_YSIZE() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG3.Reg) & 0x7ff0000) >> 16
}

// LCDC.HEOCFG4: High End Overlay Configuration Register 4
func (o *LCDC_Type) SetHEOCFG4_XMEM_SIZE(value uint32) {
	volatile.StoreUint32(&o.HEOCFG4.Reg, volatile.LoadUint32(&o.HEOCFG4.Reg)&^(0x7ff)|value)
}
func (o *LCDC_Type) GetHEOCFG4_XMEM_SIZE() uint32 {
	return volatile.LoadUint32(&o.HEOCFG4.Reg) & 0x7ff
}
func (o *LCDC_Type) SetHEOCFG4_YMEM_SIZE(value uint32) {
	volatile.StoreUint32(&o.HEOCFG4.Reg, volatile.LoadUint32(&o.HEOCFG4.Reg)&^(0x7ff0000)|value<<16)
}
func (o *LCDC_Type) GetHEOCFG4_YMEM_SIZE() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG4.Reg) & 0x7ff0000) >> 16
}

// LCDC.HEOCFG5: High End Overlay Configuration Register 5
func (o *LCDC_Type) SetHEOCFG5(value uint32) {
	volatile.StoreUint32(&o.HEOCFG5.Reg, value)
}
func (o *LCDC_Type) GetHEOCFG5() uint32 {
	return volatile.LoadUint32(&o.HEOCFG5.Reg)
}

// LCDC.HEOCFG6: High End Overlay Configuration Register 6
func (o *LCDC_Type) SetHEOCFG6(value uint32) {
	volatile.StoreUint32(&o.HEOCFG6.Reg, value)
}
func (o *LCDC_Type) GetHEOCFG6() uint32 {
	return volatile.LoadUint32(&o.HEOCFG6.Reg)
}

// LCDC.HEOCFG7: High End Overlay Configuration Register 7
func (o *LCDC_Type) SetHEOCFG7(value uint32) {
	volatile.StoreUint32(&o.HEOCFG7.Reg, value)
}
func (o *LCDC_Type) GetHEOCFG7() uint32 {
	return volatile.LoadUint32(&o.HEOCFG7.Reg)
}

// LCDC.HEOCFG8: High End Overlay Configuration Register 8
func (o *LCDC_Type) SetHEOCFG8(value uint32) {
	volatile.StoreUint32(&o.HEOCFG8.Reg, value)
}
func (o *LCDC_Type) GetHEOCFG8() uint32 {
	return volatile.LoadUint32(&o.HEOCFG8.Reg)
}

// LCDC.HEOCFG9: High End Overlay Configuration Register 9
func (o *LCDC_Type) SetHEOCFG9_BDEF(value uint32) {
	volatile.StoreUint32(&o.HEOCFG9.Reg, volatile.LoadUint32(&o.HEOCFG9.Reg)&^(0xff)|value)
}
func (o *LCDC_Type) GetHEOCFG9_BDEF() uint32 {
	return volatile.LoadUint32(&o.HEOCFG9.Reg) & 0xff
}
func (o *LCDC_Type) SetHEOCFG9_GDEF(value uint32) {
	volatile.StoreUint32(&o.HEOCFG9.Reg, volatile.LoadUint32(&o.HEOCFG9.Reg)&^(0xff00)|value<<8)
}
func (o *LCDC_Type) GetHEOCFG9_GDEF() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG9.Reg) & 0xff00) >> 8
}
func (o *LCDC_Type) SetHEOCFG9_RDEF(value uint32) {
	volatile.StoreUint32(&o.HEOCFG9.Reg, volatile.LoadUint32(&o.HEOCFG9.Reg)&^(0xff0000)|value<<16)
}
func (o *LCDC_Type) GetHEOCFG9_RDEF() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG9.Reg) & 0xff0000) >> 16
}

// LCDC.HEOCFG10: High End Overlay Configuration Register 10
func (o *LCDC_Type) SetHEOCFG10_BKEY(value uint32) {
	volatile.StoreUint32(&o.HEOCFG10.Reg, volatile.LoadUint32(&o.HEOCFG10.Reg)&^(0xff)|value)
}
func (o *LCDC_Type) GetHEOCFG10_BKEY() uint32 {
	return volatile.LoadUint32(&o.HEOCFG10.Reg) & 0xff
}
func (o *LCDC_Type) SetHEOCFG10_GKEY(value uint32) {
	volatile.StoreUint32(&o.HEOCFG10.Reg, volatile.LoadUint32(&o.HEOCFG10.Reg)&^(0xff00)|value<<8)
}
func (o *LCDC_Type) GetHEOCFG10_GKEY() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG10.Reg) & 0xff00) >> 8
}
func (o *LCDC_Type) SetHEOCFG10_RKEY(value uint32) {
	volatile.StoreUint32(&o.HEOCFG10.Reg, volatile.LoadUint32(&o.HEOCFG10.Reg)&^(0xff0000)|value<<16)
}
func (o *LCDC_Type) GetHEOCFG10_RKEY() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG10.Reg) & 0xff0000) >> 16
}

// LCDC.HEOCFG11: High End Overlay Configuration Register 11
func (o *LCDC_Type) SetHEOCFG11_BMASK(value uint32) {
	volatile.StoreUint32(&o.HEOCFG11.Reg, volatile.LoadUint32(&o.HEOCFG11.Reg)&^(0xff)|value)
}
func (o *LCDC_Type) GetHEOCFG11_BMASK() uint32 {
	return volatile.LoadUint32(&o.HEOCFG11.Reg) & 0xff
}
func (o *LCDC_Type) SetHEOCFG11_GMASK(value uint32) {
	volatile.StoreUint32(&o.HEOCFG11.Reg, volatile.LoadUint32(&o.HEOCFG11.Reg)&^(0xff00)|value<<8)
}
func (o *LCDC_Type) GetHEOCFG11_GMASK() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG11.Reg) & 0xff00) >> 8
}
func (o *LCDC_Type) SetHEOCFG11_RMASK(value uint32) {
	volatile.StoreUint32(&o.HEOCFG11.Reg, volatile.LoadUint32(&o.HEOCFG11.Reg)&^(0xff0000)|value<<16)
}
func (o *LCDC_Type) GetHEOCFG11_RMASK() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG11.Reg) & 0xff0000) >> 16
}

// LCDC.HEOCFG12: High End Overlay Configuration Register 12
func (o *LCDC_Type) SetHEOCFG12_CRKEY(value uint32) {
	volatile.StoreUint32(&o.HEOCFG12.Reg, volatile.LoadUint32(&o.HEOCFG12.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetHEOCFG12_CRKEY() uint32 {
	return volatile.LoadUint32(&o.HEOCFG12.Reg) & 0x1
}
func (o *LCDC_Type) SetHEOCFG12_INV(value uint32) {
	volatile.StoreUint32(&o.HEOCFG12.Reg, volatile.LoadUint32(&o.HEOCFG12.Reg)&^(0x2)|value<<1)
}
func (o *LCDC_Type) GetHEOCFG12_INV() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG12.Reg) & 0x2) >> 1
}
func (o *LCDC_Type) SetHEOCFG12_ITER2BL(value uint32) {
	volatile.StoreUint32(&o.HEOCFG12.Reg, volatile.LoadUint32(&o.HEOCFG12.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetHEOCFG12_ITER2BL() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG12.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetHEOCFG12_ITER(value uint32) {
	volatile.StoreUint32(&o.HEOCFG12.Reg, volatile.LoadUint32(&o.HEOCFG12.Reg)&^(0x8)|value<<3)
}
func (o *LCDC_Type) GetHEOCFG12_ITER() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG12.Reg) & 0x8) >> 3
}
func (o *LCDC_Type) SetHEOCFG12_REVALPHA(value uint32) {
	volatile.StoreUint32(&o.HEOCFG12.Reg, volatile.LoadUint32(&o.HEOCFG12.Reg)&^(0x10)|value<<4)
}
func (o *LCDC_Type) GetHEOCFG12_REVALPHA() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG12.Reg) & 0x10) >> 4
}
func (o *LCDC_Type) SetHEOCFG12_GAEN(value uint32) {
	volatile.StoreUint32(&o.HEOCFG12.Reg, volatile.LoadUint32(&o.HEOCFG12.Reg)&^(0x20)|value<<5)
}
func (o *LCDC_Type) GetHEOCFG12_GAEN() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG12.Reg) & 0x20) >> 5
}
func (o *LCDC_Type) SetHEOCFG12_LAEN(value uint32) {
	volatile.StoreUint32(&o.HEOCFG12.Reg, volatile.LoadUint32(&o.HEOCFG12.Reg)&^(0x40)|value<<6)
}
func (o *LCDC_Type) GetHEOCFG12_LAEN() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG12.Reg) & 0x40) >> 6
}
func (o *LCDC_Type) SetHEOCFG12_OVR(value uint32) {
	volatile.StoreUint32(&o.HEOCFG12.Reg, volatile.LoadUint32(&o.HEOCFG12.Reg)&^(0x80)|value<<7)
}
func (o *LCDC_Type) GetHEOCFG12_OVR() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG12.Reg) & 0x80) >> 7
}
func (o *LCDC_Type) SetHEOCFG12_DMA(value uint32) {
	volatile.StoreUint32(&o.HEOCFG12.Reg, volatile.LoadUint32(&o.HEOCFG12.Reg)&^(0x100)|value<<8)
}
func (o *LCDC_Type) GetHEOCFG12_DMA() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG12.Reg) & 0x100) >> 8
}
func (o *LCDC_Type) SetHEOCFG12_REP(value uint32) {
	volatile.StoreUint32(&o.HEOCFG12.Reg, volatile.LoadUint32(&o.HEOCFG12.Reg)&^(0x200)|value<<9)
}
func (o *LCDC_Type) GetHEOCFG12_REP() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG12.Reg) & 0x200) >> 9
}
func (o *LCDC_Type) SetHEOCFG12_DSTKEY(value uint32) {
	volatile.StoreUint32(&o.HEOCFG12.Reg, volatile.LoadUint32(&o.HEOCFG12.Reg)&^(0x400)|value<<10)
}
func (o *LCDC_Type) GetHEOCFG12_DSTKEY() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG12.Reg) & 0x400) >> 10
}
func (o *LCDC_Type) SetHEOCFG12_VIDPRI(value uint32) {
	volatile.StoreUint32(&o.HEOCFG12.Reg, volatile.LoadUint32(&o.HEOCFG12.Reg)&^(0x1000)|value<<12)
}
func (o *LCDC_Type) GetHEOCFG12_VIDPRI() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG12.Reg) & 0x1000) >> 12
}
func (o *LCDC_Type) SetHEOCFG12_GA(value uint32) {
	volatile.StoreUint32(&o.HEOCFG12.Reg, volatile.LoadUint32(&o.HEOCFG12.Reg)&^(0xff0000)|value<<16)
}
func (o *LCDC_Type) GetHEOCFG12_GA() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG12.Reg) & 0xff0000) >> 16
}

// LCDC.HEOCFG13: High End Overlay Configuration Register 13
func (o *LCDC_Type) SetHEOCFG13_XFACTOR(value uint32) {
	volatile.StoreUint32(&o.HEOCFG13.Reg, volatile.LoadUint32(&o.HEOCFG13.Reg)&^(0x1fff)|value)
}
func (o *LCDC_Type) GetHEOCFG13_XFACTOR() uint32 {
	return volatile.LoadUint32(&o.HEOCFG13.Reg) & 0x1fff
}
func (o *LCDC_Type) SetHEOCFG13_YFACTOR(value uint32) {
	volatile.StoreUint32(&o.HEOCFG13.Reg, volatile.LoadUint32(&o.HEOCFG13.Reg)&^(0x1fff0000)|value<<16)
}
func (o *LCDC_Type) GetHEOCFG13_YFACTOR() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG13.Reg) & 0x1fff0000) >> 16
}
func (o *LCDC_Type) SetHEOCFG13_SCALEN(value uint32) {
	volatile.StoreUint32(&o.HEOCFG13.Reg, volatile.LoadUint32(&o.HEOCFG13.Reg)&^(0x80000000)|value<<31)
}
func (o *LCDC_Type) GetHEOCFG13_SCALEN() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG13.Reg) & 0x80000000) >> 31
}

// LCDC.HEOCFG14: High End Overlay Configuration Register 14
func (o *LCDC_Type) SetHEOCFG14_CSCRY(value uint32) {
	volatile.StoreUint32(&o.HEOCFG14.Reg, volatile.LoadUint32(&o.HEOCFG14.Reg)&^(0x3ff)|value)
}
func (o *LCDC_Type) GetHEOCFG14_CSCRY() uint32 {
	return volatile.LoadUint32(&o.HEOCFG14.Reg) & 0x3ff
}
func (o *LCDC_Type) SetHEOCFG14_CSCRU(value uint32) {
	volatile.StoreUint32(&o.HEOCFG14.Reg, volatile.LoadUint32(&o.HEOCFG14.Reg)&^(0xffc00)|value<<10)
}
func (o *LCDC_Type) GetHEOCFG14_CSCRU() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG14.Reg) & 0xffc00) >> 10
}
func (o *LCDC_Type) SetHEOCFG14_CSCRV(value uint32) {
	volatile.StoreUint32(&o.HEOCFG14.Reg, volatile.LoadUint32(&o.HEOCFG14.Reg)&^(0x3ff00000)|value<<20)
}
func (o *LCDC_Type) GetHEOCFG14_CSCRV() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG14.Reg) & 0x3ff00000) >> 20
}
func (o *LCDC_Type) SetHEOCFG14_CSCYOFF(value uint32) {
	volatile.StoreUint32(&o.HEOCFG14.Reg, volatile.LoadUint32(&o.HEOCFG14.Reg)&^(0x40000000)|value<<30)
}
func (o *LCDC_Type) GetHEOCFG14_CSCYOFF() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG14.Reg) & 0x40000000) >> 30
}

// LCDC.HEOCFG15: High End Overlay Configuration Register 15
func (o *LCDC_Type) SetHEOCFG15_CSCGY(value uint32) {
	volatile.StoreUint32(&o.HEOCFG15.Reg, volatile.LoadUint32(&o.HEOCFG15.Reg)&^(0x3ff)|value)
}
func (o *LCDC_Type) GetHEOCFG15_CSCGY() uint32 {
	return volatile.LoadUint32(&o.HEOCFG15.Reg) & 0x3ff
}
func (o *LCDC_Type) SetHEOCFG15_CSCGU(value uint32) {
	volatile.StoreUint32(&o.HEOCFG15.Reg, volatile.LoadUint32(&o.HEOCFG15.Reg)&^(0xffc00)|value<<10)
}
func (o *LCDC_Type) GetHEOCFG15_CSCGU() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG15.Reg) & 0xffc00) >> 10
}
func (o *LCDC_Type) SetHEOCFG15_CSCGV(value uint32) {
	volatile.StoreUint32(&o.HEOCFG15.Reg, volatile.LoadUint32(&o.HEOCFG15.Reg)&^(0x3ff00000)|value<<20)
}
func (o *LCDC_Type) GetHEOCFG15_CSCGV() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG15.Reg) & 0x3ff00000) >> 20
}
func (o *LCDC_Type) SetHEOCFG15_CSCUOFF(value uint32) {
	volatile.StoreUint32(&o.HEOCFG15.Reg, volatile.LoadUint32(&o.HEOCFG15.Reg)&^(0x40000000)|value<<30)
}
func (o *LCDC_Type) GetHEOCFG15_CSCUOFF() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG15.Reg) & 0x40000000) >> 30
}

// LCDC.HEOCFG16: High End Overlay Configuration Register 16
func (o *LCDC_Type) SetHEOCFG16_CSCBY(value uint32) {
	volatile.StoreUint32(&o.HEOCFG16.Reg, volatile.LoadUint32(&o.HEOCFG16.Reg)&^(0x3ff)|value)
}
func (o *LCDC_Type) GetHEOCFG16_CSCBY() uint32 {
	return volatile.LoadUint32(&o.HEOCFG16.Reg) & 0x3ff
}
func (o *LCDC_Type) SetHEOCFG16_CSCBU(value uint32) {
	volatile.StoreUint32(&o.HEOCFG16.Reg, volatile.LoadUint32(&o.HEOCFG16.Reg)&^(0xffc00)|value<<10)
}
func (o *LCDC_Type) GetHEOCFG16_CSCBU() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG16.Reg) & 0xffc00) >> 10
}
func (o *LCDC_Type) SetHEOCFG16_CSCBV(value uint32) {
	volatile.StoreUint32(&o.HEOCFG16.Reg, volatile.LoadUint32(&o.HEOCFG16.Reg)&^(0x3ff00000)|value<<20)
}
func (o *LCDC_Type) GetHEOCFG16_CSCBV() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG16.Reg) & 0x3ff00000) >> 20
}
func (o *LCDC_Type) SetHEOCFG16_CSCVOFF(value uint32) {
	volatile.StoreUint32(&o.HEOCFG16.Reg, volatile.LoadUint32(&o.HEOCFG16.Reg)&^(0x40000000)|value<<30)
}
func (o *LCDC_Type) GetHEOCFG16_CSCVOFF() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG16.Reg) & 0x40000000) >> 30
}

// LCDC.HCRCHER: Hardware Cursor Channel Enable Register
func (o *LCDC_Type) SetHCRCHER_CHEN(value uint32) {
	volatile.StoreUint32(&o.HCRCHER.Reg, volatile.LoadUint32(&o.HCRCHER.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetHCRCHER_CHEN() uint32 {
	return volatile.LoadUint32(&o.HCRCHER.Reg) & 0x1
}
func (o *LCDC_Type) SetHCRCHER_UPDATEEN(value uint32) {
	volatile.StoreUint32(&o.HCRCHER.Reg, volatile.LoadUint32(&o.HCRCHER.Reg)&^(0x2)|value<<1)
}
func (o *LCDC_Type) GetHCRCHER_UPDATEEN() uint32 {
	return (volatile.LoadUint32(&o.HCRCHER.Reg) & 0x2) >> 1
}
func (o *LCDC_Type) SetHCRCHER_A2QEN(value uint32) {
	volatile.StoreUint32(&o.HCRCHER.Reg, volatile.LoadUint32(&o.HCRCHER.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetHCRCHER_A2QEN() uint32 {
	return (volatile.LoadUint32(&o.HCRCHER.Reg) & 0x4) >> 2
}

// LCDC.HCRCHDR: Hardware Cursor Channel Disable Register
func (o *LCDC_Type) SetHCRCHDR_CHDIS(value uint32) {
	volatile.StoreUint32(&o.HCRCHDR.Reg, volatile.LoadUint32(&o.HCRCHDR.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetHCRCHDR_CHDIS() uint32 {
	return volatile.LoadUint32(&o.HCRCHDR.Reg) & 0x1
}
func (o *LCDC_Type) SetHCRCHDR_CHRST(value uint32) {
	volatile.StoreUint32(&o.HCRCHDR.Reg, volatile.LoadUint32(&o.HCRCHDR.Reg)&^(0x100)|value<<8)
}
func (o *LCDC_Type) GetHCRCHDR_CHRST() uint32 {
	return (volatile.LoadUint32(&o.HCRCHDR.Reg) & 0x100) >> 8
}

// LCDC.HCRCHSR: Hardware Cursor Channel Status Register
func (o *LCDC_Type) SetHCRCHSR_CHSR(value uint32) {
	volatile.StoreUint32(&o.HCRCHSR.Reg, volatile.LoadUint32(&o.HCRCHSR.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetHCRCHSR_CHSR() uint32 {
	return volatile.LoadUint32(&o.HCRCHSR.Reg) & 0x1
}
func (o *LCDC_Type) SetHCRCHSR_UPDATESR(value uint32) {
	volatile.StoreUint32(&o.HCRCHSR.Reg, volatile.LoadUint32(&o.HCRCHSR.Reg)&^(0x2)|value<<1)
}
func (o *LCDC_Type) GetHCRCHSR_UPDATESR() uint32 {
	return (volatile.LoadUint32(&o.HCRCHSR.Reg) & 0x2) >> 1
}
func (o *LCDC_Type) SetHCRCHSR_A2QSR(value uint32) {
	volatile.StoreUint32(&o.HCRCHSR.Reg, volatile.LoadUint32(&o.HCRCHSR.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetHCRCHSR_A2QSR() uint32 {
	return (volatile.LoadUint32(&o.HCRCHSR.Reg) & 0x4) >> 2
}

// LCDC.HCRIER: Hardware Cursor Interrupt Enable Register
func (o *LCDC_Type) SetHCRIER_DMA(value uint32) {
	volatile.StoreUint32(&o.HCRIER.Reg, volatile.LoadUint32(&o.HCRIER.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetHCRIER_DMA() uint32 {
	return (volatile.LoadUint32(&o.HCRIER.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetHCRIER_DSCR(value uint32) {
	volatile.StoreUint32(&o.HCRIER.Reg, volatile.LoadUint32(&o.HCRIER.Reg)&^(0x8)|value<<3)
}
func (o *LCDC_Type) GetHCRIER_DSCR() uint32 {
	return (volatile.LoadUint32(&o.HCRIER.Reg) & 0x8) >> 3
}
func (o *LCDC_Type) SetHCRIER_ADD(value uint32) {
	volatile.StoreUint32(&o.HCRIER.Reg, volatile.LoadUint32(&o.HCRIER.Reg)&^(0x10)|value<<4)
}
func (o *LCDC_Type) GetHCRIER_ADD() uint32 {
	return (volatile.LoadUint32(&o.HCRIER.Reg) & 0x10) >> 4
}
func (o *LCDC_Type) SetHCRIER_DONE(value uint32) {
	volatile.StoreUint32(&o.HCRIER.Reg, volatile.LoadUint32(&o.HCRIER.Reg)&^(0x20)|value<<5)
}
func (o *LCDC_Type) GetHCRIER_DONE() uint32 {
	return (volatile.LoadUint32(&o.HCRIER.Reg) & 0x20) >> 5
}
func (o *LCDC_Type) SetHCRIER_OVR(value uint32) {
	volatile.StoreUint32(&o.HCRIER.Reg, volatile.LoadUint32(&o.HCRIER.Reg)&^(0x40)|value<<6)
}
func (o *LCDC_Type) GetHCRIER_OVR() uint32 {
	return (volatile.LoadUint32(&o.HCRIER.Reg) & 0x40) >> 6
}

// LCDC.HCRIDR: Hardware Cursor Interrupt Disable Register
func (o *LCDC_Type) SetHCRIDR_DMA(value uint32) {
	volatile.StoreUint32(&o.HCRIDR.Reg, volatile.LoadUint32(&o.HCRIDR.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetHCRIDR_DMA() uint32 {
	return (volatile.LoadUint32(&o.HCRIDR.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetHCRIDR_DSCR(value uint32) {
	volatile.StoreUint32(&o.HCRIDR.Reg, volatile.LoadUint32(&o.HCRIDR.Reg)&^(0x8)|value<<3)
}
func (o *LCDC_Type) GetHCRIDR_DSCR() uint32 {
	return (volatile.LoadUint32(&o.HCRIDR.Reg) & 0x8) >> 3
}
func (o *LCDC_Type) SetHCRIDR_ADD(value uint32) {
	volatile.StoreUint32(&o.HCRIDR.Reg, volatile.LoadUint32(&o.HCRIDR.Reg)&^(0x10)|value<<4)
}
func (o *LCDC_Type) GetHCRIDR_ADD() uint32 {
	return (volatile.LoadUint32(&o.HCRIDR.Reg) & 0x10) >> 4
}
func (o *LCDC_Type) SetHCRIDR_DONE(value uint32) {
	volatile.StoreUint32(&o.HCRIDR.Reg, volatile.LoadUint32(&o.HCRIDR.Reg)&^(0x20)|value<<5)
}
func (o *LCDC_Type) GetHCRIDR_DONE() uint32 {
	return (volatile.LoadUint32(&o.HCRIDR.Reg) & 0x20) >> 5
}
func (o *LCDC_Type) SetHCRIDR_OVR(value uint32) {
	volatile.StoreUint32(&o.HCRIDR.Reg, volatile.LoadUint32(&o.HCRIDR.Reg)&^(0x40)|value<<6)
}
func (o *LCDC_Type) GetHCRIDR_OVR() uint32 {
	return (volatile.LoadUint32(&o.HCRIDR.Reg) & 0x40) >> 6
}

// LCDC.HCRIMR: Hardware Cursor Interrupt Mask Register
func (o *LCDC_Type) SetHCRIMR_DMA(value uint32) {
	volatile.StoreUint32(&o.HCRIMR.Reg, volatile.LoadUint32(&o.HCRIMR.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetHCRIMR_DMA() uint32 {
	return (volatile.LoadUint32(&o.HCRIMR.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetHCRIMR_DSCR(value uint32) {
	volatile.StoreUint32(&o.HCRIMR.Reg, volatile.LoadUint32(&o.HCRIMR.Reg)&^(0x8)|value<<3)
}
func (o *LCDC_Type) GetHCRIMR_DSCR() uint32 {
	return (volatile.LoadUint32(&o.HCRIMR.Reg) & 0x8) >> 3
}
func (o *LCDC_Type) SetHCRIMR_ADD(value uint32) {
	volatile.StoreUint32(&o.HCRIMR.Reg, volatile.LoadUint32(&o.HCRIMR.Reg)&^(0x10)|value<<4)
}
func (o *LCDC_Type) GetHCRIMR_ADD() uint32 {
	return (volatile.LoadUint32(&o.HCRIMR.Reg) & 0x10) >> 4
}
func (o *LCDC_Type) SetHCRIMR_DONE(value uint32) {
	volatile.StoreUint32(&o.HCRIMR.Reg, volatile.LoadUint32(&o.HCRIMR.Reg)&^(0x20)|value<<5)
}
func (o *LCDC_Type) GetHCRIMR_DONE() uint32 {
	return (volatile.LoadUint32(&o.HCRIMR.Reg) & 0x20) >> 5
}
func (o *LCDC_Type) SetHCRIMR_OVR(value uint32) {
	volatile.StoreUint32(&o.HCRIMR.Reg, volatile.LoadUint32(&o.HCRIMR.Reg)&^(0x40)|value<<6)
}
func (o *LCDC_Type) GetHCRIMR_OVR() uint32 {
	return (volatile.LoadUint32(&o.HCRIMR.Reg) & 0x40) >> 6
}

// LCDC.HCRISR: Hardware Cursor Interrupt Status Register
func (o *LCDC_Type) SetHCRISR_DMA(value uint32) {
	volatile.StoreUint32(&o.HCRISR.Reg, volatile.LoadUint32(&o.HCRISR.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetHCRISR_DMA() uint32 {
	return (volatile.LoadUint32(&o.HCRISR.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetHCRISR_DSCR(value uint32) {
	volatile.StoreUint32(&o.HCRISR.Reg, volatile.LoadUint32(&o.HCRISR.Reg)&^(0x8)|value<<3)
}
func (o *LCDC_Type) GetHCRISR_DSCR() uint32 {
	return (volatile.LoadUint32(&o.HCRISR.Reg) & 0x8) >> 3
}
func (o *LCDC_Type) SetHCRISR_ADD(value uint32) {
	volatile.StoreUint32(&o.HCRISR.Reg, volatile.LoadUint32(&o.HCRISR.Reg)&^(0x10)|value<<4)
}
func (o *LCDC_Type) GetHCRISR_ADD() uint32 {
	return (volatile.LoadUint32(&o.HCRISR.Reg) & 0x10) >> 4
}
func (o *LCDC_Type) SetHCRISR_DONE(value uint32) {
	volatile.StoreUint32(&o.HCRISR.Reg, volatile.LoadUint32(&o.HCRISR.Reg)&^(0x20)|value<<5)
}
func (o *LCDC_Type) GetHCRISR_DONE() uint32 {
	return (volatile.LoadUint32(&o.HCRISR.Reg) & 0x20) >> 5
}
func (o *LCDC_Type) SetHCRISR_OVR(value uint32) {
	volatile.StoreUint32(&o.HCRISR.Reg, volatile.LoadUint32(&o.HCRISR.Reg)&^(0x40)|value<<6)
}
func (o *LCDC_Type) GetHCRISR_OVR() uint32 {
	return (volatile.LoadUint32(&o.HCRISR.Reg) & 0x40) >> 6
}

// LCDC.HCRHEAD: Hardware Cursor DMA Head Register
func (o *LCDC_Type) SetHCRHEAD_HEAD(value uint32) {
	volatile.StoreUint32(&o.HCRHEAD.Reg, volatile.LoadUint32(&o.HCRHEAD.Reg)&^(0xfffffffc)|value<<2)
}
func (o *LCDC_Type) GetHCRHEAD_HEAD() uint32 {
	return (volatile.LoadUint32(&o.HCRHEAD.Reg) & 0xfffffffc) >> 2
}

// LCDC.HCRADDR: Hardware cursor DMA Address Register
func (o *LCDC_Type) SetHCRADDR(value uint32) {
	volatile.StoreUint32(&o.HCRADDR.Reg, value)
}
func (o *LCDC_Type) GetHCRADDR() uint32 {
	return volatile.LoadUint32(&o.HCRADDR.Reg)
}

// LCDC.HCRCTRL: Hardware Cursor DMA Control Register
func (o *LCDC_Type) SetHCRCTRL_DFETCH(value uint32) {
	volatile.StoreUint32(&o.HCRCTRL.Reg, volatile.LoadUint32(&o.HCRCTRL.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetHCRCTRL_DFETCH() uint32 {
	return volatile.LoadUint32(&o.HCRCTRL.Reg) & 0x1
}
func (o *LCDC_Type) SetHCRCTRL_LFETCH(value uint32) {
	volatile.StoreUint32(&o.HCRCTRL.Reg, volatile.LoadUint32(&o.HCRCTRL.Reg)&^(0x2)|value<<1)
}
func (o *LCDC_Type) GetHCRCTRL_LFETCH() uint32 {
	return (volatile.LoadUint32(&o.HCRCTRL.Reg) & 0x2) >> 1
}
func (o *LCDC_Type) SetHCRCTRL_DMAIEN(value uint32) {
	volatile.StoreUint32(&o.HCRCTRL.Reg, volatile.LoadUint32(&o.HCRCTRL.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetHCRCTRL_DMAIEN() uint32 {
	return (volatile.LoadUint32(&o.HCRCTRL.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetHCRCTRL_DSCRIEN(value uint32) {
	volatile.StoreUint32(&o.HCRCTRL.Reg, volatile.LoadUint32(&o.HCRCTRL.Reg)&^(0x8)|value<<3)
}
func (o *LCDC_Type) GetHCRCTRL_DSCRIEN() uint32 {
	return (volatile.LoadUint32(&o.HCRCTRL.Reg) & 0x8) >> 3
}
func (o *LCDC_Type) SetHCRCTRL_ADDIEN(value uint32) {
	volatile.StoreUint32(&o.HCRCTRL.Reg, volatile.LoadUint32(&o.HCRCTRL.Reg)&^(0x10)|value<<4)
}
func (o *LCDC_Type) GetHCRCTRL_ADDIEN() uint32 {
	return (volatile.LoadUint32(&o.HCRCTRL.Reg) & 0x10) >> 4
}
func (o *LCDC_Type) SetHCRCTRL_DONEIEN(value uint32) {
	volatile.StoreUint32(&o.HCRCTRL.Reg, volatile.LoadUint32(&o.HCRCTRL.Reg)&^(0x20)|value<<5)
}
func (o *LCDC_Type) GetHCRCTRL_DONEIEN() uint32 {
	return (volatile.LoadUint32(&o.HCRCTRL.Reg) & 0x20) >> 5
}

// LCDC.HCRNEXT: Hardware Cursor DMA NExt Register
func (o *LCDC_Type) SetHCRNEXT(value uint32) {
	volatile.StoreUint32(&o.HCRNEXT.Reg, value)
}
func (o *LCDC_Type) GetHCRNEXT() uint32 {
	return volatile.LoadUint32(&o.HCRNEXT.Reg)
}

// LCDC.HCRCFG0: Hardware Cursor Configuration 0 Register
func (o *LCDC_Type) SetHCRCFG0_BLEN(value uint32) {
	volatile.StoreUint32(&o.HCRCFG0.Reg, volatile.LoadUint32(&o.HCRCFG0.Reg)&^(0x30)|value<<4)
}
func (o *LCDC_Type) GetHCRCFG0_BLEN() uint32 {
	return (volatile.LoadUint32(&o.HCRCFG0.Reg) & 0x30) >> 4
}
func (o *LCDC_Type) SetHCRCFG0_DLBO(value uint32) {
	volatile.StoreUint32(&o.HCRCFG0.Reg, volatile.LoadUint32(&o.HCRCFG0.Reg)&^(0x100)|value<<8)
}
func (o *LCDC_Type) GetHCRCFG0_DLBO() uint32 {
	return (volatile.LoadUint32(&o.HCRCFG0.Reg) & 0x100) >> 8
}

// LCDC.HCRCFG1: Hardware Cursor Configuration 1 Register
func (o *LCDC_Type) SetHCRCFG1_CLUTEN(value uint32) {
	volatile.StoreUint32(&o.HCRCFG1.Reg, volatile.LoadUint32(&o.HCRCFG1.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetHCRCFG1_CLUTEN() uint32 {
	return volatile.LoadUint32(&o.HCRCFG1.Reg) & 0x1
}
func (o *LCDC_Type) SetHCRCFG1_RGBMODE(value uint32) {
	volatile.StoreUint32(&o.HCRCFG1.Reg, volatile.LoadUint32(&o.HCRCFG1.Reg)&^(0xf0)|value<<4)
}
func (o *LCDC_Type) GetHCRCFG1_RGBMODE() uint32 {
	return (volatile.LoadUint32(&o.HCRCFG1.Reg) & 0xf0) >> 4
}
func (o *LCDC_Type) SetHCRCFG1_CLUTMODE(value uint32) {
	volatile.StoreUint32(&o.HCRCFG1.Reg, volatile.LoadUint32(&o.HCRCFG1.Reg)&^(0x300)|value<<8)
}
func (o *LCDC_Type) GetHCRCFG1_CLUTMODE() uint32 {
	return (volatile.LoadUint32(&o.HCRCFG1.Reg) & 0x300) >> 8
}

// LCDC.HCRCFG2: Hardware Cursor Configuration 2 Register
func (o *LCDC_Type) SetHCRCFG2_XPOS(value uint32) {
	volatile.StoreUint32(&o.HCRCFG2.Reg, volatile.LoadUint32(&o.HCRCFG2.Reg)&^(0x7ff)|value)
}
func (o *LCDC_Type) GetHCRCFG2_XPOS() uint32 {
	return volatile.LoadUint32(&o.HCRCFG2.Reg) & 0x7ff
}
func (o *LCDC_Type) SetHCRCFG2_YPOS(value uint32) {
	volatile.StoreUint32(&o.HCRCFG2.Reg, volatile.LoadUint32(&o.HCRCFG2.Reg)&^(0x7ff0000)|value<<16)
}
func (o *LCDC_Type) GetHCRCFG2_YPOS() uint32 {
	return (volatile.LoadUint32(&o.HCRCFG2.Reg) & 0x7ff0000) >> 16
}

// LCDC.HCRCFG3: Hardware Cursor Configuration 3 Register
func (o *LCDC_Type) SetHCRCFG3_XSIZE(value uint32) {
	volatile.StoreUint32(&o.HCRCFG3.Reg, volatile.LoadUint32(&o.HCRCFG3.Reg)&^(0x7f)|value)
}
func (o *LCDC_Type) GetHCRCFG3_XSIZE() uint32 {
	return volatile.LoadUint32(&o.HCRCFG3.Reg) & 0x7f
}
func (o *LCDC_Type) SetHCRCFG3_YSIZE(value uint32) {
	volatile.StoreUint32(&o.HCRCFG3.Reg, volatile.LoadUint32(&o.HCRCFG3.Reg)&^(0x7f0000)|value<<16)
}
func (o *LCDC_Type) GetHCRCFG3_YSIZE() uint32 {
	return (volatile.LoadUint32(&o.HCRCFG3.Reg) & 0x7f0000) >> 16
}

// LCDC.HCRCFG4: Hardware Cursor Configuration 4 Register
func (o *LCDC_Type) SetHCRCFG4(value uint32) {
	volatile.StoreUint32(&o.HCRCFG4.Reg, value)
}
func (o *LCDC_Type) GetHCRCFG4() uint32 {
	return volatile.LoadUint32(&o.HCRCFG4.Reg)
}

// LCDC.HCRCFG6: Hardware Cursor Configuration 6 Register
func (o *LCDC_Type) SetHCRCFG6_BDEF(value uint32) {
	volatile.StoreUint32(&o.HCRCFG6.Reg, volatile.LoadUint32(&o.HCRCFG6.Reg)&^(0xff)|value)
}
func (o *LCDC_Type) GetHCRCFG6_BDEF() uint32 {
	return volatile.LoadUint32(&o.HCRCFG6.Reg) & 0xff
}
func (o *LCDC_Type) SetHCRCFG6_GDEF(value uint32) {
	volatile.StoreUint32(&o.HCRCFG6.Reg, volatile.LoadUint32(&o.HCRCFG6.Reg)&^(0xff00)|value<<8)
}
func (o *LCDC_Type) GetHCRCFG6_GDEF() uint32 {
	return (volatile.LoadUint32(&o.HCRCFG6.Reg) & 0xff00) >> 8
}
func (o *LCDC_Type) SetHCRCFG6_RDEF(value uint32) {
	volatile.StoreUint32(&o.HCRCFG6.Reg, volatile.LoadUint32(&o.HCRCFG6.Reg)&^(0xff0000)|value<<16)
}
func (o *LCDC_Type) GetHCRCFG6_RDEF() uint32 {
	return (volatile.LoadUint32(&o.HCRCFG6.Reg) & 0xff0000) >> 16
}

// LCDC.HCRCFG7: Hardware Cursor Configuration 7 Register
func (o *LCDC_Type) SetHCRCFG7_BKEY(value uint32) {
	volatile.StoreUint32(&o.HCRCFG7.Reg, volatile.LoadUint32(&o.HCRCFG7.Reg)&^(0xff)|value)
}
func (o *LCDC_Type) GetHCRCFG7_BKEY() uint32 {
	return volatile.LoadUint32(&o.HCRCFG7.Reg) & 0xff
}
func (o *LCDC_Type) SetHCRCFG7_GKEY(value uint32) {
	volatile.StoreUint32(&o.HCRCFG7.Reg, volatile.LoadUint32(&o.HCRCFG7.Reg)&^(0xff00)|value<<8)
}
func (o *LCDC_Type) GetHCRCFG7_GKEY() uint32 {
	return (volatile.LoadUint32(&o.HCRCFG7.Reg) & 0xff00) >> 8
}
func (o *LCDC_Type) SetHCRCFG7_RKEY(value uint32) {
	volatile.StoreUint32(&o.HCRCFG7.Reg, volatile.LoadUint32(&o.HCRCFG7.Reg)&^(0xff0000)|value<<16)
}
func (o *LCDC_Type) GetHCRCFG7_RKEY() uint32 {
	return (volatile.LoadUint32(&o.HCRCFG7.Reg) & 0xff0000) >> 16
}

// LCDC.HCRCFG8: Hardware Cursor Configuration 8 Register
func (o *LCDC_Type) SetHCRCFG8_BMASK(value uint32) {
	volatile.StoreUint32(&o.HCRCFG8.Reg, volatile.LoadUint32(&o.HCRCFG8.Reg)&^(0xff)|value)
}
func (o *LCDC_Type) GetHCRCFG8_BMASK() uint32 {
	return volatile.LoadUint32(&o.HCRCFG8.Reg) & 0xff
}
func (o *LCDC_Type) SetHCRCFG8_GMASK(value uint32) {
	volatile.StoreUint32(&o.HCRCFG8.Reg, volatile.LoadUint32(&o.HCRCFG8.Reg)&^(0xff00)|value<<8)
}
func (o *LCDC_Type) GetHCRCFG8_GMASK() uint32 {
	return (volatile.LoadUint32(&o.HCRCFG8.Reg) & 0xff00) >> 8
}
func (o *LCDC_Type) SetHCRCFG8_RMASK(value uint32) {
	volatile.StoreUint32(&o.HCRCFG8.Reg, volatile.LoadUint32(&o.HCRCFG8.Reg)&^(0xff0000)|value<<16)
}
func (o *LCDC_Type) GetHCRCFG8_RMASK() uint32 {
	return (volatile.LoadUint32(&o.HCRCFG8.Reg) & 0xff0000) >> 16
}

// LCDC.HCRCFG9: Hardware Cursor Configuration 9 Register
func (o *LCDC_Type) SetHCRCFG9_CRKEY(value uint32) {
	volatile.StoreUint32(&o.HCRCFG9.Reg, volatile.LoadUint32(&o.HCRCFG9.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetHCRCFG9_CRKEY() uint32 {
	return volatile.LoadUint32(&o.HCRCFG9.Reg) & 0x1
}
func (o *LCDC_Type) SetHCRCFG9_INV(value uint32) {
	volatile.StoreUint32(&o.HCRCFG9.Reg, volatile.LoadUint32(&o.HCRCFG9.Reg)&^(0x2)|value<<1)
}
func (o *LCDC_Type) GetHCRCFG9_INV() uint32 {
	return (volatile.LoadUint32(&o.HCRCFG9.Reg) & 0x2) >> 1
}
func (o *LCDC_Type) SetHCRCFG9_ITER2BL(value uint32) {
	volatile.StoreUint32(&o.HCRCFG9.Reg, volatile.LoadUint32(&o.HCRCFG9.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetHCRCFG9_ITER2BL() uint32 {
	return (volatile.LoadUint32(&o.HCRCFG9.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetHCRCFG9_ITER(value uint32) {
	volatile.StoreUint32(&o.HCRCFG9.Reg, volatile.LoadUint32(&o.HCRCFG9.Reg)&^(0x8)|value<<3)
}
func (o *LCDC_Type) GetHCRCFG9_ITER() uint32 {
	return (volatile.LoadUint32(&o.HCRCFG9.Reg) & 0x8) >> 3
}
func (o *LCDC_Type) SetHCRCFG9_REVALPHA(value uint32) {
	volatile.StoreUint32(&o.HCRCFG9.Reg, volatile.LoadUint32(&o.HCRCFG9.Reg)&^(0x10)|value<<4)
}
func (o *LCDC_Type) GetHCRCFG9_REVALPHA() uint32 {
	return (volatile.LoadUint32(&o.HCRCFG9.Reg) & 0x10) >> 4
}
func (o *LCDC_Type) SetHCRCFG9_GAEN(value uint32) {
	volatile.StoreUint32(&o.HCRCFG9.Reg, volatile.LoadUint32(&o.HCRCFG9.Reg)&^(0x20)|value<<5)
}
func (o *LCDC_Type) GetHCRCFG9_GAEN() uint32 {
	return (volatile.LoadUint32(&o.HCRCFG9.Reg) & 0x20) >> 5
}
func (o *LCDC_Type) SetHCRCFG9_LAEN(value uint32) {
	volatile.StoreUint32(&o.HCRCFG9.Reg, volatile.LoadUint32(&o.HCRCFG9.Reg)&^(0x40)|value<<6)
}
func (o *LCDC_Type) GetHCRCFG9_LAEN() uint32 {
	return (volatile.LoadUint32(&o.HCRCFG9.Reg) & 0x40) >> 6
}
func (o *LCDC_Type) SetHCRCFG9_OVR(value uint32) {
	volatile.StoreUint32(&o.HCRCFG9.Reg, volatile.LoadUint32(&o.HCRCFG9.Reg)&^(0x80)|value<<7)
}
func (o *LCDC_Type) GetHCRCFG9_OVR() uint32 {
	return (volatile.LoadUint32(&o.HCRCFG9.Reg) & 0x80) >> 7
}
func (o *LCDC_Type) SetHCRCFG9_DMA(value uint32) {
	volatile.StoreUint32(&o.HCRCFG9.Reg, volatile.LoadUint32(&o.HCRCFG9.Reg)&^(0x100)|value<<8)
}
func (o *LCDC_Type) GetHCRCFG9_DMA() uint32 {
	return (volatile.LoadUint32(&o.HCRCFG9.Reg) & 0x100) >> 8
}
func (o *LCDC_Type) SetHCRCFG9_REP(value uint32) {
	volatile.StoreUint32(&o.HCRCFG9.Reg, volatile.LoadUint32(&o.HCRCFG9.Reg)&^(0x200)|value<<9)
}
func (o *LCDC_Type) GetHCRCFG9_REP() uint32 {
	return (volatile.LoadUint32(&o.HCRCFG9.Reg) & 0x200) >> 9
}
func (o *LCDC_Type) SetHCRCFG9_DSTKEY(value uint32) {
	volatile.StoreUint32(&o.HCRCFG9.Reg, volatile.LoadUint32(&o.HCRCFG9.Reg)&^(0x400)|value<<10)
}
func (o *LCDC_Type) GetHCRCFG9_DSTKEY() uint32 {
	return (volatile.LoadUint32(&o.HCRCFG9.Reg) & 0x400) >> 10
}
func (o *LCDC_Type) SetHCRCFG9_GA(value uint32) {
	volatile.StoreUint32(&o.HCRCFG9.Reg, volatile.LoadUint32(&o.HCRCFG9.Reg)&^(0xff0000)|value<<16)
}
func (o *LCDC_Type) GetHCRCFG9_GA() uint32 {
	return (volatile.LoadUint32(&o.HCRCFG9.Reg) & 0xff0000) >> 16
}

// LCDC.BASECLUT: Base CLUT Register
func (o *LCDC_Type) SetBASECLUT_BCLUT(idx int, value uint32) {
	volatile.StoreUint32(&o.BASECLUT[idx].Reg, volatile.LoadUint32(&o.BASECLUT[idx].Reg)&^(0xff)|value)
}
func (o *LCDC_Type) GetBASECLUT_BCLUT(idx int) uint32 {
	return volatile.LoadUint32(&o.BASECLUT[idx].Reg) & 0xff
}
func (o *LCDC_Type) SetBASECLUT_GCLUT(idx int, value uint32) {
	volatile.StoreUint32(&o.BASECLUT[idx].Reg, volatile.LoadUint32(&o.BASECLUT[idx].Reg)&^(0xff00)|value<<8)
}
func (o *LCDC_Type) GetBASECLUT_GCLUT(idx int) uint32 {
	return (volatile.LoadUint32(&o.BASECLUT[idx].Reg) & 0xff00) >> 8
}
func (o *LCDC_Type) SetBASECLUT_RCLUT(idx int, value uint32) {
	volatile.StoreUint32(&o.BASECLUT[idx].Reg, volatile.LoadUint32(&o.BASECLUT[idx].Reg)&^(0xff0000)|value<<16)
}
func (o *LCDC_Type) GetBASECLUT_RCLUT(idx int) uint32 {
	return (volatile.LoadUint32(&o.BASECLUT[idx].Reg) & 0xff0000) >> 16
}

// LCDC.OVR1CLUT: Overlay 1 CLUT Register
func (o *LCDC_Type) SetOVR1CLUT_BCLUT(idx int, value uint32) {
	volatile.StoreUint32(&o.OVR1CLUT[idx].Reg, volatile.LoadUint32(&o.OVR1CLUT[idx].Reg)&^(0xff)|value)
}
func (o *LCDC_Type) GetOVR1CLUT_BCLUT(idx int) uint32 {
	return volatile.LoadUint32(&o.OVR1CLUT[idx].Reg) & 0xff
}
func (o *LCDC_Type) SetOVR1CLUT_GCLUT(idx int, value uint32) {
	volatile.StoreUint32(&o.OVR1CLUT[idx].Reg, volatile.LoadUint32(&o.OVR1CLUT[idx].Reg)&^(0xff00)|value<<8)
}
func (o *LCDC_Type) GetOVR1CLUT_GCLUT(idx int) uint32 {
	return (volatile.LoadUint32(&o.OVR1CLUT[idx].Reg) & 0xff00) >> 8
}
func (o *LCDC_Type) SetOVR1CLUT_RCLUT(idx int, value uint32) {
	volatile.StoreUint32(&o.OVR1CLUT[idx].Reg, volatile.LoadUint32(&o.OVR1CLUT[idx].Reg)&^(0xff0000)|value<<16)
}
func (o *LCDC_Type) GetOVR1CLUT_RCLUT(idx int) uint32 {
	return (volatile.LoadUint32(&o.OVR1CLUT[idx].Reg) & 0xff0000) >> 16
}
func (o *LCDC_Type) SetOVR1CLUT_ACLUT(idx int, value uint32) {
	volatile.StoreUint32(&o.OVR1CLUT[idx].Reg, volatile.LoadUint32(&o.OVR1CLUT[idx].Reg)&^(0xff000000)|value<<24)
}
func (o *LCDC_Type) GetOVR1CLUT_ACLUT(idx int) uint32 {
	return (volatile.LoadUint32(&o.OVR1CLUT[idx].Reg) & 0xff000000) >> 24
}

// LCDC.HEOCLUT: High End Overlay CLUT Register
func (o *LCDC_Type) SetHEOCLUT_BCLUT(idx int, value uint32) {
	volatile.StoreUint32(&o.HEOCLUT[idx].Reg, volatile.LoadUint32(&o.HEOCLUT[idx].Reg)&^(0xff)|value)
}
func (o *LCDC_Type) GetHEOCLUT_BCLUT(idx int) uint32 {
	return volatile.LoadUint32(&o.HEOCLUT[idx].Reg) & 0xff
}
func (o *LCDC_Type) SetHEOCLUT_GCLUT(idx int, value uint32) {
	volatile.StoreUint32(&o.HEOCLUT[idx].Reg, volatile.LoadUint32(&o.HEOCLUT[idx].Reg)&^(0xff00)|value<<8)
}
func (o *LCDC_Type) GetHEOCLUT_GCLUT(idx int) uint32 {
	return (volatile.LoadUint32(&o.HEOCLUT[idx].Reg) & 0xff00) >> 8
}
func (o *LCDC_Type) SetHEOCLUT_RCLUT(idx int, value uint32) {
	volatile.StoreUint32(&o.HEOCLUT[idx].Reg, volatile.LoadUint32(&o.HEOCLUT[idx].Reg)&^(0xff0000)|value<<16)
}
func (o *LCDC_Type) GetHEOCLUT_RCLUT(idx int) uint32 {
	return (volatile.LoadUint32(&o.HEOCLUT[idx].Reg) & 0xff0000) >> 16
}
func (o *LCDC_Type) SetHEOCLUT_ACLUT(idx int, value uint32) {
	volatile.StoreUint32(&o.HEOCLUT[idx].Reg, volatile.LoadUint32(&o.HEOCLUT[idx].Reg)&^(0xff000000)|value<<24)
}
func (o *LCDC_Type) GetHEOCLUT_ACLUT(idx int) uint32 {
	return (volatile.LoadUint32(&o.HEOCLUT[idx].Reg) & 0xff000000) >> 24
}

// LCDC.HCRCLUT: Hardware Cursor CLUT Register
func (o *LCDC_Type) SetHCRCLUT_BCLUT(idx int, value uint32) {
	volatile.StoreUint32(&o.HCRCLUT[idx].Reg, volatile.LoadUint32(&o.HCRCLUT[idx].Reg)&^(0xff)|value)
}
func (o *LCDC_Type) GetHCRCLUT_BCLUT(idx int) uint32 {
	return volatile.LoadUint32(&o.HCRCLUT[idx].Reg) & 0xff
}
func (o *LCDC_Type) SetHCRCLUT_GCLUT(idx int, value uint32) {
	volatile.StoreUint32(&o.HCRCLUT[idx].Reg, volatile.LoadUint32(&o.HCRCLUT[idx].Reg)&^(0xff00)|value<<8)
}
func (o *LCDC_Type) GetHCRCLUT_GCLUT(idx int) uint32 {
	return (volatile.LoadUint32(&o.HCRCLUT[idx].Reg) & 0xff00) >> 8
}
func (o *LCDC_Type) SetHCRCLUT_RCLUT(idx int, value uint32) {
	volatile.StoreUint32(&o.HCRCLUT[idx].Reg, volatile.LoadUint32(&o.HCRCLUT[idx].Reg)&^(0xff0000)|value<<16)
}
func (o *LCDC_Type) GetHCRCLUT_RCLUT(idx int) uint32 {
	return (volatile.LoadUint32(&o.HCRCLUT[idx].Reg) & 0xff0000) >> 16
}
func (o *LCDC_Type) SetHCRCLUT_ACLUT(idx int, value uint32) {
	volatile.StoreUint32(&o.HCRCLUT[idx].Reg, volatile.LoadUint32(&o.HCRCLUT[idx].Reg)&^(0xff000000)|value<<24)
}
func (o *LCDC_Type) GetHCRCLUT_ACLUT(idx int) uint32 {
	return (volatile.LoadUint32(&o.HCRCLUT[idx].Reg) & 0xff000000) >> 24
}

// USB High Speed Device Port
type UDPHS_Type struct {
	CTRL        volatile.Register32 // 0x0
	FNUM        volatile.Register32 // 0x4
	_           [8]byte
	IEN         volatile.Register32 // 0x10
	INTSTA      volatile.Register32 // 0x14
	CLRINT      volatile.Register32 // 0x18
	EPTRST      volatile.Register32 // 0x1C
	_           [192]byte
	TST         volatile.Register32 // 0xE0
	_           [28]byte
	EPTCFG0     volatile.Register32 // 0x100
	EPTCTLENB0  volatile.Register32 // 0x104
	EPTCTLDIS0  volatile.Register32 // 0x108
	EPTCTL0     volatile.Register32 // 0x10C
	_           [4]byte
	EPTSETSTA0  volatile.Register32 // 0x114
	EPTCLRSTA0  volatile.Register32 // 0x118
	EPTSTA0     volatile.Register32 // 0x11C
	EPTCFG1     volatile.Register32 // 0x120
	EPTCTLENB1  volatile.Register32 // 0x124
	EPTCTLDIS1  volatile.Register32 // 0x128
	EPTCTL1     volatile.Register32 // 0x12C
	_           [4]byte
	EPTSETSTA1  volatile.Register32 // 0x134
	EPTCLRSTA1  volatile.Register32 // 0x138
	EPTSTA1     volatile.Register32 // 0x13C
	EPTCFG2     volatile.Register32 // 0x140
	EPTCTLENB2  volatile.Register32 // 0x144
	EPTCTLDIS2  volatile.Register32 // 0x148
	EPTCTL2     volatile.Register32 // 0x14C
	_           [4]byte
	EPTSETSTA2  volatile.Register32 // 0x154
	EPTCLRSTA2  volatile.Register32 // 0x158
	EPTSTA2     volatile.Register32 // 0x15C
	EPTCFG3     volatile.Register32 // 0x160
	EPTCTLENB3  volatile.Register32 // 0x164
	EPTCTLDIS3  volatile.Register32 // 0x168
	EPTCTL3     volatile.Register32 // 0x16C
	_           [4]byte
	EPTSETSTA3  volatile.Register32 // 0x174
	EPTCLRSTA3  volatile.Register32 // 0x178
	EPTSTA3     volatile.Register32 // 0x17C
	EPTCFG4     volatile.Register32 // 0x180
	EPTCTLENB4  volatile.Register32 // 0x184
	EPTCTLDIS4  volatile.Register32 // 0x188
	EPTCTL4     volatile.Register32 // 0x18C
	_           [4]byte
	EPTSETSTA4  volatile.Register32 // 0x194
	EPTCLRSTA4  volatile.Register32 // 0x198
	EPTSTA4     volatile.Register32 // 0x19C
	EPTCFG5     volatile.Register32 // 0x1A0
	EPTCTLENB5  volatile.Register32 // 0x1A4
	EPTCTLDIS5  volatile.Register32 // 0x1A8
	EPTCTL5     volatile.Register32 // 0x1AC
	_           [4]byte
	EPTSETSTA5  volatile.Register32 // 0x1B4
	EPTCLRSTA5  volatile.Register32 // 0x1B8
	EPTSTA5     volatile.Register32 // 0x1BC
	EPTCFG6     volatile.Register32 // 0x1C0
	EPTCTLENB6  volatile.Register32 // 0x1C4
	EPTCTLDIS6  volatile.Register32 // 0x1C8
	EPTCTL6     volatile.Register32 // 0x1CC
	_           [4]byte
	EPTSETSTA6  volatile.Register32 // 0x1D4
	EPTCLRSTA6  volatile.Register32 // 0x1D8
	EPTSTA6     volatile.Register32 // 0x1DC
	_           [288]byte
	DMANXTDSC0  volatile.Register32 // 0x300
	DMAADDRESS0 volatile.Register32 // 0x304
	DMACONTROL0 volatile.Register32 // 0x308
	DMASTATUS0  volatile.Register32 // 0x30C
	DMANXTDSC1  volatile.Register32 // 0x310
	DMAADDRESS1 volatile.Register32 // 0x314
	DMACONTROL1 volatile.Register32 // 0x318
	DMASTATUS1  volatile.Register32 // 0x31C
	DMANXTDSC2  volatile.Register32 // 0x320
	DMAADDRESS2 volatile.Register32 // 0x324
	DMACONTROL2 volatile.Register32 // 0x328
	DMASTATUS2  volatile.Register32 // 0x32C
	DMANXTDSC3  volatile.Register32 // 0x330
	DMAADDRESS3 volatile.Register32 // 0x334
	DMACONTROL3 volatile.Register32 // 0x338
	DMASTATUS3  volatile.Register32 // 0x33C
	DMANXTDSC4  volatile.Register32 // 0x340
	DMAADDRESS4 volatile.Register32 // 0x344
	DMACONTROL4 volatile.Register32 // 0x348
	DMASTATUS4  volatile.Register32 // 0x34C
	DMANXTDSC5  volatile.Register32 // 0x350
	DMAADDRESS5 volatile.Register32 // 0x354
	DMACONTROL5 volatile.Register32 // 0x358
	DMASTATUS5  volatile.Register32 // 0x35C
}

// UDPHS.CTRL: UDPHS Control Register
func (o *UDPHS_Type) SetCTRL_DEV_ADDR(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x7f)|value)
}
func (o *UDPHS_Type) GetCTRL_DEV_ADDR() uint32 {
	return volatile.LoadUint32(&o.CTRL.Reg) & 0x7f
}
func (o *UDPHS_Type) SetCTRL_FADDR_EN(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x80)|value<<7)
}
func (o *UDPHS_Type) GetCTRL_FADDR_EN() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x80) >> 7
}
func (o *UDPHS_Type) SetCTRL_EN_UDPHS(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetCTRL_EN_UDPHS() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetCTRL_DETACH(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetCTRL_DETACH() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetCTRL_REWAKEUP(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetCTRL_REWAKEUP() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetCTRL_PULLD_DIS(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetCTRL_PULLD_DIS() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x800) >> 11
}

// UDPHS.FNUM: UDPHS Frame Number Register
func (o *UDPHS_Type) SetFNUM_MICRO_FRAME_NUM(value uint32) {
	volatile.StoreUint32(&o.FNUM.Reg, volatile.LoadUint32(&o.FNUM.Reg)&^(0x7)|value)
}
func (o *UDPHS_Type) GetFNUM_MICRO_FRAME_NUM() uint32 {
	return volatile.LoadUint32(&o.FNUM.Reg) & 0x7
}
func (o *UDPHS_Type) SetFNUM_FRAME_NUMBER(value uint32) {
	volatile.StoreUint32(&o.FNUM.Reg, volatile.LoadUint32(&o.FNUM.Reg)&^(0x3ff8)|value<<3)
}
func (o *UDPHS_Type) GetFNUM_FRAME_NUMBER() uint32 {
	return (volatile.LoadUint32(&o.FNUM.Reg) & 0x3ff8) >> 3
}
func (o *UDPHS_Type) SetFNUM_FNUM_ERR(value uint32) {
	volatile.StoreUint32(&o.FNUM.Reg, volatile.LoadUint32(&o.FNUM.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetFNUM_FNUM_ERR() uint32 {
	return (volatile.LoadUint32(&o.FNUM.Reg) & 0x80000000) >> 31
}

// UDPHS.IEN: UDPHS Interrupt Enable Register
func (o *UDPHS_Type) SetIEN_DET_SUSPD(value uint32) {
	volatile.StoreUint32(&o.IEN.Reg, volatile.LoadUint32(&o.IEN.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetIEN_DET_SUSPD() uint32 {
	return (volatile.LoadUint32(&o.IEN.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetIEN_MICRO_SOF(value uint32) {
	volatile.StoreUint32(&o.IEN.Reg, volatile.LoadUint32(&o.IEN.Reg)&^(0x4)|value<<2)
}
func (o *UDPHS_Type) GetIEN_MICRO_SOF() uint32 {
	return (volatile.LoadUint32(&o.IEN.Reg) & 0x4) >> 2
}
func (o *UDPHS_Type) SetIEN_INT_SOF(value uint32) {
	volatile.StoreUint32(&o.IEN.Reg, volatile.LoadUint32(&o.IEN.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetIEN_INT_SOF() uint32 {
	return (volatile.LoadUint32(&o.IEN.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetIEN_ENDRESET(value uint32) {
	volatile.StoreUint32(&o.IEN.Reg, volatile.LoadUint32(&o.IEN.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetIEN_ENDRESET() uint32 {
	return (volatile.LoadUint32(&o.IEN.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetIEN_WAKE_UP(value uint32) {
	volatile.StoreUint32(&o.IEN.Reg, volatile.LoadUint32(&o.IEN.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetIEN_WAKE_UP() uint32 {
	return (volatile.LoadUint32(&o.IEN.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetIEN_ENDOFRSM(value uint32) {
	volatile.StoreUint32(&o.IEN.Reg, volatile.LoadUint32(&o.IEN.Reg)&^(0x40)|value<<6)
}
func (o *UDPHS_Type) GetIEN_ENDOFRSM() uint32 {
	return (volatile.LoadUint32(&o.IEN.Reg) & 0x40) >> 6
}
func (o *UDPHS_Type) SetIEN_UPSTR_RES(value uint32) {
	volatile.StoreUint32(&o.IEN.Reg, volatile.LoadUint32(&o.IEN.Reg)&^(0x80)|value<<7)
}
func (o *UDPHS_Type) GetIEN_UPSTR_RES() uint32 {
	return (volatile.LoadUint32(&o.IEN.Reg) & 0x80) >> 7
}
func (o *UDPHS_Type) SetIEN_EPT_0(value uint32) {
	volatile.StoreUint32(&o.IEN.Reg, volatile.LoadUint32(&o.IEN.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetIEN_EPT_0() uint32 {
	return (volatile.LoadUint32(&o.IEN.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetIEN_EPT_1(value uint32) {
	volatile.StoreUint32(&o.IEN.Reg, volatile.LoadUint32(&o.IEN.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetIEN_EPT_1() uint32 {
	return (volatile.LoadUint32(&o.IEN.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetIEN_EPT_2(value uint32) {
	volatile.StoreUint32(&o.IEN.Reg, volatile.LoadUint32(&o.IEN.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetIEN_EPT_2() uint32 {
	return (volatile.LoadUint32(&o.IEN.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetIEN_EPT_3(value uint32) {
	volatile.StoreUint32(&o.IEN.Reg, volatile.LoadUint32(&o.IEN.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetIEN_EPT_3() uint32 {
	return (volatile.LoadUint32(&o.IEN.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetIEN_EPT_4(value uint32) {
	volatile.StoreUint32(&o.IEN.Reg, volatile.LoadUint32(&o.IEN.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetIEN_EPT_4() uint32 {
	return (volatile.LoadUint32(&o.IEN.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetIEN_EPT_5(value uint32) {
	volatile.StoreUint32(&o.IEN.Reg, volatile.LoadUint32(&o.IEN.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetIEN_EPT_5() uint32 {
	return (volatile.LoadUint32(&o.IEN.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetIEN_EPT_6(value uint32) {
	volatile.StoreUint32(&o.IEN.Reg, volatile.LoadUint32(&o.IEN.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetIEN_EPT_6() uint32 {
	return (volatile.LoadUint32(&o.IEN.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetIEN_DMA_1(value uint32) {
	volatile.StoreUint32(&o.IEN.Reg, volatile.LoadUint32(&o.IEN.Reg)&^(0x2000000)|value<<25)
}
func (o *UDPHS_Type) GetIEN_DMA_1() uint32 {
	return (volatile.LoadUint32(&o.IEN.Reg) & 0x2000000) >> 25
}
func (o *UDPHS_Type) SetIEN_DMA_2(value uint32) {
	volatile.StoreUint32(&o.IEN.Reg, volatile.LoadUint32(&o.IEN.Reg)&^(0x4000000)|value<<26)
}
func (o *UDPHS_Type) GetIEN_DMA_2() uint32 {
	return (volatile.LoadUint32(&o.IEN.Reg) & 0x4000000) >> 26
}
func (o *UDPHS_Type) SetIEN_DMA_3(value uint32) {
	volatile.StoreUint32(&o.IEN.Reg, volatile.LoadUint32(&o.IEN.Reg)&^(0x8000000)|value<<27)
}
func (o *UDPHS_Type) GetIEN_DMA_3() uint32 {
	return (volatile.LoadUint32(&o.IEN.Reg) & 0x8000000) >> 27
}
func (o *UDPHS_Type) SetIEN_DMA_4(value uint32) {
	volatile.StoreUint32(&o.IEN.Reg, volatile.LoadUint32(&o.IEN.Reg)&^(0x10000000)|value<<28)
}
func (o *UDPHS_Type) GetIEN_DMA_4() uint32 {
	return (volatile.LoadUint32(&o.IEN.Reg) & 0x10000000) >> 28
}
func (o *UDPHS_Type) SetIEN_DMA_5(value uint32) {
	volatile.StoreUint32(&o.IEN.Reg, volatile.LoadUint32(&o.IEN.Reg)&^(0x20000000)|value<<29)
}
func (o *UDPHS_Type) GetIEN_DMA_5() uint32 {
	return (volatile.LoadUint32(&o.IEN.Reg) & 0x20000000) >> 29
}
func (o *UDPHS_Type) SetIEN_DMA_6(value uint32) {
	volatile.StoreUint32(&o.IEN.Reg, volatile.LoadUint32(&o.IEN.Reg)&^(0x40000000)|value<<30)
}
func (o *UDPHS_Type) GetIEN_DMA_6() uint32 {
	return (volatile.LoadUint32(&o.IEN.Reg) & 0x40000000) >> 30
}

// UDPHS.INTSTA: UDPHS Interrupt Status Register
func (o *UDPHS_Type) SetINTSTA_SPEED(value uint32) {
	volatile.StoreUint32(&o.INTSTA.Reg, volatile.LoadUint32(&o.INTSTA.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetINTSTA_SPEED() uint32 {
	return volatile.LoadUint32(&o.INTSTA.Reg) & 0x1
}
func (o *UDPHS_Type) SetINTSTA_DET_SUSPD(value uint32) {
	volatile.StoreUint32(&o.INTSTA.Reg, volatile.LoadUint32(&o.INTSTA.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetINTSTA_DET_SUSPD() uint32 {
	return (volatile.LoadUint32(&o.INTSTA.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetINTSTA_MICRO_SOF(value uint32) {
	volatile.StoreUint32(&o.INTSTA.Reg, volatile.LoadUint32(&o.INTSTA.Reg)&^(0x4)|value<<2)
}
func (o *UDPHS_Type) GetINTSTA_MICRO_SOF() uint32 {
	return (volatile.LoadUint32(&o.INTSTA.Reg) & 0x4) >> 2
}
func (o *UDPHS_Type) SetINTSTA_INT_SOF(value uint32) {
	volatile.StoreUint32(&o.INTSTA.Reg, volatile.LoadUint32(&o.INTSTA.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetINTSTA_INT_SOF() uint32 {
	return (volatile.LoadUint32(&o.INTSTA.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetINTSTA_ENDRESET(value uint32) {
	volatile.StoreUint32(&o.INTSTA.Reg, volatile.LoadUint32(&o.INTSTA.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetINTSTA_ENDRESET() uint32 {
	return (volatile.LoadUint32(&o.INTSTA.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetINTSTA_WAKE_UP(value uint32) {
	volatile.StoreUint32(&o.INTSTA.Reg, volatile.LoadUint32(&o.INTSTA.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetINTSTA_WAKE_UP() uint32 {
	return (volatile.LoadUint32(&o.INTSTA.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetINTSTA_ENDOFRSM(value uint32) {
	volatile.StoreUint32(&o.INTSTA.Reg, volatile.LoadUint32(&o.INTSTA.Reg)&^(0x40)|value<<6)
}
func (o *UDPHS_Type) GetINTSTA_ENDOFRSM() uint32 {
	return (volatile.LoadUint32(&o.INTSTA.Reg) & 0x40) >> 6
}
func (o *UDPHS_Type) SetINTSTA_UPSTR_RES(value uint32) {
	volatile.StoreUint32(&o.INTSTA.Reg, volatile.LoadUint32(&o.INTSTA.Reg)&^(0x80)|value<<7)
}
func (o *UDPHS_Type) GetINTSTA_UPSTR_RES() uint32 {
	return (volatile.LoadUint32(&o.INTSTA.Reg) & 0x80) >> 7
}
func (o *UDPHS_Type) SetINTSTA_EPT_0(value uint32) {
	volatile.StoreUint32(&o.INTSTA.Reg, volatile.LoadUint32(&o.INTSTA.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetINTSTA_EPT_0() uint32 {
	return (volatile.LoadUint32(&o.INTSTA.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetINTSTA_EPT_1(value uint32) {
	volatile.StoreUint32(&o.INTSTA.Reg, volatile.LoadUint32(&o.INTSTA.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetINTSTA_EPT_1() uint32 {
	return (volatile.LoadUint32(&o.INTSTA.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetINTSTA_EPT_2(value uint32) {
	volatile.StoreUint32(&o.INTSTA.Reg, volatile.LoadUint32(&o.INTSTA.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetINTSTA_EPT_2() uint32 {
	return (volatile.LoadUint32(&o.INTSTA.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetINTSTA_EPT_3(value uint32) {
	volatile.StoreUint32(&o.INTSTA.Reg, volatile.LoadUint32(&o.INTSTA.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetINTSTA_EPT_3() uint32 {
	return (volatile.LoadUint32(&o.INTSTA.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetINTSTA_EPT_4(value uint32) {
	volatile.StoreUint32(&o.INTSTA.Reg, volatile.LoadUint32(&o.INTSTA.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetINTSTA_EPT_4() uint32 {
	return (volatile.LoadUint32(&o.INTSTA.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetINTSTA_EPT_5(value uint32) {
	volatile.StoreUint32(&o.INTSTA.Reg, volatile.LoadUint32(&o.INTSTA.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetINTSTA_EPT_5() uint32 {
	return (volatile.LoadUint32(&o.INTSTA.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetINTSTA_EPT_6(value uint32) {
	volatile.StoreUint32(&o.INTSTA.Reg, volatile.LoadUint32(&o.INTSTA.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetINTSTA_EPT_6() uint32 {
	return (volatile.LoadUint32(&o.INTSTA.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetINTSTA_DMA_1(value uint32) {
	volatile.StoreUint32(&o.INTSTA.Reg, volatile.LoadUint32(&o.INTSTA.Reg)&^(0x2000000)|value<<25)
}
func (o *UDPHS_Type) GetINTSTA_DMA_1() uint32 {
	return (volatile.LoadUint32(&o.INTSTA.Reg) & 0x2000000) >> 25
}
func (o *UDPHS_Type) SetINTSTA_DMA_2(value uint32) {
	volatile.StoreUint32(&o.INTSTA.Reg, volatile.LoadUint32(&o.INTSTA.Reg)&^(0x4000000)|value<<26)
}
func (o *UDPHS_Type) GetINTSTA_DMA_2() uint32 {
	return (volatile.LoadUint32(&o.INTSTA.Reg) & 0x4000000) >> 26
}
func (o *UDPHS_Type) SetINTSTA_DMA_3(value uint32) {
	volatile.StoreUint32(&o.INTSTA.Reg, volatile.LoadUint32(&o.INTSTA.Reg)&^(0x8000000)|value<<27)
}
func (o *UDPHS_Type) GetINTSTA_DMA_3() uint32 {
	return (volatile.LoadUint32(&o.INTSTA.Reg) & 0x8000000) >> 27
}
func (o *UDPHS_Type) SetINTSTA_DMA_4(value uint32) {
	volatile.StoreUint32(&o.INTSTA.Reg, volatile.LoadUint32(&o.INTSTA.Reg)&^(0x10000000)|value<<28)
}
func (o *UDPHS_Type) GetINTSTA_DMA_4() uint32 {
	return (volatile.LoadUint32(&o.INTSTA.Reg) & 0x10000000) >> 28
}
func (o *UDPHS_Type) SetINTSTA_DMA_5(value uint32) {
	volatile.StoreUint32(&o.INTSTA.Reg, volatile.LoadUint32(&o.INTSTA.Reg)&^(0x20000000)|value<<29)
}
func (o *UDPHS_Type) GetINTSTA_DMA_5() uint32 {
	return (volatile.LoadUint32(&o.INTSTA.Reg) & 0x20000000) >> 29
}
func (o *UDPHS_Type) SetINTSTA_DMA_6(value uint32) {
	volatile.StoreUint32(&o.INTSTA.Reg, volatile.LoadUint32(&o.INTSTA.Reg)&^(0x40000000)|value<<30)
}
func (o *UDPHS_Type) GetINTSTA_DMA_6() uint32 {
	return (volatile.LoadUint32(&o.INTSTA.Reg) & 0x40000000) >> 30
}

// UDPHS.CLRINT: UDPHS Clear Interrupt Register
func (o *UDPHS_Type) SetCLRINT_DET_SUSPD(value uint32) {
	volatile.StoreUint32(&o.CLRINT.Reg, volatile.LoadUint32(&o.CLRINT.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetCLRINT_DET_SUSPD() uint32 {
	return (volatile.LoadUint32(&o.CLRINT.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetCLRINT_MICRO_SOF(value uint32) {
	volatile.StoreUint32(&o.CLRINT.Reg, volatile.LoadUint32(&o.CLRINT.Reg)&^(0x4)|value<<2)
}
func (o *UDPHS_Type) GetCLRINT_MICRO_SOF() uint32 {
	return (volatile.LoadUint32(&o.CLRINT.Reg) & 0x4) >> 2
}
func (o *UDPHS_Type) SetCLRINT_INT_SOF(value uint32) {
	volatile.StoreUint32(&o.CLRINT.Reg, volatile.LoadUint32(&o.CLRINT.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetCLRINT_INT_SOF() uint32 {
	return (volatile.LoadUint32(&o.CLRINT.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetCLRINT_ENDRESET(value uint32) {
	volatile.StoreUint32(&o.CLRINT.Reg, volatile.LoadUint32(&o.CLRINT.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetCLRINT_ENDRESET() uint32 {
	return (volatile.LoadUint32(&o.CLRINT.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetCLRINT_WAKE_UP(value uint32) {
	volatile.StoreUint32(&o.CLRINT.Reg, volatile.LoadUint32(&o.CLRINT.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetCLRINT_WAKE_UP() uint32 {
	return (volatile.LoadUint32(&o.CLRINT.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetCLRINT_ENDOFRSM(value uint32) {
	volatile.StoreUint32(&o.CLRINT.Reg, volatile.LoadUint32(&o.CLRINT.Reg)&^(0x40)|value<<6)
}
func (o *UDPHS_Type) GetCLRINT_ENDOFRSM() uint32 {
	return (volatile.LoadUint32(&o.CLRINT.Reg) & 0x40) >> 6
}
func (o *UDPHS_Type) SetCLRINT_UPSTR_RES(value uint32) {
	volatile.StoreUint32(&o.CLRINT.Reg, volatile.LoadUint32(&o.CLRINT.Reg)&^(0x80)|value<<7)
}
func (o *UDPHS_Type) GetCLRINT_UPSTR_RES() uint32 {
	return (volatile.LoadUint32(&o.CLRINT.Reg) & 0x80) >> 7
}

// UDPHS.EPTRST: UDPHS Endpoints Reset Register
func (o *UDPHS_Type) SetEPTRST_EPT_0(value uint32) {
	volatile.StoreUint32(&o.EPTRST.Reg, volatile.LoadUint32(&o.EPTRST.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTRST_EPT_0() uint32 {
	return volatile.LoadUint32(&o.EPTRST.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTRST_EPT_1(value uint32) {
	volatile.StoreUint32(&o.EPTRST.Reg, volatile.LoadUint32(&o.EPTRST.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTRST_EPT_1() uint32 {
	return (volatile.LoadUint32(&o.EPTRST.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTRST_EPT_2(value uint32) {
	volatile.StoreUint32(&o.EPTRST.Reg, volatile.LoadUint32(&o.EPTRST.Reg)&^(0x4)|value<<2)
}
func (o *UDPHS_Type) GetEPTRST_EPT_2() uint32 {
	return (volatile.LoadUint32(&o.EPTRST.Reg) & 0x4) >> 2
}
func (o *UDPHS_Type) SetEPTRST_EPT_3(value uint32) {
	volatile.StoreUint32(&o.EPTRST.Reg, volatile.LoadUint32(&o.EPTRST.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTRST_EPT_3() uint32 {
	return (volatile.LoadUint32(&o.EPTRST.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTRST_EPT_4(value uint32) {
	volatile.StoreUint32(&o.EPTRST.Reg, volatile.LoadUint32(&o.EPTRST.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTRST_EPT_4() uint32 {
	return (volatile.LoadUint32(&o.EPTRST.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTRST_EPT_5(value uint32) {
	volatile.StoreUint32(&o.EPTRST.Reg, volatile.LoadUint32(&o.EPTRST.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTRST_EPT_5() uint32 {
	return (volatile.LoadUint32(&o.EPTRST.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTRST_EPT_6(value uint32) {
	volatile.StoreUint32(&o.EPTRST.Reg, volatile.LoadUint32(&o.EPTRST.Reg)&^(0x40)|value<<6)
}
func (o *UDPHS_Type) GetEPTRST_EPT_6() uint32 {
	return (volatile.LoadUint32(&o.EPTRST.Reg) & 0x40) >> 6
}

// UDPHS.TST: UDPHS Test Register
func (o *UDPHS_Type) SetTST_SPEED_CFG(value uint32) {
	volatile.StoreUint32(&o.TST.Reg, volatile.LoadUint32(&o.TST.Reg)&^(0x3)|value)
}
func (o *UDPHS_Type) GetTST_SPEED_CFG() uint32 {
	return volatile.LoadUint32(&o.TST.Reg) & 0x3
}
func (o *UDPHS_Type) SetTST_TST_J(value uint32) {
	volatile.StoreUint32(&o.TST.Reg, volatile.LoadUint32(&o.TST.Reg)&^(0x4)|value<<2)
}
func (o *UDPHS_Type) GetTST_TST_J() uint32 {
	return (volatile.LoadUint32(&o.TST.Reg) & 0x4) >> 2
}
func (o *UDPHS_Type) SetTST_TST_K(value uint32) {
	volatile.StoreUint32(&o.TST.Reg, volatile.LoadUint32(&o.TST.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetTST_TST_K() uint32 {
	return (volatile.LoadUint32(&o.TST.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetTST_TST_PKT(value uint32) {
	volatile.StoreUint32(&o.TST.Reg, volatile.LoadUint32(&o.TST.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetTST_TST_PKT() uint32 {
	return (volatile.LoadUint32(&o.TST.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetTST_OPMODE2(value uint32) {
	volatile.StoreUint32(&o.TST.Reg, volatile.LoadUint32(&o.TST.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetTST_OPMODE2() uint32 {
	return (volatile.LoadUint32(&o.TST.Reg) & 0x20) >> 5
}

// UDPHS.EPTCFG0: UDPHS Endpoint Configuration Register (endpoint = 0)
func (o *UDPHS_Type) SetEPTCFG0_EPT_SIZE(value uint32) {
	volatile.StoreUint32(&o.EPTCFG0.Reg, volatile.LoadUint32(&o.EPTCFG0.Reg)&^(0x7)|value)
}
func (o *UDPHS_Type) GetEPTCFG0_EPT_SIZE() uint32 {
	return volatile.LoadUint32(&o.EPTCFG0.Reg) & 0x7
}
func (o *UDPHS_Type) SetEPTCFG0_EPT_DIR(value uint32) {
	volatile.StoreUint32(&o.EPTCFG0.Reg, volatile.LoadUint32(&o.EPTCFG0.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCFG0_EPT_DIR() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG0.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCFG0_EPT_TYPE(value uint32) {
	volatile.StoreUint32(&o.EPTCFG0.Reg, volatile.LoadUint32(&o.EPTCFG0.Reg)&^(0x30)|value<<4)
}
func (o *UDPHS_Type) GetEPTCFG0_EPT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG0.Reg) & 0x30) >> 4
}
func (o *UDPHS_Type) SetEPTCFG0_BK_NUMBER(value uint32) {
	volatile.StoreUint32(&o.EPTCFG0.Reg, volatile.LoadUint32(&o.EPTCFG0.Reg)&^(0xc0)|value<<6)
}
func (o *UDPHS_Type) GetEPTCFG0_BK_NUMBER() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG0.Reg) & 0xc0) >> 6
}
func (o *UDPHS_Type) SetEPTCFG0_NB_TRANS(value uint32) {
	volatile.StoreUint32(&o.EPTCFG0.Reg, volatile.LoadUint32(&o.EPTCFG0.Reg)&^(0x300)|value<<8)
}
func (o *UDPHS_Type) GetEPTCFG0_NB_TRANS() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG0.Reg) & 0x300) >> 8
}
func (o *UDPHS_Type) SetEPTCFG0_EPT_MAPD(value uint32) {
	volatile.StoreUint32(&o.EPTCFG0.Reg, volatile.LoadUint32(&o.EPTCFG0.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCFG0_EPT_MAPD() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG0.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTLENB0: UDPHS Endpoint Control Enable Register (endpoint = 0)
func (o *UDPHS_Type) SetEPTCTLENB0_EPT_ENABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB0.Reg, volatile.LoadUint32(&o.EPTCTLENB0.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTLENB0_EPT_ENABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTLENB0.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTLENB0_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB0.Reg, volatile.LoadUint32(&o.EPTCTLENB0.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTLENB0_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB0.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTLENB0_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB0.Reg, volatile.LoadUint32(&o.EPTCTLENB0.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTLENB0_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB0.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTLENB0_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB0.Reg, volatile.LoadUint32(&o.EPTCTLENB0.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTLENB0_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB0.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTLENB0_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB0.Reg, volatile.LoadUint32(&o.EPTCTLENB0.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTLENB0_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB0.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTLENB0_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB0.Reg, volatile.LoadUint32(&o.EPTCTLENB0.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTLENB0_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB0.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTLENB0_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB0.Reg, volatile.LoadUint32(&o.EPTCTLENB0.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTLENB0_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB0.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTLENB0_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB0.Reg, volatile.LoadUint32(&o.EPTCTLENB0.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTLENB0_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB0.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTLENB0_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB0.Reg, volatile.LoadUint32(&o.EPTCTLENB0.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTLENB0_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB0.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTLENB0_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB0.Reg, volatile.LoadUint32(&o.EPTCTLENB0.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTLENB0_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB0.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTLENB0_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB0.Reg, volatile.LoadUint32(&o.EPTCTLENB0.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTLENB0_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB0.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTLENB0_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB0.Reg, volatile.LoadUint32(&o.EPTCTLENB0.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTLENB0_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB0.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTLENB0_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB0.Reg, volatile.LoadUint32(&o.EPTCTLENB0.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTLENB0_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB0.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTLENB0_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB0.Reg, volatile.LoadUint32(&o.EPTCTLENB0.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTLENB0_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB0.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTLDIS0: UDPHS Endpoint Control Disable Register (endpoint = 0)
func (o *UDPHS_Type) SetEPTCTLDIS0_EPT_DISABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS0.Reg, volatile.LoadUint32(&o.EPTCTLDIS0.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTLDIS0_EPT_DISABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTLDIS0.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTLDIS0_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS0.Reg, volatile.LoadUint32(&o.EPTCTLDIS0.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTLDIS0_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS0.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTLDIS0_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS0.Reg, volatile.LoadUint32(&o.EPTCTLDIS0.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTLDIS0_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS0.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTLDIS0_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS0.Reg, volatile.LoadUint32(&o.EPTCTLDIS0.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTLDIS0_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS0.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTLDIS0_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS0.Reg, volatile.LoadUint32(&o.EPTCTLDIS0.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTLDIS0_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS0.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTLDIS0_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS0.Reg, volatile.LoadUint32(&o.EPTCTLDIS0.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTLDIS0_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS0.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTLDIS0_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS0.Reg, volatile.LoadUint32(&o.EPTCTLDIS0.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTLDIS0_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS0.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTLDIS0_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS0.Reg, volatile.LoadUint32(&o.EPTCTLDIS0.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTLDIS0_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS0.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTLDIS0_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS0.Reg, volatile.LoadUint32(&o.EPTCTLDIS0.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTLDIS0_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS0.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTLDIS0_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS0.Reg, volatile.LoadUint32(&o.EPTCTLDIS0.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTLDIS0_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS0.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTLDIS0_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS0.Reg, volatile.LoadUint32(&o.EPTCTLDIS0.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTLDIS0_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS0.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTLDIS0_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS0.Reg, volatile.LoadUint32(&o.EPTCTLDIS0.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTLDIS0_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS0.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTLDIS0_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS0.Reg, volatile.LoadUint32(&o.EPTCTLDIS0.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTLDIS0_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS0.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTLDIS0_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS0.Reg, volatile.LoadUint32(&o.EPTCTLDIS0.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTLDIS0_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS0.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTL0: UDPHS Endpoint Control Register (endpoint = 0)
func (o *UDPHS_Type) SetEPTCTL0_EPT_ENABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTL0.Reg, volatile.LoadUint32(&o.EPTCTL0.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTL0_EPT_ENABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTL0.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTL0_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTL0.Reg, volatile.LoadUint32(&o.EPTCTL0.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTL0_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL0.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTL0_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTL0.Reg, volatile.LoadUint32(&o.EPTCTL0.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTL0_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL0.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTL0_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTL0.Reg, volatile.LoadUint32(&o.EPTCTL0.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTL0_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL0.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTL0_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTL0.Reg, volatile.LoadUint32(&o.EPTCTL0.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTL0_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL0.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTL0_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTL0.Reg, volatile.LoadUint32(&o.EPTCTL0.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTL0_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL0.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTL0_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL0.Reg, volatile.LoadUint32(&o.EPTCTL0.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTL0_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL0.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTL0_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTL0.Reg, volatile.LoadUint32(&o.EPTCTL0.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTL0_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL0.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTL0_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTL0.Reg, volatile.LoadUint32(&o.EPTCTL0.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTL0_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL0.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTL0_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL0.Reg, volatile.LoadUint32(&o.EPTCTL0.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTL0_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL0.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTL0_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTL0.Reg, volatile.LoadUint32(&o.EPTCTL0.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTL0_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL0.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTL0_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL0.Reg, volatile.LoadUint32(&o.EPTCTL0.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTL0_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL0.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTL0_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTL0.Reg, volatile.LoadUint32(&o.EPTCTL0.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTL0_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL0.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTL0_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL0.Reg, volatile.LoadUint32(&o.EPTCTL0.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTL0_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL0.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTSETSTA0: UDPHS Endpoint Set Status Register (endpoint = 0)
func (o *UDPHS_Type) SetEPTSETSTA0_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA0.Reg, volatile.LoadUint32(&o.EPTSETSTA0.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTSETSTA0_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA0.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTSETSTA0_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA0.Reg, volatile.LoadUint32(&o.EPTSETSTA0.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTSETSTA0_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA0.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTSETSTA0_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA0.Reg, volatile.LoadUint32(&o.EPTSETSTA0.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTSETSTA0_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA0.Reg) & 0x800) >> 11
}

// UDPHS.EPTCLRSTA0: UDPHS Endpoint Clear Status Register (endpoint = 0)
func (o *UDPHS_Type) SetEPTCLRSTA0_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA0.Reg, volatile.LoadUint32(&o.EPTCLRSTA0.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTCLRSTA0_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA0.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTCLRSTA0_TOGGLESQ(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA0.Reg, volatile.LoadUint32(&o.EPTCLRSTA0.Reg)&^(0x40)|value<<6)
}
func (o *UDPHS_Type) GetEPTCLRSTA0_TOGGLESQ() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA0.Reg) & 0x40) >> 6
}
func (o *UDPHS_Type) SetEPTCLRSTA0_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA0.Reg, volatile.LoadUint32(&o.EPTCLRSTA0.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCLRSTA0_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA0.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCLRSTA0_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA0.Reg, volatile.LoadUint32(&o.EPTCLRSTA0.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCLRSTA0_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA0.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCLRSTA0_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA0.Reg, volatile.LoadUint32(&o.EPTCLRSTA0.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCLRSTA0_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA0.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCLRSTA0_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA0.Reg, volatile.LoadUint32(&o.EPTCLRSTA0.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCLRSTA0_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA0.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCLRSTA0_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA0.Reg, volatile.LoadUint32(&o.EPTCLRSTA0.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCLRSTA0_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA0.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCLRSTA0_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA0.Reg, volatile.LoadUint32(&o.EPTCLRSTA0.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCLRSTA0_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA0.Reg) & 0x8000) >> 15
}

// UDPHS.EPTSTA0: UDPHS Endpoint Status Register (endpoint = 0)
func (o *UDPHS_Type) SetEPTSTA0_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTSTA0.Reg, volatile.LoadUint32(&o.EPTSTA0.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTSTA0_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA0.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTSTA0_TOGGLESQ_STA(value uint32) {
	volatile.StoreUint32(&o.EPTSTA0.Reg, volatile.LoadUint32(&o.EPTSTA0.Reg)&^(0xc0)|value<<6)
}
func (o *UDPHS_Type) GetEPTSTA0_TOGGLESQ_STA() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA0.Reg) & 0xc0) >> 6
}
func (o *UDPHS_Type) SetEPTSTA0_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTSTA0.Reg, volatile.LoadUint32(&o.EPTSTA0.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTSTA0_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA0.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTSTA0_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTSTA0.Reg, volatile.LoadUint32(&o.EPTSTA0.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTSTA0_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA0.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTSTA0_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA0.Reg, volatile.LoadUint32(&o.EPTSTA0.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTSTA0_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA0.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTSTA0_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTSTA0.Reg, volatile.LoadUint32(&o.EPTSTA0.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTSTA0_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA0.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTSTA0_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTSTA0.Reg, volatile.LoadUint32(&o.EPTSTA0.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTSTA0_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA0.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTSTA0_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA0.Reg, volatile.LoadUint32(&o.EPTSTA0.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTSTA0_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA0.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTSTA0_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTSTA0.Reg, volatile.LoadUint32(&o.EPTSTA0.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTSTA0_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA0.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTSTA0_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA0.Reg, volatile.LoadUint32(&o.EPTSTA0.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTSTA0_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA0.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTSTA0_CURBK_CTLDIR(value uint32) {
	volatile.StoreUint32(&o.EPTSTA0.Reg, volatile.LoadUint32(&o.EPTSTA0.Reg)&^(0x30000)|value<<16)
}
func (o *UDPHS_Type) GetEPTSTA0_CURBK_CTLDIR() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA0.Reg) & 0x30000) >> 16
}
func (o *UDPHS_Type) SetEPTSTA0_BUSY_BANK_STA(value uint32) {
	volatile.StoreUint32(&o.EPTSTA0.Reg, volatile.LoadUint32(&o.EPTSTA0.Reg)&^(0xc0000)|value<<18)
}
func (o *UDPHS_Type) GetEPTSTA0_BUSY_BANK_STA() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA0.Reg) & 0xc0000) >> 18
}
func (o *UDPHS_Type) SetEPTSTA0_BYTE_COUNT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA0.Reg, volatile.LoadUint32(&o.EPTSTA0.Reg)&^(0x7ff00000)|value<<20)
}
func (o *UDPHS_Type) GetEPTSTA0_BYTE_COUNT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA0.Reg) & 0x7ff00000) >> 20
}
func (o *UDPHS_Type) SetEPTSTA0_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA0.Reg, volatile.LoadUint32(&o.EPTSTA0.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTSTA0_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA0.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCFG1: UDPHS Endpoint Configuration Register (endpoint = 1)
func (o *UDPHS_Type) SetEPTCFG1_EPT_SIZE(value uint32) {
	volatile.StoreUint32(&o.EPTCFG1.Reg, volatile.LoadUint32(&o.EPTCFG1.Reg)&^(0x7)|value)
}
func (o *UDPHS_Type) GetEPTCFG1_EPT_SIZE() uint32 {
	return volatile.LoadUint32(&o.EPTCFG1.Reg) & 0x7
}
func (o *UDPHS_Type) SetEPTCFG1_EPT_DIR(value uint32) {
	volatile.StoreUint32(&o.EPTCFG1.Reg, volatile.LoadUint32(&o.EPTCFG1.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCFG1_EPT_DIR() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG1.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCFG1_EPT_TYPE(value uint32) {
	volatile.StoreUint32(&o.EPTCFG1.Reg, volatile.LoadUint32(&o.EPTCFG1.Reg)&^(0x30)|value<<4)
}
func (o *UDPHS_Type) GetEPTCFG1_EPT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG1.Reg) & 0x30) >> 4
}
func (o *UDPHS_Type) SetEPTCFG1_BK_NUMBER(value uint32) {
	volatile.StoreUint32(&o.EPTCFG1.Reg, volatile.LoadUint32(&o.EPTCFG1.Reg)&^(0xc0)|value<<6)
}
func (o *UDPHS_Type) GetEPTCFG1_BK_NUMBER() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG1.Reg) & 0xc0) >> 6
}
func (o *UDPHS_Type) SetEPTCFG1_NB_TRANS(value uint32) {
	volatile.StoreUint32(&o.EPTCFG1.Reg, volatile.LoadUint32(&o.EPTCFG1.Reg)&^(0x300)|value<<8)
}
func (o *UDPHS_Type) GetEPTCFG1_NB_TRANS() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG1.Reg) & 0x300) >> 8
}
func (o *UDPHS_Type) SetEPTCFG1_EPT_MAPD(value uint32) {
	volatile.StoreUint32(&o.EPTCFG1.Reg, volatile.LoadUint32(&o.EPTCFG1.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCFG1_EPT_MAPD() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG1.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTLENB1: UDPHS Endpoint Control Enable Register (endpoint = 1)
func (o *UDPHS_Type) SetEPTCTLENB1_EPT_ENABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB1.Reg, volatile.LoadUint32(&o.EPTCTLENB1.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTLENB1_EPT_ENABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTLENB1.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTLENB1_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB1.Reg, volatile.LoadUint32(&o.EPTCTLENB1.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTLENB1_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB1.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTLENB1_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB1.Reg, volatile.LoadUint32(&o.EPTCTLENB1.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTLENB1_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB1.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTLENB1_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB1.Reg, volatile.LoadUint32(&o.EPTCTLENB1.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTLENB1_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB1.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTLENB1_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB1.Reg, volatile.LoadUint32(&o.EPTCTLENB1.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTLENB1_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB1.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTLENB1_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB1.Reg, volatile.LoadUint32(&o.EPTCTLENB1.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTLENB1_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB1.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTLENB1_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB1.Reg, volatile.LoadUint32(&o.EPTCTLENB1.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTLENB1_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB1.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTLENB1_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB1.Reg, volatile.LoadUint32(&o.EPTCTLENB1.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTLENB1_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB1.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTLENB1_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB1.Reg, volatile.LoadUint32(&o.EPTCTLENB1.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTLENB1_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB1.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTLENB1_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB1.Reg, volatile.LoadUint32(&o.EPTCTLENB1.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTLENB1_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB1.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTLENB1_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB1.Reg, volatile.LoadUint32(&o.EPTCTLENB1.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTLENB1_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB1.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTLENB1_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB1.Reg, volatile.LoadUint32(&o.EPTCTLENB1.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTLENB1_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB1.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTLENB1_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB1.Reg, volatile.LoadUint32(&o.EPTCTLENB1.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTLENB1_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB1.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTLENB1_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB1.Reg, volatile.LoadUint32(&o.EPTCTLENB1.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTLENB1_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB1.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTLDIS1: UDPHS Endpoint Control Disable Register (endpoint = 1)
func (o *UDPHS_Type) SetEPTCTLDIS1_EPT_DISABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS1.Reg, volatile.LoadUint32(&o.EPTCTLDIS1.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTLDIS1_EPT_DISABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTLDIS1.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTLDIS1_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS1.Reg, volatile.LoadUint32(&o.EPTCTLDIS1.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTLDIS1_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS1.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTLDIS1_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS1.Reg, volatile.LoadUint32(&o.EPTCTLDIS1.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTLDIS1_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS1.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTLDIS1_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS1.Reg, volatile.LoadUint32(&o.EPTCTLDIS1.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTLDIS1_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS1.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTLDIS1_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS1.Reg, volatile.LoadUint32(&o.EPTCTLDIS1.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTLDIS1_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS1.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTLDIS1_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS1.Reg, volatile.LoadUint32(&o.EPTCTLDIS1.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTLDIS1_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS1.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTLDIS1_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS1.Reg, volatile.LoadUint32(&o.EPTCTLDIS1.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTLDIS1_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS1.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTLDIS1_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS1.Reg, volatile.LoadUint32(&o.EPTCTLDIS1.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTLDIS1_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS1.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTLDIS1_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS1.Reg, volatile.LoadUint32(&o.EPTCTLDIS1.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTLDIS1_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS1.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTLDIS1_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS1.Reg, volatile.LoadUint32(&o.EPTCTLDIS1.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTLDIS1_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS1.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTLDIS1_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS1.Reg, volatile.LoadUint32(&o.EPTCTLDIS1.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTLDIS1_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS1.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTLDIS1_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS1.Reg, volatile.LoadUint32(&o.EPTCTLDIS1.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTLDIS1_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS1.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTLDIS1_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS1.Reg, volatile.LoadUint32(&o.EPTCTLDIS1.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTLDIS1_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS1.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTLDIS1_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS1.Reg, volatile.LoadUint32(&o.EPTCTLDIS1.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTLDIS1_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS1.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTL1: UDPHS Endpoint Control Register (endpoint = 1)
func (o *UDPHS_Type) SetEPTCTL1_EPT_ENABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTL1.Reg, volatile.LoadUint32(&o.EPTCTL1.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTL1_EPT_ENABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTL1.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTL1_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTL1.Reg, volatile.LoadUint32(&o.EPTCTL1.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTL1_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL1.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTL1_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTL1.Reg, volatile.LoadUint32(&o.EPTCTL1.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTL1_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL1.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTL1_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTL1.Reg, volatile.LoadUint32(&o.EPTCTL1.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTL1_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL1.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTL1_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTL1.Reg, volatile.LoadUint32(&o.EPTCTL1.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTL1_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL1.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTL1_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTL1.Reg, volatile.LoadUint32(&o.EPTCTL1.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTL1_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL1.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTL1_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL1.Reg, volatile.LoadUint32(&o.EPTCTL1.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTL1_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL1.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTL1_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTL1.Reg, volatile.LoadUint32(&o.EPTCTL1.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTL1_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL1.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTL1_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTL1.Reg, volatile.LoadUint32(&o.EPTCTL1.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTL1_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL1.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTL1_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL1.Reg, volatile.LoadUint32(&o.EPTCTL1.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTL1_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL1.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTL1_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTL1.Reg, volatile.LoadUint32(&o.EPTCTL1.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTL1_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL1.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTL1_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL1.Reg, volatile.LoadUint32(&o.EPTCTL1.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTL1_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL1.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTL1_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTL1.Reg, volatile.LoadUint32(&o.EPTCTL1.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTL1_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL1.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTL1_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL1.Reg, volatile.LoadUint32(&o.EPTCTL1.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTL1_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL1.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTSETSTA1: UDPHS Endpoint Set Status Register (endpoint = 1)
func (o *UDPHS_Type) SetEPTSETSTA1_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA1.Reg, volatile.LoadUint32(&o.EPTSETSTA1.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTSETSTA1_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA1.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTSETSTA1_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA1.Reg, volatile.LoadUint32(&o.EPTSETSTA1.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTSETSTA1_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA1.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTSETSTA1_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA1.Reg, volatile.LoadUint32(&o.EPTSETSTA1.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTSETSTA1_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA1.Reg) & 0x800) >> 11
}

// UDPHS.EPTCLRSTA1: UDPHS Endpoint Clear Status Register (endpoint = 1)
func (o *UDPHS_Type) SetEPTCLRSTA1_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA1.Reg, volatile.LoadUint32(&o.EPTCLRSTA1.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTCLRSTA1_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA1.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTCLRSTA1_TOGGLESQ(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA1.Reg, volatile.LoadUint32(&o.EPTCLRSTA1.Reg)&^(0x40)|value<<6)
}
func (o *UDPHS_Type) GetEPTCLRSTA1_TOGGLESQ() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA1.Reg) & 0x40) >> 6
}
func (o *UDPHS_Type) SetEPTCLRSTA1_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA1.Reg, volatile.LoadUint32(&o.EPTCLRSTA1.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCLRSTA1_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA1.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCLRSTA1_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA1.Reg, volatile.LoadUint32(&o.EPTCLRSTA1.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCLRSTA1_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA1.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCLRSTA1_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA1.Reg, volatile.LoadUint32(&o.EPTCLRSTA1.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCLRSTA1_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA1.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCLRSTA1_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA1.Reg, volatile.LoadUint32(&o.EPTCLRSTA1.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCLRSTA1_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA1.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCLRSTA1_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA1.Reg, volatile.LoadUint32(&o.EPTCLRSTA1.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCLRSTA1_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA1.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCLRSTA1_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA1.Reg, volatile.LoadUint32(&o.EPTCLRSTA1.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCLRSTA1_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA1.Reg) & 0x8000) >> 15
}

// UDPHS.EPTSTA1: UDPHS Endpoint Status Register (endpoint = 1)
func (o *UDPHS_Type) SetEPTSTA1_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTSTA1.Reg, volatile.LoadUint32(&o.EPTSTA1.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTSTA1_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA1.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTSTA1_TOGGLESQ_STA(value uint32) {
	volatile.StoreUint32(&o.EPTSTA1.Reg, volatile.LoadUint32(&o.EPTSTA1.Reg)&^(0xc0)|value<<6)
}
func (o *UDPHS_Type) GetEPTSTA1_TOGGLESQ_STA() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA1.Reg) & 0xc0) >> 6
}
func (o *UDPHS_Type) SetEPTSTA1_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTSTA1.Reg, volatile.LoadUint32(&o.EPTSTA1.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTSTA1_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA1.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTSTA1_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTSTA1.Reg, volatile.LoadUint32(&o.EPTSTA1.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTSTA1_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA1.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTSTA1_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA1.Reg, volatile.LoadUint32(&o.EPTSTA1.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTSTA1_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA1.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTSTA1_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTSTA1.Reg, volatile.LoadUint32(&o.EPTSTA1.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTSTA1_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA1.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTSTA1_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTSTA1.Reg, volatile.LoadUint32(&o.EPTSTA1.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTSTA1_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA1.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTSTA1_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA1.Reg, volatile.LoadUint32(&o.EPTSTA1.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTSTA1_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA1.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTSTA1_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTSTA1.Reg, volatile.LoadUint32(&o.EPTSTA1.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTSTA1_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA1.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTSTA1_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA1.Reg, volatile.LoadUint32(&o.EPTSTA1.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTSTA1_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA1.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTSTA1_CURBK_CTLDIR(value uint32) {
	volatile.StoreUint32(&o.EPTSTA1.Reg, volatile.LoadUint32(&o.EPTSTA1.Reg)&^(0x30000)|value<<16)
}
func (o *UDPHS_Type) GetEPTSTA1_CURBK_CTLDIR() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA1.Reg) & 0x30000) >> 16
}
func (o *UDPHS_Type) SetEPTSTA1_BUSY_BANK_STA(value uint32) {
	volatile.StoreUint32(&o.EPTSTA1.Reg, volatile.LoadUint32(&o.EPTSTA1.Reg)&^(0xc0000)|value<<18)
}
func (o *UDPHS_Type) GetEPTSTA1_BUSY_BANK_STA() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA1.Reg) & 0xc0000) >> 18
}
func (o *UDPHS_Type) SetEPTSTA1_BYTE_COUNT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA1.Reg, volatile.LoadUint32(&o.EPTSTA1.Reg)&^(0x7ff00000)|value<<20)
}
func (o *UDPHS_Type) GetEPTSTA1_BYTE_COUNT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA1.Reg) & 0x7ff00000) >> 20
}
func (o *UDPHS_Type) SetEPTSTA1_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA1.Reg, volatile.LoadUint32(&o.EPTSTA1.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTSTA1_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA1.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCFG2: UDPHS Endpoint Configuration Register (endpoint = 2)
func (o *UDPHS_Type) SetEPTCFG2_EPT_SIZE(value uint32) {
	volatile.StoreUint32(&o.EPTCFG2.Reg, volatile.LoadUint32(&o.EPTCFG2.Reg)&^(0x7)|value)
}
func (o *UDPHS_Type) GetEPTCFG2_EPT_SIZE() uint32 {
	return volatile.LoadUint32(&o.EPTCFG2.Reg) & 0x7
}
func (o *UDPHS_Type) SetEPTCFG2_EPT_DIR(value uint32) {
	volatile.StoreUint32(&o.EPTCFG2.Reg, volatile.LoadUint32(&o.EPTCFG2.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCFG2_EPT_DIR() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG2.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCFG2_EPT_TYPE(value uint32) {
	volatile.StoreUint32(&o.EPTCFG2.Reg, volatile.LoadUint32(&o.EPTCFG2.Reg)&^(0x30)|value<<4)
}
func (o *UDPHS_Type) GetEPTCFG2_EPT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG2.Reg) & 0x30) >> 4
}
func (o *UDPHS_Type) SetEPTCFG2_BK_NUMBER(value uint32) {
	volatile.StoreUint32(&o.EPTCFG2.Reg, volatile.LoadUint32(&o.EPTCFG2.Reg)&^(0xc0)|value<<6)
}
func (o *UDPHS_Type) GetEPTCFG2_BK_NUMBER() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG2.Reg) & 0xc0) >> 6
}
func (o *UDPHS_Type) SetEPTCFG2_NB_TRANS(value uint32) {
	volatile.StoreUint32(&o.EPTCFG2.Reg, volatile.LoadUint32(&o.EPTCFG2.Reg)&^(0x300)|value<<8)
}
func (o *UDPHS_Type) GetEPTCFG2_NB_TRANS() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG2.Reg) & 0x300) >> 8
}
func (o *UDPHS_Type) SetEPTCFG2_EPT_MAPD(value uint32) {
	volatile.StoreUint32(&o.EPTCFG2.Reg, volatile.LoadUint32(&o.EPTCFG2.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCFG2_EPT_MAPD() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG2.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTLENB2: UDPHS Endpoint Control Enable Register (endpoint = 2)
func (o *UDPHS_Type) SetEPTCTLENB2_EPT_ENABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB2.Reg, volatile.LoadUint32(&o.EPTCTLENB2.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTLENB2_EPT_ENABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTLENB2.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTLENB2_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB2.Reg, volatile.LoadUint32(&o.EPTCTLENB2.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTLENB2_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB2.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTLENB2_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB2.Reg, volatile.LoadUint32(&o.EPTCTLENB2.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTLENB2_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB2.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTLENB2_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB2.Reg, volatile.LoadUint32(&o.EPTCTLENB2.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTLENB2_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB2.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTLENB2_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB2.Reg, volatile.LoadUint32(&o.EPTCTLENB2.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTLENB2_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB2.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTLENB2_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB2.Reg, volatile.LoadUint32(&o.EPTCTLENB2.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTLENB2_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB2.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTLENB2_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB2.Reg, volatile.LoadUint32(&o.EPTCTLENB2.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTLENB2_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB2.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTLENB2_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB2.Reg, volatile.LoadUint32(&o.EPTCTLENB2.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTLENB2_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB2.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTLENB2_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB2.Reg, volatile.LoadUint32(&o.EPTCTLENB2.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTLENB2_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB2.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTLENB2_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB2.Reg, volatile.LoadUint32(&o.EPTCTLENB2.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTLENB2_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB2.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTLENB2_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB2.Reg, volatile.LoadUint32(&o.EPTCTLENB2.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTLENB2_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB2.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTLENB2_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB2.Reg, volatile.LoadUint32(&o.EPTCTLENB2.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTLENB2_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB2.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTLENB2_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB2.Reg, volatile.LoadUint32(&o.EPTCTLENB2.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTLENB2_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB2.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTLENB2_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB2.Reg, volatile.LoadUint32(&o.EPTCTLENB2.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTLENB2_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB2.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTLDIS2: UDPHS Endpoint Control Disable Register (endpoint = 2)
func (o *UDPHS_Type) SetEPTCTLDIS2_EPT_DISABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS2.Reg, volatile.LoadUint32(&o.EPTCTLDIS2.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTLDIS2_EPT_DISABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTLDIS2.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTLDIS2_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS2.Reg, volatile.LoadUint32(&o.EPTCTLDIS2.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTLDIS2_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS2.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTLDIS2_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS2.Reg, volatile.LoadUint32(&o.EPTCTLDIS2.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTLDIS2_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS2.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTLDIS2_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS2.Reg, volatile.LoadUint32(&o.EPTCTLDIS2.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTLDIS2_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS2.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTLDIS2_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS2.Reg, volatile.LoadUint32(&o.EPTCTLDIS2.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTLDIS2_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS2.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTLDIS2_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS2.Reg, volatile.LoadUint32(&o.EPTCTLDIS2.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTLDIS2_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS2.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTLDIS2_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS2.Reg, volatile.LoadUint32(&o.EPTCTLDIS2.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTLDIS2_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS2.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTLDIS2_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS2.Reg, volatile.LoadUint32(&o.EPTCTLDIS2.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTLDIS2_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS2.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTLDIS2_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS2.Reg, volatile.LoadUint32(&o.EPTCTLDIS2.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTLDIS2_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS2.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTLDIS2_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS2.Reg, volatile.LoadUint32(&o.EPTCTLDIS2.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTLDIS2_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS2.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTLDIS2_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS2.Reg, volatile.LoadUint32(&o.EPTCTLDIS2.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTLDIS2_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS2.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTLDIS2_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS2.Reg, volatile.LoadUint32(&o.EPTCTLDIS2.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTLDIS2_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS2.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTLDIS2_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS2.Reg, volatile.LoadUint32(&o.EPTCTLDIS2.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTLDIS2_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS2.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTLDIS2_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS2.Reg, volatile.LoadUint32(&o.EPTCTLDIS2.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTLDIS2_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS2.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTL2: UDPHS Endpoint Control Register (endpoint = 2)
func (o *UDPHS_Type) SetEPTCTL2_EPT_ENABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTL2.Reg, volatile.LoadUint32(&o.EPTCTL2.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTL2_EPT_ENABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTL2.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTL2_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTL2.Reg, volatile.LoadUint32(&o.EPTCTL2.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTL2_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL2.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTL2_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTL2.Reg, volatile.LoadUint32(&o.EPTCTL2.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTL2_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL2.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTL2_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTL2.Reg, volatile.LoadUint32(&o.EPTCTL2.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTL2_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL2.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTL2_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTL2.Reg, volatile.LoadUint32(&o.EPTCTL2.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTL2_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL2.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTL2_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTL2.Reg, volatile.LoadUint32(&o.EPTCTL2.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTL2_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL2.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTL2_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL2.Reg, volatile.LoadUint32(&o.EPTCTL2.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTL2_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL2.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTL2_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTL2.Reg, volatile.LoadUint32(&o.EPTCTL2.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTL2_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL2.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTL2_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTL2.Reg, volatile.LoadUint32(&o.EPTCTL2.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTL2_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL2.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTL2_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL2.Reg, volatile.LoadUint32(&o.EPTCTL2.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTL2_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL2.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTL2_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTL2.Reg, volatile.LoadUint32(&o.EPTCTL2.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTL2_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL2.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTL2_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL2.Reg, volatile.LoadUint32(&o.EPTCTL2.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTL2_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL2.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTL2_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTL2.Reg, volatile.LoadUint32(&o.EPTCTL2.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTL2_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL2.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTL2_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL2.Reg, volatile.LoadUint32(&o.EPTCTL2.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTL2_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL2.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTSETSTA2: UDPHS Endpoint Set Status Register (endpoint = 2)
func (o *UDPHS_Type) SetEPTSETSTA2_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA2.Reg, volatile.LoadUint32(&o.EPTSETSTA2.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTSETSTA2_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA2.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTSETSTA2_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA2.Reg, volatile.LoadUint32(&o.EPTSETSTA2.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTSETSTA2_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA2.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTSETSTA2_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA2.Reg, volatile.LoadUint32(&o.EPTSETSTA2.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTSETSTA2_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA2.Reg) & 0x800) >> 11
}

// UDPHS.EPTCLRSTA2: UDPHS Endpoint Clear Status Register (endpoint = 2)
func (o *UDPHS_Type) SetEPTCLRSTA2_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA2.Reg, volatile.LoadUint32(&o.EPTCLRSTA2.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTCLRSTA2_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA2.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTCLRSTA2_TOGGLESQ(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA2.Reg, volatile.LoadUint32(&o.EPTCLRSTA2.Reg)&^(0x40)|value<<6)
}
func (o *UDPHS_Type) GetEPTCLRSTA2_TOGGLESQ() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA2.Reg) & 0x40) >> 6
}
func (o *UDPHS_Type) SetEPTCLRSTA2_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA2.Reg, volatile.LoadUint32(&o.EPTCLRSTA2.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCLRSTA2_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA2.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCLRSTA2_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA2.Reg, volatile.LoadUint32(&o.EPTCLRSTA2.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCLRSTA2_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA2.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCLRSTA2_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA2.Reg, volatile.LoadUint32(&o.EPTCLRSTA2.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCLRSTA2_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA2.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCLRSTA2_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA2.Reg, volatile.LoadUint32(&o.EPTCLRSTA2.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCLRSTA2_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA2.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCLRSTA2_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA2.Reg, volatile.LoadUint32(&o.EPTCLRSTA2.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCLRSTA2_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA2.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCLRSTA2_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA2.Reg, volatile.LoadUint32(&o.EPTCLRSTA2.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCLRSTA2_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA2.Reg) & 0x8000) >> 15
}

// UDPHS.EPTSTA2: UDPHS Endpoint Status Register (endpoint = 2)
func (o *UDPHS_Type) SetEPTSTA2_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTSTA2.Reg, volatile.LoadUint32(&o.EPTSTA2.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTSTA2_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA2.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTSTA2_TOGGLESQ_STA(value uint32) {
	volatile.StoreUint32(&o.EPTSTA2.Reg, volatile.LoadUint32(&o.EPTSTA2.Reg)&^(0xc0)|value<<6)
}
func (o *UDPHS_Type) GetEPTSTA2_TOGGLESQ_STA() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA2.Reg) & 0xc0) >> 6
}
func (o *UDPHS_Type) SetEPTSTA2_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTSTA2.Reg, volatile.LoadUint32(&o.EPTSTA2.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTSTA2_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA2.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTSTA2_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTSTA2.Reg, volatile.LoadUint32(&o.EPTSTA2.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTSTA2_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA2.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTSTA2_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA2.Reg, volatile.LoadUint32(&o.EPTSTA2.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTSTA2_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA2.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTSTA2_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTSTA2.Reg, volatile.LoadUint32(&o.EPTSTA2.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTSTA2_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA2.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTSTA2_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTSTA2.Reg, volatile.LoadUint32(&o.EPTSTA2.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTSTA2_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA2.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTSTA2_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA2.Reg, volatile.LoadUint32(&o.EPTSTA2.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTSTA2_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA2.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTSTA2_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTSTA2.Reg, volatile.LoadUint32(&o.EPTSTA2.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTSTA2_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA2.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTSTA2_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA2.Reg, volatile.LoadUint32(&o.EPTSTA2.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTSTA2_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA2.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTSTA2_CURBK_CTLDIR(value uint32) {
	volatile.StoreUint32(&o.EPTSTA2.Reg, volatile.LoadUint32(&o.EPTSTA2.Reg)&^(0x30000)|value<<16)
}
func (o *UDPHS_Type) GetEPTSTA2_CURBK_CTLDIR() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA2.Reg) & 0x30000) >> 16
}
func (o *UDPHS_Type) SetEPTSTA2_BUSY_BANK_STA(value uint32) {
	volatile.StoreUint32(&o.EPTSTA2.Reg, volatile.LoadUint32(&o.EPTSTA2.Reg)&^(0xc0000)|value<<18)
}
func (o *UDPHS_Type) GetEPTSTA2_BUSY_BANK_STA() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA2.Reg) & 0xc0000) >> 18
}
func (o *UDPHS_Type) SetEPTSTA2_BYTE_COUNT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA2.Reg, volatile.LoadUint32(&o.EPTSTA2.Reg)&^(0x7ff00000)|value<<20)
}
func (o *UDPHS_Type) GetEPTSTA2_BYTE_COUNT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA2.Reg) & 0x7ff00000) >> 20
}
func (o *UDPHS_Type) SetEPTSTA2_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA2.Reg, volatile.LoadUint32(&o.EPTSTA2.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTSTA2_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA2.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCFG3: UDPHS Endpoint Configuration Register (endpoint = 3)
func (o *UDPHS_Type) SetEPTCFG3_EPT_SIZE(value uint32) {
	volatile.StoreUint32(&o.EPTCFG3.Reg, volatile.LoadUint32(&o.EPTCFG3.Reg)&^(0x7)|value)
}
func (o *UDPHS_Type) GetEPTCFG3_EPT_SIZE() uint32 {
	return volatile.LoadUint32(&o.EPTCFG3.Reg) & 0x7
}
func (o *UDPHS_Type) SetEPTCFG3_EPT_DIR(value uint32) {
	volatile.StoreUint32(&o.EPTCFG3.Reg, volatile.LoadUint32(&o.EPTCFG3.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCFG3_EPT_DIR() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG3.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCFG3_EPT_TYPE(value uint32) {
	volatile.StoreUint32(&o.EPTCFG3.Reg, volatile.LoadUint32(&o.EPTCFG3.Reg)&^(0x30)|value<<4)
}
func (o *UDPHS_Type) GetEPTCFG3_EPT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG3.Reg) & 0x30) >> 4
}
func (o *UDPHS_Type) SetEPTCFG3_BK_NUMBER(value uint32) {
	volatile.StoreUint32(&o.EPTCFG3.Reg, volatile.LoadUint32(&o.EPTCFG3.Reg)&^(0xc0)|value<<6)
}
func (o *UDPHS_Type) GetEPTCFG3_BK_NUMBER() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG3.Reg) & 0xc0) >> 6
}
func (o *UDPHS_Type) SetEPTCFG3_NB_TRANS(value uint32) {
	volatile.StoreUint32(&o.EPTCFG3.Reg, volatile.LoadUint32(&o.EPTCFG3.Reg)&^(0x300)|value<<8)
}
func (o *UDPHS_Type) GetEPTCFG3_NB_TRANS() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG3.Reg) & 0x300) >> 8
}
func (o *UDPHS_Type) SetEPTCFG3_EPT_MAPD(value uint32) {
	volatile.StoreUint32(&o.EPTCFG3.Reg, volatile.LoadUint32(&o.EPTCFG3.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCFG3_EPT_MAPD() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG3.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTLENB3: UDPHS Endpoint Control Enable Register (endpoint = 3)
func (o *UDPHS_Type) SetEPTCTLENB3_EPT_ENABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB3.Reg, volatile.LoadUint32(&o.EPTCTLENB3.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTLENB3_EPT_ENABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTLENB3.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTLENB3_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB3.Reg, volatile.LoadUint32(&o.EPTCTLENB3.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTLENB3_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB3.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTLENB3_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB3.Reg, volatile.LoadUint32(&o.EPTCTLENB3.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTLENB3_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB3.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTLENB3_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB3.Reg, volatile.LoadUint32(&o.EPTCTLENB3.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTLENB3_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB3.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTLENB3_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB3.Reg, volatile.LoadUint32(&o.EPTCTLENB3.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTLENB3_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB3.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTLENB3_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB3.Reg, volatile.LoadUint32(&o.EPTCTLENB3.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTLENB3_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB3.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTLENB3_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB3.Reg, volatile.LoadUint32(&o.EPTCTLENB3.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTLENB3_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB3.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTLENB3_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB3.Reg, volatile.LoadUint32(&o.EPTCTLENB3.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTLENB3_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB3.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTLENB3_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB3.Reg, volatile.LoadUint32(&o.EPTCTLENB3.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTLENB3_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB3.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTLENB3_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB3.Reg, volatile.LoadUint32(&o.EPTCTLENB3.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTLENB3_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB3.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTLENB3_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB3.Reg, volatile.LoadUint32(&o.EPTCTLENB3.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTLENB3_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB3.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTLENB3_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB3.Reg, volatile.LoadUint32(&o.EPTCTLENB3.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTLENB3_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB3.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTLENB3_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB3.Reg, volatile.LoadUint32(&o.EPTCTLENB3.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTLENB3_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB3.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTLENB3_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB3.Reg, volatile.LoadUint32(&o.EPTCTLENB3.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTLENB3_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB3.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTLDIS3: UDPHS Endpoint Control Disable Register (endpoint = 3)
func (o *UDPHS_Type) SetEPTCTLDIS3_EPT_DISABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS3.Reg, volatile.LoadUint32(&o.EPTCTLDIS3.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTLDIS3_EPT_DISABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTLDIS3.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTLDIS3_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS3.Reg, volatile.LoadUint32(&o.EPTCTLDIS3.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTLDIS3_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS3.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTLDIS3_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS3.Reg, volatile.LoadUint32(&o.EPTCTLDIS3.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTLDIS3_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS3.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTLDIS3_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS3.Reg, volatile.LoadUint32(&o.EPTCTLDIS3.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTLDIS3_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS3.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTLDIS3_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS3.Reg, volatile.LoadUint32(&o.EPTCTLDIS3.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTLDIS3_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS3.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTLDIS3_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS3.Reg, volatile.LoadUint32(&o.EPTCTLDIS3.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTLDIS3_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS3.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTLDIS3_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS3.Reg, volatile.LoadUint32(&o.EPTCTLDIS3.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTLDIS3_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS3.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTLDIS3_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS3.Reg, volatile.LoadUint32(&o.EPTCTLDIS3.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTLDIS3_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS3.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTLDIS3_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS3.Reg, volatile.LoadUint32(&o.EPTCTLDIS3.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTLDIS3_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS3.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTLDIS3_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS3.Reg, volatile.LoadUint32(&o.EPTCTLDIS3.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTLDIS3_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS3.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTLDIS3_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS3.Reg, volatile.LoadUint32(&o.EPTCTLDIS3.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTLDIS3_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS3.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTLDIS3_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS3.Reg, volatile.LoadUint32(&o.EPTCTLDIS3.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTLDIS3_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS3.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTLDIS3_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS3.Reg, volatile.LoadUint32(&o.EPTCTLDIS3.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTLDIS3_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS3.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTLDIS3_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS3.Reg, volatile.LoadUint32(&o.EPTCTLDIS3.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTLDIS3_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS3.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTL3: UDPHS Endpoint Control Register (endpoint = 3)
func (o *UDPHS_Type) SetEPTCTL3_EPT_ENABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTL3.Reg, volatile.LoadUint32(&o.EPTCTL3.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTL3_EPT_ENABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTL3.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTL3_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTL3.Reg, volatile.LoadUint32(&o.EPTCTL3.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTL3_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL3.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTL3_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTL3.Reg, volatile.LoadUint32(&o.EPTCTL3.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTL3_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL3.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTL3_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTL3.Reg, volatile.LoadUint32(&o.EPTCTL3.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTL3_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL3.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTL3_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTL3.Reg, volatile.LoadUint32(&o.EPTCTL3.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTL3_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL3.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTL3_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTL3.Reg, volatile.LoadUint32(&o.EPTCTL3.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTL3_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL3.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTL3_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL3.Reg, volatile.LoadUint32(&o.EPTCTL3.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTL3_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL3.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTL3_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTL3.Reg, volatile.LoadUint32(&o.EPTCTL3.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTL3_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL3.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTL3_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTL3.Reg, volatile.LoadUint32(&o.EPTCTL3.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTL3_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL3.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTL3_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL3.Reg, volatile.LoadUint32(&o.EPTCTL3.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTL3_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL3.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTL3_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTL3.Reg, volatile.LoadUint32(&o.EPTCTL3.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTL3_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL3.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTL3_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL3.Reg, volatile.LoadUint32(&o.EPTCTL3.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTL3_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL3.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTL3_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTL3.Reg, volatile.LoadUint32(&o.EPTCTL3.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTL3_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL3.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTL3_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL3.Reg, volatile.LoadUint32(&o.EPTCTL3.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTL3_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL3.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTSETSTA3: UDPHS Endpoint Set Status Register (endpoint = 3)
func (o *UDPHS_Type) SetEPTSETSTA3_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA3.Reg, volatile.LoadUint32(&o.EPTSETSTA3.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTSETSTA3_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA3.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTSETSTA3_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA3.Reg, volatile.LoadUint32(&o.EPTSETSTA3.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTSETSTA3_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA3.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTSETSTA3_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA3.Reg, volatile.LoadUint32(&o.EPTSETSTA3.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTSETSTA3_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA3.Reg) & 0x800) >> 11
}

// UDPHS.EPTCLRSTA3: UDPHS Endpoint Clear Status Register (endpoint = 3)
func (o *UDPHS_Type) SetEPTCLRSTA3_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA3.Reg, volatile.LoadUint32(&o.EPTCLRSTA3.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTCLRSTA3_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA3.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTCLRSTA3_TOGGLESQ(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA3.Reg, volatile.LoadUint32(&o.EPTCLRSTA3.Reg)&^(0x40)|value<<6)
}
func (o *UDPHS_Type) GetEPTCLRSTA3_TOGGLESQ() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA3.Reg) & 0x40) >> 6
}
func (o *UDPHS_Type) SetEPTCLRSTA3_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA3.Reg, volatile.LoadUint32(&o.EPTCLRSTA3.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCLRSTA3_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA3.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCLRSTA3_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA3.Reg, volatile.LoadUint32(&o.EPTCLRSTA3.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCLRSTA3_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA3.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCLRSTA3_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA3.Reg, volatile.LoadUint32(&o.EPTCLRSTA3.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCLRSTA3_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA3.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCLRSTA3_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA3.Reg, volatile.LoadUint32(&o.EPTCLRSTA3.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCLRSTA3_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA3.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCLRSTA3_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA3.Reg, volatile.LoadUint32(&o.EPTCLRSTA3.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCLRSTA3_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA3.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCLRSTA3_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA3.Reg, volatile.LoadUint32(&o.EPTCLRSTA3.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCLRSTA3_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA3.Reg) & 0x8000) >> 15
}

// UDPHS.EPTSTA3: UDPHS Endpoint Status Register (endpoint = 3)
func (o *UDPHS_Type) SetEPTSTA3_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTSTA3.Reg, volatile.LoadUint32(&o.EPTSTA3.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTSTA3_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA3.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTSTA3_TOGGLESQ_STA(value uint32) {
	volatile.StoreUint32(&o.EPTSTA3.Reg, volatile.LoadUint32(&o.EPTSTA3.Reg)&^(0xc0)|value<<6)
}
func (o *UDPHS_Type) GetEPTSTA3_TOGGLESQ_STA() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA3.Reg) & 0xc0) >> 6
}
func (o *UDPHS_Type) SetEPTSTA3_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTSTA3.Reg, volatile.LoadUint32(&o.EPTSTA3.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTSTA3_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA3.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTSTA3_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTSTA3.Reg, volatile.LoadUint32(&o.EPTSTA3.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTSTA3_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA3.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTSTA3_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA3.Reg, volatile.LoadUint32(&o.EPTSTA3.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTSTA3_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA3.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTSTA3_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTSTA3.Reg, volatile.LoadUint32(&o.EPTSTA3.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTSTA3_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA3.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTSTA3_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTSTA3.Reg, volatile.LoadUint32(&o.EPTSTA3.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTSTA3_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA3.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTSTA3_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA3.Reg, volatile.LoadUint32(&o.EPTSTA3.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTSTA3_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA3.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTSTA3_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTSTA3.Reg, volatile.LoadUint32(&o.EPTSTA3.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTSTA3_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA3.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTSTA3_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA3.Reg, volatile.LoadUint32(&o.EPTSTA3.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTSTA3_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA3.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTSTA3_CURBK_CTLDIR(value uint32) {
	volatile.StoreUint32(&o.EPTSTA3.Reg, volatile.LoadUint32(&o.EPTSTA3.Reg)&^(0x30000)|value<<16)
}
func (o *UDPHS_Type) GetEPTSTA3_CURBK_CTLDIR() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA3.Reg) & 0x30000) >> 16
}
func (o *UDPHS_Type) SetEPTSTA3_BUSY_BANK_STA(value uint32) {
	volatile.StoreUint32(&o.EPTSTA3.Reg, volatile.LoadUint32(&o.EPTSTA3.Reg)&^(0xc0000)|value<<18)
}
func (o *UDPHS_Type) GetEPTSTA3_BUSY_BANK_STA() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA3.Reg) & 0xc0000) >> 18
}
func (o *UDPHS_Type) SetEPTSTA3_BYTE_COUNT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA3.Reg, volatile.LoadUint32(&o.EPTSTA3.Reg)&^(0x7ff00000)|value<<20)
}
func (o *UDPHS_Type) GetEPTSTA3_BYTE_COUNT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA3.Reg) & 0x7ff00000) >> 20
}
func (o *UDPHS_Type) SetEPTSTA3_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA3.Reg, volatile.LoadUint32(&o.EPTSTA3.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTSTA3_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA3.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCFG4: UDPHS Endpoint Configuration Register (endpoint = 4)
func (o *UDPHS_Type) SetEPTCFG4_EPT_SIZE(value uint32) {
	volatile.StoreUint32(&o.EPTCFG4.Reg, volatile.LoadUint32(&o.EPTCFG4.Reg)&^(0x7)|value)
}
func (o *UDPHS_Type) GetEPTCFG4_EPT_SIZE() uint32 {
	return volatile.LoadUint32(&o.EPTCFG4.Reg) & 0x7
}
func (o *UDPHS_Type) SetEPTCFG4_EPT_DIR(value uint32) {
	volatile.StoreUint32(&o.EPTCFG4.Reg, volatile.LoadUint32(&o.EPTCFG4.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCFG4_EPT_DIR() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG4.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCFG4_EPT_TYPE(value uint32) {
	volatile.StoreUint32(&o.EPTCFG4.Reg, volatile.LoadUint32(&o.EPTCFG4.Reg)&^(0x30)|value<<4)
}
func (o *UDPHS_Type) GetEPTCFG4_EPT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG4.Reg) & 0x30) >> 4
}
func (o *UDPHS_Type) SetEPTCFG4_BK_NUMBER(value uint32) {
	volatile.StoreUint32(&o.EPTCFG4.Reg, volatile.LoadUint32(&o.EPTCFG4.Reg)&^(0xc0)|value<<6)
}
func (o *UDPHS_Type) GetEPTCFG4_BK_NUMBER() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG4.Reg) & 0xc0) >> 6
}
func (o *UDPHS_Type) SetEPTCFG4_NB_TRANS(value uint32) {
	volatile.StoreUint32(&o.EPTCFG4.Reg, volatile.LoadUint32(&o.EPTCFG4.Reg)&^(0x300)|value<<8)
}
func (o *UDPHS_Type) GetEPTCFG4_NB_TRANS() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG4.Reg) & 0x300) >> 8
}
func (o *UDPHS_Type) SetEPTCFG4_EPT_MAPD(value uint32) {
	volatile.StoreUint32(&o.EPTCFG4.Reg, volatile.LoadUint32(&o.EPTCFG4.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCFG4_EPT_MAPD() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG4.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTLENB4: UDPHS Endpoint Control Enable Register (endpoint = 4)
func (o *UDPHS_Type) SetEPTCTLENB4_EPT_ENABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB4.Reg, volatile.LoadUint32(&o.EPTCTLENB4.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTLENB4_EPT_ENABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTLENB4.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTLENB4_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB4.Reg, volatile.LoadUint32(&o.EPTCTLENB4.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTLENB4_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB4.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTLENB4_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB4.Reg, volatile.LoadUint32(&o.EPTCTLENB4.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTLENB4_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB4.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTLENB4_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB4.Reg, volatile.LoadUint32(&o.EPTCTLENB4.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTLENB4_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB4.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTLENB4_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB4.Reg, volatile.LoadUint32(&o.EPTCTLENB4.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTLENB4_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB4.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTLENB4_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB4.Reg, volatile.LoadUint32(&o.EPTCTLENB4.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTLENB4_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB4.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTLENB4_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB4.Reg, volatile.LoadUint32(&o.EPTCTLENB4.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTLENB4_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB4.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTLENB4_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB4.Reg, volatile.LoadUint32(&o.EPTCTLENB4.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTLENB4_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB4.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTLENB4_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB4.Reg, volatile.LoadUint32(&o.EPTCTLENB4.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTLENB4_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB4.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTLENB4_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB4.Reg, volatile.LoadUint32(&o.EPTCTLENB4.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTLENB4_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB4.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTLENB4_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB4.Reg, volatile.LoadUint32(&o.EPTCTLENB4.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTLENB4_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB4.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTLENB4_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB4.Reg, volatile.LoadUint32(&o.EPTCTLENB4.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTLENB4_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB4.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTLENB4_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB4.Reg, volatile.LoadUint32(&o.EPTCTLENB4.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTLENB4_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB4.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTLENB4_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB4.Reg, volatile.LoadUint32(&o.EPTCTLENB4.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTLENB4_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB4.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTLDIS4: UDPHS Endpoint Control Disable Register (endpoint = 4)
func (o *UDPHS_Type) SetEPTCTLDIS4_EPT_DISABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS4.Reg, volatile.LoadUint32(&o.EPTCTLDIS4.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTLDIS4_EPT_DISABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTLDIS4.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTLDIS4_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS4.Reg, volatile.LoadUint32(&o.EPTCTLDIS4.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTLDIS4_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS4.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTLDIS4_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS4.Reg, volatile.LoadUint32(&o.EPTCTLDIS4.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTLDIS4_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS4.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTLDIS4_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS4.Reg, volatile.LoadUint32(&o.EPTCTLDIS4.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTLDIS4_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS4.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTLDIS4_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS4.Reg, volatile.LoadUint32(&o.EPTCTLDIS4.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTLDIS4_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS4.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTLDIS4_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS4.Reg, volatile.LoadUint32(&o.EPTCTLDIS4.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTLDIS4_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS4.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTLDIS4_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS4.Reg, volatile.LoadUint32(&o.EPTCTLDIS4.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTLDIS4_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS4.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTLDIS4_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS4.Reg, volatile.LoadUint32(&o.EPTCTLDIS4.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTLDIS4_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS4.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTLDIS4_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS4.Reg, volatile.LoadUint32(&o.EPTCTLDIS4.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTLDIS4_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS4.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTLDIS4_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS4.Reg, volatile.LoadUint32(&o.EPTCTLDIS4.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTLDIS4_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS4.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTLDIS4_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS4.Reg, volatile.LoadUint32(&o.EPTCTLDIS4.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTLDIS4_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS4.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTLDIS4_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS4.Reg, volatile.LoadUint32(&o.EPTCTLDIS4.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTLDIS4_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS4.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTLDIS4_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS4.Reg, volatile.LoadUint32(&o.EPTCTLDIS4.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTLDIS4_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS4.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTLDIS4_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS4.Reg, volatile.LoadUint32(&o.EPTCTLDIS4.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTLDIS4_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS4.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTL4: UDPHS Endpoint Control Register (endpoint = 4)
func (o *UDPHS_Type) SetEPTCTL4_EPT_ENABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTL4.Reg, volatile.LoadUint32(&o.EPTCTL4.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTL4_EPT_ENABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTL4.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTL4_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTL4.Reg, volatile.LoadUint32(&o.EPTCTL4.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTL4_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL4.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTL4_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTL4.Reg, volatile.LoadUint32(&o.EPTCTL4.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTL4_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL4.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTL4_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTL4.Reg, volatile.LoadUint32(&o.EPTCTL4.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTL4_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL4.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTL4_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTL4.Reg, volatile.LoadUint32(&o.EPTCTL4.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTL4_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL4.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTL4_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTL4.Reg, volatile.LoadUint32(&o.EPTCTL4.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTL4_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL4.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTL4_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL4.Reg, volatile.LoadUint32(&o.EPTCTL4.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTL4_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL4.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTL4_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTL4.Reg, volatile.LoadUint32(&o.EPTCTL4.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTL4_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL4.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTL4_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTL4.Reg, volatile.LoadUint32(&o.EPTCTL4.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTL4_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL4.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTL4_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL4.Reg, volatile.LoadUint32(&o.EPTCTL4.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTL4_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL4.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTL4_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTL4.Reg, volatile.LoadUint32(&o.EPTCTL4.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTL4_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL4.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTL4_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL4.Reg, volatile.LoadUint32(&o.EPTCTL4.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTL4_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL4.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTL4_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTL4.Reg, volatile.LoadUint32(&o.EPTCTL4.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTL4_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL4.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTL4_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL4.Reg, volatile.LoadUint32(&o.EPTCTL4.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTL4_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL4.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTSETSTA4: UDPHS Endpoint Set Status Register (endpoint = 4)
func (o *UDPHS_Type) SetEPTSETSTA4_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA4.Reg, volatile.LoadUint32(&o.EPTSETSTA4.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTSETSTA4_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA4.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTSETSTA4_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA4.Reg, volatile.LoadUint32(&o.EPTSETSTA4.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTSETSTA4_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA4.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTSETSTA4_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA4.Reg, volatile.LoadUint32(&o.EPTSETSTA4.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTSETSTA4_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA4.Reg) & 0x800) >> 11
}

// UDPHS.EPTCLRSTA4: UDPHS Endpoint Clear Status Register (endpoint = 4)
func (o *UDPHS_Type) SetEPTCLRSTA4_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA4.Reg, volatile.LoadUint32(&o.EPTCLRSTA4.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTCLRSTA4_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA4.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTCLRSTA4_TOGGLESQ(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA4.Reg, volatile.LoadUint32(&o.EPTCLRSTA4.Reg)&^(0x40)|value<<6)
}
func (o *UDPHS_Type) GetEPTCLRSTA4_TOGGLESQ() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA4.Reg) & 0x40) >> 6
}
func (o *UDPHS_Type) SetEPTCLRSTA4_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA4.Reg, volatile.LoadUint32(&o.EPTCLRSTA4.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCLRSTA4_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA4.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCLRSTA4_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA4.Reg, volatile.LoadUint32(&o.EPTCLRSTA4.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCLRSTA4_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA4.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCLRSTA4_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA4.Reg, volatile.LoadUint32(&o.EPTCLRSTA4.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCLRSTA4_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA4.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCLRSTA4_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA4.Reg, volatile.LoadUint32(&o.EPTCLRSTA4.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCLRSTA4_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA4.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCLRSTA4_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA4.Reg, volatile.LoadUint32(&o.EPTCLRSTA4.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCLRSTA4_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA4.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCLRSTA4_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA4.Reg, volatile.LoadUint32(&o.EPTCLRSTA4.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCLRSTA4_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA4.Reg) & 0x8000) >> 15
}

// UDPHS.EPTSTA4: UDPHS Endpoint Status Register (endpoint = 4)
func (o *UDPHS_Type) SetEPTSTA4_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTSTA4.Reg, volatile.LoadUint32(&o.EPTSTA4.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTSTA4_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA4.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTSTA4_TOGGLESQ_STA(value uint32) {
	volatile.StoreUint32(&o.EPTSTA4.Reg, volatile.LoadUint32(&o.EPTSTA4.Reg)&^(0xc0)|value<<6)
}
func (o *UDPHS_Type) GetEPTSTA4_TOGGLESQ_STA() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA4.Reg) & 0xc0) >> 6
}
func (o *UDPHS_Type) SetEPTSTA4_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTSTA4.Reg, volatile.LoadUint32(&o.EPTSTA4.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTSTA4_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA4.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTSTA4_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTSTA4.Reg, volatile.LoadUint32(&o.EPTSTA4.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTSTA4_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA4.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTSTA4_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA4.Reg, volatile.LoadUint32(&o.EPTSTA4.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTSTA4_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA4.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTSTA4_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTSTA4.Reg, volatile.LoadUint32(&o.EPTSTA4.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTSTA4_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA4.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTSTA4_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTSTA4.Reg, volatile.LoadUint32(&o.EPTSTA4.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTSTA4_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA4.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTSTA4_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA4.Reg, volatile.LoadUint32(&o.EPTSTA4.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTSTA4_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA4.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTSTA4_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTSTA4.Reg, volatile.LoadUint32(&o.EPTSTA4.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTSTA4_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA4.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTSTA4_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA4.Reg, volatile.LoadUint32(&o.EPTSTA4.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTSTA4_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA4.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTSTA4_CURBK_CTLDIR(value uint32) {
	volatile.StoreUint32(&o.EPTSTA4.Reg, volatile.LoadUint32(&o.EPTSTA4.Reg)&^(0x30000)|value<<16)
}
func (o *UDPHS_Type) GetEPTSTA4_CURBK_CTLDIR() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA4.Reg) & 0x30000) >> 16
}
func (o *UDPHS_Type) SetEPTSTA4_BUSY_BANK_STA(value uint32) {
	volatile.StoreUint32(&o.EPTSTA4.Reg, volatile.LoadUint32(&o.EPTSTA4.Reg)&^(0xc0000)|value<<18)
}
func (o *UDPHS_Type) GetEPTSTA4_BUSY_BANK_STA() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA4.Reg) & 0xc0000) >> 18
}
func (o *UDPHS_Type) SetEPTSTA4_BYTE_COUNT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA4.Reg, volatile.LoadUint32(&o.EPTSTA4.Reg)&^(0x7ff00000)|value<<20)
}
func (o *UDPHS_Type) GetEPTSTA4_BYTE_COUNT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA4.Reg) & 0x7ff00000) >> 20
}
func (o *UDPHS_Type) SetEPTSTA4_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA4.Reg, volatile.LoadUint32(&o.EPTSTA4.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTSTA4_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA4.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCFG5: UDPHS Endpoint Configuration Register (endpoint = 5)
func (o *UDPHS_Type) SetEPTCFG5_EPT_SIZE(value uint32) {
	volatile.StoreUint32(&o.EPTCFG5.Reg, volatile.LoadUint32(&o.EPTCFG5.Reg)&^(0x7)|value)
}
func (o *UDPHS_Type) GetEPTCFG5_EPT_SIZE() uint32 {
	return volatile.LoadUint32(&o.EPTCFG5.Reg) & 0x7
}
func (o *UDPHS_Type) SetEPTCFG5_EPT_DIR(value uint32) {
	volatile.StoreUint32(&o.EPTCFG5.Reg, volatile.LoadUint32(&o.EPTCFG5.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCFG5_EPT_DIR() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG5.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCFG5_EPT_TYPE(value uint32) {
	volatile.StoreUint32(&o.EPTCFG5.Reg, volatile.LoadUint32(&o.EPTCFG5.Reg)&^(0x30)|value<<4)
}
func (o *UDPHS_Type) GetEPTCFG5_EPT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG5.Reg) & 0x30) >> 4
}
func (o *UDPHS_Type) SetEPTCFG5_BK_NUMBER(value uint32) {
	volatile.StoreUint32(&o.EPTCFG5.Reg, volatile.LoadUint32(&o.EPTCFG5.Reg)&^(0xc0)|value<<6)
}
func (o *UDPHS_Type) GetEPTCFG5_BK_NUMBER() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG5.Reg) & 0xc0) >> 6
}
func (o *UDPHS_Type) SetEPTCFG5_NB_TRANS(value uint32) {
	volatile.StoreUint32(&o.EPTCFG5.Reg, volatile.LoadUint32(&o.EPTCFG5.Reg)&^(0x300)|value<<8)
}
func (o *UDPHS_Type) GetEPTCFG5_NB_TRANS() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG5.Reg) & 0x300) >> 8
}
func (o *UDPHS_Type) SetEPTCFG5_EPT_MAPD(value uint32) {
	volatile.StoreUint32(&o.EPTCFG5.Reg, volatile.LoadUint32(&o.EPTCFG5.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCFG5_EPT_MAPD() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG5.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTLENB5: UDPHS Endpoint Control Enable Register (endpoint = 5)
func (o *UDPHS_Type) SetEPTCTLENB5_EPT_ENABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB5.Reg, volatile.LoadUint32(&o.EPTCTLENB5.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTLENB5_EPT_ENABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTLENB5.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTLENB5_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB5.Reg, volatile.LoadUint32(&o.EPTCTLENB5.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTLENB5_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB5.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTLENB5_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB5.Reg, volatile.LoadUint32(&o.EPTCTLENB5.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTLENB5_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB5.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTLENB5_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB5.Reg, volatile.LoadUint32(&o.EPTCTLENB5.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTLENB5_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB5.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTLENB5_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB5.Reg, volatile.LoadUint32(&o.EPTCTLENB5.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTLENB5_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB5.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTLENB5_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB5.Reg, volatile.LoadUint32(&o.EPTCTLENB5.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTLENB5_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB5.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTLENB5_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB5.Reg, volatile.LoadUint32(&o.EPTCTLENB5.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTLENB5_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB5.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTLENB5_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB5.Reg, volatile.LoadUint32(&o.EPTCTLENB5.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTLENB5_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB5.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTLENB5_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB5.Reg, volatile.LoadUint32(&o.EPTCTLENB5.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTLENB5_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB5.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTLENB5_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB5.Reg, volatile.LoadUint32(&o.EPTCTLENB5.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTLENB5_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB5.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTLENB5_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB5.Reg, volatile.LoadUint32(&o.EPTCTLENB5.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTLENB5_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB5.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTLENB5_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB5.Reg, volatile.LoadUint32(&o.EPTCTLENB5.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTLENB5_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB5.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTLENB5_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB5.Reg, volatile.LoadUint32(&o.EPTCTLENB5.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTLENB5_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB5.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTLENB5_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB5.Reg, volatile.LoadUint32(&o.EPTCTLENB5.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTLENB5_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB5.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTLDIS5: UDPHS Endpoint Control Disable Register (endpoint = 5)
func (o *UDPHS_Type) SetEPTCTLDIS5_EPT_DISABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS5.Reg, volatile.LoadUint32(&o.EPTCTLDIS5.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTLDIS5_EPT_DISABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTLDIS5.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTLDIS5_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS5.Reg, volatile.LoadUint32(&o.EPTCTLDIS5.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTLDIS5_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS5.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTLDIS5_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS5.Reg, volatile.LoadUint32(&o.EPTCTLDIS5.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTLDIS5_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS5.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTLDIS5_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS5.Reg, volatile.LoadUint32(&o.EPTCTLDIS5.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTLDIS5_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS5.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTLDIS5_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS5.Reg, volatile.LoadUint32(&o.EPTCTLDIS5.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTLDIS5_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS5.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTLDIS5_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS5.Reg, volatile.LoadUint32(&o.EPTCTLDIS5.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTLDIS5_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS5.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTLDIS5_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS5.Reg, volatile.LoadUint32(&o.EPTCTLDIS5.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTLDIS5_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS5.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTLDIS5_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS5.Reg, volatile.LoadUint32(&o.EPTCTLDIS5.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTLDIS5_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS5.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTLDIS5_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS5.Reg, volatile.LoadUint32(&o.EPTCTLDIS5.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTLDIS5_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS5.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTLDIS5_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS5.Reg, volatile.LoadUint32(&o.EPTCTLDIS5.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTLDIS5_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS5.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTLDIS5_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS5.Reg, volatile.LoadUint32(&o.EPTCTLDIS5.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTLDIS5_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS5.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTLDIS5_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS5.Reg, volatile.LoadUint32(&o.EPTCTLDIS5.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTLDIS5_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS5.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTLDIS5_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS5.Reg, volatile.LoadUint32(&o.EPTCTLDIS5.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTLDIS5_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS5.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTLDIS5_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS5.Reg, volatile.LoadUint32(&o.EPTCTLDIS5.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTLDIS5_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS5.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTL5: UDPHS Endpoint Control Register (endpoint = 5)
func (o *UDPHS_Type) SetEPTCTL5_EPT_ENABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTL5.Reg, volatile.LoadUint32(&o.EPTCTL5.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTL5_EPT_ENABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTL5.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTL5_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTL5.Reg, volatile.LoadUint32(&o.EPTCTL5.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTL5_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL5.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTL5_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTL5.Reg, volatile.LoadUint32(&o.EPTCTL5.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTL5_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL5.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTL5_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTL5.Reg, volatile.LoadUint32(&o.EPTCTL5.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTL5_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL5.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTL5_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTL5.Reg, volatile.LoadUint32(&o.EPTCTL5.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTL5_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL5.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTL5_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTL5.Reg, volatile.LoadUint32(&o.EPTCTL5.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTL5_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL5.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTL5_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL5.Reg, volatile.LoadUint32(&o.EPTCTL5.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTL5_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL5.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTL5_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTL5.Reg, volatile.LoadUint32(&o.EPTCTL5.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTL5_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL5.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTL5_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTL5.Reg, volatile.LoadUint32(&o.EPTCTL5.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTL5_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL5.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTL5_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL5.Reg, volatile.LoadUint32(&o.EPTCTL5.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTL5_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL5.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTL5_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTL5.Reg, volatile.LoadUint32(&o.EPTCTL5.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTL5_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL5.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTL5_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL5.Reg, volatile.LoadUint32(&o.EPTCTL5.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTL5_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL5.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTL5_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTL5.Reg, volatile.LoadUint32(&o.EPTCTL5.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTL5_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL5.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTL5_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL5.Reg, volatile.LoadUint32(&o.EPTCTL5.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTL5_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL5.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTSETSTA5: UDPHS Endpoint Set Status Register (endpoint = 5)
func (o *UDPHS_Type) SetEPTSETSTA5_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA5.Reg, volatile.LoadUint32(&o.EPTSETSTA5.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTSETSTA5_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA5.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTSETSTA5_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA5.Reg, volatile.LoadUint32(&o.EPTSETSTA5.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTSETSTA5_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA5.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTSETSTA5_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA5.Reg, volatile.LoadUint32(&o.EPTSETSTA5.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTSETSTA5_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA5.Reg) & 0x800) >> 11
}

// UDPHS.EPTCLRSTA5: UDPHS Endpoint Clear Status Register (endpoint = 5)
func (o *UDPHS_Type) SetEPTCLRSTA5_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA5.Reg, volatile.LoadUint32(&o.EPTCLRSTA5.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTCLRSTA5_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA5.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTCLRSTA5_TOGGLESQ(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA5.Reg, volatile.LoadUint32(&o.EPTCLRSTA5.Reg)&^(0x40)|value<<6)
}
func (o *UDPHS_Type) GetEPTCLRSTA5_TOGGLESQ() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA5.Reg) & 0x40) >> 6
}
func (o *UDPHS_Type) SetEPTCLRSTA5_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA5.Reg, volatile.LoadUint32(&o.EPTCLRSTA5.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCLRSTA5_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA5.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCLRSTA5_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA5.Reg, volatile.LoadUint32(&o.EPTCLRSTA5.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCLRSTA5_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA5.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCLRSTA5_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA5.Reg, volatile.LoadUint32(&o.EPTCLRSTA5.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCLRSTA5_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA5.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCLRSTA5_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA5.Reg, volatile.LoadUint32(&o.EPTCLRSTA5.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCLRSTA5_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA5.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCLRSTA5_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA5.Reg, volatile.LoadUint32(&o.EPTCLRSTA5.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCLRSTA5_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA5.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCLRSTA5_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA5.Reg, volatile.LoadUint32(&o.EPTCLRSTA5.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCLRSTA5_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA5.Reg) & 0x8000) >> 15
}

// UDPHS.EPTSTA5: UDPHS Endpoint Status Register (endpoint = 5)
func (o *UDPHS_Type) SetEPTSTA5_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTSTA5.Reg, volatile.LoadUint32(&o.EPTSTA5.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTSTA5_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA5.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTSTA5_TOGGLESQ_STA(value uint32) {
	volatile.StoreUint32(&o.EPTSTA5.Reg, volatile.LoadUint32(&o.EPTSTA5.Reg)&^(0xc0)|value<<6)
}
func (o *UDPHS_Type) GetEPTSTA5_TOGGLESQ_STA() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA5.Reg) & 0xc0) >> 6
}
func (o *UDPHS_Type) SetEPTSTA5_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTSTA5.Reg, volatile.LoadUint32(&o.EPTSTA5.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTSTA5_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA5.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTSTA5_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTSTA5.Reg, volatile.LoadUint32(&o.EPTSTA5.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTSTA5_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA5.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTSTA5_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA5.Reg, volatile.LoadUint32(&o.EPTSTA5.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTSTA5_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA5.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTSTA5_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTSTA5.Reg, volatile.LoadUint32(&o.EPTSTA5.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTSTA5_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA5.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTSTA5_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTSTA5.Reg, volatile.LoadUint32(&o.EPTSTA5.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTSTA5_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA5.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTSTA5_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA5.Reg, volatile.LoadUint32(&o.EPTSTA5.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTSTA5_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA5.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTSTA5_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTSTA5.Reg, volatile.LoadUint32(&o.EPTSTA5.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTSTA5_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA5.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTSTA5_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA5.Reg, volatile.LoadUint32(&o.EPTSTA5.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTSTA5_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA5.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTSTA5_CURBK_CTLDIR(value uint32) {
	volatile.StoreUint32(&o.EPTSTA5.Reg, volatile.LoadUint32(&o.EPTSTA5.Reg)&^(0x30000)|value<<16)
}
func (o *UDPHS_Type) GetEPTSTA5_CURBK_CTLDIR() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA5.Reg) & 0x30000) >> 16
}
func (o *UDPHS_Type) SetEPTSTA5_BUSY_BANK_STA(value uint32) {
	volatile.StoreUint32(&o.EPTSTA5.Reg, volatile.LoadUint32(&o.EPTSTA5.Reg)&^(0xc0000)|value<<18)
}
func (o *UDPHS_Type) GetEPTSTA5_BUSY_BANK_STA() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA5.Reg) & 0xc0000) >> 18
}
func (o *UDPHS_Type) SetEPTSTA5_BYTE_COUNT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA5.Reg, volatile.LoadUint32(&o.EPTSTA5.Reg)&^(0x7ff00000)|value<<20)
}
func (o *UDPHS_Type) GetEPTSTA5_BYTE_COUNT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA5.Reg) & 0x7ff00000) >> 20
}
func (o *UDPHS_Type) SetEPTSTA5_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA5.Reg, volatile.LoadUint32(&o.EPTSTA5.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTSTA5_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA5.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCFG6: UDPHS Endpoint Configuration Register (endpoint = 6)
func (o *UDPHS_Type) SetEPTCFG6_EPT_SIZE(value uint32) {
	volatile.StoreUint32(&o.EPTCFG6.Reg, volatile.LoadUint32(&o.EPTCFG6.Reg)&^(0x7)|value)
}
func (o *UDPHS_Type) GetEPTCFG6_EPT_SIZE() uint32 {
	return volatile.LoadUint32(&o.EPTCFG6.Reg) & 0x7
}
func (o *UDPHS_Type) SetEPTCFG6_EPT_DIR(value uint32) {
	volatile.StoreUint32(&o.EPTCFG6.Reg, volatile.LoadUint32(&o.EPTCFG6.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCFG6_EPT_DIR() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG6.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCFG6_EPT_TYPE(value uint32) {
	volatile.StoreUint32(&o.EPTCFG6.Reg, volatile.LoadUint32(&o.EPTCFG6.Reg)&^(0x30)|value<<4)
}
func (o *UDPHS_Type) GetEPTCFG6_EPT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG6.Reg) & 0x30) >> 4
}
func (o *UDPHS_Type) SetEPTCFG6_BK_NUMBER(value uint32) {
	volatile.StoreUint32(&o.EPTCFG6.Reg, volatile.LoadUint32(&o.EPTCFG6.Reg)&^(0xc0)|value<<6)
}
func (o *UDPHS_Type) GetEPTCFG6_BK_NUMBER() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG6.Reg) & 0xc0) >> 6
}
func (o *UDPHS_Type) SetEPTCFG6_NB_TRANS(value uint32) {
	volatile.StoreUint32(&o.EPTCFG6.Reg, volatile.LoadUint32(&o.EPTCFG6.Reg)&^(0x300)|value<<8)
}
func (o *UDPHS_Type) GetEPTCFG6_NB_TRANS() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG6.Reg) & 0x300) >> 8
}
func (o *UDPHS_Type) SetEPTCFG6_EPT_MAPD(value uint32) {
	volatile.StoreUint32(&o.EPTCFG6.Reg, volatile.LoadUint32(&o.EPTCFG6.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCFG6_EPT_MAPD() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG6.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTLENB6: UDPHS Endpoint Control Enable Register (endpoint = 6)
func (o *UDPHS_Type) SetEPTCTLENB6_EPT_ENABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB6.Reg, volatile.LoadUint32(&o.EPTCTLENB6.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTLENB6_EPT_ENABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTLENB6.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTLENB6_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB6.Reg, volatile.LoadUint32(&o.EPTCTLENB6.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTLENB6_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB6.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTLENB6_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB6.Reg, volatile.LoadUint32(&o.EPTCTLENB6.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTLENB6_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB6.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTLENB6_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB6.Reg, volatile.LoadUint32(&o.EPTCTLENB6.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTLENB6_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB6.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTLENB6_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB6.Reg, volatile.LoadUint32(&o.EPTCTLENB6.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTLENB6_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB6.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTLENB6_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB6.Reg, volatile.LoadUint32(&o.EPTCTLENB6.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTLENB6_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB6.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTLENB6_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB6.Reg, volatile.LoadUint32(&o.EPTCTLENB6.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTLENB6_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB6.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTLENB6_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB6.Reg, volatile.LoadUint32(&o.EPTCTLENB6.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTLENB6_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB6.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTLENB6_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB6.Reg, volatile.LoadUint32(&o.EPTCTLENB6.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTLENB6_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB6.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTLENB6_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB6.Reg, volatile.LoadUint32(&o.EPTCTLENB6.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTLENB6_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB6.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTLENB6_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB6.Reg, volatile.LoadUint32(&o.EPTCTLENB6.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTLENB6_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB6.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTLENB6_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB6.Reg, volatile.LoadUint32(&o.EPTCTLENB6.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTLENB6_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB6.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTLENB6_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB6.Reg, volatile.LoadUint32(&o.EPTCTLENB6.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTLENB6_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB6.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTLENB6_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB6.Reg, volatile.LoadUint32(&o.EPTCTLENB6.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTLENB6_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB6.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTLDIS6: UDPHS Endpoint Control Disable Register (endpoint = 6)
func (o *UDPHS_Type) SetEPTCTLDIS6_EPT_DISABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS6.Reg, volatile.LoadUint32(&o.EPTCTLDIS6.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTLDIS6_EPT_DISABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTLDIS6.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTLDIS6_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS6.Reg, volatile.LoadUint32(&o.EPTCTLDIS6.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTLDIS6_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS6.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTLDIS6_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS6.Reg, volatile.LoadUint32(&o.EPTCTLDIS6.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTLDIS6_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS6.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTLDIS6_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS6.Reg, volatile.LoadUint32(&o.EPTCTLDIS6.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTLDIS6_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS6.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTLDIS6_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS6.Reg, volatile.LoadUint32(&o.EPTCTLDIS6.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTLDIS6_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS6.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTLDIS6_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS6.Reg, volatile.LoadUint32(&o.EPTCTLDIS6.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTLDIS6_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS6.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTLDIS6_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS6.Reg, volatile.LoadUint32(&o.EPTCTLDIS6.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTLDIS6_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS6.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTLDIS6_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS6.Reg, volatile.LoadUint32(&o.EPTCTLDIS6.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTLDIS6_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS6.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTLDIS6_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS6.Reg, volatile.LoadUint32(&o.EPTCTLDIS6.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTLDIS6_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS6.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTLDIS6_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS6.Reg, volatile.LoadUint32(&o.EPTCTLDIS6.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTLDIS6_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS6.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTLDIS6_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS6.Reg, volatile.LoadUint32(&o.EPTCTLDIS6.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTLDIS6_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS6.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTLDIS6_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS6.Reg, volatile.LoadUint32(&o.EPTCTLDIS6.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTLDIS6_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS6.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTLDIS6_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS6.Reg, volatile.LoadUint32(&o.EPTCTLDIS6.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTLDIS6_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS6.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTLDIS6_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS6.Reg, volatile.LoadUint32(&o.EPTCTLDIS6.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTLDIS6_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS6.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTL6: UDPHS Endpoint Control Register (endpoint = 6)
func (o *UDPHS_Type) SetEPTCTL6_EPT_ENABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTL6.Reg, volatile.LoadUint32(&o.EPTCTL6.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTL6_EPT_ENABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTL6.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTL6_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTL6.Reg, volatile.LoadUint32(&o.EPTCTL6.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTL6_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL6.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTL6_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTL6.Reg, volatile.LoadUint32(&o.EPTCTL6.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTL6_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL6.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTL6_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTL6.Reg, volatile.LoadUint32(&o.EPTCTL6.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTL6_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL6.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTL6_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTL6.Reg, volatile.LoadUint32(&o.EPTCTL6.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTL6_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL6.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTL6_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTL6.Reg, volatile.LoadUint32(&o.EPTCTL6.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTL6_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL6.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTL6_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL6.Reg, volatile.LoadUint32(&o.EPTCTL6.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTL6_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL6.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTL6_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTL6.Reg, volatile.LoadUint32(&o.EPTCTL6.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTL6_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL6.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTL6_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTL6.Reg, volatile.LoadUint32(&o.EPTCTL6.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTL6_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL6.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTL6_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL6.Reg, volatile.LoadUint32(&o.EPTCTL6.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTL6_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL6.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTL6_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTL6.Reg, volatile.LoadUint32(&o.EPTCTL6.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTL6_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL6.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTL6_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL6.Reg, volatile.LoadUint32(&o.EPTCTL6.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTL6_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL6.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTL6_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTL6.Reg, volatile.LoadUint32(&o.EPTCTL6.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTL6_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL6.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTL6_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL6.Reg, volatile.LoadUint32(&o.EPTCTL6.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTL6_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL6.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTSETSTA6: UDPHS Endpoint Set Status Register (endpoint = 6)
func (o *UDPHS_Type) SetEPTSETSTA6_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA6.Reg, volatile.LoadUint32(&o.EPTSETSTA6.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTSETSTA6_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA6.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTSETSTA6_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA6.Reg, volatile.LoadUint32(&o.EPTSETSTA6.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTSETSTA6_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA6.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTSETSTA6_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA6.Reg, volatile.LoadUint32(&o.EPTSETSTA6.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTSETSTA6_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA6.Reg) & 0x800) >> 11
}

// UDPHS.EPTCLRSTA6: UDPHS Endpoint Clear Status Register (endpoint = 6)
func (o *UDPHS_Type) SetEPTCLRSTA6_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA6.Reg, volatile.LoadUint32(&o.EPTCLRSTA6.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTCLRSTA6_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA6.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTCLRSTA6_TOGGLESQ(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA6.Reg, volatile.LoadUint32(&o.EPTCLRSTA6.Reg)&^(0x40)|value<<6)
}
func (o *UDPHS_Type) GetEPTCLRSTA6_TOGGLESQ() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA6.Reg) & 0x40) >> 6
}
func (o *UDPHS_Type) SetEPTCLRSTA6_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA6.Reg, volatile.LoadUint32(&o.EPTCLRSTA6.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCLRSTA6_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA6.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCLRSTA6_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA6.Reg, volatile.LoadUint32(&o.EPTCLRSTA6.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCLRSTA6_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA6.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCLRSTA6_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA6.Reg, volatile.LoadUint32(&o.EPTCLRSTA6.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCLRSTA6_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA6.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCLRSTA6_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA6.Reg, volatile.LoadUint32(&o.EPTCLRSTA6.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCLRSTA6_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA6.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCLRSTA6_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA6.Reg, volatile.LoadUint32(&o.EPTCLRSTA6.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCLRSTA6_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA6.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCLRSTA6_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA6.Reg, volatile.LoadUint32(&o.EPTCLRSTA6.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCLRSTA6_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA6.Reg) & 0x8000) >> 15
}

// UDPHS.EPTSTA6: UDPHS Endpoint Status Register (endpoint = 6)
func (o *UDPHS_Type) SetEPTSTA6_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTSTA6.Reg, volatile.LoadUint32(&o.EPTSTA6.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTSTA6_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA6.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTSTA6_TOGGLESQ_STA(value uint32) {
	volatile.StoreUint32(&o.EPTSTA6.Reg, volatile.LoadUint32(&o.EPTSTA6.Reg)&^(0xc0)|value<<6)
}
func (o *UDPHS_Type) GetEPTSTA6_TOGGLESQ_STA() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA6.Reg) & 0xc0) >> 6
}
func (o *UDPHS_Type) SetEPTSTA6_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTSTA6.Reg, volatile.LoadUint32(&o.EPTSTA6.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTSTA6_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA6.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTSTA6_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTSTA6.Reg, volatile.LoadUint32(&o.EPTSTA6.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTSTA6_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA6.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTSTA6_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA6.Reg, volatile.LoadUint32(&o.EPTSTA6.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTSTA6_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA6.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTSTA6_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTSTA6.Reg, volatile.LoadUint32(&o.EPTSTA6.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTSTA6_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA6.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTSTA6_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTSTA6.Reg, volatile.LoadUint32(&o.EPTSTA6.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTSTA6_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA6.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTSTA6_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA6.Reg, volatile.LoadUint32(&o.EPTSTA6.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTSTA6_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA6.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTSTA6_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTSTA6.Reg, volatile.LoadUint32(&o.EPTSTA6.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTSTA6_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA6.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTSTA6_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA6.Reg, volatile.LoadUint32(&o.EPTSTA6.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTSTA6_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA6.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTSTA6_CURBK_CTLDIR(value uint32) {
	volatile.StoreUint32(&o.EPTSTA6.Reg, volatile.LoadUint32(&o.EPTSTA6.Reg)&^(0x30000)|value<<16)
}
func (o *UDPHS_Type) GetEPTSTA6_CURBK_CTLDIR() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA6.Reg) & 0x30000) >> 16
}
func (o *UDPHS_Type) SetEPTSTA6_BUSY_BANK_STA(value uint32) {
	volatile.StoreUint32(&o.EPTSTA6.Reg, volatile.LoadUint32(&o.EPTSTA6.Reg)&^(0xc0000)|value<<18)
}
func (o *UDPHS_Type) GetEPTSTA6_BUSY_BANK_STA() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA6.Reg) & 0xc0000) >> 18
}
func (o *UDPHS_Type) SetEPTSTA6_BYTE_COUNT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA6.Reg, volatile.LoadUint32(&o.EPTSTA6.Reg)&^(0x7ff00000)|value<<20)
}
func (o *UDPHS_Type) GetEPTSTA6_BYTE_COUNT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA6.Reg) & 0x7ff00000) >> 20
}
func (o *UDPHS_Type) SetEPTSTA6_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA6.Reg, volatile.LoadUint32(&o.EPTSTA6.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTSTA6_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA6.Reg) & 0x80000000) >> 31
}

// UDPHS.DMANXTDSC0: UDPHS DMA Next Descriptor Address Register (channel = 0)
func (o *UDPHS_Type) SetDMANXTDSC0(value uint32) {
	volatile.StoreUint32(&o.DMANXTDSC0.Reg, value)
}
func (o *UDPHS_Type) GetDMANXTDSC0() uint32 {
	return volatile.LoadUint32(&o.DMANXTDSC0.Reg)
}

// UDPHS.DMAADDRESS0: UDPHS DMA Channel Address Register (channel = 0)
func (o *UDPHS_Type) SetDMAADDRESS0(value uint32) {
	volatile.StoreUint32(&o.DMAADDRESS0.Reg, value)
}
func (o *UDPHS_Type) GetDMAADDRESS0() uint32 {
	return volatile.LoadUint32(&o.DMAADDRESS0.Reg)
}

// UDPHS.DMACONTROL0: UDPHS DMA Channel Control Register (channel = 0)
func (o *UDPHS_Type) SetDMACONTROL0_CHANN_ENB(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL0.Reg, volatile.LoadUint32(&o.DMACONTROL0.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetDMACONTROL0_CHANN_ENB() uint32 {
	return volatile.LoadUint32(&o.DMACONTROL0.Reg) & 0x1
}
func (o *UDPHS_Type) SetDMACONTROL0_LDNXT_DSC(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL0.Reg, volatile.LoadUint32(&o.DMACONTROL0.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetDMACONTROL0_LDNXT_DSC() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL0.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetDMACONTROL0_END_TR_EN(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL0.Reg, volatile.LoadUint32(&o.DMACONTROL0.Reg)&^(0x4)|value<<2)
}
func (o *UDPHS_Type) GetDMACONTROL0_END_TR_EN() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL0.Reg) & 0x4) >> 2
}
func (o *UDPHS_Type) SetDMACONTROL0_END_B_EN(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL0.Reg, volatile.LoadUint32(&o.DMACONTROL0.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetDMACONTROL0_END_B_EN() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL0.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetDMACONTROL0_END_TR_IT(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL0.Reg, volatile.LoadUint32(&o.DMACONTROL0.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetDMACONTROL0_END_TR_IT() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL0.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetDMACONTROL0_END_BUFFIT(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL0.Reg, volatile.LoadUint32(&o.DMACONTROL0.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetDMACONTROL0_END_BUFFIT() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL0.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetDMACONTROL0_DESC_LD_IT(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL0.Reg, volatile.LoadUint32(&o.DMACONTROL0.Reg)&^(0x40)|value<<6)
}
func (o *UDPHS_Type) GetDMACONTROL0_DESC_LD_IT() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL0.Reg) & 0x40) >> 6
}
func (o *UDPHS_Type) SetDMACONTROL0_BURST_LCK(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL0.Reg, volatile.LoadUint32(&o.DMACONTROL0.Reg)&^(0x80)|value<<7)
}
func (o *UDPHS_Type) GetDMACONTROL0_BURST_LCK() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL0.Reg) & 0x80) >> 7
}
func (o *UDPHS_Type) SetDMACONTROL0_BUFF_LENGTH(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL0.Reg, volatile.LoadUint32(&o.DMACONTROL0.Reg)&^(0xffff0000)|value<<16)
}
func (o *UDPHS_Type) GetDMACONTROL0_BUFF_LENGTH() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL0.Reg) & 0xffff0000) >> 16
}

// UDPHS.DMASTATUS0: UDPHS DMA Channel Status Register (channel = 0)
func (o *UDPHS_Type) SetDMASTATUS0_CHANN_ENB(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS0.Reg, volatile.LoadUint32(&o.DMASTATUS0.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetDMASTATUS0_CHANN_ENB() uint32 {
	return volatile.LoadUint32(&o.DMASTATUS0.Reg) & 0x1
}
func (o *UDPHS_Type) SetDMASTATUS0_CHANN_ACT(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS0.Reg, volatile.LoadUint32(&o.DMASTATUS0.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetDMASTATUS0_CHANN_ACT() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS0.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetDMASTATUS0_END_TR_ST(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS0.Reg, volatile.LoadUint32(&o.DMASTATUS0.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetDMASTATUS0_END_TR_ST() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS0.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetDMASTATUS0_END_BF_ST(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS0.Reg, volatile.LoadUint32(&o.DMASTATUS0.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetDMASTATUS0_END_BF_ST() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS0.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetDMASTATUS0_DESC_LDST(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS0.Reg, volatile.LoadUint32(&o.DMASTATUS0.Reg)&^(0x40)|value<<6)
}
func (o *UDPHS_Type) GetDMASTATUS0_DESC_LDST() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS0.Reg) & 0x40) >> 6
}
func (o *UDPHS_Type) SetDMASTATUS0_BUFF_COUNT(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS0.Reg, volatile.LoadUint32(&o.DMASTATUS0.Reg)&^(0xffff0000)|value<<16)
}
func (o *UDPHS_Type) GetDMASTATUS0_BUFF_COUNT() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS0.Reg) & 0xffff0000) >> 16
}

// UDPHS.DMANXTDSC1: UDPHS DMA Next Descriptor Address Register (channel = 1)
func (o *UDPHS_Type) SetDMANXTDSC1(value uint32) {
	volatile.StoreUint32(&o.DMANXTDSC1.Reg, value)
}
func (o *UDPHS_Type) GetDMANXTDSC1() uint32 {
	return volatile.LoadUint32(&o.DMANXTDSC1.Reg)
}

// UDPHS.DMAADDRESS1: UDPHS DMA Channel Address Register (channel = 1)
func (o *UDPHS_Type) SetDMAADDRESS1(value uint32) {
	volatile.StoreUint32(&o.DMAADDRESS1.Reg, value)
}
func (o *UDPHS_Type) GetDMAADDRESS1() uint32 {
	return volatile.LoadUint32(&o.DMAADDRESS1.Reg)
}

// UDPHS.DMACONTROL1: UDPHS DMA Channel Control Register (channel = 1)
func (o *UDPHS_Type) SetDMACONTROL1_CHANN_ENB(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL1.Reg, volatile.LoadUint32(&o.DMACONTROL1.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetDMACONTROL1_CHANN_ENB() uint32 {
	return volatile.LoadUint32(&o.DMACONTROL1.Reg) & 0x1
}
func (o *UDPHS_Type) SetDMACONTROL1_LDNXT_DSC(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL1.Reg, volatile.LoadUint32(&o.DMACONTROL1.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetDMACONTROL1_LDNXT_DSC() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL1.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetDMACONTROL1_END_TR_EN(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL1.Reg, volatile.LoadUint32(&o.DMACONTROL1.Reg)&^(0x4)|value<<2)
}
func (o *UDPHS_Type) GetDMACONTROL1_END_TR_EN() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL1.Reg) & 0x4) >> 2
}
func (o *UDPHS_Type) SetDMACONTROL1_END_B_EN(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL1.Reg, volatile.LoadUint32(&o.DMACONTROL1.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetDMACONTROL1_END_B_EN() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL1.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetDMACONTROL1_END_TR_IT(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL1.Reg, volatile.LoadUint32(&o.DMACONTROL1.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetDMACONTROL1_END_TR_IT() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL1.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetDMACONTROL1_END_BUFFIT(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL1.Reg, volatile.LoadUint32(&o.DMACONTROL1.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetDMACONTROL1_END_BUFFIT() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL1.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetDMACONTROL1_DESC_LD_IT(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL1.Reg, volatile.LoadUint32(&o.DMACONTROL1.Reg)&^(0x40)|value<<6)
}
func (o *UDPHS_Type) GetDMACONTROL1_DESC_LD_IT() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL1.Reg) & 0x40) >> 6
}
func (o *UDPHS_Type) SetDMACONTROL1_BURST_LCK(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL1.Reg, volatile.LoadUint32(&o.DMACONTROL1.Reg)&^(0x80)|value<<7)
}
func (o *UDPHS_Type) GetDMACONTROL1_BURST_LCK() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL1.Reg) & 0x80) >> 7
}
func (o *UDPHS_Type) SetDMACONTROL1_BUFF_LENGTH(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL1.Reg, volatile.LoadUint32(&o.DMACONTROL1.Reg)&^(0xffff0000)|value<<16)
}
func (o *UDPHS_Type) GetDMACONTROL1_BUFF_LENGTH() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL1.Reg) & 0xffff0000) >> 16
}

// UDPHS.DMASTATUS1: UDPHS DMA Channel Status Register (channel = 1)
func (o *UDPHS_Type) SetDMASTATUS1_CHANN_ENB(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS1.Reg, volatile.LoadUint32(&o.DMASTATUS1.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetDMASTATUS1_CHANN_ENB() uint32 {
	return volatile.LoadUint32(&o.DMASTATUS1.Reg) & 0x1
}
func (o *UDPHS_Type) SetDMASTATUS1_CHANN_ACT(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS1.Reg, volatile.LoadUint32(&o.DMASTATUS1.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetDMASTATUS1_CHANN_ACT() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS1.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetDMASTATUS1_END_TR_ST(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS1.Reg, volatile.LoadUint32(&o.DMASTATUS1.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetDMASTATUS1_END_TR_ST() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS1.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetDMASTATUS1_END_BF_ST(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS1.Reg, volatile.LoadUint32(&o.DMASTATUS1.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetDMASTATUS1_END_BF_ST() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS1.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetDMASTATUS1_DESC_LDST(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS1.Reg, volatile.LoadUint32(&o.DMASTATUS1.Reg)&^(0x40)|value<<6)
}
func (o *UDPHS_Type) GetDMASTATUS1_DESC_LDST() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS1.Reg) & 0x40) >> 6
}
func (o *UDPHS_Type) SetDMASTATUS1_BUFF_COUNT(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS1.Reg, volatile.LoadUint32(&o.DMASTATUS1.Reg)&^(0xffff0000)|value<<16)
}
func (o *UDPHS_Type) GetDMASTATUS1_BUFF_COUNT() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS1.Reg) & 0xffff0000) >> 16
}

// UDPHS.DMANXTDSC2: UDPHS DMA Next Descriptor Address Register (channel = 2)
func (o *UDPHS_Type) SetDMANXTDSC2(value uint32) {
	volatile.StoreUint32(&o.DMANXTDSC2.Reg, value)
}
func (o *UDPHS_Type) GetDMANXTDSC2() uint32 {
	return volatile.LoadUint32(&o.DMANXTDSC2.Reg)
}

// UDPHS.DMAADDRESS2: UDPHS DMA Channel Address Register (channel = 2)
func (o *UDPHS_Type) SetDMAADDRESS2(value uint32) {
	volatile.StoreUint32(&o.DMAADDRESS2.Reg, value)
}
func (o *UDPHS_Type) GetDMAADDRESS2() uint32 {
	return volatile.LoadUint32(&o.DMAADDRESS2.Reg)
}

// UDPHS.DMACONTROL2: UDPHS DMA Channel Control Register (channel = 2)
func (o *UDPHS_Type) SetDMACONTROL2_CHANN_ENB(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL2.Reg, volatile.LoadUint32(&o.DMACONTROL2.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetDMACONTROL2_CHANN_ENB() uint32 {
	return volatile.LoadUint32(&o.DMACONTROL2.Reg) & 0x1
}
func (o *UDPHS_Type) SetDMACONTROL2_LDNXT_DSC(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL2.Reg, volatile.LoadUint32(&o.DMACONTROL2.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetDMACONTROL2_LDNXT_DSC() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL2.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetDMACONTROL2_END_TR_EN(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL2.Reg, volatile.LoadUint32(&o.DMACONTROL2.Reg)&^(0x4)|value<<2)
}
func (o *UDPHS_Type) GetDMACONTROL2_END_TR_EN() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL2.Reg) & 0x4) >> 2
}
func (o *UDPHS_Type) SetDMACONTROL2_END_B_EN(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL2.Reg, volatile.LoadUint32(&o.DMACONTROL2.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetDMACONTROL2_END_B_EN() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL2.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetDMACONTROL2_END_TR_IT(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL2.Reg, volatile.LoadUint32(&o.DMACONTROL2.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetDMACONTROL2_END_TR_IT() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL2.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetDMACONTROL2_END_BUFFIT(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL2.Reg, volatile.LoadUint32(&o.DMACONTROL2.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetDMACONTROL2_END_BUFFIT() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL2.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetDMACONTROL2_DESC_LD_IT(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL2.Reg, volatile.LoadUint32(&o.DMACONTROL2.Reg)&^(0x40)|value<<6)
}
func (o *UDPHS_Type) GetDMACONTROL2_DESC_LD_IT() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL2.Reg) & 0x40) >> 6
}
func (o *UDPHS_Type) SetDMACONTROL2_BURST_LCK(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL2.Reg, volatile.LoadUint32(&o.DMACONTROL2.Reg)&^(0x80)|value<<7)
}
func (o *UDPHS_Type) GetDMACONTROL2_BURST_LCK() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL2.Reg) & 0x80) >> 7
}
func (o *UDPHS_Type) SetDMACONTROL2_BUFF_LENGTH(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL2.Reg, volatile.LoadUint32(&o.DMACONTROL2.Reg)&^(0xffff0000)|value<<16)
}
func (o *UDPHS_Type) GetDMACONTROL2_BUFF_LENGTH() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL2.Reg) & 0xffff0000) >> 16
}

// UDPHS.DMASTATUS2: UDPHS DMA Channel Status Register (channel = 2)
func (o *UDPHS_Type) SetDMASTATUS2_CHANN_ENB(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS2.Reg, volatile.LoadUint32(&o.DMASTATUS2.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetDMASTATUS2_CHANN_ENB() uint32 {
	return volatile.LoadUint32(&o.DMASTATUS2.Reg) & 0x1
}
func (o *UDPHS_Type) SetDMASTATUS2_CHANN_ACT(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS2.Reg, volatile.LoadUint32(&o.DMASTATUS2.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetDMASTATUS2_CHANN_ACT() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS2.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetDMASTATUS2_END_TR_ST(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS2.Reg, volatile.LoadUint32(&o.DMASTATUS2.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetDMASTATUS2_END_TR_ST() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS2.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetDMASTATUS2_END_BF_ST(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS2.Reg, volatile.LoadUint32(&o.DMASTATUS2.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetDMASTATUS2_END_BF_ST() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS2.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetDMASTATUS2_DESC_LDST(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS2.Reg, volatile.LoadUint32(&o.DMASTATUS2.Reg)&^(0x40)|value<<6)
}
func (o *UDPHS_Type) GetDMASTATUS2_DESC_LDST() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS2.Reg) & 0x40) >> 6
}
func (o *UDPHS_Type) SetDMASTATUS2_BUFF_COUNT(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS2.Reg, volatile.LoadUint32(&o.DMASTATUS2.Reg)&^(0xffff0000)|value<<16)
}
func (o *UDPHS_Type) GetDMASTATUS2_BUFF_COUNT() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS2.Reg) & 0xffff0000) >> 16
}

// UDPHS.DMANXTDSC3: UDPHS DMA Next Descriptor Address Register (channel = 3)
func (o *UDPHS_Type) SetDMANXTDSC3(value uint32) {
	volatile.StoreUint32(&o.DMANXTDSC3.Reg, value)
}
func (o *UDPHS_Type) GetDMANXTDSC3() uint32 {
	return volatile.LoadUint32(&o.DMANXTDSC3.Reg)
}

// UDPHS.DMAADDRESS3: UDPHS DMA Channel Address Register (channel = 3)
func (o *UDPHS_Type) SetDMAADDRESS3(value uint32) {
	volatile.StoreUint32(&o.DMAADDRESS3.Reg, value)
}
func (o *UDPHS_Type) GetDMAADDRESS3() uint32 {
	return volatile.LoadUint32(&o.DMAADDRESS3.Reg)
}

// UDPHS.DMACONTROL3: UDPHS DMA Channel Control Register (channel = 3)
func (o *UDPHS_Type) SetDMACONTROL3_CHANN_ENB(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL3.Reg, volatile.LoadUint32(&o.DMACONTROL3.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetDMACONTROL3_CHANN_ENB() uint32 {
	return volatile.LoadUint32(&o.DMACONTROL3.Reg) & 0x1
}
func (o *UDPHS_Type) SetDMACONTROL3_LDNXT_DSC(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL3.Reg, volatile.LoadUint32(&o.DMACONTROL3.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetDMACONTROL3_LDNXT_DSC() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL3.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetDMACONTROL3_END_TR_EN(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL3.Reg, volatile.LoadUint32(&o.DMACONTROL3.Reg)&^(0x4)|value<<2)
}
func (o *UDPHS_Type) GetDMACONTROL3_END_TR_EN() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL3.Reg) & 0x4) >> 2
}
func (o *UDPHS_Type) SetDMACONTROL3_END_B_EN(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL3.Reg, volatile.LoadUint32(&o.DMACONTROL3.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetDMACONTROL3_END_B_EN() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL3.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetDMACONTROL3_END_TR_IT(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL3.Reg, volatile.LoadUint32(&o.DMACONTROL3.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetDMACONTROL3_END_TR_IT() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL3.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetDMACONTROL3_END_BUFFIT(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL3.Reg, volatile.LoadUint32(&o.DMACONTROL3.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetDMACONTROL3_END_BUFFIT() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL3.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetDMACONTROL3_DESC_LD_IT(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL3.Reg, volatile.LoadUint32(&o.DMACONTROL3.Reg)&^(0x40)|value<<6)
}
func (o *UDPHS_Type) GetDMACONTROL3_DESC_LD_IT() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL3.Reg) & 0x40) >> 6
}
func (o *UDPHS_Type) SetDMACONTROL3_BURST_LCK(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL3.Reg, volatile.LoadUint32(&o.DMACONTROL3.Reg)&^(0x80)|value<<7)
}
func (o *UDPHS_Type) GetDMACONTROL3_BURST_LCK() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL3.Reg) & 0x80) >> 7
}
func (o *UDPHS_Type) SetDMACONTROL3_BUFF_LENGTH(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL3.Reg, volatile.LoadUint32(&o.DMACONTROL3.Reg)&^(0xffff0000)|value<<16)
}
func (o *UDPHS_Type) GetDMACONTROL3_BUFF_LENGTH() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL3.Reg) & 0xffff0000) >> 16
}

// UDPHS.DMASTATUS3: UDPHS DMA Channel Status Register (channel = 3)
func (o *UDPHS_Type) SetDMASTATUS3_CHANN_ENB(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS3.Reg, volatile.LoadUint32(&o.DMASTATUS3.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetDMASTATUS3_CHANN_ENB() uint32 {
	return volatile.LoadUint32(&o.DMASTATUS3.Reg) & 0x1
}
func (o *UDPHS_Type) SetDMASTATUS3_CHANN_ACT(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS3.Reg, volatile.LoadUint32(&o.DMASTATUS3.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetDMASTATUS3_CHANN_ACT() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS3.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetDMASTATUS3_END_TR_ST(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS3.Reg, volatile.LoadUint32(&o.DMASTATUS3.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetDMASTATUS3_END_TR_ST() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS3.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetDMASTATUS3_END_BF_ST(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS3.Reg, volatile.LoadUint32(&o.DMASTATUS3.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetDMASTATUS3_END_BF_ST() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS3.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetDMASTATUS3_DESC_LDST(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS3.Reg, volatile.LoadUint32(&o.DMASTATUS3.Reg)&^(0x40)|value<<6)
}
func (o *UDPHS_Type) GetDMASTATUS3_DESC_LDST() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS3.Reg) & 0x40) >> 6
}
func (o *UDPHS_Type) SetDMASTATUS3_BUFF_COUNT(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS3.Reg, volatile.LoadUint32(&o.DMASTATUS3.Reg)&^(0xffff0000)|value<<16)
}
func (o *UDPHS_Type) GetDMASTATUS3_BUFF_COUNT() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS3.Reg) & 0xffff0000) >> 16
}

// UDPHS.DMANXTDSC4: UDPHS DMA Next Descriptor Address Register (channel = 4)
func (o *UDPHS_Type) SetDMANXTDSC4(value uint32) {
	volatile.StoreUint32(&o.DMANXTDSC4.Reg, value)
}
func (o *UDPHS_Type) GetDMANXTDSC4() uint32 {
	return volatile.LoadUint32(&o.DMANXTDSC4.Reg)
}

// UDPHS.DMAADDRESS4: UDPHS DMA Channel Address Register (channel = 4)
func (o *UDPHS_Type) SetDMAADDRESS4(value uint32) {
	volatile.StoreUint32(&o.DMAADDRESS4.Reg, value)
}
func (o *UDPHS_Type) GetDMAADDRESS4() uint32 {
	return volatile.LoadUint32(&o.DMAADDRESS4.Reg)
}

// UDPHS.DMACONTROL4: UDPHS DMA Channel Control Register (channel = 4)
func (o *UDPHS_Type) SetDMACONTROL4_CHANN_ENB(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL4.Reg, volatile.LoadUint32(&o.DMACONTROL4.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetDMACONTROL4_CHANN_ENB() uint32 {
	return volatile.LoadUint32(&o.DMACONTROL4.Reg) & 0x1
}
func (o *UDPHS_Type) SetDMACONTROL4_LDNXT_DSC(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL4.Reg, volatile.LoadUint32(&o.DMACONTROL4.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetDMACONTROL4_LDNXT_DSC() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL4.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetDMACONTROL4_END_TR_EN(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL4.Reg, volatile.LoadUint32(&o.DMACONTROL4.Reg)&^(0x4)|value<<2)
}
func (o *UDPHS_Type) GetDMACONTROL4_END_TR_EN() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL4.Reg) & 0x4) >> 2
}
func (o *UDPHS_Type) SetDMACONTROL4_END_B_EN(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL4.Reg, volatile.LoadUint32(&o.DMACONTROL4.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetDMACONTROL4_END_B_EN() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL4.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetDMACONTROL4_END_TR_IT(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL4.Reg, volatile.LoadUint32(&o.DMACONTROL4.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetDMACONTROL4_END_TR_IT() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL4.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetDMACONTROL4_END_BUFFIT(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL4.Reg, volatile.LoadUint32(&o.DMACONTROL4.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetDMACONTROL4_END_BUFFIT() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL4.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetDMACONTROL4_DESC_LD_IT(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL4.Reg, volatile.LoadUint32(&o.DMACONTROL4.Reg)&^(0x40)|value<<6)
}
func (o *UDPHS_Type) GetDMACONTROL4_DESC_LD_IT() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL4.Reg) & 0x40) >> 6
}
func (o *UDPHS_Type) SetDMACONTROL4_BURST_LCK(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL4.Reg, volatile.LoadUint32(&o.DMACONTROL4.Reg)&^(0x80)|value<<7)
}
func (o *UDPHS_Type) GetDMACONTROL4_BURST_LCK() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL4.Reg) & 0x80) >> 7
}
func (o *UDPHS_Type) SetDMACONTROL4_BUFF_LENGTH(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL4.Reg, volatile.LoadUint32(&o.DMACONTROL4.Reg)&^(0xffff0000)|value<<16)
}
func (o *UDPHS_Type) GetDMACONTROL4_BUFF_LENGTH() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL4.Reg) & 0xffff0000) >> 16
}

// UDPHS.DMASTATUS4: UDPHS DMA Channel Status Register (channel = 4)
func (o *UDPHS_Type) SetDMASTATUS4_CHANN_ENB(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS4.Reg, volatile.LoadUint32(&o.DMASTATUS4.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetDMASTATUS4_CHANN_ENB() uint32 {
	return volatile.LoadUint32(&o.DMASTATUS4.Reg) & 0x1
}
func (o *UDPHS_Type) SetDMASTATUS4_CHANN_ACT(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS4.Reg, volatile.LoadUint32(&o.DMASTATUS4.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetDMASTATUS4_CHANN_ACT() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS4.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetDMASTATUS4_END_TR_ST(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS4.Reg, volatile.LoadUint32(&o.DMASTATUS4.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetDMASTATUS4_END_TR_ST() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS4.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetDMASTATUS4_END_BF_ST(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS4.Reg, volatile.LoadUint32(&o.DMASTATUS4.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetDMASTATUS4_END_BF_ST() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS4.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetDMASTATUS4_DESC_LDST(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS4.Reg, volatile.LoadUint32(&o.DMASTATUS4.Reg)&^(0x40)|value<<6)
}
func (o *UDPHS_Type) GetDMASTATUS4_DESC_LDST() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS4.Reg) & 0x40) >> 6
}
func (o *UDPHS_Type) SetDMASTATUS4_BUFF_COUNT(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS4.Reg, volatile.LoadUint32(&o.DMASTATUS4.Reg)&^(0xffff0000)|value<<16)
}
func (o *UDPHS_Type) GetDMASTATUS4_BUFF_COUNT() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS4.Reg) & 0xffff0000) >> 16
}

// UDPHS.DMANXTDSC5: UDPHS DMA Next Descriptor Address Register (channel = 5)
func (o *UDPHS_Type) SetDMANXTDSC5(value uint32) {
	volatile.StoreUint32(&o.DMANXTDSC5.Reg, value)
}
func (o *UDPHS_Type) GetDMANXTDSC5() uint32 {
	return volatile.LoadUint32(&o.DMANXTDSC5.Reg)
}

// UDPHS.DMAADDRESS5: UDPHS DMA Channel Address Register (channel = 5)
func (o *UDPHS_Type) SetDMAADDRESS5(value uint32) {
	volatile.StoreUint32(&o.DMAADDRESS5.Reg, value)
}
func (o *UDPHS_Type) GetDMAADDRESS5() uint32 {
	return volatile.LoadUint32(&o.DMAADDRESS5.Reg)
}

// UDPHS.DMACONTROL5: UDPHS DMA Channel Control Register (channel = 5)
func (o *UDPHS_Type) SetDMACONTROL5_CHANN_ENB(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL5.Reg, volatile.LoadUint32(&o.DMACONTROL5.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetDMACONTROL5_CHANN_ENB() uint32 {
	return volatile.LoadUint32(&o.DMACONTROL5.Reg) & 0x1
}
func (o *UDPHS_Type) SetDMACONTROL5_LDNXT_DSC(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL5.Reg, volatile.LoadUint32(&o.DMACONTROL5.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetDMACONTROL5_LDNXT_DSC() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL5.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetDMACONTROL5_END_TR_EN(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL5.Reg, volatile.LoadUint32(&o.DMACONTROL5.Reg)&^(0x4)|value<<2)
}
func (o *UDPHS_Type) GetDMACONTROL5_END_TR_EN() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL5.Reg) & 0x4) >> 2
}
func (o *UDPHS_Type) SetDMACONTROL5_END_B_EN(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL5.Reg, volatile.LoadUint32(&o.DMACONTROL5.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetDMACONTROL5_END_B_EN() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL5.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetDMACONTROL5_END_TR_IT(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL5.Reg, volatile.LoadUint32(&o.DMACONTROL5.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetDMACONTROL5_END_TR_IT() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL5.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetDMACONTROL5_END_BUFFIT(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL5.Reg, volatile.LoadUint32(&o.DMACONTROL5.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetDMACONTROL5_END_BUFFIT() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL5.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetDMACONTROL5_DESC_LD_IT(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL5.Reg, volatile.LoadUint32(&o.DMACONTROL5.Reg)&^(0x40)|value<<6)
}
func (o *UDPHS_Type) GetDMACONTROL5_DESC_LD_IT() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL5.Reg) & 0x40) >> 6
}
func (o *UDPHS_Type) SetDMACONTROL5_BURST_LCK(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL5.Reg, volatile.LoadUint32(&o.DMACONTROL5.Reg)&^(0x80)|value<<7)
}
func (o *UDPHS_Type) GetDMACONTROL5_BURST_LCK() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL5.Reg) & 0x80) >> 7
}
func (o *UDPHS_Type) SetDMACONTROL5_BUFF_LENGTH(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL5.Reg, volatile.LoadUint32(&o.DMACONTROL5.Reg)&^(0xffff0000)|value<<16)
}
func (o *UDPHS_Type) GetDMACONTROL5_BUFF_LENGTH() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL5.Reg) & 0xffff0000) >> 16
}

// UDPHS.DMASTATUS5: UDPHS DMA Channel Status Register (channel = 5)
func (o *UDPHS_Type) SetDMASTATUS5_CHANN_ENB(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS5.Reg, volatile.LoadUint32(&o.DMASTATUS5.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetDMASTATUS5_CHANN_ENB() uint32 {
	return volatile.LoadUint32(&o.DMASTATUS5.Reg) & 0x1
}
func (o *UDPHS_Type) SetDMASTATUS5_CHANN_ACT(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS5.Reg, volatile.LoadUint32(&o.DMASTATUS5.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetDMASTATUS5_CHANN_ACT() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS5.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetDMASTATUS5_END_TR_ST(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS5.Reg, volatile.LoadUint32(&o.DMASTATUS5.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetDMASTATUS5_END_TR_ST() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS5.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetDMASTATUS5_END_BF_ST(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS5.Reg, volatile.LoadUint32(&o.DMASTATUS5.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetDMASTATUS5_END_BF_ST() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS5.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetDMASTATUS5_DESC_LDST(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS5.Reg, volatile.LoadUint32(&o.DMASTATUS5.Reg)&^(0x40)|value<<6)
}
func (o *UDPHS_Type) GetDMASTATUS5_DESC_LDST() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS5.Reg) & 0x40) >> 6
}
func (o *UDPHS_Type) SetDMASTATUS5_BUFF_COUNT(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS5.Reg, volatile.LoadUint32(&o.DMASTATUS5.Reg)&^(0xffff0000)|value<<16)
}
func (o *UDPHS_Type) GetDMASTATUS5_BUFF_COUNT() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS5.Reg) & 0xffff0000) >> 16
}

// Universal Asynchronous Receiver Transmitter 0
type UART_Type struct {
	CR   volatile.Register32 // 0x0
	MR   volatile.Register32 // 0x4
	IER  volatile.Register32 // 0x8
	IDR  volatile.Register32 // 0xC
	IMR  volatile.Register32 // 0x10
	SR   volatile.Register32 // 0x14
	RHR  volatile.Register32 // 0x18
	THR  volatile.Register32 // 0x1C
	BRGR volatile.Register32 // 0x20
}

// UART.CR: Control Register
func (o *UART_Type) SetCR_RSTRX(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *UART_Type) GetCR_RSTRX() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *UART_Type) SetCR_RSTTX(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *UART_Type) GetCR_RSTTX() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *UART_Type) SetCR_RXEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *UART_Type) GetCR_RXEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *UART_Type) SetCR_RXDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20)|value<<5)
}
func (o *UART_Type) GetCR_RXDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20) >> 5
}
func (o *UART_Type) SetCR_TXEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40)|value<<6)
}
func (o *UART_Type) GetCR_TXEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40) >> 6
}
func (o *UART_Type) SetCR_TXDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *UART_Type) GetCR_TXDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *UART_Type) SetCR_RSTSTA(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100)|value<<8)
}
func (o *UART_Type) GetCR_RSTSTA() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100) >> 8
}

// UART.MR: Mode Register
func (o *UART_Type) SetMR_PAR(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xe00)|value<<9)
}
func (o *UART_Type) GetMR_PAR() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xe00) >> 9
}
func (o *UART_Type) SetMR_CHMODE(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xc000)|value<<14)
}
func (o *UART_Type) GetMR_CHMODE() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xc000) >> 14
}

// UART.IER: Interrupt Enable Register
func (o *UART_Type) SetIER_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *UART_Type) GetIER_RXRDY() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *UART_Type) SetIER_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *UART_Type) GetIER_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *UART_Type) SetIER_OVRE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *UART_Type) GetIER_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *UART_Type) SetIER_FRAME(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40)|value<<6)
}
func (o *UART_Type) GetIER_FRAME() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40) >> 6
}
func (o *UART_Type) SetIER_PARE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80)|value<<7)
}
func (o *UART_Type) GetIER_PARE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80) >> 7
}
func (o *UART_Type) SetIER_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200)|value<<9)
}
func (o *UART_Type) GetIER_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200) >> 9
}

// UART.IDR: Interrupt Disable Register
func (o *UART_Type) SetIDR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *UART_Type) GetIDR_RXRDY() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *UART_Type) SetIDR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *UART_Type) GetIDR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *UART_Type) SetIDR_OVRE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20)|value<<5)
}
func (o *UART_Type) GetIDR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20) >> 5
}
func (o *UART_Type) SetIDR_FRAME(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40)|value<<6)
}
func (o *UART_Type) GetIDR_FRAME() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40) >> 6
}
func (o *UART_Type) SetIDR_PARE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80)|value<<7)
}
func (o *UART_Type) GetIDR_PARE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80) >> 7
}
func (o *UART_Type) SetIDR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200)|value<<9)
}
func (o *UART_Type) GetIDR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200) >> 9
}

// UART.IMR: Interrupt Mask Register
func (o *UART_Type) SetIMR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *UART_Type) GetIMR_RXRDY() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *UART_Type) SetIMR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *UART_Type) GetIMR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *UART_Type) SetIMR_OVRE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20)|value<<5)
}
func (o *UART_Type) GetIMR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20) >> 5
}
func (o *UART_Type) SetIMR_FRAME(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40)|value<<6)
}
func (o *UART_Type) GetIMR_FRAME() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40) >> 6
}
func (o *UART_Type) SetIMR_PARE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80)|value<<7)
}
func (o *UART_Type) GetIMR_PARE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80) >> 7
}
func (o *UART_Type) SetIMR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200)|value<<9)
}
func (o *UART_Type) GetIMR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200) >> 9
}

// UART.SR: Status Register
func (o *UART_Type) SetSR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *UART_Type) GetSR_RXRDY() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *UART_Type) SetSR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *UART_Type) GetSR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *UART_Type) SetSR_OVRE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *UART_Type) GetSR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *UART_Type) SetSR_FRAME(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *UART_Type) GetSR_FRAME() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *UART_Type) SetSR_PARE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80)|value<<7)
}
func (o *UART_Type) GetSR_PARE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80) >> 7
}
func (o *UART_Type) SetSR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x200)|value<<9)
}
func (o *UART_Type) GetSR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x200) >> 9
}

// UART.RHR: Receive Holding Register
func (o *UART_Type) SetRHR_RXCHR(value uint32) {
	volatile.StoreUint32(&o.RHR.Reg, volatile.LoadUint32(&o.RHR.Reg)&^(0xff)|value)
}
func (o *UART_Type) GetRHR_RXCHR() uint32 {
	return volatile.LoadUint32(&o.RHR.Reg) & 0xff
}

// UART.THR: Transmit Holding Register
func (o *UART_Type) SetTHR_TXCHR(value uint32) {
	volatile.StoreUint32(&o.THR.Reg, volatile.LoadUint32(&o.THR.Reg)&^(0xff)|value)
}
func (o *UART_Type) GetTHR_TXCHR() uint32 {
	return volatile.LoadUint32(&o.THR.Reg) & 0xff
}

// UART.BRGR: Baud Rate Generator Register
func (o *UART_Type) SetBRGR_CD(value uint32) {
	volatile.StoreUint32(&o.BRGR.Reg, volatile.LoadUint32(&o.BRGR.Reg)&^(0xffff)|value)
}
func (o *UART_Type) GetBRGR_CD() uint32 {
	return volatile.LoadUint32(&o.BRGR.Reg) & 0xffff
}

// Analog-to-Digital Converter
type ADC_Type struct {
	CR     volatile.Register32 // 0x0
	MR     volatile.Register32 // 0x4
	SEQR1  volatile.Register32 // 0x8
	SEQR2  volatile.Register32 // 0xC
	CHER   volatile.Register32 // 0x10
	CHDR   volatile.Register32 // 0x14
	CHSR   volatile.Register32 // 0x18
	_      [4]byte
	LCDR   volatile.Register32 // 0x20
	IER    volatile.Register32 // 0x24
	IDR    volatile.Register32 // 0x28
	IMR    volatile.Register32 // 0x2C
	ISR    volatile.Register32 // 0x30
	_      [8]byte
	OVER   volatile.Register32 // 0x3C
	EMR    volatile.Register32 // 0x40
	CWR    volatile.Register32 // 0x44
	_      [8]byte
	CDR    [12]volatile.Register32 // 0x50
	_      [20]byte
	ACR    volatile.Register32 // 0x94
	_      [24]byte
	TSMR   volatile.Register32 // 0xB0
	XPOSR  volatile.Register32 // 0xB4
	YPOSR  volatile.Register32 // 0xB8
	PRESSR volatile.Register32 // 0xBC
	TRGR   volatile.Register32 // 0xC0
	_      [32]byte
	WPMR   volatile.Register32 // 0xE4
	WPSR   volatile.Register32 // 0xE8
}

// ADC.CR: Control Register
func (o *ADC_Type) SetCR_SWRST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetCR_SWRST() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *ADC_Type) SetCR_START(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetCR_START() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetCR_TSCALIB(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetCR_TSCALIB() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}

// ADC.MR: Mode Register
func (o *ADC_Type) SetMR_LOWRES(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetMR_LOWRES() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetMR_SLEEP(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetMR_SLEEP() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetMR_FWUP(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetMR_FWUP() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetMR_PRESCAL(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xff00)|value<<8)
}
func (o *ADC_Type) GetMR_PRESCAL() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xff00) >> 8
}
func (o *ADC_Type) SetMR_STARTUP(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xf0000)|value<<16)
}
func (o *ADC_Type) GetMR_STARTUP() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xf0000) >> 16
}
func (o *ADC_Type) SetMR_TRACKTIM(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xf000000)|value<<24)
}
func (o *ADC_Type) GetMR_TRACKTIM() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xf000000) >> 24
}
func (o *ADC_Type) SetMR_USEQ(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x80000000)|value<<31)
}
func (o *ADC_Type) GetMR_USEQ() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x80000000) >> 31
}

// ADC.SEQR1: Channel Sequence Register 1
func (o *ADC_Type) SetSEQR1_USCH1(value uint32) {
	volatile.StoreUint32(&o.SEQR1.Reg, volatile.LoadUint32(&o.SEQR1.Reg)&^(0xf)|value)
}
func (o *ADC_Type) GetSEQR1_USCH1() uint32 {
	return volatile.LoadUint32(&o.SEQR1.Reg) & 0xf
}
func (o *ADC_Type) SetSEQR1_USCH2(value uint32) {
	volatile.StoreUint32(&o.SEQR1.Reg, volatile.LoadUint32(&o.SEQR1.Reg)&^(0xf0)|value<<4)
}
func (o *ADC_Type) GetSEQR1_USCH2() uint32 {
	return (volatile.LoadUint32(&o.SEQR1.Reg) & 0xf0) >> 4
}
func (o *ADC_Type) SetSEQR1_USCH3(value uint32) {
	volatile.StoreUint32(&o.SEQR1.Reg, volatile.LoadUint32(&o.SEQR1.Reg)&^(0xf00)|value<<8)
}
func (o *ADC_Type) GetSEQR1_USCH3() uint32 {
	return (volatile.LoadUint32(&o.SEQR1.Reg) & 0xf00) >> 8
}
func (o *ADC_Type) SetSEQR1_USCH4(value uint32) {
	volatile.StoreUint32(&o.SEQR1.Reg, volatile.LoadUint32(&o.SEQR1.Reg)&^(0xf000)|value<<12)
}
func (o *ADC_Type) GetSEQR1_USCH4() uint32 {
	return (volatile.LoadUint32(&o.SEQR1.Reg) & 0xf000) >> 12
}
func (o *ADC_Type) SetSEQR1_USCH5(value uint32) {
	volatile.StoreUint32(&o.SEQR1.Reg, volatile.LoadUint32(&o.SEQR1.Reg)&^(0xf0000)|value<<16)
}
func (o *ADC_Type) GetSEQR1_USCH5() uint32 {
	return (volatile.LoadUint32(&o.SEQR1.Reg) & 0xf0000) >> 16
}
func (o *ADC_Type) SetSEQR1_USCH6(value uint32) {
	volatile.StoreUint32(&o.SEQR1.Reg, volatile.LoadUint32(&o.SEQR1.Reg)&^(0xf00000)|value<<20)
}
func (o *ADC_Type) GetSEQR1_USCH6() uint32 {
	return (volatile.LoadUint32(&o.SEQR1.Reg) & 0xf00000) >> 20
}
func (o *ADC_Type) SetSEQR1_USCH7(value uint32) {
	volatile.StoreUint32(&o.SEQR1.Reg, volatile.LoadUint32(&o.SEQR1.Reg)&^(0xf000000)|value<<24)
}
func (o *ADC_Type) GetSEQR1_USCH7() uint32 {
	return (volatile.LoadUint32(&o.SEQR1.Reg) & 0xf000000) >> 24
}
func (o *ADC_Type) SetSEQR1_USCH8(value uint32) {
	volatile.StoreUint32(&o.SEQR1.Reg, volatile.LoadUint32(&o.SEQR1.Reg)&^(0xf0000000)|value<<28)
}
func (o *ADC_Type) GetSEQR1_USCH8() uint32 {
	return (volatile.LoadUint32(&o.SEQR1.Reg) & 0xf0000000) >> 28
}

// ADC.SEQR2: Channel Sequence Register 2
func (o *ADC_Type) SetSEQR2_USCH9(value uint32) {
	volatile.StoreUint32(&o.SEQR2.Reg, volatile.LoadUint32(&o.SEQR2.Reg)&^(0xf)|value)
}
func (o *ADC_Type) GetSEQR2_USCH9() uint32 {
	return volatile.LoadUint32(&o.SEQR2.Reg) & 0xf
}
func (o *ADC_Type) SetSEQR2_USCH10(value uint32) {
	volatile.StoreUint32(&o.SEQR2.Reg, volatile.LoadUint32(&o.SEQR2.Reg)&^(0xf0)|value<<4)
}
func (o *ADC_Type) GetSEQR2_USCH10() uint32 {
	return (volatile.LoadUint32(&o.SEQR2.Reg) & 0xf0) >> 4
}
func (o *ADC_Type) SetSEQR2_USCH11(value uint32) {
	volatile.StoreUint32(&o.SEQR2.Reg, volatile.LoadUint32(&o.SEQR2.Reg)&^(0xf00)|value<<8)
}
func (o *ADC_Type) GetSEQR2_USCH11() uint32 {
	return (volatile.LoadUint32(&o.SEQR2.Reg) & 0xf00) >> 8
}
func (o *ADC_Type) SetSEQR2_USCH12(value uint32) {
	volatile.StoreUint32(&o.SEQR2.Reg, volatile.LoadUint32(&o.SEQR2.Reg)&^(0xf000)|value<<12)
}
func (o *ADC_Type) GetSEQR2_USCH12() uint32 {
	return (volatile.LoadUint32(&o.SEQR2.Reg) & 0xf000) >> 12
}
func (o *ADC_Type) SetSEQR2_USCH13(value uint32) {
	volatile.StoreUint32(&o.SEQR2.Reg, volatile.LoadUint32(&o.SEQR2.Reg)&^(0xf0000)|value<<16)
}
func (o *ADC_Type) GetSEQR2_USCH13() uint32 {
	return (volatile.LoadUint32(&o.SEQR2.Reg) & 0xf0000) >> 16
}
func (o *ADC_Type) SetSEQR2_USCH14(value uint32) {
	volatile.StoreUint32(&o.SEQR2.Reg, volatile.LoadUint32(&o.SEQR2.Reg)&^(0xf00000)|value<<20)
}
func (o *ADC_Type) GetSEQR2_USCH14() uint32 {
	return (volatile.LoadUint32(&o.SEQR2.Reg) & 0xf00000) >> 20
}
func (o *ADC_Type) SetSEQR2_USCH15(value uint32) {
	volatile.StoreUint32(&o.SEQR2.Reg, volatile.LoadUint32(&o.SEQR2.Reg)&^(0xf000000)|value<<24)
}
func (o *ADC_Type) GetSEQR2_USCH15() uint32 {
	return (volatile.LoadUint32(&o.SEQR2.Reg) & 0xf000000) >> 24
}
func (o *ADC_Type) SetSEQR2_USCH16(value uint32) {
	volatile.StoreUint32(&o.SEQR2.Reg, volatile.LoadUint32(&o.SEQR2.Reg)&^(0xf0000000)|value<<28)
}
func (o *ADC_Type) GetSEQR2_USCH16() uint32 {
	return (volatile.LoadUint32(&o.SEQR2.Reg) & 0xf0000000) >> 28
}

// ADC.CHER: Channel Enable Register
func (o *ADC_Type) SetCHER_CH0(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetCHER_CH0() uint32 {
	return volatile.LoadUint32(&o.CHER.Reg) & 0x1
}
func (o *ADC_Type) SetCHER_CH1(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetCHER_CH1() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetCHER_CH2(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetCHER_CH2() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetCHER_CH3(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetCHER_CH3() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetCHER_CH4(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetCHER_CH4() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetCHER_CH5(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetCHER_CH5() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetCHER_CH6(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetCHER_CH6() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetCHER_CH7(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetCHER_CH7() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetCHER_CH8(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetCHER_CH8() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetCHER_CH9(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetCHER_CH9() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetCHER_CH10(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetCHER_CH10() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetCHER_CH11(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x800)|value<<11)
}
func (o *ADC_Type) GetCHER_CH11() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x800) >> 11
}

// ADC.CHDR: Channel Disable Register
func (o *ADC_Type) SetCHDR_CH0(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetCHDR_CH0() uint32 {
	return volatile.LoadUint32(&o.CHDR.Reg) & 0x1
}
func (o *ADC_Type) SetCHDR_CH1(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetCHDR_CH1() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetCHDR_CH2(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetCHDR_CH2() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetCHDR_CH3(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetCHDR_CH3() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetCHDR_CH4(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetCHDR_CH4() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetCHDR_CH5(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetCHDR_CH5() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetCHDR_CH6(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetCHDR_CH6() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetCHDR_CH7(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetCHDR_CH7() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetCHDR_CH8(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetCHDR_CH8() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetCHDR_CH9(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetCHDR_CH9() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetCHDR_CH10(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetCHDR_CH10() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetCHDR_CH11(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x800)|value<<11)
}
func (o *ADC_Type) GetCHDR_CH11() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x800) >> 11
}

// ADC.CHSR: Channel Status Register
func (o *ADC_Type) SetCHSR_CH0(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetCHSR_CH0() uint32 {
	return volatile.LoadUint32(&o.CHSR.Reg) & 0x1
}
func (o *ADC_Type) SetCHSR_CH1(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetCHSR_CH1() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetCHSR_CH2(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetCHSR_CH2() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetCHSR_CH3(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetCHSR_CH3() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetCHSR_CH4(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetCHSR_CH4() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetCHSR_CH5(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetCHSR_CH5() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetCHSR_CH6(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetCHSR_CH6() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetCHSR_CH7(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetCHSR_CH7() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetCHSR_CH8(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetCHSR_CH8() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetCHSR_CH9(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetCHSR_CH9() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetCHSR_CH10(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetCHSR_CH10() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetCHSR_CH11(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x800)|value<<11)
}
func (o *ADC_Type) GetCHSR_CH11() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x800) >> 11
}

// ADC.LCDR: Last Converted Data Register
func (o *ADC_Type) SetLCDR_LDATA(value uint32) {
	volatile.StoreUint32(&o.LCDR.Reg, volatile.LoadUint32(&o.LCDR.Reg)&^(0xfff)|value)
}
func (o *ADC_Type) GetLCDR_LDATA() uint32 {
	return volatile.LoadUint32(&o.LCDR.Reg) & 0xfff
}
func (o *ADC_Type) SetLCDR_CHNB(value uint32) {
	volatile.StoreUint32(&o.LCDR.Reg, volatile.LoadUint32(&o.LCDR.Reg)&^(0xf000)|value<<12)
}
func (o *ADC_Type) GetLCDR_CHNB() uint32 {
	return (volatile.LoadUint32(&o.LCDR.Reg) & 0xf000) >> 12
}

// ADC.IER: Interrupt Enable Register
func (o *ADC_Type) SetIER_EOC0(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetIER_EOC0() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *ADC_Type) SetIER_EOC1(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetIER_EOC1() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetIER_EOC2(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetIER_EOC2() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetIER_EOC3(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetIER_EOC3() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetIER_EOC4(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetIER_EOC4() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetIER_EOC5(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetIER_EOC5() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetIER_EOC6(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetIER_EOC6() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetIER_EOC7(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetIER_EOC7() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetIER_EOC8(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetIER_EOC8() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetIER_EOC9(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetIER_EOC9() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetIER_EOC10(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetIER_EOC10() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetIER_EOC11(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x800)|value<<11)
}
func (o *ADC_Type) GetIER_EOC11() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x800) >> 11
}
func (o *ADC_Type) SetIER_XRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100000)|value<<20)
}
func (o *ADC_Type) GetIER_XRDY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100000) >> 20
}
func (o *ADC_Type) SetIER_YRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200000)|value<<21)
}
func (o *ADC_Type) GetIER_YRDY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200000) >> 21
}
func (o *ADC_Type) SetIER_PRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400000)|value<<22)
}
func (o *ADC_Type) GetIER_PRDY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400000) >> 22
}
func (o *ADC_Type) SetIER_DRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1000000)|value<<24)
}
func (o *ADC_Type) GetIER_DRDY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x1000000) >> 24
}
func (o *ADC_Type) SetIER_GOVRE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2000000)|value<<25)
}
func (o *ADC_Type) GetIER_GOVRE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2000000) >> 25
}
func (o *ADC_Type) SetIER_COMPE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4000000)|value<<26)
}
func (o *ADC_Type) GetIER_COMPE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4000000) >> 26
}
func (o *ADC_Type) SetIER_PEN(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20000000)|value<<29)
}
func (o *ADC_Type) GetIER_PEN() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20000000) >> 29
}
func (o *ADC_Type) SetIER_NOPEN(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40000000)|value<<30)
}
func (o *ADC_Type) GetIER_NOPEN() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40000000) >> 30
}

// ADC.IDR: Interrupt Disable Register
func (o *ADC_Type) SetIDR_EOC0(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetIDR_EOC0() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *ADC_Type) SetIDR_EOC1(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetIDR_EOC1() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetIDR_EOC2(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetIDR_EOC2() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetIDR_EOC3(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetIDR_EOC3() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetIDR_EOC4(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetIDR_EOC4() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetIDR_EOC5(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetIDR_EOC5() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetIDR_EOC6(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetIDR_EOC6() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetIDR_EOC7(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetIDR_EOC7() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetIDR_EOC8(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetIDR_EOC8() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetIDR_EOC9(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetIDR_EOC9() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetIDR_EOC10(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetIDR_EOC10() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetIDR_EOC11(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x800)|value<<11)
}
func (o *ADC_Type) GetIDR_EOC11() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x800) >> 11
}
func (o *ADC_Type) SetIDR_XRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100000)|value<<20)
}
func (o *ADC_Type) GetIDR_XRDY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100000) >> 20
}
func (o *ADC_Type) SetIDR_YRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200000)|value<<21)
}
func (o *ADC_Type) GetIDR_YRDY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200000) >> 21
}
func (o *ADC_Type) SetIDR_PRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400000)|value<<22)
}
func (o *ADC_Type) GetIDR_PRDY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400000) >> 22
}
func (o *ADC_Type) SetIDR_DRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1000000)|value<<24)
}
func (o *ADC_Type) GetIDR_DRDY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x1000000) >> 24
}
func (o *ADC_Type) SetIDR_GOVRE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2000000)|value<<25)
}
func (o *ADC_Type) GetIDR_GOVRE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2000000) >> 25
}
func (o *ADC_Type) SetIDR_COMPE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4000000)|value<<26)
}
func (o *ADC_Type) GetIDR_COMPE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4000000) >> 26
}
func (o *ADC_Type) SetIDR_PEN(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20000000)|value<<29)
}
func (o *ADC_Type) GetIDR_PEN() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20000000) >> 29
}
func (o *ADC_Type) SetIDR_NOPEN(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40000000)|value<<30)
}
func (o *ADC_Type) GetIDR_NOPEN() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40000000) >> 30
}

// ADC.IMR: Interrupt Mask Register
func (o *ADC_Type) SetIMR_EOC0(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetIMR_EOC0() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *ADC_Type) SetIMR_EOC1(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetIMR_EOC1() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetIMR_EOC2(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetIMR_EOC2() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetIMR_EOC3(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetIMR_EOC3() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetIMR_EOC4(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetIMR_EOC4() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetIMR_EOC5(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetIMR_EOC5() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetIMR_EOC6(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetIMR_EOC6() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetIMR_EOC7(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetIMR_EOC7() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetIMR_EOC8(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetIMR_EOC8() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetIMR_EOC9(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetIMR_EOC9() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetIMR_EOC10(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetIMR_EOC10() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetIMR_EOC11(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x800)|value<<11)
}
func (o *ADC_Type) GetIMR_EOC11() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x800) >> 11
}
func (o *ADC_Type) SetIMR_XRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100000)|value<<20)
}
func (o *ADC_Type) GetIMR_XRDY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100000) >> 20
}
func (o *ADC_Type) SetIMR_YRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200000)|value<<21)
}
func (o *ADC_Type) GetIMR_YRDY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200000) >> 21
}
func (o *ADC_Type) SetIMR_PRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400000)|value<<22)
}
func (o *ADC_Type) GetIMR_PRDY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400000) >> 22
}
func (o *ADC_Type) SetIMR_DRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1000000)|value<<24)
}
func (o *ADC_Type) GetIMR_DRDY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x1000000) >> 24
}
func (o *ADC_Type) SetIMR_GOVRE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2000000)|value<<25)
}
func (o *ADC_Type) GetIMR_GOVRE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2000000) >> 25
}
func (o *ADC_Type) SetIMR_COMPE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4000000)|value<<26)
}
func (o *ADC_Type) GetIMR_COMPE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4000000) >> 26
}
func (o *ADC_Type) SetIMR_PEN(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20000000)|value<<29)
}
func (o *ADC_Type) GetIMR_PEN() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20000000) >> 29
}
func (o *ADC_Type) SetIMR_NOPEN(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40000000)|value<<30)
}
func (o *ADC_Type) GetIMR_NOPEN() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40000000) >> 30
}

// ADC.ISR: Interrupt Status Register
func (o *ADC_Type) SetISR_EOC0(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetISR_EOC0() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}
func (o *ADC_Type) SetISR_EOC1(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetISR_EOC1() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetISR_EOC2(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetISR_EOC2() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetISR_EOC3(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetISR_EOC3() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetISR_EOC4(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetISR_EOC4() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetISR_EOC5(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetISR_EOC5() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetISR_EOC6(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetISR_EOC6() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetISR_EOC7(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetISR_EOC7() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetISR_EOC8(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetISR_EOC8() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetISR_EOC9(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetISR_EOC9() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetISR_EOC10(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetISR_EOC10() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetISR_EOC11(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x800)|value<<11)
}
func (o *ADC_Type) GetISR_EOC11() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x800) >> 11
}
func (o *ADC_Type) SetISR_XRDY(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100000)|value<<20)
}
func (o *ADC_Type) GetISR_XRDY() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100000) >> 20
}
func (o *ADC_Type) SetISR_YRDY(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200000)|value<<21)
}
func (o *ADC_Type) GetISR_YRDY() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200000) >> 21
}
func (o *ADC_Type) SetISR_PRDY(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400000)|value<<22)
}
func (o *ADC_Type) GetISR_PRDY() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400000) >> 22
}
func (o *ADC_Type) SetISR_DRDY(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1000000)|value<<24)
}
func (o *ADC_Type) GetISR_DRDY() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x1000000) >> 24
}
func (o *ADC_Type) SetISR_GOVRE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2000000)|value<<25)
}
func (o *ADC_Type) GetISR_GOVRE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2000000) >> 25
}
func (o *ADC_Type) SetISR_COMPE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4000000)|value<<26)
}
func (o *ADC_Type) GetISR_COMPE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4000000) >> 26
}
func (o *ADC_Type) SetISR_PEN(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20000000)|value<<29)
}
func (o *ADC_Type) GetISR_PEN() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20000000) >> 29
}
func (o *ADC_Type) SetISR_NOPEN(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40000000)|value<<30)
}
func (o *ADC_Type) GetISR_NOPEN() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40000000) >> 30
}
func (o *ADC_Type) SetISR_PENS(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80000000)|value<<31)
}
func (o *ADC_Type) GetISR_PENS() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80000000) >> 31
}

// ADC.OVER: Overrun Status Register
func (o *ADC_Type) SetOVER_OVRE0(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetOVER_OVRE0() uint32 {
	return volatile.LoadUint32(&o.OVER.Reg) & 0x1
}
func (o *ADC_Type) SetOVER_OVRE1(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetOVER_OVRE1() uint32 {
	return (volatile.LoadUint32(&o.OVER.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetOVER_OVRE2(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetOVER_OVRE2() uint32 {
	return (volatile.LoadUint32(&o.OVER.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetOVER_OVRE3(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetOVER_OVRE3() uint32 {
	return (volatile.LoadUint32(&o.OVER.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetOVER_OVRE4(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetOVER_OVRE4() uint32 {
	return (volatile.LoadUint32(&o.OVER.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetOVER_OVRE5(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetOVER_OVRE5() uint32 {
	return (volatile.LoadUint32(&o.OVER.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetOVER_OVRE6(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetOVER_OVRE6() uint32 {
	return (volatile.LoadUint32(&o.OVER.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetOVER_OVRE7(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetOVER_OVRE7() uint32 {
	return (volatile.LoadUint32(&o.OVER.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetOVER_OVRE8(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetOVER_OVRE8() uint32 {
	return (volatile.LoadUint32(&o.OVER.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetOVER_OVRE9(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetOVER_OVRE9() uint32 {
	return (volatile.LoadUint32(&o.OVER.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetOVER_OVRE10(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetOVER_OVRE10() uint32 {
	return (volatile.LoadUint32(&o.OVER.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetOVER_OVRE11(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x800)|value<<11)
}
func (o *ADC_Type) GetOVER_OVRE11() uint32 {
	return (volatile.LoadUint32(&o.OVER.Reg) & 0x800) >> 11
}

// ADC.EMR: Extended Mode Register
func (o *ADC_Type) SetEMR_CMPMODE(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x3)|value)
}
func (o *ADC_Type) GetEMR_CMPMODE() uint32 {
	return volatile.LoadUint32(&o.EMR.Reg) & 0x3
}
func (o *ADC_Type) SetEMR_CMPSEL(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0xf0)|value<<4)
}
func (o *ADC_Type) GetEMR_CMPSEL() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0xf0) >> 4
}
func (o *ADC_Type) SetEMR_CMPALL(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetEMR_CMPALL() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetEMR_CMPFILTER(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x3000)|value<<12)
}
func (o *ADC_Type) GetEMR_CMPFILTER() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x3000) >> 12
}
func (o *ADC_Type) SetEMR_TAG(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x1000000)|value<<24)
}
func (o *ADC_Type) GetEMR_TAG() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x1000000) >> 24
}

// ADC.CWR: Compare Window Register
func (o *ADC_Type) SetCWR_LOWTHRES(value uint32) {
	volatile.StoreUint32(&o.CWR.Reg, volatile.LoadUint32(&o.CWR.Reg)&^(0xfff)|value)
}
func (o *ADC_Type) GetCWR_LOWTHRES() uint32 {
	return volatile.LoadUint32(&o.CWR.Reg) & 0xfff
}
func (o *ADC_Type) SetCWR_HIGHTHRES(value uint32) {
	volatile.StoreUint32(&o.CWR.Reg, volatile.LoadUint32(&o.CWR.Reg)&^(0xfff0000)|value<<16)
}
func (o *ADC_Type) GetCWR_HIGHTHRES() uint32 {
	return (volatile.LoadUint32(&o.CWR.Reg) & 0xfff0000) >> 16
}

// ADC.CDR: Channel Data Register
func (o *ADC_Type) SetCDR_DATA(idx int, value uint32) {
	volatile.StoreUint32(&o.CDR[idx].Reg, volatile.LoadUint32(&o.CDR[idx].Reg)&^(0xfff)|value)
}
func (o *ADC_Type) GetCDR_DATA(idx int) uint32 {
	return volatile.LoadUint32(&o.CDR[idx].Reg) & 0xfff
}

// ADC.ACR: Analog Control Register
func (o *ADC_Type) SetACR_PENDETSENS(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x3)|value)
}
func (o *ADC_Type) GetACR_PENDETSENS() uint32 {
	return volatile.LoadUint32(&o.ACR.Reg) & 0x3
}

// ADC.TSMR: Touchscreen Mode Register
func (o *ADC_Type) SetTSMR_TSMODE(value uint32) {
	volatile.StoreUint32(&o.TSMR.Reg, volatile.LoadUint32(&o.TSMR.Reg)&^(0x3)|value)
}
func (o *ADC_Type) GetTSMR_TSMODE() uint32 {
	return volatile.LoadUint32(&o.TSMR.Reg) & 0x3
}
func (o *ADC_Type) SetTSMR_TSAV(value uint32) {
	volatile.StoreUint32(&o.TSMR.Reg, volatile.LoadUint32(&o.TSMR.Reg)&^(0x30)|value<<4)
}
func (o *ADC_Type) GetTSMR_TSAV() uint32 {
	return (volatile.LoadUint32(&o.TSMR.Reg) & 0x30) >> 4
}
func (o *ADC_Type) SetTSMR_TSFREQ(value uint32) {
	volatile.StoreUint32(&o.TSMR.Reg, volatile.LoadUint32(&o.TSMR.Reg)&^(0xf00)|value<<8)
}
func (o *ADC_Type) GetTSMR_TSFREQ() uint32 {
	return (volatile.LoadUint32(&o.TSMR.Reg) & 0xf00) >> 8
}
func (o *ADC_Type) SetTSMR_TSSCTIM(value uint32) {
	volatile.StoreUint32(&o.TSMR.Reg, volatile.LoadUint32(&o.TSMR.Reg)&^(0xf0000)|value<<16)
}
func (o *ADC_Type) GetTSMR_TSSCTIM() uint32 {
	return (volatile.LoadUint32(&o.TSMR.Reg) & 0xf0000) >> 16
}
func (o *ADC_Type) SetTSMR_NOTSDMA(value uint32) {
	volatile.StoreUint32(&o.TSMR.Reg, volatile.LoadUint32(&o.TSMR.Reg)&^(0x400000)|value<<22)
}
func (o *ADC_Type) GetTSMR_NOTSDMA() uint32 {
	return (volatile.LoadUint32(&o.TSMR.Reg) & 0x400000) >> 22
}
func (o *ADC_Type) SetTSMR_PENDET(value uint32) {
	volatile.StoreUint32(&o.TSMR.Reg, volatile.LoadUint32(&o.TSMR.Reg)&^(0x1000000)|value<<24)
}
func (o *ADC_Type) GetTSMR_PENDET() uint32 {
	return (volatile.LoadUint32(&o.TSMR.Reg) & 0x1000000) >> 24
}
func (o *ADC_Type) SetTSMR_PENDBC(value uint32) {
	volatile.StoreUint32(&o.TSMR.Reg, volatile.LoadUint32(&o.TSMR.Reg)&^(0xf0000000)|value<<28)
}
func (o *ADC_Type) GetTSMR_PENDBC() uint32 {
	return (volatile.LoadUint32(&o.TSMR.Reg) & 0xf0000000) >> 28
}

// ADC.XPOSR: Touchscreen X Position Register
func (o *ADC_Type) SetXPOSR_XPOS(value uint32) {
	volatile.StoreUint32(&o.XPOSR.Reg, volatile.LoadUint32(&o.XPOSR.Reg)&^(0xfff)|value)
}
func (o *ADC_Type) GetXPOSR_XPOS() uint32 {
	return volatile.LoadUint32(&o.XPOSR.Reg) & 0xfff
}
func (o *ADC_Type) SetXPOSR_XSCALE(value uint32) {
	volatile.StoreUint32(&o.XPOSR.Reg, volatile.LoadUint32(&o.XPOSR.Reg)&^(0xfff0000)|value<<16)
}
func (o *ADC_Type) GetXPOSR_XSCALE() uint32 {
	return (volatile.LoadUint32(&o.XPOSR.Reg) & 0xfff0000) >> 16
}

// ADC.YPOSR: Touchscreen Y Position Register
func (o *ADC_Type) SetYPOSR_YPOS(value uint32) {
	volatile.StoreUint32(&o.YPOSR.Reg, volatile.LoadUint32(&o.YPOSR.Reg)&^(0xfff)|value)
}
func (o *ADC_Type) GetYPOSR_YPOS() uint32 {
	return volatile.LoadUint32(&o.YPOSR.Reg) & 0xfff
}
func (o *ADC_Type) SetYPOSR_YSCALE(value uint32) {
	volatile.StoreUint32(&o.YPOSR.Reg, volatile.LoadUint32(&o.YPOSR.Reg)&^(0xfff0000)|value<<16)
}
func (o *ADC_Type) GetYPOSR_YSCALE() uint32 {
	return (volatile.LoadUint32(&o.YPOSR.Reg) & 0xfff0000) >> 16
}

// ADC.PRESSR: Touchscreen Pressure Register
func (o *ADC_Type) SetPRESSR_Z1(value uint32) {
	volatile.StoreUint32(&o.PRESSR.Reg, volatile.LoadUint32(&o.PRESSR.Reg)&^(0xfff)|value)
}
func (o *ADC_Type) GetPRESSR_Z1() uint32 {
	return volatile.LoadUint32(&o.PRESSR.Reg) & 0xfff
}
func (o *ADC_Type) SetPRESSR_Z2(value uint32) {
	volatile.StoreUint32(&o.PRESSR.Reg, volatile.LoadUint32(&o.PRESSR.Reg)&^(0xfff0000)|value<<16)
}
func (o *ADC_Type) GetPRESSR_Z2() uint32 {
	return (volatile.LoadUint32(&o.PRESSR.Reg) & 0xfff0000) >> 16
}

// ADC.TRGR: Trigger Register
func (o *ADC_Type) SetTRGR_TRGMOD(value uint32) {
	volatile.StoreUint32(&o.TRGR.Reg, volatile.LoadUint32(&o.TRGR.Reg)&^(0x7)|value)
}
func (o *ADC_Type) GetTRGR_TRGMOD() uint32 {
	return volatile.LoadUint32(&o.TRGR.Reg) & 0x7
}
func (o *ADC_Type) SetTRGR_TRGPER(value uint32) {
	volatile.StoreUint32(&o.TRGR.Reg, volatile.LoadUint32(&o.TRGR.Reg)&^(0xffff0000)|value<<16)
}
func (o *ADC_Type) GetTRGR_TRGPER() uint32 {
	return (volatile.LoadUint32(&o.TRGR.Reg) & 0xffff0000) >> 16
}

// ADC.WPMR: Write Protect Mode Register
func (o *ADC_Type) SetWPMR_WPEN(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetWPMR_WPEN() uint32 {
	return volatile.LoadUint32(&o.WPMR.Reg) & 0x1
}
func (o *ADC_Type) SetWPMR_WPKEY(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *ADC_Type) GetWPMR_WPKEY() uint32 {
	return (volatile.LoadUint32(&o.WPMR.Reg) & 0xffffff00) >> 8
}

// ADC.WPSR: Write Protect Status Register
func (o *ADC_Type) SetWPSR_WPVS(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetWPSR_WPVS() uint32 {
	return volatile.LoadUint32(&o.WPSR.Reg) & 0x1
}
func (o *ADC_Type) SetWPSR_WPVSRC(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0xffff00)|value<<8)
}
func (o *ADC_Type) GetWPSR_WPVSRC() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0xffff00) >> 8
}

// AHB Bus Matrix
type MATRIX_Type struct {
	MCFG  [11]volatile.Register32 // 0x0
	_     [20]byte
	SCFG  [10]volatile.Register32 // 0x40
	_     [24]byte
	PRAS0 volatile.Register32 // 0x80
	PRBS0 volatile.Register32 // 0x84
	PRAS1 volatile.Register32 // 0x88
	PRBS1 volatile.Register32 // 0x8C
	PRAS2 volatile.Register32 // 0x90
	PRBS2 volatile.Register32 // 0x94
	PRAS3 volatile.Register32 // 0x98
	PRBS3 volatile.Register32 // 0x9C
	PRAS4 volatile.Register32 // 0xA0
	PRBS4 volatile.Register32 // 0xA4
	PRAS5 volatile.Register32 // 0xA8
	PRBS5 volatile.Register32 // 0xAC
	PRAS6 volatile.Register32 // 0xB0
	PRBS6 volatile.Register32 // 0xB4
	PRAS7 volatile.Register32 // 0xB8
	PRBS7 volatile.Register32 // 0xBC
	PRAS8 volatile.Register32 // 0xC0
	PRBS8 volatile.Register32 // 0xC4
	PRAS9 volatile.Register32 // 0xC8
	PRBS9 volatile.Register32 // 0xCC
	_     [48]byte
	MRCR  volatile.Register32 // 0x100
	_     [224]byte
	WPMR  volatile.Register32 // 0x1E4
	WPSR  volatile.Register32 // 0x1E8
}

// MATRIX.MCFG: Master Configuration Register
func (o *MATRIX_Type) SetMCFG_ULBT(idx int, value uint32) {
	volatile.StoreUint32(&o.MCFG[idx].Reg, volatile.LoadUint32(&o.MCFG[idx].Reg)&^(0x7)|value)
}
func (o *MATRIX_Type) GetMCFG_ULBT(idx int) uint32 {
	return volatile.LoadUint32(&o.MCFG[idx].Reg) & 0x7
}

// MATRIX.SCFG: Slave Configuration Register
func (o *MATRIX_Type) SetSCFG_SLOT_CYCLE(idx int, value uint32) {
	volatile.StoreUint32(&o.SCFG[idx].Reg, volatile.LoadUint32(&o.SCFG[idx].Reg)&^(0x1ff)|value)
}
func (o *MATRIX_Type) GetSCFG_SLOT_CYCLE(idx int) uint32 {
	return volatile.LoadUint32(&o.SCFG[idx].Reg) & 0x1ff
}
func (o *MATRIX_Type) SetSCFG_DEFMSTR_TYPE(idx int, value uint32) {
	volatile.StoreUint32(&o.SCFG[idx].Reg, volatile.LoadUint32(&o.SCFG[idx].Reg)&^(0x30000)|value<<16)
}
func (o *MATRIX_Type) GetSCFG_DEFMSTR_TYPE(idx int) uint32 {
	return (volatile.LoadUint32(&o.SCFG[idx].Reg) & 0x30000) >> 16
}
func (o *MATRIX_Type) SetSCFG_FIXED_DEFMSTR(idx int, value uint32) {
	volatile.StoreUint32(&o.SCFG[idx].Reg, volatile.LoadUint32(&o.SCFG[idx].Reg)&^(0x3c0000)|value<<18)
}
func (o *MATRIX_Type) GetSCFG_FIXED_DEFMSTR(idx int) uint32 {
	return (volatile.LoadUint32(&o.SCFG[idx].Reg) & 0x3c0000) >> 18
}

// MATRIX.PRAS0: Priority Register A for Slave 0
func (o *MATRIX_Type) SetPRAS0_M0PR(value uint32) {
	volatile.StoreUint32(&o.PRAS0.Reg, volatile.LoadUint32(&o.PRAS0.Reg)&^(0x3)|value)
}
func (o *MATRIX_Type) GetPRAS0_M0PR() uint32 {
	return volatile.LoadUint32(&o.PRAS0.Reg) & 0x3
}
func (o *MATRIX_Type) SetPRAS0_M1PR(value uint32) {
	volatile.StoreUint32(&o.PRAS0.Reg, volatile.LoadUint32(&o.PRAS0.Reg)&^(0x30)|value<<4)
}
func (o *MATRIX_Type) GetPRAS0_M1PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS0.Reg) & 0x30) >> 4
}
func (o *MATRIX_Type) SetPRAS0_M2PR(value uint32) {
	volatile.StoreUint32(&o.PRAS0.Reg, volatile.LoadUint32(&o.PRAS0.Reg)&^(0x300)|value<<8)
}
func (o *MATRIX_Type) GetPRAS0_M2PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS0.Reg) & 0x300) >> 8
}
func (o *MATRIX_Type) SetPRAS0_M3PR(value uint32) {
	volatile.StoreUint32(&o.PRAS0.Reg, volatile.LoadUint32(&o.PRAS0.Reg)&^(0x3000)|value<<12)
}
func (o *MATRIX_Type) GetPRAS0_M3PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS0.Reg) & 0x3000) >> 12
}
func (o *MATRIX_Type) SetPRAS0_M4PR(value uint32) {
	volatile.StoreUint32(&o.PRAS0.Reg, volatile.LoadUint32(&o.PRAS0.Reg)&^(0x30000)|value<<16)
}
func (o *MATRIX_Type) GetPRAS0_M4PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS0.Reg) & 0x30000) >> 16
}
func (o *MATRIX_Type) SetPRAS0_M5PR(value uint32) {
	volatile.StoreUint32(&o.PRAS0.Reg, volatile.LoadUint32(&o.PRAS0.Reg)&^(0x300000)|value<<20)
}
func (o *MATRIX_Type) GetPRAS0_M5PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS0.Reg) & 0x300000) >> 20
}
func (o *MATRIX_Type) SetPRAS0_M6PR(value uint32) {
	volatile.StoreUint32(&o.PRAS0.Reg, volatile.LoadUint32(&o.PRAS0.Reg)&^(0x3000000)|value<<24)
}
func (o *MATRIX_Type) GetPRAS0_M6PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS0.Reg) & 0x3000000) >> 24
}
func (o *MATRIX_Type) SetPRAS0_M7PR(value uint32) {
	volatile.StoreUint32(&o.PRAS0.Reg, volatile.LoadUint32(&o.PRAS0.Reg)&^(0x30000000)|value<<28)
}
func (o *MATRIX_Type) GetPRAS0_M7PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS0.Reg) & 0x30000000) >> 28
}

// MATRIX.PRBS0: Priority Register B for Slave 0
func (o *MATRIX_Type) SetPRBS0_M8PR(value uint32) {
	volatile.StoreUint32(&o.PRBS0.Reg, volatile.LoadUint32(&o.PRBS0.Reg)&^(0x3)|value)
}
func (o *MATRIX_Type) GetPRBS0_M8PR() uint32 {
	return volatile.LoadUint32(&o.PRBS0.Reg) & 0x3
}
func (o *MATRIX_Type) SetPRBS0_M9PR(value uint32) {
	volatile.StoreUint32(&o.PRBS0.Reg, volatile.LoadUint32(&o.PRBS0.Reg)&^(0x30)|value<<4)
}
func (o *MATRIX_Type) GetPRBS0_M9PR() uint32 {
	return (volatile.LoadUint32(&o.PRBS0.Reg) & 0x30) >> 4
}
func (o *MATRIX_Type) SetPRBS0_M10PR(value uint32) {
	volatile.StoreUint32(&o.PRBS0.Reg, volatile.LoadUint32(&o.PRBS0.Reg)&^(0x300)|value<<8)
}
func (o *MATRIX_Type) GetPRBS0_M10PR() uint32 {
	return (volatile.LoadUint32(&o.PRBS0.Reg) & 0x300) >> 8
}

// MATRIX.PRAS1: Priority Register A for Slave 1
func (o *MATRIX_Type) SetPRAS1_M0PR(value uint32) {
	volatile.StoreUint32(&o.PRAS1.Reg, volatile.LoadUint32(&o.PRAS1.Reg)&^(0x3)|value)
}
func (o *MATRIX_Type) GetPRAS1_M0PR() uint32 {
	return volatile.LoadUint32(&o.PRAS1.Reg) & 0x3
}
func (o *MATRIX_Type) SetPRAS1_M1PR(value uint32) {
	volatile.StoreUint32(&o.PRAS1.Reg, volatile.LoadUint32(&o.PRAS1.Reg)&^(0x30)|value<<4)
}
func (o *MATRIX_Type) GetPRAS1_M1PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS1.Reg) & 0x30) >> 4
}
func (o *MATRIX_Type) SetPRAS1_M2PR(value uint32) {
	volatile.StoreUint32(&o.PRAS1.Reg, volatile.LoadUint32(&o.PRAS1.Reg)&^(0x300)|value<<8)
}
func (o *MATRIX_Type) GetPRAS1_M2PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS1.Reg) & 0x300) >> 8
}
func (o *MATRIX_Type) SetPRAS1_M3PR(value uint32) {
	volatile.StoreUint32(&o.PRAS1.Reg, volatile.LoadUint32(&o.PRAS1.Reg)&^(0x3000)|value<<12)
}
func (o *MATRIX_Type) GetPRAS1_M3PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS1.Reg) & 0x3000) >> 12
}
func (o *MATRIX_Type) SetPRAS1_M4PR(value uint32) {
	volatile.StoreUint32(&o.PRAS1.Reg, volatile.LoadUint32(&o.PRAS1.Reg)&^(0x30000)|value<<16)
}
func (o *MATRIX_Type) GetPRAS1_M4PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS1.Reg) & 0x30000) >> 16
}
func (o *MATRIX_Type) SetPRAS1_M5PR(value uint32) {
	volatile.StoreUint32(&o.PRAS1.Reg, volatile.LoadUint32(&o.PRAS1.Reg)&^(0x300000)|value<<20)
}
func (o *MATRIX_Type) GetPRAS1_M5PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS1.Reg) & 0x300000) >> 20
}
func (o *MATRIX_Type) SetPRAS1_M6PR(value uint32) {
	volatile.StoreUint32(&o.PRAS1.Reg, volatile.LoadUint32(&o.PRAS1.Reg)&^(0x3000000)|value<<24)
}
func (o *MATRIX_Type) GetPRAS1_M6PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS1.Reg) & 0x3000000) >> 24
}
func (o *MATRIX_Type) SetPRAS1_M7PR(value uint32) {
	volatile.StoreUint32(&o.PRAS1.Reg, volatile.LoadUint32(&o.PRAS1.Reg)&^(0x30000000)|value<<28)
}
func (o *MATRIX_Type) GetPRAS1_M7PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS1.Reg) & 0x30000000) >> 28
}

// MATRIX.PRBS1: Priority Register B for Slave 1
func (o *MATRIX_Type) SetPRBS1_M8PR(value uint32) {
	volatile.StoreUint32(&o.PRBS1.Reg, volatile.LoadUint32(&o.PRBS1.Reg)&^(0x3)|value)
}
func (o *MATRIX_Type) GetPRBS1_M8PR() uint32 {
	return volatile.LoadUint32(&o.PRBS1.Reg) & 0x3
}
func (o *MATRIX_Type) SetPRBS1_M9PR(value uint32) {
	volatile.StoreUint32(&o.PRBS1.Reg, volatile.LoadUint32(&o.PRBS1.Reg)&^(0x30)|value<<4)
}
func (o *MATRIX_Type) GetPRBS1_M9PR() uint32 {
	return (volatile.LoadUint32(&o.PRBS1.Reg) & 0x30) >> 4
}
func (o *MATRIX_Type) SetPRBS1_M10PR(value uint32) {
	volatile.StoreUint32(&o.PRBS1.Reg, volatile.LoadUint32(&o.PRBS1.Reg)&^(0x300)|value<<8)
}
func (o *MATRIX_Type) GetPRBS1_M10PR() uint32 {
	return (volatile.LoadUint32(&o.PRBS1.Reg) & 0x300) >> 8
}

// MATRIX.PRAS2: Priority Register A for Slave 2
func (o *MATRIX_Type) SetPRAS2_M0PR(value uint32) {
	volatile.StoreUint32(&o.PRAS2.Reg, volatile.LoadUint32(&o.PRAS2.Reg)&^(0x3)|value)
}
func (o *MATRIX_Type) GetPRAS2_M0PR() uint32 {
	return volatile.LoadUint32(&o.PRAS2.Reg) & 0x3
}
func (o *MATRIX_Type) SetPRAS2_M1PR(value uint32) {
	volatile.StoreUint32(&o.PRAS2.Reg, volatile.LoadUint32(&o.PRAS2.Reg)&^(0x30)|value<<4)
}
func (o *MATRIX_Type) GetPRAS2_M1PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS2.Reg) & 0x30) >> 4
}
func (o *MATRIX_Type) SetPRAS2_M2PR(value uint32) {
	volatile.StoreUint32(&o.PRAS2.Reg, volatile.LoadUint32(&o.PRAS2.Reg)&^(0x300)|value<<8)
}
func (o *MATRIX_Type) GetPRAS2_M2PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS2.Reg) & 0x300) >> 8
}
func (o *MATRIX_Type) SetPRAS2_M3PR(value uint32) {
	volatile.StoreUint32(&o.PRAS2.Reg, volatile.LoadUint32(&o.PRAS2.Reg)&^(0x3000)|value<<12)
}
func (o *MATRIX_Type) GetPRAS2_M3PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS2.Reg) & 0x3000) >> 12
}
func (o *MATRIX_Type) SetPRAS2_M4PR(value uint32) {
	volatile.StoreUint32(&o.PRAS2.Reg, volatile.LoadUint32(&o.PRAS2.Reg)&^(0x30000)|value<<16)
}
func (o *MATRIX_Type) GetPRAS2_M4PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS2.Reg) & 0x30000) >> 16
}
func (o *MATRIX_Type) SetPRAS2_M5PR(value uint32) {
	volatile.StoreUint32(&o.PRAS2.Reg, volatile.LoadUint32(&o.PRAS2.Reg)&^(0x300000)|value<<20)
}
func (o *MATRIX_Type) GetPRAS2_M5PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS2.Reg) & 0x300000) >> 20
}
func (o *MATRIX_Type) SetPRAS2_M6PR(value uint32) {
	volatile.StoreUint32(&o.PRAS2.Reg, volatile.LoadUint32(&o.PRAS2.Reg)&^(0x3000000)|value<<24)
}
func (o *MATRIX_Type) GetPRAS2_M6PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS2.Reg) & 0x3000000) >> 24
}
func (o *MATRIX_Type) SetPRAS2_M7PR(value uint32) {
	volatile.StoreUint32(&o.PRAS2.Reg, volatile.LoadUint32(&o.PRAS2.Reg)&^(0x30000000)|value<<28)
}
func (o *MATRIX_Type) GetPRAS2_M7PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS2.Reg) & 0x30000000) >> 28
}

// MATRIX.PRBS2: Priority Register B for Slave 2
func (o *MATRIX_Type) SetPRBS2_M8PR(value uint32) {
	volatile.StoreUint32(&o.PRBS2.Reg, volatile.LoadUint32(&o.PRBS2.Reg)&^(0x3)|value)
}
func (o *MATRIX_Type) GetPRBS2_M8PR() uint32 {
	return volatile.LoadUint32(&o.PRBS2.Reg) & 0x3
}
func (o *MATRIX_Type) SetPRBS2_M9PR(value uint32) {
	volatile.StoreUint32(&o.PRBS2.Reg, volatile.LoadUint32(&o.PRBS2.Reg)&^(0x30)|value<<4)
}
func (o *MATRIX_Type) GetPRBS2_M9PR() uint32 {
	return (volatile.LoadUint32(&o.PRBS2.Reg) & 0x30) >> 4
}
func (o *MATRIX_Type) SetPRBS2_M10PR(value uint32) {
	volatile.StoreUint32(&o.PRBS2.Reg, volatile.LoadUint32(&o.PRBS2.Reg)&^(0x300)|value<<8)
}
func (o *MATRIX_Type) GetPRBS2_M10PR() uint32 {
	return (volatile.LoadUint32(&o.PRBS2.Reg) & 0x300) >> 8
}

// MATRIX.PRAS3: Priority Register A for Slave 3
func (o *MATRIX_Type) SetPRAS3_M0PR(value uint32) {
	volatile.StoreUint32(&o.PRAS3.Reg, volatile.LoadUint32(&o.PRAS3.Reg)&^(0x3)|value)
}
func (o *MATRIX_Type) GetPRAS3_M0PR() uint32 {
	return volatile.LoadUint32(&o.PRAS3.Reg) & 0x3
}
func (o *MATRIX_Type) SetPRAS3_M1PR(value uint32) {
	volatile.StoreUint32(&o.PRAS3.Reg, volatile.LoadUint32(&o.PRAS3.Reg)&^(0x30)|value<<4)
}
func (o *MATRIX_Type) GetPRAS3_M1PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS3.Reg) & 0x30) >> 4
}
func (o *MATRIX_Type) SetPRAS3_M2PR(value uint32) {
	volatile.StoreUint32(&o.PRAS3.Reg, volatile.LoadUint32(&o.PRAS3.Reg)&^(0x300)|value<<8)
}
func (o *MATRIX_Type) GetPRAS3_M2PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS3.Reg) & 0x300) >> 8
}
func (o *MATRIX_Type) SetPRAS3_M3PR(value uint32) {
	volatile.StoreUint32(&o.PRAS3.Reg, volatile.LoadUint32(&o.PRAS3.Reg)&^(0x3000)|value<<12)
}
func (o *MATRIX_Type) GetPRAS3_M3PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS3.Reg) & 0x3000) >> 12
}
func (o *MATRIX_Type) SetPRAS3_M4PR(value uint32) {
	volatile.StoreUint32(&o.PRAS3.Reg, volatile.LoadUint32(&o.PRAS3.Reg)&^(0x30000)|value<<16)
}
func (o *MATRIX_Type) GetPRAS3_M4PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS3.Reg) & 0x30000) >> 16
}
func (o *MATRIX_Type) SetPRAS3_M5PR(value uint32) {
	volatile.StoreUint32(&o.PRAS3.Reg, volatile.LoadUint32(&o.PRAS3.Reg)&^(0x300000)|value<<20)
}
func (o *MATRIX_Type) GetPRAS3_M5PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS3.Reg) & 0x300000) >> 20
}
func (o *MATRIX_Type) SetPRAS3_M6PR(value uint32) {
	volatile.StoreUint32(&o.PRAS3.Reg, volatile.LoadUint32(&o.PRAS3.Reg)&^(0x3000000)|value<<24)
}
func (o *MATRIX_Type) GetPRAS3_M6PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS3.Reg) & 0x3000000) >> 24
}
func (o *MATRIX_Type) SetPRAS3_M7PR(value uint32) {
	volatile.StoreUint32(&o.PRAS3.Reg, volatile.LoadUint32(&o.PRAS3.Reg)&^(0x30000000)|value<<28)
}
func (o *MATRIX_Type) GetPRAS3_M7PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS3.Reg) & 0x30000000) >> 28
}

// MATRIX.PRBS3: Priority Register B for Slave 3
func (o *MATRIX_Type) SetPRBS3_M8PR(value uint32) {
	volatile.StoreUint32(&o.PRBS3.Reg, volatile.LoadUint32(&o.PRBS3.Reg)&^(0x3)|value)
}
func (o *MATRIX_Type) GetPRBS3_M8PR() uint32 {
	return volatile.LoadUint32(&o.PRBS3.Reg) & 0x3
}
func (o *MATRIX_Type) SetPRBS3_M9PR(value uint32) {
	volatile.StoreUint32(&o.PRBS3.Reg, volatile.LoadUint32(&o.PRBS3.Reg)&^(0x30)|value<<4)
}
func (o *MATRIX_Type) GetPRBS3_M9PR() uint32 {
	return (volatile.LoadUint32(&o.PRBS3.Reg) & 0x30) >> 4
}
func (o *MATRIX_Type) SetPRBS3_M10PR(value uint32) {
	volatile.StoreUint32(&o.PRBS3.Reg, volatile.LoadUint32(&o.PRBS3.Reg)&^(0x300)|value<<8)
}
func (o *MATRIX_Type) GetPRBS3_M10PR() uint32 {
	return (volatile.LoadUint32(&o.PRBS3.Reg) & 0x300) >> 8
}

// MATRIX.PRAS4: Priority Register A for Slave 4
func (o *MATRIX_Type) SetPRAS4_M0PR(value uint32) {
	volatile.StoreUint32(&o.PRAS4.Reg, volatile.LoadUint32(&o.PRAS4.Reg)&^(0x3)|value)
}
func (o *MATRIX_Type) GetPRAS4_M0PR() uint32 {
	return volatile.LoadUint32(&o.PRAS4.Reg) & 0x3
}
func (o *MATRIX_Type) SetPRAS4_M1PR(value uint32) {
	volatile.StoreUint32(&o.PRAS4.Reg, volatile.LoadUint32(&o.PRAS4.Reg)&^(0x30)|value<<4)
}
func (o *MATRIX_Type) GetPRAS4_M1PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS4.Reg) & 0x30) >> 4
}
func (o *MATRIX_Type) SetPRAS4_M2PR(value uint32) {
	volatile.StoreUint32(&o.PRAS4.Reg, volatile.LoadUint32(&o.PRAS4.Reg)&^(0x300)|value<<8)
}
func (o *MATRIX_Type) GetPRAS4_M2PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS4.Reg) & 0x300) >> 8
}
func (o *MATRIX_Type) SetPRAS4_M3PR(value uint32) {
	volatile.StoreUint32(&o.PRAS4.Reg, volatile.LoadUint32(&o.PRAS4.Reg)&^(0x3000)|value<<12)
}
func (o *MATRIX_Type) GetPRAS4_M3PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS4.Reg) & 0x3000) >> 12
}
func (o *MATRIX_Type) SetPRAS4_M4PR(value uint32) {
	volatile.StoreUint32(&o.PRAS4.Reg, volatile.LoadUint32(&o.PRAS4.Reg)&^(0x30000)|value<<16)
}
func (o *MATRIX_Type) GetPRAS4_M4PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS4.Reg) & 0x30000) >> 16
}
func (o *MATRIX_Type) SetPRAS4_M5PR(value uint32) {
	volatile.StoreUint32(&o.PRAS4.Reg, volatile.LoadUint32(&o.PRAS4.Reg)&^(0x300000)|value<<20)
}
func (o *MATRIX_Type) GetPRAS4_M5PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS4.Reg) & 0x300000) >> 20
}
func (o *MATRIX_Type) SetPRAS4_M6PR(value uint32) {
	volatile.StoreUint32(&o.PRAS4.Reg, volatile.LoadUint32(&o.PRAS4.Reg)&^(0x3000000)|value<<24)
}
func (o *MATRIX_Type) GetPRAS4_M6PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS4.Reg) & 0x3000000) >> 24
}
func (o *MATRIX_Type) SetPRAS4_M7PR(value uint32) {
	volatile.StoreUint32(&o.PRAS4.Reg, volatile.LoadUint32(&o.PRAS4.Reg)&^(0x30000000)|value<<28)
}
func (o *MATRIX_Type) GetPRAS4_M7PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS4.Reg) & 0x30000000) >> 28
}

// MATRIX.PRBS4: Priority Register B for Slave 4
func (o *MATRIX_Type) SetPRBS4_M8PR(value uint32) {
	volatile.StoreUint32(&o.PRBS4.Reg, volatile.LoadUint32(&o.PRBS4.Reg)&^(0x3)|value)
}
func (o *MATRIX_Type) GetPRBS4_M8PR() uint32 {
	return volatile.LoadUint32(&o.PRBS4.Reg) & 0x3
}
func (o *MATRIX_Type) SetPRBS4_M9PR(value uint32) {
	volatile.StoreUint32(&o.PRBS4.Reg, volatile.LoadUint32(&o.PRBS4.Reg)&^(0x30)|value<<4)
}
func (o *MATRIX_Type) GetPRBS4_M9PR() uint32 {
	return (volatile.LoadUint32(&o.PRBS4.Reg) & 0x30) >> 4
}
func (o *MATRIX_Type) SetPRBS4_M10PR(value uint32) {
	volatile.StoreUint32(&o.PRBS4.Reg, volatile.LoadUint32(&o.PRBS4.Reg)&^(0x300)|value<<8)
}
func (o *MATRIX_Type) GetPRBS4_M10PR() uint32 {
	return (volatile.LoadUint32(&o.PRBS4.Reg) & 0x300) >> 8
}

// MATRIX.PRAS5: Priority Register A for Slave 5
func (o *MATRIX_Type) SetPRAS5_M0PR(value uint32) {
	volatile.StoreUint32(&o.PRAS5.Reg, volatile.LoadUint32(&o.PRAS5.Reg)&^(0x3)|value)
}
func (o *MATRIX_Type) GetPRAS5_M0PR() uint32 {
	return volatile.LoadUint32(&o.PRAS5.Reg) & 0x3
}
func (o *MATRIX_Type) SetPRAS5_M1PR(value uint32) {
	volatile.StoreUint32(&o.PRAS5.Reg, volatile.LoadUint32(&o.PRAS5.Reg)&^(0x30)|value<<4)
}
func (o *MATRIX_Type) GetPRAS5_M1PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS5.Reg) & 0x30) >> 4
}
func (o *MATRIX_Type) SetPRAS5_M2PR(value uint32) {
	volatile.StoreUint32(&o.PRAS5.Reg, volatile.LoadUint32(&o.PRAS5.Reg)&^(0x300)|value<<8)
}
func (o *MATRIX_Type) GetPRAS5_M2PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS5.Reg) & 0x300) >> 8
}
func (o *MATRIX_Type) SetPRAS5_M3PR(value uint32) {
	volatile.StoreUint32(&o.PRAS5.Reg, volatile.LoadUint32(&o.PRAS5.Reg)&^(0x3000)|value<<12)
}
func (o *MATRIX_Type) GetPRAS5_M3PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS5.Reg) & 0x3000) >> 12
}
func (o *MATRIX_Type) SetPRAS5_M4PR(value uint32) {
	volatile.StoreUint32(&o.PRAS5.Reg, volatile.LoadUint32(&o.PRAS5.Reg)&^(0x30000)|value<<16)
}
func (o *MATRIX_Type) GetPRAS5_M4PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS5.Reg) & 0x30000) >> 16
}
func (o *MATRIX_Type) SetPRAS5_M5PR(value uint32) {
	volatile.StoreUint32(&o.PRAS5.Reg, volatile.LoadUint32(&o.PRAS5.Reg)&^(0x300000)|value<<20)
}
func (o *MATRIX_Type) GetPRAS5_M5PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS5.Reg) & 0x300000) >> 20
}
func (o *MATRIX_Type) SetPRAS5_M6PR(value uint32) {
	volatile.StoreUint32(&o.PRAS5.Reg, volatile.LoadUint32(&o.PRAS5.Reg)&^(0x3000000)|value<<24)
}
func (o *MATRIX_Type) GetPRAS5_M6PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS5.Reg) & 0x3000000) >> 24
}
func (o *MATRIX_Type) SetPRAS5_M7PR(value uint32) {
	volatile.StoreUint32(&o.PRAS5.Reg, volatile.LoadUint32(&o.PRAS5.Reg)&^(0x30000000)|value<<28)
}
func (o *MATRIX_Type) GetPRAS5_M7PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS5.Reg) & 0x30000000) >> 28
}

// MATRIX.PRBS5: Priority Register B for Slave 5
func (o *MATRIX_Type) SetPRBS5_M8PR(value uint32) {
	volatile.StoreUint32(&o.PRBS5.Reg, volatile.LoadUint32(&o.PRBS5.Reg)&^(0x3)|value)
}
func (o *MATRIX_Type) GetPRBS5_M8PR() uint32 {
	return volatile.LoadUint32(&o.PRBS5.Reg) & 0x3
}
func (o *MATRIX_Type) SetPRBS5_M9PR(value uint32) {
	volatile.StoreUint32(&o.PRBS5.Reg, volatile.LoadUint32(&o.PRBS5.Reg)&^(0x30)|value<<4)
}
func (o *MATRIX_Type) GetPRBS5_M9PR() uint32 {
	return (volatile.LoadUint32(&o.PRBS5.Reg) & 0x30) >> 4
}
func (o *MATRIX_Type) SetPRBS5_M10PR(value uint32) {
	volatile.StoreUint32(&o.PRBS5.Reg, volatile.LoadUint32(&o.PRBS5.Reg)&^(0x300)|value<<8)
}
func (o *MATRIX_Type) GetPRBS5_M10PR() uint32 {
	return (volatile.LoadUint32(&o.PRBS5.Reg) & 0x300) >> 8
}

// MATRIX.PRAS6: Priority Register A for Slave 6
func (o *MATRIX_Type) SetPRAS6_M0PR(value uint32) {
	volatile.StoreUint32(&o.PRAS6.Reg, volatile.LoadUint32(&o.PRAS6.Reg)&^(0x3)|value)
}
func (o *MATRIX_Type) GetPRAS6_M0PR() uint32 {
	return volatile.LoadUint32(&o.PRAS6.Reg) & 0x3
}
func (o *MATRIX_Type) SetPRAS6_M1PR(value uint32) {
	volatile.StoreUint32(&o.PRAS6.Reg, volatile.LoadUint32(&o.PRAS6.Reg)&^(0x30)|value<<4)
}
func (o *MATRIX_Type) GetPRAS6_M1PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS6.Reg) & 0x30) >> 4
}
func (o *MATRIX_Type) SetPRAS6_M2PR(value uint32) {
	volatile.StoreUint32(&o.PRAS6.Reg, volatile.LoadUint32(&o.PRAS6.Reg)&^(0x300)|value<<8)
}
func (o *MATRIX_Type) GetPRAS6_M2PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS6.Reg) & 0x300) >> 8
}
func (o *MATRIX_Type) SetPRAS6_M3PR(value uint32) {
	volatile.StoreUint32(&o.PRAS6.Reg, volatile.LoadUint32(&o.PRAS6.Reg)&^(0x3000)|value<<12)
}
func (o *MATRIX_Type) GetPRAS6_M3PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS6.Reg) & 0x3000) >> 12
}
func (o *MATRIX_Type) SetPRAS6_M4PR(value uint32) {
	volatile.StoreUint32(&o.PRAS6.Reg, volatile.LoadUint32(&o.PRAS6.Reg)&^(0x30000)|value<<16)
}
func (o *MATRIX_Type) GetPRAS6_M4PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS6.Reg) & 0x30000) >> 16
}
func (o *MATRIX_Type) SetPRAS6_M5PR(value uint32) {
	volatile.StoreUint32(&o.PRAS6.Reg, volatile.LoadUint32(&o.PRAS6.Reg)&^(0x300000)|value<<20)
}
func (o *MATRIX_Type) GetPRAS6_M5PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS6.Reg) & 0x300000) >> 20
}
func (o *MATRIX_Type) SetPRAS6_M6PR(value uint32) {
	volatile.StoreUint32(&o.PRAS6.Reg, volatile.LoadUint32(&o.PRAS6.Reg)&^(0x3000000)|value<<24)
}
func (o *MATRIX_Type) GetPRAS6_M6PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS6.Reg) & 0x3000000) >> 24
}
func (o *MATRIX_Type) SetPRAS6_M7PR(value uint32) {
	volatile.StoreUint32(&o.PRAS6.Reg, volatile.LoadUint32(&o.PRAS6.Reg)&^(0x30000000)|value<<28)
}
func (o *MATRIX_Type) GetPRAS6_M7PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS6.Reg) & 0x30000000) >> 28
}

// MATRIX.PRBS6: Priority Register B for Slave 6
func (o *MATRIX_Type) SetPRBS6_M8PR(value uint32) {
	volatile.StoreUint32(&o.PRBS6.Reg, volatile.LoadUint32(&o.PRBS6.Reg)&^(0x3)|value)
}
func (o *MATRIX_Type) GetPRBS6_M8PR() uint32 {
	return volatile.LoadUint32(&o.PRBS6.Reg) & 0x3
}
func (o *MATRIX_Type) SetPRBS6_M9PR(value uint32) {
	volatile.StoreUint32(&o.PRBS6.Reg, volatile.LoadUint32(&o.PRBS6.Reg)&^(0x30)|value<<4)
}
func (o *MATRIX_Type) GetPRBS6_M9PR() uint32 {
	return (volatile.LoadUint32(&o.PRBS6.Reg) & 0x30) >> 4
}
func (o *MATRIX_Type) SetPRBS6_M10PR(value uint32) {
	volatile.StoreUint32(&o.PRBS6.Reg, volatile.LoadUint32(&o.PRBS6.Reg)&^(0x300)|value<<8)
}
func (o *MATRIX_Type) GetPRBS6_M10PR() uint32 {
	return (volatile.LoadUint32(&o.PRBS6.Reg) & 0x300) >> 8
}

// MATRIX.PRAS7: Priority Register A for Slave 7
func (o *MATRIX_Type) SetPRAS7_M0PR(value uint32) {
	volatile.StoreUint32(&o.PRAS7.Reg, volatile.LoadUint32(&o.PRAS7.Reg)&^(0x3)|value)
}
func (o *MATRIX_Type) GetPRAS7_M0PR() uint32 {
	return volatile.LoadUint32(&o.PRAS7.Reg) & 0x3
}
func (o *MATRIX_Type) SetPRAS7_M1PR(value uint32) {
	volatile.StoreUint32(&o.PRAS7.Reg, volatile.LoadUint32(&o.PRAS7.Reg)&^(0x30)|value<<4)
}
func (o *MATRIX_Type) GetPRAS7_M1PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS7.Reg) & 0x30) >> 4
}
func (o *MATRIX_Type) SetPRAS7_M2PR(value uint32) {
	volatile.StoreUint32(&o.PRAS7.Reg, volatile.LoadUint32(&o.PRAS7.Reg)&^(0x300)|value<<8)
}
func (o *MATRIX_Type) GetPRAS7_M2PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS7.Reg) & 0x300) >> 8
}
func (o *MATRIX_Type) SetPRAS7_M3PR(value uint32) {
	volatile.StoreUint32(&o.PRAS7.Reg, volatile.LoadUint32(&o.PRAS7.Reg)&^(0x3000)|value<<12)
}
func (o *MATRIX_Type) GetPRAS7_M3PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS7.Reg) & 0x3000) >> 12
}
func (o *MATRIX_Type) SetPRAS7_M4PR(value uint32) {
	volatile.StoreUint32(&o.PRAS7.Reg, volatile.LoadUint32(&o.PRAS7.Reg)&^(0x30000)|value<<16)
}
func (o *MATRIX_Type) GetPRAS7_M4PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS7.Reg) & 0x30000) >> 16
}
func (o *MATRIX_Type) SetPRAS7_M5PR(value uint32) {
	volatile.StoreUint32(&o.PRAS7.Reg, volatile.LoadUint32(&o.PRAS7.Reg)&^(0x300000)|value<<20)
}
func (o *MATRIX_Type) GetPRAS7_M5PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS7.Reg) & 0x300000) >> 20
}
func (o *MATRIX_Type) SetPRAS7_M6PR(value uint32) {
	volatile.StoreUint32(&o.PRAS7.Reg, volatile.LoadUint32(&o.PRAS7.Reg)&^(0x3000000)|value<<24)
}
func (o *MATRIX_Type) GetPRAS7_M6PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS7.Reg) & 0x3000000) >> 24
}
func (o *MATRIX_Type) SetPRAS7_M7PR(value uint32) {
	volatile.StoreUint32(&o.PRAS7.Reg, volatile.LoadUint32(&o.PRAS7.Reg)&^(0x30000000)|value<<28)
}
func (o *MATRIX_Type) GetPRAS7_M7PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS7.Reg) & 0x30000000) >> 28
}

// MATRIX.PRBS7: Priority Register B for Slave 7
func (o *MATRIX_Type) SetPRBS7_M8PR(value uint32) {
	volatile.StoreUint32(&o.PRBS7.Reg, volatile.LoadUint32(&o.PRBS7.Reg)&^(0x3)|value)
}
func (o *MATRIX_Type) GetPRBS7_M8PR() uint32 {
	return volatile.LoadUint32(&o.PRBS7.Reg) & 0x3
}
func (o *MATRIX_Type) SetPRBS7_M9PR(value uint32) {
	volatile.StoreUint32(&o.PRBS7.Reg, volatile.LoadUint32(&o.PRBS7.Reg)&^(0x30)|value<<4)
}
func (o *MATRIX_Type) GetPRBS7_M9PR() uint32 {
	return (volatile.LoadUint32(&o.PRBS7.Reg) & 0x30) >> 4
}
func (o *MATRIX_Type) SetPRBS7_M10PR(value uint32) {
	volatile.StoreUint32(&o.PRBS7.Reg, volatile.LoadUint32(&o.PRBS7.Reg)&^(0x300)|value<<8)
}
func (o *MATRIX_Type) GetPRBS7_M10PR() uint32 {
	return (volatile.LoadUint32(&o.PRBS7.Reg) & 0x300) >> 8
}

// MATRIX.PRAS8: Priority Register A for Slave 8
func (o *MATRIX_Type) SetPRAS8_M0PR(value uint32) {
	volatile.StoreUint32(&o.PRAS8.Reg, volatile.LoadUint32(&o.PRAS8.Reg)&^(0x3)|value)
}
func (o *MATRIX_Type) GetPRAS8_M0PR() uint32 {
	return volatile.LoadUint32(&o.PRAS8.Reg) & 0x3
}
func (o *MATRIX_Type) SetPRAS8_M1PR(value uint32) {
	volatile.StoreUint32(&o.PRAS8.Reg, volatile.LoadUint32(&o.PRAS8.Reg)&^(0x30)|value<<4)
}
func (o *MATRIX_Type) GetPRAS8_M1PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS8.Reg) & 0x30) >> 4
}
func (o *MATRIX_Type) SetPRAS8_M2PR(value uint32) {
	volatile.StoreUint32(&o.PRAS8.Reg, volatile.LoadUint32(&o.PRAS8.Reg)&^(0x300)|value<<8)
}
func (o *MATRIX_Type) GetPRAS8_M2PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS8.Reg) & 0x300) >> 8
}
func (o *MATRIX_Type) SetPRAS8_M3PR(value uint32) {
	volatile.StoreUint32(&o.PRAS8.Reg, volatile.LoadUint32(&o.PRAS8.Reg)&^(0x3000)|value<<12)
}
func (o *MATRIX_Type) GetPRAS8_M3PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS8.Reg) & 0x3000) >> 12
}
func (o *MATRIX_Type) SetPRAS8_M4PR(value uint32) {
	volatile.StoreUint32(&o.PRAS8.Reg, volatile.LoadUint32(&o.PRAS8.Reg)&^(0x30000)|value<<16)
}
func (o *MATRIX_Type) GetPRAS8_M4PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS8.Reg) & 0x30000) >> 16
}
func (o *MATRIX_Type) SetPRAS8_M5PR(value uint32) {
	volatile.StoreUint32(&o.PRAS8.Reg, volatile.LoadUint32(&o.PRAS8.Reg)&^(0x300000)|value<<20)
}
func (o *MATRIX_Type) GetPRAS8_M5PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS8.Reg) & 0x300000) >> 20
}
func (o *MATRIX_Type) SetPRAS8_M6PR(value uint32) {
	volatile.StoreUint32(&o.PRAS8.Reg, volatile.LoadUint32(&o.PRAS8.Reg)&^(0x3000000)|value<<24)
}
func (o *MATRIX_Type) GetPRAS8_M6PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS8.Reg) & 0x3000000) >> 24
}
func (o *MATRIX_Type) SetPRAS8_M7PR(value uint32) {
	volatile.StoreUint32(&o.PRAS8.Reg, volatile.LoadUint32(&o.PRAS8.Reg)&^(0x30000000)|value<<28)
}
func (o *MATRIX_Type) GetPRAS8_M7PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS8.Reg) & 0x30000000) >> 28
}

// MATRIX.PRBS8: Priority Register B for Slave 8
func (o *MATRIX_Type) SetPRBS8_M8PR(value uint32) {
	volatile.StoreUint32(&o.PRBS8.Reg, volatile.LoadUint32(&o.PRBS8.Reg)&^(0x3)|value)
}
func (o *MATRIX_Type) GetPRBS8_M8PR() uint32 {
	return volatile.LoadUint32(&o.PRBS8.Reg) & 0x3
}
func (o *MATRIX_Type) SetPRBS8_M9PR(value uint32) {
	volatile.StoreUint32(&o.PRBS8.Reg, volatile.LoadUint32(&o.PRBS8.Reg)&^(0x30)|value<<4)
}
func (o *MATRIX_Type) GetPRBS8_M9PR() uint32 {
	return (volatile.LoadUint32(&o.PRBS8.Reg) & 0x30) >> 4
}
func (o *MATRIX_Type) SetPRBS8_M10PR(value uint32) {
	volatile.StoreUint32(&o.PRBS8.Reg, volatile.LoadUint32(&o.PRBS8.Reg)&^(0x300)|value<<8)
}
func (o *MATRIX_Type) GetPRBS8_M10PR() uint32 {
	return (volatile.LoadUint32(&o.PRBS8.Reg) & 0x300) >> 8
}

// MATRIX.PRAS9: Priority Register A for Slave 9
func (o *MATRIX_Type) SetPRAS9_M0PR(value uint32) {
	volatile.StoreUint32(&o.PRAS9.Reg, volatile.LoadUint32(&o.PRAS9.Reg)&^(0x3)|value)
}
func (o *MATRIX_Type) GetPRAS9_M0PR() uint32 {
	return volatile.LoadUint32(&o.PRAS9.Reg) & 0x3
}
func (o *MATRIX_Type) SetPRAS9_M1PR(value uint32) {
	volatile.StoreUint32(&o.PRAS9.Reg, volatile.LoadUint32(&o.PRAS9.Reg)&^(0x30)|value<<4)
}
func (o *MATRIX_Type) GetPRAS9_M1PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS9.Reg) & 0x30) >> 4
}
func (o *MATRIX_Type) SetPRAS9_M2PR(value uint32) {
	volatile.StoreUint32(&o.PRAS9.Reg, volatile.LoadUint32(&o.PRAS9.Reg)&^(0x300)|value<<8)
}
func (o *MATRIX_Type) GetPRAS9_M2PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS9.Reg) & 0x300) >> 8
}
func (o *MATRIX_Type) SetPRAS9_M3PR(value uint32) {
	volatile.StoreUint32(&o.PRAS9.Reg, volatile.LoadUint32(&o.PRAS9.Reg)&^(0x3000)|value<<12)
}
func (o *MATRIX_Type) GetPRAS9_M3PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS9.Reg) & 0x3000) >> 12
}
func (o *MATRIX_Type) SetPRAS9_M4PR(value uint32) {
	volatile.StoreUint32(&o.PRAS9.Reg, volatile.LoadUint32(&o.PRAS9.Reg)&^(0x30000)|value<<16)
}
func (o *MATRIX_Type) GetPRAS9_M4PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS9.Reg) & 0x30000) >> 16
}
func (o *MATRIX_Type) SetPRAS9_M5PR(value uint32) {
	volatile.StoreUint32(&o.PRAS9.Reg, volatile.LoadUint32(&o.PRAS9.Reg)&^(0x300000)|value<<20)
}
func (o *MATRIX_Type) GetPRAS9_M5PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS9.Reg) & 0x300000) >> 20
}
func (o *MATRIX_Type) SetPRAS9_M6PR(value uint32) {
	volatile.StoreUint32(&o.PRAS9.Reg, volatile.LoadUint32(&o.PRAS9.Reg)&^(0x3000000)|value<<24)
}
func (o *MATRIX_Type) GetPRAS9_M6PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS9.Reg) & 0x3000000) >> 24
}
func (o *MATRIX_Type) SetPRAS9_M7PR(value uint32) {
	volatile.StoreUint32(&o.PRAS9.Reg, volatile.LoadUint32(&o.PRAS9.Reg)&^(0x30000000)|value<<28)
}
func (o *MATRIX_Type) GetPRAS9_M7PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS9.Reg) & 0x30000000) >> 28
}

// MATRIX.PRBS9: Priority Register B for Slave 9
func (o *MATRIX_Type) SetPRBS9_M8PR(value uint32) {
	volatile.StoreUint32(&o.PRBS9.Reg, volatile.LoadUint32(&o.PRBS9.Reg)&^(0x3)|value)
}
func (o *MATRIX_Type) GetPRBS9_M8PR() uint32 {
	return volatile.LoadUint32(&o.PRBS9.Reg) & 0x3
}
func (o *MATRIX_Type) SetPRBS9_M9PR(value uint32) {
	volatile.StoreUint32(&o.PRBS9.Reg, volatile.LoadUint32(&o.PRBS9.Reg)&^(0x30)|value<<4)
}
func (o *MATRIX_Type) GetPRBS9_M9PR() uint32 {
	return (volatile.LoadUint32(&o.PRBS9.Reg) & 0x30) >> 4
}
func (o *MATRIX_Type) SetPRBS9_M10PR(value uint32) {
	volatile.StoreUint32(&o.PRBS9.Reg, volatile.LoadUint32(&o.PRBS9.Reg)&^(0x300)|value<<8)
}
func (o *MATRIX_Type) GetPRBS9_M10PR() uint32 {
	return (volatile.LoadUint32(&o.PRBS9.Reg) & 0x300) >> 8
}

// MATRIX.MRCR: Master Remap Control Register
func (o *MATRIX_Type) SetMRCR_RCB0(value uint32) {
	volatile.StoreUint32(&o.MRCR.Reg, volatile.LoadUint32(&o.MRCR.Reg)&^(0x1)|value)
}
func (o *MATRIX_Type) GetMRCR_RCB0() uint32 {
	return volatile.LoadUint32(&o.MRCR.Reg) & 0x1
}
func (o *MATRIX_Type) SetMRCR_RCB1(value uint32) {
	volatile.StoreUint32(&o.MRCR.Reg, volatile.LoadUint32(&o.MRCR.Reg)&^(0x2)|value<<1)
}
func (o *MATRIX_Type) GetMRCR_RCB1() uint32 {
	return (volatile.LoadUint32(&o.MRCR.Reg) & 0x2) >> 1
}
func (o *MATRIX_Type) SetMRCR_RCB2(value uint32) {
	volatile.StoreUint32(&o.MRCR.Reg, volatile.LoadUint32(&o.MRCR.Reg)&^(0x4)|value<<2)
}
func (o *MATRIX_Type) GetMRCR_RCB2() uint32 {
	return (volatile.LoadUint32(&o.MRCR.Reg) & 0x4) >> 2
}
func (o *MATRIX_Type) SetMRCR_RCB3(value uint32) {
	volatile.StoreUint32(&o.MRCR.Reg, volatile.LoadUint32(&o.MRCR.Reg)&^(0x8)|value<<3)
}
func (o *MATRIX_Type) GetMRCR_RCB3() uint32 {
	return (volatile.LoadUint32(&o.MRCR.Reg) & 0x8) >> 3
}
func (o *MATRIX_Type) SetMRCR_RCB4(value uint32) {
	volatile.StoreUint32(&o.MRCR.Reg, volatile.LoadUint32(&o.MRCR.Reg)&^(0x10)|value<<4)
}
func (o *MATRIX_Type) GetMRCR_RCB4() uint32 {
	return (volatile.LoadUint32(&o.MRCR.Reg) & 0x10) >> 4
}
func (o *MATRIX_Type) SetMRCR_RCB5(value uint32) {
	volatile.StoreUint32(&o.MRCR.Reg, volatile.LoadUint32(&o.MRCR.Reg)&^(0x20)|value<<5)
}
func (o *MATRIX_Type) GetMRCR_RCB5() uint32 {
	return (volatile.LoadUint32(&o.MRCR.Reg) & 0x20) >> 5
}
func (o *MATRIX_Type) SetMRCR_RCB6(value uint32) {
	volatile.StoreUint32(&o.MRCR.Reg, volatile.LoadUint32(&o.MRCR.Reg)&^(0x40)|value<<6)
}
func (o *MATRIX_Type) GetMRCR_RCB6() uint32 {
	return (volatile.LoadUint32(&o.MRCR.Reg) & 0x40) >> 6
}
func (o *MATRIX_Type) SetMRCR_RCB7(value uint32) {
	volatile.StoreUint32(&o.MRCR.Reg, volatile.LoadUint32(&o.MRCR.Reg)&^(0x80)|value<<7)
}
func (o *MATRIX_Type) GetMRCR_RCB7() uint32 {
	return (volatile.LoadUint32(&o.MRCR.Reg) & 0x80) >> 7
}
func (o *MATRIX_Type) SetMRCR_RCB8(value uint32) {
	volatile.StoreUint32(&o.MRCR.Reg, volatile.LoadUint32(&o.MRCR.Reg)&^(0x100)|value<<8)
}
func (o *MATRIX_Type) GetMRCR_RCB8() uint32 {
	return (volatile.LoadUint32(&o.MRCR.Reg) & 0x100) >> 8
}
func (o *MATRIX_Type) SetMRCR_RCB9(value uint32) {
	volatile.StoreUint32(&o.MRCR.Reg, volatile.LoadUint32(&o.MRCR.Reg)&^(0x200)|value<<9)
}
func (o *MATRIX_Type) GetMRCR_RCB9() uint32 {
	return (volatile.LoadUint32(&o.MRCR.Reg) & 0x200) >> 9
}
func (o *MATRIX_Type) SetMRCR_RCB10(value uint32) {
	volatile.StoreUint32(&o.MRCR.Reg, volatile.LoadUint32(&o.MRCR.Reg)&^(0x400)|value<<10)
}
func (o *MATRIX_Type) GetMRCR_RCB10() uint32 {
	return (volatile.LoadUint32(&o.MRCR.Reg) & 0x400) >> 10
}

// MATRIX.WPMR: Write Protect Mode Register
func (o *MATRIX_Type) SetWPMR_WPEN(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0x1)|value)
}
func (o *MATRIX_Type) GetWPMR_WPEN() uint32 {
	return volatile.LoadUint32(&o.WPMR.Reg) & 0x1
}
func (o *MATRIX_Type) SetWPMR_WPKEY(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *MATRIX_Type) GetWPMR_WPKEY() uint32 {
	return (volatile.LoadUint32(&o.WPMR.Reg) & 0xffffff00) >> 8
}

// MATRIX.WPSR: Write Protect Status Register
func (o *MATRIX_Type) SetWPSR_WPVS(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x1)|value)
}
func (o *MATRIX_Type) GetWPSR_WPVS() uint32 {
	return volatile.LoadUint32(&o.WPSR.Reg) & 0x1
}
func (o *MATRIX_Type) SetWPSR_WPVSRC(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0xffff00)|value<<8)
}
func (o *MATRIX_Type) GetWPSR_WPVSRC() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0xffff00) >> 8
}

// Programmable Multibit Error Corrected Code Controller
type EBI_Type struct {
	CFG     volatile.Register32 // 0x0
	SAREA   volatile.Register32 // 0x4
	SADDR   volatile.Register32 // 0x8
	EADDR   volatile.Register32 // 0xC
	CLK     volatile.Register32 // 0x10
	CTRL    volatile.Register32 // 0x14
	SR      volatile.Register32 // 0x18
	IER     volatile.Register32 // 0x1C
	IDR     volatile.Register32 // 0x20
	IMR     volatile.Register32 // 0x24
	ISR     volatile.Register32 // 0x28
	_       [20]byte
	ECC0_0  volatile.Register32 // 0x40
	ECC1_0  volatile.Register32 // 0x44
	ECC2_0  volatile.Register32 // 0x48
	ECC3_0  volatile.Register32 // 0x4C
	ECC4_0  volatile.Register32 // 0x50
	ECC5_0  volatile.Register32 // 0x54
	ECC6_0  volatile.Register32 // 0x58
	ECC7_0  volatile.Register32 // 0x5C
	ECC8_0  volatile.Register32 // 0x60
	ECC9_0  volatile.Register32 // 0x64
	ECC10_0 volatile.Register32 // 0x68
	_       [20]byte
	ECC0_1  volatile.Register32 // 0x80
	ECC1_1  volatile.Register32 // 0x84
	ECC2_1  volatile.Register32 // 0x88
	ECC3_1  volatile.Register32 // 0x8C
	ECC4_1  volatile.Register32 // 0x90
	ECC5_1  volatile.Register32 // 0x94
	ECC6_1  volatile.Register32 // 0x98
	ECC7_1  volatile.Register32 // 0x9C
	ECC8_1  volatile.Register32 // 0xA0
	ECC9_1  volatile.Register32 // 0xA4
	ECC10_1 volatile.Register32 // 0xA8
	_       [20]byte
	ECC0_2  volatile.Register32 // 0xC0
	ECC1_2  volatile.Register32 // 0xC4
	ECC2_2  volatile.Register32 // 0xC8
	ECC3_2  volatile.Register32 // 0xCC
	ECC4_2  volatile.Register32 // 0xD0
	ECC5_2  volatile.Register32 // 0xD4
	ECC6_2  volatile.Register32 // 0xD8
	ECC7_2  volatile.Register32 // 0xDC
	ECC8_2  volatile.Register32 // 0xE0
	ECC9_2  volatile.Register32 // 0xE4
	ECC10_2 volatile.Register32 // 0xE8
	_       [20]byte
	ECC0_3  volatile.Register32 // 0x100
	ECC1_3  volatile.Register32 // 0x104
	ECC2_3  volatile.Register32 // 0x108
	ECC3_3  volatile.Register32 // 0x10C
	ECC4_3  volatile.Register32 // 0x110
	ECC5_3  volatile.Register32 // 0x114
	ECC6_3  volatile.Register32 // 0x118
	ECC7_3  volatile.Register32 // 0x11C
	ECC8_3  volatile.Register32 // 0x120
	ECC9_3  volatile.Register32 // 0x124
	ECC10_3 volatile.Register32 // 0x128
	_       [20]byte
	ECC0_4  volatile.Register32 // 0x140
	ECC1_4  volatile.Register32 // 0x144
	ECC2_4  volatile.Register32 // 0x148
	ECC3_4  volatile.Register32 // 0x14C
	ECC4_4  volatile.Register32 // 0x150
	ECC5_4  volatile.Register32 // 0x154
	ECC6_4  volatile.Register32 // 0x158
	ECC7_4  volatile.Register32 // 0x15C
	ECC8_4  volatile.Register32 // 0x160
	ECC9_4  volatile.Register32 // 0x164
	ECC10_4 volatile.Register32 // 0x168
	_       [20]byte
	ECC0_5  volatile.Register32 // 0x180
	ECC1_5  volatile.Register32 // 0x184
	ECC2_5  volatile.Register32 // 0x188
	ECC3_5  volatile.Register32 // 0x18C
	ECC4_5  volatile.Register32 // 0x190
	ECC5_5  volatile.Register32 // 0x194
	ECC6_5  volatile.Register32 // 0x198
	ECC7_5  volatile.Register32 // 0x19C
	ECC8_5  volatile.Register32 // 0x1A0
	ECC9_5  volatile.Register32 // 0x1A4
	ECC10_5 volatile.Register32 // 0x1A8
	_       [20]byte
	ECC0_6  volatile.Register32 // 0x1C0
	ECC1_6  volatile.Register32 // 0x1C4
	ECC2_6  volatile.Register32 // 0x1C8
	ECC3_6  volatile.Register32 // 0x1CC
	ECC4_6  volatile.Register32 // 0x1D0
	ECC5_6  volatile.Register32 // 0x1D4
	ECC6_6  volatile.Register32 // 0x1D8
	ECC7_6  volatile.Register32 // 0x1DC
	ECC8_6  volatile.Register32 // 0x1E0
	ECC9_6  volatile.Register32 // 0x1E4
	ECC10_6 volatile.Register32 // 0x1E8
	_       [20]byte
	ECC0_7  volatile.Register32 // 0x200
	ECC1_7  volatile.Register32 // 0x204
	ECC2_7  volatile.Register32 // 0x208
	ECC3_7  volatile.Register32 // 0x20C
	ECC4_7  volatile.Register32 // 0x210
	ECC5_7  volatile.Register32 // 0x214
	ECC6_7  volatile.Register32 // 0x218
	ECC7_7  volatile.Register32 // 0x21C
	ECC8_7  volatile.Register32 // 0x220
	ECC9_7  volatile.Register32 // 0x224
	ECC10_7 volatile.Register32 // 0x228
	_       [20]byte
	REM0_0  volatile.Register32 // 0x240
	REM1_0  volatile.Register32 // 0x244
	REM2_0  volatile.Register32 // 0x248
	REM3_0  volatile.Register32 // 0x24C
	REM4_0  volatile.Register32 // 0x250
	REM5_0  volatile.Register32 // 0x254
	REM6_0  volatile.Register32 // 0x258
	REM7_0  volatile.Register32 // 0x25C
	REM8_0  volatile.Register32 // 0x260
	REM9_0  volatile.Register32 // 0x264
	REM10_0 volatile.Register32 // 0x268
	REM11_0 volatile.Register32 // 0x26C
	_       [16]byte
	REM0_1  volatile.Register32 // 0x280
	REM1_1  volatile.Register32 // 0x284
	REM2_1  volatile.Register32 // 0x288
	REM3_1  volatile.Register32 // 0x28C
	REM4_1  volatile.Register32 // 0x290
	REM5_1  volatile.Register32 // 0x294
	REM6_1  volatile.Register32 // 0x298
	REM7_1  volatile.Register32 // 0x29C
	REM8_1  volatile.Register32 // 0x2A0
	REM9_1  volatile.Register32 // 0x2A4
	REM10_1 volatile.Register32 // 0x2A8
	REM11_1 volatile.Register32 // 0x2AC
	_       [16]byte
	REM0_2  volatile.Register32 // 0x2C0
	REM1_2  volatile.Register32 // 0x2C4
	REM2_2  volatile.Register32 // 0x2C8
	REM3_2  volatile.Register32 // 0x2CC
	REM4_2  volatile.Register32 // 0x2D0
	REM5_2  volatile.Register32 // 0x2D4
	REM6_2  volatile.Register32 // 0x2D8
	REM7_2  volatile.Register32 // 0x2DC
	REM8_2  volatile.Register32 // 0x2E0
	REM9_2  volatile.Register32 // 0x2E4
	REM10_2 volatile.Register32 // 0x2E8
	REM11_2 volatile.Register32 // 0x2EC
	_       [16]byte
	REM0_3  volatile.Register32 // 0x300
	REM1_3  volatile.Register32 // 0x304
	REM2_3  volatile.Register32 // 0x308
	REM3_3  volatile.Register32 // 0x30C
	REM4_3  volatile.Register32 // 0x310
	REM5_3  volatile.Register32 // 0x314
	REM6_3  volatile.Register32 // 0x318
	REM7_3  volatile.Register32 // 0x31C
	REM8_3  volatile.Register32 // 0x320
	REM9_3  volatile.Register32 // 0x324
	REM10_3 volatile.Register32 // 0x328
	REM11_3 volatile.Register32 // 0x32C
	_       [16]byte
	REM0_4  volatile.Register32 // 0x340
	REM1_4  volatile.Register32 // 0x344
	REM2_4  volatile.Register32 // 0x348
	REM3_4  volatile.Register32 // 0x34C
	REM4_4  volatile.Register32 // 0x350
	REM5_4  volatile.Register32 // 0x354
	REM6_4  volatile.Register32 // 0x358
	REM7_4  volatile.Register32 // 0x35C
	REM8_4  volatile.Register32 // 0x360
	REM9_4  volatile.Register32 // 0x364
	REM10_4 volatile.Register32 // 0x368
	REM11_4 volatile.Register32 // 0x36C
	_       [16]byte
	REM0_5  volatile.Register32 // 0x380
	REM1_5  volatile.Register32 // 0x384
	REM2_5  volatile.Register32 // 0x388
	REM3_5  volatile.Register32 // 0x38C
	REM4_5  volatile.Register32 // 0x390
	REM5_5  volatile.Register32 // 0x394
	REM6_5  volatile.Register32 // 0x398
	REM7_5  volatile.Register32 // 0x39C
	REM8_5  volatile.Register32 // 0x3A0
	REM9_5  volatile.Register32 // 0x3A4
	REM10_5 volatile.Register32 // 0x3A8
	REM11_5 volatile.Register32 // 0x3AC
	_       [16]byte
	REM0_6  volatile.Register32 // 0x3C0
	REM1_6  volatile.Register32 // 0x3C4
	REM2_6  volatile.Register32 // 0x3C8
	REM3_6  volatile.Register32 // 0x3CC
	REM4_6  volatile.Register32 // 0x3D0
	REM5_6  volatile.Register32 // 0x3D4
	REM6_6  volatile.Register32 // 0x3D8
	REM7_6  volatile.Register32 // 0x3DC
	REM8_6  volatile.Register32 // 0x3E0
	REM9_6  volatile.Register32 // 0x3E4
	REM10_6 volatile.Register32 // 0x3E8
	REM11_6 volatile.Register32 // 0x3EC
	_       [16]byte
	REM0_7  volatile.Register32 // 0x400
	REM1_7  volatile.Register32 // 0x404
	REM2_7  volatile.Register32 // 0x408
	REM3_7  volatile.Register32 // 0x40C
	REM4_7  volatile.Register32 // 0x410
	REM5_7  volatile.Register32 // 0x414
	REM6_7  volatile.Register32 // 0x418
	REM7_7  volatile.Register32 // 0x41C
	REM8_7  volatile.Register32 // 0x420
	REM9_7  volatile.Register32 // 0x424
	REM10_7 volatile.Register32 // 0x428
	REM11_7 volatile.Register32 // 0x42C
}

// EBI.CFG: PMECC Configuration Register
func (o *EBI_Type) SetCFG_BCH_ERR(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x7)|value)
}
func (o *EBI_Type) GetCFG_BCH_ERR() uint32 {
	return volatile.LoadUint32(&o.CFG.Reg) & 0x7
}
func (o *EBI_Type) SetCFG_SECTORSZ(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x10)|value<<4)
}
func (o *EBI_Type) GetCFG_SECTORSZ() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x10) >> 4
}
func (o *EBI_Type) SetCFG_PAGESIZE(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x300)|value<<8)
}
func (o *EBI_Type) GetCFG_PAGESIZE() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x300) >> 8
}
func (o *EBI_Type) SetCFG_NANDWR(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x1000)|value<<12)
}
func (o *EBI_Type) GetCFG_NANDWR() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x1000) >> 12
}
func (o *EBI_Type) SetCFG_SPAREEN(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x10000)|value<<16)
}
func (o *EBI_Type) GetCFG_SPAREEN() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x10000) >> 16
}
func (o *EBI_Type) SetCFG_AUTO(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x100000)|value<<20)
}
func (o *EBI_Type) GetCFG_AUTO() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x100000) >> 20
}

// EBI.SAREA: PMECC Spare Area Size Register
func (o *EBI_Type) SetSAREA_SPARESIZE(value uint32) {
	volatile.StoreUint32(&o.SAREA.Reg, volatile.LoadUint32(&o.SAREA.Reg)&^(0x1ff)|value)
}
func (o *EBI_Type) GetSAREA_SPARESIZE() uint32 {
	return volatile.LoadUint32(&o.SAREA.Reg) & 0x1ff
}

// EBI.SADDR: PMECC Start Address Register
func (o *EBI_Type) SetSADDR_STARTADDR(value uint32) {
	volatile.StoreUint32(&o.SADDR.Reg, volatile.LoadUint32(&o.SADDR.Reg)&^(0x1ff)|value)
}
func (o *EBI_Type) GetSADDR_STARTADDR() uint32 {
	return volatile.LoadUint32(&o.SADDR.Reg) & 0x1ff
}

// EBI.EADDR: PMECC End Address Register
func (o *EBI_Type) SetEADDR_ENDADDR(value uint32) {
	volatile.StoreUint32(&o.EADDR.Reg, volatile.LoadUint32(&o.EADDR.Reg)&^(0x1ff)|value)
}
func (o *EBI_Type) GetEADDR_ENDADDR() uint32 {
	return volatile.LoadUint32(&o.EADDR.Reg) & 0x1ff
}

// EBI.CLK: PMECC Clock Control Register
func (o *EBI_Type) SetCLK_CLKCTRL(value uint32) {
	volatile.StoreUint32(&o.CLK.Reg, volatile.LoadUint32(&o.CLK.Reg)&^(0x7)|value)
}
func (o *EBI_Type) GetCLK_CLKCTRL() uint32 {
	return volatile.LoadUint32(&o.CLK.Reg) & 0x7
}

// EBI.CTRL: PMECC Control Register
func (o *EBI_Type) SetCTRL_RST(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x1)|value)
}
func (o *EBI_Type) GetCTRL_RST() uint32 {
	return volatile.LoadUint32(&o.CTRL.Reg) & 0x1
}
func (o *EBI_Type) SetCTRL_DATA(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x2)|value<<1)
}
func (o *EBI_Type) GetCTRL_DATA() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x2) >> 1
}
func (o *EBI_Type) SetCTRL_USER(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x4)|value<<2)
}
func (o *EBI_Type) GetCTRL_USER() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x4) >> 2
}
func (o *EBI_Type) SetCTRL_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x10)|value<<4)
}
func (o *EBI_Type) GetCTRL_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x10) >> 4
}
func (o *EBI_Type) SetCTRL_DISABLE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x20)|value<<5)
}
func (o *EBI_Type) GetCTRL_DISABLE() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x20) >> 5
}

// EBI.SR: PMECC Status Register
func (o *EBI_Type) SetSR_BUSY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *EBI_Type) GetSR_BUSY() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *EBI_Type) SetSR_ENABLE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *EBI_Type) GetSR_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}

// EBI.IER: PMECC Interrupt Enable register
func (o *EBI_Type) SetIER_ERRIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *EBI_Type) GetIER_ERRIE() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}

// EBI.IDR: PMECC Interrupt Disable Register
func (o *EBI_Type) SetIDR_ERRID(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *EBI_Type) GetIDR_ERRID() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}

// EBI.IMR: PMECC Interrupt Mask Register
func (o *EBI_Type) SetIMR_ERRIM(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *EBI_Type) GetIMR_ERRIM() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}

// EBI.ISR: PMECC Interrupt Status Register
func (o *EBI_Type) SetISR_ERRIS(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0xff)|value)
}
func (o *EBI_Type) GetISR_ERRIS() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0xff
}

// EBI.ECC0_0: PMECC ECC 0 Register (sec_num = 0)
func (o *EBI_Type) SetECC0_0(value uint32) {
	volatile.StoreUint32(&o.ECC0_0.Reg, value)
}
func (o *EBI_Type) GetECC0_0() uint32 {
	return volatile.LoadUint32(&o.ECC0_0.Reg)
}

// EBI.ECC1_0: PMECC ECC 1 Register (sec_num = 0)
func (o *EBI_Type) SetECC1_0(value uint32) {
	volatile.StoreUint32(&o.ECC1_0.Reg, value)
}
func (o *EBI_Type) GetECC1_0() uint32 {
	return volatile.LoadUint32(&o.ECC1_0.Reg)
}

// EBI.ECC2_0: PMECC ECC 2 Register (sec_num = 0)
func (o *EBI_Type) SetECC2_0(value uint32) {
	volatile.StoreUint32(&o.ECC2_0.Reg, value)
}
func (o *EBI_Type) GetECC2_0() uint32 {
	return volatile.LoadUint32(&o.ECC2_0.Reg)
}

// EBI.ECC3_0: PMECC ECC 3 Register (sec_num = 0)
func (o *EBI_Type) SetECC3_0(value uint32) {
	volatile.StoreUint32(&o.ECC3_0.Reg, value)
}
func (o *EBI_Type) GetECC3_0() uint32 {
	return volatile.LoadUint32(&o.ECC3_0.Reg)
}

// EBI.ECC4_0: PMECC ECC 4 Register (sec_num = 0)
func (o *EBI_Type) SetECC4_0(value uint32) {
	volatile.StoreUint32(&o.ECC4_0.Reg, value)
}
func (o *EBI_Type) GetECC4_0() uint32 {
	return volatile.LoadUint32(&o.ECC4_0.Reg)
}

// EBI.ECC5_0: PMECC ECC 5 Register (sec_num = 0)
func (o *EBI_Type) SetECC5_0(value uint32) {
	volatile.StoreUint32(&o.ECC5_0.Reg, value)
}
func (o *EBI_Type) GetECC5_0() uint32 {
	return volatile.LoadUint32(&o.ECC5_0.Reg)
}

// EBI.ECC6_0: PMECC ECC 6 Register (sec_num = 0)
func (o *EBI_Type) SetECC6_0(value uint32) {
	volatile.StoreUint32(&o.ECC6_0.Reg, value)
}
func (o *EBI_Type) GetECC6_0() uint32 {
	return volatile.LoadUint32(&o.ECC6_0.Reg)
}

// EBI.ECC7_0: PMECC ECC 7 Register (sec_num = 0)
func (o *EBI_Type) SetECC7_0(value uint32) {
	volatile.StoreUint32(&o.ECC7_0.Reg, value)
}
func (o *EBI_Type) GetECC7_0() uint32 {
	return volatile.LoadUint32(&o.ECC7_0.Reg)
}

// EBI.ECC8_0: PMECC ECC 8 Register (sec_num = 0)
func (o *EBI_Type) SetECC8_0(value uint32) {
	volatile.StoreUint32(&o.ECC8_0.Reg, value)
}
func (o *EBI_Type) GetECC8_0() uint32 {
	return volatile.LoadUint32(&o.ECC8_0.Reg)
}

// EBI.ECC9_0: PMECC ECC 9 Register (sec_num = 0)
func (o *EBI_Type) SetECC9_0(value uint32) {
	volatile.StoreUint32(&o.ECC9_0.Reg, value)
}
func (o *EBI_Type) GetECC9_0() uint32 {
	return volatile.LoadUint32(&o.ECC9_0.Reg)
}

// EBI.ECC10_0: PMECC ECC 10 Register (sec_num = 0)
func (o *EBI_Type) SetECC10_0(value uint32) {
	volatile.StoreUint32(&o.ECC10_0.Reg, value)
}
func (o *EBI_Type) GetECC10_0() uint32 {
	return volatile.LoadUint32(&o.ECC10_0.Reg)
}

// EBI.ECC0_1: PMECC ECC 0 Register (sec_num = 1)
func (o *EBI_Type) SetECC0_1(value uint32) {
	volatile.StoreUint32(&o.ECC0_1.Reg, value)
}
func (o *EBI_Type) GetECC0_1() uint32 {
	return volatile.LoadUint32(&o.ECC0_1.Reg)
}

// EBI.ECC1_1: PMECC ECC 1 Register (sec_num = 1)
func (o *EBI_Type) SetECC1_1(value uint32) {
	volatile.StoreUint32(&o.ECC1_1.Reg, value)
}
func (o *EBI_Type) GetECC1_1() uint32 {
	return volatile.LoadUint32(&o.ECC1_1.Reg)
}

// EBI.ECC2_1: PMECC ECC 2 Register (sec_num = 1)
func (o *EBI_Type) SetECC2_1(value uint32) {
	volatile.StoreUint32(&o.ECC2_1.Reg, value)
}
func (o *EBI_Type) GetECC2_1() uint32 {
	return volatile.LoadUint32(&o.ECC2_1.Reg)
}

// EBI.ECC3_1: PMECC ECC 3 Register (sec_num = 1)
func (o *EBI_Type) SetECC3_1(value uint32) {
	volatile.StoreUint32(&o.ECC3_1.Reg, value)
}
func (o *EBI_Type) GetECC3_1() uint32 {
	return volatile.LoadUint32(&o.ECC3_1.Reg)
}

// EBI.ECC4_1: PMECC ECC 4 Register (sec_num = 1)
func (o *EBI_Type) SetECC4_1(value uint32) {
	volatile.StoreUint32(&o.ECC4_1.Reg, value)
}
func (o *EBI_Type) GetECC4_1() uint32 {
	return volatile.LoadUint32(&o.ECC4_1.Reg)
}

// EBI.ECC5_1: PMECC ECC 5 Register (sec_num = 1)
func (o *EBI_Type) SetECC5_1(value uint32) {
	volatile.StoreUint32(&o.ECC5_1.Reg, value)
}
func (o *EBI_Type) GetECC5_1() uint32 {
	return volatile.LoadUint32(&o.ECC5_1.Reg)
}

// EBI.ECC6_1: PMECC ECC 6 Register (sec_num = 1)
func (o *EBI_Type) SetECC6_1(value uint32) {
	volatile.StoreUint32(&o.ECC6_1.Reg, value)
}
func (o *EBI_Type) GetECC6_1() uint32 {
	return volatile.LoadUint32(&o.ECC6_1.Reg)
}

// EBI.ECC7_1: PMECC ECC 7 Register (sec_num = 1)
func (o *EBI_Type) SetECC7_1(value uint32) {
	volatile.StoreUint32(&o.ECC7_1.Reg, value)
}
func (o *EBI_Type) GetECC7_1() uint32 {
	return volatile.LoadUint32(&o.ECC7_1.Reg)
}

// EBI.ECC8_1: PMECC ECC 8 Register (sec_num = 1)
func (o *EBI_Type) SetECC8_1(value uint32) {
	volatile.StoreUint32(&o.ECC8_1.Reg, value)
}
func (o *EBI_Type) GetECC8_1() uint32 {
	return volatile.LoadUint32(&o.ECC8_1.Reg)
}

// EBI.ECC9_1: PMECC ECC 9 Register (sec_num = 1)
func (o *EBI_Type) SetECC9_1(value uint32) {
	volatile.StoreUint32(&o.ECC9_1.Reg, value)
}
func (o *EBI_Type) GetECC9_1() uint32 {
	return volatile.LoadUint32(&o.ECC9_1.Reg)
}

// EBI.ECC10_1: PMECC ECC 10 Register (sec_num = 1)
func (o *EBI_Type) SetECC10_1(value uint32) {
	volatile.StoreUint32(&o.ECC10_1.Reg, value)
}
func (o *EBI_Type) GetECC10_1() uint32 {
	return volatile.LoadUint32(&o.ECC10_1.Reg)
}

// EBI.ECC0_2: PMECC ECC 0 Register (sec_num = 2)
func (o *EBI_Type) SetECC0_2(value uint32) {
	volatile.StoreUint32(&o.ECC0_2.Reg, value)
}
func (o *EBI_Type) GetECC0_2() uint32 {
	return volatile.LoadUint32(&o.ECC0_2.Reg)
}

// EBI.ECC1_2: PMECC ECC 1 Register (sec_num = 2)
func (o *EBI_Type) SetECC1_2(value uint32) {
	volatile.StoreUint32(&o.ECC1_2.Reg, value)
}
func (o *EBI_Type) GetECC1_2() uint32 {
	return volatile.LoadUint32(&o.ECC1_2.Reg)
}

// EBI.ECC2_2: PMECC ECC 2 Register (sec_num = 2)
func (o *EBI_Type) SetECC2_2(value uint32) {
	volatile.StoreUint32(&o.ECC2_2.Reg, value)
}
func (o *EBI_Type) GetECC2_2() uint32 {
	return volatile.LoadUint32(&o.ECC2_2.Reg)
}

// EBI.ECC3_2: PMECC ECC 3 Register (sec_num = 2)
func (o *EBI_Type) SetECC3_2(value uint32) {
	volatile.StoreUint32(&o.ECC3_2.Reg, value)
}
func (o *EBI_Type) GetECC3_2() uint32 {
	return volatile.LoadUint32(&o.ECC3_2.Reg)
}

// EBI.ECC4_2: PMECC ECC 4 Register (sec_num = 2)
func (o *EBI_Type) SetECC4_2(value uint32) {
	volatile.StoreUint32(&o.ECC4_2.Reg, value)
}
func (o *EBI_Type) GetECC4_2() uint32 {
	return volatile.LoadUint32(&o.ECC4_2.Reg)
}

// EBI.ECC5_2: PMECC ECC 5 Register (sec_num = 2)
func (o *EBI_Type) SetECC5_2(value uint32) {
	volatile.StoreUint32(&o.ECC5_2.Reg, value)
}
func (o *EBI_Type) GetECC5_2() uint32 {
	return volatile.LoadUint32(&o.ECC5_2.Reg)
}

// EBI.ECC6_2: PMECC ECC 6 Register (sec_num = 2)
func (o *EBI_Type) SetECC6_2(value uint32) {
	volatile.StoreUint32(&o.ECC6_2.Reg, value)
}
func (o *EBI_Type) GetECC6_2() uint32 {
	return volatile.LoadUint32(&o.ECC6_2.Reg)
}

// EBI.ECC7_2: PMECC ECC 7 Register (sec_num = 2)
func (o *EBI_Type) SetECC7_2(value uint32) {
	volatile.StoreUint32(&o.ECC7_2.Reg, value)
}
func (o *EBI_Type) GetECC7_2() uint32 {
	return volatile.LoadUint32(&o.ECC7_2.Reg)
}

// EBI.ECC8_2: PMECC ECC 8 Register (sec_num = 2)
func (o *EBI_Type) SetECC8_2(value uint32) {
	volatile.StoreUint32(&o.ECC8_2.Reg, value)
}
func (o *EBI_Type) GetECC8_2() uint32 {
	return volatile.LoadUint32(&o.ECC8_2.Reg)
}

// EBI.ECC9_2: PMECC ECC 9 Register (sec_num = 2)
func (o *EBI_Type) SetECC9_2(value uint32) {
	volatile.StoreUint32(&o.ECC9_2.Reg, value)
}
func (o *EBI_Type) GetECC9_2() uint32 {
	return volatile.LoadUint32(&o.ECC9_2.Reg)
}

// EBI.ECC10_2: PMECC ECC 10 Register (sec_num = 2)
func (o *EBI_Type) SetECC10_2(value uint32) {
	volatile.StoreUint32(&o.ECC10_2.Reg, value)
}
func (o *EBI_Type) GetECC10_2() uint32 {
	return volatile.LoadUint32(&o.ECC10_2.Reg)
}

// EBI.ECC0_3: PMECC ECC 0 Register (sec_num = 3)
func (o *EBI_Type) SetECC0_3(value uint32) {
	volatile.StoreUint32(&o.ECC0_3.Reg, value)
}
func (o *EBI_Type) GetECC0_3() uint32 {
	return volatile.LoadUint32(&o.ECC0_3.Reg)
}

// EBI.ECC1_3: PMECC ECC 1 Register (sec_num = 3)
func (o *EBI_Type) SetECC1_3(value uint32) {
	volatile.StoreUint32(&o.ECC1_3.Reg, value)
}
func (o *EBI_Type) GetECC1_3() uint32 {
	return volatile.LoadUint32(&o.ECC1_3.Reg)
}

// EBI.ECC2_3: PMECC ECC 2 Register (sec_num = 3)
func (o *EBI_Type) SetECC2_3(value uint32) {
	volatile.StoreUint32(&o.ECC2_3.Reg, value)
}
func (o *EBI_Type) GetECC2_3() uint32 {
	return volatile.LoadUint32(&o.ECC2_3.Reg)
}

// EBI.ECC3_3: PMECC ECC 3 Register (sec_num = 3)
func (o *EBI_Type) SetECC3_3(value uint32) {
	volatile.StoreUint32(&o.ECC3_3.Reg, value)
}
func (o *EBI_Type) GetECC3_3() uint32 {
	return volatile.LoadUint32(&o.ECC3_3.Reg)
}

// EBI.ECC4_3: PMECC ECC 4 Register (sec_num = 3)
func (o *EBI_Type) SetECC4_3(value uint32) {
	volatile.StoreUint32(&o.ECC4_3.Reg, value)
}
func (o *EBI_Type) GetECC4_3() uint32 {
	return volatile.LoadUint32(&o.ECC4_3.Reg)
}

// EBI.ECC5_3: PMECC ECC 5 Register (sec_num = 3)
func (o *EBI_Type) SetECC5_3(value uint32) {
	volatile.StoreUint32(&o.ECC5_3.Reg, value)
}
func (o *EBI_Type) GetECC5_3() uint32 {
	return volatile.LoadUint32(&o.ECC5_3.Reg)
}

// EBI.ECC6_3: PMECC ECC 6 Register (sec_num = 3)
func (o *EBI_Type) SetECC6_3(value uint32) {
	volatile.StoreUint32(&o.ECC6_3.Reg, value)
}
func (o *EBI_Type) GetECC6_3() uint32 {
	return volatile.LoadUint32(&o.ECC6_3.Reg)
}

// EBI.ECC7_3: PMECC ECC 7 Register (sec_num = 3)
func (o *EBI_Type) SetECC7_3(value uint32) {
	volatile.StoreUint32(&o.ECC7_3.Reg, value)
}
func (o *EBI_Type) GetECC7_3() uint32 {
	return volatile.LoadUint32(&o.ECC7_3.Reg)
}

// EBI.ECC8_3: PMECC ECC 8 Register (sec_num = 3)
func (o *EBI_Type) SetECC8_3(value uint32) {
	volatile.StoreUint32(&o.ECC8_3.Reg, value)
}
func (o *EBI_Type) GetECC8_3() uint32 {
	return volatile.LoadUint32(&o.ECC8_3.Reg)
}

// EBI.ECC9_3: PMECC ECC 9 Register (sec_num = 3)
func (o *EBI_Type) SetECC9_3(value uint32) {
	volatile.StoreUint32(&o.ECC9_3.Reg, value)
}
func (o *EBI_Type) GetECC9_3() uint32 {
	return volatile.LoadUint32(&o.ECC9_3.Reg)
}

// EBI.ECC10_3: PMECC ECC 10 Register (sec_num = 3)
func (o *EBI_Type) SetECC10_3(value uint32) {
	volatile.StoreUint32(&o.ECC10_3.Reg, value)
}
func (o *EBI_Type) GetECC10_3() uint32 {
	return volatile.LoadUint32(&o.ECC10_3.Reg)
}

// EBI.ECC0_4: PMECC ECC 0 Register (sec_num = 4)
func (o *EBI_Type) SetECC0_4(value uint32) {
	volatile.StoreUint32(&o.ECC0_4.Reg, value)
}
func (o *EBI_Type) GetECC0_4() uint32 {
	return volatile.LoadUint32(&o.ECC0_4.Reg)
}

// EBI.ECC1_4: PMECC ECC 1 Register (sec_num = 4)
func (o *EBI_Type) SetECC1_4(value uint32) {
	volatile.StoreUint32(&o.ECC1_4.Reg, value)
}
func (o *EBI_Type) GetECC1_4() uint32 {
	return volatile.LoadUint32(&o.ECC1_4.Reg)
}

// EBI.ECC2_4: PMECC ECC 2 Register (sec_num = 4)
func (o *EBI_Type) SetECC2_4(value uint32) {
	volatile.StoreUint32(&o.ECC2_4.Reg, value)
}
func (o *EBI_Type) GetECC2_4() uint32 {
	return volatile.LoadUint32(&o.ECC2_4.Reg)
}

// EBI.ECC3_4: PMECC ECC 3 Register (sec_num = 4)
func (o *EBI_Type) SetECC3_4(value uint32) {
	volatile.StoreUint32(&o.ECC3_4.Reg, value)
}
func (o *EBI_Type) GetECC3_4() uint32 {
	return volatile.LoadUint32(&o.ECC3_4.Reg)
}

// EBI.ECC4_4: PMECC ECC 4 Register (sec_num = 4)
func (o *EBI_Type) SetECC4_4(value uint32) {
	volatile.StoreUint32(&o.ECC4_4.Reg, value)
}
func (o *EBI_Type) GetECC4_4() uint32 {
	return volatile.LoadUint32(&o.ECC4_4.Reg)
}

// EBI.ECC5_4: PMECC ECC 5 Register (sec_num = 4)
func (o *EBI_Type) SetECC5_4(value uint32) {
	volatile.StoreUint32(&o.ECC5_4.Reg, value)
}
func (o *EBI_Type) GetECC5_4() uint32 {
	return volatile.LoadUint32(&o.ECC5_4.Reg)
}

// EBI.ECC6_4: PMECC ECC 6 Register (sec_num = 4)
func (o *EBI_Type) SetECC6_4(value uint32) {
	volatile.StoreUint32(&o.ECC6_4.Reg, value)
}
func (o *EBI_Type) GetECC6_4() uint32 {
	return volatile.LoadUint32(&o.ECC6_4.Reg)
}

// EBI.ECC7_4: PMECC ECC 7 Register (sec_num = 4)
func (o *EBI_Type) SetECC7_4(value uint32) {
	volatile.StoreUint32(&o.ECC7_4.Reg, value)
}
func (o *EBI_Type) GetECC7_4() uint32 {
	return volatile.LoadUint32(&o.ECC7_4.Reg)
}

// EBI.ECC8_4: PMECC ECC 8 Register (sec_num = 4)
func (o *EBI_Type) SetECC8_4(value uint32) {
	volatile.StoreUint32(&o.ECC8_4.Reg, value)
}
func (o *EBI_Type) GetECC8_4() uint32 {
	return volatile.LoadUint32(&o.ECC8_4.Reg)
}

// EBI.ECC9_4: PMECC ECC 9 Register (sec_num = 4)
func (o *EBI_Type) SetECC9_4(value uint32) {
	volatile.StoreUint32(&o.ECC9_4.Reg, value)
}
func (o *EBI_Type) GetECC9_4() uint32 {
	return volatile.LoadUint32(&o.ECC9_4.Reg)
}

// EBI.ECC10_4: PMECC ECC 10 Register (sec_num = 4)
func (o *EBI_Type) SetECC10_4(value uint32) {
	volatile.StoreUint32(&o.ECC10_4.Reg, value)
}
func (o *EBI_Type) GetECC10_4() uint32 {
	return volatile.LoadUint32(&o.ECC10_4.Reg)
}

// EBI.ECC0_5: PMECC ECC 0 Register (sec_num = 5)
func (o *EBI_Type) SetECC0_5(value uint32) {
	volatile.StoreUint32(&o.ECC0_5.Reg, value)
}
func (o *EBI_Type) GetECC0_5() uint32 {
	return volatile.LoadUint32(&o.ECC0_5.Reg)
}

// EBI.ECC1_5: PMECC ECC 1 Register (sec_num = 5)
func (o *EBI_Type) SetECC1_5(value uint32) {
	volatile.StoreUint32(&o.ECC1_5.Reg, value)
}
func (o *EBI_Type) GetECC1_5() uint32 {
	return volatile.LoadUint32(&o.ECC1_5.Reg)
}

// EBI.ECC2_5: PMECC ECC 2 Register (sec_num = 5)
func (o *EBI_Type) SetECC2_5(value uint32) {
	volatile.StoreUint32(&o.ECC2_5.Reg, value)
}
func (o *EBI_Type) GetECC2_5() uint32 {
	return volatile.LoadUint32(&o.ECC2_5.Reg)
}

// EBI.ECC3_5: PMECC ECC 3 Register (sec_num = 5)
func (o *EBI_Type) SetECC3_5(value uint32) {
	volatile.StoreUint32(&o.ECC3_5.Reg, value)
}
func (o *EBI_Type) GetECC3_5() uint32 {
	return volatile.LoadUint32(&o.ECC3_5.Reg)
}

// EBI.ECC4_5: PMECC ECC 4 Register (sec_num = 5)
func (o *EBI_Type) SetECC4_5(value uint32) {
	volatile.StoreUint32(&o.ECC4_5.Reg, value)
}
func (o *EBI_Type) GetECC4_5() uint32 {
	return volatile.LoadUint32(&o.ECC4_5.Reg)
}

// EBI.ECC5_5: PMECC ECC 5 Register (sec_num = 5)
func (o *EBI_Type) SetECC5_5(value uint32) {
	volatile.StoreUint32(&o.ECC5_5.Reg, value)
}
func (o *EBI_Type) GetECC5_5() uint32 {
	return volatile.LoadUint32(&o.ECC5_5.Reg)
}

// EBI.ECC6_5: PMECC ECC 6 Register (sec_num = 5)
func (o *EBI_Type) SetECC6_5(value uint32) {
	volatile.StoreUint32(&o.ECC6_5.Reg, value)
}
func (o *EBI_Type) GetECC6_5() uint32 {
	return volatile.LoadUint32(&o.ECC6_5.Reg)
}

// EBI.ECC7_5: PMECC ECC 7 Register (sec_num = 5)
func (o *EBI_Type) SetECC7_5(value uint32) {
	volatile.StoreUint32(&o.ECC7_5.Reg, value)
}
func (o *EBI_Type) GetECC7_5() uint32 {
	return volatile.LoadUint32(&o.ECC7_5.Reg)
}

// EBI.ECC8_5: PMECC ECC 8 Register (sec_num = 5)
func (o *EBI_Type) SetECC8_5(value uint32) {
	volatile.StoreUint32(&o.ECC8_5.Reg, value)
}
func (o *EBI_Type) GetECC8_5() uint32 {
	return volatile.LoadUint32(&o.ECC8_5.Reg)
}

// EBI.ECC9_5: PMECC ECC 9 Register (sec_num = 5)
func (o *EBI_Type) SetECC9_5(value uint32) {
	volatile.StoreUint32(&o.ECC9_5.Reg, value)
}
func (o *EBI_Type) GetECC9_5() uint32 {
	return volatile.LoadUint32(&o.ECC9_5.Reg)
}

// EBI.ECC10_5: PMECC ECC 10 Register (sec_num = 5)
func (o *EBI_Type) SetECC10_5(value uint32) {
	volatile.StoreUint32(&o.ECC10_5.Reg, value)
}
func (o *EBI_Type) GetECC10_5() uint32 {
	return volatile.LoadUint32(&o.ECC10_5.Reg)
}

// EBI.ECC0_6: PMECC ECC 0 Register (sec_num = 6)
func (o *EBI_Type) SetECC0_6(value uint32) {
	volatile.StoreUint32(&o.ECC0_6.Reg, value)
}
func (o *EBI_Type) GetECC0_6() uint32 {
	return volatile.LoadUint32(&o.ECC0_6.Reg)
}

// EBI.ECC1_6: PMECC ECC 1 Register (sec_num = 6)
func (o *EBI_Type) SetECC1_6(value uint32) {
	volatile.StoreUint32(&o.ECC1_6.Reg, value)
}
func (o *EBI_Type) GetECC1_6() uint32 {
	return volatile.LoadUint32(&o.ECC1_6.Reg)
}

// EBI.ECC2_6: PMECC ECC 2 Register (sec_num = 6)
func (o *EBI_Type) SetECC2_6(value uint32) {
	volatile.StoreUint32(&o.ECC2_6.Reg, value)
}
func (o *EBI_Type) GetECC2_6() uint32 {
	return volatile.LoadUint32(&o.ECC2_6.Reg)
}

// EBI.ECC3_6: PMECC ECC 3 Register (sec_num = 6)
func (o *EBI_Type) SetECC3_6(value uint32) {
	volatile.StoreUint32(&o.ECC3_6.Reg, value)
}
func (o *EBI_Type) GetECC3_6() uint32 {
	return volatile.LoadUint32(&o.ECC3_6.Reg)
}

// EBI.ECC4_6: PMECC ECC 4 Register (sec_num = 6)
func (o *EBI_Type) SetECC4_6(value uint32) {
	volatile.StoreUint32(&o.ECC4_6.Reg, value)
}
func (o *EBI_Type) GetECC4_6() uint32 {
	return volatile.LoadUint32(&o.ECC4_6.Reg)
}

// EBI.ECC5_6: PMECC ECC 5 Register (sec_num = 6)
func (o *EBI_Type) SetECC5_6(value uint32) {
	volatile.StoreUint32(&o.ECC5_6.Reg, value)
}
func (o *EBI_Type) GetECC5_6() uint32 {
	return volatile.LoadUint32(&o.ECC5_6.Reg)
}

// EBI.ECC6_6: PMECC ECC 6 Register (sec_num = 6)
func (o *EBI_Type) SetECC6_6(value uint32) {
	volatile.StoreUint32(&o.ECC6_6.Reg, value)
}
func (o *EBI_Type) GetECC6_6() uint32 {
	return volatile.LoadUint32(&o.ECC6_6.Reg)
}

// EBI.ECC7_6: PMECC ECC 7 Register (sec_num = 6)
func (o *EBI_Type) SetECC7_6(value uint32) {
	volatile.StoreUint32(&o.ECC7_6.Reg, value)
}
func (o *EBI_Type) GetECC7_6() uint32 {
	return volatile.LoadUint32(&o.ECC7_6.Reg)
}

// EBI.ECC8_6: PMECC ECC 8 Register (sec_num = 6)
func (o *EBI_Type) SetECC8_6(value uint32) {
	volatile.StoreUint32(&o.ECC8_6.Reg, value)
}
func (o *EBI_Type) GetECC8_6() uint32 {
	return volatile.LoadUint32(&o.ECC8_6.Reg)
}

// EBI.ECC9_6: PMECC ECC 9 Register (sec_num = 6)
func (o *EBI_Type) SetECC9_6(value uint32) {
	volatile.StoreUint32(&o.ECC9_6.Reg, value)
}
func (o *EBI_Type) GetECC9_6() uint32 {
	return volatile.LoadUint32(&o.ECC9_6.Reg)
}

// EBI.ECC10_6: PMECC ECC 10 Register (sec_num = 6)
func (o *EBI_Type) SetECC10_6(value uint32) {
	volatile.StoreUint32(&o.ECC10_6.Reg, value)
}
func (o *EBI_Type) GetECC10_6() uint32 {
	return volatile.LoadUint32(&o.ECC10_6.Reg)
}

// EBI.ECC0_7: PMECC ECC 0 Register (sec_num = 7)
func (o *EBI_Type) SetECC0_7(value uint32) {
	volatile.StoreUint32(&o.ECC0_7.Reg, value)
}
func (o *EBI_Type) GetECC0_7() uint32 {
	return volatile.LoadUint32(&o.ECC0_7.Reg)
}

// EBI.ECC1_7: PMECC ECC 1 Register (sec_num = 7)
func (o *EBI_Type) SetECC1_7(value uint32) {
	volatile.StoreUint32(&o.ECC1_7.Reg, value)
}
func (o *EBI_Type) GetECC1_7() uint32 {
	return volatile.LoadUint32(&o.ECC1_7.Reg)
}

// EBI.ECC2_7: PMECC ECC 2 Register (sec_num = 7)
func (o *EBI_Type) SetECC2_7(value uint32) {
	volatile.StoreUint32(&o.ECC2_7.Reg, value)
}
func (o *EBI_Type) GetECC2_7() uint32 {
	return volatile.LoadUint32(&o.ECC2_7.Reg)
}

// EBI.ECC3_7: PMECC ECC 3 Register (sec_num = 7)
func (o *EBI_Type) SetECC3_7(value uint32) {
	volatile.StoreUint32(&o.ECC3_7.Reg, value)
}
func (o *EBI_Type) GetECC3_7() uint32 {
	return volatile.LoadUint32(&o.ECC3_7.Reg)
}

// EBI.ECC4_7: PMECC ECC 4 Register (sec_num = 7)
func (o *EBI_Type) SetECC4_7(value uint32) {
	volatile.StoreUint32(&o.ECC4_7.Reg, value)
}
func (o *EBI_Type) GetECC4_7() uint32 {
	return volatile.LoadUint32(&o.ECC4_7.Reg)
}

// EBI.ECC5_7: PMECC ECC 5 Register (sec_num = 7)
func (o *EBI_Type) SetECC5_7(value uint32) {
	volatile.StoreUint32(&o.ECC5_7.Reg, value)
}
func (o *EBI_Type) GetECC5_7() uint32 {
	return volatile.LoadUint32(&o.ECC5_7.Reg)
}

// EBI.ECC6_7: PMECC ECC 6 Register (sec_num = 7)
func (o *EBI_Type) SetECC6_7(value uint32) {
	volatile.StoreUint32(&o.ECC6_7.Reg, value)
}
func (o *EBI_Type) GetECC6_7() uint32 {
	return volatile.LoadUint32(&o.ECC6_7.Reg)
}

// EBI.ECC7_7: PMECC ECC 7 Register (sec_num = 7)
func (o *EBI_Type) SetECC7_7(value uint32) {
	volatile.StoreUint32(&o.ECC7_7.Reg, value)
}
func (o *EBI_Type) GetECC7_7() uint32 {
	return volatile.LoadUint32(&o.ECC7_7.Reg)
}

// EBI.ECC8_7: PMECC ECC 8 Register (sec_num = 7)
func (o *EBI_Type) SetECC8_7(value uint32) {
	volatile.StoreUint32(&o.ECC8_7.Reg, value)
}
func (o *EBI_Type) GetECC8_7() uint32 {
	return volatile.LoadUint32(&o.ECC8_7.Reg)
}

// EBI.ECC9_7: PMECC ECC 9 Register (sec_num = 7)
func (o *EBI_Type) SetECC9_7(value uint32) {
	volatile.StoreUint32(&o.ECC9_7.Reg, value)
}
func (o *EBI_Type) GetECC9_7() uint32 {
	return volatile.LoadUint32(&o.ECC9_7.Reg)
}

// EBI.ECC10_7: PMECC ECC 10 Register (sec_num = 7)
func (o *EBI_Type) SetECC10_7(value uint32) {
	volatile.StoreUint32(&o.ECC10_7.Reg, value)
}
func (o *EBI_Type) GetECC10_7() uint32 {
	return volatile.LoadUint32(&o.ECC10_7.Reg)
}

// EBI.REM0_0: PMECC REM 0 Register (sec_num = 0)
func (o *EBI_Type) SetREM0_0_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM0_0.Reg, volatile.LoadUint32(&o.REM0_0.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM0_0_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM0_0.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM0_0_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM0_0.Reg, volatile.LoadUint32(&o.REM0_0.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM0_0_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM0_0.Reg) & 0x3fff0000) >> 16
}

// EBI.REM1_0: PMECC REM 1 Register (sec_num = 0)
func (o *EBI_Type) SetREM1_0_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM1_0.Reg, volatile.LoadUint32(&o.REM1_0.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM1_0_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM1_0.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM1_0_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM1_0.Reg, volatile.LoadUint32(&o.REM1_0.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM1_0_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM1_0.Reg) & 0x3fff0000) >> 16
}

// EBI.REM2_0: PMECC REM 2 Register (sec_num = 0)
func (o *EBI_Type) SetREM2_0_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM2_0.Reg, volatile.LoadUint32(&o.REM2_0.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM2_0_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM2_0.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM2_0_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM2_0.Reg, volatile.LoadUint32(&o.REM2_0.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM2_0_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM2_0.Reg) & 0x3fff0000) >> 16
}

// EBI.REM3_0: PMECC REM 3 Register (sec_num = 0)
func (o *EBI_Type) SetREM3_0_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM3_0.Reg, volatile.LoadUint32(&o.REM3_0.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM3_0_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM3_0.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM3_0_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM3_0.Reg, volatile.LoadUint32(&o.REM3_0.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM3_0_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM3_0.Reg) & 0x3fff0000) >> 16
}

// EBI.REM4_0: PMECC REM 4 Register (sec_num = 0)
func (o *EBI_Type) SetREM4_0_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM4_0.Reg, volatile.LoadUint32(&o.REM4_0.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM4_0_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM4_0.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM4_0_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM4_0.Reg, volatile.LoadUint32(&o.REM4_0.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM4_0_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM4_0.Reg) & 0x3fff0000) >> 16
}

// EBI.REM5_0: PMECC REM 5 Register (sec_num = 0)
func (o *EBI_Type) SetREM5_0_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM5_0.Reg, volatile.LoadUint32(&o.REM5_0.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM5_0_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM5_0.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM5_0_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM5_0.Reg, volatile.LoadUint32(&o.REM5_0.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM5_0_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM5_0.Reg) & 0x3fff0000) >> 16
}

// EBI.REM6_0: PMECC REM 6 Register (sec_num = 0)
func (o *EBI_Type) SetREM6_0_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM6_0.Reg, volatile.LoadUint32(&o.REM6_0.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM6_0_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM6_0.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM6_0_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM6_0.Reg, volatile.LoadUint32(&o.REM6_0.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM6_0_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM6_0.Reg) & 0x3fff0000) >> 16
}

// EBI.REM7_0: PMECC REM 7 Register (sec_num = 0)
func (o *EBI_Type) SetREM7_0_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM7_0.Reg, volatile.LoadUint32(&o.REM7_0.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM7_0_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM7_0.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM7_0_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM7_0.Reg, volatile.LoadUint32(&o.REM7_0.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM7_0_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM7_0.Reg) & 0x3fff0000) >> 16
}

// EBI.REM8_0: PMECC REM 8 Register (sec_num = 0)
func (o *EBI_Type) SetREM8_0_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM8_0.Reg, volatile.LoadUint32(&o.REM8_0.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM8_0_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM8_0.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM8_0_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM8_0.Reg, volatile.LoadUint32(&o.REM8_0.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM8_0_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM8_0.Reg) & 0x3fff0000) >> 16
}

// EBI.REM9_0: PMECC REM 9 Register (sec_num = 0)
func (o *EBI_Type) SetREM9_0_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM9_0.Reg, volatile.LoadUint32(&o.REM9_0.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM9_0_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM9_0.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM9_0_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM9_0.Reg, volatile.LoadUint32(&o.REM9_0.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM9_0_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM9_0.Reg) & 0x3fff0000) >> 16
}

// EBI.REM10_0: PMECC REM 10 Register (sec_num = 0)
func (o *EBI_Type) SetREM10_0_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM10_0.Reg, volatile.LoadUint32(&o.REM10_0.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM10_0_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM10_0.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM10_0_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM10_0.Reg, volatile.LoadUint32(&o.REM10_0.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM10_0_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM10_0.Reg) & 0x3fff0000) >> 16
}

// EBI.REM11_0: PMECC REM 11 Register (sec_num = 0)
func (o *EBI_Type) SetREM11_0_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM11_0.Reg, volatile.LoadUint32(&o.REM11_0.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM11_0_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM11_0.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM11_0_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM11_0.Reg, volatile.LoadUint32(&o.REM11_0.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM11_0_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM11_0.Reg) & 0x3fff0000) >> 16
}

// EBI.REM0_1: PMECC REM 0 Register (sec_num = 1)
func (o *EBI_Type) SetREM0_1_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM0_1.Reg, volatile.LoadUint32(&o.REM0_1.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM0_1_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM0_1.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM0_1_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM0_1.Reg, volatile.LoadUint32(&o.REM0_1.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM0_1_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM0_1.Reg) & 0x3fff0000) >> 16
}

// EBI.REM1_1: PMECC REM 1 Register (sec_num = 1)
func (o *EBI_Type) SetREM1_1_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM1_1.Reg, volatile.LoadUint32(&o.REM1_1.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM1_1_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM1_1.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM1_1_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM1_1.Reg, volatile.LoadUint32(&o.REM1_1.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM1_1_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM1_1.Reg) & 0x3fff0000) >> 16
}

// EBI.REM2_1: PMECC REM 2 Register (sec_num = 1)
func (o *EBI_Type) SetREM2_1_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM2_1.Reg, volatile.LoadUint32(&o.REM2_1.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM2_1_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM2_1.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM2_1_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM2_1.Reg, volatile.LoadUint32(&o.REM2_1.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM2_1_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM2_1.Reg) & 0x3fff0000) >> 16
}

// EBI.REM3_1: PMECC REM 3 Register (sec_num = 1)
func (o *EBI_Type) SetREM3_1_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM3_1.Reg, volatile.LoadUint32(&o.REM3_1.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM3_1_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM3_1.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM3_1_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM3_1.Reg, volatile.LoadUint32(&o.REM3_1.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM3_1_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM3_1.Reg) & 0x3fff0000) >> 16
}

// EBI.REM4_1: PMECC REM 4 Register (sec_num = 1)
func (o *EBI_Type) SetREM4_1_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM4_1.Reg, volatile.LoadUint32(&o.REM4_1.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM4_1_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM4_1.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM4_1_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM4_1.Reg, volatile.LoadUint32(&o.REM4_1.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM4_1_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM4_1.Reg) & 0x3fff0000) >> 16
}

// EBI.REM5_1: PMECC REM 5 Register (sec_num = 1)
func (o *EBI_Type) SetREM5_1_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM5_1.Reg, volatile.LoadUint32(&o.REM5_1.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM5_1_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM5_1.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM5_1_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM5_1.Reg, volatile.LoadUint32(&o.REM5_1.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM5_1_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM5_1.Reg) & 0x3fff0000) >> 16
}

// EBI.REM6_1: PMECC REM 6 Register (sec_num = 1)
func (o *EBI_Type) SetREM6_1_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM6_1.Reg, volatile.LoadUint32(&o.REM6_1.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM6_1_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM6_1.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM6_1_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM6_1.Reg, volatile.LoadUint32(&o.REM6_1.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM6_1_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM6_1.Reg) & 0x3fff0000) >> 16
}

// EBI.REM7_1: PMECC REM 7 Register (sec_num = 1)
func (o *EBI_Type) SetREM7_1_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM7_1.Reg, volatile.LoadUint32(&o.REM7_1.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM7_1_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM7_1.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM7_1_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM7_1.Reg, volatile.LoadUint32(&o.REM7_1.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM7_1_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM7_1.Reg) & 0x3fff0000) >> 16
}

// EBI.REM8_1: PMECC REM 8 Register (sec_num = 1)
func (o *EBI_Type) SetREM8_1_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM8_1.Reg, volatile.LoadUint32(&o.REM8_1.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM8_1_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM8_1.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM8_1_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM8_1.Reg, volatile.LoadUint32(&o.REM8_1.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM8_1_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM8_1.Reg) & 0x3fff0000) >> 16
}

// EBI.REM9_1: PMECC REM 9 Register (sec_num = 1)
func (o *EBI_Type) SetREM9_1_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM9_1.Reg, volatile.LoadUint32(&o.REM9_1.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM9_1_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM9_1.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM9_1_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM9_1.Reg, volatile.LoadUint32(&o.REM9_1.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM9_1_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM9_1.Reg) & 0x3fff0000) >> 16
}

// EBI.REM10_1: PMECC REM 10 Register (sec_num = 1)
func (o *EBI_Type) SetREM10_1_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM10_1.Reg, volatile.LoadUint32(&o.REM10_1.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM10_1_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM10_1.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM10_1_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM10_1.Reg, volatile.LoadUint32(&o.REM10_1.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM10_1_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM10_1.Reg) & 0x3fff0000) >> 16
}

// EBI.REM11_1: PMECC REM 11 Register (sec_num = 1)
func (o *EBI_Type) SetREM11_1_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM11_1.Reg, volatile.LoadUint32(&o.REM11_1.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM11_1_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM11_1.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM11_1_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM11_1.Reg, volatile.LoadUint32(&o.REM11_1.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM11_1_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM11_1.Reg) & 0x3fff0000) >> 16
}

// EBI.REM0_2: PMECC REM 0 Register (sec_num = 2)
func (o *EBI_Type) SetREM0_2_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM0_2.Reg, volatile.LoadUint32(&o.REM0_2.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM0_2_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM0_2.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM0_2_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM0_2.Reg, volatile.LoadUint32(&o.REM0_2.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM0_2_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM0_2.Reg) & 0x3fff0000) >> 16
}

// EBI.REM1_2: PMECC REM 1 Register (sec_num = 2)
func (o *EBI_Type) SetREM1_2_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM1_2.Reg, volatile.LoadUint32(&o.REM1_2.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM1_2_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM1_2.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM1_2_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM1_2.Reg, volatile.LoadUint32(&o.REM1_2.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM1_2_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM1_2.Reg) & 0x3fff0000) >> 16
}

// EBI.REM2_2: PMECC REM 2 Register (sec_num = 2)
func (o *EBI_Type) SetREM2_2_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM2_2.Reg, volatile.LoadUint32(&o.REM2_2.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM2_2_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM2_2.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM2_2_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM2_2.Reg, volatile.LoadUint32(&o.REM2_2.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM2_2_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM2_2.Reg) & 0x3fff0000) >> 16
}

// EBI.REM3_2: PMECC REM 3 Register (sec_num = 2)
func (o *EBI_Type) SetREM3_2_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM3_2.Reg, volatile.LoadUint32(&o.REM3_2.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM3_2_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM3_2.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM3_2_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM3_2.Reg, volatile.LoadUint32(&o.REM3_2.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM3_2_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM3_2.Reg) & 0x3fff0000) >> 16
}

// EBI.REM4_2: PMECC REM 4 Register (sec_num = 2)
func (o *EBI_Type) SetREM4_2_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM4_2.Reg, volatile.LoadUint32(&o.REM4_2.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM4_2_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM4_2.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM4_2_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM4_2.Reg, volatile.LoadUint32(&o.REM4_2.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM4_2_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM4_2.Reg) & 0x3fff0000) >> 16
}

// EBI.REM5_2: PMECC REM 5 Register (sec_num = 2)
func (o *EBI_Type) SetREM5_2_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM5_2.Reg, volatile.LoadUint32(&o.REM5_2.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM5_2_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM5_2.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM5_2_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM5_2.Reg, volatile.LoadUint32(&o.REM5_2.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM5_2_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM5_2.Reg) & 0x3fff0000) >> 16
}

// EBI.REM6_2: PMECC REM 6 Register (sec_num = 2)
func (o *EBI_Type) SetREM6_2_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM6_2.Reg, volatile.LoadUint32(&o.REM6_2.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM6_2_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM6_2.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM6_2_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM6_2.Reg, volatile.LoadUint32(&o.REM6_2.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM6_2_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM6_2.Reg) & 0x3fff0000) >> 16
}

// EBI.REM7_2: PMECC REM 7 Register (sec_num = 2)
func (o *EBI_Type) SetREM7_2_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM7_2.Reg, volatile.LoadUint32(&o.REM7_2.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM7_2_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM7_2.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM7_2_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM7_2.Reg, volatile.LoadUint32(&o.REM7_2.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM7_2_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM7_2.Reg) & 0x3fff0000) >> 16
}

// EBI.REM8_2: PMECC REM 8 Register (sec_num = 2)
func (o *EBI_Type) SetREM8_2_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM8_2.Reg, volatile.LoadUint32(&o.REM8_2.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM8_2_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM8_2.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM8_2_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM8_2.Reg, volatile.LoadUint32(&o.REM8_2.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM8_2_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM8_2.Reg) & 0x3fff0000) >> 16
}

// EBI.REM9_2: PMECC REM 9 Register (sec_num = 2)
func (o *EBI_Type) SetREM9_2_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM9_2.Reg, volatile.LoadUint32(&o.REM9_2.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM9_2_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM9_2.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM9_2_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM9_2.Reg, volatile.LoadUint32(&o.REM9_2.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM9_2_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM9_2.Reg) & 0x3fff0000) >> 16
}

// EBI.REM10_2: PMECC REM 10 Register (sec_num = 2)
func (o *EBI_Type) SetREM10_2_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM10_2.Reg, volatile.LoadUint32(&o.REM10_2.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM10_2_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM10_2.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM10_2_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM10_2.Reg, volatile.LoadUint32(&o.REM10_2.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM10_2_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM10_2.Reg) & 0x3fff0000) >> 16
}

// EBI.REM11_2: PMECC REM 11 Register (sec_num = 2)
func (o *EBI_Type) SetREM11_2_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM11_2.Reg, volatile.LoadUint32(&o.REM11_2.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM11_2_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM11_2.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM11_2_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM11_2.Reg, volatile.LoadUint32(&o.REM11_2.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM11_2_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM11_2.Reg) & 0x3fff0000) >> 16
}

// EBI.REM0_3: PMECC REM 0 Register (sec_num = 3)
func (o *EBI_Type) SetREM0_3_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM0_3.Reg, volatile.LoadUint32(&o.REM0_3.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM0_3_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM0_3.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM0_3_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM0_3.Reg, volatile.LoadUint32(&o.REM0_3.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM0_3_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM0_3.Reg) & 0x3fff0000) >> 16
}

// EBI.REM1_3: PMECC REM 1 Register (sec_num = 3)
func (o *EBI_Type) SetREM1_3_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM1_3.Reg, volatile.LoadUint32(&o.REM1_3.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM1_3_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM1_3.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM1_3_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM1_3.Reg, volatile.LoadUint32(&o.REM1_3.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM1_3_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM1_3.Reg) & 0x3fff0000) >> 16
}

// EBI.REM2_3: PMECC REM 2 Register (sec_num = 3)
func (o *EBI_Type) SetREM2_3_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM2_3.Reg, volatile.LoadUint32(&o.REM2_3.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM2_3_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM2_3.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM2_3_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM2_3.Reg, volatile.LoadUint32(&o.REM2_3.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM2_3_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM2_3.Reg) & 0x3fff0000) >> 16
}

// EBI.REM3_3: PMECC REM 3 Register (sec_num = 3)
func (o *EBI_Type) SetREM3_3_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM3_3.Reg, volatile.LoadUint32(&o.REM3_3.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM3_3_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM3_3.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM3_3_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM3_3.Reg, volatile.LoadUint32(&o.REM3_3.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM3_3_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM3_3.Reg) & 0x3fff0000) >> 16
}

// EBI.REM4_3: PMECC REM 4 Register (sec_num = 3)
func (o *EBI_Type) SetREM4_3_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM4_3.Reg, volatile.LoadUint32(&o.REM4_3.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM4_3_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM4_3.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM4_3_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM4_3.Reg, volatile.LoadUint32(&o.REM4_3.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM4_3_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM4_3.Reg) & 0x3fff0000) >> 16
}

// EBI.REM5_3: PMECC REM 5 Register (sec_num = 3)
func (o *EBI_Type) SetREM5_3_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM5_3.Reg, volatile.LoadUint32(&o.REM5_3.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM5_3_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM5_3.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM5_3_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM5_3.Reg, volatile.LoadUint32(&o.REM5_3.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM5_3_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM5_3.Reg) & 0x3fff0000) >> 16
}

// EBI.REM6_3: PMECC REM 6 Register (sec_num = 3)
func (o *EBI_Type) SetREM6_3_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM6_3.Reg, volatile.LoadUint32(&o.REM6_3.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM6_3_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM6_3.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM6_3_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM6_3.Reg, volatile.LoadUint32(&o.REM6_3.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM6_3_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM6_3.Reg) & 0x3fff0000) >> 16
}

// EBI.REM7_3: PMECC REM 7 Register (sec_num = 3)
func (o *EBI_Type) SetREM7_3_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM7_3.Reg, volatile.LoadUint32(&o.REM7_3.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM7_3_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM7_3.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM7_3_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM7_3.Reg, volatile.LoadUint32(&o.REM7_3.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM7_3_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM7_3.Reg) & 0x3fff0000) >> 16
}

// EBI.REM8_3: PMECC REM 8 Register (sec_num = 3)
func (o *EBI_Type) SetREM8_3_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM8_3.Reg, volatile.LoadUint32(&o.REM8_3.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM8_3_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM8_3.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM8_3_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM8_3.Reg, volatile.LoadUint32(&o.REM8_3.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM8_3_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM8_3.Reg) & 0x3fff0000) >> 16
}

// EBI.REM9_3: PMECC REM 9 Register (sec_num = 3)
func (o *EBI_Type) SetREM9_3_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM9_3.Reg, volatile.LoadUint32(&o.REM9_3.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM9_3_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM9_3.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM9_3_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM9_3.Reg, volatile.LoadUint32(&o.REM9_3.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM9_3_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM9_3.Reg) & 0x3fff0000) >> 16
}

// EBI.REM10_3: PMECC REM 10 Register (sec_num = 3)
func (o *EBI_Type) SetREM10_3_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM10_3.Reg, volatile.LoadUint32(&o.REM10_3.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM10_3_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM10_3.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM10_3_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM10_3.Reg, volatile.LoadUint32(&o.REM10_3.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM10_3_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM10_3.Reg) & 0x3fff0000) >> 16
}

// EBI.REM11_3: PMECC REM 11 Register (sec_num = 3)
func (o *EBI_Type) SetREM11_3_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM11_3.Reg, volatile.LoadUint32(&o.REM11_3.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM11_3_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM11_3.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM11_3_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM11_3.Reg, volatile.LoadUint32(&o.REM11_3.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM11_3_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM11_3.Reg) & 0x3fff0000) >> 16
}

// EBI.REM0_4: PMECC REM 0 Register (sec_num = 4)
func (o *EBI_Type) SetREM0_4_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM0_4.Reg, volatile.LoadUint32(&o.REM0_4.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM0_4_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM0_4.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM0_4_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM0_4.Reg, volatile.LoadUint32(&o.REM0_4.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM0_4_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM0_4.Reg) & 0x3fff0000) >> 16
}

// EBI.REM1_4: PMECC REM 1 Register (sec_num = 4)
func (o *EBI_Type) SetREM1_4_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM1_4.Reg, volatile.LoadUint32(&o.REM1_4.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM1_4_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM1_4.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM1_4_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM1_4.Reg, volatile.LoadUint32(&o.REM1_4.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM1_4_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM1_4.Reg) & 0x3fff0000) >> 16
}

// EBI.REM2_4: PMECC REM 2 Register (sec_num = 4)
func (o *EBI_Type) SetREM2_4_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM2_4.Reg, volatile.LoadUint32(&o.REM2_4.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM2_4_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM2_4.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM2_4_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM2_4.Reg, volatile.LoadUint32(&o.REM2_4.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM2_4_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM2_4.Reg) & 0x3fff0000) >> 16
}

// EBI.REM3_4: PMECC REM 3 Register (sec_num = 4)
func (o *EBI_Type) SetREM3_4_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM3_4.Reg, volatile.LoadUint32(&o.REM3_4.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM3_4_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM3_4.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM3_4_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM3_4.Reg, volatile.LoadUint32(&o.REM3_4.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM3_4_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM3_4.Reg) & 0x3fff0000) >> 16
}

// EBI.REM4_4: PMECC REM 4 Register (sec_num = 4)
func (o *EBI_Type) SetREM4_4_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM4_4.Reg, volatile.LoadUint32(&o.REM4_4.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM4_4_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM4_4.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM4_4_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM4_4.Reg, volatile.LoadUint32(&o.REM4_4.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM4_4_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM4_4.Reg) & 0x3fff0000) >> 16
}

// EBI.REM5_4: PMECC REM 5 Register (sec_num = 4)
func (o *EBI_Type) SetREM5_4_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM5_4.Reg, volatile.LoadUint32(&o.REM5_4.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM5_4_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM5_4.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM5_4_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM5_4.Reg, volatile.LoadUint32(&o.REM5_4.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM5_4_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM5_4.Reg) & 0x3fff0000) >> 16
}

// EBI.REM6_4: PMECC REM 6 Register (sec_num = 4)
func (o *EBI_Type) SetREM6_4_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM6_4.Reg, volatile.LoadUint32(&o.REM6_4.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM6_4_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM6_4.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM6_4_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM6_4.Reg, volatile.LoadUint32(&o.REM6_4.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM6_4_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM6_4.Reg) & 0x3fff0000) >> 16
}

// EBI.REM7_4: PMECC REM 7 Register (sec_num = 4)
func (o *EBI_Type) SetREM7_4_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM7_4.Reg, volatile.LoadUint32(&o.REM7_4.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM7_4_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM7_4.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM7_4_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM7_4.Reg, volatile.LoadUint32(&o.REM7_4.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM7_4_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM7_4.Reg) & 0x3fff0000) >> 16
}

// EBI.REM8_4: PMECC REM 8 Register (sec_num = 4)
func (o *EBI_Type) SetREM8_4_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM8_4.Reg, volatile.LoadUint32(&o.REM8_4.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM8_4_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM8_4.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM8_4_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM8_4.Reg, volatile.LoadUint32(&o.REM8_4.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM8_4_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM8_4.Reg) & 0x3fff0000) >> 16
}

// EBI.REM9_4: PMECC REM 9 Register (sec_num = 4)
func (o *EBI_Type) SetREM9_4_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM9_4.Reg, volatile.LoadUint32(&o.REM9_4.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM9_4_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM9_4.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM9_4_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM9_4.Reg, volatile.LoadUint32(&o.REM9_4.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM9_4_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM9_4.Reg) & 0x3fff0000) >> 16
}

// EBI.REM10_4: PMECC REM 10 Register (sec_num = 4)
func (o *EBI_Type) SetREM10_4_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM10_4.Reg, volatile.LoadUint32(&o.REM10_4.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM10_4_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM10_4.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM10_4_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM10_4.Reg, volatile.LoadUint32(&o.REM10_4.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM10_4_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM10_4.Reg) & 0x3fff0000) >> 16
}

// EBI.REM11_4: PMECC REM 11 Register (sec_num = 4)
func (o *EBI_Type) SetREM11_4_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM11_4.Reg, volatile.LoadUint32(&o.REM11_4.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM11_4_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM11_4.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM11_4_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM11_4.Reg, volatile.LoadUint32(&o.REM11_4.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM11_4_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM11_4.Reg) & 0x3fff0000) >> 16
}

// EBI.REM0_5: PMECC REM 0 Register (sec_num = 5)
func (o *EBI_Type) SetREM0_5_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM0_5.Reg, volatile.LoadUint32(&o.REM0_5.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM0_5_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM0_5.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM0_5_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM0_5.Reg, volatile.LoadUint32(&o.REM0_5.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM0_5_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM0_5.Reg) & 0x3fff0000) >> 16
}

// EBI.REM1_5: PMECC REM 1 Register (sec_num = 5)
func (o *EBI_Type) SetREM1_5_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM1_5.Reg, volatile.LoadUint32(&o.REM1_5.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM1_5_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM1_5.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM1_5_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM1_5.Reg, volatile.LoadUint32(&o.REM1_5.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM1_5_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM1_5.Reg) & 0x3fff0000) >> 16
}

// EBI.REM2_5: PMECC REM 2 Register (sec_num = 5)
func (o *EBI_Type) SetREM2_5_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM2_5.Reg, volatile.LoadUint32(&o.REM2_5.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM2_5_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM2_5.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM2_5_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM2_5.Reg, volatile.LoadUint32(&o.REM2_5.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM2_5_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM2_5.Reg) & 0x3fff0000) >> 16
}

// EBI.REM3_5: PMECC REM 3 Register (sec_num = 5)
func (o *EBI_Type) SetREM3_5_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM3_5.Reg, volatile.LoadUint32(&o.REM3_5.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM3_5_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM3_5.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM3_5_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM3_5.Reg, volatile.LoadUint32(&o.REM3_5.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM3_5_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM3_5.Reg) & 0x3fff0000) >> 16
}

// EBI.REM4_5: PMECC REM 4 Register (sec_num = 5)
func (o *EBI_Type) SetREM4_5_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM4_5.Reg, volatile.LoadUint32(&o.REM4_5.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM4_5_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM4_5.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM4_5_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM4_5.Reg, volatile.LoadUint32(&o.REM4_5.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM4_5_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM4_5.Reg) & 0x3fff0000) >> 16
}

// EBI.REM5_5: PMECC REM 5 Register (sec_num = 5)
func (o *EBI_Type) SetREM5_5_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM5_5.Reg, volatile.LoadUint32(&o.REM5_5.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM5_5_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM5_5.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM5_5_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM5_5.Reg, volatile.LoadUint32(&o.REM5_5.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM5_5_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM5_5.Reg) & 0x3fff0000) >> 16
}

// EBI.REM6_5: PMECC REM 6 Register (sec_num = 5)
func (o *EBI_Type) SetREM6_5_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM6_5.Reg, volatile.LoadUint32(&o.REM6_5.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM6_5_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM6_5.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM6_5_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM6_5.Reg, volatile.LoadUint32(&o.REM6_5.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM6_5_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM6_5.Reg) & 0x3fff0000) >> 16
}

// EBI.REM7_5: PMECC REM 7 Register (sec_num = 5)
func (o *EBI_Type) SetREM7_5_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM7_5.Reg, volatile.LoadUint32(&o.REM7_5.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM7_5_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM7_5.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM7_5_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM7_5.Reg, volatile.LoadUint32(&o.REM7_5.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM7_5_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM7_5.Reg) & 0x3fff0000) >> 16
}

// EBI.REM8_5: PMECC REM 8 Register (sec_num = 5)
func (o *EBI_Type) SetREM8_5_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM8_5.Reg, volatile.LoadUint32(&o.REM8_5.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM8_5_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM8_5.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM8_5_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM8_5.Reg, volatile.LoadUint32(&o.REM8_5.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM8_5_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM8_5.Reg) & 0x3fff0000) >> 16
}

// EBI.REM9_5: PMECC REM 9 Register (sec_num = 5)
func (o *EBI_Type) SetREM9_5_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM9_5.Reg, volatile.LoadUint32(&o.REM9_5.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM9_5_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM9_5.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM9_5_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM9_5.Reg, volatile.LoadUint32(&o.REM9_5.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM9_5_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM9_5.Reg) & 0x3fff0000) >> 16
}

// EBI.REM10_5: PMECC REM 10 Register (sec_num = 5)
func (o *EBI_Type) SetREM10_5_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM10_5.Reg, volatile.LoadUint32(&o.REM10_5.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM10_5_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM10_5.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM10_5_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM10_5.Reg, volatile.LoadUint32(&o.REM10_5.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM10_5_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM10_5.Reg) & 0x3fff0000) >> 16
}

// EBI.REM11_5: PMECC REM 11 Register (sec_num = 5)
func (o *EBI_Type) SetREM11_5_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM11_5.Reg, volatile.LoadUint32(&o.REM11_5.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM11_5_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM11_5.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM11_5_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM11_5.Reg, volatile.LoadUint32(&o.REM11_5.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM11_5_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM11_5.Reg) & 0x3fff0000) >> 16
}

// EBI.REM0_6: PMECC REM 0 Register (sec_num = 6)
func (o *EBI_Type) SetREM0_6_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM0_6.Reg, volatile.LoadUint32(&o.REM0_6.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM0_6_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM0_6.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM0_6_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM0_6.Reg, volatile.LoadUint32(&o.REM0_6.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM0_6_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM0_6.Reg) & 0x3fff0000) >> 16
}

// EBI.REM1_6: PMECC REM 1 Register (sec_num = 6)
func (o *EBI_Type) SetREM1_6_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM1_6.Reg, volatile.LoadUint32(&o.REM1_6.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM1_6_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM1_6.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM1_6_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM1_6.Reg, volatile.LoadUint32(&o.REM1_6.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM1_6_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM1_6.Reg) & 0x3fff0000) >> 16
}

// EBI.REM2_6: PMECC REM 2 Register (sec_num = 6)
func (o *EBI_Type) SetREM2_6_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM2_6.Reg, volatile.LoadUint32(&o.REM2_6.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM2_6_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM2_6.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM2_6_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM2_6.Reg, volatile.LoadUint32(&o.REM2_6.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM2_6_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM2_6.Reg) & 0x3fff0000) >> 16
}

// EBI.REM3_6: PMECC REM 3 Register (sec_num = 6)
func (o *EBI_Type) SetREM3_6_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM3_6.Reg, volatile.LoadUint32(&o.REM3_6.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM3_6_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM3_6.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM3_6_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM3_6.Reg, volatile.LoadUint32(&o.REM3_6.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM3_6_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM3_6.Reg) & 0x3fff0000) >> 16
}

// EBI.REM4_6: PMECC REM 4 Register (sec_num = 6)
func (o *EBI_Type) SetREM4_6_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM4_6.Reg, volatile.LoadUint32(&o.REM4_6.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM4_6_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM4_6.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM4_6_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM4_6.Reg, volatile.LoadUint32(&o.REM4_6.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM4_6_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM4_6.Reg) & 0x3fff0000) >> 16
}

// EBI.REM5_6: PMECC REM 5 Register (sec_num = 6)
func (o *EBI_Type) SetREM5_6_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM5_6.Reg, volatile.LoadUint32(&o.REM5_6.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM5_6_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM5_6.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM5_6_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM5_6.Reg, volatile.LoadUint32(&o.REM5_6.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM5_6_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM5_6.Reg) & 0x3fff0000) >> 16
}

// EBI.REM6_6: PMECC REM 6 Register (sec_num = 6)
func (o *EBI_Type) SetREM6_6_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM6_6.Reg, volatile.LoadUint32(&o.REM6_6.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM6_6_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM6_6.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM6_6_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM6_6.Reg, volatile.LoadUint32(&o.REM6_6.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM6_6_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM6_6.Reg) & 0x3fff0000) >> 16
}

// EBI.REM7_6: PMECC REM 7 Register (sec_num = 6)
func (o *EBI_Type) SetREM7_6_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM7_6.Reg, volatile.LoadUint32(&o.REM7_6.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM7_6_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM7_6.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM7_6_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM7_6.Reg, volatile.LoadUint32(&o.REM7_6.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM7_6_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM7_6.Reg) & 0x3fff0000) >> 16
}

// EBI.REM8_6: PMECC REM 8 Register (sec_num = 6)
func (o *EBI_Type) SetREM8_6_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM8_6.Reg, volatile.LoadUint32(&o.REM8_6.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM8_6_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM8_6.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM8_6_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM8_6.Reg, volatile.LoadUint32(&o.REM8_6.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM8_6_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM8_6.Reg) & 0x3fff0000) >> 16
}

// EBI.REM9_6: PMECC REM 9 Register (sec_num = 6)
func (o *EBI_Type) SetREM9_6_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM9_6.Reg, volatile.LoadUint32(&o.REM9_6.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM9_6_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM9_6.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM9_6_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM9_6.Reg, volatile.LoadUint32(&o.REM9_6.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM9_6_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM9_6.Reg) & 0x3fff0000) >> 16
}

// EBI.REM10_6: PMECC REM 10 Register (sec_num = 6)
func (o *EBI_Type) SetREM10_6_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM10_6.Reg, volatile.LoadUint32(&o.REM10_6.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM10_6_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM10_6.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM10_6_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM10_6.Reg, volatile.LoadUint32(&o.REM10_6.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM10_6_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM10_6.Reg) & 0x3fff0000) >> 16
}

// EBI.REM11_6: PMECC REM 11 Register (sec_num = 6)
func (o *EBI_Type) SetREM11_6_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM11_6.Reg, volatile.LoadUint32(&o.REM11_6.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM11_6_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM11_6.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM11_6_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM11_6.Reg, volatile.LoadUint32(&o.REM11_6.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM11_6_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM11_6.Reg) & 0x3fff0000) >> 16
}

// EBI.REM0_7: PMECC REM 0 Register (sec_num = 7)
func (o *EBI_Type) SetREM0_7_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM0_7.Reg, volatile.LoadUint32(&o.REM0_7.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM0_7_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM0_7.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM0_7_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM0_7.Reg, volatile.LoadUint32(&o.REM0_7.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM0_7_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM0_7.Reg) & 0x3fff0000) >> 16
}

// EBI.REM1_7: PMECC REM 1 Register (sec_num = 7)
func (o *EBI_Type) SetREM1_7_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM1_7.Reg, volatile.LoadUint32(&o.REM1_7.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM1_7_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM1_7.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM1_7_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM1_7.Reg, volatile.LoadUint32(&o.REM1_7.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM1_7_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM1_7.Reg) & 0x3fff0000) >> 16
}

// EBI.REM2_7: PMECC REM 2 Register (sec_num = 7)
func (o *EBI_Type) SetREM2_7_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM2_7.Reg, volatile.LoadUint32(&o.REM2_7.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM2_7_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM2_7.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM2_7_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM2_7.Reg, volatile.LoadUint32(&o.REM2_7.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM2_7_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM2_7.Reg) & 0x3fff0000) >> 16
}

// EBI.REM3_7: PMECC REM 3 Register (sec_num = 7)
func (o *EBI_Type) SetREM3_7_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM3_7.Reg, volatile.LoadUint32(&o.REM3_7.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM3_7_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM3_7.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM3_7_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM3_7.Reg, volatile.LoadUint32(&o.REM3_7.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM3_7_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM3_7.Reg) & 0x3fff0000) >> 16
}

// EBI.REM4_7: PMECC REM 4 Register (sec_num = 7)
func (o *EBI_Type) SetREM4_7_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM4_7.Reg, volatile.LoadUint32(&o.REM4_7.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM4_7_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM4_7.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM4_7_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM4_7.Reg, volatile.LoadUint32(&o.REM4_7.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM4_7_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM4_7.Reg) & 0x3fff0000) >> 16
}

// EBI.REM5_7: PMECC REM 5 Register (sec_num = 7)
func (o *EBI_Type) SetREM5_7_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM5_7.Reg, volatile.LoadUint32(&o.REM5_7.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM5_7_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM5_7.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM5_7_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM5_7.Reg, volatile.LoadUint32(&o.REM5_7.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM5_7_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM5_7.Reg) & 0x3fff0000) >> 16
}

// EBI.REM6_7: PMECC REM 6 Register (sec_num = 7)
func (o *EBI_Type) SetREM6_7_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM6_7.Reg, volatile.LoadUint32(&o.REM6_7.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM6_7_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM6_7.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM6_7_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM6_7.Reg, volatile.LoadUint32(&o.REM6_7.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM6_7_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM6_7.Reg) & 0x3fff0000) >> 16
}

// EBI.REM7_7: PMECC REM 7 Register (sec_num = 7)
func (o *EBI_Type) SetREM7_7_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM7_7.Reg, volatile.LoadUint32(&o.REM7_7.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM7_7_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM7_7.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM7_7_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM7_7.Reg, volatile.LoadUint32(&o.REM7_7.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM7_7_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM7_7.Reg) & 0x3fff0000) >> 16
}

// EBI.REM8_7: PMECC REM 8 Register (sec_num = 7)
func (o *EBI_Type) SetREM8_7_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM8_7.Reg, volatile.LoadUint32(&o.REM8_7.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM8_7_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM8_7.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM8_7_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM8_7.Reg, volatile.LoadUint32(&o.REM8_7.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM8_7_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM8_7.Reg) & 0x3fff0000) >> 16
}

// EBI.REM9_7: PMECC REM 9 Register (sec_num = 7)
func (o *EBI_Type) SetREM9_7_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM9_7.Reg, volatile.LoadUint32(&o.REM9_7.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM9_7_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM9_7.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM9_7_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM9_7.Reg, volatile.LoadUint32(&o.REM9_7.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM9_7_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM9_7.Reg) & 0x3fff0000) >> 16
}

// EBI.REM10_7: PMECC REM 10 Register (sec_num = 7)
func (o *EBI_Type) SetREM10_7_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM10_7.Reg, volatile.LoadUint32(&o.REM10_7.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM10_7_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM10_7.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM10_7_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM10_7.Reg, volatile.LoadUint32(&o.REM10_7.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM10_7_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM10_7.Reg) & 0x3fff0000) >> 16
}

// EBI.REM11_7: PMECC REM 11 Register (sec_num = 7)
func (o *EBI_Type) SetREM11_7_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM11_7.Reg, volatile.LoadUint32(&o.REM11_7.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM11_7_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM11_7.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM11_7_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM11_7.Reg, volatile.LoadUint32(&o.REM11_7.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM11_7_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM11_7.Reg) & 0x3fff0000) >> 16
}

// DMA Controller 0
type DMAC_Type struct {
	GCFG   volatile.Register32 // 0x0
	EN     volatile.Register32 // 0x4
	SREQ   volatile.Register32 // 0x8
	CREQ   volatile.Register32 // 0xC
	LAST   volatile.Register32 // 0x10
	_      [4]byte
	EBCIER volatile.Register32 // 0x18
	EBCIDR volatile.Register32 // 0x1C
	EBCIMR volatile.Register32 // 0x20
	EBCISR volatile.Register32 // 0x24
	CHER   volatile.Register32 // 0x28
	CHDR   volatile.Register32 // 0x2C
	CHSR   volatile.Register32 // 0x30
	_      [8]byte
	SADDR0 volatile.Register32 // 0x3C
	DADDR0 volatile.Register32 // 0x40
	DSCR0  volatile.Register32 // 0x44
	CTRLA0 volatile.Register32 // 0x48
	CTRLB0 volatile.Register32 // 0x4C
	CFG0   volatile.Register32 // 0x50
	SPIP0  volatile.Register32 // 0x54
	DPIP0  volatile.Register32 // 0x58
	_      [8]byte
	SADDR1 volatile.Register32 // 0x64
	DADDR1 volatile.Register32 // 0x68
	DSCR1  volatile.Register32 // 0x6C
	CTRLA1 volatile.Register32 // 0x70
	CTRLB1 volatile.Register32 // 0x74
	CFG1   volatile.Register32 // 0x78
	SPIP1  volatile.Register32 // 0x7C
	DPIP1  volatile.Register32 // 0x80
	_      [8]byte
	SADDR2 volatile.Register32 // 0x8C
	DADDR2 volatile.Register32 // 0x90
	DSCR2  volatile.Register32 // 0x94
	CTRLA2 volatile.Register32 // 0x98
	CTRLB2 volatile.Register32 // 0x9C
	CFG2   volatile.Register32 // 0xA0
	SPIP2  volatile.Register32 // 0xA4
	DPIP2  volatile.Register32 // 0xA8
	_      [8]byte
	SADDR3 volatile.Register32 // 0xB4
	DADDR3 volatile.Register32 // 0xB8
	DSCR3  volatile.Register32 // 0xBC
	CTRLA3 volatile.Register32 // 0xC0
	CTRLB3 volatile.Register32 // 0xC4
	CFG3   volatile.Register32 // 0xC8
	SPIP3  volatile.Register32 // 0xCC
	DPIP3  volatile.Register32 // 0xD0
	_      [8]byte
	SADDR4 volatile.Register32 // 0xDC
	DADDR4 volatile.Register32 // 0xE0
	DSCR4  volatile.Register32 // 0xE4
	CTRLA4 volatile.Register32 // 0xE8
	CTRLB4 volatile.Register32 // 0xEC
	CFG4   volatile.Register32 // 0xF0
	SPIP4  volatile.Register32 // 0xF4
	DPIP4  volatile.Register32 // 0xF8
	_      [8]byte
	SADDR5 volatile.Register32 // 0x104
	DADDR5 volatile.Register32 // 0x108
	DSCR5  volatile.Register32 // 0x10C
	CTRLA5 volatile.Register32 // 0x110
	CTRLB5 volatile.Register32 // 0x114
	CFG5   volatile.Register32 // 0x118
	SPIP5  volatile.Register32 // 0x11C
	DPIP5  volatile.Register32 // 0x120
	_      [8]byte
	SADDR6 volatile.Register32 // 0x12C
	DADDR6 volatile.Register32 // 0x130
	DSCR6  volatile.Register32 // 0x134
	CTRLA6 volatile.Register32 // 0x138
	CTRLB6 volatile.Register32 // 0x13C
	CFG6   volatile.Register32 // 0x140
	SPIP6  volatile.Register32 // 0x144
	DPIP6  volatile.Register32 // 0x148
	_      [8]byte
	SADDR7 volatile.Register32 // 0x154
	DADDR7 volatile.Register32 // 0x158
	DSCR7  volatile.Register32 // 0x15C
	CTRLA7 volatile.Register32 // 0x160
	CTRLB7 volatile.Register32 // 0x164
	CFG7   volatile.Register32 // 0x168
	SPIP7  volatile.Register32 // 0x16C
	DPIP7  volatile.Register32 // 0x170
	_      [112]byte
	WPMR   volatile.Register32 // 0x1E4
	WPSR   volatile.Register32 // 0x1E8
}

// DMAC.GCFG: DMAC Global Configuration Register
func (o *DMAC_Type) SetGCFG_ARB_CFG(value uint32) {
	volatile.StoreUint32(&o.GCFG.Reg, volatile.LoadUint32(&o.GCFG.Reg)&^(0x10)|value<<4)
}
func (o *DMAC_Type) GetGCFG_ARB_CFG() uint32 {
	return (volatile.LoadUint32(&o.GCFG.Reg) & 0x10) >> 4
}

// DMAC.EN: DMAC Enable Register
func (o *DMAC_Type) SetEN_ENABLE(value uint32) {
	volatile.StoreUint32(&o.EN.Reg, volatile.LoadUint32(&o.EN.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetEN_ENABLE() uint32 {
	return volatile.LoadUint32(&o.EN.Reg) & 0x1
}

// DMAC.SREQ: DMAC Software Single Request Register
func (o *DMAC_Type) SetSREQ_SSREQ0(value uint32) {
	volatile.StoreUint32(&o.SREQ.Reg, volatile.LoadUint32(&o.SREQ.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetSREQ_SSREQ0() uint32 {
	return volatile.LoadUint32(&o.SREQ.Reg) & 0x1
}
func (o *DMAC_Type) SetSREQ_DSREQ0(value uint32) {
	volatile.StoreUint32(&o.SREQ.Reg, volatile.LoadUint32(&o.SREQ.Reg)&^(0x2)|value<<1)
}
func (o *DMAC_Type) GetSREQ_DSREQ0() uint32 {
	return (volatile.LoadUint32(&o.SREQ.Reg) & 0x2) >> 1
}
func (o *DMAC_Type) SetSREQ_SSREQ1(value uint32) {
	volatile.StoreUint32(&o.SREQ.Reg, volatile.LoadUint32(&o.SREQ.Reg)&^(0x4)|value<<2)
}
func (o *DMAC_Type) GetSREQ_SSREQ1() uint32 {
	return (volatile.LoadUint32(&o.SREQ.Reg) & 0x4) >> 2
}
func (o *DMAC_Type) SetSREQ_DSREQ1(value uint32) {
	volatile.StoreUint32(&o.SREQ.Reg, volatile.LoadUint32(&o.SREQ.Reg)&^(0x8)|value<<3)
}
func (o *DMAC_Type) GetSREQ_DSREQ1() uint32 {
	return (volatile.LoadUint32(&o.SREQ.Reg) & 0x8) >> 3
}
func (o *DMAC_Type) SetSREQ_SSREQ2(value uint32) {
	volatile.StoreUint32(&o.SREQ.Reg, volatile.LoadUint32(&o.SREQ.Reg)&^(0x10)|value<<4)
}
func (o *DMAC_Type) GetSREQ_SSREQ2() uint32 {
	return (volatile.LoadUint32(&o.SREQ.Reg) & 0x10) >> 4
}
func (o *DMAC_Type) SetSREQ_DSREQ2(value uint32) {
	volatile.StoreUint32(&o.SREQ.Reg, volatile.LoadUint32(&o.SREQ.Reg)&^(0x20)|value<<5)
}
func (o *DMAC_Type) GetSREQ_DSREQ2() uint32 {
	return (volatile.LoadUint32(&o.SREQ.Reg) & 0x20) >> 5
}
func (o *DMAC_Type) SetSREQ_SSREQ3(value uint32) {
	volatile.StoreUint32(&o.SREQ.Reg, volatile.LoadUint32(&o.SREQ.Reg)&^(0x40)|value<<6)
}
func (o *DMAC_Type) GetSREQ_SSREQ3() uint32 {
	return (volatile.LoadUint32(&o.SREQ.Reg) & 0x40) >> 6
}
func (o *DMAC_Type) SetSREQ_DSREQ3(value uint32) {
	volatile.StoreUint32(&o.SREQ.Reg, volatile.LoadUint32(&o.SREQ.Reg)&^(0x80)|value<<7)
}
func (o *DMAC_Type) GetSREQ_DSREQ3() uint32 {
	return (volatile.LoadUint32(&o.SREQ.Reg) & 0x80) >> 7
}
func (o *DMAC_Type) SetSREQ_SSREQ4(value uint32) {
	volatile.StoreUint32(&o.SREQ.Reg, volatile.LoadUint32(&o.SREQ.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetSREQ_SSREQ4() uint32 {
	return (volatile.LoadUint32(&o.SREQ.Reg) & 0x100) >> 8
}
func (o *DMAC_Type) SetSREQ_DSREQ4(value uint32) {
	volatile.StoreUint32(&o.SREQ.Reg, volatile.LoadUint32(&o.SREQ.Reg)&^(0x200)|value<<9)
}
func (o *DMAC_Type) GetSREQ_DSREQ4() uint32 {
	return (volatile.LoadUint32(&o.SREQ.Reg) & 0x200) >> 9
}
func (o *DMAC_Type) SetSREQ_SSREQ5(value uint32) {
	volatile.StoreUint32(&o.SREQ.Reg, volatile.LoadUint32(&o.SREQ.Reg)&^(0x400)|value<<10)
}
func (o *DMAC_Type) GetSREQ_SSREQ5() uint32 {
	return (volatile.LoadUint32(&o.SREQ.Reg) & 0x400) >> 10
}
func (o *DMAC_Type) SetSREQ_DSREQ5(value uint32) {
	volatile.StoreUint32(&o.SREQ.Reg, volatile.LoadUint32(&o.SREQ.Reg)&^(0x800)|value<<11)
}
func (o *DMAC_Type) GetSREQ_DSREQ5() uint32 {
	return (volatile.LoadUint32(&o.SREQ.Reg) & 0x800) >> 11
}
func (o *DMAC_Type) SetSREQ_SSREQ6(value uint32) {
	volatile.StoreUint32(&o.SREQ.Reg, volatile.LoadUint32(&o.SREQ.Reg)&^(0x1000)|value<<12)
}
func (o *DMAC_Type) GetSREQ_SSREQ6() uint32 {
	return (volatile.LoadUint32(&o.SREQ.Reg) & 0x1000) >> 12
}
func (o *DMAC_Type) SetSREQ_DSREQ6(value uint32) {
	volatile.StoreUint32(&o.SREQ.Reg, volatile.LoadUint32(&o.SREQ.Reg)&^(0x2000)|value<<13)
}
func (o *DMAC_Type) GetSREQ_DSREQ6() uint32 {
	return (volatile.LoadUint32(&o.SREQ.Reg) & 0x2000) >> 13
}
func (o *DMAC_Type) SetSREQ_SSREQ7(value uint32) {
	volatile.StoreUint32(&o.SREQ.Reg, volatile.LoadUint32(&o.SREQ.Reg)&^(0x4000)|value<<14)
}
func (o *DMAC_Type) GetSREQ_SSREQ7() uint32 {
	return (volatile.LoadUint32(&o.SREQ.Reg) & 0x4000) >> 14
}
func (o *DMAC_Type) SetSREQ_DSREQ7(value uint32) {
	volatile.StoreUint32(&o.SREQ.Reg, volatile.LoadUint32(&o.SREQ.Reg)&^(0x8000)|value<<15)
}
func (o *DMAC_Type) GetSREQ_DSREQ7() uint32 {
	return (volatile.LoadUint32(&o.SREQ.Reg) & 0x8000) >> 15
}

// DMAC.CREQ: DMAC Software Chunk Transfer Request Register
func (o *DMAC_Type) SetCREQ_SCREQ0(value uint32) {
	volatile.StoreUint32(&o.CREQ.Reg, volatile.LoadUint32(&o.CREQ.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetCREQ_SCREQ0() uint32 {
	return volatile.LoadUint32(&o.CREQ.Reg) & 0x1
}
func (o *DMAC_Type) SetCREQ_DCREQ0(value uint32) {
	volatile.StoreUint32(&o.CREQ.Reg, volatile.LoadUint32(&o.CREQ.Reg)&^(0x2)|value<<1)
}
func (o *DMAC_Type) GetCREQ_DCREQ0() uint32 {
	return (volatile.LoadUint32(&o.CREQ.Reg) & 0x2) >> 1
}
func (o *DMAC_Type) SetCREQ_SCREQ1(value uint32) {
	volatile.StoreUint32(&o.CREQ.Reg, volatile.LoadUint32(&o.CREQ.Reg)&^(0x4)|value<<2)
}
func (o *DMAC_Type) GetCREQ_SCREQ1() uint32 {
	return (volatile.LoadUint32(&o.CREQ.Reg) & 0x4) >> 2
}
func (o *DMAC_Type) SetCREQ_DCREQ1(value uint32) {
	volatile.StoreUint32(&o.CREQ.Reg, volatile.LoadUint32(&o.CREQ.Reg)&^(0x8)|value<<3)
}
func (o *DMAC_Type) GetCREQ_DCREQ1() uint32 {
	return (volatile.LoadUint32(&o.CREQ.Reg) & 0x8) >> 3
}
func (o *DMAC_Type) SetCREQ_SCREQ2(value uint32) {
	volatile.StoreUint32(&o.CREQ.Reg, volatile.LoadUint32(&o.CREQ.Reg)&^(0x10)|value<<4)
}
func (o *DMAC_Type) GetCREQ_SCREQ2() uint32 {
	return (volatile.LoadUint32(&o.CREQ.Reg) & 0x10) >> 4
}
func (o *DMAC_Type) SetCREQ_DCREQ2(value uint32) {
	volatile.StoreUint32(&o.CREQ.Reg, volatile.LoadUint32(&o.CREQ.Reg)&^(0x20)|value<<5)
}
func (o *DMAC_Type) GetCREQ_DCREQ2() uint32 {
	return (volatile.LoadUint32(&o.CREQ.Reg) & 0x20) >> 5
}
func (o *DMAC_Type) SetCREQ_SCREQ3(value uint32) {
	volatile.StoreUint32(&o.CREQ.Reg, volatile.LoadUint32(&o.CREQ.Reg)&^(0x40)|value<<6)
}
func (o *DMAC_Type) GetCREQ_SCREQ3() uint32 {
	return (volatile.LoadUint32(&o.CREQ.Reg) & 0x40) >> 6
}
func (o *DMAC_Type) SetCREQ_DCREQ3(value uint32) {
	volatile.StoreUint32(&o.CREQ.Reg, volatile.LoadUint32(&o.CREQ.Reg)&^(0x80)|value<<7)
}
func (o *DMAC_Type) GetCREQ_DCREQ3() uint32 {
	return (volatile.LoadUint32(&o.CREQ.Reg) & 0x80) >> 7
}
func (o *DMAC_Type) SetCREQ_SCREQ4(value uint32) {
	volatile.StoreUint32(&o.CREQ.Reg, volatile.LoadUint32(&o.CREQ.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetCREQ_SCREQ4() uint32 {
	return (volatile.LoadUint32(&o.CREQ.Reg) & 0x100) >> 8
}
func (o *DMAC_Type) SetCREQ_DCREQ4(value uint32) {
	volatile.StoreUint32(&o.CREQ.Reg, volatile.LoadUint32(&o.CREQ.Reg)&^(0x200)|value<<9)
}
func (o *DMAC_Type) GetCREQ_DCREQ4() uint32 {
	return (volatile.LoadUint32(&o.CREQ.Reg) & 0x200) >> 9
}
func (o *DMAC_Type) SetCREQ_SCREQ5(value uint32) {
	volatile.StoreUint32(&o.CREQ.Reg, volatile.LoadUint32(&o.CREQ.Reg)&^(0x400)|value<<10)
}
func (o *DMAC_Type) GetCREQ_SCREQ5() uint32 {
	return (volatile.LoadUint32(&o.CREQ.Reg) & 0x400) >> 10
}
func (o *DMAC_Type) SetCREQ_DCREQ5(value uint32) {
	volatile.StoreUint32(&o.CREQ.Reg, volatile.LoadUint32(&o.CREQ.Reg)&^(0x800)|value<<11)
}
func (o *DMAC_Type) GetCREQ_DCREQ5() uint32 {
	return (volatile.LoadUint32(&o.CREQ.Reg) & 0x800) >> 11
}
func (o *DMAC_Type) SetCREQ_SCREQ6(value uint32) {
	volatile.StoreUint32(&o.CREQ.Reg, volatile.LoadUint32(&o.CREQ.Reg)&^(0x1000)|value<<12)
}
func (o *DMAC_Type) GetCREQ_SCREQ6() uint32 {
	return (volatile.LoadUint32(&o.CREQ.Reg) & 0x1000) >> 12
}
func (o *DMAC_Type) SetCREQ_DCREQ6(value uint32) {
	volatile.StoreUint32(&o.CREQ.Reg, volatile.LoadUint32(&o.CREQ.Reg)&^(0x2000)|value<<13)
}
func (o *DMAC_Type) GetCREQ_DCREQ6() uint32 {
	return (volatile.LoadUint32(&o.CREQ.Reg) & 0x2000) >> 13
}
func (o *DMAC_Type) SetCREQ_SCREQ7(value uint32) {
	volatile.StoreUint32(&o.CREQ.Reg, volatile.LoadUint32(&o.CREQ.Reg)&^(0x4000)|value<<14)
}
func (o *DMAC_Type) GetCREQ_SCREQ7() uint32 {
	return (volatile.LoadUint32(&o.CREQ.Reg) & 0x4000) >> 14
}
func (o *DMAC_Type) SetCREQ_DCREQ7(value uint32) {
	volatile.StoreUint32(&o.CREQ.Reg, volatile.LoadUint32(&o.CREQ.Reg)&^(0x8000)|value<<15)
}
func (o *DMAC_Type) GetCREQ_DCREQ7() uint32 {
	return (volatile.LoadUint32(&o.CREQ.Reg) & 0x8000) >> 15
}

// DMAC.LAST: DMAC Software Last Transfer Flag Register
func (o *DMAC_Type) SetLAST_SLAST0(value uint32) {
	volatile.StoreUint32(&o.LAST.Reg, volatile.LoadUint32(&o.LAST.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetLAST_SLAST0() uint32 {
	return volatile.LoadUint32(&o.LAST.Reg) & 0x1
}
func (o *DMAC_Type) SetLAST_DLAST0(value uint32) {
	volatile.StoreUint32(&o.LAST.Reg, volatile.LoadUint32(&o.LAST.Reg)&^(0x2)|value<<1)
}
func (o *DMAC_Type) GetLAST_DLAST0() uint32 {
	return (volatile.LoadUint32(&o.LAST.Reg) & 0x2) >> 1
}
func (o *DMAC_Type) SetLAST_SLAST1(value uint32) {
	volatile.StoreUint32(&o.LAST.Reg, volatile.LoadUint32(&o.LAST.Reg)&^(0x4)|value<<2)
}
func (o *DMAC_Type) GetLAST_SLAST1() uint32 {
	return (volatile.LoadUint32(&o.LAST.Reg) & 0x4) >> 2
}
func (o *DMAC_Type) SetLAST_DLAST1(value uint32) {
	volatile.StoreUint32(&o.LAST.Reg, volatile.LoadUint32(&o.LAST.Reg)&^(0x8)|value<<3)
}
func (o *DMAC_Type) GetLAST_DLAST1() uint32 {
	return (volatile.LoadUint32(&o.LAST.Reg) & 0x8) >> 3
}
func (o *DMAC_Type) SetLAST_SLAST2(value uint32) {
	volatile.StoreUint32(&o.LAST.Reg, volatile.LoadUint32(&o.LAST.Reg)&^(0x10)|value<<4)
}
func (o *DMAC_Type) GetLAST_SLAST2() uint32 {
	return (volatile.LoadUint32(&o.LAST.Reg) & 0x10) >> 4
}
func (o *DMAC_Type) SetLAST_DLAST2(value uint32) {
	volatile.StoreUint32(&o.LAST.Reg, volatile.LoadUint32(&o.LAST.Reg)&^(0x20)|value<<5)
}
func (o *DMAC_Type) GetLAST_DLAST2() uint32 {
	return (volatile.LoadUint32(&o.LAST.Reg) & 0x20) >> 5
}
func (o *DMAC_Type) SetLAST_SLAST3(value uint32) {
	volatile.StoreUint32(&o.LAST.Reg, volatile.LoadUint32(&o.LAST.Reg)&^(0x40)|value<<6)
}
func (o *DMAC_Type) GetLAST_SLAST3() uint32 {
	return (volatile.LoadUint32(&o.LAST.Reg) & 0x40) >> 6
}
func (o *DMAC_Type) SetLAST_DLAST3(value uint32) {
	volatile.StoreUint32(&o.LAST.Reg, volatile.LoadUint32(&o.LAST.Reg)&^(0x80)|value<<7)
}
func (o *DMAC_Type) GetLAST_DLAST3() uint32 {
	return (volatile.LoadUint32(&o.LAST.Reg) & 0x80) >> 7
}
func (o *DMAC_Type) SetLAST_SLAST4(value uint32) {
	volatile.StoreUint32(&o.LAST.Reg, volatile.LoadUint32(&o.LAST.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetLAST_SLAST4() uint32 {
	return (volatile.LoadUint32(&o.LAST.Reg) & 0x100) >> 8
}
func (o *DMAC_Type) SetLAST_DLAST4(value uint32) {
	volatile.StoreUint32(&o.LAST.Reg, volatile.LoadUint32(&o.LAST.Reg)&^(0x200)|value<<9)
}
func (o *DMAC_Type) GetLAST_DLAST4() uint32 {
	return (volatile.LoadUint32(&o.LAST.Reg) & 0x200) >> 9
}
func (o *DMAC_Type) SetLAST_SLAST5(value uint32) {
	volatile.StoreUint32(&o.LAST.Reg, volatile.LoadUint32(&o.LAST.Reg)&^(0x400)|value<<10)
}
func (o *DMAC_Type) GetLAST_SLAST5() uint32 {
	return (volatile.LoadUint32(&o.LAST.Reg) & 0x400) >> 10
}
func (o *DMAC_Type) SetLAST_DLAST5(value uint32) {
	volatile.StoreUint32(&o.LAST.Reg, volatile.LoadUint32(&o.LAST.Reg)&^(0x800)|value<<11)
}
func (o *DMAC_Type) GetLAST_DLAST5() uint32 {
	return (volatile.LoadUint32(&o.LAST.Reg) & 0x800) >> 11
}
func (o *DMAC_Type) SetLAST_SLAST6(value uint32) {
	volatile.StoreUint32(&o.LAST.Reg, volatile.LoadUint32(&o.LAST.Reg)&^(0x1000)|value<<12)
}
func (o *DMAC_Type) GetLAST_SLAST6() uint32 {
	return (volatile.LoadUint32(&o.LAST.Reg) & 0x1000) >> 12
}
func (o *DMAC_Type) SetLAST_DLAST6(value uint32) {
	volatile.StoreUint32(&o.LAST.Reg, volatile.LoadUint32(&o.LAST.Reg)&^(0x2000)|value<<13)
}
func (o *DMAC_Type) GetLAST_DLAST6() uint32 {
	return (volatile.LoadUint32(&o.LAST.Reg) & 0x2000) >> 13
}
func (o *DMAC_Type) SetLAST_SLAST7(value uint32) {
	volatile.StoreUint32(&o.LAST.Reg, volatile.LoadUint32(&o.LAST.Reg)&^(0x4000)|value<<14)
}
func (o *DMAC_Type) GetLAST_SLAST7() uint32 {
	return (volatile.LoadUint32(&o.LAST.Reg) & 0x4000) >> 14
}
func (o *DMAC_Type) SetLAST_DLAST7(value uint32) {
	volatile.StoreUint32(&o.LAST.Reg, volatile.LoadUint32(&o.LAST.Reg)&^(0x8000)|value<<15)
}
func (o *DMAC_Type) GetLAST_DLAST7() uint32 {
	return (volatile.LoadUint32(&o.LAST.Reg) & 0x8000) >> 15
}

// DMAC.EBCIER: DMAC Error, Chained Buffer Transfer Completed Interrupt and Buffer Transfer Completed Interrupt Enable register.
func (o *DMAC_Type) SetEBCIER_BTC0(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetEBCIER_BTC0() uint32 {
	return volatile.LoadUint32(&o.EBCIER.Reg) & 0x1
}
func (o *DMAC_Type) SetEBCIER_BTC1(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x2)|value<<1)
}
func (o *DMAC_Type) GetEBCIER_BTC1() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x2) >> 1
}
func (o *DMAC_Type) SetEBCIER_BTC2(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x4)|value<<2)
}
func (o *DMAC_Type) GetEBCIER_BTC2() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x4) >> 2
}
func (o *DMAC_Type) SetEBCIER_BTC3(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x8)|value<<3)
}
func (o *DMAC_Type) GetEBCIER_BTC3() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x8) >> 3
}
func (o *DMAC_Type) SetEBCIER_BTC4(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x10)|value<<4)
}
func (o *DMAC_Type) GetEBCIER_BTC4() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x10) >> 4
}
func (o *DMAC_Type) SetEBCIER_BTC5(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x20)|value<<5)
}
func (o *DMAC_Type) GetEBCIER_BTC5() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x20) >> 5
}
func (o *DMAC_Type) SetEBCIER_BTC6(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x40)|value<<6)
}
func (o *DMAC_Type) GetEBCIER_BTC6() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x40) >> 6
}
func (o *DMAC_Type) SetEBCIER_BTC7(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x80)|value<<7)
}
func (o *DMAC_Type) GetEBCIER_BTC7() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x80) >> 7
}
func (o *DMAC_Type) SetEBCIER_CBTC0(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetEBCIER_CBTC0() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x100) >> 8
}
func (o *DMAC_Type) SetEBCIER_CBTC1(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x200)|value<<9)
}
func (o *DMAC_Type) GetEBCIER_CBTC1() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x200) >> 9
}
func (o *DMAC_Type) SetEBCIER_CBTC2(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x400)|value<<10)
}
func (o *DMAC_Type) GetEBCIER_CBTC2() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x400) >> 10
}
func (o *DMAC_Type) SetEBCIER_CBTC3(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x800)|value<<11)
}
func (o *DMAC_Type) GetEBCIER_CBTC3() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x800) >> 11
}
func (o *DMAC_Type) SetEBCIER_CBTC4(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x1000)|value<<12)
}
func (o *DMAC_Type) GetEBCIER_CBTC4() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x1000) >> 12
}
func (o *DMAC_Type) SetEBCIER_CBTC5(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x2000)|value<<13)
}
func (o *DMAC_Type) GetEBCIER_CBTC5() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x2000) >> 13
}
func (o *DMAC_Type) SetEBCIER_CBTC6(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x4000)|value<<14)
}
func (o *DMAC_Type) GetEBCIER_CBTC6() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x4000) >> 14
}
func (o *DMAC_Type) SetEBCIER_CBTC7(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x8000)|value<<15)
}
func (o *DMAC_Type) GetEBCIER_CBTC7() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x8000) >> 15
}
func (o *DMAC_Type) SetEBCIER_ERR0(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x10000)|value<<16)
}
func (o *DMAC_Type) GetEBCIER_ERR0() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x10000) >> 16
}
func (o *DMAC_Type) SetEBCIER_ERR1(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x20000)|value<<17)
}
func (o *DMAC_Type) GetEBCIER_ERR1() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x20000) >> 17
}
func (o *DMAC_Type) SetEBCIER_ERR2(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x40000)|value<<18)
}
func (o *DMAC_Type) GetEBCIER_ERR2() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x40000) >> 18
}
func (o *DMAC_Type) SetEBCIER_ERR3(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x80000)|value<<19)
}
func (o *DMAC_Type) GetEBCIER_ERR3() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x80000) >> 19
}
func (o *DMAC_Type) SetEBCIER_ERR4(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x100000)|value<<20)
}
func (o *DMAC_Type) GetEBCIER_ERR4() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x100000) >> 20
}
func (o *DMAC_Type) SetEBCIER_ERR5(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x200000)|value<<21)
}
func (o *DMAC_Type) GetEBCIER_ERR5() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x200000) >> 21
}
func (o *DMAC_Type) SetEBCIER_ERR6(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x400000)|value<<22)
}
func (o *DMAC_Type) GetEBCIER_ERR6() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x400000) >> 22
}
func (o *DMAC_Type) SetEBCIER_ERR7(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x800000)|value<<23)
}
func (o *DMAC_Type) GetEBCIER_ERR7() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x800000) >> 23
}

// DMAC.EBCIDR: DMAC Error, Chained Buffer Transfer Completed Interrupt and Buffer Transfer Completed Interrupt Disable register.
func (o *DMAC_Type) SetEBCIDR_BTC0(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetEBCIDR_BTC0() uint32 {
	return volatile.LoadUint32(&o.EBCIDR.Reg) & 0x1
}
func (o *DMAC_Type) SetEBCIDR_BTC1(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x2)|value<<1)
}
func (o *DMAC_Type) GetEBCIDR_BTC1() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x2) >> 1
}
func (o *DMAC_Type) SetEBCIDR_BTC2(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x4)|value<<2)
}
func (o *DMAC_Type) GetEBCIDR_BTC2() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x4) >> 2
}
func (o *DMAC_Type) SetEBCIDR_BTC3(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x8)|value<<3)
}
func (o *DMAC_Type) GetEBCIDR_BTC3() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x8) >> 3
}
func (o *DMAC_Type) SetEBCIDR_BTC4(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x10)|value<<4)
}
func (o *DMAC_Type) GetEBCIDR_BTC4() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x10) >> 4
}
func (o *DMAC_Type) SetEBCIDR_BTC5(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x20)|value<<5)
}
func (o *DMAC_Type) GetEBCIDR_BTC5() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x20) >> 5
}
func (o *DMAC_Type) SetEBCIDR_BTC6(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x40)|value<<6)
}
func (o *DMAC_Type) GetEBCIDR_BTC6() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x40) >> 6
}
func (o *DMAC_Type) SetEBCIDR_BTC7(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x80)|value<<7)
}
func (o *DMAC_Type) GetEBCIDR_BTC7() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x80) >> 7
}
func (o *DMAC_Type) SetEBCIDR_CBTC0(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetEBCIDR_CBTC0() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x100) >> 8
}
func (o *DMAC_Type) SetEBCIDR_CBTC1(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x200)|value<<9)
}
func (o *DMAC_Type) GetEBCIDR_CBTC1() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x200) >> 9
}
func (o *DMAC_Type) SetEBCIDR_CBTC2(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x400)|value<<10)
}
func (o *DMAC_Type) GetEBCIDR_CBTC2() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x400) >> 10
}
func (o *DMAC_Type) SetEBCIDR_CBTC3(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x800)|value<<11)
}
func (o *DMAC_Type) GetEBCIDR_CBTC3() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x800) >> 11
}
func (o *DMAC_Type) SetEBCIDR_CBTC4(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x1000)|value<<12)
}
func (o *DMAC_Type) GetEBCIDR_CBTC4() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x1000) >> 12
}
func (o *DMAC_Type) SetEBCIDR_CBTC5(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x2000)|value<<13)
}
func (o *DMAC_Type) GetEBCIDR_CBTC5() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x2000) >> 13
}
func (o *DMAC_Type) SetEBCIDR_CBTC6(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x4000)|value<<14)
}
func (o *DMAC_Type) GetEBCIDR_CBTC6() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x4000) >> 14
}
func (o *DMAC_Type) SetEBCIDR_CBTC7(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x8000)|value<<15)
}
func (o *DMAC_Type) GetEBCIDR_CBTC7() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x8000) >> 15
}
func (o *DMAC_Type) SetEBCIDR_ERR0(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAC_Type) GetEBCIDR_ERR0() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x10000) >> 16
}
func (o *DMAC_Type) SetEBCIDR_ERR1(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x20000)|value<<17)
}
func (o *DMAC_Type) GetEBCIDR_ERR1() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x20000) >> 17
}
func (o *DMAC_Type) SetEBCIDR_ERR2(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x40000)|value<<18)
}
func (o *DMAC_Type) GetEBCIDR_ERR2() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x40000) >> 18
}
func (o *DMAC_Type) SetEBCIDR_ERR3(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x80000)|value<<19)
}
func (o *DMAC_Type) GetEBCIDR_ERR3() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x80000) >> 19
}
func (o *DMAC_Type) SetEBCIDR_ERR4(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x100000)|value<<20)
}
func (o *DMAC_Type) GetEBCIDR_ERR4() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x100000) >> 20
}
func (o *DMAC_Type) SetEBCIDR_ERR5(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x200000)|value<<21)
}
func (o *DMAC_Type) GetEBCIDR_ERR5() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x200000) >> 21
}
func (o *DMAC_Type) SetEBCIDR_ERR6(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x400000)|value<<22)
}
func (o *DMAC_Type) GetEBCIDR_ERR6() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x400000) >> 22
}
func (o *DMAC_Type) SetEBCIDR_ERR7(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x800000)|value<<23)
}
func (o *DMAC_Type) GetEBCIDR_ERR7() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x800000) >> 23
}

// DMAC.EBCIMR: DMAC Error, Chained Buffer Transfer Completed Interrupt and Buffer transfer completed Mask Register.
func (o *DMAC_Type) SetEBCIMR_BTC0(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetEBCIMR_BTC0() uint32 {
	return volatile.LoadUint32(&o.EBCIMR.Reg) & 0x1
}
func (o *DMAC_Type) SetEBCIMR_BTC1(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x2)|value<<1)
}
func (o *DMAC_Type) GetEBCIMR_BTC1() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x2) >> 1
}
func (o *DMAC_Type) SetEBCIMR_BTC2(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x4)|value<<2)
}
func (o *DMAC_Type) GetEBCIMR_BTC2() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x4) >> 2
}
func (o *DMAC_Type) SetEBCIMR_BTC3(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x8)|value<<3)
}
func (o *DMAC_Type) GetEBCIMR_BTC3() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x8) >> 3
}
func (o *DMAC_Type) SetEBCIMR_BTC4(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x10)|value<<4)
}
func (o *DMAC_Type) GetEBCIMR_BTC4() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x10) >> 4
}
func (o *DMAC_Type) SetEBCIMR_BTC5(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x20)|value<<5)
}
func (o *DMAC_Type) GetEBCIMR_BTC5() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x20) >> 5
}
func (o *DMAC_Type) SetEBCIMR_BTC6(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x40)|value<<6)
}
func (o *DMAC_Type) GetEBCIMR_BTC6() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x40) >> 6
}
func (o *DMAC_Type) SetEBCIMR_BTC7(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x80)|value<<7)
}
func (o *DMAC_Type) GetEBCIMR_BTC7() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x80) >> 7
}
func (o *DMAC_Type) SetEBCIMR_CBTC0(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetEBCIMR_CBTC0() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x100) >> 8
}
func (o *DMAC_Type) SetEBCIMR_CBTC1(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x200)|value<<9)
}
func (o *DMAC_Type) GetEBCIMR_CBTC1() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x200) >> 9
}
func (o *DMAC_Type) SetEBCIMR_CBTC2(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x400)|value<<10)
}
func (o *DMAC_Type) GetEBCIMR_CBTC2() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x400) >> 10
}
func (o *DMAC_Type) SetEBCIMR_CBTC3(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x800)|value<<11)
}
func (o *DMAC_Type) GetEBCIMR_CBTC3() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x800) >> 11
}
func (o *DMAC_Type) SetEBCIMR_CBTC4(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x1000)|value<<12)
}
func (o *DMAC_Type) GetEBCIMR_CBTC4() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x1000) >> 12
}
func (o *DMAC_Type) SetEBCIMR_CBTC5(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x2000)|value<<13)
}
func (o *DMAC_Type) GetEBCIMR_CBTC5() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x2000) >> 13
}
func (o *DMAC_Type) SetEBCIMR_CBTC6(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x4000)|value<<14)
}
func (o *DMAC_Type) GetEBCIMR_CBTC6() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x4000) >> 14
}
func (o *DMAC_Type) SetEBCIMR_CBTC7(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x8000)|value<<15)
}
func (o *DMAC_Type) GetEBCIMR_CBTC7() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x8000) >> 15
}
func (o *DMAC_Type) SetEBCIMR_ERR0(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAC_Type) GetEBCIMR_ERR0() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x10000) >> 16
}
func (o *DMAC_Type) SetEBCIMR_ERR1(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x20000)|value<<17)
}
func (o *DMAC_Type) GetEBCIMR_ERR1() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x20000) >> 17
}
func (o *DMAC_Type) SetEBCIMR_ERR2(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x40000)|value<<18)
}
func (o *DMAC_Type) GetEBCIMR_ERR2() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x40000) >> 18
}
func (o *DMAC_Type) SetEBCIMR_ERR3(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x80000)|value<<19)
}
func (o *DMAC_Type) GetEBCIMR_ERR3() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x80000) >> 19
}
func (o *DMAC_Type) SetEBCIMR_ERR4(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x100000)|value<<20)
}
func (o *DMAC_Type) GetEBCIMR_ERR4() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x100000) >> 20
}
func (o *DMAC_Type) SetEBCIMR_ERR5(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x200000)|value<<21)
}
func (o *DMAC_Type) GetEBCIMR_ERR5() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x200000) >> 21
}
func (o *DMAC_Type) SetEBCIMR_ERR6(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x400000)|value<<22)
}
func (o *DMAC_Type) GetEBCIMR_ERR6() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x400000) >> 22
}
func (o *DMAC_Type) SetEBCIMR_ERR7(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x800000)|value<<23)
}
func (o *DMAC_Type) GetEBCIMR_ERR7() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x800000) >> 23
}

// DMAC.EBCISR: DMAC Error, Chained Buffer Transfer Completed Interrupt and Buffer transfer completed Status Register.
func (o *DMAC_Type) SetEBCISR_BTC0(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetEBCISR_BTC0() uint32 {
	return volatile.LoadUint32(&o.EBCISR.Reg) & 0x1
}
func (o *DMAC_Type) SetEBCISR_BTC1(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x2)|value<<1)
}
func (o *DMAC_Type) GetEBCISR_BTC1() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x2) >> 1
}
func (o *DMAC_Type) SetEBCISR_BTC2(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x4)|value<<2)
}
func (o *DMAC_Type) GetEBCISR_BTC2() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x4) >> 2
}
func (o *DMAC_Type) SetEBCISR_BTC3(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x8)|value<<3)
}
func (o *DMAC_Type) GetEBCISR_BTC3() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x8) >> 3
}
func (o *DMAC_Type) SetEBCISR_BTC4(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x10)|value<<4)
}
func (o *DMAC_Type) GetEBCISR_BTC4() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x10) >> 4
}
func (o *DMAC_Type) SetEBCISR_BTC5(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x20)|value<<5)
}
func (o *DMAC_Type) GetEBCISR_BTC5() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x20) >> 5
}
func (o *DMAC_Type) SetEBCISR_BTC6(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x40)|value<<6)
}
func (o *DMAC_Type) GetEBCISR_BTC6() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x40) >> 6
}
func (o *DMAC_Type) SetEBCISR_BTC7(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x80)|value<<7)
}
func (o *DMAC_Type) GetEBCISR_BTC7() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x80) >> 7
}
func (o *DMAC_Type) SetEBCISR_CBTC0(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetEBCISR_CBTC0() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x100) >> 8
}
func (o *DMAC_Type) SetEBCISR_CBTC1(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x200)|value<<9)
}
func (o *DMAC_Type) GetEBCISR_CBTC1() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x200) >> 9
}
func (o *DMAC_Type) SetEBCISR_CBTC2(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x400)|value<<10)
}
func (o *DMAC_Type) GetEBCISR_CBTC2() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x400) >> 10
}
func (o *DMAC_Type) SetEBCISR_CBTC3(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x800)|value<<11)
}
func (o *DMAC_Type) GetEBCISR_CBTC3() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x800) >> 11
}
func (o *DMAC_Type) SetEBCISR_CBTC4(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x1000)|value<<12)
}
func (o *DMAC_Type) GetEBCISR_CBTC4() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x1000) >> 12
}
func (o *DMAC_Type) SetEBCISR_CBTC5(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x2000)|value<<13)
}
func (o *DMAC_Type) GetEBCISR_CBTC5() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x2000) >> 13
}
func (o *DMAC_Type) SetEBCISR_CBTC6(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x4000)|value<<14)
}
func (o *DMAC_Type) GetEBCISR_CBTC6() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x4000) >> 14
}
func (o *DMAC_Type) SetEBCISR_CBTC7(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x8000)|value<<15)
}
func (o *DMAC_Type) GetEBCISR_CBTC7() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x8000) >> 15
}
func (o *DMAC_Type) SetEBCISR_ERR0(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAC_Type) GetEBCISR_ERR0() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x10000) >> 16
}
func (o *DMAC_Type) SetEBCISR_ERR1(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x20000)|value<<17)
}
func (o *DMAC_Type) GetEBCISR_ERR1() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x20000) >> 17
}
func (o *DMAC_Type) SetEBCISR_ERR2(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x40000)|value<<18)
}
func (o *DMAC_Type) GetEBCISR_ERR2() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x40000) >> 18
}
func (o *DMAC_Type) SetEBCISR_ERR3(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x80000)|value<<19)
}
func (o *DMAC_Type) GetEBCISR_ERR3() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x80000) >> 19
}
func (o *DMAC_Type) SetEBCISR_ERR4(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x100000)|value<<20)
}
func (o *DMAC_Type) GetEBCISR_ERR4() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x100000) >> 20
}
func (o *DMAC_Type) SetEBCISR_ERR5(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x200000)|value<<21)
}
func (o *DMAC_Type) GetEBCISR_ERR5() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x200000) >> 21
}
func (o *DMAC_Type) SetEBCISR_ERR6(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x400000)|value<<22)
}
func (o *DMAC_Type) GetEBCISR_ERR6() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x400000) >> 22
}
func (o *DMAC_Type) SetEBCISR_ERR7(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x800000)|value<<23)
}
func (o *DMAC_Type) GetEBCISR_ERR7() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x800000) >> 23
}

// DMAC.CHER: DMAC Channel Handler Enable Register
func (o *DMAC_Type) SetCHER_ENA0(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetCHER_ENA0() uint32 {
	return volatile.LoadUint32(&o.CHER.Reg) & 0x1
}
func (o *DMAC_Type) SetCHER_ENA1(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x2)|value<<1)
}
func (o *DMAC_Type) GetCHER_ENA1() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x2) >> 1
}
func (o *DMAC_Type) SetCHER_ENA2(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x4)|value<<2)
}
func (o *DMAC_Type) GetCHER_ENA2() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x4) >> 2
}
func (o *DMAC_Type) SetCHER_ENA3(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x8)|value<<3)
}
func (o *DMAC_Type) GetCHER_ENA3() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x8) >> 3
}
func (o *DMAC_Type) SetCHER_ENA4(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x10)|value<<4)
}
func (o *DMAC_Type) GetCHER_ENA4() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x10) >> 4
}
func (o *DMAC_Type) SetCHER_ENA5(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x20)|value<<5)
}
func (o *DMAC_Type) GetCHER_ENA5() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x20) >> 5
}
func (o *DMAC_Type) SetCHER_ENA6(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x40)|value<<6)
}
func (o *DMAC_Type) GetCHER_ENA6() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x40) >> 6
}
func (o *DMAC_Type) SetCHER_ENA7(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x80)|value<<7)
}
func (o *DMAC_Type) GetCHER_ENA7() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x80) >> 7
}
func (o *DMAC_Type) SetCHER_SUSP0(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetCHER_SUSP0() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x100) >> 8
}
func (o *DMAC_Type) SetCHER_SUSP1(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x200)|value<<9)
}
func (o *DMAC_Type) GetCHER_SUSP1() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x200) >> 9
}
func (o *DMAC_Type) SetCHER_SUSP2(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x400)|value<<10)
}
func (o *DMAC_Type) GetCHER_SUSP2() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x400) >> 10
}
func (o *DMAC_Type) SetCHER_SUSP3(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x800)|value<<11)
}
func (o *DMAC_Type) GetCHER_SUSP3() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x800) >> 11
}
func (o *DMAC_Type) SetCHER_SUSP4(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x1000)|value<<12)
}
func (o *DMAC_Type) GetCHER_SUSP4() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x1000) >> 12
}
func (o *DMAC_Type) SetCHER_SUSP5(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x2000)|value<<13)
}
func (o *DMAC_Type) GetCHER_SUSP5() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x2000) >> 13
}
func (o *DMAC_Type) SetCHER_SUSP6(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x4000)|value<<14)
}
func (o *DMAC_Type) GetCHER_SUSP6() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x4000) >> 14
}
func (o *DMAC_Type) SetCHER_SUSP7(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x8000)|value<<15)
}
func (o *DMAC_Type) GetCHER_SUSP7() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x8000) >> 15
}
func (o *DMAC_Type) SetCHER_KEEP0(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x1000000)|value<<24)
}
func (o *DMAC_Type) GetCHER_KEEP0() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x1000000) >> 24
}
func (o *DMAC_Type) SetCHER_KEEP1(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x2000000)|value<<25)
}
func (o *DMAC_Type) GetCHER_KEEP1() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x2000000) >> 25
}
func (o *DMAC_Type) SetCHER_KEEP2(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x4000000)|value<<26)
}
func (o *DMAC_Type) GetCHER_KEEP2() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x4000000) >> 26
}
func (o *DMAC_Type) SetCHER_KEEP3(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x8000000)|value<<27)
}
func (o *DMAC_Type) GetCHER_KEEP3() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x8000000) >> 27
}
func (o *DMAC_Type) SetCHER_KEEP4(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x10000000)|value<<28)
}
func (o *DMAC_Type) GetCHER_KEEP4() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x10000000) >> 28
}
func (o *DMAC_Type) SetCHER_KEEP5(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x20000000)|value<<29)
}
func (o *DMAC_Type) GetCHER_KEEP5() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x20000000) >> 29
}
func (o *DMAC_Type) SetCHER_KEEP6(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x40000000)|value<<30)
}
func (o *DMAC_Type) GetCHER_KEEP6() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x40000000) >> 30
}
func (o *DMAC_Type) SetCHER_KEEP7(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x80000000)|value<<31)
}
func (o *DMAC_Type) GetCHER_KEEP7() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x80000000) >> 31
}

// DMAC.CHDR: DMAC Channel Handler Disable Register
func (o *DMAC_Type) SetCHDR_DIS0(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetCHDR_DIS0() uint32 {
	return volatile.LoadUint32(&o.CHDR.Reg) & 0x1
}
func (o *DMAC_Type) SetCHDR_DIS1(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x2)|value<<1)
}
func (o *DMAC_Type) GetCHDR_DIS1() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x2) >> 1
}
func (o *DMAC_Type) SetCHDR_DIS2(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x4)|value<<2)
}
func (o *DMAC_Type) GetCHDR_DIS2() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x4) >> 2
}
func (o *DMAC_Type) SetCHDR_DIS3(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x8)|value<<3)
}
func (o *DMAC_Type) GetCHDR_DIS3() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x8) >> 3
}
func (o *DMAC_Type) SetCHDR_DIS4(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x10)|value<<4)
}
func (o *DMAC_Type) GetCHDR_DIS4() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x10) >> 4
}
func (o *DMAC_Type) SetCHDR_DIS5(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x20)|value<<5)
}
func (o *DMAC_Type) GetCHDR_DIS5() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x20) >> 5
}
func (o *DMAC_Type) SetCHDR_DIS6(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x40)|value<<6)
}
func (o *DMAC_Type) GetCHDR_DIS6() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x40) >> 6
}
func (o *DMAC_Type) SetCHDR_DIS7(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x80)|value<<7)
}
func (o *DMAC_Type) GetCHDR_DIS7() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x80) >> 7
}
func (o *DMAC_Type) SetCHDR_RES0(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetCHDR_RES0() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x100) >> 8
}
func (o *DMAC_Type) SetCHDR_RES1(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x200)|value<<9)
}
func (o *DMAC_Type) GetCHDR_RES1() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x200) >> 9
}
func (o *DMAC_Type) SetCHDR_RES2(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x400)|value<<10)
}
func (o *DMAC_Type) GetCHDR_RES2() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x400) >> 10
}
func (o *DMAC_Type) SetCHDR_RES3(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x800)|value<<11)
}
func (o *DMAC_Type) GetCHDR_RES3() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x800) >> 11
}
func (o *DMAC_Type) SetCHDR_RES4(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x1000)|value<<12)
}
func (o *DMAC_Type) GetCHDR_RES4() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x1000) >> 12
}
func (o *DMAC_Type) SetCHDR_RES5(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x2000)|value<<13)
}
func (o *DMAC_Type) GetCHDR_RES5() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x2000) >> 13
}
func (o *DMAC_Type) SetCHDR_RES6(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x4000)|value<<14)
}
func (o *DMAC_Type) GetCHDR_RES6() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x4000) >> 14
}
func (o *DMAC_Type) SetCHDR_RES7(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x8000)|value<<15)
}
func (o *DMAC_Type) GetCHDR_RES7() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x8000) >> 15
}

// DMAC.CHSR: DMAC Channel Handler Status Register
func (o *DMAC_Type) SetCHSR_ENA0(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetCHSR_ENA0() uint32 {
	return volatile.LoadUint32(&o.CHSR.Reg) & 0x1
}
func (o *DMAC_Type) SetCHSR_ENA1(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x2)|value<<1)
}
func (o *DMAC_Type) GetCHSR_ENA1() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x2) >> 1
}
func (o *DMAC_Type) SetCHSR_ENA2(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x4)|value<<2)
}
func (o *DMAC_Type) GetCHSR_ENA2() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x4) >> 2
}
func (o *DMAC_Type) SetCHSR_ENA3(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x8)|value<<3)
}
func (o *DMAC_Type) GetCHSR_ENA3() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x8) >> 3
}
func (o *DMAC_Type) SetCHSR_ENA4(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x10)|value<<4)
}
func (o *DMAC_Type) GetCHSR_ENA4() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x10) >> 4
}
func (o *DMAC_Type) SetCHSR_ENA5(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x20)|value<<5)
}
func (o *DMAC_Type) GetCHSR_ENA5() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x20) >> 5
}
func (o *DMAC_Type) SetCHSR_ENA6(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x40)|value<<6)
}
func (o *DMAC_Type) GetCHSR_ENA6() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x40) >> 6
}
func (o *DMAC_Type) SetCHSR_ENA7(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x80)|value<<7)
}
func (o *DMAC_Type) GetCHSR_ENA7() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x80) >> 7
}
func (o *DMAC_Type) SetCHSR_SUSP0(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetCHSR_SUSP0() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x100) >> 8
}
func (o *DMAC_Type) SetCHSR_SUSP1(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x200)|value<<9)
}
func (o *DMAC_Type) GetCHSR_SUSP1() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x200) >> 9
}
func (o *DMAC_Type) SetCHSR_SUSP2(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x400)|value<<10)
}
func (o *DMAC_Type) GetCHSR_SUSP2() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x400) >> 10
}
func (o *DMAC_Type) SetCHSR_SUSP3(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x800)|value<<11)
}
func (o *DMAC_Type) GetCHSR_SUSP3() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x800) >> 11
}
func (o *DMAC_Type) SetCHSR_SUSP4(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x1000)|value<<12)
}
func (o *DMAC_Type) GetCHSR_SUSP4() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x1000) >> 12
}
func (o *DMAC_Type) SetCHSR_SUSP5(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x2000)|value<<13)
}
func (o *DMAC_Type) GetCHSR_SUSP5() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x2000) >> 13
}
func (o *DMAC_Type) SetCHSR_SUSP6(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x4000)|value<<14)
}
func (o *DMAC_Type) GetCHSR_SUSP6() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x4000) >> 14
}
func (o *DMAC_Type) SetCHSR_SUSP7(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x8000)|value<<15)
}
func (o *DMAC_Type) GetCHSR_SUSP7() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x8000) >> 15
}
func (o *DMAC_Type) SetCHSR_EMPT0(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAC_Type) GetCHSR_EMPT0() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x10000) >> 16
}
func (o *DMAC_Type) SetCHSR_EMPT1(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x20000)|value<<17)
}
func (o *DMAC_Type) GetCHSR_EMPT1() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x20000) >> 17
}
func (o *DMAC_Type) SetCHSR_EMPT2(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x40000)|value<<18)
}
func (o *DMAC_Type) GetCHSR_EMPT2() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x40000) >> 18
}
func (o *DMAC_Type) SetCHSR_EMPT3(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x80000)|value<<19)
}
func (o *DMAC_Type) GetCHSR_EMPT3() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x80000) >> 19
}
func (o *DMAC_Type) SetCHSR_EMPT4(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x100000)|value<<20)
}
func (o *DMAC_Type) GetCHSR_EMPT4() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x100000) >> 20
}
func (o *DMAC_Type) SetCHSR_EMPT5(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x200000)|value<<21)
}
func (o *DMAC_Type) GetCHSR_EMPT5() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x200000) >> 21
}
func (o *DMAC_Type) SetCHSR_EMPT6(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x400000)|value<<22)
}
func (o *DMAC_Type) GetCHSR_EMPT6() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x400000) >> 22
}
func (o *DMAC_Type) SetCHSR_EMPT7(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x800000)|value<<23)
}
func (o *DMAC_Type) GetCHSR_EMPT7() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x800000) >> 23
}
func (o *DMAC_Type) SetCHSR_STAL0(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x1000000)|value<<24)
}
func (o *DMAC_Type) GetCHSR_STAL0() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x1000000) >> 24
}
func (o *DMAC_Type) SetCHSR_STAL1(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x2000000)|value<<25)
}
func (o *DMAC_Type) GetCHSR_STAL1() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x2000000) >> 25
}
func (o *DMAC_Type) SetCHSR_STAL2(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x4000000)|value<<26)
}
func (o *DMAC_Type) GetCHSR_STAL2() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x4000000) >> 26
}
func (o *DMAC_Type) SetCHSR_STAL3(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x8000000)|value<<27)
}
func (o *DMAC_Type) GetCHSR_STAL3() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x8000000) >> 27
}
func (o *DMAC_Type) SetCHSR_STAL4(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x10000000)|value<<28)
}
func (o *DMAC_Type) GetCHSR_STAL4() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x10000000) >> 28
}
func (o *DMAC_Type) SetCHSR_STAL5(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x20000000)|value<<29)
}
func (o *DMAC_Type) GetCHSR_STAL5() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x20000000) >> 29
}
func (o *DMAC_Type) SetCHSR_STAL6(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x40000000)|value<<30)
}
func (o *DMAC_Type) GetCHSR_STAL6() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x40000000) >> 30
}
func (o *DMAC_Type) SetCHSR_STAL7(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x80000000)|value<<31)
}
func (o *DMAC_Type) GetCHSR_STAL7() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x80000000) >> 31
}

// DMAC.SADDR0: DMAC Channel Source Address Register (ch_num = 0)
func (o *DMAC_Type) SetSADDR0(value uint32) {
	volatile.StoreUint32(&o.SADDR0.Reg, value)
}
func (o *DMAC_Type) GetSADDR0() uint32 {
	return volatile.LoadUint32(&o.SADDR0.Reg)
}

// DMAC.DADDR0: DMAC Channel Destination Address Register (ch_num = 0)
func (o *DMAC_Type) SetDADDR0(value uint32) {
	volatile.StoreUint32(&o.DADDR0.Reg, value)
}
func (o *DMAC_Type) GetDADDR0() uint32 {
	return volatile.LoadUint32(&o.DADDR0.Reg)
}

// DMAC.DSCR0: DMAC Channel Descriptor Address Register (ch_num = 0)
func (o *DMAC_Type) SetDSCR0_DSCR_IF(value uint32) {
	volatile.StoreUint32(&o.DSCR0.Reg, volatile.LoadUint32(&o.DSCR0.Reg)&^(0x3)|value)
}
func (o *DMAC_Type) GetDSCR0_DSCR_IF() uint32 {
	return volatile.LoadUint32(&o.DSCR0.Reg) & 0x3
}
func (o *DMAC_Type) SetDSCR0_DSCR(value uint32) {
	volatile.StoreUint32(&o.DSCR0.Reg, volatile.LoadUint32(&o.DSCR0.Reg)&^(0xfffffffc)|value<<2)
}
func (o *DMAC_Type) GetDSCR0_DSCR() uint32 {
	return (volatile.LoadUint32(&o.DSCR0.Reg) & 0xfffffffc) >> 2
}

// DMAC.CTRLA0: DMAC Channel Control A Register (ch_num = 0)
func (o *DMAC_Type) SetCTRLA0_BTSIZE(value uint32) {
	volatile.StoreUint32(&o.CTRLA0.Reg, volatile.LoadUint32(&o.CTRLA0.Reg)&^(0xffff)|value)
}
func (o *DMAC_Type) GetCTRLA0_BTSIZE() uint32 {
	return volatile.LoadUint32(&o.CTRLA0.Reg) & 0xffff
}
func (o *DMAC_Type) SetCTRLA0_SCSIZE(value uint32) {
	volatile.StoreUint32(&o.CTRLA0.Reg, volatile.LoadUint32(&o.CTRLA0.Reg)&^(0x70000)|value<<16)
}
func (o *DMAC_Type) GetCTRLA0_SCSIZE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA0.Reg) & 0x70000) >> 16
}
func (o *DMAC_Type) SetCTRLA0_DCSIZE(value uint32) {
	volatile.StoreUint32(&o.CTRLA0.Reg, volatile.LoadUint32(&o.CTRLA0.Reg)&^(0x700000)|value<<20)
}
func (o *DMAC_Type) GetCTRLA0_DCSIZE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA0.Reg) & 0x700000) >> 20
}
func (o *DMAC_Type) SetCTRLA0_SRC_WIDTH(value uint32) {
	volatile.StoreUint32(&o.CTRLA0.Reg, volatile.LoadUint32(&o.CTRLA0.Reg)&^(0x3000000)|value<<24)
}
func (o *DMAC_Type) GetCTRLA0_SRC_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.CTRLA0.Reg) & 0x3000000) >> 24
}
func (o *DMAC_Type) SetCTRLA0_DST_WIDTH(value uint32) {
	volatile.StoreUint32(&o.CTRLA0.Reg, volatile.LoadUint32(&o.CTRLA0.Reg)&^(0x30000000)|value<<28)
}
func (o *DMAC_Type) GetCTRLA0_DST_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.CTRLA0.Reg) & 0x30000000) >> 28
}
func (o *DMAC_Type) SetCTRLA0_DONE(value uint32) {
	volatile.StoreUint32(&o.CTRLA0.Reg, volatile.LoadUint32(&o.CTRLA0.Reg)&^(0x80000000)|value<<31)
}
func (o *DMAC_Type) GetCTRLA0_DONE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA0.Reg) & 0x80000000) >> 31
}

// DMAC.CTRLB0: DMAC Channel Control B Register (ch_num = 0)
func (o *DMAC_Type) SetCTRLB0_SIF(value uint32) {
	volatile.StoreUint32(&o.CTRLB0.Reg, volatile.LoadUint32(&o.CTRLB0.Reg)&^(0x3)|value)
}
func (o *DMAC_Type) GetCTRLB0_SIF() uint32 {
	return volatile.LoadUint32(&o.CTRLB0.Reg) & 0x3
}
func (o *DMAC_Type) SetCTRLB0_DIF(value uint32) {
	volatile.StoreUint32(&o.CTRLB0.Reg, volatile.LoadUint32(&o.CTRLB0.Reg)&^(0x30)|value<<4)
}
func (o *DMAC_Type) GetCTRLB0_DIF() uint32 {
	return (volatile.LoadUint32(&o.CTRLB0.Reg) & 0x30) >> 4
}
func (o *DMAC_Type) SetCTRLB0_SRC_PIP(value uint32) {
	volatile.StoreUint32(&o.CTRLB0.Reg, volatile.LoadUint32(&o.CTRLB0.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetCTRLB0_SRC_PIP() uint32 {
	return (volatile.LoadUint32(&o.CTRLB0.Reg) & 0x100) >> 8
}
func (o *DMAC_Type) SetCTRLB0_DST_PIP(value uint32) {
	volatile.StoreUint32(&o.CTRLB0.Reg, volatile.LoadUint32(&o.CTRLB0.Reg)&^(0x1000)|value<<12)
}
func (o *DMAC_Type) GetCTRLB0_DST_PIP() uint32 {
	return (volatile.LoadUint32(&o.CTRLB0.Reg) & 0x1000) >> 12
}
func (o *DMAC_Type) SetCTRLB0_SRC_DSCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB0.Reg, volatile.LoadUint32(&o.CTRLB0.Reg)&^(0x10000)|value<<16)
}
func (o *DMAC_Type) GetCTRLB0_SRC_DSCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB0.Reg) & 0x10000) >> 16
}
func (o *DMAC_Type) SetCTRLB0_DST_DSCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB0.Reg, volatile.LoadUint32(&o.CTRLB0.Reg)&^(0x100000)|value<<20)
}
func (o *DMAC_Type) GetCTRLB0_DST_DSCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB0.Reg) & 0x100000) >> 20
}
func (o *DMAC_Type) SetCTRLB0_FC(value uint32) {
	volatile.StoreUint32(&o.CTRLB0.Reg, volatile.LoadUint32(&o.CTRLB0.Reg)&^(0xe00000)|value<<21)
}
func (o *DMAC_Type) GetCTRLB0_FC() uint32 {
	return (volatile.LoadUint32(&o.CTRLB0.Reg) & 0xe00000) >> 21
}
func (o *DMAC_Type) SetCTRLB0_SRC_INCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB0.Reg, volatile.LoadUint32(&o.CTRLB0.Reg)&^(0x3000000)|value<<24)
}
func (o *DMAC_Type) GetCTRLB0_SRC_INCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB0.Reg) & 0x3000000) >> 24
}
func (o *DMAC_Type) SetCTRLB0_DST_INCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB0.Reg, volatile.LoadUint32(&o.CTRLB0.Reg)&^(0x30000000)|value<<28)
}
func (o *DMAC_Type) GetCTRLB0_DST_INCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB0.Reg) & 0x30000000) >> 28
}
func (o *DMAC_Type) SetCTRLB0_IEN(value uint32) {
	volatile.StoreUint32(&o.CTRLB0.Reg, volatile.LoadUint32(&o.CTRLB0.Reg)&^(0x40000000)|value<<30)
}
func (o *DMAC_Type) GetCTRLB0_IEN() uint32 {
	return (volatile.LoadUint32(&o.CTRLB0.Reg) & 0x40000000) >> 30
}
func (o *DMAC_Type) SetCTRLB0_AUTO(value uint32) {
	volatile.StoreUint32(&o.CTRLB0.Reg, volatile.LoadUint32(&o.CTRLB0.Reg)&^(0x80000000)|value<<31)
}
func (o *DMAC_Type) GetCTRLB0_AUTO() uint32 {
	return (volatile.LoadUint32(&o.CTRLB0.Reg) & 0x80000000) >> 31
}

// DMAC.CFG0: DMAC Channel Configuration Register (ch_num = 0)
func (o *DMAC_Type) SetCFG0_SRC_PER(value uint32) {
	volatile.StoreUint32(&o.CFG0.Reg, volatile.LoadUint32(&o.CFG0.Reg)&^(0xf)|value)
}
func (o *DMAC_Type) GetCFG0_SRC_PER() uint32 {
	return volatile.LoadUint32(&o.CFG0.Reg) & 0xf
}
func (o *DMAC_Type) SetCFG0_DST_PER(value uint32) {
	volatile.StoreUint32(&o.CFG0.Reg, volatile.LoadUint32(&o.CFG0.Reg)&^(0xf0)|value<<4)
}
func (o *DMAC_Type) GetCFG0_DST_PER() uint32 {
	return (volatile.LoadUint32(&o.CFG0.Reg) & 0xf0) >> 4
}
func (o *DMAC_Type) SetCFG0_SRC_REP(value uint32) {
	volatile.StoreUint32(&o.CFG0.Reg, volatile.LoadUint32(&o.CFG0.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetCFG0_SRC_REP() uint32 {
	return (volatile.LoadUint32(&o.CFG0.Reg) & 0x100) >> 8
}
func (o *DMAC_Type) SetCFG0_SRC_H2SEL(value uint32) {
	volatile.StoreUint32(&o.CFG0.Reg, volatile.LoadUint32(&o.CFG0.Reg)&^(0x200)|value<<9)
}
func (o *DMAC_Type) GetCFG0_SRC_H2SEL() uint32 {
	return (volatile.LoadUint32(&o.CFG0.Reg) & 0x200) >> 9
}
func (o *DMAC_Type) SetCFG0_DST_REP(value uint32) {
	volatile.StoreUint32(&o.CFG0.Reg, volatile.LoadUint32(&o.CFG0.Reg)&^(0x1000)|value<<12)
}
func (o *DMAC_Type) GetCFG0_DST_REP() uint32 {
	return (volatile.LoadUint32(&o.CFG0.Reg) & 0x1000) >> 12
}
func (o *DMAC_Type) SetCFG0_DST_H2SEL(value uint32) {
	volatile.StoreUint32(&o.CFG0.Reg, volatile.LoadUint32(&o.CFG0.Reg)&^(0x2000)|value<<13)
}
func (o *DMAC_Type) GetCFG0_DST_H2SEL() uint32 {
	return (volatile.LoadUint32(&o.CFG0.Reg) & 0x2000) >> 13
}
func (o *DMAC_Type) SetCFG0_SOD(value uint32) {
	volatile.StoreUint32(&o.CFG0.Reg, volatile.LoadUint32(&o.CFG0.Reg)&^(0x10000)|value<<16)
}
func (o *DMAC_Type) GetCFG0_SOD() uint32 {
	return (volatile.LoadUint32(&o.CFG0.Reg) & 0x10000) >> 16
}
func (o *DMAC_Type) SetCFG0_LOCK_IF(value uint32) {
	volatile.StoreUint32(&o.CFG0.Reg, volatile.LoadUint32(&o.CFG0.Reg)&^(0x100000)|value<<20)
}
func (o *DMAC_Type) GetCFG0_LOCK_IF() uint32 {
	return (volatile.LoadUint32(&o.CFG0.Reg) & 0x100000) >> 20
}
func (o *DMAC_Type) SetCFG0_LOCK_B(value uint32) {
	volatile.StoreUint32(&o.CFG0.Reg, volatile.LoadUint32(&o.CFG0.Reg)&^(0x200000)|value<<21)
}
func (o *DMAC_Type) GetCFG0_LOCK_B() uint32 {
	return (volatile.LoadUint32(&o.CFG0.Reg) & 0x200000) >> 21
}
func (o *DMAC_Type) SetCFG0_LOCK_IF_L(value uint32) {
	volatile.StoreUint32(&o.CFG0.Reg, volatile.LoadUint32(&o.CFG0.Reg)&^(0x400000)|value<<22)
}
func (o *DMAC_Type) GetCFG0_LOCK_IF_L() uint32 {
	return (volatile.LoadUint32(&o.CFG0.Reg) & 0x400000) >> 22
}
func (o *DMAC_Type) SetCFG0_AHB_PROT(value uint32) {
	volatile.StoreUint32(&o.CFG0.Reg, volatile.LoadUint32(&o.CFG0.Reg)&^(0x7000000)|value<<24)
}
func (o *DMAC_Type) GetCFG0_AHB_PROT() uint32 {
	return (volatile.LoadUint32(&o.CFG0.Reg) & 0x7000000) >> 24
}
func (o *DMAC_Type) SetCFG0_FIFOCFG(value uint32) {
	volatile.StoreUint32(&o.CFG0.Reg, volatile.LoadUint32(&o.CFG0.Reg)&^(0x30000000)|value<<28)
}
func (o *DMAC_Type) GetCFG0_FIFOCFG() uint32 {
	return (volatile.LoadUint32(&o.CFG0.Reg) & 0x30000000) >> 28
}

// DMAC.SPIP0: DMAC Channel Source Picture-in-Picture Configuration Register (ch_num = 0)
func (o *DMAC_Type) SetSPIP0_SPIP_HOLE(value uint32) {
	volatile.StoreUint32(&o.SPIP0.Reg, volatile.LoadUint32(&o.SPIP0.Reg)&^(0xffff)|value)
}
func (o *DMAC_Type) GetSPIP0_SPIP_HOLE() uint32 {
	return volatile.LoadUint32(&o.SPIP0.Reg) & 0xffff
}
func (o *DMAC_Type) SetSPIP0_SPIP_BOUNDARY(value uint32) {
	volatile.StoreUint32(&o.SPIP0.Reg, volatile.LoadUint32(&o.SPIP0.Reg)&^(0x3ff0000)|value<<16)
}
func (o *DMAC_Type) GetSPIP0_SPIP_BOUNDARY() uint32 {
	return (volatile.LoadUint32(&o.SPIP0.Reg) & 0x3ff0000) >> 16
}

// DMAC.DPIP0: DMAC Channel Destination Picture-in-Picture Configuration Register (ch_num = 0)
func (o *DMAC_Type) SetDPIP0_DPIP_HOLE(value uint32) {
	volatile.StoreUint32(&o.DPIP0.Reg, volatile.LoadUint32(&o.DPIP0.Reg)&^(0xffff)|value)
}
func (o *DMAC_Type) GetDPIP0_DPIP_HOLE() uint32 {
	return volatile.LoadUint32(&o.DPIP0.Reg) & 0xffff
}
func (o *DMAC_Type) SetDPIP0_DPIP_BOUNDARY(value uint32) {
	volatile.StoreUint32(&o.DPIP0.Reg, volatile.LoadUint32(&o.DPIP0.Reg)&^(0x3ff0000)|value<<16)
}
func (o *DMAC_Type) GetDPIP0_DPIP_BOUNDARY() uint32 {
	return (volatile.LoadUint32(&o.DPIP0.Reg) & 0x3ff0000) >> 16
}

// DMAC.SADDR1: DMAC Channel Source Address Register (ch_num = 1)
func (o *DMAC_Type) SetSADDR1(value uint32) {
	volatile.StoreUint32(&o.SADDR1.Reg, value)
}
func (o *DMAC_Type) GetSADDR1() uint32 {
	return volatile.LoadUint32(&o.SADDR1.Reg)
}

// DMAC.DADDR1: DMAC Channel Destination Address Register (ch_num = 1)
func (o *DMAC_Type) SetDADDR1(value uint32) {
	volatile.StoreUint32(&o.DADDR1.Reg, value)
}
func (o *DMAC_Type) GetDADDR1() uint32 {
	return volatile.LoadUint32(&o.DADDR1.Reg)
}

// DMAC.DSCR1: DMAC Channel Descriptor Address Register (ch_num = 1)
func (o *DMAC_Type) SetDSCR1_DSCR_IF(value uint32) {
	volatile.StoreUint32(&o.DSCR1.Reg, volatile.LoadUint32(&o.DSCR1.Reg)&^(0x3)|value)
}
func (o *DMAC_Type) GetDSCR1_DSCR_IF() uint32 {
	return volatile.LoadUint32(&o.DSCR1.Reg) & 0x3
}
func (o *DMAC_Type) SetDSCR1_DSCR(value uint32) {
	volatile.StoreUint32(&o.DSCR1.Reg, volatile.LoadUint32(&o.DSCR1.Reg)&^(0xfffffffc)|value<<2)
}
func (o *DMAC_Type) GetDSCR1_DSCR() uint32 {
	return (volatile.LoadUint32(&o.DSCR1.Reg) & 0xfffffffc) >> 2
}

// DMAC.CTRLA1: DMAC Channel Control A Register (ch_num = 1)
func (o *DMAC_Type) SetCTRLA1_BTSIZE(value uint32) {
	volatile.StoreUint32(&o.CTRLA1.Reg, volatile.LoadUint32(&o.CTRLA1.Reg)&^(0xffff)|value)
}
func (o *DMAC_Type) GetCTRLA1_BTSIZE() uint32 {
	return volatile.LoadUint32(&o.CTRLA1.Reg) & 0xffff
}
func (o *DMAC_Type) SetCTRLA1_SCSIZE(value uint32) {
	volatile.StoreUint32(&o.CTRLA1.Reg, volatile.LoadUint32(&o.CTRLA1.Reg)&^(0x70000)|value<<16)
}
func (o *DMAC_Type) GetCTRLA1_SCSIZE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA1.Reg) & 0x70000) >> 16
}
func (o *DMAC_Type) SetCTRLA1_DCSIZE(value uint32) {
	volatile.StoreUint32(&o.CTRLA1.Reg, volatile.LoadUint32(&o.CTRLA1.Reg)&^(0x700000)|value<<20)
}
func (o *DMAC_Type) GetCTRLA1_DCSIZE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA1.Reg) & 0x700000) >> 20
}
func (o *DMAC_Type) SetCTRLA1_SRC_WIDTH(value uint32) {
	volatile.StoreUint32(&o.CTRLA1.Reg, volatile.LoadUint32(&o.CTRLA1.Reg)&^(0x3000000)|value<<24)
}
func (o *DMAC_Type) GetCTRLA1_SRC_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.CTRLA1.Reg) & 0x3000000) >> 24
}
func (o *DMAC_Type) SetCTRLA1_DST_WIDTH(value uint32) {
	volatile.StoreUint32(&o.CTRLA1.Reg, volatile.LoadUint32(&o.CTRLA1.Reg)&^(0x30000000)|value<<28)
}
func (o *DMAC_Type) GetCTRLA1_DST_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.CTRLA1.Reg) & 0x30000000) >> 28
}
func (o *DMAC_Type) SetCTRLA1_DONE(value uint32) {
	volatile.StoreUint32(&o.CTRLA1.Reg, volatile.LoadUint32(&o.CTRLA1.Reg)&^(0x80000000)|value<<31)
}
func (o *DMAC_Type) GetCTRLA1_DONE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA1.Reg) & 0x80000000) >> 31
}

// DMAC.CTRLB1: DMAC Channel Control B Register (ch_num = 1)
func (o *DMAC_Type) SetCTRLB1_SIF(value uint32) {
	volatile.StoreUint32(&o.CTRLB1.Reg, volatile.LoadUint32(&o.CTRLB1.Reg)&^(0x3)|value)
}
func (o *DMAC_Type) GetCTRLB1_SIF() uint32 {
	return volatile.LoadUint32(&o.CTRLB1.Reg) & 0x3
}
func (o *DMAC_Type) SetCTRLB1_DIF(value uint32) {
	volatile.StoreUint32(&o.CTRLB1.Reg, volatile.LoadUint32(&o.CTRLB1.Reg)&^(0x30)|value<<4)
}
func (o *DMAC_Type) GetCTRLB1_DIF() uint32 {
	return (volatile.LoadUint32(&o.CTRLB1.Reg) & 0x30) >> 4
}
func (o *DMAC_Type) SetCTRLB1_SRC_PIP(value uint32) {
	volatile.StoreUint32(&o.CTRLB1.Reg, volatile.LoadUint32(&o.CTRLB1.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetCTRLB1_SRC_PIP() uint32 {
	return (volatile.LoadUint32(&o.CTRLB1.Reg) & 0x100) >> 8
}
func (o *DMAC_Type) SetCTRLB1_DST_PIP(value uint32) {
	volatile.StoreUint32(&o.CTRLB1.Reg, volatile.LoadUint32(&o.CTRLB1.Reg)&^(0x1000)|value<<12)
}
func (o *DMAC_Type) GetCTRLB1_DST_PIP() uint32 {
	return (volatile.LoadUint32(&o.CTRLB1.Reg) & 0x1000) >> 12
}
func (o *DMAC_Type) SetCTRLB1_SRC_DSCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB1.Reg, volatile.LoadUint32(&o.CTRLB1.Reg)&^(0x10000)|value<<16)
}
func (o *DMAC_Type) GetCTRLB1_SRC_DSCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB1.Reg) & 0x10000) >> 16
}
func (o *DMAC_Type) SetCTRLB1_DST_DSCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB1.Reg, volatile.LoadUint32(&o.CTRLB1.Reg)&^(0x100000)|value<<20)
}
func (o *DMAC_Type) GetCTRLB1_DST_DSCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB1.Reg) & 0x100000) >> 20
}
func (o *DMAC_Type) SetCTRLB1_FC(value uint32) {
	volatile.StoreUint32(&o.CTRLB1.Reg, volatile.LoadUint32(&o.CTRLB1.Reg)&^(0xe00000)|value<<21)
}
func (o *DMAC_Type) GetCTRLB1_FC() uint32 {
	return (volatile.LoadUint32(&o.CTRLB1.Reg) & 0xe00000) >> 21
}
func (o *DMAC_Type) SetCTRLB1_SRC_INCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB1.Reg, volatile.LoadUint32(&o.CTRLB1.Reg)&^(0x3000000)|value<<24)
}
func (o *DMAC_Type) GetCTRLB1_SRC_INCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB1.Reg) & 0x3000000) >> 24
}
func (o *DMAC_Type) SetCTRLB1_DST_INCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB1.Reg, volatile.LoadUint32(&o.CTRLB1.Reg)&^(0x30000000)|value<<28)
}
func (o *DMAC_Type) GetCTRLB1_DST_INCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB1.Reg) & 0x30000000) >> 28
}
func (o *DMAC_Type) SetCTRLB1_IEN(value uint32) {
	volatile.StoreUint32(&o.CTRLB1.Reg, volatile.LoadUint32(&o.CTRLB1.Reg)&^(0x40000000)|value<<30)
}
func (o *DMAC_Type) GetCTRLB1_IEN() uint32 {
	return (volatile.LoadUint32(&o.CTRLB1.Reg) & 0x40000000) >> 30
}
func (o *DMAC_Type) SetCTRLB1_AUTO(value uint32) {
	volatile.StoreUint32(&o.CTRLB1.Reg, volatile.LoadUint32(&o.CTRLB1.Reg)&^(0x80000000)|value<<31)
}
func (o *DMAC_Type) GetCTRLB1_AUTO() uint32 {
	return (volatile.LoadUint32(&o.CTRLB1.Reg) & 0x80000000) >> 31
}

// DMAC.CFG1: DMAC Channel Configuration Register (ch_num = 1)
func (o *DMAC_Type) SetCFG1_SRC_PER(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0xf)|value)
}
func (o *DMAC_Type) GetCFG1_SRC_PER() uint32 {
	return volatile.LoadUint32(&o.CFG1.Reg) & 0xf
}
func (o *DMAC_Type) SetCFG1_DST_PER(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0xf0)|value<<4)
}
func (o *DMAC_Type) GetCFG1_DST_PER() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0xf0) >> 4
}
func (o *DMAC_Type) SetCFG1_SRC_REP(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetCFG1_SRC_REP() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x100) >> 8
}
func (o *DMAC_Type) SetCFG1_SRC_H2SEL(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x200)|value<<9)
}
func (o *DMAC_Type) GetCFG1_SRC_H2SEL() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x200) >> 9
}
func (o *DMAC_Type) SetCFG1_DST_REP(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x1000)|value<<12)
}
func (o *DMAC_Type) GetCFG1_DST_REP() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x1000) >> 12
}
func (o *DMAC_Type) SetCFG1_DST_H2SEL(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x2000)|value<<13)
}
func (o *DMAC_Type) GetCFG1_DST_H2SEL() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x2000) >> 13
}
func (o *DMAC_Type) SetCFG1_SOD(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x10000)|value<<16)
}
func (o *DMAC_Type) GetCFG1_SOD() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x10000) >> 16
}
func (o *DMAC_Type) SetCFG1_LOCK_IF(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x100000)|value<<20)
}
func (o *DMAC_Type) GetCFG1_LOCK_IF() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x100000) >> 20
}
func (o *DMAC_Type) SetCFG1_LOCK_B(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x200000)|value<<21)
}
func (o *DMAC_Type) GetCFG1_LOCK_B() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x200000) >> 21
}
func (o *DMAC_Type) SetCFG1_LOCK_IF_L(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x400000)|value<<22)
}
func (o *DMAC_Type) GetCFG1_LOCK_IF_L() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x400000) >> 22
}
func (o *DMAC_Type) SetCFG1_AHB_PROT(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x7000000)|value<<24)
}
func (o *DMAC_Type) GetCFG1_AHB_PROT() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x7000000) >> 24
}
func (o *DMAC_Type) SetCFG1_FIFOCFG(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x30000000)|value<<28)
}
func (o *DMAC_Type) GetCFG1_FIFOCFG() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x30000000) >> 28
}

// DMAC.SPIP1: DMAC Channel Source Picture-in-Picture Configuration Register (ch_num = 1)
func (o *DMAC_Type) SetSPIP1_SPIP_HOLE(value uint32) {
	volatile.StoreUint32(&o.SPIP1.Reg, volatile.LoadUint32(&o.SPIP1.Reg)&^(0xffff)|value)
}
func (o *DMAC_Type) GetSPIP1_SPIP_HOLE() uint32 {
	return volatile.LoadUint32(&o.SPIP1.Reg) & 0xffff
}
func (o *DMAC_Type) SetSPIP1_SPIP_BOUNDARY(value uint32) {
	volatile.StoreUint32(&o.SPIP1.Reg, volatile.LoadUint32(&o.SPIP1.Reg)&^(0x3ff0000)|value<<16)
}
func (o *DMAC_Type) GetSPIP1_SPIP_BOUNDARY() uint32 {
	return (volatile.LoadUint32(&o.SPIP1.Reg) & 0x3ff0000) >> 16
}

// DMAC.DPIP1: DMAC Channel Destination Picture-in-Picture Configuration Register (ch_num = 1)
func (o *DMAC_Type) SetDPIP1_DPIP_HOLE(value uint32) {
	volatile.StoreUint32(&o.DPIP1.Reg, volatile.LoadUint32(&o.DPIP1.Reg)&^(0xffff)|value)
}
func (o *DMAC_Type) GetDPIP1_DPIP_HOLE() uint32 {
	return volatile.LoadUint32(&o.DPIP1.Reg) & 0xffff
}
func (o *DMAC_Type) SetDPIP1_DPIP_BOUNDARY(value uint32) {
	volatile.StoreUint32(&o.DPIP1.Reg, volatile.LoadUint32(&o.DPIP1.Reg)&^(0x3ff0000)|value<<16)
}
func (o *DMAC_Type) GetDPIP1_DPIP_BOUNDARY() uint32 {
	return (volatile.LoadUint32(&o.DPIP1.Reg) & 0x3ff0000) >> 16
}

// DMAC.SADDR2: DMAC Channel Source Address Register (ch_num = 2)
func (o *DMAC_Type) SetSADDR2(value uint32) {
	volatile.StoreUint32(&o.SADDR2.Reg, value)
}
func (o *DMAC_Type) GetSADDR2() uint32 {
	return volatile.LoadUint32(&o.SADDR2.Reg)
}

// DMAC.DADDR2: DMAC Channel Destination Address Register (ch_num = 2)
func (o *DMAC_Type) SetDADDR2(value uint32) {
	volatile.StoreUint32(&o.DADDR2.Reg, value)
}
func (o *DMAC_Type) GetDADDR2() uint32 {
	return volatile.LoadUint32(&o.DADDR2.Reg)
}

// DMAC.DSCR2: DMAC Channel Descriptor Address Register (ch_num = 2)
func (o *DMAC_Type) SetDSCR2_DSCR_IF(value uint32) {
	volatile.StoreUint32(&o.DSCR2.Reg, volatile.LoadUint32(&o.DSCR2.Reg)&^(0x3)|value)
}
func (o *DMAC_Type) GetDSCR2_DSCR_IF() uint32 {
	return volatile.LoadUint32(&o.DSCR2.Reg) & 0x3
}
func (o *DMAC_Type) SetDSCR2_DSCR(value uint32) {
	volatile.StoreUint32(&o.DSCR2.Reg, volatile.LoadUint32(&o.DSCR2.Reg)&^(0xfffffffc)|value<<2)
}
func (o *DMAC_Type) GetDSCR2_DSCR() uint32 {
	return (volatile.LoadUint32(&o.DSCR2.Reg) & 0xfffffffc) >> 2
}

// DMAC.CTRLA2: DMAC Channel Control A Register (ch_num = 2)
func (o *DMAC_Type) SetCTRLA2_BTSIZE(value uint32) {
	volatile.StoreUint32(&o.CTRLA2.Reg, volatile.LoadUint32(&o.CTRLA2.Reg)&^(0xffff)|value)
}
func (o *DMAC_Type) GetCTRLA2_BTSIZE() uint32 {
	return volatile.LoadUint32(&o.CTRLA2.Reg) & 0xffff
}
func (o *DMAC_Type) SetCTRLA2_SCSIZE(value uint32) {
	volatile.StoreUint32(&o.CTRLA2.Reg, volatile.LoadUint32(&o.CTRLA2.Reg)&^(0x70000)|value<<16)
}
func (o *DMAC_Type) GetCTRLA2_SCSIZE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA2.Reg) & 0x70000) >> 16
}
func (o *DMAC_Type) SetCTRLA2_DCSIZE(value uint32) {
	volatile.StoreUint32(&o.CTRLA2.Reg, volatile.LoadUint32(&o.CTRLA2.Reg)&^(0x700000)|value<<20)
}
func (o *DMAC_Type) GetCTRLA2_DCSIZE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA2.Reg) & 0x700000) >> 20
}
func (o *DMAC_Type) SetCTRLA2_SRC_WIDTH(value uint32) {
	volatile.StoreUint32(&o.CTRLA2.Reg, volatile.LoadUint32(&o.CTRLA2.Reg)&^(0x3000000)|value<<24)
}
func (o *DMAC_Type) GetCTRLA2_SRC_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.CTRLA2.Reg) & 0x3000000) >> 24
}
func (o *DMAC_Type) SetCTRLA2_DST_WIDTH(value uint32) {
	volatile.StoreUint32(&o.CTRLA2.Reg, volatile.LoadUint32(&o.CTRLA2.Reg)&^(0x30000000)|value<<28)
}
func (o *DMAC_Type) GetCTRLA2_DST_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.CTRLA2.Reg) & 0x30000000) >> 28
}
func (o *DMAC_Type) SetCTRLA2_DONE(value uint32) {
	volatile.StoreUint32(&o.CTRLA2.Reg, volatile.LoadUint32(&o.CTRLA2.Reg)&^(0x80000000)|value<<31)
}
func (o *DMAC_Type) GetCTRLA2_DONE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA2.Reg) & 0x80000000) >> 31
}

// DMAC.CTRLB2: DMAC Channel Control B Register (ch_num = 2)
func (o *DMAC_Type) SetCTRLB2_SIF(value uint32) {
	volatile.StoreUint32(&o.CTRLB2.Reg, volatile.LoadUint32(&o.CTRLB2.Reg)&^(0x3)|value)
}
func (o *DMAC_Type) GetCTRLB2_SIF() uint32 {
	return volatile.LoadUint32(&o.CTRLB2.Reg) & 0x3
}
func (o *DMAC_Type) SetCTRLB2_DIF(value uint32) {
	volatile.StoreUint32(&o.CTRLB2.Reg, volatile.LoadUint32(&o.CTRLB2.Reg)&^(0x30)|value<<4)
}
func (o *DMAC_Type) GetCTRLB2_DIF() uint32 {
	return (volatile.LoadUint32(&o.CTRLB2.Reg) & 0x30) >> 4
}
func (o *DMAC_Type) SetCTRLB2_SRC_PIP(value uint32) {
	volatile.StoreUint32(&o.CTRLB2.Reg, volatile.LoadUint32(&o.CTRLB2.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetCTRLB2_SRC_PIP() uint32 {
	return (volatile.LoadUint32(&o.CTRLB2.Reg) & 0x100) >> 8
}
func (o *DMAC_Type) SetCTRLB2_DST_PIP(value uint32) {
	volatile.StoreUint32(&o.CTRLB2.Reg, volatile.LoadUint32(&o.CTRLB2.Reg)&^(0x1000)|value<<12)
}
func (o *DMAC_Type) GetCTRLB2_DST_PIP() uint32 {
	return (volatile.LoadUint32(&o.CTRLB2.Reg) & 0x1000) >> 12
}
func (o *DMAC_Type) SetCTRLB2_SRC_DSCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB2.Reg, volatile.LoadUint32(&o.CTRLB2.Reg)&^(0x10000)|value<<16)
}
func (o *DMAC_Type) GetCTRLB2_SRC_DSCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB2.Reg) & 0x10000) >> 16
}
func (o *DMAC_Type) SetCTRLB2_DST_DSCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB2.Reg, volatile.LoadUint32(&o.CTRLB2.Reg)&^(0x100000)|value<<20)
}
func (o *DMAC_Type) GetCTRLB2_DST_DSCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB2.Reg) & 0x100000) >> 20
}
func (o *DMAC_Type) SetCTRLB2_FC(value uint32) {
	volatile.StoreUint32(&o.CTRLB2.Reg, volatile.LoadUint32(&o.CTRLB2.Reg)&^(0xe00000)|value<<21)
}
func (o *DMAC_Type) GetCTRLB2_FC() uint32 {
	return (volatile.LoadUint32(&o.CTRLB2.Reg) & 0xe00000) >> 21
}
func (o *DMAC_Type) SetCTRLB2_SRC_INCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB2.Reg, volatile.LoadUint32(&o.CTRLB2.Reg)&^(0x3000000)|value<<24)
}
func (o *DMAC_Type) GetCTRLB2_SRC_INCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB2.Reg) & 0x3000000) >> 24
}
func (o *DMAC_Type) SetCTRLB2_DST_INCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB2.Reg, volatile.LoadUint32(&o.CTRLB2.Reg)&^(0x30000000)|value<<28)
}
func (o *DMAC_Type) GetCTRLB2_DST_INCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB2.Reg) & 0x30000000) >> 28
}
func (o *DMAC_Type) SetCTRLB2_IEN(value uint32) {
	volatile.StoreUint32(&o.CTRLB2.Reg, volatile.LoadUint32(&o.CTRLB2.Reg)&^(0x40000000)|value<<30)
}
func (o *DMAC_Type) GetCTRLB2_IEN() uint32 {
	return (volatile.LoadUint32(&o.CTRLB2.Reg) & 0x40000000) >> 30
}
func (o *DMAC_Type) SetCTRLB2_AUTO(value uint32) {
	volatile.StoreUint32(&o.CTRLB2.Reg, volatile.LoadUint32(&o.CTRLB2.Reg)&^(0x80000000)|value<<31)
}
func (o *DMAC_Type) GetCTRLB2_AUTO() uint32 {
	return (volatile.LoadUint32(&o.CTRLB2.Reg) & 0x80000000) >> 31
}

// DMAC.CFG2: DMAC Channel Configuration Register (ch_num = 2)
func (o *DMAC_Type) SetCFG2_SRC_PER(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0xf)|value)
}
func (o *DMAC_Type) GetCFG2_SRC_PER() uint32 {
	return volatile.LoadUint32(&o.CFG2.Reg) & 0xf
}
func (o *DMAC_Type) SetCFG2_DST_PER(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0xf0)|value<<4)
}
func (o *DMAC_Type) GetCFG2_DST_PER() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0xf0) >> 4
}
func (o *DMAC_Type) SetCFG2_SRC_REP(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetCFG2_SRC_REP() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x100) >> 8
}
func (o *DMAC_Type) SetCFG2_SRC_H2SEL(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x200)|value<<9)
}
func (o *DMAC_Type) GetCFG2_SRC_H2SEL() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x200) >> 9
}
func (o *DMAC_Type) SetCFG2_DST_REP(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x1000)|value<<12)
}
func (o *DMAC_Type) GetCFG2_DST_REP() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x1000) >> 12
}
func (o *DMAC_Type) SetCFG2_DST_H2SEL(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x2000)|value<<13)
}
func (o *DMAC_Type) GetCFG2_DST_H2SEL() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x2000) >> 13
}
func (o *DMAC_Type) SetCFG2_SOD(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x10000)|value<<16)
}
func (o *DMAC_Type) GetCFG2_SOD() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x10000) >> 16
}
func (o *DMAC_Type) SetCFG2_LOCK_IF(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x100000)|value<<20)
}
func (o *DMAC_Type) GetCFG2_LOCK_IF() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x100000) >> 20
}
func (o *DMAC_Type) SetCFG2_LOCK_B(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x200000)|value<<21)
}
func (o *DMAC_Type) GetCFG2_LOCK_B() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x200000) >> 21
}
func (o *DMAC_Type) SetCFG2_LOCK_IF_L(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x400000)|value<<22)
}
func (o *DMAC_Type) GetCFG2_LOCK_IF_L() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x400000) >> 22
}
func (o *DMAC_Type) SetCFG2_AHB_PROT(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x7000000)|value<<24)
}
func (o *DMAC_Type) GetCFG2_AHB_PROT() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x7000000) >> 24
}
func (o *DMAC_Type) SetCFG2_FIFOCFG(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x30000000)|value<<28)
}
func (o *DMAC_Type) GetCFG2_FIFOCFG() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x30000000) >> 28
}

// DMAC.SPIP2: DMAC Channel Source Picture-in-Picture Configuration Register (ch_num = 2)
func (o *DMAC_Type) SetSPIP2_SPIP_HOLE(value uint32) {
	volatile.StoreUint32(&o.SPIP2.Reg, volatile.LoadUint32(&o.SPIP2.Reg)&^(0xffff)|value)
}
func (o *DMAC_Type) GetSPIP2_SPIP_HOLE() uint32 {
	return volatile.LoadUint32(&o.SPIP2.Reg) & 0xffff
}
func (o *DMAC_Type) SetSPIP2_SPIP_BOUNDARY(value uint32) {
	volatile.StoreUint32(&o.SPIP2.Reg, volatile.LoadUint32(&o.SPIP2.Reg)&^(0x3ff0000)|value<<16)
}
func (o *DMAC_Type) GetSPIP2_SPIP_BOUNDARY() uint32 {
	return (volatile.LoadUint32(&o.SPIP2.Reg) & 0x3ff0000) >> 16
}

// DMAC.DPIP2: DMAC Channel Destination Picture-in-Picture Configuration Register (ch_num = 2)
func (o *DMAC_Type) SetDPIP2_DPIP_HOLE(value uint32) {
	volatile.StoreUint32(&o.DPIP2.Reg, volatile.LoadUint32(&o.DPIP2.Reg)&^(0xffff)|value)
}
func (o *DMAC_Type) GetDPIP2_DPIP_HOLE() uint32 {
	return volatile.LoadUint32(&o.DPIP2.Reg) & 0xffff
}
func (o *DMAC_Type) SetDPIP2_DPIP_BOUNDARY(value uint32) {
	volatile.StoreUint32(&o.DPIP2.Reg, volatile.LoadUint32(&o.DPIP2.Reg)&^(0x3ff0000)|value<<16)
}
func (o *DMAC_Type) GetDPIP2_DPIP_BOUNDARY() uint32 {
	return (volatile.LoadUint32(&o.DPIP2.Reg) & 0x3ff0000) >> 16
}

// DMAC.SADDR3: DMAC Channel Source Address Register (ch_num = 3)
func (o *DMAC_Type) SetSADDR3(value uint32) {
	volatile.StoreUint32(&o.SADDR3.Reg, value)
}
func (o *DMAC_Type) GetSADDR3() uint32 {
	return volatile.LoadUint32(&o.SADDR3.Reg)
}

// DMAC.DADDR3: DMAC Channel Destination Address Register (ch_num = 3)
func (o *DMAC_Type) SetDADDR3(value uint32) {
	volatile.StoreUint32(&o.DADDR3.Reg, value)
}
func (o *DMAC_Type) GetDADDR3() uint32 {
	return volatile.LoadUint32(&o.DADDR3.Reg)
}

// DMAC.DSCR3: DMAC Channel Descriptor Address Register (ch_num = 3)
func (o *DMAC_Type) SetDSCR3_DSCR_IF(value uint32) {
	volatile.StoreUint32(&o.DSCR3.Reg, volatile.LoadUint32(&o.DSCR3.Reg)&^(0x3)|value)
}
func (o *DMAC_Type) GetDSCR3_DSCR_IF() uint32 {
	return volatile.LoadUint32(&o.DSCR3.Reg) & 0x3
}
func (o *DMAC_Type) SetDSCR3_DSCR(value uint32) {
	volatile.StoreUint32(&o.DSCR3.Reg, volatile.LoadUint32(&o.DSCR3.Reg)&^(0xfffffffc)|value<<2)
}
func (o *DMAC_Type) GetDSCR3_DSCR() uint32 {
	return (volatile.LoadUint32(&o.DSCR3.Reg) & 0xfffffffc) >> 2
}

// DMAC.CTRLA3: DMAC Channel Control A Register (ch_num = 3)
func (o *DMAC_Type) SetCTRLA3_BTSIZE(value uint32) {
	volatile.StoreUint32(&o.CTRLA3.Reg, volatile.LoadUint32(&o.CTRLA3.Reg)&^(0xffff)|value)
}
func (o *DMAC_Type) GetCTRLA3_BTSIZE() uint32 {
	return volatile.LoadUint32(&o.CTRLA3.Reg) & 0xffff
}
func (o *DMAC_Type) SetCTRLA3_SCSIZE(value uint32) {
	volatile.StoreUint32(&o.CTRLA3.Reg, volatile.LoadUint32(&o.CTRLA3.Reg)&^(0x70000)|value<<16)
}
func (o *DMAC_Type) GetCTRLA3_SCSIZE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA3.Reg) & 0x70000) >> 16
}
func (o *DMAC_Type) SetCTRLA3_DCSIZE(value uint32) {
	volatile.StoreUint32(&o.CTRLA3.Reg, volatile.LoadUint32(&o.CTRLA3.Reg)&^(0x700000)|value<<20)
}
func (o *DMAC_Type) GetCTRLA3_DCSIZE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA3.Reg) & 0x700000) >> 20
}
func (o *DMAC_Type) SetCTRLA3_SRC_WIDTH(value uint32) {
	volatile.StoreUint32(&o.CTRLA3.Reg, volatile.LoadUint32(&o.CTRLA3.Reg)&^(0x3000000)|value<<24)
}
func (o *DMAC_Type) GetCTRLA3_SRC_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.CTRLA3.Reg) & 0x3000000) >> 24
}
func (o *DMAC_Type) SetCTRLA3_DST_WIDTH(value uint32) {
	volatile.StoreUint32(&o.CTRLA3.Reg, volatile.LoadUint32(&o.CTRLA3.Reg)&^(0x30000000)|value<<28)
}
func (o *DMAC_Type) GetCTRLA3_DST_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.CTRLA3.Reg) & 0x30000000) >> 28
}
func (o *DMAC_Type) SetCTRLA3_DONE(value uint32) {
	volatile.StoreUint32(&o.CTRLA3.Reg, volatile.LoadUint32(&o.CTRLA3.Reg)&^(0x80000000)|value<<31)
}
func (o *DMAC_Type) GetCTRLA3_DONE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA3.Reg) & 0x80000000) >> 31
}

// DMAC.CTRLB3: DMAC Channel Control B Register (ch_num = 3)
func (o *DMAC_Type) SetCTRLB3_SIF(value uint32) {
	volatile.StoreUint32(&o.CTRLB3.Reg, volatile.LoadUint32(&o.CTRLB3.Reg)&^(0x3)|value)
}
func (o *DMAC_Type) GetCTRLB3_SIF() uint32 {
	return volatile.LoadUint32(&o.CTRLB3.Reg) & 0x3
}
func (o *DMAC_Type) SetCTRLB3_DIF(value uint32) {
	volatile.StoreUint32(&o.CTRLB3.Reg, volatile.LoadUint32(&o.CTRLB3.Reg)&^(0x30)|value<<4)
}
func (o *DMAC_Type) GetCTRLB3_DIF() uint32 {
	return (volatile.LoadUint32(&o.CTRLB3.Reg) & 0x30) >> 4
}
func (o *DMAC_Type) SetCTRLB3_SRC_PIP(value uint32) {
	volatile.StoreUint32(&o.CTRLB3.Reg, volatile.LoadUint32(&o.CTRLB3.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetCTRLB3_SRC_PIP() uint32 {
	return (volatile.LoadUint32(&o.CTRLB3.Reg) & 0x100) >> 8
}
func (o *DMAC_Type) SetCTRLB3_DST_PIP(value uint32) {
	volatile.StoreUint32(&o.CTRLB3.Reg, volatile.LoadUint32(&o.CTRLB3.Reg)&^(0x1000)|value<<12)
}
func (o *DMAC_Type) GetCTRLB3_DST_PIP() uint32 {
	return (volatile.LoadUint32(&o.CTRLB3.Reg) & 0x1000) >> 12
}
func (o *DMAC_Type) SetCTRLB3_SRC_DSCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB3.Reg, volatile.LoadUint32(&o.CTRLB3.Reg)&^(0x10000)|value<<16)
}
func (o *DMAC_Type) GetCTRLB3_SRC_DSCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB3.Reg) & 0x10000) >> 16
}
func (o *DMAC_Type) SetCTRLB3_DST_DSCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB3.Reg, volatile.LoadUint32(&o.CTRLB3.Reg)&^(0x100000)|value<<20)
}
func (o *DMAC_Type) GetCTRLB3_DST_DSCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB3.Reg) & 0x100000) >> 20
}
func (o *DMAC_Type) SetCTRLB3_FC(value uint32) {
	volatile.StoreUint32(&o.CTRLB3.Reg, volatile.LoadUint32(&o.CTRLB3.Reg)&^(0xe00000)|value<<21)
}
func (o *DMAC_Type) GetCTRLB3_FC() uint32 {
	return (volatile.LoadUint32(&o.CTRLB3.Reg) & 0xe00000) >> 21
}
func (o *DMAC_Type) SetCTRLB3_SRC_INCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB3.Reg, volatile.LoadUint32(&o.CTRLB3.Reg)&^(0x3000000)|value<<24)
}
func (o *DMAC_Type) GetCTRLB3_SRC_INCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB3.Reg) & 0x3000000) >> 24
}
func (o *DMAC_Type) SetCTRLB3_DST_INCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB3.Reg, volatile.LoadUint32(&o.CTRLB3.Reg)&^(0x30000000)|value<<28)
}
func (o *DMAC_Type) GetCTRLB3_DST_INCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB3.Reg) & 0x30000000) >> 28
}
func (o *DMAC_Type) SetCTRLB3_IEN(value uint32) {
	volatile.StoreUint32(&o.CTRLB3.Reg, volatile.LoadUint32(&o.CTRLB3.Reg)&^(0x40000000)|value<<30)
}
func (o *DMAC_Type) GetCTRLB3_IEN() uint32 {
	return (volatile.LoadUint32(&o.CTRLB3.Reg) & 0x40000000) >> 30
}
func (o *DMAC_Type) SetCTRLB3_AUTO(value uint32) {
	volatile.StoreUint32(&o.CTRLB3.Reg, volatile.LoadUint32(&o.CTRLB3.Reg)&^(0x80000000)|value<<31)
}
func (o *DMAC_Type) GetCTRLB3_AUTO() uint32 {
	return (volatile.LoadUint32(&o.CTRLB3.Reg) & 0x80000000) >> 31
}

// DMAC.CFG3: DMAC Channel Configuration Register (ch_num = 3)
func (o *DMAC_Type) SetCFG3_SRC_PER(value uint32) {
	volatile.StoreUint32(&o.CFG3.Reg, volatile.LoadUint32(&o.CFG3.Reg)&^(0xf)|value)
}
func (o *DMAC_Type) GetCFG3_SRC_PER() uint32 {
	return volatile.LoadUint32(&o.CFG3.Reg) & 0xf
}
func (o *DMAC_Type) SetCFG3_DST_PER(value uint32) {
	volatile.StoreUint32(&o.CFG3.Reg, volatile.LoadUint32(&o.CFG3.Reg)&^(0xf0)|value<<4)
}
func (o *DMAC_Type) GetCFG3_DST_PER() uint32 {
	return (volatile.LoadUint32(&o.CFG3.Reg) & 0xf0) >> 4
}
func (o *DMAC_Type) SetCFG3_SRC_REP(value uint32) {
	volatile.StoreUint32(&o.CFG3.Reg, volatile.LoadUint32(&o.CFG3.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetCFG3_SRC_REP() uint32 {
	return (volatile.LoadUint32(&o.CFG3.Reg) & 0x100) >> 8
}
func (o *DMAC_Type) SetCFG3_SRC_H2SEL(value uint32) {
	volatile.StoreUint32(&o.CFG3.Reg, volatile.LoadUint32(&o.CFG3.Reg)&^(0x200)|value<<9)
}
func (o *DMAC_Type) GetCFG3_SRC_H2SEL() uint32 {
	return (volatile.LoadUint32(&o.CFG3.Reg) & 0x200) >> 9
}
func (o *DMAC_Type) SetCFG3_DST_REP(value uint32) {
	volatile.StoreUint32(&o.CFG3.Reg, volatile.LoadUint32(&o.CFG3.Reg)&^(0x1000)|value<<12)
}
func (o *DMAC_Type) GetCFG3_DST_REP() uint32 {
	return (volatile.LoadUint32(&o.CFG3.Reg) & 0x1000) >> 12
}
func (o *DMAC_Type) SetCFG3_DST_H2SEL(value uint32) {
	volatile.StoreUint32(&o.CFG3.Reg, volatile.LoadUint32(&o.CFG3.Reg)&^(0x2000)|value<<13)
}
func (o *DMAC_Type) GetCFG3_DST_H2SEL() uint32 {
	return (volatile.LoadUint32(&o.CFG3.Reg) & 0x2000) >> 13
}
func (o *DMAC_Type) SetCFG3_SOD(value uint32) {
	volatile.StoreUint32(&o.CFG3.Reg, volatile.LoadUint32(&o.CFG3.Reg)&^(0x10000)|value<<16)
}
func (o *DMAC_Type) GetCFG3_SOD() uint32 {
	return (volatile.LoadUint32(&o.CFG3.Reg) & 0x10000) >> 16
}
func (o *DMAC_Type) SetCFG3_LOCK_IF(value uint32) {
	volatile.StoreUint32(&o.CFG3.Reg, volatile.LoadUint32(&o.CFG3.Reg)&^(0x100000)|value<<20)
}
func (o *DMAC_Type) GetCFG3_LOCK_IF() uint32 {
	return (volatile.LoadUint32(&o.CFG3.Reg) & 0x100000) >> 20
}
func (o *DMAC_Type) SetCFG3_LOCK_B(value uint32) {
	volatile.StoreUint32(&o.CFG3.Reg, volatile.LoadUint32(&o.CFG3.Reg)&^(0x200000)|value<<21)
}
func (o *DMAC_Type) GetCFG3_LOCK_B() uint32 {
	return (volatile.LoadUint32(&o.CFG3.Reg) & 0x200000) >> 21
}
func (o *DMAC_Type) SetCFG3_LOCK_IF_L(value uint32) {
	volatile.StoreUint32(&o.CFG3.Reg, volatile.LoadUint32(&o.CFG3.Reg)&^(0x400000)|value<<22)
}
func (o *DMAC_Type) GetCFG3_LOCK_IF_L() uint32 {
	return (volatile.LoadUint32(&o.CFG3.Reg) & 0x400000) >> 22
}
func (o *DMAC_Type) SetCFG3_AHB_PROT(value uint32) {
	volatile.StoreUint32(&o.CFG3.Reg, volatile.LoadUint32(&o.CFG3.Reg)&^(0x7000000)|value<<24)
}
func (o *DMAC_Type) GetCFG3_AHB_PROT() uint32 {
	return (volatile.LoadUint32(&o.CFG3.Reg) & 0x7000000) >> 24
}
func (o *DMAC_Type) SetCFG3_FIFOCFG(value uint32) {
	volatile.StoreUint32(&o.CFG3.Reg, volatile.LoadUint32(&o.CFG3.Reg)&^(0x30000000)|value<<28)
}
func (o *DMAC_Type) GetCFG3_FIFOCFG() uint32 {
	return (volatile.LoadUint32(&o.CFG3.Reg) & 0x30000000) >> 28
}

// DMAC.SPIP3: DMAC Channel Source Picture-in-Picture Configuration Register (ch_num = 3)
func (o *DMAC_Type) SetSPIP3_SPIP_HOLE(value uint32) {
	volatile.StoreUint32(&o.SPIP3.Reg, volatile.LoadUint32(&o.SPIP3.Reg)&^(0xffff)|value)
}
func (o *DMAC_Type) GetSPIP3_SPIP_HOLE() uint32 {
	return volatile.LoadUint32(&o.SPIP3.Reg) & 0xffff
}
func (o *DMAC_Type) SetSPIP3_SPIP_BOUNDARY(value uint32) {
	volatile.StoreUint32(&o.SPIP3.Reg, volatile.LoadUint32(&o.SPIP3.Reg)&^(0x3ff0000)|value<<16)
}
func (o *DMAC_Type) GetSPIP3_SPIP_BOUNDARY() uint32 {
	return (volatile.LoadUint32(&o.SPIP3.Reg) & 0x3ff0000) >> 16
}

// DMAC.DPIP3: DMAC Channel Destination Picture-in-Picture Configuration Register (ch_num = 3)
func (o *DMAC_Type) SetDPIP3_DPIP_HOLE(value uint32) {
	volatile.StoreUint32(&o.DPIP3.Reg, volatile.LoadUint32(&o.DPIP3.Reg)&^(0xffff)|value)
}
func (o *DMAC_Type) GetDPIP3_DPIP_HOLE() uint32 {
	return volatile.LoadUint32(&o.DPIP3.Reg) & 0xffff
}
func (o *DMAC_Type) SetDPIP3_DPIP_BOUNDARY(value uint32) {
	volatile.StoreUint32(&o.DPIP3.Reg, volatile.LoadUint32(&o.DPIP3.Reg)&^(0x3ff0000)|value<<16)
}
func (o *DMAC_Type) GetDPIP3_DPIP_BOUNDARY() uint32 {
	return (volatile.LoadUint32(&o.DPIP3.Reg) & 0x3ff0000) >> 16
}

// DMAC.SADDR4: DMAC Channel Source Address Register (ch_num = 4)
func (o *DMAC_Type) SetSADDR4(value uint32) {
	volatile.StoreUint32(&o.SADDR4.Reg, value)
}
func (o *DMAC_Type) GetSADDR4() uint32 {
	return volatile.LoadUint32(&o.SADDR4.Reg)
}

// DMAC.DADDR4: DMAC Channel Destination Address Register (ch_num = 4)
func (o *DMAC_Type) SetDADDR4(value uint32) {
	volatile.StoreUint32(&o.DADDR4.Reg, value)
}
func (o *DMAC_Type) GetDADDR4() uint32 {
	return volatile.LoadUint32(&o.DADDR4.Reg)
}

// DMAC.DSCR4: DMAC Channel Descriptor Address Register (ch_num = 4)
func (o *DMAC_Type) SetDSCR4_DSCR_IF(value uint32) {
	volatile.StoreUint32(&o.DSCR4.Reg, volatile.LoadUint32(&o.DSCR4.Reg)&^(0x3)|value)
}
func (o *DMAC_Type) GetDSCR4_DSCR_IF() uint32 {
	return volatile.LoadUint32(&o.DSCR4.Reg) & 0x3
}
func (o *DMAC_Type) SetDSCR4_DSCR(value uint32) {
	volatile.StoreUint32(&o.DSCR4.Reg, volatile.LoadUint32(&o.DSCR4.Reg)&^(0xfffffffc)|value<<2)
}
func (o *DMAC_Type) GetDSCR4_DSCR() uint32 {
	return (volatile.LoadUint32(&o.DSCR4.Reg) & 0xfffffffc) >> 2
}

// DMAC.CTRLA4: DMAC Channel Control A Register (ch_num = 4)
func (o *DMAC_Type) SetCTRLA4_BTSIZE(value uint32) {
	volatile.StoreUint32(&o.CTRLA4.Reg, volatile.LoadUint32(&o.CTRLA4.Reg)&^(0xffff)|value)
}
func (o *DMAC_Type) GetCTRLA4_BTSIZE() uint32 {
	return volatile.LoadUint32(&o.CTRLA4.Reg) & 0xffff
}
func (o *DMAC_Type) SetCTRLA4_SCSIZE(value uint32) {
	volatile.StoreUint32(&o.CTRLA4.Reg, volatile.LoadUint32(&o.CTRLA4.Reg)&^(0x70000)|value<<16)
}
func (o *DMAC_Type) GetCTRLA4_SCSIZE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA4.Reg) & 0x70000) >> 16
}
func (o *DMAC_Type) SetCTRLA4_DCSIZE(value uint32) {
	volatile.StoreUint32(&o.CTRLA4.Reg, volatile.LoadUint32(&o.CTRLA4.Reg)&^(0x700000)|value<<20)
}
func (o *DMAC_Type) GetCTRLA4_DCSIZE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA4.Reg) & 0x700000) >> 20
}
func (o *DMAC_Type) SetCTRLA4_SRC_WIDTH(value uint32) {
	volatile.StoreUint32(&o.CTRLA4.Reg, volatile.LoadUint32(&o.CTRLA4.Reg)&^(0x3000000)|value<<24)
}
func (o *DMAC_Type) GetCTRLA4_SRC_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.CTRLA4.Reg) & 0x3000000) >> 24
}
func (o *DMAC_Type) SetCTRLA4_DST_WIDTH(value uint32) {
	volatile.StoreUint32(&o.CTRLA4.Reg, volatile.LoadUint32(&o.CTRLA4.Reg)&^(0x30000000)|value<<28)
}
func (o *DMAC_Type) GetCTRLA4_DST_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.CTRLA4.Reg) & 0x30000000) >> 28
}
func (o *DMAC_Type) SetCTRLA4_DONE(value uint32) {
	volatile.StoreUint32(&o.CTRLA4.Reg, volatile.LoadUint32(&o.CTRLA4.Reg)&^(0x80000000)|value<<31)
}
func (o *DMAC_Type) GetCTRLA4_DONE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA4.Reg) & 0x80000000) >> 31
}

// DMAC.CTRLB4: DMAC Channel Control B Register (ch_num = 4)
func (o *DMAC_Type) SetCTRLB4_SIF(value uint32) {
	volatile.StoreUint32(&o.CTRLB4.Reg, volatile.LoadUint32(&o.CTRLB4.Reg)&^(0x3)|value)
}
func (o *DMAC_Type) GetCTRLB4_SIF() uint32 {
	return volatile.LoadUint32(&o.CTRLB4.Reg) & 0x3
}
func (o *DMAC_Type) SetCTRLB4_DIF(value uint32) {
	volatile.StoreUint32(&o.CTRLB4.Reg, volatile.LoadUint32(&o.CTRLB4.Reg)&^(0x30)|value<<4)
}
func (o *DMAC_Type) GetCTRLB4_DIF() uint32 {
	return (volatile.LoadUint32(&o.CTRLB4.Reg) & 0x30) >> 4
}
func (o *DMAC_Type) SetCTRLB4_SRC_PIP(value uint32) {
	volatile.StoreUint32(&o.CTRLB4.Reg, volatile.LoadUint32(&o.CTRLB4.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetCTRLB4_SRC_PIP() uint32 {
	return (volatile.LoadUint32(&o.CTRLB4.Reg) & 0x100) >> 8
}
func (o *DMAC_Type) SetCTRLB4_DST_PIP(value uint32) {
	volatile.StoreUint32(&o.CTRLB4.Reg, volatile.LoadUint32(&o.CTRLB4.Reg)&^(0x1000)|value<<12)
}
func (o *DMAC_Type) GetCTRLB4_DST_PIP() uint32 {
	return (volatile.LoadUint32(&o.CTRLB4.Reg) & 0x1000) >> 12
}
func (o *DMAC_Type) SetCTRLB4_SRC_DSCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB4.Reg, volatile.LoadUint32(&o.CTRLB4.Reg)&^(0x10000)|value<<16)
}
func (o *DMAC_Type) GetCTRLB4_SRC_DSCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB4.Reg) & 0x10000) >> 16
}
func (o *DMAC_Type) SetCTRLB4_DST_DSCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB4.Reg, volatile.LoadUint32(&o.CTRLB4.Reg)&^(0x100000)|value<<20)
}
func (o *DMAC_Type) GetCTRLB4_DST_DSCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB4.Reg) & 0x100000) >> 20
}
func (o *DMAC_Type) SetCTRLB4_FC(value uint32) {
	volatile.StoreUint32(&o.CTRLB4.Reg, volatile.LoadUint32(&o.CTRLB4.Reg)&^(0xe00000)|value<<21)
}
func (o *DMAC_Type) GetCTRLB4_FC() uint32 {
	return (volatile.LoadUint32(&o.CTRLB4.Reg) & 0xe00000) >> 21
}
func (o *DMAC_Type) SetCTRLB4_SRC_INCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB4.Reg, volatile.LoadUint32(&o.CTRLB4.Reg)&^(0x3000000)|value<<24)
}
func (o *DMAC_Type) GetCTRLB4_SRC_INCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB4.Reg) & 0x3000000) >> 24
}
func (o *DMAC_Type) SetCTRLB4_DST_INCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB4.Reg, volatile.LoadUint32(&o.CTRLB4.Reg)&^(0x30000000)|value<<28)
}
func (o *DMAC_Type) GetCTRLB4_DST_INCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB4.Reg) & 0x30000000) >> 28
}
func (o *DMAC_Type) SetCTRLB4_IEN(value uint32) {
	volatile.StoreUint32(&o.CTRLB4.Reg, volatile.LoadUint32(&o.CTRLB4.Reg)&^(0x40000000)|value<<30)
}
func (o *DMAC_Type) GetCTRLB4_IEN() uint32 {
	return (volatile.LoadUint32(&o.CTRLB4.Reg) & 0x40000000) >> 30
}
func (o *DMAC_Type) SetCTRLB4_AUTO(value uint32) {
	volatile.StoreUint32(&o.CTRLB4.Reg, volatile.LoadUint32(&o.CTRLB4.Reg)&^(0x80000000)|value<<31)
}
func (o *DMAC_Type) GetCTRLB4_AUTO() uint32 {
	return (volatile.LoadUint32(&o.CTRLB4.Reg) & 0x80000000) >> 31
}

// DMAC.CFG4: DMAC Channel Configuration Register (ch_num = 4)
func (o *DMAC_Type) SetCFG4_SRC_PER(value uint32) {
	volatile.StoreUint32(&o.CFG4.Reg, volatile.LoadUint32(&o.CFG4.Reg)&^(0xf)|value)
}
func (o *DMAC_Type) GetCFG4_SRC_PER() uint32 {
	return volatile.LoadUint32(&o.CFG4.Reg) & 0xf
}
func (o *DMAC_Type) SetCFG4_DST_PER(value uint32) {
	volatile.StoreUint32(&o.CFG4.Reg, volatile.LoadUint32(&o.CFG4.Reg)&^(0xf0)|value<<4)
}
func (o *DMAC_Type) GetCFG4_DST_PER() uint32 {
	return (volatile.LoadUint32(&o.CFG4.Reg) & 0xf0) >> 4
}
func (o *DMAC_Type) SetCFG4_SRC_REP(value uint32) {
	volatile.StoreUint32(&o.CFG4.Reg, volatile.LoadUint32(&o.CFG4.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetCFG4_SRC_REP() uint32 {
	return (volatile.LoadUint32(&o.CFG4.Reg) & 0x100) >> 8
}
func (o *DMAC_Type) SetCFG4_SRC_H2SEL(value uint32) {
	volatile.StoreUint32(&o.CFG4.Reg, volatile.LoadUint32(&o.CFG4.Reg)&^(0x200)|value<<9)
}
func (o *DMAC_Type) GetCFG4_SRC_H2SEL() uint32 {
	return (volatile.LoadUint32(&o.CFG4.Reg) & 0x200) >> 9
}
func (o *DMAC_Type) SetCFG4_DST_REP(value uint32) {
	volatile.StoreUint32(&o.CFG4.Reg, volatile.LoadUint32(&o.CFG4.Reg)&^(0x1000)|value<<12)
}
func (o *DMAC_Type) GetCFG4_DST_REP() uint32 {
	return (volatile.LoadUint32(&o.CFG4.Reg) & 0x1000) >> 12
}
func (o *DMAC_Type) SetCFG4_DST_H2SEL(value uint32) {
	volatile.StoreUint32(&o.CFG4.Reg, volatile.LoadUint32(&o.CFG4.Reg)&^(0x2000)|value<<13)
}
func (o *DMAC_Type) GetCFG4_DST_H2SEL() uint32 {
	return (volatile.LoadUint32(&o.CFG4.Reg) & 0x2000) >> 13
}
func (o *DMAC_Type) SetCFG4_SOD(value uint32) {
	volatile.StoreUint32(&o.CFG4.Reg, volatile.LoadUint32(&o.CFG4.Reg)&^(0x10000)|value<<16)
}
func (o *DMAC_Type) GetCFG4_SOD() uint32 {
	return (volatile.LoadUint32(&o.CFG4.Reg) & 0x10000) >> 16
}
func (o *DMAC_Type) SetCFG4_LOCK_IF(value uint32) {
	volatile.StoreUint32(&o.CFG4.Reg, volatile.LoadUint32(&o.CFG4.Reg)&^(0x100000)|value<<20)
}
func (o *DMAC_Type) GetCFG4_LOCK_IF() uint32 {
	return (volatile.LoadUint32(&o.CFG4.Reg) & 0x100000) >> 20
}
func (o *DMAC_Type) SetCFG4_LOCK_B(value uint32) {
	volatile.StoreUint32(&o.CFG4.Reg, volatile.LoadUint32(&o.CFG4.Reg)&^(0x200000)|value<<21)
}
func (o *DMAC_Type) GetCFG4_LOCK_B() uint32 {
	return (volatile.LoadUint32(&o.CFG4.Reg) & 0x200000) >> 21
}
func (o *DMAC_Type) SetCFG4_LOCK_IF_L(value uint32) {
	volatile.StoreUint32(&o.CFG4.Reg, volatile.LoadUint32(&o.CFG4.Reg)&^(0x400000)|value<<22)
}
func (o *DMAC_Type) GetCFG4_LOCK_IF_L() uint32 {
	return (volatile.LoadUint32(&o.CFG4.Reg) & 0x400000) >> 22
}
func (o *DMAC_Type) SetCFG4_AHB_PROT(value uint32) {
	volatile.StoreUint32(&o.CFG4.Reg, volatile.LoadUint32(&o.CFG4.Reg)&^(0x7000000)|value<<24)
}
func (o *DMAC_Type) GetCFG4_AHB_PROT() uint32 {
	return (volatile.LoadUint32(&o.CFG4.Reg) & 0x7000000) >> 24
}
func (o *DMAC_Type) SetCFG4_FIFOCFG(value uint32) {
	volatile.StoreUint32(&o.CFG4.Reg, volatile.LoadUint32(&o.CFG4.Reg)&^(0x30000000)|value<<28)
}
func (o *DMAC_Type) GetCFG4_FIFOCFG() uint32 {
	return (volatile.LoadUint32(&o.CFG4.Reg) & 0x30000000) >> 28
}

// DMAC.SPIP4: DMAC Channel Source Picture-in-Picture Configuration Register (ch_num = 4)
func (o *DMAC_Type) SetSPIP4_SPIP_HOLE(value uint32) {
	volatile.StoreUint32(&o.SPIP4.Reg, volatile.LoadUint32(&o.SPIP4.Reg)&^(0xffff)|value)
}
func (o *DMAC_Type) GetSPIP4_SPIP_HOLE() uint32 {
	return volatile.LoadUint32(&o.SPIP4.Reg) & 0xffff
}
func (o *DMAC_Type) SetSPIP4_SPIP_BOUNDARY(value uint32) {
	volatile.StoreUint32(&o.SPIP4.Reg, volatile.LoadUint32(&o.SPIP4.Reg)&^(0x3ff0000)|value<<16)
}
func (o *DMAC_Type) GetSPIP4_SPIP_BOUNDARY() uint32 {
	return (volatile.LoadUint32(&o.SPIP4.Reg) & 0x3ff0000) >> 16
}

// DMAC.DPIP4: DMAC Channel Destination Picture-in-Picture Configuration Register (ch_num = 4)
func (o *DMAC_Type) SetDPIP4_DPIP_HOLE(value uint32) {
	volatile.StoreUint32(&o.DPIP4.Reg, volatile.LoadUint32(&o.DPIP4.Reg)&^(0xffff)|value)
}
func (o *DMAC_Type) GetDPIP4_DPIP_HOLE() uint32 {
	return volatile.LoadUint32(&o.DPIP4.Reg) & 0xffff
}
func (o *DMAC_Type) SetDPIP4_DPIP_BOUNDARY(value uint32) {
	volatile.StoreUint32(&o.DPIP4.Reg, volatile.LoadUint32(&o.DPIP4.Reg)&^(0x3ff0000)|value<<16)
}
func (o *DMAC_Type) GetDPIP4_DPIP_BOUNDARY() uint32 {
	return (volatile.LoadUint32(&o.DPIP4.Reg) & 0x3ff0000) >> 16
}

// DMAC.SADDR5: DMAC Channel Source Address Register (ch_num = 5)
func (o *DMAC_Type) SetSADDR5(value uint32) {
	volatile.StoreUint32(&o.SADDR5.Reg, value)
}
func (o *DMAC_Type) GetSADDR5() uint32 {
	return volatile.LoadUint32(&o.SADDR5.Reg)
}

// DMAC.DADDR5: DMAC Channel Destination Address Register (ch_num = 5)
func (o *DMAC_Type) SetDADDR5(value uint32) {
	volatile.StoreUint32(&o.DADDR5.Reg, value)
}
func (o *DMAC_Type) GetDADDR5() uint32 {
	return volatile.LoadUint32(&o.DADDR5.Reg)
}

// DMAC.DSCR5: DMAC Channel Descriptor Address Register (ch_num = 5)
func (o *DMAC_Type) SetDSCR5_DSCR_IF(value uint32) {
	volatile.StoreUint32(&o.DSCR5.Reg, volatile.LoadUint32(&o.DSCR5.Reg)&^(0x3)|value)
}
func (o *DMAC_Type) GetDSCR5_DSCR_IF() uint32 {
	return volatile.LoadUint32(&o.DSCR5.Reg) & 0x3
}
func (o *DMAC_Type) SetDSCR5_DSCR(value uint32) {
	volatile.StoreUint32(&o.DSCR5.Reg, volatile.LoadUint32(&o.DSCR5.Reg)&^(0xfffffffc)|value<<2)
}
func (o *DMAC_Type) GetDSCR5_DSCR() uint32 {
	return (volatile.LoadUint32(&o.DSCR5.Reg) & 0xfffffffc) >> 2
}

// DMAC.CTRLA5: DMAC Channel Control A Register (ch_num = 5)
func (o *DMAC_Type) SetCTRLA5_BTSIZE(value uint32) {
	volatile.StoreUint32(&o.CTRLA5.Reg, volatile.LoadUint32(&o.CTRLA5.Reg)&^(0xffff)|value)
}
func (o *DMAC_Type) GetCTRLA5_BTSIZE() uint32 {
	return volatile.LoadUint32(&o.CTRLA5.Reg) & 0xffff
}
func (o *DMAC_Type) SetCTRLA5_SCSIZE(value uint32) {
	volatile.StoreUint32(&o.CTRLA5.Reg, volatile.LoadUint32(&o.CTRLA5.Reg)&^(0x70000)|value<<16)
}
func (o *DMAC_Type) GetCTRLA5_SCSIZE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA5.Reg) & 0x70000) >> 16
}
func (o *DMAC_Type) SetCTRLA5_DCSIZE(value uint32) {
	volatile.StoreUint32(&o.CTRLA5.Reg, volatile.LoadUint32(&o.CTRLA5.Reg)&^(0x700000)|value<<20)
}
func (o *DMAC_Type) GetCTRLA5_DCSIZE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA5.Reg) & 0x700000) >> 20
}
func (o *DMAC_Type) SetCTRLA5_SRC_WIDTH(value uint32) {
	volatile.StoreUint32(&o.CTRLA5.Reg, volatile.LoadUint32(&o.CTRLA5.Reg)&^(0x3000000)|value<<24)
}
func (o *DMAC_Type) GetCTRLA5_SRC_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.CTRLA5.Reg) & 0x3000000) >> 24
}
func (o *DMAC_Type) SetCTRLA5_DST_WIDTH(value uint32) {
	volatile.StoreUint32(&o.CTRLA5.Reg, volatile.LoadUint32(&o.CTRLA5.Reg)&^(0x30000000)|value<<28)
}
func (o *DMAC_Type) GetCTRLA5_DST_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.CTRLA5.Reg) & 0x30000000) >> 28
}
func (o *DMAC_Type) SetCTRLA5_DONE(value uint32) {
	volatile.StoreUint32(&o.CTRLA5.Reg, volatile.LoadUint32(&o.CTRLA5.Reg)&^(0x80000000)|value<<31)
}
func (o *DMAC_Type) GetCTRLA5_DONE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA5.Reg) & 0x80000000) >> 31
}

// DMAC.CTRLB5: DMAC Channel Control B Register (ch_num = 5)
func (o *DMAC_Type) SetCTRLB5_SIF(value uint32) {
	volatile.StoreUint32(&o.CTRLB5.Reg, volatile.LoadUint32(&o.CTRLB5.Reg)&^(0x3)|value)
}
func (o *DMAC_Type) GetCTRLB5_SIF() uint32 {
	return volatile.LoadUint32(&o.CTRLB5.Reg) & 0x3
}
func (o *DMAC_Type) SetCTRLB5_DIF(value uint32) {
	volatile.StoreUint32(&o.CTRLB5.Reg, volatile.LoadUint32(&o.CTRLB5.Reg)&^(0x30)|value<<4)
}
func (o *DMAC_Type) GetCTRLB5_DIF() uint32 {
	return (volatile.LoadUint32(&o.CTRLB5.Reg) & 0x30) >> 4
}
func (o *DMAC_Type) SetCTRLB5_SRC_PIP(value uint32) {
	volatile.StoreUint32(&o.CTRLB5.Reg, volatile.LoadUint32(&o.CTRLB5.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetCTRLB5_SRC_PIP() uint32 {
	return (volatile.LoadUint32(&o.CTRLB5.Reg) & 0x100) >> 8
}
func (o *DMAC_Type) SetCTRLB5_DST_PIP(value uint32) {
	volatile.StoreUint32(&o.CTRLB5.Reg, volatile.LoadUint32(&o.CTRLB5.Reg)&^(0x1000)|value<<12)
}
func (o *DMAC_Type) GetCTRLB5_DST_PIP() uint32 {
	return (volatile.LoadUint32(&o.CTRLB5.Reg) & 0x1000) >> 12
}
func (o *DMAC_Type) SetCTRLB5_SRC_DSCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB5.Reg, volatile.LoadUint32(&o.CTRLB5.Reg)&^(0x10000)|value<<16)
}
func (o *DMAC_Type) GetCTRLB5_SRC_DSCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB5.Reg) & 0x10000) >> 16
}
func (o *DMAC_Type) SetCTRLB5_DST_DSCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB5.Reg, volatile.LoadUint32(&o.CTRLB5.Reg)&^(0x100000)|value<<20)
}
func (o *DMAC_Type) GetCTRLB5_DST_DSCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB5.Reg) & 0x100000) >> 20
}
func (o *DMAC_Type) SetCTRLB5_FC(value uint32) {
	volatile.StoreUint32(&o.CTRLB5.Reg, volatile.LoadUint32(&o.CTRLB5.Reg)&^(0xe00000)|value<<21)
}
func (o *DMAC_Type) GetCTRLB5_FC() uint32 {
	return (volatile.LoadUint32(&o.CTRLB5.Reg) & 0xe00000) >> 21
}
func (o *DMAC_Type) SetCTRLB5_SRC_INCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB5.Reg, volatile.LoadUint32(&o.CTRLB5.Reg)&^(0x3000000)|value<<24)
}
func (o *DMAC_Type) GetCTRLB5_SRC_INCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB5.Reg) & 0x3000000) >> 24
}
func (o *DMAC_Type) SetCTRLB5_DST_INCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB5.Reg, volatile.LoadUint32(&o.CTRLB5.Reg)&^(0x30000000)|value<<28)
}
func (o *DMAC_Type) GetCTRLB5_DST_INCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB5.Reg) & 0x30000000) >> 28
}
func (o *DMAC_Type) SetCTRLB5_IEN(value uint32) {
	volatile.StoreUint32(&o.CTRLB5.Reg, volatile.LoadUint32(&o.CTRLB5.Reg)&^(0x40000000)|value<<30)
}
func (o *DMAC_Type) GetCTRLB5_IEN() uint32 {
	return (volatile.LoadUint32(&o.CTRLB5.Reg) & 0x40000000) >> 30
}
func (o *DMAC_Type) SetCTRLB5_AUTO(value uint32) {
	volatile.StoreUint32(&o.CTRLB5.Reg, volatile.LoadUint32(&o.CTRLB5.Reg)&^(0x80000000)|value<<31)
}
func (o *DMAC_Type) GetCTRLB5_AUTO() uint32 {
	return (volatile.LoadUint32(&o.CTRLB5.Reg) & 0x80000000) >> 31
}

// DMAC.CFG5: DMAC Channel Configuration Register (ch_num = 5)
func (o *DMAC_Type) SetCFG5_SRC_PER(value uint32) {
	volatile.StoreUint32(&o.CFG5.Reg, volatile.LoadUint32(&o.CFG5.Reg)&^(0xf)|value)
}
func (o *DMAC_Type) GetCFG5_SRC_PER() uint32 {
	return volatile.LoadUint32(&o.CFG5.Reg) & 0xf
}
func (o *DMAC_Type) SetCFG5_DST_PER(value uint32) {
	volatile.StoreUint32(&o.CFG5.Reg, volatile.LoadUint32(&o.CFG5.Reg)&^(0xf0)|value<<4)
}
func (o *DMAC_Type) GetCFG5_DST_PER() uint32 {
	return (volatile.LoadUint32(&o.CFG5.Reg) & 0xf0) >> 4
}
func (o *DMAC_Type) SetCFG5_SRC_REP(value uint32) {
	volatile.StoreUint32(&o.CFG5.Reg, volatile.LoadUint32(&o.CFG5.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetCFG5_SRC_REP() uint32 {
	return (volatile.LoadUint32(&o.CFG5.Reg) & 0x100) >> 8
}
func (o *DMAC_Type) SetCFG5_SRC_H2SEL(value uint32) {
	volatile.StoreUint32(&o.CFG5.Reg, volatile.LoadUint32(&o.CFG5.Reg)&^(0x200)|value<<9)
}
func (o *DMAC_Type) GetCFG5_SRC_H2SEL() uint32 {
	return (volatile.LoadUint32(&o.CFG5.Reg) & 0x200) >> 9
}
func (o *DMAC_Type) SetCFG5_DST_REP(value uint32) {
	volatile.StoreUint32(&o.CFG5.Reg, volatile.LoadUint32(&o.CFG5.Reg)&^(0x1000)|value<<12)
}
func (o *DMAC_Type) GetCFG5_DST_REP() uint32 {
	return (volatile.LoadUint32(&o.CFG5.Reg) & 0x1000) >> 12
}
func (o *DMAC_Type) SetCFG5_DST_H2SEL(value uint32) {
	volatile.StoreUint32(&o.CFG5.Reg, volatile.LoadUint32(&o.CFG5.Reg)&^(0x2000)|value<<13)
}
func (o *DMAC_Type) GetCFG5_DST_H2SEL() uint32 {
	return (volatile.LoadUint32(&o.CFG5.Reg) & 0x2000) >> 13
}
func (o *DMAC_Type) SetCFG5_SOD(value uint32) {
	volatile.StoreUint32(&o.CFG5.Reg, volatile.LoadUint32(&o.CFG5.Reg)&^(0x10000)|value<<16)
}
func (o *DMAC_Type) GetCFG5_SOD() uint32 {
	return (volatile.LoadUint32(&o.CFG5.Reg) & 0x10000) >> 16
}
func (o *DMAC_Type) SetCFG5_LOCK_IF(value uint32) {
	volatile.StoreUint32(&o.CFG5.Reg, volatile.LoadUint32(&o.CFG5.Reg)&^(0x100000)|value<<20)
}
func (o *DMAC_Type) GetCFG5_LOCK_IF() uint32 {
	return (volatile.LoadUint32(&o.CFG5.Reg) & 0x100000) >> 20
}
func (o *DMAC_Type) SetCFG5_LOCK_B(value uint32) {
	volatile.StoreUint32(&o.CFG5.Reg, volatile.LoadUint32(&o.CFG5.Reg)&^(0x200000)|value<<21)
}
func (o *DMAC_Type) GetCFG5_LOCK_B() uint32 {
	return (volatile.LoadUint32(&o.CFG5.Reg) & 0x200000) >> 21
}
func (o *DMAC_Type) SetCFG5_LOCK_IF_L(value uint32) {
	volatile.StoreUint32(&o.CFG5.Reg, volatile.LoadUint32(&o.CFG5.Reg)&^(0x400000)|value<<22)
}
func (o *DMAC_Type) GetCFG5_LOCK_IF_L() uint32 {
	return (volatile.LoadUint32(&o.CFG5.Reg) & 0x400000) >> 22
}
func (o *DMAC_Type) SetCFG5_AHB_PROT(value uint32) {
	volatile.StoreUint32(&o.CFG5.Reg, volatile.LoadUint32(&o.CFG5.Reg)&^(0x7000000)|value<<24)
}
func (o *DMAC_Type) GetCFG5_AHB_PROT() uint32 {
	return (volatile.LoadUint32(&o.CFG5.Reg) & 0x7000000) >> 24
}
func (o *DMAC_Type) SetCFG5_FIFOCFG(value uint32) {
	volatile.StoreUint32(&o.CFG5.Reg, volatile.LoadUint32(&o.CFG5.Reg)&^(0x30000000)|value<<28)
}
func (o *DMAC_Type) GetCFG5_FIFOCFG() uint32 {
	return (volatile.LoadUint32(&o.CFG5.Reg) & 0x30000000) >> 28
}

// DMAC.SPIP5: DMAC Channel Source Picture-in-Picture Configuration Register (ch_num = 5)
func (o *DMAC_Type) SetSPIP5_SPIP_HOLE(value uint32) {
	volatile.StoreUint32(&o.SPIP5.Reg, volatile.LoadUint32(&o.SPIP5.Reg)&^(0xffff)|value)
}
func (o *DMAC_Type) GetSPIP5_SPIP_HOLE() uint32 {
	return volatile.LoadUint32(&o.SPIP5.Reg) & 0xffff
}
func (o *DMAC_Type) SetSPIP5_SPIP_BOUNDARY(value uint32) {
	volatile.StoreUint32(&o.SPIP5.Reg, volatile.LoadUint32(&o.SPIP5.Reg)&^(0x3ff0000)|value<<16)
}
func (o *DMAC_Type) GetSPIP5_SPIP_BOUNDARY() uint32 {
	return (volatile.LoadUint32(&o.SPIP5.Reg) & 0x3ff0000) >> 16
}

// DMAC.DPIP5: DMAC Channel Destination Picture-in-Picture Configuration Register (ch_num = 5)
func (o *DMAC_Type) SetDPIP5_DPIP_HOLE(value uint32) {
	volatile.StoreUint32(&o.DPIP5.Reg, volatile.LoadUint32(&o.DPIP5.Reg)&^(0xffff)|value)
}
func (o *DMAC_Type) GetDPIP5_DPIP_HOLE() uint32 {
	return volatile.LoadUint32(&o.DPIP5.Reg) & 0xffff
}
func (o *DMAC_Type) SetDPIP5_DPIP_BOUNDARY(value uint32) {
	volatile.StoreUint32(&o.DPIP5.Reg, volatile.LoadUint32(&o.DPIP5.Reg)&^(0x3ff0000)|value<<16)
}
func (o *DMAC_Type) GetDPIP5_DPIP_BOUNDARY() uint32 {
	return (volatile.LoadUint32(&o.DPIP5.Reg) & 0x3ff0000) >> 16
}

// DMAC.SADDR6: DMAC Channel Source Address Register (ch_num = 6)
func (o *DMAC_Type) SetSADDR6(value uint32) {
	volatile.StoreUint32(&o.SADDR6.Reg, value)
}
func (o *DMAC_Type) GetSADDR6() uint32 {
	return volatile.LoadUint32(&o.SADDR6.Reg)
}

// DMAC.DADDR6: DMAC Channel Destination Address Register (ch_num = 6)
func (o *DMAC_Type) SetDADDR6(value uint32) {
	volatile.StoreUint32(&o.DADDR6.Reg, value)
}
func (o *DMAC_Type) GetDADDR6() uint32 {
	return volatile.LoadUint32(&o.DADDR6.Reg)
}

// DMAC.DSCR6: DMAC Channel Descriptor Address Register (ch_num = 6)
func (o *DMAC_Type) SetDSCR6_DSCR_IF(value uint32) {
	volatile.StoreUint32(&o.DSCR6.Reg, volatile.LoadUint32(&o.DSCR6.Reg)&^(0x3)|value)
}
func (o *DMAC_Type) GetDSCR6_DSCR_IF() uint32 {
	return volatile.LoadUint32(&o.DSCR6.Reg) & 0x3
}
func (o *DMAC_Type) SetDSCR6_DSCR(value uint32) {
	volatile.StoreUint32(&o.DSCR6.Reg, volatile.LoadUint32(&o.DSCR6.Reg)&^(0xfffffffc)|value<<2)
}
func (o *DMAC_Type) GetDSCR6_DSCR() uint32 {
	return (volatile.LoadUint32(&o.DSCR6.Reg) & 0xfffffffc) >> 2
}

// DMAC.CTRLA6: DMAC Channel Control A Register (ch_num = 6)
func (o *DMAC_Type) SetCTRLA6_BTSIZE(value uint32) {
	volatile.StoreUint32(&o.CTRLA6.Reg, volatile.LoadUint32(&o.CTRLA6.Reg)&^(0xffff)|value)
}
func (o *DMAC_Type) GetCTRLA6_BTSIZE() uint32 {
	return volatile.LoadUint32(&o.CTRLA6.Reg) & 0xffff
}
func (o *DMAC_Type) SetCTRLA6_SCSIZE(value uint32) {
	volatile.StoreUint32(&o.CTRLA6.Reg, volatile.LoadUint32(&o.CTRLA6.Reg)&^(0x70000)|value<<16)
}
func (o *DMAC_Type) GetCTRLA6_SCSIZE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA6.Reg) & 0x70000) >> 16
}
func (o *DMAC_Type) SetCTRLA6_DCSIZE(value uint32) {
	volatile.StoreUint32(&o.CTRLA6.Reg, volatile.LoadUint32(&o.CTRLA6.Reg)&^(0x700000)|value<<20)
}
func (o *DMAC_Type) GetCTRLA6_DCSIZE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA6.Reg) & 0x700000) >> 20
}
func (o *DMAC_Type) SetCTRLA6_SRC_WIDTH(value uint32) {
	volatile.StoreUint32(&o.CTRLA6.Reg, volatile.LoadUint32(&o.CTRLA6.Reg)&^(0x3000000)|value<<24)
}
func (o *DMAC_Type) GetCTRLA6_SRC_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.CTRLA6.Reg) & 0x3000000) >> 24
}
func (o *DMAC_Type) SetCTRLA6_DST_WIDTH(value uint32) {
	volatile.StoreUint32(&o.CTRLA6.Reg, volatile.LoadUint32(&o.CTRLA6.Reg)&^(0x30000000)|value<<28)
}
func (o *DMAC_Type) GetCTRLA6_DST_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.CTRLA6.Reg) & 0x30000000) >> 28
}
func (o *DMAC_Type) SetCTRLA6_DONE(value uint32) {
	volatile.StoreUint32(&o.CTRLA6.Reg, volatile.LoadUint32(&o.CTRLA6.Reg)&^(0x80000000)|value<<31)
}
func (o *DMAC_Type) GetCTRLA6_DONE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA6.Reg) & 0x80000000) >> 31
}

// DMAC.CTRLB6: DMAC Channel Control B Register (ch_num = 6)
func (o *DMAC_Type) SetCTRLB6_SIF(value uint32) {
	volatile.StoreUint32(&o.CTRLB6.Reg, volatile.LoadUint32(&o.CTRLB6.Reg)&^(0x3)|value)
}
func (o *DMAC_Type) GetCTRLB6_SIF() uint32 {
	return volatile.LoadUint32(&o.CTRLB6.Reg) & 0x3
}
func (o *DMAC_Type) SetCTRLB6_DIF(value uint32) {
	volatile.StoreUint32(&o.CTRLB6.Reg, volatile.LoadUint32(&o.CTRLB6.Reg)&^(0x30)|value<<4)
}
func (o *DMAC_Type) GetCTRLB6_DIF() uint32 {
	return (volatile.LoadUint32(&o.CTRLB6.Reg) & 0x30) >> 4
}
func (o *DMAC_Type) SetCTRLB6_SRC_PIP(value uint32) {
	volatile.StoreUint32(&o.CTRLB6.Reg, volatile.LoadUint32(&o.CTRLB6.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetCTRLB6_SRC_PIP() uint32 {
	return (volatile.LoadUint32(&o.CTRLB6.Reg) & 0x100) >> 8
}
func (o *DMAC_Type) SetCTRLB6_DST_PIP(value uint32) {
	volatile.StoreUint32(&o.CTRLB6.Reg, volatile.LoadUint32(&o.CTRLB6.Reg)&^(0x1000)|value<<12)
}
func (o *DMAC_Type) GetCTRLB6_DST_PIP() uint32 {
	return (volatile.LoadUint32(&o.CTRLB6.Reg) & 0x1000) >> 12
}
func (o *DMAC_Type) SetCTRLB6_SRC_DSCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB6.Reg, volatile.LoadUint32(&o.CTRLB6.Reg)&^(0x10000)|value<<16)
}
func (o *DMAC_Type) GetCTRLB6_SRC_DSCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB6.Reg) & 0x10000) >> 16
}
func (o *DMAC_Type) SetCTRLB6_DST_DSCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB6.Reg, volatile.LoadUint32(&o.CTRLB6.Reg)&^(0x100000)|value<<20)
}
func (o *DMAC_Type) GetCTRLB6_DST_DSCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB6.Reg) & 0x100000) >> 20
}
func (o *DMAC_Type) SetCTRLB6_FC(value uint32) {
	volatile.StoreUint32(&o.CTRLB6.Reg, volatile.LoadUint32(&o.CTRLB6.Reg)&^(0xe00000)|value<<21)
}
func (o *DMAC_Type) GetCTRLB6_FC() uint32 {
	return (volatile.LoadUint32(&o.CTRLB6.Reg) & 0xe00000) >> 21
}
func (o *DMAC_Type) SetCTRLB6_SRC_INCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB6.Reg, volatile.LoadUint32(&o.CTRLB6.Reg)&^(0x3000000)|value<<24)
}
func (o *DMAC_Type) GetCTRLB6_SRC_INCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB6.Reg) & 0x3000000) >> 24
}
func (o *DMAC_Type) SetCTRLB6_DST_INCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB6.Reg, volatile.LoadUint32(&o.CTRLB6.Reg)&^(0x30000000)|value<<28)
}
func (o *DMAC_Type) GetCTRLB6_DST_INCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB6.Reg) & 0x30000000) >> 28
}
func (o *DMAC_Type) SetCTRLB6_IEN(value uint32) {
	volatile.StoreUint32(&o.CTRLB6.Reg, volatile.LoadUint32(&o.CTRLB6.Reg)&^(0x40000000)|value<<30)
}
func (o *DMAC_Type) GetCTRLB6_IEN() uint32 {
	return (volatile.LoadUint32(&o.CTRLB6.Reg) & 0x40000000) >> 30
}
func (o *DMAC_Type) SetCTRLB6_AUTO(value uint32) {
	volatile.StoreUint32(&o.CTRLB6.Reg, volatile.LoadUint32(&o.CTRLB6.Reg)&^(0x80000000)|value<<31)
}
func (o *DMAC_Type) GetCTRLB6_AUTO() uint32 {
	return (volatile.LoadUint32(&o.CTRLB6.Reg) & 0x80000000) >> 31
}

// DMAC.CFG6: DMAC Channel Configuration Register (ch_num = 6)
func (o *DMAC_Type) SetCFG6_SRC_PER(value uint32) {
	volatile.StoreUint32(&o.CFG6.Reg, volatile.LoadUint32(&o.CFG6.Reg)&^(0xf)|value)
}
func (o *DMAC_Type) GetCFG6_SRC_PER() uint32 {
	return volatile.LoadUint32(&o.CFG6.Reg) & 0xf
}
func (o *DMAC_Type) SetCFG6_DST_PER(value uint32) {
	volatile.StoreUint32(&o.CFG6.Reg, volatile.LoadUint32(&o.CFG6.Reg)&^(0xf0)|value<<4)
}
func (o *DMAC_Type) GetCFG6_DST_PER() uint32 {
	return (volatile.LoadUint32(&o.CFG6.Reg) & 0xf0) >> 4
}
func (o *DMAC_Type) SetCFG6_SRC_REP(value uint32) {
	volatile.StoreUint32(&o.CFG6.Reg, volatile.LoadUint32(&o.CFG6.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetCFG6_SRC_REP() uint32 {
	return (volatile.LoadUint32(&o.CFG6.Reg) & 0x100) >> 8
}
func (o *DMAC_Type) SetCFG6_SRC_H2SEL(value uint32) {
	volatile.StoreUint32(&o.CFG6.Reg, volatile.LoadUint32(&o.CFG6.Reg)&^(0x200)|value<<9)
}
func (o *DMAC_Type) GetCFG6_SRC_H2SEL() uint32 {
	return (volatile.LoadUint32(&o.CFG6.Reg) & 0x200) >> 9
}
func (o *DMAC_Type) SetCFG6_DST_REP(value uint32) {
	volatile.StoreUint32(&o.CFG6.Reg, volatile.LoadUint32(&o.CFG6.Reg)&^(0x1000)|value<<12)
}
func (o *DMAC_Type) GetCFG6_DST_REP() uint32 {
	return (volatile.LoadUint32(&o.CFG6.Reg) & 0x1000) >> 12
}
func (o *DMAC_Type) SetCFG6_DST_H2SEL(value uint32) {
	volatile.StoreUint32(&o.CFG6.Reg, volatile.LoadUint32(&o.CFG6.Reg)&^(0x2000)|value<<13)
}
func (o *DMAC_Type) GetCFG6_DST_H2SEL() uint32 {
	return (volatile.LoadUint32(&o.CFG6.Reg) & 0x2000) >> 13
}
func (o *DMAC_Type) SetCFG6_SOD(value uint32) {
	volatile.StoreUint32(&o.CFG6.Reg, volatile.LoadUint32(&o.CFG6.Reg)&^(0x10000)|value<<16)
}
func (o *DMAC_Type) GetCFG6_SOD() uint32 {
	return (volatile.LoadUint32(&o.CFG6.Reg) & 0x10000) >> 16
}
func (o *DMAC_Type) SetCFG6_LOCK_IF(value uint32) {
	volatile.StoreUint32(&o.CFG6.Reg, volatile.LoadUint32(&o.CFG6.Reg)&^(0x100000)|value<<20)
}
func (o *DMAC_Type) GetCFG6_LOCK_IF() uint32 {
	return (volatile.LoadUint32(&o.CFG6.Reg) & 0x100000) >> 20
}
func (o *DMAC_Type) SetCFG6_LOCK_B(value uint32) {
	volatile.StoreUint32(&o.CFG6.Reg, volatile.LoadUint32(&o.CFG6.Reg)&^(0x200000)|value<<21)
}
func (o *DMAC_Type) GetCFG6_LOCK_B() uint32 {
	return (volatile.LoadUint32(&o.CFG6.Reg) & 0x200000) >> 21
}
func (o *DMAC_Type) SetCFG6_LOCK_IF_L(value uint32) {
	volatile.StoreUint32(&o.CFG6.Reg, volatile.LoadUint32(&o.CFG6.Reg)&^(0x400000)|value<<22)
}
func (o *DMAC_Type) GetCFG6_LOCK_IF_L() uint32 {
	return (volatile.LoadUint32(&o.CFG6.Reg) & 0x400000) >> 22
}
func (o *DMAC_Type) SetCFG6_AHB_PROT(value uint32) {
	volatile.StoreUint32(&o.CFG6.Reg, volatile.LoadUint32(&o.CFG6.Reg)&^(0x7000000)|value<<24)
}
func (o *DMAC_Type) GetCFG6_AHB_PROT() uint32 {
	return (volatile.LoadUint32(&o.CFG6.Reg) & 0x7000000) >> 24
}
func (o *DMAC_Type) SetCFG6_FIFOCFG(value uint32) {
	volatile.StoreUint32(&o.CFG6.Reg, volatile.LoadUint32(&o.CFG6.Reg)&^(0x30000000)|value<<28)
}
func (o *DMAC_Type) GetCFG6_FIFOCFG() uint32 {
	return (volatile.LoadUint32(&o.CFG6.Reg) & 0x30000000) >> 28
}

// DMAC.SPIP6: DMAC Channel Source Picture-in-Picture Configuration Register (ch_num = 6)
func (o *DMAC_Type) SetSPIP6_SPIP_HOLE(value uint32) {
	volatile.StoreUint32(&o.SPIP6.Reg, volatile.LoadUint32(&o.SPIP6.Reg)&^(0xffff)|value)
}
func (o *DMAC_Type) GetSPIP6_SPIP_HOLE() uint32 {
	return volatile.LoadUint32(&o.SPIP6.Reg) & 0xffff
}
func (o *DMAC_Type) SetSPIP6_SPIP_BOUNDARY(value uint32) {
	volatile.StoreUint32(&o.SPIP6.Reg, volatile.LoadUint32(&o.SPIP6.Reg)&^(0x3ff0000)|value<<16)
}
func (o *DMAC_Type) GetSPIP6_SPIP_BOUNDARY() uint32 {
	return (volatile.LoadUint32(&o.SPIP6.Reg) & 0x3ff0000) >> 16
}

// DMAC.DPIP6: DMAC Channel Destination Picture-in-Picture Configuration Register (ch_num = 6)
func (o *DMAC_Type) SetDPIP6_DPIP_HOLE(value uint32) {
	volatile.StoreUint32(&o.DPIP6.Reg, volatile.LoadUint32(&o.DPIP6.Reg)&^(0xffff)|value)
}
func (o *DMAC_Type) GetDPIP6_DPIP_HOLE() uint32 {
	return volatile.LoadUint32(&o.DPIP6.Reg) & 0xffff
}
func (o *DMAC_Type) SetDPIP6_DPIP_BOUNDARY(value uint32) {
	volatile.StoreUint32(&o.DPIP6.Reg, volatile.LoadUint32(&o.DPIP6.Reg)&^(0x3ff0000)|value<<16)
}
func (o *DMAC_Type) GetDPIP6_DPIP_BOUNDARY() uint32 {
	return (volatile.LoadUint32(&o.DPIP6.Reg) & 0x3ff0000) >> 16
}

// DMAC.SADDR7: DMAC Channel Source Address Register (ch_num = 7)
func (o *DMAC_Type) SetSADDR7(value uint32) {
	volatile.StoreUint32(&o.SADDR7.Reg, value)
}
func (o *DMAC_Type) GetSADDR7() uint32 {
	return volatile.LoadUint32(&o.SADDR7.Reg)
}

// DMAC.DADDR7: DMAC Channel Destination Address Register (ch_num = 7)
func (o *DMAC_Type) SetDADDR7(value uint32) {
	volatile.StoreUint32(&o.DADDR7.Reg, value)
}
func (o *DMAC_Type) GetDADDR7() uint32 {
	return volatile.LoadUint32(&o.DADDR7.Reg)
}

// DMAC.DSCR7: DMAC Channel Descriptor Address Register (ch_num = 7)
func (o *DMAC_Type) SetDSCR7_DSCR_IF(value uint32) {
	volatile.StoreUint32(&o.DSCR7.Reg, volatile.LoadUint32(&o.DSCR7.Reg)&^(0x3)|value)
}
func (o *DMAC_Type) GetDSCR7_DSCR_IF() uint32 {
	return volatile.LoadUint32(&o.DSCR7.Reg) & 0x3
}
func (o *DMAC_Type) SetDSCR7_DSCR(value uint32) {
	volatile.StoreUint32(&o.DSCR7.Reg, volatile.LoadUint32(&o.DSCR7.Reg)&^(0xfffffffc)|value<<2)
}
func (o *DMAC_Type) GetDSCR7_DSCR() uint32 {
	return (volatile.LoadUint32(&o.DSCR7.Reg) & 0xfffffffc) >> 2
}

// DMAC.CTRLA7: DMAC Channel Control A Register (ch_num = 7)
func (o *DMAC_Type) SetCTRLA7_BTSIZE(value uint32) {
	volatile.StoreUint32(&o.CTRLA7.Reg, volatile.LoadUint32(&o.CTRLA7.Reg)&^(0xffff)|value)
}
func (o *DMAC_Type) GetCTRLA7_BTSIZE() uint32 {
	return volatile.LoadUint32(&o.CTRLA7.Reg) & 0xffff
}
func (o *DMAC_Type) SetCTRLA7_SCSIZE(value uint32) {
	volatile.StoreUint32(&o.CTRLA7.Reg, volatile.LoadUint32(&o.CTRLA7.Reg)&^(0x70000)|value<<16)
}
func (o *DMAC_Type) GetCTRLA7_SCSIZE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA7.Reg) & 0x70000) >> 16
}
func (o *DMAC_Type) SetCTRLA7_DCSIZE(value uint32) {
	volatile.StoreUint32(&o.CTRLA7.Reg, volatile.LoadUint32(&o.CTRLA7.Reg)&^(0x700000)|value<<20)
}
func (o *DMAC_Type) GetCTRLA7_DCSIZE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA7.Reg) & 0x700000) >> 20
}
func (o *DMAC_Type) SetCTRLA7_SRC_WIDTH(value uint32) {
	volatile.StoreUint32(&o.CTRLA7.Reg, volatile.LoadUint32(&o.CTRLA7.Reg)&^(0x3000000)|value<<24)
}
func (o *DMAC_Type) GetCTRLA7_SRC_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.CTRLA7.Reg) & 0x3000000) >> 24
}
func (o *DMAC_Type) SetCTRLA7_DST_WIDTH(value uint32) {
	volatile.StoreUint32(&o.CTRLA7.Reg, volatile.LoadUint32(&o.CTRLA7.Reg)&^(0x30000000)|value<<28)
}
func (o *DMAC_Type) GetCTRLA7_DST_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.CTRLA7.Reg) & 0x30000000) >> 28
}
func (o *DMAC_Type) SetCTRLA7_DONE(value uint32) {
	volatile.StoreUint32(&o.CTRLA7.Reg, volatile.LoadUint32(&o.CTRLA7.Reg)&^(0x80000000)|value<<31)
}
func (o *DMAC_Type) GetCTRLA7_DONE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA7.Reg) & 0x80000000) >> 31
}

// DMAC.CTRLB7: DMAC Channel Control B Register (ch_num = 7)
func (o *DMAC_Type) SetCTRLB7_SIF(value uint32) {
	volatile.StoreUint32(&o.CTRLB7.Reg, volatile.LoadUint32(&o.CTRLB7.Reg)&^(0x3)|value)
}
func (o *DMAC_Type) GetCTRLB7_SIF() uint32 {
	return volatile.LoadUint32(&o.CTRLB7.Reg) & 0x3
}
func (o *DMAC_Type) SetCTRLB7_DIF(value uint32) {
	volatile.StoreUint32(&o.CTRLB7.Reg, volatile.LoadUint32(&o.CTRLB7.Reg)&^(0x30)|value<<4)
}
func (o *DMAC_Type) GetCTRLB7_DIF() uint32 {
	return (volatile.LoadUint32(&o.CTRLB7.Reg) & 0x30) >> 4
}
func (o *DMAC_Type) SetCTRLB7_SRC_PIP(value uint32) {
	volatile.StoreUint32(&o.CTRLB7.Reg, volatile.LoadUint32(&o.CTRLB7.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetCTRLB7_SRC_PIP() uint32 {
	return (volatile.LoadUint32(&o.CTRLB7.Reg) & 0x100) >> 8
}
func (o *DMAC_Type) SetCTRLB7_DST_PIP(value uint32) {
	volatile.StoreUint32(&o.CTRLB7.Reg, volatile.LoadUint32(&o.CTRLB7.Reg)&^(0x1000)|value<<12)
}
func (o *DMAC_Type) GetCTRLB7_DST_PIP() uint32 {
	return (volatile.LoadUint32(&o.CTRLB7.Reg) & 0x1000) >> 12
}
func (o *DMAC_Type) SetCTRLB7_SRC_DSCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB7.Reg, volatile.LoadUint32(&o.CTRLB7.Reg)&^(0x10000)|value<<16)
}
func (o *DMAC_Type) GetCTRLB7_SRC_DSCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB7.Reg) & 0x10000) >> 16
}
func (o *DMAC_Type) SetCTRLB7_DST_DSCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB7.Reg, volatile.LoadUint32(&o.CTRLB7.Reg)&^(0x100000)|value<<20)
}
func (o *DMAC_Type) GetCTRLB7_DST_DSCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB7.Reg) & 0x100000) >> 20
}
func (o *DMAC_Type) SetCTRLB7_FC(value uint32) {
	volatile.StoreUint32(&o.CTRLB7.Reg, volatile.LoadUint32(&o.CTRLB7.Reg)&^(0xe00000)|value<<21)
}
func (o *DMAC_Type) GetCTRLB7_FC() uint32 {
	return (volatile.LoadUint32(&o.CTRLB7.Reg) & 0xe00000) >> 21
}
func (o *DMAC_Type) SetCTRLB7_SRC_INCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB7.Reg, volatile.LoadUint32(&o.CTRLB7.Reg)&^(0x3000000)|value<<24)
}
func (o *DMAC_Type) GetCTRLB7_SRC_INCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB7.Reg) & 0x3000000) >> 24
}
func (o *DMAC_Type) SetCTRLB7_DST_INCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB7.Reg, volatile.LoadUint32(&o.CTRLB7.Reg)&^(0x30000000)|value<<28)
}
func (o *DMAC_Type) GetCTRLB7_DST_INCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB7.Reg) & 0x30000000) >> 28
}
func (o *DMAC_Type) SetCTRLB7_IEN(value uint32) {
	volatile.StoreUint32(&o.CTRLB7.Reg, volatile.LoadUint32(&o.CTRLB7.Reg)&^(0x40000000)|value<<30)
}
func (o *DMAC_Type) GetCTRLB7_IEN() uint32 {
	return (volatile.LoadUint32(&o.CTRLB7.Reg) & 0x40000000) >> 30
}
func (o *DMAC_Type) SetCTRLB7_AUTO(value uint32) {
	volatile.StoreUint32(&o.CTRLB7.Reg, volatile.LoadUint32(&o.CTRLB7.Reg)&^(0x80000000)|value<<31)
}
func (o *DMAC_Type) GetCTRLB7_AUTO() uint32 {
	return (volatile.LoadUint32(&o.CTRLB7.Reg) & 0x80000000) >> 31
}

// DMAC.CFG7: DMAC Channel Configuration Register (ch_num = 7)
func (o *DMAC_Type) SetCFG7_SRC_PER(value uint32) {
	volatile.StoreUint32(&o.CFG7.Reg, volatile.LoadUint32(&o.CFG7.Reg)&^(0xf)|value)
}
func (o *DMAC_Type) GetCFG7_SRC_PER() uint32 {
	return volatile.LoadUint32(&o.CFG7.Reg) & 0xf
}
func (o *DMAC_Type) SetCFG7_DST_PER(value uint32) {
	volatile.StoreUint32(&o.CFG7.Reg, volatile.LoadUint32(&o.CFG7.Reg)&^(0xf0)|value<<4)
}
func (o *DMAC_Type) GetCFG7_DST_PER() uint32 {
	return (volatile.LoadUint32(&o.CFG7.Reg) & 0xf0) >> 4
}
func (o *DMAC_Type) SetCFG7_SRC_REP(value uint32) {
	volatile.StoreUint32(&o.CFG7.Reg, volatile.LoadUint32(&o.CFG7.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetCFG7_SRC_REP() uint32 {
	return (volatile.LoadUint32(&o.CFG7.Reg) & 0x100) >> 8
}
func (o *DMAC_Type) SetCFG7_SRC_H2SEL(value uint32) {
	volatile.StoreUint32(&o.CFG7.Reg, volatile.LoadUint32(&o.CFG7.Reg)&^(0x200)|value<<9)
}
func (o *DMAC_Type) GetCFG7_SRC_H2SEL() uint32 {
	return (volatile.LoadUint32(&o.CFG7.Reg) & 0x200) >> 9
}
func (o *DMAC_Type) SetCFG7_DST_REP(value uint32) {
	volatile.StoreUint32(&o.CFG7.Reg, volatile.LoadUint32(&o.CFG7.Reg)&^(0x1000)|value<<12)
}
func (o *DMAC_Type) GetCFG7_DST_REP() uint32 {
	return (volatile.LoadUint32(&o.CFG7.Reg) & 0x1000) >> 12
}
func (o *DMAC_Type) SetCFG7_DST_H2SEL(value uint32) {
	volatile.StoreUint32(&o.CFG7.Reg, volatile.LoadUint32(&o.CFG7.Reg)&^(0x2000)|value<<13)
}
func (o *DMAC_Type) GetCFG7_DST_H2SEL() uint32 {
	return (volatile.LoadUint32(&o.CFG7.Reg) & 0x2000) >> 13
}
func (o *DMAC_Type) SetCFG7_SOD(value uint32) {
	volatile.StoreUint32(&o.CFG7.Reg, volatile.LoadUint32(&o.CFG7.Reg)&^(0x10000)|value<<16)
}
func (o *DMAC_Type) GetCFG7_SOD() uint32 {
	return (volatile.LoadUint32(&o.CFG7.Reg) & 0x10000) >> 16
}
func (o *DMAC_Type) SetCFG7_LOCK_IF(value uint32) {
	volatile.StoreUint32(&o.CFG7.Reg, volatile.LoadUint32(&o.CFG7.Reg)&^(0x100000)|value<<20)
}
func (o *DMAC_Type) GetCFG7_LOCK_IF() uint32 {
	return (volatile.LoadUint32(&o.CFG7.Reg) & 0x100000) >> 20
}
func (o *DMAC_Type) SetCFG7_LOCK_B(value uint32) {
	volatile.StoreUint32(&o.CFG7.Reg, volatile.LoadUint32(&o.CFG7.Reg)&^(0x200000)|value<<21)
}
func (o *DMAC_Type) GetCFG7_LOCK_B() uint32 {
	return (volatile.LoadUint32(&o.CFG7.Reg) & 0x200000) >> 21
}
func (o *DMAC_Type) SetCFG7_LOCK_IF_L(value uint32) {
	volatile.StoreUint32(&o.CFG7.Reg, volatile.LoadUint32(&o.CFG7.Reg)&^(0x400000)|value<<22)
}
func (o *DMAC_Type) GetCFG7_LOCK_IF_L() uint32 {
	return (volatile.LoadUint32(&o.CFG7.Reg) & 0x400000) >> 22
}
func (o *DMAC_Type) SetCFG7_AHB_PROT(value uint32) {
	volatile.StoreUint32(&o.CFG7.Reg, volatile.LoadUint32(&o.CFG7.Reg)&^(0x7000000)|value<<24)
}
func (o *DMAC_Type) GetCFG7_AHB_PROT() uint32 {
	return (volatile.LoadUint32(&o.CFG7.Reg) & 0x7000000) >> 24
}
func (o *DMAC_Type) SetCFG7_FIFOCFG(value uint32) {
	volatile.StoreUint32(&o.CFG7.Reg, volatile.LoadUint32(&o.CFG7.Reg)&^(0x30000000)|value<<28)
}
func (o *DMAC_Type) GetCFG7_FIFOCFG() uint32 {
	return (volatile.LoadUint32(&o.CFG7.Reg) & 0x30000000) >> 28
}

// DMAC.SPIP7: DMAC Channel Source Picture-in-Picture Configuration Register (ch_num = 7)
func (o *DMAC_Type) SetSPIP7_SPIP_HOLE(value uint32) {
	volatile.StoreUint32(&o.SPIP7.Reg, volatile.LoadUint32(&o.SPIP7.Reg)&^(0xffff)|value)
}
func (o *DMAC_Type) GetSPIP7_SPIP_HOLE() uint32 {
	return volatile.LoadUint32(&o.SPIP7.Reg) & 0xffff
}
func (o *DMAC_Type) SetSPIP7_SPIP_BOUNDARY(value uint32) {
	volatile.StoreUint32(&o.SPIP7.Reg, volatile.LoadUint32(&o.SPIP7.Reg)&^(0x3ff0000)|value<<16)
}
func (o *DMAC_Type) GetSPIP7_SPIP_BOUNDARY() uint32 {
	return (volatile.LoadUint32(&o.SPIP7.Reg) & 0x3ff0000) >> 16
}

// DMAC.DPIP7: DMAC Channel Destination Picture-in-Picture Configuration Register (ch_num = 7)
func (o *DMAC_Type) SetDPIP7_DPIP_HOLE(value uint32) {
	volatile.StoreUint32(&o.DPIP7.Reg, volatile.LoadUint32(&o.DPIP7.Reg)&^(0xffff)|value)
}
func (o *DMAC_Type) GetDPIP7_DPIP_HOLE() uint32 {
	return volatile.LoadUint32(&o.DPIP7.Reg) & 0xffff
}
func (o *DMAC_Type) SetDPIP7_DPIP_BOUNDARY(value uint32) {
	volatile.StoreUint32(&o.DPIP7.Reg, volatile.LoadUint32(&o.DPIP7.Reg)&^(0x3ff0000)|value<<16)
}
func (o *DMAC_Type) GetDPIP7_DPIP_BOUNDARY() uint32 {
	return (volatile.LoadUint32(&o.DPIP7.Reg) & 0x3ff0000) >> 16
}

// DMAC.WPMR: DMAC Write Protect Mode Register
func (o *DMAC_Type) SetWPMR_WPEN(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetWPMR_WPEN() uint32 {
	return volatile.LoadUint32(&o.WPMR.Reg) & 0x1
}
func (o *DMAC_Type) SetWPMR_WPKEY(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *DMAC_Type) GetWPMR_WPKEY() uint32 {
	return (volatile.LoadUint32(&o.WPMR.Reg) & 0xffffff00) >> 8
}

// DMAC.WPSR: DMAC Write Protect Status Register
func (o *DMAC_Type) SetWPSR_WPVS(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetWPSR_WPVS() uint32 {
	return volatile.LoadUint32(&o.WPSR.Reg) & 0x1
}
func (o *DMAC_Type) SetWPSR_WPVSRC(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0xffff00)|value<<8)
}
func (o *DMAC_Type) GetWPSR_WPVSRC() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0xffff00) >> 8
}

// Advanced Interrupt Controller
type AIC_Type struct {
	SMR   [32]volatile.Register32 // 0x0
	SVR   [32]volatile.Register32 // 0x80
	IVR   volatile.Register32     // 0x100
	FVR   volatile.Register32     // 0x104
	ISR   volatile.Register32     // 0x108
	IPR   volatile.Register32     // 0x10C
	IMR   volatile.Register32     // 0x110
	CISR  volatile.Register32     // 0x114
	_     [8]byte
	IECR  volatile.Register32 // 0x120
	IDCR  volatile.Register32 // 0x124
	ICCR  volatile.Register32 // 0x128
	ISCR  volatile.Register32 // 0x12C
	EOICR volatile.Register32 // 0x130
	SPU   volatile.Register32 // 0x134
	DCR   volatile.Register32 // 0x138
	_     [4]byte
	FFER  volatile.Register32 // 0x140
	FFDR  volatile.Register32 // 0x144
	FFSR  volatile.Register32 // 0x148
	_     [152]byte
	WPMR  volatile.Register32 // 0x1E4
	WPSR  volatile.Register32 // 0x1E8
}

// AIC.SMR: Source Mode Register
func (o *AIC_Type) SetSMR_PRIOR(idx int, value uint32) {
	volatile.StoreUint32(&o.SMR[idx].Reg, volatile.LoadUint32(&o.SMR[idx].Reg)&^(0x7)|value)
}
func (o *AIC_Type) GetSMR_PRIOR(idx int) uint32 {
	return volatile.LoadUint32(&o.SMR[idx].Reg) & 0x7
}
func (o *AIC_Type) SetSMR_SRCTYPE(idx int, value uint32) {
	volatile.StoreUint32(&o.SMR[idx].Reg, volatile.LoadUint32(&o.SMR[idx].Reg)&^(0x60)|value<<5)
}
func (o *AIC_Type) GetSMR_SRCTYPE(idx int) uint32 {
	return (volatile.LoadUint32(&o.SMR[idx].Reg) & 0x60) >> 5
}

// AIC.SVR: Source Vector Register
func (o *AIC_Type) SetSVR(idx int, value uint32) {
	volatile.StoreUint32(&o.SVR[idx].Reg, value)
}
func (o *AIC_Type) GetSVR(idx int) uint32 {
	return volatile.LoadUint32(&o.SVR[idx].Reg)
}

// AIC.IVR: Interrupt Vector Register
func (o *AIC_Type) SetIVR(value uint32) {
	volatile.StoreUint32(&o.IVR.Reg, value)
}
func (o *AIC_Type) GetIVR() uint32 {
	return volatile.LoadUint32(&o.IVR.Reg)
}

// AIC.FVR: FIQ Interrupt Vector Register
func (o *AIC_Type) SetFVR(value uint32) {
	volatile.StoreUint32(&o.FVR.Reg, value)
}
func (o *AIC_Type) GetFVR() uint32 {
	return volatile.LoadUint32(&o.FVR.Reg)
}

// AIC.ISR: Interrupt Status Register
func (o *AIC_Type) SetISR_IRQID(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1f)|value)
}
func (o *AIC_Type) GetISR_IRQID() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1f
}

// AIC.IPR: Interrupt Pending Register
func (o *AIC_Type) SetIPR_FIQ(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x1)|value)
}
func (o *AIC_Type) GetIPR_FIQ() uint32 {
	return volatile.LoadUint32(&o.IPR.Reg) & 0x1
}
func (o *AIC_Type) SetIPR_SYS(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x2)|value<<1)
}
func (o *AIC_Type) GetIPR_SYS() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x2) >> 1
}
func (o *AIC_Type) SetIPR_PID2(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x4)|value<<2)
}
func (o *AIC_Type) GetIPR_PID2() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x4) >> 2
}
func (o *AIC_Type) SetIPR_PID3(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x8)|value<<3)
}
func (o *AIC_Type) GetIPR_PID3() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x8) >> 3
}
func (o *AIC_Type) SetIPR_PID4(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x10)|value<<4)
}
func (o *AIC_Type) GetIPR_PID4() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x10) >> 4
}
func (o *AIC_Type) SetIPR_PID5(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x20)|value<<5)
}
func (o *AIC_Type) GetIPR_PID5() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x20) >> 5
}
func (o *AIC_Type) SetIPR_PID6(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x40)|value<<6)
}
func (o *AIC_Type) GetIPR_PID6() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x40) >> 6
}
func (o *AIC_Type) SetIPR_PID7(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x80)|value<<7)
}
func (o *AIC_Type) GetIPR_PID7() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x80) >> 7
}
func (o *AIC_Type) SetIPR_PID8(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x100)|value<<8)
}
func (o *AIC_Type) GetIPR_PID8() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x100) >> 8
}
func (o *AIC_Type) SetIPR_PID9(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x200)|value<<9)
}
func (o *AIC_Type) GetIPR_PID9() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x200) >> 9
}
func (o *AIC_Type) SetIPR_PID10(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x400)|value<<10)
}
func (o *AIC_Type) GetIPR_PID10() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x400) >> 10
}
func (o *AIC_Type) SetIPR_PID11(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x800)|value<<11)
}
func (o *AIC_Type) GetIPR_PID11() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x800) >> 11
}
func (o *AIC_Type) SetIPR_PID12(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x1000)|value<<12)
}
func (o *AIC_Type) GetIPR_PID12() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x1000) >> 12
}
func (o *AIC_Type) SetIPR_PID13(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x2000)|value<<13)
}
func (o *AIC_Type) GetIPR_PID13() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x2000) >> 13
}
func (o *AIC_Type) SetIPR_PID14(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x4000)|value<<14)
}
func (o *AIC_Type) GetIPR_PID14() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x4000) >> 14
}
func (o *AIC_Type) SetIPR_PID15(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x8000)|value<<15)
}
func (o *AIC_Type) GetIPR_PID15() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x8000) >> 15
}
func (o *AIC_Type) SetIPR_PID16(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x10000)|value<<16)
}
func (o *AIC_Type) GetIPR_PID16() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x10000) >> 16
}
func (o *AIC_Type) SetIPR_PID17(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x20000)|value<<17)
}
func (o *AIC_Type) GetIPR_PID17() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x20000) >> 17
}
func (o *AIC_Type) SetIPR_PID18(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x40000)|value<<18)
}
func (o *AIC_Type) GetIPR_PID18() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x40000) >> 18
}
func (o *AIC_Type) SetIPR_PID19(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x80000)|value<<19)
}
func (o *AIC_Type) GetIPR_PID19() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x80000) >> 19
}
func (o *AIC_Type) SetIPR_PID20(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x100000)|value<<20)
}
func (o *AIC_Type) GetIPR_PID20() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x100000) >> 20
}
func (o *AIC_Type) SetIPR_PID21(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x200000)|value<<21)
}
func (o *AIC_Type) GetIPR_PID21() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x200000) >> 21
}
func (o *AIC_Type) SetIPR_PID22(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x400000)|value<<22)
}
func (o *AIC_Type) GetIPR_PID22() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x400000) >> 22
}
func (o *AIC_Type) SetIPR_PID23(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x800000)|value<<23)
}
func (o *AIC_Type) GetIPR_PID23() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x800000) >> 23
}
func (o *AIC_Type) SetIPR_PID24(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x1000000)|value<<24)
}
func (o *AIC_Type) GetIPR_PID24() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x1000000) >> 24
}
func (o *AIC_Type) SetIPR_PID25(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x2000000)|value<<25)
}
func (o *AIC_Type) GetIPR_PID25() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x2000000) >> 25
}
func (o *AIC_Type) SetIPR_PID26(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x4000000)|value<<26)
}
func (o *AIC_Type) GetIPR_PID26() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x4000000) >> 26
}
func (o *AIC_Type) SetIPR_PID27(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x8000000)|value<<27)
}
func (o *AIC_Type) GetIPR_PID27() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x8000000) >> 27
}
func (o *AIC_Type) SetIPR_PID28(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x10000000)|value<<28)
}
func (o *AIC_Type) GetIPR_PID28() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x10000000) >> 28
}
func (o *AIC_Type) SetIPR_PID29(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x20000000)|value<<29)
}
func (o *AIC_Type) GetIPR_PID29() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x20000000) >> 29
}
func (o *AIC_Type) SetIPR_PID30(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x40000000)|value<<30)
}
func (o *AIC_Type) GetIPR_PID30() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x40000000) >> 30
}
func (o *AIC_Type) SetIPR_PID31(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x80000000)|value<<31)
}
func (o *AIC_Type) GetIPR_PID31() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x80000000) >> 31
}

// AIC.IMR: Interrupt Mask Register
func (o *AIC_Type) SetIMR_FIQ(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *AIC_Type) GetIMR_FIQ() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *AIC_Type) SetIMR_SYS(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *AIC_Type) GetIMR_SYS() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *AIC_Type) SetIMR_PID2(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4)|value<<2)
}
func (o *AIC_Type) GetIMR_PID2() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4) >> 2
}
func (o *AIC_Type) SetIMR_PID3(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8)|value<<3)
}
func (o *AIC_Type) GetIMR_PID3() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8) >> 3
}
func (o *AIC_Type) SetIMR_PID4(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10)|value<<4)
}
func (o *AIC_Type) GetIMR_PID4() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10) >> 4
}
func (o *AIC_Type) SetIMR_PID5(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20)|value<<5)
}
func (o *AIC_Type) GetIMR_PID5() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20) >> 5
}
func (o *AIC_Type) SetIMR_PID6(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40)|value<<6)
}
func (o *AIC_Type) GetIMR_PID6() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40) >> 6
}
func (o *AIC_Type) SetIMR_PID7(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80)|value<<7)
}
func (o *AIC_Type) GetIMR_PID7() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80) >> 7
}
func (o *AIC_Type) SetIMR_PID8(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100)|value<<8)
}
func (o *AIC_Type) GetIMR_PID8() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100) >> 8
}
func (o *AIC_Type) SetIMR_PID9(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200)|value<<9)
}
func (o *AIC_Type) GetIMR_PID9() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200) >> 9
}
func (o *AIC_Type) SetIMR_PID10(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400)|value<<10)
}
func (o *AIC_Type) GetIMR_PID10() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400) >> 10
}
func (o *AIC_Type) SetIMR_PID11(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x800)|value<<11)
}
func (o *AIC_Type) GetIMR_PID11() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x800) >> 11
}
func (o *AIC_Type) SetIMR_PID12(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1000)|value<<12)
}
func (o *AIC_Type) GetIMR_PID12() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x1000) >> 12
}
func (o *AIC_Type) SetIMR_PID13(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2000)|value<<13)
}
func (o *AIC_Type) GetIMR_PID13() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2000) >> 13
}
func (o *AIC_Type) SetIMR_PID14(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4000)|value<<14)
}
func (o *AIC_Type) GetIMR_PID14() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4000) >> 14
}
func (o *AIC_Type) SetIMR_PID15(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8000)|value<<15)
}
func (o *AIC_Type) GetIMR_PID15() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8000) >> 15
}
func (o *AIC_Type) SetIMR_PID16(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10000)|value<<16)
}
func (o *AIC_Type) GetIMR_PID16() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10000) >> 16
}
func (o *AIC_Type) SetIMR_PID17(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20000)|value<<17)
}
func (o *AIC_Type) GetIMR_PID17() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20000) >> 17
}
func (o *AIC_Type) SetIMR_PID18(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40000)|value<<18)
}
func (o *AIC_Type) GetIMR_PID18() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40000) >> 18
}
func (o *AIC_Type) SetIMR_PID19(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80000)|value<<19)
}
func (o *AIC_Type) GetIMR_PID19() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80000) >> 19
}
func (o *AIC_Type) SetIMR_PID20(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100000)|value<<20)
}
func (o *AIC_Type) GetIMR_PID20() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100000) >> 20
}
func (o *AIC_Type) SetIMR_PID21(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200000)|value<<21)
}
func (o *AIC_Type) GetIMR_PID21() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200000) >> 21
}
func (o *AIC_Type) SetIMR_PID22(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400000)|value<<22)
}
func (o *AIC_Type) GetIMR_PID22() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400000) >> 22
}
func (o *AIC_Type) SetIMR_PID23(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x800000)|value<<23)
}
func (o *AIC_Type) GetIMR_PID23() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x800000) >> 23
}
func (o *AIC_Type) SetIMR_PID24(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1000000)|value<<24)
}
func (o *AIC_Type) GetIMR_PID24() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x1000000) >> 24
}
func (o *AIC_Type) SetIMR_PID25(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2000000)|value<<25)
}
func (o *AIC_Type) GetIMR_PID25() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2000000) >> 25
}
func (o *AIC_Type) SetIMR_PID26(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4000000)|value<<26)
}
func (o *AIC_Type) GetIMR_PID26() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4000000) >> 26
}
func (o *AIC_Type) SetIMR_PID27(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8000000)|value<<27)
}
func (o *AIC_Type) GetIMR_PID27() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8000000) >> 27
}
func (o *AIC_Type) SetIMR_PID28(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10000000)|value<<28)
}
func (o *AIC_Type) GetIMR_PID28() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10000000) >> 28
}
func (o *AIC_Type) SetIMR_PID29(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20000000)|value<<29)
}
func (o *AIC_Type) GetIMR_PID29() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20000000) >> 29
}
func (o *AIC_Type) SetIMR_PID30(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40000000)|value<<30)
}
func (o *AIC_Type) GetIMR_PID30() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40000000) >> 30
}
func (o *AIC_Type) SetIMR_PID31(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80000000)|value<<31)
}
func (o *AIC_Type) GetIMR_PID31() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80000000) >> 31
}

// AIC.CISR: Core Interrupt Status Register
func (o *AIC_Type) SetCISR_NFIQ(value uint32) {
	volatile.StoreUint32(&o.CISR.Reg, volatile.LoadUint32(&o.CISR.Reg)&^(0x1)|value)
}
func (o *AIC_Type) GetCISR_NFIQ() uint32 {
	return volatile.LoadUint32(&o.CISR.Reg) & 0x1
}
func (o *AIC_Type) SetCISR_NIRQ(value uint32) {
	volatile.StoreUint32(&o.CISR.Reg, volatile.LoadUint32(&o.CISR.Reg)&^(0x2)|value<<1)
}
func (o *AIC_Type) GetCISR_NIRQ() uint32 {
	return (volatile.LoadUint32(&o.CISR.Reg) & 0x2) >> 1
}

// AIC.IECR: Interrupt Enable Command Register
func (o *AIC_Type) SetIECR_FIQ(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x1)|value)
}
func (o *AIC_Type) GetIECR_FIQ() uint32 {
	return volatile.LoadUint32(&o.IECR.Reg) & 0x1
}
func (o *AIC_Type) SetIECR_SYS(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x2)|value<<1)
}
func (o *AIC_Type) GetIECR_SYS() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x2) >> 1
}
func (o *AIC_Type) SetIECR_PID2(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x4)|value<<2)
}
func (o *AIC_Type) GetIECR_PID2() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x4) >> 2
}
func (o *AIC_Type) SetIECR_PID3(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x8)|value<<3)
}
func (o *AIC_Type) GetIECR_PID3() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x8) >> 3
}
func (o *AIC_Type) SetIECR_PID4(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x10)|value<<4)
}
func (o *AIC_Type) GetIECR_PID4() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x10) >> 4
}
func (o *AIC_Type) SetIECR_PID5(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x20)|value<<5)
}
func (o *AIC_Type) GetIECR_PID5() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x20) >> 5
}
func (o *AIC_Type) SetIECR_PID6(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x40)|value<<6)
}
func (o *AIC_Type) GetIECR_PID6() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x40) >> 6
}
func (o *AIC_Type) SetIECR_PID7(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x80)|value<<7)
}
func (o *AIC_Type) GetIECR_PID7() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x80) >> 7
}
func (o *AIC_Type) SetIECR_PID8(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x100)|value<<8)
}
func (o *AIC_Type) GetIECR_PID8() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x100) >> 8
}
func (o *AIC_Type) SetIECR_PID9(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x200)|value<<9)
}
func (o *AIC_Type) GetIECR_PID9() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x200) >> 9
}
func (o *AIC_Type) SetIECR_PID10(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x400)|value<<10)
}
func (o *AIC_Type) GetIECR_PID10() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x400) >> 10
}
func (o *AIC_Type) SetIECR_PID11(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x800)|value<<11)
}
func (o *AIC_Type) GetIECR_PID11() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x800) >> 11
}
func (o *AIC_Type) SetIECR_PID12(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x1000)|value<<12)
}
func (o *AIC_Type) GetIECR_PID12() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x1000) >> 12
}
func (o *AIC_Type) SetIECR_PID13(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x2000)|value<<13)
}
func (o *AIC_Type) GetIECR_PID13() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x2000) >> 13
}
func (o *AIC_Type) SetIECR_PID14(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x4000)|value<<14)
}
func (o *AIC_Type) GetIECR_PID14() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x4000) >> 14
}
func (o *AIC_Type) SetIECR_PID15(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x8000)|value<<15)
}
func (o *AIC_Type) GetIECR_PID15() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x8000) >> 15
}
func (o *AIC_Type) SetIECR_PID16(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x10000)|value<<16)
}
func (o *AIC_Type) GetIECR_PID16() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x10000) >> 16
}
func (o *AIC_Type) SetIECR_PID17(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x20000)|value<<17)
}
func (o *AIC_Type) GetIECR_PID17() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x20000) >> 17
}
func (o *AIC_Type) SetIECR_PID18(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x40000)|value<<18)
}
func (o *AIC_Type) GetIECR_PID18() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x40000) >> 18
}
func (o *AIC_Type) SetIECR_PID19(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x80000)|value<<19)
}
func (o *AIC_Type) GetIECR_PID19() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x80000) >> 19
}
func (o *AIC_Type) SetIECR_PID20(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x100000)|value<<20)
}
func (o *AIC_Type) GetIECR_PID20() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x100000) >> 20
}
func (o *AIC_Type) SetIECR_PID21(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x200000)|value<<21)
}
func (o *AIC_Type) GetIECR_PID21() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x200000) >> 21
}
func (o *AIC_Type) SetIECR_PID22(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x400000)|value<<22)
}
func (o *AIC_Type) GetIECR_PID22() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x400000) >> 22
}
func (o *AIC_Type) SetIECR_PID23(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x800000)|value<<23)
}
func (o *AIC_Type) GetIECR_PID23() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x800000) >> 23
}
func (o *AIC_Type) SetIECR_PID24(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x1000000)|value<<24)
}
func (o *AIC_Type) GetIECR_PID24() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x1000000) >> 24
}
func (o *AIC_Type) SetIECR_PID25(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x2000000)|value<<25)
}
func (o *AIC_Type) GetIECR_PID25() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x2000000) >> 25
}
func (o *AIC_Type) SetIECR_PID26(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x4000000)|value<<26)
}
func (o *AIC_Type) GetIECR_PID26() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x4000000) >> 26
}
func (o *AIC_Type) SetIECR_PID27(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x8000000)|value<<27)
}
func (o *AIC_Type) GetIECR_PID27() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x8000000) >> 27
}
func (o *AIC_Type) SetIECR_PID28(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x10000000)|value<<28)
}
func (o *AIC_Type) GetIECR_PID28() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x10000000) >> 28
}
func (o *AIC_Type) SetIECR_PID29(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x20000000)|value<<29)
}
func (o *AIC_Type) GetIECR_PID29() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x20000000) >> 29
}
func (o *AIC_Type) SetIECR_PID30(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x40000000)|value<<30)
}
func (o *AIC_Type) GetIECR_PID30() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x40000000) >> 30
}
func (o *AIC_Type) SetIECR_PID31(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x80000000)|value<<31)
}
func (o *AIC_Type) GetIECR_PID31() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x80000000) >> 31
}

// AIC.IDCR: Interrupt Disable Command Register
func (o *AIC_Type) SetIDCR_FIQ(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x1)|value)
}
func (o *AIC_Type) GetIDCR_FIQ() uint32 {
	return volatile.LoadUint32(&o.IDCR.Reg) & 0x1
}
func (o *AIC_Type) SetIDCR_SYS(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x2)|value<<1)
}
func (o *AIC_Type) GetIDCR_SYS() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x2) >> 1
}
func (o *AIC_Type) SetIDCR_PID2(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x4)|value<<2)
}
func (o *AIC_Type) GetIDCR_PID2() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x4) >> 2
}
func (o *AIC_Type) SetIDCR_PID3(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x8)|value<<3)
}
func (o *AIC_Type) GetIDCR_PID3() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x8) >> 3
}
func (o *AIC_Type) SetIDCR_PID4(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x10)|value<<4)
}
func (o *AIC_Type) GetIDCR_PID4() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x10) >> 4
}
func (o *AIC_Type) SetIDCR_PID5(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x20)|value<<5)
}
func (o *AIC_Type) GetIDCR_PID5() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x20) >> 5
}
func (o *AIC_Type) SetIDCR_PID6(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x40)|value<<6)
}
func (o *AIC_Type) GetIDCR_PID6() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x40) >> 6
}
func (o *AIC_Type) SetIDCR_PID7(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x80)|value<<7)
}
func (o *AIC_Type) GetIDCR_PID7() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x80) >> 7
}
func (o *AIC_Type) SetIDCR_PID8(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x100)|value<<8)
}
func (o *AIC_Type) GetIDCR_PID8() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x100) >> 8
}
func (o *AIC_Type) SetIDCR_PID9(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x200)|value<<9)
}
func (o *AIC_Type) GetIDCR_PID9() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x200) >> 9
}
func (o *AIC_Type) SetIDCR_PID10(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x400)|value<<10)
}
func (o *AIC_Type) GetIDCR_PID10() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x400) >> 10
}
func (o *AIC_Type) SetIDCR_PID11(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x800)|value<<11)
}
func (o *AIC_Type) GetIDCR_PID11() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x800) >> 11
}
func (o *AIC_Type) SetIDCR_PID12(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x1000)|value<<12)
}
func (o *AIC_Type) GetIDCR_PID12() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x1000) >> 12
}
func (o *AIC_Type) SetIDCR_PID13(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x2000)|value<<13)
}
func (o *AIC_Type) GetIDCR_PID13() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x2000) >> 13
}
func (o *AIC_Type) SetIDCR_PID14(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x4000)|value<<14)
}
func (o *AIC_Type) GetIDCR_PID14() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x4000) >> 14
}
func (o *AIC_Type) SetIDCR_PID15(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x8000)|value<<15)
}
func (o *AIC_Type) GetIDCR_PID15() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x8000) >> 15
}
func (o *AIC_Type) SetIDCR_PID16(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x10000)|value<<16)
}
func (o *AIC_Type) GetIDCR_PID16() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x10000) >> 16
}
func (o *AIC_Type) SetIDCR_PID17(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x20000)|value<<17)
}
func (o *AIC_Type) GetIDCR_PID17() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x20000) >> 17
}
func (o *AIC_Type) SetIDCR_PID18(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x40000)|value<<18)
}
func (o *AIC_Type) GetIDCR_PID18() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x40000) >> 18
}
func (o *AIC_Type) SetIDCR_PID19(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x80000)|value<<19)
}
func (o *AIC_Type) GetIDCR_PID19() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x80000) >> 19
}
func (o *AIC_Type) SetIDCR_PID20(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x100000)|value<<20)
}
func (o *AIC_Type) GetIDCR_PID20() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x100000) >> 20
}
func (o *AIC_Type) SetIDCR_PID21(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x200000)|value<<21)
}
func (o *AIC_Type) GetIDCR_PID21() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x200000) >> 21
}
func (o *AIC_Type) SetIDCR_PID22(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x400000)|value<<22)
}
func (o *AIC_Type) GetIDCR_PID22() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x400000) >> 22
}
func (o *AIC_Type) SetIDCR_PID23(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x800000)|value<<23)
}
func (o *AIC_Type) GetIDCR_PID23() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x800000) >> 23
}
func (o *AIC_Type) SetIDCR_PID24(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x1000000)|value<<24)
}
func (o *AIC_Type) GetIDCR_PID24() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x1000000) >> 24
}
func (o *AIC_Type) SetIDCR_PID25(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x2000000)|value<<25)
}
func (o *AIC_Type) GetIDCR_PID25() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x2000000) >> 25
}
func (o *AIC_Type) SetIDCR_PID26(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x4000000)|value<<26)
}
func (o *AIC_Type) GetIDCR_PID26() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x4000000) >> 26
}
func (o *AIC_Type) SetIDCR_PID27(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x8000000)|value<<27)
}
func (o *AIC_Type) GetIDCR_PID27() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x8000000) >> 27
}
func (o *AIC_Type) SetIDCR_PID28(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x10000000)|value<<28)
}
func (o *AIC_Type) GetIDCR_PID28() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x10000000) >> 28
}
func (o *AIC_Type) SetIDCR_PID29(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x20000000)|value<<29)
}
func (o *AIC_Type) GetIDCR_PID29() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x20000000) >> 29
}
func (o *AIC_Type) SetIDCR_PID30(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x40000000)|value<<30)
}
func (o *AIC_Type) GetIDCR_PID30() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x40000000) >> 30
}
func (o *AIC_Type) SetIDCR_PID31(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x80000000)|value<<31)
}
func (o *AIC_Type) GetIDCR_PID31() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x80000000) >> 31
}

// AIC.ICCR: Interrupt Clear Command Register
func (o *AIC_Type) SetICCR_FIQ(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x1)|value)
}
func (o *AIC_Type) GetICCR_FIQ() uint32 {
	return volatile.LoadUint32(&o.ICCR.Reg) & 0x1
}
func (o *AIC_Type) SetICCR_SYS(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x2)|value<<1)
}
func (o *AIC_Type) GetICCR_SYS() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x2) >> 1
}
func (o *AIC_Type) SetICCR_PID2(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x4)|value<<2)
}
func (o *AIC_Type) GetICCR_PID2() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x4) >> 2
}
func (o *AIC_Type) SetICCR_PID3(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x8)|value<<3)
}
func (o *AIC_Type) GetICCR_PID3() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x8) >> 3
}
func (o *AIC_Type) SetICCR_PID4(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x10)|value<<4)
}
func (o *AIC_Type) GetICCR_PID4() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x10) >> 4
}
func (o *AIC_Type) SetICCR_PID5(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x20)|value<<5)
}
func (o *AIC_Type) GetICCR_PID5() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x20) >> 5
}
func (o *AIC_Type) SetICCR_PID6(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x40)|value<<6)
}
func (o *AIC_Type) GetICCR_PID6() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x40) >> 6
}
func (o *AIC_Type) SetICCR_PID7(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x80)|value<<7)
}
func (o *AIC_Type) GetICCR_PID7() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x80) >> 7
}
func (o *AIC_Type) SetICCR_PID8(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x100)|value<<8)
}
func (o *AIC_Type) GetICCR_PID8() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x100) >> 8
}
func (o *AIC_Type) SetICCR_PID9(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x200)|value<<9)
}
func (o *AIC_Type) GetICCR_PID9() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x200) >> 9
}
func (o *AIC_Type) SetICCR_PID10(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x400)|value<<10)
}
func (o *AIC_Type) GetICCR_PID10() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x400) >> 10
}
func (o *AIC_Type) SetICCR_PID11(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x800)|value<<11)
}
func (o *AIC_Type) GetICCR_PID11() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x800) >> 11
}
func (o *AIC_Type) SetICCR_PID12(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x1000)|value<<12)
}
func (o *AIC_Type) GetICCR_PID12() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x1000) >> 12
}
func (o *AIC_Type) SetICCR_PID13(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x2000)|value<<13)
}
func (o *AIC_Type) GetICCR_PID13() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x2000) >> 13
}
func (o *AIC_Type) SetICCR_PID14(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x4000)|value<<14)
}
func (o *AIC_Type) GetICCR_PID14() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x4000) >> 14
}
func (o *AIC_Type) SetICCR_PID15(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x8000)|value<<15)
}
func (o *AIC_Type) GetICCR_PID15() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x8000) >> 15
}
func (o *AIC_Type) SetICCR_PID16(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x10000)|value<<16)
}
func (o *AIC_Type) GetICCR_PID16() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x10000) >> 16
}
func (o *AIC_Type) SetICCR_PID17(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x20000)|value<<17)
}
func (o *AIC_Type) GetICCR_PID17() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x20000) >> 17
}
func (o *AIC_Type) SetICCR_PID18(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x40000)|value<<18)
}
func (o *AIC_Type) GetICCR_PID18() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x40000) >> 18
}
func (o *AIC_Type) SetICCR_PID19(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x80000)|value<<19)
}
func (o *AIC_Type) GetICCR_PID19() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x80000) >> 19
}
func (o *AIC_Type) SetICCR_PID20(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x100000)|value<<20)
}
func (o *AIC_Type) GetICCR_PID20() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x100000) >> 20
}
func (o *AIC_Type) SetICCR_PID21(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x200000)|value<<21)
}
func (o *AIC_Type) GetICCR_PID21() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x200000) >> 21
}
func (o *AIC_Type) SetICCR_PID22(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x400000)|value<<22)
}
func (o *AIC_Type) GetICCR_PID22() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x400000) >> 22
}
func (o *AIC_Type) SetICCR_PID23(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x800000)|value<<23)
}
func (o *AIC_Type) GetICCR_PID23() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x800000) >> 23
}
func (o *AIC_Type) SetICCR_PID24(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x1000000)|value<<24)
}
func (o *AIC_Type) GetICCR_PID24() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x1000000) >> 24
}
func (o *AIC_Type) SetICCR_PID25(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x2000000)|value<<25)
}
func (o *AIC_Type) GetICCR_PID25() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x2000000) >> 25
}
func (o *AIC_Type) SetICCR_PID26(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x4000000)|value<<26)
}
func (o *AIC_Type) GetICCR_PID26() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x4000000) >> 26
}
func (o *AIC_Type) SetICCR_PID27(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x8000000)|value<<27)
}
func (o *AIC_Type) GetICCR_PID27() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x8000000) >> 27
}
func (o *AIC_Type) SetICCR_PID28(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x10000000)|value<<28)
}
func (o *AIC_Type) GetICCR_PID28() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x10000000) >> 28
}
func (o *AIC_Type) SetICCR_PID29(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x20000000)|value<<29)
}
func (o *AIC_Type) GetICCR_PID29() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x20000000) >> 29
}
func (o *AIC_Type) SetICCR_PID30(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x40000000)|value<<30)
}
func (o *AIC_Type) GetICCR_PID30() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x40000000) >> 30
}
func (o *AIC_Type) SetICCR_PID31(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x80000000)|value<<31)
}
func (o *AIC_Type) GetICCR_PID31() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x80000000) >> 31
}

// AIC.ISCR: Interrupt Set Command Register
func (o *AIC_Type) SetISCR_FIQ(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x1)|value)
}
func (o *AIC_Type) GetISCR_FIQ() uint32 {
	return volatile.LoadUint32(&o.ISCR.Reg) & 0x1
}
func (o *AIC_Type) SetISCR_SYS(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x2)|value<<1)
}
func (o *AIC_Type) GetISCR_SYS() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x2) >> 1
}
func (o *AIC_Type) SetISCR_PID2(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x4)|value<<2)
}
func (o *AIC_Type) GetISCR_PID2() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x4) >> 2
}
func (o *AIC_Type) SetISCR_PID3(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x8)|value<<3)
}
func (o *AIC_Type) GetISCR_PID3() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x8) >> 3
}
func (o *AIC_Type) SetISCR_PID4(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x10)|value<<4)
}
func (o *AIC_Type) GetISCR_PID4() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x10) >> 4
}
func (o *AIC_Type) SetISCR_PID5(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x20)|value<<5)
}
func (o *AIC_Type) GetISCR_PID5() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x20) >> 5
}
func (o *AIC_Type) SetISCR_PID6(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x40)|value<<6)
}
func (o *AIC_Type) GetISCR_PID6() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x40) >> 6
}
func (o *AIC_Type) SetISCR_PID7(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x80)|value<<7)
}
func (o *AIC_Type) GetISCR_PID7() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x80) >> 7
}
func (o *AIC_Type) SetISCR_PID8(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x100)|value<<8)
}
func (o *AIC_Type) GetISCR_PID8() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x100) >> 8
}
func (o *AIC_Type) SetISCR_PID9(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x200)|value<<9)
}
func (o *AIC_Type) GetISCR_PID9() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x200) >> 9
}
func (o *AIC_Type) SetISCR_PID10(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x400)|value<<10)
}
func (o *AIC_Type) GetISCR_PID10() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x400) >> 10
}
func (o *AIC_Type) SetISCR_PID11(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x800)|value<<11)
}
func (o *AIC_Type) GetISCR_PID11() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x800) >> 11
}
func (o *AIC_Type) SetISCR_PID12(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x1000)|value<<12)
}
func (o *AIC_Type) GetISCR_PID12() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x1000) >> 12
}
func (o *AIC_Type) SetISCR_PID13(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x2000)|value<<13)
}
func (o *AIC_Type) GetISCR_PID13() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x2000) >> 13
}
func (o *AIC_Type) SetISCR_PID14(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x4000)|value<<14)
}
func (o *AIC_Type) GetISCR_PID14() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x4000) >> 14
}
func (o *AIC_Type) SetISCR_PID15(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x8000)|value<<15)
}
func (o *AIC_Type) GetISCR_PID15() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x8000) >> 15
}
func (o *AIC_Type) SetISCR_PID16(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x10000)|value<<16)
}
func (o *AIC_Type) GetISCR_PID16() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x10000) >> 16
}
func (o *AIC_Type) SetISCR_PID17(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x20000)|value<<17)
}
func (o *AIC_Type) GetISCR_PID17() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x20000) >> 17
}
func (o *AIC_Type) SetISCR_PID18(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x40000)|value<<18)
}
func (o *AIC_Type) GetISCR_PID18() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x40000) >> 18
}
func (o *AIC_Type) SetISCR_PID19(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x80000)|value<<19)
}
func (o *AIC_Type) GetISCR_PID19() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x80000) >> 19
}
func (o *AIC_Type) SetISCR_PID20(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x100000)|value<<20)
}
func (o *AIC_Type) GetISCR_PID20() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x100000) >> 20
}
func (o *AIC_Type) SetISCR_PID21(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x200000)|value<<21)
}
func (o *AIC_Type) GetISCR_PID21() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x200000) >> 21
}
func (o *AIC_Type) SetISCR_PID22(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x400000)|value<<22)
}
func (o *AIC_Type) GetISCR_PID22() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x400000) >> 22
}
func (o *AIC_Type) SetISCR_PID23(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x800000)|value<<23)
}
func (o *AIC_Type) GetISCR_PID23() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x800000) >> 23
}
func (o *AIC_Type) SetISCR_PID24(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x1000000)|value<<24)
}
func (o *AIC_Type) GetISCR_PID24() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x1000000) >> 24
}
func (o *AIC_Type) SetISCR_PID25(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x2000000)|value<<25)
}
func (o *AIC_Type) GetISCR_PID25() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x2000000) >> 25
}
func (o *AIC_Type) SetISCR_PID26(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x4000000)|value<<26)
}
func (o *AIC_Type) GetISCR_PID26() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x4000000) >> 26
}
func (o *AIC_Type) SetISCR_PID27(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x8000000)|value<<27)
}
func (o *AIC_Type) GetISCR_PID27() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x8000000) >> 27
}
func (o *AIC_Type) SetISCR_PID28(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x10000000)|value<<28)
}
func (o *AIC_Type) GetISCR_PID28() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x10000000) >> 28
}
func (o *AIC_Type) SetISCR_PID29(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x20000000)|value<<29)
}
func (o *AIC_Type) GetISCR_PID29() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x20000000) >> 29
}
func (o *AIC_Type) SetISCR_PID30(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x40000000)|value<<30)
}
func (o *AIC_Type) GetISCR_PID30() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x40000000) >> 30
}
func (o *AIC_Type) SetISCR_PID31(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x80000000)|value<<31)
}
func (o *AIC_Type) GetISCR_PID31() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x80000000) >> 31
}

// AIC.SPU: Spurious Interrupt Vector Register
func (o *AIC_Type) SetSPU(value uint32) {
	volatile.StoreUint32(&o.SPU.Reg, value)
}
func (o *AIC_Type) GetSPU() uint32 {
	return volatile.LoadUint32(&o.SPU.Reg)
}

// AIC.DCR: Debug Control Register
func (o *AIC_Type) SetDCR_PROT(value uint32) {
	volatile.StoreUint32(&o.DCR.Reg, volatile.LoadUint32(&o.DCR.Reg)&^(0x1)|value)
}
func (o *AIC_Type) GetDCR_PROT() uint32 {
	return volatile.LoadUint32(&o.DCR.Reg) & 0x1
}
func (o *AIC_Type) SetDCR_GMSK(value uint32) {
	volatile.StoreUint32(&o.DCR.Reg, volatile.LoadUint32(&o.DCR.Reg)&^(0x2)|value<<1)
}
func (o *AIC_Type) GetDCR_GMSK() uint32 {
	return (volatile.LoadUint32(&o.DCR.Reg) & 0x2) >> 1
}

// AIC.FFER: Fast Forcing Enable Register
func (o *AIC_Type) SetFFER_SYS(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x2)|value<<1)
}
func (o *AIC_Type) GetFFER_SYS() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x2) >> 1
}
func (o *AIC_Type) SetFFER_PID2(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x4)|value<<2)
}
func (o *AIC_Type) GetFFER_PID2() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x4) >> 2
}
func (o *AIC_Type) SetFFER_PID3(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x8)|value<<3)
}
func (o *AIC_Type) GetFFER_PID3() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x8) >> 3
}
func (o *AIC_Type) SetFFER_PID4(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x10)|value<<4)
}
func (o *AIC_Type) GetFFER_PID4() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x10) >> 4
}
func (o *AIC_Type) SetFFER_PID5(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x20)|value<<5)
}
func (o *AIC_Type) GetFFER_PID5() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x20) >> 5
}
func (o *AIC_Type) SetFFER_PID6(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x40)|value<<6)
}
func (o *AIC_Type) GetFFER_PID6() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x40) >> 6
}
func (o *AIC_Type) SetFFER_PID7(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x80)|value<<7)
}
func (o *AIC_Type) GetFFER_PID7() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x80) >> 7
}
func (o *AIC_Type) SetFFER_PID8(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x100)|value<<8)
}
func (o *AIC_Type) GetFFER_PID8() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x100) >> 8
}
func (o *AIC_Type) SetFFER_PID9(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x200)|value<<9)
}
func (o *AIC_Type) GetFFER_PID9() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x200) >> 9
}
func (o *AIC_Type) SetFFER_PID10(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x400)|value<<10)
}
func (o *AIC_Type) GetFFER_PID10() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x400) >> 10
}
func (o *AIC_Type) SetFFER_PID11(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x800)|value<<11)
}
func (o *AIC_Type) GetFFER_PID11() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x800) >> 11
}
func (o *AIC_Type) SetFFER_PID12(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x1000)|value<<12)
}
func (o *AIC_Type) GetFFER_PID12() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x1000) >> 12
}
func (o *AIC_Type) SetFFER_PID13(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x2000)|value<<13)
}
func (o *AIC_Type) GetFFER_PID13() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x2000) >> 13
}
func (o *AIC_Type) SetFFER_PID14(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x4000)|value<<14)
}
func (o *AIC_Type) GetFFER_PID14() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x4000) >> 14
}
func (o *AIC_Type) SetFFER_PID15(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x8000)|value<<15)
}
func (o *AIC_Type) GetFFER_PID15() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x8000) >> 15
}
func (o *AIC_Type) SetFFER_PID16(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x10000)|value<<16)
}
func (o *AIC_Type) GetFFER_PID16() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x10000) >> 16
}
func (o *AIC_Type) SetFFER_PID17(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x20000)|value<<17)
}
func (o *AIC_Type) GetFFER_PID17() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x20000) >> 17
}
func (o *AIC_Type) SetFFER_PID18(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x40000)|value<<18)
}
func (o *AIC_Type) GetFFER_PID18() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x40000) >> 18
}
func (o *AIC_Type) SetFFER_PID19(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x80000)|value<<19)
}
func (o *AIC_Type) GetFFER_PID19() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x80000) >> 19
}
func (o *AIC_Type) SetFFER_PID20(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x100000)|value<<20)
}
func (o *AIC_Type) GetFFER_PID20() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x100000) >> 20
}
func (o *AIC_Type) SetFFER_PID21(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x200000)|value<<21)
}
func (o *AIC_Type) GetFFER_PID21() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x200000) >> 21
}
func (o *AIC_Type) SetFFER_PID22(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x400000)|value<<22)
}
func (o *AIC_Type) GetFFER_PID22() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x400000) >> 22
}
func (o *AIC_Type) SetFFER_PID23(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x800000)|value<<23)
}
func (o *AIC_Type) GetFFER_PID23() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x800000) >> 23
}
func (o *AIC_Type) SetFFER_PID24(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x1000000)|value<<24)
}
func (o *AIC_Type) GetFFER_PID24() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x1000000) >> 24
}
func (o *AIC_Type) SetFFER_PID25(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x2000000)|value<<25)
}
func (o *AIC_Type) GetFFER_PID25() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x2000000) >> 25
}
func (o *AIC_Type) SetFFER_PID26(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x4000000)|value<<26)
}
func (o *AIC_Type) GetFFER_PID26() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x4000000) >> 26
}
func (o *AIC_Type) SetFFER_PID27(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x8000000)|value<<27)
}
func (o *AIC_Type) GetFFER_PID27() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x8000000) >> 27
}
func (o *AIC_Type) SetFFER_PID28(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x10000000)|value<<28)
}
func (o *AIC_Type) GetFFER_PID28() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x10000000) >> 28
}
func (o *AIC_Type) SetFFER_PID29(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x20000000)|value<<29)
}
func (o *AIC_Type) GetFFER_PID29() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x20000000) >> 29
}
func (o *AIC_Type) SetFFER_PID30(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x40000000)|value<<30)
}
func (o *AIC_Type) GetFFER_PID30() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x40000000) >> 30
}
func (o *AIC_Type) SetFFER_PID31(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x80000000)|value<<31)
}
func (o *AIC_Type) GetFFER_PID31() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x80000000) >> 31
}

// AIC.FFDR: Fast Forcing Disable Register
func (o *AIC_Type) SetFFDR_SYS(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x2)|value<<1)
}
func (o *AIC_Type) GetFFDR_SYS() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x2) >> 1
}
func (o *AIC_Type) SetFFDR_PID2(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x4)|value<<2)
}
func (o *AIC_Type) GetFFDR_PID2() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x4) >> 2
}
func (o *AIC_Type) SetFFDR_PID3(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x8)|value<<3)
}
func (o *AIC_Type) GetFFDR_PID3() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x8) >> 3
}
func (o *AIC_Type) SetFFDR_PID4(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x10)|value<<4)
}
func (o *AIC_Type) GetFFDR_PID4() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x10) >> 4
}
func (o *AIC_Type) SetFFDR_PID5(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x20)|value<<5)
}
func (o *AIC_Type) GetFFDR_PID5() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x20) >> 5
}
func (o *AIC_Type) SetFFDR_PID6(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x40)|value<<6)
}
func (o *AIC_Type) GetFFDR_PID6() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x40) >> 6
}
func (o *AIC_Type) SetFFDR_PID7(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x80)|value<<7)
}
func (o *AIC_Type) GetFFDR_PID7() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x80) >> 7
}
func (o *AIC_Type) SetFFDR_PID8(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x100)|value<<8)
}
func (o *AIC_Type) GetFFDR_PID8() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x100) >> 8
}
func (o *AIC_Type) SetFFDR_PID9(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x200)|value<<9)
}
func (o *AIC_Type) GetFFDR_PID9() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x200) >> 9
}
func (o *AIC_Type) SetFFDR_PID10(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x400)|value<<10)
}
func (o *AIC_Type) GetFFDR_PID10() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x400) >> 10
}
func (o *AIC_Type) SetFFDR_PID11(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x800)|value<<11)
}
func (o *AIC_Type) GetFFDR_PID11() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x800) >> 11
}
func (o *AIC_Type) SetFFDR_PID12(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x1000)|value<<12)
}
func (o *AIC_Type) GetFFDR_PID12() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x1000) >> 12
}
func (o *AIC_Type) SetFFDR_PID13(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x2000)|value<<13)
}
func (o *AIC_Type) GetFFDR_PID13() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x2000) >> 13
}
func (o *AIC_Type) SetFFDR_PID14(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x4000)|value<<14)
}
func (o *AIC_Type) GetFFDR_PID14() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x4000) >> 14
}
func (o *AIC_Type) SetFFDR_PID15(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x8000)|value<<15)
}
func (o *AIC_Type) GetFFDR_PID15() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x8000) >> 15
}
func (o *AIC_Type) SetFFDR_PID16(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x10000)|value<<16)
}
func (o *AIC_Type) GetFFDR_PID16() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x10000) >> 16
}
func (o *AIC_Type) SetFFDR_PID17(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x20000)|value<<17)
}
func (o *AIC_Type) GetFFDR_PID17() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x20000) >> 17
}
func (o *AIC_Type) SetFFDR_PID18(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x40000)|value<<18)
}
func (o *AIC_Type) GetFFDR_PID18() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x40000) >> 18
}
func (o *AIC_Type) SetFFDR_PID19(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x80000)|value<<19)
}
func (o *AIC_Type) GetFFDR_PID19() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x80000) >> 19
}
func (o *AIC_Type) SetFFDR_PID20(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x100000)|value<<20)
}
func (o *AIC_Type) GetFFDR_PID20() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x100000) >> 20
}
func (o *AIC_Type) SetFFDR_PID21(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x200000)|value<<21)
}
func (o *AIC_Type) GetFFDR_PID21() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x200000) >> 21
}
func (o *AIC_Type) SetFFDR_PID22(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x400000)|value<<22)
}
func (o *AIC_Type) GetFFDR_PID22() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x400000) >> 22
}
func (o *AIC_Type) SetFFDR_PID23(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x800000)|value<<23)
}
func (o *AIC_Type) GetFFDR_PID23() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x800000) >> 23
}
func (o *AIC_Type) SetFFDR_PID24(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x1000000)|value<<24)
}
func (o *AIC_Type) GetFFDR_PID24() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x1000000) >> 24
}
func (o *AIC_Type) SetFFDR_PID25(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x2000000)|value<<25)
}
func (o *AIC_Type) GetFFDR_PID25() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x2000000) >> 25
}
func (o *AIC_Type) SetFFDR_PID26(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x4000000)|value<<26)
}
func (o *AIC_Type) GetFFDR_PID26() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x4000000) >> 26
}
func (o *AIC_Type) SetFFDR_PID27(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x8000000)|value<<27)
}
func (o *AIC_Type) GetFFDR_PID27() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x8000000) >> 27
}
func (o *AIC_Type) SetFFDR_PID28(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x10000000)|value<<28)
}
func (o *AIC_Type) GetFFDR_PID28() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x10000000) >> 28
}
func (o *AIC_Type) SetFFDR_PID29(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x20000000)|value<<29)
}
func (o *AIC_Type) GetFFDR_PID29() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x20000000) >> 29
}
func (o *AIC_Type) SetFFDR_PID30(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x40000000)|value<<30)
}
func (o *AIC_Type) GetFFDR_PID30() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x40000000) >> 30
}
func (o *AIC_Type) SetFFDR_PID31(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x80000000)|value<<31)
}
func (o *AIC_Type) GetFFDR_PID31() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x80000000) >> 31
}

// AIC.FFSR: Fast Forcing Status Register
func (o *AIC_Type) SetFFSR_SYS(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x2)|value<<1)
}
func (o *AIC_Type) GetFFSR_SYS() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x2) >> 1
}
func (o *AIC_Type) SetFFSR_PID2(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x4)|value<<2)
}
func (o *AIC_Type) GetFFSR_PID2() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x4) >> 2
}
func (o *AIC_Type) SetFFSR_PID3(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x8)|value<<3)
}
func (o *AIC_Type) GetFFSR_PID3() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x8) >> 3
}
func (o *AIC_Type) SetFFSR_PID4(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x10)|value<<4)
}
func (o *AIC_Type) GetFFSR_PID4() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x10) >> 4
}
func (o *AIC_Type) SetFFSR_PID5(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x20)|value<<5)
}
func (o *AIC_Type) GetFFSR_PID5() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x20) >> 5
}
func (o *AIC_Type) SetFFSR_PID6(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x40)|value<<6)
}
func (o *AIC_Type) GetFFSR_PID6() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x40) >> 6
}
func (o *AIC_Type) SetFFSR_PID7(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x80)|value<<7)
}
func (o *AIC_Type) GetFFSR_PID7() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x80) >> 7
}
func (o *AIC_Type) SetFFSR_PID8(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x100)|value<<8)
}
func (o *AIC_Type) GetFFSR_PID8() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x100) >> 8
}
func (o *AIC_Type) SetFFSR_PID9(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x200)|value<<9)
}
func (o *AIC_Type) GetFFSR_PID9() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x200) >> 9
}
func (o *AIC_Type) SetFFSR_PID10(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x400)|value<<10)
}
func (o *AIC_Type) GetFFSR_PID10() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x400) >> 10
}
func (o *AIC_Type) SetFFSR_PID11(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x800)|value<<11)
}
func (o *AIC_Type) GetFFSR_PID11() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x800) >> 11
}
func (o *AIC_Type) SetFFSR_PID12(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x1000)|value<<12)
}
func (o *AIC_Type) GetFFSR_PID12() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x1000) >> 12
}
func (o *AIC_Type) SetFFSR_PID13(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x2000)|value<<13)
}
func (o *AIC_Type) GetFFSR_PID13() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x2000) >> 13
}
func (o *AIC_Type) SetFFSR_PID14(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x4000)|value<<14)
}
func (o *AIC_Type) GetFFSR_PID14() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x4000) >> 14
}
func (o *AIC_Type) SetFFSR_PID15(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x8000)|value<<15)
}
func (o *AIC_Type) GetFFSR_PID15() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x8000) >> 15
}
func (o *AIC_Type) SetFFSR_PID16(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x10000)|value<<16)
}
func (o *AIC_Type) GetFFSR_PID16() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x10000) >> 16
}
func (o *AIC_Type) SetFFSR_PID17(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x20000)|value<<17)
}
func (o *AIC_Type) GetFFSR_PID17() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x20000) >> 17
}
func (o *AIC_Type) SetFFSR_PID18(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x40000)|value<<18)
}
func (o *AIC_Type) GetFFSR_PID18() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x40000) >> 18
}
func (o *AIC_Type) SetFFSR_PID19(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x80000)|value<<19)
}
func (o *AIC_Type) GetFFSR_PID19() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x80000) >> 19
}
func (o *AIC_Type) SetFFSR_PID20(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x100000)|value<<20)
}
func (o *AIC_Type) GetFFSR_PID20() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x100000) >> 20
}
func (o *AIC_Type) SetFFSR_PID21(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x200000)|value<<21)
}
func (o *AIC_Type) GetFFSR_PID21() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x200000) >> 21
}
func (o *AIC_Type) SetFFSR_PID22(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x400000)|value<<22)
}
func (o *AIC_Type) GetFFSR_PID22() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x400000) >> 22
}
func (o *AIC_Type) SetFFSR_PID23(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x800000)|value<<23)
}
func (o *AIC_Type) GetFFSR_PID23() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x800000) >> 23
}
func (o *AIC_Type) SetFFSR_PID24(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x1000000)|value<<24)
}
func (o *AIC_Type) GetFFSR_PID24() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x1000000) >> 24
}
func (o *AIC_Type) SetFFSR_PID25(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x2000000)|value<<25)
}
func (o *AIC_Type) GetFFSR_PID25() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x2000000) >> 25
}
func (o *AIC_Type) SetFFSR_PID26(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x4000000)|value<<26)
}
func (o *AIC_Type) GetFFSR_PID26() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x4000000) >> 26
}
func (o *AIC_Type) SetFFSR_PID27(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x8000000)|value<<27)
}
func (o *AIC_Type) GetFFSR_PID27() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x8000000) >> 27
}
func (o *AIC_Type) SetFFSR_PID28(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x10000000)|value<<28)
}
func (o *AIC_Type) GetFFSR_PID28() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x10000000) >> 28
}
func (o *AIC_Type) SetFFSR_PID29(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x20000000)|value<<29)
}
func (o *AIC_Type) GetFFSR_PID29() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x20000000) >> 29
}
func (o *AIC_Type) SetFFSR_PID30(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x40000000)|value<<30)
}
func (o *AIC_Type) GetFFSR_PID30() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x40000000) >> 30
}
func (o *AIC_Type) SetFFSR_PID31(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x80000000)|value<<31)
}
func (o *AIC_Type) GetFFSR_PID31() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x80000000) >> 31
}

// AIC.WPMR: Write Protect Mode Register
func (o *AIC_Type) SetWPMR_WPEN(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0x1)|value)
}
func (o *AIC_Type) GetWPMR_WPEN() uint32 {
	return volatile.LoadUint32(&o.WPMR.Reg) & 0x1
}
func (o *AIC_Type) SetWPMR_WPKEY(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *AIC_Type) GetWPMR_WPKEY() uint32 {
	return (volatile.LoadUint32(&o.WPMR.Reg) & 0xffffff00) >> 8
}

// AIC.WPSR: Write Protect Status Register
func (o *AIC_Type) SetWPSR_WPVS(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x1)|value)
}
func (o *AIC_Type) GetWPSR_WPVS() uint32 {
	return volatile.LoadUint32(&o.WPSR.Reg) & 0x1
}
func (o *AIC_Type) SetWPSR_WPVSRC(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0xffff00)|value<<8)
}
func (o *AIC_Type) GetWPSR_WPVSRC() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0xffff00) >> 8
}

// Debug Unit
type DBGU_Type struct {
	CR   volatile.Register32 // 0x0
	MR   volatile.Register32 // 0x4
	IER  volatile.Register32 // 0x8
	IDR  volatile.Register32 // 0xC
	IMR  volatile.Register32 // 0x10
	SR   volatile.Register32 // 0x14
	RHR  volatile.Register32 // 0x18
	THR  volatile.Register32 // 0x1C
	BRGR volatile.Register32 // 0x20
	_    [28]byte
	CIDR volatile.Register32 // 0x40
	EXID volatile.Register32 // 0x44
	FNR  volatile.Register32 // 0x48
}

// DBGU.CR: Control Register
func (o *DBGU_Type) SetCR_RSTRX(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *DBGU_Type) GetCR_RSTRX() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *DBGU_Type) SetCR_RSTTX(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *DBGU_Type) GetCR_RSTTX() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *DBGU_Type) SetCR_RXEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *DBGU_Type) GetCR_RXEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *DBGU_Type) SetCR_RXDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20)|value<<5)
}
func (o *DBGU_Type) GetCR_RXDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20) >> 5
}
func (o *DBGU_Type) SetCR_TXEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40)|value<<6)
}
func (o *DBGU_Type) GetCR_TXEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40) >> 6
}
func (o *DBGU_Type) SetCR_TXDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *DBGU_Type) GetCR_TXDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *DBGU_Type) SetCR_RSTSTA(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100)|value<<8)
}
func (o *DBGU_Type) GetCR_RSTSTA() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100) >> 8
}

// DBGU.MR: Mode Register
func (o *DBGU_Type) SetMR_PAR(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xe00)|value<<9)
}
func (o *DBGU_Type) GetMR_PAR() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xe00) >> 9
}
func (o *DBGU_Type) SetMR_CHMODE(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xc000)|value<<14)
}
func (o *DBGU_Type) GetMR_CHMODE() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xc000) >> 14
}

// DBGU.IER: Interrupt Enable Register
func (o *DBGU_Type) SetIER_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *DBGU_Type) GetIER_RXRDY() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *DBGU_Type) SetIER_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *DBGU_Type) GetIER_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *DBGU_Type) SetIER_OVRE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *DBGU_Type) GetIER_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *DBGU_Type) SetIER_FRAME(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40)|value<<6)
}
func (o *DBGU_Type) GetIER_FRAME() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40) >> 6
}
func (o *DBGU_Type) SetIER_PARE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80)|value<<7)
}
func (o *DBGU_Type) GetIER_PARE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80) >> 7
}
func (o *DBGU_Type) SetIER_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200)|value<<9)
}
func (o *DBGU_Type) GetIER_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200) >> 9
}
func (o *DBGU_Type) SetIER_COMMTX(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40000000)|value<<30)
}
func (o *DBGU_Type) GetIER_COMMTX() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40000000) >> 30
}
func (o *DBGU_Type) SetIER_COMMRX(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80000000)|value<<31)
}
func (o *DBGU_Type) GetIER_COMMRX() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80000000) >> 31
}

// DBGU.IDR: Interrupt Disable Register
func (o *DBGU_Type) SetIDR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *DBGU_Type) GetIDR_RXRDY() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *DBGU_Type) SetIDR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *DBGU_Type) GetIDR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *DBGU_Type) SetIDR_OVRE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20)|value<<5)
}
func (o *DBGU_Type) GetIDR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20) >> 5
}
func (o *DBGU_Type) SetIDR_FRAME(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40)|value<<6)
}
func (o *DBGU_Type) GetIDR_FRAME() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40) >> 6
}
func (o *DBGU_Type) SetIDR_PARE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80)|value<<7)
}
func (o *DBGU_Type) GetIDR_PARE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80) >> 7
}
func (o *DBGU_Type) SetIDR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200)|value<<9)
}
func (o *DBGU_Type) GetIDR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200) >> 9
}
func (o *DBGU_Type) SetIDR_COMMTX(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40000000)|value<<30)
}
func (o *DBGU_Type) GetIDR_COMMTX() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40000000) >> 30
}
func (o *DBGU_Type) SetIDR_COMMRX(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80000000)|value<<31)
}
func (o *DBGU_Type) GetIDR_COMMRX() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80000000) >> 31
}

// DBGU.IMR: Interrupt Mask Register
func (o *DBGU_Type) SetIMR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *DBGU_Type) GetIMR_RXRDY() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *DBGU_Type) SetIMR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *DBGU_Type) GetIMR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *DBGU_Type) SetIMR_OVRE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20)|value<<5)
}
func (o *DBGU_Type) GetIMR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20) >> 5
}
func (o *DBGU_Type) SetIMR_FRAME(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40)|value<<6)
}
func (o *DBGU_Type) GetIMR_FRAME() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40) >> 6
}
func (o *DBGU_Type) SetIMR_PARE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80)|value<<7)
}
func (o *DBGU_Type) GetIMR_PARE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80) >> 7
}
func (o *DBGU_Type) SetIMR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200)|value<<9)
}
func (o *DBGU_Type) GetIMR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200) >> 9
}
func (o *DBGU_Type) SetIMR_COMMTX(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40000000)|value<<30)
}
func (o *DBGU_Type) GetIMR_COMMTX() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40000000) >> 30
}
func (o *DBGU_Type) SetIMR_COMMRX(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80000000)|value<<31)
}
func (o *DBGU_Type) GetIMR_COMMRX() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80000000) >> 31
}

// DBGU.SR: Status Register
func (o *DBGU_Type) SetSR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *DBGU_Type) GetSR_RXRDY() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *DBGU_Type) SetSR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *DBGU_Type) GetSR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *DBGU_Type) SetSR_OVRE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *DBGU_Type) GetSR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *DBGU_Type) SetSR_FRAME(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *DBGU_Type) GetSR_FRAME() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *DBGU_Type) SetSR_PARE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80)|value<<7)
}
func (o *DBGU_Type) GetSR_PARE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80) >> 7
}
func (o *DBGU_Type) SetSR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x200)|value<<9)
}
func (o *DBGU_Type) GetSR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x200) >> 9
}
func (o *DBGU_Type) SetSR_COMMTX(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40000000)|value<<30)
}
func (o *DBGU_Type) GetSR_COMMTX() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40000000) >> 30
}
func (o *DBGU_Type) SetSR_COMMRX(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80000000)|value<<31)
}
func (o *DBGU_Type) GetSR_COMMRX() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80000000) >> 31
}

// DBGU.RHR: Receive Holding Register
func (o *DBGU_Type) SetRHR_RXCHR(value uint32) {
	volatile.StoreUint32(&o.RHR.Reg, volatile.LoadUint32(&o.RHR.Reg)&^(0xff)|value)
}
func (o *DBGU_Type) GetRHR_RXCHR() uint32 {
	return volatile.LoadUint32(&o.RHR.Reg) & 0xff
}

// DBGU.THR: Transmit Holding Register
func (o *DBGU_Type) SetTHR_TXCHR(value uint32) {
	volatile.StoreUint32(&o.THR.Reg, volatile.LoadUint32(&o.THR.Reg)&^(0xff)|value)
}
func (o *DBGU_Type) GetTHR_TXCHR() uint32 {
	return volatile.LoadUint32(&o.THR.Reg) & 0xff
}

// DBGU.BRGR: Baud Rate Generator Register
func (o *DBGU_Type) SetBRGR_CD(value uint32) {
	volatile.StoreUint32(&o.BRGR.Reg, volatile.LoadUint32(&o.BRGR.Reg)&^(0xffff)|value)
}
func (o *DBGU_Type) GetBRGR_CD() uint32 {
	return volatile.LoadUint32(&o.BRGR.Reg) & 0xffff
}

// DBGU.CIDR: Chip ID Register
func (o *DBGU_Type) SetCIDR_VERSION(value uint32) {
	volatile.StoreUint32(&o.CIDR.Reg, volatile.LoadUint32(&o.CIDR.Reg)&^(0x1f)|value)
}
func (o *DBGU_Type) GetCIDR_VERSION() uint32 {
	return volatile.LoadUint32(&o.CIDR.Reg) & 0x1f
}
func (o *DBGU_Type) SetCIDR_EPROC(value uint32) {
	volatile.StoreUint32(&o.CIDR.Reg, volatile.LoadUint32(&o.CIDR.Reg)&^(0xe0)|value<<5)
}
func (o *DBGU_Type) GetCIDR_EPROC() uint32 {
	return (volatile.LoadUint32(&o.CIDR.Reg) & 0xe0) >> 5
}
func (o *DBGU_Type) SetCIDR_NVPSIZ(value uint32) {
	volatile.StoreUint32(&o.CIDR.Reg, volatile.LoadUint32(&o.CIDR.Reg)&^(0xf00)|value<<8)
}
func (o *DBGU_Type) GetCIDR_NVPSIZ() uint32 {
	return (volatile.LoadUint32(&o.CIDR.Reg) & 0xf00) >> 8
}
func (o *DBGU_Type) SetCIDR_NVPSIZ2(value uint32) {
	volatile.StoreUint32(&o.CIDR.Reg, volatile.LoadUint32(&o.CIDR.Reg)&^(0xf000)|value<<12)
}
func (o *DBGU_Type) GetCIDR_NVPSIZ2() uint32 {
	return (volatile.LoadUint32(&o.CIDR.Reg) & 0xf000) >> 12
}
func (o *DBGU_Type) SetCIDR_SRAMSIZ(value uint32) {
	volatile.StoreUint32(&o.CIDR.Reg, volatile.LoadUint32(&o.CIDR.Reg)&^(0xf0000)|value<<16)
}
func (o *DBGU_Type) GetCIDR_SRAMSIZ() uint32 {
	return (volatile.LoadUint32(&o.CIDR.Reg) & 0xf0000) >> 16
}
func (o *DBGU_Type) SetCIDR_ARCH(value uint32) {
	volatile.StoreUint32(&o.CIDR.Reg, volatile.LoadUint32(&o.CIDR.Reg)&^(0xff00000)|value<<20)
}
func (o *DBGU_Type) GetCIDR_ARCH() uint32 {
	return (volatile.LoadUint32(&o.CIDR.Reg) & 0xff00000) >> 20
}
func (o *DBGU_Type) SetCIDR_NVPTYP(value uint32) {
	volatile.StoreUint32(&o.CIDR.Reg, volatile.LoadUint32(&o.CIDR.Reg)&^(0x70000000)|value<<28)
}
func (o *DBGU_Type) GetCIDR_NVPTYP() uint32 {
	return (volatile.LoadUint32(&o.CIDR.Reg) & 0x70000000) >> 28
}
func (o *DBGU_Type) SetCIDR_EXT(value uint32) {
	volatile.StoreUint32(&o.CIDR.Reg, volatile.LoadUint32(&o.CIDR.Reg)&^(0x80000000)|value<<31)
}
func (o *DBGU_Type) GetCIDR_EXT() uint32 {
	return (volatile.LoadUint32(&o.CIDR.Reg) & 0x80000000) >> 31
}

// DBGU.EXID: Chip ID Extension Register
func (o *DBGU_Type) SetEXID(value uint32) {
	volatile.StoreUint32(&o.EXID.Reg, value)
}
func (o *DBGU_Type) GetEXID() uint32 {
	return volatile.LoadUint32(&o.EXID.Reg)
}

// DBGU.FNR: Force NTRST Register
func (o *DBGU_Type) SetFNR_FNTRST(value uint32) {
	volatile.StoreUint32(&o.FNR.Reg, volatile.LoadUint32(&o.FNR.Reg)&^(0x1)|value)
}
func (o *DBGU_Type) GetFNR_FNTRST() uint32 {
	return volatile.LoadUint32(&o.FNR.Reg) & 0x1
}

// Parallel Input/Output Controller A
type PIO_Type struct {
	PER     volatile.Register32 // 0x0
	PDR     volatile.Register32 // 0x4
	PSR     volatile.Register32 // 0x8
	_       [4]byte
	OER     volatile.Register32 // 0x10
	ODR     volatile.Register32 // 0x14
	OSR     volatile.Register32 // 0x18
	_       [4]byte
	IFER    volatile.Register32 // 0x20
	IFDR    volatile.Register32 // 0x24
	IFSR    volatile.Register32 // 0x28
	_       [4]byte
	SODR    volatile.Register32 // 0x30
	CODR    volatile.Register32 // 0x34
	ODSR    volatile.Register32 // 0x38
	PDSR    volatile.Register32 // 0x3C
	IER     volatile.Register32 // 0x40
	IDR     volatile.Register32 // 0x44
	IMR     volatile.Register32 // 0x48
	ISR     volatile.Register32 // 0x4C
	MDER    volatile.Register32 // 0x50
	MDDR    volatile.Register32 // 0x54
	MDSR    volatile.Register32 // 0x58
	_       [4]byte
	PUDR    volatile.Register32 // 0x60
	PUER    volatile.Register32 // 0x64
	PUSR    volatile.Register32 // 0x68
	_       [4]byte
	ABCDSR  [2]volatile.Register32 // 0x70
	_       [8]byte
	IFSCDR  volatile.Register32 // 0x80
	IFSCER  volatile.Register32 // 0x84
	IFSCSR  volatile.Register32 // 0x88
	SCDR    volatile.Register32 // 0x8C
	PPDDR   volatile.Register32 // 0x90
	PPDER   volatile.Register32 // 0x94
	PPDSR   volatile.Register32 // 0x98
	_       [4]byte
	OWER    volatile.Register32 // 0xA0
	OWDR    volatile.Register32 // 0xA4
	OWSR    volatile.Register32 // 0xA8
	_       [4]byte
	AIMER   volatile.Register32 // 0xB0
	AIMDR   volatile.Register32 // 0xB4
	AIMMR   volatile.Register32 // 0xB8
	_       [4]byte
	ESR     volatile.Register32 // 0xC0
	LSR     volatile.Register32 // 0xC4
	ELSR    volatile.Register32 // 0xC8
	_       [4]byte
	FELLSR  volatile.Register32 // 0xD0
	REHLSR  volatile.Register32 // 0xD4
	FRLHSR  volatile.Register32 // 0xD8
	_       [4]byte
	LOCKSR  volatile.Register32 // 0xE0
	WPMR    volatile.Register32 // 0xE4
	WPSR    volatile.Register32 // 0xE8
	_       [20]byte
	SCHMITT volatile.Register32 // 0x100
	_       [12]byte
	DELAYR  volatile.Register32 // 0x110
	DRIVER1 volatile.Register32 // 0x114
	DRIVER2 volatile.Register32 // 0x118
}

// PIO.PER: PIO Enable Register
func (o *PIO_Type) SetPER_P0(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPER_P0() uint32 {
	return volatile.LoadUint32(&o.PER.Reg) & 0x1
}
func (o *PIO_Type) SetPER_P1(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPER_P1() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPER_P2(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPER_P2() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPER_P3(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPER_P3() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPER_P4(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPER_P4() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPER_P5(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPER_P5() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPER_P6(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPER_P6() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPER_P7(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPER_P7() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPER_P8(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPER_P8() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPER_P9(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPER_P9() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPER_P10(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPER_P10() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPER_P11(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPER_P11() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPER_P12(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPER_P12() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPER_P13(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPER_P13() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPER_P14(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPER_P14() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPER_P15(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPER_P15() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPER_P16(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPER_P16() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPER_P17(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPER_P17() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPER_P18(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPER_P18() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPER_P19(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPER_P19() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPER_P20(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPER_P20() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPER_P21(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPER_P21() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPER_P22(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPER_P22() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPER_P23(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPER_P23() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPER_P24(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPER_P24() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPER_P25(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPER_P25() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPER_P26(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPER_P26() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPER_P27(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPER_P27() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPER_P28(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPER_P28() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPER_P29(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPER_P29() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPER_P30(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPER_P30() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPER_P31(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPER_P31() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x80000000) >> 31
}

// PIO.PDR: PIO Disable Register
func (o *PIO_Type) SetPDR_P0(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPDR_P0() uint32 {
	return volatile.LoadUint32(&o.PDR.Reg) & 0x1
}
func (o *PIO_Type) SetPDR_P1(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPDR_P1() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPDR_P2(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPDR_P2() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPDR_P3(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPDR_P3() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPDR_P4(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPDR_P4() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPDR_P5(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPDR_P5() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPDR_P6(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPDR_P6() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPDR_P7(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPDR_P7() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPDR_P8(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPDR_P8() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPDR_P9(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPDR_P9() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPDR_P10(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPDR_P10() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPDR_P11(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPDR_P11() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPDR_P12(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPDR_P12() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPDR_P13(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPDR_P13() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPDR_P14(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPDR_P14() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPDR_P15(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPDR_P15() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPDR_P16(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPDR_P16() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPDR_P17(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPDR_P17() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPDR_P18(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPDR_P18() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPDR_P19(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPDR_P19() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPDR_P20(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPDR_P20() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPDR_P21(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPDR_P21() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPDR_P22(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPDR_P22() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPDR_P23(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPDR_P23() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPDR_P24(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPDR_P24() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPDR_P25(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPDR_P25() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPDR_P26(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPDR_P26() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPDR_P27(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPDR_P27() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPDR_P28(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPDR_P28() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPDR_P29(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPDR_P29() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPDR_P30(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPDR_P30() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPDR_P31(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPDR_P31() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x80000000) >> 31
}

// PIO.PSR: PIO Status Register
func (o *PIO_Type) SetPSR_P0(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPSR_P0() uint32 {
	return volatile.LoadUint32(&o.PSR.Reg) & 0x1
}
func (o *PIO_Type) SetPSR_P1(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPSR_P1() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPSR_P2(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPSR_P2() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPSR_P3(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPSR_P3() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPSR_P4(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPSR_P4() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPSR_P5(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPSR_P5() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPSR_P6(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPSR_P6() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPSR_P7(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPSR_P7() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPSR_P8(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPSR_P8() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPSR_P9(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPSR_P9() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPSR_P10(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPSR_P10() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPSR_P11(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPSR_P11() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPSR_P12(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPSR_P12() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPSR_P13(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPSR_P13() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPSR_P14(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPSR_P14() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPSR_P15(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPSR_P15() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPSR_P16(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPSR_P16() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPSR_P17(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPSR_P17() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPSR_P18(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPSR_P18() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPSR_P19(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPSR_P19() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPSR_P20(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPSR_P20() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPSR_P21(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPSR_P21() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPSR_P22(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPSR_P22() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPSR_P23(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPSR_P23() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPSR_P24(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPSR_P24() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPSR_P25(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPSR_P25() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPSR_P26(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPSR_P26() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPSR_P27(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPSR_P27() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPSR_P28(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPSR_P28() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPSR_P29(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPSR_P29() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPSR_P30(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPSR_P30() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPSR_P31(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPSR_P31() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x80000000) >> 31
}

// PIO.OER: Output Enable Register
func (o *PIO_Type) SetOER_P0(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetOER_P0() uint32 {
	return volatile.LoadUint32(&o.OER.Reg) & 0x1
}
func (o *PIO_Type) SetOER_P1(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetOER_P1() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetOER_P2(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetOER_P2() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetOER_P3(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetOER_P3() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetOER_P4(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetOER_P4() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetOER_P5(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetOER_P5() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetOER_P6(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetOER_P6() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetOER_P7(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetOER_P7() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetOER_P8(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetOER_P8() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetOER_P9(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetOER_P9() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetOER_P10(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetOER_P10() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetOER_P11(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetOER_P11() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetOER_P12(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetOER_P12() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetOER_P13(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetOER_P13() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetOER_P14(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetOER_P14() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetOER_P15(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetOER_P15() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetOER_P16(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetOER_P16() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetOER_P17(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetOER_P17() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetOER_P18(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetOER_P18() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetOER_P19(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetOER_P19() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetOER_P20(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetOER_P20() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetOER_P21(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetOER_P21() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetOER_P22(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetOER_P22() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetOER_P23(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetOER_P23() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetOER_P24(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetOER_P24() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetOER_P25(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetOER_P25() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetOER_P26(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetOER_P26() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetOER_P27(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetOER_P27() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetOER_P28(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetOER_P28() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetOER_P29(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetOER_P29() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetOER_P30(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetOER_P30() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetOER_P31(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetOER_P31() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x80000000) >> 31
}

// PIO.ODR: Output Disable Register
func (o *PIO_Type) SetODR_P0(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetODR_P0() uint32 {
	return volatile.LoadUint32(&o.ODR.Reg) & 0x1
}
func (o *PIO_Type) SetODR_P1(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetODR_P1() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetODR_P2(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetODR_P2() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetODR_P3(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetODR_P3() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetODR_P4(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetODR_P4() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetODR_P5(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetODR_P5() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetODR_P6(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetODR_P6() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetODR_P7(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetODR_P7() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetODR_P8(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetODR_P8() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetODR_P9(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetODR_P9() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetODR_P10(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetODR_P10() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetODR_P11(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetODR_P11() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetODR_P12(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetODR_P12() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetODR_P13(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetODR_P13() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetODR_P14(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetODR_P14() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetODR_P15(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetODR_P15() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetODR_P16(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetODR_P16() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetODR_P17(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetODR_P17() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetODR_P18(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetODR_P18() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetODR_P19(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetODR_P19() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetODR_P20(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetODR_P20() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetODR_P21(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetODR_P21() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetODR_P22(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetODR_P22() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetODR_P23(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetODR_P23() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetODR_P24(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetODR_P24() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetODR_P25(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetODR_P25() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetODR_P26(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetODR_P26() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetODR_P27(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetODR_P27() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetODR_P28(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetODR_P28() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetODR_P29(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetODR_P29() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetODR_P30(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetODR_P30() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetODR_P31(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetODR_P31() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x80000000) >> 31
}

// PIO.OSR: Output Status Register
func (o *PIO_Type) SetOSR_P0(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetOSR_P0() uint32 {
	return volatile.LoadUint32(&o.OSR.Reg) & 0x1
}
func (o *PIO_Type) SetOSR_P1(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetOSR_P1() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetOSR_P2(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetOSR_P2() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetOSR_P3(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetOSR_P3() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetOSR_P4(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetOSR_P4() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetOSR_P5(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetOSR_P5() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetOSR_P6(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetOSR_P6() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetOSR_P7(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetOSR_P7() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetOSR_P8(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetOSR_P8() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetOSR_P9(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetOSR_P9() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetOSR_P10(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetOSR_P10() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetOSR_P11(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetOSR_P11() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetOSR_P12(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetOSR_P12() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetOSR_P13(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetOSR_P13() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetOSR_P14(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetOSR_P14() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetOSR_P15(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetOSR_P15() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetOSR_P16(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetOSR_P16() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetOSR_P17(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetOSR_P17() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetOSR_P18(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetOSR_P18() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetOSR_P19(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetOSR_P19() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetOSR_P20(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetOSR_P20() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetOSR_P21(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetOSR_P21() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetOSR_P22(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetOSR_P22() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetOSR_P23(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetOSR_P23() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetOSR_P24(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetOSR_P24() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetOSR_P25(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetOSR_P25() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetOSR_P26(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetOSR_P26() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetOSR_P27(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetOSR_P27() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetOSR_P28(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetOSR_P28() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetOSR_P29(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetOSR_P29() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetOSR_P30(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetOSR_P30() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetOSR_P31(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetOSR_P31() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x80000000) >> 31
}

// PIO.IFER: Glitch Input Filter Enable Register
func (o *PIO_Type) SetIFER_P0(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetIFER_P0() uint32 {
	return volatile.LoadUint32(&o.IFER.Reg) & 0x1
}
func (o *PIO_Type) SetIFER_P1(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetIFER_P1() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetIFER_P2(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetIFER_P2() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetIFER_P3(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetIFER_P3() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetIFER_P4(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetIFER_P4() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetIFER_P5(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetIFER_P5() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetIFER_P6(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetIFER_P6() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetIFER_P7(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetIFER_P7() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetIFER_P8(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetIFER_P8() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetIFER_P9(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetIFER_P9() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetIFER_P10(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetIFER_P10() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetIFER_P11(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetIFER_P11() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetIFER_P12(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetIFER_P12() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetIFER_P13(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetIFER_P13() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetIFER_P14(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetIFER_P14() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetIFER_P15(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetIFER_P15() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetIFER_P16(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetIFER_P16() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetIFER_P17(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetIFER_P17() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetIFER_P18(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetIFER_P18() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetIFER_P19(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetIFER_P19() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetIFER_P20(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetIFER_P20() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetIFER_P21(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetIFER_P21() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetIFER_P22(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetIFER_P22() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetIFER_P23(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetIFER_P23() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetIFER_P24(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetIFER_P24() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetIFER_P25(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetIFER_P25() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetIFER_P26(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetIFER_P26() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetIFER_P27(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetIFER_P27() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetIFER_P28(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetIFER_P28() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetIFER_P29(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetIFER_P29() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetIFER_P30(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetIFER_P30() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetIFER_P31(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetIFER_P31() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x80000000) >> 31
}

// PIO.IFDR: Glitch Input Filter Disable Register
func (o *PIO_Type) SetIFDR_P0(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetIFDR_P0() uint32 {
	return volatile.LoadUint32(&o.IFDR.Reg) & 0x1
}
func (o *PIO_Type) SetIFDR_P1(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetIFDR_P1() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetIFDR_P2(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetIFDR_P2() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetIFDR_P3(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetIFDR_P3() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetIFDR_P4(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetIFDR_P4() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetIFDR_P5(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetIFDR_P5() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetIFDR_P6(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetIFDR_P6() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetIFDR_P7(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetIFDR_P7() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetIFDR_P8(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetIFDR_P8() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetIFDR_P9(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetIFDR_P9() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetIFDR_P10(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetIFDR_P10() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetIFDR_P11(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetIFDR_P11() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetIFDR_P12(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetIFDR_P12() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetIFDR_P13(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetIFDR_P13() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetIFDR_P14(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetIFDR_P14() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetIFDR_P15(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetIFDR_P15() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetIFDR_P16(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetIFDR_P16() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetIFDR_P17(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetIFDR_P17() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetIFDR_P18(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetIFDR_P18() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetIFDR_P19(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetIFDR_P19() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetIFDR_P20(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetIFDR_P20() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetIFDR_P21(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetIFDR_P21() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetIFDR_P22(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetIFDR_P22() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetIFDR_P23(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetIFDR_P23() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetIFDR_P24(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetIFDR_P24() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetIFDR_P25(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetIFDR_P25() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetIFDR_P26(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetIFDR_P26() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetIFDR_P27(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetIFDR_P27() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetIFDR_P28(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetIFDR_P28() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetIFDR_P29(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetIFDR_P29() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetIFDR_P30(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetIFDR_P30() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetIFDR_P31(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetIFDR_P31() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x80000000) >> 31
}

// PIO.IFSR: Glitch Input Filter Status Register
func (o *PIO_Type) SetIFSR_P0(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetIFSR_P0() uint32 {
	return volatile.LoadUint32(&o.IFSR.Reg) & 0x1
}
func (o *PIO_Type) SetIFSR_P1(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetIFSR_P1() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetIFSR_P2(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetIFSR_P2() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetIFSR_P3(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetIFSR_P3() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetIFSR_P4(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetIFSR_P4() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetIFSR_P5(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetIFSR_P5() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetIFSR_P6(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetIFSR_P6() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetIFSR_P7(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetIFSR_P7() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetIFSR_P8(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetIFSR_P8() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetIFSR_P9(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetIFSR_P9() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetIFSR_P10(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetIFSR_P10() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetIFSR_P11(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetIFSR_P11() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetIFSR_P12(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetIFSR_P12() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetIFSR_P13(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetIFSR_P13() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetIFSR_P14(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetIFSR_P14() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetIFSR_P15(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetIFSR_P15() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetIFSR_P16(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetIFSR_P16() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetIFSR_P17(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetIFSR_P17() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetIFSR_P18(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetIFSR_P18() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetIFSR_P19(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetIFSR_P19() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetIFSR_P20(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetIFSR_P20() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetIFSR_P21(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetIFSR_P21() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetIFSR_P22(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetIFSR_P22() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetIFSR_P23(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetIFSR_P23() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetIFSR_P24(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetIFSR_P24() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetIFSR_P25(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetIFSR_P25() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetIFSR_P26(value uint32) {
	volatile.StoreUint32(&o