"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getOpenGraphDataAsync = exports.axiosWithContentLimit = exports.axiosWithCookie = void 0;
const axios_1 = __importDefault(require("axios"));
const content_type_1 = require("content-type");
const iconv_lite_1 = require("iconv-lite");
const open_graph_1 = require("open-graph");
const path = __importStar(require("path"));
const url_1 = require("url");
const getLogger_1 = require("../logging/getLogger");
const config_1 = require("../settings/config");
const logger = (0, getLogger_1.getLogger)(path.basename(__filename));
axios_1.default.defaults.adapter = require('axios/lib/adapters/http');
const arrayify = (value = []) => (Array.isArray(value) ? value : [value]);
const bufferToBase64 = (buffer, mimeType) => {
    const bufferBase64encoded = Buffer.from(buffer).toString('base64');
    return `data:${mimeType};base64,${bufferBase64encoded}`;
};
const fetchImageAsBase64 = (url) => __awaiter(void 0, void 0, void 0, function* () {
    var _a, _b;
    const IMAGE_SIZE_LIMIT = 5e6;
    const parsedUrl = new url_1.URL(encodeURI(url));
    const normalizedUrl = parsedUrl.protocol ? parsedUrl : new url_1.URL(`http://${url}`);
    const axiosConfig = {
        headers: {
            'User-Agent': config_1.config.userAgent,
        },
        maxContentLength: IMAGE_SIZE_LIMIT,
        method: 'get',
        responseType: 'arraybuffer',
        url: normalizedUrl.href,
    };
    let response;
    try {
        response = yield (0, exports.axiosWithCookie)(axiosConfig);
    }
    catch (error) {
        if (((_a = error.response) === null || _a === void 0 ? void 0 : _a.status) && ((_b = error === null || error === void 0 ? void 0 : error.response) === null || _b === void 0 ? void 0 : _b.statusText)) {
            throw new Error(`Request failed with status code "${error.response.status}": "${error.response.statusText}".`);
        }
        throw new Error(`Request failed: ${error.message}`);
    }
    let contentType;
    try {
        contentType = (0, content_type_1.parse)(response.headers['content-type']);
    }
    catch (error) {
        throw new Error(`Could not parse content type: "${error.message}"`);
    }
    const isImageContentType = contentType.type.match(/.*image\/.*/);
    if (!isImageContentType) {
        throw new Error(`Unhandled format for open graph image ('${contentType}')`);
    }
    return bufferToBase64(response.data, contentType.type);
});
const axiosWithCookie = (config) => __awaiter(void 0, void 0, void 0, function* () {
    try {
        const response = yield axios_1.default.request(Object.assign(Object.assign({}, config), { maxRedirects: 0, withCredentials: true }));
        return response;
    }
    catch (error) {
        const response = error.response;
        if (!response) {
            throw error;
        }
        if (response.status === 301 || response.status === 302) {
            const setCookie = response.headers['set-cookie'];
            if (setCookie) {
                const Cookie = Array.isArray(setCookie) ? setCookie.join('; ') : setCookie;
                config.headers = Object.assign(Object.assign({}, config.headers), { Cookie });
            }
        }
        return yield axios_1.default.request(config);
    }
});
exports.axiosWithCookie = axiosWithCookie;
const axiosWithContentLimit = (config, contentLimit) => __awaiter(void 0, void 0, void 0, function* () {
    const cancelSource = axios_1.default.CancelToken.source();
    config.responseType = 'stream';
    config.cancelToken = cancelSource.token;
    try {
        const response = yield (0, exports.axiosWithCookie)(config);
        let contentType;
        try {
            contentType = (0, content_type_1.parse)(response.headers['content-type']);
        }
        catch (error) {
            throw new Error(`Could not parse content type: "${error.message}"`);
        }
        if (!contentType.type.includes('text/html')) {
            throw new Error(`Unhandled format for open graph generation (Content-Type is "${contentType}")`);
        }
        const charset = contentType.parameters.charset;
        const body = yield new Promise((resolve, reject) => {
            let partialBody = '';
            response.data
                .on('end', () => resolve(partialBody))
                .on('error', error => reject(error))
                .on('data', (buffer) => {
                let chunk = buffer.toString('utf8');
                if (charset) {
                    try {
                        chunk = (0, iconv_lite_1.decode)(buffer, charset);
                    }
                    catch (error) {
                        logger.error(`Could not decode content: "${error.message}."`);
                    }
                }
                partialBody += chunk;
                if (chunk.match('</head>') || partialBody.length > contentLimit) {
                    cancelSource.cancel();
                    resolve(partialBody);
                }
            });
        });
        return body;
    }
    catch (error) {
        if (axios_1.default.isCancel(error)) {
            return '';
        }
        const mappedError = error.isAxiosError ? new Error(`Request failed with code "${error.code}"`) : error;
        throw mappedError;
    }
});
exports.axiosWithContentLimit = axiosWithContentLimit;
const fetchOpenGraphData = (url) => __awaiter(void 0, void 0, void 0, function* () {
    var _c;
    const CONTENT_SIZE_LIMIT = 1e6;
    const parsedUrl = new url_1.URL(encodeURI(url));
    const normalizedUrl = parsedUrl.protocol ? parsedUrl : new url_1.URL(`http://${url}`);
    if ((_c = normalizedUrl.host) === null || _c === void 0 ? void 0 : _c.endsWith('twitter.com')) {
        config_1.config.userAgent = 'Twitterbot/1.0';
    }
    const axiosConfig = {
        headers: {
            'User-Agent': config_1.config.userAgent,
        },
        method: 'get',
        url: normalizedUrl.href,
    };
    const body = yield (0, exports.axiosWithContentLimit)(axiosConfig, CONTENT_SIZE_LIMIT);
    return (0, open_graph_1.parse)(body);
});
const updateMetaDataWithImage = (meta, imageData) => {
    var _a;
    (_a = meta.image) !== null && _a !== void 0 ? _a : (meta.image = {});
    if (imageData && typeof meta.image === 'object' && !Array.isArray(meta.image)) {
        meta.image.data = imageData;
    }
    else {
        delete meta.image;
    }
    return meta;
};
const getOpenGraphDataAsync = (url) => __awaiter(void 0, void 0, void 0, function* () {
    const metadata = yield fetchOpenGraphData(url);
    if (!metadata.description && !metadata.image && !metadata.type && !metadata.url) {
        throw new Error('No openGraph data found');
    }
    if (Array.isArray(metadata.image)) {
        metadata.image = metadata.image[0];
    }
    if (typeof metadata.image === 'object' && metadata.image.url) {
        const [imageUrl] = arrayify(metadata.image.url);
        try {
            const uri = yield fetchImageAsBase64(imageUrl);
            return updateMetaDataWithImage(metadata, uri);
        }
        catch (error) {
            logger.warn(error);
        }
    }
    delete metadata.image;
    return metadata;
});
exports.getOpenGraphDataAsync = getOpenGraphDataAsync;
//# sourceMappingURL=openGraph.js.map