"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const readline = require("readline");
const proxy_1 = require("./proxy");
const rl = readline.createInterface({
    input: process.stdin,
    output: process.stdout,
});
// To test
// process.env.HTTP_PROXY = "http://localhost:8888";
// process.env.HTTPS_PROXY = "http://localhost:8888";
proxy_1.getAndTestProxySettings(login).then((settings) => {
    if (settings) {
        // tslint:disable:no-console
        console.log(`http=${settings.http}`);
        console.log(`https=${settings.https}`);
    }
    rl.close();
}).catch((e) => {
    console.log("Error", e);
    rl.close();
});
function login() {
    return __awaiter(this, void 0, void 0, function* () {
        let username;
        let password;
        if (process.env.DEBUGGING) {
            return { username: "1", password: "1" };
        }
        return new Promise((resolve) => {
            rl.question("Proxy username? ", (answer) => {
                username = answer;
                rl.question("Proxy password? ", (pass) => {
                    password = answer;
                    resolve({ username, password });
                });
            });
        });
    });
}
//# sourceMappingURL=cli.js.map