/**
 * Captures all types of outputs from console.[log, debug, info, warn, error] functions
 * by modifying their abilities and redirects them to suppress and release them appropriately
 */
export declare class ConsoleOutput {
    private logOutput;
    private debugOutput;
    private infoOutput;
    private warnOutput;
    private errorOutput;
    private originalConsoleLog;
    private originalConsoleDebug;
    private originalConsoleInfo;
    private originalConsoleWarn;
    private originalConsoleError;
    /**
     * Captures the output from console.* functions and suppresses it
     */
    capture(): void;
    /**
     * Reverts back the original ability of console.* functions and releases the captured output
     */
    release(): void;
}
