/* updates_checker.c generated by valac 0.56.18, the Vala compiler
 * generated from updates_checker.vala, do not modify */

/*
 *  pamac-vala
 *
 *  Copyright (C) 2020-2023 Guillaume Benoit <guillaume@manjaro.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a get of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "pamac.h"
#include <glib.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	PAMAC_UPDATES_CHECKER_0_PROPERTY,
	PAMAC_UPDATES_CHECKER_UPDATES_NB_PROPERTY,
	PAMAC_UPDATES_CHECKER_UPDATES_LIST_PROPERTY,
	PAMAC_UPDATES_CHECKER_REFRESH_PERIOD_PROPERTY,
	PAMAC_UPDATES_CHECKER_NO_UPDATE_HIDE_ICON_PROPERTY,
	PAMAC_UPDATES_CHECKER_NUM_PROPERTIES
};
static GParamSpec* pamac_updates_checker_properties[PAMAC_UPDATES_CHECKER_NUM_PROPERTIES];
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block68Data Block68Data;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
enum  {
	PAMAC_UPDATES_CHECKER_UPDATES_AVAILABLE_SIGNAL,
	PAMAC_UPDATES_CHECKER_NUM_SIGNALS
};
static guint pamac_updates_checker_signals[PAMAC_UPDATES_CHECKER_NUM_SIGNALS] = {0};

struct _PamacUpdatesCheckerPrivate {
	GMainLoop* loop;
	PamacConfig* config;
	guint check_lock_timeout_id;
	GFile* _lock;
	GFileMonitor* lock_monitor;
	guint16 _updates_nb;
	gchar** _updates_list;
	gint _updates_list_length1;
	gint __updates_list_size_;
};

struct _Block68Data {
	int _ref_count_;
	PamacUpdatesChecker* self;
	GSubprocess* process;
};

static gint PamacUpdatesChecker_private_offset;
static gpointer pamac_updates_checker_parent_class = NULL;

static void pamac_updates_checker_on_lock_changed (PamacUpdatesChecker* self,
                                            GFile* src,
                                            GFile* dest,
                                            GFileMonitorEvent event_type);
static void _pamac_updates_checker_on_lock_changed_g_file_monitor_changed (GFileMonitor* _sender,
                                                                    GFile* file,
                                                                    GFile* other_file,
                                                                    GFileMonitorEvent event_type,
                                                                    gpointer self);
static Block68Data* block68_data_ref (Block68Data* _data68_);
static void block68_data_unref (void * _userdata_);
static void ____lambda84_ (Block68Data* _data68_);
static void _vala_array_add1 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _____lambda84__gasync_ready_callback (GObject* source_object,
                                           GAsyncResult* res,
                                           gpointer self);
static gboolean ___lambda83_ (PamacUpdatesChecker* self);
static gboolean ____lambda83__gsource_func (gpointer self);
static GObject * pamac_updates_checker_constructor (GType type,
                                             guint n_construct_properties,
                                             GObjectConstructParam * construct_properties);
static void pamac_updates_checker_finalize (GObject * obj);
static GType pamac_updates_checker_get_type_once (void);
static void _vala_pamac_updates_checker_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
pamac_updates_checker_get_instance_private (PamacUpdatesChecker* self)
{
	return G_STRUCT_MEMBER_P (self, PamacUpdatesChecker_private_offset);
}

PamacUpdatesChecker*
pamac_updates_checker_construct (GType object_type)
{
	PamacUpdatesChecker * self = NULL;
	self = (PamacUpdatesChecker*) g_object_new (object_type, NULL);
	return self;
}

PamacUpdatesChecker*
pamac_updates_checker_new (void)
{
	return pamac_updates_checker_construct (PAMAC_TYPE_UPDATES_CHECKER);
}

static void
_pamac_updates_checker_on_lock_changed_g_file_monitor_changed (GFileMonitor* _sender,
                                                               GFile* file,
                                                               GFile* other_file,
                                                               GFileMonitorEvent event_type,
                                                               gpointer self)
{
	pamac_updates_checker_on_lock_changed ((PamacUpdatesChecker*) self, file, other_file, event_type);
}

static Block68Data*
block68_data_ref (Block68Data* _data68_)
{
	g_atomic_int_inc (&_data68_->_ref_count_);
	return _data68_;
}

static void
block68_data_unref (void * _userdata_)
{
	Block68Data* _data68_;
	_data68_ = (Block68Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data68_->_ref_count_)) {
		PamacUpdatesChecker* self;
		self = _data68_->self;
		_g_object_unref0 (_data68_->process);
		_g_object_unref0 (self);
		g_slice_free (Block68Data, _data68_);
	}
}

static void
_vala_array_add1 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
____lambda84_ (Block68Data* _data68_)
{
	PamacUpdatesChecker* self;
	gchar** _tmp0_;
	GSubprocess* _tmp1_;
	GMainLoop* _tmp16_;
	GError* _inner_error0_ = NULL;
	self = _data68_->self;
	self->priv->_updates_nb = (guint16) 0;
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	self->priv->_updates_list = (_vala_array_free (self->priv->_updates_list, self->priv->_updates_list_length1, (GDestroyNotify) g_free), NULL);
	self->priv->_updates_list = _tmp0_;
	self->priv->_updates_list_length1 = 0;
	self->priv->__updates_list_size_ = self->priv->_updates_list_length1;
	_tmp1_ = _data68_->process;
	if (g_subprocess_get_if_exited (_tmp1_)) {
		gint status = 0;
		GSubprocess* _tmp2_;
		_tmp2_ = _data68_->process;
		status = g_subprocess_get_exit_status (_tmp2_);
		if (status == 100) {
			GDataInputStream* dis = NULL;
			GSubprocess* _tmp3_;
			GInputStream* _tmp4_;
			GDataInputStream* _tmp5_;
			_tmp3_ = _data68_->process;
			_tmp4_ = g_subprocess_get_stdout_pipe (_tmp3_);
			_tmp5_ = g_data_input_stream_new (_tmp4_);
			dis = _tmp5_;
			{
				gchar* line = NULL;
				while (TRUE) {
					gchar* _tmp6_ = NULL;
					GDataInputStream* _tmp7_;
					gchar* _tmp8_;
					gchar* _tmp9_;
					const gchar* _tmp10_;
					guint16 _tmp11_;
					const gchar* _tmp12_;
					gchar* _tmp13_;
					_tmp7_ = dis;
					_tmp8_ = g_data_input_stream_read_line (_tmp7_, NULL, NULL, &_inner_error0_);
					_tmp6_ = _tmp8_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_free0 (line);
						goto __catch0_g_error;
					}
					_tmp9_ = _tmp6_;
					_tmp6_ = NULL;
					_g_free0 (line);
					line = _tmp9_;
					_tmp10_ = line;
					if (!(_tmp10_ != NULL)) {
						_g_free0 (_tmp6_);
						break;
					}
					_tmp11_ = self->priv->_updates_nb;
					self->priv->_updates_nb = _tmp11_ + 1;
					_tmp12_ = line;
					_tmp13_ = g_strdup (_tmp12_);
					_vala_array_add1 (&self->priv->_updates_list, &self->priv->_updates_list_length1, &self->priv->__updates_list_size_, _tmp13_);
					_g_free0 (_tmp6_);
				}
				_g_free0 (line);
			}
			goto __finally0;
			__catch0_g_error:
			{
				GError* e = NULL;
				GError* _tmp14_;
				const gchar* _tmp15_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp14_ = e;
				_tmp15_ = _tmp14_->message;
				g_warning ("updates_checker.vala:78: %s", _tmp15_);
				_g_error_free0 (e);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (dis);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			_g_object_unref0 (dis);
		}
	}
	_tmp16_ = self->priv->loop;
	g_main_loop_quit (_tmp16_);
}

static void
_____lambda84__gasync_ready_callback (GObject* source_object,
                                      GAsyncResult* res,
                                      gpointer self)
{
	____lambda84_ (self);
	block68_data_unref (self);
}

void
pamac_updates_checker_check_updates (PamacUpdatesChecker* self)
{
	GFileMonitor* _tmp0_;
	guint _tmp1_;
	PamacConfig* _tmp2_;
	PamacConfig* _tmp3_;
	guint64 _tmp4_;
	guint64 _tmp5_;
	GFileMonitor* _tmp14_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->lock_monitor;
	g_signal_parse_name ("changed", g_file_monitor_get_type (), &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _pamac_updates_checker_on_lock_changed_g_file_monitor_changed, self);
	_tmp2_ = self->priv->config;
	pamac_config_reload (_tmp2_);
	_tmp3_ = self->priv->config;
	_tmp4_ = pamac_config_get_refresh_period (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != ((guint64) 0)) {
		gchar** cmds = NULL;
		gchar* _tmp6_;
		gchar** _tmp7_;
		gint cmds_length1;
		gint _cmds_size_;
		_tmp6_ = g_strdup ("pamac-checkupdates");
		_tmp7_ = g_new0 (gchar*, 1 + 1);
		_tmp7_[0] = _tmp6_;
		cmds = _tmp7_;
		cmds_length1 = 1;
		_cmds_size_ = cmds_length1;
		g_message ("updates_checker.vala:59: check updates");
		{
			Block68Data* _data68_;
			gchar** _tmp8_;
			gint _tmp8__length1;
			GSubprocess* _tmp9_;
			GSubprocess* _tmp10_;
			GMainLoop* _tmp11_;
			_data68_ = g_slice_new0 (Block68Data);
			_data68_->_ref_count_ = 1;
			_data68_->self = g_object_ref (self);
			_tmp8_ = cmds;
			_tmp8__length1 = cmds_length1;
			_tmp9_ = g_subprocess_newv (_tmp8_, G_SUBPROCESS_FLAGS_STDOUT_PIPE, &_inner_error0_);
			_data68_->process = _tmp9_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				block68_data_unref (_data68_);
				_data68_ = NULL;
				goto __catch0_g_error;
			}
			_tmp10_ = _data68_->process;
			g_subprocess_wait_async (_tmp10_, NULL, _____lambda84__gasync_ready_callback, block68_data_ref (_data68_));
			_tmp11_ = self->priv->loop;
			g_main_loop_run (_tmp11_);
			block68_data_unref (_data68_);
			_data68_ = NULL;
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp12_;
			const gchar* _tmp13_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp12_ = e;
			_tmp13_ = _tmp12_->message;
			g_warning ("updates_checker.vala:86: %s", _tmp13_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			cmds = (_vala_array_free (cmds, cmds_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		g_signal_emit (self, pamac_updates_checker_signals[PAMAC_UPDATES_CHECKER_UPDATES_AVAILABLE_SIGNAL], 0, self->priv->_updates_nb);
		cmds = (_vala_array_free (cmds, cmds_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp14_ = self->priv->lock_monitor;
	g_signal_connect_object (_tmp14_, "changed", (GCallback) _pamac_updates_checker_on_lock_changed_g_file_monitor_changed, self, 0);
}

static gboolean
___lambda83_ (PamacUpdatesChecker* self)
{
	gboolean result;
	pamac_updates_checker_check_updates (self);
	self->priv->check_lock_timeout_id = (guint) 0;
	result = FALSE;
	return result;
}

static gboolean
____lambda83__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda83_ ((PamacUpdatesChecker*) self);
	return result;
}

static void
pamac_updates_checker_on_lock_changed (PamacUpdatesChecker* self,
                                       GFile* src,
                                       GFile* dest,
                                       GFileMonitorEvent event_type)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (src != NULL);
	if (event_type == G_FILE_MONITOR_EVENT_CREATED) {
		if (self->priv->check_lock_timeout_id != ((guint) 0)) {
			g_source_remove (self->priv->check_lock_timeout_id);
		}
	}
	if (event_type == G_FILE_MONITOR_EVENT_DELETED) {
		if (self->priv->check_lock_timeout_id != ((guint) 0)) {
			g_source_remove (self->priv->check_lock_timeout_id);
		}
		self->priv->check_lock_timeout_id = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 5000, ____lambda83__gsource_func, g_object_ref (self), g_object_unref);
	}
}

guint16
pamac_updates_checker_get_updates_nb (PamacUpdatesChecker* self)
{
	guint16 result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_updates_nb;
	return result;
}

gchar**
pamac_updates_checker_get_updates_list (PamacUpdatesChecker* self,
                                        gint* result_length1)
{
	gchar** result;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_updates_list;
	_tmp0__length1 = self->priv->_updates_list_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}

guint64
pamac_updates_checker_get_refresh_period (PamacUpdatesChecker* self)
{
	guint64 result;
	PamacConfig* _tmp0_;
	guint64 _tmp1_;
	guint64 _tmp2_;
	g_return_val_if_fail (self != NULL, 0ULL);
	_tmp0_ = self->priv->config;
	_tmp1_ = pamac_config_get_refresh_period (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

gboolean
pamac_updates_checker_get_no_update_hide_icon (PamacUpdatesChecker* self)
{
	gboolean result;
	PamacConfig* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->config;
	_tmp1_ = pamac_config_get_no_update_hide_icon (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

static GObject *
pamac_updates_checker_constructor (GType type,
                                   guint n_construct_properties,
                                   GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PamacUpdatesChecker * self;
	GMainLoop* _tmp0_;
	PamacConfig* _tmp1_;
	gchar* lock_str = NULL;
	PamacConfig* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	GFile* _tmp7_;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (pamac_updates_checker_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PAMAC_TYPE_UPDATES_CHECKER, PamacUpdatesChecker);
	_tmp0_ = g_main_loop_new (NULL, FALSE);
	_g_main_loop_unref0 (self->priv->loop);
	self->priv->loop = _tmp0_;
	_tmp1_ = pamac_config_new ("/etc/pamac.conf");
	_g_object_unref0 (self->priv->config);
	self->priv->config = _tmp1_;
	_tmp2_ = self->priv->config;
	_tmp3_ = pamac_config_get_db_path (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_build_filename (_tmp4_, "db.lck", NULL);
	lock_str = _tmp5_;
	_tmp6_ = lock_str;
	_tmp7_ = g_file_new_for_path (_tmp6_);
	_g_object_unref0 (self->priv->_lock);
	self->priv->_lock = _tmp7_;
	{
		GFileMonitor* _tmp8_ = NULL;
		GFile* _tmp9_;
		GFileMonitor* _tmp10_;
		GFileMonitor* _tmp11_;
		GFileMonitor* _tmp12_;
		_tmp9_ = self->priv->_lock;
		_tmp10_ = g_file_monitor_file (_tmp9_, G_FILE_MONITOR_NONE, NULL, &_inner_error0_);
		_tmp8_ = _tmp10_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp11_ = _tmp8_;
		_tmp8_ = NULL;
		_g_object_unref0 (self->priv->lock_monitor);
		self->priv->lock_monitor = _tmp11_;
		_tmp12_ = self->priv->lock_monitor;
		g_signal_connect_object (_tmp12_, "changed", (GCallback) _pamac_updates_checker_on_lock_changed_g_file_monitor_changed, self, 0);
		_g_object_unref0 (_tmp8_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp13_;
		const gchar* _tmp14_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp13_ = e;
		_tmp14_ = _tmp13_->message;
		g_warning ("updates_checker.vala:49: %s", _tmp14_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (lock_str);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
	_g_free0 (lock_str);
	return obj;
}

static void
pamac_updates_checker_class_init (PamacUpdatesCheckerClass * klass,
                                  gpointer klass_data)
{
	pamac_updates_checker_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PamacUpdatesChecker_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_pamac_updates_checker_get_property;
	G_OBJECT_CLASS (klass)->constructor = pamac_updates_checker_constructor;
	G_OBJECT_CLASS (klass)->finalize = pamac_updates_checker_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_UPDATES_CHECKER_UPDATES_NB_PROPERTY, pamac_updates_checker_properties[PAMAC_UPDATES_CHECKER_UPDATES_NB_PROPERTY] = g_param_spec_uint ("updates-nb", "updates-nb", "updates-nb", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_UPDATES_CHECKER_UPDATES_LIST_PROPERTY, pamac_updates_checker_properties[PAMAC_UPDATES_CHECKER_UPDATES_LIST_PROPERTY] = g_param_spec_boxed ("updates-list", "updates-list", "updates-list", G_TYPE_STRV, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_UPDATES_CHECKER_REFRESH_PERIOD_PROPERTY, pamac_updates_checker_properties[PAMAC_UPDATES_CHECKER_REFRESH_PERIOD_PROPERTY] = g_param_spec_uint64 ("refresh-period", "refresh-period", "refresh-period", 0, G_MAXUINT64, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_UPDATES_CHECKER_NO_UPDATE_HIDE_ICON_PROPERTY, pamac_updates_checker_properties[PAMAC_UPDATES_CHECKER_NO_UPDATE_HIDE_ICON_PROPERTY] = g_param_spec_boolean ("no-update-hide-icon", "no-update-hide-icon", "no-update-hide-icon", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	pamac_updates_checker_signals[PAMAC_UPDATES_CHECKER_UPDATES_AVAILABLE_SIGNAL] = g_signal_new ("updates-available", PAMAC_TYPE_UPDATES_CHECKER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__UINT, G_TYPE_NONE, 1, G_TYPE_UINT);
}

static void
pamac_updates_checker_instance_init (PamacUpdatesChecker * self,
                                     gpointer klass)
{
	self->priv = pamac_updates_checker_get_instance_private (self);
}

static void
pamac_updates_checker_finalize (GObject * obj)
{
	PamacUpdatesChecker * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PAMAC_TYPE_UPDATES_CHECKER, PamacUpdatesChecker);
	_g_main_loop_unref0 (self->priv->loop);
	_g_object_unref0 (self->priv->config);
	_g_object_unref0 (self->priv->_lock);
	_g_object_unref0 (self->priv->lock_monitor);
	self->priv->_updates_list = (_vala_array_free (self->priv->_updates_list, self->priv->_updates_list_length1, (GDestroyNotify) g_free), NULL);
	G_OBJECT_CLASS (pamac_updates_checker_parent_class)->finalize (obj);
}

static GType
pamac_updates_checker_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PamacUpdatesCheckerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pamac_updates_checker_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PamacUpdatesChecker), 0, (GInstanceInitFunc) pamac_updates_checker_instance_init, NULL };
	GType pamac_updates_checker_type_id;
	pamac_updates_checker_type_id = g_type_register_static (G_TYPE_OBJECT, "PamacUpdatesChecker", &g_define_type_info, 0);
	PamacUpdatesChecker_private_offset = g_type_add_instance_private (pamac_updates_checker_type_id, sizeof (PamacUpdatesCheckerPrivate));
	return pamac_updates_checker_type_id;
}

GType
pamac_updates_checker_get_type (void)
{
	static volatile gsize pamac_updates_checker_type_id__once = 0;
	if (g_once_init_enter (&pamac_updates_checker_type_id__once)) {
		GType pamac_updates_checker_type_id;
		pamac_updates_checker_type_id = pamac_updates_checker_get_type_once ();
		g_once_init_leave (&pamac_updates_checker_type_id__once, pamac_updates_checker_type_id);
	}
	return pamac_updates_checker_type_id__once;
}

static void
_vala_pamac_updates_checker_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	PamacUpdatesChecker * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PAMAC_TYPE_UPDATES_CHECKER, PamacUpdatesChecker);
	switch (property_id) {
		case PAMAC_UPDATES_CHECKER_UPDATES_NB_PROPERTY:
		g_value_set_uint (value, pamac_updates_checker_get_updates_nb (self));
		break;
		case PAMAC_UPDATES_CHECKER_UPDATES_LIST_PROPERTY:
		{
			int length;
			g_value_set_boxed (value, pamac_updates_checker_get_updates_list (self, &length));
		}
		break;
		case PAMAC_UPDATES_CHECKER_REFRESH_PERIOD_PROPERTY:
		g_value_set_uint64 (value, pamac_updates_checker_get_refresh_period (self));
		break;
		case PAMAC_UPDATES_CHECKER_NO_UPDATE_HIDE_ICON_PROPERTY:
		g_value_set_boolean (value, pamac_updates_checker_get_no_update_hide_icon (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

