/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.jideoss.ui;

import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.UIScale;
import com.jidesoft.plaf.basic.BasicPainter;
import com.jidesoft.plaf.basic.ThemePainter;
import com.jidesoft.swing.JideButton;
import com.jidesoft.swing.JideSplitButton;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import javax.swing.UIManager;

public class FlatJidePainter
extends BasicPainter {
    protected final int arc = UIManager.getInt("Button.arc");

    public static ThemePainter getInstance() {
        return new FlatJidePainter();
    }

    @Override
    public void installDefaults() {
        if (this._bk0 == null) {
            this._bk0 = UIManager.getColor("Panel.background");
        }
        super.installDefaults();
    }

    @Override
    protected void paintBackground(JComponent c, Graphics g2, Rectangle rect, Color borderColor, Color background, int orientation) {
        if (c instanceof JideButton && ((JideButton)c).getButtonStyle() == 0 || c instanceof JideSplitButton && ((JideSplitButton)c).getButtonStyle() == 0) {
            Color oldColor = g2.getColor();
            g2.setColor(FlatUIUtils.deriveColor(background, c.getBackground()));
            Object[] oldRenderingHints = FlatUIUtils.setRenderingHints(g2);
            if (c instanceof JideSplitButton) {
                boolean horizontal;
                boolean bl = horizontal = ((JideSplitButton)c).getOrientation() == 0;
                if (!horizontal) {
                    g2.translate(0, -1);
                }
                Shape oldClip = g2.getClip();
                g2.clipRect(rect.x, rect.y, rect.width, rect.height);
                FlatUIUtils.paintComponentBackground((Graphics2D)g2, 0, 0, horizontal ? c.getWidth() : c.getHeight(), horizontal ? c.getHeight() : c.getWidth(), 0.0f, UIScale.scale((float)this.arc));
                g2.setClip(oldClip);
                if (rect.x > 0) {
                    g2.setColor(borderColor);
                    ((Graphics2D)g2).fill(new Rectangle2D.Float(rect.x, rect.y, UIScale.scale(1.0f), rect.height));
                }
                if (!horizontal) {
                    g2.translate(0, 1);
                }
            } else {
                FlatUIUtils.paintComponentBackground((Graphics2D)g2, rect.x, rect.y, rect.width, rect.height, 0.0f, UIScale.scale((float)this.arc));
            }
            FlatUIUtils.resetRenderingHints(g2, oldRenderingHints);
            g2.setColor(oldColor);
        } else {
            super.paintBackground(c, g2, rect, borderColor, background, orientation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintGripper(JComponent c, Graphics g2, Rectangle rect, int orientation, int state) {
        float userScaleFactor = UIScale.getUserScaleFactor();
        if (userScaleFactor > 1.0f) {
            Graphics2D g22 = (Graphics2D)g2.create();
            try {
                g22.translate(rect.x, rect.y);
                g22.scale(userScaleFactor, userScaleFactor);
                Rectangle rect2 = new Rectangle(0, 0, UIScale.unscale(rect.width), UIScale.unscale(rect.height));
                super.paintGripper(c, g22, rect2, orientation, state);
            }
            finally {
                g22.dispose();
            }
        } else {
            super.paintGripper(c, g2, rect, orientation, state);
        }
    }
}

