/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf.windows;

import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import org.jdesktop.swingx.JXTaskPane;
import org.jdesktop.swingx.plaf.basic.BasicTaskPaneUI;

public class WindowsTaskPaneUI
extends BasicTaskPaneUI {
    public static ComponentUI createUI(JComponent c) {
        return new WindowsTaskPaneUI();
    }

    @Override
    protected Border createPaneBorder() {
        return new XPPaneBorder();
    }

    @Override
    public void update(Graphics g2, JComponent c) {
        if (c.isOpaque()) {
            g2.setColor(c.getParent().getBackground());
            g2.fillRect(0, 0, c.getWidth(), c.getHeight());
            g2.setColor(c.getBackground());
            g2.fillRect(0, this.getRoundHeight(), c.getWidth(), c.getHeight() - this.getRoundHeight());
        }
        this.paint(g2, c);
    }

    class XPPaneBorder
    extends BasicTaskPaneUI.PaneBorder {
        XPPaneBorder() {
        }

        @Override
        protected void paintTitleBackground(JXTaskPane group, Graphics g2) {
            if (group.isSpecial()) {
                g2.setColor(this.specialTitleBackground);
                g2.fillRoundRect(0, 0, group.getWidth(), WindowsTaskPaneUI.this.getRoundHeight() * 2, WindowsTaskPaneUI.this.getRoundHeight(), WindowsTaskPaneUI.this.getRoundHeight());
                g2.fillRect(0, WindowsTaskPaneUI.this.getRoundHeight(), group.getWidth(), WindowsTaskPaneUI.this.getTitleHeight(group) - WindowsTaskPaneUI.this.getRoundHeight());
            } else {
                Paint oldPaint = ((Graphics2D)g2).getPaint();
                GradientPaint gradient = new GradientPaint(0.0f, group.getWidth() / 2, group.getComponentOrientation().isLeftToRight() ? this.titleBackgroundGradientStart : this.titleBackgroundGradientEnd, group.getWidth(), WindowsTaskPaneUI.this.getTitleHeight(group), group.getComponentOrientation().isLeftToRight() ? this.titleBackgroundGradientEnd : this.titleBackgroundGradientStart);
                ((Graphics2D)g2).setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
                ((Graphics2D)g2).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                ((Graphics2D)g2).setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                ((Graphics2D)g2).setPaint(gradient);
                g2.fillRoundRect(0, 0, group.getWidth(), WindowsTaskPaneUI.this.getRoundHeight() * 2, WindowsTaskPaneUI.this.getRoundHeight(), WindowsTaskPaneUI.this.getRoundHeight());
                g2.fillRect(0, WindowsTaskPaneUI.this.getRoundHeight(), group.getWidth(), WindowsTaskPaneUI.this.getTitleHeight(group) - WindowsTaskPaneUI.this.getRoundHeight());
                ((Graphics2D)g2).setPaint(oldPaint);
            }
        }

        @Override
        protected void paintExpandedControls(JXTaskPane group, Graphics g2, int x, int y, int width, int height) {
            ((Graphics2D)g2).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.paintOvalAroundControls(group, g2, x, y, width, height);
            g2.setColor(this.getPaintColor(group));
            this.paintChevronControls(group, g2, x, y, width, height);
            ((Graphics2D)g2).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }

        @Override
        protected boolean isMouseOverBorder() {
            return true;
        }
    }
}

