/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.apache.lucene.util.PriorityQueue;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.search.DocValueFormat;
import org.opensearch.search.aggregations.Aggregation;
import org.opensearch.search.aggregations.AggregationExecutionException;
import org.opensearch.search.aggregations.Aggregations;
import org.opensearch.search.aggregations.BucketOrder;
import org.opensearch.search.aggregations.InternalAggregation;
import org.opensearch.search.aggregations.InternalAggregations;
import org.opensearch.search.aggregations.InternalMultiBucketAggregation;
import org.opensearch.search.aggregations.InternalOrder;
import org.opensearch.search.aggregations.KeyComparable;
import org.opensearch.search.aggregations.bucket.IteratorAndCurrent;
import org.opensearch.search.aggregations.bucket.LocalBucketCountThresholds;
import org.opensearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.opensearch.search.aggregations.bucket.terms.BucketPriorityQueue;
import org.opensearch.search.aggregations.bucket.terms.Terms;
import org.opensearch.search.aggregations.bucket.terms.TermsAggregator;
import org.opensearch.search.aggregations.bucket.terms.UnmappedTerms;

public abstract class InternalTerms<A extends InternalTerms<A, B>, B extends AbstractInternalBucket>
extends InternalMultiBucketAggregation<A, B>
implements Terms {
    protected static final ParseField DOC_COUNT_ERROR_UPPER_BOUND_FIELD_NAME = new ParseField("doc_count_error_upper_bound", new String[0]);
    protected static final ParseField SUM_OF_OTHER_DOC_COUNTS = new ParseField("sum_other_doc_count", new String[0]);
    protected final BucketOrder reduceOrder;
    protected final BucketOrder order;
    protected final int requiredSize;
    protected final long minDocCount;
    protected final TermsAggregator.BucketCountThresholds bucketCountThresholds;
    private boolean hasSliceLevelDocCountError = false;

    protected InternalTerms(String name, BucketOrder reduceOrder, BucketOrder order, TermsAggregator.BucketCountThresholds bucketCountThresholds, Map<String, Object> metadata) {
        super(name, metadata);
        this.reduceOrder = reduceOrder;
        this.order = order;
        this.bucketCountThresholds = bucketCountThresholds;
        this.requiredSize = bucketCountThresholds.getRequiredSize();
        this.minDocCount = bucketCountThresholds.getMinDocCount();
    }

    protected InternalTerms(StreamInput in) throws IOException {
        super(in);
        this.reduceOrder = InternalOrder.Streams.readOrder(in);
        this.order = InternalOrder.Streams.readOrder(in);
        this.requiredSize = InternalTerms.readSize(in);
        this.minDocCount = in.readVLong();
        this.bucketCountThresholds = new TermsAggregator.CoordinatorBucketCountThresholds(this.minDocCount, -1L, this.requiredSize, this.getShardSize());
    }

    @Override
    protected final void doWriteTo(StreamOutput out) throws IOException {
        this.reduceOrder.writeTo(out);
        this.order.writeTo(out);
        InternalTerms.writeSize(this.requiredSize, out);
        out.writeVLong(this.minDocCount);
        this.writeTermTypeInfoTo(out);
    }

    protected abstract void writeTermTypeInfoTo(StreamOutput var1) throws IOException;

    @Override
    public abstract List<B> getBuckets();

    public abstract B getBucketByKey(String var1);

    private BucketOrder getReduceOrder(List<InternalAggregation> aggregations) {
        BucketOrder thisReduceOrder = null;
        for (InternalAggregation aggregation : aggregations) {
            InternalTerms terms = (InternalTerms)aggregation;
            if (terms.getBuckets().size() == 0) continue;
            if (thisReduceOrder == null) {
                thisReduceOrder = terms.reduceOrder;
                continue;
            }
            if (thisReduceOrder.equals(terms.reduceOrder)) continue;
            return this.order;
        }
        return thisReduceOrder != null ? thisReduceOrder : this.order;
    }

    private long getDocCountError(InternalTerms<?, ?> terms, InternalAggregation.ReduceContext reduceContext) {
        int size = terms.getBuckets().size();
        if (size == 0 || size < terms.getShardSize() || InternalOrder.isKeyOrder(terms.order)) {
            return 0L;
        }
        if (InternalOrder.isCountDesc(terms.order)) {
            if (terms.getDocCountError() > 0L) {
                return terms.getDocCountError();
            }
            return terms.getBuckets().stream().mapToLong(MultiBucketsAggregation.Bucket::getDocCount).min().getAsLong();
        }
        return -1L;
    }

    private List<B> reduceMergeSort(List<InternalAggregation> aggregations, BucketOrder thisReduceOrder, InternalAggregation.ReduceContext reduceContext) {
        assert (InternalOrder.isKeyOrder(thisReduceOrder));
        final Comparator<MultiBucketsAggregation.Bucket> cmp = thisReduceOrder.comparator();
        PriorityQueue pq = new PriorityQueue<IteratorAndCurrent<B>>(this, aggregations.size()){

            protected boolean lessThan(IteratorAndCurrent<B> a, IteratorAndCurrent<B> b) {
                return cmp.compare(a.current(), b.current()) < 0;
            }
        };
        for (InternalAggregation aggregation : aggregations) {
            InternalTerms terms = (InternalTerms)aggregation;
            if (terms.getBuckets().isEmpty()) continue;
            assert (this.reduceOrder.equals(this.reduceOrder));
            pq.add(new IteratorAndCurrent<B>(terms.getBuckets().iterator()));
        }
        ArrayList<InternalMultiBucketAggregation.InternalBucket> reducedBuckets = new ArrayList<InternalMultiBucketAggregation.InternalBucket>();
        ArrayList<AbstractInternalBucket> currentBuckets = new ArrayList<AbstractInternalBucket>();
        AbstractInternalBucket lastBucket = null;
        while (pq.size() > 0) {
            IteratorAndCurrent top = (IteratorAndCurrent)pq.top();
            assert (lastBucket == null || cmp.compare((MultiBucketsAggregation.Bucket)top.current(), lastBucket) >= 0);
            if (lastBucket != null && cmp.compare((MultiBucketsAggregation.Bucket)top.current(), lastBucket) != 0) {
                InternalMultiBucketAggregation.InternalBucket reduced = this.reduceBucket(currentBuckets, reduceContext);
                reducedBuckets.add(reduced);
                currentBuckets.clear();
            }
            lastBucket = (AbstractInternalBucket)top.current();
            currentBuckets.add((AbstractInternalBucket)top.current());
            if (top.hasNext()) {
                top.next();
                assert (cmp.compare((MultiBucketsAggregation.Bucket)top.current(), lastBucket) > 0) : "shards must return data sorted by key";
                pq.updateTop();
                continue;
            }
            pq.pop();
        }
        if (!currentBuckets.isEmpty()) {
            InternalMultiBucketAggregation.InternalBucket reduced = this.reduceBucket(currentBuckets, reduceContext);
            reducedBuckets.add(reduced);
        }
        return reducedBuckets;
    }

    private List<B> reduceLegacy(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
        HashMap<Object, ArrayList<AbstractInternalBucket>> bucketMap = new HashMap<Object, ArrayList<AbstractInternalBucket>>();
        for (InternalAggregation aggregation : aggregations) {
            InternalTerms terms = (InternalTerms)aggregation;
            if (terms.getBuckets().isEmpty()) continue;
            for (AbstractInternalBucket bucket : terms.getBuckets()) {
                ArrayList<AbstractInternalBucket> bucketList = (ArrayList<AbstractInternalBucket>)bucketMap.get(bucket.getKey());
                if (bucketList == null) {
                    bucketList = new ArrayList<AbstractInternalBucket>();
                    bucketMap.put(bucket.getKey(), bucketList);
                }
                bucketList.add(bucket);
            }
        }
        ArrayList<InternalMultiBucketAggregation.InternalBucket> reducedBuckets = new ArrayList<InternalMultiBucketAggregation.InternalBucket>();
        for (List sameTermBuckets : bucketMap.values()) {
            InternalMultiBucketAggregation.InternalBucket b = this.reduceBucket(sameTermBuckets, reduceContext);
            reducedBuckets.add(b);
        }
        return reducedBuckets;
    }

    @Override
    public InternalAggregation reduce(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
        long docCountError2;
        AbstractInternalBucket[] list;
        List<B> reducedBuckets;
        LocalBucketCountThresholds localBucketCountThresholds = reduceContext.asLocalBucketCountThresholds(this.bucketCountThresholds);
        long sumDocCountError = 0L;
        long otherDocCount = 0L;
        Object referenceTerms = null;
        for (InternalAggregation aggregation : aggregations) {
            InternalTerms terms = (InternalTerms)aggregation;
            if (aggregations.size() == 1 && terms.getDocCountError() > 0L) {
                this.hasSliceLevelDocCountError = true;
            }
            if (referenceTerms == null && !aggregation.getClass().equals(UnmappedTerms.class)) {
                referenceTerms = terms;
            }
            if (referenceTerms != null && !referenceTerms.getClass().equals(terms.getClass()) && !terms.getClass().equals(UnmappedTerms.class)) {
                throw new AggregationExecutionException("Merging/Reducing the aggregations failed when computing the aggregation [" + ((InternalAggregation)referenceTerms).getName() + "] because the field you gave in the aggregation query existed as two different types in two different indices");
            }
            otherDocCount += terms.getSumOfOtherDocCounts();
            long thisAggDocCountError = this.getDocCountError(terms, reduceContext);
            if (sumDocCountError != -1L) {
                sumDocCountError = thisAggDocCountError == -1L ? -1L : (sumDocCountError += thisAggDocCountError);
            }
            this.setDocCountError(thisAggDocCountError);
            for (AbstractInternalBucket bucket : terms.getBuckets()) {
                bucket.setDocCountError(docCountError -> docCountError - thisAggDocCountError);
            }
        }
        BucketOrder thisReduceOrder = this.getReduceOrder(aggregations);
        if (InternalOrder.isKeyOrder(thisReduceOrder)) {
            thisReduceOrder = InternalOrder.key(InternalOrder.isKeyAsc(thisReduceOrder));
            reducedBuckets = this.reduceMergeSort(aggregations, thisReduceOrder, reduceContext);
        } else {
            reducedBuckets = this.reduceLegacy(aggregations, reduceContext);
        }
        if (reduceContext.isFinalReduce() || reduceContext.isSliceLevel()) {
            size = Math.min(localBucketCountThresholds.getRequiredSize(), reducedBuckets.size());
            BucketPriorityQueue<MultiBucketsAggregation.Bucket> ordered = new BucketPriorityQueue<MultiBucketsAggregation.Bucket>(size, this.order.comparator());
            for (AbstractInternalBucket bucket : reducedBuckets) {
                if (sumDocCountError == -1L) {
                    bucket.setDocCountError(-1L);
                } else {
                    long finalSumDocCountError = sumDocCountError;
                    bucket.setDocCountError(docCountError -> docCountError + finalSumDocCountError);
                }
                if (bucket.getDocCount() >= localBucketCountThresholds.getMinDocCount()) {
                    AbstractInternalBucket removed = (AbstractInternalBucket)ordered.insertWithOverflow(bucket);
                    if (removed != null) {
                        otherDocCount += removed.getDocCount();
                        reduceContext.consumeBucketsAndMaybeBreak(-InternalTerms.countInnerBucket(removed));
                        continue;
                    }
                    reduceContext.consumeBucketsAndMaybeBreak(1);
                    continue;
                }
                reduceContext.consumeBucketsAndMaybeBreak(-InternalTerms.countInnerBucket(bucket));
            }
            list = this.createBucketsArray(ordered.size());
            for (int i = ordered.size() - 1; i >= 0; --i) {
                list[i] = (AbstractInternalBucket)ordered.pop();
            }
        } else {
            size = InternalOrder.isKeyOrder(this.order) && localBucketCountThresholds.getMinDocCount() == 0L ? Math.min(localBucketCountThresholds.getRequiredSize(), reducedBuckets.size()) : reducedBuckets.size();
            list = this.createBucketsArray(size);
            for (int i = 0; i < size; ++i) {
                reduceContext.consumeBucketsAndMaybeBreak(1);
                list[i] = (AbstractInternalBucket)reducedBuckets.get(i);
                if (sumDocCountError == -1L) {
                    list[i].setDocCountError(-1L);
                    continue;
                }
                long fSumDocCountError = sumDocCountError;
                list[i].setDocCountError(docCountError -> docCountError + fSumDocCountError);
            }
        }
        if (sumDocCountError == -1L) {
            docCountError2 = -1L;
        } else if (this.hasSliceLevelDocCountError) {
            docCountError2 = sumDocCountError;
        } else {
            long l = docCountError2 = aggregations.size() == 1 ? 0L : sumDocCountError;
        }
        if (reduceContext.isSliceLevel()) {
            Arrays.sort(list, thisReduceOrder.comparator());
        }
        return this.create(this.name, Arrays.asList(list), reduceContext.isFinalReduce() ? this.order : thisReduceOrder, docCountError2, otherDocCount);
    }

    @Override
    protected B reduceBucket(List<B> buckets, InternalAggregation.ReduceContext context) {
        assert (!buckets.isEmpty());
        long docCount = 0L;
        long docCountError = 0L;
        ArrayList<InternalAggregations> aggregationsList = new ArrayList<InternalAggregations>(buckets.size());
        for (AbstractInternalBucket bucket : buckets) {
            docCount += bucket.getDocCount();
            if (docCountError != -1L) {
                docCountError = !bucket.showDocCountError() ? -1L : (docCountError += bucket.getDocCountError());
            }
            aggregationsList.add((InternalAggregations)bucket.getAggregations());
        }
        InternalAggregations aggs = InternalAggregations.reduce(aggregationsList, context);
        return (B)this.createBucket(docCount, aggs, docCountError, (AbstractInternalBucket)buckets.get(0));
    }

    protected abstract void setDocCountError(long var1);

    protected abstract int getShardSize();

    protected abstract A create(String var1, List<B> var2, BucketOrder var3, long var4, long var6);

    protected abstract B[] createBucketsArray(int var1);

    abstract B createBucket(long var1, InternalAggregations var3, long var4, B var6);

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        InternalTerms that = (InternalTerms)obj;
        return Objects.equals(this.minDocCount, that.minDocCount) && Objects.equals(this.reduceOrder, that.reduceOrder) && Objects.equals(this.order, that.order) && Objects.equals(this.requiredSize, that.requiredSize);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.minDocCount, this.reduceOrder, this.order, this.requiredSize);
    }

    protected static XContentBuilder doXContentCommon(XContentBuilder builder, ToXContent.Params params, long docCountError, long otherDocCount, List<? extends AbstractInternalBucket> buckets) throws IOException {
        builder.field(DOC_COUNT_ERROR_UPPER_BOUND_FIELD_NAME.getPreferredName(), docCountError);
        builder.field(SUM_OF_OTHER_DOC_COUNTS.getPreferredName(), otherDocCount);
        builder.startArray(Aggregation.CommonFields.BUCKETS.getPreferredName());
        for (AbstractInternalBucket abstractInternalBucket : buckets) {
            abstractInternalBucket.toXContent(builder, params);
        }
        builder.endArray();
        return builder;
    }

    public static abstract class AbstractInternalBucket
    extends InternalMultiBucketAggregation.InternalBucket
    implements Terms.Bucket {
        abstract void setDocCountError(long var1);

        abstract void setDocCountError(Function<Long, Long> var1);

        abstract boolean showDocCountError();
    }

    public static abstract class Bucket<B extends Bucket<B>>
    extends AbstractInternalBucket
    implements KeyComparable<B> {
        long bucketOrd;
        protected long docCount;
        protected long docCountError;
        protected InternalAggregations aggregations;
        protected final boolean showDocCountError;
        protected final DocValueFormat format;

        protected Bucket(long docCount, InternalAggregations aggregations, boolean showDocCountError, long docCountError, DocValueFormat formatter) {
            this.showDocCountError = showDocCountError;
            this.format = formatter;
            this.docCount = docCount;
            this.aggregations = aggregations;
            this.docCountError = docCountError;
        }

        protected Bucket(StreamInput in, DocValueFormat formatter, boolean showDocCountError) throws IOException {
            this.showDocCountError = showDocCountError;
            this.format = formatter;
            this.docCount = in.readVLong();
            this.docCountError = -1L;
            if (showDocCountError) {
                this.docCountError = in.readLong();
            }
            this.aggregations = InternalAggregations.readFrom(in);
        }

        public final void writeTo(StreamOutput out) throws IOException {
            out.writeVLong(this.getDocCount());
            if (this.showDocCountError) {
                out.writeLong(this.docCountError);
            }
            this.aggregations.writeTo(out);
            this.writeTermTo(out);
        }

        protected abstract void writeTermTo(StreamOutput var1) throws IOException;

        @Override
        public long getDocCount() {
            return this.docCount;
        }

        @Override
        public long getDocCountError() {
            if (!this.showDocCountError) {
                throw new IllegalStateException("show_terms_doc_count_error is false");
            }
            return this.docCountError;
        }

        @Override
        public void setDocCountError(long docCountError) {
            this.docCountError = docCountError;
        }

        @Override
        public void setDocCountError(Function<Long, Long> updater) {
            this.docCountError = updater.apply(this.docCountError);
        }

        @Override
        public boolean showDocCountError() {
            return this.showDocCountError;
        }

        @Override
        public Aggregations getAggregations() {
            return this.aggregations;
        }

        public final XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            this.keyToXContent(builder);
            builder.field(Aggregation.CommonFields.DOC_COUNT.getPreferredName(), this.getDocCount());
            if (this.showDocCountError) {
                builder.field(DOC_COUNT_ERROR_UPPER_BOUND_FIELD_NAME.getPreferredName(), this.getDocCountError());
            }
            this.aggregations.toXContentInternal(builder, params);
            builder.endObject();
            return builder;
        }

        protected abstract XContentBuilder keyToXContent(XContentBuilder var1) throws IOException;

        public boolean equals(Object obj) {
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Bucket that = (Bucket)obj;
            return Objects.equals(this.docCount, that.docCount) && Objects.equals(this.docCountError, that.docCountError) && Objects.equals(this.aggregations, that.aggregations);
        }

        public int hashCode() {
            return Objects.hash(this.getClass(), this.docCount, this.docCountError, this.aggregations);
        }

        @FunctionalInterface
        public static interface Reader<B extends Bucket<B>> {
            public B read(StreamInput var1, DocValueFormat var2, boolean var3) throws IOException;
        }
    }
}

