/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.util.List;
import schemacrawler.crawl.AbstractDatabaseObject;
import schemacrawler.schema.NamedObject;
import schemacrawler.schema.NamedObjectKey;
import schemacrawler.schema.Routine;
import schemacrawler.schema.RoutineBodyType;
import schemacrawler.schema.RoutineType;
import schemacrawler.schema.Schema;
import us.fatehi.utility.CompareUtility;
import us.fatehi.utility.Utility;

abstract class MutableRoutine
extends AbstractDatabaseObject
implements Routine {
    private static final long serialVersionUID = 3906925686089134130L;
    private final StringBuffer definition;
    private RoutineBodyType routineBodyType;
    private final String specificName;
    private transient NamedObjectKey key;

    MutableRoutine(Schema schema, String name, String specificName) {
        super(schema, name);
        this.specificName = specificName;
        this.routineBodyType = RoutineBodyType.unknown;
        this.definition = new StringBuffer();
    }

    @Override
    public int compareTo(NamedObject obj) {
        int comparison = super.compareTo(obj);
        if (obj instanceof Routine) {
            Routine other = (Routine)obj;
            if (comparison == 0) {
                List thisParameters = this.getParameters();
                List otherParameters = other.getParameters();
                comparison = CompareUtility.compareLists(thisParameters, otherParameters);
            }
            if (comparison == 0) {
                comparison = this.getSpecificName().compareTo(other.getSpecificName());
            }
        }
        return comparison;
    }

    @Override
    public final String getDefinition() {
        return this.definition.toString();
    }

    @Override
    public final RoutineBodyType getRoutineBodyType() {
        return this.routineBodyType;
    }

    @Override
    public RoutineType getRoutineType() {
        return null;
    }

    @Override
    public final String getSpecificName() {
        if (Utility.isBlank((CharSequence)this.specificName)) {
            return this.getName();
        }
        return this.specificName;
    }

    @Override
    public final RoutineType getType() {
        return this.getRoutineType();
    }

    @Override
    public final boolean hasDefinition() {
        return this.definition.length() > 0;
    }

    @Override
    public final NamedObjectKey key() {
        this.buildKey();
        return this.key;
    }

    final void appendDefinition(String definition) {
        if (definition != null) {
            this.definition.append(definition);
        }
    }

    final void setRoutineBodyType(RoutineBodyType routineBodyType) {
        this.routineBodyType = routineBodyType;
    }

    private void buildKey() {
        if (this.key != null) {
            return;
        }
        this.key = super.key().with(this.specificName);
    }
}

