-- SchemaCrawler
-- http://www.schemacrawler.com
-- Copyright (c) 2000-2025, Sualeh Fatehi <sualeh@hotmail.com>.
-- All rights reserved.
-- SPDX-License-Identifier: EPL-2.0

-- Not used by default. Used only when table column retrieval strategy is
-- explicitly set to data_dictionary_all
SELECT
  C.TABLE_SCHEMA AS TABLE_CAT,
  NULL AS TABLE_SCHEM,
  C.TABLE_NAME,
  C.COLUMN_NAME,
  C.ORDINAL_POSITION,
  C.COLUMN_DEFAULT AS COLUMN_DEF,
  CASE WHEN C.IS_NULLABLE = 'YES' THEN 1 ELSE 0 END AS NULLABLE,
  C.DATA_TYPE AS TYPE_NAME,
  C.CHARACTER_MAXIMUM_LENGTH,
  C.CHARACTER_OCTET_LENGTH AS COLUMN_SIZE,
  C.NUMERIC_PRECISION AS DECIMAL_DIGITS,
  C.NUMERIC_SCALE,
  C.DATETIME_PRECISION,
  CASE WHEN EXTRA = 'auto_increment' THEN 1 ELSE 0 END AS IS_AUTOINCREMENT,
  CASE WHEN EXTRA LIKE '%GENERATED%' THEN 1 ELSE 0 END AS IS_GENERATEDCOLUMN,
  C.CHARACTER_SET_NAME,
  C.COLLATION_NAME,
  C.COLUMN_TYPE,
  C.COLUMN_KEY,
  C.EXTRA,
  C.PRIVILEGES,
  C.COLUMN_COMMENT AS REMARKS,
  C.GENERATION_EXPRESSION
FROM
  INFORMATION_SCHEMA.COLUMNS C
ORDER BY
  TABLE_CAT,
  TABLE_NAME,
  COLUMN_NAME
