/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.drawable;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import net.sf.sdedit.Constants;
import net.sf.sdedit.diagram.Diagram;
import net.sf.sdedit.drawable.DrawableLabel;

public abstract class Drawable
implements Constants {
    private int top;
    private int left;
    private int height;
    private int width;
    private boolean visible = true;
    private Diagram diagram;
    private List<DrawableLabel> labels;

    protected Drawable(Diagram diagram) {
        this.diagram = diagram;
        this.labels = new ArrayList<DrawableLabel>(1);
    }

    public DrawableLabel addLabel() {
        DrawableLabel label = new DrawableLabel(this);
        this.labels.add(label);
        return label;
    }

    public DrawableLabel getLabel() {
        if (this.labels.size() == 0) {
            return null;
        }
        return this.labels.get(0);
    }

    public DrawableLabel getLabel(int i) {
        if (i < 0 || i >= this.labels.size()) {
            return null;
        }
        return this.labels.get(i);
    }

    protected Diagram getDiagram() {
        return this.diagram;
    }

    public boolean hasLabel() {
        return this.labels.size() > 0;
    }

    public void draw(Graphics2D g2d) {
        Graphics2D g2 = (Graphics2D)g2d.create();
        this.drawObject(g2);
        g2.dispose();
    }

    protected abstract void drawObject(Graphics2D var1);

    public abstract void computeLayoutInformation();

    public final int getTop() {
        return this.top;
    }

    public final int getLeft() {
        return this.left;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public final void setHeight(int height) {
        this.height = height;
    }

    public final void setLeft(int left) {
        this.left = left;
    }

    public final void setTop(int top) {
        this.top = top;
    }

    public final void setWidth(int width) {
        this.width = width;
    }

    public final int getBottom() {
        return this.top + this.height;
    }

    public final int getRight() {
        return this.left + this.width;
    }

    public final void setRight(int right) {
        this.setWidth(right - this.left);
    }

    public final void setBottom(int bottom) {
        this.setHeight(bottom - this.getTop());
    }

    public Rectangle getRectangle() {
        Rectangle r = new Rectangle();
        r.x = this.getLeft();
        r.y = this.getTop();
        r.width = this.getWidth();
        r.height = this.getHeight();
        return r;
    }

    public boolean intersects(Rectangle rectangle) {
        return rectangle.intersects(this.left - 10, this.top - 10, this.width + 20, this.height + 20);
    }

    public boolean contains(Point point) {
        int x = point.x;
        int y = point.y;
        return x >= this.left && x <= this.left + this.width && y >= this.top && y <= this.top + this.height;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public final void setVisible(boolean visible) {
        this.visible = visible;
    }
}

