/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.script;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.MalformedInputException;
import java.security.InvalidParameterException;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.sf.json.JSON;
import net.sf.json.JSONObject;
import org.parosproxy.paros.Constant;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.zaproxy.zap.extension.api.ApiAction;
import org.zaproxy.zap.extension.api.ApiException;
import org.zaproxy.zap.extension.api.ApiImplementor;
import org.zaproxy.zap.extension.api.ApiResponse;
import org.zaproxy.zap.extension.api.ApiResponseElement;
import org.zaproxy.zap.extension.api.ApiResponseList;
import org.zaproxy.zap.extension.api.ApiResponseSet;
import org.zaproxy.zap.extension.api.ApiView;
import org.zaproxy.zap.extension.script.ExtensionScript;
import org.zaproxy.zap.extension.script.ScriptEngineWrapper;
import org.zaproxy.zap.extension.script.ScriptType;
import org.zaproxy.zap.extension.script.ScriptVars;
import org.zaproxy.zap.extension.script.ScriptWrapper;

public class ScriptAPI
extends ApiImplementor {
    private static final String PREFIX = "script";
    private static final String VIEW_ENGINES = "listEngines";
    private static final String VIEW_TYPES = "listTypes";
    private static final String VIEW_GLOBAL_VAR = "globalVar";
    private static final String VIEW_GLOBAL_CUSTOM_VAR = "globalCustomVar";
    private static final String VIEW_GLOBAL_VARS = "globalVars";
    private static final String VIEW_GLOBAL_CUSTOM_VARS = "globalCustomVars";
    private static final String VIEW_SCRIPTS = "listScripts";
    private static final String VIEW_SCRIPT_VAR = "scriptVar";
    private static final String VIEW_SCRIPT_CUSTOM_VAR = "scriptCustomVar";
    private static final String VIEW_SCRIPT_VARS = "scriptVars";
    private static final String VIEW_SCRIPT_CUSTOM_VARS = "scriptCustomVars";
    private static final String ACTION_ENABLE = "enable";
    private static final String ACTION_DISABLE = "disable";
    private static final String ACTION_RUN_STANDALONE = "runStandAloneScript";
    private static final String ACTION_LOAD = "load";
    private static final String ACTION_REMOVE = "remove";
    private static final String ACTION_CLEAR_GLOBAL_VAR = "clearGlobalVar";
    private static final String ACTION_CLEAR_GLOBAL_CUSTOM_VAR = "clearGlobalCustomVar";
    private static final String ACTION_CLEAR_GLOBAL_VARS = "clearGlobalVars";
    private static final String ACTION_CLEAR_SCRIPT_VAR = "clearScriptVar";
    private static final String ACTION_CLEAR_SCRIPT_CUSTOM_VAR = "clearScriptCustomVar";
    private static final String ACTION_CLEAR_SCRIPT_VARS = "clearScriptVars";
    private static final String ACTION_SET_GLOBAL_VAR = "setGlobalVar";
    private static final String ACTION_SET_SCRIPT_VAR = "setScriptVar";
    private static final String ACTION_PARAM_SCRIPT_NAME = "scriptName";
    private static final String ACTION_PARAM_SCRIPT_DESC = "scriptDescription";
    private static final String ACTION_PARAM_SCRIPT_TYPE = "scriptType";
    private static final String ACTION_PARAM_SCRIPT_ENGINE = "scriptEngine";
    private static final String ACTION_PARAM_FILE_NAME = "fileName";
    private static final String ACTION_PARAM_CHARSET = "charset";
    private static final String PARAM_VAR_KEY = "varKey";
    private static final String PARAM_VAR_VALUE = "varValue";
    private ExtensionScript extension;

    public ScriptAPI(ExtensionScript extension) {
        this.extension = extension;
        this.addApiView(new ApiView(VIEW_ENGINES, new String[0], new String[0]));
        this.addApiView(new ApiView(VIEW_TYPES));
        this.addApiView(new ApiView(VIEW_SCRIPTS, new String[0], new String[0]));
        this.addApiView(new ApiView(VIEW_GLOBAL_VAR, new String[]{PARAM_VAR_KEY}));
        this.addApiView(new ApiView(VIEW_GLOBAL_CUSTOM_VAR, new String[]{PARAM_VAR_KEY}));
        this.addApiView(new ApiView(VIEW_GLOBAL_VARS));
        this.addApiView(new ApiView(VIEW_GLOBAL_CUSTOM_VARS));
        this.addApiView(new ApiView(VIEW_SCRIPT_VAR, new String[]{ACTION_PARAM_SCRIPT_NAME, PARAM_VAR_KEY}));
        this.addApiView(new ApiView(VIEW_SCRIPT_CUSTOM_VAR, new String[]{ACTION_PARAM_SCRIPT_NAME, PARAM_VAR_KEY}));
        this.addApiView(new ApiView(VIEW_SCRIPT_VARS, new String[]{ACTION_PARAM_SCRIPT_NAME}));
        this.addApiView(new ApiView(VIEW_SCRIPT_CUSTOM_VARS, new String[]{ACTION_PARAM_SCRIPT_NAME}));
        this.addApiAction(new ApiAction(ACTION_ENABLE, new String[]{ACTION_PARAM_SCRIPT_NAME}, new String[0]));
        this.addApiAction(new ApiAction(ACTION_DISABLE, new String[]{ACTION_PARAM_SCRIPT_NAME}, new String[0]));
        this.addApiAction(new ApiAction(ACTION_LOAD, new String[]{ACTION_PARAM_SCRIPT_NAME, ACTION_PARAM_SCRIPT_TYPE, ACTION_PARAM_SCRIPT_ENGINE, ACTION_PARAM_FILE_NAME}, new String[]{ACTION_PARAM_SCRIPT_DESC, ACTION_PARAM_CHARSET}));
        this.addApiAction(new ApiAction(ACTION_REMOVE, new String[]{ACTION_PARAM_SCRIPT_NAME}, new String[0]));
        this.addApiAction(new ApiAction(ACTION_RUN_STANDALONE, new String[]{ACTION_PARAM_SCRIPT_NAME}, new String[0]));
        this.addApiAction(new ApiAction(ACTION_CLEAR_GLOBAL_VAR, new String[]{PARAM_VAR_KEY}));
        this.addApiAction(new ApiAction(ACTION_CLEAR_GLOBAL_CUSTOM_VAR, new String[]{PARAM_VAR_KEY}));
        this.addApiAction(new ApiAction(ACTION_CLEAR_GLOBAL_VARS));
        this.addApiAction(new ApiAction(ACTION_CLEAR_SCRIPT_VAR, new String[]{ACTION_PARAM_SCRIPT_NAME, PARAM_VAR_KEY}));
        this.addApiAction(new ApiAction(ACTION_CLEAR_SCRIPT_CUSTOM_VAR, new String[]{ACTION_PARAM_SCRIPT_NAME, PARAM_VAR_KEY}));
        this.addApiAction(new ApiAction(ACTION_CLEAR_SCRIPT_VARS, new String[]{ACTION_PARAM_SCRIPT_NAME}));
        this.addApiAction(new ApiAction(ACTION_SET_SCRIPT_VAR, new String[]{ACTION_PARAM_SCRIPT_NAME, PARAM_VAR_KEY}, new String[]{PARAM_VAR_VALUE}));
        this.addApiAction(new ApiAction(ACTION_SET_GLOBAL_VAR, new String[]{PARAM_VAR_KEY}, new String[]{PARAM_VAR_VALUE}));
    }

    @Override
    public String getPrefix() {
        return PREFIX;
    }

    @Override
    public ApiResponse handleApiView(String name, JSONObject params) throws ApiException {
        if (VIEW_SCRIPTS.equals(name)) {
            ApiResponseList result = new ApiResponseList(name);
            for (ScriptType type : this.extension.getScriptTypes()) {
                for (ScriptWrapper script : this.extension.getScripts(type)) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("name", script.getName());
                    map.put("type", script.getTypeName());
                    map.put("engine", script.getEngineName());
                    map.put("description", script.getDescription());
                    map.put("error", Boolean.toString(script.isError()));
                    if (script.isError()) {
                        map.put("lastError", script.getLastErrorDetails());
                    }
                    if (type.isEnableable()) {
                        map.put("enabled", Boolean.toString(script.isEnabled()));
                    }
                    result.addItem(new ApiResponseSet("Script", map));
                }
            }
            return result;
        }
        if (VIEW_ENGINES.equals(name)) {
            ApiResponseList result = new ApiResponseList(name);
            for (String engine : this.extension.getScriptingEngines()) {
                result.addItem(new ApiResponseElement("engine", engine));
            }
            return result;
        }
        if (VIEW_TYPES.equals(name)) {
            ApiResponseList result = new ApiResponseList(name);
            for (ScriptType type : this.extension.getScriptTypes()) {
                HashMap<String, String> data = new HashMap<String, String>();
                data.put("name", type.getName());
                data.put("uiName", Constant.messages.getString(type.getI18nKey()));
                String descKey = type.getI18nKey() + ".desc";
                String description = Constant.messages.containsKey(descKey) ? Constant.messages.getString(descKey) : "";
                data.put("description", description);
                data.put("enableable", String.valueOf(type.isEnableable()));
                if (type.isEnableable()) {
                    data.put("enabledByDefault", String.valueOf(type.isEnabledByDefault()));
                }
                result.addItem(new ApiResponseSet("type", data));
            }
            return result;
        }
        if (VIEW_GLOBAL_VAR.equals(name)) {
            String value = ScriptVars.getGlobalVar(params.getString(PARAM_VAR_KEY));
            ScriptAPI.validateVarValue(value);
            return new ApiResponseElement(name, value);
        }
        if (VIEW_GLOBAL_CUSTOM_VAR.equals(name)) {
            Object value = ScriptVars.getGlobalCustomVar(params.getString(PARAM_VAR_KEY));
            ScriptAPI.validateVarValue(value);
            return new ApiResponseElement(name, value.toString());
        }
        if (VIEW_GLOBAL_VARS.equals(name)) {
            return new ScriptVarsResponse(name, ScriptVars.getGlobalVars());
        }
        if (VIEW_GLOBAL_CUSTOM_VARS.equals(name)) {
            return new ScriptVarsResponse(name, ScriptAPI.convertCustomVars(ScriptVars.getGlobalCustomVars()));
        }
        if (VIEW_SCRIPT_VAR.equals(name)) {
            String value = ScriptVars.getScriptVar(this.getAndValidateScriptName(params), params.getString(PARAM_VAR_KEY));
            ScriptAPI.validateVarValue(value);
            return new ApiResponseElement(name, value);
        }
        if (VIEW_SCRIPT_CUSTOM_VAR.equals(name)) {
            Object value = ScriptVars.getScriptCustomVar(this.getAndValidateScriptName(params), params.getString(PARAM_VAR_KEY));
            ScriptAPI.validateVarValue(value);
            return new ApiResponseElement(name, value.toString());
        }
        if (VIEW_SCRIPT_VARS.equals(name)) {
            return new ScriptVarsResponse(name, ScriptVars.getScriptVars(this.getAndValidateScriptName(params)));
        }
        if (VIEW_SCRIPT_CUSTOM_VARS.equals(name)) {
            return new ScriptVarsResponse(name, ScriptAPI.convertCustomVars(ScriptVars.getScriptCustomVars(this.getAndValidateScriptName(params))));
        }
        throw new ApiException(ApiException.Type.BAD_VIEW);
    }

    private static void validateVarValue(Object varValue) throws ApiException {
        if (varValue == null) {
            throw new ApiException(ApiException.Type.DOES_NOT_EXIST, PARAM_VAR_KEY);
        }
    }

    private String getAndValidateScriptName(JSONObject params) throws ApiException {
        String scriptName = params.getString(ACTION_PARAM_SCRIPT_NAME);
        if (this.extension.getScript(scriptName) == null) {
            throw new ApiException(ApiException.Type.DOES_NOT_EXIST, ACTION_PARAM_SCRIPT_NAME);
        }
        return scriptName;
    }

    private static Map<String, String> convertCustomVars(Map<String, Object> vars) {
        return vars.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> e.getValue().toString()));
    }

    @Override
    public ApiResponse handleApiAction(String name, JSONObject params) throws ApiException {
        if (ACTION_ENABLE.equals(name)) {
            ScriptWrapper script = this.extension.getScript(params.getString(ACTION_PARAM_SCRIPT_NAME));
            if (script == null) {
                throw new ApiException(ApiException.Type.DOES_NOT_EXIST, ACTION_PARAM_SCRIPT_NAME);
            }
            if (!script.getType().isEnableable()) {
                throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, ACTION_PARAM_SCRIPT_NAME);
            }
            if (script.getEngine() == null) {
                throw new ApiException(ApiException.Type.BAD_STATE, "Unable to enable the script, script engine not available: " + script.getEngineName());
            }
            this.extension.setEnabled(script, true);
            return ApiResponseElement.OK;
        }
        if (ACTION_DISABLE.equals(name)) {
            ScriptWrapper script = this.extension.getScript(params.getString(ACTION_PARAM_SCRIPT_NAME));
            if (script == null) {
                throw new ApiException(ApiException.Type.DOES_NOT_EXIST, ACTION_PARAM_SCRIPT_NAME);
            }
            if (!script.getType().isEnableable()) {
                throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, ACTION_PARAM_SCRIPT_NAME);
            }
            this.extension.setEnabled(script, false);
            return ApiResponseElement.OK;
        }
        if (ACTION_LOAD.equals(name)) {
            ScriptEngineWrapper engine;
            ScriptType type = this.extension.getScriptType(params.getString(ACTION_PARAM_SCRIPT_TYPE));
            if (type == null) {
                throw new ApiException(ApiException.Type.DOES_NOT_EXIST, ACTION_PARAM_SCRIPT_TYPE);
            }
            try {
                engine = this.extension.getEngineWrapper(params.getString(ACTION_PARAM_SCRIPT_ENGINE));
            }
            catch (InvalidParameterException e) {
                throw new ApiException(ApiException.Type.DOES_NOT_EXIST, ACTION_PARAM_SCRIPT_ENGINE, e);
            }
            File file = new File(params.getString(ACTION_PARAM_FILE_NAME));
            if (!file.exists()) {
                throw new ApiException(ApiException.Type.DOES_NOT_EXIST, file.getAbsolutePath());
            }
            if (this.extension.getScript(params.getString(ACTION_PARAM_SCRIPT_NAME)) != null) {
                throw new ApiException(ApiException.Type.ALREADY_EXISTS, ACTION_PARAM_SCRIPT_NAME);
            }
            ScriptWrapper script = new ScriptWrapper(params.getString(ACTION_PARAM_SCRIPT_NAME), this.getParam(params, ACTION_PARAM_SCRIPT_DESC, ""), engine, type, true, file);
            Charset charset = ScriptAPI.getCharset(params);
            try {
                if (charset != null) {
                    this.extension.loadScript(script, charset);
                } else {
                    this.extension.loadScript(script);
                }
            }
            catch (MalformedInputException e) {
                throw new ApiException(charset != null ? ApiException.Type.ILLEGAL_PARAMETER : ApiException.Type.MISSING_PARAMETER, ACTION_PARAM_CHARSET, e);
            }
            catch (IOException e) {
                throw new ApiException(ApiException.Type.INTERNAL_ERROR, (Throwable)e);
            }
            this.extension.addScript(script, false);
            return ApiResponseElement.OK;
        }
        if (ACTION_REMOVE.equals(name)) {
            ScriptWrapper script = this.extension.getScript(params.getString(ACTION_PARAM_SCRIPT_NAME));
            if (script == null) {
                throw new ApiException(ApiException.Type.DOES_NOT_EXIST, ACTION_PARAM_SCRIPT_NAME);
            }
            this.extension.removeScript(script);
            return ApiResponseElement.OK;
        }
        if (ACTION_RUN_STANDALONE.equals(name)) {
            ScriptWrapper script = this.extension.getScript(params.getString(ACTION_PARAM_SCRIPT_NAME));
            if (script == null) {
                throw new ApiException(ApiException.Type.DOES_NOT_EXIST, ACTION_PARAM_SCRIPT_NAME);
            }
            if (!script.getType().getName().equals("standalone")) {
                throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, "Parameter scriptName does not match a standalone script.");
            }
            try {
                this.extension.invokeScript(script);
            }
            catch (Exception e) {
                throw new ApiException(ApiException.Type.INTERNAL_ERROR, (Throwable)e);
            }
            return ApiResponseElement.OK;
        }
        if (ACTION_CLEAR_GLOBAL_VAR.equals(name)) {
            ScriptVars.setGlobalVar(params.getString(PARAM_VAR_KEY), null);
            return ApiResponseElement.OK;
        }
        if (ACTION_CLEAR_GLOBAL_CUSTOM_VAR.equals(name)) {
            ScriptVars.setGlobalCustomVar(params.getString(PARAM_VAR_KEY), null);
            return ApiResponseElement.OK;
        }
        if (ACTION_CLEAR_GLOBAL_VARS.equals(name)) {
            ScriptVars.clearGlobalVars();
            return ApiResponseElement.OK;
        }
        if (ACTION_CLEAR_SCRIPT_VAR.equals(name)) {
            ScriptVars.setScriptVar(this.getAndValidateScriptName(params), params.getString(PARAM_VAR_KEY), null);
            return ApiResponseElement.OK;
        }
        if (ACTION_CLEAR_SCRIPT_CUSTOM_VAR.equals(name)) {
            ScriptVars.setScriptCustomVar(this.getAndValidateScriptName(params), params.getString(PARAM_VAR_KEY), null);
            return ApiResponseElement.OK;
        }
        if (ACTION_CLEAR_SCRIPT_VARS.equals(name)) {
            ScriptVars.clearScriptVars(this.getAndValidateScriptName(params));
            return ApiResponseElement.OK;
        }
        if (ACTION_SET_GLOBAL_VAR.equals(name)) {
            ScriptVars.setGlobalVar(params.getString(PARAM_VAR_KEY), params.getString(PARAM_VAR_VALUE));
            return ApiResponseElement.OK;
        }
        if (ACTION_SET_SCRIPT_VAR.equals(name)) {
            ScriptVars.setScriptVar(this.getAndValidateScriptName(params), params.getString(PARAM_VAR_KEY), params.getString(PARAM_VAR_VALUE));
            return ApiResponseElement.OK;
        }
        throw new ApiException(ApiException.Type.BAD_VIEW);
    }

    private static Charset getCharset(JSONObject params) throws ApiException {
        if (!params.has(ACTION_PARAM_CHARSET)) {
            return null;
        }
        String charsetName = params.getString(ACTION_PARAM_CHARSET);
        if (charsetName.isEmpty()) {
            return null;
        }
        try {
            return Charset.forName(charsetName);
        }
        catch (IllegalArgumentException e) {
            throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, ACTION_PARAM_CHARSET, e);
        }
    }

    private static class ScriptVarsResponse
    extends ApiResponse {
        private final ApiResponseSet<String> defaultResponse;
        private final ApiResponseList xmlResponse;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ScriptVarsResponse(final String name, Map<String, String> vars) {
            super(name);
            this.defaultResponse = new ApiResponseSet<String>(name, vars){

                @Override
                public JSON toJSON() {
                    JSONObject response = new JSONObject();
                    response.put(name, super.toJSON());
                    return response;
                }
            };
            this.xmlResponse = new ApiResponseList(name);
            Map<String, String> map = vars;
            synchronized (map) {
                for (Map.Entry<String, String> entry : vars.entrySet()) {
                    HashMap<String, String> varData = new HashMap<String, String>();
                    varData.put("key", entry.getKey());
                    varData.put("value", entry.getValue());
                    this.xmlResponse.addItem(new ApiResponseSet("var", varData));
                }
            }
        }

        @Override
        public JSON toJSON() {
            return this.defaultResponse.toJSON();
        }

        @Override
        public void toXML(Document doc, Element rootElement) {
            this.xmlResponse.toXML(doc, rootElement);
        }

        @Override
        public void toHTML(StringBuilder sb) {
            this.defaultResponse.toHTML(sb);
        }

        @Override
        public String toString(int indent) {
            return this.defaultResponse.toString(indent);
        }
    }
}

