/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.link;

import java.awt.Point;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.freeplane.core.io.IAttributeHandler;
import org.freeplane.core.io.IElementDOMHandler;
import org.freeplane.core.io.IReadCompletionListener;
import org.freeplane.core.io.ITreeWriter;
import org.freeplane.core.io.ReadManager;
import org.freeplane.core.io.xml.TreeXmlReader;
import org.freeplane.core.io.xml.TreeXmlWriter;
import org.freeplane.core.resources.TranslatedObject;
import org.freeplane.core.util.ColorUtils;
import org.freeplane.core.util.Hyperlink;
import org.freeplane.features.link.ArrowType;
import org.freeplane.features.link.ConnectorArrows;
import org.freeplane.features.link.ConnectorModel;
import org.freeplane.features.link.ConnectorShape;
import org.freeplane.features.link.LinkController;
import org.freeplane.features.link.NodeLinkModel;
import org.freeplane.features.link.NodeLinks;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.styles.IStyle;
import org.freeplane.features.styles.MapStyleModel;
import org.freeplane.features.styles.StyleFactory;
import org.freeplane.features.styles.StyleTranslatedObject;
import org.freeplane.features.url.MapVersionInterpreter;
import org.freeplane.n3.nanoxml.XMLElement;

public class LinkBuilder
implements IElementDOMHandler,
IReadCompletionListener {
    private static final int FREEPLANE_VERSION_WITH_CURVED_LOOPED_CONNECTORS = 3;
    private static final String FORMAT_AS_HYPERLINK = "FORMAT_AS_HYPERLINK";
    private static final String LINK = "LINK";
    private final HashSet<NodeLinkModel> processedLinks;
    private final LinkController linkController;

    public LinkBuilder(LinkController linkController) {
        this.linkController = linkController;
        this.processedLinks = new HashSet();
    }

    private NodeLinkModel createArrowLink(NodeModel source, String targetID) {
        ConnectorModel connectorModel = new ConnectorModel(source, targetID);
        return connectorModel;
    }

    @Override
    public Object createElement(Object parent, String tag, XMLElement attributes) {
        if (tag.equals("arrowlink")) {
            return this.createArrowLink((NodeModel)parent, null);
        }
        return null;
    }

    @Override
    public void readingCompleted(NodeModel topNode, Map<String, String> newIds) {
        for (NodeLinkModel arrowLink : this.processedLinks) {
            String targetID;
            String id = arrowLink.getTargetID();
            String newId = newIds.get(id);
            String string = targetID = newId != null ? newId : id;
            if (targetID == null) {
                new NullPointerException().printStackTrace();
                continue;
            }
            arrowLink.setTargetID(targetID);
            NodeModel source = arrowLink.getSource();
            NodeLinks.createLinkExtension(source).addArrowlink(arrowLink);
        }
        this.processedLinks.clear();
    }

    private void registerAttributeHandlers(ReadManager reader) {
        reader.addAttributeHandler("node", LINK, new IAttributeHandler(){

            @Override
            public void setAttribute(Object userObject, String value) {
                NodeModel node = (NodeModel)userObject;
                LinkBuilder.this.linkController.loadLink(node, value);
                Collection<NodeLinkModel> links = NodeLinks.getLinks(node);
                LinkBuilder.this.processedLinks.addAll(links);
            }
        });
        IAttributeHandler hyperlinkHandler = new IAttributeHandler(){

            @Override
            public void setAttribute(Object userObject, String value) {
                NodeModel node = (NodeModel)userObject;
                LinkBuilder.this.linkController.loadLinkFormat(node, Boolean.parseBoolean(value));
            }
        };
        reader.addAttributeHandler("node", FORMAT_AS_HYPERLINK, hyperlinkHandler);
        reader.addAttributeHandler("stylenode", FORMAT_AS_HYPERLINK, hyperlinkHandler);
        reader.addAttributeHandler("arrowlink", "EDGE_LIKE", new IAttributeHandler(){

            @Override
            public void setAttribute(Object userObject, String value) {
                ConnectorModel arrowLink = (ConnectorModel)userObject;
                arrowLink.setShape(Optional.of(ConnectorShape.EDGE_LIKE));
            }
        });
        reader.addAttributeHandler("arrowlink", "SHAPE", new IAttributeHandler(){

            @Override
            public void setAttribute(Object userObject, String value) {
                ConnectorModel arrowLink = (ConnectorModel)userObject;
                arrowLink.setShape(Optional.of(ConnectorShape.valueOf(value)));
            }
        });
        reader.addAttributeHandler("arrowlink", "DASH", new IAttributeHandler(){

            @Override
            public void setAttribute(Object userObject, String value) {
                ConnectorModel arrowLink = (ConnectorModel)userObject;
                String[] split = value.isEmpty() ? new String[]{} : value.split(" ");
                int[] dash = new int[split.length];
                int i = 0;
                for (String s : split) {
                    dash[i++] = Integer.parseInt(s);
                }
                arrowLink.setDash(Optional.of(dash));
            }
        });
        reader.addAttributeHandler("arrowlink", "DESTINATION", new IAttributeHandler(){

            @Override
            public void setAttribute(Object userObject, String value) {
                ConnectorModel arrowLink = (ConnectorModel)userObject;
                arrowLink.setTargetID(value);
                LinkBuilder.this.processedLinks.add(arrowLink);
            }
        });
        reader.addAttributeHandler("arrowlink", "SOURCE_LABEL", new IAttributeHandler(){

            @Override
            public void setAttribute(Object userObject, String value) {
                ConnectorModel arrowLink = (ConnectorModel)userObject;
                arrowLink.setSourceLabel(value.toString());
            }
        });
        reader.addAttributeHandler("arrowlink", "MIDDLE_LABEL", new IAttributeHandler(){

            @Override
            public void setAttribute(Object userObject, String value) {
                ConnectorModel arrowLink = (ConnectorModel)userObject;
                arrowLink.setMiddleLabel(value.toString());
            }
        });
        reader.addAttributeHandler("arrowlink", "TARGET_LABEL", new IAttributeHandler(){

            @Override
            public void setAttribute(Object userObject, String value) {
                ConnectorModel arrowLink = (ConnectorModel)userObject;
                arrowLink.setTargetLabel(value.toString());
            }
        });
        reader.addAttributeHandler("arrowlink", "STARTINCLINATION", new IAttributeHandler(){

            @Override
            public void setAttribute(Object userObject, String value) {
                ConnectorModel arrowLink = (ConnectorModel)userObject;
                arrowLink.setStartInclination(TreeXmlReader.xmlToPoint(value.toString()));
            }
        });
        reader.addAttributeHandler("arrowlink", "ENDINCLINATION", new IAttributeHandler(){

            @Override
            public void setAttribute(Object userObject, String value) {
                ConnectorModel arrowLink = (ConnectorModel)userObject;
                arrowLink.setEndInclination(TreeXmlReader.xmlToPoint(value.toString()));
            }
        });
        reader.addAttributeHandler("arrowlink", "STARTARROW", new IAttributeHandler(){

            @Override
            public void setAttribute(Object userObject, String value) {
                ArrowType start = ArrowType.valueOf(value.toUpperCase(Locale.ENGLISH));
                ConnectorModel arrowLink = (ConnectorModel)userObject;
                ArrowType end = arrowLink.getArrows().orElse((ConnectorArrows)ConnectorArrows.NONE).end;
                arrowLink.setArrows(ConnectorArrows.of(start, end));
            }
        });
        reader.addAttributeHandler("arrowlink", "ENDARROW", new IAttributeHandler(){

            @Override
            public void setAttribute(Object userObject, String value) {
                ArrowType end = ArrowType.valueOf(value.toUpperCase(Locale.ENGLISH));
                ConnectorModel arrowLink = (ConnectorModel)userObject;
                ArrowType start = arrowLink.getArrows().orElse((ConnectorArrows)ConnectorArrows.NONE).start;
                arrowLink.setArrows(ConnectorArrows.of(start, end));
            }
        });
        reader.addAttributeHandler("arrowlink", "WIDTH", new IAttributeHandler(){

            @Override
            public void setAttribute(Object userObject, String value) {
                ConnectorModel arrowLink = (ConnectorModel)userObject;
                arrowLink.setWidth(Optional.of(Integer.parseInt(value.toString())));
            }
        });
        reader.addAttributeHandler("arrowlink", "FONT_FAMILY", new IAttributeHandler(){

            @Override
            public void setAttribute(Object userObject, String value) {
                ConnectorModel arrowLink = (ConnectorModel)userObject;
                arrowLink.setLabelFontFamily(Optional.of(value.toString()));
            }
        });
        reader.addAttributeHandler("arrowlink", "FONT_SIZE", new IAttributeHandler(){

            @Override
            public void setAttribute(Object userObject, String value) {
                ConnectorModel arrowLink = (ConnectorModel)userObject;
                arrowLink.setLabelFontSize(Optional.of(Integer.parseInt(value.toString())));
            }
        });
        reader.addAttributeHandler("arrowlink", "STYLE_REF", new IAttributeHandler(){

            @Override
            public void setAttribute(Object userObject, String value) {
                ConnectorModel arrowLink = (ConnectorModel)userObject;
                arrowLink.setStyle(StyleFactory.create(value));
            }
        });
        reader.addAttributeHandler("arrowlink", "LOCALIZED_STYLE_REF", new IAttributeHandler(){

            @Override
            public void setAttribute(Object userObject, String value) {
                ConnectorModel arrowLink = (ConnectorModel)userObject;
                arrowLink.setStyle(StyleFactory.create(TranslatedObject.format(value)));
            }
        });
    }

    @Override
    public void endElement(Object parent, String tag, Object element, XMLElement dom) {
        ConnectorModel arrowLink = (ConnectorModel)element;
        String color = dom.getAttribute("COLOR", null);
        String transparency = dom.getAttribute("TRANSPARENCY", null);
        if (color != null) {
            arrowLink.setColor(Optional.of(ColorUtils.stringToColor(color)));
            if (transparency == null) {
                arrowLink.setAlpha(Optional.of(255));
            }
        }
        if (transparency != null) {
            arrowLink.setAlpha(Optional.of(Integer.parseInt(transparency)));
        }
        this.fixSelfLoopedConnectorShape(arrowLink);
    }

    private void fixSelfLoopedConnectorShape(ConnectorModel connector) {
        if (connector.isSelfLink() && ConnectorShape.CUBIC_CURVE.equals(connector.getShape()) && MapVersionInterpreter.isOlderThan(connector.getSource().getMap(), 3)) {
            connector.setShape(Optional.of(ConnectorShape.LINE));
        }
    }

    void registerBy(ReadManager reader) {
        reader.addElementHandler("arrowlink", this);
        this.registerAttributeHandlers(reader);
        reader.addReadCompletionListener(this);
    }

    public void save(ITreeWriter writer, ConnectorModel model) throws IOException {
        Point endInclination;
        NodeModel target = model.getTarget();
        if (target == null) {
            return;
        }
        XMLElement arrowLink = new XMLElement();
        arrowLink.setName("arrowlink");
        IStyle style = model.getStyle();
        if (!MapStyleModel.DEFAULT_STYLE.equals(style)) {
            String value = StyleTranslatedObject.toKeyString(style);
            if (style instanceof StyleTranslatedObject) {
                arrowLink.setAttribute("LOCALIZED_STYLE_REF", value);
            } else {
                arrowLink.setAttribute("STYLE_REF", value);
            }
        }
        model.getShape().ifPresent(shape -> arrowLink.setAttribute("SHAPE", shape.name()));
        model.getColor().ifPresent(color -> arrowLink.setAttribute("COLOR", ColorUtils.colorToString(color)));
        model.getWidth().ifPresent(width -> arrowLink.setAttribute("WIDTH", Integer.toString(width)));
        model.getAlpha().ifPresent(alpha -> arrowLink.setAttribute("TRANSPARENCY", Integer.toString(alpha)));
        model.getDash().ifPresent(dash -> {
            StringBuilder sb = new StringBuilder(((int[])dash).length * 4);
            for (int i : dash) {
                if (sb.length() > 0) {
                    sb.append(' ');
                }
                sb.append(i);
            }
            arrowLink.setAttribute("DASH", sb.toString());
        });
        model.getLabelFontSize().ifPresent(fontSize -> arrowLink.setAttribute("FONT_SIZE", Integer.toString(fontSize)));
        model.getLabelFontFamily().ifPresent(fontFamily -> arrowLink.setAttribute("FONT_FAMILY", (String)fontFamily));
        String destinationId = target.createID();
        if (destinationId != null) {
            arrowLink.setAttribute("DESTINATION", destinationId);
        }
        model.getSourceLabel().ifPresent(sourceLabel -> arrowLink.setAttribute("SOURCE_LABEL", (String)sourceLabel));
        model.getTargetLabel().ifPresent(targetLabel -> arrowLink.setAttribute("TARGET_LABEL", (String)targetLabel));
        model.getMiddleLabel().ifPresent(middleLabel -> arrowLink.setAttribute("MIDDLE_LABEL", (String)middleLabel));
        Point startInclination = model.getStartInclination();
        if (startInclination != null) {
            arrowLink.setAttribute("STARTINCLINATION", TreeXmlWriter.pointToXml(startInclination));
        }
        if ((endInclination = model.getEndInclination()) != null) {
            arrowLink.setAttribute("ENDINCLINATION", TreeXmlWriter.pointToXml(endInclination));
        }
        model.getArrows().ifPresent(arrows -> {
            arrowLink.setAttribute("STARTARROW", arrows.start.name());
            arrowLink.setAttribute("ENDARROW", arrows.end.name());
        });
        writer.addElement((Object)model, arrowLink);
    }

    public void setAttributes(String tag, Object node, XMLElement attributes) {
    }

    public void writeAttributes(ITreeWriter writer, NodeModel node) {
        NodeLinks links = node.getExtension(NodeLinks.class);
        if (links != null) {
            Boolean formatNodeAsHyperlink;
            Hyperlink link = links.getHyperLink(node);
            if (link != null) {
                String string = link.toString();
                if (string.startsWith("#ID") && node.getMap().getNodeForID(string.substring(1)) == null) {
                    return;
                }
                writer.addAttribute(LINK, string);
            }
            if ((formatNodeAsHyperlink = links.formatNodeAsHyperlink()) != null) {
                writer.addAttribute(FORMAT_AS_HYPERLINK, formatNodeAsHyperlink.toString());
            }
        }
    }

    public void writeContent(ITreeWriter writer, NodeModel node) throws IOException {
        NodeLinks links = node.getExtension(NodeLinks.class);
        if (links != null) {
            for (NodeLinkModel nodeLinkModel : links.getLinks()) {
                ConnectorModel arrowLinkModel;
                boolean linkNotWrittenBefore;
                if (!(nodeLinkModel instanceof ConnectorModel) || !(linkNotWrittenBefore = !this.processedLinks.contains(nodeLinkModel)) || (arrowLinkModel = (ConnectorModel)nodeLinkModel.cloneForSource(node)) == null) continue;
                this.save(writer, arrowLinkModel);
                this.processedLinks.add(nodeLinkModel);
            }
        }
    }
}

