/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework.permissions;

import java.io.File;

class PermUtil {
    PermUtil() {
    }

    public static StringBuffer quote(String str, StringBuffer out) {
        if (out == null) {
            out = new StringBuffer();
        }
        out.append('\"');
        int len = str.length();
        block5: for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    out.append('\\');
                    out.append(c);
                    continue block5;
                }
                case '\r': {
                    out.append("\\r");
                    continue block5;
                }
                case '\n': {
                    out.append("\\n");
                    continue block5;
                }
                default: {
                    out.append(c);
                }
            }
        }
        out.append('\"');
        return out;
    }

    public static int skipWhite(char[] ca, int pos) {
        while (Character.isWhitespace(ca[pos])) {
            ++pos;
        }
        return pos;
    }

    public static int endOfString(char[] ca, int pos, int len) {
        while (pos < len && Character.isWhitespace(ca[pos])) {
            ++pos;
        }
        return pos == len ? -1 : pos;
    }

    public static int unquote(char[] ca, int pos, StringBuffer out) {
        if (ca[pos++] != '\"') {
            throw new IllegalArgumentException("Input not a quoted string");
        }
        while (ca[pos] != '\"') {
            int c;
            if ((c = ca[pos++]) == 92) {
                switch (ca[pos++]) {
                    case '\"': {
                        c = 34;
                        break;
                    }
                    case '\\': {
                        c = 92;
                        break;
                    }
                    case 'n': {
                        c = 10;
                        break;
                    }
                    case 'r': {
                        c = 13;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Illegal escape char in quoted string: \\" + ca[pos - 1]);
                    }
                }
            }
            if (out == null) continue;
            out.append((char)c);
        }
        return pos + 1;
    }

    public static File[] getSortedFiles(File dir) {
        int i;
        String[] files = dir.list();
        File[] res = new File[files.length];
        long[] lfiles = new long[files.length];
        int lf = -1;
        int pos = 0;
        for (i = 0; i < files.length; ++i) {
            try {
                int j;
                long fval = Long.parseLong(files[i]);
                for (j = lf; j >= 0 && fval <= lfiles[j]; --j) {
                }
                if (j >= lf) {
                    lfiles[++lf] = fval;
                } else {
                    System.arraycopy(lfiles, ++j, lfiles, j + 1, ++lf - j);
                    lfiles[j] = fval;
                }
                files[i] = null;
                continue;
            }
            catch (NumberFormatException ignore) {
                res[pos++] = new File(dir, files[i]);
            }
        }
        for (i = 0; i <= lf; ++i) {
            res[pos++] = new File(dir, Long.toString(lfiles[i]));
        }
        return res;
    }
}

