/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.awt.event.ActionEvent;
import java.time.Instant;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.actions.DownloadReferrersAction;
import org.openstreetmap.josm.actions.UpdateDataAction;
import org.openstreetmap.josm.actions.UpdateSelectionAction;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.gui.ExceptionDialogUtil;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.io.DownloadPrimitivesTask;
import org.openstreetmap.josm.gui.io.UpdatePrimitivesTask;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OsmApiException;
import org.openstreetmap.josm.io.OsmApiInitializationException;
import org.openstreetmap.josm.io.OsmApiPrimitiveGoneException;
import org.openstreetmap.josm.tools.ExceptionUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.date.DateUtils;

public abstract class AbstractUploadTask
extends PleaseWaitRunnable {
    private static final String CANCEL_TR = I18n.marktr("Cancel");
    private static final String CANCEL = "cancel";
    private static final String UPDATE_DATA = "updatedata";

    protected AbstractUploadTask(String title, boolean ignoreException) {
        super(title, ignoreException);
    }

    protected AbstractUploadTask(String title, ProgressMonitor progressMonitor, boolean ignoreException) {
        super(title, progressMonitor, ignoreException);
    }

    protected AbstractUploadTask(String title) {
        super(title);
    }

    protected void synchronizePrimitive(OsmPrimitiveType type, long id) {
        OsmDataLayer layer = MainApplication.getLayerManager().getEditLayer();
        if (layer == null) {
            throw new IllegalStateException(I18n.tr("Failed to update primitive with id {0} because current edit layer is null", id));
        }
        OsmPrimitive p = (OsmPrimitive)layer.data.getPrimitiveById(id, type);
        if (p == null) {
            throw new IllegalStateException(I18n.tr("Failed to update primitive with id {0} because current edit layer does not include such a primitive", id));
        }
        MainApplication.worker.execute(new UpdatePrimitivesTask(layer, Collections.singleton(p)));
    }

    protected void synchronizeDataSet() {
        UpdateDataAction act = new UpdateDataAction();
        act.actionPerformed(new ActionEvent(this, 0, ""));
    }

    protected void handleUploadConflictForKnownConflict(OsmPrimitiveType primitiveType, long id, String serverVersion, String myVersion) {
        String lbl;
        switch (primitiveType) {
            case NODE: {
                lbl = I18n.tr("Synchronize node {0} only", id);
                break;
            }
            case WAY: {
                lbl = I18n.tr("Synchronize way {0} only", id);
                break;
            }
            case RELATION: {
                lbl = I18n.tr("Synchronize relation {0} only", id);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        HelpAwareOptionPane.ButtonSpec[] spec = new HelpAwareOptionPane.ButtonSpec[]{new HelpAwareOptionPane.ButtonSpec(lbl, new ImageProvider(UPDATE_DATA), null, null), new HelpAwareOptionPane.ButtonSpec(I18n.tr("Synchronize entire dataset", new Object[0]), new ImageProvider(UPDATE_DATA), null, null), new HelpAwareOptionPane.ButtonSpec(I18n.tr(CANCEL_TR, new Object[0]), new ImageProvider(CANCEL), null, null)};
        String msg = I18n.tr("<html>Uploading <strong>failed</strong> because the server has a newer version of one<br>of your nodes, ways, or relations.<br>The conflict is caused by the <strong>{0}</strong> with id <strong>{1}</strong>,<br>the server has version {2}, your version is {3}.<br><br>Click <strong>{4}</strong> to synchronize the conflicting primitive only.<br>Click <strong>{5}</strong> to synchronize the entire local dataset with the server.<br>Click <strong>{6}</strong> to abort and continue editing.<br></html>", I18n.tr(primitiveType.getAPIName(), new Object[0]), id, serverVersion, myVersion, spec[0].text, spec[1].text, spec[2].text);
        int ret = HelpAwareOptionPane.showOptionDialog(MainApplication.getMainFrame(), msg, I18n.tr("Conflicts detected", new Object[0]), 0, null, spec, spec[0], "/Concepts/Conflict");
        switch (ret) {
            case 0: {
                this.synchronizePrimitive(primitiveType, id);
                break;
            }
            case 1: {
                this.synchronizeDataSet();
                break;
            }
        }
    }

    protected void handleUploadConflictForUnknownConflict() {
        HelpAwareOptionPane.ButtonSpec[] spec = new HelpAwareOptionPane.ButtonSpec[]{new HelpAwareOptionPane.ButtonSpec(I18n.tr("Synchronize entire dataset", new Object[0]), new ImageProvider(UPDATE_DATA), null, null), new HelpAwareOptionPane.ButtonSpec(I18n.tr(CANCEL_TR, new Object[0]), new ImageProvider(CANCEL), null, null)};
        String msg = I18n.tr("<html>Uploading <strong>failed</strong> because the server has a newer version of one<br>of your nodes, ways, or relations.<br><br>Click <strong>{0}</strong> to synchronize the entire local dataset with the server.<br>Click <strong>{1}</strong> to abort and continue editing.<br></html>", spec[0].text, spec[1].text);
        int ret = HelpAwareOptionPane.showOptionDialog(MainApplication.getMainFrame(), msg, I18n.tr("Conflicts detected", new Object[0]), 0, null, spec, spec[0], HelpUtil.ht("/Concepts/Conflict"));
        if (ret == 0) {
            this.synchronizeDataSet();
        }
    }

    protected void handleUploadConflictForClosedChangeset(long changesetId, Instant d) {
        String msg = I18n.tr("<html>Uploading <strong>failed</strong> because you have been using<br>changeset {0} which was already closed at {1}.<br>Please upload again with a new or an existing open changeset.</html>", changesetId, DateUtils.getDateTimeFormatter(FormatStyle.SHORT, FormatStyle.SHORT).format(d));
        JOptionPane.showMessageDialog(MainApplication.getMainFrame(), msg, I18n.tr("Changeset closed", new Object[0]), 0);
    }

    protected void handleUploadPreconditionFailedConflict(OsmApiException e, Pair<OsmPrimitive, Collection<OsmPrimitive>> conflict) {
        HelpAwareOptionPane.ButtonSpec[] options = new HelpAwareOptionPane.ButtonSpec[]{new HelpAwareOptionPane.ButtonSpec(I18n.tr("Prepare conflict resolution", new Object[0]), new ImageProvider("ok"), I18n.tr("Click to download all referring objects for {0}", conflict.a), null), new HelpAwareOptionPane.ButtonSpec(I18n.tr(CANCEL_TR, new Object[0]), new ImageProvider(CANCEL), I18n.tr("Click to cancel and to resume editing the map", new Object[0]), null)};
        String msg = ExceptionUtil.explainPreconditionFailed(e).replace("</html>", "<br><br>" + I18n.tr("Click <strong>{0}</strong> to load them now.<br>If necessary JOSM will create conflicts which you can resolve in the Conflict Resolution Dialog.", options[0].text)) + "</html>";
        int ret = HelpAwareOptionPane.showOptionDialog(MainApplication.getMainFrame(), msg, I18n.tr("Object still in use", new Object[0]), 0, null, options, options[0], "/Action/Upload#NodeStillInUseInWay");
        if (ret == 0) {
            if (msg.contains("to delete")) {
                DownloadReferrersAction.downloadReferrers(MainApplication.getLayerManager().getEditLayer(), Collections.singletonList((OsmPrimitive)conflict.a));
            }
            if (msg.contains("to upload") && !((Collection)conflict.b).isEmpty()) {
                MainApplication.worker.submit(new DownloadPrimitivesTask(MainApplication.getLayerManager().getEditLayer(), new ArrayList<PrimitiveId>((Collection)conflict.b), false));
            }
        }
    }

    protected void handleUploadConflict(OsmApiException e) {
        String errorHeader = e.getErrorHeader();
        if (errorHeader != null) {
            Pattern p = Pattern.compile("Version mismatch: Provided (\\d+), server had: (\\d+) of (\\S+) (\\d+)");
            Matcher m = p.matcher(errorHeader);
            if (m.matches()) {
                this.handleUploadConflictForKnownConflict(OsmPrimitiveType.from(m.group(3)), Long.parseLong(m.group(4)), m.group(2), m.group(1));
                return;
            }
            p = Pattern.compile("The changeset (\\d+) was closed at (.*)");
            m = p.matcher(errorHeader);
            if (m.matches()) {
                this.handleUploadConflictForClosedChangeset(Long.parseLong(m.group(1)), DateUtils.parseInstant(m.group(2)));
                return;
            }
        }
        Logging.warn(I18n.tr("Error header \"{0}\" did not match with an expected pattern", errorHeader));
        this.handleUploadConflictForUnknownConflict();
    }

    protected void handlePreconditionFailed(OsmApiException e) {
        Pair<OsmPrimitive, Collection<OsmPrimitive>> conflict = ExceptionUtil.parsePreconditionFailed(e.getErrorHeader());
        if (conflict != null) {
            this.handleUploadPreconditionFailedConflict(e, conflict);
        } else {
            Logging.warn(I18n.tr("Error header \"{0}\" did not match with an expected pattern", e.getErrorHeader()));
            ExceptionDialogUtil.explainPreconditionFailed(e);
        }
    }

    protected void handleGone(OsmApiPrimitiveGoneException e) {
        if (e.isKnownPrimitive()) {
            UpdateSelectionAction.handlePrimitiveGoneException(e.getPrimitiveId(), e.getPrimitiveType());
        } else {
            ExceptionDialogUtil.explainGoneForUnknownPrimitive(e);
        }
    }

    protected void handleFailedUpload(Exception e) {
        if (e instanceof OsmApiInitializationException) {
            ExceptionDialogUtil.explainOsmApiInitializationException((OsmApiInitializationException)e);
            return;
        }
        if (e instanceof OsmApiPrimitiveGoneException) {
            this.handleGone((OsmApiPrimitiveGoneException)e);
            return;
        }
        if (e instanceof OsmApiException) {
            OsmApiException ex = (OsmApiException)e;
            if (ex.getResponseCode() == 409) {
                this.handleUploadConflict(ex);
                return;
            }
            if (ex.getResponseCode() == 412) {
                this.handlePreconditionFailed(ex);
                return;
            }
            if (ex.getResponseCode() == 404) {
                ExceptionDialogUtil.explainNotFound(ex);
                return;
            }
        }
        ExceptionDialogUtil.explainException(e);
    }
}

