/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyFloat;
import org.jruby.RubyString;
import org.jruby.api.Create;
import org.jruby.ext.ffi.MemoryIO;
import org.jruby.ext.ffi.Util;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public final class MemoryUtil {
    private MemoryUtil() {
    }

    public static IRubyObject getArrayOfSigned8(ThreadContext context, MemoryIO io2, long offset2, int count2) {
        byte[] array2 = new byte[count2];
        if (array2.length > 0) {
            io2.get(offset2, array2, 0, array2.length);
        }
        IRubyObject[] objArray = new IRubyObject[count2];
        for (int i2 = 0; i2 < array2.length; ++i2) {
            objArray[i2] = Util.newSigned8(context.runtime, array2[i2]);
        }
        return Create.newArrayNoCopy(context, objArray);
    }

    public static void putArrayOfSigned8(MemoryIO io2, long offset2, RubyArray ary) {
        byte[] array2 = new byte[ary.size()];
        for (int i2 = 0; i2 < array2.length; ++i2) {
            array2[i2] = Util.int8Value(ary.entry(i2));
        }
        if (array2.length > 0) {
            io2.put(offset2, array2, 0, array2.length);
        }
    }

    public static IRubyObject getArrayOfUnsigned8(ThreadContext context, MemoryIO io2, long offset2, int count2) {
        byte[] array2 = new byte[count2];
        if (array2.length > 0) {
            io2.get(offset2, array2, 0, array2.length);
        }
        IRubyObject[] objArray = new IRubyObject[count2];
        for (int i2 = 0; i2 < array2.length; ++i2) {
            objArray[i2] = Util.newUnsigned8(context.runtime, array2[i2]);
        }
        return Create.newArrayNoCopy(context, objArray);
    }

    public static void putArrayOfUnsigned8(MemoryIO io2, long offset2, RubyArray ary) {
        byte[] array2 = new byte[ary.size()];
        for (int i2 = 0; i2 < array2.length; ++i2) {
            array2[i2] = (byte)Util.uint8Value(ary.entry(i2));
        }
        if (array2.length > 0) {
            io2.put(offset2, array2, 0, array2.length);
        }
    }

    public static IRubyObject getArrayOfSigned16(ThreadContext context, MemoryIO io2, long offset2, int count2) {
        short[] array2 = new short[count2];
        if (array2.length > 0) {
            io2.get(offset2, array2, 0, array2.length);
        }
        IRubyObject[] objArray = new IRubyObject[count2];
        for (int i2 = 0; i2 < array2.length; ++i2) {
            objArray[i2] = Util.newSigned16(context.runtime, array2[i2]);
        }
        return Create.newArrayNoCopy(context, objArray);
    }

    public static void putArrayOfSigned16(MemoryIO io2, long offset2, RubyArray ary) {
        short[] array2 = new short[ary.size()];
        for (int i2 = 0; i2 < array2.length; ++i2) {
            array2[i2] = Util.int16Value(ary.entry(i2));
        }
        if (array2.length > 0) {
            io2.put(offset2, array2, 0, array2.length);
        }
    }

    public static IRubyObject getArrayOfUnsigned16(ThreadContext context, MemoryIO io2, long offset2, int count2) {
        short[] array2 = new short[count2];
        if (array2.length > 0) {
            io2.get(offset2, array2, 0, array2.length);
        }
        IRubyObject[] objArray = new IRubyObject[count2];
        for (int i2 = 0; i2 < array2.length; ++i2) {
            objArray[i2] = Util.newUnsigned16(context.runtime, array2[i2]);
        }
        return Create.newArrayNoCopy(context, objArray);
    }

    public static void putArrayOfUnsigned16(MemoryIO io2, long offset2, RubyArray ary) {
        short[] array2 = new short[ary.size()];
        for (int i2 = 0; i2 < array2.length; ++i2) {
            array2[i2] = (short)Util.uint16Value(ary.entry(i2));
        }
        if (array2.length > 0) {
            io2.put(offset2, array2, 0, array2.length);
        }
    }

    public static IRubyObject getArrayOfSigned32(ThreadContext context, MemoryIO io2, long offset2, int count2) {
        int[] array2 = new int[count2];
        if (array2.length > 0) {
            io2.get(offset2, array2, 0, array2.length);
        }
        IRubyObject[] objArray = new IRubyObject[count2];
        for (int i2 = 0; i2 < array2.length; ++i2) {
            objArray[i2] = Util.newSigned32(context.runtime, array2[i2]);
        }
        return Create.newArrayNoCopy(context, objArray);
    }

    public static void putArrayOfSigned32(MemoryIO io2, long offset2, RubyArray ary) {
        int[] array2 = new int[ary.size()];
        for (int i2 = 0; i2 < array2.length; ++i2) {
            array2[i2] = Util.int32Value(ary.entry(i2));
        }
        if (array2.length > 0) {
            io2.put(offset2, array2, 0, array2.length);
        }
    }

    public static IRubyObject getArrayOfUnsigned32(ThreadContext context, MemoryIO io2, long offset2, int count2) {
        int[] array2 = new int[count2];
        if (array2.length > 0) {
            io2.get(offset2, array2, 0, array2.length);
        }
        IRubyObject[] objArray = new IRubyObject[count2];
        for (int i2 = 0; i2 < array2.length; ++i2) {
            objArray[i2] = Util.newUnsigned32(context.runtime, array2[i2]);
        }
        return Create.newArrayNoCopy(context, objArray);
    }

    public static void putArrayOfUnsigned32(MemoryIO io2, long offset2, RubyArray ary) {
        int[] array2 = new int[ary.size()];
        for (int i2 = 0; i2 < array2.length; ++i2) {
            array2[i2] = (int)Util.uint32Value(ary.entry(i2));
        }
        if (array2.length > 0) {
            io2.put(offset2, array2, 0, array2.length);
        }
    }

    public static IRubyObject getArrayOfSigned64(ThreadContext context, MemoryIO io2, long offset2, int count2) {
        long[] array2 = new long[count2];
        if (array2.length > 0) {
            io2.get(offset2, array2, 0, array2.length);
        }
        IRubyObject[] objArray = new IRubyObject[count2];
        for (int i2 = 0; i2 < array2.length; ++i2) {
            objArray[i2] = Util.newSigned64(context.runtime, array2[i2]);
        }
        return Create.newArrayNoCopy(context, objArray);
    }

    public static void putArrayOfSigned64(MemoryIO io2, long offset2, RubyArray ary) {
        long[] array2 = new long[ary.size()];
        for (int i2 = 0; i2 < array2.length; ++i2) {
            array2[i2] = Util.int64Value(ary.entry(i2));
        }
        if (array2.length > 0) {
            io2.put(offset2, array2, 0, array2.length);
        }
    }

    public static IRubyObject getArrayOfUnsigned64(ThreadContext context, MemoryIO io2, long offset2, int count2) {
        long[] array2 = new long[count2];
        if (array2.length > 0) {
            io2.get(offset2, array2, 0, array2.length);
        }
        IRubyObject[] objArray = new IRubyObject[count2];
        for (int i2 = 0; i2 < array2.length; ++i2) {
            objArray[i2] = Util.newUnsigned64(context.runtime, array2[i2]);
        }
        return Create.newArrayNoCopy(context, objArray);
    }

    public static void putArrayOfUnsigned64(MemoryIO io2, long offset2, RubyArray ary) {
        long[] array2 = new long[ary.size()];
        for (int i2 = 0; i2 < array2.length; ++i2) {
            array2[i2] = Util.uint64Value(ary.entry(i2));
        }
        if (array2.length > 0) {
            io2.put(offset2, array2, 0, array2.length);
        }
    }

    public static IRubyObject getArrayOfFloat32(ThreadContext context, MemoryIO io2, long offset2, int count2) {
        float[] array2 = new float[count2];
        if (array2.length > 0) {
            io2.get(offset2, array2, 0, array2.length);
        }
        IRubyObject[] objArray = new IRubyObject[count2];
        for (int i2 = 0; i2 < array2.length; ++i2) {
            objArray[i2] = RubyFloat.newFloat(context.runtime, array2[i2]);
        }
        return Create.newArrayNoCopy(context, objArray);
    }

    @Deprecated(since="10.0")
    public static void putArrayOfFloat32(MemoryIO io2, long offset2, RubyArray ary) {
        MemoryUtil.putArrayOfFloat32(ary.getCurrentContext(), io2, offset2, ary);
    }

    public static void putArrayOfFloat32(ThreadContext context, MemoryIO io2, long offset2, RubyArray ary) {
        float[] array2 = new float[ary.size()];
        for (int i2 = 0; i2 < array2.length; ++i2) {
            array2[i2] = Util.floatValue(context, ary.entry(i2));
        }
        if (array2.length > 0) {
            io2.put(offset2, array2, 0, array2.length);
        }
    }

    public static IRubyObject getArrayOfFloat64(ThreadContext context, MemoryIO io2, long offset2, int count2) {
        double[] array2 = new double[count2];
        if (array2.length > 0) {
            io2.get(offset2, array2, 0, array2.length);
        }
        IRubyObject[] objArray = new IRubyObject[count2];
        for (int i2 = 0; i2 < array2.length; ++i2) {
            objArray[i2] = RubyFloat.newFloat(context.runtime, array2[i2]);
        }
        return Create.newArrayNoCopy(context, objArray);
    }

    @Deprecated(since="10.0")
    public static void putArrayOfFloat64(MemoryIO io2, long offset2, RubyArray ary) {
        MemoryUtil.putArrayOfFloat64(ary.getCurrentContext(), io2, offset2, ary);
    }

    public static void putArrayOfFloat64(ThreadContext context, MemoryIO io2, long offset2, RubyArray ary) {
        double[] array2 = new double[ary.size()];
        for (int i2 = 0; i2 < array2.length; ++i2) {
            array2[i2] = Util.doubleValue(context, ary.entry(i2));
        }
        if (array2.length > 0) {
            io2.put(offset2, array2, 0, array2.length);
        }
    }

    public static RubyString newTaintedString(Ruby runtime2, byte[] bytes2) {
        RubyString s2 = RubyString.newStringNoCopy(runtime2, bytes2);
        return s2;
    }

    public static RubyString getTaintedByteString(Ruby runtime2, MemoryIO io2, long offset2, int length2) {
        byte[] bytes2 = new byte[length2];
        io2.get(offset2, bytes2, 0, bytes2.length);
        return MemoryUtil.newTaintedString(runtime2, bytes2);
    }

    public static IRubyObject getTaintedString(Ruby runtime2, MemoryIO io2, long offset2) {
        return MemoryUtil.newTaintedString(runtime2, io2.getZeroTerminatedByteArray(offset2));
    }

    public static IRubyObject getTaintedString(Ruby runtime2, MemoryIO io2, long offset2, int length2) {
        return MemoryUtil.newTaintedString(runtime2, io2.getZeroTerminatedByteArray(offset2, length2));
    }
}

