/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.formcomponents;

import com.install4j.api.Util;
import com.install4j.api.beans.VariableErrorHandlingDescriptor;
import com.install4j.api.formcomponents.FormEnvironment;
import com.install4j.api.screens.Console;
import com.install4j.runtime.beans.formcomponents.FontStyle;
import com.install4j.runtime.beans.formcomponents.FontType;
import com.install4j.runtime.beans.formcomponents.LeadingLabelComponent;
import com.install4j.runtime.beans.formcomponents.LinkLabelContainer;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.util.HyperlinkLabel;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class HyperlinkLabelComponent
extends LeadingLabelComponent
implements LinkLabelContainer {
    private String hyperlinkText;
    private String url;
    private Color linkLabelColor = null;
    private Color linkLabelActiveColor = null;
    private Font linkLabelFont = null;
    private FontType linkLabelFontType = FontType.DEFAULT;
    private FontStyle linkLabelFontStyle = FontStyle.UNCHANGED;
    private int linkLabelFontSizePercent = 100;
    private HyperlinkLabel linkLabel;

    @Override
    public String getHyperlinkText() {
        return HyperlinkLabelComponent.replaceVariables(this.replaceFormVariables(this.hyperlinkText, VariableErrorHandlingDescriptor.ALWAYS_ERROR_MESSAGE));
    }

    public void setHyperlinkText(String hyperlinkText) {
        this.hyperlinkText = hyperlinkText;
    }

    public String getUrl() {
        return HyperlinkLabelComponent.replaceVariables(this.replaceFormVariables(this.url));
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    public Color getLinkLabelColor() {
        return this.replaceWithTextOverride("linkLabelColor", this.linkLabelColor, Color.class);
    }

    public void setLinkLabelColor(Color linkLabelColor) {
        this.linkLabelColor = linkLabelColor;
    }

    @Override
    public Color getLinkLabelActiveColor() {
        return this.replaceWithTextOverride("linkLabelActiveColor", this.linkLabelActiveColor, Color.class);
    }

    public void setLinkLabelActiveColor(Color linkLabelActiveColor) {
        this.linkLabelActiveColor = linkLabelActiveColor;
    }

    @Override
    public Font getLinkLabelFont() {
        return this.replaceWithTextOverride("linkLabelFont", this.linkLabelFont, Font.class);
    }

    public void setLinkLabelFont(Font linkLabelFont) {
        this.linkLabelFont = linkLabelFont;
    }

    @Override
    public FontType getLinkLabelFontType() {
        return this.replaceWithTextOverride("linkLabelFontType", this.linkLabelFontType, FontType.class);
    }

    public void setLinkLabelFontType(FontType linkLabelFontType) {
        this.linkLabelFontType = linkLabelFontType;
    }

    @Override
    public FontStyle getLinkLabelFontStyle() {
        return this.replaceWithTextOverride("linkLabelFontStyle", this.linkLabelFontStyle, FontStyle.class);
    }

    public void setLinkLabelFontStyle(FontStyle linkLabelFontStyle) {
        this.linkLabelFontStyle = linkLabelFontStyle;
    }

    @Override
    public int getLinkLabelFontSizePercent() {
        return this.replaceWithTextOverride("linkLabelFontSizePercent", this.linkLabelFontSizePercent);
    }

    public void setLinkLabelFontSizePercent(int linkLabelFontSizePercent) {
        this.linkLabelFontSizePercent = linkLabelFontSizePercent;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.initializeLinkLabel(this.linkLabel, this);
    }

    @Override
    public void setFormEnvironment(FormEnvironment formEnvironment) {
        super.setFormEnvironment(formEnvironment);
        if (this.linkLabel != null && formEnvironment != null) {
            this.linkLabel.setName(formEnvironment.getId(this));
        }
    }

    @Override
    public JComponent createCenterComponent() {
        this.linkLabel = new HyperlinkLabel(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HyperlinkLabelComponent.this.doHyperlink();
            }
        });
        return this.linkLabel;
    }

    private void doHyperlink() {
        if (this.getFormEnvironment().isDesignTime()) {
            return;
        }
        String url = this.getUrl();
        if (url.length() == 0) {
            return;
        }
        try {
            URL realUrl = new URL(url);
            Util.showUrl(realUrl);
        }
        catch (MalformedURLException e) {
            Util.showErrorMessage(Messages.formatString(".InvalidUrl", url));
        }
    }

    @Override
    public boolean isFillCenterHorizontal() {
        return false;
    }

    @Override
    public Object getConfigurationObject() {
        return this.linkLabel;
    }

    @Override
    public Class getConfigurationObjectClass() {
        return JLabel.class;
    }

    @Override
    public boolean handleConsole(Console console) {
        String url = this.getUrl();
        String hyperlinkText = this.getHyperlinkText();
        if (hyperlinkText != null && !Objects.equals(hyperlinkText, url)) {
            console.println(hyperlinkText + " " + url);
        } else {
            console.println(url);
        }
        return true;
    }
}

