/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.abo;

import ca.odell.glazedlists.swing.GlazedListsSwing;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import mediathek.config.Daten;
import mediathek.daten.ListeAbo;
import mediathek.daten.abo.AboTags;
import mediathek.daten.abo.DatenAbo;
import mediathek.gui.actions.CreateNewAboAction;
import mediathek.gui.dialog.DialogEditAbo;
import mediathek.gui.messages.AboListChangedEvent;
import mediathek.mainwindow.MediathekGui;
import mediathek.tool.InfiniteProgressPanel;
import mediathek.tool.MessageBus;
import mediathek.tool.NoSelectionErrorDialog;
import mediathek.tool.SVGIconUtilities;
import mediathek.tool.SenderListModel;
import mediathek.tool.cellrenderer.CellRendererAbo;
import mediathek.tool.listener.BeobTableHeader;
import mediathek.tool.models.TModelAbo;
import mediathek.tool.table.MVAbosTable;
import mediathek.tool.table.MVTable;
import net.engio.mbassy.listener.Handler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jdesktop.swingx.JXStatusBar;
import org.jetbrains.annotations.NotNull;

public class ManageAboPanel
extends JPanel {
    private static final String ACTION_MAP_KEY_EDIT_ABO = "edit_abo";
    private static final String ACTION_MAP_KEY_DELETE_ABO = "delete_abo";
    private static final Logger logger = LogManager.getLogger();
    private final MVTable tabelle = new MVAbosTable();
    private final Daten daten;
    private final CreateNewAboAction createAboAction = new CreateNewAboAction(Daten.getInstance().getListeAbo());
    private final JXStatusBar infoPanel = new JXStatusBar();
    private final JLabel totalAbos = new JLabel("totalAbos");
    private final JLabel activeAbos = new JLabel("activeAbos");
    private final JLabel inactiveAbos = new JLabel("inactiveAbos");
    private final JToolBar swingToolBar = new JToolBar();
    private final JComboBox<String> senderCombo = new JComboBox();
    private final InfiniteProgressPanel infiniteProgressPanel = new InfiniteProgressPanel();
    private final JButton btnEditAbo = new JButton();
    private JScrollPane jScrollPane1;

    public ManageAboPanel(@NotNull JDialog dialog) {
        this.daten = Daten.getInstance();
        this.initComponents();
        this.jScrollPane1.setViewportView(this.tabelle);
        this.setupToolBar();
        this.setupInfoPanel();
        this.updateInfoText();
        MessageBus.getMessageBus().subscribe(this);
        this.initListeners();
        this.initializeTable();
        this.tabelle.getSelectionModel().addListSelectionListener(e -> this.btnEditAbo.setEnabled(this.tabelle.getSelectedRows().length <= 1));
        this.tabelle.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2 && ManageAboPanel.this.tabelle.getSelectedRow() != -1 && ManageAboPanel.this.tabelle.rowAtPoint(mouseEvent.getPoint()) != -1) {
                    ManageAboPanel.this.editAbo();
                }
            }
        });
        dialog.setGlassPane(this.infiniteProgressPanel);
    }

    public void addObjectData(TModelAbo model, String sender) {
        model.setRowCount(0);
        Object[] object = new Object[14];
        for (DatenAbo abo : this.daten.getListeAbo()) {
            if (!sender.isEmpty() && !sender.equals(abo.getSender())) continue;
            object[0] = null;
            object[1] = abo.isActive();
            object[2] = null;
            object[3] = null;
            object[4] = null;
            object[5] = null;
            object[6] = null;
            object[7] = null;
            object[8] = null;
            object[9] = null;
            object[10] = null;
            object[11] = null;
            object[12] = null;
            object[13] = abo;
            model.addRow(object);
        }
    }

    private void setupInfoPanel() {
        this.infoPanel.add(this.totalAbos);
        this.infoPanel.add(this.activeAbos);
        this.infoPanel.add(this.inactiveAbos);
    }

    private void initializeTable() {
        this.tabelleLaden();
        this.tabelle.readColumnConfigurationData();
        if (this.tabelle.getRowCount() > 0) {
            this.tabelle.setRowSelectionInterval(0, 0);
        }
    }

    private void setupToolBar() {
        JButton button = new JButton();
        button.setToolTipText("Abos einschalten");
        button.addActionListener(l -> this.changeAboActiveState(true));
        button.setIcon(SVGIconUtilities.createSVGIcon("icons/fontawesome/check.svg"));
        this.swingToolBar.add(button);
        button = new JButton();
        button.setToolTipText("Abos ausschalten");
        button.addActionListener(l -> this.changeAboActiveState(false));
        button.setIcon(SVGIconUtilities.createSVGIcon("icons/fontawesome/xmark.svg", 16.0f));
        this.swingToolBar.add(button);
        this.swingToolBar.addSeparator();
        button = new JButton(this.createAboAction);
        button.setText("");
        this.swingToolBar.add(button);
        button = new JButton();
        button.setToolTipText("Abos l\u00f6schen");
        button.addActionListener(l -> this.aboLoeschen());
        button.setIcon(SVGIconUtilities.createSVGIcon("icons/fontawesome/trash-can.svg"));
        this.swingToolBar.add(button);
        this.btnEditAbo.setToolTipText("Abo \u00e4ndern");
        this.btnEditAbo.addActionListener(l -> this.editAbo());
        this.btnEditAbo.setIcon(SVGIconUtilities.createSVGIcon("icons/fontawesome/pen-to-square.svg"));
        this.swingToolBar.add(this.btnEditAbo);
        this.swingToolBar.addSeparator();
        this.swingToolBar.add(new JLabel("Abos f\u00fcr Sender:"));
        this.senderCombo.setMaximumSize(new Dimension(150, Integer.MAX_VALUE));
        this.senderCombo.setModel(GlazedListsSwing.eventComboBoxModel(new SenderListModel()));
        this.senderCombo.setSelectedIndex(0);
        this.senderCombo.addActionListener(l -> this.tabelleLaden());
        this.swingToolBar.add(this.senderCombo);
    }

    public void tabelleSpeichern() {
        if (this.tabelle != null) {
            this.tabelle.writeTableConfigurationData();
        }
    }

    @Handler
    private void handleAboListChanged(AboListChangedEvent e) {
        SwingUtilities.invokeLater(() -> {
            this.tabelleLaden();
            this.updateInfoText();
        });
    }

    private long numActiveAbos() {
        return Daten.getInstance().getListeAbo().stream().filter(DatenAbo::isActive).count();
    }

    private long numInactiveAbos() {
        return Daten.getInstance().getListeAbo().stream().filter(abo -> !abo.isActive()).count();
    }

    private void updateInfoText() {
        ListeAbo listeAbo = Daten.getInstance().getListeAbo();
        int numAbos = listeAbo.size();
        if (numAbos == 1) {
            this.totalAbos.setText("Gesamt: 1 Abo");
        } else {
            this.totalAbos.setText(String.format("Gesamt: %d Abos", numAbos));
        }
        this.activeAbos.setText(String.format("%d eingeschaltet", this.numActiveAbos()));
        this.inactiveAbos.setText(String.format("%d ausgeschaltet", this.numInactiveAbos()));
    }

    private void setupKeyMap() {
        InputMap im = this.tabelle.getInputMap();
        im.put(KeyStroke.getKeyStroke(10, 0), ACTION_MAP_KEY_EDIT_ABO);
        im.put(KeyStroke.getKeyStroke(127, 0), ACTION_MAP_KEY_DELETE_ABO);
        ActionMap am = this.tabelle.getActionMap();
        am.put(ACTION_MAP_KEY_EDIT_ABO, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ManageAboPanel.this.editAbo();
            }
        });
        am.put(ACTION_MAP_KEY_DELETE_ABO, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ManageAboPanel.this.aboLoeschen();
            }
        });
    }

    private JPopupMenu createContextMenu() {
        JMenuItem itemEinschalten = new JMenuItem("Abo einschalten");
        itemEinschalten.setIcon(SVGIconUtilities.createSVGIcon("icons/fontawesome/check.svg"));
        itemEinschalten.addActionListener(e -> this.changeAboActiveState(true));
        JMenuItem itemDeaktivieren = new JMenuItem("Abo ausschalten");
        itemDeaktivieren.setIcon(SVGIconUtilities.createSVGIcon("icons/fontawesome/xmark.svg"));
        itemDeaktivieren.addActionListener(e -> this.changeAboActiveState(false));
        JMenuItem itemLoeschen = new JMenuItem("Abo l\u00f6schen");
        itemLoeschen.setIcon(SVGIconUtilities.createSVGIcon("icons/fontawesome/minus.svg"));
        itemLoeschen.addActionListener(e -> this.aboLoeschen());
        JMenuItem itemAendern = new JMenuItem("Abo \u00e4ndern");
        itemAendern.setIcon(SVGIconUtilities.createSVGIcon("icons/fontawesome/pen-to-square.svg"));
        itemAendern.addActionListener(e -> this.editAbo());
        JMenuItem itemNeu = new JMenuItem();
        itemNeu.setAction(this.createAboAction);
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(itemEinschalten);
        jPopupMenu.add(itemDeaktivieren);
        jPopupMenu.addSeparator();
        jPopupMenu.add(itemNeu);
        jPopupMenu.add(itemLoeschen);
        jPopupMenu.add(itemAendern);
        return jPopupMenu;
    }

    private void initListeners() {
        this.tabelle.setComponentPopupMenu(this.createContextMenu());
        this.tabelle.setDefaultRenderer(Object.class, new CellRendererAbo());
        this.tabelle.setModel(new TModelAbo(new Object[0][]));
        this.tabelle.setLineBreak(false);
        this.tabelle.getTableHeader().addMouseListener(new BeobTableHeader(this.tabelle, DatenAbo.spaltenAnzeigen, new int[]{1, 13}, new int[0], true, null));
        this.setupKeyMap();
    }

    private void tabelleLaden() {
        this.tabelle.getSpalten();
        String selectedItem = null;
        Object item = this.senderCombo.getSelectedItem();
        if (item != null) {
            selectedItem = item.toString();
        }
        if (selectedItem != null) {
            this.addObjectData((TModelAbo)this.tabelle.getModel(), selectedItem);
            this.tabelle.setSpalten();
        }
    }

    private void aboLoeschen() {
        int[] rows = this.tabelle.getSelectedRows();
        if (rows.length > 0) {
            String text;
            if (rows.length == 1) {
                int delRow = this.tabelle.convertRowIndexToModel(rows[0]);
                DatenAbo abo = (DatenAbo)this.tabelle.getModel().getValueAt(delRow, 13);
                text = "\"" + abo.getName() + "\" l\u00f6schen?";
            } else {
                text = "M\u00f6chten Sie wirklich " + rows.length + " Abos l\u00f6schen?";
            }
            int ret = JOptionPane.showConfirmDialog(this, text, "Abo l\u00f6schen", 0);
            if (ret == 0) {
                try {
                    ListeAbo listeAbo = this.daten.getListeAbo();
                    for (int row : rows) {
                        int modelRow = this.tabelle.convertRowIndexToModel(row);
                        DatenAbo abo = (DatenAbo)this.tabelle.getModel().getValueAt(modelRow, 13);
                        listeAbo.remove(abo);
                    }
                }
                catch (Exception e) {
                    logger.error("aboLoeschen", (Throwable)e);
                }
            }
            this.tabelleLaden();
            this.selectFirstRow();
            ChangeWorker worker = new ChangeWorker();
            worker.execute();
        } else {
            NoSelectionErrorDialog.show(this);
        }
    }

    private void selectFirstRow() {
        if (this.tabelle.getRowCount() > 0 && this.tabelle.getSelectedRow() == -1) {
            this.tabelle.requestFocus();
            this.tabelle.setRowSelectionInterval(0, 0);
        }
    }

    public void editAbo() {
        if (this.tabelle.getSelectedRowCount() == 0) {
            NoSelectionErrorDialog.show(this);
            return;
        }
        int[] rows = this.tabelle.getSelectedRows();
        int modelRow = this.tabelle.convertRowIndexToModel(this.tabelle.getSelectedRow());
        DatenAbo editedAbo = (DatenAbo)this.tabelle.getModel().getValueAt(modelRow, 13);
        DialogEditAbo dialog = new DialogEditAbo(MediathekGui.ui(), editedAbo, this.tabelle.getSelectedRowCount() > 1);
        dialog.setTitle("Abo \u00e4ndern");
        dialog.setVisible(true);
        if (!dialog.successful()) {
            return;
        }
        if (this.tabelle.getSelectedRowCount() > 1) {
            for (int row : rows) {
                for (int b = 0; b < dialog.multiEditCbIndices.length; ++b) {
                    if (!dialog.multiEditCbIndices[b]) continue;
                    modelRow = this.tabelle.convertRowIndexToModel(row);
                    DatenAbo curSelAbo = (DatenAbo)this.tabelle.getModel().getValueAt(modelRow, 13);
                    AboTags.fromIndex(b).ifPresent(tag -> {
                        switch (tag) {
                            case EINGESCHALTET: {
                                curSelAbo.setActive(editedAbo.isActive());
                                break;
                            }
                            case MINDESTDAUER: {
                                curSelAbo.setMindestDauerMinuten(editedAbo.getMindestDauerMinuten());
                                break;
                            }
                            case MIN: {
                                curSelAbo.setFilmLengthState(editedAbo.getFilmLengthState());
                                break;
                            }
                            case ZIELPFAD: {
                                curSelAbo.setZielpfad(editedAbo.getZielpfad());
                                break;
                            }
                            case PSET: {
                                curSelAbo.setPsetName(editedAbo.getPsetName());
                                break;
                            }
                            default: {
                                logger.error("Unhandled tag called {}", tag);
                            }
                        }
                    });
                }
            }
        }
        this.tabelleLaden();
        ChangeWorker worker = new ChangeWorker();
        worker.execute();
    }

    private void changeAboActiveState(boolean ein) {
        int[] rows = this.tabelle.getSelectedRows();
        if (rows.length > 0) {
            for (int row : rows) {
                int modelRow = this.tabelle.convertRowIndexToModel(row);
                DatenAbo akt = (DatenAbo)this.tabelle.getModel().getValueAt(modelRow, 13);
                akt.setActive(ein);
            }
            this.tabelleLaden();
            this.tabelle.clearSelection();
            this.tabelle.requestFocus();
            for (int row : rows) {
                this.tabelle.addRowSelectionInterval(row, row);
            }
            ChangeWorker worker = new ChangeWorker();
            worker.execute();
        } else {
            NoSelectionErrorDialog.show(this);
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        JTable jTable1 = new JTable();
        this.setLayout(new BorderLayout());
        jTable1.setAutoCreateRowSorter(true);
        jTable1.setAutoResizeMode(0);
        this.jScrollPane1.setViewportView(jTable1);
        this.add((Component)this.swingToolBar, "North");
        this.add((Component)this.jScrollPane1, "Center");
        this.add((Component)this.infoPanel, "South");
    }

    class ChangeWorker
    extends SwingWorker<Void, Void> {
        public ChangeWorker() {
            ManageAboPanel.this.infiniteProgressPanel.start();
            ManageAboPanel.this.infiniteProgressPanel.setText("Verarbeite Abos...");
        }

        @Override
        protected void done() {
            ManageAboPanel.this.infiniteProgressPanel.stop();
            ManageAboPanel.this.infiniteProgressPanel.setText("");
        }

        @Override
        protected Void doInBackground() {
            ManageAboPanel.this.daten.getListeAbo().aenderungMelden();
            return null;
        }
    }
}

