/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.ratelimit;

import java.time.Clock;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.support.ThreadedActionListener;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.action.ActionListener;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.timeseries.AnalysisType;
import org.opensearch.timeseries.NodeStateManager;
import org.opensearch.timeseries.breaker.CircuitBreakerService;
import org.opensearch.timeseries.ratelimit.ConcurrentWorker;
import org.opensearch.timeseries.ratelimit.QueuedRequest;

public abstract class BatchWorker<RequestType extends QueuedRequest, BatchRequestType, BatchResponseType>
extends ConcurrentWorker<RequestType> {
    private static final Logger LOG = LogManager.getLogger(BatchWorker.class);
    protected int batchSize;

    public BatchWorker(String queueName, long heapSize, int singleRequestSize, Setting<Float> maxHeapPercentForQueueSetting, ClusterService clusterService, Random random, CircuitBreakerService circuitBreakerService, ThreadPool threadPool, String threadPoolName, Settings settings, float maxQueuedTaskRatio, Clock clock, float mediumSegmentPruneRatio, float lowSegmentPruneRatio, int maintenanceFreqConstant, Setting<Integer> concurrencySetting, Duration executionTtl, Setting<Integer> batchSizeSetting, Duration stateTtl, NodeStateManager timeSeriesNodeStateManager, AnalysisType context) {
        super(queueName, heapSize, singleRequestSize, maxHeapPercentForQueueSetting, clusterService, random, circuitBreakerService, threadPool, threadPoolName, settings, maxQueuedTaskRatio, clock, mediumSegmentPruneRatio, lowSegmentPruneRatio, maintenanceFreqConstant, concurrencySetting, executionTtl, stateTtl, timeSeriesNodeStateManager, context);
        this.batchSize = (Integer)batchSizeSetting.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(batchSizeSetting, it -> {
            this.batchSize = it;
        });
    }

    protected abstract void executeBatchRequest(BatchRequestType var1, ActionListener<BatchResponseType> var2);

    protected abstract BatchRequestType toBatchRequest(List<RequestType> var1);

    @Override
    protected void execute(Runnable afterProcessCallback, Runnable emptyQueueCallback) {
        List toProcess = this.getRequests(this.batchSize);
        if (!toProcess.isEmpty()) {
            ArrayList<String> inflights = new ArrayList<String>();
            for (QueuedRequest request : toProcess) {
                this.inflightConfigs.add(request.getConfigId());
                inflights.add(request.getConfigId());
            }
            BatchRequestType batchRequest = this.toBatchRequest(toProcess);
            ThreadedActionListener listener = new ThreadedActionListener(LOG, this.threadPool, this.threadPoolName, this.getResponseListener(toProcess, batchRequest), false);
            ActionListener listenerWithRelease = ActionListener.runAfter((ActionListener)listener, (Runnable)afterProcessCallback);
            this.executeBatchRequest(batchRequest, ActionListener.runAfter((ActionListener)listenerWithRelease, () -> {
                if (!inflights.isEmpty()) {
                    this.inflightConfigs.removeAll(inflights);
                }
            }));
        } else {
            emptyQueueCallback.run();
        }
    }

    protected abstract ActionListener<BatchResponseType> getResponseListener(List<RequestType> var1, BatchRequestType var2);
}

