/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.tim;

import net.sourceforge.plantuml.preproc.OptionKey;
import net.sourceforge.plantuml.text.StringLocated;
import net.sourceforge.plantuml.tim.Eater;
import net.sourceforge.plantuml.tim.EaterException;
import net.sourceforge.plantuml.tim.TContext;
import net.sourceforge.plantuml.tim.TMemory;
import net.sourceforge.plantuml.tim.expression.TValue;
import net.sourceforge.plantuml.warning.Warning;

public class EaterOption
extends Eater {
    public EaterOption(StringLocated s2) {
        super(s2);
    }

    @Override
    public void analyze(TContext context, TMemory memory) throws EaterException {
        this.skipSpaces();
        this.checkAndEatChar("!option");
        this.skipSpaces();
        String key = this.eatAndGetVarname();
        this.skipSpaces();
        TValue value = this.eatExpression(context, memory);
        this.skipSpaces();
        OptionKey optionKey = OptionKey.lazyFrom(key);
        if (optionKey == null) {
            context.getPreprocessingArtifact().addWarning(new Warning("No such !option " + key));
        } else {
            context.getPreprocessingArtifact().getOption().define(optionKey, value.toString());
        }
    }
}

