/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.util.graph;

import java.util.Collection;
import net.sf.sdedit.util.Pair;
import net.sf.sdedit.util.collection.IStack;
import net.sf.sdedit.util.collection.StackImpl;
import net.sf.sdedit.util.graph.Edge;
import net.sf.sdedit.util.graph.Node;

public class DepthFirstSearch {
    private IStack<Pair<Node, IStack<Edge>>> stack;
    private Collection<Node> allNodes;
    private static int n = 0;

    public DepthFirstSearch(Collection<Node> allNodes) {
        this.allNodes = allNodes;
        this.stack = new StackImpl<Pair<Node, IStack<Edge>>>();
    }

    private void push(Node node) {
        StackImpl<Edge> nodeStack = new StackImpl<Edge>();
        Pair entry = new Pair(node, nodeStack);
        for (Edge edge : node.getEdges()) {
            if (edge.isVisited()) continue;
            nodeStack.push(edge);
        }
        this.stack.push(entry);
    }

    public void start() {
        for (Node node : this.allNodes) {
            if (node.getTRoot() != null) continue;
            this.push(node);
            node.setTRoot(node);
            this.dfs();
        }
    }

    private void dfs() {
        while (!this.stack.isEmpty()) {
            Node next;
            Pair<Node, IStack<Edge>> entry = this.stack.peek();
            Node node = entry.getFirst();
            IStack<Edge> subStack = entry.getSecond();
            if (subStack.isEmpty()) {
                this.stack.pop();
                continue;
            }
            Edge edge = subStack.pop();
            if (edge.isVisited()) continue;
            edge.setVisited(true);
            if (++n % 100000 == 0) {
                System.out.println(n + " edges visited");
            }
            if ((next = edge.getNode1() == node ? edge.getNode2() : edge.getNode1()).getTRoot() != null) continue;
            this.push(next);
            next.setTRoot(node.getTRoot());
        }
    }
}

