/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.viewcontroller;

import com.eteks.sweethome3d.model.DimensionLine;
import com.eteks.sweethome3d.model.Home;
import com.eteks.sweethome3d.model.Selectable;
import com.eteks.sweethome3d.model.TextStyle;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.viewcontroller.Controller;
import com.eteks.sweethome3d.viewcontroller.DialogView;
import com.eteks.sweethome3d.viewcontroller.LocalizedUndoableEdit;
import com.eteks.sweethome3d.viewcontroller.View;
import com.eteks.sweethome3d.viewcontroller.ViewFactory;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import javax.swing.undo.UndoableEditSupport;

public class DimensionLineController
implements Controller {
    private final Home home;
    private final UserPreferences preferences;
    private final ViewFactory viewFactory;
    private final UndoableEditSupport undoSupport;
    private final PropertyChangeSupport propertyChangeSupport;
    private DialogView dimensionLineView;
    private final boolean dimensionLineModification;
    private boolean editableDistance;
    private Float xStart;
    private Float yStart;
    private Float elevationStart;
    private Float xEnd;
    private Float yEnd;
    private Float elevationEnd;
    private Float distanceToEndPoint;
    private DimensionLineOrientation orientation;
    private Float offset;
    private Float lengthFontSize;
    private Integer color;
    private Boolean visibleIn3D;
    private Float pitch;

    public DimensionLineController(Home home, UserPreferences userPreferences, ViewFactory viewFactory, UndoableEditSupport undoableEditSupport) {
        this.home = home;
        this.preferences = userPreferences;
        this.viewFactory = viewFactory;
        this.undoSupport = undoableEditSupport;
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.dimensionLineModification = true;
        this.updateProperties();
    }

    public DimensionLineController(Home home, float f, float f2, UserPreferences userPreferences, ViewFactory viewFactory, UndoableEditSupport undoableEditSupport) {
        this.home = home;
        this.preferences = userPreferences;
        this.viewFactory = viewFactory;
        this.undoSupport = undoableEditSupport;
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.dimensionLineModification = false;
        this.xStart = this.xEnd = Float.valueOf(f);
        this.yStart = this.yEnd = Float.valueOf(f2);
        this.editableDistance = true;
        this.elevationStart = Float.valueOf(0.0f);
        this.elevationEnd = this.distanceToEndPoint = Float.valueOf(home.getWallHeight());
        this.offset = Float.valueOf(20.0f);
        this.orientation = DimensionLineOrientation.ELEVATION;
        this.lengthFontSize = Float.valueOf(userPreferences.getDefaultTextStyle(DimensionLine.class).getFontSize());
        this.visibleIn3D = true;
        this.pitch = Float.valueOf(-1.5707964f);
    }

    @Override
    public DialogView getView() {
        if (this.dimensionLineView == null) {
            this.dimensionLineView = this.viewFactory.createDimensionLineView(this.dimensionLineModification, this.preferences, this);
        }
        return this.dimensionLineView;
    }

    public void displayView(View view) {
        this.getView().displayView(view);
    }

    public void addPropertyChangeListener(Property property, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(property.name(), propertyChangeListener);
    }

    public void removePropertyChangeListener(Property property, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(property.name(), propertyChangeListener);
    }

    protected void updateProperties() {
        List<DimensionLine> list = Home.getDimensionLinesSubList(this.home.getSelectedItems());
        if (list.isEmpty()) {
            this.setXStart(null);
            this.setYStart(null);
            this.setElevationStart(null);
            this.setXEnd(null);
            this.setYEnd(null);
            this.setElevationEnd(null);
            this.setEditableDistance(false);
            this.setOrientation(null);
            this.setOffset(null);
            this.setLengthFontSize(null);
            this.setColor(null);
            this.setVisibleIn3D(null);
            this.setPitch(null);
        } else {
            Serializable serializable;
            DimensionLine dimensionLine = list.get(0);
            Float f = Float.valueOf(dimensionLine.getXStart());
            for (int i = 1; i < list.size(); ++i) {
                if (f.equals(Float.valueOf(list.get(i).getXStart()))) continue;
                f = null;
                break;
            }
            this.setXStart(f);
            Float f2 = Float.valueOf(dimensionLine.getYStart());
            for (int i = 1; i < list.size(); ++i) {
                if (f2.equals(Float.valueOf(list.get(i).getYStart()))) continue;
                f2 = null;
                break;
            }
            this.setYStart(f2);
            Float f3 = Float.valueOf(dimensionLine.getElevationStart());
            for (int i = 1; i < list.size(); ++i) {
                if (f3.equals(Float.valueOf(list.get(i).getElevationStart()))) continue;
                f3 = null;
                break;
            }
            this.setElevationStart(f3);
            Float f4 = Float.valueOf(dimensionLine.getXEnd());
            for (int i = 1; i < list.size(); ++i) {
                if (f4.equals(Float.valueOf(list.get(i).getXEnd()))) continue;
                f4 = null;
                break;
            }
            this.setXEnd(f4);
            Float f5 = Float.valueOf(dimensionLine.getYEnd());
            for (int i = 1; i < list.size(); ++i) {
                if (f5.equals(Float.valueOf(list.get(i).getYEnd()))) continue;
                f5 = null;
                break;
            }
            this.setYEnd(f5);
            Float f6 = Float.valueOf(dimensionLine.getElevationEnd());
            boolean bl = dimensionLine.isElevationDimensionLine();
            for (int i = 1; i < list.size(); ++i) {
                if (f6.equals(Float.valueOf(list.get(i).getElevationEnd())) && bl == list.get(i).isElevationDimensionLine()) continue;
                f6 = null;
                break;
            }
            this.setElevationEnd(f6);
            this.setEditableDistance(this.getXStart() != null && this.getYStart() != null && this.getElevationStart() != null && this.getXEnd() != null && this.getYEnd() != null && this.getElevationEnd() != null);
            DimensionLineOrientation dimensionLineOrientation = null;
            if (dimensionLine.isElevationDimensionLine()) {
                dimensionLineOrientation = DimensionLineOrientation.ELEVATION;
            } else if (dimensionLine.getElevationStart() == dimensionLine.getElevationEnd()) {
                dimensionLineOrientation = DimensionLineOrientation.PLAN;
            }
            for (int i = 1; i < list.size(); ++i) {
                DimensionLine dimensionLine2 = list.get(i);
                if ((!dimensionLine2.isElevationDimensionLine() || dimensionLineOrientation == DimensionLineOrientation.ELEVATION) && (dimensionLine2.getElevationStart() != dimensionLine2.getElevationEnd() || dimensionLineOrientation == DimensionLineOrientation.PLAN)) continue;
                dimensionLineOrientation = null;
                break;
            }
            this.setOrientation(dimensionLineOrientation, false);
            Float f7 = Float.valueOf(dimensionLine.getOffset());
            for (int i = 1; i < list.size(); ++i) {
                if (f7.equals(Float.valueOf(list.get(i).getOffset()))) continue;
                f7 = null;
                break;
            }
            this.setOffset(f7);
            float f8 = this.preferences.getDefaultTextStyle(DimensionLine.class).getFontSize();
            Float f9 = Float.valueOf(dimensionLine.getLengthStyle() != null ? dimensionLine.getLengthStyle().getFontSize() : f8);
            for (int i = 1; i < list.size(); ++i) {
                serializable = list.get(i);
                if (f9.equals(Float.valueOf(((DimensionLine)serializable).getLengthStyle() != null ? ((DimensionLine)serializable).getLengthStyle().getFontSize() : f8))) continue;
                f9 = null;
                break;
            }
            this.setLengthFontSize(f9);
            Integer n = dimensionLine.getColor();
            if (n != null) {
                for (int i = 1; i < list.size(); ++i) {
                    if (n.equals(list.get(i).getColor())) continue;
                    n = null;
                    break;
                }
            }
            this.setColor(n);
            serializable = Boolean.valueOf(dimensionLine.isVisibleIn3D());
            for (int i = 1; i < list.size(); ++i) {
                if (((Boolean)serializable).equals(list.get(i).isVisibleIn3D())) continue;
                serializable = null;
                break;
            }
            this.setVisibleIn3D((Boolean)serializable);
            Float f10 = Float.valueOf(dimensionLine.getPitch());
            for (int i = 1; i < list.size(); ++i) {
                if (f10.equals(Float.valueOf(list.get(i).getPitch()))) continue;
                f10 = null;
                break;
            }
            this.setPitch(f10);
        }
    }

    public void setXStart(Float f) {
        this.setXStart(f, true);
    }

    private void setXStart(Float f, boolean bl) {
        if (f != this.xStart) {
            Float f2 = this.xStart;
            this.xStart = f;
            this.propertyChangeSupport.firePropertyChange(Property.X_START.name(), f2, f);
            if (bl && this.orientation == DimensionLineOrientation.ELEVATION) {
                this.setXEnd(f, false);
            } else {
                this.updateDistanceToEndPoint();
            }
        }
    }

    public Float getXStart() {
        return this.xStart;
    }

    public void setYStart(Float f) {
        this.setYStart(f, true);
    }

    private void setYStart(Float f, boolean bl) {
        if (f != this.yStart) {
            Float f2 = this.yStart;
            this.yStart = f;
            this.propertyChangeSupport.firePropertyChange(Property.Y_START.name(), f2, f);
            if (bl && this.orientation == DimensionLineOrientation.ELEVATION) {
                this.setYEnd(f, false);
            } else {
                this.updateDistanceToEndPoint();
            }
        }
    }

    public Float getYStart() {
        return this.yStart;
    }

    public void setElevationStart(Float f) {
        this.setElevationStart(f, true);
    }

    private void setElevationStart(Float f, boolean bl) {
        if (f != this.elevationStart) {
            Float f2 = this.elevationStart;
            this.elevationStart = f;
            this.propertyChangeSupport.firePropertyChange(Property.ELEVATION_START.name(), f2, f);
            if (bl && this.orientation == DimensionLineOrientation.PLAN) {
                this.setElevationEnd(f, false);
            } else {
                this.updateDistanceToEndPoint();
            }
        }
    }

    public Float getElevationStart() {
        return this.elevationStart;
    }

    public void setXEnd(Float f) {
        this.setXEnd(f, true);
    }

    private void setXEnd(Float f, boolean bl) {
        if (f != this.xEnd) {
            Float f2 = this.xEnd;
            this.xEnd = f;
            this.propertyChangeSupport.firePropertyChange(Property.X_END.name(), f2, f);
            if (bl && this.orientation == DimensionLineOrientation.ELEVATION) {
                this.setXStart(f, false);
            } else {
                this.updateDistanceToEndPoint();
            }
        }
    }

    public Float getXEnd() {
        return this.xEnd;
    }

    public void setYEnd(Float f) {
        this.setYEnd(f, true);
    }

    private void setYEnd(Float f, boolean bl) {
        if (f != this.yEnd) {
            Float f2 = this.yEnd;
            this.yEnd = f;
            this.propertyChangeSupport.firePropertyChange(Property.Y_END.name(), f2, f);
            if (bl && this.orientation == DimensionLineOrientation.ELEVATION) {
                this.setYStart(f, false);
            } else {
                this.updateDistanceToEndPoint();
            }
        }
    }

    public Float getYEnd() {
        return this.yEnd;
    }

    public void setElevationEnd(Float f) {
        this.setElevationEnd(f, true);
    }

    private void setElevationEnd(Float f, boolean bl) {
        if (f != this.elevationEnd) {
            Float f2 = this.elevationEnd;
            this.elevationEnd = f;
            this.propertyChangeSupport.firePropertyChange(Property.ELEVATION_END.name(), f2, f);
            if (bl && this.orientation == DimensionLineOrientation.PLAN) {
                this.setElevationStart(f, false);
            } else {
                this.updateDistanceToEndPoint();
            }
        }
    }

    public Float getElevationEnd() {
        return this.elevationEnd;
    }

    private void updateDistanceToEndPoint() {
        Float f = this.getXStart();
        Float f2 = this.getYStart();
        Float f3 = this.getElevationStart();
        Float f4 = this.getXEnd();
        Float f5 = this.getYEnd();
        Float f6 = this.getElevationEnd();
        if (f != null && f2 != null && f3 != null && f4 != null && f5 != null && f6 != null) {
            DimensionLine dimensionLine = new DimensionLine(f.floatValue(), f2.floatValue(), f3.floatValue(), f4.floatValue(), f5.floatValue(), f6.floatValue(), 0.0f);
            this.setDistanceToEndPoint(Float.valueOf(dimensionLine.getLength()), false);
        } else {
            this.setDistanceToEndPoint(null, false);
        }
    }

    public void setDistanceToEndPoint(Float f) {
        this.setDistanceToEndPoint(f, true);
    }

    private void setDistanceToEndPoint(Float f, boolean bl) {
        if (f != this.distanceToEndPoint) {
            Float f2 = this.distanceToEndPoint;
            this.distanceToEndPoint = f;
            this.propertyChangeSupport.firePropertyChange(Property.DISTANCE_TO_END_POINT.name(), f2, f);
            if (bl) {
                Float f3 = this.getXStart();
                Float f4 = this.getYStart();
                Float f5 = this.getElevationStart();
                Float f6 = this.getXEnd();
                Float f7 = this.getYEnd();
                Float f8 = this.getElevationEnd();
                if (f3 != null && f4 != null && f5 != null && f6 != null && f7 != null && f8 != null && f != null) {
                    double d = Math.atan2(f4.floatValue() - f7.floatValue(), f6.floatValue() - f3.floatValue());
                    double d2 = Math.atan2(f8.floatValue() - f5.floatValue(), f6.floatValue() - f3.floatValue());
                    this.setXEnd(Float.valueOf((float)((double)f3.floatValue() + (double)f.floatValue() * Math.cos(d) * Math.cos(d2))));
                    this.setYEnd(Float.valueOf((float)((double)f4.floatValue() - (double)f.floatValue() * Math.sin(d) * Math.cos(d2))));
                    this.setElevationEnd(Float.valueOf((float)((double)f5.floatValue() + (double)f.floatValue() * Math.sin(d2))));
                } else {
                    this.setXEnd(null);
                    this.setYEnd(null);
                    this.setElevationEnd(null);
                }
            }
        }
    }

    public Float getDistanceToEndPoint() {
        return this.distanceToEndPoint;
    }

    public void setOrientation(DimensionLineOrientation dimensionLineOrientation) {
        this.setOrientation(dimensionLineOrientation, true);
    }

    private void setOrientation(DimensionLineOrientation dimensionLineOrientation, boolean bl) {
        if (dimensionLineOrientation != this.orientation) {
            DimensionLineOrientation dimensionLineOrientation2 = this.orientation;
            this.orientation = dimensionLineOrientation;
            this.propertyChangeSupport.firePropertyChange(Property.ORIENTATION.name(), (Object)dimensionLineOrientation2, (Object)dimensionLineOrientation);
            if (bl) {
                if (dimensionLineOrientation == DimensionLineOrientation.PLAN && this.pitch.floatValue() != 0.0f && this.pitch.floatValue() != 1.5707964f) {
                    this.setPitch(Float.valueOf(0.0f));
                }
                if (this.distanceToEndPoint != null) {
                    float f = this.distanceToEndPoint.floatValue();
                    Float f2 = this.getXStart();
                    Float f3 = this.getYStart();
                    Float f4 = this.getElevationStart();
                    if (dimensionLineOrientation == DimensionLineOrientation.PLAN) {
                        this.setElevationEnd(f4, false);
                        this.setYEnd(f3, false);
                        this.setXEnd(Float.valueOf(f2.floatValue() + f), false);
                    } else if (dimensionLineOrientation == DimensionLineOrientation.ELEVATION) {
                        this.setXEnd(f2, false);
                        this.setYEnd(f3, false);
                        this.setElevationEnd(Float.valueOf(f4.floatValue() + f), false);
                    }
                }
            }
        }
    }

    public DimensionLineOrientation getOrientation() {
        return this.orientation;
    }

    public void setEditableDistance(boolean bl) {
        if (bl != this.editableDistance) {
            this.editableDistance = bl;
            this.propertyChangeSupport.firePropertyChange(Property.EDITABLE_DISTANCE.name(), !bl, bl);
        }
    }

    public boolean isEditableDistance() {
        return this.editableDistance;
    }

    public void setOffset(Float f) {
        if (f != this.offset) {
            Float f2 = this.offset;
            this.offset = f;
            this.propertyChangeSupport.firePropertyChange(Property.OFFSET.name(), f2, f);
        }
    }

    public Float getOffset() {
        return this.offset;
    }

    public void setLengthFontSize(Float f) {
        if (f != this.lengthFontSize) {
            Float f2 = this.lengthFontSize;
            this.lengthFontSize = f;
            this.propertyChangeSupport.firePropertyChange(Property.LENGTH_FONT_SIZE.name(), f2, f);
        }
    }

    public Float getLengthFontSize() {
        return this.lengthFontSize;
    }

    public void setColor(Integer n) {
        if (n != this.color) {
            Integer n2 = this.color;
            this.color = n;
            this.propertyChangeSupport.firePropertyChange(Property.COLOR.name(), n2, n);
        }
    }

    public Integer getColor() {
        return this.color;
    }

    public void setVisibleIn3D(Boolean bl) {
        if (bl != this.visibleIn3D) {
            Boolean bl2 = this.visibleIn3D;
            this.visibleIn3D = bl;
            this.propertyChangeSupport.firePropertyChange(Property.VISIBLE_IN_3D.name(), bl2, bl);
        }
    }

    public Boolean isVisibleIn3D() {
        return this.visibleIn3D;
    }

    public void setPitch(Float f) {
        if (f != this.pitch) {
            Float f2 = this.pitch;
            this.pitch = f;
            this.propertyChangeSupport.firePropertyChange(Property.PITCH.name(), f2, f);
        }
    }

    public Float getPitch() {
        return this.pitch;
    }

    protected DimensionLine createDimensionLine(float f, float f2, float f3, float f4, float f5, float f6, float f7) {
        DimensionLine dimensionLine = new DimensionLine(this.getXStart().floatValue(), this.getYStart().floatValue(), this.getElevationStart().floatValue(), this.getXEnd().floatValue(), this.getYEnd().floatValue(), this.getElevationEnd().floatValue(), this.getOffset().floatValue());
        this.home.addDimensionLine(dimensionLine);
        return dimensionLine;
    }

    public void createDimensionLine() {
        Serializable serializable;
        List<Selectable> list = this.home.getSelectedItems();
        boolean bl = this.home.isBasePlanLocked();
        boolean bl2 = this.home.isAllLevelsSelection();
        DimensionLine dimensionLine = this.createDimensionLine(this.getXStart().floatValue(), this.getYStart().floatValue(), this.getElevationStart().floatValue(), this.getXEnd().floatValue(), this.getYEnd().floatValue(), this.getElevationEnd().floatValue(), this.getOffset().floatValue());
        Float f = this.getLengthFontSize();
        if (f != null) {
            serializable = this.preferences.getDefaultTextStyle(DimensionLine.class).deriveStyle(f.floatValue());
            dimensionLine.setLengthStyle((TextStyle)serializable);
        }
        dimensionLine.setColor(this.getColor());
        dimensionLine.setVisibleIn3D(this.isVisibleIn3D());
        dimensionLine.setPitch(this.getPitch().floatValue());
        DimensionLineController.doAddAndSelectDimensionLine(this.home, dimensionLine, false);
        if (this.undoSupport != null) {
            serializable = new DimensionLineCreationUndoableEdit(this.home, this.preferences, list.toArray(new Selectable[list.size()]), bl, bl2, dimensionLine);
            this.undoSupport.postEdit((UndoableEdit)((Object)serializable));
        }
    }

    private static void doAddAndSelectDimensionLine(Home home, DimensionLine dimensionLine, boolean bl) {
        if (bl) {
            home.addDimensionLine(dimensionLine);
        }
        home.setBasePlanLocked(false);
        home.setSelectedItems(Arrays.asList(dimensionLine));
        home.setAllLevelsSelection(false);
    }

    private static void doDeleteDimensionLine(Home home, DimensionLine dimensionLine, boolean bl) {
        home.deleteDimensionLine(dimensionLine);
        home.setBasePlanLocked(bl);
    }

    public void modifyDimensionLines() {
        List<Selectable> list = this.home.getSelectedItems();
        List<DimensionLine> list2 = Home.getDimensionLinesSubList(list);
        if (!list2.isEmpty()) {
            Float f = this.getXStart();
            Float f2 = this.getYStart();
            Float f3 = this.getElevationStart();
            Float f4 = this.getXEnd();
            Float f5 = this.getYEnd();
            Float f6 = this.getElevationEnd();
            Float f7 = this.getOffset();
            Float f8 = this.getLengthFontSize();
            Integer n = this.getColor();
            Boolean bl = this.isVisibleIn3D();
            Float f9 = this.getPitch();
            ModifiedDimensionLine[] modifiedDimensionLineArray = new ModifiedDimensionLine[list2.size()];
            for (int i = 0; i < modifiedDimensionLineArray.length; ++i) {
                modifiedDimensionLineArray[i] = new ModifiedDimensionLine(list2.get(i));
            }
            TextStyle textStyle = this.preferences.getDefaultTextStyle(DimensionLine.class);
            DimensionLineController.doModifyDimensionLines(modifiedDimensionLineArray, f, f2, f3, f4, f5, f6, f7, f8, textStyle, n, bl, f9);
            if (this.undoSupport != null) {
                DimensionLinesModificationUndoableEdit dimensionLinesModificationUndoableEdit = new DimensionLinesModificationUndoableEdit(this.home, this.preferences, list.toArray(new Selectable[list.size()]), modifiedDimensionLineArray, f, f2, f3, f4, f5, f6, f7, f8, textStyle, n, bl, f9);
                this.undoSupport.postEdit(dimensionLinesModificationUndoableEdit);
            }
        }
    }

    private static void doModifyDimensionLines(ModifiedDimensionLine[] modifiedDimensionLineArray, Float f, Float f2, Float f3, Float f4, Float f5, Float f6, Float f7, Float f8, TextStyle textStyle, Integer n, Boolean bl, Float f9) {
        for (ModifiedDimensionLine modifiedDimensionLine : modifiedDimensionLineArray) {
            DimensionLine dimensionLine = modifiedDimensionLine.getDimensionLine();
            if (f != null) {
                dimensionLine.setXStart(f.floatValue());
            }
            if (f2 != null) {
                dimensionLine.setYStart(f2.floatValue());
            }
            if (f3 != null) {
                if (f6 == null) {
                    if (dimensionLine.isElevationDimensionLine()) {
                        dimensionLine.setElevationEnd(f3.floatValue() + dimensionLine.getElevationEnd() - dimensionLine.getElevationStart());
                    } else {
                        dimensionLine.setElevationEnd(f3.floatValue());
                    }
                }
                dimensionLine.setElevationStart(f3.floatValue());
            }
            if (f4 != null) {
                dimensionLine.setXEnd(f4.floatValue());
            }
            if (f5 != null) {
                dimensionLine.setYEnd(f5.floatValue());
            }
            if (f6 != null) {
                dimensionLine.setElevationEnd(f6.floatValue());
            }
            if (f7 != null) {
                dimensionLine.setOffset(f7.floatValue());
            }
            if (f8 != null) {
                dimensionLine.setLengthStyle(dimensionLine.getLengthStyle() != null ? dimensionLine.getLengthStyle().deriveStyle(f8.floatValue()) : textStyle.deriveStyle(f8.floatValue()));
            }
            if (n != null) {
                dimensionLine.setColor(n);
            }
            if (bl != null) {
                dimensionLine.setVisibleIn3D(bl);
            }
            if (f9 == null) continue;
            dimensionLine.setPitch(f9.floatValue());
        }
    }

    private static void undoModifyDimensionLines(ModifiedDimensionLine[] modifiedDimensionLineArray) {
        for (ModifiedDimensionLine modifiedDimensionLine : modifiedDimensionLineArray) {
            modifiedDimensionLine.reset();
        }
    }

    private static final class ModifiedDimensionLine {
        private final DimensionLine dimensionLine;
        private final float xStart;
        private final float yStart;
        private final float elevationStart;
        private final float xEnd;
        private final float yEnd;
        private final float elevationEnd;
        private final float offset;
        private final TextStyle lengthStyle;
        private final Integer color;
        private final boolean visibleIn3D;
        private final float pitch;

        public ModifiedDimensionLine(DimensionLine dimensionLine) {
            this.dimensionLine = dimensionLine;
            this.xStart = dimensionLine.getXStart();
            this.yStart = dimensionLine.getYStart();
            this.elevationStart = dimensionLine.getElevationStart();
            this.xEnd = dimensionLine.getXEnd();
            this.yEnd = dimensionLine.getYEnd();
            this.elevationEnd = dimensionLine.getElevationEnd();
            this.offset = dimensionLine.getOffset();
            this.lengthStyle = dimensionLine.getLengthStyle();
            this.color = dimensionLine.getColor();
            this.visibleIn3D = dimensionLine.isVisibleIn3D();
            this.pitch = dimensionLine.getPitch();
        }

        public DimensionLine getDimensionLine() {
            return this.dimensionLine;
        }

        public void reset() {
            this.dimensionLine.setXStart(this.xStart);
            this.dimensionLine.setYStart(this.yStart);
            this.dimensionLine.setElevationStart(this.elevationStart);
            this.dimensionLine.setXEnd(this.xEnd);
            this.dimensionLine.setYEnd(this.yEnd);
            this.dimensionLine.setElevationEnd(this.elevationEnd);
            this.dimensionLine.setOffset(this.offset);
            this.dimensionLine.setLengthStyle(this.lengthStyle);
            this.dimensionLine.setColor(this.color);
            this.dimensionLine.setVisibleIn3D(this.visibleIn3D);
            this.dimensionLine.setPitch(this.pitch);
        }
    }

    public static enum DimensionLineOrientation {
        PLAN,
        ELEVATION,
        DIAGONAL;

    }

    public static enum Property {
        X_START,
        Y_START,
        ELEVATION_START,
        X_END,
        Y_END,
        ELEVATION_END,
        DISTANCE_TO_END_POINT,
        ORIENTATION,
        EDITABLE_DISTANCE,
        OFFSET,
        LENGTH_FONT_SIZE,
        COLOR,
        VISIBLE_IN_3D,
        PITCH;

    }

    private static class DimensionLineCreationUndoableEdit
    extends LocalizedUndoableEdit {
        private final Home home;
        private final Selectable[] oldSelection;
        private final boolean oldBasePlanLocked;
        private final boolean oldAllLevelsSelection;
        private final DimensionLine dimensionLine;

        private DimensionLineCreationUndoableEdit(Home home, UserPreferences userPreferences, Selectable[] selectableArray, boolean bl, boolean bl2, DimensionLine dimensionLine) {
            super(userPreferences, DimensionLineController.class, "undoCreateDimensionLineName");
            this.home = home;
            this.oldSelection = selectableArray;
            this.oldBasePlanLocked = bl;
            this.oldAllLevelsSelection = bl2;
            this.dimensionLine = dimensionLine;
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            DimensionLineController.doDeleteDimensionLine(this.home, this.dimensionLine, this.oldBasePlanLocked);
            this.home.setSelectedItems(Arrays.asList(this.oldSelection));
            this.home.setAllLevelsSelection(this.oldAllLevelsSelection);
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            DimensionLineController.doAddAndSelectDimensionLine(this.home, this.dimensionLine, true);
        }
    }

    private static class DimensionLinesModificationUndoableEdit
    extends LocalizedUndoableEdit {
        private final Home home;
        private final Selectable[] oldSelection;
        private final ModifiedDimensionLine[] modifiedDimensionLines;
        private final Float xStart;
        private final Float yStart;
        private final Float elevationStart;
        private final Float xEnd;
        private final Float yEnd;
        private final Float elevationEnd;
        private final Float offset;
        private final Float lengthFontSize;
        private final TextStyle defaultStyle;
        private final Integer color;
        private final Boolean visibleIn3D;
        private final Float pitch;

        private DimensionLinesModificationUndoableEdit(Home home, UserPreferences userPreferences, Selectable[] selectableArray, ModifiedDimensionLine[] modifiedDimensionLineArray, Float f, Float f2, Float f3, Float f4, Float f5, Float f6, Float f7, Float f8, TextStyle textStyle, Integer n, Boolean bl, Float f9) {
            super(userPreferences, DimensionLineController.class, "undoModifyDimensionLinesName");
            this.home = home;
            this.oldSelection = selectableArray;
            this.modifiedDimensionLines = modifiedDimensionLineArray;
            this.xStart = f;
            this.yStart = f2;
            this.elevationStart = f3;
            this.xEnd = f4;
            this.yEnd = f5;
            this.elevationEnd = f6;
            this.offset = f7;
            this.lengthFontSize = f8;
            this.defaultStyle = textStyle;
            this.color = n;
            this.visibleIn3D = bl;
            this.pitch = f9;
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            DimensionLineController.undoModifyDimensionLines(this.modifiedDimensionLines);
            this.home.setSelectedItems(Arrays.asList(this.oldSelection));
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            DimensionLineController.doModifyDimensionLines(this.modifiedDimensionLines, this.xStart, this.yStart, this.elevationStart, this.xEnd, this.yEnd, this.elevationEnd, this.offset, this.lengthFontSize, this.defaultStyle, this.color, this.visibleIn3D, this.pitch);
            this.home.setSelectedItems(Arrays.asList(this.oldSelection));
        }
    }
}

