/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.instrumentation;

import java.io.IOException;
import java.util.ArrayList;
import org.graalvm.visualvm.lib.jfluid.classfile.ClassInfo;
import org.graalvm.visualvm.lib.jfluid.classfile.ClassRepository;
import org.graalvm.visualvm.lib.jfluid.classfile.DynamicClassInfo;
import org.graalvm.visualvm.lib.jfluid.client.ClientUtils;
import org.graalvm.visualvm.lib.jfluid.global.ProfilingSessionStatus;
import org.graalvm.visualvm.lib.jfluid.instrumentation.BadLocationException;
import org.graalvm.visualvm.lib.jfluid.instrumentation.ClassManager;
import org.graalvm.visualvm.lib.jfluid.instrumentation.ClassRewriter;
import org.graalvm.visualvm.lib.jfluid.instrumentation.DynamicConstantPoolExtension;
import org.graalvm.visualvm.lib.jfluid.instrumentation.InstrumentationFactory;
import org.graalvm.visualvm.lib.jfluid.utils.MiscUtils;
import org.graalvm.visualvm.lib.jfluid.wireprotocol.RootClassLoadedCommand;

public class CodeRegionMethodInstrumentor
extends ClassManager {
    private ClientUtils.SourceCodeSelection sourceCodeSelection;
    private ArrayList instrClasses;
    private String className;
    private int nInstrClasses;

    public CodeRegionMethodInstrumentor(ClassRepository repo, ProfilingSessionStatus status, ClientUtils.SourceCodeSelection codeSelection) {
        super(repo, status);
        this.sourceCodeSelection = codeSelection;
        this.className = this.sourceCodeSelection.getClassName().replace('.', '/').intern();
        this.instrClasses = new ArrayList();
    }

    public Object[] getFollowUpInstrumentCodeRegionResponse(int classLoaderId) {
        DynamicClassInfo clazz = this.javaClassForName(this.className, classLoaderId);
        this.instrClasses.clear();
        this.instrClasses.add(clazz);
        this.nInstrClasses = 1;
        return this.createInstrumentedMethodPack();
    }

    protected Object[] createInstrumentedMethodPack() {
        if (this.nInstrClasses == 0) {
            return null;
        }
        return this.createInstrumentedMethodPack15();
    }

    Object[] getInitialInstrumentCodeRegionResponse(RootClassLoadedCommand rootLoaded) {
        String[] loadedClasses = rootLoaded.getAllLoadedClassNames();
        int[] loadedClassLoaderIds = rootLoaded.getAllLoadedClassLoaderIds();
        DynamicClassInfo clazz = null;
        this.storeClassFileBytesForCustomLoaderClasses(rootLoaded);
        for (int i = 0; i < loadedClasses.length; ++i) {
            int mIdx;
            ClassRepository.CodeRegionBCI instrLocation;
            String loadedClassName = loadedClasses[i];
            if (this.className != loadedClassName || (clazz = this.javaClassForName(loadedClasses[i], loadedClassLoaderIds[i])) == null || (instrLocation = this.computeCodeRegionFromSourceCodeSelection(clazz)) == null || (mIdx = clazz.getMethodIndex(instrLocation.methodName, instrLocation.methodSignature)) == -1) continue;
            clazz.setLoaded(true);
            this.instrClasses.add(clazz);
        }
        this.nInstrClasses = this.instrClasses.size();
        return this.createInstrumentedMethodPack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassRepository.CodeRegionBCI computeCodeRegionFromSourceCodeSelection(ClassInfo clazz) {
        try {
            if (this.sourceCodeSelection.definedViaSourceLines()) {
                int startLine = this.sourceCodeSelection.getStartLine();
                int endLine = this.sourceCodeSelection.getEndLine();
                ClassRepository.CodeRegionBCI loc = this.classRepo.getMethodForSourceRegion(clazz, startLine, endLine);
                this.status.beginTrans(true);
                try {
                    this.status.setInstrMethodNames(new String[]{loc.methodName});
                    this.status.setInstrMethodSignatures(new String[]{loc.methodSignature});
                }
                finally {
                    this.status.endTrans();
                }
                return loc;
            }
            if (this.sourceCodeSelection.definedViaMethodName()) {
                String methodName = this.sourceCodeSelection.getMethodName();
                String methodSignature = this.sourceCodeSelection.getMethodSignature();
                return ClassRepository.getMethodMinAndMaxBCI(clazz, methodName, methodSignature);
            }
        }
        catch (IOException ex) {
            MiscUtils.printErrorMessage(ex.getMessage());
        }
        catch (BadLocationException ex) {
            MiscUtils.printErrorMessage(ex.getMessage());
        }
        catch (ClassNotFoundException ex) {
            MiscUtils.printErrorMessage(ex.getMessage());
        }
        return null;
    }

    private Object[] createInstrumentedMethodPack15() {
        String[] instrMethodClasses = new String[this.nInstrClasses];
        int[] instrClassLoaderIds = new int[this.nInstrClasses];
        byte[][] replacementClassFileBytes = new byte[this.nInstrClasses][];
        for (int j = 0; j < this.nInstrClasses; ++j) {
            DynamicClassInfo clazz = (DynamicClassInfo)this.instrClasses.get(j);
            instrMethodClasses[j] = clazz.getName().replace('/', '.');
            instrClassLoaderIds[j] = clazz.getLoaderId();
            ClassRepository.CodeRegionBCI instrLocation = this.computeCodeRegionFromSourceCodeSelection(clazz);
            int mIdx = clazz.getMethodIndex(instrLocation.methodName, instrLocation.methodSignature);
            clazz.setMethodInstrumented(mIdx);
            DynamicConstantPoolExtension ecp = DynamicConstantPoolExtension.getCPFragment(clazz, 8);
            byte[] newMethodInfo = InstrumentationFactory.instrumentCodeRegion(clazz, mIdx, instrLocation.bci0, instrLocation.bci1);
            int nMethods = clazz.getMethodNames().length;
            byte[][] replacementMethodInfos = new byte[nMethods][];
            for (int i = 0; i < nMethods; ++i) {
                replacementMethodInfos[i] = clazz.getMethodInfo(i);
            }
            replacementMethodInfos[mIdx] = newMethodInfo;
            int nAddedCPEntries = ecp.getNEntries();
            byte[] addedCPContents = ecp.getContents();
            replacementClassFileBytes[j] = ClassRewriter.rewriteClassFile(clazz, replacementMethodInfos, nAddedCPEntries, addedCPContents);
        }
        return new Object[]{instrMethodClasses, instrClassLoaderIds, replacementClassFileBytes};
    }
}

