"use strict";
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.H4 = exports.h4Style = exports.H3 = exports.h3Style = exports.H2 = exports.h2Style = exports.H1 = exports.h1Style = exports.Heading = void 0;
const jsx_runtime_1 = require("@emotion/react/jsx-runtime");
const Text_1 = require("./Text");
const mediaQueries_1 = require("../mediaQueries");
const Heading = (_a) => {
    var { level } = _a, props = __rest(_a, ["level"]);
    switch (level) {
        case '2':
            return (0, jsx_runtime_1.jsx)(exports.H2, Object.assign({}, props));
        case '3':
            return (0, jsx_runtime_1.jsx)(exports.H3, Object.assign({}, props));
        case '4':
            return (0, jsx_runtime_1.jsx)(exports.H4, Object.assign({}, props));
        case '1':
        default:
            return (0, jsx_runtime_1.jsx)(exports.H1, Object.assign({}, props));
    }
};
exports.Heading = Heading;
const h1Style = (theme, _a) => {
    var { block = true, color = theme.general.color, level = '1', noWrap = false, textTransform = 'none' } = _a, props = __rest(_a, ["block", "color", "level", "noWrap", "textTransform"]);
    return (Object.assign(Object.assign({}, (0, Text_1.textStyle)(theme, Object.assign({ block, color, noWrap, textTransform }, props))), { fontSize: '3rem', fontWeight: 400, lineHeight: '3.5rem', marginBottom: '64px', marginTop: 0, minHeight: '3rem', [mediaQueries_1.media[mediaQueries_1.QueryKeys.MOBILE]]: {
            fontSize: '2.5rem',
            lineHeight: '3rem',
        } }));
};
exports.h1Style = h1Style;
const H1 = (props) => ((0, jsx_runtime_1.jsx)("h1", Object.assign({ css: (theme) => (0, exports.h1Style)(theme, props) }, (0, Text_1.filterTextProps)(props))));
exports.H1 = H1;
const h2Style = (theme, _a) => {
    var { block = true, color = theme.general.color, noWrap = false, textTransform = 'none' } = _a, props = __rest(_a, ["block", "color", "noWrap", "textTransform"]);
    return (Object.assign(Object.assign({}, (0, Text_1.textStyle)(theme, Object.assign({ block, color, noWrap, textTransform }, props))), { fontSize: '1.25rem', fontWeight: 700, lineHeight: '1.75rem', marginBottom: '24px', marginTop: '32px', [mediaQueries_1.media[mediaQueries_1.QueryKeys.MOBILE]]: {
            fontSize: '1.125rem',
            lineHeight: '1.625rem',
            marginBottom: '20px',
            marginTop: '26px',
        } }));
};
exports.h2Style = h2Style;
const H2 = (props) => ((0, jsx_runtime_1.jsx)("h2", Object.assign({ css: (theme) => (0, exports.h2Style)(theme, props) }, (0, Text_1.filterTextProps)(props))));
exports.H2 = H2;
const h3Style = (theme, _a) => {
    var { block = true, color = theme.general.color, noWrap = false, textTransform = 'none' } = _a, props = __rest(_a, ["block", "color", "noWrap", "textTransform"]);
    return (Object.assign(Object.assign({}, (0, Text_1.textStyle)(theme, Object.assign({ block, color, noWrap, textTransform }, props))), { fontSize: theme.fontSizes.base, fontWeight: 600, marginBottom: '16px' }));
};
exports.h3Style = h3Style;
const H3 = (props) => ((0, jsx_runtime_1.jsx)("h3", Object.assign({ css: (theme) => (0, exports.h3Style)(theme, props) }, (0, Text_1.filterTextProps)(props))));
exports.H3 = H3;
const h4Style = (theme, _a) => {
    var { block = true, color = theme.general.color, noWrap = false, textTransform = 'none' } = _a, props = __rest(_a, ["block", "color", "noWrap", "textTransform"]);
    return (Object.assign(Object.assign({}, (0, Text_1.textStyle)(theme, Object.assign({ block, color, noWrap, textTransform }, props))), { fontSize: theme.fontSizes.extraSmall, fontWeight: 400, marginBottom: '5px', marginTop: '20px' }));
};
exports.h4Style = h4Style;
const H4 = (props) => ((0, jsx_runtime_1.jsx)("h3", Object.assign({ css: (theme) => (0, exports.h4Style)(theme, props) }, (0, Text_1.filterTextProps)(props))));
exports.H4 = H4;
