/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.MemberValuePair;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.ElementValuePair;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.parser.Parser;

public class AnnotationMethodDeclaration
extends MethodDeclaration {
    public Expression defaultValue;
    public int extendedDimensions;

    public AnnotationMethodDeclaration(CompilationResult compilationResult) {
        super(compilationResult);
    }

    @Override
    public void generateCode(ClassFile classFile) {
        classFile.generateMethodInfoHeader(this.binding);
        int n = classFile.contentsOffset;
        int n2 = classFile.generateMethodInfoAttributes(this.binding, this);
        classFile.completeMethodInfo(this.binding, n, n2);
    }

    @Override
    public boolean isAnnotationMethod() {
        return true;
    }

    @Override
    public boolean isMethod() {
        return false;
    }

    @Override
    public void parseStatements(Parser parser, CompilationUnitDeclaration compilationUnitDeclaration) {
    }

    @Override
    public StringBuffer print(int n, StringBuffer stringBuffer) {
        int n2;
        TypeParameter[] typeParameterArray;
        AnnotationMethodDeclaration.printIndent(n, stringBuffer);
        AnnotationMethodDeclaration.printModifiers(this.modifiers, stringBuffer);
        if (this.annotations != null) {
            AnnotationMethodDeclaration.printAnnotations(this.annotations, stringBuffer);
            stringBuffer.append(' ');
        }
        if ((typeParameterArray = this.typeParameters()) != null) {
            stringBuffer.append('<');
            n2 = typeParameterArray.length - 1;
            for (int i = 0; i < n2; ++i) {
                typeParameterArray[i].print(0, stringBuffer);
                stringBuffer.append(", ");
            }
            typeParameterArray[n2].print(0, stringBuffer);
            stringBuffer.append('>');
        }
        this.printReturnType(0, stringBuffer).append(this.selector).append('(');
        if (this.arguments != null) {
            for (n2 = 0; n2 < this.arguments.length; ++n2) {
                if (n2 > 0) {
                    stringBuffer.append(", ");
                }
                this.arguments[n2].print(0, stringBuffer);
            }
        }
        stringBuffer.append(')');
        if (this.thrownExceptions != null) {
            stringBuffer.append(" throws ");
            for (n2 = 0; n2 < this.thrownExceptions.length; ++n2) {
                if (n2 > 0) {
                    stringBuffer.append(", ");
                }
                this.thrownExceptions[n2].print(0, stringBuffer);
            }
        }
        if (this.defaultValue != null) {
            stringBuffer.append(" default ");
            this.defaultValue.print(0, stringBuffer);
        }
        this.printBody(n + 1, stringBuffer);
        return stringBuffer;
    }

    @Override
    public void resolveStatements() {
        block10: {
            Object object;
            TypeBinding typeBinding;
            block12: {
                block11: {
                    super.resolveStatements();
                    if (this.arguments != null || this.receiver != null) {
                        this.scope.problemReporter().annotationMembersCannotHaveParameters(this);
                    }
                    if (this.typeParameters != null) {
                        this.scope.problemReporter().annotationMembersCannotHaveTypeParameters(this);
                    }
                    if (this.extendedDimensions != 0) {
                        this.scope.problemReporter().illegalExtendedDimensions(this);
                    }
                    if (this.binding == null) {
                        return;
                    }
                    typeBinding = this.binding.returnType;
                    if (typeBinding == null) break block10;
                    object = typeBinding.leafComponentType();
                    if (typeBinding.dimensions() > 1) break block11;
                    switch (((TypeBinding)object).erasure().id) {
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 7: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 11: 
                        case 16: {
                            break block12;
                        }
                        default: {
                            if (((TypeBinding)object).isEnum() || ((Binding)object).isAnnotationType()) break block12;
                        }
                    }
                }
                this.scope.problemReporter().invalidAnnotationMemberType(this);
            }
            if (this.defaultValue != null) {
                object = new MemberValuePair(this.selector, this.sourceStart, this.sourceEnd, this.defaultValue);
                ((MemberValuePair)object).binding = this.binding;
                if (((MemberValuePair)object).value.resolvedType == null) {
                    ((MemberValuePair)object).resolveTypeExpecting(this.scope, typeBinding);
                }
                this.binding.setDefaultValue(ElementValuePair.getValue(this.defaultValue));
            } else {
                this.binding.setDefaultValue(null);
            }
        }
    }

    @Override
    public void traverse(ASTVisitor aSTVisitor, ClassScope classScope) {
        if (aSTVisitor.visit(this, classScope)) {
            if (this.annotations != null) {
                int n = this.annotations.length;
                for (int i = 0; i < n; ++i) {
                    this.annotations[i].traverse(aSTVisitor, this.scope);
                }
            }
            if (this.returnType != null) {
                this.returnType.traverse(aSTVisitor, this.scope);
            }
            if (this.defaultValue != null) {
                this.defaultValue.traverse(aSTVisitor, this.scope);
            }
        }
        aSTVisitor.endVisit(this, classScope);
    }
}

