/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.text;

import org.freeplane.core.util.HtmlUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.filter.StringMatchingStrategy;
import org.freeplane.features.filter.condition.ASelectableCondition;
import org.freeplane.features.filter.condition.StringConditionAdapter;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.note.NoteModel;
import org.freeplane.n3.nanoxml.XMLElement;

public class NoteContainsCondition
extends StringConditionAdapter {
    static final String IGNORE_CASE_NAME = "note_contains_condition";
    static final String MATCH_CASE_NAME = "match_case_note_contains_condition";
    static final String VALUE = "VALUE";
    private final String value;
    final StringMatchingStrategy stringMatchingStrategy;

    static ASelectableCondition loadMatchCase(XMLElement element) {
        return new NoteContainsCondition(element.getAttribute(VALUE, null), true, Boolean.valueOf(element.getAttribute("MATCH_APPROXIMATELY", null)), Boolean.valueOf(element.getAttribute("IGNORE_DIACRITICS", null)));
    }

    static ASelectableCondition loadIgnoreCase(XMLElement element) {
        return new NoteContainsCondition(element.getAttribute(VALUE, null), false, Boolean.valueOf(element.getAttribute("MATCH_APPROXIMATELY", null)), Boolean.valueOf(element.getAttribute("IGNORE_DIACRITICS", null)));
    }

    NoteContainsCondition(String value, boolean matchCase, boolean matchApproximately, boolean ignoreDiacritics) {
        super(matchCase, matchApproximately, ignoreDiacritics);
        this.value = value;
        this.stringMatchingStrategy = matchApproximately ? StringMatchingStrategy.DEFAULT_APPROXIMATE_STRING_MATCHING_STRATEGY : StringMatchingStrategy.EXACT_STRING_MATCHING_STRATEGY;
    }

    @Override
    public boolean checkNode(NodeModel node) {
        String text = this.getText(node);
        if (text == null) {
            return false;
        }
        return this.stringMatchingStrategy.matches(this.normalizedValue(), this.normalize(text), true);
    }

    @Override
    protected String createDescription() {
        return this.createDescription(true);
    }

    protected String createDescription(boolean matchCase) {
        String nodeCondition = TextUtils.getText("filter_note");
        String simpleCondition = TextUtils.getText("filter_contains");
        return this.createDescription(nodeCondition, simpleCondition, this.value);
    }

    protected String getText(NodeModel node) {
        String noteText = NoteModel.getNoteText(node);
        return noteText == null ? null : HtmlUtils.htmlToPlain(noteText);
    }

    @Override
    public void fillXML(XMLElement child) {
        super.fillXML(child);
        child.setAttribute(VALUE, this.value);
    }

    @Override
    protected String getName() {
        return this.matchCase ? MATCH_CASE_NAME : IGNORE_CASE_NAME;
    }

    @Override
    protected Object conditionValue() {
        return this.value;
    }
}

