/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.svg;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.JOptionPane;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.ExtensionHandler;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGGraphics2D;
import org.freeplane.features.export.mindmapmode.IExportEngine;
import org.freeplane.features.ui.FrameController;
import org.freeplane.plugin.svg.GradientExtensionHandler;
import org.freeplane.view.swing.map.MapView;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

abstract class ExportVectorGraphic
implements IExportEngine {
    private static final LookAndFeel CROSS_PLATTFORM_LOOK_AND_FEEL;

    ExportVectorGraphic() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SVGGraphics2D createSVGGraphics2D(MapView view) {
        LookAndFeel previousLnF = UIManager.getLookAndFeel();
        this.setLnF(view, CROSS_PLATTFORM_LOOK_AND_FEEL);
        try {
            DOMImplementation impl = GenericDOMImplementation.getDOMImplementation();
            String namespaceURI = "http://www.w3.org/2000/svg";
            Document domFactory = impl.createDocument("http://www.w3.org/2000/svg", "svg", null);
            SVGGeneratorContext ctx = this.createGeneratorContext(domFactory);
            SVGGeneratorContext.GraphicContextDefaults defaults = new SVGGeneratorContext.GraphicContextDefaults();
            defaults.setFont(new Font("Arial", 0, 12));
            ctx.setGraphicContextDefaults(defaults);
            ctx.setExtensionHandler((ExtensionHandler)new GradientExtensionHandler());
            ctx.setPrecision(12);
            SVGGraphics2D g2d = new SVGGraphics2D(ctx, false);
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
            view.preparePrinting();
            Rectangle innerBounds = view.getInnerBounds();
            g2d.setSVGCanvasSize(new Dimension(innerBounds.width, innerBounds.height));
            g2d.translate(-innerBounds.x, -innerBounds.y);
            view.print((Graphics)g2d);
            view.endPrinting();
            SVGGraphics2D sVGGraphics2D = g2d;
            return sVGGraphics2D;
        }
        finally {
            this.setLnF(view, previousLnF);
        }
    }

    private String currentLookAndFeelClassName() {
        return UIManager.getLookAndFeel().getClass().getName();
    }

    protected SVGGeneratorContext createGeneratorContext(Document domFactory) {
        SVGGeneratorContext ctx = SVGGeneratorContext.createDefault((Document)domFactory);
        return ctx;
    }

    private void setLnF(MapView view, LookAndFeel newLookAndFeel) {
        String currentLookAndFeelClassName = this.currentLookAndFeelClassName();
        if (currentLookAndFeelClassName.equals(newLookAndFeel.getClass().getName())) {
            return;
        }
        try {
            UIManager.setLookAndFeel(newLookAndFeel);
            Frame frame = JOptionPane.getFrameForComponent(view.getRoot().getRootPane());
            SwingUtilities.updateComponentTreeUI(frame);
        }
        catch (Exception ex) {
            throw new RuntimeException("Error when changing L&F for SVG Export!", ex);
        }
    }

    static {
        try {
            CROSS_PLATTFORM_LOOK_AND_FEEL = (LookAndFeel)FrameController.class.getClassLoader().loadClass(UIManager.getCrossPlatformLookAndFeelClassName()).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

