/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map.overview;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.event.MouseInputAdapter;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.ui.IMapViewManager;
import org.freeplane.view.swing.map.MapView;
import org.freeplane.view.swing.map.overview.MapOverviewImage;

class MapOverviewImageMouseHandler
extends MouseInputAdapter {
    private static final String ZOOM_AROUND_SELECTED_NODE_PROPERTY = "zoomAroundSelectedNode";
    private final MapView mapView;
    private final JScrollPane mapViewScrollPane;

    MapOverviewImageMouseHandler(MapView mapView, JScrollPane mapViewScrollPane) {
        this.mapView = mapView;
        this.mapViewScrollPane = mapViewScrollPane;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            MapOverviewImage image = (MapOverviewImage)e.getComponent();
            image.showPopupMenu(e.getX(), e.getY());
        } else if (e.getButton() == 1) {
            this.processMousePanEvent(e);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        e.getComponent().setCursor(Cursor.getPredefinedCursor(1));
    }

    @Override
    public void mouseExited(MouseEvent e) {
        e.getComponent().setCursor(Cursor.getDefaultCursor());
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        double zoom = this.calculateNewZoom(e);
        IMapViewManager viewManager = Controller.getCurrentController().getMapViewManager();
        viewManager.changeToMapView(this.mapView);
        ResourceController resourceController = ResourceController.getResourceController();
        if (!resourceController.getBooleanProperty(ZOOM_AROUND_SELECTED_NODE_PROPERTY)) {
            MapOverviewImage image = (MapOverviewImage)e.getComponent();
            this.scrollTo(image, e.getPoint());
            Dimension viewportSize = this.mapViewScrollPane.getViewport().getExtentSize();
            Point mapViewLocation = this.mapView.getLocation();
            Point keptPoint = new Point(-mapViewLocation.x + viewportSize.width / 2, -mapViewLocation.y + viewportSize.height / 2);
            this.mapView.setZoom((float)zoom, keptPoint);
            this.mapView.setShowsSelectedAfterScroll(false);
        }
        viewManager.setZoom((float)zoom);
    }

    private double calculateNewZoom(MouseWheelEvent e) {
        double oldZoom = this.mapView.getZoom();
        double zoomFactor = 1.25;
        double zoom = e.getWheelRotation() > 0 ? oldZoom / zoomFactor : oldZoom * zoomFactor;
        double x = Math.round(Math.log(zoom) / Math.log(1.25));
        zoom = Math.pow(1.25, x);
        zoom = Math.max(Math.min(zoom, 32.0), (double)0.03f);
        return zoom;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.processMousePanEvent(e);
    }

    private void processMousePanEvent(MouseEvent e) {
        MapOverviewImage image = (MapOverviewImage)e.getComponent();
        this.scrollTo(image, e.getPoint());
    }

    private void scrollTo(MapOverviewImage overview, Point newCenterPointOnOverview) {
        int maximumValidY;
        int maximumValidX;
        Rectangle overviewBounds;
        Dimension overviewSize;
        Rectangle mapBounds = this.mapView.getRoot().getBounds();
        Dimension mapSize = mapBounds.getSize();
        double scale = overview.getBestScale(mapSize, overviewSize = (overviewBounds = overview.getBounds()).getSize());
        int minimumValidX = (int)(((double)overviewSize.width - (double)mapSize.width * scale) / 2.0);
        if (newCenterPointOnOverview.x < minimumValidX) {
            newCenterPointOnOverview.x = minimumValidX;
        } else if (0 < minimumValidX && newCenterPointOnOverview.x > (maximumValidX = overviewSize.width - minimumValidX)) {
            newCenterPointOnOverview.x = maximumValidX;
        }
        int minimumValidY = (int)(((double)overviewSize.height - (double)mapSize.height * scale) / 2.0);
        if (newCenterPointOnOverview.y < minimumValidY) {
            newCenterPointOnOverview.y = minimumValidY;
        } else if (0 < minimumValidY && newCenterPointOnOverview.y > (maximumValidY = overviewSize.height - minimumValidY)) {
            newCenterPointOnOverview.y = maximumValidY;
        }
        Point mapLocation = mapBounds.getLocation();
        JViewport viewport = this.mapViewScrollPane.getViewport();
        Dimension viewportSize = viewport.getExtentSize();
        Point newViewPosition = new Point(mapLocation.x + (int)((double)(newCenterPointOnOverview.x - overviewSize.width / 2) / scale) + (mapSize.width - viewportSize.width) / 2, mapLocation.y + (int)((double)(newCenterPointOnOverview.y - overviewSize.height / 2) / scale) + (mapSize.height - viewportSize.height) / 2);
        viewport.setViewPosition(newViewPosition);
    }
}

