/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.gui.settings;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import org.fibs.geotag.Settings;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public abstract class SettingsPanel
extends JPanel {
    private static final I18n i18n = I18nFactory.getI18n(SettingsPanel.class);
    static final String YES = i18n.tr("Yes");
    static final String NO = i18n.tr("No");
    private JPanel panel;
    private JFrame parentFrame;
    private Component editorComponent;
    private Settings.SETTING enablingSetting;
    private boolean defaultEnabled;
    private Settings.SETTING setting;
    private String defaultValue;
    private String title;
    private JCheckBox checkbox;

    public SettingsPanel(JFrame parent, String title, Settings.SETTING enablingSetting, boolean defaultEnabled, Settings.SETTING setting, String defaultValue) {
        super(new BorderLayout());
        TitledBorder border = BorderFactory.createTitledBorder(title);
        this.setBorder(border);
        this.parentFrame = parent;
        this.title = title;
        this.enablingSetting = enablingSetting;
        this.defaultEnabled = defaultEnabled;
        this.setting = setting;
        this.defaultValue = defaultValue;
        this.panel = new JPanel(new BorderLayout());
        if (enablingSetting != null) {
            this.checkbox = new JCheckBox();
            this.checkbox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (SettingsPanel.this.getEditorComponent() != null) {
                        SettingsPanel.this.getEditorComponent().setEnabled(SettingsPanel.this.getCheckbox().isSelected());
                        SettingsPanel.this.getCheckbox().setText(SettingsPanel.this.getCheckbox().isSelected() ? YES : NO);
                    }
                }
            });
            this.checkbox.setSelected(Settings.get(enablingSetting, defaultEnabled));
            this.checkbox.setText(this.checkbox.isSelected() ? YES : NO);
            this.panel.add((Component)this.checkbox, "West");
        }
        this.add((Component)this.panel, "North");
    }

    public void addEditor(Component component) {
        if (this.enablingSetting != null) {
            boolean enabled = Settings.get(this.enablingSetting, this.defaultEnabled);
            component.setEnabled(enabled);
        }
        this.panel.add(component, "Center");
        this.editorComponent = component;
    }

    public abstract String getValue();

    public void save() {
        String value;
        boolean enabled;
        if (this.enablingSetting != null && (enabled = this.checkbox.isSelected()) != Settings.get(this.enablingSetting, false)) {
            System.out.println(String.valueOf(this.enablingSetting.toString()) + '=' + enabled);
            Settings.put(this.enablingSetting, enabled);
        }
        if (!(value = this.getValue()).equals(Settings.get(this.setting, this.defaultValue))) {
            System.out.println(String.valueOf(this.setting.toString()) + '=' + value);
            Settings.put(this.setting, value);
        }
    }

    public Settings.SETTING getSetting() {
        return this.setting;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public String toString() {
        return this.title;
    }

    Component getEditorComponent() {
        return this.editorComponent;
    }

    JCheckBox getCheckbox() {
        return this.checkbox;
    }

    protected JFrame getParentFrame() {
        return this.parentFrame;
    }
}

