/*
 * Copyright (c) 2003-2023, John Wiegley.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer.
 *
 * - Redistributions in binary form must reproduce the above copyright
 *   notice, this list of conditions and the following disclaimer in the
 *   documentation and/or other materials provided with the distribution.
 *
 * - Neither the name of New Artisans LLC nor the names of its
 *   contributors may be used to endorse or promote products derived from
 *   this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * @addtogroup report
 */

/**
 * @file   emacs.h
 * @author John Wiegley
 *
 * @ingroup report
 */
#ifndef INCLUDED_EMACS_H
#define INCLUDED_EMACS_H

#include "chain.h"

namespace ledger {

class xact_t;

class format_emacs_posts : public item_handler<post_t>
{
  format_emacs_posts();

protected:
  std::ostream& out;
  xact_t *     last_xact;

public:
  format_emacs_posts(std::ostream& _out)
    : out(_out), last_xact(NULL) {
    TRACE_CTOR(format_emacs_posts, "std::ostream&");
  }
  ~format_emacs_posts() {
    TRACE_DTOR(format_emacs_posts);
  }

  virtual void write_xact(xact_t& xact);
  virtual void flush() {
    if (last_xact)
      out << "))\n";
    out.flush();
  }
  virtual void operator()(post_t& post);
  virtual string escape_string(string raw);
};

} // namespace ledger

#endif // INCLUDED_EMACS_H
