/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.formcomponents;

import com.install4j.api.context.UserCanceledException;
import com.install4j.api.screens.Console;
import com.install4j.runtime.beans.formcomponents.SystemFormComponent;
import com.install4j.runtime.installer.frontend.components.ProgramGroupSelector;
import javax.swing.JComponent;

public class ProgramGroupComponent
extends SystemFormComponent {
    private String variableName = "";
    private String initialProgramGroup = "";
    private boolean allUsers = false;
    private boolean showWarningIfExists = false;
    private boolean fillVertical = false;
    private ProgramGroupSelector programGroupSelector;
    private boolean initialized;

    public String getVariableName() {
        return ProgramGroupComponent.replaceVariables(this.variableName);
    }

    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }

    public String getInitialProgramGroup() {
        return ProgramGroupComponent.replaceVariables(this.replaceFormVariables(this.initialProgramGroup));
    }

    public void setInitialProgramGroup(String initialProgramGroup) {
        this.initialProgramGroup = initialProgramGroup;
    }

    public boolean isAllUsers() {
        return this.replaceWithTextOverride("allUsers", this.allUsers);
    }

    public void setAllUsers(boolean allUsers) {
        this.allUsers = allUsers;
    }

    public boolean isShowWarningIfExists() {
        return this.replaceWithTextOverride("showWarningIfExists", this.showWarningIfExists);
    }

    public void setShowWarningIfExists(boolean showWarningIfExists) {
        this.showWarningIfExists = showWarningIfExists;
    }

    private void initProgramGroupSelector() {
        if (this.programGroupSelector == null) {
            this.programGroupSelector = new ProgramGroupSelector(this.isAllUsers(), this.isShowWarningIfExists(), this.getContext().getWizardContext());
        }
    }

    @Override
    public void formWillActivate() {
        super.formWillActivate();
        this.initializeProgramGroupSelector();
    }

    public boolean isFillVertical() {
        return this.replaceWithTextOverride("fillVertical", this.fillVertical);
    }

    public void setFillVertical(boolean fillVertical) {
        this.fillVertical = fillVertical;
    }

    @Override
    public boolean handleUnattended() {
        this.initProgramGroupSelector();
        this.setVariable(this.getSelectedProgramGroupName());
        return true;
    }

    private String getUsedInitialProgramGroup() {
        Object value = this.getContext().getVariable(this.getVariableName());
        if (value instanceof String) {
            return (String)value;
        }
        return this.getInitialProgramGroup();
    }

    @Override
    public boolean handleConsole(Console console) throws UserCanceledException {
        String programGroup;
        if (!super.handleConsole(console)) {
            return false;
        }
        while (!ProgramGroupSelector.checkProgramGroup(programGroup = console.askString(null, this.getUsedInitialProgramGroup()), this.isAllUsers(), this.isShowWarningIfExists(), null)) {
        }
        this.setVariable(programGroup);
        return true;
    }

    @Override
    public boolean checkCompleted() {
        if (!this.programGroupSelector.checkSelectedProgramGroup()) {
            return false;
        }
        this.getContext().setVariable(this.getVariableName(), this.getSelectedProgramGroupName());
        this.getContext().registerResponseFileVariable(this.getVariableName());
        return true;
    }

    private void setVariable(String selectedProgramGroupName) {
        this.getContext().setVariable(this.getVariableName(), selectedProgramGroupName);
        this.getContext().registerResponseFileVariable(this.getVariableName());
    }

    private void initializeProgramGroupSelector() {
        if (!this.initialized) {
            this.programGroupSelector.setSelectedProgramGroup(this.getUsedInitialProgramGroup());
            this.initialized = true;
        }
    }

    private String getSelectedProgramGroupName() {
        this.initializeProgramGroupSelector();
        return this.programGroupSelector.getSelectedProgramGroup();
    }

    @Override
    public boolean isFillCenterHorizontal() {
        return true;
    }

    @Override
    public boolean isFillCenterVertical() {
        return this.isFillVertical();
    }

    @Override
    public JComponent createCenterComponent() {
        this.initProgramGroupSelector();
        return this.programGroupSelector;
    }
}

