/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.SoftHashMap;
import java.awt.Font;
import java.util.Map;

public class FontUtils {
    private static Map<FontAttribute, Font> _fontCache;

    public static int getDerivedFontCacheSize() {
        return _fontCache != null ? _fontCache.size() : 0;
    }

    public static void clearDerivedFontCache() {
        if (_fontCache != null) {
            _fontCache.clear();
            _fontCache = null;
        }
    }

    public static Font getCachedDerivedFont(Font font, int style, int size) {
        FontAttribute attribute;
        Font derivedFont;
        if (_fontCache == null) {
            _fontCache = new SoftHashMap<FontAttribute, Font>();
        }
        if ((derivedFont = _fontCache.get(attribute = new FontAttribute(font, style, size))) == null) {
            derivedFont = font.deriveFont(style, size);
            _fontCache.put(attribute, derivedFont);
        }
        return derivedFont;
    }

    private static class FontAttribute {
        private Font _font;
        private int _style;
        private float _size;

        FontAttribute(Font font, int style, float size) {
            this._font = font;
            this._style = style;
            this._size = size;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FontAttribute)) {
                return false;
            }
            FontAttribute that = (FontAttribute)o;
            if (Float.compare(that._size, this._size) != 0) {
                return false;
            }
            if (this._style != that._style) {
                return false;
            }
            return this._font != null && this._font.equals(that._font);
        }

        public int hashCode() {
            int result = this._font.hashCode();
            result = 31 * result + this._style;
            result = 31 * result + (this._size != 0.0f ? Float.floatToIntBits(this._size) : 0);
            return result;
        }
    }
}

