/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.query.functionscore;

import java.io.IOException;
import java.util.Objects;
import org.opensearch.Version;
import org.opensearch.common.lucene.search.function.ScoreFunction;
import org.opensearch.common.lucene.search.function.WeightFactorFunction;
import org.opensearch.core.common.io.stream.NamedWriteable;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.index.query.functionscore.FunctionScoreQueryBuilder;

public abstract class ScoreFunctionBuilder<FB extends ScoreFunctionBuilder<FB>>
implements ToXContentFragment,
NamedWriteable {
    private Float weight;
    private String functionName;

    public ScoreFunctionBuilder() {
    }

    public ScoreFunctionBuilder(StreamInput in) throws IOException {
        this.weight = this.checkWeight(in.readOptionalFloat());
        if (in.getVersion().onOrAfter(Version.V_1_3_0)) {
            this.functionName = in.readOptionalString();
        }
    }

    public final void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalFloat(this.weight);
        if (out.getVersion().onOrAfter(Version.V_1_3_0)) {
            out.writeOptionalString(this.functionName);
        }
        this.doWriteTo(out);
    }

    protected abstract void doWriteTo(StreamOutput var1) throws IOException;

    public abstract String getName();

    public final FB setWeight(float weight) {
        this.weight = this.checkWeight(Float.valueOf(weight));
        return (FB)this;
    }

    private Float checkWeight(Float weight) {
        if (weight != null && Float.compare(weight.floatValue(), 0.0f) < 0) {
            throw new IllegalArgumentException("[weight] cannot be negative for a filtering function");
        }
        return weight;
    }

    public final Float getWeight() {
        return this.weight;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public void setFunctionName(String functionName) {
        this.functionName = functionName;
    }

    public final XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.weight != null) {
            builder.field(FunctionScoreQueryBuilder.WEIGHT_FIELD.getPreferredName(), this.weight);
        }
        if (this.functionName != null) {
            builder.field(FunctionScoreQueryBuilder.NAME_FIELD.getPreferredName(), this.functionName);
        }
        this.doXContent(builder, params);
        return builder;
    }

    protected abstract void doXContent(XContentBuilder var1, ToXContent.Params var2) throws IOException;

    public String getWriteableName() {
        return this.getName();
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ScoreFunctionBuilder other = (ScoreFunctionBuilder)obj;
        return Objects.equals(this.weight, other.getWeight()) && Objects.equals(this.functionName, other.getFunctionName()) && this.doEquals(other);
    }

    protected abstract boolean doEquals(FB var1);

    public final int hashCode() {
        return Objects.hash(this.getClass(), this.weight, this.functionName, this.doHashCode());
    }

    protected abstract int doHashCode();

    public final ScoreFunction toFunction(QueryShardContext context) throws IOException {
        ScoreFunction scoreFunction = this.doToFunction(context);
        if (this.weight == null) {
            return scoreFunction;
        }
        return new WeightFactorFunction(this.weight.floatValue(), scoreFunction, this.getFunctionName());
    }

    protected abstract ScoreFunction doToFunction(QueryShardContext var1) throws IOException;
}

