/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.snapshots;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.MediaTypeRegistry;
import org.opensearch.core.xcontent.ObjectParser;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;

public class RestoreInfo
implements ToXContentObject,
Writeable {
    private String name;
    private List<String> indices;
    private int totalShards;
    private int successfulShards;
    private static final ObjectParser<RestoreInfo, Void> PARSER = new ObjectParser(RestoreInfo.class.getName(), true, RestoreInfo::new);

    RestoreInfo() {
    }

    public RestoreInfo(String name, List<String> indices, int totalShards, int successfulShards) {
        this.name = name;
        this.indices = indices;
        this.totalShards = totalShards;
        this.successfulShards = successfulShards;
    }

    public RestoreInfo(StreamInput in) throws IOException {
        this.name = in.readString();
        this.indices = Collections.unmodifiableList(in.readStringList());
        this.totalShards = in.readVInt();
        this.successfulShards = in.readVInt();
    }

    public String name() {
        return this.name;
    }

    public List<String> indices() {
        return this.indices;
    }

    public int totalShards() {
        return this.totalShards;
    }

    public int failedShards() {
        return this.totalShards - this.successfulShards;
    }

    public int successfulShards() {
        return this.successfulShards;
    }

    public RestStatus status() {
        return RestStatus.OK;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("snapshot", this.name);
        builder.startArray("indices");
        for (String index : this.indices) {
            builder.value(index);
        }
        builder.endArray();
        builder.startObject("shards");
        builder.field("total", this.totalShards);
        builder.field("failed", this.failedShards());
        builder.field("successful", this.successfulShards);
        builder.endObject();
        builder.endObject();
        return builder;
    }

    public static RestoreInfo fromXContent(XContentParser parser) throws IOException {
        return (RestoreInfo)PARSER.parse(parser, null);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeStringCollection(this.indices);
        out.writeVInt(this.totalShards);
        out.writeVInt(this.successfulShards);
    }

    public static RestoreInfo readOptionalRestoreInfo(StreamInput in) throws IOException {
        return (RestoreInfo)in.readOptionalWriteable(RestoreInfo::new);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RestoreInfo that = (RestoreInfo)o;
        return this.totalShards == that.totalShards && this.successfulShards == that.successfulShards && Objects.equals(this.name, that.name) && Objects.equals(this.indices, that.indices);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.indices, this.totalShards, this.successfulShards);
    }

    public String toString() {
        return Strings.toString((MediaType)MediaTypeRegistry.JSON, (ToXContent)this);
    }

    static {
        ObjectParser shardsParser = new ObjectParser("shards", true, null);
        shardsParser.declareInt((r, s) -> {
            r.totalShards = s;
        }, new ParseField("total", new String[0]));
        shardsParser.declareInt((r, s) -> {}, new ParseField("failed", new String[0]));
        shardsParser.declareInt((r, s) -> {
            r.successfulShards = s;
        }, new ParseField("successful", new String[0]));
        PARSER.declareString((r, n) -> {
            r.name = n;
        }, new ParseField("snapshot", new String[0]));
        PARSER.declareStringArray((r, i) -> {
            r.indices = i;
        }, new ParseField("indices", new String[0]));
        PARSER.declareField((arg_0, arg_1, arg_2) -> ((ObjectParser)shardsParser).parse(arg_0, arg_1, arg_2), new ParseField("shards", new String[0]), ObjectParser.ValueType.OBJECT);
    }

    static final class Fields {
        static final String SNAPSHOT = "snapshot";
        static final String INDICES = "indices";
        static final String SHARDS = "shards";
        static final String TOTAL = "total";
        static final String FAILED = "failed";
        static final String SUCCESSFUL = "successful";

        Fields() {
        }
    }
}

