/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.parkservices;

import com.amazon.randomcutforest.CommonUtils;
import com.amazon.randomcutforest.RandomCutForest;
import com.amazon.randomcutforest.config.ForestMode;
import com.amazon.randomcutforest.config.ScoringStrategy;
import com.amazon.randomcutforest.config.TransformMethod;
import com.amazon.randomcutforest.parkservices.AnomalyDescriptor;
import com.amazon.randomcutforest.parkservices.ErrorHandler;
import com.amazon.randomcutforest.parkservices.ForecastDescriptor;
import com.amazon.randomcutforest.parkservices.PredictorCorrector;
import com.amazon.randomcutforest.parkservices.RCFComputeDescriptor;
import com.amazon.randomcutforest.parkservices.ThresholdedRandomCutForest;
import com.amazon.randomcutforest.parkservices.calibration.Calibration;
import com.amazon.randomcutforest.parkservices.preprocessor.Preprocessor;
import com.amazon.randomcutforest.parkservices.returntypes.TimedRangeVector;
import com.amazon.randomcutforest.returntypes.RangeVector;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import lombok.Generated;

public class RCFCaster
extends ThresholdedRandomCutForest {
    public static double DEFAULT_ERROR_PERCENTILE = 0.1;
    public static Calibration DEFAULT_CALIBRATION = Calibration.SIMPLE;
    public static BiFunction<Float, Float, Float> defaultError = (x, y) -> Float.valueOf(x.floatValue() - y.floatValue());
    public static BiFunction<Float, Float, Float> alternateError = (x, y) -> Float.valueOf(2.0f * (x.floatValue() - y.floatValue()) / (Math.abs(x.floatValue()) + Math.abs(y.floatValue())));
    protected int forecastHorizon;
    protected ErrorHandler errorHandler;
    protected int errorHorizon;
    protected Calibration calibrationMethod;

    public static Builder builder() {
        return new Builder();
    }

    public RCFCaster(Builder builder) {
        super(builder);
        this.forecastHorizon = builder.forecastHorizon;
        this.errorHorizon = builder.errorHorizon;
        this.errorHandler = new ErrorHandler(builder);
        this.calibrationMethod = builder.calibrationMethod;
    }

    public RCFCaster(ForestMode forestMode, TransformMethod transformMethod, ScoringStrategy scoringStrategy, RandomCutForest forest, PredictorCorrector predictorCorrector, Preprocessor preprocessor, RCFComputeDescriptor descriptor, int forecastHorizon, ErrorHandler errorHandler, int errorHorizon, Calibration calibrationMethod) {
        super(forestMode, transformMethod, scoringStrategy, forest, predictorCorrector, preprocessor, descriptor);
        this.forecastHorizon = forecastHorizon;
        this.errorHandler = errorHandler;
        this.errorHorizon = errorHorizon;
        this.calibrationMethod = calibrationMethod;
    }

    @Override
    public ForecastDescriptor process(double[] inputPoint, long timestamp) {
        return this.process(inputPoint, timestamp, null);
    }

    void augmentForecast(ForecastDescriptor answer) {
        answer.setScoringStrategy(this.scoringStrategy);
        answer = this.preprocessor.postProcess(this.predictorCorrector.detect(this.preprocessor.preProcess(answer, this.lastAnomalyDescriptor, this.forest), this.lastAnomalyDescriptor, this.forest), this.lastAnomalyDescriptor, this.forest);
        if (this.saveDescriptor(answer)) {
            this.lastAnomalyDescriptor = answer.copyOf();
        }
        TimedRangeVector timedForecast = new TimedRangeVector(this.forest.getDimensions() * this.forecastHorizon / this.preprocessor.getShingleSize(), this.forecastHorizon);
        if (this.forest.isOutputReady()) {
            this.errorHandler.updateActuals(answer.getCurrentInput(), answer.getPostDeviations());
            this.errorHandler.augmentDescriptor(answer);
            timedForecast = this.extrapolate(this.forecastHorizon);
            this.errorHandler.updateForecasts(timedForecast.rangeVector);
        }
        answer.setTimedForecast(timedForecast);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ForecastDescriptor process(double[] inputPoint, long timestamp, int[] missingValues) {
        CommonUtils.checkArgument((missingValues == null ? 1 : 0) != 0, (String)"on the fly imputation and error estimation should not mix");
        ForecastDescriptor answer = new ForecastDescriptor(inputPoint, timestamp, this.forecastHorizon);
        answer.setScoringStrategy(this.scoringStrategy);
        boolean cacheDisabled = this.forest.getBoundingBoxCacheFraction() == 0.0;
        try {
            if (cacheDisabled) {
                this.forest.setBoundingBoxCacheFraction(1.0);
            }
            this.augmentForecast(answer);
        }
        finally {
            if (cacheDisabled) {
                this.forest.setBoundingBoxCacheFraction(0.0);
            }
        }
        return answer;
    }

    public void calibrate(Calibration calibration, RangeVector ranges) {
        this.errorHandler.calibrate(calibration, ranges);
    }

    @Override
    public TimedRangeVector extrapolate(int horizon, boolean correct, double centrality) {
        return this.extrapolate(this.calibrationMethod, horizon, correct, centrality);
    }

    public TimedRangeVector extrapolate(Calibration calibration, int horizon, boolean correct, double centrality) {
        TimedRangeVector answer = super.extrapolate(horizon, correct, centrality);
        this.calibrate(calibration, answer.rangeVector);
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AnomalyDescriptor> processSequentially(double[][] data, Function<AnomalyDescriptor, Boolean> filter) {
        ArrayList<AnomalyDescriptor> answer = new ArrayList<AnomalyDescriptor>();
        if (data != null && data.length > 0) {
            boolean cacheDisabled = this.forest.getBoundingBoxCacheFraction() == 0.0;
            try {
                if (cacheDisabled) {
                    this.forest.setBoundingBoxCacheFraction(1.0);
                }
                long timestamp = this.preprocessor.getInternalTimeStamp();
                int length = this.preprocessor.getInputLength();
                for (double[] point : data) {
                    CommonUtils.checkArgument((point.length == length ? 1 : 0) != 0, (String)" nonuniform lengths ");
                    ForecastDescriptor description = new ForecastDescriptor(point, timestamp++, this.forecastHorizon);
                    this.augmentForecast(description);
                    if (!filter.apply(description).booleanValue()) continue;
                    answer.add(description);
                }
            }
            finally {
                if (cacheDisabled) {
                    this.forest.setBoundingBoxCacheFraction(0.0);
                }
            }
        }
        return answer;
    }

    @Generated
    public int getForecastHorizon() {
        return this.forecastHorizon;
    }

    @Generated
    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @Generated
    public int getErrorHorizon() {
        return this.errorHorizon;
    }

    @Generated
    public Calibration getCalibrationMethod() {
        return this.calibrationMethod;
    }

    @Generated
    public void setForecastHorizon(int forecastHorizon) {
        this.forecastHorizon = forecastHorizon;
    }

    @Generated
    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    @Generated
    public void setErrorHorizon(int errorHorizon) {
        this.errorHorizon = errorHorizon;
    }

    @Generated
    public void setCalibrationMethod(Calibration calibrationMethod) {
        this.calibrationMethod = calibrationMethod;
    }

    public static class Builder
    extends ThresholdedRandomCutForest.Builder<Builder> {
        int forecastHorizon;
        int errorHorizon;
        double percentile = DEFAULT_ERROR_PERCENTILE;
        protected Calibration calibrationMethod = DEFAULT_CALIBRATION;

        Builder() {
            this.transformMethod = TransformMethod.NORMALIZE;
        }

        public Builder forecastHorizon(int horizon) {
            this.forecastHorizon = horizon;
            return this;
        }

        public Builder errorHorizon(int errorHorizon) {
            this.errorHorizon = errorHorizon;
            return this;
        }

        public Builder percentile(double percentile) {
            this.percentile = percentile;
            return this;
        }

        public Builder calibration(Calibration calibrationMethod) {
            this.calibrationMethod = calibrationMethod;
            return this;
        }

        @Override
        public RCFCaster build() {
            CommonUtils.checkArgument((this.forecastHorizon > 0 ? 1 : 0) != 0, (String)"need non-negative horizon");
            CommonUtils.checkArgument((this.shingleSize > 0 ? 1 : 0) != 0, (String)"need shingle size > 1");
            CommonUtils.checkArgument((this.forestMode != ForestMode.STREAMING_IMPUTE ? 1 : 0) != 0, (String)"error estimation with on the fly imputation should not be abstracted, either estimate errors outside of this object or perform on the fly imputation outside this code");
            CommonUtils.checkArgument((this.forestMode != ForestMode.TIME_AUGMENTED ? 1 : 0) != 0, (String)"error estimation when time is used as a field in the forest should not be abstractedperform estimation outside this code");
            CommonUtils.checkArgument((!this.internalShinglingEnabled.isPresent() || (Boolean)this.internalShinglingEnabled.get() != false ? 1 : 0) != 0, (String)"internal shingling only");
            if (this.errorHorizon == 0) {
                this.errorHorizon = Math.max(this.sampleSize, 2 * this.forecastHorizon);
            }
            this.validate();
            return new RCFCaster(this);
        }
    }
}

