/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.parkservices.preprocessor.transform;

import com.amazon.randomcutforest.CommonUtils;
import com.amazon.randomcutforest.parkservices.preprocessor.transform.ITransformer;
import com.amazon.randomcutforest.parkservices.statistics.Deviation;
import com.amazon.randomcutforest.returntypes.RangeVector;
import java.util.Arrays;
import lombok.Generated;

public class WeightedTransformer
implements ITransformer {
    public static int NUMBER_OF_STATS = 5;
    double[] weights;
    Deviation[] deviations;

    public WeightedTransformer(double[] weights, Deviation[] deviations) {
        CommonUtils.checkArgument((NUMBER_OF_STATS * weights.length == deviations.length ? 1 : 0) != 0, (String)"incorrect lengths");
        this.weights = Arrays.copyOf(weights, weights.length);
        this.deviations = new Deviation[deviations.length];
        for (int i = 0; i < deviations.length; ++i) {
            CommonUtils.checkArgument((deviations[i] != null ? 1 : 0) != 0, (String)"cannot be null");
            this.deviations[i] = deviations[i].copy();
        }
    }

    @Override
    public double[] invert(double[] values, double[] previousInput) {
        double[] output = new double[values.length];
        for (int i = 0; i < values.length; ++i) {
            output[i] = this.weights[i] == 0.0 ? 0.0 : values[i] * this.getScale(i, this.deviations) / this.weights[i];
            int n = i;
            output[n] = output[n] + this.getShift(i, this.deviations);
        }
        return output;
    }

    @Override
    public void invertForecastRange(RangeVector ranges, int baseDimension, double[] previousInput, double[] correction) {
        int horizon = ranges.values.length / baseDimension;
        int inputLength = this.weights.length;
        CommonUtils.checkArgument((correction.length >= inputLength ? 1 : 0) != 0, (String)" incorrect length ");
        for (int i = 0; i < horizon; ++i) {
            for (int j = 0; j < inputLength; ++j) {
                double weight = this.weights[j] == 0.0 ? 0.0 : this.getScale(j, this.deviations) / this.weights[j];
                ranges.scale(i * baseDimension + j, (float)weight);
                ranges.shift(i * baseDimension + j, (float)(this.getShift(j, this.deviations) + (double)(i + 1) * this.getDrift(j, this.deviations)));
            }
        }
    }

    @Override
    public void updateDeviation(double[] inputPoint, double[] previousInput) {
        CommonUtils.checkArgument((inputPoint.length * NUMBER_OF_STATS == this.deviations.length ? 1 : 0) != 0, (String)"incorrect lengths");
        CommonUtils.checkArgument((inputPoint.length == previousInput.length ? 1 : 0) != 0, (String)" lengths must match");
        for (int i = 0; i < inputPoint.length; ++i) {
            this.deviations[i].update(inputPoint[i]);
            if (this.deviations[i + inputPoint.length].getCount() == 0) {
                this.deviations[i + inputPoint.length].update(0.0);
            } else {
                this.deviations[i + inputPoint.length].update(inputPoint[i] - previousInput[i]);
            }
            this.deviations[i + 2 * inputPoint.length].update(this.deviations[i].getDeviation());
            this.deviations[i + 3 * inputPoint.length].update(this.deviations[i + inputPoint.length].getMean());
            this.deviations[i + 4 * inputPoint.length].update(this.deviations[i + inputPoint.length].getDeviation());
        }
    }

    protected double normalize(double value, double shift, double scale, double clipFactor) {
        CommonUtils.checkArgument((scale > 0.0 ? 1 : 0) != 0, (String)" should be non-negative");
        double t = (value - shift) / scale;
        if (t >= clipFactor) {
            return clipFactor;
        }
        if (t < -clipFactor) {
            return -clipFactor;
        }
        return t;
    }

    @Override
    public double[] transformValues(int internalTimeStamp, double[] inputPoint, double[] previousInput, Deviation[] initials, double clipFactor) {
        double[] output = new double[inputPoint.length];
        for (int i = 0; i < inputPoint.length; ++i) {
            Deviation[] devs = initials == null ? this.deviations : initials;
            output[i] = this.weights[i] * this.normalize(inputPoint[i], this.getShift(i, devs), this.getScale(i, devs), this.clipValue(clipFactor));
        }
        return output;
    }

    protected double clipValue(double clipfactor) {
        return Double.MAX_VALUE;
    }

    @Override
    public Deviation[] getDeviations() {
        Deviation[] answer = new Deviation[this.deviations.length];
        for (int i = 0; i < this.deviations.length; ++i) {
            answer[i] = this.deviations[i].copy();
        }
        return answer;
    }

    @Override
    public double[] getWeights() {
        return Arrays.copyOf(this.weights, this.weights.length);
    }

    @Override
    public void setWeights(double[] weights) {
        CommonUtils.checkArgument((weights.length == this.weights.length ? 1 : 0) != 0, (String)" incorrect length");
        this.weights = Arrays.copyOf(weights, weights.length);
    }

    protected double getScale(int i, Deviation[] devs) {
        return 1.0;
    }

    protected double getShift(int i, Deviation[] devs) {
        return 0.0;
    }

    protected double getDrift(int i, Deviation[] devs) {
        return devs[i + 3 * this.weights.length].getMean();
    }

    @Override
    public double[] getScale() {
        double[] answer = new double[this.weights.length];
        for (int i = 0; i < this.weights.length; ++i) {
            answer[i] = this.weights[i] == 0.0 ? 0.0 : this.getScale(i, this.deviations) / this.weights[i];
        }
        return answer;
    }

    @Override
    public double[] getShift(double[] previous) {
        double[] answer = new double[this.weights.length];
        for (int i = 0; i < this.weights.length; ++i) {
            answer[i] = this.getShift(i, this.deviations);
        }
        return answer;
    }

    @Override
    public double[] getSmoothedDeviations() {
        double[] answer = new double[this.weights.length];
        for (int i = 0; i < this.weights.length; ++i) {
            answer[i] = Math.abs(this.deviations[i + 2 * this.weights.length].getMean());
        }
        return answer;
    }

    @Override
    public double[] getSmoothedDifferenceDeviations() {
        double[] answer = new double[this.weights.length];
        for (int i = 0; i < this.weights.length; ++i) {
            answer[i] = Math.abs(this.deviations[i + 4 * this.weights.length].getMean());
        }
        return answer;
    }

    @Generated
    public void setDeviations(Deviation[] deviations) {
        this.deviations = deviations;
    }
}

