/*
 * Decompiled with CFR 0.152.
 */
package ai.onnxruntime;

import ai.onnxruntime.OrtProvider;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

final class OnnxRuntime {
    private static final Logger logger = Logger.getLogger(OnnxRuntime.class.getName());
    private static final int ORT_API_VERSION_1 = 1;
    private static final int ORT_API_VERSION_2 = 2;
    private static final int ORT_API_VERSION_3 = 3;
    private static final int ORT_API_VERSION_7 = 7;
    private static final int ORT_API_VERSION_8 = 8;
    private static final int ORT_API_VERSION_11 = 11;
    private static final int ORT_API_VERSION_13 = 13;
    private static final int ORT_API_VERSION_14 = 14;
    private static final int ORT_TRAINING_API_VERSION_1 = 1;
    static final String ONNXRUNTIME_NATIVE_PATH = "onnxruntime.native.path";
    static final String ONNXRUNTIME_LIBRARY_NAME = "onnxruntime";
    static final String ONNXRUNTIME_JNI_LIBRARY_NAME = "onnxruntime4j_jni";
    static final String ONNXRUNTIME_LIBRARY_SHARED_NAME = "onnxruntime_providers_shared";
    static final String ONNXRUNTIME_LIBRARY_CUDA_NAME = "onnxruntime_providers_cuda";
    static final String ONNXRUNTIME_LIBRARY_ROCM_NAME = "onnxruntime_providers_rocm";
    static final String ONNXRUNTIME_LIBRARY_DNNL_NAME = "onnxruntime_providers_dnnl";
    static final String ONNXRUNTIME_LIBRARY_OPENVINO_NAME = "onnxruntime_providers_openvino";
    static final String ONNXRUNTIME_LIBRARY_TENSORRT_NAME = "onnxruntime_providers_tensorrt";
    private static final String OS_ARCH_STR = OnnxRuntime.initOsArch();
    private static boolean loaded = false;
    private static Path tempDirectory;
    private static String libraryDirPathProperty;
    private static final Set<String> extractedSharedProviders;
    static long ortApiHandle;
    static long ortTrainingApiHandle;
    static boolean trainingEnabled;
    static EnumSet<OrtProvider> providers;
    private static String version;

    private OnnxRuntime() {
    }

    private static String initOsArch() {
        String detectedOS = null;
        String os = System.getProperty("os.name", "generic").toLowerCase(Locale.ENGLISH);
        if (os.contains("mac") || os.contains("darwin")) {
            detectedOS = "osx";
        } else if (os.contains("win")) {
            detectedOS = "win";
        } else if (os.contains("nux")) {
            detectedOS = "linux";
        } else if (OnnxRuntime.isAndroid()) {
            detectedOS = "android";
        } else {
            throw new IllegalStateException("Unsupported os:" + os);
        }
        String detectedArch = null;
        String arch = System.getProperty("os.arch", "generic").toLowerCase(Locale.ENGLISH);
        if (arch.startsWith("amd64") || arch.startsWith("x86_64")) {
            detectedArch = "x64";
        } else if (arch.startsWith("x86")) {
            detectedArch = "x86";
        } else if (arch.startsWith("aarch64")) {
            detectedArch = "aarch64";
        } else if (arch.startsWith("ppc64")) {
            detectedArch = "ppc64";
        } else if (OnnxRuntime.isAndroid()) {
            detectedArch = arch;
        } else {
            throw new IllegalStateException("Unsupported arch:" + arch);
        }
        return detectedOS + '-' + detectedArch;
    }

    static synchronized void init() throws IOException {
        if (loaded) {
            return;
        }
        tempDirectory = OnnxRuntime.isAndroid() ? null : Files.createTempDirectory("onnxruntime-java", new FileAttribute[0]);
        try {
            libraryDirPathProperty = System.getProperty(ONNXRUNTIME_NATIVE_PATH);
            OnnxRuntime.extractProviderLibrary(ONNXRUNTIME_LIBRARY_SHARED_NAME);
            OnnxRuntime.load(ONNXRUNTIME_LIBRARY_NAME);
            OnnxRuntime.load(ONNXRUNTIME_JNI_LIBRARY_NAME);
            ortApiHandle = OnnxRuntime.initialiseAPIBase(14);
            if (ortApiHandle == 0L) {
                throw new IllegalStateException("There is a mismatch between the ORT class files and the ORT native library, and the native library could not be loaded");
            }
            ortTrainingApiHandle = OnnxRuntime.initialiseTrainingAPIBase(ortApiHandle, 14);
            trainingEnabled = ortTrainingApiHandle != 0L;
            providers = OnnxRuntime.initialiseProviders(ortApiHandle);
            version = OnnxRuntime.initialiseVersion();
            loaded = true;
        }
        finally {
            if (tempDirectory != null) {
                OnnxRuntime.cleanUp(tempDirectory.toFile());
            }
        }
    }

    private static void cleanUp(File file) {
        if (!file.exists()) {
            return;
        }
        logger.log(Level.FINE, "Deleting " + file + " on exit");
        file.deleteOnExit();
    }

    static String version() {
        return version;
    }

    static boolean extractCUDA() {
        return OnnxRuntime.extractProviderLibrary(ONNXRUNTIME_LIBRARY_CUDA_NAME);
    }

    static boolean extractROCM() {
        return OnnxRuntime.extractProviderLibrary(ONNXRUNTIME_LIBRARY_ROCM_NAME);
    }

    static boolean extractDNNL() {
        return OnnxRuntime.extractProviderLibrary(ONNXRUNTIME_LIBRARY_DNNL_NAME);
    }

    static boolean extractOpenVINO() {
        return OnnxRuntime.extractProviderLibrary(ONNXRUNTIME_LIBRARY_OPENVINO_NAME);
    }

    static boolean extractTensorRT() {
        return OnnxRuntime.extractProviderLibrary(ONNXRUNTIME_LIBRARY_TENSORRT_NAME);
    }

    static synchronized boolean extractProviderLibrary(String libraryName) {
        if (OnnxRuntime.isAndroid()) {
            return false;
        }
        if (extractedSharedProviders.contains(libraryName)) {
            return true;
        }
        Optional<File> file = OnnxRuntime.extractFromResources(libraryName);
        if (file.isPresent()) {
            extractedSharedProviders.add(libraryName);
            return true;
        }
        if (libraryDirPathProperty != null) {
            String libraryFileName = OnnxRuntime.mapLibraryName(libraryName);
            File libraryFile = Paths.get(libraryDirPathProperty, libraryFileName).toFile();
            if (libraryFile.exists()) {
                extractedSharedProviders.add(libraryName);
                return true;
            }
            return false;
        }
        return false;
    }

    static boolean isAndroid() {
        return System.getProperty("java.vendor", "generic").equals("The Android Project");
    }

    private static void load(String library) throws IOException {
        if (OnnxRuntime.isAndroid()) {
            System.loadLibrary(ONNXRUNTIME_JNI_LIBRARY_NAME);
            return;
        }
        String skip = System.getProperty("onnxruntime.native." + library + ".skip");
        if (Boolean.TRUE.toString().equalsIgnoreCase(skip)) {
            logger.log(Level.FINE, "Skipping load of native library '" + library + "'");
            return;
        }
        String libraryFileName = OnnxRuntime.mapLibraryName(library);
        if (libraryDirPathProperty != null) {
            logger.log(Level.FINE, "Attempting to load native library '" + library + "' from specified path: " + libraryDirPathProperty);
            File libraryFile = Paths.get(libraryDirPathProperty, libraryFileName).toFile();
            String libraryFilePath = libraryFile.getAbsolutePath();
            if (!libraryFile.exists()) {
                throw new IOException("Native library '" + library + "' not found at " + libraryFilePath);
            }
            System.load(libraryFilePath);
            logger.log(Level.FINE, "Loaded native library '" + library + "' from specified path");
            return;
        }
        String libraryPathProperty = System.getProperty("onnxruntime.native." + library + ".path");
        if (libraryPathProperty != null) {
            logger.log(Level.FINE, "Attempting to load native library '" + library + "' from specified path: " + libraryPathProperty);
            File libraryFile = new File(libraryPathProperty);
            String libraryFilePath = libraryFile.getAbsolutePath();
            if (!libraryFile.exists()) {
                throw new IOException("Native library '" + library + "' not found at " + libraryFilePath);
            }
            System.load(libraryFilePath);
            logger.log(Level.FINE, "Loaded native library '" + library + "' from specified path");
            return;
        }
        Optional<File> extractedPath = OnnxRuntime.extractFromResources(library);
        if (extractedPath.isPresent()) {
            System.load(extractedPath.get().getAbsolutePath());
            logger.log(Level.FINE, "Loaded native library '" + library + "' from resource path");
        } else {
            logger.log(Level.FINE, "Attempting to load native library '" + library + "' from library path");
            System.loadLibrary(library);
            logger.log(Level.FINE, "Loaded native library '" + library + "' from library path");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Optional<File> extractFromResources(String library) {
        String libraryFileName = OnnxRuntime.mapLibraryName(library);
        String resourcePath = "/ai/onnxruntime/native/" + OS_ARCH_STR + '/' + libraryFileName;
        File tempFile = tempDirectory.resolve(libraryFileName).toFile();
        try {
            Optional<File> optional;
            block22: {
                InputStream is;
                block19: {
                    Optional<File> optional2;
                    block20: {
                        is = OnnxRuntime.class.getResourceAsStream(resourcePath);
                        if (is != null) break block19;
                        optional2 = Optional.empty();
                        if (is == null) break block20;
                        is.close();
                    }
                    return optional2;
                }
                try {
                    logger.log(Level.FINE, "Attempting to load native library '" + library + "' from resource path " + resourcePath + " copying to " + tempFile);
                    byte[] buffer = new byte[4096];
                    try (FileOutputStream os = new FileOutputStream(tempFile);){
                        int readBytes;
                        while ((readBytes = is.read(buffer)) != -1) {
                            os.write(buffer, 0, readBytes);
                        }
                    }
                    logger.log(Level.FINE, "Extracted native library '" + library + "' from resource path");
                    optional = Optional.of(tempFile);
                    if (is == null) break block22;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        logger.log(Level.WARNING, "Failed to extract library '" + library + "' from the resources", e);
                        Optional<File> optional3 = Optional.empty();
                        return optional3;
                    }
                }
                is.close();
            }
            return optional;
        }
        finally {
            OnnxRuntime.cleanUp(tempFile);
        }
    }

    private static String mapLibraryName(String library) {
        return System.mapLibraryName(library).replace("jnilib", "dylib");
    }

    private static EnumSet<OrtProvider> initialiseProviders(long ortApiHandle) {
        String[] providersArray = OnnxRuntime.getAvailableProviders(ortApiHandle);
        EnumSet<OrtProvider> providers = EnumSet.noneOf(OrtProvider.class);
        for (String provider : providersArray) {
            providers.add(OrtProvider.mapFromName(provider));
        }
        return providers;
    }

    private static native long initialiseAPIBase(int var0);

    private static native long initialiseTrainingAPIBase(long var0, int var2);

    private static native String[] getAvailableProviders(long var0);

    private static native String initialiseVersion();

    static {
        extractedSharedProviders = new HashSet<String>();
    }
}

