import sys
from typing import NamedTuple

if sys.version_info >= (3, 8):
    from typing import Final
else:
    from typing_extensions import Final

class __KeyData(NamedTuple):  # __KeyData type
    href: str
    name: str

class __KeyDataNoHref(NamedTuple):  # __KeyData type
    href: None
    name: str

class __Transform(NamedTuple):  # __Transform type
    href: str
    name: str
    usage: int

class __TransformNoHref(NamedTuple):  # __Transform type
    href: None
    name: str
    usage: int

DSigNs: Final[str]
EncNs: Final[str]
KeyDataAes: Final[__KeyData]
KeyDataDes: Final[__KeyData]
KeyDataDsa: Final[__KeyData]
KeyDataEcdsa: Final[__KeyData]
KeyDataEncryptedKey: Final[__KeyData]
KeyDataFormatBinary: Final[int]
KeyDataFormatCertDer: Final[int]
KeyDataFormatCertPem: Final[int]
KeyDataFormatDer: Final[int]
KeyDataFormatPem: Final[int]
KeyDataFormatPkcs12: Final[int]
KeyDataFormatPkcs8Der: Final[int]
KeyDataFormatPkcs8Pem: Final[int]
KeyDataFormatUnknown: Final[int]
KeyDataHmac: Final[__KeyData]
KeyDataName: Final[__KeyDataNoHref]
KeyDataRawX509Cert: Final[__KeyData]
KeyDataRetrievalMethod: Final[__KeyDataNoHref]
KeyDataRsa: Final[__KeyData]
KeyDataTypeAny: Final[int]
KeyDataTypeNone: Final[int]
KeyDataTypePermanent: Final[int]
KeyDataTypePrivate: Final[int]
KeyDataTypePublic: Final[int]
KeyDataTypeSession: Final[int]
KeyDataTypeSymmetric: Final[int]
KeyDataTypeTrusted: Final[int]
KeyDataTypeUnknown: Final[int]
KeyDataValue: Final[__KeyDataNoHref]
KeyDataX509: Final[__KeyData]
NodeCanonicalizationMethod: Final[str]
NodeCipherData: Final[str]
NodeCipherReference: Final[str]
NodeCipherValue: Final[str]
NodeDataReference: Final[str]
NodeDigestMethod: Final[str]
NodeDigestValue: Final[str]
NodeEncryptedData: Final[str]
NodeEncryptedKey: Final[str]
NodeEncryptionMethod: Final[str]
NodeEncryptionProperties: Final[str]
NodeEncryptionProperty: Final[str]
NodeKeyInfo: Final[str]
NodeKeyName: Final[str]
NodeKeyReference: Final[str]
NodeKeyValue: Final[str]
NodeManifest: Final[str]
NodeObject: Final[str]
NodeReference: Final[str]
NodeReferenceList: Final[str]
NodeSignature: Final[str]
NodeSignatureMethod: Final[str]
NodeSignatureProperties: Final[str]
NodeSignatureValue: Final[str]
NodeSignedInfo: Final[str]
NodeX509Data: Final[str]
Ns: Final[str]
NsExcC14N: Final[str]
NsExcC14NWithComments: Final[str]
TransformAes128Cbc: Final[__Transform]
TransformAes128Gcm: Final[__Transform]
TransformAes192Cbc: Final[__Transform]
TransformAes192Gcm: Final[__Transform]
TransformAes256Cbc: Final[__Transform]
TransformAes256Gcm: Final[__Transform]
TransformDes3Cbc: Final[__Transform]
TransformDsaSha1: Final[__Transform]
TransformEcdsaSha1: Final[__Transform]
TransformEcdsaSha224: Final[__Transform]
TransformEcdsaSha256: Final[__Transform]
TransformEcdsaSha384: Final[__Transform]
TransformEcdsaSha512: Final[__Transform]
TransformEnveloped: Final[__Transform]
TransformExclC14N: Final[__Transform]
TransformExclC14NWithComments: Final[__Transform]
TransformHmacMd5: Final[__Transform]
TransformHmacRipemd160: Final[__Transform]
TransformHmacSha1: Final[__Transform]
TransformHmacSha224: Final[__Transform]
TransformHmacSha256: Final[__Transform]
TransformHmacSha384: Final[__Transform]
TransformHmacSha512: Final[__Transform]
TransformInclC14N: Final[__Transform]
TransformInclC14N11: Final[__Transform]
TransformInclC14N11WithComments: Final[__Transform]
TransformInclC14NWithComments: Final[__Transform]
TransformKWAes128: Final[__Transform]
TransformKWAes192: Final[__Transform]
TransformKWAes256: Final[__Transform]
TransformKWDes3: Final[__Transform]
TransformMd5: Final[__Transform]
TransformRemoveXmlTagsC14N: Final[__TransformNoHref]
TransformRipemd160: Final[__Transform]
TransformRsaMd5: Final[__Transform]
TransformRsaOaep: Final[__Transform]
TransformRsaPkcs1: Final[__Transform]
TransformRsaRipemd160: Final[__Transform]
TransformRsaSha1: Final[__Transform]
TransformRsaSha224: Final[__Transform]
TransformRsaSha256: Final[__Transform]
TransformRsaSha384: Final[__Transform]
TransformRsaSha512: Final[__Transform]
TransformSha1: Final[__Transform]
TransformSha224: Final[__Transform]
TransformSha256: Final[__Transform]
TransformSha384: Final[__Transform]
TransformSha512: Final[__Transform]
TransformUsageAny: Final[int]
TransformUsageC14NMethod: Final[int]
TransformUsageDSigTransform: Final[int]
TransformUsageDigestMethod: Final[int]
TransformUsageEncryptionMethod: Final[int]
TransformUsageSignatureMethod: Final[int]
TransformUsageUnknown: Final[int]
TransformVisa3DHack: Final[__TransformNoHref]
TransformXPath: Final[__Transform]
TransformXPath2: Final[__Transform]
TransformXPointer: Final[__Transform]
TransformXslt: Final[__Transform]
TypeEncContent: Final[str]
TypeEncElement: Final[str]
XPath2Ns: Final[str]
XPathNs: Final[str]
XPointerNs: Final[str]
