/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cli;

import java.io.PrintStream;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.solr.cli.CLIO;
import org.apache.solr.cli.SolrCLI;
import org.apache.solr.cli.ToolBase;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.CloudHttp2SolrClient;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.Http2SolrClient;
import org.apache.solr.client.solrj.impl.JsonMapResponseParser;
import org.apache.solr.client.solrj.impl.NoOpResponseParser;
import org.apache.solr.client.solrj.request.CollectionAdminRequest;
import org.apache.solr.client.solrj.request.CoreAdminRequest;
import org.apache.solr.client.solrj.request.GenericSolrRequest;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.util.NamedList;
import org.noggit.CharArr;
import org.noggit.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteTool
extends ToolBase {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public DeleteTool() {
        this(CLIO.getOutStream());
    }

    public DeleteTool(PrintStream stdout) {
        super(stdout);
    }

    @Override
    public String getName() {
        return "delete";
    }

    @Override
    public List<Option> getOptions() {
        return List.of(SolrCLI.OPTION_SOLRURL, Option.builder((String)"name").argName("NAME").hasArg().required(true).desc("Name of the core / collection to delete.").build(), Option.builder((String)"deleteConfig").argName("true|false").hasArg().required(false).desc("Flag to indicate if the underlying configuration directory for a collection should also be deleted; default is true.").build(), Option.builder((String)"forceDeleteConfig").required(false).desc("Skip safety checks when deleting the configuration directory used by a collection.").build(), SolrCLI.OPTION_ZKHOST, SolrCLI.OPTION_VERBOSE);
    }

    @Override
    public void runImpl(CommandLine cli) throws Exception {
        SolrCLI.raiseLogLevelUnlessVerbose(cli);
        Object solrUrl = cli.getOptionValue("solrUrl", SolrCLI.getDefaultSolrUrl());
        if (!((String)solrUrl).endsWith("/")) {
            solrUrl = (String)solrUrl + "/";
        }
        try (SolrClient solrClient = SolrCLI.getSolrClient((String)solrUrl);){
            Map systemInfo = solrClient.request((SolrRequest)new GenericSolrRequest(SolrRequest.METHOD.GET, "/admin/info/system")).asMap();
            if ("solrcloud".equals(systemInfo.get("mode"))) {
                this.deleteCollection(cli);
            } else {
                this.deleteCore(cli, solrClient);
            }
        }
    }

    protected void deleteCollection(CommandLine cli) throws Exception {
        String zkHost = SolrCLI.getZkHost(cli);
        try (CloudHttp2SolrClient cloudSolrClient = new CloudHttp2SolrClient.Builder(Collections.singletonList(zkHost), Optional.empty()).withInternalClientBuilder(new Http2SolrClient.Builder().withIdleTimeout(30L, TimeUnit.SECONDS).withKeyStoreReloadInterval(-1L, TimeUnit.SECONDS).withConnectionTimeout(15L, TimeUnit.SECONDS)).build();){
            this.echoIfVerbose("Connecting to ZooKeeper at " + zkHost, cli);
            cloudSolrClient.connect();
            this.deleteCollection((CloudSolrClient)cloudSolrClient, cli);
        }
    }

    protected void deleteCollection(CloudSolrClient cloudSolrClient, CommandLine cli) throws Exception {
        NamedList response;
        Set liveNodes = cloudSolrClient.getClusterState().getLiveNodes();
        if (liveNodes.isEmpty()) {
            throw new IllegalStateException("No live nodes found! Cannot delete a collection until there is at least 1 live node in the cluster.");
        }
        ZkStateReader zkStateReader = ZkStateReader.from((CloudSolrClient)cloudSolrClient);
        String collectionName = cli.getOptionValue("name");
        if (!zkStateReader.getClusterState().hasCollection(collectionName)) {
            throw new IllegalArgumentException("Collection " + collectionName + " not found!");
        }
        String configName = zkStateReader.getClusterState().getCollection(collectionName).getConfigName();
        boolean deleteConfig = "true".equals(cli.getOptionValue("deleteConfig", "true"));
        if (deleteConfig && configName != null) {
            if (cli.hasOption("forceDeleteConfig")) {
                log.warn("Skipping safety checks, configuration directory {} will be deleted with impunity.", (Object)configName);
            } else {
                Optional<String> inUse;
                Set collections = zkStateReader.getClusterState().getCollectionsMap().keySet();
                if (collections.size() > 50 && log.isInfoEnabled()) {
                    log.info("Scanning {} to ensure no other collections are using config {}", (Object)collections.size(), (Object)configName);
                }
                if ((inUse = collections.stream().filter(name -> !name.equals(collectionName)).filter(name -> configName.equals(zkStateReader.getClusterState().getCollection(name).getConfigName())).findFirst()).isPresent()) {
                    deleteConfig = false;
                    log.warn("Configuration directory {} is also being used by {}{}", new Object[]{configName, inUse.get(), "; configuration will not be deleted from ZooKeeper. You can pass the -forceDeleteConfig flag to force delete."});
                }
            }
        }
        this.echoIfVerbose("\nDeleting collection '" + collectionName + "' using CollectionAdminRequest", cli);
        try {
            CollectionAdminRequest.Delete req = CollectionAdminRequest.deleteCollection((String)collectionName);
            req.setResponseParser((ResponseParser)new JsonMapResponseParser());
            response = cloudSolrClient.request((SolrRequest)req);
        }
        catch (SolrServerException sse) {
            throw new Exception("Failed to delete collection '" + collectionName + "' due to: " + sse.getMessage());
        }
        if (deleteConfig) {
            String configZnode = "/configs/" + configName;
            try {
                zkStateReader.getZkClient().clean(configZnode);
            }
            catch (Exception exc) {
                this.echo("\nWARNING: Failed to delete configuration directory " + configZnode + " in ZooKeeper due to: " + exc.getMessage() + "\nYou'll need to manually delete this znode using the zkcli script.");
            }
        }
        if (response != null) {
            CharArr arr = new CharArr();
            new JSONWriter(arr, 2).write(response.asMap());
            this.echo(arr.toString());
            this.echo("\n");
        }
        this.echo("Deleted collection '" + collectionName + "' using CollectionAdminRequest");
    }

    protected void deleteCore(CommandLine cli, SolrClient solrClient) throws Exception {
        NamedList response;
        String coreName = cli.getOptionValue("name");
        this.echo("\nDeleting core '" + coreName + "' using CoreAdminRequest\n");
        try {
            CoreAdminRequest.Unload unloadRequest = new CoreAdminRequest.Unload(true);
            unloadRequest.setDeleteIndex(true);
            unloadRequest.setDeleteDataDir(true);
            unloadRequest.setDeleteInstanceDir(true);
            unloadRequest.setCoreName(coreName);
            unloadRequest.setResponseParser((ResponseParser)new NoOpResponseParser("json"));
            response = solrClient.request((SolrRequest)unloadRequest);
        }
        catch (SolrServerException sse) {
            throw new Exception("Failed to delete core '" + coreName + "' due to: " + sse.getMessage());
        }
        if (response != null) {
            this.echoIfVerbose((String)response.get("response"), cli);
            this.echoIfVerbose("\n", cli);
        }
    }
}

